# Big O notation

## Intro

Small Big O notation chart [Source](https://twitter.com/kamranahmedse/status/1235708842610212864)

## [Orders of common functions](https://en.wikipedia.org/wiki/Big_O_notation#Orders_of_common_functions)

### O(1) constant 	

Finding the median value for a sorted array of numbers; Calculating ( − 1 ) n 
Using a constant-size [lookup table](https://en.wikipedia.org/wiki/Lookup_table "Lookup table")Using a constant-size lookup table

### O(log n) logarithmic 	

Finding an item in a sorted array with a [binary search](https://en.wikipedia.org/wiki/Binary_search_algorithm "Binary search algorithm") or a balanced search [tree](https://en.wikipedia.org/wiki/Tree_data_structure "Tree data structure") as well as all operations in a [binomial heap](https://en.wikipedia.org/wiki/Binomial_heap)

### O(n) linear 	

Finding an item in an unsorted list or in an unsorted array; adding two _n_-bit integers by [ripple carry](https://en.wikipedia.org/wiki/Ripple_carry_adder "Ripple carry adder")

### O(n^2) quadratic 	

Multiplying two _n_-digit numbers by [schoolbook multiplication](https://en.wikipedia.org/wiki/Multiplication_algorithm#Long_multiplication "Multiplication algorithm"); simple sorting algorithms, such as [bubble sort](https://en.wikipedia.org/wiki/Bubble_sort "Bubble sort"), [selection sort](https://en.wikipedia.org/wiki/Selection_sort "Selection sort") and [insertion sort](https://en.wikipedia.org/wiki/Insertion_sort "Insertion sort"); (worst-case) bound on some usually faster sorting algorithms such as [quicksort](https://en.wikipedia.org/wiki/Quicksort "Quicksort"), [Shellsort](https://en.wikipedia.org/wiki/Shellsort "Shellsort"), and [tree sort](https://en.wikipedia.org/wiki/Tree_sort "Tree sort")

### O(c^n) exponential 	

Finding the (exact) solution to the [travelling salesman problem](https://en.wikipedia.org/wiki/Travelling_salesman_problem "Travelling salesman problem") using [dynamic programming](https://en.wikipedia.org/wiki/Dynamic_programming "Dynamic programming"); determining if two logical statements are equivalent using [brute-force search](https://en.wikipedia.org/wiki/Brute-force_search "Brute-force search")

### O(n!) factorial 	

Solving the [travelling salesman problem](https://en.wikipedia.org/wiki/Travelling_salesman_problem "Travelling salesman problem") via brute-force search; generating all unrestricted permutations of a [poset](https://en.wikipedia.org/wiki/Partially_ordered_set "Partially ordered set"); finding the [determinant](https://en.wikipedia.org/wiki/Determinant "Determinant") with [Laplace expansion](https://en.wikipedia.org/wiki/Laplace_expansion "Laplace expansion"); enumerating [all partitions of a set](https://en.wikipedia.org/wiki/Bell_number)


## References

[Wiki](https://en.wikipedia.org/wiki/Big_O_notation)