# Map 


## Shorthands


```swift
sessionNotExpired
    .map(\.authentication.refreshToken.value)

```

Keypath - \ : shorthand for the type of `Session.Entry`
Not referencing actual Session.Entry object. Just passing a key like a dictionary key path.
Compiler infers the type using the `\.` 

`.map(Session.Entry.authentication.refreshToken.value)` doesnt compile
but `\` is saying use a reference and map internally.
 

```swift
sessionNotExpired
    .map { $0.authentication.refreshToken.value }

```


## Split

```swift
// Not present? Optional ?
let (isSSOEnabled, isSSODisabled) = sessionEntry
	.filter { session in
		return session == nil
	}
	.mapToVoid()
	.split { _ in context.account.onlySSO }
	.map { _ in context.account.onlySSO }
	.split{$0}
```


## Navigation Context

You can check the difference between these two options we have for mapping NavigationContext to present them in the same Rx chain. 
Some of the code refers to the [rxSwift extensions](rx_extensions.md) file 

1st example
Old:
```swift
// User requested to skip the onboarding screens
skipButton
	.rx
	.tap
	.asObservable()
	.mapToVoid()
	.withUnretained(self)
	.subscribeNext(weak: self, OnboardingFlowViewController.showSignUpWebView)
	.disposed(by: disposeBag)
	
private func showSignUpWebView() {
        let signUpViewController = SignUpViewController(context: context)
        navigationController?
            .pushViewController(signUpViewController,
                                animated: true)
    }
```

New:
```swift
// User requested to skip the onboarding screens
skipButton
	.rx
	.tap
	.asObservable()
	.mapToVoid()
	.withUnretained(self)
	.subscribe(onNext: { owner, _ in
		let view = SignUpViewController(context: owner.context)
		owner.navigationController?.pushViewController(view, animated: true)
	})
	.disposed(by: disposeBag)
```


2nd Example

```swift
successfulSubject // Void
	.map { UserTrialsCreationContext(hidesButton: true) }
	.map(NavigationContext.startBuildingApp)
	.map(ViewControllerFactory.create)
	.delay(.seconds(3), scheduler: MainScheduler.instance) 
	.withUnretained(windowManager)
	.subscribe(onNext: { window, view in
		let navigationController = UINavigationController(rootViewController: view)
		window.rootViewController?
		.present(navigationController, animated: true)
	})
	.disposed(by: disposeBag)
```

The delay was added due 
`// Async Windows events firing mitigating timing issue.`