# Best Practices for Apple ecosystem

## Intro

Following best practices are always easier said then done. So having more context around every decision you make and why you make is helpful in general sense to provide better maintainability of the code / software you're writing.

## Structure 

[naming](naming.md)

[string_segregation](string_segregation.md)

[creational_patterns](creational_patterns.md)

## Code Management

[swift_lint](swift_lint.md)

[danger](danger.md)

[documentation](ios/lifecycle/documentation.md)

## Concurrency 

Basic understanding of concurrency
[concurrency](architecture/concurrency.md)

## UI 

Not blocking the main thread for smooth UI operations read more about apple swift async operations [dispatch_main](dispatch_main.md)


## Storage

[secret_keys](secret_keys.md)


##  [Access Control](ios/swift/access_control.md)

## Conformance

You can have [protocol enforcement](protocol.md) in your code for safe guarding yourself to not expose things more than necessary or make sure that the public interface gets properly written with strict Inputs and Outputs.

