# GitHub Project Guidelines

Thank you for taking the time to report a bug/request a feature 👍

Kinds of issues which can be raised in the project:

- Bug Report
- Checklist TODO
- Conversational
- Feature TODO
- iOS Feature TODO

Please search and see if your issue has already been filed/asked before submitting it. Duplicates will be closed. If your issues do not have the questionnaire filled, it will be closed. If you feel the need to address an already filed issue, please comment in that issue itself.

## Workflow

- Please follow consistent Git messages, to describe the change and appropriately link issues, To Do and feature requests while pushing changes to your branch.
- If you failed to adhere this methods, Git administrator may squash and rebase the git history according to the proper description of the code updates with Merge commit summary + description.
 - People looking to contribute please go through our Contributing guidelines and then filter issues by "good first issue", comment on the issue that they would like to be assigned to work on it.


## Tasks

- When a new category issue is created appropriate label & person would be automatically assigned to it.
- Utilize appropriate color coded labels, don't clutter too much information with Issue titles.
- Please follow consistent task creation and provide as much verbose information about the task or bug as possible.
- For example, I would link you a task created for iOS app functionality. #31 #30 


## Git Commits

Please try to label your commit messages and description as much as possible.
You can use one of these commit message format.

- Syntax: 

> (type)File/Feature name: What did you changed/ functionality 

- Example:

> (feat)iOS Health: Workouts tracking added

- Types:
  - feat: A new feature
  - fix: A bug fix
  - docs: Documentation only changes
  - style: Changes that do not affect the meaning of the code (UI)
  - refactor: A code change that neither fixes a bug nor adds a feature
  - perf: A code change that improves performance
  - chore: Unrelated to code or removing  (white-space, commented code, formatting, missing semi-colons, etc)
  - build: Build related changes

[Git commitzen](https://github.com/commitizen/cz-cli) 

## PR Merge

- After your PR is been submitted for the change request, Bug Issue fix. You can add reviewers for your code merge to "Master" branch. 
- If someone approves the PR via Peer Review, you can merge the PR into "default master" branch.


## Learn

You can watch some videos regarding good practices to be followed with GitHub Workflow. I'm linking some sources you could find useful.

- [Professional Guides: Managing Projects](https://www.youtube.com/watch?v=nI5VdsVl0FM)

- [Git & GitHub Crash Course For Beginners](https://www.youtube.com/watch?v=SWYqp7iY_Tc)

- [Opensource Guide](https://opensource.guide/)

Tools

- [GitKraken](https://www.gitkraken.com/invite/3ok6ATxr)