# White space

We will discuss how CSS elements could have white spacing or breathing space for every other component it hugs closely. Proper Grid layout and white space differentiates average and good User Experiences.

## Margin

It is the most outermost whitespace of any css layout. You can specify simple Margin value or you can custom margin according to your preferences of Left,Down, Up and Down \(LRUD\)

```css
 margin: 20px,
 marginTop: 25px
```

## Border

Border could be used to set specific border differences of border width or radius depending on your preferences.

```css
 borderWidth: 2px,
 borderRadius: 10px
 borderColor: 'black',
```

If you want the component to have visual to differentiate various other components you could tweak border property accordingly.

```css
borderBottomColor: 'black',
borderBottomWidth: 10,
```

## Padding

Padding could be used to add padding or whitespace internally of a component. So if there is a button component then margin would set how other components would arrange themselves with the button component. But if the button component has text, image or link child component, then internal padding of these components could be done using padding attribute.

```css
padding: 10px,
paddingLeft: 10px
```

