

## Clean Code

Uncle Bob's famous book about maintaining or writing scalable software

[Satire video | Biggest Scams In Software Engineering](https://youtu.be/-_o4YFFD6is?si=2uUK4Q04vt3rnyvf)

## DRY

Don't Repeat Yourself


## KISS

Keep it Simple Stupid


## SOLID

- Single Responsibility Principle (SRP)
- Open-Close Principle (OCP)
- Liskov Substitution Principle (LSP)
- Interface Segregation Principle (ISP)
- Dependency Inversion Principle (DIP)


## OOP

Four pillars of OOPs, **abstraction, encapsulation, inheritance, and polymorphism**



## Functional Programming

**In functional programming, however, there are no variables; there are functions and functions only**.

FP is based on the principles of immutability, referential transparency, higher-order functions, and recursion.

[swift - example of functional_programming](functional_programming.md)

## Reactive Programming

Reactive programming **creates software that responds to events rather than solicits inputs from users**

[Wiki](https://en.wikipedia.org/wiki/Reactive_programming)


## Imperative Programming 


[Wiki](https://en.wikipedia.org/wiki/Imperative_programming)


## Hardware description language

> In [computer engineering](https://en.wikipedia.org/wiki/Computer_engineering "Computer engineering"), a **hardware description language** (**HDL**) is a specialized [computer language](https://en.wikipedia.org/wiki/Computer_language "Computer language") used to describe the structure and behavior of [electronic circuits](https://en.wikipedia.org/wiki/Electronic_circuit "Electronic circuit"), most commonly to design [ASICs](https://en.wikipedia.org/wiki/Application-specific_integrated_circuit "Application-specific integrated circuit") and program [FPGAs](https://en.wikipedia.org/wiki/Field-programmable_gate_array "Field-programmable gate array").

[Wiki](https://en.wikipedia.org/wiki/Hardware_description_language)

## LoB

Locality of Behavior 

[locality of behaviour (LoB)](https://htmx.org/essays/locality-of-behaviour/)