
Composable Architecture for keeping track of different states across the app. Just like react redux.

## List

[input_output](input_output.md)

[setup](architecture/concurrency/composable/setup.md)

[usage](usage.md)

[viewState](viewState.md)

[viewStateBridgeVCVM](viewStateBridgeVCVM.md)

[viewStateCustomModel](viewStateCustomModel.md)

[viewStateExtensions](viewStateExtensions.md)

[viewStateProtocol](viewStateProtocol.md)

[viewStateViewController](viewStateViewController.md)

[viewStateViewModel](viewStateViewModel.md)



## References

[an-ios-architecture-approach-for-uiviewcontroller-states-error-management-in-swift](https://blog.smartnsoft.com/an-ios-architecture-approach-for-uiviewcontroller-states-error-management-in-swift-a353b0e53d94)


ViewStates current state

[maintaining-state-in-view-controllers](https://swiftwithmajid.com/2019/01/23/maintaining-state-in-view-controllers/)

[HWS | reflecting-loading-error-states-on-api-calls](https://www.hackingwithswift.com/forums/swiftui/reflecting-loading-error-states-on-api-calls/2561)


[swift by sundell | handling-loading-states-in-swiftui](https://www.swiftbysundell.com/articles/handling-loading-states-in-swiftui/)


[Documentation by Point free](https://pointfreeco.github.io/swift-composable-architecture/0.54.0/tutorials/meetcomposablearchitecture)


[The Composable Architecture: My 3 Year Experience](https://rodschmidt.com/posts/composable-architecture-experience/)