# Architecture

## Intro

I love architecture and design patterns.
This is one of those head scratcher where I thought I would start writing things out how I'm understanding the patterns in real code examples.

So it won't be fully fleshed out but nothing in this whole cheatsheet is. Everything is just a scratch pad for me to keep my brain stimulated with new things and gotchas.

Enjoy!

## [Architecture Patterns](architectural_pattern.md)

## [Behavioral Patterns](behavioral_patterns.md)

## [Concurrency Pattern](concurrency_pattern.md)

## [Creational Patterns](creational_patterns.md)

## [Structural Pattern](structural_pattern.md)

## SDLC

[IT Depends](it_Depends.md)

[[architecture/concurrency]]

[System Designs](system_designs.md)

[software_updates](software_updates.md)

## [Terminologies](architecture/terminologies.md)

## Advance Topics

[Swift Concurrency](ios/concurrency/Readme_concurrency.md)

### Reactive Paradigm

[RxSwift](ios/rxSwift/README_rxSwift.md) 
[Combine](ios/combine/ReadMe_combine.md)

### View Debugging, Memory Graph, Method Swizzling

[Performance](ios/xcode/performance.md)
[ARC](ios/lifecycle/arc.md)
[debug](ios/xcode/debug.md)

Higher Order functions [short_hands](ios/swift/short_hands.md)

## Resources

[Point Free](https://www.pointfree.co/collections/composable-architecture)

[Point Series](https://www.pointfree.co)

[design-patterns](https://refactoring.guru/design-patterns/catalog)

[SO | whats-the-difference-between-design-patterns-and-architectural-patterns](https://stackoverflow.com/questions/4243187/whats-the-difference-between-design-patterns-and-architectural-patterns)

[Wiki | Software_design_pattern](https://en.wikipedia.org/wiki/Software_design_pattern)

[Wiki | architectural pattern](https://en.wikipedia.org/wiki/Architectural_pattern)

[Wiki | Design_pattern](https://en.wikipedia.org/wiki/Design_pattern)

[Medium | iOS pattern](https://singhdivesh.medium.com/according-to-wikipedia-b1afa6de08c) 
