'use strict';

var obsidian = require('obsidian');

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var MyVantagePlugin = /** @class */ (function (_super) {
    __extends(MyVantagePlugin, _super);
    function MyVantagePlugin() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MyVantagePlugin.prototype.onload = function () {
        var _this = this;
        console.log('Loading the Vantage plugin.');
        if (this.app.workspace.layoutReady) {
            this.onLayoutReady();
        }
        else {
            this.app.workspace.on("layout-ready", this.onLayoutReady.bind(this));
        }
        this.addCommand({
            id: 'build-search',
            name: "Build a new search",
            checkCallback: function (checking) {
                var leaf = _this.app.workspace.activeLeaf;
                if (leaf) {
                    if (!checking) {
                        new VantageModal(_this.app).open();
                    }
                    return true;
                }
                return false;
            }
        });
        this.addRibbonIcon('magnifying-glass', 'Vantage - Advanced search builder', function () {
            var leaf = _this.app.workspace.activeLeaf;
            if (leaf) {
                new VantageModal(_this.app).open();
                return true;
            }
            return false;
        });
        // this.addSettingTab(new SampleSettingTab(this.app, this));
    };
    MyVantagePlugin.prototype.onLayoutReady = function () {
        // Check for the Natural Language Dates plugin after all the plugins are loaded.
        // If not found, tell the user to install it/initialize it.
        var naturalLanguageDates = this.app.plugins.getPlugin('nldates-obsidian');
        if (!naturalLanguageDates) {
            new obsidian.Notice("The Natural Language Dates plugin was not found. The Vantage plugin requires the Natural Language Dates plugin. Please install it first and make sure it is updated and enabled before using Vantage.");
        }
    };
    MyVantagePlugin.prototype.onunload = function () {
        console.log('Unloading the Vantage plugin');
    };
    // getBacklinks(someFile: TFile) { // No longer used
    // 	let obsidianApp = this.app;
    // 	let allNotes = this.app.vault.getMarkdownFiles();
    // 	let currentBacklinks: Object[] = [];
    // 	allNotes.forEach((markdownFile: TFile) => {
    // 		this.app.metadataCache.getFileCache(markdownFile);
    // 		let thisMetadataCache = obsidianApp.metadataCache.getFileCache(markdownFile);
    // 		if (thisMetadataCache.links) {
    // 			for (let eachLink of thisMetadataCache.links) {
    // 				if (eachLink.link === currentFileName) {
    // 					currentBacklinks.push({noteName: markdownFile.basename, startPosition: eachLink.position.start, endPosition: eachLink.position.end});
    // 				}
    // 			}
    // 		}
    // 		if (thisMetadataCache.embeds) {
    // 			for (let eachEmbed of thisMetadataCache.embeds) {
    // 				if (eachEmbed.link.contains(currentFileName)) {
    // 					currentBacklinks.push({noteName: markdownFile.basename, startPosition: eachEmbed.position.start, endPosition: eachEmbed.position.end});
    // 				}
    // 			}
    // 		}
    // 	});
    // 	return currentBacklinks;
    // }
    MyVantagePlugin.prototype.delay = function (waittimeInMilliseconds) {
        return new Promise(function (resolve) {
            setTimeout(function () {
                resolve(2);
            }, waittimeInMilliseconds);
        });
    };
    MyVantagePlugin.prototype.getSearch = function (someSearchQuery) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.app.internalPlugins.getPluginById('global-search').instance.openGlobalSearch(someSearchQuery);
                        return [4 /*yield*/, this.delay(5000)];
                    case 1:
                        _a.sent();
                        this.app.workspace.getLeavesOfType('search')[0].view.dom.resultDoms;
                        return [2 /*return*/];
                }
            });
        });
    };
    return MyVantagePlugin;
}(obsidian.Plugin));
var VantageModal = /** @class */ (function (_super) {
    __extends(VantageModal, _super);
    function VantageModal(app) {
        return _super.call(this, app) || this;
    }
    VantageModal.prototype.onOpen = function () {
        var _this = this;
        var contentEl = this.contentEl;
        var searchModal = this;
        contentEl.parentElement.addClass("vantage-modal");
        var vantagePlugin = this.app.plugins.getPlugin("vantage-obsidian");
        var naturalLanguageDates = this.app.plugins.getPlugin('nldates-obsidian'); // Get the Natural Language Dates plugin.
        this.titleEl.setText("Vantage - Advanced Search");
        var vantageSettingsDiv = contentEl.createEl("div");
        var vantageSettingsDescriptionDiv = contentEl.createEl("div");
        vantageSettingsDescriptionDiv.addClass("setting-item");
        var vantageSettingsDescriptionSubdiv = contentEl.createEl("div");
        vantageSettingsDescriptionSubdiv.addClass("setting-item-info");
        var vantageSettingsDescription = contentEl.createEl("div", { "text": "Vantage helps create complex search queries. See Obsidian's search documentation for more." });
        vantageSettingsDescription.addClass("setting-item-description");
        var vantageSettingsDescriptionLink = contentEl.createEl("a", { "text": "https://publish.obsidian.md/help/Plugins/Search" });
        var vantageSettingsLinebreakDiv = contentEl.createEl("div");
        var vantageSettingsLinebreak = contentEl.createEl("br");
        vantageSettingsLinebreakDiv.append(vantageSettingsLinebreak);
        vantageSettingsLinebreakDiv.addClass("setting-item-description");
        vantageSettingsDescriptionLink.addClass("setting-item-description");
        vantageSettingsDescriptionLink.setAttr("href", "https://publish.obsidian.md/help/Plugins/Search");
        var vantageSettingsRegexDescription = contentEl.createEl("div", { "text": "Many complex searches use Regular Expressions. These help us search for patterns in our text. Visit RegExr to learn more and to practice with regular expressions." });
        vantageSettingsRegexDescription.addClass("setting-item-description");
        var vantageSettingsRegexLink = contentEl.createEl("a", { "text": "https://regexr.com/" });
        vantageSettingsRegexLink.setAttr("href", "https://regexr.com/");
        vantageSettingsRegexLink.addClass("setting-item-description");
        vantageSettingsDescriptionSubdiv.append(vantageSettingsDescription);
        vantageSettingsDescriptionSubdiv.append(vantageSettingsDescriptionLink);
        vantageSettingsDescriptionSubdiv.append(vantageSettingsLinebreakDiv);
        vantageSettingsDescriptionSubdiv.append(vantageSettingsRegexDescription);
        vantageSettingsDescriptionSubdiv.append(vantageSettingsRegexLink);
        vantageSettingsDescriptionDiv.append(vantageSettingsDescriptionSubdiv);
        vantageSettingsDiv.append(vantageSettingsDescriptionDiv);
        // Note attributes
        var noteAttributesHeadingDiv = contentEl.createEl("h2", { "text": "Search note attributes" });
        noteAttributesHeadingDiv.addClass("setting-item");
        noteAttributesHeadingDiv.addClass("setting-item-heading");
        vantageSettingsDiv.append(noteAttributesHeadingDiv);
        // Note Titles
        var noteTitleContainsDiv = contentEl.createEl("div");
        noteTitleContainsDiv.addClass("setting-item");
        var noteTitleInfoDiv = contentEl.createEl("div");
        noteTitleInfoDiv.addClass("setting-item-info");
        var noteTitleControlDiv = contentEl.createEl("div");
        noteTitleControlDiv.addClass("setting-item-control");
        var noteTitleContainsText = contentEl.createEl("span", { "text": "Note title contains: " });
        noteTitleContainsText.addClass("setting-item-name");
        var noteTitleContainsInput = contentEl.createEl("input", { "type": "text" });
        noteTitleContainsInput.id = "note-title-input";
        //noteTitleContainsInput.setAttr("style", "float: right; width: 50%");
        noteTitleInfoDiv.append(noteTitleContainsText);
        noteTitleControlDiv.append(noteTitleContainsInput);
        noteTitleContainsDiv.append(noteTitleInfoDiv);
        noteTitleContainsDiv.append(noteTitleControlDiv);
        vantageSettingsDiv.append(noteTitleContainsDiv);
        // Date range:
        var dateRangeDiv = contentEl.createEl("div");
        dateRangeDiv.addClass("setting-item");
        var dateRangeHeaderDiv = contentEl.createEl("div");
        dateRangeHeaderDiv.addClass("setting-item-info");
        var dateRangeHeader = contentEl.createEl("div", { "text": "Date range: " });
        dateRangeHeader.addClass("setting-item-name");
        var dateRangeSubtitle = contentEl.createEl("span", { "text": "(Entering data here will make the search include only daily notes (and may conflict with the above). Use natural language.)" });
        dateRangeSubtitle.setAttr("class", "setting-item-description");
        dateRangeHeaderDiv.append(dateRangeHeader);
        dateRangeHeaderDiv.append(dateRangeSubtitle);
        var startDateDiv = contentEl.createEl("div");
        var startDateInfoDiv = contentEl.createEl("div");
        startDateInfoDiv.addClass("setting-item-info");
        var startDateText = contentEl.createEl("div", { "text": "Start date: " });
        startDateText.addClass("setting-item-name");
        startDateInfoDiv.append(startDateText);
        var startDateControlDiv = contentEl.createEl("div");
        startDateControlDiv.addClass("setting-item-control");
        var fileStartDateInput = contentEl.createEl("input", { "type": "text" });
        startDateControlDiv.append(fileStartDateInput);
        startDateDiv.append(startDateInfoDiv);
        startDateDiv.append(startDateControlDiv);
        var endDateDiv = contentEl.createEl("div");
        var endDateInfoDiv = contentEl.createEl("div");
        endDateInfoDiv.addClass("setting-item-info");
        var endDateText = contentEl.createEl("div", { "text": "End date: " });
        endDateText.addClass("setting-item-name");
        endDateInfoDiv.append(endDateText);
        var endDateControlDiv = contentEl.createEl("div");
        endDateControlDiv.addClass("setting-item-control");
        var fileEndDateInput = contentEl.createEl("input", { "type": "text" });
        endDateControlDiv.append(fileEndDateInput);
        endDateDiv.append(endDateInfoDiv);
        endDateDiv.append(endDateControlDiv);
        dateRangeDiv.append(dateRangeHeaderDiv);
        dateRangeDiv.append(startDateDiv);
        dateRangeDiv.append(endDateDiv);
        vantageSettingsDiv.append(dateRangeDiv);
        // Tagged with
        var tagDiv = contentEl.createEl("div");
        tagDiv.addClass("setting-item");
        var tagInfoDiv = contentEl.createEl("div");
        var tagControlDiv = contentEl.createEl("div");
        tagInfoDiv.addClass("setting-item-info");
        tagControlDiv.addClass("setting-item-control");
        var noteTagText = contentEl.createEl("div", { "text": "Tagged with: " });
        noteTagText.addClass("setting-item-name");
        tagInfoDiv.append(noteTagText);
        var tagInput = contentEl.createEl("input", { "type": "text" });
        tagControlDiv.append(tagInput);
        tagDiv.append(tagInfoDiv);
        tagDiv.append(tagControlDiv);
        vantageSettingsDiv.append(tagDiv);
        // Notes with Path
        var notesPathDiv = contentEl.createEl("div");
        notesPathDiv.addClass("setting-item");
        var notesPathInfoDiv = contentEl.createEl("div");
        var notesPathControlDiv = contentEl.createEl("div");
        notesPathInfoDiv.addClass("setting-item-info");
        notesPathControlDiv.addClass("setting-item-control");
        var notesPathText = contentEl.createEl("div", { "text": "Notes in folder or path: " });
        notesPathText.addClass("setting-item-name");
        var notePathDescription = contentEl.createEl("span", { "text": "For example, include the folder to your Daily Notes to search all daily notes." });
        notePathDescription.setAttr("class", "setting-item-description");
        notesPathInfoDiv.append(notesPathText);
        notesPathInfoDiv.append(notePathDescription);
        var notesPathInput = contentEl.createEl("input", { "type": "text" });
        notesPathControlDiv.append(notesPathInput);
        notesPathDiv.append(notesPathInfoDiv);
        notesPathDiv.append(notesPathControlDiv);
        vantageSettingsDiv.append(notesPathDiv);
        // Note contents
        var noteContentsHeadingDiv = contentEl.createEl("h2", { "text": "Search note contents" });
        noteContentsHeadingDiv.addClass("setting-item");
        noteContentsHeadingDiv.addClass("setting-item-heading");
        vantageSettingsDiv.append(noteContentsHeadingDiv);
        contentEl.append(vantageSettingsDiv);
        var focusInputBox = contentEl.querySelector("#note-title-input");
        focusInputBox.focus();
        var queryDivs = contentEl.querySelectorAll("div");
        queryDivs.forEach(function (div) {
            var inputBoxes = div.querySelectorAll("input");
            inputBoxes.forEach(function (inputBox) {
                inputBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
        });
        function initiateSearch() {
            var searchQuery = setSearchQuery();
            searchModal.close();
            vantagePlugin.getSearch(searchQuery);
        }
        function processDateRange(startDate, endDate) {
            var parsedFileStartDate = naturalLanguageDates.parseDate(startDate);
            var parsedFileEndDate = naturalLanguageDates.parseDate(endDate);
            console.debug("Start date:" + parsedFileStartDate.formattedString + ". End date: " + parsedFileEndDate.formattedString + ".");
            // figure out if the user input dates in chronological or reverse-chronological order. e.g., did they write "yesterday" then "tomorrow," or "tomorrow" then "yesterday"?
            var dateDirection = "forward";
            if (parsedFileEndDate.moment.isAfter(parsedFileStartDate.moment)) {
                console.log("Dates go forward in time.");
                dateDirection = "forward";
            }
            else {
                dateDirection = "backward";
                console.log("Dates go backwards in time.");
            }
            // iterate through the dates from start to end, adding the title of each daily note to a string we'll use as a search query.
            var allDates = parsedFileStartDate.formattedString; // initialize the search query string
            var currentDate = parsedFileStartDate;
            while ((!(currentDate.formattedString === parsedFileEndDate.formattedString))) {
                var currentDateMoment = currentDate.moment;
                if (dateDirection == "forward") {
                    currentDateMoment = currentDateMoment.add(1, "days");
                }
                else {
                    currentDateMoment = currentDateMoment.subtract(1, "days");
                }
                var nextDate = naturalLanguageDates.parseDate(currentDateMoment.format("MMMM D YYYY"));
                allDates = allDates + " OR " + nextDate.formattedString;
                console.debug(currentDate + " === " + parsedFileEndDate.formattedString + ": " + (currentDate === parsedFileEndDate.formattedString));
                currentDate = nextDate;
            }
            return allDates;
        }
        function processTags(inputTags) {
            //split by spaces, then return each with tag: appended
            //if no #, add the # too
            var allTags = inputTags.split(" ");
            var processedTags = "";
            for (var _i = 0, allTags_1 = allTags; _i < allTags_1.length; _i++) {
                var eachTag = allTags_1[_i];
                if (eachTag.includes("#")) {
                    processedTags = processedTags + "tag:" + eachTag + " ";
                }
                else {
                    processedTags = processedTags + "tag:#" + eachTag + " ";
                }
            }
            processedTags = processedTags.trim();
            return processedTags;
        }
        function setSearchQuery() {
            var searchQuery = "";
            if (noteTitleContainsInput.value != "") {
                if ((fileStartDateInput.value != "") && (fileEndDateInput.value != "")) {
                    searchQuery = searchQuery + "file:(" + noteTitleContainsInput.value + processDateRange(fileStartDateInput.value, fileEndDateInput.value) + ") ";
                }
                else {
                    searchQuery = searchQuery + "file:(" + noteTitleContainsInput.value + ") ";
                }
            }
            else if ((fileStartDateInput.value != "") && (fileEndDateInput.value != "")) {
                searchQuery = searchQuery + "file:(" + processDateRange(fileStartDateInput.value, fileEndDateInput.value) + ") ";
            }
            if (tagInput.value != "") {
                searchQuery = searchQuery + "(" + processTags(tagInput.value) + ") ";
            }
            if (notesPathInput.value != "") {
                searchQuery = searchQuery + "path:(" + notesPathInput.value + ") ";
            }
            var newQueries = contentEl.querySelectorAll("div");
            newQueries.forEach(function (div) {
                if ((div.id.contains("AND")) || (div.id.contains("OR")) || (div.id.contains("NOT"))) {
                    var contentQuery = div.querySelectorAll("input");
                    var subquery_1 = contentQuery.item(0).value;
                    var selectBoxes = div.querySelectorAll("select");
                    selectBoxes.forEach(function (select) {
                        if (select.id.contains("Subtype")) {
                            if (select.value == "") ;
                            if (select.value.contains("link")) {
                                subquery_1 = "\\[\\[.*" + subquery_1 + ".*\\]\\]";
                            }
                            if (select.value.contains("email")) {
                                subquery_1 = "([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\.([a-zA-Z]{2,5})";
                            }
                            if (select.value.contains("phone")) {
                                subquery_1 = "[+]*[(]{0,1}[0-9]{1,4}[)]{0,1}[-\\s\\./0-9]*";
                            }
                        }
                    });
                    selectBoxes.forEach(function (select) {
                        if (select.id.contains("List")) {
                            if (select.value.contains("any")) {
                                if ((subquery_1.contains("[a-zA-Z0-9_")) || subquery_1.contains("}[0-9]")) {
                                    subquery_1 = "(/" + subquery_1 + "/)";
                                }
                            }
                            if (select.value.contains("list item")) {
                                subquery_1 = "(/- [^\[.\]].*" + subquery_1 + ".*/)";
                            }
                            if (select.value.contains("incomplete")) {
                                subquery_1 = "(/- \\[ \\].*" + subquery_1 + ".*/)";
                            }
                            if (select.value.contains("completed")) {
                                subquery_1 = "(/- \\[x\\].*" + subquery_1 + ".*/)";
                            }
                            if (select.value.contains("all")) {
                                subquery_1 = "(/- \\[.\\].*" + subquery_1 + ".*/)";
                            }
                        }
                    });
                    selectBoxes.forEach(function (select) {
                        if (select.id.contains("Type")) {
                            if (select.value.contains("note")) ;
                            if (select.value.contains("section")) {
                                subquery_1 = "section:" + subquery_1;
                            }
                            if (select.value.contains("block")) {
                                subquery_1 = "block:" + subquery_1;
                            }
                            if (select.value.contains("line")) {
                                subquery_1 = "line:" + subquery_1;
                            }
                        }
                    });
                    if (div.id.contains("AND")) {
                        console.log("This is an AND query");
                        searchQuery = searchQuery + " (" + subquery_1 + ")";
                    }
                    else if (div.id.contains("OR")) {
                        console.log("This is an OR query");
                        searchQuery = searchQuery + " OR (" + subquery_1 + ")";
                    }
                    else if (div.id.contains("NOT")) {
                        console.log("This is a NOT query");
                        searchQuery = searchQuery + " -(" + subquery_1 + ")";
                    }
                }
            });
            return searchQuery;
        }
        var vantageButtonsDiv = contentEl.createEl("div");
        vantageButtonsDiv.addClass("setting-item");
        var vantageButtonsControlDiv = contentEl.createEl("div");
        vantageButtonsControlDiv.addClass("setting-item-control");
        var vantageAddedQueriesDiv = contentEl.createEl("div");
        vantageSettingsDiv.append(vantageAddedQueriesDiv);
        var queryCount = 1;
        new obsidian.ButtonComponent(vantageSettingsDiv)
            .setButtonText("Add an AND search token")
            .setClass("mod-cta")
            .onClick(function () {
            var newQueryDiv = contentEl.createEl("div");
            newQueryDiv.addClass("setting-item");
            newQueryDiv.setAttr("id", "AND query" + queryCount);
            var newQueryInfoDiv = contentEl.createEl("div");
            newQueryInfoDiv.addClass("setting-item-info");
            var newQueryControlDiv = contentEl.createEl("div");
            newQueryControlDiv.addClass("setting-item-control");
            var newQuerySentenceStart = contentEl.createEl("div", { "text": "AND search⠀" });
            newQueryControlDiv.append(newQuerySentenceStart);
            // choose query type
            var queryType = contentEl.createEl("select");
            queryType.setAttr("class", "dropdown");
            queryType.multiple;
            //queryType.setAttr("style", "float: right;");
            queryType.setAttr("id", "Additional Query Type " + queryCount);
            var defaultTypeOption = contentEl.createEl("option", { "value": "note", "text": "notes" });
            defaultTypeOption.selected;
            queryType.append(defaultTypeOption);
            queryType.append(contentEl.createEl("option", { "value": "section", "text": "sections" }));
            queryType.append(contentEl.createEl("option", { "value": "block", "text": "blocks" }));
            queryType.append(contentEl.createEl("option", { "value": "line", "text": "lines" }));
            newQueryControlDiv.append(queryType);
            var newQueryForText = contentEl.createEl("div", { "text": "⠀for⠀" });
            newQueryControlDiv.append(newQueryForText);
            // choose list type
            var listType = contentEl.createEl("select");
            listType.setAttr("class", "dropdown");
            listType.multiple;
            //listType.setAttr("style", "float: right;");
            listType.setAttr("id", "Additional Query List Type " + queryCount);
            var defaultListTypeOption = contentEl.createEl("option", { "value": "any", "text": "any line type" });
            defaultListTypeOption.selected;
            listType.append(defaultListTypeOption);
            listType.append(contentEl.createEl("option", { "value": "list item", "text": "list items" }));
            listType.append(contentEl.createEl("option", { "value": "incomplete tasks", "text": "incomplete tasks" }));
            listType.append(contentEl.createEl("option", { "value": "completed tasks", "text": "completed tasks" }));
            listType.append(contentEl.createEl("option", { "value": "all tasks", "text": "all tasks" }));
            newQueryControlDiv.append(listType);
            // choose query subtype
            var querySubtype = contentEl.createEl("select");
            querySubtype.setAttr("class", "dropdown");
            querySubtype.multiple;
            querySubtype.setAttr("id", "Additional Query Subtype " + queryCount);
            // querySubtype.setAttr("style", "float: right;");
            var defaultSubtypeOption = contentEl.createEl("option", { "value": "", "text": "with text containing" });
            defaultSubtypeOption.selected;
            querySubtype.append(defaultSubtypeOption);
            querySubtype.append(contentEl.createEl("option", { "value": "with a link to notes with names containing", "text": "with links to notes with names containing" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with an email address", "text": "with email addresses (ignores the following search field)" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with a phone number", "text": "with phone numbers (ignores the following search field)" }));
            newQueryControlDiv.append(querySubtype);
            var newQuery = contentEl.createEl("input", { "type": "text" });
            newQuery.setAttr("id", "AND query " + queryCount);
            queryCount = queryCount + 1;
            newQueryControlDiv.append(newQuery);
            newQueryDiv.append(newQueryInfoDiv);
            newQueryDiv.append(newQueryControlDiv);
            vantageAddedQueriesDiv.append(newQueryDiv);
            var inputBoxes = vantageAddedQueriesDiv.querySelectorAll("input");
            inputBoxes.forEach(function (inputBox) {
                inputBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
            var optionBoxes = vantageAddedQueriesDiv.querySelectorAll("select");
            optionBoxes.forEach(function (optionBox) {
                optionBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
        });
        new obsidian.ButtonComponent(vantageSettingsDiv)
            .setButtonText("Add an OR search token")
            .setClass("mod-cta")
            .onClick(function () {
            var newQueryDiv = contentEl.createEl("div");
            newQueryDiv.addClass("setting-item");
            newQueryDiv.setAttr("id", "OR query" + queryCount);
            var newQueryInfoDiv = contentEl.createEl("div");
            newQueryInfoDiv.addClass("setting-item-info");
            // let newQueryTextLabel = contentEl.createEl("div", {"text":"OR search ..."});
            // newQueryInfoDiv.append(newQueryTextLabel);
            var newQueryControlDiv = contentEl.createEl("div");
            newQueryControlDiv.addClass("setting-item-control");
            var newQuerySentenceStart = contentEl.createEl("div", { "text": "OR search⠀" });
            newQueryControlDiv.append(newQuerySentenceStart);
            // choose query type
            var queryType = contentEl.createEl("select");
            queryType.setAttr("class", "dropdown");
            queryType.multiple;
            //queryType.setAttr("style", "float: right;");
            queryType.setAttr("id", "Additional Query Type " + queryCount);
            var defaultTypeOption = contentEl.createEl("option", { "value": "note", "text": "notes" });
            defaultTypeOption.selected;
            queryType.append(defaultTypeOption);
            queryType.append(contentEl.createEl("option", { "value": "section", "text": "sections" }));
            queryType.append(contentEl.createEl("option", { "value": "block", "text": "blocks" }));
            queryType.append(contentEl.createEl("option", { "value": "line", "text": "lines" }));
            newQueryControlDiv.append(queryType);
            var newQueryForText = contentEl.createEl("div", { "text": "⠀for⠀" });
            newQueryControlDiv.append(newQueryForText);
            // choose list type
            var listType = contentEl.createEl("select");
            listType.setAttr("class", "dropdown");
            listType.multiple;
            //listType.setAttr("style", "float: right;");
            listType.setAttr("id", "Additional Query List Type " + queryCount);
            var defaultListTypeOption = contentEl.createEl("option", { "value": "any", "text": "any line type" });
            defaultListTypeOption.selected;
            listType.append(defaultListTypeOption);
            listType.append(contentEl.createEl("option", { "value": "list item", "text": "list items" }));
            listType.append(contentEl.createEl("option", { "value": "incomplete tasks", "text": "incomplete tasks" }));
            listType.append(contentEl.createEl("option", { "value": "completed tasks", "text": "completed tasks" }));
            listType.append(contentEl.createEl("option", { "value": "all tasks", "text": "all tasks" }));
            newQueryControlDiv.append(listType);
            // choose query subtype
            var querySubtype = contentEl.createEl("select");
            querySubtype.setAttr("class", "dropdown");
            querySubtype.multiple;
            querySubtype.setAttr("id", "Additional Query Subtype " + queryCount);
            // querySubtype.setAttr("style", "float: right;");
            var defaultSubtypeOption = contentEl.createEl("option", { "value": "", "text": "with text containing" });
            defaultSubtypeOption.selected;
            querySubtype.append(defaultSubtypeOption);
            querySubtype.append(contentEl.createEl("option", { "value": "with a link to notes with names containing", "text": "with links to notes with names containing" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with an email address", "text": "with email addresses (ignores the following search field)" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with a phone number", "text": "with phone numbers (ignores the following search field)" }));
            newQueryControlDiv.append(querySubtype);
            var newQuery = contentEl.createEl("input", { "type": "text" });
            newQuery.setAttr("id", "OR query " + queryCount);
            queryCount = queryCount + 1;
            newQueryControlDiv.append(newQuery);
            newQueryDiv.append(newQueryInfoDiv);
            newQueryDiv.append(newQueryControlDiv);
            vantageAddedQueriesDiv.append(newQueryDiv);
            var inputBoxes = vantageAddedQueriesDiv.querySelectorAll("input");
            inputBoxes.forEach(function (inputBox) {
                inputBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
            var optionBoxes = vantageAddedQueriesDiv.querySelectorAll("select");
            optionBoxes.forEach(function (optionBox) {
                optionBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
        });
        new obsidian.ButtonComponent(vantageSettingsDiv)
            .setButtonText("Add a NOT search token")
            .setClass("mod-cta")
            .onClick(function () {
            var newQueryDiv = contentEl.createEl("div");
            newQueryDiv.addClass("setting-item");
            newQueryDiv.setAttr("id", "NOT query" + queryCount);
            var newQueryInfoDiv = contentEl.createEl("div");
            newQueryInfoDiv.addClass("setting-item-info");
            var newQueryControlDiv = contentEl.createEl("div");
            newQueryControlDiv.addClass("setting-item-control");
            var newQuerySentenceStart = contentEl.createEl("div", { "text": "NOT search⠀" });
            newQueryControlDiv.append(newQuerySentenceStart);
            // choose query type
            var queryType = contentEl.createEl("select");
            queryType.setAttr("class", "dropdown");
            queryType.multiple;
            //queryType.setAttr("style", "float: right;");
            queryType.setAttr("id", "Additional Query Type " + queryCount);
            var defaultTypeOption = contentEl.createEl("option", { "value": "note", "text": "notes" });
            defaultTypeOption.selected;
            queryType.append(defaultTypeOption);
            queryType.append(contentEl.createEl("option", { "value": "section", "text": "sections" }));
            queryType.append(contentEl.createEl("option", { "value": "block", "text": "blocks" }));
            queryType.append(contentEl.createEl("option", { "value": "line", "text": "lines" }));
            newQueryControlDiv.append(queryType);
            var newQueryForText = contentEl.createEl("div", { "text": "⠀for⠀" });
            newQueryControlDiv.append(newQueryForText);
            // choose list type
            var listType = contentEl.createEl("select");
            listType.setAttr("class", "dropdown");
            listType.multiple;
            //listType.setAttr("style", "float: right;");
            listType.setAttr("id", "Additional Query List Type " + queryCount);
            var defaultListTypeOption = contentEl.createEl("option", { "value": "any", "text": "any line type" });
            defaultListTypeOption.selected;
            listType.append(defaultListTypeOption);
            listType.append(contentEl.createEl("option", { "value": "list item", "text": "list items" }));
            listType.append(contentEl.createEl("option", { "value": "incomplete tasks", "text": "incomplete tasks" }));
            listType.append(contentEl.createEl("option", { "value": "completed tasks", "text": "completed tasks" }));
            listType.append(contentEl.createEl("option", { "value": "all tasks", "text": "all tasks" }));
            newQueryControlDiv.append(listType);
            // choose query subtype
            var querySubtype = contentEl.createEl("select");
            querySubtype.setAttr("class", "dropdown");
            querySubtype.multiple;
            querySubtype.setAttr("id", "Additional Query Subtype " + queryCount);
            // querySubtype.setAttr("style", "float: right;");
            var defaultSubtypeOption = contentEl.createEl("option", { "value": "", "text": "with text containing" });
            defaultSubtypeOption.selected;
            querySubtype.append(defaultSubtypeOption);
            querySubtype.append(contentEl.createEl("option", { "value": "with a link to notes with names containing", "text": "with links to notes with names containing" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with an email address", "text": "with email addresses (ignores the following search field)" }));
            querySubtype.append(contentEl.createEl("option", { "value": "with a phone number", "text": "with phone numbers (ignores the following search field)" }));
            newQueryControlDiv.append(querySubtype);
            var newQuery = contentEl.createEl("input", { "type": "text" });
            newQuery.setAttr("id", "NOT query " + queryCount);
            queryCount = queryCount + 1;
            newQueryControlDiv.append(newQuery);
            newQueryDiv.append(newQueryInfoDiv);
            newQueryDiv.append(newQueryControlDiv);
            vantageAddedQueriesDiv.append(newQueryDiv);
            var inputBoxes = vantageAddedQueriesDiv.querySelectorAll("input");
            inputBoxes.forEach(function (inputBox) {
                inputBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
            var optionBoxes = vantageAddedQueriesDiv.querySelectorAll("select");
            optionBoxes.forEach(function (optionBox) {
                optionBox.addEventListener('keypress', function (keypressed) {
                    if (keypressed.key === 'Enter') {
                        initiateSearch();
                    }
                });
            });
        });
        new obsidian.ButtonComponent(vantageButtonsControlDiv)
            .setButtonText("Create embedded search")
            .setClass("mod-cta")
            .onClick(function () {
            var embeddedSearchQueryHeader = "```query\n";
            var embeddedSearchQueryFooter = "\n```";
            var embeddedSearchQuery;
            fileStartDateInput.removeAttribute("style");
            fileEndDateInput.removeAttribute("style");
            if ((fileStartDateInput.value != "") && (fileEndDateInput.value != "")) { // If both date fields have values, the user is trying to search daily notes
                var parsedFileStartDate = naturalLanguageDates.parseDate(fileStartDateInput.value);
                var parsedFileEndDate = naturalLanguageDates.parseDate(fileEndDateInput.value);
                if (parsedFileStartDate.formattedString.contains("Invalid")) { // if the start date cannot be processed, let the user know
                    console.log("Start date could not be processed.");
                    new obsidian.Notice("Sorry, something seems to be wrong with that start date.");
                    fileStartDateInput.setAttr("style", "border-color: var(--background-modifier-error); border-width: .1em;");
                }
                if (parsedFileEndDate.formattedString.contains("Invalid")) { // if the end date cannot be processed, let the user know
                    console.log("End date could not be processed.");
                    new obsidian.Notice("Sorry, something seems to be wrong with that end date.");
                    fileEndDateInput.setAttr("style", "border-color: var(--background-modifier-error); border-width: .1em;");
                }
                if (!(parsedFileStartDate.formattedString.contains("Invalid")) && !(parsedFileEndDate.formattedString.contains("Invalid"))) { // otherwise go ahead with the search
                    embeddedSearchQuery = embeddedSearchQueryHeader + setSearchQuery() + embeddedSearchQueryFooter;
                    // let doc = this.app.workspace.activeLeaf.view.sourceMode.cmEditor.getDoc();
                    var view = _this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
                    if (!view) {
                        new obsidian.Notice("No editable document is open. Perhaps you meant to click \"New search\"?");
                        return;
                    }
                    _this.close();
                    var doc = view.sourceMode.cmEditor.getDoc();
                    var cursor = doc.getCursor();
                    doc.replaceRange(embeddedSearchQuery, cursor);
                }
            }
            else { // no dates have been entered, so the search can continue
                embeddedSearchQuery = embeddedSearchQueryHeader + setSearchQuery() + embeddedSearchQueryFooter;
                var view = _this.app.workspace.getActiveViewOfType(obsidian.MarkdownView);
                if (!view) {
                    new obsidian.Notice("No editable document is open. Perhaps you meant to click \"New search\"?");
                    return;
                }
                _this.close();
                var doc = view.sourceMode.cmEditor.getDoc();
                var cursor = doc.getCursor();
                doc.replaceRange(embeddedSearchQuery, cursor);
            }
        });
        new obsidian.ButtonComponent(vantageButtonsControlDiv)
            .setButtonText("New search")
            .setClass("mod-cta")
            .onClick(function () {
            fileStartDateInput.removeAttribute("style");
            fileEndDateInput.removeAttribute("style");
            if ((fileStartDateInput.value != "") && (fileEndDateInput.value != "")) { // If both date fields have values, the user is trying to search daily notes
                var parsedFileStartDate = naturalLanguageDates.parseDate(fileStartDateInput.value);
                var parsedFileEndDate = naturalLanguageDates.parseDate(fileEndDateInput.value);
                if (parsedFileStartDate.formattedString.contains("Invalid")) { // if the start date cannot be processed, let the user know
                    console.log("Start date could not be processed.");
                    new obsidian.Notice("Sorry, something seems to be wrong with that start date.");
                    fileStartDateInput.setAttr("style", "border-color: var(--background-modifier-error); border-width: .1em;");
                    return;
                }
                if (parsedFileEndDate.formattedString.contains("Invalid")) { // if the end date cannot be processed, let the user know
                    console.log("End date could not be processed.");
                    new obsidian.Notice("Sorry, something seems to be wrong with that end date.");
                    fileEndDateInput.setAttr("style", "border-color: var(--background-modifier-error); border-width: .1em;");
                    return;
                }
                if (!(parsedFileStartDate.formattedString.contains("Invalid")) && !(parsedFileEndDate.formattedString.contains("Invalid"))) { // otherwise go ahead with the search
                    initiateSearch();
                }
            }
            else { // no dates have been entered, so the search can continue
                initiateSearch();
            }
        });
        vantageButtonsDiv.append(vantageButtonsControlDiv);
        vantageSettingsDiv.append(vantageButtonsDiv);
    };
    VantageModal.prototype.onClose = function () {
        var contentEl = this.contentEl;
        contentEl.empty();
    };
    return VantageModal;
}(obsidian.Modal));
// class SampleSettingTab extends PluginSettingTab {
// 	display(): void {
// 		let {containerEl} = this;
// 		containerEl.empty();
// 		containerEl.createEl('h2', {text: 'Settings for my awesome plugin.'});
// 		new Setting(containerEl)
// 			.setName('Setting #1')
// 			.setDesc('It\'s a secret')
// 			.addText(text => text.setPlaceholder('Enter your secret')
// 				.setValue('')
// 				.onChange((value) => {
// 					console.log('Secret: ' + value);
// 				}));
// 	}
// }

module.exports = MyVantagePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
