/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && key !== "default")
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toModule = (module2) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", module2 && module2.__esModule && "default" in module2 ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// main.ts
__export(exports, {
  default: () => MinimalTheme
});
var import_obsidian = __toModule(require("obsidian"));
var MinimalTheme = class extends import_obsidian.Plugin {
  onload() {
    return __async(this, null, function* () {
      yield this.loadSettings();
      this.addSettingTab(new MinimalSettingTab(this.app, this));
      this.addStyle();
      let media = window.matchMedia("(prefers-color-scheme: dark)");
      let updateSystemTheme = () => {
        if (media.matches && this.settings.useSystemTheme) {
          console.log("Dark mode active");
          this.updateDarkStyle();
        } else if (this.settings.useSystemTheme) {
          console.log("Light mode active");
          this.updateLightStyle();
        }
      };
      media.addEventListener("change", updateSystemTheme);
      this.register(() => media.removeEventListener("change", updateSystemTheme));
      updateSystemTheme();
      let settingsUpdate = () => {
        const fontSize = this.app.vault.getConfig("baseFontSize");
        this.settings.textNormal = fontSize;
        if (this.app.vault.getConfig("foldHeading")) {
          this.settings.folding = true;
          this.saveData(this.settings);
          console.log("Folding is on");
        } else {
          this.settings.folding = false;
          this.saveData(this.settings);
          console.log("Folding is off");
        }
        document.body.classList.toggle("minimal-folding", this.settings.folding);
        if (this.app.vault.getConfig("showLineNumber")) {
          this.settings.lineNumbers = true;
          this.saveData(this.settings);
          console.log("Line numbers are on");
        } else {
          this.settings.lineNumbers = false;
          this.saveData(this.settings);
          console.log("Line numbers are off");
        }
        document.body.classList.toggle("minimal-line-nums", this.settings.lineNumbers);
        if (this.app.vault.getConfig("readableLineLength")) {
          this.settings.readableLineLength = true;
          this.saveData(this.settings);
          console.log("Readable line length is on");
        } else {
          this.settings.readableLineLength = false;
          this.saveData(this.settings);
          console.log("Readable line length is off");
        }
        document.body.classList.toggle("minimal-readable", this.settings.readableLineLength);
        document.body.classList.toggle("minimal-readable-off", !this.settings.readableLineLength);
      };
      let sidebarUpdate = () => {
        const sidebarEl = document.getElementsByClassName("mod-left-split")[0];
        const ribbonEl = document.getElementsByClassName("side-dock-ribbon")[0];
        if (sidebarEl && ribbonEl && this.app.vault.getConfig("theme") == "moonstone" && this.settings.lightStyle == "minimal-light-contrast") {
          sidebarEl.addClass("theme-dark");
          ribbonEl.addClass("theme-dark");
        } else if (sidebarEl && ribbonEl) {
          sidebarEl.removeClass("theme-dark");
          ribbonEl.removeClass("theme-dark");
        }
      };
      this.registerEvent(app.vault.on("config-changed", settingsUpdate));
      this.registerEvent(app.workspace.on("css-change", sidebarUpdate));
      settingsUpdate();
      app.workspace.onLayoutReady(() => {
        sidebarUpdate();
      });
      const lightStyles = ["minimal-light", "minimal-light-tonal", "minimal-light-contrast", "minimal-light-white"];
      const darkStyles = ["minimal-dark", "minimal-dark-tonal", "minimal-dark-black"];
      const imgGridStyles = ["img-grid", "img-grid-ratio", "img-nogrid"];
      const tableWidthStyles = ["table-100", "table-default-width", "table-wide", "table-max"];
      const iframeWidthStyles = ["iframe-100", "iframe-default-width", "iframe-wide", "iframe-max"];
      const imgWidthStyles = ["img-100", "img-default-width", "img-wide", "img-max"];
      const mapWidthStyles = ["map-100", "map-default-width", "map-wide", "map-max"];
      const chartWidthStyles = ["chart-100", "chart-default-width", "chart-wide", "chart-max"];
      const theme = ["moonstone", "obsidian"];
      this.addCommand({
        id: "increase-body-font-size",
        name: "Increase body font size",
        callback: () => {
          this.settings.textNormal = this.settings.textNormal + 0.5;
          this.saveData(this.settings);
          this.setFontSize();
        }
      });
      this.addCommand({
        id: "decrease-body-font-size",
        name: "Decrease body font size",
        callback: () => {
          this.settings.textNormal = this.settings.textNormal - 0.5;
          this.saveData(this.settings);
          this.setFontSize();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dark-cycle",
        name: "Cycle between dark mode styles",
        callback: () => {
          this.settings.darkStyle = darkStyles[(darkStyles.indexOf(this.settings.darkStyle) + 1) % darkStyles.length];
          this.saveData(this.settings);
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-light-cycle",
        name: "Cycle between light mode styles",
        callback: () => {
          this.settings.lightStyle = lightStyles[(lightStyles.indexOf(this.settings.lightStyle) + 1) % lightStyles.length];
          this.saveData(this.settings);
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-hidden-borders",
        name: "Toggle sidebar borders",
        callback: () => {
          this.settings.bordersToggle = !this.settings.bordersToggle;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "toggle-colorful-headings",
        name: "Toggle colorful headings",
        callback: () => {
          this.settings.colorfulHeadings = !this.settings.colorfulHeadings;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "toggle-minimal-focus-mode",
        name: "Toggle focus mode",
        callback: () => {
          this.settings.focusMode = !this.settings.focusMode;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "toggle-minimal-colorful-frame",
        name: "Toggle colorful window frame",
        callback: () => {
          this.settings.colorfulFrame = !this.settings.colorfulFrame;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "cycle-minimal-table-width",
        name: "Cycle between table width options",
        callback: () => {
          this.settings.tableWidth = tableWidthStyles[(tableWidthStyles.indexOf(this.settings.tableWidth) + 1) % tableWidthStyles.length];
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "cycle-minimal-image-width",
        name: "Cycle between image width options",
        callback: () => {
          this.settings.imgWidth = imgWidthStyles[(imgWidthStyles.indexOf(this.settings.imgWidth) + 1) % imgWidthStyles.length];
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "cycle-minimal-iframe-width",
        name: "Cycle between iframe width options",
        callback: () => {
          this.settings.iframeWidth = iframeWidthStyles[(iframeWidthStyles.indexOf(this.settings.iframeWidth) + 1) % iframeWidthStyles.length];
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "cycle-minimal-chart-width",
        name: "Cycle between chart width options",
        callback: () => {
          this.settings.chartWidth = chartWidthStyles[(chartWidthStyles.indexOf(this.settings.chartWidth) + 1) % chartWidthStyles.length];
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "cycle-minimal-map-width",
        name: "Cycle between map width options",
        callback: () => {
          this.settings.mapWidth = mapWidthStyles[(mapWidthStyles.indexOf(this.settings.mapWidth) + 1) % mapWidthStyles.length];
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "toggle-minimal-img-grid",
        name: "Toggle image grids",
        callback: () => {
          this.settings.imgGrid = !this.settings.imgGrid;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.addCommand({
        id: "toggle-minimal-switch",
        name: "Switch between light and dark mode",
        callback: () => {
          this.settings.theme = theme[(theme.indexOf(this.settings.theme) + 1) % theme.length];
          this.saveData(this.settings);
          this.updateTheme();
        }
      });
      this.addCommand({
        id: "toggle-minimal-light-default",
        name: "Use light mode (default)",
        callback: () => {
          this.settings.lightStyle = "minimal-light";
          this.saveData(this.settings);
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-light-white",
        name: "Use light mode (all white)",
        callback: () => {
          this.settings.lightStyle = "minimal-light-white";
          this.saveData(this.settings);
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-light-tonal",
        name: "Use light mode (low contrast)",
        callback: () => {
          this.settings.lightStyle = "minimal-light-tonal";
          this.saveData(this.settings);
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-light-contrast",
        name: "Use light mode (high contrast)",
        callback: () => {
          this.settings.lightStyle = "minimal-light-contrast";
          this.saveData(this.settings);
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dark-default",
        name: "Use dark mode (default)",
        callback: () => {
          this.settings.darkStyle = "minimal-dark";
          this.saveData(this.settings);
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dark-tonal",
        name: "Use dark mode (low contrast)",
        callback: () => {
          this.settings.darkStyle = "minimal-dark-tonal";
          this.saveData(this.settings);
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dark-black",
        name: "Use dark mode (true black)",
        callback: () => {
          this.settings.darkStyle = "minimal-dark-black";
          this.saveData(this.settings);
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-atom-light",
        name: "Switch light color scheme to Atom (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-atom-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-ayu-light",
        name: "Switch light color scheme to Ayu (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-ayu-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-catppuccin-light",
        name: "Switch light color scheme to Catppuccin (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-catppuccin-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-default-light",
        name: "Switch light color scheme to default (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-default-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-gruvbox-light",
        name: "Switch light color scheme to Gruvbox (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-gruvbox-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-eink-light",
        name: "Switch light color scheme to E-ink (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-eink-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-everforest-light",
        name: "Switch light color scheme to Everforest (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-everforest-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-flexoki-light",
        name: "Switch light color scheme to Flexoki (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-flexoki-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-macos-light",
        name: "Switch light color scheme to macOS (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-macos-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-notion-light",
        name: "Switch light color scheme to Sky (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-notion-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-nord-light",
        name: "Switch light color scheme to Nord (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-nord-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-rose-pine-light",
        name: "Switch light color scheme to Ros\xE9 Pine (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-rose-pine-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-solarized-light",
        name: "Switch light color scheme to Solarized (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-solarized-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-things-light",
        name: "Switch light color scheme to Things (light)",
        callback: () => {
          this.settings.lightScheme = "minimal-things-light";
          this.saveData(this.settings);
          this.updateLightScheme();
          this.updateLightStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-atom-dark",
        name: "Switch dark color scheme to Atom (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-atom-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-ayu-dark",
        name: "Switch dark color scheme to Ayu (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-ayu-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-catppuccin-dark",
        name: "Switch dark color scheme to Catppuccin (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-catppuccin-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dracula-dark",
        name: "Switch dark color scheme to Dracula (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-dracula-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-default-dark",
        name: "Switch dark color scheme to default (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-default-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-eink-dark",
        name: "Switch dark color scheme to E-ink (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-eink-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-everforest-dark",
        name: "Switch dark color scheme to Everforest (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-everforest-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-flexoki-dark",
        name: "Switch dark color scheme to Flexoki (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-flexoki-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-gruvbox-dark",
        name: "Switch dark color scheme to Gruvbox (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-gruvbox-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-macos-dark",
        name: "Switch dark color scheme to macOS (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-macos-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-nord-dark",
        name: "Switch dark color scheme to Nord (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-nord-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-notion-dark",
        name: "Switch dark color scheme to Sky (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-notion-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-rose-pine-dark",
        name: "Switch dark color scheme to Ros\xE9 Pine (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-rose-pine-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-solarized-dark",
        name: "Switch dark color scheme to Solarized (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-solarized-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-things-dark",
        name: "Switch dark color scheme to Things (dark)",
        callback: () => {
          this.settings.darkScheme = "minimal-things-dark";
          this.saveData(this.settings);
          this.updateDarkScheme();
          this.updateDarkStyle();
        }
      });
      this.addCommand({
        id: "toggle-minimal-dev-block-width",
        name: "Dev \u2014 Show block widths",
        callback: () => {
          this.settings.devBlockWidth = !this.settings.devBlockWidth;
          this.saveData(this.settings);
          this.refresh();
        }
      });
      this.refresh();
    });
  }
  onunload() {
    console.log("Unloading Minimal Theme Settings plugin");
  }
  loadSettings() {
    return __async(this, null, function* () {
      this.settings = Object.assign(DEFAULT_SETTINGS, yield this.loadData());
    });
  }
  saveSettings() {
    return __async(this, null, function* () {
      yield this.saveData(this.settings);
    });
  }
  refresh() {
    this.updateStyle();
  }
  addStyle() {
    const css = document.createElement("style");
    css.id = "minimal-theme";
    document.getElementsByTagName("head")[0].appendChild(css);
    document.body.classList.add("minimal-theme");
    this.updateStyle();
  }
  setFontSize() {
    this.app.vault.setConfig("baseFontSize", this.settings.textNormal);
    this.app.updateFontSize();
  }
  updateStyle() {
    this.removeStyle();
    document.body.addClass(this.settings.darkScheme);
    document.body.addClass(this.settings.lightScheme);
    document.body.classList.toggle("borders-none", !this.settings.bordersToggle);
    document.body.classList.toggle("colorful-headings", this.settings.colorfulHeadings);
    document.body.classList.toggle("colorful-frame", this.settings.colorfulFrame);
    document.body.classList.toggle("colorful-active", this.settings.colorfulActiveStates);
    document.body.classList.toggle("minimal-focus-mode", this.settings.focusMode);
    document.body.classList.toggle("links-int-on", this.settings.underlineInternal);
    document.body.classList.toggle("links-ext-on", this.settings.underlineExternal);
    document.body.classList.toggle("system-shade", this.settings.useSystemTheme);
    document.body.classList.toggle("full-width-media", this.settings.fullWidthMedia);
    document.body.classList.toggle("img-grid", this.settings.imgGrid);
    document.body.classList.toggle("minimal-dev-block-width", this.settings.devBlockWidth);
    document.body.classList.toggle("minimal-status-off", !this.settings.minimalStatus);
    document.body.classList.toggle("full-file-names", !this.settings.trimNames);
    document.body.classList.toggle("labeled-nav", this.settings.labeledNav);
    document.body.classList.toggle("minimal-folding", this.settings.folding);
    document.body.removeClass("table-wide", "table-max", "table-100", "table-default-width", "iframe-wide", "iframe-max", "iframe-100", "iframe-default-width", "img-wide", "img-max", "img-100", "img-default-width", "chart-wide", "chart-max", "chart-100", "chart-default-width", "map-wide", "map-max", "map-100", "map-default-width");
    document.body.addClass(this.settings.chartWidth);
    document.body.addClass(this.settings.tableWidth);
    document.body.addClass(this.settings.imgWidth);
    document.body.addClass(this.settings.iframeWidth);
    document.body.addClass(this.settings.mapWidth);
    const el = document.getElementById("minimal-theme");
    if (!el)
      throw "minimal-theme element not found!";
    else {
      el.innerText = "body.minimal-theme{--font-ui-small:" + this.settings.textSmall + "px;--line-height:" + this.settings.lineHeight + ";--line-width:" + this.settings.lineWidth + "rem;--line-width-wide:" + this.settings.lineWidthWide + "rem;--max-width:" + this.settings.maxWidth + "%;--font-editor-override:" + this.settings.editorFont + ";";
    }
  }
  refreshSystemTheme() {
    const isDarkMode = window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches;
    if (isDarkMode && this.settings.useSystemTheme) {
      console.log("Dark mode active");
      this.updateDarkStyle();
    } else if (this.settings.useSystemTheme) {
      console.log("Light mode active");
      this.updateLightStyle();
    }
  }
  updateDarkStyle() {
    document.body.removeClass("theme-light", "minimal-dark", "minimal-dark-tonal", "minimal-dark-black");
    document.body.addClass(this.settings.darkStyle);
    this.app.setTheme("obsidian");
    this.app.vault.setConfig("theme", "obsidian");
    this.app.workspace.trigger("css-change");
  }
  updateLightStyle() {
    document.body.removeClass("theme-dark", "minimal-light", "minimal-light-tonal", "minimal-light-contrast", "minimal-light-white");
    document.body.addClass(this.settings.lightStyle);
    this.app.setTheme("moonstone");
    this.app.vault.setConfig("theme", "moonstone");
    this.app.workspace.trigger("css-change");
  }
  updateDarkScheme() {
    document.body.removeClass("minimal-atom-dark", "minimal-ayu-dark", "minimal-catppuccin-dark", "minimal-default-dark", "minimal-dracula-dark", "minimal-eink-dark", "minimal-everforest-dark", "minimal-flexoki-dark", "minimal-gruvbox-dark", "minimal-macos-dark", "minimal-nord-dark", "minimal-notion-dark", "minimal-rose-pine-dark", "minimal-solarized-dark", "minimal-things-dark");
    document.body.addClass(this.settings.darkScheme);
  }
  updateLightScheme() {
    document.body.removeClass("minimal-atom-light", "minimal-ayu-light", "minimal-catppuccin-light", "minimal-default-light", "minimal-eink-light", "minimal-everforest-light", "minimal-flexoki-light", "minimal-gruvbox-light", "minimal-macos-light", "minimal-nord-light", "minimal-notion-light", "minimal-rose-pine-light", "minimal-solarized-light", "minimal-things-light");
    document.body.addClass(this.settings.lightScheme);
  }
  updateTheme() {
    this.app.setTheme(this.settings.theme);
    this.app.vault.setConfig("theme", this.settings.theme);
    this.app.workspace.trigger("css-change");
  }
  removeStyle() {
    document.body.removeClass("minimal-light", "minimal-light-tonal", "minimal-light-contrast", "minimal-light-white", "minimal-dark", "minimal-dark-tonal", "minimal-dark-black");
    document.body.addClass(this.settings.lightStyle, this.settings.darkStyle);
  }
};
var DEFAULT_SETTINGS = {
  theme: "moonstone",
  lightStyle: "minimal-light",
  darkStyle: "minimal-dark",
  lightScheme: "minimal-default-light",
  darkScheme: "minimal-default-dark",
  editorFont: "",
  lineHeight: 1.5,
  lineWidth: 40,
  lineWidthWide: 50,
  maxWidth: 88,
  textNormal: 16,
  textSmall: 13,
  imgGrid: false,
  imgWidth: "img-default-width",
  tableWidth: "table-default-width",
  iframeWidth: "iframe-default-width",
  mapWidth: "map-default-width",
  chartWidth: "chart-default-width",
  colorfulHeadings: false,
  colorfulFrame: false,
  colorfulActiveStates: false,
  trimNames: true,
  labeledNav: false,
  fullWidthMedia: true,
  bordersToggle: true,
  minimalStatus: true,
  focusMode: false,
  underlineInternal: true,
  underlineExternal: true,
  useSystemTheme: false,
  folding: true,
  lineNumbers: false,
  readableLineLength: false,
  devBlockWidth: false
};
var MinimalSettingTab = class extends import_obsidian.PluginSettingTab {
  constructor(app2, plugin) {
    super(app2, plugin);
    this.plugin = plugin;
  }
  display() {
    let { containerEl } = this;
    containerEl.empty();
    const colorSection = containerEl.createEl("div", { cls: "setting-item setting-item-heading" });
    const colorSectionInfo = colorSection.createEl("div", { cls: "setting-item-info" });
    colorSectionInfo.createEl("div", { text: "Color scheme", cls: "setting-item-name" });
    const colorDesc = colorSectionInfo.createEl("div", { cls: "setting-item-description" });
    colorDesc.appendChild(createEl("span", {
      text: "To create a custom color scheme use the "
    }));
    colorDesc.appendChild(createEl("a", {
      text: "Style Settings",
      href: "obsidian://show-plugin?id=obsidian-style-settings"
    }));
    colorDesc.appendText(" plugin. See ");
    colorDesc.appendChild(createEl("a", {
      text: "documentation",
      href: "https://minimal.guide/features/color-schemes"
    }));
    colorDesc.appendText(" for details.");
    new import_obsidian.Setting(containerEl).setName("Light mode color scheme").setDesc("Preset color options for light mode.").addDropdown((dropdown) => dropdown.addOption("minimal-default-light", "Default").addOption("minimal-atom-light", "Atom").addOption("minimal-ayu-light", "Ayu").addOption("minimal-catppuccin-light", "Catppuccin").addOption("minimal-eink-light", "E-ink (beta)").addOption("minimal-everforest-light", "Everforest").addOption("minimal-flexoki-light", "Flexoki").addOption("minimal-gruvbox-light", "Gruvbox").addOption("minimal-macos-light", "macOS").addOption("minimal-nord-light", "Nord").addOption("minimal-rose-pine-light", "Ros\xE9 Pine").addOption("minimal-notion-light", "Sky").addOption("minimal-solarized-light", "Solarized").addOption("minimal-things-light", "Things").setValue(this.plugin.settings.lightScheme).onChange((value) => {
      this.plugin.settings.lightScheme = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.updateLightScheme();
    }));
    new import_obsidian.Setting(containerEl).setName("Light mode background contrast").setDesc("Level of contrast between sidebar and main content.").addDropdown((dropdown) => dropdown.addOption("minimal-light", "Default").addOption("minimal-light-white", "All white").addOption("minimal-light-tonal", "Low contrast").addOption("minimal-light-contrast", "High contrast").setValue(this.plugin.settings.lightStyle).onChange((value) => {
      this.plugin.settings.lightStyle = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.updateLightStyle();
    }));
    new import_obsidian.Setting(containerEl).setName("Dark mode color scheme").setDesc("Preset colors options for dark mode.").addDropdown((dropdown) => dropdown.addOption("minimal-default-dark", "Default").addOption("minimal-atom-dark", "Atom").addOption("minimal-ayu-dark", "Ayu").addOption("minimal-catppuccin-dark", "Catppuccin").addOption("minimal-dracula-dark", "Dracula").addOption("minimal-eink-dark", "E-ink (beta)").addOption("minimal-everforest-dark", "Everforest").addOption("minimal-flexoki-dark", "Flexoki").addOption("minimal-gruvbox-dark", "Gruvbox").addOption("minimal-macos-dark", "macOS").addOption("minimal-nord-dark", "Nord").addOption("minimal-rose-pine-dark", "Ros\xE9 Pine").addOption("minimal-notion-dark", "Sky").addOption("minimal-solarized-dark", "Solarized").addOption("minimal-things-dark", "Things").setValue(this.plugin.settings.darkScheme).onChange((value) => {
      this.plugin.settings.darkScheme = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.updateDarkScheme();
    }));
    new import_obsidian.Setting(containerEl).setName("Dark mode background contrast").setDesc("Level of contrast between sidebar and main content.").addDropdown((dropdown) => dropdown.addOption("minimal-dark", "Default").addOption("minimal-dark-tonal", "Low contrast").addOption("minimal-dark-black", "True black").setValue(this.plugin.settings.darkStyle).onChange((value) => {
      this.plugin.settings.darkStyle = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.updateDarkStyle();
    }));
    containerEl.createEl("br");
    const featuresSection = containerEl.createEl("div", { cls: "setting-item setting-item-heading" });
    const featuresSectionInfo = featuresSection.createEl("div", { cls: "setting-item-info" });
    featuresSectionInfo.createEl("div", { text: "Features", cls: "setting-item-name" });
    const featuresSectionDesc = featuresSectionInfo.createEl("div", { cls: "setting-item-description" });
    featuresSectionDesc.appendChild(createEl("span", {
      text: "See "
    }));
    featuresSectionDesc.appendChild(createEl("a", {
      text: "documentation",
      href: "https://minimal.guide"
    }));
    featuresSectionDesc.appendText(" for details.");
    new import_obsidian.Setting(containerEl).setName("Match system setting for light or dark mode").setDesc("Automatically switch based on your OS setting.").addToggle((toggle) => toggle.setValue(this.plugin.settings.useSystemTheme).onChange((value) => {
      this.plugin.settings.useSystemTheme = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refreshSystemTheme();
    }));
    new import_obsidian.Setting(containerEl).setName("Text labels for primary navigation").setDesc("Navigation items in the left sidebar uses text labels.").addToggle((toggle) => toggle.setValue(this.plugin.settings.labeledNav).onChange((value) => {
      this.plugin.settings.labeledNav = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Colorful window frame").setDesc("The top area of the app uses your accent color.").addToggle((toggle) => toggle.setValue(this.plugin.settings.colorfulFrame).onChange((value) => {
      this.plugin.settings.colorfulFrame = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Colorful active states").setDesc("Active file and menu items use your accent color.").addToggle((toggle) => toggle.setValue(this.plugin.settings.colorfulActiveStates).onChange((value) => {
      this.plugin.settings.colorfulActiveStates = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Colorful headings").setDesc("Headings use a different color for each size.").addToggle((toggle) => toggle.setValue(this.plugin.settings.colorfulHeadings).onChange((value) => {
      this.plugin.settings.colorfulHeadings = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Minimal status bar").setDesc("Turn off to use full-width status bar.").addToggle((toggle) => toggle.setValue(this.plugin.settings.minimalStatus).onChange((value) => {
      this.plugin.settings.minimalStatus = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Trim file names in sidebars").setDesc("Use ellipses to fit file names on a single line.").addToggle((toggle) => toggle.setValue(this.plugin.settings.trimNames).onChange((value) => {
      this.plugin.settings.trimNames = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Workspace borders").setDesc("Display divider lines between workspace elements.").addToggle((toggle) => toggle.setValue(this.plugin.settings.bordersToggle).onChange((value) => {
      this.plugin.settings.bordersToggle = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Focus mode").setDesc("Hide tab bar and status bar, hover to display. Can be toggled via hotkey.").addToggle((toggle) => toggle.setValue(this.plugin.settings.focusMode).onChange((value) => {
      this.plugin.settings.focusMode = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Underline internal links").setDesc("Show underlines on internal links.").addToggle((toggle) => toggle.setValue(this.plugin.settings.underlineInternal).onChange((value) => {
      this.plugin.settings.underlineInternal = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Underline external links").setDesc("Show underlines on external links.").addToggle((toggle) => toggle.setValue(this.plugin.settings.underlineExternal).onChange((value) => {
      this.plugin.settings.underlineExternal = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Maximize media").setDesc("Images and videos fill the width of the line.").addToggle((toggle) => toggle.setValue(this.plugin.settings.fullWidthMedia).onChange((value) => {
      this.plugin.settings.fullWidthMedia = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    containerEl.createEl("br");
    const layoutSection = containerEl.createEl("div", { cls: "setting-item setting-item-heading" });
    const layoutSectionInfo = layoutSection.createEl("div", { cls: "setting-item-info" });
    layoutSectionInfo.createEl("div", { text: "Layout", cls: "setting-item-name" });
    const layoutSectionDesc = layoutSectionInfo.createEl("div", { cls: "setting-item-description" });
    layoutSectionDesc.appendChild(createEl("span", {
      text: "These options can also be defined on a per-file basis, see "
    }));
    layoutSectionDesc.appendChild(createEl("a", {
      text: "documentation",
      href: "https://minimal.guide/features/block-width"
    }));
    layoutSectionDesc.appendText(" for details.");
    new import_obsidian.Setting(containerEl).setName("Image grids").setDesc("Turn consecutive images into columns \u2014 to make a new row, add an extra line break between images.").addToggle((toggle) => toggle.setValue(this.plugin.settings.imgGrid).onChange((value) => {
      this.plugin.settings.imgGrid = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Chart width").setDesc("Default width for chart blocks.").addDropdown((dropdown) => dropdown.addOption("chart-default-width", "Default").addOption("chart-wide", "Wide line width").addOption("chart-max", "Maximum line width").addOption("chart-100", "100% pane width").setValue(this.plugin.settings.chartWidth).onChange((value) => {
      this.plugin.settings.chartWidth = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Iframe width").setDesc("Default width for iframe blocks.").addDropdown((dropdown) => dropdown.addOption("iframe-default-width", "Default").addOption("iframe-wide", "Wide line width").addOption("iframe-max", "Maximum line width").addOption("iframe-100", "100% pane width").setValue(this.plugin.settings.iframeWidth).onChange((value) => {
      this.plugin.settings.iframeWidth = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Image width").setDesc("Default width for image blocks.").addDropdown((dropdown) => dropdown.addOption("img-default-width", "Default").addOption("img-wide", "Wide line width").addOption("img-max", "Maximum line width").addOption("img-100", "100% pane width").setValue(this.plugin.settings.imgWidth).onChange((value) => {
      this.plugin.settings.imgWidth = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Map width").setDesc("Default width for map blocks.").addDropdown((dropdown) => dropdown.addOption("map-default-width", "Default").addOption("map-wide", "Wide line width").addOption("map-max", "Maximum line width").addOption("map-100", "100% pane width").setValue(this.plugin.settings.mapWidth).onChange((value) => {
      this.plugin.settings.mapWidth = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Table width").setDesc("Default width for table and Dataview blocks.").addDropdown((dropdown) => dropdown.addOption("table-default-width", "Default").addOption("table-wide", "Wide line width").addOption("table-max", "Maximum line width").addOption("table-100", "100% pane width").setValue(this.plugin.settings.tableWidth).onChange((value) => {
      this.plugin.settings.tableWidth = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    containerEl.createEl("br");
    containerEl.createEl("div", { text: "Typography", cls: "setting-item setting-item-heading" });
    new import_obsidian.Setting(containerEl).setName("Text font size").setDesc("Used for the main text (default 16).").addText((text) => text.setPlaceholder("16").setValue((this.plugin.settings.textNormal || "") + "").onChange((value) => {
      this.plugin.settings.textNormal = parseFloat(value);
      this.plugin.saveData(this.plugin.settings);
      this.plugin.setFontSize();
    }));
    new import_obsidian.Setting(containerEl).setName("Small font size").setDesc("Used for text in the sidebars and tabs (default 13).").addText((text) => text.setPlaceholder("13").setValue((this.plugin.settings.textSmall || "") + "").onChange((value) => {
      this.plugin.settings.textSmall = parseFloat(value);
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Line height").setDesc("Line height of text (default 1.5).").addText((text) => text.setPlaceholder("1.5").setValue((this.plugin.settings.lineHeight || "") + "").onChange((value) => {
      this.plugin.settings.lineHeight = parseFloat(value);
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Normal line width").setDesc("Number of characters per line (default 40).").addText((text) => text.setPlaceholder("40").setValue((this.plugin.settings.lineWidth || "") + "").onChange((value) => {
      this.plugin.settings.lineWidth = parseInt(value.trim());
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Wide line width").setDesc("Number of characters per line for wide elements (default 50).").addText((text) => text.setPlaceholder("50").setValue((this.plugin.settings.lineWidthWide || "") + "").onChange((value) => {
      this.plugin.settings.lineWidthWide = parseInt(value.trim());
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Maximum line width %").setDesc("Percentage of space inside a pane that a line can fill (default 88).").addText((text) => text.setPlaceholder("88").setValue((this.plugin.settings.maxWidth || "") + "").onChange((value) => {
      this.plugin.settings.maxWidth = parseInt(value.trim());
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
    new import_obsidian.Setting(containerEl).setName("Editor font").setDesc("Overrides the text font defined in Obsidian Appearance settings when in edit mode.").addText((text) => text.setPlaceholder("").setValue((this.plugin.settings.editorFont || "") + "").onChange((value) => {
      this.plugin.settings.editorFont = value;
      this.plugin.saveData(this.plugin.settings);
      this.plugin.refresh();
    }));
  }
};
//# sourceMappingURL=data:application/json;base64,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
