/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository
*/

'use strict';

var obsidian = require('obsidian');
var path = require('path');
var fs$2 = require('fs');
var url = require('url');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var path__default = /*#__PURE__*/_interopDefaultLegacy(path);
var fs__default = /*#__PURE__*/_interopDefaultLegacy(fs$2);

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
				var args = [null];
				args.push.apply(args, arguments);
				var Ctor = Function.bind.apply(f, args);
				return new Ctor();
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var lib$3 = {};

var FsPromise = {};

/**
 * Module convert fs functions to promise based functions
 */
Object.defineProperty(FsPromise, "__esModule", { value: true });
FsPromise.readFile = FsPromise.writeFileSync = FsPromise.writeFile = FsPromise.read = FsPromise.open = FsPromise.close = FsPromise.stat = FsPromise.createReadStream = FsPromise.pathExists = void 0;
const fs$1 = fs__default["default"];
FsPromise.pathExists = fs$1.existsSync;
FsPromise.createReadStream = fs$1.createReadStream;
async function stat(path) {
    return new Promise((resolve, reject) => {
        fs$1.stat(path, (err, stats) => {
            if (err)
                reject(err);
            else
                resolve(stats);
        });
    });
}
FsPromise.stat = stat;
async function close(fd) {
    return new Promise((resolve, reject) => {
        fs$1.close(fd, err => {
            if (err)
                reject(err);
            else
                resolve();
        });
    });
}
FsPromise.close = close;
async function open(path, mode) {
    return new Promise((resolve, reject) => {
        fs$1.open(path, mode, (err, fd) => {
            if (err)
                reject(err);
            else
                resolve(fd);
        });
    });
}
FsPromise.open = open;
async function read(fd, buffer, offset, length, position) {
    return new Promise((resolve, reject) => {
        fs$1.read(fd, buffer, offset, length, position, (err, bytesRead, _buffer) => {
            if (err)
                reject(err);
            else
                resolve({ bytesRead, buffer: _buffer });
        });
    });
}
FsPromise.read = read;
async function writeFile(path, data) {
    return new Promise((resolve, reject) => {
        fs$1.writeFile(path, data, err => {
            if (err)
                reject(err);
            else
                resolve();
        });
    });
}
FsPromise.writeFile = writeFile;
function writeFileSync(path, data) {
    fs$1.writeFileSync(path, data);
}
FsPromise.writeFileSync = writeFileSync;
async function readFile(path) {
    return new Promise((resolve, reject) => {
        fs$1.readFile(path, (err, buffer) => {
            if (err)
                reject(err);
            else
                resolve(buffer);
        });
    });
}
FsPromise.readFile = readFile;

var core$3 = {};

var ReadStreamTokenizer$1 = {};

var AbstractTokenizer$1 = {};

var lib$2 = {};

var EndOfFileStream = {};

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.EndOfStreamError = exports.defaultMessages = void 0;
	exports.defaultMessages = 'End-Of-Stream';
	/**
	 * Thrown on read operation of the end of file or stream has been reached
	 */
	class EndOfStreamError extends Error {
	    constructor() {
	        super(exports.defaultMessages);
	    }
	}
	exports.EndOfStreamError = EndOfStreamError; 
} (EndOfFileStream));

var StreamReader = {};

var Deferred$1 = {};

Object.defineProperty(Deferred$1, "__esModule", { value: true });
Deferred$1.Deferred = void 0;
class Deferred {
    constructor() {
        this.resolve = () => null;
        this.reject = () => null;
        this.promise = new Promise((resolve, reject) => {
            this.reject = reject;
            this.resolve = resolve;
        });
    }
}
Deferred$1.Deferred = Deferred;

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.StreamReader = exports.EndOfStreamError = void 0;
	const EndOfFileStream_1 = EndOfFileStream;
	const Deferred_1 = Deferred$1;
	var EndOfFileStream_2 = EndOfFileStream;
	Object.defineProperty(exports, "EndOfStreamError", { enumerable: true, get: function () { return EndOfFileStream_2.EndOfStreamError; } });
	const maxStreamReadSize = 1 * 1024 * 1024; // Maximum request length on read-stream operation
	class StreamReader {
	    constructor(s) {
	        this.s = s;
	        /**
	         * Deferred used for postponed read request (as not data is yet available to read)
	         */
	        this.deferred = null;
	        this.endOfStream = false;
	        /**
	         * Store peeked data
	         * @type {Array}
	         */
	        this.peekQueue = [];
	        if (!s.read || !s.once) {
	            throw new Error('Expected an instance of stream.Readable');
	        }
	        this.s.once('end', () => this.reject(new EndOfFileStream_1.EndOfStreamError()));
	        this.s.once('error', err => this.reject(err));
	        this.s.once('close', () => this.reject(new Error('Stream closed')));
	    }
	    /**
	     * Read ahead (peek) from stream. Subsequent read or peeks will return the same data
	     * @param uint8Array - Uint8Array (or Buffer) to store data read from stream in
	     * @param offset - Offset target
	     * @param length - Number of bytes to read
	     * @returns Number of bytes peeked
	     */
	    async peek(uint8Array, offset, length) {
	        const bytesRead = await this.read(uint8Array, offset, length);
	        this.peekQueue.push(uint8Array.subarray(offset, offset + bytesRead)); // Put read data back to peek buffer
	        return bytesRead;
	    }
	    /**
	     * Read chunk from stream
	     * @param buffer - Target Uint8Array (or Buffer) to store data read from stream in
	     * @param offset - Offset target
	     * @param length - Number of bytes to read
	     * @returns Number of bytes read
	     */
	    async read(buffer, offset, length) {
	        if (length === 0) {
	            return 0;
	        }
	        if (this.peekQueue.length === 0 && this.endOfStream) {
	            throw new EndOfFileStream_1.EndOfStreamError();
	        }
	        let remaining = length;
	        let bytesRead = 0;
	        // consume peeked data first
	        while (this.peekQueue.length > 0 && remaining > 0) {
	            const peekData = this.peekQueue.pop(); // Front of queue
	            if (!peekData)
	                throw new Error('peekData should be defined');
	            const lenCopy = Math.min(peekData.length, remaining);
	            buffer.set(peekData.subarray(0, lenCopy), offset + bytesRead);
	            bytesRead += lenCopy;
	            remaining -= lenCopy;
	            if (lenCopy < peekData.length) {
	                // remainder back to queue
	                this.peekQueue.push(peekData.subarray(lenCopy));
	            }
	        }
	        // continue reading from stream if required
	        while (remaining > 0 && !this.endOfStream) {
	            const reqLen = Math.min(remaining, maxStreamReadSize);
	            const chunkLen = await this.readFromStream(buffer, offset + bytesRead, reqLen);
	            bytesRead += chunkLen;
	            if (chunkLen < reqLen)
	                break;
	            remaining -= chunkLen;
	        }
	        return bytesRead;
	    }
	    /**
	     * Read chunk from stream
	     * @param buffer Target Uint8Array (or Buffer) to store data read from stream in
	     * @param offset Offset target
	     * @param length Number of bytes to read
	     * @returns Number of bytes read
	     */
	    async readFromStream(buffer, offset, length) {
	        const readBuffer = this.s.read(length);
	        if (readBuffer) {
	            buffer.set(readBuffer, offset);
	            return readBuffer.length;
	        }
	        else {
	            const request = {
	                buffer,
	                offset,
	                length,
	                deferred: new Deferred_1.Deferred()
	            };
	            this.deferred = request.deferred;
	            this.s.once('readable', () => {
	                this.readDeferred(request);
	            });
	            return request.deferred.promise;
	        }
	    }
	    /**
	     * Process deferred read request
	     * @param request Deferred read request
	     */
	    readDeferred(request) {
	        const readBuffer = this.s.read(request.length);
	        if (readBuffer) {
	            request.buffer.set(readBuffer, request.offset);
	            request.deferred.resolve(readBuffer.length);
	            this.deferred = null;
	        }
	        else {
	            this.s.once('readable', () => {
	                this.readDeferred(request);
	            });
	        }
	    }
	    reject(err) {
	        this.endOfStream = true;
	        if (this.deferred) {
	            this.deferred.reject(err);
	            this.deferred = null;
	        }
	    }
	}
	exports.StreamReader = StreamReader; 
} (StreamReader));

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.StreamReader = exports.EndOfStreamError = void 0;
	var EndOfFileStream_1 = EndOfFileStream;
	Object.defineProperty(exports, "EndOfStreamError", { enumerable: true, get: function () { return EndOfFileStream_1.EndOfStreamError; } });
	var StreamReader_1 = StreamReader;
	Object.defineProperty(exports, "StreamReader", { enumerable: true, get: function () { return StreamReader_1.StreamReader; } }); 
} (lib$2));

Object.defineProperty(AbstractTokenizer$1, "__esModule", { value: true });
AbstractTokenizer$1.AbstractTokenizer = void 0;
const peek_readable_1$3 = lib$2;
/**
 * Core tokenizer
 */
class AbstractTokenizer {
    constructor(fileInfo) {
        /**
         * Tokenizer-stream position
         */
        this.position = 0;
        this.numBuffer = new Uint8Array(8);
        this.fileInfo = fileInfo ? fileInfo : {};
    }
    /**
     * Read a token from the tokenizer-stream
     * @param token - The token to read
     * @param position - If provided, the desired position in the tokenizer-stream
     * @returns Promise with token data
     */
    async readToken(token, position = this.position) {
        const uint8Array = Buffer.alloc(token.len);
        const len = await this.readBuffer(uint8Array, { position });
        if (len < token.len)
            throw new peek_readable_1$3.EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Peek a token from the tokenizer-stream.
     * @param token - Token to peek from the tokenizer-stream.
     * @param position - Offset where to begin reading within the file. If position is null, data will be read from the current file position.
     * @returns Promise with token data
     */
    async peekToken(token, position = this.position) {
        const uint8Array = Buffer.alloc(token.len);
        const len = await this.peekBuffer(uint8Array, { position });
        if (len < token.len)
            throw new peek_readable_1$3.EndOfStreamError();
        return token.get(uint8Array, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async readNumber(token) {
        const len = await this.readBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new peek_readable_1$3.EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Read a numeric token from the stream
     * @param token - Numeric token
     * @returns Promise with number
     */
    async peekNumber(token) {
        const len = await this.peekBuffer(this.numBuffer, { length: token.len });
        if (len < token.len)
            throw new peek_readable_1$3.EndOfStreamError();
        return token.get(this.numBuffer, 0);
    }
    /**
     * Ignore number of bytes, advances the pointer in under tokenizer-stream.
     * @param length - Number of bytes to ignore
     * @return resolves the number of bytes ignored, equals length if this available, otherwise the number of bytes available
     */
    async ignore(length) {
        if (this.fileInfo.size !== undefined) {
            const bytesLeft = this.fileInfo.size - this.position;
            if (length > bytesLeft) {
                this.position += bytesLeft;
                return bytesLeft;
            }
        }
        this.position += length;
        return length;
    }
    async close() {
        // empty
    }
    normalizeOptions(uint8Array, options) {
        if (options && options.position !== undefined && options.position < this.position) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        if (options) {
            return {
                mayBeLess: options.mayBeLess === true,
                offset: options.offset ? options.offset : 0,
                length: options.length ? options.length : (uint8Array.length - (options.offset ? options.offset : 0)),
                position: options.position ? options.position : this.position
            };
        }
        return {
            mayBeLess: false,
            offset: 0,
            length: uint8Array.length,
            position: this.position
        };
    }
}
AbstractTokenizer$1.AbstractTokenizer = AbstractTokenizer;

Object.defineProperty(ReadStreamTokenizer$1, "__esModule", { value: true });
ReadStreamTokenizer$1.ReadStreamTokenizer = void 0;
const AbstractTokenizer_1$2 = AbstractTokenizer$1;
const peek_readable_1$2 = lib$2;
const maxBufferSize = 256000;
class ReadStreamTokenizer extends AbstractTokenizer_1$2.AbstractTokenizer {
    constructor(stream, fileInfo) {
        super(fileInfo);
        this.streamReader = new peek_readable_1$2.StreamReader(stream);
    }
    /**
     * Get file information, an HTTP-client may implement this doing a HEAD request
     * @return Promise with file information
     */
    async getFileInfo() {
        return this.fileInfo;
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Target Uint8Array to fill with data read from the tokenizer-stream
     * @param options - Read behaviour options
     * @returns Promise with number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const skipBytes = normOptions.position - this.position;
        if (skipBytes > 0) {
            await this.ignore(skipBytes);
            return this.readBuffer(uint8Array, options);
        }
        else if (skipBytes < 0) {
            throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
        }
        if (normOptions.length === 0) {
            return 0;
        }
        const bytesRead = await this.streamReader.read(uint8Array, normOptions.offset, normOptions.length);
        this.position += bytesRead;
        if ((!options || !options.mayBeLess) && bytesRead < normOptions.length) {
            throw new peek_readable_1$2.EndOfStreamError();
        }
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise with number of bytes peeked
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        let bytesRead = 0;
        if (normOptions.position) {
            const skipBytes = normOptions.position - this.position;
            if (skipBytes > 0) {
                const skipBuffer = new Uint8Array(normOptions.length + skipBytes);
                bytesRead = await this.peekBuffer(skipBuffer, { mayBeLess: normOptions.mayBeLess });
                uint8Array.set(skipBuffer.subarray(skipBytes), normOptions.offset);
                return bytesRead - skipBytes;
            }
            else if (skipBytes < 0) {
                throw new Error('Cannot peek from a negative offset in a stream');
            }
        }
        if (normOptions.length > 0) {
            try {
                bytesRead = await this.streamReader.peek(uint8Array, normOptions.offset, normOptions.length);
            }
            catch (err) {
                if (options && options.mayBeLess && err instanceof peek_readable_1$2.EndOfStreamError) {
                    return 0;
                }
                throw err;
            }
            if ((!normOptions.mayBeLess) && bytesRead < normOptions.length) {
                throw new peek_readable_1$2.EndOfStreamError();
            }
        }
        return bytesRead;
    }
    async ignore(length) {
        // debug(`ignore ${this.position}...${this.position + length - 1}`);
        const bufSize = Math.min(maxBufferSize, length);
        const buf = new Uint8Array(bufSize);
        let totBytesRead = 0;
        while (totBytesRead < length) {
            const remaining = length - totBytesRead;
            const bytesRead = await this.readBuffer(buf, { length: Math.min(bufSize, remaining) });
            if (bytesRead < 0) {
                return bytesRead;
            }
            totBytesRead += bytesRead;
        }
        return totBytesRead;
    }
}
ReadStreamTokenizer$1.ReadStreamTokenizer = ReadStreamTokenizer;

var BufferTokenizer$1 = {};

Object.defineProperty(BufferTokenizer$1, "__esModule", { value: true });
BufferTokenizer$1.BufferTokenizer = void 0;
const peek_readable_1$1 = lib$2;
const AbstractTokenizer_1$1 = AbstractTokenizer$1;
class BufferTokenizer extends AbstractTokenizer_1$1.AbstractTokenizer {
    /**
     * Construct BufferTokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param fileInfo - Pass additional file information to the tokenizer
     */
    constructor(uint8Array, fileInfo) {
        super(fileInfo);
        this.uint8Array = uint8Array;
        this.fileInfo.size = this.fileInfo.size ? this.fileInfo.size : uint8Array.length;
    }
    /**
     * Read buffer from tokenizer
     * @param uint8Array - Uint8Array to tokenize
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async readBuffer(uint8Array, options) {
        if (options && options.position) {
            if (options.position < this.position) {
                throw new Error('`options.position` must be equal or greater than `tokenizer.position`');
            }
            this.position = options.position;
        }
        const bytesRead = await this.peekBuffer(uint8Array, options);
        this.position += bytesRead;
        return bytesRead;
    }
    /**
     * Peek (read ahead) buffer from tokenizer
     * @param uint8Array
     * @param options - Read behaviour options
     * @returns {Promise<number>}
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const bytes2read = Math.min(this.uint8Array.length - normOptions.position, normOptions.length);
        if ((!normOptions.mayBeLess) && bytes2read < normOptions.length) {
            throw new peek_readable_1$1.EndOfStreamError();
        }
        else {
            uint8Array.set(this.uint8Array.subarray(normOptions.position, normOptions.position + bytes2read), normOptions.offset);
            return bytes2read;
        }
    }
    async close() {
        // empty
    }
}
BufferTokenizer$1.BufferTokenizer = BufferTokenizer;

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.fromBuffer = exports.fromStream = exports.EndOfStreamError = void 0;
	const ReadStreamTokenizer_1 = ReadStreamTokenizer$1;
	const BufferTokenizer_1 = BufferTokenizer$1;
	var peek_readable_1 = lib$2;
	Object.defineProperty(exports, "EndOfStreamError", { enumerable: true, get: function () { return peek_readable_1.EndOfStreamError; } });
	/**
	 * Construct ReadStreamTokenizer from given Stream.
	 * Will set fileSize, if provided given Stream has set the .path property/
	 * @param stream - Read from Node.js Stream.Readable
	 * @param fileInfo - Pass the file information, like size and MIME-type of the corresponding stream.
	 * @returns ReadStreamTokenizer
	 */
	function fromStream(stream, fileInfo) {
	    fileInfo = fileInfo ? fileInfo : {};
	    return new ReadStreamTokenizer_1.ReadStreamTokenizer(stream, fileInfo);
	}
	exports.fromStream = fromStream;
	/**
	 * Construct ReadStreamTokenizer from given Buffer.
	 * @param uint8Array - Uint8Array to tokenize
	 * @param fileInfo - Pass additional file information to the tokenizer
	 * @returns BufferTokenizer
	 */
	function fromBuffer(uint8Array, fileInfo) {
	    return new BufferTokenizer_1.BufferTokenizer(uint8Array, fileInfo);
	}
	exports.fromBuffer = fromBuffer; 
} (core$3));

var FileTokenizer$1 = {};

Object.defineProperty(FileTokenizer$1, "__esModule", { value: true });
FileTokenizer$1.fromFile = FileTokenizer$1.FileTokenizer = void 0;
const AbstractTokenizer_1 = AbstractTokenizer$1;
const peek_readable_1 = lib$2;
const fs = FsPromise;
class FileTokenizer extends AbstractTokenizer_1.AbstractTokenizer {
    constructor(fd, fileInfo) {
        super(fileInfo);
        this.fd = fd;
    }
    /**
     * Read buffer from file
     * @param uint8Array - Uint8Array to write result to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async readBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        this.position = normOptions.position;
        const res = await fs.read(this.fd, uint8Array, normOptions.offset, normOptions.length, normOptions.position);
        this.position += res.bytesRead;
        if (res.bytesRead < normOptions.length && (!options || !options.mayBeLess)) {
            throw new peek_readable_1.EndOfStreamError();
        }
        return res.bytesRead;
    }
    /**
     * Peek buffer from file
     * @param uint8Array - Uint8Array (or Buffer) to write data to
     * @param options - Read behaviour options
     * @returns Promise number of bytes read
     */
    async peekBuffer(uint8Array, options) {
        const normOptions = this.normalizeOptions(uint8Array, options);
        const res = await fs.read(this.fd, uint8Array, normOptions.offset, normOptions.length, normOptions.position);
        if ((!normOptions.mayBeLess) && res.bytesRead < normOptions.length) {
            throw new peek_readable_1.EndOfStreamError();
        }
        return res.bytesRead;
    }
    async close() {
        return fs.close(this.fd);
    }
}
FileTokenizer$1.FileTokenizer = FileTokenizer;
async function fromFile$1(sourceFilePath) {
    const stat = await fs.stat(sourceFilePath);
    if (!stat.isFile) {
        throw new Error(`File not a file: ${sourceFilePath}`);
    }
    const fd = await fs.open(sourceFilePath, 'r');
    return new FileTokenizer(fd, { path: sourceFilePath, size: stat.size });
}
FileTokenizer$1.fromFile = fromFile$1;

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.fromStream = exports.fromBuffer = exports.EndOfStreamError = exports.fromFile = void 0;
	const fs = FsPromise;
	const core = core$3;
	var FileTokenizer_1 = FileTokenizer$1;
	Object.defineProperty(exports, "fromFile", { enumerable: true, get: function () { return FileTokenizer_1.fromFile; } });
	var core_1 = core$3;
	Object.defineProperty(exports, "EndOfStreamError", { enumerable: true, get: function () { return core_1.EndOfStreamError; } });
	Object.defineProperty(exports, "fromBuffer", { enumerable: true, get: function () { return core_1.fromBuffer; } });
	/**
	 * Construct ReadStreamTokenizer from given Stream.
	 * Will set fileSize, if provided given Stream has set the .path property.
	 * @param stream - Node.js Stream.Readable
	 * @param fileInfo - Pass additional file information to the tokenizer
	 * @returns Tokenizer
	 */
	async function fromStream(stream, fileInfo) {
	    fileInfo = fileInfo ? fileInfo : {};
	    if (stream.path) {
	        const stat = await fs.stat(stream.path);
	        fileInfo.path = stream.path;
	        fileInfo.size = stat.size;
	    }
	    return core.fromStream(stream, fileInfo);
	}
	exports.fromStream = fromStream; 
} (lib$3));

var lib$1 = {};

var ieee754 = {};

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */

ieee754.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m;
  var eLen = (nBytes * 8) - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i = isLE ? (nBytes - 1) : 0;
  var d = isLE ? -1 : 1;
  var s = buffer[offset + i];

  i += d;

  e = s & ((1 << (-nBits)) - 1);
  s >>= (-nBits);
  nBits += eLen;
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1);
  e >>= (-nBits);
  nBits += mLen;
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen);
    e = e - eBias;
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
};

ieee754.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c;
  var eLen = (nBytes * 8) - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
  var i = isLE ? 0 : (nBytes - 1);
  var d = isLE ? 1 : -1;
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

  value = Math.abs(value);

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }

    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m;
  eLen += mLen;
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128;
};

(function (exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.AnsiStringType = exports.StringType = exports.BufferType = exports.Uint8ArrayType = exports.IgnoreType = exports.Float80_LE = exports.Float80_BE = exports.Float64_LE = exports.Float64_BE = exports.Float32_LE = exports.Float32_BE = exports.Float16_LE = exports.Float16_BE = exports.INT64_BE = exports.UINT64_BE = exports.INT64_LE = exports.UINT64_LE = exports.INT32_LE = exports.INT32_BE = exports.INT24_BE = exports.INT24_LE = exports.INT16_LE = exports.INT16_BE = exports.INT8 = exports.UINT32_BE = exports.UINT32_LE = exports.UINT24_BE = exports.UINT24_LE = exports.UINT16_BE = exports.UINT16_LE = exports.UINT8 = void 0;
	const ieee754$1 = ieee754;
	// Primitive types
	function dv(array) {
	    return new DataView(array.buffer, array.byteOffset);
	}
	/**
	 * 8-bit unsigned integer
	 */
	exports.UINT8 = {
	    len: 1,
	    get(array, offset) {
	        return dv(array).getUint8(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setUint8(offset, value);
	        return offset + 1;
	    }
	};
	/**
	 * 16-bit unsigned integer, Little Endian byte order
	 */
	exports.UINT16_LE = {
	    len: 2,
	    get(array, offset) {
	        return dv(array).getUint16(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setUint16(offset, value, true);
	        return offset + 2;
	    }
	};
	/**
	 * 16-bit unsigned integer, Big Endian byte order
	 */
	exports.UINT16_BE = {
	    len: 2,
	    get(array, offset) {
	        return dv(array).getUint16(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setUint16(offset, value);
	        return offset + 2;
	    }
	};
	/**
	 * 24-bit unsigned integer, Little Endian byte order
	 */
	exports.UINT24_LE = {
	    len: 3,
	    get(array, offset) {
	        const dataView = dv(array);
	        return dataView.getUint8(offset) + (dataView.getUint16(offset + 1, true) << 8);
	    },
	    put(array, offset, value) {
	        const dataView = dv(array);
	        dataView.setUint8(offset, value & 0xff);
	        dataView.setUint16(offset + 1, value >> 8, true);
	        return offset + 3;
	    }
	};
	/**
	 * 24-bit unsigned integer, Big Endian byte order
	 */
	exports.UINT24_BE = {
	    len: 3,
	    get(array, offset) {
	        const dataView = dv(array);
	        return (dataView.getUint16(offset) << 8) + dataView.getUint8(offset + 2);
	    },
	    put(array, offset, value) {
	        const dataView = dv(array);
	        dataView.setUint16(offset, value >> 8);
	        dataView.setUint8(offset + 2, value & 0xff);
	        return offset + 3;
	    }
	};
	/**
	 * 32-bit unsigned integer, Little Endian byte order
	 */
	exports.UINT32_LE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getUint32(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setUint32(offset, value, true);
	        return offset + 4;
	    }
	};
	/**
	 * 32-bit unsigned integer, Big Endian byte order
	 */
	exports.UINT32_BE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getUint32(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setUint32(offset, value);
	        return offset + 4;
	    }
	};
	/**
	 * 8-bit signed integer
	 */
	exports.INT8 = {
	    len: 1,
	    get(array, offset) {
	        return dv(array).getInt8(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setInt8(offset, value);
	        return offset + 1;
	    }
	};
	/**
	 * 16-bit signed integer, Big Endian byte order
	 */
	exports.INT16_BE = {
	    len: 2,
	    get(array, offset) {
	        return dv(array).getInt16(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setInt16(offset, value);
	        return offset + 2;
	    }
	};
	/**
	 * 16-bit signed integer, Little Endian byte order
	 */
	exports.INT16_LE = {
	    len: 2,
	    get(array, offset) {
	        return dv(array).getInt16(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setInt16(offset, value, true);
	        return offset + 2;
	    }
	};
	/**
	 * 24-bit signed integer, Little Endian byte order
	 */
	exports.INT24_LE = {
	    len: 3,
	    get(array, offset) {
	        const unsigned = exports.UINT24_LE.get(array, offset);
	        return unsigned > 0x7fffff ? unsigned - 0x1000000 : unsigned;
	    },
	    put(array, offset, value) {
	        const dataView = dv(array);
	        dataView.setUint8(offset, value & 0xff);
	        dataView.setUint16(offset + 1, value >> 8, true);
	        return offset + 3;
	    }
	};
	/**
	 * 24-bit signed integer, Big Endian byte order
	 */
	exports.INT24_BE = {
	    len: 3,
	    get(array, offset) {
	        const unsigned = exports.UINT24_BE.get(array, offset);
	        return unsigned > 0x7fffff ? unsigned - 0x1000000 : unsigned;
	    },
	    put(array, offset, value) {
	        const dataView = dv(array);
	        dataView.setUint16(offset, value >> 8);
	        dataView.setUint8(offset + 2, value & 0xff);
	        return offset + 3;
	    }
	};
	/**
	 * 32-bit signed integer, Big Endian byte order
	 */
	exports.INT32_BE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getInt32(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setInt32(offset, value);
	        return offset + 4;
	    }
	};
	/**
	 * 32-bit signed integer, Big Endian byte order
	 */
	exports.INT32_LE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getInt32(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setInt32(offset, value, true);
	        return offset + 4;
	    }
	};
	/**
	 * 64-bit unsigned integer, Little Endian byte order
	 */
	exports.UINT64_LE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getBigUint64(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setBigUint64(offset, value, true);
	        return offset + 8;
	    }
	};
	/**
	 * 64-bit signed integer, Little Endian byte order
	 */
	exports.INT64_LE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getBigInt64(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setBigInt64(offset, value, true);
	        return offset + 8;
	    }
	};
	/**
	 * 64-bit unsigned integer, Big Endian byte order
	 */
	exports.UINT64_BE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getBigUint64(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setBigUint64(offset, value);
	        return offset + 8;
	    }
	};
	/**
	 * 64-bit signed integer, Big Endian byte order
	 */
	exports.INT64_BE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getBigInt64(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setBigInt64(offset, value);
	        return offset + 8;
	    }
	};
	/**
	 * IEEE 754 16-bit (half precision) float, big endian
	 */
	exports.Float16_BE = {
	    len: 2,
	    get(dataView, offset) {
	        return ieee754$1.read(dataView, offset, false, 10, this.len);
	    },
	    put(dataView, offset, value) {
	        ieee754$1.write(dataView, value, offset, false, 10, this.len);
	        return offset + this.len;
	    }
	};
	/**
	 * IEEE 754 16-bit (half precision) float, little endian
	 */
	exports.Float16_LE = {
	    len: 2,
	    get(array, offset) {
	        return ieee754$1.read(array, offset, true, 10, this.len);
	    },
	    put(array, offset, value) {
	        ieee754$1.write(array, value, offset, true, 10, this.len);
	        return offset + this.len;
	    }
	};
	/**
	 * IEEE 754 32-bit (single precision) float, big endian
	 */
	exports.Float32_BE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getFloat32(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setFloat32(offset, value);
	        return offset + 4;
	    }
	};
	/**
	 * IEEE 754 32-bit (single precision) float, little endian
	 */
	exports.Float32_LE = {
	    len: 4,
	    get(array, offset) {
	        return dv(array).getFloat32(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setFloat32(offset, value, true);
	        return offset + 4;
	    }
	};
	/**
	 * IEEE 754 64-bit (double precision) float, big endian
	 */
	exports.Float64_BE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getFloat64(offset);
	    },
	    put(array, offset, value) {
	        dv(array).setFloat64(offset, value);
	        return offset + 8;
	    }
	};
	/**
	 * IEEE 754 64-bit (double precision) float, little endian
	 */
	exports.Float64_LE = {
	    len: 8,
	    get(array, offset) {
	        return dv(array).getFloat64(offset, true);
	    },
	    put(array, offset, value) {
	        dv(array).setFloat64(offset, value, true);
	        return offset + 8;
	    }
	};
	/**
	 * IEEE 754 80-bit (extended precision) float, big endian
	 */
	exports.Float80_BE = {
	    len: 10,
	    get(array, offset) {
	        return ieee754$1.read(array, offset, false, 63, this.len);
	    },
	    put(array, offset, value) {
	        ieee754$1.write(array, value, offset, false, 63, this.len);
	        return offset + this.len;
	    }
	};
	/**
	 * IEEE 754 80-bit (extended precision) float, little endian
	 */
	exports.Float80_LE = {
	    len: 10,
	    get(array, offset) {
	        return ieee754$1.read(array, offset, true, 63, this.len);
	    },
	    put(array, offset, value) {
	        ieee754$1.write(array, value, offset, true, 63, this.len);
	        return offset + this.len;
	    }
	};
	/**
	 * Ignore a given number of bytes
	 */
	class IgnoreType {
	    /**
	     * @param len number of bytes to ignore
	     */
	    constructor(len) {
	        this.len = len;
	    }
	    // ToDo: don't read, but skip data
	    get(array, off) {
	    }
	}
	exports.IgnoreType = IgnoreType;
	class Uint8ArrayType {
	    constructor(len) {
	        this.len = len;
	    }
	    get(array, offset) {
	        return array.subarray(offset, offset + this.len);
	    }
	}
	exports.Uint8ArrayType = Uint8ArrayType;
	class BufferType {
	    constructor(len) {
	        this.len = len;
	    }
	    get(uint8Array, off) {
	        return Buffer.from(uint8Array.subarray(off, off + this.len));
	    }
	}
	exports.BufferType = BufferType;
	/**
	 * Consume a fixed number of bytes from the stream and return a string with a specified encoding.
	 */
	class StringType {
	    constructor(len, encoding) {
	        this.len = len;
	        this.encoding = encoding;
	    }
	    get(uint8Array, offset) {
	        return Buffer.from(uint8Array).toString(this.encoding, offset, offset + this.len);
	    }
	}
	exports.StringType = StringType;
	/**
	 * ANSI Latin 1 String
	 * Using windows-1252 / ISO 8859-1 decoding
	 */
	class AnsiStringType {
	    constructor(len) {
	        this.len = len;
	    }
	    static decode(buffer, offset, until) {
	        let str = '';
	        for (let i = offset; i < until; ++i) {
	            str += AnsiStringType.codePointToString(AnsiStringType.singleByteDecoder(buffer[i]));
	        }
	        return str;
	    }
	    static inRange(a, min, max) {
	        return min <= a && a <= max;
	    }
	    static codePointToString(cp) {
	        if (cp <= 0xFFFF) {
	            return String.fromCharCode(cp);
	        }
	        else {
	            cp -= 0x10000;
	            return String.fromCharCode((cp >> 10) + 0xD800, (cp & 0x3FF) + 0xDC00);
	        }
	    }
	    static singleByteDecoder(bite) {
	        if (AnsiStringType.inRange(bite, 0x00, 0x7F)) {
	            return bite;
	        }
	        const codePoint = AnsiStringType.windows1252[bite - 0x80];
	        if (codePoint === null) {
	            throw Error('invaliding encoding');
	        }
	        return codePoint;
	    }
	    get(buffer, offset = 0) {
	        return AnsiStringType.decode(buffer, offset, offset + this.len);
	    }
	}
	exports.AnsiStringType = AnsiStringType;
	AnsiStringType.windows1252 = [8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352,
	    8249, 338, 141, 381, 143, 144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732,
	    8482, 353, 8250, 339, 157, 382, 376, 160, 161, 162, 163, 164, 165, 166, 167, 168,
	    169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184,
	    185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
	    201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
	    217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232,
	    233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247,
	    248, 249, 250, 251, 252, 253, 254, 255]; 
} (lib$1));

var util$4 = {};

util$4.stringToBytes = string => [...string].map(character => character.charCodeAt(0));

/**
Checks whether the TAR checksum is valid.

@param {Buffer} buffer - The TAR header `[offset ... offset + 512]`.
@param {number} offset - TAR header offset.
@returns {boolean} `true` if the TAR checksum is valid, otherwise `false`.
*/
util$4.tarHeaderChecksumMatches = (buffer, offset = 0) => {
	const readSum = parseInt(buffer.toString('utf8', 148, 154).replace(/\0.*$/, '').trim(), 8); // Read sum in header
	if (isNaN(readSum)) {
		return false;
	}

	let sum = 8 * 0x20; // Initialize signed bit sum

	for (let i = offset; i < offset + 148; i++) {
		sum += buffer[i];
	}

	for (let i = offset + 156; i < offset + 512; i++) {
		sum += buffer[i];
	}

	return readSum === sum;
};

/**
ID3 UINT32 sync-safe tokenizer token.
28 bits (representing up to 256MB) integer, the msb is 0 to avoid "false syncsignals".
*/
util$4.uint32SyncSafeToken = {
	get: (buffer, offset) => {
		return (buffer[offset + 3] & 0x7F) | ((buffer[offset + 2]) << 7) | ((buffer[offset + 1]) << 14) | ((buffer[offset]) << 21);
	},
	len: 4
};

var supported$1 = {
	extensions: [
		'jpg',
		'png',
		'apng',
		'gif',
		'webp',
		'flif',
		'xcf',
		'cr2',
		'cr3',
		'orf',
		'arw',
		'dng',
		'nef',
		'rw2',
		'raf',
		'tif',
		'bmp',
		'icns',
		'jxr',
		'psd',
		'indd',
		'zip',
		'tar',
		'rar',
		'gz',
		'bz2',
		'7z',
		'dmg',
		'mp4',
		'mid',
		'mkv',
		'webm',
		'mov',
		'avi',
		'mpg',
		'mp2',
		'mp3',
		'm4a',
		'oga',
		'ogg',
		'ogv',
		'opus',
		'flac',
		'wav',
		'spx',
		'amr',
		'pdf',
		'epub',
		'exe',
		'swf',
		'rtf',
		'wasm',
		'woff',
		'woff2',
		'eot',
		'ttf',
		'otf',
		'ico',
		'flv',
		'ps',
		'xz',
		'sqlite',
		'nes',
		'crx',
		'xpi',
		'cab',
		'deb',
		'ar',
		'rpm',
		'Z',
		'lz',
		'cfb',
		'mxf',
		'mts',
		'blend',
		'bpg',
		'docx',
		'pptx',
		'xlsx',
		'3gp',
		'3g2',
		'jp2',
		'jpm',
		'jpx',
		'mj2',
		'aif',
		'qcp',
		'odt',
		'ods',
		'odp',
		'xml',
		'mobi',
		'heic',
		'cur',
		'ktx',
		'ape',
		'wv',
		'dcm',
		'ics',
		'glb',
		'pcap',
		'dsf',
		'lnk',
		'alias',
		'voc',
		'ac3',
		'm4v',
		'm4p',
		'm4b',
		'f4v',
		'f4p',
		'f4b',
		'f4a',
		'mie',
		'asf',
		'ogm',
		'ogx',
		'mpc',
		'arrow',
		'shp',
		'aac',
		'mp1',
		'it',
		's3m',
		'xm',
		'ai',
		'skp',
		'avif',
		'eps',
		'lzh',
		'pgp',
		'asar',
		'stl',
		'chm',
		'3mf',
		'zst',
		'jxl',
		'vcf'
	],
	mimeTypes: [
		'image/jpeg',
		'image/png',
		'image/gif',
		'image/webp',
		'image/flif',
		'image/x-xcf',
		'image/x-canon-cr2',
		'image/x-canon-cr3',
		'image/tiff',
		'image/bmp',
		'image/vnd.ms-photo',
		'image/vnd.adobe.photoshop',
		'application/x-indesign',
		'application/epub+zip',
		'application/x-xpinstall',
		'application/vnd.oasis.opendocument.text',
		'application/vnd.oasis.opendocument.spreadsheet',
		'application/vnd.oasis.opendocument.presentation',
		'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
		'application/vnd.openxmlformats-officedocument.presentationml.presentation',
		'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
		'application/zip',
		'application/x-tar',
		'application/x-rar-compressed',
		'application/gzip',
		'application/x-bzip2',
		'application/x-7z-compressed',
		'application/x-apple-diskimage',
		'application/x-apache-arrow',
		'video/mp4',
		'audio/midi',
		'video/x-matroska',
		'video/webm',
		'video/quicktime',
		'video/vnd.avi',
		'audio/vnd.wave',
		'audio/qcelp',
		'audio/x-ms-asf',
		'video/x-ms-asf',
		'application/vnd.ms-asf',
		'video/mpeg',
		'video/3gpp',
		'audio/mpeg',
		'audio/mp4', // RFC 4337
		'audio/opus',
		'video/ogg',
		'audio/ogg',
		'application/ogg',
		'audio/x-flac',
		'audio/ape',
		'audio/wavpack',
		'audio/amr',
		'application/pdf',
		'application/x-msdownload',
		'application/x-shockwave-flash',
		'application/rtf',
		'application/wasm',
		'font/woff',
		'font/woff2',
		'application/vnd.ms-fontobject',
		'font/ttf',
		'font/otf',
		'image/x-icon',
		'video/x-flv',
		'application/postscript',
		'application/eps',
		'application/x-xz',
		'application/x-sqlite3',
		'application/x-nintendo-nes-rom',
		'application/x-google-chrome-extension',
		'application/vnd.ms-cab-compressed',
		'application/x-deb',
		'application/x-unix-archive',
		'application/x-rpm',
		'application/x-compress',
		'application/x-lzip',
		'application/x-cfb',
		'application/x-mie',
		'application/mxf',
		'video/mp2t',
		'application/x-blender',
		'image/bpg',
		'image/jp2',
		'image/jpx',
		'image/jpm',
		'image/mj2',
		'audio/aiff',
		'application/xml',
		'application/x-mobipocket-ebook',
		'image/heif',
		'image/heif-sequence',
		'image/heic',
		'image/heic-sequence',
		'image/icns',
		'image/ktx',
		'application/dicom',
		'audio/x-musepack',
		'text/calendar',
		'text/vcard',
		'model/gltf-binary',
		'application/vnd.tcpdump.pcap',
		'audio/x-dsf', // Non-standard
		'application/x.ms.shortcut', // Invented by us
		'application/x.apple.alias', // Invented by us
		'audio/x-voc',
		'audio/vnd.dolby.dd-raw',
		'audio/x-m4a',
		'image/apng',
		'image/x-olympus-orf',
		'image/x-sony-arw',
		'image/x-adobe-dng',
		'image/x-nikon-nef',
		'image/x-panasonic-rw2',
		'image/x-fujifilm-raf',
		'video/x-m4v',
		'video/3gpp2',
		'application/x-esri-shape',
		'audio/aac',
		'audio/x-it',
		'audio/x-s3m',
		'audio/x-xm',
		'video/MP1S',
		'video/MP2P',
		'application/vnd.sketchup.skp',
		'image/avif',
		'application/x-lzh-compressed',
		'application/pgp-encrypted',
		'application/x-asar',
		'model/stl',
		'application/vnd.ms-htmlhelp',
		'model/3mf',
		'image/jxl',
		'application/zstd'
	]
};

const Token = lib$1;
const strtok3$1 = core$3;
const {
	stringToBytes,
	tarHeaderChecksumMatches,
	uint32SyncSafeToken
} = util$4;
const supported = supported$1;

const minimumBytes = 4100; // A fair amount of file-types are detectable within this range

async function fromStream(stream) {
	const tokenizer = await strtok3$1.fromStream(stream);
	try {
		return await fromTokenizer(tokenizer);
	} finally {
		await tokenizer.close();
	}
}

async function fromBuffer(input) {
	if (!(input instanceof Uint8Array || input instanceof ArrayBuffer || Buffer.isBuffer(input))) {
		throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`Buffer\` or \`ArrayBuffer\`, got \`${typeof input}\``);
	}

	const buffer = input instanceof Buffer ? input : Buffer.from(input);

	if (!(buffer && buffer.length > 1)) {
		return;
	}

	const tokenizer = strtok3$1.fromBuffer(buffer);
	return fromTokenizer(tokenizer);
}

function _check(buffer, headers, options) {
	options = {
		offset: 0,
		...options
	};

	for (const [index, header] of headers.entries()) {
		// If a bitmask is set
		if (options.mask) {
			// If header doesn't equal `buf` with bits masked off
			if (header !== (options.mask[index] & buffer[index + options.offset])) {
				return false;
			}
		} else if (header !== buffer[index + options.offset]) {
			return false;
		}
	}

	return true;
}

async function fromTokenizer(tokenizer) {
	try {
		return _fromTokenizer(tokenizer);
	} catch (error) {
		if (!(error instanceof strtok3$1.EndOfStreamError)) {
			throw error;
		}
	}
}

async function _fromTokenizer(tokenizer) {
	let buffer = Buffer.alloc(minimumBytes);
	const bytesRead = 12;
	const check = (header, options) => _check(buffer, header, options);
	const checkString = (header, options) => check(stringToBytes(header), options);

	// Keep reading until EOF if the file size is unknown.
	if (!tokenizer.fileInfo.size) {
		tokenizer.fileInfo.size = Number.MAX_SAFE_INTEGER;
	}

	await tokenizer.peekBuffer(buffer, {length: bytesRead, mayBeLess: true});

	// -- 2-byte signatures --

	if (check([0x42, 0x4D])) {
		return {
			ext: 'bmp',
			mime: 'image/bmp'
		};
	}

	if (check([0x0B, 0x77])) {
		return {
			ext: 'ac3',
			mime: 'audio/vnd.dolby.dd-raw'
		};
	}

	if (check([0x78, 0x01])) {
		return {
			ext: 'dmg',
			mime: 'application/x-apple-diskimage'
		};
	}

	if (check([0x4D, 0x5A])) {
		return {
			ext: 'exe',
			mime: 'application/x-msdownload'
		};
	}

	if (check([0x25, 0x21])) {
		await tokenizer.peekBuffer(buffer, {length: 24, mayBeLess: true});

		if (checkString('PS-Adobe-', {offset: 2}) &&
			checkString(' EPSF-', {offset: 14})) {
			return {
				ext: 'eps',
				mime: 'application/eps'
			};
		}

		return {
			ext: 'ps',
			mime: 'application/postscript'
		};
	}

	if (
		check([0x1F, 0xA0]) ||
		check([0x1F, 0x9D])
	) {
		return {
			ext: 'Z',
			mime: 'application/x-compress'
		};
	}

	// -- 3-byte signatures --

	if (check([0xFF, 0xD8, 0xFF])) {
		return {
			ext: 'jpg',
			mime: 'image/jpeg'
		};
	}

	if (check([0x49, 0x49, 0xBC])) {
		return {
			ext: 'jxr',
			mime: 'image/vnd.ms-photo'
		};
	}

	if (check([0x1F, 0x8B, 0x8])) {
		return {
			ext: 'gz',
			mime: 'application/gzip'
		};
	}

	if (check([0x42, 0x5A, 0x68])) {
		return {
			ext: 'bz2',
			mime: 'application/x-bzip2'
		};
	}

	if (checkString('ID3')) {
		await tokenizer.ignore(6); // Skip ID3 header until the header size
		const id3HeaderLen = await tokenizer.readToken(uint32SyncSafeToken);
		if (tokenizer.position + id3HeaderLen > tokenizer.fileInfo.size) {
			// Guess file type based on ID3 header for backward compatibility
			return {
				ext: 'mp3',
				mime: 'audio/mpeg'
			};
		}

		await tokenizer.ignore(id3HeaderLen);
		return fromTokenizer(tokenizer); // Skip ID3 header, recursion
	}

	// Musepack, SV7
	if (checkString('MP+')) {
		return {
			ext: 'mpc',
			mime: 'audio/x-musepack'
		};
	}

	if (
		(buffer[0] === 0x43 || buffer[0] === 0x46) &&
		check([0x57, 0x53], {offset: 1})
	) {
		return {
			ext: 'swf',
			mime: 'application/x-shockwave-flash'
		};
	}

	// -- 4-byte signatures --

	if (check([0x47, 0x49, 0x46])) {
		return {
			ext: 'gif',
			mime: 'image/gif'
		};
	}

	if (checkString('FLIF')) {
		return {
			ext: 'flif',
			mime: 'image/flif'
		};
	}

	if (checkString('8BPS')) {
		return {
			ext: 'psd',
			mime: 'image/vnd.adobe.photoshop'
		};
	}

	if (checkString('WEBP', {offset: 8})) {
		return {
			ext: 'webp',
			mime: 'image/webp'
		};
	}

	// Musepack, SV8
	if (checkString('MPCK')) {
		return {
			ext: 'mpc',
			mime: 'audio/x-musepack'
		};
	}

	if (checkString('FORM')) {
		return {
			ext: 'aif',
			mime: 'audio/aiff'
		};
	}

	if (checkString('icns', {offset: 0})) {
		return {
			ext: 'icns',
			mime: 'image/icns'
		};
	}

	// Zip-based file formats
	// Need to be before the `zip` check
	if (check([0x50, 0x4B, 0x3, 0x4])) { // Local file header signature
		try {
			while (tokenizer.position + 30 < tokenizer.fileInfo.size) {
				await tokenizer.readBuffer(buffer, {length: 30});

				// https://en.wikipedia.org/wiki/Zip_(file_format)#File_headers
				const zipHeader = {
					compressedSize: buffer.readUInt32LE(18),
					uncompressedSize: buffer.readUInt32LE(22),
					filenameLength: buffer.readUInt16LE(26),
					extraFieldLength: buffer.readUInt16LE(28)
				};

				zipHeader.filename = await tokenizer.readToken(new Token.StringType(zipHeader.filenameLength, 'utf-8'));
				await tokenizer.ignore(zipHeader.extraFieldLength);

				// Assumes signed `.xpi` from addons.mozilla.org
				if (zipHeader.filename === 'META-INF/mozilla.rsa') {
					return {
						ext: 'xpi',
						mime: 'application/x-xpinstall'
					};
				}

				if (zipHeader.filename.endsWith('.rels') || zipHeader.filename.endsWith('.xml')) {
					const type = zipHeader.filename.split('/')[0];
					switch (type) {
						case '_rels':
							break;
						case 'word':
							return {
								ext: 'docx',
								mime: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
							};
						case 'ppt':
							return {
								ext: 'pptx',
								mime: 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
							};
						case 'xl':
							return {
								ext: 'xlsx',
								mime: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
							};
						default:
							break;
					}
				}

				if (zipHeader.filename.startsWith('xl/')) {
					return {
						ext: 'xlsx',
						mime: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
					};
				}

				if (zipHeader.filename.startsWith('3D/') && zipHeader.filename.endsWith('.model')) {
					return {
						ext: '3mf',
						mime: 'model/3mf'
					};
				}

				// The docx, xlsx and pptx file types extend the Office Open XML file format:
				// https://en.wikipedia.org/wiki/Office_Open_XML_file_formats
				// We look for:
				// - one entry named '[Content_Types].xml' or '_rels/.rels',
				// - one entry indicating specific type of file.
				// MS Office, OpenOffice and LibreOffice may put the parts in different order, so the check should not rely on it.
				if (zipHeader.filename === 'mimetype' && zipHeader.compressedSize === zipHeader.uncompressedSize) {
					const mimeType = await tokenizer.readToken(new Token.StringType(zipHeader.compressedSize, 'utf-8'));

					switch (mimeType) {
						case 'application/epub+zip':
							return {
								ext: 'epub',
								mime: 'application/epub+zip'
							};
						case 'application/vnd.oasis.opendocument.text':
							return {
								ext: 'odt',
								mime: 'application/vnd.oasis.opendocument.text'
							};
						case 'application/vnd.oasis.opendocument.spreadsheet':
							return {
								ext: 'ods',
								mime: 'application/vnd.oasis.opendocument.spreadsheet'
							};
						case 'application/vnd.oasis.opendocument.presentation':
							return {
								ext: 'odp',
								mime: 'application/vnd.oasis.opendocument.presentation'
							};
						default:
					}
				}

				// Try to find next header manually when current one is corrupted
				if (zipHeader.compressedSize === 0) {
					let nextHeaderIndex = -1;

					while (nextHeaderIndex < 0 && (tokenizer.position < tokenizer.fileInfo.size)) {
						await tokenizer.peekBuffer(buffer, {mayBeLess: true});

						nextHeaderIndex = buffer.indexOf('504B0304', 0, 'hex');
						// Move position to the next header if found, skip the whole buffer otherwise
						await tokenizer.ignore(nextHeaderIndex >= 0 ? nextHeaderIndex : buffer.length);
					}
				} else {
					await tokenizer.ignore(zipHeader.compressedSize);
				}
			}
		} catch (error) {
			if (!(error instanceof strtok3$1.EndOfStreamError)) {
				throw error;
			}
		}

		return {
			ext: 'zip',
			mime: 'application/zip'
		};
	}

	if (checkString('OggS')) {
		// This is an OGG container
		await tokenizer.ignore(28);
		const type = Buffer.alloc(8);
		await tokenizer.readBuffer(type);

		// Needs to be before `ogg` check
		if (_check(type, [0x4F, 0x70, 0x75, 0x73, 0x48, 0x65, 0x61, 0x64])) {
			return {
				ext: 'opus',
				mime: 'audio/opus'
			};
		}

		// If ' theora' in header.
		if (_check(type, [0x80, 0x74, 0x68, 0x65, 0x6F, 0x72, 0x61])) {
			return {
				ext: 'ogv',
				mime: 'video/ogg'
			};
		}

		// If '\x01video' in header.
		if (_check(type, [0x01, 0x76, 0x69, 0x64, 0x65, 0x6F, 0x00])) {
			return {
				ext: 'ogm',
				mime: 'video/ogg'
			};
		}

		// If ' FLAC' in header  https://xiph.org/flac/faq.html
		if (_check(type, [0x7F, 0x46, 0x4C, 0x41, 0x43])) {
			return {
				ext: 'oga',
				mime: 'audio/ogg'
			};
		}

		// 'Speex  ' in header https://en.wikipedia.org/wiki/Speex
		if (_check(type, [0x53, 0x70, 0x65, 0x65, 0x78, 0x20, 0x20])) {
			return {
				ext: 'spx',
				mime: 'audio/ogg'
			};
		}

		// If '\x01vorbis' in header
		if (_check(type, [0x01, 0x76, 0x6F, 0x72, 0x62, 0x69, 0x73])) {
			return {
				ext: 'ogg',
				mime: 'audio/ogg'
			};
		}

		// Default OGG container https://www.iana.org/assignments/media-types/application/ogg
		return {
			ext: 'ogx',
			mime: 'application/ogg'
		};
	}

	if (
		check([0x50, 0x4B]) &&
		(buffer[2] === 0x3 || buffer[2] === 0x5 || buffer[2] === 0x7) &&
		(buffer[3] === 0x4 || buffer[3] === 0x6 || buffer[3] === 0x8)
	) {
		return {
			ext: 'zip',
			mime: 'application/zip'
		};
	}

	//

	// File Type Box (https://en.wikipedia.org/wiki/ISO_base_media_file_format)
	// It's not required to be first, but it's recommended to be. Almost all ISO base media files start with `ftyp` box.
	// `ftyp` box must contain a brand major identifier, which must consist of ISO 8859-1 printable characters.
	// Here we check for 8859-1 printable characters (for simplicity, it's a mask which also catches one non-printable character).
	if (
		checkString('ftyp', {offset: 4}) &&
		(buffer[8] & 0x60) !== 0x00 // Brand major, first character ASCII?
	) {
		// They all can have MIME `video/mp4` except `application/mp4` special-case which is hard to detect.
		// For some cases, we're specific, everything else falls to `video/mp4` with `mp4` extension.
		const brandMajor = buffer.toString('binary', 8, 12).replace('\0', ' ').trim();
		switch (brandMajor) {
			case 'avif':
				return {ext: 'avif', mime: 'image/avif'};
			case 'mif1':
				return {ext: 'heic', mime: 'image/heif'};
			case 'msf1':
				return {ext: 'heic', mime: 'image/heif-sequence'};
			case 'heic':
			case 'heix':
				return {ext: 'heic', mime: 'image/heic'};
			case 'hevc':
			case 'hevx':
				return {ext: 'heic', mime: 'image/heic-sequence'};
			case 'qt':
				return {ext: 'mov', mime: 'video/quicktime'};
			case 'M4V':
			case 'M4VH':
			case 'M4VP':
				return {ext: 'm4v', mime: 'video/x-m4v'};
			case 'M4P':
				return {ext: 'm4p', mime: 'video/mp4'};
			case 'M4B':
				return {ext: 'm4b', mime: 'audio/mp4'};
			case 'M4A':
				return {ext: 'm4a', mime: 'audio/x-m4a'};
			case 'F4V':
				return {ext: 'f4v', mime: 'video/mp4'};
			case 'F4P':
				return {ext: 'f4p', mime: 'video/mp4'};
			case 'F4A':
				return {ext: 'f4a', mime: 'audio/mp4'};
			case 'F4B':
				return {ext: 'f4b', mime: 'audio/mp4'};
			case 'crx':
				return {ext: 'cr3', mime: 'image/x-canon-cr3'};
			default:
				if (brandMajor.startsWith('3g')) {
					if (brandMajor.startsWith('3g2')) {
						return {ext: '3g2', mime: 'video/3gpp2'};
					}

					return {ext: '3gp', mime: 'video/3gpp'};
				}

				return {ext: 'mp4', mime: 'video/mp4'};
		}
	}

	if (checkString('MThd')) {
		return {
			ext: 'mid',
			mime: 'audio/midi'
		};
	}

	if (
		checkString('wOFF') &&
		(
			check([0x00, 0x01, 0x00, 0x00], {offset: 4}) ||
			checkString('OTTO', {offset: 4})
		)
	) {
		return {
			ext: 'woff',
			mime: 'font/woff'
		};
	}

	if (
		checkString('wOF2') &&
		(
			check([0x00, 0x01, 0x00, 0x00], {offset: 4}) ||
			checkString('OTTO', {offset: 4})
		)
	) {
		return {
			ext: 'woff2',
			mime: 'font/woff2'
		};
	}

	if (check([0xD4, 0xC3, 0xB2, 0xA1]) || check([0xA1, 0xB2, 0xC3, 0xD4])) {
		return {
			ext: 'pcap',
			mime: 'application/vnd.tcpdump.pcap'
		};
	}

	// Sony DSD Stream File (DSF)
	if (checkString('DSD ')) {
		return {
			ext: 'dsf',
			mime: 'audio/x-dsf' // Non-standard
		};
	}

	if (checkString('LZIP')) {
		return {
			ext: 'lz',
			mime: 'application/x-lzip'
		};
	}

	if (checkString('fLaC')) {
		return {
			ext: 'flac',
			mime: 'audio/x-flac'
		};
	}

	if (check([0x42, 0x50, 0x47, 0xFB])) {
		return {
			ext: 'bpg',
			mime: 'image/bpg'
		};
	}

	if (checkString('wvpk')) {
		return {
			ext: 'wv',
			mime: 'audio/wavpack'
		};
	}

	if (checkString('%PDF')) {
		await tokenizer.ignore(1350);
		const maxBufferSize = 10 * 1024 * 1024;
		const buffer = Buffer.alloc(Math.min(maxBufferSize, tokenizer.fileInfo.size));
		await tokenizer.readBuffer(buffer, {mayBeLess: true});

		// Check if this is an Adobe Illustrator file
		if (buffer.includes(Buffer.from('AIPrivateData'))) {
			return {
				ext: 'ai',
				mime: 'application/postscript'
			};
		}

		// Assume this is just a normal PDF
		return {
			ext: 'pdf',
			mime: 'application/pdf'
		};
	}

	if (check([0x00, 0x61, 0x73, 0x6D])) {
		return {
			ext: 'wasm',
			mime: 'application/wasm'
		};
	}

	// TIFF, little-endian type
	if (check([0x49, 0x49, 0x2A, 0x0])) {
		if (checkString('CR', {offset: 8})) {
			return {
				ext: 'cr2',
				mime: 'image/x-canon-cr2'
			};
		}

		if (check([0x1C, 0x00, 0xFE, 0x00], {offset: 8}) || check([0x1F, 0x00, 0x0B, 0x00], {offset: 8})) {
			return {
				ext: 'nef',
				mime: 'image/x-nikon-nef'
			};
		}

		if (
			check([0x08, 0x00, 0x00, 0x00], {offset: 4}) &&
			(check([0x2D, 0x00, 0xFE, 0x00], {offset: 8}) ||
				check([0x27, 0x00, 0xFE, 0x00], {offset: 8}))
		) {
			return {
				ext: 'dng',
				mime: 'image/x-adobe-dng'
			};
		}

		buffer = Buffer.alloc(24);
		await tokenizer.peekBuffer(buffer);
		if (
			(check([0x10, 0xFB, 0x86, 0x01], {offset: 4}) || check([0x08, 0x00, 0x00, 0x00], {offset: 4})) &&
			// This pattern differentiates ARW from other TIFF-ish file types:
			check([0x00, 0xFE, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x01], {offset: 9})
		) {
			return {
				ext: 'arw',
				mime: 'image/x-sony-arw'
			};
		}

		return {
			ext: 'tif',
			mime: 'image/tiff'
		};
	}

	// TIFF, big-endian type
	if (check([0x4D, 0x4D, 0x0, 0x2A])) {
		return {
			ext: 'tif',
			mime: 'image/tiff'
		};
	}

	if (checkString('MAC ')) {
		return {
			ext: 'ape',
			mime: 'audio/ape'
		};
	}

	// https://github.com/threatstack/libmagic/blob/master/magic/Magdir/matroska
	if (check([0x1A, 0x45, 0xDF, 0xA3])) { // Root element: EBML
		async function readField() {
			const msb = await tokenizer.peekNumber(Token.UINT8);
			let mask = 0x80;
			let ic = 0; // 0 = A, 1 = B, 2 = C, 3 = D

			while ((msb & mask) === 0 && mask !== 0) {
				++ic;
				mask >>= 1;
			}

			const id = Buffer.alloc(ic + 1);
			await tokenizer.readBuffer(id);
			return id;
		}

		async function readElement() {
			const id = await readField();
			const lenField = await readField();
			lenField[0] ^= 0x80 >> (lenField.length - 1);
			const nrLen = Math.min(6, lenField.length); // JavaScript can max read 6 bytes integer
			return {
				id: id.readUIntBE(0, id.length),
				len: lenField.readUIntBE(lenField.length - nrLen, nrLen)
			};
		}

		async function readChildren(level, children) {
			while (children > 0) {
				const e = await readElement();
				if (e.id === 0x4282) {
					return tokenizer.readToken(new Token.StringType(e.len, 'utf-8')); // Return DocType
				}

				await tokenizer.ignore(e.len); // ignore payload
				--children;
			}
		}

		const re = await readElement();
		const docType = await readChildren(1, re.len);

		switch (docType) {
			case 'webm':
				return {
					ext: 'webm',
					mime: 'video/webm'
				};

			case 'matroska':
				return {
					ext: 'mkv',
					mime: 'video/x-matroska'
				};

			default:
				return;
		}
	}

	// RIFF file format which might be AVI, WAV, QCP, etc
	if (check([0x52, 0x49, 0x46, 0x46])) {
		if (check([0x41, 0x56, 0x49], {offset: 8})) {
			return {
				ext: 'avi',
				mime: 'video/vnd.avi'
			};
		}

		if (check([0x57, 0x41, 0x56, 0x45], {offset: 8})) {
			return {
				ext: 'wav',
				mime: 'audio/vnd.wave'
			};
		}

		// QLCM, QCP file
		if (check([0x51, 0x4C, 0x43, 0x4D], {offset: 8})) {
			return {
				ext: 'qcp',
				mime: 'audio/qcelp'
			};
		}
	}

	if (checkString('SQLi')) {
		return {
			ext: 'sqlite',
			mime: 'application/x-sqlite3'
		};
	}

	if (check([0x4E, 0x45, 0x53, 0x1A])) {
		return {
			ext: 'nes',
			mime: 'application/x-nintendo-nes-rom'
		};
	}

	if (checkString('Cr24')) {
		return {
			ext: 'crx',
			mime: 'application/x-google-chrome-extension'
		};
	}

	if (
		checkString('MSCF') ||
		checkString('ISc(')
	) {
		return {
			ext: 'cab',
			mime: 'application/vnd.ms-cab-compressed'
		};
	}

	if (check([0xED, 0xAB, 0xEE, 0xDB])) {
		return {
			ext: 'rpm',
			mime: 'application/x-rpm'
		};
	}

	if (check([0xC5, 0xD0, 0xD3, 0xC6])) {
		return {
			ext: 'eps',
			mime: 'application/eps'
		};
	}

	if (check([0x28, 0xB5, 0x2F, 0xFD])) {
		return {
			ext: 'zst',
			mime: 'application/zstd'
		};
	}

	// -- 5-byte signatures --

	if (check([0x4F, 0x54, 0x54, 0x4F, 0x00])) {
		return {
			ext: 'otf',
			mime: 'font/otf'
		};
	}

	if (checkString('#!AMR')) {
		return {
			ext: 'amr',
			mime: 'audio/amr'
		};
	}

	if (checkString('{\\rtf')) {
		return {
			ext: 'rtf',
			mime: 'application/rtf'
		};
	}

	if (check([0x46, 0x4C, 0x56, 0x01])) {
		return {
			ext: 'flv',
			mime: 'video/x-flv'
		};
	}

	if (checkString('IMPM')) {
		return {
			ext: 'it',
			mime: 'audio/x-it'
		};
	}

	if (
		checkString('-lh0-', {offset: 2}) ||
		checkString('-lh1-', {offset: 2}) ||
		checkString('-lh2-', {offset: 2}) ||
		checkString('-lh3-', {offset: 2}) ||
		checkString('-lh4-', {offset: 2}) ||
		checkString('-lh5-', {offset: 2}) ||
		checkString('-lh6-', {offset: 2}) ||
		checkString('-lh7-', {offset: 2}) ||
		checkString('-lzs-', {offset: 2}) ||
		checkString('-lz4-', {offset: 2}) ||
		checkString('-lz5-', {offset: 2}) ||
		checkString('-lhd-', {offset: 2})
	) {
		return {
			ext: 'lzh',
			mime: 'application/x-lzh-compressed'
		};
	}

	// MPEG program stream (PS or MPEG-PS)
	if (check([0x00, 0x00, 0x01, 0xBA])) {
		//  MPEG-PS, MPEG-1 Part 1
		if (check([0x21], {offset: 4, mask: [0xF1]})) {
			return {
				ext: 'mpg', // May also be .ps, .mpeg
				mime: 'video/MP1S'
			};
		}

		// MPEG-PS, MPEG-2 Part 1
		if (check([0x44], {offset: 4, mask: [0xC4]})) {
			return {
				ext: 'mpg', // May also be .mpg, .m2p, .vob or .sub
				mime: 'video/MP2P'
			};
		}
	}

	if (checkString('ITSF')) {
		return {
			ext: 'chm',
			mime: 'application/vnd.ms-htmlhelp'
		};
	}

	// -- 6-byte signatures --

	if (check([0xFD, 0x37, 0x7A, 0x58, 0x5A, 0x00])) {
		return {
			ext: 'xz',
			mime: 'application/x-xz'
		};
	}

	if (checkString('<?xml ')) {
		return {
			ext: 'xml',
			mime: 'application/xml'
		};
	}

	if (check([0x37, 0x7A, 0xBC, 0xAF, 0x27, 0x1C])) {
		return {
			ext: '7z',
			mime: 'application/x-7z-compressed'
		};
	}

	if (
		check([0x52, 0x61, 0x72, 0x21, 0x1A, 0x7]) &&
		(buffer[6] === 0x0 || buffer[6] === 0x1)
	) {
		return {
			ext: 'rar',
			mime: 'application/x-rar-compressed'
		};
	}

	if (checkString('solid ')) {
		return {
			ext: 'stl',
			mime: 'model/stl'
		};
	}

	// -- 7-byte signatures --

	if (checkString('BLENDER')) {
		return {
			ext: 'blend',
			mime: 'application/x-blender'
		};
	}

	if (checkString('!<arch>')) {
		await tokenizer.ignore(8);
		const str = await tokenizer.readToken(new Token.StringType(13, 'ascii'));
		if (str === 'debian-binary') {
			return {
				ext: 'deb',
				mime: 'application/x-deb'
			};
		}

		return {
			ext: 'ar',
			mime: 'application/x-unix-archive'
		};
	}

	// -- 8-byte signatures --

	if (check([0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A])) {
		// APNG format (https://wiki.mozilla.org/APNG_Specification)
		// 1. Find the first IDAT (image data) chunk (49 44 41 54)
		// 2. Check if there is an "acTL" chunk before the IDAT one (61 63 54 4C)

		// Offset calculated as follows:
		// - 8 bytes: PNG signature
		// - 4 (length) + 4 (chunk type) + 13 (chunk data) + 4 (CRC): IHDR chunk

		await tokenizer.ignore(8); // ignore PNG signature

		async function readChunkHeader() {
			return {
				length: await tokenizer.readToken(Token.INT32_BE),
				type: await tokenizer.readToken(new Token.StringType(4, 'binary'))
			};
		}

		do {
			const chunk = await readChunkHeader();
			if (chunk.length < 0) {
				return; // Invalid chunk length
			}

			switch (chunk.type) {
				case 'IDAT':
					return {
						ext: 'png',
						mime: 'image/png'
					};
				case 'acTL':
					return {
						ext: 'apng',
						mime: 'image/apng'
					};
				default:
					await tokenizer.ignore(chunk.length + 4); // Ignore chunk-data + CRC
			}
		} while (tokenizer.position + 8 < tokenizer.fileInfo.size);

		return {
			ext: 'png',
			mime: 'image/png'
		};
	}

	if (check([0x41, 0x52, 0x52, 0x4F, 0x57, 0x31, 0x00, 0x00])) {
		return {
			ext: 'arrow',
			mime: 'application/x-apache-arrow'
		};
	}

	if (check([0x67, 0x6C, 0x54, 0x46, 0x02, 0x00, 0x00, 0x00])) {
		return {
			ext: 'glb',
			mime: 'model/gltf-binary'
		};
	}

	// `mov` format variants
	if (
		check([0x66, 0x72, 0x65, 0x65], {offset: 4}) || // `free`
		check([0x6D, 0x64, 0x61, 0x74], {offset: 4}) || // `mdat` MJPEG
		check([0x6D, 0x6F, 0x6F, 0x76], {offset: 4}) || // `moov`
		check([0x77, 0x69, 0x64, 0x65], {offset: 4}) // `wide`
	) {
		return {
			ext: 'mov',
			mime: 'video/quicktime'
		};
	}

	// -- 9-byte signatures --

	if (check([0x49, 0x49, 0x52, 0x4F, 0x08, 0x00, 0x00, 0x00, 0x18])) {
		return {
			ext: 'orf',
			mime: 'image/x-olympus-orf'
		};
	}

	if (checkString('gimp xcf ')) {
		return {
			ext: 'xcf',
			mime: 'image/x-xcf'
		};
	}

	// -- 12-byte signatures --

	if (check([0x49, 0x49, 0x55, 0x00, 0x18, 0x00, 0x00, 0x00, 0x88, 0xE7, 0x74, 0xD8])) {
		return {
			ext: 'rw2',
			mime: 'image/x-panasonic-rw2'
		};
	}

	// ASF_Header_Object first 80 bytes
	if (check([0x30, 0x26, 0xB2, 0x75, 0x8E, 0x66, 0xCF, 0x11, 0xA6, 0xD9])) {
		async function readHeader() {
			const guid = Buffer.alloc(16);
			await tokenizer.readBuffer(guid);
			return {
				id: guid,
				size: Number(await tokenizer.readToken(Token.UINT64_LE))
			};
		}

		await tokenizer.ignore(30);
		// Search for header should be in first 1KB of file.
		while (tokenizer.position + 24 < tokenizer.fileInfo.size) {
			const header = await readHeader();
			let payload = header.size - 24;
			if (_check(header.id, [0x91, 0x07, 0xDC, 0xB7, 0xB7, 0xA9, 0xCF, 0x11, 0x8E, 0xE6, 0x00, 0xC0, 0x0C, 0x20, 0x53, 0x65])) {
				// Sync on Stream-Properties-Object (B7DC0791-A9B7-11CF-8EE6-00C00C205365)
				const typeId = Buffer.alloc(16);
				payload -= await tokenizer.readBuffer(typeId);

				if (_check(typeId, [0x40, 0x9E, 0x69, 0xF8, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
					// Found audio:
					return {
						ext: 'asf',
						mime: 'audio/x-ms-asf'
					};
				}

				if (_check(typeId, [0xC0, 0xEF, 0x19, 0xBC, 0x4D, 0x5B, 0xCF, 0x11, 0xA8, 0xFD, 0x00, 0x80, 0x5F, 0x5C, 0x44, 0x2B])) {
					// Found video:
					return {
						ext: 'asf',
						mime: 'video/x-ms-asf'
					};
				}

				break;
			}

			await tokenizer.ignore(payload);
		}

		// Default to ASF generic extension
		return {
			ext: 'asf',
			mime: 'application/vnd.ms-asf'
		};
	}

	if (check([0xAB, 0x4B, 0x54, 0x58, 0x20, 0x31, 0x31, 0xBB, 0x0D, 0x0A, 0x1A, 0x0A])) {
		return {
			ext: 'ktx',
			mime: 'image/ktx'
		};
	}

	if ((check([0x7E, 0x10, 0x04]) || check([0x7E, 0x18, 0x04])) && check([0x30, 0x4D, 0x49, 0x45], {offset: 4})) {
		return {
			ext: 'mie',
			mime: 'application/x-mie'
		};
	}

	if (check([0x27, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], {offset: 2})) {
		return {
			ext: 'shp',
			mime: 'application/x-esri-shape'
		};
	}

	if (check([0x00, 0x00, 0x00, 0x0C, 0x6A, 0x50, 0x20, 0x20, 0x0D, 0x0A, 0x87, 0x0A])) {
		// JPEG-2000 family

		await tokenizer.ignore(20);
		const type = await tokenizer.readToken(new Token.StringType(4, 'ascii'));
		switch (type) {
			case 'jp2 ':
				return {
					ext: 'jp2',
					mime: 'image/jp2'
				};
			case 'jpx ':
				return {
					ext: 'jpx',
					mime: 'image/jpx'
				};
			case 'jpm ':
				return {
					ext: 'jpm',
					mime: 'image/jpm'
				};
			case 'mjp2':
				return {
					ext: 'mj2',
					mime: 'image/mj2'
				};
			default:
				return;
		}
	}

	if (
		check([0xFF, 0x0A]) ||
		check([0x00, 0x00, 0x00, 0x0C, 0x4A, 0x58, 0x4C, 0x20, 0x0D, 0x0A, 0x87, 0x0A])
	) {
		return {
			ext: 'jxl',
			mime: 'image/jxl'
		};
	}

	// -- Unsafe signatures --

	if (
		check([0x0, 0x0, 0x1, 0xBA]) ||
		check([0x0, 0x0, 0x1, 0xB3])
	) {
		return {
			ext: 'mpg',
			mime: 'video/mpeg'
		};
	}

	if (check([0x00, 0x01, 0x00, 0x00, 0x00])) {
		return {
			ext: 'ttf',
			mime: 'font/ttf'
		};
	}

	if (check([0x00, 0x00, 0x01, 0x00])) {
		return {
			ext: 'ico',
			mime: 'image/x-icon'
		};
	}

	if (check([0x00, 0x00, 0x02, 0x00])) {
		return {
			ext: 'cur',
			mime: 'image/x-icon'
		};
	}

	if (check([0xD0, 0xCF, 0x11, 0xE0, 0xA1, 0xB1, 0x1A, 0xE1])) {
		// Detected Microsoft Compound File Binary File (MS-CFB) Format.
		return {
			ext: 'cfb',
			mime: 'application/x-cfb'
		};
	}

	// Increase sample size from 12 to 256.
	await tokenizer.peekBuffer(buffer, {length: Math.min(256, tokenizer.fileInfo.size), mayBeLess: true});

	// -- 15-byte signatures --

	if (checkString('BEGIN:')) {
		if (checkString('VCARD', {offset: 6})) {
			return {
				ext: 'vcf',
				mime: 'text/vcard'
			};
		}

		if (checkString('VCALENDAR', {offset: 6})) {
			return {
				ext: 'ics',
				mime: 'text/calendar'
			};
		}
	}

	// `raf` is here just to keep all the raw image detectors together.
	if (checkString('FUJIFILMCCD-RAW')) {
		return {
			ext: 'raf',
			mime: 'image/x-fujifilm-raf'
		};
	}

	if (checkString('Extended Module:')) {
		return {
			ext: 'xm',
			mime: 'audio/x-xm'
		};
	}

	if (checkString('Creative Voice File')) {
		return {
			ext: 'voc',
			mime: 'audio/x-voc'
		};
	}

	if (check([0x04, 0x00, 0x00, 0x00]) && buffer.length >= 16) { // Rough & quick check Pickle/ASAR
		const jsonSize = buffer.readUInt32LE(12);
		if (jsonSize > 12 && buffer.length >= jsonSize + 16) {
			try {
				const header = buffer.slice(16, jsonSize + 16).toString();
				const json = JSON.parse(header);
				// Check if Pickle is ASAR
				if (json.files) { // Final check, assuring Pickle/ASAR format
					return {
						ext: 'asar',
						mime: 'application/x-asar'
					};
				}
			} catch (_) {
			}
		}
	}

	if (check([0x06, 0x0E, 0x2B, 0x34, 0x02, 0x05, 0x01, 0x01, 0x0D, 0x01, 0x02, 0x01, 0x01, 0x02])) {
		return {
			ext: 'mxf',
			mime: 'application/mxf'
		};
	}

	if (checkString('SCRM', {offset: 44})) {
		return {
			ext: 's3m',
			mime: 'audio/x-s3m'
		};
	}

	if (check([0x47], {offset: 4}) && (check([0x47], {offset: 192}) || check([0x47], {offset: 196}))) {
		return {
			ext: 'mts',
			mime: 'video/mp2t'
		};
	}

	if (check([0x42, 0x4F, 0x4F, 0x4B, 0x4D, 0x4F, 0x42, 0x49], {offset: 60})) {
		return {
			ext: 'mobi',
			mime: 'application/x-mobipocket-ebook'
		};
	}

	if (check([0x44, 0x49, 0x43, 0x4D], {offset: 128})) {
		return {
			ext: 'dcm',
			mime: 'application/dicom'
		};
	}

	if (check([0x4C, 0x00, 0x00, 0x00, 0x01, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46])) {
		return {
			ext: 'lnk',
			mime: 'application/x.ms.shortcut' // Invented by us
		};
	}

	if (check([0x62, 0x6F, 0x6F, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x61, 0x72, 0x6B, 0x00, 0x00, 0x00, 0x00])) {
		return {
			ext: 'alias',
			mime: 'application/x.apple.alias' // Invented by us
		};
	}

	if (
		check([0x4C, 0x50], {offset: 34}) &&
		(
			check([0x00, 0x00, 0x01], {offset: 8}) ||
			check([0x01, 0x00, 0x02], {offset: 8}) ||
			check([0x02, 0x00, 0x02], {offset: 8})
		)
	) {
		return {
			ext: 'eot',
			mime: 'application/vnd.ms-fontobject'
		};
	}

	if (check([0x06, 0x06, 0xED, 0xF5, 0xD8, 0x1D, 0x46, 0xE5, 0xBD, 0x31, 0xEF, 0xE7, 0xFE, 0x74, 0xB7, 0x1D])) {
		return {
			ext: 'indd',
			mime: 'application/x-indesign'
		};
	}

	// Increase sample size from 256 to 512
	await tokenizer.peekBuffer(buffer, {length: Math.min(512, tokenizer.fileInfo.size), mayBeLess: true});

	// Requires a buffer size of 512 bytes
	if (tarHeaderChecksumMatches(buffer)) {
		return {
			ext: 'tar',
			mime: 'application/x-tar'
		};
	}

	if (check([0xFF, 0xFE, 0xFF, 0x0E, 0x53, 0x00, 0x6B, 0x00, 0x65, 0x00, 0x74, 0x00, 0x63, 0x00, 0x68, 0x00, 0x55, 0x00, 0x70, 0x00, 0x20, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6C, 0x00])) {
		return {
			ext: 'skp',
			mime: 'application/vnd.sketchup.skp'
		};
	}

	if (checkString('-----BEGIN PGP MESSAGE-----')) {
		return {
			ext: 'pgp',
			mime: 'application/pgp-encrypted'
		};
	}

	// Check MPEG 1 or 2 Layer 3 header, or 'layer 0' for ADTS (MPEG sync-word 0xFFE)
	if (buffer.length >= 2 && check([0xFF, 0xE0], {offset: 0, mask: [0xFF, 0xE0]})) {
		if (check([0x10], {offset: 1, mask: [0x16]})) {
			// Check for (ADTS) MPEG-2
			if (check([0x08], {offset: 1, mask: [0x08]})) {
				return {
					ext: 'aac',
					mime: 'audio/aac'
				};
			}

			// Must be (ADTS) MPEG-4
			return {
				ext: 'aac',
				mime: 'audio/aac'
			};
		}

		// MPEG 1 or 2 Layer 3 header
		// Check for MPEG layer 3
		if (check([0x02], {offset: 1, mask: [0x06]})) {
			return {
				ext: 'mp3',
				mime: 'audio/mpeg'
			};
		}

		// Check for MPEG layer 2
		if (check([0x04], {offset: 1, mask: [0x06]})) {
			return {
				ext: 'mp2',
				mime: 'audio/mpeg'
			};
		}

		// Check for MPEG layer 1
		if (check([0x06], {offset: 1, mask: [0x06]})) {
			return {
				ext: 'mp1',
				mime: 'audio/mpeg'
			};
		}
	}
}

const stream = readableStream => new Promise((resolve, reject) => {
	// Using `eval` to work around issues when bundling with Webpack
	const stream = eval('require')('stream'); // eslint-disable-line no-eval

	readableStream.on('error', reject);
	readableStream.once('readable', async () => {
		// Set up output stream
		const pass = new stream.PassThrough();
		let outputStream;
		if (stream.pipeline) {
			outputStream = stream.pipeline(readableStream, pass, () => {
			});
		} else {
			outputStream = readableStream.pipe(pass);
		}

		// Read the input stream and detect the filetype
		const chunk = readableStream.read(minimumBytes) || readableStream.read() || Buffer.alloc(0);
		try {
			const fileType = await fromBuffer(chunk);
			pass.fileType = fileType;
		} catch (error) {
			reject(error);
		}

		resolve(outputStream);
	});
});

const fileType$1 = {
	fromStream,
	fromTokenizer,
	fromBuffer,
	stream
};

Object.defineProperty(fileType$1, 'extensions', {
	get() {
		return new Set(supported.extensions);
	}
});

Object.defineProperty(fileType$1, 'mimeTypes', {
	get() {
		return new Set(supported.mimeTypes);
	}
});

var core$2 = fileType$1;

const strtok3 = lib$3;
const core$1 = core$2;

async function fromFile(path) {
	const tokenizer = await strtok3.fromFile(path);
	try {
		return await core$1.fromTokenizer(tokenizer);
	} finally {
		await tokenizer.close();
	}
}

const fileType = {
	fromFile
};

Object.assign(fileType, core$1);

Object.defineProperty(fileType, 'extensions', {
	get() {
		return core$1.extensions;
	}
});

Object.defineProperty(fileType, 'mimeTypes', {
	get() {
		return core$1.mimeTypes;
	}
});

var fileType_1 = fileType;

var isSvg$2 = {exports: {}};

var validator$2 = {};

var util$3 = {};

(function (exports) {

	const nameStartChar = ':A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD';
	const nameChar = nameStartChar + '\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040';
	const nameRegexp = '[' + nameStartChar + '][' + nameChar + ']*';
	const regexName = new RegExp('^' + nameRegexp + '$');

	const getAllMatches = function(string, regex) {
	  const matches = [];
	  let match = regex.exec(string);
	  while (match) {
	    const allmatches = [];
	    allmatches.startIndex = regex.lastIndex - match[0].length;
	    const len = match.length;
	    for (let index = 0; index < len; index++) {
	      allmatches.push(match[index]);
	    }
	    matches.push(allmatches);
	    match = regex.exec(string);
	  }
	  return matches;
	};

	const isName = function(string) {
	  const match = regexName.exec(string);
	  return !(match === null || typeof match === 'undefined');
	};

	exports.isExist = function(v) {
	  return typeof v !== 'undefined';
	};

	exports.isEmptyObject = function(obj) {
	  return Object.keys(obj).length === 0;
	};

	/**
	 * Copy all the properties of a into b.
	 * @param {*} target
	 * @param {*} a
	 */
	exports.merge = function(target, a, arrayMode) {
	  if (a) {
	    const keys = Object.keys(a); // will return an array of own properties
	    const len = keys.length; //don't make it inline
	    for (let i = 0; i < len; i++) {
	      if (arrayMode === 'strict') {
	        target[keys[i]] = [ a[keys[i]] ];
	      } else {
	        target[keys[i]] = a[keys[i]];
	      }
	    }
	  }
	};
	/* exports.merge =function (b,a){
	  return Object.assign(b,a);
	} */

	exports.getValue = function(v) {
	  if (exports.isExist(v)) {
	    return v;
	  } else {
	    return '';
	  }
	};

	// const fakeCall = function(a) {return a;};
	// const fakeCallNoReturn = function() {};

	exports.isName = isName;
	exports.getAllMatches = getAllMatches;
	exports.nameRegexp = nameRegexp; 
} (util$3));

const util$2 = util$3;

const defaultOptions$2 = {
  allowBooleanAttributes: false, //A tag can have attributes without any value
  unpairedTags: []
};

//const tagsPattern = new RegExp("<\\/?([\\w:\\-_\.]+)\\s*\/?>","g");
validator$2.validate = function (xmlData, options) {
  options = Object.assign({}, defaultOptions$2, options);

  //xmlData = xmlData.replace(/(\r\n|\n|\r)/gm,"");//make it single line
  //xmlData = xmlData.replace(/(^\s*<\?xml.*?\?>)/g,"");//Remove XML starting tag
  //xmlData = xmlData.replace(/(<!DOCTYPE[\s\w\"\.\/\-\:]+(\[.*\])*\s*>)/g,"");//Remove DOCTYPE
  const tags = [];
  let tagFound = false;

  //indicates that the root tag has been closed (aka. depth 0 has been reached)
  let reachedRoot = false;

  if (xmlData[0] === '\ufeff') {
    // check for byte order mark (BOM)
    xmlData = xmlData.substr(1);
  }
  
  for (let i = 0; i < xmlData.length; i++) {

    if (xmlData[i] === '<' && xmlData[i+1] === '?') {
      i+=2;
      i = readPI(xmlData,i);
      if (i.err) return i;
    }else if (xmlData[i] === '<') {
      //starting of tag
      //read until you reach to '>' avoiding any '>' in attribute value
      let tagStartPos = i;
      i++;
      
      if (xmlData[i] === '!') {
        i = readCommentAndCDATA(xmlData, i);
        continue;
      } else {
        let closingTag = false;
        if (xmlData[i] === '/') {
          //closing tag
          closingTag = true;
          i++;
        }
        //read tagname
        let tagName = '';
        for (; i < xmlData.length &&
          xmlData[i] !== '>' &&
          xmlData[i] !== ' ' &&
          xmlData[i] !== '\t' &&
          xmlData[i] !== '\n' &&
          xmlData[i] !== '\r'; i++
        ) {
          tagName += xmlData[i];
        }
        tagName = tagName.trim();
        //console.log(tagName);

        if (tagName[tagName.length - 1] === '/') {
          //self closing tag without attributes
          tagName = tagName.substring(0, tagName.length - 1);
          //continue;
          i--;
        }
        if (!validateTagName(tagName)) {
          let msg;
          if (tagName.trim().length === 0) {
            msg = "Invalid space after '<'.";
          } else {
            msg = "Tag '"+tagName+"' is an invalid name.";
          }
          return getErrorObject('InvalidTag', msg, getLineNumberForPosition(xmlData, i));
        }

        const result = readAttributeStr(xmlData, i);
        if (result === false) {
          return getErrorObject('InvalidAttr', "Attributes for '"+tagName+"' have open quote.", getLineNumberForPosition(xmlData, i));
        }
        let attrStr = result.value;
        i = result.index;

        if (attrStr[attrStr.length - 1] === '/') {
          //self closing tag
          const attrStrStart = i - attrStr.length;
          attrStr = attrStr.substring(0, attrStr.length - 1);
          const isValid = validateAttributeString(attrStr, options);
          if (isValid === true) {
            tagFound = true;
            //continue; //text may presents after self closing tag
          } else {
            //the result from the nested function returns the position of the error within the attribute
            //in order to get the 'true' error line, we need to calculate the position where the attribute begins (i - attrStr.length) and then add the position within the attribute
            //this gives us the absolute index in the entire xml, which we can use to find the line at last
            return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, attrStrStart + isValid.err.line));
          }
        } else if (closingTag) {
          if (!result.tagClosed) {
            return getErrorObject('InvalidTag', "Closing tag '"+tagName+"' doesn't have proper closing.", getLineNumberForPosition(xmlData, i));
          } else if (attrStr.trim().length > 0) {
            return getErrorObject('InvalidTag', "Closing tag '"+tagName+"' can't have attributes or invalid starting.", getLineNumberForPosition(xmlData, tagStartPos));
          } else {
            const otg = tags.pop();
            if (tagName !== otg.tagName) {
              let openPos = getLineNumberForPosition(xmlData, otg.tagStartPos);
              return getErrorObject('InvalidTag',
                "Expected closing tag '"+otg.tagName+"' (opened in line "+openPos.line+", col "+openPos.col+") instead of closing tag '"+tagName+"'.",
                getLineNumberForPosition(xmlData, tagStartPos));
            }

            //when there are no more tags, we reached the root level.
            if (tags.length == 0) {
              reachedRoot = true;
            }
          }
        } else {
          const isValid = validateAttributeString(attrStr, options);
          if (isValid !== true) {
            //the result from the nested function returns the position of the error within the attribute
            //in order to get the 'true' error line, we need to calculate the position where the attribute begins (i - attrStr.length) and then add the position within the attribute
            //this gives us the absolute index in the entire xml, which we can use to find the line at last
            return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, i - attrStr.length + isValid.err.line));
          }

          //if the root level has been reached before ...
          if (reachedRoot === true) {
            return getErrorObject('InvalidXml', 'Multiple possible root nodes found.', getLineNumberForPosition(xmlData, i));
          } else if(options.unpairedTags.indexOf(tagName) !== -1); else {
            tags.push({tagName, tagStartPos});
          }
          tagFound = true;
        }

        //skip tag text value
        //It may include comments and CDATA value
        for (i++; i < xmlData.length; i++) {
          if (xmlData[i] === '<') {
            if (xmlData[i + 1] === '!') {
              //comment or CADATA
              i++;
              i = readCommentAndCDATA(xmlData, i);
              continue;
            } else if (xmlData[i+1] === '?') {
              i = readPI(xmlData, ++i);
              if (i.err) return i;
            } else {
              break;
            }
          } else if (xmlData[i] === '&') {
            const afterAmp = validateAmpersand(xmlData, i);
            if (afterAmp == -1)
              return getErrorObject('InvalidChar', "char '&' is not expected.", getLineNumberForPosition(xmlData, i));
            i = afterAmp;
          }else {
            if (reachedRoot === true && !isWhiteSpace(xmlData[i])) {
              return getErrorObject('InvalidXml', "Extra text at the end", getLineNumberForPosition(xmlData, i));
            }
          }
        } //end of reading tag text value
        if (xmlData[i] === '<') {
          i--;
        }
      }
    } else {
      if ( isWhiteSpace(xmlData[i])) {
        continue;
      }
      return getErrorObject('InvalidChar', "char '"+xmlData[i]+"' is not expected.", getLineNumberForPosition(xmlData, i));
    }
  }

  if (!tagFound) {
    return getErrorObject('InvalidXml', 'Start tag expected.', 1);
  }else if (tags.length == 1) {
      return getErrorObject('InvalidTag', "Unclosed tag '"+tags[0].tagName+"'.", getLineNumberForPosition(xmlData, tags[0].tagStartPos));
  }else if (tags.length > 0) {
      return getErrorObject('InvalidXml', "Invalid '"+
          JSON.stringify(tags.map(t => t.tagName), null, 4).replace(/\r?\n/g, '')+
          "' found.", {line: 1, col: 1});
  }

  return true;
};

function isWhiteSpace(char){
  return char === ' ' || char === '\t' || char === '\n'  || char === '\r';
}
/**
 * Read Processing insstructions and skip
 * @param {*} xmlData
 * @param {*} i
 */
function readPI(xmlData, i) {
  const start = i;
  for (; i < xmlData.length; i++) {
    if (xmlData[i] == '?' || xmlData[i] == ' ') {
      //tagname
      const tagname = xmlData.substr(start, i - start);
      if (i > 5 && tagname === 'xml') {
        return getErrorObject('InvalidXml', 'XML declaration allowed only at the start of the document.', getLineNumberForPosition(xmlData, i));
      } else if (xmlData[i] == '?' && xmlData[i + 1] == '>') {
        //check if valid attribut string
        i++;
        break;
      } else {
        continue;
      }
    }
  }
  return i;
}

function readCommentAndCDATA(xmlData, i) {
  if (xmlData.length > i + 5 && xmlData[i + 1] === '-' && xmlData[i + 2] === '-') {
    //comment
    for (i += 3; i < xmlData.length; i++) {
      if (xmlData[i] === '-' && xmlData[i + 1] === '-' && xmlData[i + 2] === '>') {
        i += 2;
        break;
      }
    }
  } else if (
    xmlData.length > i + 8 &&
    xmlData[i + 1] === 'D' &&
    xmlData[i + 2] === 'O' &&
    xmlData[i + 3] === 'C' &&
    xmlData[i + 4] === 'T' &&
    xmlData[i + 5] === 'Y' &&
    xmlData[i + 6] === 'P' &&
    xmlData[i + 7] === 'E'
  ) {
    let angleBracketsCount = 1;
    for (i += 8; i < xmlData.length; i++) {
      if (xmlData[i] === '<') {
        angleBracketsCount++;
      } else if (xmlData[i] === '>') {
        angleBracketsCount--;
        if (angleBracketsCount === 0) {
          break;
        }
      }
    }
  } else if (
    xmlData.length > i + 9 &&
    xmlData[i + 1] === '[' &&
    xmlData[i + 2] === 'C' &&
    xmlData[i + 3] === 'D' &&
    xmlData[i + 4] === 'A' &&
    xmlData[i + 5] === 'T' &&
    xmlData[i + 6] === 'A' &&
    xmlData[i + 7] === '['
  ) {
    for (i += 8; i < xmlData.length; i++) {
      if (xmlData[i] === ']' && xmlData[i + 1] === ']' && xmlData[i + 2] === '>') {
        i += 2;
        break;
      }
    }
  }

  return i;
}

const doubleQuote = '"';
const singleQuote = "'";

/**
 * Keep reading xmlData until '<' is found outside the attribute value.
 * @param {string} xmlData
 * @param {number} i
 */
function readAttributeStr(xmlData, i) {
  let attrStr = '';
  let startChar = '';
  let tagClosed = false;
  for (; i < xmlData.length; i++) {
    if (xmlData[i] === doubleQuote || xmlData[i] === singleQuote) {
      if (startChar === '') {
        startChar = xmlData[i];
      } else if (startChar !== xmlData[i]) ; else {
        startChar = '';
      }
    } else if (xmlData[i] === '>') {
      if (startChar === '') {
        tagClosed = true;
        break;
      }
    }
    attrStr += xmlData[i];
  }
  if (startChar !== '') {
    return false;
  }

  return {
    value: attrStr,
    index: i,
    tagClosed: tagClosed
  };
}

/**
 * Select all the attributes whether valid or invalid.
 */
const validAttrStrRegxp = new RegExp('(\\s*)([^\\s=]+)(\\s*=)?(\\s*([\'"])(([\\s\\S])*?)\\5)?', 'g');

//attr, ="sd", a="amit's", a="sd"b="saf", ab  cd=""

function validateAttributeString(attrStr, options) {
  //console.log("start:"+attrStr+":end");

  //if(attrStr.trim().length === 0) return true; //empty string

  const matches = util$2.getAllMatches(attrStr, validAttrStrRegxp);
  const attrNames = {};

  for (let i = 0; i < matches.length; i++) {
    if (matches[i][1].length === 0) {
      //nospace before attribute name: a="sd"b="saf"
      return getErrorObject('InvalidAttr', "Attribute '"+matches[i][2]+"' has no space in starting.", getPositionFromMatch(matches[i]))
    } else if (matches[i][3] !== undefined && matches[i][4] === undefined) {
      return getErrorObject('InvalidAttr', "Attribute '"+matches[i][2]+"' is without value.", getPositionFromMatch(matches[i]));
    } else if (matches[i][3] === undefined && !options.allowBooleanAttributes) {
      //independent attribute: ab
      return getErrorObject('InvalidAttr', "boolean attribute '"+matches[i][2]+"' is not allowed.", getPositionFromMatch(matches[i]));
    }
    /* else if(matches[i][6] === undefined){//attribute without value: ab=
                    return { err: { code:"InvalidAttr",msg:"attribute " + matches[i][2] + " has no value assigned."}};
                } */
    const attrName = matches[i][2];
    if (!validateAttrName(attrName)) {
      return getErrorObject('InvalidAttr', "Attribute '"+attrName+"' is an invalid name.", getPositionFromMatch(matches[i]));
    }
    if (!attrNames.hasOwnProperty(attrName)) {
      //check for duplicate attribute.
      attrNames[attrName] = 1;
    } else {
      return getErrorObject('InvalidAttr', "Attribute '"+attrName+"' is repeated.", getPositionFromMatch(matches[i]));
    }
  }

  return true;
}

function validateNumberAmpersand(xmlData, i) {
  let re = /\d/;
  if (xmlData[i] === 'x') {
    i++;
    re = /[\da-fA-F]/;
  }
  for (; i < xmlData.length; i++) {
    if (xmlData[i] === ';')
      return i;
    if (!xmlData[i].match(re))
      break;
  }
  return -1;
}

function validateAmpersand(xmlData, i) {
  // https://www.w3.org/TR/xml/#dt-charref
  i++;
  if (xmlData[i] === ';')
    return -1;
  if (xmlData[i] === '#') {
    i++;
    return validateNumberAmpersand(xmlData, i);
  }
  let count = 0;
  for (; i < xmlData.length; i++, count++) {
    if (xmlData[i].match(/\w/) && count < 20)
      continue;
    if (xmlData[i] === ';')
      break;
    return -1;
  }
  return i;
}

function getErrorObject(code, message, lineNumber) {
  return {
    err: {
      code: code,
      msg: message,
      line: lineNumber.line || lineNumber,
      col: lineNumber.col,
    },
  };
}

function validateAttrName(attrName) {
  return util$2.isName(attrName);
}

// const startsWithXML = /^xml/i;

function validateTagName(tagname) {
  return util$2.isName(tagname) /* && !tagname.match(startsWithXML) */;
}

//this function returns the line number for the character at the given index
function getLineNumberForPosition(xmlData, index) {
  const lines = xmlData.substring(0, index).split(/\r?\n/);
  return {
    line: lines.length,

    // column number is last line's length + 1, because column numbering starts at 1:
    col: lines[lines.length - 1].length + 1
  };
}

//this function returns the position of the first character of match within attrStr
function getPositionFromMatch(match) {
  return match.startIndex + match[1].length;
}

var OptionsBuilder = {};

const defaultOptions$1 = {
    preserveOrder: false,
    attributeNamePrefix: '@_',
    attributesGroupName: false,
    textNodeName: '#text',
    ignoreAttributes: true,
    removeNSPrefix: false, // remove NS from tag name or attribute name if true
    allowBooleanAttributes: false, //a tag can have attributes without any value
    //ignoreRootElement : false,
    parseTagValue: true,
    parseAttributeValue: false,
    trimValues: true, //Trim string values of tag and attributes
    cdataPropName: false,
    numberParseOptions: {
      hex: true,
      leadingZeros: true,
      eNotation: true
    },
    tagValueProcessor: function(tagName, val) {
      return val;
    },
    attributeValueProcessor: function(attrName, val) {
      return val;
    },
    stopNodes: [], //nested tags will not be parsed even for errors
    alwaysCreateTextNode: false,
    isArray: () => false,
    commentPropName: false,
    unpairedTags: [],
    processEntities: true,
    htmlEntities: false,
    ignoreDeclaration: false,
    ignorePiTags: false,
    transformTagName: false,
    transformAttributeName: false,
    updateTag: function(tagName, jPath, attrs){
      return tagName
    },
    // skipEmptyListItem: false
};
   
const buildOptions$1 = function(options) {
    return Object.assign({}, defaultOptions$1, options);
};

OptionsBuilder.buildOptions = buildOptions$1;
OptionsBuilder.defaultOptions = defaultOptions$1;

class XmlNode{
  constructor(tagname) {
    this.tagname = tagname;
    this.child = []; //nested tags, text, cdata, comments in order
    this[":@"] = {}; //attributes map
  }
  add(key,val){
    // this.child.push( {name : key, val: val, isCdata: isCdata });
    if(key === "__proto__") key = "#__proto__";
    this.child.push( {[key]: val });
  }
  addChild(node) {
    if(node.tagname === "__proto__") node.tagname = "#__proto__";
    if(node[":@"] && Object.keys(node[":@"]).length > 0){
      this.child.push( { [node.tagname]: node.child, [":@"]: node[":@"] });
    }else {
      this.child.push( { [node.tagname]: node.child });
    }
  };
}

var xmlNode$1 = XmlNode;

const util$1 = util$3;

//TODO: handle comments
function readDocType$1(xmlData, i){
    
    const entities = {};
    if( xmlData[i + 3] === 'O' &&
         xmlData[i + 4] === 'C' &&
         xmlData[i + 5] === 'T' &&
         xmlData[i + 6] === 'Y' &&
         xmlData[i + 7] === 'P' &&
         xmlData[i + 8] === 'E')
    {    
        i = i+9;
        let angleBracketsCount = 1;
        let hasBody = false, comment = false;
        let exp = "";
        for(;i<xmlData.length;i++){
            if (xmlData[i] === '<' && !comment) { //Determine the tag type
                if( hasBody && isEntity(xmlData, i)){
                    i += 7; 
                    [entityName, val,i] = readEntityExp(xmlData,i+1);
                    if(val.indexOf("&") === -1) //Parameter entities are not supported
                        entities[ validateEntityName(entityName) ] = {
                            regx : RegExp( `&${entityName};`,"g"),
                            val: val
                        };
                }
                else if( hasBody && isElement(xmlData, i))  i += 8;//Not supported
                else if( hasBody && isAttlist(xmlData, i))  i += 8;//Not supported
                else if( hasBody && isNotation(xmlData, i)) i += 9;//Not supported
                else if( isComment)                         comment = true;
                else                                        throw new Error("Invalid DOCTYPE");

                angleBracketsCount++;
                exp = "";
            } else if (xmlData[i] === '>') { //Read tag content
                if(comment){
                    if( xmlData[i - 1] === "-" && xmlData[i - 2] === "-"){
                        comment = false;
                        angleBracketsCount--;
                    }
                }else {
                    angleBracketsCount--;
                }
                if (angleBracketsCount === 0) {
                  break;
                }
            }else if( xmlData[i] === '['){
                hasBody = true;
            }else {
                exp += xmlData[i];
            }
        }
        if(angleBracketsCount !== 0){
            throw new Error(`Unclosed DOCTYPE`);
        }
    }else {
        throw new Error(`Invalid Tag instead of DOCTYPE`);
    }
    return {entities, i};
}

function readEntityExp(xmlData,i){
    //External entities are not supported
    //    <!ENTITY ext SYSTEM "http://normal-website.com" >

    //Parameter entities are not supported
    //    <!ENTITY entityname "&anotherElement;">

    //Internal entities are supported
    //    <!ENTITY entityname "replacement text">
    
    //read EntityName
    let entityName = "";
    for (; i < xmlData.length && (xmlData[i] !== "'" && xmlData[i] !== '"' ); i++) {
        // if(xmlData[i] === " ") continue;
        // else 
        entityName += xmlData[i];
    }
    entityName = entityName.trim();
    if(entityName.indexOf(" ") !== -1) throw new Error("External entites are not supported");

    //read Entity Value
    const startChar = xmlData[i++];
    let val = "";
    for (; i < xmlData.length && xmlData[i] !== startChar ; i++) {
        val += xmlData[i];
    }
    return [entityName, val, i];
}

function isComment(xmlData, i){
    if(xmlData[i+1] === '!' &&
    xmlData[i+2] === '-' &&
    xmlData[i+3] === '-') return true
    return false
}
function isEntity(xmlData, i){
    if(xmlData[i+1] === '!' &&
    xmlData[i+2] === 'E' &&
    xmlData[i+3] === 'N' &&
    xmlData[i+4] === 'T' &&
    xmlData[i+5] === 'I' &&
    xmlData[i+6] === 'T' &&
    xmlData[i+7] === 'Y') return true
    return false
}
function isElement(xmlData, i){
    if(xmlData[i+1] === '!' &&
    xmlData[i+2] === 'E' &&
    xmlData[i+3] === 'L' &&
    xmlData[i+4] === 'E' &&
    xmlData[i+5] === 'M' &&
    xmlData[i+6] === 'E' &&
    xmlData[i+7] === 'N' &&
    xmlData[i+8] === 'T') return true
    return false
}

function isAttlist(xmlData, i){
    if(xmlData[i+1] === '!' &&
    xmlData[i+2] === 'A' &&
    xmlData[i+3] === 'T' &&
    xmlData[i+4] === 'T' &&
    xmlData[i+5] === 'L' &&
    xmlData[i+6] === 'I' &&
    xmlData[i+7] === 'S' &&
    xmlData[i+8] === 'T') return true
    return false
}
function isNotation(xmlData, i){
    if(xmlData[i+1] === '!' &&
    xmlData[i+2] === 'N' &&
    xmlData[i+3] === 'O' &&
    xmlData[i+4] === 'T' &&
    xmlData[i+5] === 'A' &&
    xmlData[i+6] === 'T' &&
    xmlData[i+7] === 'I' &&
    xmlData[i+8] === 'O' &&
    xmlData[i+9] === 'N') return true
    return false
}

function validateEntityName(name){
    if (util$1.isName(name))
	return name;
    else
        throw new Error(`Invalid entity name ${name}`);
}

var DocTypeReader = readDocType$1;

const hexRegex = /^[-+]?0x[a-fA-F0-9]+$/;
const numRegex = /^([\-\+])?(0*)(\.[0-9]+([eE]\-?[0-9]+)?|[0-9]+(\.[0-9]+([eE]\-?[0-9]+)?)?)$/;
// const octRegex = /0x[a-z0-9]+/;
// const binRegex = /0x[a-z0-9]+/;


//polyfill
if (!Number.parseInt && window.parseInt) {
    Number.parseInt = window.parseInt;
}
if (!Number.parseFloat && window.parseFloat) {
    Number.parseFloat = window.parseFloat;
}

  
const consider = {
    hex :  true,
    leadingZeros: true,
    decimalPoint: "\.",
    eNotation: true
    //skipLike: /regex/
};

function toNumber$1(str, options = {}){
    // const options = Object.assign({}, consider);
    // if(opt.leadingZeros === false){
    //     options.leadingZeros = false;
    // }else if(opt.hex === false){
    //     options.hex = false;
    // }

    options = Object.assign({}, consider, options );
    if(!str || typeof str !== "string" ) return str;
    
    let trimmedStr  = str.trim();
    // if(trimmedStr === "0.0") return 0;
    // else if(trimmedStr === "+0.0") return 0;
    // else if(trimmedStr === "-0.0") return -0;

    if(options.skipLike !== undefined && options.skipLike.test(trimmedStr)) return str;
    else if (options.hex && hexRegex.test(trimmedStr)) {
        return Number.parseInt(trimmedStr, 16);
    // } else if (options.parseOct && octRegex.test(str)) {
    //     return Number.parseInt(val, 8);
    // }else if (options.parseBin && binRegex.test(str)) {
    //     return Number.parseInt(val, 2);
    }else {
        //separate negative sign, leading zeros, and rest number
        const match = numRegex.exec(trimmedStr);
        if(match){
            const sign = match[1];
            const leadingZeros = match[2];
            let numTrimmedByZeros = trimZeros(match[3]); //complete num without leading zeros
            //trim ending zeros for floating number
            
            const eNotation = match[4] || match[6];
            if(!options.leadingZeros && leadingZeros.length > 0 && sign && trimmedStr[2] !== ".") return str; //-0123
            else if(!options.leadingZeros && leadingZeros.length > 0 && !sign && trimmedStr[1] !== ".") return str; //0123
            else {//no leading zeros or leading zeros are allowed
                const num = Number(trimmedStr);
                const numStr = "" + num;
                if(numStr.search(/[eE]/) !== -1){ //given number is long and parsed to eNotation
                    if(options.eNotation) return num;
                    else return str;
                }else if(eNotation){ //given number has enotation
                    if(options.eNotation) return num;
                    else return str;
                }else if(trimmedStr.indexOf(".") !== -1){ //floating number
                    // const decimalPart = match[5].substr(1);
                    // const intPart = trimmedStr.substr(0,trimmedStr.indexOf("."));

                    
                    // const p = numStr.indexOf(".");
                    // const givenIntPart = numStr.substr(0,p);
                    // const givenDecPart = numStr.substr(p+1);
                    if(numStr === "0" && (numTrimmedByZeros === "") ) return num; //0.0
                    else if(numStr === numTrimmedByZeros) return num; //0.456. 0.79000
                    else if( sign && numStr === "-"+numTrimmedByZeros) return num;
                    else return str;
                }
                
                if(leadingZeros){
                    // if(numTrimmedByZeros === numStr){
                    //     if(options.leadingZeros) return num;
                    //     else return str;
                    // }else return str;
                    if(numTrimmedByZeros === numStr) return num;
                    else if(sign+numTrimmedByZeros === numStr) return num;
                    else return str;
                }

                if(trimmedStr === numStr) return num;
                else if(trimmedStr === sign+numStr) return num;
                // else{
                //     //number with +/- sign
                //     trimmedStr.test(/[-+][0-9]);

                // }
                return str;
            }
            // else if(!eNotation && trimmedStr && trimmedStr !== Number(trimmedStr) ) return str;
            
        }else { //non-numeric string
            return str;
        }
    }
}

/**
 * 
 * @param {string} numStr without leading zeros
 * @returns 
 */
function trimZeros(numStr){
    if(numStr && numStr.indexOf(".") !== -1){//float
        numStr = numStr.replace(/0+$/, ""); //remove ending zeros
        if(numStr === ".")  numStr = "0";
        else if(numStr[0] === ".")  numStr = "0"+numStr;
        else if(numStr[numStr.length-1] === ".")  numStr = numStr.substr(0,numStr.length-1);
        return numStr;
    }
    return numStr;
}
var strnum = toNumber$1;

///@ts-check

const util = util$3;
const xmlNode = xmlNode$1;
const readDocType = DocTypeReader;
const toNumber = strnum;

'<((!\\[CDATA\\[([\\s\\S]*?)(]]>))|((NAME:)?(NAME))([^>]*)>|((\\/)(NAME)\\s*>))([^<]*)'
  .replace(/NAME/g, util.nameRegexp);

//const tagsRegx = new RegExp("<(\\/?[\\w:\\-\._]+)([^>]*)>(\\s*"+cdataRegx+")*([^<]+)?","g");
//const tagsRegx = new RegExp("<(\\/?)((\\w*:)?([\\w:\\-\._]+))([^>]*)>([^<]*)("+cdataRegx+"([^<]*))*([^<]+)?","g");

class OrderedObjParser$1{
  constructor(options){
    this.options = options;
    this.currentNode = null;
    this.tagsNodeStack = [];
    this.docTypeEntities = {};
    this.lastEntities = {
      "apos" : { regex: /&(apos|#39|#x27);/g, val : "'"},
      "gt" : { regex: /&(gt|#62|#x3E);/g, val : ">"},
      "lt" : { regex: /&(lt|#60|#x3C);/g, val : "<"},
      "quot" : { regex: /&(quot|#34|#x22);/g, val : "\""},
    };
    this.ampEntity = { regex: /&(amp|#38|#x26);/g, val : "&"};
    this.htmlEntities = {
      "space": { regex: /&(nbsp|#160);/g, val: " " },
      // "lt" : { regex: /&(lt|#60);/g, val: "<" },
      // "gt" : { regex: /&(gt|#62);/g, val: ">" },
      // "amp" : { regex: /&(amp|#38);/g, val: "&" },
      // "quot" : { regex: /&(quot|#34);/g, val: "\"" },
      // "apos" : { regex: /&(apos|#39);/g, val: "'" },
      "cent" : { regex: /&(cent|#162);/g, val: "¢" },
      "pound" : { regex: /&(pound|#163);/g, val: "£" },
      "yen" : { regex: /&(yen|#165);/g, val: "¥" },
      "euro" : { regex: /&(euro|#8364);/g, val: "€" },
      "copyright" : { regex: /&(copy|#169);/g, val: "©" },
      "reg" : { regex: /&(reg|#174);/g, val: "®" },
      "inr" : { regex: /&(inr|#8377);/g, val: "₹" },
    };
    this.addExternalEntities = addExternalEntities;
    this.parseXml = parseXml;
    this.parseTextData = parseTextData;
    this.resolveNameSpace = resolveNameSpace;
    this.buildAttributesMap = buildAttributesMap;
    this.isItStopNode = isItStopNode;
    this.replaceEntitiesValue = replaceEntitiesValue$1;
    this.readStopNodeData = readStopNodeData;
    this.saveTextToParentTag = saveTextToParentTag;
    this.addChild = addChild;
  }

}

function addExternalEntities(externalEntities){
  const entKeys = Object.keys(externalEntities);
  for (let i = 0; i < entKeys.length; i++) {
    const ent = entKeys[i];
    this.lastEntities[ent] = {
       regex: new RegExp("&"+ent+";","g"),
       val : externalEntities[ent]
    };
  }
}

/**
 * @param {string} val
 * @param {string} tagName
 * @param {string} jPath
 * @param {boolean} dontTrim
 * @param {boolean} hasAttributes
 * @param {boolean} isLeafNode
 * @param {boolean} escapeEntities
 */
function parseTextData(val, tagName, jPath, dontTrim, hasAttributes, isLeafNode, escapeEntities) {
  if (val !== undefined) {
    if (this.options.trimValues && !dontTrim) {
      val = val.trim();
    }
    if(val.length > 0){
      if(!escapeEntities) val = this.replaceEntitiesValue(val);
      
      const newval = this.options.tagValueProcessor(tagName, val, jPath, hasAttributes, isLeafNode);
      if(newval === null || newval === undefined){
        //don't parse
        return val;
      }else if(typeof newval !== typeof val || newval !== val){
        //overwrite
        return newval;
      }else if(this.options.trimValues){
        return parseValue(val, this.options.parseTagValue, this.options.numberParseOptions);
      }else {
        const trimmedVal = val.trim();
        if(trimmedVal === val){
          return parseValue(val, this.options.parseTagValue, this.options.numberParseOptions);
        }else {
          return val;
        }
      }
    }
  }
}

function resolveNameSpace(tagname) {
  if (this.options.removeNSPrefix) {
    const tags = tagname.split(':');
    const prefix = tagname.charAt(0) === '/' ? '/' : '';
    if (tags[0] === 'xmlns') {
      return '';
    }
    if (tags.length === 2) {
      tagname = prefix + tags[1];
    }
  }
  return tagname;
}

//TODO: change regex to capture NS
//const attrsRegx = new RegExp("([\\w\\-\\.\\:]+)\\s*=\\s*(['\"])((.|\n)*?)\\2","gm");
const attrsRegx = new RegExp('([^\\s=]+)\\s*(=\\s*([\'"])([\\s\\S]*?)\\3)?', 'gm');

function buildAttributesMap(attrStr, jPath, tagName) {
  if (!this.options.ignoreAttributes && typeof attrStr === 'string') {
    // attrStr = attrStr.replace(/\r?\n/g, ' ');
    //attrStr = attrStr || attrStr.trim();

    const matches = util.getAllMatches(attrStr, attrsRegx);
    const len = matches.length; //don't make it inline
    const attrs = {};
    for (let i = 0; i < len; i++) {
      const attrName = this.resolveNameSpace(matches[i][1]);
      let oldVal = matches[i][4];
      let aName = this.options.attributeNamePrefix + attrName;
      if (attrName.length) {
        if (this.options.transformAttributeName) {
          aName = this.options.transformAttributeName(aName);
        }
        if(aName === "__proto__") aName  = "#__proto__";
        if (oldVal !== undefined) {
          if (this.options.trimValues) {
            oldVal = oldVal.trim();
          }
          oldVal = this.replaceEntitiesValue(oldVal);
          const newVal = this.options.attributeValueProcessor(attrName, oldVal, jPath);
          if(newVal === null || newVal === undefined){
            //don't parse
            attrs[aName] = oldVal;
          }else if(typeof newVal !== typeof oldVal || newVal !== oldVal){
            //overwrite
            attrs[aName] = newVal;
          }else {
            //parse
            attrs[aName] = parseValue(
              oldVal,
              this.options.parseAttributeValue,
              this.options.numberParseOptions
            );
          }
        } else if (this.options.allowBooleanAttributes) {
          attrs[aName] = true;
        }
      }
    }
    if (!Object.keys(attrs).length) {
      return;
    }
    if (this.options.attributesGroupName) {
      const attrCollection = {};
      attrCollection[this.options.attributesGroupName] = attrs;
      return attrCollection;
    }
    return attrs
  }
}

const parseXml = function(xmlData) {
  xmlData = xmlData.replace(/\r\n?/g, "\n"); //TODO: remove this line
  const xmlObj = new xmlNode('!xml');
  let currentNode = xmlObj;
  let textData = "";
  let jPath = "";
  for(let i=0; i< xmlData.length; i++){//for each char in XML data
    const ch = xmlData[i];
    if(ch === '<'){
      // const nextIndex = i+1;
      // const _2ndChar = xmlData[nextIndex];
      if( xmlData[i+1] === '/') {//Closing Tag
        const closeIndex = findClosingIndex(xmlData, ">", i, "Closing Tag is not closed.");
        let tagName = xmlData.substring(i+2,closeIndex).trim();

        if(this.options.removeNSPrefix){
          const colonIndex = tagName.indexOf(":");
          if(colonIndex !== -1){
            tagName = tagName.substr(colonIndex+1);
          }
        }

        if(this.options.transformTagName) {
          tagName = this.options.transformTagName(tagName);
        }

        if(currentNode){
          textData = this.saveTextToParentTag(textData, currentNode, jPath);
        }

        //check if last tag of nested tag was unpaired tag
        const lastTagName = jPath.substring(jPath.lastIndexOf(".")+1);
        if(tagName && this.options.unpairedTags.indexOf(tagName) !== -1 ){
          throw new Error(`Unpaired tag can not be used as closing tag: </${tagName}>`);
        }
        let propIndex = 0;
        if(lastTagName && this.options.unpairedTags.indexOf(lastTagName) !== -1 ){
          propIndex = jPath.lastIndexOf('.', jPath.lastIndexOf('.')-1);
          this.tagsNodeStack.pop();
        }else {
          propIndex = jPath.lastIndexOf(".");
        }
        jPath = jPath.substring(0, propIndex);

        currentNode = this.tagsNodeStack.pop();//avoid recursion, set the parent tag scope
        textData = "";
        i = closeIndex;
      } else if( xmlData[i+1] === '?') {

        let tagData = readTagExp(xmlData,i, false, "?>");
        if(!tagData) throw new Error("Pi Tag is not closed.");

        textData = this.saveTextToParentTag(textData, currentNode, jPath);
        if( (this.options.ignoreDeclaration && tagData.tagName === "?xml") || this.options.ignorePiTags);else {
  
          const childNode = new xmlNode(tagData.tagName);
          childNode.add(this.options.textNodeName, "");
          
          if(tagData.tagName !== tagData.tagExp && tagData.attrExpPresent){
            childNode[":@"] = this.buildAttributesMap(tagData.tagExp, jPath, tagData.tagName);
          }
          this.addChild(currentNode, childNode, jPath);

        }


        i = tagData.closeIndex + 1;
      } else if(xmlData.substr(i + 1, 3) === '!--') {
        const endIndex = findClosingIndex(xmlData, "-->", i+4, "Comment is not closed.");
        if(this.options.commentPropName){
          const comment = xmlData.substring(i + 4, endIndex - 2);

          textData = this.saveTextToParentTag(textData, currentNode, jPath);

          currentNode.add(this.options.commentPropName, [ { [this.options.textNodeName] : comment } ]);
        }
        i = endIndex;
      } else if( xmlData.substr(i + 1, 2) === '!D') {
        const result = readDocType(xmlData, i);
        this.docTypeEntities = result.entities;
        i = result.i;
      }else if(xmlData.substr(i + 1, 2) === '![') {
        const closeIndex = findClosingIndex(xmlData, "]]>", i, "CDATA is not closed.") - 2;
        const tagExp = xmlData.substring(i + 9,closeIndex);

        textData = this.saveTextToParentTag(textData, currentNode, jPath);

        //cdata should be set even if it is 0 length string
        if(this.options.cdataPropName){
          // let val = this.parseTextData(tagExp, this.options.cdataPropName, jPath + "." + this.options.cdataPropName, true, false, true);
          // if(!val) val = "";
          currentNode.add(this.options.cdataPropName, [ { [this.options.textNodeName] : tagExp } ]);
        }else {
          let val = this.parseTextData(tagExp, currentNode.tagname, jPath, true, false, true);
          if(val == undefined) val = "";
          currentNode.add(this.options.textNodeName, val);
        }
        
        i = closeIndex + 2;
      }else {//Opening tag
        let result = readTagExp(xmlData,i, this.options.removeNSPrefix);
        let tagName= result.tagName;
        const rawTagName = result.rawTagName;
        let tagExp = result.tagExp;
        let attrExpPresent = result.attrExpPresent;
        let closeIndex = result.closeIndex;

        if (this.options.transformTagName) {
          tagName = this.options.transformTagName(tagName);
        }
        
        //save text as child node
        if (currentNode && textData) {
          if(currentNode.tagname !== '!xml'){
            //when nested tag is found
            textData = this.saveTextToParentTag(textData, currentNode, jPath, false);
          }
        }

        //check if last tag was unpaired tag
        const lastTag = currentNode;
        if(lastTag && this.options.unpairedTags.indexOf(lastTag.tagname) !== -1 ){
          currentNode = this.tagsNodeStack.pop();
          jPath = jPath.substring(0, jPath.lastIndexOf("."));
        }
        if(tagName !== xmlObj.tagname){
          jPath += jPath ? "." + tagName : tagName;
        }
        if (this.isItStopNode(this.options.stopNodes, jPath, tagName)) {
          let tagContent = "";
          //self-closing tag
          if(tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1){
            i = result.closeIndex;
          }
          //unpaired tag
          else if(this.options.unpairedTags.indexOf(tagName) !== -1){
            i = result.closeIndex;
          }
          //normal tag
          else {
            //read until closing tag is found
            const result = this.readStopNodeData(xmlData, rawTagName, closeIndex + 1);
            if(!result) throw new Error(`Unexpected end of ${rawTagName}`);
            i = result.i;
            tagContent = result.tagContent;
          }

          const childNode = new xmlNode(tagName);
          if(tagName !== tagExp && attrExpPresent){
            childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
          }
          if(tagContent) {
            tagContent = this.parseTextData(tagContent, tagName, jPath, true, attrExpPresent, true, true);
          }
          
          jPath = jPath.substr(0, jPath.lastIndexOf("."));
          childNode.add(this.options.textNodeName, tagContent);
          
          this.addChild(currentNode, childNode, jPath);
        }else {
  //selfClosing tag
          if(tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1){
            if(tagName[tagName.length - 1] === "/"){ //remove trailing '/'
              tagName = tagName.substr(0, tagName.length - 1);
              jPath = jPath.substr(0, jPath.length - 1);
              tagExp = tagName;
            }else {
              tagExp = tagExp.substr(0, tagExp.length - 1);
            }
            
            if(this.options.transformTagName) {
              tagName = this.options.transformTagName(tagName);
            }

            const childNode = new xmlNode(tagName);
            if(tagName !== tagExp && attrExpPresent){
              childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
            }
            this.addChild(currentNode, childNode, jPath);
            jPath = jPath.substr(0, jPath.lastIndexOf("."));
          }
    //opening tag
          else {
            const childNode = new xmlNode( tagName);
            this.tagsNodeStack.push(currentNode);
            
            if(tagName !== tagExp && attrExpPresent){
              childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
            }
            this.addChild(currentNode, childNode, jPath);
            currentNode = childNode;
          }
          textData = "";
          i = closeIndex;
        }
      }
    }else {
      textData += xmlData[i];
    }
  }
  return xmlObj.child;
};

function addChild(currentNode, childNode, jPath){
  const result = this.options.updateTag(childNode.tagname, jPath, childNode[":@"]);
  if(result === false);else if(typeof result === "string"){
    childNode.tagname = result;
    currentNode.addChild(childNode);
  }else {
    currentNode.addChild(childNode);
  }
}

const replaceEntitiesValue$1 = function(val){

  if(this.options.processEntities){
    for(let entityName in this.docTypeEntities){
      const entity = this.docTypeEntities[entityName];
      val = val.replace( entity.regx, entity.val);
    }
    for(let entityName in this.lastEntities){
      const entity = this.lastEntities[entityName];
      val = val.replace( entity.regex, entity.val);
    }
    if(this.options.htmlEntities){
      for(let entityName in this.htmlEntities){
        const entity = this.htmlEntities[entityName];
        val = val.replace( entity.regex, entity.val);
      }
    }
    val = val.replace( this.ampEntity.regex, this.ampEntity.val);
  }
  return val;
};
function saveTextToParentTag(textData, currentNode, jPath, isLeafNode) {
  if (textData) { //store previously collected data as textNode
    if(isLeafNode === undefined) isLeafNode = Object.keys(currentNode.child).length === 0;
    
    textData = this.parseTextData(textData,
      currentNode.tagname,
      jPath,
      false,
      currentNode[":@"] ? Object.keys(currentNode[":@"]).length !== 0 : false,
      isLeafNode);

    if (textData !== undefined && textData !== "")
      currentNode.add(this.options.textNodeName, textData);
    textData = "";
  }
  return textData;
}

//TODO: use jPath to simplify the logic
/**
 * 
 * @param {string[]} stopNodes 
 * @param {string} jPath
 * @param {string} currentTagName 
 */
function isItStopNode(stopNodes, jPath, currentTagName){
  const allNodesExp = "*." + currentTagName;
  for (const stopNodePath in stopNodes) {
    const stopNodeExp = stopNodes[stopNodePath];
    if( allNodesExp === stopNodeExp || jPath === stopNodeExp  ) return true;
  }
  return false;
}

/**
 * Returns the tag Expression and where it is ending handling single-double quotes situation
 * @param {string} xmlData 
 * @param {number} i starting index
 * @returns 
 */
function tagExpWithClosingIndex(xmlData, i, closingChar = ">"){
  let attrBoundary;
  let tagExp = "";
  for (let index = i; index < xmlData.length; index++) {
    let ch = xmlData[index];
    if (attrBoundary) {
        if (ch === attrBoundary) attrBoundary = "";//reset
    } else if (ch === '"' || ch === "'") {
        attrBoundary = ch;
    } else if (ch === closingChar[0]) {
      if(closingChar[1]){
        if(xmlData[index + 1] === closingChar[1]){
          return {
            data: tagExp,
            index: index
          }
        }
      }else {
        return {
          data: tagExp,
          index: index
        }
      }
    } else if (ch === '\t') {
      ch = " ";
    }
    tagExp += ch;
  }
}

function findClosingIndex(xmlData, str, i, errMsg){
  const closingIndex = xmlData.indexOf(str, i);
  if(closingIndex === -1){
    throw new Error(errMsg)
  }else {
    return closingIndex + str.length - 1;
  }
}

function readTagExp(xmlData,i, removeNSPrefix, closingChar = ">"){
  const result = tagExpWithClosingIndex(xmlData, i+1, closingChar);
  if(!result) return;
  let tagExp = result.data;
  const closeIndex = result.index;
  const separatorIndex = tagExp.search(/\s/);
  let tagName = tagExp;
  let attrExpPresent = true;
  if(separatorIndex !== -1){//separate tag name and attributes expression
    tagName = tagExp.substr(0, separatorIndex).replace(/\s\s*$/, '');
    tagExp = tagExp.substr(separatorIndex + 1);
  }

  const rawTagName = tagName;
  if(removeNSPrefix){
    const colonIndex = tagName.indexOf(":");
    if(colonIndex !== -1){
      tagName = tagName.substr(colonIndex+1);
      attrExpPresent = tagName !== result.data.substr(colonIndex + 1);
    }
  }

  return {
    tagName: tagName,
    tagExp: tagExp,
    closeIndex: closeIndex,
    attrExpPresent: attrExpPresent,
    rawTagName: rawTagName,
  }
}
/**
 * find paired tag for a stop node
 * @param {string} xmlData 
 * @param {string} tagName 
 * @param {number} i 
 */
function readStopNodeData(xmlData, tagName, i){
  const startIndex = i;
  // Starting at 1 since we already have an open tag
  let openTagCount = 1;

  for (; i < xmlData.length; i++) {
    if( xmlData[i] === "<"){ 
      if (xmlData[i+1] === "/") {//close tag
          const closeIndex = findClosingIndex(xmlData, ">", i, `${tagName} is not closed`);
          let closeTagName = xmlData.substring(i+2,closeIndex).trim();
          if(closeTagName === tagName){
            openTagCount--;
            if (openTagCount === 0) {
              return {
                tagContent: xmlData.substring(startIndex, i),
                i : closeIndex
              }
            }
          }
          i=closeIndex;
        } else if(xmlData[i+1] === '?') { 
          const closeIndex = findClosingIndex(xmlData, "?>", i+1, "StopNode is not closed.");
          i=closeIndex;
        } else if(xmlData.substr(i + 1, 3) === '!--') { 
          const closeIndex = findClosingIndex(xmlData, "-->", i+3, "StopNode is not closed.");
          i=closeIndex;
        } else if(xmlData.substr(i + 1, 2) === '![') { 
          const closeIndex = findClosingIndex(xmlData, "]]>", i, "StopNode is not closed.") - 2;
          i=closeIndex;
        } else {
          const tagData = readTagExp(xmlData, i, '>');

          if (tagData) {
            const openTagName = tagData && tagData.tagName;
            if (openTagName === tagName && tagData.tagExp[tagData.tagExp.length-1] !== "/") {
              openTagCount++;
            }
            i=tagData.closeIndex;
          }
        }
      }
  }//end for loop
}

function parseValue(val, shouldParse, options) {
  if (shouldParse && typeof val === 'string') {
    //console.log(options)
    const newval = val.trim();
    if(newval === 'true' ) return true;
    else if(newval === 'false' ) return false;
    else return toNumber(val, options);
  } else {
    if (util.isExist(val)) {
      return val;
    } else {
      return '';
    }
  }
}


var OrderedObjParser_1 = OrderedObjParser$1;

var node2json = {};

/**
 * 
 * @param {array} node 
 * @param {any} options 
 * @returns 
 */
function prettify$1(node, options){
  return compress( node, options);
}

/**
 * 
 * @param {array} arr 
 * @param {object} options 
 * @param {string} jPath 
 * @returns object
 */
function compress(arr, options, jPath){
  let text;
  const compressedObj = {};
  for (let i = 0; i < arr.length; i++) {
    const tagObj = arr[i];
    const property = propName$1(tagObj);
    let newJpath = "";
    if(jPath === undefined) newJpath = property;
    else newJpath = jPath + "." + property;

    if(property === options.textNodeName){
      if(text === undefined) text = tagObj[property];
      else text += "" + tagObj[property];
    }else if(property === undefined){
      continue;
    }else if(tagObj[property]){
      
      let val = compress(tagObj[property], options, newJpath);
      const isLeaf = isLeafTag(val, options);

      if(tagObj[":@"]){
        assignAttributes( val, tagObj[":@"], newJpath, options);
      }else if(Object.keys(val).length === 1 && val[options.textNodeName] !== undefined && !options.alwaysCreateTextNode){
        val = val[options.textNodeName];
      }else if(Object.keys(val).length === 0){
        if(options.alwaysCreateTextNode) val[options.textNodeName] = "";
        else val = "";
      }

      if(compressedObj[property] !== undefined && compressedObj.hasOwnProperty(property)) {
        if(!Array.isArray(compressedObj[property])) {
            compressedObj[property] = [ compressedObj[property] ];
        }
        compressedObj[property].push(val);
      }else {
        //TODO: if a node is not an array, then check if it should be an array
        //also determine if it is a leaf node
        if (options.isArray(property, newJpath, isLeaf )) {
          compressedObj[property] = [val];
        }else {
          compressedObj[property] = val;
        }
      }
    }
    
  }
  // if(text && text.length > 0) compressedObj[options.textNodeName] = text;
  if(typeof text === "string"){
    if(text.length > 0) compressedObj[options.textNodeName] = text;
  }else if(text !== undefined) compressedObj[options.textNodeName] = text;
  return compressedObj;
}

function propName$1(obj){
  const keys = Object.keys(obj);
  for (let i = 0; i < keys.length; i++) {
    const key = keys[i];
    if(key !== ":@") return key;
  }
}

function assignAttributes(obj, attrMap, jpath, options){
  if (attrMap) {
    const keys = Object.keys(attrMap);
    const len = keys.length; //don't make it inline
    for (let i = 0; i < len; i++) {
      const atrrName = keys[i];
      if (options.isArray(atrrName, jpath + "." + atrrName, true, true)) {
        obj[atrrName] = [ attrMap[atrrName] ];
      } else {
        obj[atrrName] = attrMap[atrrName];
      }
    }
  }
}

function isLeafTag(obj, options){
  const { textNodeName } = options;
  const propCount = Object.keys(obj).length;
  
  if (propCount === 0) {
    return true;
  }

  if (
    propCount === 1 &&
    (obj[textNodeName] || typeof obj[textNodeName] === "boolean" || obj[textNodeName] === 0)
  ) {
    return true;
  }

  return false;
}
node2json.prettify = prettify$1;

const { buildOptions} = OptionsBuilder;
const OrderedObjParser = OrderedObjParser_1;
const { prettify} = node2json;
const validator$1 = validator$2;

class XMLParser$2{
    
    constructor(options){
        this.externalEntities = {};
        this.options = buildOptions(options);
        
    }
    /**
     * Parse XML dats to JS object 
     * @param {string|Buffer} xmlData 
     * @param {boolean|Object} validationOption 
     */
    parse(xmlData,validationOption){
        if(typeof xmlData === "string");else if( xmlData.toString){
            xmlData = xmlData.toString();
        }else {
            throw new Error("XML data is accepted in String or Bytes[] form.")
        }
        if( validationOption){
            if(validationOption === true) validationOption = {}; //validate with default options
            
            const result = validator$1.validate(xmlData, validationOption);
            if (result !== true) {
              throw Error( `${result.err.msg}:${result.err.line}:${result.err.col}` )
            }
          }
        const orderedObjParser = new OrderedObjParser(this.options);
        orderedObjParser.addExternalEntities(this.externalEntities);
        const orderedResult = orderedObjParser.parseXml(xmlData);
        if(this.options.preserveOrder || orderedResult === undefined) return orderedResult;
        else return prettify(orderedResult, this.options);
    }

    /**
     * Add Entity which is not by default supported by this library
     * @param {string} key 
     * @param {string} value 
     */
    addEntity(key, value){
        if(value.indexOf("&") !== -1){
            throw new Error("Entity value can't have '&'")
        }else if(key.indexOf("&") !== -1 || key.indexOf(";") !== -1){
            throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'")
        }else if(value === "&"){
            throw new Error("An entity with value '&' is not permitted");
        }else {
            this.externalEntities[key] = value;
        }
    }
}

var XMLParser_1 = XMLParser$2;

const EOL = "\n";

/**
 * 
 * @param {array} jArray 
 * @param {any} options 
 * @returns 
 */
function toXml(jArray, options) {
    let indentation = "";
    if (options.format && options.indentBy.length > 0) {
        indentation = EOL;
    }
    return arrToStr(jArray, options, "", indentation);
}

function arrToStr(arr, options, jPath, indentation) {
    let xmlStr = "";
    let isPreviousElementTag = false;

    for (let i = 0; i < arr.length; i++) {
        const tagObj = arr[i];
        const tagName = propName(tagObj);
        if(tagName === undefined) continue;

        let newJPath = "";
        if (jPath.length === 0) newJPath = tagName;
        else newJPath = `${jPath}.${tagName}`;

        if (tagName === options.textNodeName) {
            let tagText = tagObj[tagName];
            if (!isStopNode(newJPath, options)) {
                tagText = options.tagValueProcessor(tagName, tagText);
                tagText = replaceEntitiesValue(tagText, options);
            }
            if (isPreviousElementTag) {
                xmlStr += indentation;
            }
            xmlStr += tagText;
            isPreviousElementTag = false;
            continue;
        } else if (tagName === options.cdataPropName) {
            if (isPreviousElementTag) {
                xmlStr += indentation;
            }
            xmlStr += `<![CDATA[${tagObj[tagName][0][options.textNodeName]}]]>`;
            isPreviousElementTag = false;
            continue;
        } else if (tagName === options.commentPropName) {
            xmlStr += indentation + `<!--${tagObj[tagName][0][options.textNodeName]}-->`;
            isPreviousElementTag = true;
            continue;
        } else if (tagName[0] === "?") {
            const attStr = attr_to_str(tagObj[":@"], options);
            const tempInd = tagName === "?xml" ? "" : indentation;
            let piTextNodeName = tagObj[tagName][0][options.textNodeName];
            piTextNodeName = piTextNodeName.length !== 0 ? " " + piTextNodeName : ""; //remove extra spacing
            xmlStr += tempInd + `<${tagName}${piTextNodeName}${attStr}?>`;
            isPreviousElementTag = true;
            continue;
        }
        let newIdentation = indentation;
        if (newIdentation !== "") {
            newIdentation += options.indentBy;
        }
        const attStr = attr_to_str(tagObj[":@"], options);
        const tagStart = indentation + `<${tagName}${attStr}`;
        const tagValue = arrToStr(tagObj[tagName], options, newJPath, newIdentation);
        if (options.unpairedTags.indexOf(tagName) !== -1) {
            if (options.suppressUnpairedNode) xmlStr += tagStart + ">";
            else xmlStr += tagStart + "/>";
        } else if ((!tagValue || tagValue.length === 0) && options.suppressEmptyNode) {
            xmlStr += tagStart + "/>";
        } else if (tagValue && tagValue.endsWith(">")) {
            xmlStr += tagStart + `>${tagValue}${indentation}</${tagName}>`;
        } else {
            xmlStr += tagStart + ">";
            if (tagValue && indentation !== "" && (tagValue.includes("/>") || tagValue.includes("</"))) {
                xmlStr += indentation + options.indentBy + tagValue + indentation;
            } else {
                xmlStr += tagValue;
            }
            xmlStr += `</${tagName}>`;
        }
        isPreviousElementTag = true;
    }

    return xmlStr;
}

function propName(obj) {
    const keys = Object.keys(obj);
    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        if(!obj.hasOwnProperty(key)) continue;
        if (key !== ":@") return key;
    }
}

function attr_to_str(attrMap, options) {
    let attrStr = "";
    if (attrMap && !options.ignoreAttributes) {
        for (let attr in attrMap) {
            if(!attrMap.hasOwnProperty(attr)) continue;
            let attrVal = options.attributeValueProcessor(attr, attrMap[attr]);
            attrVal = replaceEntitiesValue(attrVal, options);
            if (attrVal === true && options.suppressBooleanAttributes) {
                attrStr += ` ${attr.substr(options.attributeNamePrefix.length)}`;
            } else {
                attrStr += ` ${attr.substr(options.attributeNamePrefix.length)}="${attrVal}"`;
            }
        }
    }
    return attrStr;
}

function isStopNode(jPath, options) {
    jPath = jPath.substr(0, jPath.length - options.textNodeName.length - 1);
    let tagName = jPath.substr(jPath.lastIndexOf(".") + 1);
    for (let index in options.stopNodes) {
        if (options.stopNodes[index] === jPath || options.stopNodes[index] === "*." + tagName) return true;
    }
    return false;
}

function replaceEntitiesValue(textValue, options) {
    if (textValue && textValue.length > 0 && options.processEntities) {
        for (let i = 0; i < options.entities.length; i++) {
            const entity = options.entities[i];
            textValue = textValue.replace(entity.regex, entity.val);
        }
    }
    return textValue;
}
var orderedJs2Xml = toXml;

//parse Empty Node as self closing node
const buildFromOrderedJs = orderedJs2Xml;

const defaultOptions = {
  attributeNamePrefix: '@_',
  attributesGroupName: false,
  textNodeName: '#text',
  ignoreAttributes: true,
  cdataPropName: false,
  format: false,
  indentBy: '  ',
  suppressEmptyNode: false,
  suppressUnpairedNode: true,
  suppressBooleanAttributes: true,
  tagValueProcessor: function(key, a) {
    return a;
  },
  attributeValueProcessor: function(attrName, a) {
    return a;
  },
  preserveOrder: false,
  commentPropName: false,
  unpairedTags: [],
  entities: [
    { regex: new RegExp("&", "g"), val: "&amp;" },//it must be on top
    { regex: new RegExp(">", "g"), val: "&gt;" },
    { regex: new RegExp("<", "g"), val: "&lt;" },
    { regex: new RegExp("\'", "g"), val: "&apos;" },
    { regex: new RegExp("\"", "g"), val: "&quot;" }
  ],
  processEntities: true,
  stopNodes: [],
  // transformTagName: false,
  // transformAttributeName: false,
  oneListGroup: false
};

function Builder(options) {
  this.options = Object.assign({}, defaultOptions, options);
  if (this.options.ignoreAttributes || this.options.attributesGroupName) {
    this.isAttribute = function(/*a*/) {
      return false;
    };
  } else {
    this.attrPrefixLen = this.options.attributeNamePrefix.length;
    this.isAttribute = isAttribute;
  }

  this.processTextOrObjNode = processTextOrObjNode;

  if (this.options.format) {
    this.indentate = indentate;
    this.tagEndChar = '>\n';
    this.newLine = '\n';
  } else {
    this.indentate = function() {
      return '';
    };
    this.tagEndChar = '>';
    this.newLine = '';
  }
}

Builder.prototype.build = function(jObj) {
  if(this.options.preserveOrder){
    return buildFromOrderedJs(jObj, this.options);
  }else {
    if(Array.isArray(jObj) && this.options.arrayNodeName && this.options.arrayNodeName.length > 1){
      jObj = {
        [this.options.arrayNodeName] : jObj
      };
    }
    return this.j2x(jObj, 0).val;
  }
};

Builder.prototype.j2x = function(jObj, level) {
  let attrStr = '';
  let val = '';
  for (let key in jObj) {
    if(!Object.prototype.hasOwnProperty.call(jObj, key)) continue;
    if (typeof jObj[key] === 'undefined') {
      // supress undefined node only if it is not an attribute
      if (this.isAttribute(key)) {
        val += '';
      }
    } else if (jObj[key] === null) {
      // null attribute should be ignored by the attribute list, but should not cause the tag closing
      if (this.isAttribute(key)) {
        val += '';
      } else if (key[0] === '?') {
        val += this.indentate(level) + '<' + key + '?' + this.tagEndChar;
      } else {
        val += this.indentate(level) + '<' + key + '/' + this.tagEndChar;
      }
      // val += this.indentate(level) + '<' + key + '/' + this.tagEndChar;
    } else if (jObj[key] instanceof Date) {
      val += this.buildTextValNode(jObj[key], key, '', level);
    } else if (typeof jObj[key] !== 'object') {
      //premitive type
      const attr = this.isAttribute(key);
      if (attr) {
        attrStr += this.buildAttrPairStr(attr, '' + jObj[key]);
      }else {
        //tag value
        if (key === this.options.textNodeName) {
          let newval = this.options.tagValueProcessor(key, '' + jObj[key]);
          val += this.replaceEntitiesValue(newval);
        } else {
          val += this.buildTextValNode(jObj[key], key, '', level);
        }
      }
    } else if (Array.isArray(jObj[key])) {
      //repeated nodes
      const arrLen = jObj[key].length;
      let listTagVal = "";
      for (let j = 0; j < arrLen; j++) {
        const item = jObj[key][j];
        if (typeof item === 'undefined') ; else if (item === null) {
          if(key[0] === "?") val += this.indentate(level) + '<' + key + '?' + this.tagEndChar;
          else val += this.indentate(level) + '<' + key + '/' + this.tagEndChar;
          // val += this.indentate(level) + '<' + key + '/' + this.tagEndChar;
        } else if (typeof item === 'object') {
          if(this.options.oneListGroup ){
            listTagVal += this.j2x(item, level + 1).val;
          }else {
            listTagVal += this.processTextOrObjNode(item, key, level);
          }
        } else {
          listTagVal += this.buildTextValNode(item, key, '', level);
        }
      }
      if(this.options.oneListGroup){
        listTagVal = this.buildObjectNode(listTagVal, key, '', level);
      }
      val += listTagVal;
    } else {
      //nested node
      if (this.options.attributesGroupName && key === this.options.attributesGroupName) {
        const Ks = Object.keys(jObj[key]);
        const L = Ks.length;
        for (let j = 0; j < L; j++) {
          attrStr += this.buildAttrPairStr(Ks[j], '' + jObj[key][Ks[j]]);
        }
      } else {
        val += this.processTextOrObjNode(jObj[key], key, level);
      }
    }
  }
  return {attrStr: attrStr, val: val};
};

Builder.prototype.buildAttrPairStr = function(attrName, val){
  val = this.options.attributeValueProcessor(attrName, '' + val);
  val = this.replaceEntitiesValue(val);
  if (this.options.suppressBooleanAttributes && val === "true") {
    return ' ' + attrName;
  } else return ' ' + attrName + '="' + val + '"';
};

function processTextOrObjNode (object, key, level) {
  const result = this.j2x(object, level + 1);
  if (object[this.options.textNodeName] !== undefined && Object.keys(object).length === 1) {
    return this.buildTextValNode(object[this.options.textNodeName], key, result.attrStr, level);
  } else {
    return this.buildObjectNode(result.val, key, result.attrStr, level);
  }
}

Builder.prototype.buildObjectNode = function(val, key, attrStr, level) {
  if(val === ""){
    if(key[0] === "?") return  this.indentate(level) + '<' + key + attrStr+ '?' + this.tagEndChar;
    else {
      return this.indentate(level) + '<' + key + attrStr + this.closeTag(key) + this.tagEndChar;
    }
  }else {

    let tagEndExp = '</' + key + this.tagEndChar;
    let piClosingChar = "";
    
    if(key[0] === "?") {
      piClosingChar = "?";
      tagEndExp = "";
    }
  
    // attrStr is an empty string in case the attribute came as undefined or null
    if ((attrStr || attrStr === '') && val.indexOf('<') === -1) {
      return ( this.indentate(level) + '<' +  key + attrStr + piClosingChar + '>' + val + tagEndExp );
    } else if (this.options.commentPropName !== false && key === this.options.commentPropName && piClosingChar.length === 0) {
      return this.indentate(level) + `<!--${val}-->` + this.newLine;
    }else {
      return (
        this.indentate(level) + '<' + key + attrStr + piClosingChar + this.tagEndChar +
        val +
        this.indentate(level) + tagEndExp    );
    }
  }
};

Builder.prototype.closeTag = function(key){
  let closeTag = "";
  if(this.options.unpairedTags.indexOf(key) !== -1){ //unpaired
    if(!this.options.suppressUnpairedNode) closeTag = "/";
  }else if(this.options.suppressEmptyNode){ //empty
    closeTag = "/";
  }else {
    closeTag = `></${key}`;
  }
  return closeTag;
};

Builder.prototype.buildTextValNode = function(val, key, attrStr, level) {
  if (this.options.cdataPropName !== false && key === this.options.cdataPropName) {
    return this.indentate(level) + `<![CDATA[${val}]]>` +  this.newLine;
  }else if (this.options.commentPropName !== false && key === this.options.commentPropName) {
    return this.indentate(level) + `<!--${val}-->` +  this.newLine;
  }else if(key[0] === "?") {//PI tag
    return  this.indentate(level) + '<' + key + attrStr+ '?' + this.tagEndChar; 
  }else {
    let textValue = this.options.tagValueProcessor(key, val);
    textValue = this.replaceEntitiesValue(textValue);
  
    if( textValue === ''){
      return this.indentate(level) + '<' + key + attrStr + this.closeTag(key) + this.tagEndChar;
    }else {
      return this.indentate(level) + '<' + key + attrStr + '>' +
         textValue +
        '</' + key + this.tagEndChar;
    }
  }
};

Builder.prototype.replaceEntitiesValue = function(textValue){
  if(textValue && textValue.length > 0 && this.options.processEntities){
    for (let i=0; i<this.options.entities.length; i++) {
      const entity = this.options.entities[i];
      textValue = textValue.replace(entity.regex, entity.val);
    }
  }
  return textValue;
};

function indentate(level) {
  return this.options.indentBy.repeat(level);
}

function isAttribute(name /*, options*/) {
  if (name.startsWith(this.options.attributeNamePrefix) && name !== this.options.textNodeName) {
    return name.substr(this.attrPrefixLen);
  } else {
    return false;
  }
}

var json2xml = Builder;

const validator = validator$2;
const XMLParser$1 = XMLParser_1;
const XMLBuilder = json2xml;

var fxp = {
  XMLParser: XMLParser$1,
  XMLValidator: validator,
  XMLBuilder: XMLBuilder
};

const {XMLParser, XMLValidator} = fxp;

const isSvg = input => {
	if (input === undefined || input === null) {
		return false;
	}

	input = input.toString().trim();

	if (input.length === 0) {
		return false;
	}

	// Has to be `!==` as it can also return an object with error info.
	if (XMLValidator.validate(input) !== true) {
		return false;
	}

	let jsonObject;
	const parser = new XMLParser();

	try {
		jsonObject = parser.parse(input);
	} catch (_) {
		return false;
	}

	if (!jsonObject) {
		return false;
	}

	if (!('svg' in jsonObject)) {
		return false;
	}

	return true;
};

isSvg$2.exports = isSvg;
// TODO: Remove this for the next major release
isSvg$2.exports.default = isSvg;

var isSvgExports = isSvg$2.exports;
var isSvg$1 = /*@__PURE__*/getDefaultExportFromCjs(isSvgExports);

var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;

var escapeStringRegexp$2 = function (str) {
	if (typeof str !== 'string') {
		throw new TypeError('Expected a string');
	}

	return str.replace(matchOperatorsRe, '\\$&');
};

var escapeStringRegexp$1 = escapeStringRegexp$2;

var trimRepeated = function (str, target) {
	if (typeof str !== 'string' || typeof target !== 'string') {
		throw new TypeError('Expected a string');
	}

	return str.replace(new RegExp('(?:' + escapeStringRegexp$1(target) + '){2,}', 'g'), target);
};

var trimRepeated$1 = /*@__PURE__*/getDefaultExportFromCjs(trimRepeated);

var filenameReservedRegex$1 = {exports: {}};

/* eslint-disable no-control-regex */
// TODO: remove parens when Node.js 6 is targeted. Node.js 4 barfs at it.
filenameReservedRegex$1.exports = () => (/[<>:"\/\\|?*\x00-\x1F]/g);
filenameReservedRegex$1.exports.windowsNames = () => (/^(con|prn|aux|nul|com[0-9]|lpt[0-9])$/i);

var filenameReservedRegexExports = filenameReservedRegex$1.exports;
var filenameReservedRegex = /*@__PURE__*/getDefaultExportFromCjs(filenameReservedRegexExports);

var escapeStringRegexp = escapeStringRegexp$2;

var stripOuter = function (str, sub) {
	if (typeof str !== 'string' || typeof sub !== 'string') {
		throw new TypeError();
	}

	sub = escapeStringRegexp(sub);
	return str.replace(new RegExp('^' + sub + '|' + sub + '$', 'g'), '');
};

var stripOuter$1 = /*@__PURE__*/getDefaultExportFromCjs(stripOuter);

// Doesn't make sense to have longer filenames
const MAX_FILENAME_LENGTH = 100;

const reControlChars = /[\u0000-\u001F\u0080-\u009F]/g; // eslint-disable-line no-control-regex
const reRelativePath = /^\.+/;
const reTrailingPeriods = /\.+$/;

function filenamify(string, options = {}) {
	if (typeof string !== 'string') {
		throw new TypeError('Expected a string');
	}

	const replacement = options.replacement === undefined ? '!' : options.replacement;

	if (filenameReservedRegex().test(replacement) && reControlChars.test(replacement)) {
		throw new Error('Replacement string cannot contain reserved filename characters');
	}

	string = string.replace(filenameReservedRegex(), replacement);
	string = string.replace(reControlChars, replacement);
	string = string.replace(reRelativePath, replacement);
	string = string.replace(reTrailingPeriods, '');

	if (replacement.length > 0) {
		string = trimRepeated$1(string, replacement);
		string = string.length > 1 ? stripOuter$1(string, replacement) : string;
	}

	string = filenameReservedRegex.windowsNames().test(string) ? string + replacement : string;
	string = string.slice(0, typeof options.maxLength === 'number' ? options.maxLength : MAX_FILENAME_LENGTH);

	return string;
}

function commonjsRequire(path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var jimp = {exports: {}};

/*
Jimp v0.3.10
https://github.com/oliver-moran/jimp
Ported for the Web by Phil Seaton
The MIT License (MIT)

Copyright (c) 2014 Oliver Moran

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
jimp.exports;

(function (module, exports) {
	if ((typeof(window)=='undefined' || !window) && (typeof(self)!='undefined')) var window = self;
	(function(f){{module.exports=f();}})(function(){return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof commonjsRequire&&commonjsRequire;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t);}return n[i].exports}for(var u="function"==typeof commonjsRequire&&commonjsRequire,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
	var Converter = require('./src/converter');

	/**
	 * Function get source and destination alphabet and return convert function
	 *
	 * @param {string|Array} srcAlphabet
	 * @param {string|Array} dstAlphabet
	 *
	 * @returns {function(number|Array)}
	 */
	function anyBase(srcAlphabet, dstAlphabet) {
	    var converter = new Converter(srcAlphabet, dstAlphabet);
	    /**
	     * Convert function
	     *
	     * @param {string|Array} number
	     *
	     * @return {string|Array} number
	     */
	    return function (number) {
	        return converter.convert(number);
	    }
	}
	anyBase.BIN = '01';
	anyBase.OCT = '01234567';
	anyBase.DEC = '0123456789';
	anyBase.HEX = '0123456789abcdef';

	module.exports = anyBase;
	},{"./src/converter":2}],2:[function(require,module,exports){

	/**
	 * Converter
	 *
	 * @param {string|Array} srcAlphabet
	 * @param {string|Array} dstAlphabet
	 * @constructor
	 */
	function Converter(srcAlphabet, dstAlphabet) {
	    if (!srcAlphabet || !dstAlphabet || !srcAlphabet.length || !dstAlphabet.length) {
	        throw new Error('Bad alphabet');
	    }
	    this.srcAlphabet = srcAlphabet;
	    this.dstAlphabet = dstAlphabet;
	}

	/**
	 * Convert number from source alphabet to destination alphabet
	 *
	 * @param {string|Array} number - number represented as a string or array of points
	 *
	 * @returns {string|Array}
	 */
	Converter.prototype.convert = function(number) {
	    var i, divide, newlen,
	    numberMap = {},
	    fromBase = this.srcAlphabet.length,
	    toBase = this.dstAlphabet.length,
	    length = number.length,
	    result = typeof number === 'string' ? '' : [];

	    if (!this.isValid(number)) {
	        throw new Error('Number "' + number + '" contains of non-alphabetic digits (' + this.srcAlphabet + ')');
	    }

	    if (this.srcAlphabet === this.dstAlphabet) {
	        return number;
	    }

	    for (i = 0; i < length; i++) {
	        numberMap[i] = this.srcAlphabet.indexOf(number[i]);
	    }
	    do {
	        divide = 0;
	        newlen = 0;
	        for (i = 0; i < length; i++) {
	            divide = divide * fromBase + numberMap[i];
	            if (divide >= toBase) {
	                numberMap[newlen++] = parseInt(divide / toBase, 10);
	                divide = divide % toBase;
	            } else if (newlen > 0) {
	                numberMap[newlen++] = 0;
	            }
	        }
	        length = newlen;
	        result = this.dstAlphabet.slice(divide, divide + 1).concat(result);
	    } while (newlen !== 0);

	    return result;
	};

	/**
	 * Valid number with source alphabet
	 *
	 * @param {number} number
	 *
	 * @returns {boolean}
	 */
	Converter.prototype.isValid = function(number) {
	    var i = 0;
	    for (; i < number.length; ++i) {
	        if (this.srcAlphabet.indexOf(number[i]) === -1) {
	            return false;
	        }
	    }
	    return true;
	};

	module.exports = Converter;
	},{}],3:[function(require,module,exports){
	(function (global){

	// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
	// original notice:

	/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	function compare(a, b) {
	  if (a === b) {
	    return 0;
	  }

	  var x = a.length;
	  var y = b.length;

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i];
	      y = b[i];
	      break;
	    }
	  }

	  if (x < y) {
	    return -1;
	  }
	  if (y < x) {
	    return 1;
	  }
	  return 0;
	}
	function isBuffer(b) {
	  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
	    return global.Buffer.isBuffer(b);
	  }
	  return !!(b != null && b._isBuffer);
	}

	// based on node assert, original notice:

	// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
	//
	// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
	//
	// Originally from narwhal.js (http://narwhaljs.org)
	// Copyright (c) 2009 Thomas Robinson <280north.com>
	//
	// Permission is hereby granted, free of charge, to any person obtaining a copy
	// of this software and associated documentation files (the 'Software'), to
	// deal in the Software without restriction, including without limitation the
	// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
	// sell copies of the Software, and to permit persons to whom the Software is
	// furnished to do so, subject to the following conditions:
	//
	// The above copyright notice and this permission notice shall be included in
	// all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
	// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
	// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

	var util = require('util/');
	var hasOwn = Object.prototype.hasOwnProperty;
	var pSlice = Array.prototype.slice;
	var functionsHaveNames = (function () {
	  return function foo() {}.name === 'foo';
	}());
	function pToString (obj) {
	  return Object.prototype.toString.call(obj);
	}
	function isView(arrbuf) {
	  if (isBuffer(arrbuf)) {
	    return false;
	  }
	  if (typeof global.ArrayBuffer !== 'function') {
	    return false;
	  }
	  if (typeof ArrayBuffer.isView === 'function') {
	    return ArrayBuffer.isView(arrbuf);
	  }
	  if (!arrbuf) {
	    return false;
	  }
	  if (arrbuf instanceof DataView) {
	    return true;
	  }
	  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
	    return true;
	  }
	  return false;
	}
	// 1. The assert module provides functions that throw
	// AssertionError's when particular conditions are not met. The
	// assert module must conform to the following interface.

	var assert = module.exports = ok;

	// 2. The AssertionError is defined in assert.
	// new assert.AssertionError({ message: message,
	//                             actual: actual,
	//                             expected: expected })

	var regex = /\s*function\s+([^\(\s]*)\s*/;
	// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
	function getName(func) {
	  if (!util.isFunction(func)) {
	    return;
	  }
	  if (functionsHaveNames) {
	    return func.name;
	  }
	  var str = func.toString();
	  var match = str.match(regex);
	  return match && match[1];
	}
	assert.AssertionError = function AssertionError(options) {
	  this.name = 'AssertionError';
	  this.actual = options.actual;
	  this.expected = options.expected;
	  this.operator = options.operator;
	  if (options.message) {
	    this.message = options.message;
	    this.generatedMessage = false;
	  } else {
	    this.message = getMessage(this);
	    this.generatedMessage = true;
	  }
	  var stackStartFunction = options.stackStartFunction || fail;
	  if (Error.captureStackTrace) {
	    Error.captureStackTrace(this, stackStartFunction);
	  } else {
	    // non v8 browsers so we can have a stacktrace
	    var err = new Error();
	    if (err.stack) {
	      var out = err.stack;

	      // try to strip useless frames
	      var fn_name = getName(stackStartFunction);
	      var idx = out.indexOf('\n' + fn_name);
	      if (idx >= 0) {
	        // once we have located the function frame
	        // we need to strip out everything before it (and its line)
	        var next_line = out.indexOf('\n', idx + 1);
	        out = out.substring(next_line + 1);
	      }

	      this.stack = out;
	    }
	  }
	};

	// assert.AssertionError instanceof Error
	util.inherits(assert.AssertionError, Error);

	function truncate(s, n) {
	  if (typeof s === 'string') {
	    return s.length < n ? s : s.slice(0, n);
	  } else {
	    return s;
	  }
	}
	function inspect(something) {
	  if (functionsHaveNames || !util.isFunction(something)) {
	    return util.inspect(something);
	  }
	  var rawname = getName(something);
	  var name = rawname ? ': ' + rawname : '';
	  return '[Function' +  name + ']';
	}
	function getMessage(self) {
	  return truncate(inspect(self.actual), 128) + ' ' +
	         self.operator + ' ' +
	         truncate(inspect(self.expected), 128);
	}

	// At present only the three keys mentioned above are used and
	// understood by the spec. Implementations or sub modules can pass
	// other keys to the AssertionError's constructor - they will be
	// ignored.

	// 3. All of the following functions must throw an AssertionError
	// when a corresponding condition is not met, with a message that
	// may be undefined if not provided.  All assertion methods provide
	// both the actual and expected values to the assertion error for
	// display purposes.

	function fail(actual, expected, message, operator, stackStartFunction) {
	  throw new assert.AssertionError({
	    message: message,
	    actual: actual,
	    expected: expected,
	    operator: operator,
	    stackStartFunction: stackStartFunction
	  });
	}

	// EXTENSION! allows for well behaved errors defined elsewhere.
	assert.fail = fail;

	// 4. Pure assertion tests whether a value is truthy, as determined
	// by !!guard.
	// assert.ok(guard, message_opt);
	// This statement is equivalent to assert.equal(true, !!guard,
	// message_opt);. To test strictly for the value true, use
	// assert.strictEqual(true, guard, message_opt);.

	function ok(value, message) {
	  if (!value) fail(value, true, message, '==', assert.ok);
	}
	assert.ok = ok;

	// 5. The equality assertion tests shallow, coercive equality with
	// ==.
	// assert.equal(actual, expected, message_opt);

	assert.equal = function equal(actual, expected, message) {
	  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
	};

	// 6. The non-equality assertion tests for whether two objects are not equal
	// with != assert.notEqual(actual, expected, message_opt);

	assert.notEqual = function notEqual(actual, expected, message) {
	  if (actual == expected) {
	    fail(actual, expected, message, '!=', assert.notEqual);
	  }
	};

	// 7. The equivalence assertion tests a deep equality relation.
	// assert.deepEqual(actual, expected, message_opt);

	assert.deepEqual = function deepEqual(actual, expected, message) {
	  if (!_deepEqual(actual, expected, false)) {
	    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
	  }
	};

	assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
	  if (!_deepEqual(actual, expected, true)) {
	    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
	  }
	};

	function _deepEqual(actual, expected, strict, memos) {
	  // 7.1. All identical values are equivalent, as determined by ===.
	  if (actual === expected) {
	    return true;
	  } else if (isBuffer(actual) && isBuffer(expected)) {
	    return compare(actual, expected) === 0;

	  // 7.2. If the expected value is a Date object, the actual value is
	  // equivalent if it is also a Date object that refers to the same time.
	  } else if (util.isDate(actual) && util.isDate(expected)) {
	    return actual.getTime() === expected.getTime();

	  // 7.3 If the expected value is a RegExp object, the actual value is
	  // equivalent if it is also a RegExp object with the same source and
	  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
	  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
	    return actual.source === expected.source &&
	           actual.global === expected.global &&
	           actual.multiline === expected.multiline &&
	           actual.lastIndex === expected.lastIndex &&
	           actual.ignoreCase === expected.ignoreCase;

	  // 7.4. Other pairs that do not both pass typeof value == 'object',
	  // equivalence is determined by ==.
	  } else if ((actual === null || typeof actual !== 'object') &&
	             (expected === null || typeof expected !== 'object')) {
	    return strict ? actual === expected : actual == expected;

	  // If both values are instances of typed arrays, wrap their underlying
	  // ArrayBuffers in a Buffer each to increase performance
	  // This optimization requires the arrays to have the same type as checked by
	  // Object.prototype.toString (aka pToString). Never perform binary
	  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
	  // bit patterns are not identical.
	  } else if (isView(actual) && isView(expected) &&
	             pToString(actual) === pToString(expected) &&
	             !(actual instanceof Float32Array ||
	               actual instanceof Float64Array)) {
	    return compare(new Uint8Array(actual.buffer),
	                   new Uint8Array(expected.buffer)) === 0;

	  // 7.5 For all other Object pairs, including Array objects, equivalence is
	  // determined by having the same number of owned properties (as verified
	  // with Object.prototype.hasOwnProperty.call), the same set of keys
	  // (although not necessarily the same order), equivalent values for every
	  // corresponding key, and an identical 'prototype' property. Note: this
	  // accounts for both named and indexed properties on Arrays.
	  } else if (isBuffer(actual) !== isBuffer(expected)) {
	    return false;
	  } else {
	    memos = memos || {actual: [], expected: []};

	    var actualIndex = memos.actual.indexOf(actual);
	    if (actualIndex !== -1) {
	      if (actualIndex === memos.expected.indexOf(expected)) {
	        return true;
	      }
	    }

	    memos.actual.push(actual);
	    memos.expected.push(expected);

	    return objEquiv(actual, expected, strict, memos);
	  }
	}

	function isArguments(object) {
	  return Object.prototype.toString.call(object) == '[object Arguments]';
	}

	function objEquiv(a, b, strict, actualVisitedObjects) {
	  if (a === null || a === undefined || b === null || b === undefined)
	    return false;
	  // if one is a primitive, the other must be same
	  if (util.isPrimitive(a) || util.isPrimitive(b))
	    return a === b;
	  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
	    return false;
	  var aIsArgs = isArguments(a);
	  var bIsArgs = isArguments(b);
	  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
	    return false;
	  if (aIsArgs) {
	    a = pSlice.call(a);
	    b = pSlice.call(b);
	    return _deepEqual(a, b, strict);
	  }
	  var ka = objectKeys(a);
	  var kb = objectKeys(b);
	  var key, i;
	  // having the same number of owned properties (keys incorporates
	  // hasOwnProperty)
	  if (ka.length !== kb.length)
	    return false;
	  //the same set of keys (although not necessarily the same order),
	  ka.sort();
	  kb.sort();
	  //~~~cheap key test
	  for (i = ka.length - 1; i >= 0; i--) {
	    if (ka[i] !== kb[i])
	      return false;
	  }
	  //equivalent values for every corresponding key, and
	  //~~~possibly expensive deep test
	  for (i = ka.length - 1; i >= 0; i--) {
	    key = ka[i];
	    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
	      return false;
	  }
	  return true;
	}

	// 8. The non-equivalence assertion tests for any deep inequality.
	// assert.notDeepEqual(actual, expected, message_opt);

	assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
	  if (_deepEqual(actual, expected, false)) {
	    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
	  }
	};

	assert.notDeepStrictEqual = notDeepStrictEqual;
	function notDeepStrictEqual(actual, expected, message) {
	  if (_deepEqual(actual, expected, true)) {
	    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
	  }
	}


	// 9. The strict equality assertion tests strict equality, as determined by ===.
	// assert.strictEqual(actual, expected, message_opt);

	assert.strictEqual = function strictEqual(actual, expected, message) {
	  if (actual !== expected) {
	    fail(actual, expected, message, '===', assert.strictEqual);
	  }
	};

	// 10. The strict non-equality assertion tests for strict inequality, as
	// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

	assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
	  if (actual === expected) {
	    fail(actual, expected, message, '!==', assert.notStrictEqual);
	  }
	};

	function expectedException(actual, expected) {
	  if (!actual || !expected) {
	    return false;
	  }

	  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
	    return expected.test(actual);
	  }

	  try {
	    if (actual instanceof expected) {
	      return true;
	    }
	  } catch (e) {
	    // Ignore.  The instanceof check doesn't work for arrow functions.
	  }

	  if (Error.isPrototypeOf(expected)) {
	    return false;
	  }

	  return expected.call({}, actual) === true;
	}

	function _tryBlock(block) {
	  var error;
	  try {
	    block();
	  } catch (e) {
	    error = e;
	  }
	  return error;
	}

	function _throws(shouldThrow, block, expected, message) {
	  var actual;

	  if (typeof block !== 'function') {
	    throw new TypeError('"block" argument must be a function');
	  }

	  if (typeof expected === 'string') {
	    message = expected;
	    expected = null;
	  }

	  actual = _tryBlock(block);

	  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
	            (message ? ' ' + message : '.');

	  if (shouldThrow && !actual) {
	    fail(actual, expected, 'Missing expected exception' + message);
	  }

	  var userProvidedMessage = typeof message === 'string';
	  var isUnwantedException = !shouldThrow && util.isError(actual);
	  var isUnexpectedException = !shouldThrow && actual && !expected;

	  if ((isUnwantedException &&
	      userProvidedMessage &&
	      expectedException(actual, expected)) ||
	      isUnexpectedException) {
	    fail(actual, expected, 'Got unwanted exception' + message);
	  }

	  if ((shouldThrow && actual && expected &&
	      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
	    throw actual;
	  }
	}

	// 11. Expected to throw an error:
	// assert.throws(block, Error_opt, message_opt);

	assert.throws = function(block, /*optional*/error, /*optional*/message) {
	  _throws(true, block, error, message);
	};

	// EXTENSION! This is annoying to write outside this module.
	assert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {
	  _throws(false, block, error, message);
	};

	assert.ifError = function(err) { if (err) throw err; };

	var objectKeys = Object.keys || function (obj) {
	  var keys = [];
	  for (var key in obj) {
	    if (hasOwn.call(obj, key)) keys.push(key);
	  }
	  return keys;
	};

	}).call(this,typeof commonjsGlobal !== "undefined" ? commonjsGlobal : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
	},{"util/":6}],4:[function(require,module,exports){
	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor;
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor;
	    var TempCtor = function () {};
	    TempCtor.prototype = superCtor.prototype;
	    ctor.prototype = new TempCtor();
	    ctor.prototype.constructor = ctor;
	  };
	}

	},{}],5:[function(require,module,exports){
	module.exports = function isBuffer(arg) {
	  return arg && typeof arg === 'object'
	    && typeof arg.copy === 'function'
	    && typeof arg.fill === 'function'
	    && typeof arg.readUInt8 === 'function';
	};
	},{}],6:[function(require,module,exports){
	(function (process,global){
	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var formatRegExp = /%[sdj%]/g;
	exports.format = function(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	};


	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	exports.deprecate = function(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return exports.deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (process.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	};


	var debugs = {};
	var debugEnviron;
	exports.debuglog = function(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = process.pid;
	      debugs[set] = function() {
	        var msg = exports.format.apply(exports, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	};


	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    exports._extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}
	exports.inspect = inspect;


	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== exports.inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var length = output.reduce(function(prev, cur) {
	    if (cur.indexOf('\n') >= 0) ;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray(ar) {
	  return Array.isArray(ar);
	}
	exports.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;

	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;

	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;

	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;

	exports.isBuffer = require('./support/isBuffer');

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}


	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}


	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];

	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}


	// log is just a thin wrapper to console.log that prepends a timestamp
	exports.log = function() {
	  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
	};


	/**
	 * Inherit the prototype methods from one constructor into another.
	 *
	 * The Function.prototype.inherits from lang.js rewritten as a standalone
	 * function (not on Function.prototype). NOTE: If this file is to be loaded
	 * during bootstrapping this function needs to be rewritten using some native
	 * functions as prototype setup using normal JavaScript does not work as
	 * expected during bootstrapping (see mirror.js in r114903).
	 *
	 * @param {function} ctor Constructor function which needs to inherit the
	 *     prototype.
	 * @param {function} superCtor Constructor function to inherit prototype from.
	 */
	exports.inherits = require('inherits');

	exports._extend = function(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	};

	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	}).call(this,require('_process'),typeof commonjsGlobal !== "undefined" ? commonjsGlobal : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
	},{"./support/isBuffer":5,"_process":226,"inherits":4}],7:[function(require,module,exports){

	exports.byteLength = byteLength;
	exports.toByteArray = toByteArray;
	exports.fromByteArray = fromByteArray;

	var lookup = [];
	var revLookup = [];
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

	var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	for (var i = 0, len = code.length; i < len; ++i) {
	  lookup[i] = code[i];
	  revLookup[code.charCodeAt(i)] = i;
	}

	// Support decoding URL-safe base64 strings, as Node.js does.
	// See: https://en.wikipedia.org/wiki/Base64#URL_applications
	revLookup['-'.charCodeAt(0)] = 62;
	revLookup['_'.charCodeAt(0)] = 63;

	function getLens (b64) {
	  var len = b64.length;

	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // Trim off extra bytes after placeholder bytes are found
	  // See: https://github.com/beatgammit/base64-js/issues/42
	  var validLen = b64.indexOf('=');
	  if (validLen === -1) validLen = len;

	  var placeHoldersLen = validLen === len
	    ? 0
	    : 4 - (validLen % 4);

	  return [validLen, placeHoldersLen]
	}

	// base64 is 4/3 + up to two characters of the original data
	function byteLength (b64) {
	  var lens = getLens(b64);
	  var validLen = lens[0];
	  var placeHoldersLen = lens[1];
	  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
	}

	function _byteLength (b64, validLen, placeHoldersLen) {
	  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
	}

	function toByteArray (b64) {
	  var tmp;
	  var lens = getLens(b64);
	  var validLen = lens[0];
	  var placeHoldersLen = lens[1];

	  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));

	  var curByte = 0;

	  // if there are placeholders, only get up to the last complete 4 chars
	  var len = placeHoldersLen > 0
	    ? validLen - 4
	    : validLen;

	  for (var i = 0; i < len; i += 4) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 18) |
	      (revLookup[b64.charCodeAt(i + 1)] << 12) |
	      (revLookup[b64.charCodeAt(i + 2)] << 6) |
	      revLookup[b64.charCodeAt(i + 3)];
	    arr[curByte++] = (tmp >> 16) & 0xFF;
	    arr[curByte++] = (tmp >> 8) & 0xFF;
	    arr[curByte++] = tmp & 0xFF;
	  }

	  if (placeHoldersLen === 2) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 2) |
	      (revLookup[b64.charCodeAt(i + 1)] >> 4);
	    arr[curByte++] = tmp & 0xFF;
	  }

	  if (placeHoldersLen === 1) {
	    tmp =
	      (revLookup[b64.charCodeAt(i)] << 10) |
	      (revLookup[b64.charCodeAt(i + 1)] << 4) |
	      (revLookup[b64.charCodeAt(i + 2)] >> 2);
	    arr[curByte++] = (tmp >> 8) & 0xFF;
	    arr[curByte++] = tmp & 0xFF;
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] +
	    lookup[num >> 12 & 0x3F] +
	    lookup[num >> 6 & 0x3F] +
	    lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp;
	  var output = [];
	  for (var i = start; i < end; i += 3) {
	    tmp =
	      ((uint8[i] << 16) & 0xFF0000) +
	      ((uint8[i + 1] << 8) & 0xFF00) +
	      (uint8[i + 2] & 0xFF);
	    output.push(tripletToBase64(tmp));
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  var tmp;
	  var len = uint8.length;
	  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
	  var parts = [];
	  var maxChunkLength = 16383; // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(
	      uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
	    ));
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1];
	    parts.push(
	      lookup[tmp >> 2] +
	      lookup[(tmp << 4) & 0x3F] +
	      '=='
	    );
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
	    parts.push(
	      lookup[tmp >> 10] +
	      lookup[(tmp >> 4) & 0x3F] +
	      lookup[(tmp << 2) & 0x3F] +
	      '='
	    );
	  }

	  return parts.join('')
	}

	},{}],8:[function(require,module,exports){
	/**
	 * @author shaozilee
	 *
	 * support 1bit 4bit 8bit 24bit decode
	 * encode with 24bit
	 * 
	 */

	var encode = require('./lib/encoder'),
	    decode = require('./lib/decoder');

	module.exports = {
	  encode: encode,
	  decode: decode
	};

	},{"./lib/decoder":9,"./lib/encoder":10}],9:[function(require,module,exports){
	(function (Buffer){
	/**
	 * @author shaozilee
	 *
	 * Bmp format decoder,support 1bit 4bit 8bit 24bit bmp
	 *
	 */

	function BmpDecoder(buffer,is_with_alpha) {
	  this.pos = 0;
	  this.buffer = buffer;
	  this.is_with_alpha = !!is_with_alpha;
	  this.bottom_up = true;
	  this.flag = this.buffer.toString("utf-8", 0, this.pos += 2);
	  if (this.flag != "BM") throw new Error("Invalid BMP File");
	  this.parseHeader();
	  this.parseRGBA();
	}

	BmpDecoder.prototype.parseHeader = function() {
	  this.fileSize = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.reserved = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.offset = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.headerSize = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.width = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.height = this.buffer.readInt32LE(this.pos);
	  this.pos += 4;
	  this.planes = this.buffer.readUInt16LE(this.pos);
	  this.pos += 2;
	  this.bitPP = this.buffer.readUInt16LE(this.pos);
	  this.pos += 2;
	  this.compress = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.rawSize = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.hr = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.vr = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.colors = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;
	  this.importantColors = this.buffer.readUInt32LE(this.pos);
	  this.pos += 4;

	  if(this.bitPP === 16 && this.is_with_alpha){
	    this.bitPP = 15;
	  }
	  if (this.bitPP < 15) {
	    var len = this.colors === 0 ? 1 << this.bitPP : this.colors;
	    this.palette = new Array(len);
	    for (var i = 0; i < len; i++) {
	      var blue = this.buffer.readUInt8(this.pos++);
	      var green = this.buffer.readUInt8(this.pos++);
	      var red = this.buffer.readUInt8(this.pos++);
	      var quad = this.buffer.readUInt8(this.pos++);
	      this.palette[i] = {
	        red: red,
	        green: green,
	        blue: blue,
	        quad: quad
	      };
	    }
	  }
	  if(this.height < 0) {
	    this.height *= -1;
	    this.bottom_up = false;
	  }

	};

	BmpDecoder.prototype.parseRGBA = function() {
	    var bitn = "bit" + this.bitPP;
	    var len = this.width * this.height * 4;
	    this.data = new Buffer(len);
	    this[bitn]();
	};

	BmpDecoder.prototype.bit1 = function() {
	  var xlen = Math.ceil(this.width / 8);
	  var mode = xlen%4;
	  var y = this.height >= 0 ? this.height - 1 : -this.height;
	  for (var y = this.height - 1; y >= 0; y--) {
	    var line = this.bottom_up ? y : this.height - 1 - y;
	    for (var x = 0; x < xlen; x++) {
	      var b = this.buffer.readUInt8(this.pos++);
	      var location = line * this.width * 4 + x*8*4;
	      for (var i = 0; i < 8; i++) {
	        if(x*8+i<this.width){
	          var rgb = this.palette[((b>>(7-i))&0x1)];

	          this.data[location+i*4] = 0;
	          this.data[location+i*4 + 1] = rgb.blue;
	          this.data[location+i*4 + 2] = rgb.green;
	          this.data[location+i*4 + 3] = rgb.red;

	        }else {
	          break;
	        }
	      }
	    }

	    if (mode != 0){
	      this.pos+=(4 - mode);
	    }
	  }
	};

	BmpDecoder.prototype.bit4 = function() {
	    //RLE-4
	    if(this.compress == 2){
	        this.data.fill(0xff);

	        var location = 0;
	        var lines = this.bottom_up?this.height-1:0;
	        var low_nibble = false;//for all count of pixel

	        while(location<this.data.length){
	            var a = this.buffer.readUInt8(this.pos++);
	            var b = this.buffer.readUInt8(this.pos++);
	            //absolute mode
	            if(a == 0){
	                if(b == 0){//line end
	                    if(this.bottom_up){
	                        lines--;
	                    }else {
	                        lines++;
	                    }
	                    location = lines*this.width*4;
	                    low_nibble = false;
	                    continue;
	                }else if(b == 1){//image end
	                    break;
	                }else if(b ==2){
	                    //offset x,y
	                    var x = this.buffer.readUInt8(this.pos++);
	                    var y = this.buffer.readUInt8(this.pos++);
	                    if(this.bottom_up){
	                        lines-=y;
	                    }else {
	                        lines+=y;
	                    }

	                    location +=(y*this.width*4+x*4);
	                }else {
	                    var c = this.buffer.readUInt8(this.pos++);
	                    for(var i=0;i<b;i++){
	                        if (low_nibble) {
	                            setPixelData.call(this, (c & 0x0f));
	                        } else {
	                            setPixelData.call(this, (c & 0xf0)>>4);
	                        }

	                        if ((i & 1) && (i+1 < b)){
	                            c = this.buffer.readUInt8(this.pos++);
	                        }

	                        low_nibble = !low_nibble;
	                    }

	                    if ((((b+1) >> 1) & 1 ) == 1){
	                        this.pos++;
	                    }
	                }

	            }else {//encoded mode
	                for (var i = 0; i < a; i++) {
	                    if (low_nibble) {
	                        setPixelData.call(this, (b & 0x0f));
	                    } else {
	                        setPixelData.call(this, (b & 0xf0)>>4);
	                    }
	                    low_nibble = !low_nibble;
	                }
	            }

	        }




	        function setPixelData(rgbIndex){
	            var rgb = this.palette[rgbIndex];
	            this.data[location] = 0;
	            this.data[location + 1] = rgb.blue;
	            this.data[location + 2] = rgb.green;
	            this.data[location + 3] = rgb.red;
	            location+=4;
	        }
	    }else {

	      var xlen = Math.ceil(this.width/2);
	      var mode = xlen%4;
	      for (var y = this.height - 1; y >= 0; y--) {
	        var line = this.bottom_up ? y : this.height - 1 - y;
	        for (var x = 0; x < xlen; x++) {
	          var b = this.buffer.readUInt8(this.pos++);
	          var location = line * this.width * 4 + x*2*4;

	          var before = b>>4;
	          var after = b&0x0F;

	          var rgb = this.palette[before];
	          this.data[location] = 0;
	          this.data[location + 1] = rgb.blue;
	          this.data[location + 2] = rgb.green;
	          this.data[location + 3] = rgb.red;


	          if(x*2+1>=this.width)break;

	          rgb = this.palette[after];

	          this.data[location+4] = 0;
	          this.data[location+4 + 1] = rgb.blue;
	          this.data[location+4 + 2] = rgb.green;
	          this.data[location+4 + 3] = rgb.red;

	        }

	        if (mode != 0){
	          this.pos+=(4 - mode);
	        }
	      }

	    }

	};

	BmpDecoder.prototype.bit8 = function() {
	    //RLE-8
	    if(this.compress == 1){
	        this.data.fill(0xff);

	        var location = 0;
	        var lines = this.bottom_up?this.height-1:0;

	        while(location<this.data.length){
	            var a = this.buffer.readUInt8(this.pos++);
	            var b = this.buffer.readUInt8(this.pos++);
	            //absolute mode
	            if(a == 0){
	                if(b == 0){//line end
	                    if(this.bottom_up){
	                        lines--;
	                    }else {
	                        lines++;
	                    }
	                    location = lines*this.width*4;
	                    continue;
	                }else if(b == 1){//image end
	                    break;
	                }else if(b ==2){
	                    //offset x,y
	                    var x = this.buffer.readUInt8(this.pos++);
	                    var y = this.buffer.readUInt8(this.pos++);
	                    if(this.bottom_up){
	                        lines-=y;
	                    }else {
	                        lines+=y;
	                    }

	                    location +=(y*this.width*4+x*4);
	                }else {
	                    for(var i=0;i<b;i++){
	                        var c = this.buffer.readUInt8(this.pos++);
	                        setPixelData.call(this, c);
	                    }
	                    if(b&1 == 1){
	                        this.pos++;
	                    }

	                }

	            }else {//encoded mode
	                for (var i = 0; i < a; i++) {
	                    setPixelData.call(this, b);
	                }
	            }

	        }




	        function setPixelData(rgbIndex){
	            var rgb = this.palette[rgbIndex];
	            this.data[location] = 0;
	            this.data[location + 1] = rgb.blue;
	            this.data[location + 2] = rgb.green;
	            this.data[location + 3] = rgb.red;
	            location+=4;
	        }
	    }else {
	        var mode = this.width % 4;
	        for (var y = this.height - 1; y >= 0; y--) {
	            var line = this.bottom_up ? y : this.height - 1 - y;
	            for (var x = 0; x < this.width; x++) {
	                var b = this.buffer.readUInt8(this.pos++);
	                var location = line * this.width * 4 + x * 4;
	                if (b < this.palette.length) {
	                    var rgb = this.palette[b];

	                    this.data[location] = 0;
	                    this.data[location + 1] = rgb.blue;
	                    this.data[location + 2] = rgb.green;
	                    this.data[location + 3] = rgb.red;

	                } else {
	                    this.data[location] = 0;
	                    this.data[location + 1] = 0xFF;
	                    this.data[location + 2] = 0xFF;
	                    this.data[location + 3] = 0xFF;
	                }
	            }
	            if (mode != 0) {
	                this.pos += (4 - mode);
	            }
	        }
	    }
	};

	BmpDecoder.prototype.bit15 = function() {
	  var dif_w =this.width % 3;
	  var _11111 = parseInt("11111", 2),_1_5 = _11111;
	  for (var y = this.height - 1; y >= 0; y--) {
	    var line = this.bottom_up ? y : this.height - 1 - y;
	    for (var x = 0; x < this.width; x++) {

	      var B = this.buffer.readUInt16LE(this.pos);
	      this.pos+=2;
	      var blue = (B & _1_5) / _1_5 * 255 | 0;
	      var green = (B >> 5 & _1_5 ) / _1_5 * 255 | 0;
	      var red = (B >> 10 & _1_5) / _1_5 * 255 | 0;
	      var alpha = (B>>15)?0xFF:0x00;

	      var location = line * this.width * 4 + x * 4;

	      this.data[location] = alpha;
	      this.data[location + 1] = blue;
	      this.data[location + 2] = green;
	      this.data[location + 3] = red;
	    }
	    //skip extra bytes
	    this.pos += dif_w;
	  }
	};

	BmpDecoder.prototype.bit16 = function() {
	  var dif_w =(this.width % 2)*2;
	  //default xrgb555
	  this.maskRed = 0x7C00;
	  this.maskGreen = 0x3E0;
	  this.maskBlue =0x1F;
	  this.mask0 = 0;

	  if(this.compress == 3){
	    this.maskRed = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.maskGreen = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.maskBlue = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.mask0 = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	  }


	  var ns=[0,0,0];
	  for (var i=0;i<16;i++){
	    if ((this.maskRed>>i)&0x01) ns[0]++;
	    if ((this.maskGreen>>i)&0x01) ns[1]++;
	    if ((this.maskBlue>>i)&0x01) ns[2]++;
	  }
	  ns[1]+=ns[0]; ns[2]+=ns[1];	ns[0]=8-ns[0]; ns[1]-=8; ns[2]-=8;

	  for (var y = this.height - 1; y >= 0; y--) {
	    var line = this.bottom_up ? y : this.height - 1 - y;
	    for (var x = 0; x < this.width; x++) {

	      var B = this.buffer.readUInt16LE(this.pos);
	      this.pos+=2;

	      var blue = (B&this.maskBlue)<<ns[0];
	      var green = (B&this.maskGreen)>>ns[1];
	      var red = (B&this.maskRed)>>ns[2];

	      var location = line * this.width * 4 + x * 4;

	      this.data[location] = 0;
	      this.data[location + 1] = blue;
	      this.data[location + 2] = green;
	      this.data[location + 3] = red;
	    }
	    //skip extra bytes
	    this.pos += dif_w;
	  }
	};

	BmpDecoder.prototype.bit24 = function() {
	  for (var y = this.height - 1; y >= 0; y--) {
	    var line = this.bottom_up ? y : this.height - 1 - y;
	    for (var x = 0; x < this.width; x++) {
	      //Little Endian rgb
	      var blue = this.buffer.readUInt8(this.pos++);
	      var green = this.buffer.readUInt8(this.pos++);
	      var red = this.buffer.readUInt8(this.pos++);
	      var location = line * this.width * 4 + x * 4;
	      this.data[location] = 0;
	      this.data[location + 1] = blue;
	      this.data[location + 2] = green;
	      this.data[location + 3] = red;
	    }
	    //skip extra bytes
	    this.pos += (this.width % 4);
	  }

	};

	/**
	 * add 32bit decode func
	 * @author soubok
	 */
	BmpDecoder.prototype.bit32 = function() {
	  //BI_BITFIELDS
	  if(this.compress == 3){
	    this.maskRed = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.maskGreen = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.maskBlue = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	    this.mask0 = this.buffer.readUInt32LE(this.pos);
	    this.pos+=4;
	      for (var y = this.height - 1; y >= 0; y--) {
	          var line = this.bottom_up ? y : this.height - 1 - y;
	          for (var x = 0; x < this.width; x++) {
	              //Little Endian rgba
	              var alpha = this.buffer.readUInt8(this.pos++);
	              var blue = this.buffer.readUInt8(this.pos++);
	              var green = this.buffer.readUInt8(this.pos++);
	              var red = this.buffer.readUInt8(this.pos++);
	              var location = line * this.width * 4 + x * 4;
	              this.data[location] = alpha;
	              this.data[location + 1] = blue;
	              this.data[location + 2] = green;
	              this.data[location + 3] = red;
	          }
	      }

	  }else {
	      for (var y = this.height - 1; y >= 0; y--) {
	          var line = this.bottom_up ? y : this.height - 1 - y;
	          for (var x = 0; x < this.width; x++) {
	              //Little Endian argb
	              var blue = this.buffer.readUInt8(this.pos++);
	              var green = this.buffer.readUInt8(this.pos++);
	              var red = this.buffer.readUInt8(this.pos++);
	              var alpha = this.buffer.readUInt8(this.pos++);
	              var location = line * this.width * 4 + x * 4;
	              this.data[location] = alpha;
	              this.data[location + 1] = blue;
	              this.data[location + 2] = green;
	              this.data[location + 3] = red;
	          }
	      }

	  }




	};

	BmpDecoder.prototype.getData = function() {
	  return this.data;
	};

	module.exports = function(bmpData) {
	  var decoder = new BmpDecoder(bmpData);
	  return decoder;
	};

	}).call(this,require("buffer").Buffer);
	},{"buffer":16}],10:[function(require,module,exports){
	(function (Buffer){
	/**
	 * @author shaozilee
	 *
	 * BMP format encoder,encode 24bit BMP
	 * Not support quality compression
	 *
	 */

	function BmpEncoder(imgData){
		this.buffer = imgData.data;
		this.width = imgData.width;
		this.height = imgData.height;
		this.extraBytes = this.width%4;
		this.rgbSize = this.height*(3*this.width+this.extraBytes);
		this.headerInfoSize = 40;

		this.data = [];
		/******************header***********************/
		this.flag = "BM";
		this.reserved = 0;
		this.offset = 54;
		this.fileSize = this.rgbSize+this.offset;
		this.planes = 1;
		this.bitPP = 24;
		this.compress = 0;
		this.hr = 0;
		this.vr = 0;
		this.colors = 0;
		this.importantColors = 0;
	}

	BmpEncoder.prototype.encode = function() {
		var tempBuffer = new Buffer(this.offset+this.rgbSize);
		this.pos = 0;
		tempBuffer.write(this.flag,this.pos,2);this.pos+=2;
		tempBuffer.writeUInt32LE(this.fileSize,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.reserved,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.offset,this.pos);this.pos+=4;

		tempBuffer.writeUInt32LE(this.headerInfoSize,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.width,this.pos);this.pos+=4;
		tempBuffer.writeInt32LE(-this.height,this.pos);this.pos+=4;
		tempBuffer.writeUInt16LE(this.planes,this.pos);this.pos+=2;
		tempBuffer.writeUInt16LE(this.bitPP,this.pos);this.pos+=2;
		tempBuffer.writeUInt32LE(this.compress,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.rgbSize,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.hr,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.vr,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.colors,this.pos);this.pos+=4;
		tempBuffer.writeUInt32LE(this.importantColors,this.pos);this.pos+=4;

		var i=0;
		var rowBytes = 3*this.width+this.extraBytes;

		for (var y = 0; y <this.height; y++){
			for (var x = 0; x < this.width; x++){
				var p = this.pos+y*rowBytes+x*3;
				i++;//a
				tempBuffer[p]= this.buffer[i++];//b
				tempBuffer[p+1] = this.buffer[i++];//g
				tempBuffer[p+2]  = this.buffer[i++];//r
			}
			if(this.extraBytes>0){
				var fillOffset = this.pos+y*rowBytes+this.width*3;
				tempBuffer.fill(0,fillOffset,fillOffset+this.extraBytes);
			}
		}

		return tempBuffer;
	};

	module.exports = function(imgData, quality) {
	 	var encoder = new BmpEncoder(imgData);
		var data = encoder.encode();
	  return {
	    data: data,
	    width: imgData.width,
	    height: imgData.height
	  };
	};

	}).call(this,require("buffer").Buffer);
	},{"buffer":16}],11:[function(require,module,exports){

	},{}],12:[function(require,module,exports){
	(function (process,Buffer){
	/* eslint camelcase: "off" */

	var assert = require('assert');

	var Zstream = require('pako/lib/zlib/zstream');
	var zlib_deflate = require('pako/lib/zlib/deflate.js');
	var zlib_inflate = require('pako/lib/zlib/inflate.js');
	var constants = require('pako/lib/zlib/constants');

	for (var key in constants) {
	  exports[key] = constants[key];
	}

	// zlib modes
	exports.NONE = 0;
	exports.DEFLATE = 1;
	exports.INFLATE = 2;
	exports.GZIP = 3;
	exports.GUNZIP = 4;
	exports.DEFLATERAW = 5;
	exports.INFLATERAW = 6;
	exports.UNZIP = 7;

	var GZIP_HEADER_ID1 = 0x1f;
	var GZIP_HEADER_ID2 = 0x8b;

	/**
	 * Emulate Node's zlib C++ layer for use by the JS layer in index.js
	 */
	function Zlib(mode) {
	  if (typeof mode !== 'number' || mode < exports.DEFLATE || mode > exports.UNZIP) {
	    throw new TypeError('Bad argument');
	  }

	  this.dictionary = null;
	  this.err = 0;
	  this.flush = 0;
	  this.init_done = false;
	  this.level = 0;
	  this.memLevel = 0;
	  this.mode = mode;
	  this.strategy = 0;
	  this.windowBits = 0;
	  this.write_in_progress = false;
	  this.pending_close = false;
	  this.gzip_id_bytes_read = 0;
	}

	Zlib.prototype.close = function () {
	  if (this.write_in_progress) {
	    this.pending_close = true;
	    return;
	  }

	  this.pending_close = false;

	  assert(this.init_done, 'close before init');
	  assert(this.mode <= exports.UNZIP);

	  if (this.mode === exports.DEFLATE || this.mode === exports.GZIP || this.mode === exports.DEFLATERAW) {
	    zlib_deflate.deflateEnd(this.strm);
	  } else if (this.mode === exports.INFLATE || this.mode === exports.GUNZIP || this.mode === exports.INFLATERAW || this.mode === exports.UNZIP) {
	    zlib_inflate.inflateEnd(this.strm);
	  }

	  this.mode = exports.NONE;

	  this.dictionary = null;
	};

	Zlib.prototype.write = function (flush, input, in_off, in_len, out, out_off, out_len) {
	  return this._write(true, flush, input, in_off, in_len, out, out_off, out_len);
	};

	Zlib.prototype.writeSync = function (flush, input, in_off, in_len, out, out_off, out_len) {
	  return this._write(false, flush, input, in_off, in_len, out, out_off, out_len);
	};

	Zlib.prototype._write = function (async, flush, input, in_off, in_len, out, out_off, out_len) {
	  assert.equal(arguments.length, 8);

	  assert(this.init_done, 'write before init');
	  assert(this.mode !== exports.NONE, 'already finalized');
	  assert.equal(false, this.write_in_progress, 'write already in progress');
	  assert.equal(false, this.pending_close, 'close is pending');

	  this.write_in_progress = true;

	  assert.equal(false, flush === undefined, 'must provide flush value');

	  this.write_in_progress = true;

	  if (flush !== exports.Z_NO_FLUSH && flush !== exports.Z_PARTIAL_FLUSH && flush !== exports.Z_SYNC_FLUSH && flush !== exports.Z_FULL_FLUSH && flush !== exports.Z_FINISH && flush !== exports.Z_BLOCK) {
	    throw new Error('Invalid flush value');
	  }

	  if (input == null) {
	    input = Buffer.alloc(0);
	    in_len = 0;
	    in_off = 0;
	  }

	  this.strm.avail_in = in_len;
	  this.strm.input = input;
	  this.strm.next_in = in_off;
	  this.strm.avail_out = out_len;
	  this.strm.output = out;
	  this.strm.next_out = out_off;
	  this.flush = flush;

	  if (!async) {
	    // sync version
	    this._process();

	    if (this._checkError()) {
	      return this._afterSync();
	    }
	    return;
	  }

	  // async version
	  var self = this;
	  process.nextTick(function () {
	    self._process();
	    self._after();
	  });

	  return this;
	};

	Zlib.prototype._afterSync = function () {
	  var avail_out = this.strm.avail_out;
	  var avail_in = this.strm.avail_in;

	  this.write_in_progress = false;

	  return [avail_in, avail_out];
	};

	Zlib.prototype._process = function () {
	  var next_expected_header_byte = null;

	  // If the avail_out is left at 0, then it means that it ran out
	  // of room.  If there was avail_out left over, then it means
	  // that all of the input was consumed.
	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.GZIP:
	    case exports.DEFLATERAW:
	      this.err = zlib_deflate.deflate(this.strm, this.flush);
	      break;
	    case exports.UNZIP:
	      if (this.strm.avail_in > 0) {
	        next_expected_header_byte = this.strm.next_in;
	      }

	      switch (this.gzip_id_bytes_read) {
	        case 0:
	          if (next_expected_header_byte === null) {
	            break;
	          }

	          if (this.strm.input[next_expected_header_byte] === GZIP_HEADER_ID1) {
	            this.gzip_id_bytes_read = 1;
	            next_expected_header_byte++;

	            if (this.strm.avail_in === 1) {
	              // The only available byte was already read.
	              break;
	            }
	          } else {
	            this.mode = exports.INFLATE;
	            break;
	          }

	        // fallthrough
	        case 1:
	          if (next_expected_header_byte === null) {
	            break;
	          }

	          if (this.strm.input[next_expected_header_byte] === GZIP_HEADER_ID2) {
	            this.gzip_id_bytes_read = 2;
	            this.mode = exports.GUNZIP;
	          } else {
	            // There is no actual difference between INFLATE and INFLATERAW
	            // (after initialization).
	            this.mode = exports.INFLATE;
	          }

	          break;
	        default:
	          throw new Error('invalid number of gzip magic number bytes read');
	      }

	    // fallthrough
	    case exports.INFLATE:
	    case exports.GUNZIP:
	    case exports.INFLATERAW:
	      this.err = zlib_inflate.inflate(this.strm, this.flush

	      // If data was encoded with dictionary
	      );if (this.err === exports.Z_NEED_DICT && this.dictionary) {
	        // Load it
	        this.err = zlib_inflate.inflateSetDictionary(this.strm, this.dictionary);
	        if (this.err === exports.Z_OK) {
	          // And try to decode again
	          this.err = zlib_inflate.inflate(this.strm, this.flush);
	        } else if (this.err === exports.Z_DATA_ERROR) {
	          // Both inflateSetDictionary() and inflate() return Z_DATA_ERROR.
	          // Make it possible for After() to tell a bad dictionary from bad
	          // input.
	          this.err = exports.Z_NEED_DICT;
	        }
	      }
	      while (this.strm.avail_in > 0 && this.mode === exports.GUNZIP && this.err === exports.Z_STREAM_END && this.strm.next_in[0] !== 0x00) {
	        // Bytes remain in input buffer. Perhaps this is another compressed
	        // member in the same archive, or just trailing garbage.
	        // Trailing zero bytes are okay, though, since they are frequently
	        // used for padding.

	        this.reset();
	        this.err = zlib_inflate.inflate(this.strm, this.flush);
	      }
	      break;
	    default:
	      throw new Error('Unknown mode ' + this.mode);
	  }
	};

	Zlib.prototype._checkError = function () {
	  // Acceptable error states depend on the type of zlib stream.
	  switch (this.err) {
	    case exports.Z_OK:
	    case exports.Z_BUF_ERROR:
	      if (this.strm.avail_out !== 0 && this.flush === exports.Z_FINISH) {
	        this._error('unexpected end of file');
	        return false;
	      }
	      break;
	    case exports.Z_STREAM_END:
	      // normal statuses, not fatal
	      break;
	    case exports.Z_NEED_DICT:
	      if (this.dictionary == null) {
	        this._error('Missing dictionary');
	      } else {
	        this._error('Bad dictionary');
	      }
	      return false;
	    default:
	      // something else.
	      this._error('Zlib error');
	      return false;
	  }

	  return true;
	};

	Zlib.prototype._after = function () {
	  if (!this._checkError()) {
	    return;
	  }

	  var avail_out = this.strm.avail_out;
	  var avail_in = this.strm.avail_in;

	  this.write_in_progress = false;

	  // call the write() cb
	  this.callback(avail_in, avail_out);

	  if (this.pending_close) {
	    this.close();
	  }
	};

	Zlib.prototype._error = function (message) {
	  if (this.strm.msg) {
	    message = this.strm.msg;
	  }
	  this.onerror(message, this.err

	  // no hope of rescue.
	  );this.write_in_progress = false;
	  if (this.pending_close) {
	    this.close();
	  }
	};

	Zlib.prototype.init = function (windowBits, level, memLevel, strategy, dictionary) {
	  assert(arguments.length === 4 || arguments.length === 5, 'init(windowBits, level, memLevel, strategy, [dictionary])');

	  assert(windowBits >= 8 && windowBits <= 15, 'invalid windowBits');
	  assert(level >= -1 && level <= 9, 'invalid compression level');

	  assert(memLevel >= 1 && memLevel <= 9, 'invalid memlevel');

	  assert(strategy === exports.Z_FILTERED || strategy === exports.Z_HUFFMAN_ONLY || strategy === exports.Z_RLE || strategy === exports.Z_FIXED || strategy === exports.Z_DEFAULT_STRATEGY, 'invalid strategy');

	  this._init(level, windowBits, memLevel, strategy, dictionary);
	  this._setDictionary();
	};

	Zlib.prototype.params = function () {
	  throw new Error('deflateParams Not supported');
	};

	Zlib.prototype.reset = function () {
	  this._reset();
	  this._setDictionary();
	};

	Zlib.prototype._init = function (level, windowBits, memLevel, strategy, dictionary) {
	  this.level = level;
	  this.windowBits = windowBits;
	  this.memLevel = memLevel;
	  this.strategy = strategy;

	  this.flush = exports.Z_NO_FLUSH;

	  this.err = exports.Z_OK;

	  if (this.mode === exports.GZIP || this.mode === exports.GUNZIP) {
	    this.windowBits += 16;
	  }

	  if (this.mode === exports.UNZIP) {
	    this.windowBits += 32;
	  }

	  if (this.mode === exports.DEFLATERAW || this.mode === exports.INFLATERAW) {
	    this.windowBits = -1 * this.windowBits;
	  }

	  this.strm = new Zstream();

	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.GZIP:
	    case exports.DEFLATERAW:
	      this.err = zlib_deflate.deflateInit2(this.strm, this.level, exports.Z_DEFLATED, this.windowBits, this.memLevel, this.strategy);
	      break;
	    case exports.INFLATE:
	    case exports.GUNZIP:
	    case exports.INFLATERAW:
	    case exports.UNZIP:
	      this.err = zlib_inflate.inflateInit2(this.strm, this.windowBits);
	      break;
	    default:
	      throw new Error('Unknown mode ' + this.mode);
	  }

	  if (this.err !== exports.Z_OK) {
	    this._error('Init error');
	  }

	  this.dictionary = dictionary;

	  this.write_in_progress = false;
	  this.init_done = true;
	};

	Zlib.prototype._setDictionary = function () {
	  if (this.dictionary == null) {
	    return;
	  }

	  this.err = exports.Z_OK;

	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.DEFLATERAW:
	      this.err = zlib_deflate.deflateSetDictionary(this.strm, this.dictionary);
	      break;
	  }

	  if (this.err !== exports.Z_OK) {
	    this._error('Failed to set dictionary');
	  }
	};

	Zlib.prototype._reset = function () {
	  this.err = exports.Z_OK;

	  switch (this.mode) {
	    case exports.DEFLATE:
	    case exports.DEFLATERAW:
	    case exports.GZIP:
	      this.err = zlib_deflate.deflateReset(this.strm);
	      break;
	    case exports.INFLATE:
	    case exports.INFLATERAW:
	    case exports.GUNZIP:
	      this.err = zlib_inflate.inflateReset(this.strm);
	      break;
	  }

	  if (this.err !== exports.Z_OK) {
	    this._error('Failed to reset stream');
	  }
	};

	exports.Zlib = Zlib;
	}).call(this,require('_process'),require("buffer").Buffer);
	},{"_process":226,"assert":3,"buffer":16,"pako/lib/zlib/constants":185,"pako/lib/zlib/deflate.js":187,"pako/lib/zlib/inflate.js":190,"pako/lib/zlib/zstream":194}],13:[function(require,module,exports){
	(function (process){

	var Buffer = require('buffer').Buffer;
	var Transform = require('stream').Transform;
	var binding = require('./binding');
	var util = require('util');
	var assert = require('assert').ok;
	var kMaxLength = require('buffer').kMaxLength;
	var kRangeErrorMessage = 'Cannot create final Buffer. It would be larger ' + 'than 0x' + kMaxLength.toString(16) + ' bytes';

	// zlib doesn't provide these, so kludge them in following the same
	// const naming scheme zlib uses.
	binding.Z_MIN_WINDOWBITS = 8;
	binding.Z_MAX_WINDOWBITS = 15;
	binding.Z_DEFAULT_WINDOWBITS = 15;

	// fewer than 64 bytes per chunk is stupid.
	// technically it could work with as few as 8, but even 64 bytes
	// is absurdly low.  Usually a MB or more is best.
	binding.Z_MIN_CHUNK = 64;
	binding.Z_MAX_CHUNK = Infinity;
	binding.Z_DEFAULT_CHUNK = 16 * 1024;

	binding.Z_MIN_MEMLEVEL = 1;
	binding.Z_MAX_MEMLEVEL = 9;
	binding.Z_DEFAULT_MEMLEVEL = 8;

	binding.Z_MIN_LEVEL = -1;
	binding.Z_MAX_LEVEL = 9;
	binding.Z_DEFAULT_LEVEL = binding.Z_DEFAULT_COMPRESSION;

	// expose all the zlib constants
	var bkeys = Object.keys(binding);
	for (var bk = 0; bk < bkeys.length; bk++) {
	  var bkey = bkeys[bk];
	  if (bkey.match(/^Z/)) {
	    Object.defineProperty(exports, bkey, {
	      enumerable: true, value: binding[bkey], writable: false
	    });
	  }
	}

	// translation table for return codes.
	var codes = {
	  Z_OK: binding.Z_OK,
	  Z_STREAM_END: binding.Z_STREAM_END,
	  Z_NEED_DICT: binding.Z_NEED_DICT,
	  Z_ERRNO: binding.Z_ERRNO,
	  Z_STREAM_ERROR: binding.Z_STREAM_ERROR,
	  Z_DATA_ERROR: binding.Z_DATA_ERROR,
	  Z_MEM_ERROR: binding.Z_MEM_ERROR,
	  Z_BUF_ERROR: binding.Z_BUF_ERROR,
	  Z_VERSION_ERROR: binding.Z_VERSION_ERROR
	};

	var ckeys = Object.keys(codes);
	for (var ck = 0; ck < ckeys.length; ck++) {
	  var ckey = ckeys[ck];
	  codes[codes[ckey]] = ckey;
	}

	Object.defineProperty(exports, 'codes', {
	  enumerable: true, value: Object.freeze(codes), writable: false
	});

	exports.Deflate = Deflate;
	exports.Inflate = Inflate;
	exports.Gzip = Gzip;
	exports.Gunzip = Gunzip;
	exports.DeflateRaw = DeflateRaw;
	exports.InflateRaw = InflateRaw;
	exports.Unzip = Unzip;

	exports.createDeflate = function (o) {
	  return new Deflate(o);
	};

	exports.createInflate = function (o) {
	  return new Inflate(o);
	};

	exports.createDeflateRaw = function (o) {
	  return new DeflateRaw(o);
	};

	exports.createInflateRaw = function (o) {
	  return new InflateRaw(o);
	};

	exports.createGzip = function (o) {
	  return new Gzip(o);
	};

	exports.createGunzip = function (o) {
	  return new Gunzip(o);
	};

	exports.createUnzip = function (o) {
	  return new Unzip(o);
	};

	// Convenience methods.
	// compress/decompress a string or buffer in one step.
	exports.deflate = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Deflate(opts), buffer, callback);
	};

	exports.deflateSync = function (buffer, opts) {
	  return zlibBufferSync(new Deflate(opts), buffer);
	};

	exports.gzip = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Gzip(opts), buffer, callback);
	};

	exports.gzipSync = function (buffer, opts) {
	  return zlibBufferSync(new Gzip(opts), buffer);
	};

	exports.deflateRaw = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new DeflateRaw(opts), buffer, callback);
	};

	exports.deflateRawSync = function (buffer, opts) {
	  return zlibBufferSync(new DeflateRaw(opts), buffer);
	};

	exports.unzip = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Unzip(opts), buffer, callback);
	};

	exports.unzipSync = function (buffer, opts) {
	  return zlibBufferSync(new Unzip(opts), buffer);
	};

	exports.inflate = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Inflate(opts), buffer, callback);
	};

	exports.inflateSync = function (buffer, opts) {
	  return zlibBufferSync(new Inflate(opts), buffer);
	};

	exports.gunzip = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new Gunzip(opts), buffer, callback);
	};

	exports.gunzipSync = function (buffer, opts) {
	  return zlibBufferSync(new Gunzip(opts), buffer);
	};

	exports.inflateRaw = function (buffer, opts, callback) {
	  if (typeof opts === 'function') {
	    callback = opts;
	    opts = {};
	  }
	  return zlibBuffer(new InflateRaw(opts), buffer, callback);
	};

	exports.inflateRawSync = function (buffer, opts) {
	  return zlibBufferSync(new InflateRaw(opts), buffer);
	};

	function zlibBuffer(engine, buffer, callback) {
	  var buffers = [];
	  var nread = 0;

	  engine.on('error', onError);
	  engine.on('end', onEnd);

	  engine.end(buffer);
	  flow();

	  function flow() {
	    var chunk;
	    while (null !== (chunk = engine.read())) {
	      buffers.push(chunk);
	      nread += chunk.length;
	    }
	    engine.once('readable', flow);
	  }

	  function onError(err) {
	    engine.removeListener('end', onEnd);
	    engine.removeListener('readable', flow);
	    callback(err);
	  }

	  function onEnd() {
	    var buf;
	    var err = null;

	    if (nread >= kMaxLength) {
	      err = new RangeError(kRangeErrorMessage);
	    } else {
	      buf = Buffer.concat(buffers, nread);
	    }

	    buffers = [];
	    engine.close();
	    callback(err, buf);
	  }
	}

	function zlibBufferSync(engine, buffer) {
	  if (typeof buffer === 'string') buffer = Buffer.from(buffer);

	  if (!Buffer.isBuffer(buffer)) throw new TypeError('Not a string or buffer');

	  var flushFlag = engine._finishFlushFlag;

	  return engine._processChunk(buffer, flushFlag);
	}

	// generic zlib
	// minimal 2-byte header
	function Deflate(opts) {
	  if (!(this instanceof Deflate)) return new Deflate(opts);
	  Zlib.call(this, opts, binding.DEFLATE);
	}

	function Inflate(opts) {
	  if (!(this instanceof Inflate)) return new Inflate(opts);
	  Zlib.call(this, opts, binding.INFLATE);
	}

	// gzip - bigger header, same deflate compression
	function Gzip(opts) {
	  if (!(this instanceof Gzip)) return new Gzip(opts);
	  Zlib.call(this, opts, binding.GZIP);
	}

	function Gunzip(opts) {
	  if (!(this instanceof Gunzip)) return new Gunzip(opts);
	  Zlib.call(this, opts, binding.GUNZIP);
	}

	// raw - no header
	function DeflateRaw(opts) {
	  if (!(this instanceof DeflateRaw)) return new DeflateRaw(opts);
	  Zlib.call(this, opts, binding.DEFLATERAW);
	}

	function InflateRaw(opts) {
	  if (!(this instanceof InflateRaw)) return new InflateRaw(opts);
	  Zlib.call(this, opts, binding.INFLATERAW);
	}

	// auto-detect header.
	function Unzip(opts) {
	  if (!(this instanceof Unzip)) return new Unzip(opts);
	  Zlib.call(this, opts, binding.UNZIP);
	}

	function isValidFlushFlag(flag) {
	  return flag === binding.Z_NO_FLUSH || flag === binding.Z_PARTIAL_FLUSH || flag === binding.Z_SYNC_FLUSH || flag === binding.Z_FULL_FLUSH || flag === binding.Z_FINISH || flag === binding.Z_BLOCK;
	}

	// the Zlib class they all inherit from
	// This thing manages the queue of requests, and returns
	// true or false if there is anything in the queue when
	// you call the .write() method.

	function Zlib(opts, mode) {
	  var _this = this;

	  this._opts = opts = opts || {};
	  this._chunkSize = opts.chunkSize || exports.Z_DEFAULT_CHUNK;

	  Transform.call(this, opts);

	  if (opts.flush && !isValidFlushFlag(opts.flush)) {
	    throw new Error('Invalid flush flag: ' + opts.flush);
	  }
	  if (opts.finishFlush && !isValidFlushFlag(opts.finishFlush)) {
	    throw new Error('Invalid flush flag: ' + opts.finishFlush);
	  }

	  this._flushFlag = opts.flush || binding.Z_NO_FLUSH;
	  this._finishFlushFlag = typeof opts.finishFlush !== 'undefined' ? opts.finishFlush : binding.Z_FINISH;

	  if (opts.chunkSize) {
	    if (opts.chunkSize < exports.Z_MIN_CHUNK || opts.chunkSize > exports.Z_MAX_CHUNK) {
	      throw new Error('Invalid chunk size: ' + opts.chunkSize);
	    }
	  }

	  if (opts.windowBits) {
	    if (opts.windowBits < exports.Z_MIN_WINDOWBITS || opts.windowBits > exports.Z_MAX_WINDOWBITS) {
	      throw new Error('Invalid windowBits: ' + opts.windowBits);
	    }
	  }

	  if (opts.level) {
	    if (opts.level < exports.Z_MIN_LEVEL || opts.level > exports.Z_MAX_LEVEL) {
	      throw new Error('Invalid compression level: ' + opts.level);
	    }
	  }

	  if (opts.memLevel) {
	    if (opts.memLevel < exports.Z_MIN_MEMLEVEL || opts.memLevel > exports.Z_MAX_MEMLEVEL) {
	      throw new Error('Invalid memLevel: ' + opts.memLevel);
	    }
	  }

	  if (opts.strategy) {
	    if (opts.strategy != exports.Z_FILTERED && opts.strategy != exports.Z_HUFFMAN_ONLY && opts.strategy != exports.Z_RLE && opts.strategy != exports.Z_FIXED && opts.strategy != exports.Z_DEFAULT_STRATEGY) {
	      throw new Error('Invalid strategy: ' + opts.strategy);
	    }
	  }

	  if (opts.dictionary) {
	    if (!Buffer.isBuffer(opts.dictionary)) {
	      throw new Error('Invalid dictionary: it should be a Buffer instance');
	    }
	  }

	  this._handle = new binding.Zlib(mode);

	  var self = this;
	  this._hadError = false;
	  this._handle.onerror = function (message, errno) {
	    // there is no way to cleanly recover.
	    // continuing only obscures problems.
	    _close(self);
	    self._hadError = true;

	    var error = new Error(message);
	    error.errno = errno;
	    error.code = exports.codes[errno];
	    self.emit('error', error);
	  };

	  var level = exports.Z_DEFAULT_COMPRESSION;
	  if (typeof opts.level === 'number') level = opts.level;

	  var strategy = exports.Z_DEFAULT_STRATEGY;
	  if (typeof opts.strategy === 'number') strategy = opts.strategy;

	  this._handle.init(opts.windowBits || exports.Z_DEFAULT_WINDOWBITS, level, opts.memLevel || exports.Z_DEFAULT_MEMLEVEL, strategy, opts.dictionary);

	  this._buffer = Buffer.allocUnsafe(this._chunkSize);
	  this._offset = 0;
	  this._level = level;
	  this._strategy = strategy;

	  this.once('end', this.close);

	  Object.defineProperty(this, '_closed', {
	    get: function () {
	      return !_this._handle;
	    },
	    configurable: true,
	    enumerable: true
	  });
	}

	util.inherits(Zlib, Transform);

	Zlib.prototype.params = function (level, strategy, callback) {
	  if (level < exports.Z_MIN_LEVEL || level > exports.Z_MAX_LEVEL) {
	    throw new RangeError('Invalid compression level: ' + level);
	  }
	  if (strategy != exports.Z_FILTERED && strategy != exports.Z_HUFFMAN_ONLY && strategy != exports.Z_RLE && strategy != exports.Z_FIXED && strategy != exports.Z_DEFAULT_STRATEGY) {
	    throw new TypeError('Invalid strategy: ' + strategy);
	  }

	  if (this._level !== level || this._strategy !== strategy) {
	    var self = this;
	    this.flush(binding.Z_SYNC_FLUSH, function () {
	      assert(self._handle, 'zlib binding closed');
	      self._handle.params(level, strategy);
	      if (!self._hadError) {
	        self._level = level;
	        self._strategy = strategy;
	        if (callback) callback();
	      }
	    });
	  } else {
	    process.nextTick(callback);
	  }
	};

	Zlib.prototype.reset = function () {
	  assert(this._handle, 'zlib binding closed');
	  return this._handle.reset();
	};

	// This is the _flush function called by the transform class,
	// internally, when the last chunk has been written.
	Zlib.prototype._flush = function (callback) {
	  this._transform(Buffer.alloc(0), '', callback);
	};

	Zlib.prototype.flush = function (kind, callback) {
	  var _this2 = this;

	  var ws = this._writableState;

	  if (typeof kind === 'function' || kind === undefined && !callback) {
	    callback = kind;
	    kind = binding.Z_FULL_FLUSH;
	  }

	  if (ws.ended) {
	    if (callback) process.nextTick(callback);
	  } else if (ws.ending) {
	    if (callback) this.once('end', callback);
	  } else if (ws.needDrain) {
	    if (callback) {
	      this.once('drain', function () {
	        return _this2.flush(kind, callback);
	      });
	    }
	  } else {
	    this._flushFlag = kind;
	    this.write(Buffer.alloc(0), '', callback);
	  }
	};

	Zlib.prototype.close = function (callback) {
	  _close(this, callback);
	  process.nextTick(emitCloseNT, this);
	};

	function _close(engine, callback) {
	  if (callback) process.nextTick(callback);

	  // Caller may invoke .close after a zlib error (which will null _handle).
	  if (!engine._handle) return;

	  engine._handle.close();
	  engine._handle = null;
	}

	function emitCloseNT(self) {
	  self.emit('close');
	}

	Zlib.prototype._transform = function (chunk, encoding, cb) {
	  var flushFlag;
	  var ws = this._writableState;
	  var ending = ws.ending || ws.ended;
	  var last = ending && (!chunk || ws.length === chunk.length);

	  if (chunk !== null && !Buffer.isBuffer(chunk)) return cb(new Error('invalid input'));

	  if (!this._handle) return cb(new Error('zlib binding closed'));

	  // If it's the last chunk, or a final flush, we use the Z_FINISH flush flag
	  // (or whatever flag was provided using opts.finishFlush).
	  // If it's explicitly flushing at some other time, then we use
	  // Z_FULL_FLUSH. Otherwise, use Z_NO_FLUSH for maximum compression
	  // goodness.
	  if (last) flushFlag = this._finishFlushFlag;else {
	    flushFlag = this._flushFlag;
	    // once we've flushed the last of the queue, stop flushing and
	    // go back to the normal behavior.
	    if (chunk.length >= ws.length) {
	      this._flushFlag = this._opts.flush || binding.Z_NO_FLUSH;
	    }
	  }

	  this._processChunk(chunk, flushFlag, cb);
	};

	Zlib.prototype._processChunk = function (chunk, flushFlag, cb) {
	  var availInBefore = chunk && chunk.length;
	  var availOutBefore = this._chunkSize - this._offset;
	  var inOff = 0;

	  var self = this;

	  var async = typeof cb === 'function';

	  if (!async) {
	    var buffers = [];
	    var nread = 0;

	    var error;
	    this.on('error', function (er) {
	      error = er;
	    });

	    assert(this._handle, 'zlib binding closed');
	    do {
	      var res = this._handle.writeSync(flushFlag, chunk, // in
	      inOff, // in_off
	      availInBefore, // in_len
	      this._buffer, // out
	      this._offset, //out_off
	      availOutBefore); // out_len
	    } while (!this._hadError && callback(res[0], res[1]));

	    if (this._hadError) {
	      throw error;
	    }

	    if (nread >= kMaxLength) {
	      _close(this);
	      throw new RangeError(kRangeErrorMessage);
	    }

	    var buf = Buffer.concat(buffers, nread);
	    _close(this);

	    return buf;
	  }

	  assert(this._handle, 'zlib binding closed');
	  var req = this._handle.write(flushFlag, chunk, // in
	  inOff, // in_off
	  availInBefore, // in_len
	  this._buffer, // out
	  this._offset, //out_off
	  availOutBefore); // out_len

	  req.buffer = chunk;
	  req.callback = callback;

	  function callback(availInAfter, availOutAfter) {
	    // When the callback is used in an async write, the callback's
	    // context is the `req` object that was created. The req object
	    // is === this._handle, and that's why it's important to null
	    // out the values after they are done being used. `this._handle`
	    // can stay in memory longer than the callback and buffer are needed.
	    if (this) {
	      this.buffer = null;
	      this.callback = null;
	    }

	    if (self._hadError) return;

	    var have = availOutBefore - availOutAfter;
	    assert(have >= 0, 'have should not go down');

	    if (have > 0) {
	      var out = self._buffer.slice(self._offset, self._offset + have);
	      self._offset += have;
	      // serve some output to the consumer.
	      if (async) {
	        self.push(out);
	      } else {
	        buffers.push(out);
	        nread += out.length;
	      }
	    }

	    // exhausted the output buffer, or used all the input create a new one.
	    if (availOutAfter === 0 || self._offset >= self._chunkSize) {
	      availOutBefore = self._chunkSize;
	      self._offset = 0;
	      self._buffer = Buffer.allocUnsafe(self._chunkSize);
	    }

	    if (availOutAfter === 0) {
	      // Not actually done.  Need to reprocess.
	      // Also, update the availInBefore to the availInAfter value,
	      // so that if we have to hit it a third (fourth, etc.) time,
	      // it'll have the correct byte counts.
	      inOff += availInBefore - availInAfter;
	      availInBefore = availInAfter;

	      if (!async) return true;

	      var newReq = self._handle.write(flushFlag, chunk, inOff, availInBefore, self._buffer, self._offset, self._chunkSize);
	      newReq.callback = callback; // this same function
	      newReq.buffer = chunk;
	      return;
	    }

	    if (!async) return false;

	    // finished with the chunk.
	    cb();
	  }
	};

	util.inherits(Deflate, Zlib);
	util.inherits(Inflate, Zlib);
	util.inherits(Gzip, Zlib);
	util.inherits(Gunzip, Zlib);
	util.inherits(DeflateRaw, Zlib);
	util.inherits(InflateRaw, Zlib);
	util.inherits(Unzip, Zlib);
	}).call(this,require('_process'));
	},{"./binding":12,"_process":226,"assert":3,"buffer":16,"stream":245,"util":261}],14:[function(require,module,exports){
	arguments[4][11][0].apply(exports,arguments);
	},{"dup":11}],15:[function(require,module,exports){
	var Buffer = require('buffer').Buffer; // for use with browserify

	module.exports = function (a, b) {
	    if (!Buffer.isBuffer(a)) return undefined;
	    if (!Buffer.isBuffer(b)) return undefined;
	    if (typeof a.equals === 'function') return a.equals(b);
	    if (a.length !== b.length) return false;
	    
	    for (var i = 0; i < a.length; i++) {
	        if (a[i] !== b[i]) return false;
	    }
	    
	    return true;
	};

	},{"buffer":16}],16:[function(require,module,exports){

	var base64 = require('base64-js');
	var ieee754 = require('ieee754');

	exports.Buffer = Buffer;
	exports.SlowBuffer = SlowBuffer;
	exports.INSPECT_MAX_BYTES = 50;

	var K_MAX_LENGTH = 0x7fffffff;
	exports.kMaxLength = K_MAX_LENGTH;

	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
	 *               implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * We report that the browser does not support typed arrays if the are not subclassable
	 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
	 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
	 * for __proto__ and has a buggy typed array implementation.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();

	if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
	    typeof console.error === 'function') {
	  console.error(
	    'This browser lacks typed array (Uint8Array) support which is required by ' +
	    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
	  );
	}

	function typedArraySupport () {
	  // Can typed array instances can be augmented?
	  try {
	    var arr = new Uint8Array(1);
	    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }};
	    return arr.foo() === 42
	  } catch (e) {
	    return false
	  }
	}

	Object.defineProperty(Buffer.prototype, 'parent', {
	  enumerable: true,
	  get: function () {
	    if (!Buffer.isBuffer(this)) return undefined
	    return this.buffer
	  }
	});

	Object.defineProperty(Buffer.prototype, 'offset', {
	  enumerable: true,
	  get: function () {
	    if (!Buffer.isBuffer(this)) return undefined
	    return this.byteOffset
	  }
	});

	function createBuffer (length) {
	  if (length > K_MAX_LENGTH) {
	    throw new RangeError('The value "' + length + '" is invalid for option "size"')
	  }
	  // Return an augmented `Uint8Array` instance
	  var buf = new Uint8Array(length);
	  buf.__proto__ = Buffer.prototype;
	  return buf
	}

	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */

	function Buffer (arg, encodingOrOffset, length) {
	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new TypeError(
	        'The "string" argument must be of type string. Received type number'
	      )
	    }
	    return allocUnsafe(arg)
	  }
	  return from(arg, encodingOrOffset, length)
	}

	// Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
	if (typeof Symbol !== 'undefined' && Symbol.species != null &&
	    Buffer[Symbol.species] === Buffer) {
	  Object.defineProperty(Buffer, Symbol.species, {
	    value: null,
	    configurable: true,
	    enumerable: false,
	    writable: false
	  });
	}

	Buffer.poolSize = 8192; // not used by this implementation

	function from (value, encodingOrOffset, length) {
	  if (typeof value === 'string') {
	    return fromString(value, encodingOrOffset)
	  }

	  if (ArrayBuffer.isView(value)) {
	    return fromArrayLike(value)
	  }

	  if (value == null) {
	    throw TypeError(
	      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
	      'or Array-like Object. Received type ' + (typeof value)
	    )
	  }

	  if (isInstance(value, ArrayBuffer) ||
	      (value && isInstance(value.buffer, ArrayBuffer))) {
	    return fromArrayBuffer(value, encodingOrOffset, length)
	  }

	  if (typeof value === 'number') {
	    throw new TypeError(
	      'The "value" argument must not be of type number. Received type number'
	    )
	  }

	  var valueOf = value.valueOf && value.valueOf();
	  if (valueOf != null && valueOf !== value) {
	    return Buffer.from(valueOf, encodingOrOffset, length)
	  }

	  var b = fromObject(value);
	  if (b) return b

	  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
	      typeof value[Symbol.toPrimitive] === 'function') {
	    return Buffer.from(
	      value[Symbol.toPrimitive]('string'), encodingOrOffset, length
	    )
	  }

	  throw new TypeError(
	    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
	    'or Array-like Object. Received type ' + (typeof value)
	  )
	}

	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(value, encodingOrOffset, length)
	};

	// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
	// https://github.com/feross/buffer/pull/148
	Buffer.prototype.__proto__ = Uint8Array.prototype;
	Buffer.__proto__ = Uint8Array;

	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be of type number')
	  } else if (size < 0) {
	    throw new RangeError('The value "' + size + '" is invalid for option "size"')
	  }
	}

	function alloc (size, fill, encoding) {
	  assertSize(size);
	  if (size <= 0) {
	    return createBuffer(size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(size).fill(fill, encoding)
	      : createBuffer(size).fill(fill)
	  }
	  return createBuffer(size)
	}

	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(size, fill, encoding)
	};

	function allocUnsafe (size) {
	  assertSize(size);
	  return createBuffer(size < 0 ? 0 : checked(size) | 0)
	}

	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(size)
	};
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(size)
	};

	function fromString (string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8';
	  }

	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('Unknown encoding: ' + encoding)
	  }

	  var length = byteLength(string, encoding) | 0;
	  var buf = createBuffer(length);

	  var actual = buf.write(string, encoding);

	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    buf = buf.slice(0, actual);
	  }

	  return buf
	}

	function fromArrayLike (array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0;
	  var buf = createBuffer(length);
	  for (var i = 0; i < length; i += 1) {
	    buf[i] = array[i] & 255;
	  }
	  return buf
	}

	function fromArrayBuffer (array, byteOffset, length) {
	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('"offset" is outside of buffer bounds')
	  }

	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('"length" is outside of buffer bounds')
	  }

	  var buf;
	  if (byteOffset === undefined && length === undefined) {
	    buf = new Uint8Array(array);
	  } else if (length === undefined) {
	    buf = new Uint8Array(array, byteOffset);
	  } else {
	    buf = new Uint8Array(array, byteOffset, length);
	  }

	  // Return an augmented `Uint8Array` instance
	  buf.__proto__ = Buffer.prototype;
	  return buf
	}

	function fromObject (obj) {
	  if (Buffer.isBuffer(obj)) {
	    var len = checked(obj.length) | 0;
	    var buf = createBuffer(len);

	    if (buf.length === 0) {
	      return buf
	    }

	    obj.copy(buf, 0, 0, len);
	    return buf
	  }

	  if (obj.length !== undefined) {
	    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
	      return createBuffer(0)
	    }
	    return fromArrayLike(obj)
	  }

	  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
	    return fromArrayLike(obj.data)
	  }
	}

	function checked (length) {
	  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= K_MAX_LENGTH) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
	  }
	  return length | 0
	}

	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0;
	  }
	  return Buffer.alloc(+length)
	}

	Buffer.isBuffer = function isBuffer (b) {
	  return b != null && b._isBuffer === true &&
	    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
	};

	Buffer.compare = function compare (a, b) {
	  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
	  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError(
	      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
	    )
	  }

	  if (a === b) return 0

	  var x = a.length;
	  var y = b.length;

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i];
	      y = b[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	};

	Buffer.concat = function concat (list, length) {
	  if (!Array.isArray(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }

	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }

	  var i;
	  if (length === undefined) {
	    length = 0;
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length;
	    }
	  }

	  var buffer = Buffer.allocUnsafe(length);
	  var pos = 0;
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i];
	    if (isInstance(buf, Uint8Array)) {
	      buf = Buffer.from(buf);
	    }
	    if (!Buffer.isBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos);
	    pos += buf.length;
	  }
	  return buffer
	};

	function byteLength (string, encoding) {
	  if (Buffer.isBuffer(string)) {
	    return string.length
	  }
	  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    throw new TypeError(
	      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
	      'Received type ' + typeof string
	    )
	  }

	  var len = string.length;
	  var mustMatch = (arguments.length > 2 && arguments[2] === true);
	  if (!mustMatch && len === 0) return 0

	  // Use a for loop to avoid recursion
	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) {
	          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
	        }
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	}
	Buffer.byteLength = byteLength;

	function slowToString (encoding, start, end) {
	  var loweredCase = false;

	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.

	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0;
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }

	  if (end === undefined || end > this.length) {
	    end = this.length;
	  }

	  if (end <= 0) {
	    return ''
	  }

	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0;
	  start >>>= 0;

	  if (end <= start) {
	    return ''
	  }

	  if (!encoding) encoding = 'utf8';

	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)

	      case 'ascii':
	        return asciiSlice(this, start, end)

	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)

	      case 'base64':
	        return base64Slice(this, start, end)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase();
	        loweredCase = true;
	    }
	  }
	}

	// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
	// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
	// reliably in a browserify context because there could be multiple different
	// copies of the 'buffer' package in use. This method works even for Buffer
	// instances that were created from another copy of the `buffer` package.
	// See: https://github.com/feross/buffer/issues/154
	Buffer.prototype._isBuffer = true;

	function swap (b, n, m) {
	  var i = b[n];
	  b[n] = b[m];
	  b[m] = i;
	}

	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length;
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1);
	  }
	  return this
	};

	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length;
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3);
	    swap(this, i + 1, i + 2);
	  }
	  return this
	};

	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length;
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7);
	    swap(this, i + 1, i + 6);
	    swap(this, i + 2, i + 5);
	    swap(this, i + 3, i + 4);
	  }
	  return this
	};

	Buffer.prototype.toString = function toString () {
	  var length = this.length;
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	};

	Buffer.prototype.toLocaleString = Buffer.prototype.toString;

	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	};

	Buffer.prototype.inspect = function inspect () {
	  var str = '';
	  var max = exports.INSPECT_MAX_BYTES;
	  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
	  if (this.length > max) str += ' ... ';
	  return '<Buffer ' + str + '>'
	};

	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (isInstance(target, Uint8Array)) {
	    target = Buffer.from(target, target.offset, target.byteLength);
	  }
	  if (!Buffer.isBuffer(target)) {
	    throw new TypeError(
	      'The "target" argument must be one of type Buffer or Uint8Array. ' +
	      'Received type ' + (typeof target)
	    )
	  }

	  if (start === undefined) {
	    start = 0;
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0;
	  }
	  if (thisStart === undefined) {
	    thisStart = 0;
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length;
	  }

	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }

	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }

	  start >>>= 0;
	  end >>>= 0;
	  thisStart >>>= 0;
	  thisEnd >>>= 0;

	  if (this === target) return 0

	  var x = thisEnd - thisStart;
	  var y = end - start;
	  var len = Math.min(x, y);

	  var thisCopy = this.slice(thisStart, thisEnd);
	  var targetCopy = target.slice(start, end);

	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i];
	      y = targetCopy[i];
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	};

	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1

	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset;
	    byteOffset = 0;
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff;
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000;
	  }
	  byteOffset = +byteOffset; // Coerce to Number.
	  if (numberIsNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1);
	  }

	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1;
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0;
	    else return -1
	  }

	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding);
	  }

	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (Buffer.isBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF; // Search for a byte value [0-255]
	    if (typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }

	  throw new TypeError('val must be string, number or Buffer')
	}

	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1;
	  var arrLength = arr.length;
	  var valLength = val.length;

	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase();
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2;
	      arrLength /= 2;
	      valLength /= 2;
	      byteOffset /= 2;
	    }
	  }

	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }

	  var i;
	  if (dir) {
	    var foundIndex = -1;
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i;
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex;
	        foundIndex = -1;
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true;
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false;
	          break
	        }
	      }
	      if (found) return i
	    }
	  }

	  return -1
	}

	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	};

	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	};

	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	};

	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0;
	  var remaining = buf.length - offset;
	  if (!length) {
	    length = remaining;
	  } else {
	    length = Number(length);
	    if (length > remaining) {
	      length = remaining;
	    }
	  }

	  var strLen = string.length;

	  if (length > strLen / 2) {
	    length = strLen / 2;
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16);
	    if (numberIsNaN(parsed)) return i
	    buf[offset + i] = parsed;
	  }
	  return i
	}

	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}

	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}

	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}

	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}

	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}

	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8';
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset;
	    length = this.length;
	    offset = 0;
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset >>> 0;
	    if (isFinite(length)) {
	      length = length >>> 0;
	      if (encoding === undefined) encoding = 'utf8';
	    } else {
	      encoding = length;
	      length = undefined;
	    }
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }

	  var remaining = this.length - offset;
	  if (length === undefined || length > remaining) length = remaining;

	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }

	  if (!encoding) encoding = 'utf8';

	  var loweredCase = false;
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)

	      case 'ascii':
	        return asciiWrite(this, string, offset, length)

	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)

	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase();
	        loweredCase = true;
	    }
	  }
	};

	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	};

	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}

	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end);
	  var res = [];

	  var i = start;
	  while (i < end) {
	    var firstByte = buf[i];
	    var codePoint = null;
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	        : (firstByte > 0xBF) ? 2
	          : 1;

	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint;

	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte;
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1];
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint;
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1];
	          thirdByte = buf[i + 2];
	          fourthByte = buf[i + 3];
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint;
	            }
	          }
	      }
	    }

	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD;
	      bytesPerSequence = 1;
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000;
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
	      codePoint = 0xDC00 | codePoint & 0x3FF;
	    }

	    res.push(codePoint);
	    i += bytesPerSequence;
	  }

	  return decodeCodePointsArray(res)
	}

	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000;

	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length;
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }

	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = '';
	  var i = 0;
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    );
	  }
	  return res
	}

	function asciiSlice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F);
	  }
	  return ret
	}

	function latin1Slice (buf, start, end) {
	  var ret = '';
	  end = Math.min(buf.length, end);

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i]);
	  }
	  return ret
	}

	function hexSlice (buf, start, end) {
	  var len = buf.length;

	  if (!start || start < 0) start = 0;
	  if (!end || end < 0 || end > len) end = len;

	  var out = '';
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i]);
	  }
	  return out
	}

	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end);
	  var res = '';
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256));
	  }
	  return res
	}

	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length;
	  start = ~~start;
	  end = end === undefined ? len : ~~end;

	  if (start < 0) {
	    start += len;
	    if (start < 0) start = 0;
	  } else if (start > len) {
	    start = len;
	  }

	  if (end < 0) {
	    end += len;
	    if (end < 0) end = 0;
	  } else if (end > len) {
	    end = len;
	  }

	  if (end < start) end = start;

	  var newBuf = this.subarray(start, end);
	  // Return an augmented `Uint8Array` instance
	  newBuf.__proto__ = Buffer.prototype;
	  return newBuf
	};

	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}

	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }

	  return val
	};

	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length);
	  }

	  var val = this[offset + --byteLength];
	  var mul = 1;
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul;
	  }

	  return val
	};

	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  return this[offset]
	};

	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return this[offset] | (this[offset + 1] << 8)
	};

	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  return (this[offset] << 8) | this[offset + 1]
	};

	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	};

	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	};

	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var val = this[offset];
	  var mul = 1;
	  var i = 0;
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) checkOffset(offset, byteLength, this.length);

	  var i = byteLength;
	  var mul = 1;
	  var val = this[offset + --i];
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul;
	  }
	  mul *= 0x80;

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

	  return val
	};

	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 1, this.length);
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	};

	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset] | (this[offset + 1] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 2, this.length);
	  var val = this[offset + 1] | (this[offset] << 8);
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	};

	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	};

	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);

	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	};

	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return ieee754.read(this, offset, true, 23, 4)
	};

	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 4, this.length);
	  return ieee754.read(this, offset, false, 23, 4)
	};

	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return ieee754.read(this, offset, true, 52, 8)
	};

	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  offset = offset >>> 0;
	  if (!noAssert) checkOffset(offset, 8, this.length);
	  return ieee754.read(this, offset, false, 52, 8)
	};

	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}

	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var mul = 1;
	  var i = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  byteLength = byteLength >>> 0;
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
	    checkInt(this, value, offset, byteLength, maxBytes, 0);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  this[offset] = (value & 0xff);
	  this[offset + 1] = (value >>> 8);
	  return offset + 2
	};

	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
	  this[offset] = (value >>> 8);
	  this[offset + 1] = (value & 0xff);
	  return offset + 2
	};

	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  this[offset + 3] = (value >>> 24);
	  this[offset + 2] = (value >>> 16);
	  this[offset + 1] = (value >>> 8);
	  this[offset] = (value & 0xff);
	  return offset + 4
	};

	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
	  this[offset] = (value >>> 24);
	  this[offset + 1] = (value >>> 16);
	  this[offset + 2] = (value >>> 8);
	  this[offset + 3] = (value & 0xff);
	  return offset + 4
	};

	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, (8 * byteLength) - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = 0;
	  var mul = 1;
	  var sub = 0;
	  this[offset] = value & 0xFF;
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) {
	    var limit = Math.pow(2, (8 * byteLength) - 1);

	    checkInt(this, value, offset, byteLength, limit - 1, -limit);
	  }

	  var i = byteLength - 1;
	  var mul = 1;
	  var sub = 0;
	  this[offset + i] = value & 0xFF;
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1;
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
	  }

	  return offset + byteLength
	};

	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
	  if (value < 0) value = 0xff + value + 1;
	  this[offset] = (value & 0xff);
	  return offset + 1
	};

	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
	  this[offset] = (value & 0xff);
	  this[offset + 1] = (value >>> 8);
	  return offset + 2
	};

	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
	  this[offset] = (value >>> 8);
	  this[offset + 1] = (value & 0xff);
	  return offset + 2
	};

	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
	  this[offset] = (value & 0xff);
	  this[offset + 1] = (value >>> 8);
	  this[offset + 2] = (value >>> 16);
	  this[offset + 3] = (value >>> 24);
	  return offset + 4
	};

	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
	  if (value < 0) value = 0xffffffff + value + 1;
	  this[offset] = (value >>> 24);
	  this[offset + 1] = (value >>> 16);
	  this[offset + 2] = (value >>> 8);
	  this[offset + 3] = (value & 0xff);
	  return offset + 4
	};

	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}

	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4);
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4);
	  return offset + 4
	}

	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	};

	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	};

	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  value = +value;
	  offset = offset >>> 0;
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8);
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8);
	  return offset + 8
	}

	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	};

	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	};

	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
	  if (!start) start = 0;
	  if (!end && end !== 0) end = this.length;
	  if (targetStart >= target.length) targetStart = target.length;
	  if (!targetStart) targetStart = 0;
	  if (end > 0 && end < start) end = start;

	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0

	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')

	  // Are we oob?
	  if (end > this.length) end = this.length;
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start;
	  }

	  var len = end - start;

	  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
	    // Use built-in when available, missing from IE11
	    this.copyWithin(targetStart, start, end);
	  } else if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (var i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start];
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, end),
	      targetStart
	    );
	  }

	  return len
	};

	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start;
	      start = 0;
	      end = this.length;
	    } else if (typeof end === 'string') {
	      encoding = end;
	      end = this.length;
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0);
	      if ((encoding === 'utf8' && code < 128) ||
	          encoding === 'latin1') {
	        // Fast path: If `val` fits into a single byte, use that numeric value.
	        val = code;
	      }
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255;
	  }

	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return this
	  }

	  start = start >>> 0;
	  end = end === undefined ? this.length : end >>> 0;

	  if (!val) val = 0;

	  var i;
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val;
	    }
	  } else {
	    var bytes = Buffer.isBuffer(val)
	      ? val
	      : Buffer.from(val, encoding);
	    var len = bytes.length;
	    if (len === 0) {
	      throw new TypeError('The value "' + val +
	        '" is invalid for argument "value"')
	    }
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len];
	    }
	  }

	  return this
	};

	// HELPER FUNCTIONS
	// ================

	var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;

	function base64clean (str) {
	  // Node takes equal signs as end of the Base64 encoding
	  str = str.split('=')[0];
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = str.trim().replace(INVALID_BASE64_RE, '');
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '=';
	  }
	  return str
	}

	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}

	function utf8ToBytes (string, units) {
	  units = units || Infinity;
	  var codePoint;
	  var length = string.length;
	  var leadSurrogate = null;
	  var bytes = [];

	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i);

	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	          continue
	        }

	        // valid lead
	        leadSurrogate = codePoint;

	        continue
	      }

	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	        leadSurrogate = codePoint;
	        continue
	      }

	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
	    }

	    leadSurrogate = null;

	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint);
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      );
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }

	  return bytes
	}

	function asciiToBytes (str) {
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF);
	  }
	  return byteArray
	}

	function utf16leToBytes (str, units) {
	  var c, hi, lo;
	  var byteArray = [];
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break

	    c = str.charCodeAt(i);
	    hi = c >> 8;
	    lo = c % 256;
	    byteArray.push(lo);
	    byteArray.push(hi);
	  }

	  return byteArray
	}

	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}

	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i];
	  }
	  return i
	}

	// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
	// the `instanceof` check but they should be treated as of that type.
	// See: https://github.com/feross/buffer/issues/166
	function isInstance (obj, type) {
	  return obj instanceof type ||
	    (obj != null && obj.constructor != null && obj.constructor.name != null &&
	      obj.constructor.name === type.name)
	}
	function numberIsNaN (obj) {
	  // For IE11 support
	  return obj !== obj // eslint-disable-line no-self-compare
	}

	},{"base64-js":7,"ieee754":165}],17:[function(require,module,exports){
	module.exports = {
	  "100": "Continue",
	  "101": "Switching Protocols",
	  "102": "Processing",
	  "200": "OK",
	  "201": "Created",
	  "202": "Accepted",
	  "203": "Non-Authoritative Information",
	  "204": "No Content",
	  "205": "Reset Content",
	  "206": "Partial Content",
	  "207": "Multi-Status",
	  "208": "Already Reported",
	  "226": "IM Used",
	  "300": "Multiple Choices",
	  "301": "Moved Permanently",
	  "302": "Found",
	  "303": "See Other",
	  "304": "Not Modified",
	  "305": "Use Proxy",
	  "307": "Temporary Redirect",
	  "308": "Permanent Redirect",
	  "400": "Bad Request",
	  "401": "Unauthorized",
	  "402": "Payment Required",
	  "403": "Forbidden",
	  "404": "Not Found",
	  "405": "Method Not Allowed",
	  "406": "Not Acceptable",
	  "407": "Proxy Authentication Required",
	  "408": "Request Timeout",
	  "409": "Conflict",
	  "410": "Gone",
	  "411": "Length Required",
	  "412": "Precondition Failed",
	  "413": "Payload Too Large",
	  "414": "URI Too Long",
	  "415": "Unsupported Media Type",
	  "416": "Range Not Satisfiable",
	  "417": "Expectation Failed",
	  "418": "I'm a teapot",
	  "421": "Misdirected Request",
	  "422": "Unprocessable Entity",
	  "423": "Locked",
	  "424": "Failed Dependency",
	  "425": "Unordered Collection",
	  "426": "Upgrade Required",
	  "428": "Precondition Required",
	  "429": "Too Many Requests",
	  "431": "Request Header Fields Too Large",
	  "451": "Unavailable For Legal Reasons",
	  "500": "Internal Server Error",
	  "501": "Not Implemented",
	  "502": "Bad Gateway",
	  "503": "Service Unavailable",
	  "504": "Gateway Timeout",
	  "505": "HTTP Version Not Supported",
	  "506": "Variant Also Negotiates",
	  "507": "Insufficient Storage",
	  "508": "Loop Detected",
	  "509": "Bandwidth Limit Exceeded",
	  "510": "Not Extended",
	  "511": "Network Authentication Required"
	};

	},{}],18:[function(require,module,exports){
	module.exports = function (it) {
	  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
	  return it;
	};

	},{}],19:[function(require,module,exports){
	// 22.1.3.31 Array.prototype[@@unscopables]
	var UNSCOPABLES = require('./_wks')('unscopables');
	var ArrayProto = Array.prototype;
	if (ArrayProto[UNSCOPABLES] == undefined) require('./_hide')(ArrayProto, UNSCOPABLES, {});
	module.exports = function (key) {
	  ArrayProto[UNSCOPABLES][key] = true;
	};

	},{"./_hide":47,"./_wks":112}],20:[function(require,module,exports){
	module.exports = function (it, Constructor, name, forbiddenField) {
	  if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
	    throw TypeError(name + ': incorrect invocation!');
	  } return it;
	};

	},{}],21:[function(require,module,exports){
	var isObject = require('./_is-object');
	module.exports = function (it) {
	  if (!isObject(it)) throw TypeError(it + ' is not an object!');
	  return it;
	};

	},{"./_is-object":55}],22:[function(require,module,exports){
	var toObject = require('./_to-object');
	var toAbsoluteIndex = require('./_to-absolute-index');
	var toLength = require('./_to-length');

	module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
	  var O = toObject(this);
	  var len = toLength(O.length);
	  var to = toAbsoluteIndex(target, len);
	  var from = toAbsoluteIndex(start, len);
	  var end = arguments.length > 2 ? arguments[2] : undefined;
	  var count = Math.min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
	  var inc = 1;
	  if (from < to && to < from + count) {
	    inc = -1;
	    from += count - 1;
	    to += count - 1;
	  }
	  while (count-- > 0) {
	    if (from in O) O[to] = O[from];
	    else delete O[to];
	    to += inc;
	    from += inc;
	  } return O;
	};

	},{"./_to-absolute-index":98,"./_to-length":102,"./_to-object":103}],23:[function(require,module,exports){
	var toObject = require('./_to-object');
	var toAbsoluteIndex = require('./_to-absolute-index');
	var toLength = require('./_to-length');
	module.exports = function fill(value /* , start = 0, end = @length */) {
	  var O = toObject(this);
	  var length = toLength(O.length);
	  var aLen = arguments.length;
	  var index = toAbsoluteIndex(aLen > 1 ? arguments[1] : undefined, length);
	  var end = aLen > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
	  while (endPos > index) O[index++] = value;
	  return O;
	};

	},{"./_to-absolute-index":98,"./_to-length":102,"./_to-object":103}],24:[function(require,module,exports){
	// false -> Array#indexOf
	// true  -> Array#includes
	var toIObject = require('./_to-iobject');
	var toLength = require('./_to-length');
	var toAbsoluteIndex = require('./_to-absolute-index');
	module.exports = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIObject($this);
	    var length = toLength(O.length);
	    var index = toAbsoluteIndex(fromIndex, length);
	    var value;
	    // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare
	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++];
	      // eslint-disable-next-line no-self-compare
	      if (value != value) return true;
	    // Array#indexOf ignores holes, Array#includes - not
	    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
	      if (O[index] === el) return IS_INCLUDES || index || 0;
	    } return !IS_INCLUDES && -1;
	  };
	};

	},{"./_to-absolute-index":98,"./_to-iobject":101,"./_to-length":102}],25:[function(require,module,exports){
	// 0 -> Array#forEach
	// 1 -> Array#map
	// 2 -> Array#filter
	// 3 -> Array#some
	// 4 -> Array#every
	// 5 -> Array#find
	// 6 -> Array#findIndex
	var ctx = require('./_ctx');
	var IObject = require('./_iobject');
	var toObject = require('./_to-object');
	var toLength = require('./_to-length');
	var asc = require('./_array-species-create');
	module.exports = function (TYPE, $create) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  var create = $create || asc;
	  return function ($this, callbackfn, that) {
	    var O = toObject($this);
	    var self = IObject(O);
	    var f = ctx(callbackfn, that, 3);
	    var length = toLength(self.length);
	    var index = 0;
	    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
	    var val, res;
	    for (;length > index; index++) if (NO_HOLES || index in self) {
	      val = self[index];
	      res = f(val, index, O);
	      if (TYPE) {
	        if (IS_MAP) result[index] = res;   // map
	        else if (res) switch (TYPE) {
	          case 3: return true;             // some
	          case 5: return val;              // find
	          case 6: return index;            // findIndex
	          case 2: result.push(val);        // filter
	        } else if (IS_EVERY) return false; // every
	      }
	    }
	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
	  };
	};

	},{"./_array-species-create":27,"./_ctx":33,"./_iobject":52,"./_to-length":102,"./_to-object":103}],26:[function(require,module,exports){
	var isObject = require('./_is-object');
	var isArray = require('./_is-array');
	var SPECIES = require('./_wks')('species');

	module.exports = function (original) {
	  var C;
	  if (isArray(original)) {
	    C = original.constructor;
	    // cross-realm fallback
	    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
	    if (isObject(C)) {
	      C = C[SPECIES];
	      if (C === null) C = undefined;
	    }
	  } return C === undefined ? Array : C;
	};

	},{"./_is-array":54,"./_is-object":55,"./_wks":112}],27:[function(require,module,exports){
	// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
	var speciesConstructor = require('./_array-species-constructor');

	module.exports = function (original, length) {
	  return new (speciesConstructor(original))(length);
	};

	},{"./_array-species-constructor":26}],28:[function(require,module,exports){
	var aFunction = require('./_a-function');
	var isObject = require('./_is-object');
	var invoke = require('./_invoke');
	var arraySlice = [].slice;
	var factories = {};

	var construct = function (F, len, args) {
	  if (!(len in factories)) {
	    for (var n = [], i = 0; i < len; i++) n[i] = 'a[' + i + ']';
	    // eslint-disable-next-line no-new-func
	    factories[len] = Function('F,a', 'return new F(' + n.join(',') + ')');
	  } return factories[len](F, args);
	};

	module.exports = Function.bind || function bind(that /* , ...args */) {
	  var fn = aFunction(this);
	  var partArgs = arraySlice.call(arguments, 1);
	  var bound = function (/* args... */) {
	    var args = partArgs.concat(arraySlice.call(arguments));
	    return this instanceof bound ? construct(fn, args.length, args) : invoke(fn, args, that);
	  };
	  if (isObject(fn.prototype)) bound.prototype = fn.prototype;
	  return bound;
	};

	},{"./_a-function":18,"./_invoke":51,"./_is-object":55}],29:[function(require,module,exports){
	// getting tag from 19.1.3.6 Object.prototype.toString()
	var cof = require('./_cof');
	var TAG = require('./_wks')('toStringTag');
	// ES3 wrong here
	var ARG = cof(function () { return arguments; }()) == 'Arguments';

	// fallback for IE11 Script Access Denied error
	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (e) { /* empty */ }
	};

	module.exports = function (it) {
	  var O, T, B;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	    // @@toStringTag case
	    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
	    // builtinTag case
	    : ARG ? cof(O)
	    // ES3 arguments fallback
	    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
	};

	},{"./_cof":30,"./_wks":112}],30:[function(require,module,exports){
	var toString = {}.toString;

	module.exports = function (it) {
	  return toString.call(it).slice(8, -1);
	};

	},{}],31:[function(require,module,exports){
	var core = module.exports = { version: '2.5.7' };
	if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef

	},{}],32:[function(require,module,exports){
	var $defineProperty = require('./_object-dp');
	var createDesc = require('./_property-desc');

	module.exports = function (object, index, value) {
	  if (index in object) $defineProperty.f(object, index, createDesc(0, value));
	  else object[index] = value;
	};

	},{"./_object-dp":69,"./_property-desc":83}],33:[function(require,module,exports){
	// optional / simple context binding
	var aFunction = require('./_a-function');
	module.exports = function (fn, that, length) {
	  aFunction(fn);
	  if (that === undefined) return fn;
	  switch (length) {
	    case 1: return function (a) {
	      return fn.call(that, a);
	    };
	    case 2: return function (a, b) {
	      return fn.call(that, a, b);
	    };
	    case 3: return function (a, b, c) {
	      return fn.call(that, a, b, c);
	    };
	  }
	  return function (/* ...args */) {
	    return fn.apply(that, arguments);
	  };
	};

	},{"./_a-function":18}],34:[function(require,module,exports){
	// 7.2.1 RequireObjectCoercible(argument)
	module.exports = function (it) {
	  if (it == undefined) throw TypeError("Can't call method on  " + it);
	  return it;
	};

	},{}],35:[function(require,module,exports){
	// Thank's IE8 for his funny defineProperty
	module.exports = !require('./_fails')(function () {
	  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
	});

	},{"./_fails":41}],36:[function(require,module,exports){
	var isObject = require('./_is-object');
	var document = require('./_global').document;
	// typeof document.createElement is 'object' in old IE
	var is = isObject(document) && isObject(document.createElement);
	module.exports = function (it) {
	  return is ? document.createElement(it) : {};
	};

	},{"./_global":45,"./_is-object":55}],37:[function(require,module,exports){
	// IE 8- don't enum bug keys
	module.exports = (
	  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
	).split(',');

	},{}],38:[function(require,module,exports){
	// all enumerable object keys, includes symbols
	var getKeys = require('./_object-keys');
	var gOPS = require('./_object-gops');
	var pIE = require('./_object-pie');
	module.exports = function (it) {
	  var result = getKeys(it);
	  var getSymbols = gOPS.f;
	  if (getSymbols) {
	    var symbols = getSymbols(it);
	    var isEnum = pIE.f;
	    var i = 0;
	    var key;
	    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
	  } return result;
	};

	},{"./_object-gops":74,"./_object-keys":77,"./_object-pie":78}],39:[function(require,module,exports){
	var global = require('./_global');
	var core = require('./_core');
	var hide = require('./_hide');
	var redefine = require('./_redefine');
	var ctx = require('./_ctx');
	var PROTOTYPE = 'prototype';

	var $export = function (type, name, source) {
	  var IS_FORCED = type & $export.F;
	  var IS_GLOBAL = type & $export.G;
	  var IS_STATIC = type & $export.S;
	  var IS_PROTO = type & $export.P;
	  var IS_BIND = type & $export.B;
	  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];
	  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
	  var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});
	  var key, own, out, exp;
	  if (IS_GLOBAL) source = name;
	  for (key in source) {
	    // contains in native
	    own = !IS_FORCED && target && target[key] !== undefined;
	    // export native or passed
	    out = (own ? target : source)[key];
	    // bind timers to global for call from export context
	    exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
	    // extend global
	    if (target) redefine(target, key, out, type & $export.U);
	    // export
	    if (exports[key] != out) hide(exports, key, exp);
	    if (IS_PROTO && expProto[key] != out) expProto[key] = out;
	  }
	};
	global.core = core;
	// type bitmap
	$export.F = 1;   // forced
	$export.G = 2;   // global
	$export.S = 4;   // static
	$export.P = 8;   // proto
	$export.B = 16;  // bind
	$export.W = 32;  // wrap
	$export.U = 64;  // safe
	$export.R = 128; // real proto method for `library`
	module.exports = $export;

	},{"./_core":31,"./_ctx":33,"./_global":45,"./_hide":47,"./_redefine":85}],40:[function(require,module,exports){
	var MATCH = require('./_wks')('match');
	module.exports = function (KEY) {
	  var re = /./;
	  try {
	    '/./'[KEY](re);
	  } catch (e) {
	    try {
	      re[MATCH] = false;
	      return !'/./'[KEY](re);
	    } catch (f) { /* empty */ }
	  } return true;
	};

	},{"./_wks":112}],41:[function(require,module,exports){
	module.exports = function (exec) {
	  try {
	    return !!exec();
	  } catch (e) {
	    return true;
	  }
	};

	},{}],42:[function(require,module,exports){
	var hide = require('./_hide');
	var redefine = require('./_redefine');
	var fails = require('./_fails');
	var defined = require('./_defined');
	var wks = require('./_wks');

	module.exports = function (KEY, length, exec) {
	  var SYMBOL = wks(KEY);
	  var fns = exec(defined, SYMBOL, ''[KEY]);
	  var strfn = fns[0];
	  var rxfn = fns[1];
	  if (fails(function () {
	    var O = {};
	    O[SYMBOL] = function () { return 7; };
	    return ''[KEY](O) != 7;
	  })) {
	    redefine(String.prototype, KEY, strfn);
	    hide(RegExp.prototype, SYMBOL, length == 2
	      // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
	      // 21.2.5.11 RegExp.prototype[@@split](string, limit)
	      ? function (string, arg) { return rxfn.call(string, this, arg); }
	      // 21.2.5.6 RegExp.prototype[@@match](string)
	      // 21.2.5.9 RegExp.prototype[@@search](string)
	      : function (string) { return rxfn.call(string, this); }
	    );
	  }
	};

	},{"./_defined":34,"./_fails":41,"./_hide":47,"./_redefine":85,"./_wks":112}],43:[function(require,module,exports){
	// 21.2.5.3 get RegExp.prototype.flags
	var anObject = require('./_an-object');
	module.exports = function () {
	  var that = anObject(this);
	  var result = '';
	  if (that.global) result += 'g';
	  if (that.ignoreCase) result += 'i';
	  if (that.multiline) result += 'm';
	  if (that.unicode) result += 'u';
	  if (that.sticky) result += 'y';
	  return result;
	};

	},{"./_an-object":21}],44:[function(require,module,exports){
	var ctx = require('./_ctx');
	var call = require('./_iter-call');
	var isArrayIter = require('./_is-array-iter');
	var anObject = require('./_an-object');
	var toLength = require('./_to-length');
	var getIterFn = require('./core.get-iterator-method');
	var BREAK = {};
	var RETURN = {};
	var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
	  var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);
	  var f = ctx(fn, that, entries ? 2 : 1);
	  var index = 0;
	  var length, step, iterator, result;
	  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
	  // fast case for arrays with default iterator
	  if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {
	    result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
	    if (result === BREAK || result === RETURN) return result;
	  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
	    result = call(iterator, f, step.value, entries);
	    if (result === BREAK || result === RETURN) return result;
	  }
	};
	exports.BREAK = BREAK;
	exports.RETURN = RETURN;

	},{"./_an-object":21,"./_ctx":33,"./_is-array-iter":53,"./_iter-call":57,"./_to-length":102,"./core.get-iterator-method":113}],45:[function(require,module,exports){
	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global = module.exports = typeof window != 'undefined' && window.Math == Math
	  ? window : typeof self != 'undefined' && self.Math == Math ? self
	  // eslint-disable-next-line no-new-func
	  : Function('return this')();
	if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef

	},{}],46:[function(require,module,exports){
	var hasOwnProperty = {}.hasOwnProperty;
	module.exports = function (it, key) {
	  return hasOwnProperty.call(it, key);
	};

	},{}],47:[function(require,module,exports){
	var dP = require('./_object-dp');
	var createDesc = require('./_property-desc');
	module.exports = require('./_descriptors') ? function (object, key, value) {
	  return dP.f(object, key, createDesc(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	},{"./_descriptors":35,"./_object-dp":69,"./_property-desc":83}],48:[function(require,module,exports){
	var document = require('./_global').document;
	module.exports = document && document.documentElement;

	},{"./_global":45}],49:[function(require,module,exports){
	module.exports = !require('./_descriptors') && !require('./_fails')(function () {
	  return Object.defineProperty(require('./_dom-create')('div'), 'a', { get: function () { return 7; } }).a != 7;
	});

	},{"./_descriptors":35,"./_dom-create":36,"./_fails":41}],50:[function(require,module,exports){
	var isObject = require('./_is-object');
	var setPrototypeOf = require('./_set-proto').set;
	module.exports = function (that, target, C) {
	  var S = target.constructor;
	  var P;
	  if (S !== C && typeof S == 'function' && (P = S.prototype) !== C.prototype && isObject(P) && setPrototypeOf) {
	    setPrototypeOf(that, P);
	  } return that;
	};

	},{"./_is-object":55,"./_set-proto":86}],51:[function(require,module,exports){
	// fast apply, http://jsperf.lnkit.com/fast-apply/5
	module.exports = function (fn, args, that) {
	  var un = that === undefined;
	  switch (args.length) {
	    case 0: return un ? fn()
	                      : fn.call(that);
	    case 1: return un ? fn(args[0])
	                      : fn.call(that, args[0]);
	    case 2: return un ? fn(args[0], args[1])
	                      : fn.call(that, args[0], args[1]);
	    case 3: return un ? fn(args[0], args[1], args[2])
	                      : fn.call(that, args[0], args[1], args[2]);
	    case 4: return un ? fn(args[0], args[1], args[2], args[3])
	                      : fn.call(that, args[0], args[1], args[2], args[3]);
	  } return fn.apply(that, args);
	};

	},{}],52:[function(require,module,exports){
	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var cof = require('./_cof');
	// eslint-disable-next-line no-prototype-builtins
	module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
	  return cof(it) == 'String' ? it.split('') : Object(it);
	};

	},{"./_cof":30}],53:[function(require,module,exports){
	// check on default Array iterator
	var Iterators = require('./_iterators');
	var ITERATOR = require('./_wks')('iterator');
	var ArrayProto = Array.prototype;

	module.exports = function (it) {
	  return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
	};

	},{"./_iterators":62,"./_wks":112}],54:[function(require,module,exports){
	// 7.2.2 IsArray(argument)
	var cof = require('./_cof');
	module.exports = Array.isArray || function isArray(arg) {
	  return cof(arg) == 'Array';
	};

	},{"./_cof":30}],55:[function(require,module,exports){
	module.exports = function (it) {
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

	},{}],56:[function(require,module,exports){
	// 7.2.8 IsRegExp(argument)
	var isObject = require('./_is-object');
	var cof = require('./_cof');
	var MATCH = require('./_wks')('match');
	module.exports = function (it) {
	  var isRegExp;
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');
	};

	},{"./_cof":30,"./_is-object":55,"./_wks":112}],57:[function(require,module,exports){
	// call something on iterator step with safe closing on error
	var anObject = require('./_an-object');
	module.exports = function (iterator, fn, value, entries) {
	  try {
	    return entries ? fn(anObject(value)[0], value[1]) : fn(value);
	  // 7.4.6 IteratorClose(iterator, completion)
	  } catch (e) {
	    var ret = iterator['return'];
	    if (ret !== undefined) anObject(ret.call(iterator));
	    throw e;
	  }
	};

	},{"./_an-object":21}],58:[function(require,module,exports){
	var create = require('./_object-create');
	var descriptor = require('./_property-desc');
	var setToStringTag = require('./_set-to-string-tag');
	var IteratorPrototype = {};

	// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
	require('./_hide')(IteratorPrototype, require('./_wks')('iterator'), function () { return this; });

	module.exports = function (Constructor, NAME, next) {
	  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
	  setToStringTag(Constructor, NAME + ' Iterator');
	};

	},{"./_hide":47,"./_object-create":68,"./_property-desc":83,"./_set-to-string-tag":88,"./_wks":112}],59:[function(require,module,exports){
	var LIBRARY = require('./_library');
	var $export = require('./_export');
	var redefine = require('./_redefine');
	var hide = require('./_hide');
	var Iterators = require('./_iterators');
	var $iterCreate = require('./_iter-create');
	var setToStringTag = require('./_set-to-string-tag');
	var getPrototypeOf = require('./_object-gpo');
	var ITERATOR = require('./_wks')('iterator');
	var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
	var FF_ITERATOR = '@@iterator';
	var KEYS = 'keys';
	var VALUES = 'values';

	var returnThis = function () { return this; };

	module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
	  $iterCreate(Constructor, NAME, next);
	  var getMethod = function (kind) {
	    if (!BUGGY && kind in proto) return proto[kind];
	    switch (kind) {
	      case KEYS: return function keys() { return new Constructor(this, kind); };
	      case VALUES: return function values() { return new Constructor(this, kind); };
	    } return function entries() { return new Constructor(this, kind); };
	  };
	  var TAG = NAME + ' Iterator';
	  var DEF_VALUES = DEFAULT == VALUES;
	  var VALUES_BUG = false;
	  var proto = Base.prototype;
	  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
	  var $default = $native || getMethod(DEFAULT);
	  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
	  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
	  var methods, key, IteratorPrototype;
	  // Fix native
	  if ($anyNative) {
	    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
	    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
	      // Set @@toStringTag to native iterators
	      setToStringTag(IteratorPrototype, TAG, true);
	      // fix for some old engines
	      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
	    }
	  }
	  // fix Array#{values, @@iterator}.name in V8 / FF
	  if (DEF_VALUES && $native && $native.name !== VALUES) {
	    VALUES_BUG = true;
	    $default = function values() { return $native.call(this); };
	  }
	  // Define iterator
	  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
	    hide(proto, ITERATOR, $default);
	  }
	  // Plug for library
	  Iterators[NAME] = $default;
	  Iterators[TAG] = returnThis;
	  if (DEFAULT) {
	    methods = {
	      values: DEF_VALUES ? $default : getMethod(VALUES),
	      keys: IS_SET ? $default : getMethod(KEYS),
	      entries: $entries
	    };
	    if (FORCED) for (key in methods) {
	      if (!(key in proto)) redefine(proto, key, methods[key]);
	    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
	  }
	  return methods;
	};

	},{"./_export":39,"./_hide":47,"./_iter-create":58,"./_iterators":62,"./_library":63,"./_object-gpo":75,"./_redefine":85,"./_set-to-string-tag":88,"./_wks":112}],60:[function(require,module,exports){
	var ITERATOR = require('./_wks')('iterator');
	var SAFE_CLOSING = false;

	try {
	  var riter = [7][ITERATOR]();
	  riter['return'] = function () { SAFE_CLOSING = true; };
	  // eslint-disable-next-line no-throw-literal
	  Array.from(riter, function () { throw 2; });
	} catch (e) { /* empty */ }

	module.exports = function (exec, skipClosing) {
	  if (!skipClosing && !SAFE_CLOSING) return false;
	  var safe = false;
	  try {
	    var arr = [7];
	    var iter = arr[ITERATOR]();
	    iter.next = function () { return { done: safe = true }; };
	    arr[ITERATOR] = function () { return iter; };
	    exec(arr);
	  } catch (e) { /* empty */ }
	  return safe;
	};

	},{"./_wks":112}],61:[function(require,module,exports){
	module.exports = function (done, value) {
	  return { value: value, done: !!done };
	};

	},{}],62:[function(require,module,exports){
	module.exports = {};

	},{}],63:[function(require,module,exports){
	module.exports = false;

	},{}],64:[function(require,module,exports){
	var META = require('./_uid')('meta');
	var isObject = require('./_is-object');
	var has = require('./_has');
	var setDesc = require('./_object-dp').f;
	var id = 0;
	var isExtensible = Object.isExtensible || function () {
	  return true;
	};
	var FREEZE = !require('./_fails')(function () {
	  return isExtensible(Object.preventExtensions({}));
	});
	var setMeta = function (it) {
	  setDesc(it, META, { value: {
	    i: 'O' + ++id, // object ID
	    w: {}          // weak collections IDs
	  } });
	};
	var fastKey = function (it, create) {
	  // return primitive with prefix
	  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
	  if (!has(it, META)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return 'F';
	    // not necessary to add metadata
	    if (!create) return 'E';
	    // add missing metadata
	    setMeta(it);
	  // return object ID
	  } return it[META].i;
	};
	var getWeak = function (it, create) {
	  if (!has(it, META)) {
	    // can't set metadata to uncaught frozen object
	    if (!isExtensible(it)) return true;
	    // not necessary to add metadata
	    if (!create) return false;
	    // add missing metadata
	    setMeta(it);
	  // return hash weak collections IDs
	  } return it[META].w;
	};
	// add metadata on freeze-family methods calling
	var onFreeze = function (it) {
	  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
	  return it;
	};
	var meta = module.exports = {
	  KEY: META,
	  NEED: false,
	  fastKey: fastKey,
	  getWeak: getWeak,
	  onFreeze: onFreeze
	};

	},{"./_fails":41,"./_has":46,"./_is-object":55,"./_object-dp":69,"./_uid":108}],65:[function(require,module,exports){
	var global = require('./_global');
	var macrotask = require('./_task').set;
	var Observer = global.MutationObserver || global.WebKitMutationObserver;
	var process = global.process;
	var Promise = global.Promise;
	var isNode = require('./_cof')(process) == 'process';

	module.exports = function () {
	  var head, last, notify;

	  var flush = function () {
	    var parent, fn;
	    if (isNode && (parent = process.domain)) parent.exit();
	    while (head) {
	      fn = head.fn;
	      head = head.next;
	      try {
	        fn();
	      } catch (e) {
	        if (head) notify();
	        else last = undefined;
	        throw e;
	      }
	    } last = undefined;
	    if (parent) parent.enter();
	  };

	  // Node.js
	  if (isNode) {
	    notify = function () {
	      process.nextTick(flush);
	    };
	  // browsers with MutationObserver, except iOS Safari - https://github.com/zloirock/core-js/issues/339
	  } else if (Observer && !(global.navigator && global.navigator.standalone)) {
	    var toggle = true;
	    var node = document.createTextNode('');
	    new Observer(flush).observe(node, { characterData: true }); // eslint-disable-line no-new
	    notify = function () {
	      node.data = toggle = !toggle;
	    };
	  // environments with maybe non-completely correct, but existent Promise
	  } else if (Promise && Promise.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    var promise = Promise.resolve(undefined);
	    notify = function () {
	      promise.then(flush);
	    };
	  // for other environments - macrotask based on:
	  // - setImmediate
	  // - MessageChannel
	  // - window.postMessag
	  // - onreadystatechange
	  // - setTimeout
	  } else {
	    notify = function () {
	      // strange IE + webpack dev server bug - use .call(global)
	      macrotask.call(global, flush);
	    };
	  }

	  return function (fn) {
	    var task = { fn: fn, next: undefined };
	    if (last) last.next = task;
	    if (!head) {
	      head = task;
	      notify();
	    } last = task;
	  };
	};

	},{"./_cof":30,"./_global":45,"./_task":97}],66:[function(require,module,exports){
	// 25.4.1.5 NewPromiseCapability(C)
	var aFunction = require('./_a-function');

	function PromiseCapability(C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aFunction(resolve);
	  this.reject = aFunction(reject);
	}

	module.exports.f = function (C) {
	  return new PromiseCapability(C);
	};

	},{"./_a-function":18}],67:[function(require,module,exports){
	// 19.1.2.1 Object.assign(target, source, ...)
	var getKeys = require('./_object-keys');
	var gOPS = require('./_object-gops');
	var pIE = require('./_object-pie');
	var toObject = require('./_to-object');
	var IObject = require('./_iobject');
	var $assign = Object.assign;

	// should work with symbols and should have deterministic property order (V8 bug)
	module.exports = !$assign || require('./_fails')(function () {
	  var A = {};
	  var B = {};
	  // eslint-disable-next-line no-undef
	  var S = Symbol();
	  var K = 'abcdefghijklmnopqrst';
	  A[S] = 7;
	  K.split('').forEach(function (k) { B[k] = k; });
	  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
	}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
	  var T = toObject(target);
	  var aLen = arguments.length;
	  var index = 1;
	  var getSymbols = gOPS.f;
	  var isEnum = pIE.f;
	  while (aLen > index) {
	    var S = IObject(arguments[index++]);
	    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
	    var length = keys.length;
	    var j = 0;
	    var key;
	    while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];
	  } return T;
	} : $assign;

	},{"./_fails":41,"./_iobject":52,"./_object-gops":74,"./_object-keys":77,"./_object-pie":78,"./_to-object":103}],68:[function(require,module,exports){
	// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
	var anObject = require('./_an-object');
	var dPs = require('./_object-dps');
	var enumBugKeys = require('./_enum-bug-keys');
	var IE_PROTO = require('./_shared-key')('IE_PROTO');
	var Empty = function () { /* empty */ };
	var PROTOTYPE = 'prototype';

	// Create object with fake `null` prototype: use iframe Object with cleared prototype
	var createDict = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = require('./_dom-create')('iframe');
	  var i = enumBugKeys.length;
	  var lt = '<';
	  var gt = '>';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  require('./_html').appendChild(iframe);
	  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
	  // createDict = iframe.contentWindow.Object;
	  // html.removeChild(iframe);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
	  iframeDocument.close();
	  createDict = iframeDocument.F;
	  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
	  return createDict();
	};

	module.exports = Object.create || function create(O, Properties) {
	  var result;
	  if (O !== null) {
	    Empty[PROTOTYPE] = anObject(O);
	    result = new Empty();
	    Empty[PROTOTYPE] = null;
	    // add "__proto__" for Object.getPrototypeOf polyfill
	    result[IE_PROTO] = O;
	  } else result = createDict();
	  return Properties === undefined ? result : dPs(result, Properties);
	};

	},{"./_an-object":21,"./_dom-create":36,"./_enum-bug-keys":37,"./_html":48,"./_object-dps":70,"./_shared-key":89}],69:[function(require,module,exports){
	var anObject = require('./_an-object');
	var IE8_DOM_DEFINE = require('./_ie8-dom-define');
	var toPrimitive = require('./_to-primitive');
	var dP = Object.defineProperty;

	exports.f = require('./_descriptors') ? Object.defineProperty : function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPrimitive(P, true);
	  anObject(Attributes);
	  if (IE8_DOM_DEFINE) try {
	    return dP(O, P, Attributes);
	  } catch (e) { /* empty */ }
	  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};

	},{"./_an-object":21,"./_descriptors":35,"./_ie8-dom-define":49,"./_to-primitive":104}],70:[function(require,module,exports){
	var dP = require('./_object-dp');
	var anObject = require('./_an-object');
	var getKeys = require('./_object-keys');

	module.exports = require('./_descriptors') ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject(O);
	  var keys = getKeys(Properties);
	  var length = keys.length;
	  var i = 0;
	  var P;
	  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
	  return O;
	};

	},{"./_an-object":21,"./_descriptors":35,"./_object-dp":69,"./_object-keys":77}],71:[function(require,module,exports){
	var pIE = require('./_object-pie');
	var createDesc = require('./_property-desc');
	var toIObject = require('./_to-iobject');
	var toPrimitive = require('./_to-primitive');
	var has = require('./_has');
	var IE8_DOM_DEFINE = require('./_ie8-dom-define');
	var gOPD = Object.getOwnPropertyDescriptor;

	exports.f = require('./_descriptors') ? gOPD : function getOwnPropertyDescriptor(O, P) {
	  O = toIObject(O);
	  P = toPrimitive(P, true);
	  if (IE8_DOM_DEFINE) try {
	    return gOPD(O, P);
	  } catch (e) { /* empty */ }
	  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
	};

	},{"./_descriptors":35,"./_has":46,"./_ie8-dom-define":49,"./_object-pie":78,"./_property-desc":83,"./_to-iobject":101,"./_to-primitive":104}],72:[function(require,module,exports){
	// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
	var toIObject = require('./_to-iobject');
	var gOPN = require('./_object-gopn').f;
	var toString = {}.toString;

	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
	  ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return gOPN(it);
	  } catch (e) {
	    return windowNames.slice();
	  }
	};

	module.exports.f = function getOwnPropertyNames(it) {
	  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
	};

	},{"./_object-gopn":73,"./_to-iobject":101}],73:[function(require,module,exports){
	// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
	var $keys = require('./_object-keys-internal');
	var hiddenKeys = require('./_enum-bug-keys').concat('length', 'prototype');

	exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return $keys(O, hiddenKeys);
	};

	},{"./_enum-bug-keys":37,"./_object-keys-internal":76}],74:[function(require,module,exports){
	exports.f = Object.getOwnPropertySymbols;

	},{}],75:[function(require,module,exports){
	// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
	var has = require('./_has');
	var toObject = require('./_to-object');
	var IE_PROTO = require('./_shared-key')('IE_PROTO');
	var ObjectProto = Object.prototype;

	module.exports = Object.getPrototypeOf || function (O) {
	  O = toObject(O);
	  if (has(O, IE_PROTO)) return O[IE_PROTO];
	  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
	    return O.constructor.prototype;
	  } return O instanceof Object ? ObjectProto : null;
	};

	},{"./_has":46,"./_shared-key":89,"./_to-object":103}],76:[function(require,module,exports){
	var has = require('./_has');
	var toIObject = require('./_to-iobject');
	var arrayIndexOf = require('./_array-includes')(false);
	var IE_PROTO = require('./_shared-key')('IE_PROTO');

	module.exports = function (object, names) {
	  var O = toIObject(object);
	  var i = 0;
	  var result = [];
	  var key;
	  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
	  // Don't enum bug & hidden keys
	  while (names.length > i) if (has(O, key = names[i++])) {
	    ~arrayIndexOf(result, key) || result.push(key);
	  }
	  return result;
	};

	},{"./_array-includes":24,"./_has":46,"./_shared-key":89,"./_to-iobject":101}],77:[function(require,module,exports){
	// 19.1.2.14 / 15.2.3.14 Object.keys(O)
	var $keys = require('./_object-keys-internal');
	var enumBugKeys = require('./_enum-bug-keys');

	module.exports = Object.keys || function keys(O) {
	  return $keys(O, enumBugKeys);
	};

	},{"./_enum-bug-keys":37,"./_object-keys-internal":76}],78:[function(require,module,exports){
	exports.f = {}.propertyIsEnumerable;

	},{}],79:[function(require,module,exports){
	// most Object methods by ES6 should accept primitives
	var $export = require('./_export');
	var core = require('./_core');
	var fails = require('./_fails');
	module.exports = function (KEY, exec) {
	  var fn = (core.Object || {})[KEY] || Object[KEY];
	  var exp = {};
	  exp[KEY] = exec(fn);
	  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
	};

	},{"./_core":31,"./_export":39,"./_fails":41}],80:[function(require,module,exports){
	var getKeys = require('./_object-keys');
	var toIObject = require('./_to-iobject');
	var isEnum = require('./_object-pie').f;
	module.exports = function (isEntries) {
	  return function (it) {
	    var O = toIObject(it);
	    var keys = getKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;
	    while (length > i) if (isEnum.call(O, key = keys[i++])) {
	      result.push(isEntries ? [key, O[key]] : O[key]);
	    } return result;
	  };
	};

	},{"./_object-keys":77,"./_object-pie":78,"./_to-iobject":101}],81:[function(require,module,exports){
	module.exports = function (exec) {
	  try {
	    return { e: false, v: exec() };
	  } catch (e) {
	    return { e: true, v: e };
	  }
	};

	},{}],82:[function(require,module,exports){
	var anObject = require('./_an-object');
	var isObject = require('./_is-object');
	var newPromiseCapability = require('./_new-promise-capability');

	module.exports = function (C, x) {
	  anObject(C);
	  if (isObject(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};

	},{"./_an-object":21,"./_is-object":55,"./_new-promise-capability":66}],83:[function(require,module,exports){
	module.exports = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	},{}],84:[function(require,module,exports){
	var redefine = require('./_redefine');
	module.exports = function (target, src, safe) {
	  for (var key in src) redefine(target, key, src[key], safe);
	  return target;
	};

	},{"./_redefine":85}],85:[function(require,module,exports){
	var global = require('./_global');
	var hide = require('./_hide');
	var has = require('./_has');
	var SRC = require('./_uid')('src');
	var TO_STRING = 'toString';
	var $toString = Function[TO_STRING];
	var TPL = ('' + $toString).split(TO_STRING);

	require('./_core').inspectSource = function (it) {
	  return $toString.call(it);
	};

	(module.exports = function (O, key, val, safe) {
	  var isFunction = typeof val == 'function';
	  if (isFunction) has(val, 'name') || hide(val, 'name', key);
	  if (O[key] === val) return;
	  if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));
	  if (O === global) {
	    O[key] = val;
	  } else if (!safe) {
	    delete O[key];
	    hide(O, key, val);
	  } else if (O[key]) {
	    O[key] = val;
	  } else {
	    hide(O, key, val);
	  }
	// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
	})(Function.prototype, TO_STRING, function toString() {
	  return typeof this == 'function' && this[SRC] || $toString.call(this);
	});

	},{"./_core":31,"./_global":45,"./_has":46,"./_hide":47,"./_uid":108}],86:[function(require,module,exports){
	// Works with __proto__ only. Old v8 can't work with null proto objects.
	/* eslint-disable no-proto */
	var isObject = require('./_is-object');
	var anObject = require('./_an-object');
	var check = function (O, proto) {
	  anObject(O);
	  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
	};
	module.exports = {
	  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
	    function (test, buggy, set) {
	      try {
	        set = require('./_ctx')(Function.call, require('./_object-gopd').f(Object.prototype, '__proto__').set, 2);
	        set(test, []);
	        buggy = !(test instanceof Array);
	      } catch (e) { buggy = true; }
	      return function setPrototypeOf(O, proto) {
	        check(O, proto);
	        if (buggy) O.__proto__ = proto;
	        else set(O, proto);
	        return O;
	      };
	    }({}, false) : undefined),
	  check: check
	};

	},{"./_an-object":21,"./_ctx":33,"./_is-object":55,"./_object-gopd":71}],87:[function(require,module,exports){
	var global = require('./_global');
	var dP = require('./_object-dp');
	var DESCRIPTORS = require('./_descriptors');
	var SPECIES = require('./_wks')('species');

	module.exports = function (KEY) {
	  var C = global[KEY];
	  if (DESCRIPTORS && C && !C[SPECIES]) dP.f(C, SPECIES, {
	    configurable: true,
	    get: function () { return this; }
	  });
	};

	},{"./_descriptors":35,"./_global":45,"./_object-dp":69,"./_wks":112}],88:[function(require,module,exports){
	var def = require('./_object-dp').f;
	var has = require('./_has');
	var TAG = require('./_wks')('toStringTag');

	module.exports = function (it, tag, stat) {
	  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
	};

	},{"./_has":46,"./_object-dp":69,"./_wks":112}],89:[function(require,module,exports){
	var shared = require('./_shared')('keys');
	var uid = require('./_uid');
	module.exports = function (key) {
	  return shared[key] || (shared[key] = uid(key));
	};

	},{"./_shared":90,"./_uid":108}],90:[function(require,module,exports){
	var core = require('./_core');
	var global = require('./_global');
	var SHARED = '__core-js_shared__';
	var store = global[SHARED] || (global[SHARED] = {});

	(module.exports = function (key, value) {
	  return store[key] || (store[key] = value !== undefined ? value : {});
	})('versions', []).push({
	  version: core.version,
	  mode: require('./_library') ? 'pure' : 'global',
	  copyright: '© 2018 Denis Pushkarev (zloirock.ru)'
	});

	},{"./_core":31,"./_global":45,"./_library":63}],91:[function(require,module,exports){
	// 7.3.20 SpeciesConstructor(O, defaultConstructor)
	var anObject = require('./_an-object');
	var aFunction = require('./_a-function');
	var SPECIES = require('./_wks')('species');
	module.exports = function (O, D) {
	  var C = anObject(O).constructor;
	  var S;
	  return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? D : aFunction(S);
	};

	},{"./_a-function":18,"./_an-object":21,"./_wks":112}],92:[function(require,module,exports){
	var fails = require('./_fails');

	module.exports = function (method, arg) {
	  return !!method && fails(function () {
	    // eslint-disable-next-line no-useless-call
	    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
	  });
	};

	},{"./_fails":41}],93:[function(require,module,exports){
	var toInteger = require('./_to-integer');
	var defined = require('./_defined');
	// true  -> String#at
	// false -> String#codePointAt
	module.exports = function (TO_STRING) {
	  return function (that, pos) {
	    var s = String(defined(that));
	    var i = toInteger(pos);
	    var l = s.length;
	    var a, b;
	    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
	    a = s.charCodeAt(i);
	    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
	      ? TO_STRING ? s.charAt(i) : a
	      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
	  };
	};

	},{"./_defined":34,"./_to-integer":100}],94:[function(require,module,exports){
	// helper for String#{startsWith, endsWith, includes}
	var isRegExp = require('./_is-regexp');
	var defined = require('./_defined');

	module.exports = function (that, searchString, NAME) {
	  if (isRegExp(searchString)) throw TypeError('String#' + NAME + " doesn't accept regex!");
	  return String(defined(that));
	};

	},{"./_defined":34,"./_is-regexp":56}],95:[function(require,module,exports){
	var $export = require('./_export');
	var defined = require('./_defined');
	var fails = require('./_fails');
	var spaces = require('./_string-ws');
	var space = '[' + spaces + ']';
	var non = '\u200b\u0085';
	var ltrim = RegExp('^' + space + space + '*');
	var rtrim = RegExp(space + space + '*$');

	var exporter = function (KEY, exec, ALIAS) {
	  var exp = {};
	  var FORCE = fails(function () {
	    return !!spaces[KEY]() || non[KEY]() != non;
	  });
	  var fn = exp[KEY] = FORCE ? exec(trim) : spaces[KEY];
	  if (ALIAS) exp[ALIAS] = fn;
	  $export($export.P + $export.F * FORCE, 'String', exp);
	};

	// 1 -> String#trimLeft
	// 2 -> String#trimRight
	// 3 -> String#trim
	var trim = exporter.trim = function (string, TYPE) {
	  string = String(defined(string));
	  if (TYPE & 1) string = string.replace(ltrim, '');
	  if (TYPE & 2) string = string.replace(rtrim, '');
	  return string;
	};

	module.exports = exporter;

	},{"./_defined":34,"./_export":39,"./_fails":41,"./_string-ws":96}],96:[function(require,module,exports){
	module.exports = '\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003' +
	  '\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	},{}],97:[function(require,module,exports){
	var ctx = require('./_ctx');
	var invoke = require('./_invoke');
	var html = require('./_html');
	var cel = require('./_dom-create');
	var global = require('./_global');
	var process = global.process;
	var setTask = global.setImmediate;
	var clearTask = global.clearImmediate;
	var MessageChannel = global.MessageChannel;
	var Dispatch = global.Dispatch;
	var counter = 0;
	var queue = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var defer, channel, port;
	var run = function () {
	  var id = +this;
	  // eslint-disable-next-line no-prototype-builtins
	  if (queue.hasOwnProperty(id)) {
	    var fn = queue[id];
	    delete queue[id];
	    fn();
	  }
	};
	var listener = function (event) {
	  run.call(event.data);
	};
	// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
	if (!setTask || !clearTask) {
	  setTask = function setImmediate(fn) {
	    var args = [];
	    var i = 1;
	    while (arguments.length > i) args.push(arguments[i++]);
	    queue[++counter] = function () {
	      // eslint-disable-next-line no-new-func
	      invoke(typeof fn == 'function' ? fn : Function(fn), args);
	    };
	    defer(counter);
	    return counter;
	  };
	  clearTask = function clearImmediate(id) {
	    delete queue[id];
	  };
	  // Node.js 0.8-
	  if (require('./_cof')(process) == 'process') {
	    defer = function (id) {
	      process.nextTick(ctx(run, id, 1));
	    };
	  // Sphere (JS game engine) Dispatch API
	  } else if (Dispatch && Dispatch.now) {
	    defer = function (id) {
	      Dispatch.now(ctx(run, id, 1));
	    };
	  // Browsers with MessageChannel, includes WebWorkers
	  } else if (MessageChannel) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = listener;
	    defer = ctx(port.postMessage, port, 1);
	  // Browsers with postMessage, skip WebWorkers
	  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts) {
	    defer = function (id) {
	      global.postMessage(id + '', '*');
	    };
	    global.addEventListener('message', listener, false);
	  // IE8-
	  } else if (ONREADYSTATECHANGE in cel('script')) {
	    defer = function (id) {
	      html.appendChild(cel('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run.call(id);
	      };
	    };
	  // Rest old browsers
	  } else {
	    defer = function (id) {
	      setTimeout(ctx(run, id, 1), 0);
	    };
	  }
	}
	module.exports = {
	  set: setTask,
	  clear: clearTask
	};

	},{"./_cof":30,"./_ctx":33,"./_dom-create":36,"./_global":45,"./_html":48,"./_invoke":51}],98:[function(require,module,exports){
	var toInteger = require('./_to-integer');
	var max = Math.max;
	var min = Math.min;
	module.exports = function (index, length) {
	  index = toInteger(index);
	  return index < 0 ? max(index + length, 0) : min(index, length);
	};

	},{"./_to-integer":100}],99:[function(require,module,exports){
	// https://tc39.github.io/ecma262/#sec-toindex
	var toInteger = require('./_to-integer');
	var toLength = require('./_to-length');
	module.exports = function (it) {
	  if (it === undefined) return 0;
	  var number = toInteger(it);
	  var length = toLength(number);
	  if (number !== length) throw RangeError('Wrong length!');
	  return length;
	};

	},{"./_to-integer":100,"./_to-length":102}],100:[function(require,module,exports){
	// 7.1.4 ToInteger
	var ceil = Math.ceil;
	var floor = Math.floor;
	module.exports = function (it) {
	  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
	};

	},{}],101:[function(require,module,exports){
	// to indexed object, toObject with fallback for non-array-like ES3 strings
	var IObject = require('./_iobject');
	var defined = require('./_defined');
	module.exports = function (it) {
	  return IObject(defined(it));
	};

	},{"./_defined":34,"./_iobject":52}],102:[function(require,module,exports){
	// 7.1.15 ToLength
	var toInteger = require('./_to-integer');
	var min = Math.min;
	module.exports = function (it) {
	  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
	};

	},{"./_to-integer":100}],103:[function(require,module,exports){
	// 7.1.13 ToObject(argument)
	var defined = require('./_defined');
	module.exports = function (it) {
	  return Object(defined(it));
	};

	},{"./_defined":34}],104:[function(require,module,exports){
	// 7.1.1 ToPrimitive(input [, PreferredType])
	var isObject = require('./_is-object');
	// instead of the ES6 spec version, we didn't implement @@toPrimitive case
	// and the second argument - flag - preferred type is a string
	module.exports = function (it, S) {
	  if (!isObject(it)) return it;
	  var fn, val;
	  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
	  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
	  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
	  throw TypeError("Can't convert object to primitive value");
	};

	},{"./_is-object":55}],105:[function(require,module,exports){
	if (require('./_descriptors')) {
	  var LIBRARY = require('./_library');
	  var global = require('./_global');
	  var fails = require('./_fails');
	  var $export = require('./_export');
	  var $typed = require('./_typed');
	  var $buffer = require('./_typed-buffer');
	  var ctx = require('./_ctx');
	  var anInstance = require('./_an-instance');
	  var propertyDesc = require('./_property-desc');
	  var hide = require('./_hide');
	  var redefineAll = require('./_redefine-all');
	  var toInteger = require('./_to-integer');
	  var toLength = require('./_to-length');
	  var toIndex = require('./_to-index');
	  var toAbsoluteIndex = require('./_to-absolute-index');
	  var toPrimitive = require('./_to-primitive');
	  var has = require('./_has');
	  var classof = require('./_classof');
	  var isObject = require('./_is-object');
	  var toObject = require('./_to-object');
	  var isArrayIter = require('./_is-array-iter');
	  var create = require('./_object-create');
	  var getPrototypeOf = require('./_object-gpo');
	  var gOPN = require('./_object-gopn').f;
	  var getIterFn = require('./core.get-iterator-method');
	  var uid = require('./_uid');
	  var wks = require('./_wks');
	  var createArrayMethod = require('./_array-methods');
	  var createArrayIncludes = require('./_array-includes');
	  var speciesConstructor = require('./_species-constructor');
	  var ArrayIterators = require('./es6.array.iterator');
	  var Iterators = require('./_iterators');
	  var $iterDetect = require('./_iter-detect');
	  var setSpecies = require('./_set-species');
	  var arrayFill = require('./_array-fill');
	  var arrayCopyWithin = require('./_array-copy-within');
	  var $DP = require('./_object-dp');
	  var $GOPD = require('./_object-gopd');
	  var dP = $DP.f;
	  var gOPD = $GOPD.f;
	  var RangeError = global.RangeError;
	  var TypeError = global.TypeError;
	  var Uint8Array = global.Uint8Array;
	  var ARRAY_BUFFER = 'ArrayBuffer';
	  var SHARED_BUFFER = 'Shared' + ARRAY_BUFFER;
	  var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
	  var PROTOTYPE = 'prototype';
	  var ArrayProto = Array[PROTOTYPE];
	  var $ArrayBuffer = $buffer.ArrayBuffer;
	  var $DataView = $buffer.DataView;
	  var arrayForEach = createArrayMethod(0);
	  var arrayFilter = createArrayMethod(2);
	  var arraySome = createArrayMethod(3);
	  var arrayEvery = createArrayMethod(4);
	  var arrayFind = createArrayMethod(5);
	  var arrayFindIndex = createArrayMethod(6);
	  var arrayIncludes = createArrayIncludes(true);
	  var arrayIndexOf = createArrayIncludes(false);
	  var arrayValues = ArrayIterators.values;
	  var arrayKeys = ArrayIterators.keys;
	  var arrayEntries = ArrayIterators.entries;
	  var arrayLastIndexOf = ArrayProto.lastIndexOf;
	  var arrayReduce = ArrayProto.reduce;
	  var arrayReduceRight = ArrayProto.reduceRight;
	  var arrayJoin = ArrayProto.join;
	  var arraySort = ArrayProto.sort;
	  var arraySlice = ArrayProto.slice;
	  var arrayToString = ArrayProto.toString;
	  var arrayToLocaleString = ArrayProto.toLocaleString;
	  var ITERATOR = wks('iterator');
	  var TAG = wks('toStringTag');
	  var TYPED_CONSTRUCTOR = uid('typed_constructor');
	  var DEF_CONSTRUCTOR = uid('def_constructor');
	  var ALL_CONSTRUCTORS = $typed.CONSTR;
	  var TYPED_ARRAY = $typed.TYPED;
	  var VIEW = $typed.VIEW;
	  var WRONG_LENGTH = 'Wrong length!';

	  var $map = createArrayMethod(1, function (O, length) {
	    return allocate(speciesConstructor(O, O[DEF_CONSTRUCTOR]), length);
	  });

	  var LITTLE_ENDIAN = fails(function () {
	    // eslint-disable-next-line no-undef
	    return new Uint8Array(new Uint16Array([1]).buffer)[0] === 1;
	  });

	  var FORCED_SET = !!Uint8Array && !!Uint8Array[PROTOTYPE].set && fails(function () {
	    new Uint8Array(1).set({});
	  });

	  var toOffset = function (it, BYTES) {
	    var offset = toInteger(it);
	    if (offset < 0 || offset % BYTES) throw RangeError('Wrong offset!');
	    return offset;
	  };

	  var validate = function (it) {
	    if (isObject(it) && TYPED_ARRAY in it) return it;
	    throw TypeError(it + ' is not a typed array!');
	  };

	  var allocate = function (C, length) {
	    if (!(isObject(C) && TYPED_CONSTRUCTOR in C)) {
	      throw TypeError('It is not a typed array constructor!');
	    } return new C(length);
	  };

	  var speciesFromList = function (O, list) {
	    return fromList(speciesConstructor(O, O[DEF_CONSTRUCTOR]), list);
	  };

	  var fromList = function (C, list) {
	    var index = 0;
	    var length = list.length;
	    var result = allocate(C, length);
	    while (length > index) result[index] = list[index++];
	    return result;
	  };

	  var addGetter = function (it, key, internal) {
	    dP(it, key, { get: function () { return this._d[internal]; } });
	  };

	  var $from = function from(source /* , mapfn, thisArg */) {
	    var O = toObject(source);
	    var aLen = arguments.length;
	    var mapfn = aLen > 1 ? arguments[1] : undefined;
	    var mapping = mapfn !== undefined;
	    var iterFn = getIterFn(O);
	    var i, length, values, result, step, iterator;
	    if (iterFn != undefined && !isArrayIter(iterFn)) {
	      for (iterator = iterFn.call(O), values = [], i = 0; !(step = iterator.next()).done; i++) {
	        values.push(step.value);
	      } O = values;
	    }
	    if (mapping && aLen > 2) mapfn = ctx(mapfn, arguments[2], 2);
	    for (i = 0, length = toLength(O.length), result = allocate(this, length); length > i; i++) {
	      result[i] = mapping ? mapfn(O[i], i) : O[i];
	    }
	    return result;
	  };

	  var $of = function of(/* ...items */) {
	    var index = 0;
	    var length = arguments.length;
	    var result = allocate(this, length);
	    while (length > index) result[index] = arguments[index++];
	    return result;
	  };

	  // iOS Safari 6.x fails here
	  var TO_LOCALE_BUG = !!Uint8Array && fails(function () { arrayToLocaleString.call(new Uint8Array(1)); });

	  var $toLocaleString = function toLocaleString() {
	    return arrayToLocaleString.apply(TO_LOCALE_BUG ? arraySlice.call(validate(this)) : validate(this), arguments);
	  };

	  var proto = {
	    copyWithin: function copyWithin(target, start /* , end */) {
	      return arrayCopyWithin.call(validate(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    every: function every(callbackfn /* , thisArg */) {
	      return arrayEvery(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    fill: function fill(value /* , start, end */) { // eslint-disable-line no-unused-vars
	      return arrayFill.apply(validate(this), arguments);
	    },
	    filter: function filter(callbackfn /* , thisArg */) {
	      return speciesFromList(this, arrayFilter(validate(this), callbackfn,
	        arguments.length > 1 ? arguments[1] : undefined));
	    },
	    find: function find(predicate /* , thisArg */) {
	      return arrayFind(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    findIndex: function findIndex(predicate /* , thisArg */) {
	      return arrayFindIndex(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    forEach: function forEach(callbackfn /* , thisArg */) {
	      arrayForEach(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    indexOf: function indexOf(searchElement /* , fromIndex */) {
	      return arrayIndexOf(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    includes: function includes(searchElement /* , fromIndex */) {
	      return arrayIncludes(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    join: function join(separator) { // eslint-disable-line no-unused-vars
	      return arrayJoin.apply(validate(this), arguments);
	    },
	    lastIndexOf: function lastIndexOf(searchElement /* , fromIndex */) { // eslint-disable-line no-unused-vars
	      return arrayLastIndexOf.apply(validate(this), arguments);
	    },
	    map: function map(mapfn /* , thisArg */) {
	      return $map(validate(this), mapfn, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    reduce: function reduce(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
	      return arrayReduce.apply(validate(this), arguments);
	    },
	    reduceRight: function reduceRight(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars
	      return arrayReduceRight.apply(validate(this), arguments);
	    },
	    reverse: function reverse() {
	      var that = this;
	      var length = validate(that).length;
	      var middle = Math.floor(length / 2);
	      var index = 0;
	      var value;
	      while (index < middle) {
	        value = that[index];
	        that[index++] = that[--length];
	        that[length] = value;
	      } return that;
	    },
	    some: function some(callbackfn /* , thisArg */) {
	      return arraySome(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    },
	    sort: function sort(comparefn) {
	      return arraySort.call(validate(this), comparefn);
	    },
	    subarray: function subarray(begin, end) {
	      var O = validate(this);
	      var length = O.length;
	      var $begin = toAbsoluteIndex(begin, length);
	      return new (speciesConstructor(O, O[DEF_CONSTRUCTOR]))(
	        O.buffer,
	        O.byteOffset + $begin * O.BYTES_PER_ELEMENT,
	        toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - $begin)
	      );
	    }
	  };

	  var $slice = function slice(start, end) {
	    return speciesFromList(this, arraySlice.call(validate(this), start, end));
	  };

	  var $set = function set(arrayLike /* , offset */) {
	    validate(this);
	    var offset = toOffset(arguments[1], 1);
	    var length = this.length;
	    var src = toObject(arrayLike);
	    var len = toLength(src.length);
	    var index = 0;
	    if (len + offset > length) throw RangeError(WRONG_LENGTH);
	    while (index < len) this[offset + index] = src[index++];
	  };

	  var $iterators = {
	    entries: function entries() {
	      return arrayEntries.call(validate(this));
	    },
	    keys: function keys() {
	      return arrayKeys.call(validate(this));
	    },
	    values: function values() {
	      return arrayValues.call(validate(this));
	    }
	  };

	  var isTAIndex = function (target, key) {
	    return isObject(target)
	      && target[TYPED_ARRAY]
	      && typeof key != 'symbol'
	      && key in target
	      && String(+key) == String(key);
	  };
	  var $getDesc = function getOwnPropertyDescriptor(target, key) {
	    return isTAIndex(target, key = toPrimitive(key, true))
	      ? propertyDesc(2, target[key])
	      : gOPD(target, key);
	  };
	  var $setDesc = function defineProperty(target, key, desc) {
	    if (isTAIndex(target, key = toPrimitive(key, true))
	      && isObject(desc)
	      && has(desc, 'value')
	      && !has(desc, 'get')
	      && !has(desc, 'set')
	      // TODO: add validation descriptor w/o calling accessors
	      && !desc.configurable
	      && (!has(desc, 'writable') || desc.writable)
	      && (!has(desc, 'enumerable') || desc.enumerable)
	    ) {
	      target[key] = desc.value;
	      return target;
	    } return dP(target, key, desc);
	  };

	  if (!ALL_CONSTRUCTORS) {
	    $GOPD.f = $getDesc;
	    $DP.f = $setDesc;
	  }

	  $export($export.S + $export.F * !ALL_CONSTRUCTORS, 'Object', {
	    getOwnPropertyDescriptor: $getDesc,
	    defineProperty: $setDesc
	  });

	  if (fails(function () { arrayToString.call({}); })) {
	    arrayToString = arrayToLocaleString = function toString() {
	      return arrayJoin.call(this);
	    };
	  }

	  var $TypedArrayPrototype$ = redefineAll({}, proto);
	  redefineAll($TypedArrayPrototype$, $iterators);
	  hide($TypedArrayPrototype$, ITERATOR, $iterators.values);
	  redefineAll($TypedArrayPrototype$, {
	    slice: $slice,
	    set: $set,
	    constructor: function () { /* noop */ },
	    toString: arrayToString,
	    toLocaleString: $toLocaleString
	  });
	  addGetter($TypedArrayPrototype$, 'buffer', 'b');
	  addGetter($TypedArrayPrototype$, 'byteOffset', 'o');
	  addGetter($TypedArrayPrototype$, 'byteLength', 'l');
	  addGetter($TypedArrayPrototype$, 'length', 'e');
	  dP($TypedArrayPrototype$, TAG, {
	    get: function () { return this[TYPED_ARRAY]; }
	  });

	  // eslint-disable-next-line max-statements
	  module.exports = function (KEY, BYTES, wrapper, CLAMPED) {
	    CLAMPED = !!CLAMPED;
	    var NAME = KEY + (CLAMPED ? 'Clamped' : '') + 'Array';
	    var GETTER = 'get' + KEY;
	    var SETTER = 'set' + KEY;
	    var TypedArray = global[NAME];
	    var Base = TypedArray || {};
	    var TAC = TypedArray && getPrototypeOf(TypedArray);
	    var FORCED = !TypedArray || !$typed.ABV;
	    var O = {};
	    var TypedArrayPrototype = TypedArray && TypedArray[PROTOTYPE];
	    var getter = function (that, index) {
	      var data = that._d;
	      return data.v[GETTER](index * BYTES + data.o, LITTLE_ENDIAN);
	    };
	    var setter = function (that, index, value) {
	      var data = that._d;
	      if (CLAMPED) value = (value = Math.round(value)) < 0 ? 0 : value > 0xff ? 0xff : value & 0xff;
	      data.v[SETTER](index * BYTES + data.o, value, LITTLE_ENDIAN);
	    };
	    var addElement = function (that, index) {
	      dP(that, index, {
	        get: function () {
	          return getter(this, index);
	        },
	        set: function (value) {
	          return setter(this, index, value);
	        },
	        enumerable: true
	      });
	    };
	    if (FORCED) {
	      TypedArray = wrapper(function (that, data, $offset, $length) {
	        anInstance(that, TypedArray, NAME, '_d');
	        var index = 0;
	        var offset = 0;
	        var buffer, byteLength, length, klass;
	        if (!isObject(data)) {
	          length = toIndex(data);
	          byteLength = length * BYTES;
	          buffer = new $ArrayBuffer(byteLength);
	        } else if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
	          buffer = data;
	          offset = toOffset($offset, BYTES);
	          var $len = data.byteLength;
	          if ($length === undefined) {
	            if ($len % BYTES) throw RangeError(WRONG_LENGTH);
	            byteLength = $len - offset;
	            if (byteLength < 0) throw RangeError(WRONG_LENGTH);
	          } else {
	            byteLength = toLength($length) * BYTES;
	            if (byteLength + offset > $len) throw RangeError(WRONG_LENGTH);
	          }
	          length = byteLength / BYTES;
	        } else if (TYPED_ARRAY in data) {
	          return fromList(TypedArray, data);
	        } else {
	          return $from.call(TypedArray, data);
	        }
	        hide(that, '_d', {
	          b: buffer,
	          o: offset,
	          l: byteLength,
	          e: length,
	          v: new $DataView(buffer)
	        });
	        while (index < length) addElement(that, index++);
	      });
	      TypedArrayPrototype = TypedArray[PROTOTYPE] = create($TypedArrayPrototype$);
	      hide(TypedArrayPrototype, 'constructor', TypedArray);
	    } else if (!fails(function () {
	      TypedArray(1);
	    }) || !fails(function () {
	      new TypedArray(-1); // eslint-disable-line no-new
	    }) || !$iterDetect(function (iter) {
	      new TypedArray(); // eslint-disable-line no-new
	      new TypedArray(null); // eslint-disable-line no-new
	      new TypedArray(1.5); // eslint-disable-line no-new
	      new TypedArray(iter); // eslint-disable-line no-new
	    }, true)) {
	      TypedArray = wrapper(function (that, data, $offset, $length) {
	        anInstance(that, TypedArray, NAME);
	        var klass;
	        // `ws` module bug, temporarily remove validation length for Uint8Array
	        // https://github.com/websockets/ws/pull/645
	        if (!isObject(data)) return new Base(toIndex(data));
	        if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {
	          return $length !== undefined
	            ? new Base(data, toOffset($offset, BYTES), $length)
	            : $offset !== undefined
	              ? new Base(data, toOffset($offset, BYTES))
	              : new Base(data);
	        }
	        if (TYPED_ARRAY in data) return fromList(TypedArray, data);
	        return $from.call(TypedArray, data);
	      });
	      arrayForEach(TAC !== Function.prototype ? gOPN(Base).concat(gOPN(TAC)) : gOPN(Base), function (key) {
	        if (!(key in TypedArray)) hide(TypedArray, key, Base[key]);
	      });
	      TypedArray[PROTOTYPE] = TypedArrayPrototype;
	      if (!LIBRARY) TypedArrayPrototype.constructor = TypedArray;
	    }
	    var $nativeIterator = TypedArrayPrototype[ITERATOR];
	    var CORRECT_ITER_NAME = !!$nativeIterator
	      && ($nativeIterator.name == 'values' || $nativeIterator.name == undefined);
	    var $iterator = $iterators.values;
	    hide(TypedArray, TYPED_CONSTRUCTOR, true);
	    hide(TypedArrayPrototype, TYPED_ARRAY, NAME);
	    hide(TypedArrayPrototype, VIEW, true);
	    hide(TypedArrayPrototype, DEF_CONSTRUCTOR, TypedArray);

	    if (CLAMPED ? new TypedArray(1)[TAG] != NAME : !(TAG in TypedArrayPrototype)) {
	      dP(TypedArrayPrototype, TAG, {
	        get: function () { return NAME; }
	      });
	    }

	    O[NAME] = TypedArray;

	    $export($export.G + $export.W + $export.F * (TypedArray != Base), O);

	    $export($export.S, NAME, {
	      BYTES_PER_ELEMENT: BYTES
	    });

	    $export($export.S + $export.F * fails(function () { Base.of.call(TypedArray, 1); }), NAME, {
	      from: $from,
	      of: $of
	    });

	    if (!(BYTES_PER_ELEMENT in TypedArrayPrototype)) hide(TypedArrayPrototype, BYTES_PER_ELEMENT, BYTES);

	    $export($export.P, NAME, proto);

	    setSpecies(NAME);

	    $export($export.P + $export.F * FORCED_SET, NAME, { set: $set });

	    $export($export.P + $export.F * !CORRECT_ITER_NAME, NAME, $iterators);

	    if (!LIBRARY && TypedArrayPrototype.toString != arrayToString) TypedArrayPrototype.toString = arrayToString;

	    $export($export.P + $export.F * fails(function () {
	      new TypedArray(1).slice();
	    }), NAME, { slice: $slice });

	    $export($export.P + $export.F * (fails(function () {
	      return [1, 2].toLocaleString() != new TypedArray([1, 2]).toLocaleString();
	    }) || !fails(function () {
	      TypedArrayPrototype.toLocaleString.call([1, 2]);
	    })), NAME, { toLocaleString: $toLocaleString });

	    Iterators[NAME] = CORRECT_ITER_NAME ? $nativeIterator : $iterator;
	    if (!LIBRARY && !CORRECT_ITER_NAME) hide(TypedArrayPrototype, ITERATOR, $iterator);
	  };
	} else module.exports = function () { /* empty */ };

	},{"./_an-instance":20,"./_array-copy-within":22,"./_array-fill":23,"./_array-includes":24,"./_array-methods":25,"./_classof":29,"./_ctx":33,"./_descriptors":35,"./_export":39,"./_fails":41,"./_global":45,"./_has":46,"./_hide":47,"./_is-array-iter":53,"./_is-object":55,"./_iter-detect":60,"./_iterators":62,"./_library":63,"./_object-create":68,"./_object-dp":69,"./_object-gopd":71,"./_object-gopn":73,"./_object-gpo":75,"./_property-desc":83,"./_redefine-all":84,"./_set-species":87,"./_species-constructor":91,"./_to-absolute-index":98,"./_to-index":99,"./_to-integer":100,"./_to-length":102,"./_to-object":103,"./_to-primitive":104,"./_typed":107,"./_typed-buffer":106,"./_uid":108,"./_wks":112,"./core.get-iterator-method":113,"./es6.array.iterator":122}],106:[function(require,module,exports){
	var global = require('./_global');
	var DESCRIPTORS = require('./_descriptors');
	var LIBRARY = require('./_library');
	var $typed = require('./_typed');
	var hide = require('./_hide');
	var redefineAll = require('./_redefine-all');
	var fails = require('./_fails');
	var anInstance = require('./_an-instance');
	var toInteger = require('./_to-integer');
	var toLength = require('./_to-length');
	var toIndex = require('./_to-index');
	var gOPN = require('./_object-gopn').f;
	var dP = require('./_object-dp').f;
	var arrayFill = require('./_array-fill');
	var setToStringTag = require('./_set-to-string-tag');
	var ARRAY_BUFFER = 'ArrayBuffer';
	var DATA_VIEW = 'DataView';
	var PROTOTYPE = 'prototype';
	var WRONG_LENGTH = 'Wrong length!';
	var WRONG_INDEX = 'Wrong index!';
	var $ArrayBuffer = global[ARRAY_BUFFER];
	var $DataView = global[DATA_VIEW];
	var Math = global.Math;
	var RangeError = global.RangeError;
	// eslint-disable-next-line no-shadow-restricted-names
	var Infinity = global.Infinity;
	var BaseBuffer = $ArrayBuffer;
	var abs = Math.abs;
	var pow = Math.pow;
	var floor = Math.floor;
	var log = Math.log;
	var LN2 = Math.LN2;
	var BUFFER = 'buffer';
	var BYTE_LENGTH = 'byteLength';
	var BYTE_OFFSET = 'byteOffset';
	var $BUFFER = DESCRIPTORS ? '_b' : BUFFER;
	var $LENGTH = DESCRIPTORS ? '_l' : BYTE_LENGTH;
	var $OFFSET = DESCRIPTORS ? '_o' : BYTE_OFFSET;

	// IEEE754 conversions based on https://github.com/feross/ieee754
	function packIEEE754(value, mLen, nBytes) {
	  var buffer = new Array(nBytes);
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = mLen === 23 ? pow(2, -24) - pow(2, -77) : 0;
	  var i = 0;
	  var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
	  var e, m, c;
	  value = abs(value);
	  // eslint-disable-next-line no-self-compare
	  if (value != value || value === Infinity) {
	    // eslint-disable-next-line no-self-compare
	    m = value != value ? 1 : 0;
	    e = eMax;
	  } else {
	    e = floor(log(value) / LN2);
	    if (value * (c = pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }
	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * pow(2, eBias - 1) * pow(2, mLen);
	      e = 0;
	    }
	  }
	  for (; mLen >= 8; buffer[i++] = m & 255, m /= 256, mLen -= 8);
	  e = e << mLen | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[i++] = e & 255, e /= 256, eLen -= 8);
	  buffer[--i] |= s * 128;
	  return buffer;
	}
	function unpackIEEE754(buffer, mLen, nBytes) {
	  var eLen = nBytes * 8 - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = eLen - 7;
	  var i = nBytes - 1;
	  var s = buffer[i--];
	  var e = s & 127;
	  var m;
	  s >>= 7;
	  for (; nBits > 0; e = e * 256 + buffer[i], i--, nBits -= 8);
	  m = e & (1 << -nBits) - 1;
	  e >>= -nBits;
	  nBits += mLen;
	  for (; nBits > 0; m = m * 256 + buffer[i], i--, nBits -= 8);
	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : s ? -Infinity : Infinity;
	  } else {
	    m = m + pow(2, mLen);
	    e = e - eBias;
	  } return (s ? -1 : 1) * m * pow(2, e - mLen);
	}

	function unpackI32(bytes) {
	  return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
	}
	function packI8(it) {
	  return [it & 0xff];
	}
	function packI16(it) {
	  return [it & 0xff, it >> 8 & 0xff];
	}
	function packI32(it) {
	  return [it & 0xff, it >> 8 & 0xff, it >> 16 & 0xff, it >> 24 & 0xff];
	}
	function packF64(it) {
	  return packIEEE754(it, 52, 8);
	}
	function packF32(it) {
	  return packIEEE754(it, 23, 4);
	}

	function addGetter(C, key, internal) {
	  dP(C[PROTOTYPE], key, { get: function () { return this[internal]; } });
	}

	function get(view, bytes, index, isLittleEndian) {
	  var numIndex = +index;
	  var intIndex = toIndex(numIndex);
	  if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
	  var store = view[$BUFFER]._b;
	  var start = intIndex + view[$OFFSET];
	  var pack = store.slice(start, start + bytes);
	  return isLittleEndian ? pack : pack.reverse();
	}
	function set(view, bytes, index, conversion, value, isLittleEndian) {
	  var numIndex = +index;
	  var intIndex = toIndex(numIndex);
	  if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);
	  var store = view[$BUFFER]._b;
	  var start = intIndex + view[$OFFSET];
	  var pack = conversion(+value);
	  for (var i = 0; i < bytes; i++) store[start + i] = pack[isLittleEndian ? i : bytes - i - 1];
	}

	if (!$typed.ABV) {
	  $ArrayBuffer = function ArrayBuffer(length) {
	    anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
	    var byteLength = toIndex(length);
	    this._b = arrayFill.call(new Array(byteLength), 0);
	    this[$LENGTH] = byteLength;
	  };

	  $DataView = function DataView(buffer, byteOffset, byteLength) {
	    anInstance(this, $DataView, DATA_VIEW);
	    anInstance(buffer, $ArrayBuffer, DATA_VIEW);
	    var bufferLength = buffer[$LENGTH];
	    var offset = toInteger(byteOffset);
	    if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset!');
	    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
	    if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
	    this[$BUFFER] = buffer;
	    this[$OFFSET] = offset;
	    this[$LENGTH] = byteLength;
	  };

	  if (DESCRIPTORS) {
	    addGetter($ArrayBuffer, BYTE_LENGTH, '_l');
	    addGetter($DataView, BUFFER, '_b');
	    addGetter($DataView, BYTE_LENGTH, '_l');
	    addGetter($DataView, BYTE_OFFSET, '_o');
	  }

	  redefineAll($DataView[PROTOTYPE], {
	    getInt8: function getInt8(byteOffset) {
	      return get(this, 1, byteOffset)[0] << 24 >> 24;
	    },
	    getUint8: function getUint8(byteOffset) {
	      return get(this, 1, byteOffset)[0];
	    },
	    getInt16: function getInt16(byteOffset /* , littleEndian */) {
	      var bytes = get(this, 2, byteOffset, arguments[1]);
	      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
	    },
	    getUint16: function getUint16(byteOffset /* , littleEndian */) {
	      var bytes = get(this, 2, byteOffset, arguments[1]);
	      return bytes[1] << 8 | bytes[0];
	    },
	    getInt32: function getInt32(byteOffset /* , littleEndian */) {
	      return unpackI32(get(this, 4, byteOffset, arguments[1]));
	    },
	    getUint32: function getUint32(byteOffset /* , littleEndian */) {
	      return unpackI32(get(this, 4, byteOffset, arguments[1])) >>> 0;
	    },
	    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
	      return unpackIEEE754(get(this, 4, byteOffset, arguments[1]), 23, 4);
	    },
	    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
	      return unpackIEEE754(get(this, 8, byteOffset, arguments[1]), 52, 8);
	    },
	    setInt8: function setInt8(byteOffset, value) {
	      set(this, 1, byteOffset, packI8, value);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      set(this, 1, byteOffset, packI8, value);
	    },
	    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
	      set(this, 2, byteOffset, packI16, value, arguments[2]);
	    },
	    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
	      set(this, 2, byteOffset, packI16, value, arguments[2]);
	    },
	    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
	      set(this, 4, byteOffset, packI32, value, arguments[2]);
	    },
	    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
	      set(this, 4, byteOffset, packI32, value, arguments[2]);
	    },
	    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
	      set(this, 4, byteOffset, packF32, value, arguments[2]);
	    },
	    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
	      set(this, 8, byteOffset, packF64, value, arguments[2]);
	    }
	  });
	} else {
	  if (!fails(function () {
	    $ArrayBuffer(1);
	  }) || !fails(function () {
	    new $ArrayBuffer(-1); // eslint-disable-line no-new
	  }) || fails(function () {
	    new $ArrayBuffer(); // eslint-disable-line no-new
	    new $ArrayBuffer(1.5); // eslint-disable-line no-new
	    new $ArrayBuffer(NaN); // eslint-disable-line no-new
	    return $ArrayBuffer.name != ARRAY_BUFFER;
	  })) {
	    $ArrayBuffer = function ArrayBuffer(length) {
	      anInstance(this, $ArrayBuffer);
	      return new BaseBuffer(toIndex(length));
	    };
	    var ArrayBufferProto = $ArrayBuffer[PROTOTYPE] = BaseBuffer[PROTOTYPE];
	    for (var keys = gOPN(BaseBuffer), j = 0, key; keys.length > j;) {
	      if (!((key = keys[j++]) in $ArrayBuffer)) hide($ArrayBuffer, key, BaseBuffer[key]);
	    }
	    if (!LIBRARY) ArrayBufferProto.constructor = $ArrayBuffer;
	  }
	  // iOS Safari 7.x bug
	  var view = new $DataView(new $ArrayBuffer(2));
	  var $setInt8 = $DataView[PROTOTYPE].setInt8;
	  view.setInt8(0, 2147483648);
	  view.setInt8(1, 2147483649);
	  if (view.getInt8(0) || !view.getInt8(1)) redefineAll($DataView[PROTOTYPE], {
	    setInt8: function setInt8(byteOffset, value) {
	      $setInt8.call(this, byteOffset, value << 24 >> 24);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      $setInt8.call(this, byteOffset, value << 24 >> 24);
	    }
	  }, true);
	}
	setToStringTag($ArrayBuffer, ARRAY_BUFFER);
	setToStringTag($DataView, DATA_VIEW);
	hide($DataView[PROTOTYPE], $typed.VIEW, true);
	exports[ARRAY_BUFFER] = $ArrayBuffer;
	exports[DATA_VIEW] = $DataView;

	},{"./_an-instance":20,"./_array-fill":23,"./_descriptors":35,"./_fails":41,"./_global":45,"./_hide":47,"./_library":63,"./_object-dp":69,"./_object-gopn":73,"./_redefine-all":84,"./_set-to-string-tag":88,"./_to-index":99,"./_to-integer":100,"./_to-length":102,"./_typed":107}],107:[function(require,module,exports){
	var global = require('./_global');
	var hide = require('./_hide');
	var uid = require('./_uid');
	var TYPED = uid('typed_array');
	var VIEW = uid('view');
	var ABV = !!(global.ArrayBuffer && global.DataView);
	var CONSTR = ABV;
	var i = 0;
	var l = 9;
	var Typed;

	var TypedArrayConstructors = (
	  'Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array'
	).split(',');

	while (i < l) {
	  if (Typed = global[TypedArrayConstructors[i++]]) {
	    hide(Typed.prototype, TYPED, true);
	    hide(Typed.prototype, VIEW, true);
	  } else CONSTR = false;
	}

	module.exports = {
	  ABV: ABV,
	  CONSTR: CONSTR,
	  TYPED: TYPED,
	  VIEW: VIEW
	};

	},{"./_global":45,"./_hide":47,"./_uid":108}],108:[function(require,module,exports){
	var id = 0;
	var px = Math.random();
	module.exports = function (key) {
	  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
	};

	},{}],109:[function(require,module,exports){
	var global = require('./_global');
	var navigator = global.navigator;

	module.exports = navigator && navigator.userAgent || '';

	},{"./_global":45}],110:[function(require,module,exports){
	var global = require('./_global');
	var core = require('./_core');
	var LIBRARY = require('./_library');
	var wksExt = require('./_wks-ext');
	var defineProperty = require('./_object-dp').f;
	module.exports = function (name) {
	  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
	  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
	};

	},{"./_core":31,"./_global":45,"./_library":63,"./_object-dp":69,"./_wks-ext":111}],111:[function(require,module,exports){
	exports.f = require('./_wks');

	},{"./_wks":112}],112:[function(require,module,exports){
	var store = require('./_shared')('wks');
	var uid = require('./_uid');
	var Symbol = require('./_global').Symbol;
	var USE_SYMBOL = typeof Symbol == 'function';

	var $exports = module.exports = function (name) {
	  return store[name] || (store[name] =
	    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
	};

	$exports.store = store;

	},{"./_global":45,"./_shared":90,"./_uid":108}],113:[function(require,module,exports){
	var classof = require('./_classof');
	var ITERATOR = require('./_wks')('iterator');
	var Iterators = require('./_iterators');
	module.exports = require('./_core').getIteratorMethod = function (it) {
	  if (it != undefined) return it[ITERATOR]
	    || it['@@iterator']
	    || Iterators[classof(it)];
	};

	},{"./_classof":29,"./_core":31,"./_iterators":62,"./_wks":112}],114:[function(require,module,exports){
	// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)
	var $export = require('./_export');

	$export($export.P, 'Array', { fill: require('./_array-fill') });

	require('./_add-to-unscopables')('fill');

	},{"./_add-to-unscopables":19,"./_array-fill":23,"./_export":39}],115:[function(require,module,exports){
	var $export = require('./_export');
	var $filter = require('./_array-methods')(2);

	$export($export.P + $export.F * !require('./_strict-method')([].filter, true), 'Array', {
	  // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])
	  filter: function filter(callbackfn /* , thisArg */) {
	    return $filter(this, callbackfn, arguments[1]);
	  }
	});

	},{"./_array-methods":25,"./_export":39,"./_strict-method":92}],116:[function(require,module,exports){
	// 22.1.3.9 Array.prototype.findIndex(predicate, thisArg = undefined)
	var $export = require('./_export');
	var $find = require('./_array-methods')(6);
	var KEY = 'findIndex';
	var forced = true;
	// Shouldn't skip holes
	if (KEY in []) Array(1)[KEY](function () { forced = false; });
	$export($export.P + $export.F * forced, 'Array', {
	  findIndex: function findIndex(callbackfn /* , that = undefined */) {
	    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	require('./_add-to-unscopables')(KEY);

	},{"./_add-to-unscopables":19,"./_array-methods":25,"./_export":39}],117:[function(require,module,exports){
	// 22.1.3.8 Array.prototype.find(predicate, thisArg = undefined)
	var $export = require('./_export');
	var $find = require('./_array-methods')(5);
	var KEY = 'find';
	var forced = true;
	// Shouldn't skip holes
	if (KEY in []) Array(1)[KEY](function () { forced = false; });
	$export($export.P + $export.F * forced, 'Array', {
	  find: function find(callbackfn /* , that = undefined */) {
	    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	require('./_add-to-unscopables')(KEY);

	},{"./_add-to-unscopables":19,"./_array-methods":25,"./_export":39}],118:[function(require,module,exports){
	var $export = require('./_export');
	var $forEach = require('./_array-methods')(0);
	var STRICT = require('./_strict-method')([].forEach, true);

	$export($export.P + $export.F * !STRICT, 'Array', {
	  // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])
	  forEach: function forEach(callbackfn /* , thisArg */) {
	    return $forEach(this, callbackfn, arguments[1]);
	  }
	});

	},{"./_array-methods":25,"./_export":39,"./_strict-method":92}],119:[function(require,module,exports){
	var ctx = require('./_ctx');
	var $export = require('./_export');
	var toObject = require('./_to-object');
	var call = require('./_iter-call');
	var isArrayIter = require('./_is-array-iter');
	var toLength = require('./_to-length');
	var createProperty = require('./_create-property');
	var getIterFn = require('./core.get-iterator-method');

	$export($export.S + $export.F * !require('./_iter-detect')(function (iter) { Array.from(iter); }), 'Array', {
	  // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)
	  from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
	    var O = toObject(arrayLike);
	    var C = typeof this == 'function' ? this : Array;
	    var aLen = arguments.length;
	    var mapfn = aLen > 1 ? arguments[1] : undefined;
	    var mapping = mapfn !== undefined;
	    var index = 0;
	    var iterFn = getIterFn(O);
	    var length, result, step, iterator;
	    if (mapping) mapfn = ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);
	    // if object isn't iterable or it's array with default iterator - use simple case
	    if (iterFn != undefined && !(C == Array && isArrayIter(iterFn))) {
	      for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {
	        createProperty(result, index, mapping ? call(iterator, mapfn, [step.value, index], true) : step.value);
	      }
	    } else {
	      length = toLength(O.length);
	      for (result = new C(length); length > index; index++) {
	        createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);
	      }
	    }
	    result.length = index;
	    return result;
	  }
	});

	},{"./_create-property":32,"./_ctx":33,"./_export":39,"./_is-array-iter":53,"./_iter-call":57,"./_iter-detect":60,"./_to-length":102,"./_to-object":103,"./core.get-iterator-method":113}],120:[function(require,module,exports){
	var $export = require('./_export');
	var $indexOf = require('./_array-includes')(false);
	var $native = [].indexOf;
	var NEGATIVE_ZERO = !!$native && 1 / [1].indexOf(1, -0) < 0;

	$export($export.P + $export.F * (NEGATIVE_ZERO || !require('./_strict-method')($native)), 'Array', {
	  // 22.1.3.11 / 15.4.4.14 Array.prototype.indexOf(searchElement [, fromIndex])
	  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
	    return NEGATIVE_ZERO
	      // convert -0 to +0
	      ? $native.apply(this, arguments) || 0
	      : $indexOf(this, searchElement, arguments[1]);
	  }
	});

	},{"./_array-includes":24,"./_export":39,"./_strict-method":92}],121:[function(require,module,exports){
	// 22.1.2.2 / 15.4.3.2 Array.isArray(arg)
	var $export = require('./_export');

	$export($export.S, 'Array', { isArray: require('./_is-array') });

	},{"./_export":39,"./_is-array":54}],122:[function(require,module,exports){
	var addToUnscopables = require('./_add-to-unscopables');
	var step = require('./_iter-step');
	var Iterators = require('./_iterators');
	var toIObject = require('./_to-iobject');

	// 22.1.3.4 Array.prototype.entries()
	// 22.1.3.13 Array.prototype.keys()
	// 22.1.3.29 Array.prototype.values()
	// 22.1.3.30 Array.prototype[@@iterator]()
	module.exports = require('./_iter-define')(Array, 'Array', function (iterated, kind) {
	  this._t = toIObject(iterated); // target
	  this._i = 0;                   // next index
	  this._k = kind;                // kind
	// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
	}, function () {
	  var O = this._t;
	  var kind = this._k;
	  var index = this._i++;
	  if (!O || index >= O.length) {
	    this._t = undefined;
	    return step(1);
	  }
	  if (kind == 'keys') return step(0, index);
	  if (kind == 'values') return step(0, O[index]);
	  return step(0, [index, O[index]]);
	}, 'values');

	// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
	Iterators.Arguments = Iterators.Array;

	addToUnscopables('keys');
	addToUnscopables('values');
	addToUnscopables('entries');

	},{"./_add-to-unscopables":19,"./_iter-define":59,"./_iter-step":61,"./_iterators":62,"./_to-iobject":101}],123:[function(require,module,exports){
	var $export = require('./_export');
	var $map = require('./_array-methods')(1);

	$export($export.P + $export.F * !require('./_strict-method')([].map, true), 'Array', {
	  // 22.1.3.15 / 15.4.4.19 Array.prototype.map(callbackfn [, thisArg])
	  map: function map(callbackfn /* , thisArg */) {
	    return $map(this, callbackfn, arguments[1]);
	  }
	});

	},{"./_array-methods":25,"./_export":39,"./_strict-method":92}],124:[function(require,module,exports){
	var DateProto = Date.prototype;
	var INVALID_DATE = 'Invalid Date';
	var TO_STRING = 'toString';
	var $toString = DateProto[TO_STRING];
	var getTime = DateProto.getTime;
	if (new Date(NaN) + '' != INVALID_DATE) {
	  require('./_redefine')(DateProto, TO_STRING, function toString() {
	    var value = getTime.call(this);
	    // eslint-disable-next-line no-self-compare
	    return value === value ? $toString.call(this) : INVALID_DATE;
	  });
	}

	},{"./_redefine":85}],125:[function(require,module,exports){
	// 19.2.3.2 / 15.3.4.5 Function.prototype.bind(thisArg, args...)
	var $export = require('./_export');

	$export($export.P, 'Function', { bind: require('./_bind') });

	},{"./_bind":28,"./_export":39}],126:[function(require,module,exports){
	var global = require('./_global');
	var has = require('./_has');
	var cof = require('./_cof');
	var inheritIfRequired = require('./_inherit-if-required');
	var toPrimitive = require('./_to-primitive');
	var fails = require('./_fails');
	var gOPN = require('./_object-gopn').f;
	var gOPD = require('./_object-gopd').f;
	var dP = require('./_object-dp').f;
	var $trim = require('./_string-trim').trim;
	var NUMBER = 'Number';
	var $Number = global[NUMBER];
	var Base = $Number;
	var proto = $Number.prototype;
	// Opera ~12 has broken Object#toString
	var BROKEN_COF = cof(require('./_object-create')(proto)) == NUMBER;
	var TRIM = 'trim' in String.prototype;

	// 7.1.3 ToNumber(argument)
	var toNumber = function (argument) {
	  var it = toPrimitive(argument, false);
	  if (typeof it == 'string' && it.length > 2) {
	    it = TRIM ? it.trim() : $trim(it, 3);
	    var first = it.charCodeAt(0);
	    var third, radix, maxCode;
	    if (first === 43 || first === 45) {
	      third = it.charCodeAt(2);
	      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
	    } else if (first === 48) {
	      switch (it.charCodeAt(1)) {
	        case 66: case 98: radix = 2; maxCode = 49; break; // fast equal /^0b[01]+$/i
	        case 79: case 111: radix = 8; maxCode = 55; break; // fast equal /^0o[0-7]+$/i
	        default: return +it;
	      }
	      for (var digits = it.slice(2), i = 0, l = digits.length, code; i < l; i++) {
	        code = digits.charCodeAt(i);
	        // parseInt parses a string to a first unavailable symbol
	        // but ToNumber should return NaN if a string contains unavailable symbols
	        if (code < 48 || code > maxCode) return NaN;
	      } return parseInt(digits, radix);
	    }
	  } return +it;
	};

	if (!$Number(' 0o1') || !$Number('0b1') || $Number('+0x1')) {
	  $Number = function Number(value) {
	    var it = arguments.length < 1 ? 0 : value;
	    var that = this;
	    return that instanceof $Number
	      // check on 1..constructor(foo) case
	      && (BROKEN_COF ? fails(function () { proto.valueOf.call(that); }) : cof(that) != NUMBER)
	        ? inheritIfRequired(new Base(toNumber(it)), that, $Number) : toNumber(it);
	  };
	  for (var keys = require('./_descriptors') ? gOPN(Base) : (
	    // ES3:
	    'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
	    // ES6 (in case, if modules with ES6 Number statics required before):
	    'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' +
	    'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger'
	  ).split(','), j = 0, key; keys.length > j; j++) {
	    if (has(Base, key = keys[j]) && !has($Number, key)) {
	      dP($Number, key, gOPD(Base, key));
	    }
	  }
	  $Number.prototype = proto;
	  proto.constructor = $Number;
	  require('./_redefine')(global, NUMBER, $Number);
	}

	},{"./_cof":30,"./_descriptors":35,"./_fails":41,"./_global":45,"./_has":46,"./_inherit-if-required":50,"./_object-create":68,"./_object-dp":69,"./_object-gopd":71,"./_object-gopn":73,"./_redefine":85,"./_string-trim":95,"./_to-primitive":104}],127:[function(require,module,exports){
	// 19.1.3.1 Object.assign(target, source)
	var $export = require('./_export');

	$export($export.S + $export.F, 'Object', { assign: require('./_object-assign') });

	},{"./_export":39,"./_object-assign":67}],128:[function(require,module,exports){
	var $export = require('./_export');
	// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
	$export($export.S, 'Object', { create: require('./_object-create') });

	},{"./_export":39,"./_object-create":68}],129:[function(require,module,exports){
	var $export = require('./_export');
	// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
	$export($export.S + $export.F * !require('./_descriptors'), 'Object', { defineProperty: require('./_object-dp').f });

	},{"./_descriptors":35,"./_export":39,"./_object-dp":69}],130:[function(require,module,exports){
	// 19.1.2.14 Object.keys(O)
	var toObject = require('./_to-object');
	var $keys = require('./_object-keys');

	require('./_object-sap')('keys', function () {
	  return function keys(it) {
	    return $keys(toObject(it));
	  };
	});

	},{"./_object-keys":77,"./_object-sap":79,"./_to-object":103}],131:[function(require,module,exports){
	// 19.1.3.19 Object.setPrototypeOf(O, proto)
	var $export = require('./_export');
	$export($export.S, 'Object', { setPrototypeOf: require('./_set-proto').set });

	},{"./_export":39,"./_set-proto":86}],132:[function(require,module,exports){
	var LIBRARY = require('./_library');
	var global = require('./_global');
	var ctx = require('./_ctx');
	var classof = require('./_classof');
	var $export = require('./_export');
	var isObject = require('./_is-object');
	var aFunction = require('./_a-function');
	var anInstance = require('./_an-instance');
	var forOf = require('./_for-of');
	var speciesConstructor = require('./_species-constructor');
	var task = require('./_task').set;
	var microtask = require('./_microtask')();
	var newPromiseCapabilityModule = require('./_new-promise-capability');
	var perform = require('./_perform');
	var userAgent = require('./_user-agent');
	var promiseResolve = require('./_promise-resolve');
	var PROMISE = 'Promise';
	var TypeError = global.TypeError;
	var process = global.process;
	var versions = process && process.versions;
	var v8 = versions && versions.v8 || '';
	var $Promise = global[PROMISE];
	var isNode = classof(process) == 'process';
	var empty = function () { /* empty */ };
	var Internal, newGenericPromiseCapability, OwnPromiseCapability, Wrapper;
	var newPromiseCapability = newGenericPromiseCapability = newPromiseCapabilityModule.f;

	var USE_NATIVE = !!function () {
	  try {
	    // correct subclassing with @@species support
	    var promise = $Promise.resolve(1);
	    var FakePromise = (promise.constructor = {})[require('./_wks')('species')] = function (exec) {
	      exec(empty, empty);
	    };
	    // unhandled rejections tracking support, NodeJS Promise without it fails @@species test
	    return (isNode || typeof PromiseRejectionEvent == 'function')
	      && promise.then(empty) instanceof FakePromise
	      // v8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	      // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	      // we can't detect it synchronously, so just check versions
	      && v8.indexOf('6.6') !== 0
	      && userAgent.indexOf('Chrome/66') === -1;
	  } catch (e) { /* empty */ }
	}();

	// helpers
	var isThenable = function (it) {
	  var then;
	  return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
	};
	var notify = function (promise, isReject) {
	  if (promise._n) return;
	  promise._n = true;
	  var chain = promise._c;
	  microtask(function () {
	    var value = promise._v;
	    var ok = promise._s == 1;
	    var i = 0;
	    var run = function (reaction) {
	      var handler = ok ? reaction.ok : reaction.fail;
	      var resolve = reaction.resolve;
	      var reject = reaction.reject;
	      var domain = reaction.domain;
	      var result, then, exited;
	      try {
	        if (handler) {
	          if (!ok) {
	            if (promise._h == 2) onHandleUnhandled(promise);
	            promise._h = 1;
	          }
	          if (handler === true) result = value;
	          else {
	            if (domain) domain.enter();
	            result = handler(value); // may throw
	            if (domain) {
	              domain.exit();
	              exited = true;
	            }
	          }
	          if (result === reaction.promise) {
	            reject(TypeError('Promise-chain cycle'));
	          } else if (then = isThenable(result)) {
	            then.call(result, resolve, reject);
	          } else resolve(result);
	        } else reject(value);
	      } catch (e) {
	        if (domain && !exited) domain.exit();
	        reject(e);
	      }
	    };
	    while (chain.length > i) run(chain[i++]); // variable length - can't use forEach
	    promise._c = [];
	    promise._n = false;
	    if (isReject && !promise._h) onUnhandled(promise);
	  });
	};
	var onUnhandled = function (promise) {
	  task.call(global, function () {
	    var value = promise._v;
	    var unhandled = isUnhandled(promise);
	    var result, handler, console;
	    if (unhandled) {
	      result = perform(function () {
	        if (isNode) {
	          process.emit('unhandledRejection', value, promise);
	        } else if (handler = global.onunhandledrejection) {
	          handler({ promise: promise, reason: value });
	        } else if ((console = global.console) && console.error) {
	          console.error('Unhandled promise rejection', value);
	        }
	      });
	      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
	      promise._h = isNode || isUnhandled(promise) ? 2 : 1;
	    } promise._a = undefined;
	    if (unhandled && result.e) throw result.v;
	  });
	};
	var isUnhandled = function (promise) {
	  return promise._h !== 1 && (promise._a || promise._c).length === 0;
	};
	var onHandleUnhandled = function (promise) {
	  task.call(global, function () {
	    var handler;
	    if (isNode) {
	      process.emit('rejectionHandled', promise);
	    } else if (handler = global.onrejectionhandled) {
	      handler({ promise: promise, reason: promise._v });
	    }
	  });
	};
	var $reject = function (value) {
	  var promise = this;
	  if (promise._d) return;
	  promise._d = true;
	  promise = promise._w || promise; // unwrap
	  promise._v = value;
	  promise._s = 2;
	  if (!promise._a) promise._a = promise._c.slice();
	  notify(promise, true);
	};
	var $resolve = function (value) {
	  var promise = this;
	  var then;
	  if (promise._d) return;
	  promise._d = true;
	  promise = promise._w || promise; // unwrap
	  try {
	    if (promise === value) throw TypeError("Promise can't be resolved itself");
	    if (then = isThenable(value)) {
	      microtask(function () {
	        var wrapper = { _w: promise, _d: false }; // wrap
	        try {
	          then.call(value, ctx($resolve, wrapper, 1), ctx($reject, wrapper, 1));
	        } catch (e) {
	          $reject.call(wrapper, e);
	        }
	      });
	    } else {
	      promise._v = value;
	      promise._s = 1;
	      notify(promise, false);
	    }
	  } catch (e) {
	    $reject.call({ _w: promise, _d: false }, e); // wrap
	  }
	};

	// constructor polyfill
	if (!USE_NATIVE) {
	  // 25.4.3.1 Promise(executor)
	  $Promise = function Promise(executor) {
	    anInstance(this, $Promise, PROMISE, '_h');
	    aFunction(executor);
	    Internal.call(this);
	    try {
	      executor(ctx($resolve, this, 1), ctx($reject, this, 1));
	    } catch (err) {
	      $reject.call(this, err);
	    }
	  };
	  // eslint-disable-next-line no-unused-vars
	  Internal = function Promise(executor) {
	    this._c = [];             // <- awaiting reactions
	    this._a = undefined;      // <- checked in isUnhandled reactions
	    this._s = 0;              // <- state
	    this._d = false;          // <- done
	    this._v = undefined;      // <- value
	    this._h = 0;              // <- rejection state, 0 - default, 1 - handled, 2 - unhandled
	    this._n = false;          // <- notify
	  };
	  Internal.prototype = require('./_redefine-all')($Promise.prototype, {
	    // 25.4.5.3 Promise.prototype.then(onFulfilled, onRejected)
	    then: function then(onFulfilled, onRejected) {
	      var reaction = newPromiseCapability(speciesConstructor(this, $Promise));
	      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
	      reaction.fail = typeof onRejected == 'function' && onRejected;
	      reaction.domain = isNode ? process.domain : undefined;
	      this._c.push(reaction);
	      if (this._a) this._a.push(reaction);
	      if (this._s) notify(this, false);
	      return reaction.promise;
	    },
	    // 25.4.5.1 Promise.prototype.catch(onRejected)
	    'catch': function (onRejected) {
	      return this.then(undefined, onRejected);
	    }
	  });
	  OwnPromiseCapability = function () {
	    var promise = new Internal();
	    this.promise = promise;
	    this.resolve = ctx($resolve, promise, 1);
	    this.reject = ctx($reject, promise, 1);
	  };
	  newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
	    return C === $Promise || C === Wrapper
	      ? new OwnPromiseCapability(C)
	      : newGenericPromiseCapability(C);
	  };
	}

	$export($export.G + $export.W + $export.F * !USE_NATIVE, { Promise: $Promise });
	require('./_set-to-string-tag')($Promise, PROMISE);
	require('./_set-species')(PROMISE);
	Wrapper = require('./_core')[PROMISE];

	// statics
	$export($export.S + $export.F * !USE_NATIVE, PROMISE, {
	  // 25.4.4.5 Promise.reject(r)
	  reject: function reject(r) {
	    var capability = newPromiseCapability(this);
	    var $$reject = capability.reject;
	    $$reject(r);
	    return capability.promise;
	  }
	});
	$export($export.S + $export.F * (LIBRARY || !USE_NATIVE), PROMISE, {
	  // 25.4.4.6 Promise.resolve(x)
	  resolve: function resolve(x) {
	    return promiseResolve(LIBRARY && this === Wrapper ? $Promise : this, x);
	  }
	});
	$export($export.S + $export.F * !(USE_NATIVE && require('./_iter-detect')(function (iter) {
	  $Promise.all(iter)['catch'](empty);
	})), PROMISE, {
	  // 25.4.4.1 Promise.all(iterable)
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapability(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var values = [];
	      var index = 0;
	      var remaining = 1;
	      forOf(iterable, false, function (promise) {
	        var $index = index++;
	        var alreadyCalled = false;
	        values.push(undefined);
	        remaining++;
	        C.resolve(promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[$index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.e) reject(result.v);
	    return capability.promise;
	  },
	  // 25.4.4.4 Promise.race(iterable)
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapability(C);
	    var reject = capability.reject;
	    var result = perform(function () {
	      forOf(iterable, false, function (promise) {
	        C.resolve(promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.e) reject(result.v);
	    return capability.promise;
	  }
	});

	},{"./_a-function":18,"./_an-instance":20,"./_classof":29,"./_core":31,"./_ctx":33,"./_export":39,"./_for-of":44,"./_global":45,"./_is-object":55,"./_iter-detect":60,"./_library":63,"./_microtask":65,"./_new-promise-capability":66,"./_perform":81,"./_promise-resolve":82,"./_redefine-all":84,"./_set-species":87,"./_set-to-string-tag":88,"./_species-constructor":91,"./_task":97,"./_user-agent":109,"./_wks":112}],133:[function(require,module,exports){
	// 26.1.2 Reflect.construct(target, argumentsList [, newTarget])
	var $export = require('./_export');
	var create = require('./_object-create');
	var aFunction = require('./_a-function');
	var anObject = require('./_an-object');
	var isObject = require('./_is-object');
	var fails = require('./_fails');
	var bind = require('./_bind');
	var rConstruct = (require('./_global').Reflect || {}).construct;

	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it
	var NEW_TARGET_BUG = fails(function () {
	  function F() { /* empty */ }
	  return !(rConstruct(function () { /* empty */ }, [], F) instanceof F);
	});
	var ARGS_BUG = !fails(function () {
	  rConstruct(function () { /* empty */ });
	});

	$export($export.S + $export.F * (NEW_TARGET_BUG || ARGS_BUG), 'Reflect', {
	  construct: function construct(Target, args /* , newTarget */) {
	    aFunction(Target);
	    anObject(args);
	    var newTarget = arguments.length < 3 ? Target : aFunction(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return rConstruct(Target, args, newTarget);
	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0: return new Target();
	        case 1: return new Target(args[0]);
	        case 2: return new Target(args[0], args[1]);
	        case 3: return new Target(args[0], args[1], args[2]);
	        case 4: return new Target(args[0], args[1], args[2], args[3]);
	      }
	      // w/o altered newTarget, lot of arguments case
	      var $args = [null];
	      $args.push.apply($args, args);
	      return new (bind.apply(Target, $args))();
	    }
	    // with altered newTarget, not support built-in constructors
	    var proto = newTarget.prototype;
	    var instance = create(isObject(proto) ? proto : Object.prototype);
	    var result = Function.apply.call(Target, instance, args);
	    return isObject(result) ? result : instance;
	  }
	});

	},{"./_a-function":18,"./_an-object":21,"./_bind":28,"./_export":39,"./_fails":41,"./_global":45,"./_is-object":55,"./_object-create":68}],134:[function(require,module,exports){
	// 21.2.5.3 get RegExp.prototype.flags()
	if (require('./_descriptors') && /./g.flags != 'g') require('./_object-dp').f(RegExp.prototype, 'flags', {
	  configurable: true,
	  get: require('./_flags')
	});

	},{"./_descriptors":35,"./_flags":43,"./_object-dp":69}],135:[function(require,module,exports){
	// @@match logic
	require('./_fix-re-wks')('match', 1, function (defined, MATCH, $match) {
	  // 21.1.3.11 String.prototype.match(regexp)
	  return [function match(regexp) {
	    var O = defined(this);
	    var fn = regexp == undefined ? undefined : regexp[MATCH];
	    return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
	  }, $match];
	});

	},{"./_fix-re-wks":42}],136:[function(require,module,exports){
	// @@replace logic
	require('./_fix-re-wks')('replace', 2, function (defined, REPLACE, $replace) {
	  // 21.1.3.14 String.prototype.replace(searchValue, replaceValue)
	  return [function replace(searchValue, replaceValue) {
	    var O = defined(this);
	    var fn = searchValue == undefined ? undefined : searchValue[REPLACE];
	    return fn !== undefined
	      ? fn.call(searchValue, O, replaceValue)
	      : $replace.call(String(O), searchValue, replaceValue);
	  }, $replace];
	});

	},{"./_fix-re-wks":42}],137:[function(require,module,exports){
	// @@split logic
	require('./_fix-re-wks')('split', 2, function (defined, SPLIT, $split) {
	  var isRegExp = require('./_is-regexp');
	  var _split = $split;
	  var $push = [].push;
	  var $SPLIT = 'split';
	  var LENGTH = 'length';
	  var LAST_INDEX = 'lastIndex';
	  if (
	    'abbc'[$SPLIT](/(b)*/)[1] == 'c' ||
	    'test'[$SPLIT](/(?:)/, -1)[LENGTH] != 4 ||
	    'ab'[$SPLIT](/(?:ab)*/)[LENGTH] != 2 ||
	    '.'[$SPLIT](/(.?)(.?)/)[LENGTH] != 4 ||
	    '.'[$SPLIT](/()()/)[LENGTH] > 1 ||
	    ''[$SPLIT](/.?/)[LENGTH]
	  ) {
	    var NPCG = /()??/.exec('')[1] === undefined; // nonparticipating capturing group
	    // based on es5-shim implementation, need to rework it
	    $split = function (separator, limit) {
	      var string = String(this);
	      if (separator === undefined && limit === 0) return [];
	      // If `separator` is not a regex, use native split
	      if (!isRegExp(separator)) return _split.call(string, separator, limit);
	      var output = [];
	      var flags = (separator.ignoreCase ? 'i' : '') +
	                  (separator.multiline ? 'm' : '') +
	                  (separator.unicode ? 'u' : '') +
	                  (separator.sticky ? 'y' : '');
	      var lastLastIndex = 0;
	      var splitLimit = limit === undefined ? 4294967295 : limit >>> 0;
	      // Make `global` and avoid `lastIndex` issues by working with a copy
	      var separatorCopy = new RegExp(separator.source, flags + 'g');
	      var separator2, match, lastIndex, lastLength, i;
	      // Doesn't need flags gy, but they don't hurt
	      if (!NPCG) separator2 = new RegExp('^' + separatorCopy.source + '$(?!\\s)', flags);
	      while (match = separatorCopy.exec(string)) {
	        // `separatorCopy.lastIndex` is not reliable cross-browser
	        lastIndex = match.index + match[0][LENGTH];
	        if (lastIndex > lastLastIndex) {
	          output.push(string.slice(lastLastIndex, match.index));
	          // Fix browsers whose `exec` methods don't consistently return `undefined` for NPCG
	          // eslint-disable-next-line no-loop-func
	          if (!NPCG && match[LENGTH] > 1) match[0].replace(separator2, function () {
	            for (i = 1; i < arguments[LENGTH] - 2; i++) if (arguments[i] === undefined) match[i] = undefined;
	          });
	          if (match[LENGTH] > 1 && match.index < string[LENGTH]) $push.apply(output, match.slice(1));
	          lastLength = match[0][LENGTH];
	          lastLastIndex = lastIndex;
	          if (output[LENGTH] >= splitLimit) break;
	        }
	        if (separatorCopy[LAST_INDEX] === match.index) separatorCopy[LAST_INDEX]++; // Avoid an infinite loop
	      }
	      if (lastLastIndex === string[LENGTH]) {
	        if (lastLength || !separatorCopy.test('')) output.push('');
	      } else output.push(string.slice(lastLastIndex));
	      return output[LENGTH] > splitLimit ? output.slice(0, splitLimit) : output;
	    };
	  // Chakra, V8
	  } else if ('0'[$SPLIT](undefined, 0)[LENGTH]) {
	    $split = function (separator, limit) {
	      return separator === undefined && limit === 0 ? [] : _split.call(this, separator, limit);
	    };
	  }
	  // 21.1.3.17 String.prototype.split(separator, limit)
	  return [function split(separator, limit) {
	    var O = defined(this);
	    var fn = separator == undefined ? undefined : separator[SPLIT];
	    return fn !== undefined ? fn.call(separator, O, limit) : $split.call(String(O), separator, limit);
	  }, $split];
	});

	},{"./_fix-re-wks":42,"./_is-regexp":56}],138:[function(require,module,exports){
	require('./es6.regexp.flags');
	var anObject = require('./_an-object');
	var $flags = require('./_flags');
	var DESCRIPTORS = require('./_descriptors');
	var TO_STRING = 'toString';
	var $toString = /./[TO_STRING];

	var define = function (fn) {
	  require('./_redefine')(RegExp.prototype, TO_STRING, fn, true);
	};

	// 21.2.5.14 RegExp.prototype.toString()
	if (require('./_fails')(function () { return $toString.call({ source: 'a', flags: 'b' }) != '/a/b'; })) {
	  define(function toString() {
	    var R = anObject(this);
	    return '/'.concat(R.source, '/',
	      'flags' in R ? R.flags : !DESCRIPTORS && R instanceof RegExp ? $flags.call(R) : undefined);
	  });
	// FF44- RegExp#toString has a wrong name
	} else if ($toString.name != TO_STRING) {
	  define(function toString() {
	    return $toString.call(this);
	  });
	}

	},{"./_an-object":21,"./_descriptors":35,"./_fails":41,"./_flags":43,"./_redefine":85,"./es6.regexp.flags":134}],139:[function(require,module,exports){
	var $export = require('./_export');
	var context = require('./_string-context');
	var INCLUDES = 'includes';

	$export($export.P + $export.F * require('./_fails-is-regexp')(INCLUDES), 'String', {
	  includes: function includes(searchString /* , position = 0 */) {
	    return !!~context(this, searchString, INCLUDES)
	      .indexOf(searchString, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	},{"./_export":39,"./_fails-is-regexp":40,"./_string-context":94}],140:[function(require,module,exports){
	var $at = require('./_string-at')(true);

	// 21.1.3.27 String.prototype[@@iterator]()
	require('./_iter-define')(String, 'String', function (iterated) {
	  this._t = String(iterated); // target
	  this._i = 0;                // next index
	// 21.1.5.2.1 %StringIteratorPrototype%.next()
	}, function () {
	  var O = this._t;
	  var index = this._i;
	  var point;
	  if (index >= O.length) return { value: undefined, done: true };
	  point = $at(O, index);
	  this._i += point.length;
	  return { value: point, done: false };
	});

	},{"./_iter-define":59,"./_string-at":93}],141:[function(require,module,exports){
	// ECMAScript 6 symbols shim
	var global = require('./_global');
	var has = require('./_has');
	var DESCRIPTORS = require('./_descriptors');
	var $export = require('./_export');
	var redefine = require('./_redefine');
	var META = require('./_meta').KEY;
	var $fails = require('./_fails');
	var shared = require('./_shared');
	var setToStringTag = require('./_set-to-string-tag');
	var uid = require('./_uid');
	var wks = require('./_wks');
	var wksExt = require('./_wks-ext');
	var wksDefine = require('./_wks-define');
	var enumKeys = require('./_enum-keys');
	var isArray = require('./_is-array');
	var anObject = require('./_an-object');
	var isObject = require('./_is-object');
	var toIObject = require('./_to-iobject');
	var toPrimitive = require('./_to-primitive');
	var createDesc = require('./_property-desc');
	var _create = require('./_object-create');
	var gOPNExt = require('./_object-gopn-ext');
	var $GOPD = require('./_object-gopd');
	var $DP = require('./_object-dp');
	var $keys = require('./_object-keys');
	var gOPD = $GOPD.f;
	var dP = $DP.f;
	var gOPN = gOPNExt.f;
	var $Symbol = global.Symbol;
	var $JSON = global.JSON;
	var _stringify = $JSON && $JSON.stringify;
	var PROTOTYPE = 'prototype';
	var HIDDEN = wks('_hidden');
	var TO_PRIMITIVE = wks('toPrimitive');
	var isEnum = {}.propertyIsEnumerable;
	var SymbolRegistry = shared('symbol-registry');
	var AllSymbols = shared('symbols');
	var OPSymbols = shared('op-symbols');
	var ObjectProto = Object[PROTOTYPE];
	var USE_NATIVE = typeof $Symbol == 'function';
	var QObject = global.QObject;
	// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
	var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

	// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
	var setSymbolDesc = DESCRIPTORS && $fails(function () {
	  return _create(dP({}, 'a', {
	    get: function () { return dP(this, 'a', { value: 7 }).a; }
	  })).a != 7;
	}) ? function (it, key, D) {
	  var protoDesc = gOPD(ObjectProto, key);
	  if (protoDesc) delete ObjectProto[key];
	  dP(it, key, D);
	  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);
	} : dP;

	var wrap = function (tag) {
	  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
	  sym._k = tag;
	  return sym;
	};

	var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  return it instanceof $Symbol;
	};

	var $defineProperty = function defineProperty(it, key, D) {
	  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
	  anObject(it);
	  key = toPrimitive(key, true);
	  anObject(D);
	  if (has(AllSymbols, key)) {
	    if (!D.enumerable) {
	      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));
	      it[HIDDEN][key] = true;
	    } else {
	      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
	      D = _create(D, { enumerable: createDesc(0, false) });
	    } return setSymbolDesc(it, key, D);
	  } return dP(it, key, D);
	};
	var $defineProperties = function defineProperties(it, P) {
	  anObject(it);
	  var keys = enumKeys(P = toIObject(P));
	  var i = 0;
	  var l = keys.length;
	  var key;
	  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
	  return it;
	};
	var $create = function create(it, P) {
	  return P === undefined ? _create(it) : $defineProperties(_create(it), P);
	};
	var $propertyIsEnumerable = function propertyIsEnumerable(key) {
	  var E = isEnum.call(this, key = toPrimitive(key, true));
	  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;
	  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
	};
	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
	  it = toIObject(it);
	  key = toPrimitive(key, true);
	  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;
	  var D = gOPD(it, key);
	  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
	  return D;
	};
	var $getOwnPropertyNames = function getOwnPropertyNames(it) {
	  var names = gOPN(toIObject(it));
	  var result = [];
	  var i = 0;
	  var key;
	  while (names.length > i) {
	    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
	  } return result;
	};
	var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
	  var IS_OP = it === ObjectProto;
	  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));
	  var result = [];
	  var i = 0;
	  var key;
	  while (names.length > i) {
	    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
	  } return result;
	};

	// 19.4.1.1 Symbol([description])
	if (!USE_NATIVE) {
	  $Symbol = function Symbol() {
	    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
	    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
	    var $set = function (value) {
	      if (this === ObjectProto) $set.call(OPSymbols, value);
	      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDesc(this, tag, createDesc(1, value));
	    };
	    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
	    return wrap(tag);
	  };
	  redefine($Symbol[PROTOTYPE], 'toString', function toString() {
	    return this._k;
	  });

	  $GOPD.f = $getOwnPropertyDescriptor;
	  $DP.f = $defineProperty;
	  require('./_object-gopn').f = gOPNExt.f = $getOwnPropertyNames;
	  require('./_object-pie').f = $propertyIsEnumerable;
	  require('./_object-gops').f = $getOwnPropertySymbols;

	  if (DESCRIPTORS && !require('./_library')) {
	    redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);
	  }

	  wksExt.f = function (name) {
	    return wrap(wks(name));
	  };
	}

	$export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });

	for (var es6Symbols = (
	  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
	  'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
	).split(','), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);

	for (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);

	$export($export.S + $export.F * !USE_NATIVE, 'Symbol', {
	  // 19.4.2.1 Symbol.for(key)
	  'for': function (key) {
	    return has(SymbolRegistry, key += '')
	      ? SymbolRegistry[key]
	      : SymbolRegistry[key] = $Symbol(key);
	  },
	  // 19.4.2.5 Symbol.keyFor(sym)
	  keyFor: function keyFor(sym) {
	    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
	    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
	  },
	  useSetter: function () { setter = true; },
	  useSimple: function () { setter = false; }
	});

	$export($export.S + $export.F * !USE_NATIVE, 'Object', {
	  // 19.1.2.2 Object.create(O [, Properties])
	  create: $create,
	  // 19.1.2.4 Object.defineProperty(O, P, Attributes)
	  defineProperty: $defineProperty,
	  // 19.1.2.3 Object.defineProperties(O, Properties)
	  defineProperties: $defineProperties,
	  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
	  // 19.1.2.7 Object.getOwnPropertyNames(O)
	  getOwnPropertyNames: $getOwnPropertyNames,
	  // 19.1.2.8 Object.getOwnPropertySymbols(O)
	  getOwnPropertySymbols: $getOwnPropertySymbols
	});

	// 24.3.2 JSON.stringify(value [, replacer [, space]])
	$JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {
	  var S = $Symbol();
	  // MS Edge converts symbol values to JSON as {}
	  // WebKit converts symbol values to JSON as null
	  // V8 throws on boxed symbols
	  return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
	})), 'JSON', {
	  stringify: function stringify(it) {
	    var args = [it];
	    var i = 1;
	    var replacer, $replacer;
	    while (arguments.length > i) args.push(arguments[i++]);
	    $replacer = replacer = args[1];
	    if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
	    if (!isArray(replacer)) replacer = function (key, value) {
	      if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
	      if (!isSymbol(value)) return value;
	    };
	    args[1] = replacer;
	    return _stringify.apply($JSON, args);
	  }
	});

	// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
	$Symbol[PROTOTYPE][TO_PRIMITIVE] || require('./_hide')($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
	// 19.4.3.5 Symbol.prototype[@@toStringTag]
	setToStringTag($Symbol, 'Symbol');
	// 20.2.1.9 Math[@@toStringTag]
	setToStringTag(Math, 'Math', true);
	// 24.3.3 JSON[@@toStringTag]
	setToStringTag(global.JSON, 'JSON', true);

	},{"./_an-object":21,"./_descriptors":35,"./_enum-keys":38,"./_export":39,"./_fails":41,"./_global":45,"./_has":46,"./_hide":47,"./_is-array":54,"./_is-object":55,"./_library":63,"./_meta":64,"./_object-create":68,"./_object-dp":69,"./_object-gopd":71,"./_object-gopn":73,"./_object-gopn-ext":72,"./_object-gops":74,"./_object-keys":77,"./_object-pie":78,"./_property-desc":83,"./_redefine":85,"./_set-to-string-tag":88,"./_shared":90,"./_to-iobject":101,"./_to-primitive":104,"./_uid":108,"./_wks":112,"./_wks-define":110,"./_wks-ext":111}],142:[function(require,module,exports){
	require('./_typed-array')('Float32', 4, function (init) {
	  return function Float32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	},{"./_typed-array":105}],143:[function(require,module,exports){
	require('./_typed-array')('Float64', 8, function (init) {
	  return function Float64Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	},{"./_typed-array":105}],144:[function(require,module,exports){
	require('./_typed-array')('Uint8', 1, function (init) {
	  return function Uint8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});

	},{"./_typed-array":105}],145:[function(require,module,exports){
	require('./_typed-array')('Uint8', 1, function (init) {
	  return function Uint8ClampedArray(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	}, true);

	},{"./_typed-array":105}],146:[function(require,module,exports){
	// https://github.com/tc39/Array.prototype.includes
	var $export = require('./_export');
	var $includes = require('./_array-includes')(true);

	$export($export.P, 'Array', {
	  includes: function includes(el /* , fromIndex = 0 */) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	require('./_add-to-unscopables')('includes');

	},{"./_add-to-unscopables":19,"./_array-includes":24,"./_export":39}],147:[function(require,module,exports){
	// https://github.com/tc39/proposal-object-values-entries
	var $export = require('./_export');
	var $entries = require('./_object-to-array')(true);

	$export($export.S, 'Object', {
	  entries: function entries(it) {
	    return $entries(it);
	  }
	});

	},{"./_export":39,"./_object-to-array":80}],148:[function(require,module,exports){
	require('./_wks-define')('asyncIterator');

	},{"./_wks-define":110}],149:[function(require,module,exports){
	var $iterators = require('./es6.array.iterator');
	var getKeys = require('./_object-keys');
	var redefine = require('./_redefine');
	var global = require('./_global');
	var hide = require('./_hide');
	var Iterators = require('./_iterators');
	var wks = require('./_wks');
	var ITERATOR = wks('iterator');
	var TO_STRING_TAG = wks('toStringTag');
	var ArrayValues = Iterators.Array;

	var DOMIterables = {
	  CSSRuleList: true, // TODO: Not spec compliant, should be false.
	  CSSStyleDeclaration: false,
	  CSSValueList: false,
	  ClientRectList: false,
	  DOMRectList: false,
	  DOMStringList: false,
	  DOMTokenList: true,
	  DataTransferItemList: false,
	  FileList: false,
	  HTMLAllCollection: false,
	  HTMLCollection: false,
	  HTMLFormElement: false,
	  HTMLSelectElement: false,
	  MediaList: true, // TODO: Not spec compliant, should be false.
	  MimeTypeArray: false,
	  NamedNodeMap: false,
	  NodeList: true,
	  PaintRequestList: false,
	  Plugin: false,
	  PluginArray: false,
	  SVGLengthList: false,
	  SVGNumberList: false,
	  SVGPathSegList: false,
	  SVGPointList: false,
	  SVGStringList: false,
	  SVGTransformList: false,
	  SourceBufferList: false,
	  StyleSheetList: true, // TODO: Not spec compliant, should be false.
	  TextTrackCueList: false,
	  TextTrackList: false,
	  TouchList: false
	};

	for (var collections = getKeys(DOMIterables), i = 0; i < collections.length; i++) {
	  var NAME = collections[i];
	  var explicit = DOMIterables[NAME];
	  var Collection = global[NAME];
	  var proto = Collection && Collection.prototype;
	  var key;
	  if (proto) {
	    if (!proto[ITERATOR]) hide(proto, ITERATOR, ArrayValues);
	    if (!proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
	    Iterators[NAME] = ArrayValues;
	    if (explicit) for (key in $iterators) if (!proto[key]) redefine(proto, key, $iterators[key], true);
	  }
	}

	},{"./_global":45,"./_hide":47,"./_iterators":62,"./_object-keys":77,"./_redefine":85,"./_wks":112,"./es6.array.iterator":122}],150:[function(require,module,exports){
	(function (Buffer){
	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.

	function isArray(arg) {
	  if (Array.isArray) {
	    return Array.isArray(arg);
	  }
	  return objectToString(arg) === '[object Array]';
	}
	exports.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;

	function isRegExp(re) {
	  return objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;

	function isDate(d) {
	  return objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;

	function isError(e) {
	  return (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;

	exports.isBuffer = Buffer.isBuffer;

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}

	}).call(this,{"isBuffer":require("../../is-buffer/index.js")});
	},{"../../is-buffer/index.js":167}],151:[function(require,module,exports){
	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var objectCreate = Object.create || objectCreatePolyfill;
	var objectKeys = Object.keys || objectKeysPolyfill;
	var bind = Function.prototype.bind || functionBindPolyfill;

	function EventEmitter() {
	  if (!this._events || !Object.prototype.hasOwnProperty.call(this, '_events')) {
	    this._events = objectCreate(null);
	    this._eventsCount = 0;
	  }

	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	var defaultMaxListeners = 10;

	var hasDefineProperty;
	try {
	  var o = {};
	  if (Object.defineProperty) Object.defineProperty(o, 'x', { value: 0 });
	  hasDefineProperty = o.x === 0;
	} catch (err) { hasDefineProperty = false; }
	if (hasDefineProperty) {
	  Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
	    enumerable: true,
	    get: function() {
	      return defaultMaxListeners;
	    },
	    set: function(arg) {
	      // check whether the input is a positive number (whose value is zero or
	      // greater and not a NaN).
	      if (typeof arg !== 'number' || arg < 0 || arg !== arg)
	        throw new TypeError('"defaultMaxListeners" must be a positive number');
	      defaultMaxListeners = arg;
	    }
	  });
	} else {
	  EventEmitter.defaultMaxListeners = defaultMaxListeners;
	}

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
	  if (typeof n !== 'number' || n < 0 || isNaN(n))
	    throw new TypeError('"n" argument must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	function $getMaxListeners(that) {
	  if (that._maxListeners === undefined)
	    return EventEmitter.defaultMaxListeners;
	  return that._maxListeners;
	}

	EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
	  return $getMaxListeners(this);
	};

	// These standalone emit* functions are used to optimize calling of event
	// handlers for fast cases because emit() itself often has a variable number of
	// arguments and can be deoptimized because of that. These functions always have
	// the same number of arguments and thus do not get deoptimized, so the code
	// inside them can execute faster.
	function emitNone(handler, isFn, self) {
	  if (isFn)
	    handler.call(self);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self);
	  }
	}
	function emitOne(handler, isFn, self, arg1) {
	  if (isFn)
	    handler.call(self, arg1);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1);
	  }
	}
	function emitTwo(handler, isFn, self, arg1, arg2) {
	  if (isFn)
	    handler.call(self, arg1, arg2);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1, arg2);
	  }
	}
	function emitThree(handler, isFn, self, arg1, arg2, arg3) {
	  if (isFn)
	    handler.call(self, arg1, arg2, arg3);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].call(self, arg1, arg2, arg3);
	  }
	}

	function emitMany(handler, isFn, self, args) {
	  if (isFn)
	    handler.apply(self, args);
	  else {
	    var len = handler.length;
	    var listeners = arrayClone(handler, len);
	    for (var i = 0; i < len; ++i)
	      listeners[i].apply(self, args);
	  }
	}

	EventEmitter.prototype.emit = function emit(type) {
	  var er, handler, len, args, i, events;
	  var doError = (type === 'error');

	  events = this._events;
	  if (events)
	    doError = (doError && events.error == null);
	  else if (!doError)
	    return false;

	  // If there is no 'error' event listener then throw.
	  if (doError) {
	    if (arguments.length > 1)
	      er = arguments[1];
	    if (er instanceof Error) {
	      throw er; // Unhandled 'error' event
	    } else {
	      // At least give some kind of context to the user
	      var err = new Error('Unhandled "error" event. (' + er + ')');
	      err.context = er;
	      throw err;
	    }
	  }

	  handler = events[type];

	  if (!handler)
	    return false;

	  var isFn = typeof handler === 'function';
	  len = arguments.length;
	  switch (len) {
	      // fast cases
	    case 1:
	      emitNone(handler, isFn, this);
	      break;
	    case 2:
	      emitOne(handler, isFn, this, arguments[1]);
	      break;
	    case 3:
	      emitTwo(handler, isFn, this, arguments[1], arguments[2]);
	      break;
	    case 4:
	      emitThree(handler, isFn, this, arguments[1], arguments[2], arguments[3]);
	      break;
	      // slower
	    default:
	      args = new Array(len - 1);
	      for (i = 1; i < len; i++)
	        args[i - 1] = arguments[i];
	      emitMany(handler, isFn, this, args);
	  }

	  return true;
	};

	function _addListener(target, type, listener, prepend) {
	  var m;
	  var events;
	  var existing;

	  if (typeof listener !== 'function')
	    throw new TypeError('"listener" argument must be a function');

	  events = target._events;
	  if (!events) {
	    events = target._events = objectCreate(null);
	    target._eventsCount = 0;
	  } else {
	    // To avoid recursion in the case that type === "newListener"! Before
	    // adding it to the listeners, first emit "newListener".
	    if (events.newListener) {
	      target.emit('newListener', type,
	          listener.listener ? listener.listener : listener);

	      // Re-assign `events` because a newListener handler could have caused the
	      // this._events to be assigned to a new object
	      events = target._events;
	    }
	    existing = events[type];
	  }

	  if (!existing) {
	    // Optimize the case of one listener. Don't need the extra array object.
	    existing = events[type] = listener;
	    ++target._eventsCount;
	  } else {
	    if (typeof existing === 'function') {
	      // Adding the second element, need to change to array.
	      existing = events[type] =
	          prepend ? [listener, existing] : [existing, listener];
	    } else {
	      // If we've already got an array, just append.
	      if (prepend) {
	        existing.unshift(listener);
	      } else {
	        existing.push(listener);
	      }
	    }

	    // Check for listener leak
	    if (!existing.warned) {
	      m = $getMaxListeners(target);
	      if (m && m > 0 && existing.length > m) {
	        existing.warned = true;
	        var w = new Error('Possible EventEmitter memory leak detected. ' +
	            existing.length + ' "' + String(type) + '" listeners ' +
	            'added. Use emitter.setMaxListeners() to ' +
	            'increase limit.');
	        w.name = 'MaxListenersExceededWarning';
	        w.emitter = target;
	        w.type = type;
	        w.count = existing.length;
	        if (typeof console === 'object' && console.warn) {
	          console.warn('%s: %s', w.name, w.message);
	        }
	      }
	    }
	  }

	  return target;
	}

	EventEmitter.prototype.addListener = function addListener(type, listener) {
	  return _addListener(this, type, listener, false);
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.prependListener =
	    function prependListener(type, listener) {
	      return _addListener(this, type, listener, true);
	    };

	function onceWrapper() {
	  if (!this.fired) {
	    this.target.removeListener(this.type, this.wrapFn);
	    this.fired = true;
	    switch (arguments.length) {
	      case 0:
	        return this.listener.call(this.target);
	      case 1:
	        return this.listener.call(this.target, arguments[0]);
	      case 2:
	        return this.listener.call(this.target, arguments[0], arguments[1]);
	      case 3:
	        return this.listener.call(this.target, arguments[0], arguments[1],
	            arguments[2]);
	      default:
	        var args = new Array(arguments.length);
	        for (var i = 0; i < args.length; ++i)
	          args[i] = arguments[i];
	        this.listener.apply(this.target, args);
	    }
	  }
	}

	function _onceWrap(target, type, listener) {
	  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
	  var wrapped = bind.call(onceWrapper, state);
	  wrapped.listener = listener;
	  state.wrapFn = wrapped;
	  return wrapped;
	}

	EventEmitter.prototype.once = function once(type, listener) {
	  if (typeof listener !== 'function')
	    throw new TypeError('"listener" argument must be a function');
	  this.on(type, _onceWrap(this, type, listener));
	  return this;
	};

	EventEmitter.prototype.prependOnceListener =
	    function prependOnceListener(type, listener) {
	      if (typeof listener !== 'function')
	        throw new TypeError('"listener" argument must be a function');
	      this.prependListener(type, _onceWrap(this, type, listener));
	      return this;
	    };

	// Emits a 'removeListener' event if and only if the listener was removed.
	EventEmitter.prototype.removeListener =
	    function removeListener(type, listener) {
	      var list, events, position, i, originalListener;

	      if (typeof listener !== 'function')
	        throw new TypeError('"listener" argument must be a function');

	      events = this._events;
	      if (!events)
	        return this;

	      list = events[type];
	      if (!list)
	        return this;

	      if (list === listener || list.listener === listener) {
	        if (--this._eventsCount === 0)
	          this._events = objectCreate(null);
	        else {
	          delete events[type];
	          if (events.removeListener)
	            this.emit('removeListener', type, list.listener || listener);
	        }
	      } else if (typeof list !== 'function') {
	        position = -1;

	        for (i = list.length - 1; i >= 0; i--) {
	          if (list[i] === listener || list[i].listener === listener) {
	            originalListener = list[i].listener;
	            position = i;
	            break;
	          }
	        }

	        if (position < 0)
	          return this;

	        if (position === 0)
	          list.shift();
	        else
	          spliceOne(list, position);

	        if (list.length === 1)
	          events[type] = list[0];

	        if (events.removeListener)
	          this.emit('removeListener', type, originalListener || listener);
	      }

	      return this;
	    };

	EventEmitter.prototype.removeAllListeners =
	    function removeAllListeners(type) {
	      var listeners, events, i;

	      events = this._events;
	      if (!events)
	        return this;

	      // not listening for removeListener, no need to emit
	      if (!events.removeListener) {
	        if (arguments.length === 0) {
	          this._events = objectCreate(null);
	          this._eventsCount = 0;
	        } else if (events[type]) {
	          if (--this._eventsCount === 0)
	            this._events = objectCreate(null);
	          else
	            delete events[type];
	        }
	        return this;
	      }

	      // emit removeListener for all listeners on all events
	      if (arguments.length === 0) {
	        var keys = objectKeys(events);
	        var key;
	        for (i = 0; i < keys.length; ++i) {
	          key = keys[i];
	          if (key === 'removeListener') continue;
	          this.removeAllListeners(key);
	        }
	        this.removeAllListeners('removeListener');
	        this._events = objectCreate(null);
	        this._eventsCount = 0;
	        return this;
	      }

	      listeners = events[type];

	      if (typeof listeners === 'function') {
	        this.removeListener(type, listeners);
	      } else if (listeners) {
	        // LIFO order
	        for (i = listeners.length - 1; i >= 0; i--) {
	          this.removeListener(type, listeners[i]);
	        }
	      }

	      return this;
	    };

	function _listeners(target, type, unwrap) {
	  var events = target._events;

	  if (!events)
	    return [];

	  var evlistener = events[type];
	  if (!evlistener)
	    return [];

	  if (typeof evlistener === 'function')
	    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

	  return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
	}

	EventEmitter.prototype.listeners = function listeners(type) {
	  return _listeners(this, type, true);
	};

	EventEmitter.prototype.rawListeners = function rawListeners(type) {
	  return _listeners(this, type, false);
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  if (typeof emitter.listenerCount === 'function') {
	    return emitter.listenerCount(type);
	  } else {
	    return listenerCount.call(emitter, type);
	  }
	};

	EventEmitter.prototype.listenerCount = listenerCount;
	function listenerCount(type) {
	  var events = this._events;

	  if (events) {
	    var evlistener = events[type];

	    if (typeof evlistener === 'function') {
	      return 1;
	    } else if (evlistener) {
	      return evlistener.length;
	    }
	  }

	  return 0;
	}

	EventEmitter.prototype.eventNames = function eventNames() {
	  return this._eventsCount > 0 ? Reflect.ownKeys(this._events) : [];
	};

	// About 1.5x faster than the two-arg version of Array#splice().
	function spliceOne(list, index) {
	  for (var i = index, k = i + 1, n = list.length; k < n; i += 1, k += 1)
	    list[i] = list[k];
	  list.pop();
	}

	function arrayClone(arr, n) {
	  var copy = new Array(n);
	  for (var i = 0; i < n; ++i)
	    copy[i] = arr[i];
	  return copy;
	}

	function unwrapListeners(arr) {
	  var ret = new Array(arr.length);
	  for (var i = 0; i < ret.length; ++i) {
	    ret[i] = arr[i].listener || arr[i];
	  }
	  return ret;
	}

	function objectCreatePolyfill(proto) {
	  var F = function() {};
	  F.prototype = proto;
	  return new F;
	}
	function objectKeysPolyfill(obj) {
	  for (var k in obj) if (Object.prototype.hasOwnProperty.call(obj, k)) ;
	  return k;
	}
	function functionBindPolyfill(context) {
	  var fn = this;
	  return function () {
	    return fn.apply(context, arguments);
	  };
	}

	},{}],152:[function(require,module,exports){
	var Parser = require('./lib/parser');

	function getGlobal() {
		return (0, eval)('this');
	}

	module.exports = {
		create: function(buffer, global) {
			global = global || getGlobal();
			if(buffer instanceof global.ArrayBuffer) {
				var DOMBufferStream = require('./lib/dom-bufferstream');
				return new Parser(new DOMBufferStream(buffer, 0, buffer.byteLength, true, global));
			} else {
				var NodeBufferStream = require('./lib/bufferstream');
				return new Parser(new NodeBufferStream(buffer, 0, buffer.length, true));
			}
		}
	};

	},{"./lib/bufferstream":153,"./lib/dom-bufferstream":155,"./lib/parser":159}],153:[function(require,module,exports){
	function BufferStream(buffer, offset, length, bigEndian) {
		this.buffer = buffer;
		this.offset = offset || 0;
		length = typeof length === 'number' ? length : buffer.length;
		this.endPosition = this.offset + length;
		this.setBigEndian(bigEndian);
	}

	BufferStream.prototype = {
		setBigEndian: function(bigEndian) {
			this.bigEndian = !!bigEndian;
		},
		nextUInt8: function() {
			var value = this.buffer.readUInt8(this.offset);
			this.offset += 1;
			return value;
		},
		nextInt8: function() {
			var value = this.buffer.readInt8(this.offset);
			this.offset += 1;
			return value;
		},
		nextUInt16: function() {
			var value = this.bigEndian ? this.buffer.readUInt16BE(this.offset) : this.buffer.readUInt16LE(this.offset);
			this.offset += 2;
			return value;
		},
		nextUInt32: function() {
			var value = this.bigEndian ? this.buffer.readUInt32BE(this.offset) : this.buffer.readUInt32LE(this.offset);
			this.offset += 4;
			return value;
		},
		nextInt16: function() {
			var value = this.bigEndian ? this.buffer.readInt16BE(this.offset) : this.buffer.readInt16LE(this.offset);
			this.offset += 2;
			return value;
		},
		nextInt32: function() {
			var value = this.bigEndian ? this.buffer.readInt32BE(this.offset) : this.buffer.readInt32LE(this.offset);
			this.offset += 4;
			return value;
		},
		nextFloat: function() {
			var value = this.bigEndian ? this.buffer.readFloatBE(this.offset) : this.buffer.readFloatLE(this.offset);
			this.offset += 4;
			return value;
		},
		nextDouble: function() {
			var value = this.bigEndian ? this.buffer.readDoubleBE(this.offset) : this.buffer.readDoubleLE(this.offset);
			this.offset += 8;
			return value;
		},
		nextBuffer: function(length) {
			var value = this.buffer.slice(this.offset, this.offset + length);
			this.offset += length;
			return value;
		},
		remainingLength: function() {
			return this.endPosition - this.offset;
		},
		nextString: function(length) {
			var value = this.buffer.toString('utf8', this.offset, this.offset + length);
			this.offset += length;
			return value;
		},
		mark: function() {
			var self = this;
			return {
				openWithOffset: function(offset) {
					offset = (offset || 0) + this.offset;
					return new BufferStream(self.buffer, offset, self.endPosition - offset, self.bigEndian);
				},
				offset: this.offset
			};
		},
		offsetFrom: function(marker) {
			return this.offset - marker.offset;
		},
		skip: function(amount) {
			this.offset += amount;
		},
		branch: function(offset, length) {
			length = typeof length === 'number' ? length : this.endPosition - (this.offset + offset);
			return new BufferStream(this.buffer, this.offset + offset, length, this.bigEndian);
		}
	};

	module.exports = BufferStream;

	},{}],154:[function(require,module,exports){
	function parseNumber(s) {
		return parseInt(s, 10);
	}

	//in seconds
	var hours = 3600;
	var minutes = 60;

	//take date (year, month, day) and time (hour, minutes, seconds) digits in UTC
	//and return a timestamp in seconds
	function parseDateTimeParts(dateParts, timeParts) {
		dateParts = dateParts.map(parseNumber);
		timeParts = timeParts.map(parseNumber);
		var year = dateParts[0];
		var month = dateParts[1] - 1;
		var day = dateParts[2];
		var hours = timeParts[0];
		var minutes = timeParts[1];
		var seconds = timeParts[2];
		var date = Date.UTC(year, month, day, hours, minutes, seconds, 0);
		var timestamp = date / 1000;
		return timestamp;
	}

	//parse date with "2004-09-04T23:39:06-08:00" format,
	//one of the formats supported by ISO 8601, and
	//convert to utc timestamp in seconds
	function parseDateWithTimezoneFormat(dateTimeStr) {

		var dateParts = dateTimeStr.substr(0, 10).split('-');
		var timeParts = dateTimeStr.substr(11, 8).split(':');
		var timezoneStr = dateTimeStr.substr(19, 6);
		var timezoneParts = timezoneStr.split(':').map(parseNumber);
		var timezoneOffset = (timezoneParts[0] * hours) +
			(timezoneParts[1] * minutes);

		var timestamp = parseDateTimeParts(dateParts, timeParts);
		//minus because the timezoneOffset describes
		//how much the described time is ahead of UTC
		timestamp -= timezoneOffset;

		if(typeof timestamp === 'number' && !isNaN(timestamp)) {
			return timestamp;
		}
	}

	//parse date with "YYYY:MM:DD hh:mm:ss" format, convert to utc timestamp in seconds
	function parseDateWithSpecFormat(dateTimeStr) {
		var parts = dateTimeStr.split(' '),
			dateParts = parts[0].split(':'),
			timeParts = parts[1].split(':');

		var timestamp = parseDateTimeParts(dateParts, timeParts);

		if(typeof timestamp === 'number' && !isNaN(timestamp)) {
			return timestamp;
		}
	}

	function parseExifDate(dateTimeStr) {
		//some easy checks to determine two common date formats

		//is the date in the standard "YYYY:MM:DD hh:mm:ss" format?
		var isSpecFormat = dateTimeStr.length === 19 &&
			dateTimeStr.charAt(4) === ':';
		//is the date in the non-standard format,
		//"2004-09-04T23:39:06-08:00" to include a timezone?
		var isTimezoneFormat = dateTimeStr.length === 25 &&
			dateTimeStr.charAt(10) === 'T';

		if(isTimezoneFormat) {
			return parseDateWithTimezoneFormat(dateTimeStr);
		}
		else if(isSpecFormat) {
			return parseDateWithSpecFormat(dateTimeStr);
		}
	}

	module.exports = {
		parseDateWithSpecFormat: parseDateWithSpecFormat,
		parseDateWithTimezoneFormat: parseDateWithTimezoneFormat,
		parseExifDate: parseExifDate
	};

	},{}],155:[function(require,module,exports){
	/*jslint browser: true, devel: true, bitwise: false, debug: true, eqeq: false, es5: true, evil: false, forin: false, newcap: false, nomen: true, plusplus: true, regexp: false, unparam: false, sloppy: true, stupid: false, sub: false, todo: true, vars: true, white: true */

	function DOMBufferStream(arrayBuffer, offset, length, bigEndian, global, parentOffset) {
		this.global = global;
		offset = offset || 0;
		length = length || (arrayBuffer.byteLength - offset);
		this.arrayBuffer = arrayBuffer.slice(offset, offset + length);
		this.view = new global.DataView(this.arrayBuffer, 0, this.arrayBuffer.byteLength);
		this.setBigEndian(bigEndian);
		this.offset = 0;
		this.parentOffset = (parentOffset || 0) + offset;
	}

	DOMBufferStream.prototype = {
		setBigEndian: function(bigEndian) {
			this.littleEndian = !bigEndian;
		},
		nextUInt8: function() {
			var value = this.view.getUint8(this.offset);
			this.offset += 1;
			return value;
		},
		nextInt8: function() {
			var value = this.view.getInt8(this.offset);
			this.offset += 1;
			return value;
		},
		nextUInt16: function() {
			var value = this.view.getUint16(this.offset, this.littleEndian);
			this.offset += 2;
			return value;
		},
		nextUInt32: function() {
			var value = this.view.getUint32(this.offset, this.littleEndian);
			this.offset += 4;
			return value;
		},
		nextInt16: function() {
			var value = this.view.getInt16(this.offset, this.littleEndian);
			this.offset += 2;
			return value;
		},
		nextInt32: function() {
			var value = this.view.getInt32(this.offset, this.littleEndian);
			this.offset += 4;
			return value;
		},
		nextFloat: function() {
			var value = this.view.getFloat32(this.offset, this.littleEndian);
			this.offset += 4;
			return value;
		},
		nextDouble: function() {
			var value = this.view.getFloat64(this.offset, this.littleEndian);
			this.offset += 8;
			return value;
		},
		nextBuffer: function(length) {
			//this won't work in IE10
			var value = this.arrayBuffer.slice(this.offset, this.offset + length);
			this.offset += length;
			return value;
		},
		remainingLength: function() {
			return this.arrayBuffer.byteLength - this.offset;
		},
		nextString: function(length) {
			var value = this.arrayBuffer.slice(this.offset, this.offset + length);
			value = String.fromCharCode.apply(null, new this.global.Uint8Array(value));
			this.offset += length;
			return value;
		},
		mark: function() {
			var self = this;
			return {
				openWithOffset: function(offset) {
					offset = (offset || 0) + this.offset;
					return new DOMBufferStream(self.arrayBuffer, offset, self.arrayBuffer.byteLength - offset, !self.littleEndian, self.global, self.parentOffset);
				},
				offset: this.offset,
				getParentOffset: function() {
					return self.parentOffset;
				}
			};
		},
		offsetFrom: function(marker) {
			return this.parentOffset + this.offset - (marker.offset + marker.getParentOffset());
		},
		skip: function(amount) {
			this.offset += amount;
		},
		branch: function(offset, length) {
			length = typeof length === 'number' ? length : this.arrayBuffer.byteLength - (this.offset + offset);
			return new DOMBufferStream(this.arrayBuffer, this.offset + offset, length, !this.littleEndian, this.global, this.parentOffset);
		}
	};

	module.exports = DOMBufferStream;

	},{}],156:[function(require,module,exports){
	module.exports = {
		exif : {
			0x0001 : "InteropIndex",
			0x0002 : "InteropVersion",
			0x000B : "ProcessingSoftware",
			0x00FE : "SubfileType",
			0x00FF : "OldSubfileType",
			0x0100 : "ImageWidth",
			0x0101 : "ImageHeight",
			0x0102 : "BitsPerSample",
			0x0103 : "Compression",
			0x0106 : "PhotometricInterpretation",
			0x0107 : "Thresholding",
			0x0108 : "CellWidth",
			0x0109 : "CellLength",
			0x010A : "FillOrder",
			0x010D : "DocumentName",
			0x010E : "ImageDescription",
			0x010F : "Make",
			0x0110 : "Model",
			0x0111 : "StripOffsets",
			0x0112 : "Orientation",
			0x0115 : "SamplesPerPixel",
			0x0116 : "RowsPerStrip",
			0x0117 : "StripByteCounts",
			0x0118 : "MinSampleValue",
			0x0119 : "MaxSampleValue",
			0x011A : "XResolution",
			0x011B : "YResolution",
			0x011C : "PlanarConfiguration",
			0x011D : "PageName",
			0x011E : "XPosition",
			0x011F : "YPosition",
			0x0120 : "FreeOffsets",
			0x0121 : "FreeByteCounts",
			0x0122 : "GrayResponseUnit",
			0x0123 : "GrayResponseCurve",
			0x0124 : "T4Options",
			0x0125 : "T6Options",
			0x0128 : "ResolutionUnit",
			0x0129 : "PageNumber",
			0x012C : "ColorResponseUnit",
			0x012D : "TransferFunction",
			0x0131 : "Software",
			0x0132 : "ModifyDate",
			0x013B : "Artist",
			0x013C : "HostComputer",
			0x013D : "Predictor",
			0x013E : "WhitePoint",
			0x013F : "PrimaryChromaticities",
			0x0140 : "ColorMap",
			0x0141 : "HalftoneHints",
			0x0142 : "TileWidth",
			0x0143 : "TileLength",
			0x0144 : "TileOffsets",
			0x0145 : "TileByteCounts",
			0x0146 : "BadFaxLines",
			0x0147 : "CleanFaxData",
			0x0148 : "ConsecutiveBadFaxLines",
			0x014A : "SubIFD",
			0x014C : "InkSet",
			0x014D : "InkNames",
			0x014E : "NumberofInks",
			0x0150 : "DotRange",
			0x0151 : "TargetPrinter",
			0x0152 : "ExtraSamples",
			0x0153 : "SampleFormat",
			0x0154 : "SMinSampleValue",
			0x0155 : "SMaxSampleValue",
			0x0156 : "TransferRange",
			0x0157 : "ClipPath",
			0x0158 : "XClipPathUnits",
			0x0159 : "YClipPathUnits",
			0x015A : "Indexed",
			0x015B : "JPEGTables",
			0x015F : "OPIProxy",
			0x0190 : "GlobalParametersIFD",
			0x0191 : "ProfileType",
			0x0192 : "FaxProfile",
			0x0193 : "CodingMethods",
			0x0194 : "VersionYear",
			0x0195 : "ModeNumber",
			0x01B1 : "Decode",
			0x01B2 : "DefaultImageColor",
			0x01B3 : "T82Options",
			0x01B5 : "JPEGTables",
			0x0200 : "JPEGProc",
			0x0201 : "ThumbnailOffset",
			0x0202 : "ThumbnailLength",
			0x0203 : "JPEGRestartInterval",
			0x0205 : "JPEGLosslessPredictors",
			0x0206 : "JPEGPointTransforms",
			0x0207 : "JPEGQTables",
			0x0208 : "JPEGDCTables",
			0x0209 : "JPEGACTables",
			0x0211 : "YCbCrCoefficients",
			0x0212 : "YCbCrSubSampling",
			0x0213 : "YCbCrPositioning",
			0x0214 : "ReferenceBlackWhite",
			0x022F : "StripRowCounts",
			0x02BC : "ApplicationNotes",
			0x03E7 : "USPTOMiscellaneous",
			0x1000 : "RelatedImageFileFormat",
			0x1001 : "RelatedImageWidth",
			0x1002 : "RelatedImageHeight",
			0x4746 : "Rating",
			0x4747 : "XP_DIP_XML",
			0x4748 : "StitchInfo",
			0x4749 : "RatingPercent",
			0x800D : "ImageID",
			0x80A3 : "WangTag1",
			0x80A4 : "WangAnnotation",
			0x80A5 : "WangTag3",
			0x80A6 : "WangTag4",
			0x80E3 : "Matteing",
			0x80E4 : "DataType",
			0x80E5 : "ImageDepth",
			0x80E6 : "TileDepth",
			0x827D : "Model2",
			0x828D : "CFARepeatPatternDim",
			0x828E : "CFAPattern2",
			0x828F : "BatteryLevel",
			0x8290 : "KodakIFD",
			0x8298 : "Copyright",
			0x829A : "ExposureTime",
			0x829D : "FNumber",
			0x82A5 : "MDFileTag",
			0x82A6 : "MDScalePixel",
			0x82A7 : "MDColorTable",
			0x82A8 : "MDLabName",
			0x82A9 : "MDSampleInfo",
			0x82AA : "MDPrepDate",
			0x82AB : "MDPrepTime",
			0x82AC : "MDFileUnits",
			0x830E : "PixelScale",
			0x8335 : "AdventScale",
			0x8336 : "AdventRevision",
			0x835C : "UIC1Tag",
			0x835D : "UIC2Tag",
			0x835E : "UIC3Tag",
			0x835F : "UIC4Tag",
			0x83BB : "IPTC-NAA",
			0x847E : "IntergraphPacketData",
			0x847F : "IntergraphFlagRegisters",
			0x8480 : "IntergraphMatrix",
			0x8481 : "INGRReserved",
			0x8482 : "ModelTiePoint",
			0x84E0 : "Site",
			0x84E1 : "ColorSequence",
			0x84E2 : "IT8Header",
			0x84E3 : "RasterPadding",
			0x84E4 : "BitsPerRunLength",
			0x84E5 : "BitsPerExtendedRunLength",
			0x84E6 : "ColorTable",
			0x84E7 : "ImageColorIndicator",
			0x84E8 : "BackgroundColorIndicator",
			0x84E9 : "ImageColorValue",
			0x84EA : "BackgroundColorValue",
			0x84EB : "PixelIntensityRange",
			0x84EC : "TransparencyIndicator",
			0x84ED : "ColorCharacterization",
			0x84EE : "HCUsage",
			0x84EF : "TrapIndicator",
			0x84F0 : "CMYKEquivalent",
			0x8546 : "SEMInfo",
			0x8568 : "AFCP_IPTC",
			0x85B8 : "PixelMagicJBIGOptions",
			0x85D8 : "ModelTransform",
			0x8602 : "WB_GRGBLevels",
			0x8606 : "LeafData",
			0x8649 : "PhotoshopSettings",
			0x8769 : "ExifOffset",
			0x8773 : "ICC_Profile",
			0x877F : "TIFF_FXExtensions",
			0x8780 : "MultiProfiles",
			0x8781 : "SharedData",
			0x8782 : "T88Options",
			0x87AC : "ImageLayer",
			0x87AF : "GeoTiffDirectory",
			0x87B0 : "GeoTiffDoubleParams",
			0x87B1 : "GeoTiffAsciiParams",
			0x8822 : "ExposureProgram",
			0x8824 : "SpectralSensitivity",
			0x8825 : "GPSInfo",
			0x8827 : "ISO",
			0x8828 : "Opto-ElectricConvFactor",
			0x8829 : "Interlace",
			0x882A : "TimeZoneOffset",
			0x882B : "SelfTimerMode",
			0x8830 : "SensitivityType",
			0x8831 : "StandardOutputSensitivity",
			0x8832 : "RecommendedExposureIndex",
			0x8833 : "ISOSpeed",
			0x8834 : "ISOSpeedLatitudeyyy",
			0x8835 : "ISOSpeedLatitudezzz",
			0x885C : "FaxRecvParams",
			0x885D : "FaxSubAddress",
			0x885E : "FaxRecvTime",
			0x888A : "LeafSubIFD",
			0x9000 : "ExifVersion",
			0x9003 : "DateTimeOriginal",
			0x9004 : "CreateDate",
			0x9101 : "ComponentsConfiguration",
			0x9102 : "CompressedBitsPerPixel",
			0x9201 : "ShutterSpeedValue",
			0x9202 : "ApertureValue",
			0x9203 : "BrightnessValue",
			0x9204 : "ExposureCompensation",
			0x9205 : "MaxApertureValue",
			0x9206 : "SubjectDistance",
			0x9207 : "MeteringMode",
			0x9208 : "LightSource",
			0x9209 : "Flash",
			0x920A : "FocalLength",
			0x920B : "FlashEnergy",
			0x920C : "SpatialFrequencyResponse",
			0x920D : "Noise",
			0x920E : "FocalPlaneXResolution",
			0x920F : "FocalPlaneYResolution",
			0x9210 : "FocalPlaneResolutionUnit",
			0x9211 : "ImageNumber",
			0x9212 : "SecurityClassification",
			0x9213 : "ImageHistory",
			0x9214 : "SubjectArea",
			0x9215 : "ExposureIndex",
			0x9216 : "TIFF-EPStandardID",
			0x9217 : "SensingMethod",
			0x923A : "CIP3DataFile",
			0x923B : "CIP3Sheet",
			0x923C : "CIP3Side",
			0x923F : "StoNits",
			0x927C : "MakerNote",
			0x9286 : "UserComment",
			0x9290 : "SubSecTime",
			0x9291 : "SubSecTimeOriginal",
			0x9292 : "SubSecTimeDigitized",
			0x932F : "MSDocumentText",
			0x9330 : "MSPropertySetStorage",
			0x9331 : "MSDocumentTextPosition",
			0x935C : "ImageSourceData",
			0x9C9B : "XPTitle",
			0x9C9C : "XPComment",
			0x9C9D : "XPAuthor",
			0x9C9E : "XPKeywords",
			0x9C9F : "XPSubject",
			0xA000 : "FlashpixVersion",
			0xA001 : "ColorSpace",
			0xA002 : "ExifImageWidth",
			0xA003 : "ExifImageHeight",
			0xA004 : "RelatedSoundFile",
			0xA005 : "InteropOffset",
			0xA20B : "FlashEnergy",
			0xA20C : "SpatialFrequencyResponse",
			0xA20D : "Noise",
			0xA20E : "FocalPlaneXResolution",
			0xA20F : "FocalPlaneYResolution",
			0xA210 : "FocalPlaneResolutionUnit",
			0xA211 : "ImageNumber",
			0xA212 : "SecurityClassification",
			0xA213 : "ImageHistory",
			0xA214 : "SubjectLocation",
			0xA215 : "ExposureIndex",
			0xA216 : "TIFF-EPStandardID",
			0xA217 : "SensingMethod",
			0xA300 : "FileSource",
			0xA301 : "SceneType",
			0xA302 : "CFAPattern",
			0xA401 : "CustomRendered",
			0xA402 : "ExposureMode",
			0xA403 : "WhiteBalance",
			0xA404 : "DigitalZoomRatio",
			0xA405 : "FocalLengthIn35mmFormat",
			0xA406 : "SceneCaptureType",
			0xA407 : "GainControl",
			0xA408 : "Contrast",
			0xA409 : "Saturation",
			0xA40A : "Sharpness",
			0xA40B : "DeviceSettingDescription",
			0xA40C : "SubjectDistanceRange",
			0xA420 : "ImageUniqueID",
			0xA430 : "OwnerName",
			0xA431 : "SerialNumber",
			0xA432 : "LensInfo",
			0xA433 : "LensMake",
			0xA434 : "LensModel",
			0xA435 : "LensSerialNumber",
			0xA480 : "GDALMetadata",
			0xA481 : "GDALNoData",
			0xA500 : "Gamma",
			0xAFC0 : "ExpandSoftware",
			0xAFC1 : "ExpandLens",
			0xAFC2 : "ExpandFilm",
			0xAFC3 : "ExpandFilterLens",
			0xAFC4 : "ExpandScanner",
			0xAFC5 : "ExpandFlashLamp",
			0xBC01 : "PixelFormat",
			0xBC02 : "Transformation",
			0xBC03 : "Uncompressed",
			0xBC04 : "ImageType",
			0xBC80 : "ImageWidth",
			0xBC81 : "ImageHeight",
			0xBC82 : "WidthResolution",
			0xBC83 : "HeightResolution",
			0xBCC0 : "ImageOffset",
			0xBCC1 : "ImageByteCount",
			0xBCC2 : "AlphaOffset",
			0xBCC3 : "AlphaByteCount",
			0xBCC4 : "ImageDataDiscard",
			0xBCC5 : "AlphaDataDiscard",
			0xC427 : "OceScanjobDesc",
			0xC428 : "OceApplicationSelector",
			0xC429 : "OceIDNumber",
			0xC42A : "OceImageLogic",
			0xC44F : "Annotations",
			0xC4A5 : "PrintIM",
			0xC580 : "USPTOOriginalContentType",
			0xC612 : "DNGVersion",
			0xC613 : "DNGBackwardVersion",
			0xC614 : "UniqueCameraModel",
			0xC615 : "LocalizedCameraModel",
			0xC616 : "CFAPlaneColor",
			0xC617 : "CFALayout",
			0xC618 : "LinearizationTable",
			0xC619 : "BlackLevelRepeatDim",
			0xC61A : "BlackLevel",
			0xC61B : "BlackLevelDeltaH",
			0xC61C : "BlackLevelDeltaV",
			0xC61D : "WhiteLevel",
			0xC61E : "DefaultScale",
			0xC61F : "DefaultCropOrigin",
			0xC620 : "DefaultCropSize",
			0xC621 : "ColorMatrix1",
			0xC622 : "ColorMatrix2",
			0xC623 : "CameraCalibration1",
			0xC624 : "CameraCalibration2",
			0xC625 : "ReductionMatrix1",
			0xC626 : "ReductionMatrix2",
			0xC627 : "AnalogBalance",
			0xC628 : "AsShotNeutral",
			0xC629 : "AsShotWhiteXY",
			0xC62A : "BaselineExposure",
			0xC62B : "BaselineNoise",
			0xC62C : "BaselineSharpness",
			0xC62D : "BayerGreenSplit",
			0xC62E : "LinearResponseLimit",
			0xC62F : "CameraSerialNumber",
			0xC630 : "DNGLensInfo",
			0xC631 : "ChromaBlurRadius",
			0xC632 : "AntiAliasStrength",
			0xC633 : "ShadowScale",
			0xC634 : "DNGPrivateData",
			0xC635 : "MakerNoteSafety",
			0xC640 : "RawImageSegmentation",
			0xC65A : "CalibrationIlluminant1",
			0xC65B : "CalibrationIlluminant2",
			0xC65C : "BestQualityScale",
			0xC65D : "RawDataUniqueID",
			0xC660 : "AliasLayerMetadata",
			0xC68B : "OriginalRawFileName",
			0xC68C : "OriginalRawFileData",
			0xC68D : "ActiveArea",
			0xC68E : "MaskedAreas",
			0xC68F : "AsShotICCProfile",
			0xC690 : "AsShotPreProfileMatrix",
			0xC691 : "CurrentICCProfile",
			0xC692 : "CurrentPreProfileMatrix",
			0xC6BF : "ColorimetricReference",
			0xC6D2 : "PanasonicTitle",
			0xC6D3 : "PanasonicTitle2",
			0xC6F3 : "CameraCalibrationSig",
			0xC6F4 : "ProfileCalibrationSig",
			0xC6F5 : "ProfileIFD",
			0xC6F6 : "AsShotProfileName",
			0xC6F7 : "NoiseReductionApplied",
			0xC6F8 : "ProfileName",
			0xC6F9 : "ProfileHueSatMapDims",
			0xC6FA : "ProfileHueSatMapData1",
			0xC6FB : "ProfileHueSatMapData2",
			0xC6FC : "ProfileToneCurve",
			0xC6FD : "ProfileEmbedPolicy",
			0xC6FE : "ProfileCopyright",
			0xC714 : "ForwardMatrix1",
			0xC715 : "ForwardMatrix2",
			0xC716 : "PreviewApplicationName",
			0xC717 : "PreviewApplicationVersion",
			0xC718 : "PreviewSettingsName",
			0xC719 : "PreviewSettingsDigest",
			0xC71A : "PreviewColorSpace",
			0xC71B : "PreviewDateTime",
			0xC71C : "RawImageDigest",
			0xC71D : "OriginalRawFileDigest",
			0xC71E : "SubTileBlockSize",
			0xC71F : "RowInterleaveFactor",
			0xC725 : "ProfileLookTableDims",
			0xC726 : "ProfileLookTableData",
			0xC740 : "OpcodeList1",
			0xC741 : "OpcodeList2",
			0xC74E : "OpcodeList3",
			0xC761 : "NoiseProfile",
			0xC763 : "TimeCodes",
			0xC764 : "FrameRate",
			0xC772 : "TStop",
			0xC789 : "ReelName",
			0xC791 : "OriginalDefaultFinalSize",
			0xC792 : "OriginalBestQualitySize",
			0xC793 : "OriginalDefaultCropSize",
			0xC7A1 : "CameraLabel",
			0xC7A3 : "ProfileHueSatMapEncoding",
			0xC7A4 : "ProfileLookTableEncoding",
			0xC7A5 : "BaselineExposureOffset",
			0xC7A6 : "DefaultBlackRender",
			0xC7A7 : "NewRawImageDigest",
			0xC7A8 : "RawToPreviewGain",
			0xC7B5 : "DefaultUserCrop",
			0xEA1C : "Padding",
			0xEA1D : "OffsetSchema",
			0xFDE8 : "OwnerName",
			0xFDE9 : "SerialNumber",
			0xFDEA : "Lens",
			0xFE00 : "KDC_IFD",
			0xFE4C : "RawFile",
			0xFE4D : "Converter",
			0xFE4E : "WhiteBalance",
			0xFE51 : "Exposure",
			0xFE52 : "Shadows",
			0xFE53 : "Brightness",
			0xFE54 : "Contrast",
			0xFE55 : "Saturation",
			0xFE56 : "Sharpness",
			0xFE57 : "Smoothness",
			0xFE58 : "MoireFilter"
			
		},
		gps : {	
			0x0000 : 'GPSVersionID',
			0x0001 : 'GPSLatitudeRef',
			0x0002 : 'GPSLatitude',
			0x0003 : 'GPSLongitudeRef',
			0x0004 : 'GPSLongitude',
			0x0005 : 'GPSAltitudeRef',
			0x0006 : 'GPSAltitude',
			0x0007 : 'GPSTimeStamp',
			0x0008 : 'GPSSatellites',
			0x0009 : 'GPSStatus',
			0x000A : 'GPSMeasureMode',
			0x000B : 'GPSDOP',
			0x000C : 'GPSSpeedRef',
			0x000D : 'GPSSpeed',
			0x000E : 'GPSTrackRef',
			0x000F : 'GPSTrack',
			0x0010 : 'GPSImgDirectionRef',
			0x0011 : 'GPSImgDirection',
			0x0012 : 'GPSMapDatum',
			0x0013 : 'GPSDestLatitudeRef',
			0x0014 : 'GPSDestLatitude',
			0x0015 : 'GPSDestLongitudeRef',
			0x0016 : 'GPSDestLongitude',
			0x0017 : 'GPSDestBearingRef',
			0x0018 : 'GPSDestBearing',
			0x0019 : 'GPSDestDistanceRef',
			0x001A : 'GPSDestDistance',
			0x001B : 'GPSProcessingMethod',
			0x001C : 'GPSAreaInformation',
			0x001D : 'GPSDateStamp',
			0x001E : 'GPSDifferential',
			0x001F : 'GPSHPositioningError'
		}
	};
	},{}],157:[function(require,module,exports){
	/*jslint browser: true, devel: true, bitwise: false, debug: true, eqeq: false, es5: true, evil: false, forin: false, newcap: false, nomen: true, plusplus: true, regexp: false, unparam: false, sloppy: true, stupid: false, sub: false, todo: true, vars: true, white: true */

	function readExifValue(format, stream) {
		switch(format) {
			case 1: return stream.nextUInt8();
			case 3: return stream.nextUInt16();
			case 4: return stream.nextUInt32();
			case 5: return [stream.nextUInt32(), stream.nextUInt32()];
			case 6: return stream.nextInt8();
			case 8: return stream.nextUInt16();
			case 9: return stream.nextUInt32();
			case 10: return [stream.nextInt32(), stream.nextInt32()];
			case 11: return stream.nextFloat();
			case 12: return stream.nextDouble();
			default: throw new Error('Invalid format while decoding: ' + format);
		}
	}

	function getBytesPerComponent(format) {
		switch(format) {
			case 1:
			case 2:
			case 6:
			case 7:
				return 1;
			case 3:
			case 8:
				return 2;
			case 4:
			case 9:
			case 11:
				return 4;
			case 5:
			case 10:
			case 12:
				return 8;
			default:
				return 0;
		}
	}

	function readExifTag(tiffMarker, stream) {
		var tagType = stream.nextUInt16(),
			format = stream.nextUInt16(),
			bytesPerComponent = getBytesPerComponent(format),
			components = stream.nextUInt32(),
			valueBytes = bytesPerComponent * components,
			values,
			c;

		/* if the value is bigger then 4 bytes, the value is in the data section of the IFD
		and the value present in the tag is the offset starting from the tiff header. So we replace the stream
		with a stream that is located at the given offset in the data section. s*/
		if(valueBytes > 4) {
			stream = tiffMarker.openWithOffset(stream.nextUInt32());
		}
		//we don't want to read strings as arrays
		if(format === 2) {
			values = stream.nextString(components);
			//cut off \0 characters
			var lastNull = values.indexOf('\0');
			if(lastNull !== -1) {
				values = values.substr(0, lastNull);
			}
		}
		else if(format === 7) {
			values = stream.nextBuffer(components);
		}
		else if(format !== 0) {
			values = [];
			for(c = 0; c < components; ++c) {
				values.push(readExifValue(format, stream));
			}
		}
		//since our stream is a stateful object, we need to skip remaining bytes
		//so our offset stays correct
		if(valueBytes < 4) {
			stream.skip(4 - valueBytes);
		}

		return [tagType, values, format];
	}

	function readIFDSection(tiffMarker, stream, iterator) {
		var numberOfEntries = stream.nextUInt16(), tag, i;
		for(i = 0; i < numberOfEntries; ++i) {
			tag = readExifTag(tiffMarker, stream);
			iterator(tag[0], tag[1], tag[2]);
		}
	}

	function readHeader(stream) {
		var exifHeader = stream.nextString(6);
		if(exifHeader !== 'Exif\0\0') {
			throw new Error('Invalid EXIF header');
		}

		var tiffMarker = stream.mark();
		var tiffHeader = stream.nextUInt16();
		if(tiffHeader === 0x4949) {
			stream.setBigEndian(false);
		} else if(tiffHeader === 0x4D4D) {
			stream.setBigEndian(true);
		} else {
			throw new Error('Invalid TIFF header');
		}
		if(stream.nextUInt16() !== 0x002A) {
			throw new Error('Invalid TIFF data');
		}
		return tiffMarker;
	}

	module.exports = {
		IFD0: 1,
		IFD1: 2,
		GPSIFD: 3,
		SubIFD: 4,
		InteropIFD: 5,
		parseTags: function(stream, iterator) {
			var tiffMarker;
			try {
				tiffMarker = readHeader(stream);
			} catch(e) {
				return false;	//ignore APP1 sections with invalid headers
			}
			var subIfdOffset, gpsOffset, interopOffset;
			var ifd0Stream = tiffMarker.openWithOffset(stream.nextUInt32()),
				IFD0 = this.IFD0;
			readIFDSection(tiffMarker, ifd0Stream, function(tagType, value, format) {
				switch(tagType) {
					case 0x8825: gpsOffset = value[0]; break;
					case 0x8769: subIfdOffset = value[0]; break;
					default: iterator(IFD0, tagType, value, format); break;
				}
			});
			var ifd1Offset = ifd0Stream.nextUInt32();
			if(ifd1Offset !== 0) {
				var ifd1Stream = tiffMarker.openWithOffset(ifd1Offset);
				readIFDSection(tiffMarker, ifd1Stream, iterator.bind(null, this.IFD1));
			}

			if(gpsOffset) {
				var gpsStream = tiffMarker.openWithOffset(gpsOffset);
				readIFDSection(tiffMarker, gpsStream, iterator.bind(null, this.GPSIFD));
			}

			if(subIfdOffset) {
				var subIfdStream = tiffMarker.openWithOffset(subIfdOffset), InteropIFD = this.InteropIFD;
				readIFDSection(tiffMarker, subIfdStream, function(tagType, value, format) {
					if(tagType === 0xA005) {
						interopOffset = value[0];
					} else {
						iterator(InteropIFD, tagType, value, format);
					}
				});
			}

			if(interopOffset) {
				var interopStream = tiffMarker.openWithOffset(interopOffset);
				readIFDSection(tiffMarker, interopStream, iterator.bind(null, this.InteropIFD));
			}
			return true;
		}
	};
	},{}],158:[function(require,module,exports){
	/*jslint browser: true, devel: true, bitwise: false, debug: true, eqeq: false, es5: true, evil: false, forin: false, newcap: false, nomen: true, plusplus: true, regexp: false, unparam: false, sloppy: true, stupid: false, sub: false, todo: true, vars: true, white: true */

	module.exports = {
		parseSections: function(stream, iterator) {
			var len, markerType;
			stream.setBigEndian(true);
			//stop reading the stream at the SOS (Start of Stream) marker,
			//because its length is not stored in the header so we can't
			//know where to jump to. The only marker after that is just EOI (End Of Image) anyway
			while(stream.remainingLength() > 0 && markerType !== 0xDA) {
				if(stream.nextUInt8() !== 0xFF) {
					throw new Error('Invalid JPEG section offset');
				}
				markerType = stream.nextUInt8();
				//don't read size from markers that have no datas
				if((markerType >= 0xD0 && markerType <= 0xD9) || markerType === 0xDA) {
					len = 0;
				} else {
					len = stream.nextUInt16() - 2;
				}
				iterator(markerType, stream.branch(0, len));
				stream.skip(len);
			}
		},
		//stream should be located after SOF section size and in big endian mode, like passed to parseSections iterator
		getSizeFromSOFSection: function(stream) {
			stream.skip(1);
			return {
				height: stream.nextUInt16(),
				width: stream.nextUInt16()
			};
		},
		getSectionName: function(markerType) {
			var name, index;
			switch(markerType) {
				case 0xD8: name = 'SOI'; break;
				case 0xC4: name = 'DHT'; break;
				case 0xDB: name = 'DQT'; break;
				case 0xDD: name = 'DRI'; break;
				case 0xDA: name = 'SOS'; break;
				case 0xFE: name = 'COM'; break;
				case 0xD9: name = 'EOI'; break;
				default:
					if(markerType >= 0xE0 && markerType <= 0xEF) {
						name = 'APP';
						index = markerType - 0xE0;
					}
					else if(markerType >= 0xC0 && markerType <= 0xCF && markerType !== 0xC4 && markerType !== 0xC8 && markerType !== 0xCC) {
						name = 'SOF';
						index = markerType - 0xC0;
					}
					else if(markerType >= 0xD0 && markerType <= 0xD7) {
						name = 'RST';
						index = markerType - 0xD0;
					}
					break;
			}
			var nameStruct = {
				name: name
			};
			if(typeof index === 'number') {
				nameStruct.index = index;
			}
			return nameStruct;
		}
	};
	},{}],159:[function(require,module,exports){
	/*jslint browser: true, devel: true, bitwise: false, debug: true, eqeq: false, es5: true, evil: false, forin: false, newcap: false, nomen: true, plusplus: true, regexp: false, unparam: false, sloppy: true, stupid: false, sub: false, todo: true, vars: true, white: true */

	var jpeg = require('./jpeg'),
		exif = require('./exif'),
		simplify = require('./simplify');

	function ExifResult(startMarker, tags, imageSize, thumbnailOffset, thumbnailLength, thumbnailType, app1Offset) {
		this.startMarker = startMarker;
		this.tags = tags;
		this.imageSize = imageSize;
		this.thumbnailOffset = thumbnailOffset;
		this.thumbnailLength = thumbnailLength;
		this.thumbnailType = thumbnailType;
		this.app1Offset = app1Offset;
	}

	ExifResult.prototype = {
		hasThumbnail: function(mime) {
			if(!this.thumbnailOffset || !this.thumbnailLength) {
				return false;
			}
			if(typeof mime !== 'string') {
				return true;
			}
			if(mime.toLowerCase().trim() === 'image/jpeg') {
				return this.thumbnailType === 6;
			}
			if(mime.toLowerCase().trim() === 'image/tiff') {
				return this.thumbnailType === 1;
			}
			return false;
		},
		getThumbnailOffset: function() {
			return this.app1Offset + 6 + this.thumbnailOffset;
		},
		getThumbnailLength: function() {
			return this.thumbnailLength;
		},
		getThumbnailBuffer: function() {
			return this._getThumbnailStream().nextBuffer(this.thumbnailLength);
		},
		_getThumbnailStream: function() {
			return this.startMarker.openWithOffset(this.getThumbnailOffset());
		},
		getImageSize: function() {
			return this.imageSize;
		},
		getThumbnailSize: function() {
			var stream = this._getThumbnailStream(), size;
			jpeg.parseSections(stream, function(sectionType, sectionStream) {
				if(jpeg.getSectionName(sectionType).name === 'SOF') {
					size = jpeg.getSizeFromSOFSection(sectionStream);
				}
			});
			return size;
		}
	};

	function Parser(stream) {
		this.stream = stream;
		this.flags = {
			readBinaryTags: false,
			resolveTagNames: true,
			simplifyValues: true,
			imageSize: true,
			hidePointers: true,
			returnTags: true
		};
	}

	Parser.prototype = {
		enableBinaryFields: function(enable) {
			this.flags.readBinaryTags = !!enable;
			return this;
		},
		enablePointers: function(enable) {
			this.flags.hidePointers = !enable;
			return this;
		},
		enableTagNames: function(enable) {
			this.flags.resolveTagNames = !!enable;
			return this;
		},
		enableImageSize: function(enable) {
			this.flags.imageSize = !!enable;
			return this;
		},
		enableReturnTags: function(enable) {
			this.flags.returnTags = !!enable;
			return this;
		},
		enableSimpleValues: function(enable) {
			this.flags.simplifyValues = !!enable;
			return this;
		},
		parse: function() {
			var start = this.stream.mark(),
				stream = start.openWithOffset(0),
				flags = this.flags,
				tags,
				imageSize,
				thumbnailOffset,
				thumbnailLength,
				thumbnailType,
				app1Offset,
				tagNames,
				getTagValue, setTagValue;
			if(flags.resolveTagNames) {
				tagNames = require('./exif-tags');
			}
			if(flags.resolveTagNames) {
				tags = {};
				getTagValue = function(t) {
					return tags[t.name];
				};
				setTagValue = function(t, value) {
					tags[t.name] = value;
				};
			} else {
				tags = [];
				getTagValue = function(t) {
					var i;
					for(i = 0; i < tags.length; ++i) {
						if(tags[i].type === t.type && tags[i].section === t.section) {
							return tags.value;
						}
					}
				};
				setTagValue = function(t, value) {
					var i;
					for(i = 0; i < tags.length; ++i) {
						if(tags[i].type === t.type && tags[i].section === t.section) {
							tags.value = value;
							return;
						}
					}
				};
			}

			jpeg.parseSections(stream, function(sectionType, sectionStream) {
				var validExifHeaders, sectionOffset = sectionStream.offsetFrom(start);
				if(sectionType === 0xE1) {
					validExifHeaders = exif.parseTags(sectionStream, function(ifdSection, tagType, value, format) {
						//ignore binary fields if disabled
						if(!flags.readBinaryTags && format === 7) {
							return;
						}

						if(tagType === 0x0201) {
							thumbnailOffset = value[0];
							if(flags.hidePointers) {return;}
						} else if(tagType === 0x0202) {
							thumbnailLength = value[0];
							if(flags.hidePointers) {return;}
						} else if(tagType === 0x0103) {
							thumbnailType = value[0];
							if(flags.hidePointers) {return;}
						}
						//if flag is set to not store tags, return here after storing pointers
						if(!flags.returnTags) {
							return;
						}

						if(flags.simplifyValues) {
							value = simplify.simplifyValue(value, format);
						}
						if(flags.resolveTagNames) {
							var sectionTagNames = ifdSection === exif.GPSIFD ? tagNames.gps : tagNames.exif;
							var name = sectionTagNames[tagType];
							if(!name) {
								name = tagNames.exif[tagType];
							}
							if (!tags.hasOwnProperty(name)) {
								tags[name] = value;
							}
						} else {
							tags.push({
								section: ifdSection,
								type: tagType,
								value: value
							});
						}
					});
					if(validExifHeaders) {
						app1Offset = sectionOffset;
					}
				}
				else if(flags.imageSize && jpeg.getSectionName(sectionType).name === 'SOF') {
					imageSize = jpeg.getSizeFromSOFSection(sectionStream);
				}
			});

			if(flags.simplifyValues) {
				simplify.castDegreeValues(getTagValue, setTagValue);
				simplify.castDateValues(getTagValue, setTagValue);
			}

			return new ExifResult(start, tags, imageSize, thumbnailOffset, thumbnailLength, thumbnailType, app1Offset);
		}
	};



	module.exports = Parser;

	},{"./exif":157,"./exif-tags":156,"./jpeg":158,"./simplify":160}],160:[function(require,module,exports){
	var exif = require('./exif');
	var date = require('./date');

	var degreeTags = [{
		section: exif.GPSIFD,
		type: 0x0002,
		name: 'GPSLatitude',
		refType: 0x0001,
		refName: 'GPSLatitudeRef',
		posVal: 'N'
	},
	{
		section: exif.GPSIFD,
		type: 0x0004,
		name: 'GPSLongitude',
		refType: 0x0003,
		refName: 'GPSLongitudeRef',
		posVal: 'E'
	}];
	var dateTags = [{
		section: exif.SubIFD,
		type: 0x0132,
		name: 'ModifyDate'
	},
	{
		section: exif.SubIFD,
		type: 0x9003,
		name: 'DateTimeOriginal'
	},
	{
		section: exif.SubIFD,
		type: 0x9004,
		name: 'CreateDate'
	},
	{
		section: exif.SubIFD,
		type: 0x0132,
		name : 'ModifyDate',
	}];

	module.exports = {
		castDegreeValues: function(getTagValue, setTagValue) {
			degreeTags.forEach(function(t) {
				var degreeVal = getTagValue(t);
				if(degreeVal) {
					var degreeRef = getTagValue({section: t.section, type: t.refType, name: t.refName});
					var degreeNumRef = degreeRef === t.posVal ? 1 : -1;
					var degree = (degreeVal[0] + (degreeVal[1] / 60) + (degreeVal[2] / 3600)) * degreeNumRef;
					setTagValue(t, degree);
				}
			});
		},
		castDateValues: function(getTagValue, setTagValue) {
			dateTags.forEach(function(t) {
				var dateStrVal = getTagValue(t);
				if(dateStrVal) {
					//some easy checks to determine two common date formats
					var timestamp = date.parseExifDate(dateStrVal);
					if(typeof timestamp !== 'undefined') {
						setTagValue(t, timestamp);
					}
				}
			});
		},
		simplifyValue: function(values, format) {
			if(Array.isArray(values)) {
				values = values.map(function(value) {
					if(format === 10 || format === 5) {
						return value[0] / value[1];
					}
					return value;
				});
				if(values.length === 1) {
					values = values[0];
				}
			}
			return values;
		}
	};

	},{"./date":154,"./exif":157}],161:[function(require,module,exports){

	function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

	function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

	function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

	function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

	var toBytes = function toBytes(s) {
	  return _toConsumableArray(s).map(function (c) {
	    return c.charCodeAt(0);
	  });
	};

	var xpiZipFilename = toBytes('META-INF/mozilla.rsa');
	var oxmlContentTypes = toBytes('[Content_Types].xml');
	var oxmlRels = toBytes('_rels/.rels');

	module.exports = function (input) {
	  var buf = input instanceof Uint8Array ? input : new Uint8Array(input);

	  if (!(buf && buf.length > 1)) {
	    return null;
	  }

	  var check = function check(header, options) {
	    options = Object.assign({
	      offset: 0
	    }, options);

	    for (var i = 0; i < header.length; i++) {
	      // If a bitmask is set
	      if (options.mask) {
	        // If header doesn't equal `buf` with bits masked off
	        if (header[i] !== (options.mask[i] & buf[i + options.offset])) {
	          return false;
	        }
	      } else if (header[i] !== buf[i + options.offset]) {
	        return false;
	      }
	    }

	    return true;
	  };

	  var checkString = function checkString(header, options) {
	    return check(toBytes(header), options);
	  };

	  if (check([0xFF, 0xD8, 0xFF])) {
	    return {
	      ext: 'jpg',
	      mime: 'image/jpeg'
	    };
	  }

	  if (check([0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A])) {
	    return {
	      ext: 'png',
	      mime: 'image/png'
	    };
	  }

	  if (check([0x47, 0x49, 0x46])) {
	    return {
	      ext: 'gif',
	      mime: 'image/gif'
	    };
	  }

	  if (check([0x57, 0x45, 0x42, 0x50], {
	    offset: 8
	  })) {
	    return {
	      ext: 'webp',
	      mime: 'image/webp'
	    };
	  }

	  if (check([0x46, 0x4C, 0x49, 0x46])) {
	    return {
	      ext: 'flif',
	      mime: 'image/flif'
	    };
	  } // Needs to be before `tif` check


	  if ((check([0x49, 0x49, 0x2A, 0x0]) || check([0x4D, 0x4D, 0x0, 0x2A])) && check([0x43, 0x52], {
	    offset: 8
	  })) {
	    return {
	      ext: 'cr2',
	      mime: 'image/x-canon-cr2'
	    };
	  }

	  if (check([0x49, 0x49, 0x2A, 0x0]) || check([0x4D, 0x4D, 0x0, 0x2A])) {
	    return {
	      ext: 'tif',
	      mime: 'image/tiff'
	    };
	  }

	  if (check([0x42, 0x4D])) {
	    return {
	      ext: 'bmp',
	      mime: 'image/bmp'
	    };
	  }

	  if (check([0x49, 0x49, 0xBC])) {
	    return {
	      ext: 'jxr',
	      mime: 'image/vnd.ms-photo'
	    };
	  }

	  if (check([0x38, 0x42, 0x50, 0x53])) {
	    return {
	      ext: 'psd',
	      mime: 'image/vnd.adobe.photoshop'
	    };
	  } // Zip-based file formats
	  // Need to be before the `zip` check


	  if (check([0x50, 0x4B, 0x3, 0x4])) {
	    if (check([0x6D, 0x69, 0x6D, 0x65, 0x74, 0x79, 0x70, 0x65, 0x61, 0x70, 0x70, 0x6C, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x2F, 0x65, 0x70, 0x75, 0x62, 0x2B, 0x7A, 0x69, 0x70], {
	      offset: 30
	    })) {
	      return {
	        ext: 'epub',
	        mime: 'application/epub+zip'
	      };
	    } // Assumes signed `.xpi` from addons.mozilla.org


	    if (check(xpiZipFilename, {
	      offset: 30
	    })) {
	      return {
	        ext: 'xpi',
	        mime: 'application/x-xpinstall'
	      };
	    }

	    if (checkString('mimetypeapplication/vnd.oasis.opendocument.text', {
	      offset: 30
	    })) {
	      return {
	        ext: 'odt',
	        mime: 'application/vnd.oasis.opendocument.text'
	      };
	    }

	    if (checkString('mimetypeapplication/vnd.oasis.opendocument.spreadsheet', {
	      offset: 30
	    })) {
	      return {
	        ext: 'ods',
	        mime: 'application/vnd.oasis.opendocument.spreadsheet'
	      };
	    }

	    if (checkString('mimetypeapplication/vnd.oasis.opendocument.presentation', {
	      offset: 30
	    })) {
	      return {
	        ext: 'odp',
	        mime: 'application/vnd.oasis.opendocument.presentation'
	      };
	    } // The docx, xlsx and pptx file types extend the Office Open XML file format:
	    // https://en.wikipedia.org/wiki/Office_Open_XML_file_formats
	    // We look for:
	    // - one entry named '[Content_Types].xml' or '_rels/.rels',
	    // - one entry indicating specific type of file.
	    // MS Office, OpenOffice and LibreOffice may put the parts in different order, so the check should not rely on it.


	    var findNextZipHeaderIndex = function findNextZipHeaderIndex(arr) {
	      var startAt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	      return arr.findIndex(function (el, i, arr) {
	        return i >= startAt && arr[i] === 0x50 && arr[i + 1] === 0x4B && arr[i + 2] === 0x3 && arr[i + 3] === 0x4;
	      });
	    };

	    var zipHeaderIndex = 0; // The first zip header was already found at index 0

	    var oxmlFound = false;
	    var type = null;

	    do {
	      var offset = zipHeaderIndex + 30;

	      if (!oxmlFound) {
	        oxmlFound = check(oxmlContentTypes, {
	          offset: offset
	        }) || check(oxmlRels, {
	          offset: offset
	        });
	      }

	      if (!type) {
	        if (checkString('word/', {
	          offset: offset
	        })) {
	          type = {
	            ext: 'docx',
	            mime: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
	          };
	        } else if (checkString('ppt/', {
	          offset: offset
	        })) {
	          type = {
	            ext: 'pptx',
	            mime: 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
	          };
	        } else if (checkString('xl/', {
	          offset: offset
	        })) {
	          type = {
	            ext: 'xlsx',
	            mime: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
	          };
	        }
	      }

	      if (oxmlFound && type) {
	        return type;
	      }

	      zipHeaderIndex = findNextZipHeaderIndex(buf, offset);
	    } while (zipHeaderIndex >= 0); // No more zip parts available in the buffer, but maybe we are almost certain about the type?


	    if (type) {
	      return type;
	    }
	  }

	  if (check([0x50, 0x4B]) && (buf[2] === 0x3 || buf[2] === 0x5 || buf[2] === 0x7) && (buf[3] === 0x4 || buf[3] === 0x6 || buf[3] === 0x8)) {
	    return {
	      ext: 'zip',
	      mime: 'application/zip'
	    };
	  }

	  if (check([0x75, 0x73, 0x74, 0x61, 0x72], {
	    offset: 257
	  })) {
	    return {
	      ext: 'tar',
	      mime: 'application/x-tar'
	    };
	  }

	  if (check([0x52, 0x61, 0x72, 0x21, 0x1A, 0x7]) && (buf[6] === 0x0 || buf[6] === 0x1)) {
	    return {
	      ext: 'rar',
	      mime: 'application/x-rar-compressed'
	    };
	  }

	  if (check([0x1F, 0x8B, 0x8])) {
	    return {
	      ext: 'gz',
	      mime: 'application/gzip'
	    };
	  }

	  if (check([0x42, 0x5A, 0x68])) {
	    return {
	      ext: 'bz2',
	      mime: 'application/x-bzip2'
	    };
	  }

	  if (check([0x37, 0x7A, 0xBC, 0xAF, 0x27, 0x1C])) {
	    return {
	      ext: '7z',
	      mime: 'application/x-7z-compressed'
	    };
	  }

	  if (check([0x78, 0x01])) {
	    return {
	      ext: 'dmg',
	      mime: 'application/x-apple-diskimage'
	    };
	  }

	  if (check([0x33, 0x67, 0x70, 0x35]) || // 3gp5
	  check([0x0, 0x0, 0x0]) && check([0x66, 0x74, 0x79, 0x70], {
	    offset: 4
	  }) && (check([0x6D, 0x70, 0x34, 0x31], {
	    offset: 8
	  }) || // MP41
	  check([0x6D, 0x70, 0x34, 0x32], {
	    offset: 8
	  }) || // MP42
	  check([0x69, 0x73, 0x6F, 0x6D], {
	    offset: 8
	  }) || // ISOM
	  check([0x69, 0x73, 0x6F, 0x32], {
	    offset: 8
	  }) || // ISO2
	  check([0x6D, 0x6D, 0x70, 0x34], {
	    offset: 8
	  }) || // MMP4
	  check([0x4D, 0x34, 0x56], {
	    offset: 8
	  }) || // M4V
	  check([0x64, 0x61, 0x73, 0x68], {
	    offset: 8
	  }) // DASH
	  )) {
	    return {
	      ext: 'mp4',
	      mime: 'video/mp4'
	    };
	  }

	  if (check([0x4D, 0x54, 0x68, 0x64])) {
	    return {
	      ext: 'mid',
	      mime: 'audio/midi'
	    };
	  } // https://github.com/threatstack/libmagic/blob/master/magic/Magdir/matroska


	  if (check([0x1A, 0x45, 0xDF, 0xA3])) {
	    var sliced = buf.subarray(4, 4 + 4096);
	    var idPos = sliced.findIndex(function (el, i, arr) {
	      return arr[i] === 0x42 && arr[i + 1] === 0x82;
	    });

	    if (idPos !== -1) {
	      var docTypePos = idPos + 3;

	      var findDocType = function findDocType(type) {
	        return _toConsumableArray(type).every(function (c, i) {
	          return sliced[docTypePos + i] === c.charCodeAt(0);
	        });
	      };

	      if (findDocType('matroska')) {
	        return {
	          ext: 'mkv',
	          mime: 'video/x-matroska'
	        };
	      }

	      if (findDocType('webm')) {
	        return {
	          ext: 'webm',
	          mime: 'video/webm'
	        };
	      }
	    }
	  }

	  if (check([0x0, 0x0, 0x0, 0x14, 0x66, 0x74, 0x79, 0x70, 0x71, 0x74, 0x20, 0x20]) || check([0x66, 0x72, 0x65, 0x65], {
	    offset: 4
	  }) || check([0x66, 0x74, 0x79, 0x70, 0x71, 0x74, 0x20, 0x20], {
	    offset: 4
	  }) || check([0x6D, 0x64, 0x61, 0x74], {
	    offset: 4
	  }) || // MJPEG
	  check([0x77, 0x69, 0x64, 0x65], {
	    offset: 4
	  })) {
	    return {
	      ext: 'mov',
	      mime: 'video/quicktime'
	    };
	  } // RIFF file format which might be AVI, WAV, QCP, etc


	  if (check([0x52, 0x49, 0x46, 0x46])) {
	    if (check([0x41, 0x56, 0x49], {
	      offset: 8
	    })) {
	      return {
	        ext: 'avi',
	        mime: 'video/vnd.avi'
	      };
	    }

	    if (check([0x57, 0x41, 0x56, 0x45], {
	      offset: 8
	    })) {
	      return {
	        ext: 'wav',
	        mime: 'audio/vnd.wave'
	      };
	    } // QLCM, QCP file


	    if (check([0x51, 0x4C, 0x43, 0x4D], {
	      offset: 8
	    })) {
	      return {
	        ext: 'qcp',
	        mime: 'audio/qcelp'
	      };
	    }
	  }

	  if (check([0x30, 0x26, 0xB2, 0x75, 0x8E, 0x66, 0xCF, 0x11, 0xA6, 0xD9])) {
	    return {
	      ext: 'wmv',
	      mime: 'video/x-ms-wmv'
	    };
	  }

	  if (check([0x0, 0x0, 0x1, 0xBA]) || check([0x0, 0x0, 0x1, 0xB3])) {
	    return {
	      ext: 'mpg',
	      mime: 'video/mpeg'
	    };
	  }

	  if (check([0x66, 0x74, 0x79, 0x70, 0x33, 0x67], {
	    offset: 4
	  })) {
	    return {
	      ext: '3gp',
	      mime: 'video/3gpp'
	    };
	  } // Check for MPEG header at different starting offsets


	  for (var start = 0; start < 2 && start < buf.length - 16; start++) {
	    if (check([0x49, 0x44, 0x33], {
	      offset: start
	    }) || // ID3 header
	    check([0xFF, 0xE2], {
	      offset: start,
	      mask: [0xFF, 0xE2]
	    }) // MPEG 1 or 2 Layer 3 header
	    ) {
	        return {
	          ext: 'mp3',
	          mime: 'audio/mpeg'
	        };
	      }

	    if (check([0xFF, 0xE4], {
	      offset: start,
	      mask: [0xFF, 0xE4]
	    }) // MPEG 1 or 2 Layer 2 header
	    ) {
	        return {
	          ext: 'mp2',
	          mime: 'audio/mpeg'
	        };
	      }

	    if (check([0xFF, 0xF8], {
	      offset: start,
	      mask: [0xFF, 0xFC]
	    }) // MPEG 2 layer 0 using ADTS
	    ) {
	        return {
	          ext: 'mp2',
	          mime: 'audio/mpeg'
	        };
	      }

	    if (check([0xFF, 0xF0], {
	      offset: start,
	      mask: [0xFF, 0xFC]
	    }) // MPEG 4 layer 0 using ADTS
	    ) {
	        return {
	          ext: 'mp4',
	          mime: 'audio/mpeg'
	        };
	      }
	  }

	  if (check([0x66, 0x74, 0x79, 0x70, 0x4D, 0x34, 0x41], {
	    offset: 4
	  }) || check([0x4D, 0x34, 0x41, 0x20])) {
	    return {
	      // MPEG-4 layer 3 (audio)
	      ext: 'm4a',
	      mime: 'audio/mp4' // RFC 4337

	    };
	  } // Needs to be before `ogg` check


	  if (check([0x4F, 0x70, 0x75, 0x73, 0x48, 0x65, 0x61, 0x64], {
	    offset: 28
	  })) {
	    return {
	      ext: 'opus',
	      mime: 'audio/opus'
	    };
	  } // If 'OggS' in first  bytes, then OGG container


	  if (check([0x4F, 0x67, 0x67, 0x53])) {
	    // This is a OGG container
	    // If ' theora' in header.
	    if (check([0x80, 0x74, 0x68, 0x65, 0x6F, 0x72, 0x61], {
	      offset: 28
	    })) {
	      return {
	        ext: 'ogv',
	        mime: 'video/ogg'
	      };
	    } // If '\x01video' in header.


	    if (check([0x01, 0x76, 0x69, 0x64, 0x65, 0x6F, 0x00], {
	      offset: 28
	    })) {
	      return {
	        ext: 'ogm',
	        mime: 'video/ogg'
	      };
	    } // If ' FLAC' in header  https://xiph.org/flac/faq.html


	    if (check([0x7F, 0x46, 0x4C, 0x41, 0x43], {
	      offset: 28
	    })) {
	      return {
	        ext: 'oga',
	        mime: 'audio/ogg'
	      };
	    } // 'Speex  ' in header https://en.wikipedia.org/wiki/Speex


	    if (check([0x53, 0x70, 0x65, 0x65, 0x78, 0x20, 0x20], {
	      offset: 28
	    })) {
	      return {
	        ext: 'spx',
	        mime: 'audio/ogg'
	      };
	    } // If '\x01vorbis' in header


	    if (check([0x01, 0x76, 0x6F, 0x72, 0x62, 0x69, 0x73], {
	      offset: 28
	    })) {
	      return {
	        ext: 'ogg',
	        mime: 'audio/ogg'
	      };
	    } // Default OGG container https://www.iana.org/assignments/media-types/application/ogg


	    return {
	      ext: 'ogx',
	      mime: 'application/ogg'
	    };
	  }

	  if (check([0x66, 0x4C, 0x61, 0x43])) {
	    return {
	      ext: 'flac',
	      mime: 'audio/x-flac'
	    };
	  }

	  if (check([0x4D, 0x41, 0x43, 0x20])) {
	    // 'MAC '
	    return {
	      ext: 'ape',
	      mime: 'audio/ape'
	    };
	  }

	  if (check([0x77, 0x76, 0x70, 0x6B])) {
	    // 'wvpk'
	    return {
	      ext: 'wv',
	      mime: 'audio/wavpack'
	    };
	  }

	  if (check([0x23, 0x21, 0x41, 0x4D, 0x52, 0x0A])) {
	    return {
	      ext: 'amr',
	      mime: 'audio/amr'
	    };
	  }

	  if (check([0x25, 0x50, 0x44, 0x46])) {
	    return {
	      ext: 'pdf',
	      mime: 'application/pdf'
	    };
	  }

	  if (check([0x4D, 0x5A])) {
	    return {
	      ext: 'exe',
	      mime: 'application/x-msdownload'
	    };
	  }

	  if ((buf[0] === 0x43 || buf[0] === 0x46) && check([0x57, 0x53], {
	    offset: 1
	  })) {
	    return {
	      ext: 'swf',
	      mime: 'application/x-shockwave-flash'
	    };
	  }

	  if (check([0x7B, 0x5C, 0x72, 0x74, 0x66])) {
	    return {
	      ext: 'rtf',
	      mime: 'application/rtf'
	    };
	  }

	  if (check([0x00, 0x61, 0x73, 0x6D])) {
	    return {
	      ext: 'wasm',
	      mime: 'application/wasm'
	    };
	  }

	  if (check([0x77, 0x4F, 0x46, 0x46]) && (check([0x00, 0x01, 0x00, 0x00], {
	    offset: 4
	  }) || check([0x4F, 0x54, 0x54, 0x4F], {
	    offset: 4
	  }))) {
	    return {
	      ext: 'woff',
	      mime: 'font/woff'
	    };
	  }

	  if (check([0x77, 0x4F, 0x46, 0x32]) && (check([0x00, 0x01, 0x00, 0x00], {
	    offset: 4
	  }) || check([0x4F, 0x54, 0x54, 0x4F], {
	    offset: 4
	  }))) {
	    return {
	      ext: 'woff2',
	      mime: 'font/woff2'
	    };
	  }

	  if (check([0x4C, 0x50], {
	    offset: 34
	  }) && (check([0x00, 0x00, 0x01], {
	    offset: 8
	  }) || check([0x01, 0x00, 0x02], {
	    offset: 8
	  }) || check([0x02, 0x00, 0x02], {
	    offset: 8
	  }))) {
	    return {
	      ext: 'eot',
	      mime: 'application/vnd.ms-fontobject'
	    };
	  }

	  if (check([0x00, 0x01, 0x00, 0x00, 0x00])) {
	    return {
	      ext: 'ttf',
	      mime: 'font/ttf'
	    };
	  }

	  if (check([0x4F, 0x54, 0x54, 0x4F, 0x00])) {
	    return {
	      ext: 'otf',
	      mime: 'font/otf'
	    };
	  }

	  if (check([0x00, 0x00, 0x01, 0x00])) {
	    return {
	      ext: 'ico',
	      mime: 'image/x-icon'
	    };
	  }

	  if (check([0x00, 0x00, 0x02, 0x00])) {
	    return {
	      ext: 'cur',
	      mime: 'image/x-icon'
	    };
	  }

	  if (check([0x46, 0x4C, 0x56, 0x01])) {
	    return {
	      ext: 'flv',
	      mime: 'video/x-flv'
	    };
	  }

	  if (check([0x25, 0x21])) {
	    return {
	      ext: 'ps',
	      mime: 'application/postscript'
	    };
	  }

	  if (check([0xFD, 0x37, 0x7A, 0x58, 0x5A, 0x00])) {
	    return {
	      ext: 'xz',
	      mime: 'application/x-xz'
	    };
	  }

	  if (check([0x53, 0x51, 0x4C, 0x69])) {
	    return {
	      ext: 'sqlite',
	      mime: 'application/x-sqlite3'
	    };
	  }

	  if (check([0x4E, 0x45, 0x53, 0x1A])) {
	    return {
	      ext: 'nes',
	      mime: 'application/x-nintendo-nes-rom'
	    };
	  }

	  if (check([0x43, 0x72, 0x32, 0x34])) {
	    return {
	      ext: 'crx',
	      mime: 'application/x-google-chrome-extension'
	    };
	  }

	  if (check([0x4D, 0x53, 0x43, 0x46]) || check([0x49, 0x53, 0x63, 0x28])) {
	    return {
	      ext: 'cab',
	      mime: 'application/vnd.ms-cab-compressed'
	    };
	  } // Needs to be before `ar` check


	  if (check([0x21, 0x3C, 0x61, 0x72, 0x63, 0x68, 0x3E, 0x0A, 0x64, 0x65, 0x62, 0x69, 0x61, 0x6E, 0x2D, 0x62, 0x69, 0x6E, 0x61, 0x72, 0x79])) {
	    return {
	      ext: 'deb',
	      mime: 'application/x-deb'
	    };
	  }

	  if (check([0x21, 0x3C, 0x61, 0x72, 0x63, 0x68, 0x3E])) {
	    return {
	      ext: 'ar',
	      mime: 'application/x-unix-archive'
	    };
	  }

	  if (check([0xED, 0xAB, 0xEE, 0xDB])) {
	    return {
	      ext: 'rpm',
	      mime: 'application/x-rpm'
	    };
	  }

	  if (check([0x1F, 0xA0]) || check([0x1F, 0x9D])) {
	    return {
	      ext: 'Z',
	      mime: 'application/x-compress'
	    };
	  }

	  if (check([0x4C, 0x5A, 0x49, 0x50])) {
	    return {
	      ext: 'lz',
	      mime: 'application/x-lzip'
	    };
	  }

	  if (check([0xD0, 0xCF, 0x11, 0xE0, 0xA1, 0xB1, 0x1A, 0xE1])) {
	    return {
	      ext: 'msi',
	      mime: 'application/x-msi'
	    };
	  }

	  if (check([0x06, 0x0E, 0x2B, 0x34, 0x02, 0x05, 0x01, 0x01, 0x0D, 0x01, 0x02, 0x01, 0x01, 0x02])) {
	    return {
	      ext: 'mxf',
	      mime: 'application/mxf'
	    };
	  }

	  if (check([0x47], {
	    offset: 4
	  }) && (check([0x47], {
	    offset: 192
	  }) || check([0x47], {
	    offset: 196
	  }))) {
	    return {
	      ext: 'mts',
	      mime: 'video/mp2t'
	    };
	  }

	  if (check([0x42, 0x4C, 0x45, 0x4E, 0x44, 0x45, 0x52])) {
	    return {
	      ext: 'blend',
	      mime: 'application/x-blender'
	    };
	  }

	  if (check([0x42, 0x50, 0x47, 0xFB])) {
	    return {
	      ext: 'bpg',
	      mime: 'image/bpg'
	    };
	  }

	  if (check([0x00, 0x00, 0x00, 0x0C, 0x6A, 0x50, 0x20, 0x20, 0x0D, 0x0A, 0x87, 0x0A])) {
	    // JPEG-2000 family
	    if (check([0x6A, 0x70, 0x32, 0x20], {
	      offset: 20
	    })) {
	      return {
	        ext: 'jp2',
	        mime: 'image/jp2'
	      };
	    }

	    if (check([0x6A, 0x70, 0x78, 0x20], {
	      offset: 20
	    })) {
	      return {
	        ext: 'jpx',
	        mime: 'image/jpx'
	      };
	    }

	    if (check([0x6A, 0x70, 0x6D, 0x20], {
	      offset: 20
	    })) {
	      return {
	        ext: 'jpm',
	        mime: 'image/jpm'
	      };
	    }

	    if (check([0x6D, 0x6A, 0x70, 0x32], {
	      offset: 20
	    })) {
	      return {
	        ext: 'mj2',
	        mime: 'image/mj2'
	      };
	    }
	  }

	  if (check([0x46, 0x4F, 0x52, 0x4D, 0x00])) {
	    return {
	      ext: 'aif',
	      mime: 'audio/aiff'
	    };
	  }

	  if (checkString('<?xml ')) {
	    return {
	      ext: 'xml',
	      mime: 'application/xml'
	    };
	  }

	  if (check([0x42, 0x4F, 0x4F, 0x4B, 0x4D, 0x4F, 0x42, 0x49], {
	    offset: 60
	  })) {
	    return {
	      ext: 'mobi',
	      mime: 'application/x-mobipocket-ebook'
	    };
	  } // File Type Box (https://en.wikipedia.org/wiki/ISO_base_media_file_format)


	  if (check([0x66, 0x74, 0x79, 0x70], {
	    offset: 4
	  })) {
	    if (check([0x6D, 0x69, 0x66, 0x31], {
	      offset: 8
	    })) {
	      return {
	        ext: 'heic',
	        mime: 'image/heif'
	      };
	    }

	    if (check([0x6D, 0x73, 0x66, 0x31], {
	      offset: 8
	    })) {
	      return {
	        ext: 'heic',
	        mime: 'image/heif-sequence'
	      };
	    }

	    if (check([0x68, 0x65, 0x69, 0x63], {
	      offset: 8
	    }) || check([0x68, 0x65, 0x69, 0x78], {
	      offset: 8
	    })) {
	      return {
	        ext: 'heic',
	        mime: 'image/heic'
	      };
	    }

	    if (check([0x68, 0x65, 0x76, 0x63], {
	      offset: 8
	    }) || check([0x68, 0x65, 0x76, 0x78], {
	      offset: 8
	    })) {
	      return {
	        ext: 'heic',
	        mime: 'image/heic-sequence'
	      };
	    }
	  }

	  if (check([0xAB, 0x4B, 0x54, 0x58, 0x20, 0x31, 0x31, 0xBB, 0x0D, 0x0A, 0x1A, 0x0A])) {
	    return {
	      ext: 'ktx',
	      mime: 'image/ktx'
	    };
	  }

	  return null;
	};

	},{}],162:[function(require,module,exports){

	var isCallable = require('is-callable');

	var toStr = Object.prototype.toString;
	var hasOwnProperty = Object.prototype.hasOwnProperty;

	var forEachArray = function forEachArray(array, iterator, receiver) {
	    for (var i = 0, len = array.length; i < len; i++) {
	        if (hasOwnProperty.call(array, i)) {
	            if (receiver == null) {
	                iterator(array[i], i, array);
	            } else {
	                iterator.call(receiver, array[i], i, array);
	            }
	        }
	    }
	};

	var forEachString = function forEachString(string, iterator, receiver) {
	    for (var i = 0, len = string.length; i < len; i++) {
	        // no such thing as a sparse string.
	        if (receiver == null) {
	            iterator(string.charAt(i), i, string);
	        } else {
	            iterator.call(receiver, string.charAt(i), i, string);
	        }
	    }
	};

	var forEachObject = function forEachObject(object, iterator, receiver) {
	    for (var k in object) {
	        if (hasOwnProperty.call(object, k)) {
	            if (receiver == null) {
	                iterator(object[k], k, object);
	            } else {
	                iterator.call(receiver, object[k], k, object);
	            }
	        }
	    }
	};

	var forEach = function forEach(list, iterator, thisArg) {
	    if (!isCallable(iterator)) {
	        throw new TypeError('iterator must be a function');
	    }

	    var receiver;
	    if (arguments.length >= 3) {
	        receiver = thisArg;
	    }

	    if (toStr.call(list) === '[object Array]') {
	        forEachArray(list, iterator, receiver);
	    } else if (typeof list === 'string') {
	        forEachString(list, iterator, receiver);
	    } else {
	        forEachObject(list, iterator, receiver);
	    }
	};

	module.exports = forEach;

	},{"is-callable":168}],163:[function(require,module,exports){
	(function (global){
	var win;

	if (typeof window !== "undefined") {
	    win = window;
	} else if (typeof global !== "undefined") {
	    win = global;
	} else if (typeof self !== "undefined"){
	    win = self;
	} else {
	    win = {};
	}

	module.exports = win;

	}).call(this,typeof commonjsGlobal !== "undefined" ? commonjsGlobal : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
	},{}],164:[function(require,module,exports){
	var http = require('http');
	var url = require('url');

	var https = module.exports;

	for (var key in http) {
	  if (http.hasOwnProperty(key)) https[key] = http[key];
	}

	https.request = function (params, cb) {
	  params = validateParams(params);
	  return http.request.call(this, params, cb)
	};

	https.get = function (params, cb) {
	  params = validateParams(params);
	  return http.get.call(this, params, cb)
	};

	function validateParams (params) {
	  if (typeof params === 'string') {
	    params = url.parse(params);
	  }
	  if (!params.protocol) {
	    params.protocol = 'https:';
	  }
	  if (params.protocol !== 'https:') {
	    throw new Error('Protocol "' + params.protocol + '" not supported. Expected "https:"')
	  }
	  return params
	}

	},{"http":246,"url":256}],165:[function(require,module,exports){
	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var nBits = -7;
	  var i = isLE ? (nBytes - 1) : 0;
	  var d = isLE ? -1 : 1;
	  var s = buffer[offset + i];

	  i += d;

	  e = s & ((1 << (-nBits)) - 1);
	  s >>= (-nBits);
	  nBits += eLen;
	  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1);
	  e >>= (-nBits);
	  nBits += mLen;
	  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias;
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen);
	    e = e - eBias;
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	};

	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c;
	  var eLen = (nBytes * 8) - mLen - 1;
	  var eMax = (1 << eLen) - 1;
	  var eBias = eMax >> 1;
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
	  var i = isLE ? 0 : (nBytes - 1);
	  var d = isLE ? 1 : -1;
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

	  value = Math.abs(value);

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0;
	    e = eMax;
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2);
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--;
	      c *= 2;
	    }
	    if (e + eBias >= 1) {
	      value += rt / c;
	    } else {
	      value += rt * Math.pow(2, 1 - eBias);
	    }
	    if (value * c >= 2) {
	      e++;
	      c /= 2;
	    }

	    if (e + eBias >= eMax) {
	      m = 0;
	      e = eMax;
	    } else if (e + eBias >= 1) {
	      m = ((value * c) - 1) * Math.pow(2, mLen);
	      e = e + eBias;
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
	      e = 0;
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m;
	  eLen += mLen;
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128;
	};

	},{}],166:[function(require,module,exports){
	arguments[4][4][0].apply(exports,arguments);
	},{"dup":4}],167:[function(require,module,exports){
	/*!
	 * Determine if an object is a Buffer
	 *
	 * @author   Feross Aboukhadijeh <https://feross.org>
	 * @license  MIT
	 */

	// The _isBuffer check is for Safari 5-7 support, because it's missing
	// Object.prototype.constructor. Remove this eventually
	module.exports = function (obj) {
	  return obj != null && (isBuffer(obj) || isSlowBuffer(obj) || !!obj._isBuffer)
	};

	function isBuffer (obj) {
	  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
	}

	// For Node v0.10 support. Remove this eventually.
	function isSlowBuffer (obj) {
	  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isBuffer(obj.slice(0, 0))
	}

	},{}],168:[function(require,module,exports){

	var fnToStr = Function.prototype.toString;

	var constructorRegex = /^\s*class\b/;
	var isES6ClassFn = function isES6ClassFunction(value) {
		try {
			var fnStr = fnToStr.call(value);
			return constructorRegex.test(fnStr);
		} catch (e) {
			return false; // not a function
		}
	};

	var tryFunctionObject = function tryFunctionToStr(value) {
		try {
			if (isES6ClassFn(value)) { return false; }
			fnToStr.call(value);
			return true;
		} catch (e) {
			return false;
		}
	};
	var toStr = Object.prototype.toString;
	var fnClass = '[object Function]';
	var genClass = '[object GeneratorFunction]';
	var hasToStringTag = typeof Symbol === 'function' && typeof Symbol.toStringTag === 'symbol';

	module.exports = function isCallable(value) {
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (typeof value === 'function' && !value.prototype) { return true; }
		if (hasToStringTag) { return tryFunctionObject(value); }
		if (isES6ClassFn(value)) { return false; }
		var strClass = toStr.call(value);
		return strClass === fnClass || strClass === genClass;
	};

	},{}],169:[function(require,module,exports){
	module.exports = isFunction;

	var toString = Object.prototype.toString;

	function isFunction (fn) {
	  var string = toString.call(fn);
	  return string === '[object Function]' ||
	    (typeof fn === 'function' && string !== '[object RegExp]') ||
	    (typeof window !== 'undefined' &&
	     // IE8 and below
	     (fn === window.setTimeout ||
	      fn === window.alert ||
	      fn === window.confirm ||
	      fn === window.prompt))
	}
	},{}],170:[function(require,module,exports){
	var toString = {}.toString;

	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};

	},{}],171:[function(require,module,exports){
	var encode = require('./lib/encoder'),
	    decode = require('./lib/decoder');

	module.exports = {
	  encode: encode,
	  decode: decode
	};

	},{"./lib/decoder":172,"./lib/encoder":173}],172:[function(require,module,exports){
	(function (Buffer){
	/* -*- tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- /
	/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */
	/*
	   Copyright 2011 notmasteryet

	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at

	       http://www.apache.org/licenses/LICENSE-2.0

	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
	*/

	// - The JPEG specification can be found in the ITU CCITT Recommendation T.81
	//   (www.w3.org/Graphics/JPEG/itu-t81.pdf)
	// - The JFIF specification can be found in the JPEG File Interchange Format
	//   (www.w3.org/Graphics/JPEG/jfif3.pdf)
	// - The Adobe Application-Specific JPEG markers in the Supporting the DCT Filters
	//   in PostScript Level 2, Technical Note #5116
	//   (partners.adobe.com/public/developer/en/ps/sdk/5116.DCT_Filter.pdf)

	var JpegImage = (function jpegImage() {
	  var dctZigZag = new Int32Array([
	     0,
	     1,  8,
	    16,  9,  2,
	     3, 10, 17, 24,
	    32, 25, 18, 11, 4,
	     5, 12, 19, 26, 33, 40,
	    48, 41, 34, 27, 20, 13,  6,
	     7, 14, 21, 28, 35, 42, 49, 56,
	    57, 50, 43, 36, 29, 22, 15,
	    23, 30, 37, 44, 51, 58,
	    59, 52, 45, 38, 31,
	    39, 46, 53, 60,
	    61, 54, 47,
	    55, 62,
	    63
	  ]);

	  var dctCos1  =  4017;   // cos(pi/16)
	  var dctSin1  =   799;   // sin(pi/16)
	  var dctCos3  =  3406;   // cos(3*pi/16)
	  var dctSin3  =  2276;   // sin(3*pi/16)
	  var dctCos6  =  1567;   // cos(6*pi/16)
	  var dctSin6  =  3784;   // sin(6*pi/16)
	  var dctSqrt2 =  5793;   // sqrt(2)
	  var dctSqrt1d2 = 2896;  // sqrt(2) / 2

	  function constructor() {
	  }

	  function buildHuffmanTable(codeLengths, values) {
	    var k = 0, code = [], i, j, length = 16;
	    while (length > 0 && !codeLengths[length - 1])
	      length--;
	    code.push({children: [], index: 0});
	    var p = code[0], q;
	    for (i = 0; i < length; i++) {
	      for (j = 0; j < codeLengths[i]; j++) {
	        p = code.pop();
	        p.children[p.index] = values[k];
	        while (p.index > 0) {
	          p = code.pop();
	        }
	        p.index++;
	        code.push(p);
	        while (code.length <= i) {
	          code.push(q = {children: [], index: 0});
	          p.children[p.index] = q.children;
	          p = q;
	        }
	        k++;
	      }
	      if (i + 1 < length) {
	        // p here points to last code
	        code.push(q = {children: [], index: 0});
	        p.children[p.index] = q.children;
	        p = q;
	      }
	    }
	    return code[0].children;
	  }

	  function decodeScan(data, offset,
	                      frame, components, resetInterval,
	                      spectralStart, spectralEnd,
	                      successivePrev, successive) {
	    frame.precision;
	    frame.samplesPerLine;
	    frame.scanLines;
	    var mcusPerLine = frame.mcusPerLine;
	    var progressive = frame.progressive;
	    frame.maxH; frame.maxV;

	    var startOffset = offset, bitsData = 0, bitsCount = 0;
	    function readBit() {
	      if (bitsCount > 0) {
	        bitsCount--;
	        return (bitsData >> bitsCount) & 1;
	      }
	      bitsData = data[offset++];
	      if (bitsData == 0xFF) {
	        var nextByte = data[offset++];
	        if (nextByte) {
	          throw new Error("unexpected marker: " + ((bitsData << 8) | nextByte).toString(16));
	        }
	        // unstuff 0
	      }
	      bitsCount = 7;
	      return bitsData >>> 7;
	    }
	    function decodeHuffman(tree) {
	      var node = tree, bit;
	      while ((bit = readBit()) !== null) {
	        node = node[bit];
	        if (typeof node === 'number')
	          return node;
	        if (typeof node !== 'object')
	          throw new Error("invalid huffman sequence");
	      }
	      return null;
	    }
	    function receive(length) {
	      var n = 0;
	      while (length > 0) {
	        var bit = readBit();
	        if (bit === null) return;
	        n = (n << 1) | bit;
	        length--;
	      }
	      return n;
	    }
	    function receiveAndExtend(length) {
	      var n = receive(length);
	      if (n >= 1 << (length - 1))
	        return n;
	      return n + (-1 << length) + 1;
	    }
	    function decodeBaseline(component, zz) {
	      var t = decodeHuffman(component.huffmanTableDC);
	      var diff = t === 0 ? 0 : receiveAndExtend(t);
	      zz[0]= (component.pred += diff);
	      var k = 1;
	      while (k < 64) {
	        var rs = decodeHuffman(component.huffmanTableAC);
	        var s = rs & 15, r = rs >> 4;
	        if (s === 0) {
	          if (r < 15)
	            break;
	          k += 16;
	          continue;
	        }
	        k += r;
	        var z = dctZigZag[k];
	        zz[z] = receiveAndExtend(s);
	        k++;
	      }
	    }
	    function decodeDCFirst(component, zz) {
	      var t = decodeHuffman(component.huffmanTableDC);
	      var diff = t === 0 ? 0 : (receiveAndExtend(t) << successive);
	      zz[0] = (component.pred += diff);
	    }
	    function decodeDCSuccessive(component, zz) {
	      zz[0] |= readBit() << successive;
	    }
	    var eobrun = 0;
	    function decodeACFirst(component, zz) {
	      if (eobrun > 0) {
	        eobrun--;
	        return;
	      }
	      var k = spectralStart, e = spectralEnd;
	      while (k <= e) {
	        var rs = decodeHuffman(component.huffmanTableAC);
	        var s = rs & 15, r = rs >> 4;
	        if (s === 0) {
	          if (r < 15) {
	            eobrun = receive(r) + (1 << r) - 1;
	            break;
	          }
	          k += 16;
	          continue;
	        }
	        k += r;
	        var z = dctZigZag[k];
	        zz[z] = receiveAndExtend(s) * (1 << successive);
	        k++;
	      }
	    }
	    var successiveACState = 0, successiveACNextValue;
	    function decodeACSuccessive(component, zz) {
	      var k = spectralStart, e = spectralEnd, r = 0;
	      while (k <= e) {
	        var z = dctZigZag[k];
	        var direction = zz[z] < 0 ? -1 : 1;
	        switch (successiveACState) {
	        case 0: // initial state
	          var rs = decodeHuffman(component.huffmanTableAC);
	          var s = rs & 15, r = rs >> 4;
	          if (s === 0) {
	            if (r < 15) {
	              eobrun = receive(r) + (1 << r);
	              successiveACState = 4;
	            } else {
	              r = 16;
	              successiveACState = 1;
	            }
	          } else {
	            if (s !== 1)
	              throw new Error("invalid ACn encoding");
	            successiveACNextValue = receiveAndExtend(s);
	            successiveACState = r ? 2 : 3;
	          }
	          continue;
	        case 1: // skipping r zero items
	        case 2:
	          if (zz[z])
	            zz[z] += (readBit() << successive) * direction;
	          else {
	            r--;
	            if (r === 0)
	              successiveACState = successiveACState == 2 ? 3 : 0;
	          }
	          break;
	        case 3: // set value for a zero item
	          if (zz[z])
	            zz[z] += (readBit() << successive) * direction;
	          else {
	            zz[z] = successiveACNextValue << successive;
	            successiveACState = 0;
	          }
	          break;
	        case 4: // eob
	          if (zz[z])
	            zz[z] += (readBit() << successive) * direction;
	          break;
	        }
	        k++;
	      }
	      if (successiveACState === 4) {
	        eobrun--;
	        if (eobrun === 0)
	          successiveACState = 0;
	      }
	    }
	    function decodeMcu(component, decode, mcu, row, col) {
	      var mcuRow = (mcu / mcusPerLine) | 0;
	      var mcuCol = mcu % mcusPerLine;
	      var blockRow = mcuRow * component.v + row;
	      var blockCol = mcuCol * component.h + col;
	      decode(component, component.blocks[blockRow][blockCol]);
	    }
	    function decodeBlock(component, decode, mcu) {
	      var blockRow = (mcu / component.blocksPerLine) | 0;
	      var blockCol = mcu % component.blocksPerLine;
	      decode(component, component.blocks[blockRow][blockCol]);
	    }

	    var componentsLength = components.length;
	    var component, i, j, k, n;
	    var decodeFn;
	    if (progressive) {
	      if (spectralStart === 0)
	        decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
	      else
	        decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
	    } else {
	      decodeFn = decodeBaseline;
	    }

	    var mcu = 0, marker;
	    var mcuExpected;
	    if (componentsLength == 1) {
	      mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
	    } else {
	      mcuExpected = mcusPerLine * frame.mcusPerColumn;
	    }
	    if (!resetInterval) resetInterval = mcuExpected;

	    var h, v;
	    while (mcu < mcuExpected) {
	      // reset interval stuff
	      for (i = 0; i < componentsLength; i++)
	        components[i].pred = 0;
	      eobrun = 0;

	      if (componentsLength == 1) {
	        component = components[0];
	        for (n = 0; n < resetInterval; n++) {
	          decodeBlock(component, decodeFn, mcu);
	          mcu++;
	        }
	      } else {
	        for (n = 0; n < resetInterval; n++) {
	          for (i = 0; i < componentsLength; i++) {
	            component = components[i];
	            h = component.h;
	            v = component.v;
	            for (j = 0; j < v; j++) {
	              for (k = 0; k < h; k++) {
	                decodeMcu(component, decodeFn, mcu, j, k);
	              }
	            }
	          }
	          mcu++;

	          // If we've reached our expected MCU's, stop decoding
	          if (mcu === mcuExpected) break;
	        }
	      }

	      // find marker
	      bitsCount = 0;
	      marker = (data[offset] << 8) | data[offset + 1];
	      if (marker < 0xFF00) {
	        throw new Error("marker was not found");
	      }

	      if (marker >= 0xFFD0 && marker <= 0xFFD7) { // RSTx
	        offset += 2;
	      }
	      else
	        break;
	    }

	    return offset - startOffset;
	  }

	  function buildComponentData(frame, component) {
	    var lines = [];
	    var blocksPerLine = component.blocksPerLine;
	    var blocksPerColumn = component.blocksPerColumn;
	    var samplesPerLine = blocksPerLine << 3;
	    var R = new Int32Array(64), r = new Uint8Array(64);

	    // A port of poppler's IDCT method which in turn is taken from:
	    //   Christoph Loeffler, Adriaan Ligtenberg, George S. Moschytz,
	    //   "Practical Fast 1-D DCT Algorithms with 11 Multiplications",
	    //   IEEE Intl. Conf. on Acoustics, Speech & Signal Processing, 1989,
	    //   988-991.
	    function quantizeAndInverse(zz, dataOut, dataIn) {
	      var qt = component.quantizationTable;
	      var v0, v1, v2, v3, v4, v5, v6, v7, t;
	      var p = dataIn;
	      var i;

	      // dequant
	      for (i = 0; i < 64; i++)
	        p[i] = zz[i] * qt[i];

	      // inverse DCT on rows
	      for (i = 0; i < 8; ++i) {
	        var row = 8 * i;

	        // check for all-zero AC coefficients
	        if (p[1 + row] == 0 && p[2 + row] == 0 && p[3 + row] == 0 &&
	            p[4 + row] == 0 && p[5 + row] == 0 && p[6 + row] == 0 &&
	            p[7 + row] == 0) {
	          t = (dctSqrt2 * p[0 + row] + 512) >> 10;
	          p[0 + row] = t;
	          p[1 + row] = t;
	          p[2 + row] = t;
	          p[3 + row] = t;
	          p[4 + row] = t;
	          p[5 + row] = t;
	          p[6 + row] = t;
	          p[7 + row] = t;
	          continue;
	        }

	        // stage 4
	        v0 = (dctSqrt2 * p[0 + row] + 128) >> 8;
	        v1 = (dctSqrt2 * p[4 + row] + 128) >> 8;
	        v2 = p[2 + row];
	        v3 = p[6 + row];
	        v4 = (dctSqrt1d2 * (p[1 + row] - p[7 + row]) + 128) >> 8;
	        v7 = (dctSqrt1d2 * (p[1 + row] + p[7 + row]) + 128) >> 8;
	        v5 = p[3 + row] << 4;
	        v6 = p[5 + row] << 4;

	        // stage 3
	        t = (v0 - v1+ 1) >> 1;
	        v0 = (v0 + v1 + 1) >> 1;
	        v1 = t;
	        t = (v2 * dctSin6 + v3 * dctCos6 + 128) >> 8;
	        v2 = (v2 * dctCos6 - v3 * dctSin6 + 128) >> 8;
	        v3 = t;
	        t = (v4 - v6 + 1) >> 1;
	        v4 = (v4 + v6 + 1) >> 1;
	        v6 = t;
	        t = (v7 + v5 + 1) >> 1;
	        v5 = (v7 - v5 + 1) >> 1;
	        v7 = t;

	        // stage 2
	        t = (v0 - v3 + 1) >> 1;
	        v0 = (v0 + v3 + 1) >> 1;
	        v3 = t;
	        t = (v1 - v2 + 1) >> 1;
	        v1 = (v1 + v2 + 1) >> 1;
	        v2 = t;
	        t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
	        v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
	        v7 = t;
	        t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
	        v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
	        v6 = t;

	        // stage 1
	        p[0 + row] = v0 + v7;
	        p[7 + row] = v0 - v7;
	        p[1 + row] = v1 + v6;
	        p[6 + row] = v1 - v6;
	        p[2 + row] = v2 + v5;
	        p[5 + row] = v2 - v5;
	        p[3 + row] = v3 + v4;
	        p[4 + row] = v3 - v4;
	      }

	      // inverse DCT on columns
	      for (i = 0; i < 8; ++i) {
	        var col = i;

	        // check for all-zero AC coefficients
	        if (p[1*8 + col] == 0 && p[2*8 + col] == 0 && p[3*8 + col] == 0 &&
	            p[4*8 + col] == 0 && p[5*8 + col] == 0 && p[6*8 + col] == 0 &&
	            p[7*8 + col] == 0) {
	          t = (dctSqrt2 * dataIn[i+0] + 8192) >> 14;
	          p[0*8 + col] = t;
	          p[1*8 + col] = t;
	          p[2*8 + col] = t;
	          p[3*8 + col] = t;
	          p[4*8 + col] = t;
	          p[5*8 + col] = t;
	          p[6*8 + col] = t;
	          p[7*8 + col] = t;
	          continue;
	        }

	        // stage 4
	        v0 = (dctSqrt2 * p[0*8 + col] + 2048) >> 12;
	        v1 = (dctSqrt2 * p[4*8 + col] + 2048) >> 12;
	        v2 = p[2*8 + col];
	        v3 = p[6*8 + col];
	        v4 = (dctSqrt1d2 * (p[1*8 + col] - p[7*8 + col]) + 2048) >> 12;
	        v7 = (dctSqrt1d2 * (p[1*8 + col] + p[7*8 + col]) + 2048) >> 12;
	        v5 = p[3*8 + col];
	        v6 = p[5*8 + col];

	        // stage 3
	        t = (v0 - v1 + 1) >> 1;
	        v0 = (v0 + v1 + 1) >> 1;
	        v1 = t;
	        t = (v2 * dctSin6 + v3 * dctCos6 + 2048) >> 12;
	        v2 = (v2 * dctCos6 - v3 * dctSin6 + 2048) >> 12;
	        v3 = t;
	        t = (v4 - v6 + 1) >> 1;
	        v4 = (v4 + v6 + 1) >> 1;
	        v6 = t;
	        t = (v7 + v5 + 1) >> 1;
	        v5 = (v7 - v5 + 1) >> 1;
	        v7 = t;

	        // stage 2
	        t = (v0 - v3 + 1) >> 1;
	        v0 = (v0 + v3 + 1) >> 1;
	        v3 = t;
	        t = (v1 - v2 + 1) >> 1;
	        v1 = (v1 + v2 + 1) >> 1;
	        v2 = t;
	        t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
	        v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
	        v7 = t;
	        t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
	        v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
	        v6 = t;

	        // stage 1
	        p[0*8 + col] = v0 + v7;
	        p[7*8 + col] = v0 - v7;
	        p[1*8 + col] = v1 + v6;
	        p[6*8 + col] = v1 - v6;
	        p[2*8 + col] = v2 + v5;
	        p[5*8 + col] = v2 - v5;
	        p[3*8 + col] = v3 + v4;
	        p[4*8 + col] = v3 - v4;
	      }

	      // convert to 8-bit integers
	      for (i = 0; i < 64; ++i) {
	        var sample = 128 + ((p[i] + 8) >> 4);
	        dataOut[i] = sample < 0 ? 0 : sample > 0xFF ? 0xFF : sample;
	      }
	    }

	    var i, j;
	    for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
	      var scanLine = blockRow << 3;
	      for (i = 0; i < 8; i++)
	        lines.push(new Uint8Array(samplesPerLine));
	      for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
	        quantizeAndInverse(component.blocks[blockRow][blockCol], r, R);

	        var offset = 0, sample = blockCol << 3;
	        for (j = 0; j < 8; j++) {
	          var line = lines[scanLine + j];
	          for (i = 0; i < 8; i++)
	            line[sample + i] = r[offset++];
	        }
	      }
	    }
	    return lines;
	  }

	  function clampTo8bit(a) {
	    return a < 0 ? 0 : a > 255 ? 255 : a;
	  }

	  constructor.prototype = {
	    load: function load(path) {
	      var xhr = new XMLHttpRequest();
	      xhr.open("GET", path, true);
	      xhr.responseType = "arraybuffer";
	      xhr.onload = (function() {
	        // TODO catch parse error
	        var data = new Uint8Array(xhr.response || xhr.mozResponseArrayBuffer);
	        this.parse(data);
	        if (this.onload)
	          this.onload();
	      }).bind(this);
	      xhr.send(null);
	    },
	    parse: function parse(data) {
	      var offset = 0; data.length;
	      function readUint16() {
	        var value = (data[offset] << 8) | data[offset + 1];
	        offset += 2;
	        return value;
	      }
	      function readDataBlock() {
	        var length = readUint16();
	        var array = data.subarray(offset, offset + length - 2);
	        offset += array.length;
	        return array;
	      }
	      function prepareComponents(frame) {
	        var maxH = 0, maxV = 0;
	        var component, componentId;
	        for (componentId in frame.components) {
	          if (frame.components.hasOwnProperty(componentId)) {
	            component = frame.components[componentId];
	            if (maxH < component.h) maxH = component.h;
	            if (maxV < component.v) maxV = component.v;
	          }
	        }
	        var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / maxH);
	        var mcusPerColumn = Math.ceil(frame.scanLines / 8 / maxV);
	        for (componentId in frame.components) {
	          if (frame.components.hasOwnProperty(componentId)) {
	            component = frame.components[componentId];
	            var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / maxH);
	            var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines  / 8) * component.v / maxV);
	            var blocksPerLineForMcu = mcusPerLine * component.h;
	            var blocksPerColumnForMcu = mcusPerColumn * component.v;
	            var blocks = [];
	            for (var i = 0; i < blocksPerColumnForMcu; i++) {
	              var row = [];
	              for (var j = 0; j < blocksPerLineForMcu; j++)
	                row.push(new Int32Array(64));
	              blocks.push(row);
	            }
	            component.blocksPerLine = blocksPerLine;
	            component.blocksPerColumn = blocksPerColumn;
	            component.blocks = blocks;
	          }
	        }
	        frame.maxH = maxH;
	        frame.maxV = maxV;
	        frame.mcusPerLine = mcusPerLine;
	        frame.mcusPerColumn = mcusPerColumn;
	      }
	      var jfif = null;
	      var adobe = null;
	      var frame, resetInterval;
	      var quantizationTables = [], frames = [];
	      var huffmanTablesAC = [], huffmanTablesDC = [];
	      var fileMarker = readUint16();
	      if (fileMarker != 0xFFD8) { // SOI (Start of Image)
	        throw new Error("SOI not found");
	      }

	      fileMarker = readUint16();
	      while (fileMarker != 0xFFD9) { // EOI (End of image)
	        var i, j;
	        switch(fileMarker) {
	          case 0xFF00: break;
	          case 0xFFE0: // APP0 (Application Specific)
	          case 0xFFE1: // APP1
	          case 0xFFE2: // APP2
	          case 0xFFE3: // APP3
	          case 0xFFE4: // APP4
	          case 0xFFE5: // APP5
	          case 0xFFE6: // APP6
	          case 0xFFE7: // APP7
	          case 0xFFE8: // APP8
	          case 0xFFE9: // APP9
	          case 0xFFEA: // APP10
	          case 0xFFEB: // APP11
	          case 0xFFEC: // APP12
	          case 0xFFED: // APP13
	          case 0xFFEE: // APP14
	          case 0xFFEF: // APP15
	          case 0xFFFE: // COM (Comment)
	            var appData = readDataBlock();

	            if (fileMarker === 0xFFE0) {
	              if (appData[0] === 0x4A && appData[1] === 0x46 && appData[2] === 0x49 &&
	                appData[3] === 0x46 && appData[4] === 0) { // 'JFIF\x00'
	                jfif = {
	                  version: { major: appData[5], minor: appData[6] },
	                  densityUnits: appData[7],
	                  xDensity: (appData[8] << 8) | appData[9],
	                  yDensity: (appData[10] << 8) | appData[11],
	                  thumbWidth: appData[12],
	                  thumbHeight: appData[13],
	                  thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
	                };
	              }
	            }
	            // TODO APP1 - Exif
	            if (fileMarker === 0xFFEE) {
	              if (appData[0] === 0x41 && appData[1] === 0x64 && appData[2] === 0x6F &&
	                appData[3] === 0x62 && appData[4] === 0x65 && appData[5] === 0) { // 'Adobe\x00'
	                adobe = {
	                  version: appData[6],
	                  flags0: (appData[7] << 8) | appData[8],
	                  flags1: (appData[9] << 8) | appData[10],
	                  transformCode: appData[11]
	                };
	              }
	            }
	            break;

	          case 0xFFDB: // DQT (Define Quantization Tables)
	            var quantizationTablesLength = readUint16();
	            var quantizationTablesEnd = quantizationTablesLength + offset - 2;
	            while (offset < quantizationTablesEnd) {
	              var quantizationTableSpec = data[offset++];
	              var tableData = new Int32Array(64);
	              if ((quantizationTableSpec >> 4) === 0) { // 8 bit values
	                for (j = 0; j < 64; j++) {
	                  var z = dctZigZag[j];
	                  tableData[z] = data[offset++];
	                }
	              } else if ((quantizationTableSpec >> 4) === 1) { //16 bit
	                for (j = 0; j < 64; j++) {
	                  var z = dctZigZag[j];
	                  tableData[z] = readUint16();
	                }
	              } else
	                throw new Error("DQT: invalid table spec");
	              quantizationTables[quantizationTableSpec & 15] = tableData;
	            }
	            break;

	          case 0xFFC0: // SOF0 (Start of Frame, Baseline DCT)
	          case 0xFFC1: // SOF1 (Start of Frame, Extended DCT)
	          case 0xFFC2: // SOF2 (Start of Frame, Progressive DCT)
	            readUint16(); // skip data length
	            frame = {};
	            frame.extended = (fileMarker === 0xFFC1);
	            frame.progressive = (fileMarker === 0xFFC2);
	            frame.precision = data[offset++];
	            frame.scanLines = readUint16();
	            frame.samplesPerLine = readUint16();
	            frame.components = {};
	            frame.componentsOrder = [];
	            var componentsCount = data[offset++], componentId;
	            for (i = 0; i < componentsCount; i++) {
	              componentId = data[offset];
	              var h = data[offset + 1] >> 4;
	              var v = data[offset + 1] & 15;
	              var qId = data[offset + 2];
	              frame.componentsOrder.push(componentId);
	              frame.components[componentId] = {
	                h: h,
	                v: v,
	                quantizationIdx: qId
	              };
	              offset += 3;
	            }
	            prepareComponents(frame);
	            frames.push(frame);
	            break;

	          case 0xFFC4: // DHT (Define Huffman Tables)
	            var huffmanLength = readUint16();
	            for (i = 2; i < huffmanLength;) {
	              var huffmanTableSpec = data[offset++];
	              var codeLengths = new Uint8Array(16);
	              var codeLengthSum = 0;
	              for (j = 0; j < 16; j++, offset++)
	                codeLengthSum += (codeLengths[j] = data[offset]);
	              var huffmanValues = new Uint8Array(codeLengthSum);
	              for (j = 0; j < codeLengthSum; j++, offset++)
	                huffmanValues[j] = data[offset];
	              i += 17 + codeLengthSum;

	              ((huffmanTableSpec >> 4) === 0 ?
	                huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] =
	                buildHuffmanTable(codeLengths, huffmanValues);
	            }
	            break;

	          case 0xFFDD: // DRI (Define Restart Interval)
	            readUint16(); // skip data length
	            resetInterval = readUint16();
	            break;

	          case 0xFFDA: // SOS (Start of Scan)
	            readUint16();
	            var selectorsCount = data[offset++];
	            var components = [], component;
	            for (i = 0; i < selectorsCount; i++) {
	              component = frame.components[data[offset++]];
	              var tableSpec = data[offset++];
	              component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
	              component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
	              components.push(component);
	            }
	            var spectralStart = data[offset++];
	            var spectralEnd = data[offset++];
	            var successiveApproximation = data[offset++];
	            var processed = decodeScan(data, offset,
	              frame, components, resetInterval,
	              spectralStart, spectralEnd,
	              successiveApproximation >> 4, successiveApproximation & 15);
	            offset += processed;
	            break;

	          case 0xFFFF: // Fill bytes
	            if (data[offset] !== 0xFF) { // Avoid skipping a valid marker.
	              offset--;
	            }
	            break;

	          default:
	            if (data[offset - 3] == 0xFF &&
	                data[offset - 2] >= 0xC0 && data[offset - 2] <= 0xFE) {
	              // could be incorrect encoding -- last 0xFF byte of the previous
	              // block was eaten by the encoder
	              offset -= 3;
	              break;
	            }
	            throw new Error("unknown JPEG marker " + fileMarker.toString(16));
	        }
	        fileMarker = readUint16();
	      }
	      if (frames.length != 1)
	        throw new Error("only single frame JPEGs supported");

	      // set each frame's components quantization table
	      for (var i = 0; i < frames.length; i++) {
	        var cp = frames[i].components;
	        for (var j in cp) {
	          cp[j].quantizationTable = quantizationTables[cp[j].quantizationIdx];
	          delete cp[j].quantizationIdx;
	        }
	      }

	      this.width = frame.samplesPerLine;
	      this.height = frame.scanLines;
	      this.jfif = jfif;
	      this.adobe = adobe;
	      this.components = [];
	      for (var i = 0; i < frame.componentsOrder.length; i++) {
	        var component = frame.components[frame.componentsOrder[i]];
	        this.components.push({
	          lines: buildComponentData(frame, component),
	          scaleX: component.h / frame.maxH,
	          scaleY: component.v / frame.maxV
	        });
	      }
	    },
	    getData: function getData(width, height) {
	      var scaleX = this.width / width, scaleY = this.height / height;

	      var component1, component2, component3, component4;
	      var component1Line, component2Line, component3Line, component4Line;
	      var x, y;
	      var offset = 0;
	      var Y, Cb, Cr, K, C, M, Ye, R, G, B;
	      var colorTransform;
	      var dataLength = width * height * this.components.length;
	      var data = new Uint8Array(dataLength);
	      switch (this.components.length) {
	        case 1:
	          component1 = this.components[0];
	          for (y = 0; y < height; y++) {
	            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
	            for (x = 0; x < width; x++) {
	              Y = component1Line[0 | (x * component1.scaleX * scaleX)];

	              data[offset++] = Y;
	            }
	          }
	          break;
	        case 2:
	          // PDF might compress two component data in custom colorspace
	          component1 = this.components[0];
	          component2 = this.components[1];
	          for (y = 0; y < height; y++) {
	            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
	            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
	            for (x = 0; x < width; x++) {
	              Y = component1Line[0 | (x * component1.scaleX * scaleX)];
	              data[offset++] = Y;
	              Y = component2Line[0 | (x * component2.scaleX * scaleX)];
	              data[offset++] = Y;
	            }
	          }
	          break;
	        case 3:
	          // The default transform for three components is true
	          colorTransform = true;
	          // The adobe transform marker overrides any previous setting
	          if (this.adobe && this.adobe.transformCode)
	            colorTransform = true;
	          else if (typeof this.colorTransform !== 'undefined')
	            colorTransform = !!this.colorTransform;

	          component1 = this.components[0];
	          component2 = this.components[1];
	          component3 = this.components[2];
	          for (y = 0; y < height; y++) {
	            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
	            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
	            component3Line = component3.lines[0 | (y * component3.scaleY * scaleY)];
	            for (x = 0; x < width; x++) {
	              if (!colorTransform) {
	                R = component1Line[0 | (x * component1.scaleX * scaleX)];
	                G = component2Line[0 | (x * component2.scaleX * scaleX)];
	                B = component3Line[0 | (x * component3.scaleX * scaleX)];
	              } else {
	                Y = component1Line[0 | (x * component1.scaleX * scaleX)];
	                Cb = component2Line[0 | (x * component2.scaleX * scaleX)];
	                Cr = component3Line[0 | (x * component3.scaleX * scaleX)];

	                R = clampTo8bit(Y + 1.402 * (Cr - 128));
	                G = clampTo8bit(Y - 0.3441363 * (Cb - 128) - 0.71413636 * (Cr - 128));
	                B = clampTo8bit(Y + 1.772 * (Cb - 128));
	              }

	              data[offset++] = R;
	              data[offset++] = G;
	              data[offset++] = B;
	            }
	          }
	          break;
	        case 4:
	          if (!this.adobe)
	            throw 'Unsupported color mode (4 components)';
	          // The default transform for four components is false
	          colorTransform = false;
	          // The adobe transform marker overrides any previous setting
	          if (this.adobe && this.adobe.transformCode)
	            colorTransform = true;
	          else if (typeof this.colorTransform !== 'undefined')
	            colorTransform = !!this.colorTransform;

	          component1 = this.components[0];
	          component2 = this.components[1];
	          component3 = this.components[2];
	          component4 = this.components[3];
	          for (y = 0; y < height; y++) {
	            component1Line = component1.lines[0 | (y * component1.scaleY * scaleY)];
	            component2Line = component2.lines[0 | (y * component2.scaleY * scaleY)];
	            component3Line = component3.lines[0 | (y * component3.scaleY * scaleY)];
	            component4Line = component4.lines[0 | (y * component4.scaleY * scaleY)];
	            for (x = 0; x < width; x++) {
	              if (!colorTransform) {
	                C = component1Line[0 | (x * component1.scaleX * scaleX)];
	                M = component2Line[0 | (x * component2.scaleX * scaleX)];
	                Ye = component3Line[0 | (x * component3.scaleX * scaleX)];
	                K = component4Line[0 | (x * component4.scaleX * scaleX)];
	              } else {
	                Y = component1Line[0 | (x * component1.scaleX * scaleX)];
	                Cb = component2Line[0 | (x * component2.scaleX * scaleX)];
	                Cr = component3Line[0 | (x * component3.scaleX * scaleX)];
	                K = component4Line[0 | (x * component4.scaleX * scaleX)];

	                C = 255 - clampTo8bit(Y + 1.402 * (Cr - 128));
	                M = 255 - clampTo8bit(Y - 0.3441363 * (Cb - 128) - 0.71413636 * (Cr - 128));
	                Ye = 255 - clampTo8bit(Y + 1.772 * (Cb - 128));
	              }
	              data[offset++] = 255-C;
	              data[offset++] = 255-M;
	              data[offset++] = 255-Ye;
	              data[offset++] = 255-K;
	            }
	          }
	          break;
	        default:
	          throw 'Unsupported color mode';
	      }
	      return data;
	    },
	    copyToImageData: function copyToImageData(imageData) {
	      var width = imageData.width, height = imageData.height;
	      var imageDataArray = imageData.data;
	      var data = this.getData(width, height);
	      var i = 0, j = 0, x, y;
	      var Y, K, C, M, R, G, B;
	      switch (this.components.length) {
	        case 1:
	          for (y = 0; y < height; y++) {
	            for (x = 0; x < width; x++) {
	              Y = data[i++];

	              imageDataArray[j++] = Y;
	              imageDataArray[j++] = Y;
	              imageDataArray[j++] = Y;
	              imageDataArray[j++] = 255;
	            }
	          }
	          break;
	        case 3:
	          for (y = 0; y < height; y++) {
	            for (x = 0; x < width; x++) {
	              R = data[i++];
	              G = data[i++];
	              B = data[i++];

	              imageDataArray[j++] = R;
	              imageDataArray[j++] = G;
	              imageDataArray[j++] = B;
	              imageDataArray[j++] = 255;
	            }
	          }
	          break;
	        case 4:
	          for (y = 0; y < height; y++) {
	            for (x = 0; x < width; x++) {
	              C = data[i++];
	              M = data[i++];
	              Y = data[i++];
	              K = data[i++];

	              R = 255 - clampTo8bit(C * (1 - K / 255) + K);
	              G = 255 - clampTo8bit(M * (1 - K / 255) + K);
	              B = 255 - clampTo8bit(Y * (1 - K / 255) + K);

	              imageDataArray[j++] = R;
	              imageDataArray[j++] = G;
	              imageDataArray[j++] = B;
	              imageDataArray[j++] = 255;
	            }
	          }
	          break;
	        default:
	          throw 'Unsupported color mode';
	      }
	    }
	  };

	  return constructor;
	})();
	module.exports = decode;

	function decode(jpegData, useTArray) {
	  var arr = new Uint8Array(jpegData);
	  var decoder = new JpegImage();
	  decoder.parse(arr);

	  var image = {
	    width: decoder.width,
	    height: decoder.height,
	    data: useTArray ?
	      new Uint8Array(decoder.width * decoder.height * 4) :
	      new Buffer(decoder.width * decoder.height * 4)
	  };

	  decoder.copyToImageData(image);

	  return image;
	}

	}).call(this,require("buffer").Buffer);
	},{"buffer":16}],173:[function(require,module,exports){
	(function (Buffer){

	function JPEGEncoder(quality) {
		var ffloor = Math.floor;
		var YTable = new Array(64);
		var UVTable = new Array(64);
		var fdtbl_Y = new Array(64);
		var fdtbl_UV = new Array(64);
		var YDC_HT;
		var UVDC_HT;
		var YAC_HT;
		var UVAC_HT;
		
		var bitcode = new Array(65535);
		var category = new Array(65535);
		var outputfDCTQuant = new Array(64);
		var DU = new Array(64);
		var byteout = [];
		var bytenew = 0;
		var bytepos = 7;
		
		var YDU = new Array(64);
		var UDU = new Array(64);
		var VDU = new Array(64);
		var clt = new Array(256);
		var RGB_YUV_TABLE = new Array(2048);
		var currentQuality;
		
		var ZigZag = [
				 0, 1, 5, 6,14,15,27,28,
				 2, 4, 7,13,16,26,29,42,
				 3, 8,12,17,25,30,41,43,
				 9,11,18,24,31,40,44,53,
				10,19,23,32,39,45,52,54,
				20,22,33,38,46,51,55,60,
				21,34,37,47,50,56,59,61,
				35,36,48,49,57,58,62,63
			];
		
		var std_dc_luminance_nrcodes = [0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0];
		var std_dc_luminance_values = [0,1,2,3,4,5,6,7,8,9,10,11];
		var std_ac_luminance_nrcodes = [0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,0x7d];
		var std_ac_luminance_values = [
				0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
				0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,
				0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
				0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,
				0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
				0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,
				0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
				0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,
				0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
				0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,
				0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
				0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,
				0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
				0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,
				0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
				0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,
				0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
				0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,
				0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
				0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,
				0xf9,0xfa
			];
		
		var std_dc_chrominance_nrcodes = [0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0];
		var std_dc_chrominance_values = [0,1,2,3,4,5,6,7,8,9,10,11];
		var std_ac_chrominance_nrcodes = [0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,0x77];
		var std_ac_chrominance_values = [
				0x00,0x01,0x02,0x03,0x11,0x04,0x05,0x21,
				0x31,0x06,0x12,0x41,0x51,0x07,0x61,0x71,
				0x13,0x22,0x32,0x81,0x08,0x14,0x42,0x91,
				0xa1,0xb1,0xc1,0x09,0x23,0x33,0x52,0xf0,
				0x15,0x62,0x72,0xd1,0x0a,0x16,0x24,0x34,
				0xe1,0x25,0xf1,0x17,0x18,0x19,0x1a,0x26,
				0x27,0x28,0x29,0x2a,0x35,0x36,0x37,0x38,
				0x39,0x3a,0x43,0x44,0x45,0x46,0x47,0x48,
				0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,
				0x59,0x5a,0x63,0x64,0x65,0x66,0x67,0x68,
				0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,
				0x79,0x7a,0x82,0x83,0x84,0x85,0x86,0x87,
				0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,
				0x97,0x98,0x99,0x9a,0xa2,0xa3,0xa4,0xa5,
				0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,
				0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xc2,0xc3,
				0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,
				0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,
				0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,
				0xea,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,
				0xf9,0xfa
			];
		
		function initQuantTables(sf){
				var YQT = [
					16, 11, 10, 16, 24, 40, 51, 61,
					12, 12, 14, 19, 26, 58, 60, 55,
					14, 13, 16, 24, 40, 57, 69, 56,
					14, 17, 22, 29, 51, 87, 80, 62,
					18, 22, 37, 56, 68,109,103, 77,
					24, 35, 55, 64, 81,104,113, 92,
					49, 64, 78, 87,103,121,120,101,
					72, 92, 95, 98,112,100,103, 99
				];
				
				for (var i = 0; i < 64; i++) {
					var t = ffloor((YQT[i]*sf+50)/100);
					if (t < 1) {
						t = 1;
					} else if (t > 255) {
						t = 255;
					}
					YTable[ZigZag[i]] = t;
				}
				var UVQT = [
					17, 18, 24, 47, 99, 99, 99, 99,
					18, 21, 26, 66, 99, 99, 99, 99,
					24, 26, 56, 99, 99, 99, 99, 99,
					47, 66, 99, 99, 99, 99, 99, 99,
					99, 99, 99, 99, 99, 99, 99, 99,
					99, 99, 99, 99, 99, 99, 99, 99,
					99, 99, 99, 99, 99, 99, 99, 99,
					99, 99, 99, 99, 99, 99, 99, 99
				];
				for (var j = 0; j < 64; j++) {
					var u = ffloor((UVQT[j]*sf+50)/100);
					if (u < 1) {
						u = 1;
					} else if (u > 255) {
						u = 255;
					}
					UVTable[ZigZag[j]] = u;
				}
				var aasf = [
					1.0, 1.387039845, 1.306562965, 1.175875602,
					1.0, 0.785694958, 0.541196100, 0.275899379
				];
				var k = 0;
				for (var row = 0; row < 8; row++)
				{
					for (var col = 0; col < 8; col++)
					{
						fdtbl_Y[k]  = (1.0 / (YTable [ZigZag[k]] * aasf[row] * aasf[col] * 8.0));
						fdtbl_UV[k] = (1.0 / (UVTable[ZigZag[k]] * aasf[row] * aasf[col] * 8.0));
						k++;
					}
				}
			}
			
			function computeHuffmanTbl(nrcodes, std_table){
				var codevalue = 0;
				var pos_in_table = 0;
				var HT = new Array();
				for (var k = 1; k <= 16; k++) {
					for (var j = 1; j <= nrcodes[k]; j++) {
						HT[std_table[pos_in_table]] = [];
						HT[std_table[pos_in_table]][0] = codevalue;
						HT[std_table[pos_in_table]][1] = k;
						pos_in_table++;
						codevalue++;
					}
					codevalue*=2;
				}
				return HT;
			}
			
			function initHuffmanTbl()
			{
				YDC_HT = computeHuffmanTbl(std_dc_luminance_nrcodes,std_dc_luminance_values);
				UVDC_HT = computeHuffmanTbl(std_dc_chrominance_nrcodes,std_dc_chrominance_values);
				YAC_HT = computeHuffmanTbl(std_ac_luminance_nrcodes,std_ac_luminance_values);
				UVAC_HT = computeHuffmanTbl(std_ac_chrominance_nrcodes,std_ac_chrominance_values);
			}
		
			function initCategoryNumber()
			{
				var nrlower = 1;
				var nrupper = 2;
				for (var cat = 1; cat <= 15; cat++) {
					//Positive numbers
					for (var nr = nrlower; nr<nrupper; nr++) {
						category[32767+nr] = cat;
						bitcode[32767+nr] = [];
						bitcode[32767+nr][1] = cat;
						bitcode[32767+nr][0] = nr;
					}
					//Negative numbers
					for (var nrneg =-(nrupper-1); nrneg<=-nrlower; nrneg++) {
						category[32767+nrneg] = cat;
						bitcode[32767+nrneg] = [];
						bitcode[32767+nrneg][1] = cat;
						bitcode[32767+nrneg][0] = nrupper-1+nrneg;
					}
					nrlower <<= 1;
					nrupper <<= 1;
				}
			}
			
			function initRGBYUVTable() {
				for(var i = 0; i < 256;i++) {
					RGB_YUV_TABLE[i]      		=  19595 * i;
					RGB_YUV_TABLE[(i+ 256)>>0] 	=  38470 * i;
					RGB_YUV_TABLE[(i+ 512)>>0] 	=   7471 * i + 0x8000;
					RGB_YUV_TABLE[(i+ 768)>>0] 	= -11059 * i;
					RGB_YUV_TABLE[(i+1024)>>0] 	= -21709 * i;
					RGB_YUV_TABLE[(i+1280)>>0] 	=  32768 * i + 0x807FFF;
					RGB_YUV_TABLE[(i+1536)>>0] 	= -27439 * i;
					RGB_YUV_TABLE[(i+1792)>>0] 	= - 5329 * i;
				}
			}
			
			// IO functions
			function writeBits(bs)
			{
				var value = bs[0];
				var posval = bs[1]-1;
				while ( posval >= 0 ) {
					if (value & (1 << posval) ) {
						bytenew |= (1 << bytepos);
					}
					posval--;
					bytepos--;
					if (bytepos < 0) {
						if (bytenew == 0xFF) {
							writeByte(0xFF);
							writeByte(0);
						}
						else {
							writeByte(bytenew);
						}
						bytepos=7;
						bytenew=0;
					}
				}
			}
		
			function writeByte(value)
			{
				//byteout.push(clt[value]); // write char directly instead of converting later
	      byteout.push(value);
			}
		
			function writeWord(value)
			{
				writeByte((value>>8)&0xFF);
				writeByte((value   )&0xFF);
			}
			
			// DCT & quantization core
			function fDCTQuant(data, fdtbl)
			{
				var d0, d1, d2, d3, d4, d5, d6, d7;
				/* Pass 1: process rows. */
				var dataOff=0;
				var i;
				var I8 = 8;
				var I64 = 64;
				for (i=0; i<I8; ++i)
				{
					d0 = data[dataOff];
					d1 = data[dataOff+1];
					d2 = data[dataOff+2];
					d3 = data[dataOff+3];
					d4 = data[dataOff+4];
					d5 = data[dataOff+5];
					d6 = data[dataOff+6];
					d7 = data[dataOff+7];
					
					var tmp0 = d0 + d7;
					var tmp7 = d0 - d7;
					var tmp1 = d1 + d6;
					var tmp6 = d1 - d6;
					var tmp2 = d2 + d5;
					var tmp5 = d2 - d5;
					var tmp3 = d3 + d4;
					var tmp4 = d3 - d4;
		
					/* Even part */
					var tmp10 = tmp0 + tmp3;	/* phase 2 */
					var tmp13 = tmp0 - tmp3;
					var tmp11 = tmp1 + tmp2;
					var tmp12 = tmp1 - tmp2;
		
					data[dataOff] = tmp10 + tmp11; /* phase 3 */
					data[dataOff+4] = tmp10 - tmp11;
		
					var z1 = (tmp12 + tmp13) * 0.707106781; /* c4 */
					data[dataOff+2] = tmp13 + z1; /* phase 5 */
					data[dataOff+6] = tmp13 - z1;
		
					/* Odd part */
					tmp10 = tmp4 + tmp5; /* phase 2 */
					tmp11 = tmp5 + tmp6;
					tmp12 = tmp6 + tmp7;
		
					/* The rotator is modified from fig 4-8 to avoid extra negations. */
					var z5 = (tmp10 - tmp12) * 0.382683433; /* c6 */
					var z2 = 0.541196100 * tmp10 + z5; /* c2-c6 */
					var z4 = 1.306562965 * tmp12 + z5; /* c2+c6 */
					var z3 = tmp11 * 0.707106781; /* c4 */
		
					var z11 = tmp7 + z3;	/* phase 5 */
					var z13 = tmp7 - z3;
		
					data[dataOff+5] = z13 + z2;	/* phase 6 */
					data[dataOff+3] = z13 - z2;
					data[dataOff+1] = z11 + z4;
					data[dataOff+7] = z11 - z4;
		
					dataOff += 8; /* advance pointer to next row */
				}
		
				/* Pass 2: process columns. */
				dataOff = 0;
				for (i=0; i<I8; ++i)
				{
					d0 = data[dataOff];
					d1 = data[dataOff + 8];
					d2 = data[dataOff + 16];
					d3 = data[dataOff + 24];
					d4 = data[dataOff + 32];
					d5 = data[dataOff + 40];
					d6 = data[dataOff + 48];
					d7 = data[dataOff + 56];
					
					var tmp0p2 = d0 + d7;
					var tmp7p2 = d0 - d7;
					var tmp1p2 = d1 + d6;
					var tmp6p2 = d1 - d6;
					var tmp2p2 = d2 + d5;
					var tmp5p2 = d2 - d5;
					var tmp3p2 = d3 + d4;
					var tmp4p2 = d3 - d4;
		
					/* Even part */
					var tmp10p2 = tmp0p2 + tmp3p2;	/* phase 2 */
					var tmp13p2 = tmp0p2 - tmp3p2;
					var tmp11p2 = tmp1p2 + tmp2p2;
					var tmp12p2 = tmp1p2 - tmp2p2;
		
					data[dataOff] = tmp10p2 + tmp11p2; /* phase 3 */
					data[dataOff+32] = tmp10p2 - tmp11p2;
		
					var z1p2 = (tmp12p2 + tmp13p2) * 0.707106781; /* c4 */
					data[dataOff+16] = tmp13p2 + z1p2; /* phase 5 */
					data[dataOff+48] = tmp13p2 - z1p2;
		
					/* Odd part */
					tmp10p2 = tmp4p2 + tmp5p2; /* phase 2 */
					tmp11p2 = tmp5p2 + tmp6p2;
					tmp12p2 = tmp6p2 + tmp7p2;
		
					/* The rotator is modified from fig 4-8 to avoid extra negations. */
					var z5p2 = (tmp10p2 - tmp12p2) * 0.382683433; /* c6 */
					var z2p2 = 0.541196100 * tmp10p2 + z5p2; /* c2-c6 */
					var z4p2 = 1.306562965 * tmp12p2 + z5p2; /* c2+c6 */
					var z3p2 = tmp11p2 * 0.707106781; /* c4 */
		
					var z11p2 = tmp7p2 + z3p2;	/* phase 5 */
					var z13p2 = tmp7p2 - z3p2;
		
					data[dataOff+40] = z13p2 + z2p2; /* phase 6 */
					data[dataOff+24] = z13p2 - z2p2;
					data[dataOff+ 8] = z11p2 + z4p2;
					data[dataOff+56] = z11p2 - z4p2;
		
					dataOff++; /* advance pointer to next column */
				}
		
				// Quantize/descale the coefficients
				var fDCTQuant;
				for (i=0; i<I64; ++i)
				{
					// Apply the quantization and scaling factor & Round to nearest integer
					fDCTQuant = data[i]*fdtbl[i];
					outputfDCTQuant[i] = (fDCTQuant > 0.0) ? ((fDCTQuant + 0.5)|0) : ((fDCTQuant - 0.5)|0);
					//outputfDCTQuant[i] = fround(fDCTQuant);

				}
				return outputfDCTQuant;
			}
			
			function writeAPP0()
			{
				writeWord(0xFFE0); // marker
				writeWord(16); // length
				writeByte(0x4A); // J
				writeByte(0x46); // F
				writeByte(0x49); // I
				writeByte(0x46); // F
				writeByte(0); // = "JFIF",'\0'
				writeByte(1); // versionhi
				writeByte(1); // versionlo
				writeByte(0); // xyunits
				writeWord(1); // xdensity
				writeWord(1); // ydensity
				writeByte(0); // thumbnwidth
				writeByte(0); // thumbnheight
			}
		
			function writeSOF0(width, height)
			{
				writeWord(0xFFC0); // marker
				writeWord(17);   // length, truecolor YUV JPG
				writeByte(8);    // precision
				writeWord(height);
				writeWord(width);
				writeByte(3);    // nrofcomponents
				writeByte(1);    // IdY
				writeByte(0x11); // HVY
				writeByte(0);    // QTY
				writeByte(2);    // IdU
				writeByte(0x11); // HVU
				writeByte(1);    // QTU
				writeByte(3);    // IdV
				writeByte(0x11); // HVV
				writeByte(1);    // QTV
			}
		
			function writeDQT()
			{
				writeWord(0xFFDB); // marker
				writeWord(132);	   // length
				writeByte(0);
				for (var i=0; i<64; i++) {
					writeByte(YTable[i]);
				}
				writeByte(1);
				for (var j=0; j<64; j++) {
					writeByte(UVTable[j]);
				}
			}
		
			function writeDHT()
			{
				writeWord(0xFFC4); // marker
				writeWord(0x01A2); // length
		
				writeByte(0); // HTYDCinfo
				for (var i=0; i<16; i++) {
					writeByte(std_dc_luminance_nrcodes[i+1]);
				}
				for (var j=0; j<=11; j++) {
					writeByte(std_dc_luminance_values[j]);
				}
		
				writeByte(0x10); // HTYACinfo
				for (var k=0; k<16; k++) {
					writeByte(std_ac_luminance_nrcodes[k+1]);
				}
				for (var l=0; l<=161; l++) {
					writeByte(std_ac_luminance_values[l]);
				}
		
				writeByte(1); // HTUDCinfo
				for (var m=0; m<16; m++) {
					writeByte(std_dc_chrominance_nrcodes[m+1]);
				}
				for (var n=0; n<=11; n++) {
					writeByte(std_dc_chrominance_values[n]);
				}
		
				writeByte(0x11); // HTUACinfo
				for (var o=0; o<16; o++) {
					writeByte(std_ac_chrominance_nrcodes[o+1]);
				}
				for (var p=0; p<=161; p++) {
					writeByte(std_ac_chrominance_values[p]);
				}
			}
		
			function writeSOS()
			{
				writeWord(0xFFDA); // marker
				writeWord(12); // length
				writeByte(3); // nrofcomponents
				writeByte(1); // IdY
				writeByte(0); // HTY
				writeByte(2); // IdU
				writeByte(0x11); // HTU
				writeByte(3); // IdV
				writeByte(0x11); // HTV
				writeByte(0); // Ss
				writeByte(0x3f); // Se
				writeByte(0); // Bf
			}
			
			function processDU(CDU, fdtbl, DC, HTDC, HTAC){
				var EOB = HTAC[0x00];
				var M16zeroes = HTAC[0xF0];
				var pos;
				var I16 = 16;
				var I63 = 63;
				var I64 = 64;
				var DU_DCT = fDCTQuant(CDU, fdtbl);
				//ZigZag reorder
				for (var j=0;j<I64;++j) {
					DU[ZigZag[j]]=DU_DCT[j];
				}
				var Diff = DU[0] - DC; DC = DU[0];
				//Encode DC
				if (Diff==0) {
					writeBits(HTDC[0]); // Diff might be 0
				} else {
					pos = 32767+Diff;
					writeBits(HTDC[category[pos]]);
					writeBits(bitcode[pos]);
				}
				//Encode ACs
				var end0pos = 63; // was const... which is crazy
				for (; (end0pos>0)&&(DU[end0pos]==0); end0pos--) {}				//end0pos = first element in reverse order !=0
				if ( end0pos == 0) {
					writeBits(EOB);
					return DC;
				}
				var i = 1;
				var lng;
				while ( i <= end0pos ) {
					var startpos = i;
					for (; (DU[i]==0) && (i<=end0pos); ++i) {}
					var nrzeroes = i-startpos;
					if ( nrzeroes >= I16 ) {
						lng = nrzeroes>>4;
						for (var nrmarker=1; nrmarker <= lng; ++nrmarker)
							writeBits(M16zeroes);
						nrzeroes = nrzeroes&0xF;
					}
					pos = 32767+DU[i];
					writeBits(HTAC[(nrzeroes<<4)+category[pos]]);
					writeBits(bitcode[pos]);
					i++;
				}
				if ( end0pos != I63 ) {
					writeBits(EOB);
				}
				return DC;
			}

			function initCharLookupTable(){
				var sfcc = String.fromCharCode;
				for(var i=0; i < 256; i++){ ///// ACHTUNG // 255
					clt[i] = sfcc(i);
				}
			}
			
			this.encode = function(image,quality) // image data object
			{
				new Date().getTime();
				
				if(quality) setQuality(quality);
				
				// Initialize bit writer
				byteout = new Array();
				bytenew=0;
				bytepos=7;
		
				// Add JPEG headers
				writeWord(0xFFD8); // SOI
				writeAPP0();
				writeDQT();
				writeSOF0(image.width,image.height);
				writeDHT();
				writeSOS();

		
				// Encode 8x8 macroblocks
				var DCY=0;
				var DCU=0;
				var DCV=0;
				
				bytenew=0;
				bytepos=7;
				
				
				this.encode.displayName = "_encode_";

				var imageData = image.data;
				var width = image.width;
				var height = image.height;

				var quadWidth = width*4;
				
				var x, y = 0;
				var r, g, b;
				var start,p, col,row,pos;
				while(y < height){
					x = 0;
					while(x < quadWidth){
					start = quadWidth * y + x;
					p = start;
					col = -1;
					row = 0;
					
					for(pos=0; pos < 64; pos++){
						row = pos >> 3;// /8
						col = ( pos & 7 ) * 4; // %8
						p = start + ( row * quadWidth ) + col;		
						
						if(y+row >= height){ // padding bottom
							p-= (quadWidth*(y+1+row-height));
						}

						if(x+col >= quadWidth){ // padding right	
							p-= ((x+col) - quadWidth +4);
						}
						
						r = imageData[ p++ ];
						g = imageData[ p++ ];
						b = imageData[ p++ ];
						
						
						/* // calculate YUV values dynamically
						YDU[pos]=((( 0.29900)*r+( 0.58700)*g+( 0.11400)*b))-128; //-0x80
						UDU[pos]=(((-0.16874)*r+(-0.33126)*g+( 0.50000)*b));
						VDU[pos]=((( 0.50000)*r+(-0.41869)*g+(-0.08131)*b));
						*/
						
						// use lookup table (slightly faster)
						YDU[pos] = ((RGB_YUV_TABLE[r]             + RGB_YUV_TABLE[(g +  256)>>0] + RGB_YUV_TABLE[(b +  512)>>0]) >> 16)-128;
						UDU[pos] = ((RGB_YUV_TABLE[(r +  768)>>0] + RGB_YUV_TABLE[(g + 1024)>>0] + RGB_YUV_TABLE[(b + 1280)>>0]) >> 16)-128;
						VDU[pos] = ((RGB_YUV_TABLE[(r + 1280)>>0] + RGB_YUV_TABLE[(g + 1536)>>0] + RGB_YUV_TABLE[(b + 1792)>>0]) >> 16)-128;

					}
					
					DCY = processDU(YDU, fdtbl_Y, DCY, YDC_HT, YAC_HT);
					DCU = processDU(UDU, fdtbl_UV, DCU, UVDC_HT, UVAC_HT);
					DCV = processDU(VDU, fdtbl_UV, DCV, UVDC_HT, UVAC_HT);
					x+=32;
					}
					y+=8;
				}
				
				
				////////////////////////////////////////////////////////////////
		
				// Do the bit alignment of the EOI marker
				if ( bytepos >= 0 ) {
					var fillbits = [];
					fillbits[1] = bytepos+1;
					fillbits[0] = (1<<(bytepos+1))-1;
					writeBits(fillbits);
				}
		
				writeWord(0xFFD9); //EOI

	      //return new Uint8Array(byteout);
	      return new Buffer(byteout);
		};
		
		function setQuality(quality){
			if (quality <= 0) {
				quality = 1;
			}
			if (quality > 100) {
				quality = 100;
			}
			
			if(currentQuality == quality) return // don't recalc if unchanged
			
			var sf = 0;
			if (quality < 50) {
				sf = Math.floor(5000 / quality);
			} else {
				sf = Math.floor(200 - quality*2);
			}
			
			initQuantTables(sf);
			currentQuality = quality;
			//console.log('Quality set to: '+quality +'%');
		}
		
		function init(){
			var time_start = new Date().getTime();
			if(!quality) quality = 50;
			// Create tables
			initCharLookupTable();
			initHuffmanTbl();
			initCategoryNumber();
			initRGBYUVTable();
			
			setQuality(quality);
			new Date().getTime() - time_start;
	    	//console.log('Initialization '+ duration + 'ms');
		}
		
		init();
		
	}	module.exports = encode;

	function encode(imgData, qu) {
	  if (typeof qu === 'undefined') qu = 50;
	  var encoder = new JPEGEncoder(qu);
		var data = encoder.encode(imgData, qu);
	  return {
	    data: data,
	    width: imgData.width,
	    height: imgData.height
	  };
	}

	}).call(this,require("buffer").Buffer);
	},{"buffer":16}],174:[function(require,module,exports){
	/**
	 * @license
	 * Copyright 2015 Mozilla Foundation
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *     http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	function loadURLasArrayBuffer(path, callback) {
	    if (path.indexOf("data:") === 0) {
	        var offset = path.indexOf("base64,") + 7;
	        var data = atob(path.substring(offset));
	        var arr = new Uint8Array(data.length);
	        for (var i = data.length - 1; i >= 0; i--) {
	            arr[i] = data.charCodeAt(i);
	        }
	        callback(arr.buffer);
	        return;
	    }
	    var xhr = new XMLHttpRequest();
	    xhr.open("GET", path, true);
	    xhr.responseType = "arraybuffer";
	    xhr.onload = function() {
	        callback(xhr.response);
	    };
	    xhr.send(null);
	}

	var JpegImage = function jpegImage() {
	    function JpegImage() {
	        this._src = null;
	        this._parser = new PDFJS.JpegImage();
	        this.onload = null;
	    }
	    JpegImage.prototype = {
	        get src() {
	            return this._src;
	        },
	        set src(value) {
	            this.load(value);
	        },
	        get width() {
	            return this._parser.width;
	        },
	        get height() {
	            return this._parser.height;
	        },
	        load: function load(path) {
	            this._src = path;
	            loadURLasArrayBuffer(path, function(buffer) {
	                this.parse(new Uint8Array(buffer));
	                if (this.onload) {
	                    this.onload();
	                }
	            }.bind(this));
	        },
	        parse: function(data) {
	            this._parser.parse(data);
	        },
	        getData: function(width, height) {
	            return this._parser.getData(width, height, false);
	        },
	        copyToImageData: function copyToImageData(imageData) {
	            if (this._parser.numComponents === 2 || this._parser.numComponents > 4) {
	                throw new Error("Unsupported amount of components");
	            }
	            var width = imageData.width, height = imageData.height;
	            var imageDataBytes = width * height * 4;
	            var imageDataArray = imageData.data;
	            var i, j;
	            if (this._parser.numComponents === 1) {
	                var values = this._parser.getData(width, height, false);
	                for (i = 0, j = 0; i < imageDataBytes; ) {
	                    var value = values[j++];
	                    imageDataArray[i++] = value;
	                    imageDataArray[i++] = value;
	                    imageDataArray[i++] = value;
	                    imageDataArray[i++] = 255;
	                }
	                return;
	            }
	            var rgb = this._parser.getData(width, height, true);
	            for (i = 0, j = 0; i < imageDataBytes; ) {
	                imageDataArray[i++] = rgb[j++];
	                imageDataArray[i++] = rgb[j++];
	                imageDataArray[i++] = rgb[j++];
	                imageDataArray[i++] = 255;
	            }
	        }
	    };
	    return JpegImage;
	}();

	var PDFJS;

	(function(PDFJS) {
	    var JpegImage = function jpegImage() {
	        var dctZigZag = new Uint8Array([ 0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63 ]);
	        var dctCos1 = 4017;
	        var dctSin1 = 799;
	        var dctCos3 = 3406;
	        var dctSin3 = 2276;
	        var dctCos6 = 1567;
	        var dctSin6 = 3784;
	        var dctSqrt2 = 5793;
	        var dctSqrt1d2 = 2896;
	        function constructor() {}
	        function buildHuffmanTable(codeLengths, values) {
	            var k = 0, code = [], i, j, length = 16;
	            while (length > 0 && !codeLengths[length - 1]) {
	                length--;
	            }
	            code.push({
	                children: [],
	                index: 0
	            });
	            var p = code[0], q;
	            for (i = 0; i < length; i++) {
	                for (j = 0; j < codeLengths[i]; j++) {
	                    p = code.pop();
	                    p.children[p.index] = values[k];
	                    while (p.index > 0) {
	                        p = code.pop();
	                    }
	                    p.index++;
	                    code.push(p);
	                    while (code.length <= i) {
	                        code.push(q = {
	                            children: [],
	                            index: 0
	                        });
	                        p.children[p.index] = q.children;
	                        p = q;
	                    }
	                    k++;
	                }
	                if (i + 1 < length) {
	                    code.push(q = {
	                        children: [],
	                        index: 0
	                    });
	                    p.children[p.index] = q.children;
	                    p = q;
	                }
	            }
	            return code[0].children;
	        }
	        function getBlockBufferOffset(component, row, col) {
	            return 64 * ((component.blocksPerLine + 1) * row + col);
	        }
	        function decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successivePrev, successive) {
	            frame.precision;
	            frame.samplesPerLine;
	            frame.scanLines;
	            var mcusPerLine = frame.mcusPerLine;
	            var progressive = frame.progressive;
	            frame.maxH; frame.maxV;
	            var startOffset = offset, bitsData = 0, bitsCount = 0;
	            function readBit() {
	                if (bitsCount > 0) {
	                    bitsCount--;
	                    return bitsData >> bitsCount & 1;
	                }
	                bitsData = data[offset++];
	                if (bitsData === 255) {
	                    var nextByte = data[offset++];
	                    if (nextByte) {
	                        throw "unexpected marker: " + (bitsData << 8 | nextByte).toString(16);
	                    }
	                }
	                bitsCount = 7;
	                return bitsData >>> 7;
	            }
	            function decodeHuffman(tree) {
	                var node = tree;
	                while (true) {
	                    node = node[readBit()];
	                    if (typeof node === "number") {
	                        return node;
	                    }
	                    if (typeof node !== "object") {
	                        throw "invalid huffman sequence";
	                    }
	                }
	            }
	            function receive(length) {
	                var n = 0;
	                while (length > 0) {
	                    n = n << 1 | readBit();
	                    length--;
	                }
	                return n;
	            }
	            function receiveAndExtend(length) {
	                if (length === 1) {
	                    return readBit() === 1 ? 1 : -1;
	                }
	                var n = receive(length);
	                if (n >= 1 << length - 1) {
	                    return n;
	                }
	                return n + (-1 << length) + 1;
	            }
	            function decodeBaseline(component, offset) {
	                var t = decodeHuffman(component.huffmanTableDC);
	                var diff = t === 0 ? 0 : receiveAndExtend(t);
	                component.blockData[offset] = component.pred += diff;
	                var k = 1;
	                while (k < 64) {
	                    var rs = decodeHuffman(component.huffmanTableAC);
	                    var s = rs & 15, r = rs >> 4;
	                    if (s === 0) {
	                        if (r < 15) {
	                            break;
	                        }
	                        k += 16;
	                        continue;
	                    }
	                    k += r;
	                    var z = dctZigZag[k];
	                    component.blockData[offset + z] = receiveAndExtend(s);
	                    k++;
	                }
	            }
	            function decodeDCFirst(component, offset) {
	                var t = decodeHuffman(component.huffmanTableDC);
	                var diff = t === 0 ? 0 : receiveAndExtend(t) << successive;
	                component.blockData[offset] = component.pred += diff;
	            }
	            function decodeDCSuccessive(component, offset) {
	                component.blockData[offset] |= readBit() << successive;
	            }
	            var eobrun = 0;
	            function decodeACFirst(component, offset) {
	                if (eobrun > 0) {
	                    eobrun--;
	                    return;
	                }
	                var k = spectralStart, e = spectralEnd;
	                while (k <= e) {
	                    var rs = decodeHuffman(component.huffmanTableAC);
	                    var s = rs & 15, r = rs >> 4;
	                    if (s === 0) {
	                        if (r < 15) {
	                            eobrun = receive(r) + (1 << r) - 1;
	                            break;
	                        }
	                        k += 16;
	                        continue;
	                    }
	                    k += r;
	                    var z = dctZigZag[k];
	                    component.blockData[offset + z] = receiveAndExtend(s) * (1 << successive);
	                    k++;
	                }
	            }
	            var successiveACState = 0, successiveACNextValue;
	            function decodeACSuccessive(component, offset) {
	                var k = spectralStart;
	                var e = spectralEnd;
	                var r = 0;
	                var s;
	                var rs;
	                while (k <= e) {
	                    var z = dctZigZag[k];
	                    switch (successiveACState) {
	                      case 0:
	                        rs = decodeHuffman(component.huffmanTableAC);
	                        s = rs & 15;
	                        r = rs >> 4;
	                        if (s === 0) {
	                            if (r < 15) {
	                                eobrun = receive(r) + (1 << r);
	                                successiveACState = 4;
	                            } else {
	                                r = 16;
	                                successiveACState = 1;
	                            }
	                        } else {
	                            if (s !== 1) {
	                                throw "invalid ACn encoding";
	                            }
	                            successiveACNextValue = receiveAndExtend(s);
	                            successiveACState = r ? 2 : 3;
	                        }
	                        continue;

	                      case 1:
	                      case 2:
	                        if (component.blockData[offset + z]) {
	                            component.blockData[offset + z] += readBit() << successive;
	                        } else {
	                            r--;
	                            if (r === 0) {
	                                successiveACState = successiveACState === 2 ? 3 : 0;
	                            }
	                        }
	                        break;

	                      case 3:
	                        if (component.blockData[offset + z]) {
	                            component.blockData[offset + z] += readBit() << successive;
	                        } else {
	                            component.blockData[offset + z] = successiveACNextValue << successive;
	                            successiveACState = 0;
	                        }
	                        break;

	                      case 4:
	                        if (component.blockData[offset + z]) {
	                            component.blockData[offset + z] += readBit() << successive;
	                        }
	                        break;
	                    }
	                    k++;
	                }
	                if (successiveACState === 4) {
	                    eobrun--;
	                    if (eobrun === 0) {
	                        successiveACState = 0;
	                    }
	                }
	            }
	            function decodeMcu(component, decode, mcu, row, col) {
	                var mcuRow = mcu / mcusPerLine | 0;
	                var mcuCol = mcu % mcusPerLine;
	                var blockRow = mcuRow * component.v + row;
	                var blockCol = mcuCol * component.h + col;
	                var offset = getBlockBufferOffset(component, blockRow, blockCol);
	                decode(component, offset);
	            }
	            function decodeBlock(component, decode, mcu) {
	                var blockRow = mcu / component.blocksPerLine | 0;
	                var blockCol = mcu % component.blocksPerLine;
	                var offset = getBlockBufferOffset(component, blockRow, blockCol);
	                decode(component, offset);
	            }
	            var componentsLength = components.length;
	            var component, i, j, k, n;
	            var decodeFn;
	            if (progressive) {
	                if (spectralStart === 0) {
	                    decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
	                } else {
	                    decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
	                }
	            } else {
	                decodeFn = decodeBaseline;
	            }
	            var mcu = 0, marker;
	            var mcuExpected;
	            if (componentsLength === 1) {
	                mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
	            } else {
	                mcuExpected = mcusPerLine * frame.mcusPerColumn;
	            }
	            if (!resetInterval) {
	                resetInterval = mcuExpected;
	            }
	            var h, v;
	            while (mcu < mcuExpected) {
	                for (i = 0; i < componentsLength; i++) {
	                    components[i].pred = 0;
	                }
	                eobrun = 0;
	                if (componentsLength === 1) {
	                    component = components[0];
	                    for (n = 0; n < resetInterval; n++) {
	                        decodeBlock(component, decodeFn, mcu);
	                        mcu++;
	                    }
	                } else {
	                    for (n = 0; n < resetInterval; n++) {
	                        for (i = 0; i < componentsLength; i++) {
	                            component = components[i];
	                            h = component.h;
	                            v = component.v;
	                            for (j = 0; j < v; j++) {
	                                for (k = 0; k < h; k++) {
	                                    decodeMcu(component, decodeFn, mcu, j, k);
	                                }
	                            }
	                        }
	                        mcu++;
	                    }
	                }
	                bitsCount = 0;
	                marker = data[offset] << 8 | data[offset + 1];
	                if (marker <= 65280) {
	                    throw "marker was not found";
	                }
	                if (marker >= 65488 && marker <= 65495) {
	                    offset += 2;
	                } else {
	                    break;
	                }
	            }
	            return offset - startOffset;
	        }
	        function quantizeAndInverse(component, blockBufferOffset, p) {
	            var qt = component.quantizationTable, blockData = component.blockData;
	            var v0, v1, v2, v3, v4, v5, v6, v7;
	            var p0, p1, p2, p3, p4, p5, p6, p7;
	            var t;
	            for (var row = 0; row < 64; row += 8) {
	                p0 = blockData[blockBufferOffset + row];
	                p1 = blockData[blockBufferOffset + row + 1];
	                p2 = blockData[blockBufferOffset + row + 2];
	                p3 = blockData[blockBufferOffset + row + 3];
	                p4 = blockData[blockBufferOffset + row + 4];
	                p5 = blockData[blockBufferOffset + row + 5];
	                p6 = blockData[blockBufferOffset + row + 6];
	                p7 = blockData[blockBufferOffset + row + 7];
	                p0 *= qt[row];
	                if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
	                    t = dctSqrt2 * p0 + 512 >> 10;
	                    p[row] = t;
	                    p[row + 1] = t;
	                    p[row + 2] = t;
	                    p[row + 3] = t;
	                    p[row + 4] = t;
	                    p[row + 5] = t;
	                    p[row + 6] = t;
	                    p[row + 7] = t;
	                    continue;
	                }
	                p1 *= qt[row + 1];
	                p2 *= qt[row + 2];
	                p3 *= qt[row + 3];
	                p4 *= qt[row + 4];
	                p5 *= qt[row + 5];
	                p6 *= qt[row + 6];
	                p7 *= qt[row + 7];
	                v0 = dctSqrt2 * p0 + 128 >> 8;
	                v1 = dctSqrt2 * p4 + 128 >> 8;
	                v2 = p2;
	                v3 = p6;
	                v4 = dctSqrt1d2 * (p1 - p7) + 128 >> 8;
	                v7 = dctSqrt1d2 * (p1 + p7) + 128 >> 8;
	                v5 = p3 << 4;
	                v6 = p5 << 4;
	                v0 = v0 + v1 + 1 >> 1;
	                v1 = v0 - v1;
	                t = v2 * dctSin6 + v3 * dctCos6 + 128 >> 8;
	                v2 = v2 * dctCos6 - v3 * dctSin6 + 128 >> 8;
	                v3 = t;
	                v4 = v4 + v6 + 1 >> 1;
	                v6 = v4 - v6;
	                v7 = v7 + v5 + 1 >> 1;
	                v5 = v7 - v5;
	                v0 = v0 + v3 + 1 >> 1;
	                v3 = v0 - v3;
	                v1 = v1 + v2 + 1 >> 1;
	                v2 = v1 - v2;
	                t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
	                v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
	                v7 = t;
	                t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
	                v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
	                v6 = t;
	                p[row] = v0 + v7;
	                p[row + 7] = v0 - v7;
	                p[row + 1] = v1 + v6;
	                p[row + 6] = v1 - v6;
	                p[row + 2] = v2 + v5;
	                p[row + 5] = v2 - v5;
	                p[row + 3] = v3 + v4;
	                p[row + 4] = v3 - v4;
	            }
	            for (var col = 0; col < 8; ++col) {
	                p0 = p[col];
	                p1 = p[col + 8];
	                p2 = p[col + 16];
	                p3 = p[col + 24];
	                p4 = p[col + 32];
	                p5 = p[col + 40];
	                p6 = p[col + 48];
	                p7 = p[col + 56];
	                if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
	                    t = dctSqrt2 * p0 + 8192 >> 14;
	                    t = t < -2040 ? 0 : t >= 2024 ? 255 : t + 2056 >> 4;
	                    blockData[blockBufferOffset + col] = t;
	                    blockData[blockBufferOffset + col + 8] = t;
	                    blockData[blockBufferOffset + col + 16] = t;
	                    blockData[blockBufferOffset + col + 24] = t;
	                    blockData[blockBufferOffset + col + 32] = t;
	                    blockData[blockBufferOffset + col + 40] = t;
	                    blockData[blockBufferOffset + col + 48] = t;
	                    blockData[blockBufferOffset + col + 56] = t;
	                    continue;
	                }
	                v0 = dctSqrt2 * p0 + 2048 >> 12;
	                v1 = dctSqrt2 * p4 + 2048 >> 12;
	                v2 = p2;
	                v3 = p6;
	                v4 = dctSqrt1d2 * (p1 - p7) + 2048 >> 12;
	                v7 = dctSqrt1d2 * (p1 + p7) + 2048 >> 12;
	                v5 = p3;
	                v6 = p5;
	                v0 = (v0 + v1 + 1 >> 1) + 4112;
	                v1 = v0 - v1;
	                t = v2 * dctSin6 + v3 * dctCos6 + 2048 >> 12;
	                v2 = v2 * dctCos6 - v3 * dctSin6 + 2048 >> 12;
	                v3 = t;
	                v4 = v4 + v6 + 1 >> 1;
	                v6 = v4 - v6;
	                v7 = v7 + v5 + 1 >> 1;
	                v5 = v7 - v5;
	                v0 = v0 + v3 + 1 >> 1;
	                v3 = v0 - v3;
	                v1 = v1 + v2 + 1 >> 1;
	                v2 = v1 - v2;
	                t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
	                v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
	                v7 = t;
	                t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
	                v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
	                v6 = t;
	                p0 = v0 + v7;
	                p7 = v0 - v7;
	                p1 = v1 + v6;
	                p6 = v1 - v6;
	                p2 = v2 + v5;
	                p5 = v2 - v5;
	                p3 = v3 + v4;
	                p4 = v3 - v4;
	                p0 = p0 < 16 ? 0 : p0 >= 4080 ? 255 : p0 >> 4;
	                p1 = p1 < 16 ? 0 : p1 >= 4080 ? 255 : p1 >> 4;
	                p2 = p2 < 16 ? 0 : p2 >= 4080 ? 255 : p2 >> 4;
	                p3 = p3 < 16 ? 0 : p3 >= 4080 ? 255 : p3 >> 4;
	                p4 = p4 < 16 ? 0 : p4 >= 4080 ? 255 : p4 >> 4;
	                p5 = p5 < 16 ? 0 : p5 >= 4080 ? 255 : p5 >> 4;
	                p6 = p6 < 16 ? 0 : p6 >= 4080 ? 255 : p6 >> 4;
	                p7 = p7 < 16 ? 0 : p7 >= 4080 ? 255 : p7 >> 4;
	                blockData[blockBufferOffset + col] = p0;
	                blockData[blockBufferOffset + col + 8] = p1;
	                blockData[blockBufferOffset + col + 16] = p2;
	                blockData[blockBufferOffset + col + 24] = p3;
	                blockData[blockBufferOffset + col + 32] = p4;
	                blockData[blockBufferOffset + col + 40] = p5;
	                blockData[blockBufferOffset + col + 48] = p6;
	                blockData[blockBufferOffset + col + 56] = p7;
	            }
	        }
	        function buildComponentData(frame, component) {
	            var blocksPerLine = component.blocksPerLine;
	            var blocksPerColumn = component.blocksPerColumn;
	            var computationBuffer = new Int16Array(64);
	            for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
	                for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
	                    var offset = getBlockBufferOffset(component, blockRow, blockCol);
	                    quantizeAndInverse(component, offset, computationBuffer);
	                }
	            }
	            return component.blockData;
	        }
	        function clamp0to255(a) {
	            return a <= 0 ? 0 : a >= 255 ? 255 : a;
	        }
	        constructor.prototype = {
	            parse: function parse(data) {
	                function readUint16() {
	                    var value = data[offset] << 8 | data[offset + 1];
	                    offset += 2;
	                    return value;
	                }
	                function readDataBlock() {
	                    var length = readUint16();
	                    var array = data.subarray(offset, offset + length - 2);
	                    offset += array.length;
	                    return array;
	                }
	                function prepareComponents(frame) {
	                    var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / frame.maxH);
	                    var mcusPerColumn = Math.ceil(frame.scanLines / 8 / frame.maxV);
	                    for (var i = 0; i < frame.components.length; i++) {
	                        component = frame.components[i];
	                        var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / frame.maxH);
	                        var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines / 8) * component.v / frame.maxV);
	                        var blocksPerLineForMcu = mcusPerLine * component.h;
	                        var blocksPerColumnForMcu = mcusPerColumn * component.v;
	                        var blocksBufferSize = 64 * blocksPerColumnForMcu * (blocksPerLineForMcu + 1);
	                        component.blockData = new Int16Array(blocksBufferSize);
	                        component.blocksPerLine = blocksPerLine;
	                        component.blocksPerColumn = blocksPerColumn;
	                    }
	                    frame.mcusPerLine = mcusPerLine;
	                    frame.mcusPerColumn = mcusPerColumn;
	                }
	                var offset = 0; data.length;
	                var jfif = null;
	                var adobe = null;
	                var frame, resetInterval;
	                var quantizationTables = [];
	                var huffmanTablesAC = [], huffmanTablesDC = [];
	                var fileMarker = readUint16();
	                if (fileMarker !== 65496) {
	                    throw "SOI not found";
	                }
	                fileMarker = readUint16();
	                while (fileMarker !== 65497) {
	                    var i, j, l;
	                    switch (fileMarker) {
	                      case 65504:
	                      case 65505:
	                      case 65506:
	                      case 65507:
	                      case 65508:
	                      case 65509:
	                      case 65510:
	                      case 65511:
	                      case 65512:
	                      case 65513:
	                      case 65514:
	                      case 65515:
	                      case 65516:
	                      case 65517:
	                      case 65518:
	                      case 65519:
	                      case 65534:
	                        var appData = readDataBlock();
	                        if (fileMarker === 65504) {
	                            if (appData[0] === 74 && appData[1] === 70 && appData[2] === 73 && appData[3] === 70 && appData[4] === 0) {
	                                jfif = {
	                                    version: {
	                                        major: appData[5],
	                                        minor: appData[6]
	                                    },
	                                    densityUnits: appData[7],
	                                    xDensity: appData[8] << 8 | appData[9],
	                                    yDensity: appData[10] << 8 | appData[11],
	                                    thumbWidth: appData[12],
	                                    thumbHeight: appData[13],
	                                    thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
	                                };
	                            }
	                        }
	                        if (fileMarker === 65518) {
	                            if (appData[0] === 65 && appData[1] === 100 && appData[2] === 111 && appData[3] === 98 && appData[4] === 101 && appData[5] === 0) {
	                                adobe = {
	                                    version: appData[6],
	                                    flags0: appData[7] << 8 | appData[8],
	                                    flags1: appData[9] << 8 | appData[10],
	                                    transformCode: appData[11]
	                                };
	                            }
	                        }
	                        break;

	                      case 65499:
	                        var quantizationTablesLength = readUint16();
	                        var quantizationTablesEnd = quantizationTablesLength + offset - 2;
	                        var z;
	                        while (offset < quantizationTablesEnd) {
	                            var quantizationTableSpec = data[offset++];
	                            var tableData = new Uint16Array(64);
	                            if (quantizationTableSpec >> 4 === 0) {
	                                for (j = 0; j < 64; j++) {
	                                    z = dctZigZag[j];
	                                    tableData[z] = data[offset++];
	                                }
	                            } else if (quantizationTableSpec >> 4 === 1) {
	                                for (j = 0; j < 64; j++) {
	                                    z = dctZigZag[j];
	                                    tableData[z] = readUint16();
	                                }
	                            } else {
	                                throw "DQT: invalid table spec";
	                            }
	                            quantizationTables[quantizationTableSpec & 15] = tableData;
	                        }
	                        break;

	                      case 65472:
	                      case 65473:
	                      case 65474:
	                        if (frame) {
	                            throw "Only single frame JPEGs supported";
	                        }
	                        readUint16();
	                        frame = {};
	                        frame.extended = fileMarker === 65473;
	                        frame.progressive = fileMarker === 65474;
	                        frame.precision = data[offset++];
	                        frame.scanLines = readUint16();
	                        frame.samplesPerLine = readUint16();
	                        frame.components = [];
	                        frame.componentIds = {};
	                        var componentsCount = data[offset++], componentId;
	                        var maxH = 0, maxV = 0;
	                        for (i = 0; i < componentsCount; i++) {
	                            componentId = data[offset];
	                            var h = data[offset + 1] >> 4;
	                            var v = data[offset + 1] & 15;
	                            if (maxH < h) {
	                                maxH = h;
	                            }
	                            if (maxV < v) {
	                                maxV = v;
	                            }
	                            var qId = data[offset + 2];
	                            l = frame.components.push({
	                                h: h,
	                                v: v,
	                                quantizationTable: quantizationTables[qId]
	                            });
	                            frame.componentIds[componentId] = l - 1;
	                            offset += 3;
	                        }
	                        frame.maxH = maxH;
	                        frame.maxV = maxV;
	                        prepareComponents(frame);
	                        break;

	                      case 65476:
	                        var huffmanLength = readUint16();
	                        for (i = 2; i < huffmanLength; ) {
	                            var huffmanTableSpec = data[offset++];
	                            var codeLengths = new Uint8Array(16);
	                            var codeLengthSum = 0;
	                            for (j = 0; j < 16; j++, offset++) {
	                                codeLengthSum += codeLengths[j] = data[offset];
	                            }
	                            var huffmanValues = new Uint8Array(codeLengthSum);
	                            for (j = 0; j < codeLengthSum; j++, offset++) {
	                                huffmanValues[j] = data[offset];
	                            }
	                            i += 17 + codeLengthSum;
	                            (huffmanTableSpec >> 4 === 0 ? huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] = buildHuffmanTable(codeLengths, huffmanValues);
	                        }
	                        break;

	                      case 65501:
	                        readUint16();
	                        resetInterval = readUint16();
	                        break;

	                      case 65498:
	                        readUint16();
	                        var selectorsCount = data[offset++];
	                        var components = [], component;
	                        for (i = 0; i < selectorsCount; i++) {
	                            var componentIndex = frame.componentIds[data[offset++]];
	                            component = frame.components[componentIndex];
	                            var tableSpec = data[offset++];
	                            component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
	                            component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
	                            components.push(component);
	                        }
	                        var spectralStart = data[offset++];
	                        var spectralEnd = data[offset++];
	                        var successiveApproximation = data[offset++];
	                        var processed = decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successiveApproximation >> 4, successiveApproximation & 15);
	                        offset += processed;
	                        break;

	                      case 65535:
	                        if (data[offset] !== 255) {
	                            offset--;
	                        }
	                        break;

	                      default:
	                        if (data[offset - 3] === 255 && data[offset - 2] >= 192 && data[offset - 2] <= 254) {
	                            offset -= 3;
	                            break;
	                        }
	                        throw "unknown JPEG marker " + fileMarker.toString(16);
	                    }
	                    fileMarker = readUint16();
	                }
	                this.width = frame.samplesPerLine;
	                this.height = frame.scanLines;
	                this.jfif = jfif;
	                this.adobe = adobe;
	                this.components = [];
	                for (i = 0; i < frame.components.length; i++) {
	                    component = frame.components[i];
	                    this.components.push({
	                        output: buildComponentData(frame, component),
	                        scaleX: component.h / frame.maxH,
	                        scaleY: component.v / frame.maxV,
	                        blocksPerLine: component.blocksPerLine,
	                        blocksPerColumn: component.blocksPerColumn
	                    });
	                }
	                this.numComponents = this.components.length;
	            },
	            _getLinearizedBlockData: function getLinearizedBlockData(width, height) {
	                var scaleX = this.width / width, scaleY = this.height / height;
	                var component, componentScaleX, componentScaleY, blocksPerScanline;
	                var x, y, i, j, k;
	                var index;
	                var offset = 0;
	                var output;
	                var numComponents = this.components.length;
	                var dataLength = width * height * numComponents;
	                var data = new Uint8Array(dataLength);
	                var xScaleBlockOffset = new Uint32Array(width);
	                var mask3LSB = 4294967288;
	                for (i = 0; i < numComponents; i++) {
	                    component = this.components[i];
	                    componentScaleX = component.scaleX * scaleX;
	                    componentScaleY = component.scaleY * scaleY;
	                    offset = i;
	                    output = component.output;
	                    blocksPerScanline = component.blocksPerLine + 1 << 3;
	                    for (x = 0; x < width; x++) {
	                        j = 0 | x * componentScaleX;
	                        xScaleBlockOffset[x] = (j & mask3LSB) << 3 | j & 7;
	                    }
	                    for (y = 0; y < height; y++) {
	                        j = 0 | y * componentScaleY;
	                        index = blocksPerScanline * (j & mask3LSB) | (j & 7) << 3;
	                        for (x = 0; x < width; x++) {
	                            data[offset] = output[index + xScaleBlockOffset[x]];
	                            offset += numComponents;
	                        }
	                    }
	                }
	                var transform = this.decodeTransform;
	                if (transform) {
	                    for (i = 0; i < dataLength; ) {
	                        for (j = 0, k = 0; j < numComponents; j++, i++, k += 2) {
	                            data[i] = (data[i] * transform[k] >> 8) + transform[k + 1];
	                        }
	                    }
	                }
	                return data;
	            },
	            _isColorConversionNeeded: function isColorConversionNeeded() {
	                if (this.adobe && this.adobe.transformCode) {
	                    return true;
	                } else if (this.numComponents === 3) {
	                    return true;
	                } else {
	                    return false;
	                }
	            },
	            _convertYccToRgb: function convertYccToRgb(data) {
	                var Y, Cb, Cr;
	                for (var i = 0, length = data.length; i < length; i += 3) {
	                    Y = data[i];
	                    Cb = data[i + 1];
	                    Cr = data[i + 2];
	                    data[i] = clamp0to255(Y - 179.456 + 1.402 * Cr);
	                    data[i + 1] = clamp0to255(Y + 135.459 - .344 * Cb - .714 * Cr);
	                    data[i + 2] = clamp0to255(Y - 226.816 + 1.772 * Cb);
	                }
	                return data;
	            },
	            _convertYcckToRgb: function convertYcckToRgb(data) {
	                var Y, Cb, Cr, k;
	                var offset = 0;
	                for (var i = 0, length = data.length; i < length; i += 4) {
	                    Y = data[i];
	                    Cb = data[i + 1];
	                    Cr = data[i + 2];
	                    k = data[i + 3];
	                    var r = -122.67195406894 + Cb * (-660635669420364e-19 * Cb + .000437130475926232 * Cr - 54080610064599e-18 * Y + .00048449797120281 * k - .154362151871126) + Cr * (-.000957964378445773 * Cr + .000817076911346625 * Y - .00477271405408747 * k + 1.53380253221734) + Y * (.000961250184130688 * Y - .00266257332283933 * k + .48357088451265) + k * (-.000336197177618394 * k + .484791561490776);
	                    var g = 107.268039397724 + Cb * (219927104525741e-19 * Cb - .000640992018297945 * Cr + .000659397001245577 * Y + .000426105652938837 * k - .176491792462875) + Cr * (-.000778269941513683 * Cr + .00130872261408275 * Y + .000770482631801132 * k - .151051492775562) + Y * (.00126935368114843 * Y - .00265090189010898 * k + .25802910206845) + k * (-.000318913117588328 * k - .213742400323665);
	                    var b = -20.810012546947 + Cb * (-.000570115196973677 * Cb - 263409051004589e-19 * Cr + .0020741088115012 * Y - .00288260236853442 * k + .814272968359295) + Cr * (-153496057440975e-19 * Cr - .000132689043961446 * Y + .000560833691242812 * k - .195152027534049) + Y * (.00174418132927582 * Y - .00255243321439347 * k + .116935020465145) + k * (-.000343531996510555 * k + .24165260232407);
	                    data[offset++] = clamp0to255(r);
	                    data[offset++] = clamp0to255(g);
	                    data[offset++] = clamp0to255(b);
	                }
	                return data;
	            },
	            _convertYcckToCmyk: function convertYcckToCmyk(data) {
	                var Y, Cb, Cr;
	                for (var i = 0, length = data.length; i < length; i += 4) {
	                    Y = data[i];
	                    Cb = data[i + 1];
	                    Cr = data[i + 2];
	                    data[i] = clamp0to255(434.456 - Y - 1.402 * Cr);
	                    data[i + 1] = clamp0to255(119.541 - Y + .344 * Cb + .714 * Cr);
	                    data[i + 2] = clamp0to255(481.816 - Y - 1.772 * Cb);
	                }
	                return data;
	            },
	            _convertCmykToRgb: function convertCmykToRgb(data) {
	                var c, m, y, k;
	                var offset = 0;
	                var min = -255 * 255 * 255;
	                var scale = 1 / 255 / 255;
	                for (var i = 0, length = data.length; i < length; i += 4) {
	                    c = data[i];
	                    m = data[i + 1];
	                    y = data[i + 2];
	                    k = data[i + 3];
	                    var r = c * (-4.387332384609988 * c + 54.48615194189176 * m + 18.82290502165302 * y + 212.25662451639585 * k - 72734.4411664936) + m * (1.7149763477362134 * m - 5.6096736904047315 * y - 17.873870861415444 * k - 1401.7366389350734) + y * (-2.5217340131683033 * y - 21.248923337353073 * k + 4465.541406466231) - k * (21.86122147463605 * k + 48317.86113160301);
	                    var g = c * (8.841041422036149 * c + 60.118027045597366 * m + 6.871425592049007 * y + 31.159100130055922 * k - 20220.756542821975) + m * (-15.310361306967817 * m + 17.575251261109482 * y + 131.35250912493976 * k - 48691.05921601825) + y * (4.444339102852739 * y + 9.8632861493405 * k - 6341.191035517494) - k * (20.737325471181034 * k + 47890.15695978492);
	                    var b = c * (.8842522430003296 * c + 8.078677503112928 * m + 30.89978309703729 * y - .23883238689178934 * k - 3616.812083916688) + m * (10.49593273432072 * m + 63.02378494754052 * y + 50.606957656360734 * k - 28620.90484698408) + y * (.03296041114873217 * y + 115.60384449646641 * k - 49363.43385999684) - k * (22.33816807309886 * k + 45932.16563550634);
	                    data[offset++] = r >= 0 ? 255 : r <= min ? 0 : 255 + r * scale | 0;
	                    data[offset++] = g >= 0 ? 255 : g <= min ? 0 : 255 + g * scale | 0;
	                    data[offset++] = b >= 0 ? 255 : b <= min ? 0 : 255 + b * scale | 0;
	                }
	                return data;
	            },
	            getData: function getData(width, height, forceRGBoutput) {
	                if (this.numComponents > 4) {
	                    throw "Unsupported color mode";
	                }
	                var data = this._getLinearizedBlockData(width, height);
	                if (this.numComponents === 3) {
	                    return this._convertYccToRgb(data);
	                } else if (this.numComponents === 4) {
	                    if (this._isColorConversionNeeded()) {
	                        if (forceRGBoutput) {
	                            return this._convertYcckToRgb(data);
	                        } else {
	                            return this._convertYcckToCmyk(data);
	                        }
	                    } else if (forceRGBoutput) {
	                        return this._convertCmykToRgb(data);
	                    }
	                }
	                return data;
	            }
	        };
	        return constructor;
	    }();
	    var ArithmeticDecoder = function ArithmeticDecoderClosure() {
	        var QeTable = [ {
	            qe: 22017,
	            nmps: 1,
	            nlps: 1,
	            switchFlag: 1
	        }, {
	            qe: 13313,
	            nmps: 2,
	            nlps: 6,
	            switchFlag: 0
	        }, {
	            qe: 6145,
	            nmps: 3,
	            nlps: 9,
	            switchFlag: 0
	        }, {
	            qe: 2753,
	            nmps: 4,
	            nlps: 12,
	            switchFlag: 0
	        }, {
	            qe: 1313,
	            nmps: 5,
	            nlps: 29,
	            switchFlag: 0
	        }, {
	            qe: 545,
	            nmps: 38,
	            nlps: 33,
	            switchFlag: 0
	        }, {
	            qe: 22017,
	            nmps: 7,
	            nlps: 6,
	            switchFlag: 1
	        }, {
	            qe: 21505,
	            nmps: 8,
	            nlps: 14,
	            switchFlag: 0
	        }, {
	            qe: 18433,
	            nmps: 9,
	            nlps: 14,
	            switchFlag: 0
	        }, {
	            qe: 14337,
	            nmps: 10,
	            nlps: 14,
	            switchFlag: 0
	        }, {
	            qe: 12289,
	            nmps: 11,
	            nlps: 17,
	            switchFlag: 0
	        }, {
	            qe: 9217,
	            nmps: 12,
	            nlps: 18,
	            switchFlag: 0
	        }, {
	            qe: 7169,
	            nmps: 13,
	            nlps: 20,
	            switchFlag: 0
	        }, {
	            qe: 5633,
	            nmps: 29,
	            nlps: 21,
	            switchFlag: 0
	        }, {
	            qe: 22017,
	            nmps: 15,
	            nlps: 14,
	            switchFlag: 1
	        }, {
	            qe: 21505,
	            nmps: 16,
	            nlps: 14,
	            switchFlag: 0
	        }, {
	            qe: 20737,
	            nmps: 17,
	            nlps: 15,
	            switchFlag: 0
	        }, {
	            qe: 18433,
	            nmps: 18,
	            nlps: 16,
	            switchFlag: 0
	        }, {
	            qe: 14337,
	            nmps: 19,
	            nlps: 17,
	            switchFlag: 0
	        }, {
	            qe: 13313,
	            nmps: 20,
	            nlps: 18,
	            switchFlag: 0
	        }, {
	            qe: 12289,
	            nmps: 21,
	            nlps: 19,
	            switchFlag: 0
	        }, {
	            qe: 10241,
	            nmps: 22,
	            nlps: 19,
	            switchFlag: 0
	        }, {
	            qe: 9217,
	            nmps: 23,
	            nlps: 20,
	            switchFlag: 0
	        }, {
	            qe: 8705,
	            nmps: 24,
	            nlps: 21,
	            switchFlag: 0
	        }, {
	            qe: 7169,
	            nmps: 25,
	            nlps: 22,
	            switchFlag: 0
	        }, {
	            qe: 6145,
	            nmps: 26,
	            nlps: 23,
	            switchFlag: 0
	        }, {
	            qe: 5633,
	            nmps: 27,
	            nlps: 24,
	            switchFlag: 0
	        }, {
	            qe: 5121,
	            nmps: 28,
	            nlps: 25,
	            switchFlag: 0
	        }, {
	            qe: 4609,
	            nmps: 29,
	            nlps: 26,
	            switchFlag: 0
	        }, {
	            qe: 4353,
	            nmps: 30,
	            nlps: 27,
	            switchFlag: 0
	        }, {
	            qe: 2753,
	            nmps: 31,
	            nlps: 28,
	            switchFlag: 0
	        }, {
	            qe: 2497,
	            nmps: 32,
	            nlps: 29,
	            switchFlag: 0
	        }, {
	            qe: 2209,
	            nmps: 33,
	            nlps: 30,
	            switchFlag: 0
	        }, {
	            qe: 1313,
	            nmps: 34,
	            nlps: 31,
	            switchFlag: 0
	        }, {
	            qe: 1089,
	            nmps: 35,
	            nlps: 32,
	            switchFlag: 0
	        }, {
	            qe: 673,
	            nmps: 36,
	            nlps: 33,
	            switchFlag: 0
	        }, {
	            qe: 545,
	            nmps: 37,
	            nlps: 34,
	            switchFlag: 0
	        }, {
	            qe: 321,
	            nmps: 38,
	            nlps: 35,
	            switchFlag: 0
	        }, {
	            qe: 273,
	            nmps: 39,
	            nlps: 36,
	            switchFlag: 0
	        }, {
	            qe: 133,
	            nmps: 40,
	            nlps: 37,
	            switchFlag: 0
	        }, {
	            qe: 73,
	            nmps: 41,
	            nlps: 38,
	            switchFlag: 0
	        }, {
	            qe: 37,
	            nmps: 42,
	            nlps: 39,
	            switchFlag: 0
	        }, {
	            qe: 21,
	            nmps: 43,
	            nlps: 40,
	            switchFlag: 0
	        }, {
	            qe: 9,
	            nmps: 44,
	            nlps: 41,
	            switchFlag: 0
	        }, {
	            qe: 5,
	            nmps: 45,
	            nlps: 42,
	            switchFlag: 0
	        }, {
	            qe: 1,
	            nmps: 45,
	            nlps: 43,
	            switchFlag: 0
	        }, {
	            qe: 22017,
	            nmps: 46,
	            nlps: 46,
	            switchFlag: 0
	        } ];
	        function ArithmeticDecoder(data, start, end) {
	            this.data = data;
	            this.bp = start;
	            this.dataEnd = end;
	            this.chigh = data[start];
	            this.clow = 0;
	            this.byteIn();
	            this.chigh = this.chigh << 7 & 65535 | this.clow >> 9 & 127;
	            this.clow = this.clow << 7 & 65535;
	            this.ct -= 7;
	            this.a = 32768;
	        }
	        ArithmeticDecoder.prototype = {
	            byteIn: function ArithmeticDecoder_byteIn() {
	                var data = this.data;
	                var bp = this.bp;
	                if (data[bp] === 255) {
	                    var b1 = data[bp + 1];
	                    if (b1 > 143) {
	                        this.clow += 65280;
	                        this.ct = 8;
	                    } else {
	                        bp++;
	                        this.clow += data[bp] << 9;
	                        this.ct = 7;
	                        this.bp = bp;
	                    }
	                } else {
	                    bp++;
	                    this.clow += bp < this.dataEnd ? data[bp] << 8 : 65280;
	                    this.ct = 8;
	                    this.bp = bp;
	                }
	                if (this.clow > 65535) {
	                    this.chigh += this.clow >> 16;
	                    this.clow &= 65535;
	                }
	            },
	            readBit: function ArithmeticDecoder_readBit(contexts, pos) {
	                var cx_index = contexts[pos] >> 1, cx_mps = contexts[pos] & 1;
	                var qeTableIcx = QeTable[cx_index];
	                var qeIcx = qeTableIcx.qe;
	                var d;
	                var a = this.a - qeIcx;
	                if (this.chigh < qeIcx) {
	                    if (a < qeIcx) {
	                        a = qeIcx;
	                        d = cx_mps;
	                        cx_index = qeTableIcx.nmps;
	                    } else {
	                        a = qeIcx;
	                        d = 1 ^ cx_mps;
	                        if (qeTableIcx.switchFlag === 1) {
	                            cx_mps = d;
	                        }
	                        cx_index = qeTableIcx.nlps;
	                    }
	                } else {
	                    this.chigh -= qeIcx;
	                    if ((a & 32768) !== 0) {
	                        this.a = a;
	                        return cx_mps;
	                    }
	                    if (a < qeIcx) {
	                        d = 1 ^ cx_mps;
	                        if (qeTableIcx.switchFlag === 1) {
	                            cx_mps = d;
	                        }
	                        cx_index = qeTableIcx.nlps;
	                    } else {
	                        d = cx_mps;
	                        cx_index = qeTableIcx.nmps;
	                    }
	                }
	                do {
	                    if (this.ct === 0) {
	                        this.byteIn();
	                    }
	                    a <<= 1;
	                    this.chigh = this.chigh << 1 & 65535 | this.clow >> 15 & 1;
	                    this.clow = this.clow << 1 & 65535;
	                    this.ct--;
	                } while ((a & 32768) === 0);
	                this.a = a;
	                contexts[pos] = cx_index << 1 | cx_mps;
	                return d;
	            }
	        };
	        return ArithmeticDecoder;
	    }();
	    var JpxImage = function JpxImageClosure() {
	        var SubbandsGainLog2 = {
	            LL: 0,
	            LH: 1,
	            HL: 1,
	            HH: 2
	        };
	        function JpxImage() {
	            this.failOnCorruptedImage = false;
	        }
	        JpxImage.prototype = {
	            parse: function JpxImage_parse(data) {
	                var head = readUint16(data, 0);
	                if (head === 65359) {
	                    this.parseCodestream(data, 0, data.length);
	                    return;
	                }
	                var position = 0, length = data.length;
	                while (position < length) {
	                    var headerSize = 8;
	                    var lbox = readUint32(data, position);
	                    var tbox = readUint32(data, position + 4);
	                    position += headerSize;
	                    if (lbox === 1) {
	                        lbox = readUint32(data, position) * 4294967296 + readUint32(data, position + 4);
	                        position += 8;
	                        headerSize += 8;
	                    }
	                    if (lbox === 0) {
	                        lbox = length - position + headerSize;
	                    }
	                    if (lbox < headerSize) {
	                        throw new Error("JPX Error: Invalid box field size");
	                    }
	                    var dataLength = lbox - headerSize;
	                    var jumpDataLength = true;
	                    switch (tbox) {
	                      case 1785737832:
	                        jumpDataLength = false;
	                        break;

	                      case 1668246642:
	                        var method = data[position];
	                        data[position + 1];
	                        data[position + 2];
	                        if (method === 1) {
	                            var colorspace = readUint32(data, position + 3);
	                            switch (colorspace) {
	                              case 16:
	                              case 17:
	                              case 18:
	                                break;

	                              default:
	                                warn("Unknown colorspace " + colorspace);
	                                break;
	                            }
	                        } else if (method === 2) {
	                            info("ICC profile not supported");
	                        }
	                        break;

	                      case 1785737827:
	                        this.parseCodestream(data, position, position + dataLength);
	                        break;

	                      case 1783636e3:
	                        if (218793738 !== readUint32(data, position)) {
	                            warn("Invalid JP2 signature");
	                        }
	                        break;

	                      case 1783634458:
	                      case 1718909296:
	                      case 1920099697:
	                      case 1919251232:
	                      case 1768449138:
	                        break;

	                      default:
	                        var headerType = String.fromCharCode(tbox >> 24 & 255, tbox >> 16 & 255, tbox >> 8 & 255, tbox & 255);
	                        warn("Unsupported header type " + tbox + " (" + headerType + ")");
	                        break;
	                    }
	                    if (jumpDataLength) {
	                        position += dataLength;
	                    }
	                }
	            },
	            parseImageProperties: function JpxImage_parseImageProperties(stream) {
	                var newByte = stream.getByte();
	                while (newByte >= 0) {
	                    var oldByte = newByte;
	                    newByte = stream.getByte();
	                    var code = oldByte << 8 | newByte;
	                    if (code === 65361) {
	                        stream.skip(4);
	                        var Xsiz = stream.getInt32() >>> 0;
	                        var Ysiz = stream.getInt32() >>> 0;
	                        var XOsiz = stream.getInt32() >>> 0;
	                        var YOsiz = stream.getInt32() >>> 0;
	                        stream.skip(16);
	                        var Csiz = stream.getUint16();
	                        this.width = Xsiz - XOsiz;
	                        this.height = Ysiz - YOsiz;
	                        this.componentsCount = Csiz;
	                        this.bitsPerComponent = 8;
	                        return;
	                    }
	                }
	                throw new Error("JPX Error: No size marker found in JPX stream");
	            },
	            parseCodestream: function JpxImage_parseCodestream(data, start, end) {
	                var context = {};
	                try {
	                    var doNotRecover = false;
	                    var position = start;
	                    while (position + 1 < end) {
	                        var code = readUint16(data, position);
	                        position += 2;
	                        var length = 0, j, sqcd, spqcds, spqcdSize, scalarExpounded, tile;
	                        switch (code) {
	                          case 65359:
	                            context.mainHeader = true;
	                            break;

	                          case 65497:
	                            break;

	                          case 65361:
	                            length = readUint16(data, position);
	                            var siz = {};
	                            siz.Xsiz = readUint32(data, position + 4);
	                            siz.Ysiz = readUint32(data, position + 8);
	                            siz.XOsiz = readUint32(data, position + 12);
	                            siz.YOsiz = readUint32(data, position + 16);
	                            siz.XTsiz = readUint32(data, position + 20);
	                            siz.YTsiz = readUint32(data, position + 24);
	                            siz.XTOsiz = readUint32(data, position + 28);
	                            siz.YTOsiz = readUint32(data, position + 32);
	                            var componentsCount = readUint16(data, position + 36);
	                            siz.Csiz = componentsCount;
	                            var components = [];
	                            j = position + 38;
	                            for (var i = 0; i < componentsCount; i++) {
	                                var component = {
	                                    precision: (data[j] & 127) + 1,
	                                    isSigned: !!(data[j] & 128),
	                                    XRsiz: data[j + 1],
	                                    YRsiz: data[j + 1]
	                                };
	                                calculateComponentDimensions(component, siz);
	                                components.push(component);
	                            }
	                            context.SIZ = siz;
	                            context.components = components;
	                            calculateTileGrids(context, components);
	                            context.QCC = [];
	                            context.COC = [];
	                            break;

	                          case 65372:
	                            length = readUint16(data, position);
	                            var qcd = {};
	                            j = position + 2;
	                            sqcd = data[j++];
	                            switch (sqcd & 31) {
	                              case 0:
	                                spqcdSize = 8;
	                                scalarExpounded = true;
	                                break;

	                              case 1:
	                                spqcdSize = 16;
	                                scalarExpounded = false;
	                                break;

	                              case 2:
	                                spqcdSize = 16;
	                                scalarExpounded = true;
	                                break;

	                              default:
	                                throw new Error("JPX Error: Invalid SQcd value " + sqcd);
	                            }
	                            qcd.noQuantization = spqcdSize === 8;
	                            qcd.scalarExpounded = scalarExpounded;
	                            qcd.guardBits = sqcd >> 5;
	                            spqcds = [];
	                            while (j < length + position) {
	                                var spqcd = {};
	                                if (spqcdSize === 8) {
	                                    spqcd.epsilon = data[j++] >> 3;
	                                    spqcd.mu = 0;
	                                } else {
	                                    spqcd.epsilon = data[j] >> 3;
	                                    spqcd.mu = (data[j] & 7) << 8 | data[j + 1];
	                                    j += 2;
	                                }
	                                spqcds.push(spqcd);
	                            }
	                            qcd.SPqcds = spqcds;
	                            if (context.mainHeader) {
	                                context.QCD = qcd;
	                            } else {
	                                context.currentTile.QCD = qcd;
	                                context.currentTile.QCC = [];
	                            }
	                            break;

	                          case 65373:
	                            length = readUint16(data, position);
	                            var qcc = {};
	                            j = position + 2;
	                            var cqcc;
	                            if (context.SIZ.Csiz < 257) {
	                                cqcc = data[j++];
	                            } else {
	                                cqcc = readUint16(data, j);
	                                j += 2;
	                            }
	                            sqcd = data[j++];
	                            switch (sqcd & 31) {
	                              case 0:
	                                spqcdSize = 8;
	                                scalarExpounded = true;
	                                break;

	                              case 1:
	                                spqcdSize = 16;
	                                scalarExpounded = false;
	                                break;

	                              case 2:
	                                spqcdSize = 16;
	                                scalarExpounded = true;
	                                break;

	                              default:
	                                throw new Error("JPX Error: Invalid SQcd value " + sqcd);
	                            }
	                            qcc.noQuantization = spqcdSize === 8;
	                            qcc.scalarExpounded = scalarExpounded;
	                            qcc.guardBits = sqcd >> 5;
	                            spqcds = [];
	                            while (j < length + position) {
	                                spqcd = {};
	                                if (spqcdSize === 8) {
	                                    spqcd.epsilon = data[j++] >> 3;
	                                    spqcd.mu = 0;
	                                } else {
	                                    spqcd.epsilon = data[j] >> 3;
	                                    spqcd.mu = (data[j] & 7) << 8 | data[j + 1];
	                                    j += 2;
	                                }
	                                spqcds.push(spqcd);
	                            }
	                            qcc.SPqcds = spqcds;
	                            if (context.mainHeader) {
	                                context.QCC[cqcc] = qcc;
	                            } else {
	                                context.currentTile.QCC[cqcc] = qcc;
	                            }
	                            break;

	                          case 65362:
	                            length = readUint16(data, position);
	                            var cod = {};
	                            j = position + 2;
	                            var scod = data[j++];
	                            cod.entropyCoderWithCustomPrecincts = !!(scod & 1);
	                            cod.sopMarkerUsed = !!(scod & 2);
	                            cod.ephMarkerUsed = !!(scod & 4);
	                            cod.progressionOrder = data[j++];
	                            cod.layersCount = readUint16(data, j);
	                            j += 2;
	                            cod.multipleComponentTransform = data[j++];
	                            cod.decompositionLevelsCount = data[j++];
	                            cod.xcb = (data[j++] & 15) + 2;
	                            cod.ycb = (data[j++] & 15) + 2;
	                            var blockStyle = data[j++];
	                            cod.selectiveArithmeticCodingBypass = !!(blockStyle & 1);
	                            cod.resetContextProbabilities = !!(blockStyle & 2);
	                            cod.terminationOnEachCodingPass = !!(blockStyle & 4);
	                            cod.verticalyStripe = !!(blockStyle & 8);
	                            cod.predictableTermination = !!(blockStyle & 16);
	                            cod.segmentationSymbolUsed = !!(blockStyle & 32);
	                            cod.reversibleTransformation = data[j++];
	                            if (cod.entropyCoderWithCustomPrecincts) {
	                                var precinctsSizes = [];
	                                while (j < length + position) {
	                                    var precinctsSize = data[j++];
	                                    precinctsSizes.push({
	                                        PPx: precinctsSize & 15,
	                                        PPy: precinctsSize >> 4
	                                    });
	                                }
	                                cod.precinctsSizes = precinctsSizes;
	                            }
	                            var unsupported = [];
	                            if (cod.selectiveArithmeticCodingBypass) {
	                                unsupported.push("selectiveArithmeticCodingBypass");
	                            }
	                            if (cod.resetContextProbabilities) {
	                                unsupported.push("resetContextProbabilities");
	                            }
	                            if (cod.terminationOnEachCodingPass) {
	                                unsupported.push("terminationOnEachCodingPass");
	                            }
	                            if (cod.verticalyStripe) {
	                                unsupported.push("verticalyStripe");
	                            }
	                            if (cod.predictableTermination) {
	                                unsupported.push("predictableTermination");
	                            }
	                            if (unsupported.length > 0) {
	                                doNotRecover = true;
	                                throw new Error("JPX Error: Unsupported COD options (" + unsupported.join(", ") + ")");
	                            }
	                            if (context.mainHeader) {
	                                context.COD = cod;
	                            } else {
	                                context.currentTile.COD = cod;
	                                context.currentTile.COC = [];
	                            }
	                            break;

	                          case 65424:
	                            length = readUint16(data, position);
	                            tile = {};
	                            tile.index = readUint16(data, position + 2);
	                            tile.length = readUint32(data, position + 4);
	                            tile.dataEnd = tile.length + position - 2;
	                            tile.partIndex = data[position + 8];
	                            tile.partsCount = data[position + 9];
	                            context.mainHeader = false;
	                            if (tile.partIndex === 0) {
	                                tile.COD = context.COD;
	                                tile.COC = context.COC.slice(0);
	                                tile.QCD = context.QCD;
	                                tile.QCC = context.QCC.slice(0);
	                            }
	                            context.currentTile = tile;
	                            break;

	                          case 65427:
	                            tile = context.currentTile;
	                            if (tile.partIndex === 0) {
	                                initializeTile(context, tile.index);
	                                buildPackets(context);
	                            }
	                            length = tile.dataEnd - position;
	                            parseTilePackets(context, data, position, length);
	                            break;

	                          case 65365:
	                          case 65367:
	                          case 65368:
	                          case 65380:
	                            length = readUint16(data, position);
	                            break;

	                          case 65363:
	                            throw new Error("JPX Error: Codestream code 0xFF53 (COC) is " + "not implemented");

	                          default:
	                            throw new Error("JPX Error: Unknown codestream code: " + code.toString(16));
	                        }
	                        position += length;
	                    }
	                } catch (e) {
	                    if (doNotRecover || this.failOnCorruptedImage) {
	                        throw e;
	                    } else {
	                        warn("Trying to recover from " + e.message);
	                    }
	                }
	                this.tiles = transformComponents(context);
	                this.width = context.SIZ.Xsiz - context.SIZ.XOsiz;
	                this.height = context.SIZ.Ysiz - context.SIZ.YOsiz;
	                this.componentsCount = context.SIZ.Csiz;
	            }
	        };
	        function calculateComponentDimensions(component, siz) {
	            component.x0 = Math.ceil(siz.XOsiz / component.XRsiz);
	            component.x1 = Math.ceil(siz.Xsiz / component.XRsiz);
	            component.y0 = Math.ceil(siz.YOsiz / component.YRsiz);
	            component.y1 = Math.ceil(siz.Ysiz / component.YRsiz);
	            component.width = component.x1 - component.x0;
	            component.height = component.y1 - component.y0;
	        }
	        function calculateTileGrids(context, components) {
	            var siz = context.SIZ;
	            var tile, tiles = [];
	            var numXtiles = Math.ceil((siz.Xsiz - siz.XTOsiz) / siz.XTsiz);
	            var numYtiles = Math.ceil((siz.Ysiz - siz.YTOsiz) / siz.YTsiz);
	            for (var q = 0; q < numYtiles; q++) {
	                for (var p = 0; p < numXtiles; p++) {
	                    tile = {};
	                    tile.tx0 = Math.max(siz.XTOsiz + p * siz.XTsiz, siz.XOsiz);
	                    tile.ty0 = Math.max(siz.YTOsiz + q * siz.YTsiz, siz.YOsiz);
	                    tile.tx1 = Math.min(siz.XTOsiz + (p + 1) * siz.XTsiz, siz.Xsiz);
	                    tile.ty1 = Math.min(siz.YTOsiz + (q + 1) * siz.YTsiz, siz.Ysiz);
	                    tile.width = tile.tx1 - tile.tx0;
	                    tile.height = tile.ty1 - tile.ty0;
	                    tile.components = [];
	                    tiles.push(tile);
	                }
	            }
	            context.tiles = tiles;
	            var componentsCount = siz.Csiz;
	            for (var i = 0, ii = componentsCount; i < ii; i++) {
	                var component = components[i];
	                for (var j = 0, jj = tiles.length; j < jj; j++) {
	                    var tileComponent = {};
	                    tile = tiles[j];
	                    tileComponent.tcx0 = Math.ceil(tile.tx0 / component.XRsiz);
	                    tileComponent.tcy0 = Math.ceil(tile.ty0 / component.YRsiz);
	                    tileComponent.tcx1 = Math.ceil(tile.tx1 / component.XRsiz);
	                    tileComponent.tcy1 = Math.ceil(tile.ty1 / component.YRsiz);
	                    tileComponent.width = tileComponent.tcx1 - tileComponent.tcx0;
	                    tileComponent.height = tileComponent.tcy1 - tileComponent.tcy0;
	                    tile.components[i] = tileComponent;
	                }
	            }
	        }
	        function getBlocksDimensions(context, component, r) {
	            var codOrCoc = component.codingStyleParameters;
	            var result = {};
	            if (!codOrCoc.entropyCoderWithCustomPrecincts) {
	                result.PPx = 15;
	                result.PPy = 15;
	            } else {
	                result.PPx = codOrCoc.precinctsSizes[r].PPx;
	                result.PPy = codOrCoc.precinctsSizes[r].PPy;
	            }
	            result.xcb_ = r > 0 ? Math.min(codOrCoc.xcb, result.PPx - 1) : Math.min(codOrCoc.xcb, result.PPx);
	            result.ycb_ = r > 0 ? Math.min(codOrCoc.ycb, result.PPy - 1) : Math.min(codOrCoc.ycb, result.PPy);
	            return result;
	        }
	        function buildPrecincts(context, resolution, dimensions) {
	            var precinctWidth = 1 << dimensions.PPx;
	            var precinctHeight = 1 << dimensions.PPy;
	            var isZeroRes = resolution.resLevel === 0;
	            var precinctWidthInSubband = 1 << dimensions.PPx + (isZeroRes ? 0 : -1);
	            var precinctHeightInSubband = 1 << dimensions.PPy + (isZeroRes ? 0 : -1);
	            var numprecinctswide = resolution.trx1 > resolution.trx0 ? Math.ceil(resolution.trx1 / precinctWidth) - Math.floor(resolution.trx0 / precinctWidth) : 0;
	            var numprecinctshigh = resolution.try1 > resolution.try0 ? Math.ceil(resolution.try1 / precinctHeight) - Math.floor(resolution.try0 / precinctHeight) : 0;
	            var numprecincts = numprecinctswide * numprecinctshigh;
	            resolution.precinctParameters = {
	                precinctWidth: precinctWidth,
	                precinctHeight: precinctHeight,
	                numprecinctswide: numprecinctswide,
	                numprecinctshigh: numprecinctshigh,
	                numprecincts: numprecincts,
	                precinctWidthInSubband: precinctWidthInSubband,
	                precinctHeightInSubband: precinctHeightInSubband
	            };
	        }
	        function buildCodeblocks(context, subband, dimensions) {
	            var xcb_ = dimensions.xcb_;
	            var ycb_ = dimensions.ycb_;
	            var codeblockWidth = 1 << xcb_;
	            var codeblockHeight = 1 << ycb_;
	            var cbx0 = subband.tbx0 >> xcb_;
	            var cby0 = subband.tby0 >> ycb_;
	            var cbx1 = subband.tbx1 + codeblockWidth - 1 >> xcb_;
	            var cby1 = subband.tby1 + codeblockHeight - 1 >> ycb_;
	            var precinctParameters = subband.resolution.precinctParameters;
	            var codeblocks = [];
	            var precincts = [];
	            var i, j, codeblock, precinctNumber;
	            for (j = cby0; j < cby1; j++) {
	                for (i = cbx0; i < cbx1; i++) {
	                    codeblock = {
	                        cbx: i,
	                        cby: j,
	                        tbx0: codeblockWidth * i,
	                        tby0: codeblockHeight * j,
	                        tbx1: codeblockWidth * (i + 1),
	                        tby1: codeblockHeight * (j + 1)
	                    };
	                    codeblock.tbx0_ = Math.max(subband.tbx0, codeblock.tbx0);
	                    codeblock.tby0_ = Math.max(subband.tby0, codeblock.tby0);
	                    codeblock.tbx1_ = Math.min(subband.tbx1, codeblock.tbx1);
	                    codeblock.tby1_ = Math.min(subband.tby1, codeblock.tby1);
	                    var pi = Math.floor((codeblock.tbx0_ - subband.tbx0) / precinctParameters.precinctWidthInSubband);
	                    var pj = Math.floor((codeblock.tby0_ - subband.tby0) / precinctParameters.precinctHeightInSubband);
	                    precinctNumber = pi + pj * precinctParameters.numprecinctswide;
	                    codeblock.precinctNumber = precinctNumber;
	                    codeblock.subbandType = subband.type;
	                    codeblock.Lblock = 3;
	                    if (codeblock.tbx1_ <= codeblock.tbx0_ || codeblock.tby1_ <= codeblock.tby0_) {
	                        continue;
	                    }
	                    codeblocks.push(codeblock);
	                    var precinct = precincts[precinctNumber];
	                    if (precinct !== undefined) {
	                        if (i < precinct.cbxMin) {
	                            precinct.cbxMin = i;
	                        } else if (i > precinct.cbxMax) {
	                            precinct.cbxMax = i;
	                        }
	                        if (j < precinct.cbyMin) {
	                            precinct.cbxMin = j;
	                        } else if (j > precinct.cbyMax) {
	                            precinct.cbyMax = j;
	                        }
	                    } else {
	                        precincts[precinctNumber] = precinct = {
	                            cbxMin: i,
	                            cbyMin: j,
	                            cbxMax: i,
	                            cbyMax: j
	                        };
	                    }
	                    codeblock.precinct = precinct;
	                }
	            }
	            subband.codeblockParameters = {
	                codeblockWidth: xcb_,
	                codeblockHeight: ycb_,
	                numcodeblockwide: cbx1 - cbx0 + 1,
	                numcodeblockhigh: cby1 - cby0 + 1
	            };
	            subband.codeblocks = codeblocks;
	            subband.precincts = precincts;
	        }
	        function createPacket(resolution, precinctNumber, layerNumber) {
	            var precinctCodeblocks = [];
	            var subbands = resolution.subbands;
	            for (var i = 0, ii = subbands.length; i < ii; i++) {
	                var subband = subbands[i];
	                var codeblocks = subband.codeblocks;
	                for (var j = 0, jj = codeblocks.length; j < jj; j++) {
	                    var codeblock = codeblocks[j];
	                    if (codeblock.precinctNumber !== precinctNumber) {
	                        continue;
	                    }
	                    precinctCodeblocks.push(codeblock);
	                }
	            }
	            return {
	                layerNumber: layerNumber,
	                codeblocks: precinctCodeblocks
	            };
	        }
	        function LayerResolutionComponentPositionIterator(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var layersCount = tile.codingStyleDefaultParameters.layersCount;
	            var componentsCount = siz.Csiz;
	            var maxDecompositionLevelsCount = 0;
	            for (var q = 0; q < componentsCount; q++) {
	                maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, tile.components[q].codingStyleParameters.decompositionLevelsCount);
	            }
	            var l = 0, r = 0, i = 0, k = 0;
	            this.nextPacket = function JpxImage_nextPacket() {
	                for (;l < layersCount; l++) {
	                    for (;r <= maxDecompositionLevelsCount; r++) {
	                        for (;i < componentsCount; i++) {
	                            var component = tile.components[i];
	                            if (r > component.codingStyleParameters.decompositionLevelsCount) {
	                                continue;
	                            }
	                            var resolution = component.resolutions[r];
	                            var numprecincts = resolution.precinctParameters.numprecincts;
	                            for (;k < numprecincts; ) {
	                                var packet = createPacket(resolution, k, l);
	                                k++;
	                                return packet;
	                            }
	                            k = 0;
	                        }
	                        i = 0;
	                    }
	                    r = 0;
	                }
	                throw new Error("JPX Error: Out of packets");
	            };
	        }
	        function ResolutionLayerComponentPositionIterator(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var layersCount = tile.codingStyleDefaultParameters.layersCount;
	            var componentsCount = siz.Csiz;
	            var maxDecompositionLevelsCount = 0;
	            for (var q = 0; q < componentsCount; q++) {
	                maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, tile.components[q].codingStyleParameters.decompositionLevelsCount);
	            }
	            var r = 0, l = 0, i = 0, k = 0;
	            this.nextPacket = function JpxImage_nextPacket() {
	                for (;r <= maxDecompositionLevelsCount; r++) {
	                    for (;l < layersCount; l++) {
	                        for (;i < componentsCount; i++) {
	                            var component = tile.components[i];
	                            if (r > component.codingStyleParameters.decompositionLevelsCount) {
	                                continue;
	                            }
	                            var resolution = component.resolutions[r];
	                            var numprecincts = resolution.precinctParameters.numprecincts;
	                            for (;k < numprecincts; ) {
	                                var packet = createPacket(resolution, k, l);
	                                k++;
	                                return packet;
	                            }
	                            k = 0;
	                        }
	                        i = 0;
	                    }
	                    l = 0;
	                }
	                throw new Error("JPX Error: Out of packets");
	            };
	        }
	        function ResolutionPositionComponentLayerIterator(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var layersCount = tile.codingStyleDefaultParameters.layersCount;
	            var componentsCount = siz.Csiz;
	            var l, r, c, p;
	            var maxDecompositionLevelsCount = 0;
	            for (c = 0; c < componentsCount; c++) {
	                var component = tile.components[c];
	                maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount, component.codingStyleParameters.decompositionLevelsCount);
	            }
	            var maxNumPrecinctsInLevel = new Int32Array(maxDecompositionLevelsCount + 1);
	            for (r = 0; r <= maxDecompositionLevelsCount; ++r) {
	                var maxNumPrecincts = 0;
	                for (c = 0; c < componentsCount; ++c) {
	                    var resolutions = tile.components[c].resolutions;
	                    if (r < resolutions.length) {
	                        maxNumPrecincts = Math.max(maxNumPrecincts, resolutions[r].precinctParameters.numprecincts);
	                    }
	                }
	                maxNumPrecinctsInLevel[r] = maxNumPrecincts;
	            }
	            l = 0;
	            r = 0;
	            c = 0;
	            p = 0;
	            this.nextPacket = function JpxImage_nextPacket() {
	                for (;r <= maxDecompositionLevelsCount; r++) {
	                    for (;p < maxNumPrecinctsInLevel[r]; p++) {
	                        for (;c < componentsCount; c++) {
	                            var component = tile.components[c];
	                            if (r > component.codingStyleParameters.decompositionLevelsCount) {
	                                continue;
	                            }
	                            var resolution = component.resolutions[r];
	                            var numprecincts = resolution.precinctParameters.numprecincts;
	                            if (p >= numprecincts) {
	                                continue;
	                            }
	                            for (;l < layersCount; ) {
	                                var packet = createPacket(resolution, p, l);
	                                l++;
	                                return packet;
	                            }
	                            l = 0;
	                        }
	                        c = 0;
	                    }
	                    p = 0;
	                }
	                throw new Error("JPX Error: Out of packets");
	            };
	        }
	        function PositionComponentResolutionLayerIterator(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var layersCount = tile.codingStyleDefaultParameters.layersCount;
	            var componentsCount = siz.Csiz;
	            var precinctsSizes = getPrecinctSizesInImageScale(tile);
	            var precinctsIterationSizes = precinctsSizes;
	            var l = 0, r = 0, c = 0, px = 0, py = 0;
	            this.nextPacket = function JpxImage_nextPacket() {
	                for (;py < precinctsIterationSizes.maxNumHigh; py++) {
	                    for (;px < precinctsIterationSizes.maxNumWide; px++) {
	                        for (;c < componentsCount; c++) {
	                            var component = tile.components[c];
	                            var decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
	                            for (;r <= decompositionLevelsCount; r++) {
	                                var resolution = component.resolutions[r];
	                                var sizeInImageScale = precinctsSizes.components[c].resolutions[r];
	                                var k = getPrecinctIndexIfExist(px, py, sizeInImageScale, precinctsIterationSizes, resolution);
	                                if (k === null) {
	                                    continue;
	                                }
	                                for (;l < layersCount; ) {
	                                    var packet = createPacket(resolution, k, l);
	                                    l++;
	                                    return packet;
	                                }
	                                l = 0;
	                            }
	                            r = 0;
	                        }
	                        c = 0;
	                    }
	                    px = 0;
	                }
	                throw new Error("JPX Error: Out of packets");
	            };
	        }
	        function ComponentPositionResolutionLayerIterator(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var layersCount = tile.codingStyleDefaultParameters.layersCount;
	            var componentsCount = siz.Csiz;
	            var precinctsSizes = getPrecinctSizesInImageScale(tile);
	            var l = 0, r = 0, c = 0, px = 0, py = 0;
	            this.nextPacket = function JpxImage_nextPacket() {
	                for (;c < componentsCount; ++c) {
	                    var component = tile.components[c];
	                    var precinctsIterationSizes = precinctsSizes.components[c];
	                    var decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
	                    for (;py < precinctsIterationSizes.maxNumHigh; py++) {
	                        for (;px < precinctsIterationSizes.maxNumWide; px++) {
	                            for (;r <= decompositionLevelsCount; r++) {
	                                var resolution = component.resolutions[r];
	                                var sizeInImageScale = precinctsIterationSizes.resolutions[r];
	                                var k = getPrecinctIndexIfExist(px, py, sizeInImageScale, precinctsIterationSizes, resolution);
	                                if (k === null) {
	                                    continue;
	                                }
	                                for (;l < layersCount; ) {
	                                    var packet = createPacket(resolution, k, l);
	                                    l++;
	                                    return packet;
	                                }
	                                l = 0;
	                            }
	                            r = 0;
	                        }
	                        px = 0;
	                    }
	                    py = 0;
	                }
	                throw new Error("JPX Error: Out of packets");
	            };
	        }
	        function getPrecinctIndexIfExist(pxIndex, pyIndex, sizeInImageScale, precinctIterationSizes, resolution) {
	            var posX = pxIndex * precinctIterationSizes.minWidth;
	            var posY = pyIndex * precinctIterationSizes.minHeight;
	            if (posX % sizeInImageScale.width !== 0 || posY % sizeInImageScale.height !== 0) {
	                return null;
	            }
	            var startPrecinctRowIndex = posY / sizeInImageScale.width * resolution.precinctParameters.numprecinctswide;
	            return posX / sizeInImageScale.height + startPrecinctRowIndex;
	        }
	        function getPrecinctSizesInImageScale(tile) {
	            var componentsCount = tile.components.length;
	            var minWidth = Number.MAX_VALUE;
	            var minHeight = Number.MAX_VALUE;
	            var maxNumWide = 0;
	            var maxNumHigh = 0;
	            var sizePerComponent = new Array(componentsCount);
	            for (var c = 0; c < componentsCount; c++) {
	                var component = tile.components[c];
	                var decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
	                var sizePerResolution = new Array(decompositionLevelsCount + 1);
	                var minWidthCurrentComponent = Number.MAX_VALUE;
	                var minHeightCurrentComponent = Number.MAX_VALUE;
	                var maxNumWideCurrentComponent = 0;
	                var maxNumHighCurrentComponent = 0;
	                var scale = 1;
	                for (var r = decompositionLevelsCount; r >= 0; --r) {
	                    var resolution = component.resolutions[r];
	                    var widthCurrentResolution = scale * resolution.precinctParameters.precinctWidth;
	                    var heightCurrentResolution = scale * resolution.precinctParameters.precinctHeight;
	                    minWidthCurrentComponent = Math.min(minWidthCurrentComponent, widthCurrentResolution);
	                    minHeightCurrentComponent = Math.min(minHeightCurrentComponent, heightCurrentResolution);
	                    maxNumWideCurrentComponent = Math.max(maxNumWideCurrentComponent, resolution.precinctParameters.numprecinctswide);
	                    maxNumHighCurrentComponent = Math.max(maxNumHighCurrentComponent, resolution.precinctParameters.numprecinctshigh);
	                    sizePerResolution[r] = {
	                        width: widthCurrentResolution,
	                        height: heightCurrentResolution
	                    };
	                    scale <<= 1;
	                }
	                minWidth = Math.min(minWidth, minWidthCurrentComponent);
	                minHeight = Math.min(minHeight, minHeightCurrentComponent);
	                maxNumWide = Math.max(maxNumWide, maxNumWideCurrentComponent);
	                maxNumHigh = Math.max(maxNumHigh, maxNumHighCurrentComponent);
	                sizePerComponent[c] = {
	                    resolutions: sizePerResolution,
	                    minWidth: minWidthCurrentComponent,
	                    minHeight: minHeightCurrentComponent,
	                    maxNumWide: maxNumWideCurrentComponent,
	                    maxNumHigh: maxNumHighCurrentComponent
	                };
	            }
	            return {
	                components: sizePerComponent,
	                minWidth: minWidth,
	                minHeight: minHeight,
	                maxNumWide: maxNumWide,
	                maxNumHigh: maxNumHigh
	            };
	        }
	        function buildPackets(context) {
	            var siz = context.SIZ;
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var componentsCount = siz.Csiz;
	            for (var c = 0; c < componentsCount; c++) {
	                var component = tile.components[c];
	                var decompositionLevelsCount = component.codingStyleParameters.decompositionLevelsCount;
	                var resolutions = [];
	                var subbands = [];
	                for (var r = 0; r <= decompositionLevelsCount; r++) {
	                    var blocksDimensions = getBlocksDimensions(context, component, r);
	                    var resolution = {};
	                    var scale = 1 << decompositionLevelsCount - r;
	                    resolution.trx0 = Math.ceil(component.tcx0 / scale);
	                    resolution.try0 = Math.ceil(component.tcy0 / scale);
	                    resolution.trx1 = Math.ceil(component.tcx1 / scale);
	                    resolution.try1 = Math.ceil(component.tcy1 / scale);
	                    resolution.resLevel = r;
	                    buildPrecincts(context, resolution, blocksDimensions);
	                    resolutions.push(resolution);
	                    var subband;
	                    if (r === 0) {
	                        subband = {};
	                        subband.type = "LL";
	                        subband.tbx0 = Math.ceil(component.tcx0 / scale);
	                        subband.tby0 = Math.ceil(component.tcy0 / scale);
	                        subband.tbx1 = Math.ceil(component.tcx1 / scale);
	                        subband.tby1 = Math.ceil(component.tcy1 / scale);
	                        subband.resolution = resolution;
	                        buildCodeblocks(context, subband, blocksDimensions);
	                        subbands.push(subband);
	                        resolution.subbands = [ subband ];
	                    } else {
	                        var bscale = 1 << decompositionLevelsCount - r + 1;
	                        var resolutionSubbands = [];
	                        subband = {};
	                        subband.type = "HL";
	                        subband.tbx0 = Math.ceil(component.tcx0 / bscale - .5);
	                        subband.tby0 = Math.ceil(component.tcy0 / bscale);
	                        subband.tbx1 = Math.ceil(component.tcx1 / bscale - .5);
	                        subband.tby1 = Math.ceil(component.tcy1 / bscale);
	                        subband.resolution = resolution;
	                        buildCodeblocks(context, subband, blocksDimensions);
	                        subbands.push(subband);
	                        resolutionSubbands.push(subband);
	                        subband = {};
	                        subband.type = "LH";
	                        subband.tbx0 = Math.ceil(component.tcx0 / bscale);
	                        subband.tby0 = Math.ceil(component.tcy0 / bscale - .5);
	                        subband.tbx1 = Math.ceil(component.tcx1 / bscale);
	                        subband.tby1 = Math.ceil(component.tcy1 / bscale - .5);
	                        subband.resolution = resolution;
	                        buildCodeblocks(context, subband, blocksDimensions);
	                        subbands.push(subband);
	                        resolutionSubbands.push(subband);
	                        subband = {};
	                        subband.type = "HH";
	                        subband.tbx0 = Math.ceil(component.tcx0 / bscale - .5);
	                        subband.tby0 = Math.ceil(component.tcy0 / bscale - .5);
	                        subband.tbx1 = Math.ceil(component.tcx1 / bscale - .5);
	                        subband.tby1 = Math.ceil(component.tcy1 / bscale - .5);
	                        subband.resolution = resolution;
	                        buildCodeblocks(context, subband, blocksDimensions);
	                        subbands.push(subband);
	                        resolutionSubbands.push(subband);
	                        resolution.subbands = resolutionSubbands;
	                    }
	                }
	                component.resolutions = resolutions;
	                component.subbands = subbands;
	            }
	            var progressionOrder = tile.codingStyleDefaultParameters.progressionOrder;
	            switch (progressionOrder) {
	              case 0:
	                tile.packetsIterator = new LayerResolutionComponentPositionIterator(context);
	                break;

	              case 1:
	                tile.packetsIterator = new ResolutionLayerComponentPositionIterator(context);
	                break;

	              case 2:
	                tile.packetsIterator = new ResolutionPositionComponentLayerIterator(context);
	                break;

	              case 3:
	                tile.packetsIterator = new PositionComponentResolutionLayerIterator(context);
	                break;

	              case 4:
	                tile.packetsIterator = new ComponentPositionResolutionLayerIterator(context);
	                break;

	              default:
	                throw new Error("JPX Error: Unsupported progression order " + progressionOrder);
	            }
	        }
	        function parseTilePackets(context, data, offset, dataLength) {
	            var position = 0;
	            var buffer, bufferSize = 0, skipNextBit = false;
	            function readBits(count) {
	                while (bufferSize < count) {
	                    var b = data[offset + position];
	                    position++;
	                    if (skipNextBit) {
	                        buffer = buffer << 7 | b;
	                        bufferSize += 7;
	                        skipNextBit = false;
	                    } else {
	                        buffer = buffer << 8 | b;
	                        bufferSize += 8;
	                    }
	                    if (b === 255) {
	                        skipNextBit = true;
	                    }
	                }
	                bufferSize -= count;
	                return buffer >>> bufferSize & (1 << count) - 1;
	            }
	            function skipMarkerIfEqual(value) {
	                if (data[offset + position - 1] === 255 && data[offset + position] === value) {
	                    skipBytes(1);
	                    return true;
	                } else if (data[offset + position] === 255 && data[offset + position + 1] === value) {
	                    skipBytes(2);
	                    return true;
	                }
	                return false;
	            }
	            function skipBytes(count) {
	                position += count;
	            }
	            function alignToByte() {
	                bufferSize = 0;
	                if (skipNextBit) {
	                    position++;
	                    skipNextBit = false;
	                }
	            }
	            function readCodingpasses() {
	                if (readBits(1) === 0) {
	                    return 1;
	                }
	                if (readBits(1) === 0) {
	                    return 2;
	                }
	                var value = readBits(2);
	                if (value < 3) {
	                    return value + 3;
	                }
	                value = readBits(5);
	                if (value < 31) {
	                    return value + 6;
	                }
	                value = readBits(7);
	                return value + 37;
	            }
	            var tileIndex = context.currentTile.index;
	            var tile = context.tiles[tileIndex];
	            var sopMarkerUsed = context.COD.sopMarkerUsed;
	            var ephMarkerUsed = context.COD.ephMarkerUsed;
	            var packetsIterator = tile.packetsIterator;
	            while (position < dataLength) {
	                alignToByte();
	                if (sopMarkerUsed && skipMarkerIfEqual(145)) {
	                    skipBytes(4);
	                }
	                var packet = packetsIterator.nextPacket();
	                if (!readBits(1)) {
	                    continue;
	                }
	                var layerNumber = packet.layerNumber;
	                var queue = [], codeblock;
	                for (var i = 0, ii = packet.codeblocks.length; i < ii; i++) {
	                    codeblock = packet.codeblocks[i];
	                    var precinct = codeblock.precinct;
	                    var codeblockColumn = codeblock.cbx - precinct.cbxMin;
	                    var codeblockRow = codeblock.cby - precinct.cbyMin;
	                    var codeblockIncluded = false;
	                    var firstTimeInclusion = false;
	                    var valueReady;
	                    if (codeblock["included"] !== undefined) {
	                        codeblockIncluded = !!readBits(1);
	                    } else {
	                        precinct = codeblock.precinct;
	                        var inclusionTree, zeroBitPlanesTree;
	                        if (precinct["inclusionTree"] !== undefined) {
	                            inclusionTree = precinct.inclusionTree;
	                        } else {
	                            var width = precinct.cbxMax - precinct.cbxMin + 1;
	                            var height = precinct.cbyMax - precinct.cbyMin + 1;
	                            inclusionTree = new InclusionTree(width, height, layerNumber);
	                            zeroBitPlanesTree = new TagTree(width, height);
	                            precinct.inclusionTree = inclusionTree;
	                            precinct.zeroBitPlanesTree = zeroBitPlanesTree;
	                        }
	                        if (inclusionTree.reset(codeblockColumn, codeblockRow, layerNumber)) {
	                            while (true) {
	                                if (readBits(1)) {
	                                    valueReady = !inclusionTree.nextLevel();
	                                    if (valueReady) {
	                                        codeblock.included = true;
	                                        codeblockIncluded = firstTimeInclusion = true;
	                                        break;
	                                    }
	                                } else {
	                                    inclusionTree.incrementValue(layerNumber);
	                                    break;
	                                }
	                            }
	                        }
	                    }
	                    if (!codeblockIncluded) {
	                        continue;
	                    }
	                    if (firstTimeInclusion) {
	                        zeroBitPlanesTree = precinct.zeroBitPlanesTree;
	                        zeroBitPlanesTree.reset(codeblockColumn, codeblockRow);
	                        while (true) {
	                            if (readBits(1)) {
	                                valueReady = !zeroBitPlanesTree.nextLevel();
	                                if (valueReady) {
	                                    break;
	                                }
	                            } else {
	                                zeroBitPlanesTree.incrementValue();
	                            }
	                        }
	                        codeblock.zeroBitPlanes = zeroBitPlanesTree.value;
	                    }
	                    var codingpasses = readCodingpasses();
	                    while (readBits(1)) {
	                        codeblock.Lblock++;
	                    }
	                    var codingpassesLog2 = log2(codingpasses);
	                    var bits = (codingpasses < 1 << codingpassesLog2 ? codingpassesLog2 - 1 : codingpassesLog2) + codeblock.Lblock;
	                    var codedDataLength = readBits(bits);
	                    queue.push({
	                        codeblock: codeblock,
	                        codingpasses: codingpasses,
	                        dataLength: codedDataLength
	                    });
	                }
	                alignToByte();
	                if (ephMarkerUsed) {
	                    skipMarkerIfEqual(146);
	                }
	                while (queue.length > 0) {
	                    var packetItem = queue.shift();
	                    codeblock = packetItem.codeblock;
	                    if (codeblock["data"] === undefined) {
	                        codeblock.data = [];
	                    }
	                    codeblock.data.push({
	                        data: data,
	                        start: offset + position,
	                        end: offset + position + packetItem.dataLength,
	                        codingpasses: packetItem.codingpasses
	                    });
	                    position += packetItem.dataLength;
	                }
	            }
	            return position;
	        }
	        function copyCoefficients(coefficients, levelWidth, levelHeight, subband, delta, mb, reversible, segmentationSymbolUsed) {
	            var x0 = subband.tbx0;
	            var y0 = subband.tby0;
	            var width = subband.tbx1 - subband.tbx0;
	            var codeblocks = subband.codeblocks;
	            var right = subband.type.charAt(0) === "H" ? 1 : 0;
	            var bottom = subband.type.charAt(1) === "H" ? levelWidth : 0;
	            for (var i = 0, ii = codeblocks.length; i < ii; ++i) {
	                var codeblock = codeblocks[i];
	                var blockWidth = codeblock.tbx1_ - codeblock.tbx0_;
	                var blockHeight = codeblock.tby1_ - codeblock.tby0_;
	                if (blockWidth === 0 || blockHeight === 0) {
	                    continue;
	                }
	                if (codeblock["data"] === undefined) {
	                    continue;
	                }
	                var bitModel, currentCodingpassType;
	                bitModel = new BitModel(blockWidth, blockHeight, codeblock.subbandType, codeblock.zeroBitPlanes, mb);
	                currentCodingpassType = 2;
	                var data = codeblock.data, totalLength = 0, codingpasses = 0;
	                var j, jj, dataItem;
	                for (j = 0, jj = data.length; j < jj; j++) {
	                    dataItem = data[j];
	                    totalLength += dataItem.end - dataItem.start;
	                    codingpasses += dataItem.codingpasses;
	                }
	                var encodedData = new Uint8Array(totalLength);
	                var position = 0;
	                for (j = 0, jj = data.length; j < jj; j++) {
	                    dataItem = data[j];
	                    var chunk = dataItem.data.subarray(dataItem.start, dataItem.end);
	                    encodedData.set(chunk, position);
	                    position += chunk.length;
	                }
	                var decoder = new ArithmeticDecoder(encodedData, 0, totalLength);
	                bitModel.setDecoder(decoder);
	                for (j = 0; j < codingpasses; j++) {
	                    switch (currentCodingpassType) {
	                      case 0:
	                        bitModel.runSignificancePropogationPass();
	                        break;

	                      case 1:
	                        bitModel.runMagnitudeRefinementPass();
	                        break;

	                      case 2:
	                        bitModel.runCleanupPass();
	                        if (segmentationSymbolUsed) {
	                            bitModel.checkSegmentationSymbol();
	                        }
	                        break;
	                    }
	                    currentCodingpassType = (currentCodingpassType + 1) % 3;
	                }
	                var offset = codeblock.tbx0_ - x0 + (codeblock.tby0_ - y0) * width;
	                var sign = bitModel.coefficentsSign;
	                var magnitude = bitModel.coefficentsMagnitude;
	                var bitsDecoded = bitModel.bitsDecoded;
	                var magnitudeCorrection = reversible ? 0 : .5;
	                var k, n, nb;
	                position = 0;
	                var interleave = subband.type !== "LL";
	                for (j = 0; j < blockHeight; j++) {
	                    var row = offset / width | 0;
	                    var levelOffset = 2 * row * (levelWidth - width) + right + bottom;
	                    for (k = 0; k < blockWidth; k++) {
	                        n = magnitude[position];
	                        if (n !== 0) {
	                            n = (n + magnitudeCorrection) * delta;
	                            if (sign[position] !== 0) {
	                                n = -n;
	                            }
	                            nb = bitsDecoded[position];
	                            var pos = interleave ? levelOffset + (offset << 1) : offset;
	                            if (reversible && nb >= mb) {
	                                coefficients[pos] = n;
	                            } else {
	                                coefficients[pos] = n * (1 << mb - nb);
	                            }
	                        }
	                        offset++;
	                        position++;
	                    }
	                    offset += width - blockWidth;
	                }
	            }
	        }
	        function transformTile(context, tile, c) {
	            var component = tile.components[c];
	            var codingStyleParameters = component.codingStyleParameters;
	            var quantizationParameters = component.quantizationParameters;
	            var decompositionLevelsCount = codingStyleParameters.decompositionLevelsCount;
	            var spqcds = quantizationParameters.SPqcds;
	            var scalarExpounded = quantizationParameters.scalarExpounded;
	            var guardBits = quantizationParameters.guardBits;
	            var segmentationSymbolUsed = codingStyleParameters.segmentationSymbolUsed;
	            var precision = context.components[c].precision;
	            var reversible = codingStyleParameters.reversibleTransformation;
	            var transform = reversible ? new ReversibleTransform() : new IrreversibleTransform();
	            var subbandCoefficients = [];
	            var b = 0;
	            for (var i = 0; i <= decompositionLevelsCount; i++) {
	                var resolution = component.resolutions[i];
	                var width = resolution.trx1 - resolution.trx0;
	                var height = resolution.try1 - resolution.try0;
	                var coefficients = new Float32Array(width * height);
	                for (var j = 0, jj = resolution.subbands.length; j < jj; j++) {
	                    var mu, epsilon;
	                    if (!scalarExpounded) {
	                        mu = spqcds[0].mu;
	                        epsilon = spqcds[0].epsilon + (i > 0 ? 1 - i : 0);
	                    } else {
	                        mu = spqcds[b].mu;
	                        epsilon = spqcds[b].epsilon;
	                        b++;
	                    }
	                    var subband = resolution.subbands[j];
	                    var gainLog2 = SubbandsGainLog2[subband.type];
	                    var delta = reversible ? 1 : Math.pow(2, precision + gainLog2 - epsilon) * (1 + mu / 2048);
	                    var mb = guardBits + epsilon - 1;
	                    copyCoefficients(coefficients, width, height, subband, delta, mb, reversible, segmentationSymbolUsed);
	                }
	                subbandCoefficients.push({
	                    width: width,
	                    height: height,
	                    items: coefficients
	                });
	            }
	            var result = transform.calculate(subbandCoefficients, component.tcx0, component.tcy0);
	            return {
	                left: component.tcx0,
	                top: component.tcy0,
	                width: result.width,
	                height: result.height,
	                items: result.items
	            };
	        }
	        function transformComponents(context) {
	            var siz = context.SIZ;
	            var components = context.components;
	            var componentsCount = siz.Csiz;
	            var resultImages = [];
	            for (var i = 0, ii = context.tiles.length; i < ii; i++) {
	                var tile = context.tiles[i];
	                var transformedTiles = [];
	                var c;
	                for (c = 0; c < componentsCount; c++) {
	                    transformedTiles[c] = transformTile(context, tile, c);
	                }
	                var tile0 = transformedTiles[0];
	                var out = new Uint8Array(tile0.items.length * componentsCount);
	                var result = {
	                    left: tile0.left,
	                    top: tile0.top,
	                    width: tile0.width,
	                    height: tile0.height,
	                    items: out
	                };
	                var shift, offset, max, min, maxK;
	                var pos = 0, j, jj, y0, y1, y2, r, g, b, k, val;
	                if (tile.codingStyleDefaultParameters.multipleComponentTransform) {
	                    var fourComponents = componentsCount === 4;
	                    var y0items = transformedTiles[0].items;
	                    var y1items = transformedTiles[1].items;
	                    var y2items = transformedTiles[2].items;
	                    var y3items = fourComponents ? transformedTiles[3].items : null;
	                    shift = components[0].precision - 8;
	                    offset = (128 << shift) + .5;
	                    max = 255 * (1 << shift);
	                    maxK = max * .5;
	                    min = -maxK;
	                    var component0 = tile.components[0];
	                    var alpha01 = componentsCount - 3;
	                    jj = y0items.length;
	                    if (!component0.codingStyleParameters.reversibleTransformation) {
	                        for (j = 0; j < jj; j++, pos += alpha01) {
	                            y0 = y0items[j] + offset;
	                            y1 = y1items[j];
	                            y2 = y2items[j];
	                            r = y0 + 1.402 * y2;
	                            g = y0 - .34413 * y1 - .71414 * y2;
	                            b = y0 + 1.772 * y1;
	                            out[pos++] = r <= 0 ? 0 : r >= max ? 255 : r >> shift;
	                            out[pos++] = g <= 0 ? 0 : g >= max ? 255 : g >> shift;
	                            out[pos++] = b <= 0 ? 0 : b >= max ? 255 : b >> shift;
	                        }
	                    } else {
	                        for (j = 0; j < jj; j++, pos += alpha01) {
	                            y0 = y0items[j] + offset;
	                            y1 = y1items[j];
	                            y2 = y2items[j];
	                            g = y0 - (y2 + y1 >> 2);
	                            r = g + y2;
	                            b = g + y1;
	                            out[pos++] = r <= 0 ? 0 : r >= max ? 255 : r >> shift;
	                            out[pos++] = g <= 0 ? 0 : g >= max ? 255 : g >> shift;
	                            out[pos++] = b <= 0 ? 0 : b >= max ? 255 : b >> shift;
	                        }
	                    }
	                    if (fourComponents) {
	                        for (j = 0, pos = 3; j < jj; j++, pos += 4) {
	                            k = y3items[j];
	                            out[pos] = k <= min ? 0 : k >= maxK ? 255 : k + offset >> shift;
	                        }
	                    }
	                } else {
	                    for (c = 0; c < componentsCount; c++) {
	                        var items = transformedTiles[c].items;
	                        shift = components[c].precision - 8;
	                        offset = (128 << shift) + .5;
	                        max = 127.5 * (1 << shift);
	                        min = -max;
	                        for (pos = c, j = 0, jj = items.length; j < jj; j++) {
	                            val = items[j];
	                            out[pos] = val <= min ? 0 : val >= max ? 255 : val + offset >> shift;
	                            pos += componentsCount;
	                        }
	                    }
	                }
	                resultImages.push(result);
	            }
	            return resultImages;
	        }
	        function initializeTile(context, tileIndex) {
	            var siz = context.SIZ;
	            var componentsCount = siz.Csiz;
	            var tile = context.tiles[tileIndex];
	            for (var c = 0; c < componentsCount; c++) {
	                var component = tile.components[c];
	                var qcdOrQcc = context.currentTile.QCC[c] !== undefined ? context.currentTile.QCC[c] : context.currentTile.QCD;
	                component.quantizationParameters = qcdOrQcc;
	                var codOrCoc = context.currentTile.COC[c] !== undefined ? context.currentTile.COC[c] : context.currentTile.COD;
	                component.codingStyleParameters = codOrCoc;
	            }
	            tile.codingStyleDefaultParameters = context.currentTile.COD;
	        }
	        var TagTree = function TagTreeClosure() {
	            function TagTree(width, height) {
	                var levelsLength = log2(Math.max(width, height)) + 1;
	                this.levels = [];
	                for (var i = 0; i < levelsLength; i++) {
	                    var level = {
	                        width: width,
	                        height: height,
	                        items: []
	                    };
	                    this.levels.push(level);
	                    width = Math.ceil(width / 2);
	                    height = Math.ceil(height / 2);
	                }
	            }
	            TagTree.prototype = {
	                reset: function TagTree_reset(i, j) {
	                    var currentLevel = 0, value = 0, level;
	                    while (currentLevel < this.levels.length) {
	                        level = this.levels[currentLevel];
	                        var index = i + j * level.width;
	                        if (level.items[index] !== undefined) {
	                            value = level.items[index];
	                            break;
	                        }
	                        level.index = index;
	                        i >>= 1;
	                        j >>= 1;
	                        currentLevel++;
	                    }
	                    currentLevel--;
	                    level = this.levels[currentLevel];
	                    level.items[level.index] = value;
	                    this.currentLevel = currentLevel;
	                    delete this.value;
	                },
	                incrementValue: function TagTree_incrementValue() {
	                    var level = this.levels[this.currentLevel];
	                    level.items[level.index]++;
	                },
	                nextLevel: function TagTree_nextLevel() {
	                    var currentLevel = this.currentLevel;
	                    var level = this.levels[currentLevel];
	                    var value = level.items[level.index];
	                    currentLevel--;
	                    if (currentLevel < 0) {
	                        this.value = value;
	                        return false;
	                    }
	                    this.currentLevel = currentLevel;
	                    level = this.levels[currentLevel];
	                    level.items[level.index] = value;
	                    return true;
	                }
	            };
	            return TagTree;
	        }();
	        var InclusionTree = function InclusionTreeClosure() {
	            function InclusionTree(width, height, defaultValue) {
	                var levelsLength = log2(Math.max(width, height)) + 1;
	                this.levels = [];
	                for (var i = 0; i < levelsLength; i++) {
	                    var items = new Uint8Array(width * height);
	                    for (var j = 0, jj = items.length; j < jj; j++) {
	                        items[j] = defaultValue;
	                    }
	                    var level = {
	                        width: width,
	                        height: height,
	                        items: items
	                    };
	                    this.levels.push(level);
	                    width = Math.ceil(width / 2);
	                    height = Math.ceil(height / 2);
	                }
	            }
	            InclusionTree.prototype = {
	                reset: function InclusionTree_reset(i, j, stopValue) {
	                    var currentLevel = 0;
	                    while (currentLevel < this.levels.length) {
	                        var level = this.levels[currentLevel];
	                        var index = i + j * level.width;
	                        level.index = index;
	                        var value = level.items[index];
	                        if (value === 255) {
	                            break;
	                        }
	                        if (value > stopValue) {
	                            this.currentLevel = currentLevel;
	                            this.propagateValues();
	                            return false;
	                        }
	                        i >>= 1;
	                        j >>= 1;
	                        currentLevel++;
	                    }
	                    this.currentLevel = currentLevel - 1;
	                    return true;
	                },
	                incrementValue: function InclusionTree_incrementValue(stopValue) {
	                    var level = this.levels[this.currentLevel];
	                    level.items[level.index] = stopValue + 1;
	                    this.propagateValues();
	                },
	                propagateValues: function InclusionTree_propagateValues() {
	                    var levelIndex = this.currentLevel;
	                    var level = this.levels[levelIndex];
	                    var currentValue = level.items[level.index];
	                    while (--levelIndex >= 0) {
	                        level = this.levels[levelIndex];
	                        level.items[level.index] = currentValue;
	                    }
	                },
	                nextLevel: function InclusionTree_nextLevel() {
	                    var currentLevel = this.currentLevel;
	                    var level = this.levels[currentLevel];
	                    var value = level.items[level.index];
	                    level.items[level.index] = 255;
	                    currentLevel--;
	                    if (currentLevel < 0) {
	                        return false;
	                    }
	                    this.currentLevel = currentLevel;
	                    level = this.levels[currentLevel];
	                    level.items[level.index] = value;
	                    return true;
	                }
	            };
	            return InclusionTree;
	        }();
	        var BitModel = function BitModelClosure() {
	            var UNIFORM_CONTEXT = 17;
	            var RUNLENGTH_CONTEXT = 18;
	            var LLAndLHContextsLabel = new Uint8Array([ 0, 5, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 1, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8 ]);
	            var HLContextLabel = new Uint8Array([ 0, 3, 4, 0, 5, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 1, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8 ]);
	            var HHContextLabel = new Uint8Array([ 0, 1, 2, 0, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 3, 4, 5, 0, 4, 5, 5, 0, 5, 5, 5, 0, 0, 0, 0, 0, 6, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8 ]);
	            function BitModel(width, height, subband, zeroBitPlanes, mb) {
	                this.width = width;
	                this.height = height;
	                this.contextLabelTable = subband === "HH" ? HHContextLabel : subband === "HL" ? HLContextLabel : LLAndLHContextsLabel;
	                var coefficientCount = width * height;
	                this.neighborsSignificance = new Uint8Array(coefficientCount);
	                this.coefficentsSign = new Uint8Array(coefficientCount);
	                this.coefficentsMagnitude = mb > 14 ? new Uint32Array(coefficientCount) : mb > 6 ? new Uint16Array(coefficientCount) : new Uint8Array(coefficientCount);
	                this.processingFlags = new Uint8Array(coefficientCount);
	                var bitsDecoded = new Uint8Array(coefficientCount);
	                if (zeroBitPlanes !== 0) {
	                    for (var i = 0; i < coefficientCount; i++) {
	                        bitsDecoded[i] = zeroBitPlanes;
	                    }
	                }
	                this.bitsDecoded = bitsDecoded;
	                this.reset();
	            }
	            BitModel.prototype = {
	                setDecoder: function BitModel_setDecoder(decoder) {
	                    this.decoder = decoder;
	                },
	                reset: function BitModel_reset() {
	                    this.contexts = new Int8Array(19);
	                    this.contexts[0] = 4 << 1 | 0;
	                    this.contexts[UNIFORM_CONTEXT] = 46 << 1 | 0;
	                    this.contexts[RUNLENGTH_CONTEXT] = 3 << 1 | 0;
	                },
	                setNeighborsSignificance: function BitModel_setNeighborsSignificance(row, column, index) {
	                    var neighborsSignificance = this.neighborsSignificance;
	                    var width = this.width, height = this.height;
	                    var left = column > 0;
	                    var right = column + 1 < width;
	                    var i;
	                    if (row > 0) {
	                        i = index - width;
	                        if (left) {
	                            neighborsSignificance[i - 1] += 16;
	                        }
	                        if (right) {
	                            neighborsSignificance[i + 1] += 16;
	                        }
	                        neighborsSignificance[i] += 4;
	                    }
	                    if (row + 1 < height) {
	                        i = index + width;
	                        if (left) {
	                            neighborsSignificance[i - 1] += 16;
	                        }
	                        if (right) {
	                            neighborsSignificance[i + 1] += 16;
	                        }
	                        neighborsSignificance[i] += 4;
	                    }
	                    if (left) {
	                        neighborsSignificance[index - 1] += 1;
	                    }
	                    if (right) {
	                        neighborsSignificance[index + 1] += 1;
	                    }
	                    neighborsSignificance[index] |= 128;
	                },
	                runSignificancePropogationPass: function BitModel_runSignificancePropogationPass() {
	                    var decoder = this.decoder;
	                    var width = this.width, height = this.height;
	                    var coefficentsMagnitude = this.coefficentsMagnitude;
	                    var coefficentsSign = this.coefficentsSign;
	                    var neighborsSignificance = this.neighborsSignificance;
	                    var processingFlags = this.processingFlags;
	                    var contexts = this.contexts;
	                    var labels = this.contextLabelTable;
	                    var bitsDecoded = this.bitsDecoded;
	                    var processedInverseMask = ~1;
	                    var processedMask = 1;
	                    var firstMagnitudeBitMask = 2;
	                    for (var i0 = 0; i0 < height; i0 += 4) {
	                        for (var j = 0; j < width; j++) {
	                            var index = i0 * width + j;
	                            for (var i1 = 0; i1 < 4; i1++, index += width) {
	                                var i = i0 + i1;
	                                if (i >= height) {
	                                    break;
	                                }
	                                processingFlags[index] &= processedInverseMask;
	                                if (coefficentsMagnitude[index] || !neighborsSignificance[index]) {
	                                    continue;
	                                }
	                                var contextLabel = labels[neighborsSignificance[index]];
	                                var decision = decoder.readBit(contexts, contextLabel);
	                                if (decision) {
	                                    var sign = this.decodeSignBit(i, j, index);
	                                    coefficentsSign[index] = sign;
	                                    coefficentsMagnitude[index] = 1;
	                                    this.setNeighborsSignificance(i, j, index);
	                                    processingFlags[index] |= firstMagnitudeBitMask;
	                                }
	                                bitsDecoded[index]++;
	                                processingFlags[index] |= processedMask;
	                            }
	                        }
	                    }
	                },
	                decodeSignBit: function BitModel_decodeSignBit(row, column, index) {
	                    var width = this.width, height = this.height;
	                    var coefficentsMagnitude = this.coefficentsMagnitude;
	                    var coefficentsSign = this.coefficentsSign;
	                    var contribution, sign0, sign1, significance1;
	                    var contextLabel, decoded;
	                    significance1 = column > 0 && coefficentsMagnitude[index - 1] !== 0;
	                    if (column + 1 < width && coefficentsMagnitude[index + 1] !== 0) {
	                        sign1 = coefficentsSign[index + 1];
	                        if (significance1) {
	                            sign0 = coefficentsSign[index - 1];
	                            contribution = 1 - sign1 - sign0;
	                        } else {
	                            contribution = 1 - sign1 - sign1;
	                        }
	                    } else if (significance1) {
	                        sign0 = coefficentsSign[index - 1];
	                        contribution = 1 - sign0 - sign0;
	                    } else {
	                        contribution = 0;
	                    }
	                    var horizontalContribution = 3 * contribution;
	                    significance1 = row > 0 && coefficentsMagnitude[index - width] !== 0;
	                    if (row + 1 < height && coefficentsMagnitude[index + width] !== 0) {
	                        sign1 = coefficentsSign[index + width];
	                        if (significance1) {
	                            sign0 = coefficentsSign[index - width];
	                            contribution = 1 - sign1 - sign0 + horizontalContribution;
	                        } else {
	                            contribution = 1 - sign1 - sign1 + horizontalContribution;
	                        }
	                    } else if (significance1) {
	                        sign0 = coefficentsSign[index - width];
	                        contribution = 1 - sign0 - sign0 + horizontalContribution;
	                    } else {
	                        contribution = horizontalContribution;
	                    }
	                    if (contribution >= 0) {
	                        contextLabel = 9 + contribution;
	                        decoded = this.decoder.readBit(this.contexts, contextLabel);
	                    } else {
	                        contextLabel = 9 - contribution;
	                        decoded = this.decoder.readBit(this.contexts, contextLabel) ^ 1;
	                    }
	                    return decoded;
	                },
	                runMagnitudeRefinementPass: function BitModel_runMagnitudeRefinementPass() {
	                    var decoder = this.decoder;
	                    var width = this.width, height = this.height;
	                    var coefficentsMagnitude = this.coefficentsMagnitude;
	                    var neighborsSignificance = this.neighborsSignificance;
	                    var contexts = this.contexts;
	                    var bitsDecoded = this.bitsDecoded;
	                    var processingFlags = this.processingFlags;
	                    var processedMask = 1;
	                    var firstMagnitudeBitMask = 2;
	                    var length = width * height;
	                    var width4 = width * 4;
	                    for (var index0 = 0, indexNext; index0 < length; index0 = indexNext) {
	                        indexNext = Math.min(length, index0 + width4);
	                        for (var j = 0; j < width; j++) {
	                            for (var index = index0 + j; index < indexNext; index += width) {
	                                if (!coefficentsMagnitude[index] || (processingFlags[index] & processedMask) !== 0) {
	                                    continue;
	                                }
	                                var contextLabel = 16;
	                                if ((processingFlags[index] & firstMagnitudeBitMask) !== 0) {
	                                    processingFlags[index] ^= firstMagnitudeBitMask;
	                                    var significance = neighborsSignificance[index] & 127;
	                                    contextLabel = significance === 0 ? 15 : 14;
	                                }
	                                var bit = decoder.readBit(contexts, contextLabel);
	                                coefficentsMagnitude[index] = coefficentsMagnitude[index] << 1 | bit;
	                                bitsDecoded[index]++;
	                                processingFlags[index] |= processedMask;
	                            }
	                        }
	                    }
	                },
	                runCleanupPass: function BitModel_runCleanupPass() {
	                    var decoder = this.decoder;
	                    var width = this.width, height = this.height;
	                    var neighborsSignificance = this.neighborsSignificance;
	                    var coefficentsMagnitude = this.coefficentsMagnitude;
	                    var coefficentsSign = this.coefficentsSign;
	                    var contexts = this.contexts;
	                    var labels = this.contextLabelTable;
	                    var bitsDecoded = this.bitsDecoded;
	                    var processingFlags = this.processingFlags;
	                    var processedMask = 1;
	                    var firstMagnitudeBitMask = 2;
	                    var oneRowDown = width;
	                    var twoRowsDown = width * 2;
	                    var threeRowsDown = width * 3;
	                    var iNext;
	                    for (var i0 = 0; i0 < height; i0 = iNext) {
	                        iNext = Math.min(i0 + 4, height);
	                        var indexBase = i0 * width;
	                        var checkAllEmpty = i0 + 3 < height;
	                        for (var j = 0; j < width; j++) {
	                            var index0 = indexBase + j;
	                            var allEmpty = checkAllEmpty && processingFlags[index0] === 0 && processingFlags[index0 + oneRowDown] === 0 && processingFlags[index0 + twoRowsDown] === 0 && processingFlags[index0 + threeRowsDown] === 0 && neighborsSignificance[index0] === 0 && neighborsSignificance[index0 + oneRowDown] === 0 && neighborsSignificance[index0 + twoRowsDown] === 0 && neighborsSignificance[index0 + threeRowsDown] === 0;
	                            var i1 = 0, index = index0;
	                            var i = i0, sign;
	                            if (allEmpty) {
	                                var hasSignificantCoefficent = decoder.readBit(contexts, RUNLENGTH_CONTEXT);
	                                if (!hasSignificantCoefficent) {
	                                    bitsDecoded[index0]++;
	                                    bitsDecoded[index0 + oneRowDown]++;
	                                    bitsDecoded[index0 + twoRowsDown]++;
	                                    bitsDecoded[index0 + threeRowsDown]++;
	                                    continue;
	                                }
	                                i1 = decoder.readBit(contexts, UNIFORM_CONTEXT) << 1 | decoder.readBit(contexts, UNIFORM_CONTEXT);
	                                if (i1 !== 0) {
	                                    i = i0 + i1;
	                                    index += i1 * width;
	                                }
	                                sign = this.decodeSignBit(i, j, index);
	                                coefficentsSign[index] = sign;
	                                coefficentsMagnitude[index] = 1;
	                                this.setNeighborsSignificance(i, j, index);
	                                processingFlags[index] |= firstMagnitudeBitMask;
	                                index = index0;
	                                for (var i2 = i0; i2 <= i; i2++, index += width) {
	                                    bitsDecoded[index]++;
	                                }
	                                i1++;
	                            }
	                            for (i = i0 + i1; i < iNext; i++, index += width) {
	                                if (coefficentsMagnitude[index] || (processingFlags[index] & processedMask) !== 0) {
	                                    continue;
	                                }
	                                var contextLabel = labels[neighborsSignificance[index]];
	                                var decision = decoder.readBit(contexts, contextLabel);
	                                if (decision === 1) {
	                                    sign = this.decodeSignBit(i, j, index);
	                                    coefficentsSign[index] = sign;
	                                    coefficentsMagnitude[index] = 1;
	                                    this.setNeighborsSignificance(i, j, index);
	                                    processingFlags[index] |= firstMagnitudeBitMask;
	                                }
	                                bitsDecoded[index]++;
	                            }
	                        }
	                    }
	                },
	                checkSegmentationSymbol: function BitModel_checkSegmentationSymbol() {
	                    var decoder = this.decoder;
	                    var contexts = this.contexts;
	                    var symbol = decoder.readBit(contexts, UNIFORM_CONTEXT) << 3 | decoder.readBit(contexts, UNIFORM_CONTEXT) << 2 | decoder.readBit(contexts, UNIFORM_CONTEXT) << 1 | decoder.readBit(contexts, UNIFORM_CONTEXT);
	                    if (symbol !== 10) {
	                        throw new Error("JPX Error: Invalid segmentation symbol");
	                    }
	                }
	            };
	            return BitModel;
	        }();
	        var Transform = function TransformClosure() {
	            function Transform() {}
	            Transform.prototype.calculate = function transformCalculate(subbands, u0, v0) {
	                var ll = subbands[0];
	                for (var i = 1, ii = subbands.length; i < ii; i++) {
	                    ll = this.iterate(ll, subbands[i], u0, v0);
	                }
	                return ll;
	            };
	            Transform.prototype.extend = function extend(buffer, offset, size) {
	                var i1 = offset - 1, j1 = offset + 1;
	                var i2 = offset + size - 2, j2 = offset + size;
	                buffer[i1--] = buffer[j1++];
	                buffer[j2++] = buffer[i2--];
	                buffer[i1--] = buffer[j1++];
	                buffer[j2++] = buffer[i2--];
	                buffer[i1--] = buffer[j1++];
	                buffer[j2++] = buffer[i2--];
	                buffer[i1] = buffer[j1];
	                buffer[j2] = buffer[i2];
	            };
	            Transform.prototype.iterate = function Transform_iterate(ll, hl_lh_hh, u0, v0) {
	                var llWidth = ll.width, llHeight = ll.height, llItems = ll.items;
	                var width = hl_lh_hh.width;
	                var height = hl_lh_hh.height;
	                var items = hl_lh_hh.items;
	                var i, j, k, l, u, v;
	                for (k = 0, i = 0; i < llHeight; i++) {
	                    l = i * 2 * width;
	                    for (j = 0; j < llWidth; j++, k++, l += 2) {
	                        items[l] = llItems[k];
	                    }
	                }
	                llItems = ll.items = null;
	                var bufferPadding = 4;
	                var rowBuffer = new Float32Array(width + 2 * bufferPadding);
	                if (width === 1) {
	                    if ((u0 & 1) !== 0) {
	                        for (v = 0, k = 0; v < height; v++, k += width) {
	                            items[k] *= .5;
	                        }
	                    }
	                } else {
	                    for (v = 0, k = 0; v < height; v++, k += width) {
	                        rowBuffer.set(items.subarray(k, k + width), bufferPadding);
	                        this.extend(rowBuffer, bufferPadding, width);
	                        this.filter(rowBuffer, bufferPadding, width);
	                        items.set(rowBuffer.subarray(bufferPadding, bufferPadding + width), k);
	                    }
	                }
	                var numBuffers = 16;
	                var colBuffers = [];
	                for (i = 0; i < numBuffers; i++) {
	                    colBuffers.push(new Float32Array(height + 2 * bufferPadding));
	                }
	                var b, currentBuffer = 0;
	                ll = bufferPadding + height;
	                if (height === 1) {
	                    if ((v0 & 1) !== 0) {
	                        for (u = 0; u < width; u++) {
	                            items[u] *= .5;
	                        }
	                    }
	                } else {
	                    for (u = 0; u < width; u++) {
	                        if (currentBuffer === 0) {
	                            numBuffers = Math.min(width - u, numBuffers);
	                            for (k = u, l = bufferPadding; l < ll; k += width, l++) {
	                                for (b = 0; b < numBuffers; b++) {
	                                    colBuffers[b][l] = items[k + b];
	                                }
	                            }
	                            currentBuffer = numBuffers;
	                        }
	                        currentBuffer--;
	                        var buffer = colBuffers[currentBuffer];
	                        this.extend(buffer, bufferPadding, height);
	                        this.filter(buffer, bufferPadding, height);
	                        if (currentBuffer === 0) {
	                            k = u - numBuffers + 1;
	                            for (l = bufferPadding; l < ll; k += width, l++) {
	                                for (b = 0; b < numBuffers; b++) {
	                                    items[k + b] = colBuffers[b][l];
	                                }
	                            }
	                        }
	                    }
	                }
	                return {
	                    width: width,
	                    height: height,
	                    items: items
	                };
	            };
	            return Transform;
	        }();
	        var IrreversibleTransform = function IrreversibleTransformClosure() {
	            function IrreversibleTransform() {
	                Transform.call(this);
	            }
	            IrreversibleTransform.prototype = Object.create(Transform.prototype);
	            IrreversibleTransform.prototype.filter = function irreversibleTransformFilter(x, offset, length) {
	                var len = length >> 1;
	                offset = offset | 0;
	                var j, n, current, next;
	                var alpha = -1.586134342059924;
	                var beta = -.052980118572961;
	                var gamma = .882911075530934;
	                var delta = .443506852043971;
	                var K = 1.230174104914001;
	                var K_ = 1 / K;
	                j = offset - 3;
	                for (n = len + 4; n--; j += 2) {
	                    x[j] *= K_;
	                }
	                j = offset - 2;
	                current = delta * x[j - 1];
	                for (n = len + 3; n--; j += 2) {
	                    next = delta * x[j + 1];
	                    x[j] = K * x[j] - current - next;
	                    if (n--) {
	                        j += 2;
	                        current = delta * x[j + 1];
	                        x[j] = K * x[j] - current - next;
	                    } else {
	                        break;
	                    }
	                }
	                j = offset - 1;
	                current = gamma * x[j - 1];
	                for (n = len + 2; n--; j += 2) {
	                    next = gamma * x[j + 1];
	                    x[j] -= current + next;
	                    if (n--) {
	                        j += 2;
	                        current = gamma * x[j + 1];
	                        x[j] -= current + next;
	                    } else {
	                        break;
	                    }
	                }
	                j = offset;
	                current = beta * x[j - 1];
	                for (n = len + 1; n--; j += 2) {
	                    next = beta * x[j + 1];
	                    x[j] -= current + next;
	                    if (n--) {
	                        j += 2;
	                        current = beta * x[j + 1];
	                        x[j] -= current + next;
	                    } else {
	                        break;
	                    }
	                }
	                if (len !== 0) {
	                    j = offset + 1;
	                    current = alpha * x[j - 1];
	                    for (n = len; n--; j += 2) {
	                        next = alpha * x[j + 1];
	                        x[j] -= current + next;
	                        if (n--) {
	                            j += 2;
	                            current = alpha * x[j + 1];
	                            x[j] -= current + next;
	                        } else {
	                            break;
	                        }
	                    }
	                }
	            };
	            return IrreversibleTransform;
	        }();
	        var ReversibleTransform = function ReversibleTransformClosure() {
	            function ReversibleTransform() {
	                Transform.call(this);
	            }
	            ReversibleTransform.prototype = Object.create(Transform.prototype);
	            ReversibleTransform.prototype.filter = function reversibleTransformFilter(x, offset, length) {
	                var len = length >> 1;
	                offset = offset | 0;
	                var j, n;
	                for (j = offset, n = len + 1; n--; j += 2) {
	                    x[j] -= x[j - 1] + x[j + 1] + 2 >> 2;
	                }
	                for (j = offset + 1, n = len; n--; j += 2) {
	                    x[j] += x[j - 1] + x[j + 1] >> 1;
	                }
	            };
	            return ReversibleTransform;
	        }();
	        return JpxImage;
	    }();
	    var Jbig2Image = function Jbig2ImageClosure() {
	        function ContextCache() {}
	        ContextCache.prototype = {
	            getContexts: function(id) {
	                if (id in this) {
	                    return this[id];
	                }
	                return this[id] = new Int8Array(1 << 16);
	            }
	        };
	        function DecodingContext(data, start, end) {
	            this.data = data;
	            this.start = start;
	            this.end = end;
	        }
	        DecodingContext.prototype = {
	            get decoder() {
	                var decoder = new ArithmeticDecoder(this.data, this.start, this.end);
	                return shadow(this, "decoder", decoder);
	            },
	            get contextCache() {
	                var cache = new ContextCache();
	                return shadow(this, "contextCache", cache);
	            }
	        };
	        function decodeInteger(contextCache, procedure, decoder) {
	            var contexts = contextCache.getContexts(procedure);
	            var prev = 1;
	            function readBits(length) {
	                var v = 0;
	                for (var i = 0; i < length; i++) {
	                    var bit = decoder.readBit(contexts, prev);
	                    prev = prev < 256 ? prev << 1 | bit : (prev << 1 | bit) & 511 | 256;
	                    v = v << 1 | bit;
	                }
	                return v >>> 0;
	            }
	            var sign = readBits(1);
	            var value = readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(32) + 4436 : readBits(12) + 340 : readBits(8) + 84 : readBits(6) + 20 : readBits(4) + 4 : readBits(2);
	            return sign === 0 ? value : value > 0 ? -value : null;
	        }
	        function decodeIAID(contextCache, decoder, codeLength) {
	            var contexts = contextCache.getContexts("IAID");
	            var prev = 1;
	            for (var i = 0; i < codeLength; i++) {
	                var bit = decoder.readBit(contexts, prev);
	                prev = prev << 1 | bit;
	            }
	            if (codeLength < 31) {
	                return prev & (1 << codeLength) - 1;
	            }
	            return prev & 2147483647;
	        }
	        var SegmentTypes = [ "SymbolDictionary", null, null, null, "IntermediateTextRegion", null, "ImmediateTextRegion", "ImmediateLosslessTextRegion", null, null, null, null, null, null, null, null, "patternDictionary", null, null, null, "IntermediateHalftoneRegion", null, "ImmediateHalftoneRegion", "ImmediateLosslessHalftoneRegion", null, null, null, null, null, null, null, null, null, null, null, null, "IntermediateGenericRegion", null, "ImmediateGenericRegion", "ImmediateLosslessGenericRegion", "IntermediateGenericRefinementRegion", null, "ImmediateGenericRefinementRegion", "ImmediateLosslessGenericRefinementRegion", null, null, null, null, "PageInformation", "EndOfPage", "EndOfStripe", "EndOfFile", "Profiles", "Tables", null, null, null, null, null, null, null, null, "Extension" ];
	        var CodingTemplates = [ [ {
	            x: -1,
	            y: -2
	        }, {
	            x: 0,
	            y: -2
	        }, {
	            x: 1,
	            y: -2
	        }, {
	            x: -2,
	            y: -1
	        }, {
	            x: -1,
	            y: -1
	        }, {
	            x: 0,
	            y: -1
	        }, {
	            x: 1,
	            y: -1
	        }, {
	            x: 2,
	            y: -1
	        }, {
	            x: -4,
	            y: 0
	        }, {
	            x: -3,
	            y: 0
	        }, {
	            x: -2,
	            y: 0
	        }, {
	            x: -1,
	            y: 0
	        } ], [ {
	            x: -1,
	            y: -2
	        }, {
	            x: 0,
	            y: -2
	        }, {
	            x: 1,
	            y: -2
	        }, {
	            x: 2,
	            y: -2
	        }, {
	            x: -2,
	            y: -1
	        }, {
	            x: -1,
	            y: -1
	        }, {
	            x: 0,
	            y: -1
	        }, {
	            x: 1,
	            y: -1
	        }, {
	            x: 2,
	            y: -1
	        }, {
	            x: -3,
	            y: 0
	        }, {
	            x: -2,
	            y: 0
	        }, {
	            x: -1,
	            y: 0
	        } ], [ {
	            x: -1,
	            y: -2
	        }, {
	            x: 0,
	            y: -2
	        }, {
	            x: 1,
	            y: -2
	        }, {
	            x: -2,
	            y: -1
	        }, {
	            x: -1,
	            y: -1
	        }, {
	            x: 0,
	            y: -1
	        }, {
	            x: 1,
	            y: -1
	        }, {
	            x: -2,
	            y: 0
	        }, {
	            x: -1,
	            y: 0
	        } ], [ {
	            x: -3,
	            y: -1
	        }, {
	            x: -2,
	            y: -1
	        }, {
	            x: -1,
	            y: -1
	        }, {
	            x: 0,
	            y: -1
	        }, {
	            x: 1,
	            y: -1
	        }, {
	            x: -4,
	            y: 0
	        }, {
	            x: -3,
	            y: 0
	        }, {
	            x: -2,
	            y: 0
	        }, {
	            x: -1,
	            y: 0
	        } ] ];
	        var RefinementTemplates = [ {
	            coding: [ {
	                x: 0,
	                y: -1
	            }, {
	                x: 1,
	                y: -1
	            }, {
	                x: -1,
	                y: 0
	            } ],
	            reference: [ {
	                x: 0,
	                y: -1
	            }, {
	                x: 1,
	                y: -1
	            }, {
	                x: -1,
	                y: 0
	            }, {
	                x: 0,
	                y: 0
	            }, {
	                x: 1,
	                y: 0
	            }, {
	                x: -1,
	                y: 1
	            }, {
	                x: 0,
	                y: 1
	            }, {
	                x: 1,
	                y: 1
	            } ]
	        }, {
	            coding: [ {
	                x: -1,
	                y: -1
	            }, {
	                x: 0,
	                y: -1
	            }, {
	                x: 1,
	                y: -1
	            }, {
	                x: -1,
	                y: 0
	            } ],
	            reference: [ {
	                x: 0,
	                y: -1
	            }, {
	                x: -1,
	                y: 0
	            }, {
	                x: 0,
	                y: 0
	            }, {
	                x: 1,
	                y: 0
	            }, {
	                x: 0,
	                y: 1
	            }, {
	                x: 1,
	                y: 1
	            } ]
	        } ];
	        var ReusedContexts = [ 39717, 1941, 229, 405 ];
	        var RefinementReusedContexts = [ 32, 8 ];
	        function decodeBitmapTemplate0(width, height, decodingContext) {
	            var decoder = decodingContext.decoder;
	            var contexts = decodingContext.contextCache.getContexts("GB");
	            var contextLabel, i, j, pixel, row, row1, row2, bitmap = [];
	            var OLD_PIXEL_MASK = 31735;
	            for (i = 0; i < height; i++) {
	                row = bitmap[i] = new Uint8Array(width);
	                row1 = i < 1 ? row : bitmap[i - 1];
	                row2 = i < 2 ? row : bitmap[i - 2];
	                contextLabel = row2[0] << 13 | row2[1] << 12 | row2[2] << 11 | row1[0] << 7 | row1[1] << 6 | row1[2] << 5 | row1[3] << 4;
	                for (j = 0; j < width; j++) {
	                    row[j] = pixel = decoder.readBit(contexts, contextLabel);
	                    contextLabel = (contextLabel & OLD_PIXEL_MASK) << 1 | (j + 3 < width ? row2[j + 3] << 11 : 0) | (j + 4 < width ? row1[j + 4] << 4 : 0) | pixel;
	                }
	            }
	            return bitmap;
	        }
	        function decodeBitmap(mmr, width, height, templateIndex, prediction, skip, at, decodingContext) {
	            if (mmr) {
	                error("JBIG2 error: MMR encoding is not supported");
	            }
	            if (templateIndex === 0 && !skip && !prediction && at.length === 4 && at[0].x === 3 && at[0].y === -1 && at[1].x === -3 && at[1].y === -1 && at[2].x === 2 && at[2].y === -2 && at[3].x === -2 && at[3].y === -2) {
	                return decodeBitmapTemplate0(width, height, decodingContext);
	            }
	            var useskip = !!skip;
	            var template = CodingTemplates[templateIndex].concat(at);
	            template.sort(function(a, b) {
	                return a.y - b.y || a.x - b.x;
	            });
	            var templateLength = template.length;
	            var templateX = new Int8Array(templateLength);
	            var templateY = new Int8Array(templateLength);
	            var changingTemplateEntries = [];
	            var reuseMask = 0, minX = 0, maxX = 0, minY = 0;
	            var c, k;
	            for (k = 0; k < templateLength; k++) {
	                templateX[k] = template[k].x;
	                templateY[k] = template[k].y;
	                minX = Math.min(minX, template[k].x);
	                maxX = Math.max(maxX, template[k].x);
	                minY = Math.min(minY, template[k].y);
	                if (k < templateLength - 1 && template[k].y === template[k + 1].y && template[k].x === template[k + 1].x - 1) {
	                    reuseMask |= 1 << templateLength - 1 - k;
	                } else {
	                    changingTemplateEntries.push(k);
	                }
	            }
	            var changingEntriesLength = changingTemplateEntries.length;
	            var changingTemplateX = new Int8Array(changingEntriesLength);
	            var changingTemplateY = new Int8Array(changingEntriesLength);
	            var changingTemplateBit = new Uint16Array(changingEntriesLength);
	            for (c = 0; c < changingEntriesLength; c++) {
	                k = changingTemplateEntries[c];
	                changingTemplateX[c] = template[k].x;
	                changingTemplateY[c] = template[k].y;
	                changingTemplateBit[c] = 1 << templateLength - 1 - k;
	            }
	            var sbb_left = -minX;
	            var sbb_top = -minY;
	            var sbb_right = width - maxX;
	            var pseudoPixelContext = ReusedContexts[templateIndex];
	            var row = new Uint8Array(width);
	            var bitmap = [];
	            var decoder = decodingContext.decoder;
	            var contexts = decodingContext.contextCache.getContexts("GB");
	            var ltp = 0, j, i0, j0, contextLabel = 0, bit, shift;
	            for (var i = 0; i < height; i++) {
	                if (prediction) {
	                    var sltp = decoder.readBit(contexts, pseudoPixelContext);
	                    ltp ^= sltp;
	                    if (ltp) {
	                        bitmap.push(row);
	                        continue;
	                    }
	                }
	                row = new Uint8Array(row);
	                bitmap.push(row);
	                for (j = 0; j < width; j++) {
	                    if (useskip && skip[i][j]) {
	                        row[j] = 0;
	                        continue;
	                    }
	                    if (j >= sbb_left && j < sbb_right && i >= sbb_top) {
	                        contextLabel = contextLabel << 1 & reuseMask;
	                        for (k = 0; k < changingEntriesLength; k++) {
	                            i0 = i + changingTemplateY[k];
	                            j0 = j + changingTemplateX[k];
	                            bit = bitmap[i0][j0];
	                            if (bit) {
	                                bit = changingTemplateBit[k];
	                                contextLabel |= bit;
	                            }
	                        }
	                    } else {
	                        contextLabel = 0;
	                        shift = templateLength - 1;
	                        for (k = 0; k < templateLength; k++, shift--) {
	                            j0 = j + templateX[k];
	                            if (j0 >= 0 && j0 < width) {
	                                i0 = i + templateY[k];
	                                if (i0 >= 0) {
	                                    bit = bitmap[i0][j0];
	                                    if (bit) {
	                                        contextLabel |= bit << shift;
	                                    }
	                                }
	                            }
	                        }
	                    }
	                    var pixel = decoder.readBit(contexts, contextLabel);
	                    row[j] = pixel;
	                }
	            }
	            return bitmap;
	        }
	        function decodeRefinement(width, height, templateIndex, referenceBitmap, offsetX, offsetY, prediction, at, decodingContext) {
	            var codingTemplate = RefinementTemplates[templateIndex].coding;
	            if (templateIndex === 0) {
	                codingTemplate = codingTemplate.concat([ at[0] ]);
	            }
	            var codingTemplateLength = codingTemplate.length;
	            var codingTemplateX = new Int32Array(codingTemplateLength);
	            var codingTemplateY = new Int32Array(codingTemplateLength);
	            var k;
	            for (k = 0; k < codingTemplateLength; k++) {
	                codingTemplateX[k] = codingTemplate[k].x;
	                codingTemplateY[k] = codingTemplate[k].y;
	            }
	            var referenceTemplate = RefinementTemplates[templateIndex].reference;
	            if (templateIndex === 0) {
	                referenceTemplate = referenceTemplate.concat([ at[1] ]);
	            }
	            var referenceTemplateLength = referenceTemplate.length;
	            var referenceTemplateX = new Int32Array(referenceTemplateLength);
	            var referenceTemplateY = new Int32Array(referenceTemplateLength);
	            for (k = 0; k < referenceTemplateLength; k++) {
	                referenceTemplateX[k] = referenceTemplate[k].x;
	                referenceTemplateY[k] = referenceTemplate[k].y;
	            }
	            var referenceWidth = referenceBitmap[0].length;
	            var referenceHeight = referenceBitmap.length;
	            var pseudoPixelContext = RefinementReusedContexts[templateIndex];
	            var bitmap = [];
	            var decoder = decodingContext.decoder;
	            var contexts = decodingContext.contextCache.getContexts("GR");
	            var ltp = 0;
	            for (var i = 0; i < height; i++) {
	                if (prediction) {
	                    var sltp = decoder.readBit(contexts, pseudoPixelContext);
	                    ltp ^= sltp;
	                    if (ltp) {
	                        error("JBIG2 error: prediction is not supported");
	                    }
	                }
	                var row = new Uint8Array(width);
	                bitmap.push(row);
	                for (var j = 0; j < width; j++) {
	                    var i0, j0;
	                    var contextLabel = 0;
	                    for (k = 0; k < codingTemplateLength; k++) {
	                        i0 = i + codingTemplateY[k];
	                        j0 = j + codingTemplateX[k];
	                        if (i0 < 0 || j0 < 0 || j0 >= width) {
	                            contextLabel <<= 1;
	                        } else {
	                            contextLabel = contextLabel << 1 | bitmap[i0][j0];
	                        }
	                    }
	                    for (k = 0; k < referenceTemplateLength; k++) {
	                        i0 = i + referenceTemplateY[k] + offsetY;
	                        j0 = j + referenceTemplateX[k] + offsetX;
	                        if (i0 < 0 || i0 >= referenceHeight || j0 < 0 || j0 >= referenceWidth) {
	                            contextLabel <<= 1;
	                        } else {
	                            contextLabel = contextLabel << 1 | referenceBitmap[i0][j0];
	                        }
	                    }
	                    var pixel = decoder.readBit(contexts, contextLabel);
	                    row[j] = pixel;
	                }
	            }
	            return bitmap;
	        }
	        function decodeSymbolDictionary(huffman, refinement, symbols, numberOfNewSymbols, numberOfExportedSymbols, huffmanTables, templateIndex, at, refinementTemplateIndex, refinementAt, decodingContext) {
	            if (huffman) {
	                error("JBIG2 error: huffman is not supported");
	            }
	            var newSymbols = [];
	            var currentHeight = 0;
	            var symbolCodeLength = log2(symbols.length + numberOfNewSymbols);
	            var decoder = decodingContext.decoder;
	            var contextCache = decodingContext.contextCache;
	            while (newSymbols.length < numberOfNewSymbols) {
	                var deltaHeight = decodeInteger(contextCache, "IADH", decoder);
	                currentHeight += deltaHeight;
	                var currentWidth = 0;
	                while (true) {
	                    var deltaWidth = decodeInteger(contextCache, "IADW", decoder);
	                    if (deltaWidth === null) {
	                        break;
	                    }
	                    currentWidth += deltaWidth;
	                    var bitmap;
	                    if (refinement) {
	                        var numberOfInstances = decodeInteger(contextCache, "IAAI", decoder);
	                        if (numberOfInstances > 1) {
	                            bitmap = decodeTextRegion(huffman, refinement, currentWidth, currentHeight, 0, numberOfInstances, 1, symbols.concat(newSymbols), symbolCodeLength, 0, 0, 1, 0, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext);
	                        } else {
	                            var symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
	                            var rdx = decodeInteger(contextCache, "IARDX", decoder);
	                            var rdy = decodeInteger(contextCache, "IARDY", decoder);
	                            var symbol = symbolId < symbols.length ? symbols[symbolId] : newSymbols[symbolId - symbols.length];
	                            bitmap = decodeRefinement(currentWidth, currentHeight, refinementTemplateIndex, symbol, rdx, rdy, false, refinementAt, decodingContext);
	                        }
	                    } else {
	                        bitmap = decodeBitmap(false, currentWidth, currentHeight, templateIndex, false, null, at, decodingContext);
	                    }
	                    newSymbols.push(bitmap);
	                }
	            }
	            var exportedSymbols = [];
	            var flags = [], currentFlag = false;
	            var totalSymbolsLength = symbols.length + numberOfNewSymbols;
	            while (flags.length < totalSymbolsLength) {
	                var runLength = decodeInteger(contextCache, "IAEX", decoder);
	                while (runLength--) {
	                    flags.push(currentFlag);
	                }
	                currentFlag = !currentFlag;
	            }
	            for (var i = 0, ii = symbols.length; i < ii; i++) {
	                if (flags[i]) {
	                    exportedSymbols.push(symbols[i]);
	                }
	            }
	            for (var j = 0; j < numberOfNewSymbols; i++, j++) {
	                if (flags[i]) {
	                    exportedSymbols.push(newSymbols[j]);
	                }
	            }
	            return exportedSymbols;
	        }
	        function decodeTextRegion(huffman, refinement, width, height, defaultPixelValue, numberOfSymbolInstances, stripSize, inputSymbols, symbolCodeLength, transposed, dsOffset, referenceCorner, combinationOperator, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext) {
	            if (huffman) {
	                error("JBIG2 error: huffman is not supported");
	            }
	            var bitmap = [];
	            var i, row;
	            for (i = 0; i < height; i++) {
	                row = new Uint8Array(width);
	                if (defaultPixelValue) {
	                    for (var j = 0; j < width; j++) {
	                        row[j] = defaultPixelValue;
	                    }
	                }
	                bitmap.push(row);
	            }
	            var decoder = decodingContext.decoder;
	            var contextCache = decodingContext.contextCache;
	            var stripT = -decodeInteger(contextCache, "IADT", decoder);
	            var firstS = 0;
	            i = 0;
	            while (i < numberOfSymbolInstances) {
	                var deltaT = decodeInteger(contextCache, "IADT", decoder);
	                stripT += deltaT;
	                var deltaFirstS = decodeInteger(contextCache, "IAFS", decoder);
	                firstS += deltaFirstS;
	                var currentS = firstS;
	                do {
	                    var currentT = stripSize === 1 ? 0 : decodeInteger(contextCache, "IAIT", decoder);
	                    var t = stripSize * stripT + currentT;
	                    var symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
	                    var applyRefinement = refinement && decodeInteger(contextCache, "IARI", decoder);
	                    var symbolBitmap = inputSymbols[symbolId];
	                    var symbolWidth = symbolBitmap[0].length;
	                    var symbolHeight = symbolBitmap.length;
	                    if (applyRefinement) {
	                        var rdw = decodeInteger(contextCache, "IARDW", decoder);
	                        var rdh = decodeInteger(contextCache, "IARDH", decoder);
	                        var rdx = decodeInteger(contextCache, "IARDX", decoder);
	                        var rdy = decodeInteger(contextCache, "IARDY", decoder);
	                        symbolWidth += rdw;
	                        symbolHeight += rdh;
	                        symbolBitmap = decodeRefinement(symbolWidth, symbolHeight, refinementTemplateIndex, symbolBitmap, (rdw >> 1) + rdx, (rdh >> 1) + rdy, false, refinementAt, decodingContext);
	                    }
	                    var offsetT = t - (referenceCorner & 1 ? 0 : symbolHeight);
	                    var offsetS = currentS - (referenceCorner & 2 ? symbolWidth : 0);
	                    var s2, t2, symbolRow;
	                    if (transposed) {
	                        for (s2 = 0; s2 < symbolHeight; s2++) {
	                            row = bitmap[offsetS + s2];
	                            if (!row) {
	                                continue;
	                            }
	                            symbolRow = symbolBitmap[s2];
	                            var maxWidth = Math.min(width - offsetT, symbolWidth);
	                            switch (combinationOperator) {
	                              case 0:
	                                for (t2 = 0; t2 < maxWidth; t2++) {
	                                    row[offsetT + t2] |= symbolRow[t2];
	                                }
	                                break;

	                              case 2:
	                                for (t2 = 0; t2 < maxWidth; t2++) {
	                                    row[offsetT + t2] ^= symbolRow[t2];
	                                }
	                                break;

	                              default:
	                                error("JBIG2 error: operator " + combinationOperator + " is not supported");
	                            }
	                        }
	                        currentS += symbolHeight - 1;
	                    } else {
	                        for (t2 = 0; t2 < symbolHeight; t2++) {
	                            row = bitmap[offsetT + t2];
	                            if (!row) {
	                                continue;
	                            }
	                            symbolRow = symbolBitmap[t2];
	                            switch (combinationOperator) {
	                              case 0:
	                                for (s2 = 0; s2 < symbolWidth; s2++) {
	                                    row[offsetS + s2] |= symbolRow[s2];
	                                }
	                                break;

	                              case 2:
	                                for (s2 = 0; s2 < symbolWidth; s2++) {
	                                    row[offsetS + s2] ^= symbolRow[s2];
	                                }
	                                break;

	                              default:
	                                error("JBIG2 error: operator " + combinationOperator + " is not supported");
	                            }
	                        }
	                        currentS += symbolWidth - 1;
	                    }
	                    i++;
	                    var deltaS = decodeInteger(contextCache, "IADS", decoder);
	                    if (deltaS === null) {
	                        break;
	                    }
	                    currentS += deltaS + dsOffset;
	                } while (true);
	            }
	            return bitmap;
	        }
	        function readSegmentHeader(data, start) {
	            var segmentHeader = {};
	            segmentHeader.number = readUint32(data, start);
	            var flags = data[start + 4];
	            var segmentType = flags & 63;
	            if (!SegmentTypes[segmentType]) {
	                error("JBIG2 error: invalid segment type: " + segmentType);
	            }
	            segmentHeader.type = segmentType;
	            segmentHeader.typeName = SegmentTypes[segmentType];
	            segmentHeader.deferredNonRetain = !!(flags & 128);
	            var pageAssociationFieldSize = !!(flags & 64);
	            var referredFlags = data[start + 5];
	            var referredToCount = referredFlags >> 5 & 7;
	            var retainBits = [ referredFlags & 31 ];
	            var position = start + 6;
	            if (referredFlags === 7) {
	                referredToCount = readUint32(data, position - 1) & 536870911;
	                position += 3;
	                var bytes = referredToCount + 7 >> 3;
	                retainBits[0] = data[position++];
	                while (--bytes > 0) {
	                    retainBits.push(data[position++]);
	                }
	            } else if (referredFlags === 5 || referredFlags === 6) {
	                error("JBIG2 error: invalid referred-to flags");
	            }
	            segmentHeader.retainBits = retainBits;
	            var referredToSegmentNumberSize = segmentHeader.number <= 256 ? 1 : segmentHeader.number <= 65536 ? 2 : 4;
	            var referredTo = [];
	            var i, ii;
	            for (i = 0; i < referredToCount; i++) {
	                var number = referredToSegmentNumberSize === 1 ? data[position] : referredToSegmentNumberSize === 2 ? readUint16(data, position) : readUint32(data, position);
	                referredTo.push(number);
	                position += referredToSegmentNumberSize;
	            }
	            segmentHeader.referredTo = referredTo;
	            if (!pageAssociationFieldSize) {
	                segmentHeader.pageAssociation = data[position++];
	            } else {
	                segmentHeader.pageAssociation = readUint32(data, position);
	                position += 4;
	            }
	            segmentHeader.length = readUint32(data, position);
	            position += 4;
	            if (segmentHeader.length === 4294967295) {
	                if (segmentType === 38) {
	                    var genericRegionInfo = readRegionSegmentInformation(data, position);
	                    var genericRegionSegmentFlags = data[position + RegionSegmentInformationFieldLength];
	                    var genericRegionMmr = !!(genericRegionSegmentFlags & 1);
	                    var searchPatternLength = 6;
	                    var searchPattern = new Uint8Array(searchPatternLength);
	                    if (!genericRegionMmr) {
	                        searchPattern[0] = 255;
	                        searchPattern[1] = 172;
	                    }
	                    searchPattern[2] = genericRegionInfo.height >>> 24 & 255;
	                    searchPattern[3] = genericRegionInfo.height >> 16 & 255;
	                    searchPattern[4] = genericRegionInfo.height >> 8 & 255;
	                    searchPattern[5] = genericRegionInfo.height & 255;
	                    for (i = position, ii = data.length; i < ii; i++) {
	                        var j = 0;
	                        while (j < searchPatternLength && searchPattern[j] === data[i + j]) {
	                            j++;
	                        }
	                        if (j === searchPatternLength) {
	                            segmentHeader.length = i + searchPatternLength;
	                            break;
	                        }
	                    }
	                    if (segmentHeader.length === 4294967295) {
	                        error("JBIG2 error: segment end was not found");
	                    }
	                } else {
	                    error("JBIG2 error: invalid unknown segment length");
	                }
	            }
	            segmentHeader.headerEnd = position;
	            return segmentHeader;
	        }
	        function readSegments(header, data, start, end) {
	            var segments = [];
	            var position = start;
	            while (position < end) {
	                var segmentHeader = readSegmentHeader(data, position);
	                position = segmentHeader.headerEnd;
	                var segment = {
	                    header: segmentHeader,
	                    data: data
	                };
	                if (!header.randomAccess) {
	                    segment.start = position;
	                    position += segmentHeader.length;
	                    segment.end = position;
	                }
	                segments.push(segment);
	                if (segmentHeader.type === 51) {
	                    break;
	                }
	            }
	            if (header.randomAccess) {
	                for (var i = 0, ii = segments.length; i < ii; i++) {
	                    segments[i].start = position;
	                    position += segments[i].header.length;
	                    segments[i].end = position;
	                }
	            }
	            return segments;
	        }
	        function readRegionSegmentInformation(data, start) {
	            return {
	                width: readUint32(data, start),
	                height: readUint32(data, start + 4),
	                x: readUint32(data, start + 8),
	                y: readUint32(data, start + 12),
	                combinationOperator: data[start + 16] & 7
	            };
	        }
	        var RegionSegmentInformationFieldLength = 17;
	        function processSegment(segment, visitor) {
	            var header = segment.header;
	            var data = segment.data, position = segment.start, end = segment.end;
	            var args, at, i, atLength;
	            switch (header.type) {
	              case 0:
	                var dictionary = {};
	                var dictionaryFlags = readUint16(data, position);
	                dictionary.huffman = !!(dictionaryFlags & 1);
	                dictionary.refinement = !!(dictionaryFlags & 2);
	                dictionary.huffmanDHSelector = dictionaryFlags >> 2 & 3;
	                dictionary.huffmanDWSelector = dictionaryFlags >> 4 & 3;
	                dictionary.bitmapSizeSelector = dictionaryFlags >> 6 & 1;
	                dictionary.aggregationInstancesSelector = dictionaryFlags >> 7 & 1;
	                dictionary.bitmapCodingContextUsed = !!(dictionaryFlags & 256);
	                dictionary.bitmapCodingContextRetained = !!(dictionaryFlags & 512);
	                dictionary.template = dictionaryFlags >> 10 & 3;
	                dictionary.refinementTemplate = dictionaryFlags >> 12 & 1;
	                position += 2;
	                if (!dictionary.huffman) {
	                    atLength = dictionary.template === 0 ? 4 : 1;
	                    at = [];
	                    for (i = 0; i < atLength; i++) {
	                        at.push({
	                            x: readInt8(data, position),
	                            y: readInt8(data, position + 1)
	                        });
	                        position += 2;
	                    }
	                    dictionary.at = at;
	                }
	                if (dictionary.refinement && !dictionary.refinementTemplate) {
	                    at = [];
	                    for (i = 0; i < 2; i++) {
	                        at.push({
	                            x: readInt8(data, position),
	                            y: readInt8(data, position + 1)
	                        });
	                        position += 2;
	                    }
	                    dictionary.refinementAt = at;
	                }
	                dictionary.numberOfExportedSymbols = readUint32(data, position);
	                position += 4;
	                dictionary.numberOfNewSymbols = readUint32(data, position);
	                position += 4;
	                args = [ dictionary, header.number, header.referredTo, data, position, end ];
	                break;

	              case 6:
	              case 7:
	                var textRegion = {};
	                textRegion.info = readRegionSegmentInformation(data, position);
	                position += RegionSegmentInformationFieldLength;
	                var textRegionSegmentFlags = readUint16(data, position);
	                position += 2;
	                textRegion.huffman = !!(textRegionSegmentFlags & 1);
	                textRegion.refinement = !!(textRegionSegmentFlags & 2);
	                textRegion.stripSize = 1 << (textRegionSegmentFlags >> 2 & 3);
	                textRegion.referenceCorner = textRegionSegmentFlags >> 4 & 3;
	                textRegion.transposed = !!(textRegionSegmentFlags & 64);
	                textRegion.combinationOperator = textRegionSegmentFlags >> 7 & 3;
	                textRegion.defaultPixelValue = textRegionSegmentFlags >> 9 & 1;
	                textRegion.dsOffset = textRegionSegmentFlags << 17 >> 27;
	                textRegion.refinementTemplate = textRegionSegmentFlags >> 15 & 1;
	                if (textRegion.huffman) {
	                    var textRegionHuffmanFlags = readUint16(data, position);
	                    position += 2;
	                    textRegion.huffmanFS = textRegionHuffmanFlags & 3;
	                    textRegion.huffmanDS = textRegionHuffmanFlags >> 2 & 3;
	                    textRegion.huffmanDT = textRegionHuffmanFlags >> 4 & 3;
	                    textRegion.huffmanRefinementDW = textRegionHuffmanFlags >> 6 & 3;
	                    textRegion.huffmanRefinementDH = textRegionHuffmanFlags >> 8 & 3;
	                    textRegion.huffmanRefinementDX = textRegionHuffmanFlags >> 10 & 3;
	                    textRegion.huffmanRefinementDY = textRegionHuffmanFlags >> 12 & 3;
	                    textRegion.huffmanRefinementSizeSelector = !!(textRegionHuffmanFlags & 14);
	                }
	                if (textRegion.refinement && !textRegion.refinementTemplate) {
	                    at = [];
	                    for (i = 0; i < 2; i++) {
	                        at.push({
	                            x: readInt8(data, position),
	                            y: readInt8(data, position + 1)
	                        });
	                        position += 2;
	                    }
	                    textRegion.refinementAt = at;
	                }
	                textRegion.numberOfSymbolInstances = readUint32(data, position);
	                position += 4;
	                if (textRegion.huffman) {
	                    error("JBIG2 error: huffman is not supported");
	                }
	                args = [ textRegion, header.referredTo, data, position, end ];
	                break;

	              case 38:
	              case 39:
	                var genericRegion = {};
	                genericRegion.info = readRegionSegmentInformation(data, position);
	                position += RegionSegmentInformationFieldLength;
	                var genericRegionSegmentFlags = data[position++];
	                genericRegion.mmr = !!(genericRegionSegmentFlags & 1);
	                genericRegion.template = genericRegionSegmentFlags >> 1 & 3;
	                genericRegion.prediction = !!(genericRegionSegmentFlags & 8);
	                if (!genericRegion.mmr) {
	                    atLength = genericRegion.template === 0 ? 4 : 1;
	                    at = [];
	                    for (i = 0; i < atLength; i++) {
	                        at.push({
	                            x: readInt8(data, position),
	                            y: readInt8(data, position + 1)
	                        });
	                        position += 2;
	                    }
	                    genericRegion.at = at;
	                }
	                args = [ genericRegion, data, position, end ];
	                break;

	              case 48:
	                var pageInfo = {
	                    width: readUint32(data, position),
	                    height: readUint32(data, position + 4),
	                    resolutionX: readUint32(data, position + 8),
	                    resolutionY: readUint32(data, position + 12)
	                };
	                if (pageInfo.height === 4294967295) {
	                    delete pageInfo.height;
	                }
	                var pageSegmentFlags = data[position + 16];
	                readUint16(data, position + 17);
	                pageInfo.lossless = !!(pageSegmentFlags & 1);
	                pageInfo.refinement = !!(pageSegmentFlags & 2);
	                pageInfo.defaultPixelValue = pageSegmentFlags >> 2 & 1;
	                pageInfo.combinationOperator = pageSegmentFlags >> 3 & 3;
	                pageInfo.requiresBuffer = !!(pageSegmentFlags & 32);
	                pageInfo.combinationOperatorOverride = !!(pageSegmentFlags & 64);
	                args = [ pageInfo ];
	                break;

	              case 49:
	                break;

	              case 50:
	                break;

	              case 51:
	                break;

	              case 62:
	                break;

	              default:
	                error("JBIG2 error: segment type " + header.typeName + "(" + header.type + ") is not implemented");
	            }
	            var callbackName = "on" + header.typeName;
	            if (callbackName in visitor) {
	                visitor[callbackName].apply(visitor, args);
	            }
	        }
	        function processSegments(segments, visitor) {
	            for (var i = 0, ii = segments.length; i < ii; i++) {
	                processSegment(segments[i], visitor);
	            }
	        }
	        function parseJbig2Chunks(chunks) {
	            var visitor = new SimpleSegmentVisitor();
	            for (var i = 0, ii = chunks.length; i < ii; i++) {
	                var chunk = chunks[i];
	                var segments = readSegments({}, chunk.data, chunk.start, chunk.end);
	                processSegments(segments, visitor);
	            }
	            return visitor;
	        }
	        function SimpleSegmentVisitor() {}
	        SimpleSegmentVisitor.prototype = {
	            onPageInformation: function SimpleSegmentVisitor_onPageInformation(info) {
	                this.currentPageInfo = info;
	                var rowSize = info.width + 7 >> 3;
	                var buffer = new Uint8Array(rowSize * info.height);
	                if (info.defaultPixelValue) {
	                    for (var i = 0, ii = buffer.length; i < ii; i++) {
	                        buffer[i] = 255;
	                    }
	                }
	                this.buffer = buffer;
	            },
	            drawBitmap: function SimpleSegmentVisitor_drawBitmap(regionInfo, bitmap) {
	                var pageInfo = this.currentPageInfo;
	                var width = regionInfo.width, height = regionInfo.height;
	                var rowSize = pageInfo.width + 7 >> 3;
	                var combinationOperator = pageInfo.combinationOperatorOverride ? regionInfo.combinationOperator : pageInfo.combinationOperator;
	                var buffer = this.buffer;
	                var mask0 = 128 >> (regionInfo.x & 7);
	                var offset0 = regionInfo.y * rowSize + (regionInfo.x >> 3);
	                var i, j, mask, offset;
	                switch (combinationOperator) {
	                  case 0:
	                    for (i = 0; i < height; i++) {
	                        mask = mask0;
	                        offset = offset0;
	                        for (j = 0; j < width; j++) {
	                            if (bitmap[i][j]) {
	                                buffer[offset] |= mask;
	                            }
	                            mask >>= 1;
	                            if (!mask) {
	                                mask = 128;
	                                offset++;
	                            }
	                        }
	                        offset0 += rowSize;
	                    }
	                    break;

	                  case 2:
	                    for (i = 0; i < height; i++) {
	                        mask = mask0;
	                        offset = offset0;
	                        for (j = 0; j < width; j++) {
	                            if (bitmap[i][j]) {
	                                buffer[offset] ^= mask;
	                            }
	                            mask >>= 1;
	                            if (!mask) {
	                                mask = 128;
	                                offset++;
	                            }
	                        }
	                        offset0 += rowSize;
	                    }
	                    break;

	                  default:
	                    error("JBIG2 error: operator " + combinationOperator + " is not supported");
	                }
	            },
	            onImmediateGenericRegion: function SimpleSegmentVisitor_onImmediateGenericRegion(region, data, start, end) {
	                var regionInfo = region.info;
	                var decodingContext = new DecodingContext(data, start, end);
	                var bitmap = decodeBitmap(region.mmr, regionInfo.width, regionInfo.height, region.template, region.prediction, null, region.at, decodingContext);
	                this.drawBitmap(regionInfo, bitmap);
	            },
	            onImmediateLosslessGenericRegion: function SimpleSegmentVisitor_onImmediateLosslessGenericRegion() {
	                this.onImmediateGenericRegion.apply(this, arguments);
	            },
	            onSymbolDictionary: function SimpleSegmentVisitor_onSymbolDictionary(dictionary, currentSegment, referredSegments, data, start, end) {
	                var huffmanTables;
	                if (dictionary.huffman) {
	                    error("JBIG2 error: huffman is not supported");
	                }
	                var symbols = this.symbols;
	                if (!symbols) {
	                    this.symbols = symbols = {};
	                }
	                var inputSymbols = [];
	                for (var i = 0, ii = referredSegments.length; i < ii; i++) {
	                    inputSymbols = inputSymbols.concat(symbols[referredSegments[i]]);
	                }
	                var decodingContext = new DecodingContext(data, start, end);
	                symbols[currentSegment] = decodeSymbolDictionary(dictionary.huffman, dictionary.refinement, inputSymbols, dictionary.numberOfNewSymbols, dictionary.numberOfExportedSymbols, huffmanTables, dictionary.template, dictionary.at, dictionary.refinementTemplate, dictionary.refinementAt, decodingContext);
	            },
	            onImmediateTextRegion: function SimpleSegmentVisitor_onImmediateTextRegion(region, referredSegments, data, start, end) {
	                var regionInfo = region.info;
	                var huffmanTables;
	                var symbols = this.symbols;
	                var inputSymbols = [];
	                for (var i = 0, ii = referredSegments.length; i < ii; i++) {
	                    inputSymbols = inputSymbols.concat(symbols[referredSegments[i]]);
	                }
	                var symbolCodeLength = log2(inputSymbols.length);
	                var decodingContext = new DecodingContext(data, start, end);
	                var bitmap = decodeTextRegion(region.huffman, region.refinement, regionInfo.width, regionInfo.height, region.defaultPixelValue, region.numberOfSymbolInstances, region.stripSize, inputSymbols, symbolCodeLength, region.transposed, region.dsOffset, region.referenceCorner, region.combinationOperator, huffmanTables, region.refinementTemplate, region.refinementAt, decodingContext);
	                this.drawBitmap(regionInfo, bitmap);
	            },
	            onImmediateLosslessTextRegion: function SimpleSegmentVisitor_onImmediateLosslessTextRegion() {
	                this.onImmediateTextRegion.apply(this, arguments);
	            }
	        };
	        function Jbig2Image() {}
	        Jbig2Image.prototype = {
	            parseChunks: function Jbig2Image_parseChunks(chunks) {
	                return parseJbig2Chunks(chunks);
	            }
	        };
	        return Jbig2Image;
	    }();
	    function log2(x) {
	        var n = 1, i = 0;
	        while (x > n) {
	            n <<= 1;
	            i++;
	        }
	        return i;
	    }
	    function readInt8(data, start) {
	        return data[start] << 24 >> 24;
	    }
	    function readUint16(data, offset) {
	        return data[offset] << 8 | data[offset + 1];
	    }
	    function readUint32(data, offset) {
	        return (data[offset] << 24 | data[offset + 1] << 16 | data[offset + 2] << 8 | data[offset + 3]) >>> 0;
	    }
	    function shadow(obj, prop, value) {
	        Object.defineProperty(obj, prop, {
	            value: value,
	            enumerable: true,
	            configurable: true,
	            writable: false
	        });
	        return value;
	    }
	    var error = function() {
	        console.error.apply(console, arguments);
	        throw new Error("PDFJS error: " + arguments[0]);
	    };
	    var warn = function() {
	        console.warn.apply(console, arguments);
	    };
	    var info = function() {
	        console.info.apply(console, arguments);
	    };
	    Jbig2Image.prototype.parse = function parseJbig2(data) {
	        var position = 0, end = data.length;
	        if (data[position] !== 151 || data[position + 1] !== 74 || data[position + 2] !== 66 || data[position + 3] !== 50 || data[position + 4] !== 13 || data[position + 5] !== 10 || data[position + 6] !== 26 || data[position + 7] !== 10) {
	            error("JBIG2 error: invalid header");
	        }
	        position += 8;
	        var flags = data[position++];
	        if (!(flags & 2)) {
	            readUint32(data, position);
	            position += 4;
	        }
	        var visitor = this.parseChunks([ {
	            data: data,
	            start: position,
	            end: end
	        } ]);
	        var width = visitor.currentPageInfo.width;
	        var height = visitor.currentPageInfo.height;
	        var bitPacked = visitor.buffer;
	        var data = new Uint8Array(width * height);
	        var q = 0, k = 0;
	        for (var i = 0; i < height; i++) {
	            var mask = 0, buffer;
	            for (var j = 0; j < width; j++) {
	                if (!mask) {
	                    mask = 128;
	                    buffer = bitPacked[k++];
	                }
	                data[q++] = buffer & mask ? 0 : 255;
	                mask >>= 1;
	            }
	        }
	        this.width = width;
	        this.height = height;
	        this.data = data;
	    };
	    PDFJS.JpegImage = JpegImage;
	    PDFJS.JpxImage = JpxImage;
	    PDFJS.Jbig2Image = Jbig2Image;
	})(PDFJS || (PDFJS = {}));

	var JpegDecoder = PDFJS.JpegImage;

	var JpxDecoder = PDFJS.JpxImage;

	var Jbig2Decoder = PDFJS.Jbig2Image;


	if(typeof exports === "object")
	{
		module.exports = {
			JpegImage: JpegImage,
			JpegDecoder: JpegDecoder,
			JpxDecoder: JpxDecoder,
			Jbig2Decoder: Jbig2Decoder
		};
	}
	},{}],175:[function(require,module,exports){
	(function (Buffer){
	var xhr = require('xhr');
	var noop = function(){};
	var parseASCII = require('parse-bmfont-ascii');
	var parseXML = require('parse-bmfont-xml');
	var readBinary = require('parse-bmfont-binary');
	var isBinaryFormat = require('./lib/is-binary');
	var xtend = require('xtend');

	var xml2 = (function hasXML2() {
	  return self.XMLHttpRequest && "withCredentials" in new XMLHttpRequest
	})();

	module.exports = function(opt, cb) {
	  cb = typeof cb === 'function' ? cb : noop;

	  if (typeof opt === 'string')
	    opt = { uri: opt };
	  else if (!opt)
	    opt = {};

	  var expectBinary = opt.binary;
	  if (expectBinary)
	    opt = getBinaryOpts(opt);

	  xhr(opt, function(err, res, body) {
	    if (err)
	      return cb(err)
	    if (!/^2/.test(res.statusCode))
	      return cb(new Error('http status code: '+res.statusCode))
	    if (!body)
	      return cb(new Error('no body result'))

	    var binary = false; 

	    //if the response type is an array buffer,
	    //we need to convert it into a regular Buffer object
	    if (isArrayBuffer(body)) {
	      var array = new Uint8Array(body);
	      body = new Buffer(array, 'binary');
	    }

	    //now check the string/Buffer response
	    //and see if it has a binary BMF header
	    if (isBinaryFormat(body)) {
	      binary = true;
	      //if we have a string, turn it into a Buffer
	      if (typeof body === 'string') 
	        body = new Buffer(body, 'binary');
	    } 

	    //we are not parsing a binary format, just ASCII/XML/etc
	    if (!binary) {
	      //might still be a buffer if responseType is 'arraybuffer'
	      if (Buffer.isBuffer(body))
	        body = body.toString(opt.encoding);
	      body = body.trim();
	    }

	    var result;
	    try {
	      var type = res.headers['content-type'];
	      if (binary)
	        result = readBinary(body);
	      else if (/json/.test(type) || body.charAt(0) === '{')
	        result = JSON.parse(body);
	      else if (/xml/.test(type)  || body.charAt(0) === '<')
	        result = parseXML(body);
	      else
	        result = parseASCII(body);
	    } catch (e) {
	      cb(new Error('error parsing font '+e.message));
	      cb = noop;
	    }
	    cb(null, result);
	  });
	};

	function isArrayBuffer(arr) {
	  var str = Object.prototype.toString;
	  return str.call(arr) === '[object ArrayBuffer]'
	}

	function getBinaryOpts(opt) {
	  //IE10+ and other modern browsers support array buffers
	  if (xml2)
	    return xtend(opt, { responseType: 'arraybuffer' })
	  
	  if (typeof self.XMLHttpRequest === 'undefined')
	    throw new Error('your browser does not support XHR loading')

	  //IE9 and XML1 browsers could still use an override
	  var req = new self.XMLHttpRequest();
	  req.overrideMimeType('text/plain; charset=x-user-defined');
	  return xtend({
	    xhr: req
	  }, opt)
	}

	}).call(this,require("buffer").Buffer);
	},{"./lib/is-binary":176,"buffer":16,"parse-bmfont-ascii":195,"parse-bmfont-binary":196,"parse-bmfont-xml":197,"xhr":262,"xtend":264}],176:[function(require,module,exports){
	(function (Buffer){
	var equal = require('buffer-equal');
	var HEADER = new Buffer([66, 77, 70, 3]);

	module.exports = function(buf) {
	  if (typeof buf === 'string')
	    return buf.substring(0, 3) === 'BMF'
	  return buf.length > 4 && equal(buf.slice(0, 4), HEADER)
	};
	}).call(this,require("buffer").Buffer);
	},{"buffer":16,"buffer-equal":15}],177:[function(require,module,exports){
	(function (process){
	var path = require('path');
	var fs = require('fs');
	var _0777 = parseInt('0777', 8);

	module.exports = mkdirP.mkdirp = mkdirP.mkdirP = mkdirP;

	function mkdirP (p, opts, f, made) {
	    if (typeof opts === 'function') {
	        f = opts;
	        opts = {};
	    }
	    else if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = _0777 & (~process.umask());
	    }
	    if (!made) made = null;
	    
	    var cb = f || function () {};
	    p = path.resolve(p);
	    
	    xfs.mkdir(p, mode, function (er) {
	        if (!er) {
	            made = made || p;
	            return cb(null, made);
	        }
	        switch (er.code) {
	            case 'ENOENT':
	                mkdirP(path.dirname(p), opts, function (er, made) {
	                    if (er) cb(er, made);
	                    else mkdirP(p, opts, cb, made);
	                });
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                xfs.stat(p, function (er2, stat) {
	                    // if the stat fails, then that's super weird.
	                    // let the original error be the failure reason.
	                    if (er2 || !stat.isDirectory()) cb(er, made);
	                    else cb(null, made);
	                });
	                break;
	        }
	    });
	}

	mkdirP.sync = function sync (p, opts, made) {
	    if (!opts || typeof opts !== 'object') {
	        opts = { mode: opts };
	    }
	    
	    var mode = opts.mode;
	    var xfs = opts.fs || fs;
	    
	    if (mode === undefined) {
	        mode = _0777 & (~process.umask());
	    }
	    if (!made) made = null;

	    p = path.resolve(p);

	    try {
	        xfs.mkdirSync(p, mode);
	        made = made || p;
	    }
	    catch (err0) {
	        switch (err0.code) {
	            case 'ENOENT' :
	                made = sync(path.dirname(p), opts, made);
	                sync(p, opts, made);
	                break;

	            // In the case of any other error, just see if there's a dir
	            // there already.  If so, then hooray!  If not, then something
	            // is borked.
	            default:
	                var stat;
	                try {
	                    stat = xfs.statSync(p);
	                }
	                catch (err1) {
	                    throw err0;
	                }
	                if (!stat.isDirectory()) throw err0;
	                break;
	        }
	    }

	    return made;
	};

	}).call(this,require('_process'));
	},{"_process":226,"fs":14,"path":200}],178:[function(require,module,exports){

	function GifWriter(buf, width, height, gopts) {
	  var p = 0;

	  var gopts = gopts === undefined ? { } : gopts;
	  var loop_count = gopts.loop === undefined ? null : gopts.loop;
	  var global_palette = gopts.palette === undefined ? null : gopts.palette;

	  if (width <= 0 || height <= 0 || width > 65535 || height > 65535)
	    throw new Error("Width/Height invalid.");

	  function check_palette_and_num_colors(palette) {
	    var num_colors = palette.length;
	    if (num_colors < 2 || num_colors > 256 ||  num_colors & (num_colors-1)) {
	      throw new Error(
	          "Invalid code/color length, must be power of 2 and 2 .. 256.");
	    }
	    return num_colors;
	  }

	  // - Header.
	  buf[p++] = 0x47; buf[p++] = 0x49; buf[p++] = 0x46;  // GIF
	  buf[p++] = 0x38; buf[p++] = 0x39; buf[p++] = 0x61;  // 89a

	  // Handling of Global Color Table (palette) and background index.
	  var gp_num_colors_pow2 = 0;
	  var background = 0;
	  if (global_palette !== null) {
	    var gp_num_colors = check_palette_and_num_colors(global_palette);
	    while (gp_num_colors >>= 1) ++gp_num_colors_pow2;
	    gp_num_colors = 1 << gp_num_colors_pow2;
	    --gp_num_colors_pow2;
	    if (gopts.background !== undefined) {
	      background = gopts.background;
	      if (background >= gp_num_colors)
	        throw new Error("Background index out of range.");
	      // The GIF spec states that a background index of 0 should be ignored, so
	      // this is probably a mistake and you really want to set it to another
	      // slot in the palette.  But actually in the end most browsers, etc end
	      // up ignoring this almost completely (including for dispose background).
	      if (background === 0)
	        throw new Error("Background index explicitly passed as 0.");
	    }
	  }

	  // - Logical Screen Descriptor.
	  // NOTE(deanm): w/h apparently ignored by implementations, but set anyway.
	  buf[p++] = width & 0xff; buf[p++] = width >> 8 & 0xff;
	  buf[p++] = height & 0xff; buf[p++] = height >> 8 & 0xff;
	  // NOTE: Indicates 0-bpp original color resolution (unused?).
	  buf[p++] = (global_palette !== null ? 0x80 : 0) |  // Global Color Table Flag.
	             gp_num_colors_pow2;  // NOTE: No sort flag (unused?).
	  buf[p++] = background;  // Background Color Index.
	  buf[p++] = 0;  // Pixel aspect ratio (unused?).

	  // - Global Color Table
	  if (global_palette !== null) {
	    for (var i = 0, il = global_palette.length; i < il; ++i) {
	      var rgb = global_palette[i];
	      buf[p++] = rgb >> 16 & 0xff;
	      buf[p++] = rgb >> 8 & 0xff;
	      buf[p++] = rgb & 0xff;
	    }
	  }

	  if (loop_count !== null) {  // Netscape block for looping.
	    if (loop_count < 0 || loop_count > 65535)
	      throw new Error("Loop count invalid.")
	    // Extension code, label, and length.
	    buf[p++] = 0x21; buf[p++] = 0xff; buf[p++] = 0x0b;
	    // NETSCAPE2.0
	    buf[p++] = 0x4e; buf[p++] = 0x45; buf[p++] = 0x54; buf[p++] = 0x53;
	    buf[p++] = 0x43; buf[p++] = 0x41; buf[p++] = 0x50; buf[p++] = 0x45;
	    buf[p++] = 0x32; buf[p++] = 0x2e; buf[p++] = 0x30;
	    // Sub-block
	    buf[p++] = 0x03; buf[p++] = 0x01;
	    buf[p++] = loop_count & 0xff; buf[p++] = loop_count >> 8 & 0xff;
	    buf[p++] = 0x00;  // Terminator.
	  }


	  var ended = false;

	  this.addFrame = function(x, y, w, h, indexed_pixels, opts) {
	    if (ended === true) { --p; ended = false; }  // Un-end.

	    opts = opts === undefined ? { } : opts;

	    // TODO(deanm): Bounds check x, y.  Do they need to be within the virtual
	    // canvas width/height, I imagine?
	    if (x < 0 || y < 0 || x > 65535 || y > 65535)
	      throw new Error("x/y invalid.")

	    if (w <= 0 || h <= 0 || w > 65535 || h > 65535)
	      throw new Error("Width/Height invalid.")

	    if (indexed_pixels.length < w * h)
	      throw new Error("Not enough pixels for the frame size.");

	    var using_local_palette = true;
	    var palette = opts.palette;
	    if (palette === undefined || palette === null) {
	      using_local_palette = false;
	      palette = global_palette;
	    }

	    if (palette === undefined || palette === null)
	      throw new Error("Must supply either a local or global palette.");

	    var num_colors = check_palette_and_num_colors(palette);

	    // Compute the min_code_size (power of 2), destroying num_colors.
	    var min_code_size = 0;
	    while (num_colors >>= 1) ++min_code_size;
	    num_colors = 1 << min_code_size;  // Now we can easily get it back.

	    var delay = opts.delay === undefined ? 0 : opts.delay;

	    // From the spec:
	    //     0 -   No disposal specified. The decoder is
	    //           not required to take any action.
	    //     1 -   Do not dispose. The graphic is to be left
	    //           in place.
	    //     2 -   Restore to background color. The area used by the
	    //           graphic must be restored to the background color.
	    //     3 -   Restore to previous. The decoder is required to
	    //           restore the area overwritten by the graphic with
	    //           what was there prior to rendering the graphic.
	    //  4-7 -    To be defined.
	    // NOTE(deanm): Dispose background doesn't really work, apparently most
	    // browsers ignore the background palette index and clear to transparency.
	    var disposal = opts.disposal === undefined ? 0 : opts.disposal;
	    if (disposal < 0 || disposal > 3)  // 4-7 is reserved.
	      throw new Error("Disposal out of range.");

	    var use_transparency = false;
	    var transparent_index = 0;
	    if (opts.transparent !== undefined && opts.transparent !== null) {
	      use_transparency = true;
	      transparent_index = opts.transparent;
	      if (transparent_index < 0 || transparent_index >= num_colors)
	        throw new Error("Transparent color index.");
	    }

	    if (disposal !== 0 || use_transparency || delay !== 0) {
	      // - Graphics Control Extension
	      buf[p++] = 0x21; buf[p++] = 0xf9;  // Extension / Label.
	      buf[p++] = 4;  // Byte size.

	      buf[p++] = disposal << 2 | (use_transparency === true ? 1 : 0);
	      buf[p++] = delay & 0xff; buf[p++] = delay >> 8 & 0xff;
	      buf[p++] = transparent_index;  // Transparent color index.
	      buf[p++] = 0;  // Block Terminator.
	    }

	    // - Image Descriptor
	    buf[p++] = 0x2c;  // Image Seperator.
	    buf[p++] = x & 0xff; buf[p++] = x >> 8 & 0xff;  // Left.
	    buf[p++] = y & 0xff; buf[p++] = y >> 8 & 0xff;  // Top.
	    buf[p++] = w & 0xff; buf[p++] = w >> 8 & 0xff;
	    buf[p++] = h & 0xff; buf[p++] = h >> 8 & 0xff;
	    // NOTE: No sort flag (unused?).
	    // TODO(deanm): Support interlace.
	    buf[p++] = using_local_palette === true ? (0x80 | (min_code_size-1)) : 0;

	    // - Local Color Table
	    if (using_local_palette === true) {
	      for (var i = 0, il = palette.length; i < il; ++i) {
	        var rgb = palette[i];
	        buf[p++] = rgb >> 16 & 0xff;
	        buf[p++] = rgb >> 8 & 0xff;
	        buf[p++] = rgb & 0xff;
	      }
	    }

	    p = GifWriterOutputLZWCodeStream(
	            buf, p, min_code_size < 2 ? 2 : min_code_size, indexed_pixels);

	    return p;
	  };

	  this.end = function() {
	    if (ended === false) {
	      buf[p++] = 0x3b;  // Trailer.
	      ended = true;
	    }
	    return p;
	  };

	  this.getOutputBuffer = function() { return buf; };
	  this.setOutputBuffer = function(v) { buf = v; };
	  this.getOutputBufferPosition = function() { return p; };
	  this.setOutputBufferPosition = function(v) { p = v; };
	}

	// Main compression routine, palette indexes -> LZW code stream.
	// |index_stream| must have at least one entry.
	function GifWriterOutputLZWCodeStream(buf, p, min_code_size, index_stream) {
	  buf[p++] = min_code_size;
	  var cur_subblock = p++;  // Pointing at the length field.

	  var clear_code = 1 << min_code_size;
	  var code_mask = clear_code - 1;
	  var eoi_code = clear_code + 1;
	  var next_code = eoi_code + 1;

	  var cur_code_size = min_code_size + 1;  // Number of bits per code.
	  var cur_shift = 0;
	  // We have at most 12-bit codes, so we should have to hold a max of 19
	  // bits here (and then we would write out).
	  var cur = 0;

	  function emit_bytes_to_buffer(bit_block_size) {
	    while (cur_shift >= bit_block_size) {
	      buf[p++] = cur & 0xff;
	      cur >>= 8; cur_shift -= 8;
	      if (p === cur_subblock + 256) {  // Finished a subblock.
	        buf[cur_subblock] = 255;
	        cur_subblock = p++;
	      }
	    }
	  }

	  function emit_code(c) {
	    cur |= c << cur_shift;
	    cur_shift += cur_code_size;
	    emit_bytes_to_buffer(8);
	  }

	  // I am not an expert on the topic, and I don't want to write a thesis.
	  // However, it is good to outline here the basic algorithm and the few data
	  // structures and optimizations here that make this implementation fast.
	  // The basic idea behind LZW is to build a table of previously seen runs
	  // addressed by a short id (herein called output code).  All data is
	  // referenced by a code, which represents one or more values from the
	  // original input stream.  All input bytes can be referenced as the same
	  // value as an output code.  So if you didn't want any compression, you
	  // could more or less just output the original bytes as codes (there are
	  // some details to this, but it is the idea).  In order to achieve
	  // compression, values greater then the input range (codes can be up to
	  // 12-bit while input only 8-bit) represent a sequence of previously seen
	  // inputs.  The decompressor is able to build the same mapping while
	  // decoding, so there is always a shared common knowledge between the
	  // encoding and decoder, which is also important for "timing" aspects like
	  // how to handle variable bit width code encoding.
	  //
	  // One obvious but very important consequence of the table system is there
	  // is always a unique id (at most 12-bits) to map the runs.  'A' might be
	  // 4, then 'AA' might be 10, 'AAA' 11, 'AAAA' 12, etc.  This relationship
	  // can be used for an effecient lookup strategy for the code mapping.  We
	  // need to know if a run has been seen before, and be able to map that run
	  // to the output code.  Since we start with known unique ids (input bytes),
	  // and then from those build more unique ids (table entries), we can
	  // continue this chain (almost like a linked list) to always have small
	  // integer values that represent the current byte chains in the encoder.
	  // This means instead of tracking the input bytes (AAAABCD) to know our
	  // current state, we can track the table entry for AAAABC (it is guaranteed
	  // to exist by the nature of the algorithm) and the next character D.
	  // Therefor the tuple of (table_entry, byte) is guaranteed to also be
	  // unique.  This allows us to create a simple lookup key for mapping input
	  // sequences to codes (table indices) without having to store or search
	  // any of the code sequences.  So if 'AAAA' has a table entry of 12, the
	  // tuple of ('AAAA', K) for any input byte K will be unique, and can be our
	  // key.  This leads to a integer value at most 20-bits, which can always
	  // fit in an SMI value and be used as a fast sparse array / object key.

	  // Output code for the current contents of the index buffer.
	  var ib_code = index_stream[0] & code_mask;  // Load first input index.
	  var code_table = { };  // Key'd on our 20-bit "tuple".

	  emit_code(clear_code);  // Spec says first code should be a clear code.

	  // First index already loaded, process the rest of the stream.
	  for (var i = 1, il = index_stream.length; i < il; ++i) {
	    var k = index_stream[i] & code_mask;
	    var cur_key = ib_code << 8 | k;  // (prev, k) unique tuple.
	    var cur_code = code_table[cur_key];  // buffer + k.

	    // Check if we have to create a new code table entry.
	    if (cur_code === undefined) {  // We don't have buffer + k.
	      // Emit index buffer (without k).
	      // This is an inline version of emit_code, because this is the core
	      // writing routine of the compressor (and V8 cannot inline emit_code
	      // because it is a closure here in a different context).  Additionally
	      // we can call emit_byte_to_buffer less often, because we can have
	      // 30-bits (from our 31-bit signed SMI), and we know our codes will only
	      // be 12-bits, so can safely have 18-bits there without overflow.
	      // emit_code(ib_code);
	      cur |= ib_code << cur_shift;
	      cur_shift += cur_code_size;
	      while (cur_shift >= 8) {
	        buf[p++] = cur & 0xff;
	        cur >>= 8; cur_shift -= 8;
	        if (p === cur_subblock + 256) {  // Finished a subblock.
	          buf[cur_subblock] = 255;
	          cur_subblock = p++;
	        }
	      }

	      if (next_code === 4096) {  // Table full, need a clear.
	        emit_code(clear_code);
	        next_code = eoi_code + 1;
	        cur_code_size = min_code_size + 1;
	        code_table = { };
	      } else {  // Table not full, insert a new entry.
	        // Increase our variable bit code sizes if necessary.  This is a bit
	        // tricky as it is based on "timing" between the encoding and
	        // decoder.  From the encoders perspective this should happen after
	        // we've already emitted the index buffer and are about to create the
	        // first table entry that would overflow our current code bit size.
	        if (next_code >= (1 << cur_code_size)) ++cur_code_size;
	        code_table[cur_key] = next_code++;  // Insert into code table.
	      }

	      ib_code = k;  // Index buffer to single input k.
	    } else {
	      ib_code = cur_code;  // Index buffer to sequence in code table.
	    }
	  }

	  emit_code(ib_code);  // There will still be something in the index buffer.
	  emit_code(eoi_code);  // End Of Information.

	  // Flush / finalize the sub-blocks stream to the buffer.
	  emit_bytes_to_buffer(1);

	  // Finish the sub-blocks, writing out any unfinished lengths and
	  // terminating with a sub-block of length 0.  If we have already started
	  // but not yet used a sub-block it can just become the terminator.
	  if (cur_subblock + 1 === p) {  // Started but unused.
	    buf[cur_subblock] = 0;
	  } else {  // Started and used, write length and additional terminator block.
	    buf[cur_subblock] = p - cur_subblock - 1;
	    buf[p++] = 0;
	  }
	  return p;
	}

	function GifReader(buf) {
	  var p = 0;

	  // - Header (GIF87a or GIF89a).
	  if (buf[p++] !== 0x47 ||            buf[p++] !== 0x49 || buf[p++] !== 0x46 ||
	      buf[p++] !== 0x38 || (buf[p++]+1 & 0xfd) !== 0x38 || buf[p++] !== 0x61) {
	    throw new Error("Invalid GIF 87a/89a header.");
	  }

	  // - Logical Screen Descriptor.
	  var width = buf[p++] | buf[p++] << 8;
	  var height = buf[p++] | buf[p++] << 8;
	  var pf0 = buf[p++];  // <Packed Fields>.
	  var global_palette_flag = pf0 >> 7;
	  var num_global_colors_pow2 = pf0 & 0x7;
	  var num_global_colors = 1 << (num_global_colors_pow2 + 1);
	  buf[p++];
	  buf[p++];  // Pixel aspect ratio (unused?).

	  var global_palette_offset = null;
	  var global_palette_size   = null;

	  if (global_palette_flag) {
	    global_palette_offset = p;
	    global_palette_size = num_global_colors;
	    p += num_global_colors * 3;  // Seek past palette.
	  }

	  var no_eof = true;

	  var frames = [ ];

	  var delay = 0;
	  var transparent_index = null;
	  var disposal = 0;  // 0 - No disposal specified.
	  var loop_count = null;

	  this.width = width;
	  this.height = height;

	  while (no_eof && p < buf.length) {
	    switch (buf[p++]) {
	      case 0x21:  // Graphics Control Extension Block
	        switch (buf[p++]) {
	          case 0xff:  // Application specific block
	            // Try if it's a Netscape block (with animation loop counter).
	            if (buf[p   ] !== 0x0b ||  // 21 FF already read, check block size.
	                // NETSCAPE2.0
	                buf[p+1 ] == 0x4e && buf[p+2 ] == 0x45 && buf[p+3 ] == 0x54 &&
	                buf[p+4 ] == 0x53 && buf[p+5 ] == 0x43 && buf[p+6 ] == 0x41 &&
	                buf[p+7 ] == 0x50 && buf[p+8 ] == 0x45 && buf[p+9 ] == 0x32 &&
	                buf[p+10] == 0x2e && buf[p+11] == 0x30 &&
	                // Sub-block
	                buf[p+12] == 0x03 && buf[p+13] == 0x01 && buf[p+16] == 0) {
	              p += 14;
	              loop_count = buf[p++] | buf[p++] << 8;
	              p++;  // Skip terminator.
	            } else {  // We don't know what it is, just try to get past it.
	              p += 12;
	              while (true) {  // Seek through subblocks.
	                var block_size = buf[p++];
	                // Bad block size (ex: undefined from an out of bounds read).
	                if (!(block_size >= 0)) throw Error("Invalid block size");
	                if (block_size === 0) break;  // 0 size is terminator
	                p += block_size;
	              }
	            }
	            break;

	          case 0xf9:  // Graphics Control Extension
	            if (buf[p++] !== 0x4 || buf[p+4] !== 0)
	              throw new Error("Invalid graphics extension block.");
	            var pf1 = buf[p++];
	            delay = buf[p++] | buf[p++] << 8;
	            transparent_index = buf[p++];
	            if ((pf1 & 1) === 0) transparent_index = null;
	            disposal = pf1 >> 2 & 0x7;
	            p++;  // Skip terminator.
	            break;

	          case 0xfe:  // Comment Extension.
	            while (true) {  // Seek through subblocks.
	              var block_size = buf[p++];
	              // Bad block size (ex: undefined from an out of bounds read).
	              if (!(block_size >= 0)) throw Error("Invalid block size");
	              if (block_size === 0) break;  // 0 size is terminator
	              // console.log(buf.slice(p, p+block_size).toString('ascii'));
	              p += block_size;
	            }
	            break;

	          default:
	            throw new Error(
	                "Unknown graphic control label: 0x" + buf[p-1].toString(16));
	        }
	        break;

	      case 0x2c:  // Image Descriptor.
	        var x = buf[p++] | buf[p++] << 8;
	        var y = buf[p++] | buf[p++] << 8;
	        var w = buf[p++] | buf[p++] << 8;
	        var h = buf[p++] | buf[p++] << 8;
	        var pf2 = buf[p++];
	        var local_palette_flag = pf2 >> 7;
	        var interlace_flag = pf2 >> 6 & 1;
	        var num_local_colors_pow2 = pf2 & 0x7;
	        var num_local_colors = 1 << (num_local_colors_pow2 + 1);
	        var palette_offset = global_palette_offset;
	        var palette_size = global_palette_size;
	        var has_local_palette = false;
	        if (local_palette_flag) {
	          var has_local_palette = true;
	          palette_offset = p;  // Override with local palette.
	          palette_size = num_local_colors;
	          p += num_local_colors * 3;  // Seek past palette.
	        }

	        var data_offset = p;

	        p++;  // codesize
	        while (true) {
	          var block_size = buf[p++];
	          // Bad block size (ex: undefined from an out of bounds read).
	          if (!(block_size >= 0)) throw Error("Invalid block size");
	          if (block_size === 0) break;  // 0 size is terminator
	          p += block_size;
	        }

	        frames.push({x: x, y: y, width: w, height: h,
	                     has_local_palette: has_local_palette,
	                     palette_offset: palette_offset,
	                     palette_size: palette_size,
	                     data_offset: data_offset,
	                     data_length: p - data_offset,
	                     transparent_index: transparent_index,
	                     interlaced: !!interlace_flag,
	                     delay: delay,
	                     disposal: disposal});
	        break;

	      case 0x3b:  // Trailer Marker (end of file).
	        no_eof = false;
	        break;

	      default:
	        throw new Error("Unknown gif block: 0x" + buf[p-1].toString(16));
	    }
	  }

	  this.numFrames = function() {
	    return frames.length;
	  };

	  this.loopCount = function() {
	    return loop_count;
	  };

	  this.frameInfo = function(frame_num) {
	    if (frame_num < 0 || frame_num >= frames.length)
	      throw new Error("Frame index out of range.");
	    return frames[frame_num];
	  };

	  this.decodeAndBlitFrameBGRA = function(frame_num, pixels) {
	    var frame = this.frameInfo(frame_num);
	    var num_pixels = frame.width * frame.height;
	    var index_stream = new Uint8Array(num_pixels);  // At most 8-bit indices.
	    GifReaderLZWOutputIndexStream(
	        buf, frame.data_offset, index_stream, num_pixels);
	    var palette_offset = frame.palette_offset;

	    // NOTE(deanm): It seems to be much faster to compare index to 256 than
	    // to === null.  Not sure why, but CompareStub_EQ_STRICT shows up high in
	    // the profile, not sure if it's related to using a Uint8Array.
	    var trans = frame.transparent_index;
	    if (trans === null) trans = 256;

	    // We are possibly just blitting to a portion of the entire frame.
	    // That is a subrect within the framerect, so the additional pixels
	    // must be skipped over after we finished a scanline.
	    var framewidth  = frame.width;
	    var framestride = width - framewidth;
	    var xleft       = framewidth;  // Number of subrect pixels left in scanline.

	    // Output indicies of the top left and bottom right corners of the subrect.
	    var opbeg = ((frame.y * width) + frame.x) * 4;
	    var opend = ((frame.y + frame.height) * width + frame.x) * 4;
	    var op    = opbeg;

	    var scanstride = framestride * 4;

	    // Use scanstride to skip past the rows when interlacing.  This is skipping
	    // 7 rows for the first two passes, then 3 then 1.
	    if (frame.interlaced === true) {
	      scanstride += width * 4 * 7;  // Pass 1.
	    }

	    var interlaceskip = 8;  // Tracking the row interval in the current pass.

	    for (var i = 0, il = index_stream.length; i < il; ++i) {
	      var index = index_stream[i];

	      if (xleft === 0) {  // Beginning of new scan line
	        op += scanstride;
	        xleft = framewidth;
	        if (op >= opend) { // Catch the wrap to switch passes when interlacing.
	          scanstride = framestride * 4 + width * 4 * (interlaceskip-1);
	          // interlaceskip / 2 * 4 is interlaceskip << 1.
	          op = opbeg + (framewidth + framestride) * (interlaceskip << 1);
	          interlaceskip >>= 1;
	        }
	      }

	      if (index === trans) {
	        op += 4;
	      } else {
	        var r = buf[palette_offset + index * 3];
	        var g = buf[palette_offset + index * 3 + 1];
	        var b = buf[palette_offset + index * 3 + 2];
	        pixels[op++] = b;
	        pixels[op++] = g;
	        pixels[op++] = r;
	        pixels[op++] = 255;
	      }
	      --xleft;
	    }
	  };

	  // I will go to copy and paste hell one day...
	  this.decodeAndBlitFrameRGBA = function(frame_num, pixels) {
	    var frame = this.frameInfo(frame_num);
	    var num_pixels = frame.width * frame.height;
	    var index_stream = new Uint8Array(num_pixels);  // At most 8-bit indices.
	    GifReaderLZWOutputIndexStream(
	        buf, frame.data_offset, index_stream, num_pixels);
	    var palette_offset = frame.palette_offset;

	    // NOTE(deanm): It seems to be much faster to compare index to 256 than
	    // to === null.  Not sure why, but CompareStub_EQ_STRICT shows up high in
	    // the profile, not sure if it's related to using a Uint8Array.
	    var trans = frame.transparent_index;
	    if (trans === null) trans = 256;

	    // We are possibly just blitting to a portion of the entire frame.
	    // That is a subrect within the framerect, so the additional pixels
	    // must be skipped over after we finished a scanline.
	    var framewidth  = frame.width;
	    var framestride = width - framewidth;
	    var xleft       = framewidth;  // Number of subrect pixels left in scanline.

	    // Output indicies of the top left and bottom right corners of the subrect.
	    var opbeg = ((frame.y * width) + frame.x) * 4;
	    var opend = ((frame.y + frame.height) * width + frame.x) * 4;
	    var op    = opbeg;

	    var scanstride = framestride * 4;

	    // Use scanstride to skip past the rows when interlacing.  This is skipping
	    // 7 rows for the first two passes, then 3 then 1.
	    if (frame.interlaced === true) {
	      scanstride += width * 4 * 7;  // Pass 1.
	    }

	    var interlaceskip = 8;  // Tracking the row interval in the current pass.

	    for (var i = 0, il = index_stream.length; i < il; ++i) {
	      var index = index_stream[i];

	      if (xleft === 0) {  // Beginning of new scan line
	        op += scanstride;
	        xleft = framewidth;
	        if (op >= opend) { // Catch the wrap to switch passes when interlacing.
	          scanstride = framestride * 4 + width * 4 * (interlaceskip-1);
	          // interlaceskip / 2 * 4 is interlaceskip << 1.
	          op = opbeg + (framewidth + framestride) * (interlaceskip << 1);
	          interlaceskip >>= 1;
	        }
	      }

	      if (index === trans) {
	        op += 4;
	      } else {
	        var r = buf[palette_offset + index * 3];
	        var g = buf[palette_offset + index * 3 + 1];
	        var b = buf[palette_offset + index * 3 + 2];
	        pixels[op++] = r;
	        pixels[op++] = g;
	        pixels[op++] = b;
	        pixels[op++] = 255;
	      }
	      --xleft;
	    }
	  };
	}

	function GifReaderLZWOutputIndexStream(code_stream, p, output, output_length) {
	  var min_code_size = code_stream[p++];

	  var clear_code = 1 << min_code_size;
	  var eoi_code = clear_code + 1;
	  var next_code = eoi_code + 1;

	  var cur_code_size = min_code_size + 1;  // Number of bits per code.
	  // NOTE: This shares the same name as the encoder, but has a different
	  // meaning here.  Here this masks each code coming from the code stream.
	  var code_mask = (1 << cur_code_size) - 1;
	  var cur_shift = 0;
	  var cur = 0;

	  var op = 0;  // Output pointer.

	  var subblock_size = code_stream[p++];

	  // TODO(deanm): Would using a TypedArray be any faster?  At least it would
	  // solve the fast mode / backing store uncertainty.
	  // var code_table = Array(4096);
	  var code_table = new Int32Array(4096);  // Can be signed, we only use 20 bits.

	  var prev_code = null;  // Track code-1.

	  while (true) {
	    // Read up to two bytes, making sure we always 12-bits for max sized code.
	    while (cur_shift < 16) {
	      if (subblock_size === 0) break;  // No more data to be read.

	      cur |= code_stream[p++] << cur_shift;
	      cur_shift += 8;

	      if (subblock_size === 1) {  // Never let it get to 0 to hold logic above.
	        subblock_size = code_stream[p++];  // Next subblock.
	      } else {
	        --subblock_size;
	      }
	    }

	    // TODO(deanm): We should never really get here, we should have received
	    // and EOI.
	    if (cur_shift < cur_code_size)
	      break;

	    var code = cur & code_mask;
	    cur >>= cur_code_size;
	    cur_shift -= cur_code_size;

	    // TODO(deanm): Maybe should check that the first code was a clear code,
	    // at least this is what you're supposed to do.  But actually our encoder
	    // now doesn't emit a clear code first anyway.
	    if (code === clear_code) {
	      // We don't actually have to clear the table.  This could be a good idea
	      // for greater error checking, but we don't really do any anyway.  We
	      // will just track it with next_code and overwrite old entries.

	      next_code = eoi_code + 1;
	      cur_code_size = min_code_size + 1;
	      code_mask = (1 << cur_code_size) - 1;

	      // Don't update prev_code ?
	      prev_code = null;
	      continue;
	    } else if (code === eoi_code) {
	      break;
	    }

	    // We have a similar situation as the decoder, where we want to store
	    // variable length entries (code table entries), but we want to do in a
	    // faster manner than an array of arrays.  The code below stores sort of a
	    // linked list within the code table, and then "chases" through it to
	    // construct the dictionary entries.  When a new entry is created, just the
	    // last byte is stored, and the rest (prefix) of the entry is only
	    // referenced by its table entry.  Then the code chases through the
	    // prefixes until it reaches a single byte code.  We have to chase twice,
	    // first to compute the length, and then to actually copy the data to the
	    // output (backwards, since we know the length).  The alternative would be
	    // storing something in an intermediate stack, but that doesn't make any
	    // more sense.  I implemented an approach where it also stored the length
	    // in the code table, although it's a bit tricky because you run out of
	    // bits (12 + 12 + 8), but I didn't measure much improvements (the table
	    // entries are generally not the long).  Even when I created benchmarks for
	    // very long table entries the complexity did not seem worth it.
	    // The code table stores the prefix entry in 12 bits and then the suffix
	    // byte in 8 bits, so each entry is 20 bits.

	    var chase_code = code < next_code ? code : prev_code;

	    // Chase what we will output, either {CODE} or {CODE-1}.
	    var chase_length = 0;
	    var chase = chase_code;
	    while (chase > clear_code) {
	      chase = code_table[chase] >> 8;
	      ++chase_length;
	    }

	    var k = chase;

	    var op_end = op + chase_length + (chase_code !== code ? 1 : 0);
	    if (op_end > output_length) {
	      console.log("Warning, gif stream longer than expected.");
	      return;
	    }

	    // Already have the first byte from the chase, might as well write it fast.
	    output[op++] = k;

	    op += chase_length;
	    var b = op;  // Track pointer, writing backwards.

	    if (chase_code !== code)  // The case of emitting {CODE-1} + k.
	      output[op++] = k;

	    chase = chase_code;
	    while (chase_length--) {
	      chase = code_table[chase];
	      output[--b] = chase & 0xff;  // Write backwards.
	      chase >>= 8;  // Pull down to the prefix code.
	    }

	    if (prev_code !== null && next_code < 4096) {
	      code_table[next_code++] = prev_code << 8 | k;
	      // TODO(deanm): Figure out this clearing vs code growth logic better.  I
	      // have an feeling that it should just happen somewhere else, for now it
	      // is awkward between when we grow past the max and then hit a clear code.
	      // For now just check if we hit the max 12-bits (then a clear code should
	      // follow, also of course encoded in 12-bits).
	      if (next_code >= code_mask+1 && cur_code_size < 12) {
	        ++cur_code_size;
	        code_mask = code_mask << 1 | 1;
	      }
	    }

	    prev_code = code;
	  }

	  if (op !== output_length) {
	    console.log("Warning, gif stream shorter than expected.");
	  }

	  return output;
	}

	// CommonJS.
	try { exports.GifWriter = GifWriter; exports.GifReader = GifReader; } catch(e) {}

	},{}],179:[function(require,module,exports){

	var assign    = require('./lib/utils/common').assign;

	var deflate   = require('./lib/deflate');
	var inflate   = require('./lib/inflate');
	var constants = require('./lib/zlib/constants');

	var pako = {};

	assign(pako, deflate, inflate, constants);

	module.exports = pako;

	},{"./lib/deflate":180,"./lib/inflate":181,"./lib/utils/common":182,"./lib/zlib/constants":185}],180:[function(require,module,exports){


	var zlib_deflate = require('./zlib/deflate');
	var utils        = require('./utils/common');
	var strings      = require('./utils/strings');
	var msg          = require('./zlib/messages');
	var ZStream      = require('./zlib/zstream');

	var toString = Object.prototype.toString;

	/* Public constants ==========================================================*/
	/* ===========================================================================*/

	var Z_NO_FLUSH      = 0;
	var Z_FINISH        = 4;

	var Z_OK            = 0;
	var Z_STREAM_END    = 1;
	var Z_SYNC_FLUSH    = 2;

	var Z_DEFAULT_COMPRESSION = -1;

	var Z_DEFAULT_STRATEGY    = 0;

	var Z_DEFLATED  = 8;

	/* ===========================================================================*/


	/**
	 * class Deflate
	 *
	 * Generic JS-style wrapper for zlib calls. If you don't need
	 * streaming behaviour - use more simple functions: [[deflate]],
	 * [[deflateRaw]] and [[gzip]].
	 **/

	/* internal
	 * Deflate.chunks -> Array
	 *
	 * Chunks of output data, if [[Deflate#onData]] not overridden.
	 **/

	/**
	 * Deflate.result -> Uint8Array|Array
	 *
	 * Compressed result, generated by default [[Deflate#onData]]
	 * and [[Deflate#onEnd]] handlers. Filled after you push last chunk
	 * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you
	 * push a chunk with explicit flush (call [[Deflate#push]] with
	 * `Z_SYNC_FLUSH` param).
	 **/

	/**
	 * Deflate.err -> Number
	 *
	 * Error code after deflate finished. 0 (Z_OK) on success.
	 * You will not need it in real life, because deflate errors
	 * are possible only on wrong options or bad `onData` / `onEnd`
	 * custom handlers.
	 **/

	/**
	 * Deflate.msg -> String
	 *
	 * Error message, if [[Deflate.err]] != 0
	 **/


	/**
	 * new Deflate(options)
	 * - options (Object): zlib deflate options.
	 *
	 * Creates new deflator instance with specified params. Throws exception
	 * on bad params. Supported options:
	 *
	 * - `level`
	 * - `windowBits`
	 * - `memLevel`
	 * - `strategy`
	 * - `dictionary`
	 *
	 * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
	 * for more information on these.
	 *
	 * Additional options, for internal needs:
	 *
	 * - `chunkSize` - size of generated data chunks (16K by default)
	 * - `raw` (Boolean) - do raw deflate
	 * - `gzip` (Boolean) - create gzip wrapper
	 * - `to` (String) - if equal to 'string', then result will be "binary string"
	 *    (each char code [0..255])
	 * - `header` (Object) - custom header for gzip
	 *   - `text` (Boolean) - true if compressed data believed to be text
	 *   - `time` (Number) - modification time, unix timestamp
	 *   - `os` (Number) - operation system code
	 *   - `extra` (Array) - array of bytes with extra data (max 65536)
	 *   - `name` (String) - file name (binary string)
	 *   - `comment` (String) - comment (binary string)
	 *   - `hcrc` (Boolean) - true if header crc should be added
	 *
	 * ##### Example:
	 *
	 * ```javascript
	 * var pako = require('pako')
	 *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
	 *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
	 *
	 * var deflate = new pako.Deflate({ level: 3});
	 *
	 * deflate.push(chunk1, false);
	 * deflate.push(chunk2, true);  // true -> last chunk
	 *
	 * if (deflate.err) { throw new Error(deflate.err); }
	 *
	 * console.log(deflate.result);
	 * ```
	 **/
	function Deflate(options) {
	  if (!(this instanceof Deflate)) return new Deflate(options);

	  this.options = utils.assign({
	    level: Z_DEFAULT_COMPRESSION,
	    method: Z_DEFLATED,
	    chunkSize: 16384,
	    windowBits: 15,
	    memLevel: 8,
	    strategy: Z_DEFAULT_STRATEGY,
	    to: ''
	  }, options || {});

	  var opt = this.options;

	  if (opt.raw && (opt.windowBits > 0)) {
	    opt.windowBits = -opt.windowBits;
	  }

	  else if (opt.gzip && (opt.windowBits > 0) && (opt.windowBits < 16)) {
	    opt.windowBits += 16;
	  }

	  this.err    = 0;      // error code, if happens (0 = Z_OK)
	  this.msg    = '';     // error message
	  this.ended  = false;  // used to avoid multiple onEnd() calls
	  this.chunks = [];     // chunks of compressed data

	  this.strm = new ZStream();
	  this.strm.avail_out = 0;

	  var status = zlib_deflate.deflateInit2(
	    this.strm,
	    opt.level,
	    opt.method,
	    opt.windowBits,
	    opt.memLevel,
	    opt.strategy
	  );

	  if (status !== Z_OK) {
	    throw new Error(msg[status]);
	  }

	  if (opt.header) {
	    zlib_deflate.deflateSetHeader(this.strm, opt.header);
	  }

	  if (opt.dictionary) {
	    var dict;
	    // Convert data if needed
	    if (typeof opt.dictionary === 'string') {
	      // If we need to compress text, change encoding to utf8.
	      dict = strings.string2buf(opt.dictionary);
	    } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {
	      dict = new Uint8Array(opt.dictionary);
	    } else {
	      dict = opt.dictionary;
	    }

	    status = zlib_deflate.deflateSetDictionary(this.strm, dict);

	    if (status !== Z_OK) {
	      throw new Error(msg[status]);
	    }

	    this._dict_set = true;
	  }
	}

	/**
	 * Deflate#push(data[, mode]) -> Boolean
	 * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be
	 *   converted to utf8 byte sequence.
	 * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
	 *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.
	 *
	 * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with
	 * new compressed chunks. Returns `true` on success. The last data block must have
	 * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
	 * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you
	 * can use mode Z_SYNC_FLUSH, keeping the compression context.
	 *
	 * On fail call [[Deflate#onEnd]] with error code and return false.
	 *
	 * We strongly recommend to use `Uint8Array` on input for best speed (output
	 * array format is detected automatically). Also, don't skip last param and always
	 * use the same type in your code (boolean or number). That will improve JS speed.
	 *
	 * For regular `Array`-s make sure all elements are [0..255].
	 *
	 * ##### Example
	 *
	 * ```javascript
	 * push(chunk, false); // push one of data chunks
	 * ...
	 * push(chunk, true);  // push last chunk
	 * ```
	 **/
	Deflate.prototype.push = function (data, mode) {
	  var strm = this.strm;
	  var chunkSize = this.options.chunkSize;
	  var status, _mode;

	  if (this.ended) { return false; }

	  _mode = (mode === ~~mode) ? mode : ((mode === true) ? Z_FINISH : Z_NO_FLUSH);

	  // Convert data if needed
	  if (typeof data === 'string') {
	    // If we need to compress text, change encoding to utf8.
	    strm.input = strings.string2buf(data);
	  } else if (toString.call(data) === '[object ArrayBuffer]') {
	    strm.input = new Uint8Array(data);
	  } else {
	    strm.input = data;
	  }

	  strm.next_in = 0;
	  strm.avail_in = strm.input.length;

	  do {
	    if (strm.avail_out === 0) {
	      strm.output = new utils.Buf8(chunkSize);
	      strm.next_out = 0;
	      strm.avail_out = chunkSize;
	    }
	    status = zlib_deflate.deflate(strm, _mode);    /* no bad return value */

	    if (status !== Z_STREAM_END && status !== Z_OK) {
	      this.onEnd(status);
	      this.ended = true;
	      return false;
	    }
	    if (strm.avail_out === 0 || (strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH))) {
	      if (this.options.to === 'string') {
	        this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));
	      } else {
	        this.onData(utils.shrinkBuf(strm.output, strm.next_out));
	      }
	    }
	  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END);

	  // Finalize on the last chunk.
	  if (_mode === Z_FINISH) {
	    status = zlib_deflate.deflateEnd(this.strm);
	    this.onEnd(status);
	    this.ended = true;
	    return status === Z_OK;
	  }

	  // callback interim results if Z_SYNC_FLUSH.
	  if (_mode === Z_SYNC_FLUSH) {
	    this.onEnd(Z_OK);
	    strm.avail_out = 0;
	    return true;
	  }

	  return true;
	};


	/**
	 * Deflate#onData(chunk) -> Void
	 * - chunk (Uint8Array|Array|String): output data. Type of array depends
	 *   on js engine support. When string output requested, each chunk
	 *   will be string.
	 *
	 * By default, stores data blocks in `chunks[]` property and glue
	 * those in `onEnd`. Override this handler, if you need another behaviour.
	 **/
	Deflate.prototype.onData = function (chunk) {
	  this.chunks.push(chunk);
	};


	/**
	 * Deflate#onEnd(status) -> Void
	 * - status (Number): deflate status. 0 (Z_OK) on success,
	 *   other if not.
	 *
	 * Called once after you tell deflate that the input stream is
	 * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
	 * or if an error happened. By default - join collected chunks,
	 * free memory and fill `results` / `err` properties.
	 **/
	Deflate.prototype.onEnd = function (status) {
	  // On success - join
	  if (status === Z_OK) {
	    if (this.options.to === 'string') {
	      this.result = this.chunks.join('');
	    } else {
	      this.result = utils.flattenChunks(this.chunks);
	    }
	  }
	  this.chunks = [];
	  this.err = status;
	  this.msg = this.strm.msg;
	};


	/**
	 * deflate(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to compress.
	 * - options (Object): zlib deflate options.
	 *
	 * Compress `data` with deflate algorithm and `options`.
	 *
	 * Supported options are:
	 *
	 * - level
	 * - windowBits
	 * - memLevel
	 * - strategy
	 * - dictionary
	 *
	 * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
	 * for more information on these.
	 *
	 * Sugar (options):
	 *
	 * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
	 *   negative windowBits implicitly.
	 * - `to` (String) - if equal to 'string', then result will be "binary string"
	 *    (each char code [0..255])
	 *
	 * ##### Example:
	 *
	 * ```javascript
	 * var pako = require('pako')
	 *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);
	 *
	 * console.log(pako.deflate(data));
	 * ```
	 **/
	function deflate(input, options) {
	  var deflator = new Deflate(options);

	  deflator.push(input, true);

	  // That will never happens, if you don't cheat with options :)
	  if (deflator.err) { throw deflator.msg || msg[deflator.err]; }

	  return deflator.result;
	}


	/**
	 * deflateRaw(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to compress.
	 * - options (Object): zlib deflate options.
	 *
	 * The same as [[deflate]], but creates raw data, without wrapper
	 * (header and adler32 crc).
	 **/
	function deflateRaw(input, options) {
	  options = options || {};
	  options.raw = true;
	  return deflate(input, options);
	}


	/**
	 * gzip(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to compress.
	 * - options (Object): zlib deflate options.
	 *
	 * The same as [[deflate]], but create gzip wrapper instead of
	 * deflate one.
	 **/
	function gzip(input, options) {
	  options = options || {};
	  options.gzip = true;
	  return deflate(input, options);
	}


	exports.Deflate = Deflate;
	exports.deflate = deflate;
	exports.deflateRaw = deflateRaw;
	exports.gzip = gzip;

	},{"./utils/common":182,"./utils/strings":183,"./zlib/deflate":187,"./zlib/messages":192,"./zlib/zstream":194}],181:[function(require,module,exports){


	var zlib_inflate = require('./zlib/inflate');
	var utils        = require('./utils/common');
	var strings      = require('./utils/strings');
	var c            = require('./zlib/constants');
	var msg          = require('./zlib/messages');
	var ZStream      = require('./zlib/zstream');
	var GZheader     = require('./zlib/gzheader');

	var toString = Object.prototype.toString;

	/**
	 * class Inflate
	 *
	 * Generic JS-style wrapper for zlib calls. If you don't need
	 * streaming behaviour - use more simple functions: [[inflate]]
	 * and [[inflateRaw]].
	 **/

	/* internal
	 * inflate.chunks -> Array
	 *
	 * Chunks of output data, if [[Inflate#onData]] not overridden.
	 **/

	/**
	 * Inflate.result -> Uint8Array|Array|String
	 *
	 * Uncompressed result, generated by default [[Inflate#onData]]
	 * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
	 * (call [[Inflate#push]] with `Z_FINISH` / `true` param) or if you
	 * push a chunk with explicit flush (call [[Inflate#push]] with
	 * `Z_SYNC_FLUSH` param).
	 **/

	/**
	 * Inflate.err -> Number
	 *
	 * Error code after inflate finished. 0 (Z_OK) on success.
	 * Should be checked if broken data possible.
	 **/

	/**
	 * Inflate.msg -> String
	 *
	 * Error message, if [[Inflate.err]] != 0
	 **/


	/**
	 * new Inflate(options)
	 * - options (Object): zlib inflate options.
	 *
	 * Creates new inflator instance with specified params. Throws exception
	 * on bad params. Supported options:
	 *
	 * - `windowBits`
	 * - `dictionary`
	 *
	 * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
	 * for more information on these.
	 *
	 * Additional options, for internal needs:
	 *
	 * - `chunkSize` - size of generated data chunks (16K by default)
	 * - `raw` (Boolean) - do raw inflate
	 * - `to` (String) - if equal to 'string', then result will be converted
	 *   from utf8 to utf16 (javascript) string. When string output requested,
	 *   chunk length can differ from `chunkSize`, depending on content.
	 *
	 * By default, when no options set, autodetect deflate/gzip data format via
	 * wrapper header.
	 *
	 * ##### Example:
	 *
	 * ```javascript
	 * var pako = require('pako')
	 *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
	 *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
	 *
	 * var inflate = new pako.Inflate({ level: 3});
	 *
	 * inflate.push(chunk1, false);
	 * inflate.push(chunk2, true);  // true -> last chunk
	 *
	 * if (inflate.err) { throw new Error(inflate.err); }
	 *
	 * console.log(inflate.result);
	 * ```
	 **/
	function Inflate(options) {
	  if (!(this instanceof Inflate)) return new Inflate(options);

	  this.options = utils.assign({
	    chunkSize: 16384,
	    windowBits: 0,
	    to: ''
	  }, options || {});

	  var opt = this.options;

	  // Force window size for `raw` data, if not set directly,
	  // because we have no header for autodetect.
	  if (opt.raw && (opt.windowBits >= 0) && (opt.windowBits < 16)) {
	    opt.windowBits = -opt.windowBits;
	    if (opt.windowBits === 0) { opt.windowBits = -15; }
	  }

	  // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate
	  if ((opt.windowBits >= 0) && (opt.windowBits < 16) &&
	      !(options && options.windowBits)) {
	    opt.windowBits += 32;
	  }

	  // Gzip header has no info about windows size, we can do autodetect only
	  // for deflate. So, if window size not set, force it to max when gzip possible
	  if ((opt.windowBits > 15) && (opt.windowBits < 48)) {
	    // bit 3 (16) -> gzipped data
	    // bit 4 (32) -> autodetect gzip/deflate
	    if ((opt.windowBits & 15) === 0) {
	      opt.windowBits |= 15;
	    }
	  }

	  this.err    = 0;      // error code, if happens (0 = Z_OK)
	  this.msg    = '';     // error message
	  this.ended  = false;  // used to avoid multiple onEnd() calls
	  this.chunks = [];     // chunks of compressed data

	  this.strm   = new ZStream();
	  this.strm.avail_out = 0;

	  var status  = zlib_inflate.inflateInit2(
	    this.strm,
	    opt.windowBits
	  );

	  if (status !== c.Z_OK) {
	    throw new Error(msg[status]);
	  }

	  this.header = new GZheader();

	  zlib_inflate.inflateGetHeader(this.strm, this.header);
	}

	/**
	 * Inflate#push(data[, mode]) -> Boolean
	 * - data (Uint8Array|Array|ArrayBuffer|String): input data
	 * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
	 *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.
	 *
	 * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
	 * new output chunks. Returns `true` on success. The last data block must have
	 * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
	 * [[Inflate#onEnd]]. For interim explicit flushes (without ending the stream) you
	 * can use mode Z_SYNC_FLUSH, keeping the decompression context.
	 *
	 * On fail call [[Inflate#onEnd]] with error code and return false.
	 *
	 * We strongly recommend to use `Uint8Array` on input for best speed (output
	 * format is detected automatically). Also, don't skip last param and always
	 * use the same type in your code (boolean or number). That will improve JS speed.
	 *
	 * For regular `Array`-s make sure all elements are [0..255].
	 *
	 * ##### Example
	 *
	 * ```javascript
	 * push(chunk, false); // push one of data chunks
	 * ...
	 * push(chunk, true);  // push last chunk
	 * ```
	 **/
	Inflate.prototype.push = function (data, mode) {
	  var strm = this.strm;
	  var chunkSize = this.options.chunkSize;
	  var dictionary = this.options.dictionary;
	  var status, _mode;
	  var next_out_utf8, tail, utf8str;
	  var dict;

	  // Flag to properly process Z_BUF_ERROR on testing inflate call
	  // when we check that all output data was flushed.
	  var allowBufError = false;

	  if (this.ended) { return false; }
	  _mode = (mode === ~~mode) ? mode : ((mode === true) ? c.Z_FINISH : c.Z_NO_FLUSH);

	  // Convert data if needed
	  if (typeof data === 'string') {
	    // Only binary strings can be decompressed on practice
	    strm.input = strings.binstring2buf(data);
	  } else if (toString.call(data) === '[object ArrayBuffer]') {
	    strm.input = new Uint8Array(data);
	  } else {
	    strm.input = data;
	  }

	  strm.next_in = 0;
	  strm.avail_in = strm.input.length;

	  do {
	    if (strm.avail_out === 0) {
	      strm.output = new utils.Buf8(chunkSize);
	      strm.next_out = 0;
	      strm.avail_out = chunkSize;
	    }

	    status = zlib_inflate.inflate(strm, c.Z_NO_FLUSH);    /* no bad return value */

	    if (status === c.Z_NEED_DICT && dictionary) {
	      // Convert data if needed
	      if (typeof dictionary === 'string') {
	        dict = strings.string2buf(dictionary);
	      } else if (toString.call(dictionary) === '[object ArrayBuffer]') {
	        dict = new Uint8Array(dictionary);
	      } else {
	        dict = dictionary;
	      }

	      status = zlib_inflate.inflateSetDictionary(this.strm, dict);

	    }

	    if (status === c.Z_BUF_ERROR && allowBufError === true) {
	      status = c.Z_OK;
	      allowBufError = false;
	    }

	    if (status !== c.Z_STREAM_END && status !== c.Z_OK) {
	      this.onEnd(status);
	      this.ended = true;
	      return false;
	    }

	    if (strm.next_out) {
	      if (strm.avail_out === 0 || status === c.Z_STREAM_END || (strm.avail_in === 0 && (_mode === c.Z_FINISH || _mode === c.Z_SYNC_FLUSH))) {

	        if (this.options.to === 'string') {

	          next_out_utf8 = strings.utf8border(strm.output, strm.next_out);

	          tail = strm.next_out - next_out_utf8;
	          utf8str = strings.buf2string(strm.output, next_out_utf8);

	          // move tail
	          strm.next_out = tail;
	          strm.avail_out = chunkSize - tail;
	          if (tail) { utils.arraySet(strm.output, strm.output, next_out_utf8, tail, 0); }

	          this.onData(utf8str);

	        } else {
	          this.onData(utils.shrinkBuf(strm.output, strm.next_out));
	        }
	      }
	    }

	    // When no more input data, we should check that internal inflate buffers
	    // are flushed. The only way to do it when avail_out = 0 - run one more
	    // inflate pass. But if output data not exists, inflate return Z_BUF_ERROR.
	    // Here we set flag to process this error properly.
	    //
	    // NOTE. Deflate does not return error in this case and does not needs such
	    // logic.
	    if (strm.avail_in === 0 && strm.avail_out === 0) {
	      allowBufError = true;
	    }

	  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== c.Z_STREAM_END);

	  if (status === c.Z_STREAM_END) {
	    _mode = c.Z_FINISH;
	  }

	  // Finalize on the last chunk.
	  if (_mode === c.Z_FINISH) {
	    status = zlib_inflate.inflateEnd(this.strm);
	    this.onEnd(status);
	    this.ended = true;
	    return status === c.Z_OK;
	  }

	  // callback interim results if Z_SYNC_FLUSH.
	  if (_mode === c.Z_SYNC_FLUSH) {
	    this.onEnd(c.Z_OK);
	    strm.avail_out = 0;
	    return true;
	  }

	  return true;
	};


	/**
	 * Inflate#onData(chunk) -> Void
	 * - chunk (Uint8Array|Array|String): output data. Type of array depends
	 *   on js engine support. When string output requested, each chunk
	 *   will be string.
	 *
	 * By default, stores data blocks in `chunks[]` property and glue
	 * those in `onEnd`. Override this handler, if you need another behaviour.
	 **/
	Inflate.prototype.onData = function (chunk) {
	  this.chunks.push(chunk);
	};


	/**
	 * Inflate#onEnd(status) -> Void
	 * - status (Number): inflate status. 0 (Z_OK) on success,
	 *   other if not.
	 *
	 * Called either after you tell inflate that the input stream is
	 * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
	 * or if an error happened. By default - join collected chunks,
	 * free memory and fill `results` / `err` properties.
	 **/
	Inflate.prototype.onEnd = function (status) {
	  // On success - join
	  if (status === c.Z_OK) {
	    if (this.options.to === 'string') {
	      // Glue & convert here, until we teach pako to send
	      // utf8 aligned strings to onData
	      this.result = this.chunks.join('');
	    } else {
	      this.result = utils.flattenChunks(this.chunks);
	    }
	  }
	  this.chunks = [];
	  this.err = status;
	  this.msg = this.strm.msg;
	};


	/**
	 * inflate(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to decompress.
	 * - options (Object): zlib inflate options.
	 *
	 * Decompress `data` with inflate/ungzip and `options`. Autodetect
	 * format via wrapper header by default. That's why we don't provide
	 * separate `ungzip` method.
	 *
	 * Supported options are:
	 *
	 * - windowBits
	 *
	 * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
	 * for more information.
	 *
	 * Sugar (options):
	 *
	 * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
	 *   negative windowBits implicitly.
	 * - `to` (String) - if equal to 'string', then result will be converted
	 *   from utf8 to utf16 (javascript) string. When string output requested,
	 *   chunk length can differ from `chunkSize`, depending on content.
	 *
	 *
	 * ##### Example:
	 *
	 * ```javascript
	 * var pako = require('pako')
	 *   , input = pako.deflate([1,2,3,4,5,6,7,8,9])
	 *   , output;
	 *
	 * try {
	 *   output = pako.inflate(input);
	 * } catch (err)
	 *   console.log(err);
	 * }
	 * ```
	 **/
	function inflate(input, options) {
	  var inflator = new Inflate(options);

	  inflator.push(input, true);

	  // That will never happens, if you don't cheat with options :)
	  if (inflator.err) { throw inflator.msg || msg[inflator.err]; }

	  return inflator.result;
	}


	/**
	 * inflateRaw(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to decompress.
	 * - options (Object): zlib inflate options.
	 *
	 * The same as [[inflate]], but creates raw data, without wrapper
	 * (header and adler32 crc).
	 **/
	function inflateRaw(input, options) {
	  options = options || {};
	  options.raw = true;
	  return inflate(input, options);
	}


	/**
	 * ungzip(data[, options]) -> Uint8Array|Array|String
	 * - data (Uint8Array|Array|String): input data to decompress.
	 * - options (Object): zlib inflate options.
	 *
	 * Just shortcut to [[inflate]], because it autodetects format
	 * by header.content. Done for convenience.
	 **/


	exports.Inflate = Inflate;
	exports.inflate = inflate;
	exports.inflateRaw = inflateRaw;
	exports.ungzip  = inflate;

	},{"./utils/common":182,"./utils/strings":183,"./zlib/constants":185,"./zlib/gzheader":188,"./zlib/inflate":190,"./zlib/messages":192,"./zlib/zstream":194}],182:[function(require,module,exports){


	var TYPED_OK =  (typeof Uint8Array !== 'undefined') &&
	                (typeof Uint16Array !== 'undefined') &&
	                (typeof Int32Array !== 'undefined');

	function _has(obj, key) {
	  return Object.prototype.hasOwnProperty.call(obj, key);
	}

	exports.assign = function (obj /*from1, from2, from3, ...*/) {
	  var sources = Array.prototype.slice.call(arguments, 1);
	  while (sources.length) {
	    var source = sources.shift();
	    if (!source) { continue; }

	    if (typeof source !== 'object') {
	      throw new TypeError(source + 'must be non-object');
	    }

	    for (var p in source) {
	      if (_has(source, p)) {
	        obj[p] = source[p];
	      }
	    }
	  }

	  return obj;
	};


	// reduce buffer size, avoiding mem copy
	exports.shrinkBuf = function (buf, size) {
	  if (buf.length === size) { return buf; }
	  if (buf.subarray) { return buf.subarray(0, size); }
	  buf.length = size;
	  return buf;
	};


	var fnTyped = {
	  arraySet: function (dest, src, src_offs, len, dest_offs) {
	    if (src.subarray && dest.subarray) {
	      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
	      return;
	    }
	    // Fallback to ordinary array
	    for (var i = 0; i < len; i++) {
	      dest[dest_offs + i] = src[src_offs + i];
	    }
	  },
	  // Join array of chunks to single array.
	  flattenChunks: function (chunks) {
	    var i, l, len, pos, chunk, result;

	    // calculate data length
	    len = 0;
	    for (i = 0, l = chunks.length; i < l; i++) {
	      len += chunks[i].length;
	    }

	    // join chunks
	    result = new Uint8Array(len);
	    pos = 0;
	    for (i = 0, l = chunks.length; i < l; i++) {
	      chunk = chunks[i];
	      result.set(chunk, pos);
	      pos += chunk.length;
	    }

	    return result;
	  }
	};

	var fnUntyped = {
	  arraySet: function (dest, src, src_offs, len, dest_offs) {
	    for (var i = 0; i < len; i++) {
	      dest[dest_offs + i] = src[src_offs + i];
	    }
	  },
	  // Join array of chunks to single array.
	  flattenChunks: function (chunks) {
	    return [].concat.apply([], chunks);
	  }
	};


	// Enable/Disable typed arrays use, for testing
	//
	exports.setTyped = function (on) {
	  if (on) {
	    exports.Buf8  = Uint8Array;
	    exports.Buf16 = Uint16Array;
	    exports.Buf32 = Int32Array;
	    exports.assign(exports, fnTyped);
	  } else {
	    exports.Buf8  = Array;
	    exports.Buf16 = Array;
	    exports.Buf32 = Array;
	    exports.assign(exports, fnUntyped);
	  }
	};

	exports.setTyped(TYPED_OK);

	},{}],183:[function(require,module,exports){


	var utils = require('./common');


	// Quick check if we can use fast array to bin string conversion
	//
	// - apply(Array) can fail on Android 2.2
	// - apply(Uint8Array) can fail on iOS 5.1 Safari
	//
	var STR_APPLY_OK = true;
	var STR_APPLY_UIA_OK = true;

	try { String.fromCharCode.apply(null, [ 0 ]); } catch (__) { STR_APPLY_OK = false; }
	try { String.fromCharCode.apply(null, new Uint8Array(1)); } catch (__) { STR_APPLY_UIA_OK = false; }


	// Table with utf8 lengths (calculated by first byte of sequence)
	// Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
	// because max possible codepoint is 0x10ffff
	var _utf8len = new utils.Buf8(256);
	for (var q = 0; q < 256; q++) {
	  _utf8len[q] = (q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1);
	}
	_utf8len[254] = _utf8len[254] = 1; // Invalid sequence start


	// convert string to array (typed, when possible)
	exports.string2buf = function (str) {
	  var buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;

	  // count binary size
	  for (m_pos = 0; m_pos < str_len; m_pos++) {
	    c = str.charCodeAt(m_pos);
	    if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
	      c2 = str.charCodeAt(m_pos + 1);
	      if ((c2 & 0xfc00) === 0xdc00) {
	        c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
	        m_pos++;
	      }
	    }
	    buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
	  }

	  // allocate buffer
	  buf = new utils.Buf8(buf_len);

	  // convert
	  for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
	    c = str.charCodeAt(m_pos);
	    if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {
	      c2 = str.charCodeAt(m_pos + 1);
	      if ((c2 & 0xfc00) === 0xdc00) {
	        c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
	        m_pos++;
	      }
	    }
	    if (c < 0x80) {
	      /* one byte */
	      buf[i++] = c;
	    } else if (c < 0x800) {
	      /* two bytes */
	      buf[i++] = 0xC0 | (c >>> 6);
	      buf[i++] = 0x80 | (c & 0x3f);
	    } else if (c < 0x10000) {
	      /* three bytes */
	      buf[i++] = 0xE0 | (c >>> 12);
	      buf[i++] = 0x80 | (c >>> 6 & 0x3f);
	      buf[i++] = 0x80 | (c & 0x3f);
	    } else {
	      /* four bytes */
	      buf[i++] = 0xf0 | (c >>> 18);
	      buf[i++] = 0x80 | (c >>> 12 & 0x3f);
	      buf[i++] = 0x80 | (c >>> 6 & 0x3f);
	      buf[i++] = 0x80 | (c & 0x3f);
	    }
	  }

	  return buf;
	};

	// Helper (used in 2 places)
	function buf2binstring(buf, len) {
	  // use fallback for big arrays to avoid stack overflow
	  if (len < 65537) {
	    if ((buf.subarray && STR_APPLY_UIA_OK) || (!buf.subarray && STR_APPLY_OK)) {
	      return String.fromCharCode.apply(null, utils.shrinkBuf(buf, len));
	    }
	  }

	  var result = '';
	  for (var i = 0; i < len; i++) {
	    result += String.fromCharCode(buf[i]);
	  }
	  return result;
	}


	// Convert byte array to binary string
	exports.buf2binstring = function (buf) {
	  return buf2binstring(buf, buf.length);
	};


	// Convert binary string (typed, when possible)
	exports.binstring2buf = function (str) {
	  var buf = new utils.Buf8(str.length);
	  for (var i = 0, len = buf.length; i < len; i++) {
	    buf[i] = str.charCodeAt(i);
	  }
	  return buf;
	};


	// convert array to string
	exports.buf2string = function (buf, max) {
	  var i, out, c, c_len;
	  var len = max || buf.length;

	  // Reserve max possible length (2 words per char)
	  // NB: by unknown reasons, Array is significantly faster for
	  //     String.fromCharCode.apply than Uint16Array.
	  var utf16buf = new Array(len * 2);

	  for (out = 0, i = 0; i < len;) {
	    c = buf[i++];
	    // quick process ascii
	    if (c < 0x80) { utf16buf[out++] = c; continue; }

	    c_len = _utf8len[c];
	    // skip 5 & 6 byte codes
	    if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len - 1; continue; }

	    // apply mask on first byte
	    c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;
	    // join the rest
	    while (c_len > 1 && i < len) {
	      c = (c << 6) | (buf[i++] & 0x3f);
	      c_len--;
	    }

	    // terminated by end of string?
	    if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }

	    if (c < 0x10000) {
	      utf16buf[out++] = c;
	    } else {
	      c -= 0x10000;
	      utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);
	      utf16buf[out++] = 0xdc00 | (c & 0x3ff);
	    }
	  }

	  return buf2binstring(utf16buf, out);
	};


	// Calculate max possible position in utf8 buffer,
	// that will not break sequence. If that's not possible
	// - (very small limits) return max size as is.
	//
	// buf[] - utf8 bytes array
	// max   - length limit (mandatory);
	exports.utf8border = function (buf, max) {
	  var pos;

	  max = max || buf.length;
	  if (max > buf.length) { max = buf.length; }

	  // go back from last position, until start of sequence found
	  pos = max - 1;
	  while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }

	  // Very small and broken sequence,
	  // return max, because we should return something anyway.
	  if (pos < 0) { return max; }

	  // If we came to start of buffer - that means buffer is too small,
	  // return max too.
	  if (pos === 0) { return max; }

	  return (pos + _utf8len[buf[pos]] > max) ? pos : max;
	};

	},{"./common":182}],184:[function(require,module,exports){

	// Note: adler32 takes 12% for level 0 and 2% for level 6.
	// It isn't worth it to make additional optimizations as in original.
	// Small size is preferable.

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	function adler32(adler, buf, len, pos) {
	  var s1 = (adler & 0xffff) |0,
	      s2 = ((adler >>> 16) & 0xffff) |0,
	      n = 0;

	  while (len !== 0) {
	    // Set limit ~ twice less than 5552, to keep
	    // s2 in 31-bits, because we force signed ints.
	    // in other case %= will fail.
	    n = len > 2000 ? 2000 : len;
	    len -= n;

	    do {
	      s1 = (s1 + buf[pos++]) |0;
	      s2 = (s2 + s1) |0;
	    } while (--n);

	    s1 %= 65521;
	    s2 %= 65521;
	  }

	  return (s1 | (s2 << 16)) |0;
	}


	module.exports = adler32;

	},{}],185:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	module.exports = {

	  /* Allowed flush values; see deflate() and inflate() below for details */
	  Z_NO_FLUSH:         0,
	  Z_PARTIAL_FLUSH:    1,
	  Z_SYNC_FLUSH:       2,
	  Z_FULL_FLUSH:       3,
	  Z_FINISH:           4,
	  Z_BLOCK:            5,
	  Z_TREES:            6,

	  /* Return codes for the compression/decompression functions. Negative values
	  * are errors, positive values are used for special but normal events.
	  */
	  Z_OK:               0,
	  Z_STREAM_END:       1,
	  Z_NEED_DICT:        2,
	  Z_ERRNO:           -1,
	  Z_STREAM_ERROR:    -2,
	  Z_DATA_ERROR:      -3,
	  //Z_MEM_ERROR:     -4,
	  Z_BUF_ERROR:       -5,
	  //Z_VERSION_ERROR: -6,

	  /* compression levels */
	  Z_NO_COMPRESSION:         0,
	  Z_BEST_SPEED:             1,
	  Z_BEST_COMPRESSION:       9,
	  Z_DEFAULT_COMPRESSION:   -1,


	  Z_FILTERED:               1,
	  Z_HUFFMAN_ONLY:           2,
	  Z_RLE:                    3,
	  Z_FIXED:                  4,
	  Z_DEFAULT_STRATEGY:       0,

	  /* Possible values of the data_type field (though see inflate()) */
	  Z_BINARY:                 0,
	  Z_TEXT:                   1,
	  //Z_ASCII:                1, // = Z_TEXT (deprecated)
	  Z_UNKNOWN:                2,

	  /* The deflate compression method */
	  Z_DEFLATED:               8
	  //Z_NULL:                 null // Use -1 or null inline, depending on var type
	};

	},{}],186:[function(require,module,exports){

	// Note: we can't get significant speed boost here.
	// So write code to minimize size - no pregenerated tables
	// and array tools dependencies.

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	// Use ordinary array, since untyped makes no boost here
	function makeTable() {
	  var c, table = [];

	  for (var n = 0; n < 256; n++) {
	    c = n;
	    for (var k = 0; k < 8; k++) {
	      c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
	    }
	    table[n] = c;
	  }

	  return table;
	}

	// Create table on load. Just 255 signed longs. Not a problem.
	var crcTable = makeTable();


	function crc32(crc, buf, len, pos) {
	  var t = crcTable,
	      end = pos + len;

	  crc ^= -1;

	  for (var i = pos; i < end; i++) {
	    crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
	  }

	  return (crc ^ (-1)); // >>> 0;
	}


	module.exports = crc32;

	},{}],187:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	var utils   = require('../utils/common');
	var trees   = require('./trees');
	var adler32 = require('./adler32');
	var crc32   = require('./crc32');
	var msg     = require('./messages');

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	/* Allowed flush values; see deflate() and inflate() below for details */
	var Z_NO_FLUSH      = 0;
	var Z_PARTIAL_FLUSH = 1;
	//var Z_SYNC_FLUSH    = 2;
	var Z_FULL_FLUSH    = 3;
	var Z_FINISH        = 4;
	var Z_BLOCK         = 5;
	//var Z_TREES         = 6;


	/* Return codes for the compression/decompression functions. Negative values
	 * are errors, positive values are used for special but normal events.
	 */
	var Z_OK            = 0;
	var Z_STREAM_END    = 1;
	//var Z_NEED_DICT     = 2;
	//var Z_ERRNO         = -1;
	var Z_STREAM_ERROR  = -2;
	var Z_DATA_ERROR    = -3;
	//var Z_MEM_ERROR     = -4;
	var Z_BUF_ERROR     = -5;
	//var Z_VERSION_ERROR = -6;


	/* compression levels */
	//var Z_NO_COMPRESSION      = 0;
	//var Z_BEST_SPEED          = 1;
	//var Z_BEST_COMPRESSION    = 9;
	var Z_DEFAULT_COMPRESSION = -1;


	var Z_FILTERED            = 1;
	var Z_HUFFMAN_ONLY        = 2;
	var Z_RLE                 = 3;
	var Z_FIXED               = 4;
	var Z_DEFAULT_STRATEGY    = 0;

	/* Possible values of the data_type field (though see inflate()) */
	//var Z_BINARY              = 0;
	//var Z_TEXT                = 1;
	//var Z_ASCII               = 1; // = Z_TEXT
	var Z_UNKNOWN             = 2;


	/* The deflate compression method */
	var Z_DEFLATED  = 8;

	/*============================================================================*/


	var MAX_MEM_LEVEL = 9;
	/* Maximum value for memLevel in deflateInit2 */
	var MAX_WBITS = 15;
	/* 32K LZ77 window */
	var DEF_MEM_LEVEL = 8;


	var LENGTH_CODES  = 29;
	/* number of length codes, not counting the special END_BLOCK code */
	var LITERALS      = 256;
	/* number of literal bytes 0..255 */
	var L_CODES       = LITERALS + 1 + LENGTH_CODES;
	/* number of Literal or Length codes, including the END_BLOCK code */
	var D_CODES       = 30;
	/* number of distance codes */
	var BL_CODES      = 19;
	/* number of codes used to transfer the bit lengths */
	var HEAP_SIZE     = 2 * L_CODES + 1;
	/* maximum heap size */
	var MAX_BITS  = 15;
	/* All codes must not exceed MAX_BITS bits */

	var MIN_MATCH = 3;
	var MAX_MATCH = 258;
	var MIN_LOOKAHEAD = (MAX_MATCH + MIN_MATCH + 1);

	var PRESET_DICT = 0x20;

	var INIT_STATE = 42;
	var EXTRA_STATE = 69;
	var NAME_STATE = 73;
	var COMMENT_STATE = 91;
	var HCRC_STATE = 103;
	var BUSY_STATE = 113;
	var FINISH_STATE = 666;

	var BS_NEED_MORE      = 1; /* block not completed, need more input or more output */
	var BS_BLOCK_DONE     = 2; /* block flush performed */
	var BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */
	var BS_FINISH_DONE    = 4; /* finish done, accept no more input or output */

	var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

	function err(strm, errorCode) {
	  strm.msg = msg[errorCode];
	  return errorCode;
	}

	function rank(f) {
	  return ((f) << 1) - ((f) > 4 ? 9 : 0);
	}

	function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }


	/* =========================================================================
	 * Flush as much pending output as possible. All deflate() output goes
	 * through this function so some applications may wish to modify it
	 * to avoid allocating a large strm->output buffer and copying into it.
	 * (See also read_buf()).
	 */
	function flush_pending(strm) {
	  var s = strm.state;

	  //_tr_flush_bits(s);
	  var len = s.pending;
	  if (len > strm.avail_out) {
	    len = strm.avail_out;
	  }
	  if (len === 0) { return; }

	  utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
	  strm.next_out += len;
	  s.pending_out += len;
	  strm.total_out += len;
	  strm.avail_out -= len;
	  s.pending -= len;
	  if (s.pending === 0) {
	    s.pending_out = 0;
	  }
	}


	function flush_block_only(s, last) {
	  trees._tr_flush_block(s, (s.block_start >= 0 ? s.block_start : -1), s.strstart - s.block_start, last);
	  s.block_start = s.strstart;
	  flush_pending(s.strm);
	}


	function put_byte(s, b) {
	  s.pending_buf[s.pending++] = b;
	}


	/* =========================================================================
	 * Put a short in the pending buffer. The 16-bit value is put in MSB order.
	 * IN assertion: the stream state is correct and there is enough room in
	 * pending_buf.
	 */
	function putShortMSB(s, b) {
	//  put_byte(s, (Byte)(b >> 8));
	//  put_byte(s, (Byte)(b & 0xff));
	  s.pending_buf[s.pending++] = (b >>> 8) & 0xff;
	  s.pending_buf[s.pending++] = b & 0xff;
	}


	/* ===========================================================================
	 * Read a new buffer from the current input stream, update the adler32
	 * and total number of bytes read.  All deflate() input goes through
	 * this function so some applications may wish to modify it to avoid
	 * allocating a large strm->input buffer and copying from it.
	 * (See also flush_pending()).
	 */
	function read_buf(strm, buf, start, size) {
	  var len = strm.avail_in;

	  if (len > size) { len = size; }
	  if (len === 0) { return 0; }

	  strm.avail_in -= len;

	  // zmemcpy(buf, strm->next_in, len);
	  utils.arraySet(buf, strm.input, strm.next_in, len, start);
	  if (strm.state.wrap === 1) {
	    strm.adler = adler32(strm.adler, buf, len, start);
	  }

	  else if (strm.state.wrap === 2) {
	    strm.adler = crc32(strm.adler, buf, len, start);
	  }

	  strm.next_in += len;
	  strm.total_in += len;

	  return len;
	}


	/* ===========================================================================
	 * Set match_start to the longest match starting at the given string and
	 * return its length. Matches shorter or equal to prev_length are discarded,
	 * in which case the result is equal to prev_length and match_start is
	 * garbage.
	 * IN assertions: cur_match is the head of the hash chain for the current
	 *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
	 * OUT assertion: the match length is not greater than s->lookahead.
	 */
	function longest_match(s, cur_match) {
	  var chain_length = s.max_chain_length;      /* max hash chain length */
	  var scan = s.strstart; /* current string */
	  var match;                       /* matched string */
	  var len;                           /* length of current match */
	  var best_len = s.prev_length;              /* best match length so far */
	  var nice_match = s.nice_match;             /* stop if match long enough */
	  var limit = (s.strstart > (s.w_size - MIN_LOOKAHEAD)) ?
	      s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0/*NIL*/;

	  var _win = s.window; // shortcut

	  var wmask = s.w_mask;
	  var prev  = s.prev;

	  /* Stop when cur_match becomes <= limit. To simplify the code,
	   * we prevent matches with the string of window index 0.
	   */

	  var strend = s.strstart + MAX_MATCH;
	  var scan_end1  = _win[scan + best_len - 1];
	  var scan_end   = _win[scan + best_len];

	  /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
	   * It is easy to get rid of this optimization if necessary.
	   */
	  // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

	  /* Do not waste too much time if we already have a good match: */
	  if (s.prev_length >= s.good_match) {
	    chain_length >>= 2;
	  }
	  /* Do not look for matches beyond the end of the input. This is necessary
	   * to make deflate deterministic.
	   */
	  if (nice_match > s.lookahead) { nice_match = s.lookahead; }

	  // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");

	  do {
	    // Assert(cur_match < s->strstart, "no future");
	    match = cur_match;

	    /* Skip to next match if the match length cannot increase
	     * or if the match length is less than 2.  Note that the checks below
	     * for insufficient lookahead only occur occasionally for performance
	     * reasons.  Therefore uninitialized memory will be accessed, and
	     * conditional jumps will be made that depend on those values.
	     * However the length of the match is limited to the lookahead, so
	     * the output of deflate is not affected by the uninitialized values.
	     */

	    if (_win[match + best_len]     !== scan_end  ||
	        _win[match + best_len - 1] !== scan_end1 ||
	        _win[match]                !== _win[scan] ||
	        _win[++match]              !== _win[scan + 1]) {
	      continue;
	    }

	    /* The check at best_len-1 can be removed because it will be made
	     * again later. (This heuristic is not always a win.)
	     * It is not necessary to compare scan[2] and match[2] since they
	     * are always equal when the other bytes match, given that
	     * the hash keys are equal and that HASH_BITS >= 8.
	     */
	    scan += 2;
	    match++;
	    // Assert(*scan == *match, "match[2]?");

	    /* We check for insufficient lookahead only every 8th comparison;
	     * the 256th check will be made at strstart+258.
	     */
	    do {
	      /*jshint noempty:false*/
	    } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
	             scan < strend);

	    // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");

	    len = MAX_MATCH - (strend - scan);
	    scan = strend - MAX_MATCH;

	    if (len > best_len) {
	      s.match_start = cur_match;
	      best_len = len;
	      if (len >= nice_match) {
	        break;
	      }
	      scan_end1  = _win[scan + best_len - 1];
	      scan_end   = _win[scan + best_len];
	    }
	  } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

	  if (best_len <= s.lookahead) {
	    return best_len;
	  }
	  return s.lookahead;
	}


	/* ===========================================================================
	 * Fill the window when the lookahead becomes insufficient.
	 * Updates strstart and lookahead.
	 *
	 * IN assertion: lookahead < MIN_LOOKAHEAD
	 * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
	 *    At least one byte has been read, or avail_in == 0; reads are
	 *    performed for at least two bytes (required for the zip translate_eol
	 *    option -- not supported here).
	 */
	function fill_window(s) {
	  var _w_size = s.w_size;
	  var p, n, m, more, str;

	  //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

	  do {
	    more = s.window_size - s.lookahead - s.strstart;

	    // JS ints have 32 bit, block below not needed
	    /* Deal with !@#$% 64K limit: */
	    //if (sizeof(int) <= 2) {
	    //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
	    //        more = wsize;
	    //
	    //  } else if (more == (unsigned)(-1)) {
	    //        /* Very unlikely, but possible on 16 bit machine if
	    //         * strstart == 0 && lookahead == 1 (input done a byte at time)
	    //         */
	    //        more--;
	    //    }
	    //}


	    /* If the window is almost full and there is insufficient lookahead,
	     * move the upper half to the lower one to make room in the upper half.
	     */
	    if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {

	      utils.arraySet(s.window, s.window, _w_size, _w_size, 0);
	      s.match_start -= _w_size;
	      s.strstart -= _w_size;
	      /* we now have strstart >= MAX_DIST */
	      s.block_start -= _w_size;

	      /* Slide the hash table (could be avoided with 32 bit values
	       at the expense of memory usage). We slide even when level == 0
	       to keep the hash table consistent if we switch back to level > 0
	       later. (Using level 0 permanently is not an optimal usage of
	       zlib, so we don't care about this pathological case.)
	       */

	      n = s.hash_size;
	      p = n;
	      do {
	        m = s.head[--p];
	        s.head[p] = (m >= _w_size ? m - _w_size : 0);
	      } while (--n);

	      n = _w_size;
	      p = n;
	      do {
	        m = s.prev[--p];
	        s.prev[p] = (m >= _w_size ? m - _w_size : 0);
	        /* If n is not on any hash chain, prev[n] is garbage but
	         * its value will never be used.
	         */
	      } while (--n);

	      more += _w_size;
	    }
	    if (s.strm.avail_in === 0) {
	      break;
	    }

	    /* If there was no sliding:
	     *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
	     *    more == window_size - lookahead - strstart
	     * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
	     * => more >= window_size - 2*WSIZE + 2
	     * In the BIG_MEM or MMAP case (not yet supported),
	     *   window_size == input_size + MIN_LOOKAHEAD  &&
	     *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
	     * Otherwise, window_size == 2*WSIZE so more >= 2.
	     * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
	     */
	    //Assert(more >= 2, "more < 2");
	    n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
	    s.lookahead += n;

	    /* Initialize the hash value now that we have some input: */
	    if (s.lookahead + s.insert >= MIN_MATCH) {
	      str = s.strstart - s.insert;
	      s.ins_h = s.window[str];

	      /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + 1]) & s.hash_mask;
	//#if MIN_MATCH != 3
	//        Call update_hash() MIN_MATCH-3 more times
	//#endif
	      while (s.insert) {
	        /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
	        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

	        s.prev[str & s.w_mask] = s.head[s.ins_h];
	        s.head[s.ins_h] = str;
	        str++;
	        s.insert--;
	        if (s.lookahead + s.insert < MIN_MATCH) {
	          break;
	        }
	      }
	    }
	    /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
	     * but this is not important since only literal bytes will be emitted.
	     */

	  } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);

	  /* If the WIN_INIT bytes after the end of the current data have never been
	   * written, then zero those bytes in order to avoid memory check reports of
	   * the use of uninitialized (or uninitialised as Julian writes) bytes by
	   * the longest match routines.  Update the high water mark for the next
	   * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
	   * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
	   */
	//  if (s.high_water < s.window_size) {
	//    var curr = s.strstart + s.lookahead;
	//    var init = 0;
	//
	//    if (s.high_water < curr) {
	//      /* Previous high water mark below current data -- zero WIN_INIT
	//       * bytes or up to end of window, whichever is less.
	//       */
	//      init = s.window_size - curr;
	//      if (init > WIN_INIT)
	//        init = WIN_INIT;
	//      zmemzero(s->window + curr, (unsigned)init);
	//      s->high_water = curr + init;
	//    }
	//    else if (s->high_water < (ulg)curr + WIN_INIT) {
	//      /* High water mark at or above current data, but below current data
	//       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
	//       * to end of window, whichever is less.
	//       */
	//      init = (ulg)curr + WIN_INIT - s->high_water;
	//      if (init > s->window_size - s->high_water)
	//        init = s->window_size - s->high_water;
	//      zmemzero(s->window + s->high_water, (unsigned)init);
	//      s->high_water += init;
	//    }
	//  }
	//
	//  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
	//    "not enough room for search");
	}

	/* ===========================================================================
	 * Copy without compression as much as possible from the input stream, return
	 * the current block state.
	 * This function does not insert new strings in the dictionary since
	 * uncompressible data is probably not useful. This function is used
	 * only for the level=0 compression option.
	 * NOTE: this function should be optimized to avoid extra copying from
	 * window to pending_buf.
	 */
	function deflate_stored(s, flush) {
	  /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
	   * to pending_buf_size, and each stored block has a 5 byte header:
	   */
	  var max_block_size = 0xffff;

	  if (max_block_size > s.pending_buf_size - 5) {
	    max_block_size = s.pending_buf_size - 5;
	  }

	  /* Copy as much as possible from input to output: */
	  for (;;) {
	    /* Fill the window as much as possible: */
	    if (s.lookahead <= 1) {

	      //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
	      //  s->block_start >= (long)s->w_size, "slide too late");
	//      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
	//        s.block_start >= s.w_size)) {
	//        throw  new Error("slide too late");
	//      }

	      fill_window(s);
	      if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }

	      if (s.lookahead === 0) {
	        break;
	      }
	      /* flush the current block */
	    }
	    //Assert(s->block_start >= 0L, "block gone");
	//    if (s.block_start < 0) throw new Error("block gone");

	    s.strstart += s.lookahead;
	    s.lookahead = 0;

	    /* Emit a stored block if pending_buf will be full: */
	    var max_start = s.block_start + max_block_size;

	    if (s.strstart === 0 || s.strstart >= max_start) {
	      /* strstart == 0 is possible when wraparound on 16-bit machine */
	      s.lookahead = s.strstart - max_start;
	      s.strstart = max_start;
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/


	    }
	    /* Flush if we may have to slide, otherwise block_start may become
	     * negative and the data will be gone:
	     */
	    if (s.strstart - s.block_start >= (s.w_size - MIN_LOOKAHEAD)) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }

	  s.insert = 0;

	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }

	  if (s.strstart > s.block_start) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }

	  return BS_NEED_MORE;
	}

	/* ===========================================================================
	 * Compress as much as possible from the input stream, return the current
	 * block state.
	 * This function does not perform lazy evaluation of matches and inserts
	 * new strings in the dictionary only for unmatched strings or for short
	 * matches. It is used only for the fast compression options.
	 */
	function deflate_fast(s, flush) {
	  var hash_head;        /* head of the hash chain */
	  var bflush;           /* set if current block must be flushed */

	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the next match, plus MIN_MATCH bytes to insert the
	     * string following the next match.
	     */
	    if (s.lookahead < MIN_LOOKAHEAD) {
	      fill_window(s);
	      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) {
	        break; /* flush the current block */
	      }
	    }

	    /* Insert the string window[strstart .. strstart+2] in the
	     * dictionary, and set hash_head to the head of the hash chain:
	     */
	    hash_head = 0/*NIL*/;
	    if (s.lookahead >= MIN_MATCH) {
	      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	      s.head[s.ins_h] = s.strstart;
	      /***/
	    }

	    /* Find the longest match, discarding those <= prev_length.
	     * At this point we have always match_length < MIN_MATCH
	     */
	    if (hash_head !== 0/*NIL*/ && ((s.strstart - hash_head) <= (s.w_size - MIN_LOOKAHEAD))) {
	      /* To simplify the code, we prevent matches with the string
	       * of window index 0 (in particular we have to avoid a match
	       * of the string with itself at the start of the input file).
	       */
	      s.match_length = longest_match(s, hash_head);
	      /* longest_match() sets match_start */
	    }
	    if (s.match_length >= MIN_MATCH) {
	      // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

	      /*** _tr_tally_dist(s, s.strstart - s.match_start,
	                     s.match_length - MIN_MATCH, bflush); ***/
	      bflush = trees._tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);

	      s.lookahead -= s.match_length;

	      /* Insert new strings in the hash table only if the match length
	       * is not too large. This saves time but degrades compression.
	       */
	      if (s.match_length <= s.max_lazy_match/*max_insert_length*/ && s.lookahead >= MIN_MATCH) {
	        s.match_length--; /* string at strstart already in table */
	        do {
	          s.strstart++;
	          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	          s.head[s.ins_h] = s.strstart;
	          /***/
	          /* strstart never exceeds WSIZE-MAX_MATCH, so there are
	           * always MIN_MATCH bytes ahead.
	           */
	        } while (--s.match_length !== 0);
	        s.strstart++;
	      } else
	      {
	        s.strstart += s.match_length;
	        s.match_length = 0;
	        s.ins_h = s.window[s.strstart];
	        /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */
	        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + 1]) & s.hash_mask;

	//#if MIN_MATCH != 3
	//                Call UPDATE_HASH() MIN_MATCH-3 more times
	//#endif
	        /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
	         * matter since it will be recomputed at next deflate call.
	         */
	      }
	    } else {
	      /* No match, output a literal byte */
	      //Tracevv((stderr,"%c", s.window[s.strstart]));
	      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

	      s.lookahead--;
	      s.strstart++;
	    }
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = ((s.strstart < (MIN_MATCH - 1)) ? s.strstart : MIN_MATCH - 1);
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* ===========================================================================
	 * Same as above, but achieves better compression. We use a lazy
	 * evaluation for matches: a match is finally adopted only if there is
	 * no better match at the next window position.
	 */
	function deflate_slow(s, flush) {
	  var hash_head;          /* head of hash chain */
	  var bflush;              /* set if current block must be flushed */

	  var max_insert;

	  /* Process the input block. */
	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the next match, plus MIN_MATCH bytes to insert the
	     * string following the next match.
	     */
	    if (s.lookahead < MIN_LOOKAHEAD) {
	      fill_window(s);
	      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) { break; } /* flush the current block */
	    }

	    /* Insert the string window[strstart .. strstart+2] in the
	     * dictionary, and set hash_head to the head of the hash chain:
	     */
	    hash_head = 0/*NIL*/;
	    if (s.lookahead >= MIN_MATCH) {
	      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	      s.head[s.ins_h] = s.strstart;
	      /***/
	    }

	    /* Find the longest match, discarding those <= prev_length.
	     */
	    s.prev_length = s.match_length;
	    s.prev_match = s.match_start;
	    s.match_length = MIN_MATCH - 1;

	    if (hash_head !== 0/*NIL*/ && s.prev_length < s.max_lazy_match &&
	        s.strstart - hash_head <= (s.w_size - MIN_LOOKAHEAD)/*MAX_DIST(s)*/) {
	      /* To simplify the code, we prevent matches with the string
	       * of window index 0 (in particular we have to avoid a match
	       * of the string with itself at the start of the input file).
	       */
	      s.match_length = longest_match(s, hash_head);
	      /* longest_match() sets match_start */

	      if (s.match_length <= 5 &&
	         (s.strategy === Z_FILTERED || (s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096/*TOO_FAR*/))) {

	        /* If prev_match is also MIN_MATCH, match_start is garbage
	         * but we will ignore the current match anyway.
	         */
	        s.match_length = MIN_MATCH - 1;
	      }
	    }
	    /* If there was a match at the previous step and the current
	     * match is not better, output the previous match:
	     */
	    if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
	      max_insert = s.strstart + s.lookahead - MIN_MATCH;
	      /* Do not insert strings in hash table beyond this. */

	      //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

	      /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
	                     s.prev_length - MIN_MATCH, bflush);***/
	      bflush = trees._tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH);
	      /* Insert in hash table all strings up to the end of the match.
	       * strstart-1 and strstart are already inserted. If there is not
	       * enough lookahead, the last two strings are not inserted in
	       * the hash table.
	       */
	      s.lookahead -= s.prev_length - 1;
	      s.prev_length -= 2;
	      do {
	        if (++s.strstart <= max_insert) {
	          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
	          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
	          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
	          s.head[s.ins_h] = s.strstart;
	          /***/
	        }
	      } while (--s.prev_length !== 0);
	      s.match_available = 0;
	      s.match_length = MIN_MATCH - 1;
	      s.strstart++;

	      if (bflush) {
	        /*** FLUSH_BLOCK(s, 0); ***/
	        flush_block_only(s, false);
	        if (s.strm.avail_out === 0) {
	          return BS_NEED_MORE;
	        }
	        /***/
	      }

	    } else if (s.match_available) {
	      /* If there was no match at the previous position, output a
	       * single literal. If there was a match but the current match
	       * is longer, truncate the previous match to a single literal.
	       */
	      //Tracevv((stderr,"%c", s->window[s->strstart-1]));
	      /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

	      if (bflush) {
	        /*** FLUSH_BLOCK_ONLY(s, 0) ***/
	        flush_block_only(s, false);
	        /***/
	      }
	      s.strstart++;
	      s.lookahead--;
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	    } else {
	      /* There is no previous match to compare with, wait for
	       * the next step to decide.
	       */
	      s.match_available = 1;
	      s.strstart++;
	      s.lookahead--;
	    }
	  }
	  //Assert (flush != Z_NO_FLUSH, "no flush?");
	  if (s.match_available) {
	    //Tracevv((stderr,"%c", s->window[s->strstart-1]));
	    /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
	    bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

	    s.match_available = 0;
	  }
	  s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }

	  return BS_BLOCK_DONE;
	}


	/* ===========================================================================
	 * For Z_RLE, simply look for runs of bytes, generate matches only of distance
	 * one.  Do not maintain a hash table.  (It will be regenerated if this run of
	 * deflate switches away from Z_RLE.)
	 */
	function deflate_rle(s, flush) {
	  var bflush;            /* set if current block must be flushed */
	  var prev;              /* byte at distance one to match */
	  var scan, strend;      /* scan goes up to strend for length of run */

	  var _win = s.window;

	  for (;;) {
	    /* Make sure that we always have enough lookahead, except
	     * at the end of the input file. We need MAX_MATCH bytes
	     * for the longest run, plus one for the unrolled loop.
	     */
	    if (s.lookahead <= MAX_MATCH) {
	      fill_window(s);
	      if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH) {
	        return BS_NEED_MORE;
	      }
	      if (s.lookahead === 0) { break; } /* flush the current block */
	    }

	    /* See how many times the previous byte repeats */
	    s.match_length = 0;
	    if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
	      scan = s.strstart - 1;
	      prev = _win[scan];
	      if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
	        strend = s.strstart + MAX_MATCH;
	        do {
	          /*jshint noempty:false*/
	        } while (prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 prev === _win[++scan] && prev === _win[++scan] &&
	                 scan < strend);
	        s.match_length = MAX_MATCH - (strend - scan);
	        if (s.match_length > s.lookahead) {
	          s.match_length = s.lookahead;
	        }
	      }
	      //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");
	    }

	    /* Emit match if have run of MIN_MATCH or longer, else emit literal */
	    if (s.match_length >= MIN_MATCH) {
	      //check_match(s, s.strstart, s.strstart - 1, s.match_length);

	      /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
	      bflush = trees._tr_tally(s, 1, s.match_length - MIN_MATCH);

	      s.lookahead -= s.match_length;
	      s.strstart += s.match_length;
	      s.match_length = 0;
	    } else {
	      /* No match, output a literal byte */
	      //Tracevv((stderr,"%c", s->window[s->strstart]));
	      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

	      s.lookahead--;
	      s.strstart++;
	    }
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = 0;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* ===========================================================================
	 * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
	 * (It will be regenerated if this run of deflate switches away from Huffman.)
	 */
	function deflate_huff(s, flush) {
	  var bflush;             /* set if current block must be flushed */

	  for (;;) {
	    /* Make sure that we have a literal to write. */
	    if (s.lookahead === 0) {
	      fill_window(s);
	      if (s.lookahead === 0) {
	        if (flush === Z_NO_FLUSH) {
	          return BS_NEED_MORE;
	        }
	        break;      /* flush the current block */
	      }
	    }

	    /* Output a literal byte */
	    s.match_length = 0;
	    //Tracevv((stderr,"%c", s->window[s->strstart]));
	    /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
	    bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
	    s.lookahead--;
	    s.strstart++;
	    if (bflush) {
	      /*** FLUSH_BLOCK(s, 0); ***/
	      flush_block_only(s, false);
	      if (s.strm.avail_out === 0) {
	        return BS_NEED_MORE;
	      }
	      /***/
	    }
	  }
	  s.insert = 0;
	  if (flush === Z_FINISH) {
	    /*** FLUSH_BLOCK(s, 1); ***/
	    flush_block_only(s, true);
	    if (s.strm.avail_out === 0) {
	      return BS_FINISH_STARTED;
	    }
	    /***/
	    return BS_FINISH_DONE;
	  }
	  if (s.last_lit) {
	    /*** FLUSH_BLOCK(s, 0); ***/
	    flush_block_only(s, false);
	    if (s.strm.avail_out === 0) {
	      return BS_NEED_MORE;
	    }
	    /***/
	  }
	  return BS_BLOCK_DONE;
	}

	/* Values for max_lazy_match, good_match and max_chain_length, depending on
	 * the desired pack level (0..9). The values given below have been tuned to
	 * exclude worst case performance for pathological files. Better values may be
	 * found for specific files.
	 */
	function Config(good_length, max_lazy, nice_length, max_chain, func) {
	  this.good_length = good_length;
	  this.max_lazy = max_lazy;
	  this.nice_length = nice_length;
	  this.max_chain = max_chain;
	  this.func = func;
	}

	var configuration_table;

	configuration_table = [
	  /*      good lazy nice chain */
	  new Config(0, 0, 0, 0, deflate_stored),          /* 0 store only */
	  new Config(4, 4, 8, 4, deflate_fast),            /* 1 max speed, no lazy matches */
	  new Config(4, 5, 16, 8, deflate_fast),           /* 2 */
	  new Config(4, 6, 32, 32, deflate_fast),          /* 3 */

	  new Config(4, 4, 16, 16, deflate_slow),          /* 4 lazy matches */
	  new Config(8, 16, 32, 32, deflate_slow),         /* 5 */
	  new Config(8, 16, 128, 128, deflate_slow),       /* 6 */
	  new Config(8, 32, 128, 256, deflate_slow),       /* 7 */
	  new Config(32, 128, 258, 1024, deflate_slow),    /* 8 */
	  new Config(32, 258, 258, 4096, deflate_slow)     /* 9 max compression */
	];


	/* ===========================================================================
	 * Initialize the "longest match" routines for a new zlib stream
	 */
	function lm_init(s) {
	  s.window_size = 2 * s.w_size;

	  /*** CLEAR_HASH(s); ***/
	  zero(s.head); // Fill with NIL (= 0);

	  /* Set the default configuration parameters:
	   */
	  s.max_lazy_match = configuration_table[s.level].max_lazy;
	  s.good_match = configuration_table[s.level].good_length;
	  s.nice_match = configuration_table[s.level].nice_length;
	  s.max_chain_length = configuration_table[s.level].max_chain;

	  s.strstart = 0;
	  s.block_start = 0;
	  s.lookahead = 0;
	  s.insert = 0;
	  s.match_length = s.prev_length = MIN_MATCH - 1;
	  s.match_available = 0;
	  s.ins_h = 0;
	}


	function DeflateState() {
	  this.strm = null;            /* pointer back to this zlib stream */
	  this.status = 0;            /* as the name implies */
	  this.pending_buf = null;      /* output still pending */
	  this.pending_buf_size = 0;  /* size of pending_buf */
	  this.pending_out = 0;       /* next pending byte to output to the stream */
	  this.pending = 0;           /* nb of bytes in the pending buffer */
	  this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip */
	  this.gzhead = null;         /* gzip header information to write */
	  this.gzindex = 0;           /* where in extra, name, or comment */
	  this.method = Z_DEFLATED; /* can only be DEFLATED */
	  this.last_flush = -1;   /* value of flush param for previous deflate call */

	  this.w_size = 0;  /* LZ77 window size (32K by default) */
	  this.w_bits = 0;  /* log2(w_size)  (8..16) */
	  this.w_mask = 0;  /* w_size - 1 */

	  this.window = null;
	  /* Sliding window. Input bytes are read into the second half of the window,
	   * and move to the first half later to keep a dictionary of at least wSize
	   * bytes. With this organization, matches are limited to a distance of
	   * wSize-MAX_MATCH bytes, but this ensures that IO is always
	   * performed with a length multiple of the block size.
	   */

	  this.window_size = 0;
	  /* Actual size of window: 2*wSize, except when the user input buffer
	   * is directly used as sliding window.
	   */

	  this.prev = null;
	  /* Link to older string with same hash index. To limit the size of this
	   * array to 64K, this link is maintained only for the last 32K strings.
	   * An index in this array is thus a window index modulo 32K.
	   */

	  this.head = null;   /* Heads of the hash chains or NIL. */

	  this.ins_h = 0;       /* hash index of string to be inserted */
	  this.hash_size = 0;   /* number of elements in hash table */
	  this.hash_bits = 0;   /* log2(hash_size) */
	  this.hash_mask = 0;   /* hash_size-1 */

	  this.hash_shift = 0;
	  /* Number of bits by which ins_h must be shifted at each input
	   * step. It must be such that after MIN_MATCH steps, the oldest
	   * byte no longer takes part in the hash key, that is:
	   *   hash_shift * MIN_MATCH >= hash_bits
	   */

	  this.block_start = 0;
	  /* Window position at the beginning of the current output block. Gets
	   * negative when the window is moved backwards.
	   */

	  this.match_length = 0;      /* length of best match */
	  this.prev_match = 0;        /* previous match */
	  this.match_available = 0;   /* set if previous match exists */
	  this.strstart = 0;          /* start of string to insert */
	  this.match_start = 0;       /* start of matching string */
	  this.lookahead = 0;         /* number of valid bytes ahead in window */

	  this.prev_length = 0;
	  /* Length of the best match at previous step. Matches not greater than this
	   * are discarded. This is used in the lazy match evaluation.
	   */

	  this.max_chain_length = 0;
	  /* To speed up deflation, hash chains are never searched beyond this
	   * length.  A higher limit improves compression ratio but degrades the
	   * speed.
	   */

	  this.max_lazy_match = 0;
	  /* Attempt to find a better match only when the current match is strictly
	   * smaller than this value. This mechanism is used only for compression
	   * levels >= 4.
	   */
	  // That's alias to max_lazy_match, don't use directly
	  //this.max_insert_length = 0;
	  /* Insert new strings in the hash table only if the match length is not
	   * greater than this length. This saves time but degrades compression.
	   * max_insert_length is used only for compression levels <= 3.
	   */

	  this.level = 0;     /* compression level (1..9) */
	  this.strategy = 0;  /* favor or force Huffman coding*/

	  this.good_match = 0;
	  /* Use a faster search when the previous match is longer than this */

	  this.nice_match = 0; /* Stop searching when current match exceeds this */

	              /* used by trees.c: */

	  /* Didn't use ct_data typedef below to suppress compiler warning */

	  // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
	  // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
	  // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */

	  // Use flat array of DOUBLE size, with interleaved fata,
	  // because JS does not support effective
	  this.dyn_ltree  = new utils.Buf16(HEAP_SIZE * 2);
	  this.dyn_dtree  = new utils.Buf16((2 * D_CODES + 1) * 2);
	  this.bl_tree    = new utils.Buf16((2 * BL_CODES + 1) * 2);
	  zero(this.dyn_ltree);
	  zero(this.dyn_dtree);
	  zero(this.bl_tree);

	  this.l_desc   = null;         /* desc. for literal tree */
	  this.d_desc   = null;         /* desc. for distance tree */
	  this.bl_desc  = null;         /* desc. for bit length tree */

	  //ush bl_count[MAX_BITS+1];
	  this.bl_count = new utils.Buf16(MAX_BITS + 1);
	  /* number of codes at each bit length for an optimal tree */

	  //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */
	  this.heap = new utils.Buf16(2 * L_CODES + 1);  /* heap used to build the Huffman trees */
	  zero(this.heap);

	  this.heap_len = 0;               /* number of elements in the heap */
	  this.heap_max = 0;               /* element of largest frequency */
	  /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
	   * The same heap array is used to build all trees.
	   */

	  this.depth = new utils.Buf16(2 * L_CODES + 1); //uch depth[2*L_CODES+1];
	  zero(this.depth);
	  /* Depth of each subtree used as tie breaker for trees of equal frequency
	   */

	  this.l_buf = 0;          /* buffer index for literals or lengths */

	  this.lit_bufsize = 0;
	  /* Size of match buffer for literals/lengths.  There are 4 reasons for
	   * limiting lit_bufsize to 64K:
	   *   - frequencies can be kept in 16 bit counters
	   *   - if compression is not successful for the first block, all input
	   *     data is still in the window so we can still emit a stored block even
	   *     when input comes from standard input.  (This can also be done for
	   *     all blocks if lit_bufsize is not greater than 32K.)
	   *   - if compression is not successful for a file smaller than 64K, we can
	   *     even emit a stored file instead of a stored block (saving 5 bytes).
	   *     This is applicable only for zip (not gzip or zlib).
	   *   - creating new Huffman trees less frequently may not provide fast
	   *     adaptation to changes in the input data statistics. (Take for
	   *     example a binary file with poorly compressible code followed by
	   *     a highly compressible string table.) Smaller buffer sizes give
	   *     fast adaptation but have of course the overhead of transmitting
	   *     trees more frequently.
	   *   - I can't count above 4
	   */

	  this.last_lit = 0;      /* running index in l_buf */

	  this.d_buf = 0;
	  /* Buffer index for distances. To simplify the code, d_buf and l_buf have
	   * the same number of elements. To use different lengths, an extra flag
	   * array would be necessary.
	   */

	  this.opt_len = 0;       /* bit length of current block with optimal trees */
	  this.static_len = 0;    /* bit length of current block with static trees */
	  this.matches = 0;       /* number of string matches in current block */
	  this.insert = 0;        /* bytes at end of window left to insert */


	  this.bi_buf = 0;
	  /* Output buffer. bits are inserted starting at the bottom (least
	   * significant bits).
	   */
	  this.bi_valid = 0;
	  /* Number of valid bits in bi_buf.  All bits above the last valid bit
	   * are always zero.
	   */

	  // Used for window memory init. We safely ignore it for JS. That makes
	  // sense only for pointers and memory check tools.
	  //this.high_water = 0;
	  /* High water mark offset in window for initialized bytes -- bytes above
	   * this are set to zero in order to avoid memory check warnings when
	   * longest match routines access bytes past the input.  This is then
	   * updated to the new high water mark.
	   */
	}


	function deflateResetKeep(strm) {
	  var s;

	  if (!strm || !strm.state) {
	    return err(strm, Z_STREAM_ERROR);
	  }

	  strm.total_in = strm.total_out = 0;
	  strm.data_type = Z_UNKNOWN;

	  s = strm.state;
	  s.pending = 0;
	  s.pending_out = 0;

	  if (s.wrap < 0) {
	    s.wrap = -s.wrap;
	    /* was made negative by deflate(..., Z_FINISH); */
	  }
	  s.status = (s.wrap ? INIT_STATE : BUSY_STATE);
	  strm.adler = (s.wrap === 2) ?
	    0  // crc32(0, Z_NULL, 0)
	  :
	    1; // adler32(0, Z_NULL, 0)
	  s.last_flush = Z_NO_FLUSH;
	  trees._tr_init(s);
	  return Z_OK;
	}


	function deflateReset(strm) {
	  var ret = deflateResetKeep(strm);
	  if (ret === Z_OK) {
	    lm_init(strm.state);
	  }
	  return ret;
	}


	function deflateSetHeader(strm, head) {
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  if (strm.state.wrap !== 2) { return Z_STREAM_ERROR; }
	  strm.state.gzhead = head;
	  return Z_OK;
	}


	function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
	  if (!strm) { // === Z_NULL
	    return Z_STREAM_ERROR;
	  }
	  var wrap = 1;

	  if (level === Z_DEFAULT_COMPRESSION) {
	    level = 6;
	  }

	  if (windowBits < 0) { /* suppress zlib wrapper */
	    wrap = 0;
	    windowBits = -windowBits;
	  }

	  else if (windowBits > 15) {
	    wrap = 2;           /* write gzip wrapper instead */
	    windowBits -= 16;
	  }


	  if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED ||
	    windowBits < 8 || windowBits > 15 || level < 0 || level > 9 ||
	    strategy < 0 || strategy > Z_FIXED) {
	    return err(strm, Z_STREAM_ERROR);
	  }


	  if (windowBits === 8) {
	    windowBits = 9;
	  }
	  /* until 256-byte window bug fixed */

	  var s = new DeflateState();

	  strm.state = s;
	  s.strm = strm;

	  s.wrap = wrap;
	  s.gzhead = null;
	  s.w_bits = windowBits;
	  s.w_size = 1 << s.w_bits;
	  s.w_mask = s.w_size - 1;

	  s.hash_bits = memLevel + 7;
	  s.hash_size = 1 << s.hash_bits;
	  s.hash_mask = s.hash_size - 1;
	  s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);

	  s.window = new utils.Buf8(s.w_size * 2);
	  s.head = new utils.Buf16(s.hash_size);
	  s.prev = new utils.Buf16(s.w_size);

	  // Don't need mem init magic for JS.
	  //s.high_water = 0;  /* nothing written to s->window yet */

	  s.lit_bufsize = 1 << (memLevel + 6); /* 16K elements by default */

	  s.pending_buf_size = s.lit_bufsize * 4;

	  //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
	  //s->pending_buf = (uchf *) overlay;
	  s.pending_buf = new utils.Buf8(s.pending_buf_size);

	  // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
	  //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);
	  s.d_buf = 1 * s.lit_bufsize;

	  //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;
	  s.l_buf = (1 + 2) * s.lit_bufsize;

	  s.level = level;
	  s.strategy = strategy;
	  s.method = method;

	  return deflateReset(strm);
	}

	function deflateInit(strm, level) {
	  return deflateInit2(strm, level, Z_DEFLATED, MAX_WBITS, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY);
	}


	function deflate(strm, flush) {
	  var old_flush, s;
	  var beg, val; // for gzip header write only

	  if (!strm || !strm.state ||
	    flush > Z_BLOCK || flush < 0) {
	    return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
	  }

	  s = strm.state;

	  if (!strm.output ||
	      (!strm.input && strm.avail_in !== 0) ||
	      (s.status === FINISH_STATE && flush !== Z_FINISH)) {
	    return err(strm, (strm.avail_out === 0) ? Z_BUF_ERROR : Z_STREAM_ERROR);
	  }

	  s.strm = strm; /* just in case */
	  old_flush = s.last_flush;
	  s.last_flush = flush;

	  /* Write the header */
	  if (s.status === INIT_STATE) {

	    if (s.wrap === 2) { // GZIP header
	      strm.adler = 0;  //crc32(0L, Z_NULL, 0);
	      put_byte(s, 31);
	      put_byte(s, 139);
	      put_byte(s, 8);
	      if (!s.gzhead) { // s->gzhead == Z_NULL
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, 0);
	        put_byte(s, s.level === 9 ? 2 :
	                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
	                     4 : 0));
	        put_byte(s, OS_CODE);
	        s.status = BUSY_STATE;
	      }
	      else {
	        put_byte(s, (s.gzhead.text ? 1 : 0) +
	                    (s.gzhead.hcrc ? 2 : 0) +
	                    (!s.gzhead.extra ? 0 : 4) +
	                    (!s.gzhead.name ? 0 : 8) +
	                    (!s.gzhead.comment ? 0 : 16)
	                );
	        put_byte(s, s.gzhead.time & 0xff);
	        put_byte(s, (s.gzhead.time >> 8) & 0xff);
	        put_byte(s, (s.gzhead.time >> 16) & 0xff);
	        put_byte(s, (s.gzhead.time >> 24) & 0xff);
	        put_byte(s, s.level === 9 ? 2 :
	                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
	                     4 : 0));
	        put_byte(s, s.gzhead.os & 0xff);
	        if (s.gzhead.extra && s.gzhead.extra.length) {
	          put_byte(s, s.gzhead.extra.length & 0xff);
	          put_byte(s, (s.gzhead.extra.length >> 8) & 0xff);
	        }
	        if (s.gzhead.hcrc) {
	          strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
	        }
	        s.gzindex = 0;
	        s.status = EXTRA_STATE;
	      }
	    }
	    else // DEFLATE header
	    {
	      var header = (Z_DEFLATED + ((s.w_bits - 8) << 4)) << 8;
	      var level_flags = -1;

	      if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
	        level_flags = 0;
	      } else if (s.level < 6) {
	        level_flags = 1;
	      } else if (s.level === 6) {
	        level_flags = 2;
	      } else {
	        level_flags = 3;
	      }
	      header |= (level_flags << 6);
	      if (s.strstart !== 0) { header |= PRESET_DICT; }
	      header += 31 - (header % 31);

	      s.status = BUSY_STATE;
	      putShortMSB(s, header);

	      /* Save the adler32 of the preset dictionary: */
	      if (s.strstart !== 0) {
	        putShortMSB(s, strm.adler >>> 16);
	        putShortMSB(s, strm.adler & 0xffff);
	      }
	      strm.adler = 1; // adler32(0L, Z_NULL, 0);
	    }
	  }

	//#ifdef GZIP
	  if (s.status === EXTRA_STATE) {
	    if (s.gzhead.extra/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */

	      while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            break;
	          }
	        }
	        put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
	        s.gzindex++;
	      }
	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (s.gzindex === s.gzhead.extra.length) {
	        s.gzindex = 0;
	        s.status = NAME_STATE;
	      }
	    }
	    else {
	      s.status = NAME_STATE;
	    }
	  }
	  if (s.status === NAME_STATE) {
	    if (s.gzhead.name/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */
	      //int val;

	      do {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            val = 1;
	            break;
	          }
	        }
	        // JS specific: little magic to add zero terminator to end of string
	        if (s.gzindex < s.gzhead.name.length) {
	          val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
	        } else {
	          val = 0;
	        }
	        put_byte(s, val);
	      } while (val !== 0);

	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (val === 0) {
	        s.gzindex = 0;
	        s.status = COMMENT_STATE;
	      }
	    }
	    else {
	      s.status = COMMENT_STATE;
	    }
	  }
	  if (s.status === COMMENT_STATE) {
	    if (s.gzhead.comment/* != Z_NULL*/) {
	      beg = s.pending;  /* start of bytes to update crc */
	      //int val;

	      do {
	        if (s.pending === s.pending_buf_size) {
	          if (s.gzhead.hcrc && s.pending > beg) {
	            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	          }
	          flush_pending(strm);
	          beg = s.pending;
	          if (s.pending === s.pending_buf_size) {
	            val = 1;
	            break;
	          }
	        }
	        // JS specific: little magic to add zero terminator to end of string
	        if (s.gzindex < s.gzhead.comment.length) {
	          val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
	        } else {
	          val = 0;
	        }
	        put_byte(s, val);
	      } while (val !== 0);

	      if (s.gzhead.hcrc && s.pending > beg) {
	        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
	      }
	      if (val === 0) {
	        s.status = HCRC_STATE;
	      }
	    }
	    else {
	      s.status = HCRC_STATE;
	    }
	  }
	  if (s.status === HCRC_STATE) {
	    if (s.gzhead.hcrc) {
	      if (s.pending + 2 > s.pending_buf_size) {
	        flush_pending(strm);
	      }
	      if (s.pending + 2 <= s.pending_buf_size) {
	        put_byte(s, strm.adler & 0xff);
	        put_byte(s, (strm.adler >> 8) & 0xff);
	        strm.adler = 0; //crc32(0L, Z_NULL, 0);
	        s.status = BUSY_STATE;
	      }
	    }
	    else {
	      s.status = BUSY_STATE;
	    }
	  }
	//#endif

	  /* Flush as much pending output as possible */
	  if (s.pending !== 0) {
	    flush_pending(strm);
	    if (strm.avail_out === 0) {
	      /* Since avail_out is 0, deflate will be called again with
	       * more output space, but possibly with both pending and
	       * avail_in equal to zero. There won't be anything to do,
	       * but this is not an error situation so make sure we
	       * return OK instead of BUF_ERROR at next call of deflate:
	       */
	      s.last_flush = -1;
	      return Z_OK;
	    }

	    /* Make sure there is something to do and avoid duplicate consecutive
	     * flushes. For repeated and useless calls with Z_FINISH, we keep
	     * returning Z_STREAM_END instead of Z_BUF_ERROR.
	     */
	  } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) &&
	    flush !== Z_FINISH) {
	    return err(strm, Z_BUF_ERROR);
	  }

	  /* User must not provide more input after the first FINISH: */
	  if (s.status === FINISH_STATE && strm.avail_in !== 0) {
	    return err(strm, Z_BUF_ERROR);
	  }

	  /* Start a new block or continue the current one.
	   */
	  if (strm.avail_in !== 0 || s.lookahead !== 0 ||
	    (flush !== Z_NO_FLUSH && s.status !== FINISH_STATE)) {
	    var bstate = (s.strategy === Z_HUFFMAN_ONLY) ? deflate_huff(s, flush) :
	      (s.strategy === Z_RLE ? deflate_rle(s, flush) :
	        configuration_table[s.level].func(s, flush));

	    if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
	      s.status = FINISH_STATE;
	    }
	    if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
	      if (strm.avail_out === 0) {
	        s.last_flush = -1;
	        /* avoid BUF_ERROR next call, see above */
	      }
	      return Z_OK;
	      /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
	       * of deflate should use the same flush parameter to make sure
	       * that the flush is complete. So we don't have to output an
	       * empty block here, this will be done at next call. This also
	       * ensures that for a very small output buffer, we emit at most
	       * one empty block.
	       */
	    }
	    if (bstate === BS_BLOCK_DONE) {
	      if (flush === Z_PARTIAL_FLUSH) {
	        trees._tr_align(s);
	      }
	      else if (flush !== Z_BLOCK) { /* FULL_FLUSH or SYNC_FLUSH */

	        trees._tr_stored_block(s, 0, 0, false);
	        /* For a full flush, this empty block will be recognized
	         * as a special marker by inflate_sync().
	         */
	        if (flush === Z_FULL_FLUSH) {
	          /*** CLEAR_HASH(s); ***/             /* forget history */
	          zero(s.head); // Fill with NIL (= 0);

	          if (s.lookahead === 0) {
	            s.strstart = 0;
	            s.block_start = 0;
	            s.insert = 0;
	          }
	        }
	      }
	      flush_pending(strm);
	      if (strm.avail_out === 0) {
	        s.last_flush = -1; /* avoid BUF_ERROR at next call, see above */
	        return Z_OK;
	      }
	    }
	  }
	  //Assert(strm->avail_out > 0, "bug2");
	  //if (strm.avail_out <= 0) { throw new Error("bug2");}

	  if (flush !== Z_FINISH) { return Z_OK; }
	  if (s.wrap <= 0) { return Z_STREAM_END; }

	  /* Write the trailer */
	  if (s.wrap === 2) {
	    put_byte(s, strm.adler & 0xff);
	    put_byte(s, (strm.adler >> 8) & 0xff);
	    put_byte(s, (strm.adler >> 16) & 0xff);
	    put_byte(s, (strm.adler >> 24) & 0xff);
	    put_byte(s, strm.total_in & 0xff);
	    put_byte(s, (strm.total_in >> 8) & 0xff);
	    put_byte(s, (strm.total_in >> 16) & 0xff);
	    put_byte(s, (strm.total_in >> 24) & 0xff);
	  }
	  else
	  {
	    putShortMSB(s, strm.adler >>> 16);
	    putShortMSB(s, strm.adler & 0xffff);
	  }

	  flush_pending(strm);
	  /* If avail_out is zero, the application will call deflate again
	   * to flush the rest.
	   */
	  if (s.wrap > 0) { s.wrap = -s.wrap; }
	  /* write the trailer only once! */
	  return s.pending !== 0 ? Z_OK : Z_STREAM_END;
	}

	function deflateEnd(strm) {
	  var status;

	  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
	    return Z_STREAM_ERROR;
	  }

	  status = strm.state.status;
	  if (status !== INIT_STATE &&
	    status !== EXTRA_STATE &&
	    status !== NAME_STATE &&
	    status !== COMMENT_STATE &&
	    status !== HCRC_STATE &&
	    status !== BUSY_STATE &&
	    status !== FINISH_STATE
	  ) {
	    return err(strm, Z_STREAM_ERROR);
	  }

	  strm.state = null;

	  return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
	}


	/* =========================================================================
	 * Initializes the compression dictionary from the given byte
	 * sequence without producing any compressed output.
	 */
	function deflateSetDictionary(strm, dictionary) {
	  var dictLength = dictionary.length;

	  var s;
	  var str, n;
	  var wrap;
	  var avail;
	  var next;
	  var input;
	  var tmpDict;

	  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
	    return Z_STREAM_ERROR;
	  }

	  s = strm.state;
	  wrap = s.wrap;

	  if (wrap === 2 || (wrap === 1 && s.status !== INIT_STATE) || s.lookahead) {
	    return Z_STREAM_ERROR;
	  }

	  /* when using zlib wrappers, compute Adler-32 for provided dictionary */
	  if (wrap === 1) {
	    /* adler32(strm->adler, dictionary, dictLength); */
	    strm.adler = adler32(strm.adler, dictionary, dictLength, 0);
	  }

	  s.wrap = 0;   /* avoid computing Adler-32 in read_buf */

	  /* if dictionary would fill window, just replace the history */
	  if (dictLength >= s.w_size) {
	    if (wrap === 0) {            /* already empty otherwise */
	      /*** CLEAR_HASH(s); ***/
	      zero(s.head); // Fill with NIL (= 0);
	      s.strstart = 0;
	      s.block_start = 0;
	      s.insert = 0;
	    }
	    /* use the tail */
	    // dictionary = dictionary.slice(dictLength - s.w_size);
	    tmpDict = new utils.Buf8(s.w_size);
	    utils.arraySet(tmpDict, dictionary, dictLength - s.w_size, s.w_size, 0);
	    dictionary = tmpDict;
	    dictLength = s.w_size;
	  }
	  /* insert dictionary into window and hash */
	  avail = strm.avail_in;
	  next = strm.next_in;
	  input = strm.input;
	  strm.avail_in = dictLength;
	  strm.next_in = 0;
	  strm.input = dictionary;
	  fill_window(s);
	  while (s.lookahead >= MIN_MATCH) {
	    str = s.strstart;
	    n = s.lookahead - (MIN_MATCH - 1);
	    do {
	      /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
	      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

	      s.prev[str & s.w_mask] = s.head[s.ins_h];

	      s.head[s.ins_h] = str;
	      str++;
	    } while (--n);
	    s.strstart = str;
	    s.lookahead = MIN_MATCH - 1;
	    fill_window(s);
	  }
	  s.strstart += s.lookahead;
	  s.block_start = s.strstart;
	  s.insert = s.lookahead;
	  s.lookahead = 0;
	  s.match_length = s.prev_length = MIN_MATCH - 1;
	  s.match_available = 0;
	  strm.next_in = next;
	  strm.input = input;
	  strm.avail_in = avail;
	  s.wrap = wrap;
	  return Z_OK;
	}


	exports.deflateInit = deflateInit;
	exports.deflateInit2 = deflateInit2;
	exports.deflateReset = deflateReset;
	exports.deflateResetKeep = deflateResetKeep;
	exports.deflateSetHeader = deflateSetHeader;
	exports.deflate = deflate;
	exports.deflateEnd = deflateEnd;
	exports.deflateSetDictionary = deflateSetDictionary;
	exports.deflateInfo = 'pako deflate (from Nodeca project)';

	/* Not implemented
	exports.deflateBound = deflateBound;
	exports.deflateCopy = deflateCopy;
	exports.deflateParams = deflateParams;
	exports.deflatePending = deflatePending;
	exports.deflatePrime = deflatePrime;
	exports.deflateTune = deflateTune;
	*/

	},{"../utils/common":182,"./adler32":184,"./crc32":186,"./messages":192,"./trees":193}],188:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	function GZheader() {
	  /* true if compressed data believed to be text */
	  this.text       = 0;
	  /* modification time */
	  this.time       = 0;
	  /* extra flags (not used when writing a gzip file) */
	  this.xflags     = 0;
	  /* operating system */
	  this.os         = 0;
	  /* pointer to extra field or Z_NULL if none */
	  this.extra      = null;
	  /* extra field length (valid if extra != Z_NULL) */
	  this.extra_len  = 0; // Actually, we don't need it in JS,
	                       // but leave for few code modifications

	  //
	  // Setup limits is not necessary because in js we should not preallocate memory
	  // for inflate use constant limit in 65536 bytes
	  //

	  /* space at extra (only when reading header) */
	  // this.extra_max  = 0;
	  /* pointer to zero-terminated file name or Z_NULL */
	  this.name       = '';
	  /* space at name (only when reading header) */
	  // this.name_max   = 0;
	  /* pointer to zero-terminated comment or Z_NULL */
	  this.comment    = '';
	  /* space at comment (only when reading header) */
	  // this.comm_max   = 0;
	  /* true if there was or will be a header crc */
	  this.hcrc       = 0;
	  /* true when done reading gzip header (not used when writing a gzip file) */
	  this.done       = false;
	}

	module.exports = GZheader;

	},{}],189:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	// See state defs from inflate.js
	var BAD = 30;       /* got a data error -- remain here until reset */
	var TYPE = 12;      /* i: waiting for type bits, including last-flag bit */

	/*
	   Decode literal, length, and distance codes and write out the resulting
	   literal and match bytes until either not enough input or output is
	   available, an end-of-block is encountered, or a data error is encountered.
	   When large enough input and output buffers are supplied to inflate(), for
	   example, a 16K input buffer and a 64K output buffer, more than 95% of the
	   inflate execution time is spent in this routine.

	   Entry assumptions:

	        state.mode === LEN
	        strm.avail_in >= 6
	        strm.avail_out >= 258
	        start >= strm.avail_out
	        state.bits < 8

	   On return, state.mode is one of:

	        LEN -- ran out of enough output space or enough available input
	        TYPE -- reached end of block code, inflate() to interpret next block
	        BAD -- error in block data

	   Notes:

	    - The maximum input bits used by a length/distance pair is 15 bits for the
	      length code, 5 bits for the length extra, 15 bits for the distance code,
	      and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
	      Therefore if strm.avail_in >= 6, then there is enough input to avoid
	      checking for available input while decoding.

	    - The maximum bytes that a single length/distance pair can output is 258
	      bytes, which is the maximum length that can be coded.  inflate_fast()
	      requires strm.avail_out >= 258 for each loop to avoid checking for
	      output space.
	 */
	module.exports = function inflate_fast(strm, start) {
	  var state;
	  var _in;                    /* local strm.input */
	  var last;                   /* have enough input while in < last */
	  var _out;                   /* local strm.output */
	  var beg;                    /* inflate()'s initial strm.output */
	  var end;                    /* while out < end, enough space available */
	//#ifdef INFLATE_STRICT
	  var dmax;                   /* maximum distance from zlib header */
	//#endif
	  var wsize;                  /* window size or zero if not using window */
	  var whave;                  /* valid bytes in the window */
	  var wnext;                  /* window write index */
	  // Use `s_window` instead `window`, avoid conflict with instrumentation tools
	  var s_window;               /* allocated sliding window, if wsize != 0 */
	  var hold;                   /* local strm.hold */
	  var bits;                   /* local strm.bits */
	  var lcode;                  /* local strm.lencode */
	  var dcode;                  /* local strm.distcode */
	  var lmask;                  /* mask for first level of length codes */
	  var dmask;                  /* mask for first level of distance codes */
	  var here;                   /* retrieved table entry */
	  var op;                     /* code bits, operation, extra bits, or */
	                              /*  window position, window bytes to copy */
	  var len;                    /* match length, unused bytes */
	  var dist;                   /* match distance */
	  var from;                   /* where to copy match from */
	  var from_source;


	  var input, output; // JS specific, because we have no pointers

	  /* copy state to local variables */
	  state = strm.state;
	  //here = state.here;
	  _in = strm.next_in;
	  input = strm.input;
	  last = _in + (strm.avail_in - 5);
	  _out = strm.next_out;
	  output = strm.output;
	  beg = _out - (start - strm.avail_out);
	  end = _out + (strm.avail_out - 257);
	//#ifdef INFLATE_STRICT
	  dmax = state.dmax;
	//#endif
	  wsize = state.wsize;
	  whave = state.whave;
	  wnext = state.wnext;
	  s_window = state.window;
	  hold = state.hold;
	  bits = state.bits;
	  lcode = state.lencode;
	  dcode = state.distcode;
	  lmask = (1 << state.lenbits) - 1;
	  dmask = (1 << state.distbits) - 1;


	  /* decode literals and length/distances until end-of-block or not enough
	     input data or output space */

	  top:
	  do {
	    if (bits < 15) {
	      hold += input[_in++] << bits;
	      bits += 8;
	      hold += input[_in++] << bits;
	      bits += 8;
	    }

	    here = lcode[hold & lmask];

	    dolen:
	    for (;;) { // Goto emulation
	      op = here >>> 24/*here.bits*/;
	      hold >>>= op;
	      bits -= op;
	      op = (here >>> 16) & 0xff/*here.op*/;
	      if (op === 0) {                          /* literal */
	        //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
	        //        "inflate:         literal '%c'\n" :
	        //        "inflate:         literal 0x%02x\n", here.val));
	        output[_out++] = here & 0xffff/*here.val*/;
	      }
	      else if (op & 16) {                     /* length base */
	        len = here & 0xffff/*here.val*/;
	        op &= 15;                           /* number of extra bits */
	        if (op) {
	          if (bits < op) {
	            hold += input[_in++] << bits;
	            bits += 8;
	          }
	          len += hold & ((1 << op) - 1);
	          hold >>>= op;
	          bits -= op;
	        }
	        //Tracevv((stderr, "inflate:         length %u\n", len));
	        if (bits < 15) {
	          hold += input[_in++] << bits;
	          bits += 8;
	          hold += input[_in++] << bits;
	          bits += 8;
	        }
	        here = dcode[hold & dmask];

	        dodist:
	        for (;;) { // goto emulation
	          op = here >>> 24/*here.bits*/;
	          hold >>>= op;
	          bits -= op;
	          op = (here >>> 16) & 0xff/*here.op*/;

	          if (op & 16) {                      /* distance base */
	            dist = here & 0xffff/*here.val*/;
	            op &= 15;                       /* number of extra bits */
	            if (bits < op) {
	              hold += input[_in++] << bits;
	              bits += 8;
	              if (bits < op) {
	                hold += input[_in++] << bits;
	                bits += 8;
	              }
	            }
	            dist += hold & ((1 << op) - 1);
	//#ifdef INFLATE_STRICT
	            if (dist > dmax) {
	              strm.msg = 'invalid distance too far back';
	              state.mode = BAD;
	              break top;
	            }
	//#endif
	            hold >>>= op;
	            bits -= op;
	            //Tracevv((stderr, "inflate:         distance %u\n", dist));
	            op = _out - beg;                /* max distance in output */
	            if (dist > op) {                /* see if copy from window */
	              op = dist - op;               /* distance back in window */
	              if (op > whave) {
	                if (state.sane) {
	                  strm.msg = 'invalid distance too far back';
	                  state.mode = BAD;
	                  break top;
	                }

	// (!) This block is disabled in zlib defaults,
	// don't enable it for binary compatibility
	//#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
	//                if (len <= op - whave) {
	//                  do {
	//                    output[_out++] = 0;
	//                  } while (--len);
	//                  continue top;
	//                }
	//                len -= op - whave;
	//                do {
	//                  output[_out++] = 0;
	//                } while (--op > whave);
	//                if (op === 0) {
	//                  from = _out - dist;
	//                  do {
	//                    output[_out++] = output[from++];
	//                  } while (--len);
	//                  continue top;
	//                }
	//#endif
	              }
	              from = 0; // window index
	              from_source = s_window;
	              if (wnext === 0) {           /* very common case */
	                from += wsize - op;
	                if (op < len) {         /* some from window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = _out - dist;  /* rest from output */
	                  from_source = output;
	                }
	              }
	              else if (wnext < op) {      /* wrap around window */
	                from += wsize + wnext - op;
	                op -= wnext;
	                if (op < len) {         /* some from end of window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = 0;
	                  if (wnext < len) {  /* some from start of window */
	                    op = wnext;
	                    len -= op;
	                    do {
	                      output[_out++] = s_window[from++];
	                    } while (--op);
	                    from = _out - dist;      /* rest from output */
	                    from_source = output;
	                  }
	                }
	              }
	              else {                      /* contiguous in window */
	                from += wnext - op;
	                if (op < len) {         /* some from window */
	                  len -= op;
	                  do {
	                    output[_out++] = s_window[from++];
	                  } while (--op);
	                  from = _out - dist;  /* rest from output */
	                  from_source = output;
	                }
	              }
	              while (len > 2) {
	                output[_out++] = from_source[from++];
	                output[_out++] = from_source[from++];
	                output[_out++] = from_source[from++];
	                len -= 3;
	              }
	              if (len) {
	                output[_out++] = from_source[from++];
	                if (len > 1) {
	                  output[_out++] = from_source[from++];
	                }
	              }
	            }
	            else {
	              from = _out - dist;          /* copy direct from output */
	              do {                        /* minimum length is three */
	                output[_out++] = output[from++];
	                output[_out++] = output[from++];
	                output[_out++] = output[from++];
	                len -= 3;
	              } while (len > 2);
	              if (len) {
	                output[_out++] = output[from++];
	                if (len > 1) {
	                  output[_out++] = output[from++];
	                }
	              }
	            }
	          }
	          else if ((op & 64) === 0) {          /* 2nd level distance code */
	            here = dcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
	            continue dodist;
	          }
	          else {
	            strm.msg = 'invalid distance code';
	            state.mode = BAD;
	            break top;
	          }

	          break; // need to emulate goto via "continue"
	        }
	      }
	      else if ((op & 64) === 0) {              /* 2nd level length code */
	        here = lcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
	        continue dolen;
	      }
	      else if (op & 32) {                     /* end-of-block */
	        //Tracevv((stderr, "inflate:         end of block\n"));
	        state.mode = TYPE;
	        break top;
	      }
	      else {
	        strm.msg = 'invalid literal/length code';
	        state.mode = BAD;
	        break top;
	      }

	      break; // need to emulate goto via "continue"
	    }
	  } while (_in < last && _out < end);

	  /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
	  len = bits >> 3;
	  _in -= len;
	  bits -= len << 3;
	  hold &= (1 << bits) - 1;

	  /* update state and return */
	  strm.next_in = _in;
	  strm.next_out = _out;
	  strm.avail_in = (_in < last ? 5 + (last - _in) : 5 - (_in - last));
	  strm.avail_out = (_out < end ? 257 + (end - _out) : 257 - (_out - end));
	  state.hold = hold;
	  state.bits = bits;
	  return;
	};

	},{}],190:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	var utils         = require('../utils/common');
	var adler32       = require('./adler32');
	var crc32         = require('./crc32');
	var inflate_fast  = require('./inffast');
	var inflate_table = require('./inftrees');

	var CODES = 0;
	var LENS = 1;
	var DISTS = 2;

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	/* Allowed flush values; see deflate() and inflate() below for details */
	//var Z_NO_FLUSH      = 0;
	//var Z_PARTIAL_FLUSH = 1;
	//var Z_SYNC_FLUSH    = 2;
	//var Z_FULL_FLUSH    = 3;
	var Z_FINISH        = 4;
	var Z_BLOCK         = 5;
	var Z_TREES         = 6;


	/* Return codes for the compression/decompression functions. Negative values
	 * are errors, positive values are used for special but normal events.
	 */
	var Z_OK            = 0;
	var Z_STREAM_END    = 1;
	var Z_NEED_DICT     = 2;
	//var Z_ERRNO         = -1;
	var Z_STREAM_ERROR  = -2;
	var Z_DATA_ERROR    = -3;
	var Z_MEM_ERROR     = -4;
	var Z_BUF_ERROR     = -5;
	//var Z_VERSION_ERROR = -6;

	/* The deflate compression method */
	var Z_DEFLATED  = 8;


	/* STATES ====================================================================*/
	/* ===========================================================================*/


	var    HEAD = 1;       /* i: waiting for magic header */
	var    FLAGS = 2;      /* i: waiting for method and flags (gzip) */
	var    TIME = 3;       /* i: waiting for modification time (gzip) */
	var    OS = 4;         /* i: waiting for extra flags and operating system (gzip) */
	var    EXLEN = 5;      /* i: waiting for extra length (gzip) */
	var    EXTRA = 6;      /* i: waiting for extra bytes (gzip) */
	var    NAME = 7;       /* i: waiting for end of file name (gzip) */
	var    COMMENT = 8;    /* i: waiting for end of comment (gzip) */
	var    HCRC = 9;       /* i: waiting for header crc (gzip) */
	var    DICTID = 10;    /* i: waiting for dictionary check value */
	var    DICT = 11;      /* waiting for inflateSetDictionary() call */
	var        TYPE = 12;      /* i: waiting for type bits, including last-flag bit */
	var        TYPEDO = 13;    /* i: same, but skip check to exit inflate on new block */
	var        STORED = 14;    /* i: waiting for stored size (length and complement) */
	var        COPY_ = 15;     /* i/o: same as COPY below, but only first time in */
	var        COPY = 16;      /* i/o: waiting for input or output to copy stored block */
	var        TABLE = 17;     /* i: waiting for dynamic block table lengths */
	var        LENLENS = 18;   /* i: waiting for code length code lengths */
	var        CODELENS = 19;  /* i: waiting for length/lit and distance code lengths */
	var            LEN_ = 20;      /* i: same as LEN below, but only first time in */
	var            LEN = 21;       /* i: waiting for length/lit/eob code */
	var            LENEXT = 22;    /* i: waiting for length extra bits */
	var            DIST = 23;      /* i: waiting for distance code */
	var            DISTEXT = 24;   /* i: waiting for distance extra bits */
	var            MATCH = 25;     /* o: waiting for output space to copy string */
	var            LIT = 26;       /* o: waiting for output space to write literal */
	var    CHECK = 27;     /* i: waiting for 32-bit check value */
	var    LENGTH = 28;    /* i: waiting for 32-bit length (gzip) */
	var    DONE = 29;      /* finished check, done -- remain here until reset */
	var    BAD = 30;       /* got a data error -- remain here until reset */
	var    MEM = 31;       /* got an inflate() memory error -- remain here until reset */
	var    SYNC = 32;      /* looking for synchronization bytes to restart inflate() */

	/* ===========================================================================*/



	var ENOUGH_LENS = 852;
	var ENOUGH_DISTS = 592;
	//var ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

	var MAX_WBITS = 15;
	/* 32K LZ77 window */
	var DEF_WBITS = MAX_WBITS;


	function zswap32(q) {
	  return  (((q >>> 24) & 0xff) +
	          ((q >>> 8) & 0xff00) +
	          ((q & 0xff00) << 8) +
	          ((q & 0xff) << 24));
	}


	function InflateState() {
	  this.mode = 0;             /* current inflate mode */
	  this.last = false;          /* true if processing last block */
	  this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip */
	  this.havedict = false;      /* true if dictionary provided */
	  this.flags = 0;             /* gzip header method and flags (0 if zlib) */
	  this.dmax = 0;              /* zlib header max distance (INFLATE_STRICT) */
	  this.check = 0;             /* protected copy of check value */
	  this.total = 0;             /* protected copy of output count */
	  // TODO: may be {}
	  this.head = null;           /* where to save gzip header information */

	  /* sliding window */
	  this.wbits = 0;             /* log base 2 of requested window size */
	  this.wsize = 0;             /* window size or zero if not using window */
	  this.whave = 0;             /* valid bytes in the window */
	  this.wnext = 0;             /* window write index */
	  this.window = null;         /* allocated sliding window, if needed */

	  /* bit accumulator */
	  this.hold = 0;              /* input bit accumulator */
	  this.bits = 0;              /* number of bits in "in" */

	  /* for string and stored block copying */
	  this.length = 0;            /* literal or length of data to copy */
	  this.offset = 0;            /* distance back to copy string from */

	  /* for table and code decoding */
	  this.extra = 0;             /* extra bits needed */

	  /* fixed and dynamic code tables */
	  this.lencode = null;          /* starting table for length/literal codes */
	  this.distcode = null;         /* starting table for distance codes */
	  this.lenbits = 0;           /* index bits for lencode */
	  this.distbits = 0;          /* index bits for distcode */

	  /* dynamic table building */
	  this.ncode = 0;             /* number of code length code lengths */
	  this.nlen = 0;              /* number of length code lengths */
	  this.ndist = 0;             /* number of distance code lengths */
	  this.have = 0;              /* number of code lengths in lens[] */
	  this.next = null;              /* next available space in codes[] */

	  this.lens = new utils.Buf16(320); /* temporary storage for code lengths */
	  this.work = new utils.Buf16(288); /* work area for code table building */

	  /*
	   because we don't have pointers in js, we use lencode and distcode directly
	   as buffers so we don't need codes
	  */
	  //this.codes = new utils.Buf32(ENOUGH);       /* space for code tables */
	  this.lendyn = null;              /* dynamic table for length/literal codes (JS specific) */
	  this.distdyn = null;             /* dynamic table for distance codes (JS specific) */
	  this.sane = 0;                   /* if false, allow invalid distance too far */
	  this.back = 0;                   /* bits back of last unprocessed length/lit */
	  this.was = 0;                    /* initial length of match */
	}

	function inflateResetKeep(strm) {
	  var state;

	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  strm.total_in = strm.total_out = state.total = 0;
	  strm.msg = ''; /*Z_NULL*/
	  if (state.wrap) {       /* to support ill-conceived Java test suite */
	    strm.adler = state.wrap & 1;
	  }
	  state.mode = HEAD;
	  state.last = 0;
	  state.havedict = 0;
	  state.dmax = 32768;
	  state.head = null/*Z_NULL*/;
	  state.hold = 0;
	  state.bits = 0;
	  //state.lencode = state.distcode = state.next = state.codes;
	  state.lencode = state.lendyn = new utils.Buf32(ENOUGH_LENS);
	  state.distcode = state.distdyn = new utils.Buf32(ENOUGH_DISTS);

	  state.sane = 1;
	  state.back = -1;
	  //Tracev((stderr, "inflate: reset\n"));
	  return Z_OK;
	}

	function inflateReset(strm) {
	  var state;

	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  state.wsize = 0;
	  state.whave = 0;
	  state.wnext = 0;
	  return inflateResetKeep(strm);

	}

	function inflateReset2(strm, windowBits) {
	  var wrap;
	  var state;

	  /* get the state */
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;

	  /* extract wrap request from windowBits parameter */
	  if (windowBits < 0) {
	    wrap = 0;
	    windowBits = -windowBits;
	  }
	  else {
	    wrap = (windowBits >> 4) + 1;
	    if (windowBits < 48) {
	      windowBits &= 15;
	    }
	  }

	  /* set number of window bits, free window if different */
	  if (windowBits && (windowBits < 8 || windowBits > 15)) {
	    return Z_STREAM_ERROR;
	  }
	  if (state.window !== null && state.wbits !== windowBits) {
	    state.window = null;
	  }

	  /* update state and reset the rest of it */
	  state.wrap = wrap;
	  state.wbits = windowBits;
	  return inflateReset(strm);
	}

	function inflateInit2(strm, windowBits) {
	  var ret;
	  var state;

	  if (!strm) { return Z_STREAM_ERROR; }
	  //strm.msg = Z_NULL;                 /* in case we return an error */

	  state = new InflateState();

	  //if (state === Z_NULL) return Z_MEM_ERROR;
	  //Tracev((stderr, "inflate: allocated\n"));
	  strm.state = state;
	  state.window = null/*Z_NULL*/;
	  ret = inflateReset2(strm, windowBits);
	  if (ret !== Z_OK) {
	    strm.state = null/*Z_NULL*/;
	  }
	  return ret;
	}

	function inflateInit(strm) {
	  return inflateInit2(strm, DEF_WBITS);
	}


	/*
	 Return state with length and distance decoding tables and index sizes set to
	 fixed code decoding.  Normally this returns fixed tables from inffixed.h.
	 If BUILDFIXED is defined, then instead this routine builds the tables the
	 first time it's called, and returns those tables the first time and
	 thereafter.  This reduces the size of the code by about 2K bytes, in
	 exchange for a little execution time.  However, BUILDFIXED should not be
	 used for threaded applications, since the rewriting of the tables and virgin
	 may not be thread-safe.
	 */
	var virgin = true;

	var lenfix, distfix; // We have no pointers in JS, so keep tables separate

	function fixedtables(state) {
	  /* build fixed huffman tables if first call (may not be thread safe) */
	  if (virgin) {
	    var sym;

	    lenfix = new utils.Buf32(512);
	    distfix = new utils.Buf32(32);

	    /* literal/length table */
	    sym = 0;
	    while (sym < 144) { state.lens[sym++] = 8; }
	    while (sym < 256) { state.lens[sym++] = 9; }
	    while (sym < 280) { state.lens[sym++] = 7; }
	    while (sym < 288) { state.lens[sym++] = 8; }

	    inflate_table(LENS,  state.lens, 0, 288, lenfix,   0, state.work, { bits: 9 });

	    /* distance table */
	    sym = 0;
	    while (sym < 32) { state.lens[sym++] = 5; }

	    inflate_table(DISTS, state.lens, 0, 32,   distfix, 0, state.work, { bits: 5 });

	    /* do this just once */
	    virgin = false;
	  }

	  state.lencode = lenfix;
	  state.lenbits = 9;
	  state.distcode = distfix;
	  state.distbits = 5;
	}


	/*
	 Update the window with the last wsize (normally 32K) bytes written before
	 returning.  If window does not exist yet, create it.  This is only called
	 when a window is already in use, or when output has been written during this
	 inflate call, but the end of the deflate stream has not been reached yet.
	 It is also called to create a window for dictionary data when a dictionary
	 is loaded.

	 Providing output buffers larger than 32K to inflate() should provide a speed
	 advantage, since only the last 32K of output is copied to the sliding window
	 upon return from inflate(), and since all distances after the first 32K of
	 output will fall in the output data, making match copies simpler and faster.
	 The advantage may be dependent on the size of the processor's data caches.
	 */
	function updatewindow(strm, src, end, copy) {
	  var dist;
	  var state = strm.state;

	  /* if it hasn't been done already, allocate space for the window */
	  if (state.window === null) {
	    state.wsize = 1 << state.wbits;
	    state.wnext = 0;
	    state.whave = 0;

	    state.window = new utils.Buf8(state.wsize);
	  }

	  /* copy state->wsize or less output bytes into the circular window */
	  if (copy >= state.wsize) {
	    utils.arraySet(state.window, src, end - state.wsize, state.wsize, 0);
	    state.wnext = 0;
	    state.whave = state.wsize;
	  }
	  else {
	    dist = state.wsize - state.wnext;
	    if (dist > copy) {
	      dist = copy;
	    }
	    //zmemcpy(state->window + state->wnext, end - copy, dist);
	    utils.arraySet(state.window, src, end - copy, dist, state.wnext);
	    copy -= dist;
	    if (copy) {
	      //zmemcpy(state->window, end - copy, copy);
	      utils.arraySet(state.window, src, end - copy, copy, 0);
	      state.wnext = copy;
	      state.whave = state.wsize;
	    }
	    else {
	      state.wnext += dist;
	      if (state.wnext === state.wsize) { state.wnext = 0; }
	      if (state.whave < state.wsize) { state.whave += dist; }
	    }
	  }
	  return 0;
	}

	function inflate(strm, flush) {
	  var state;
	  var input, output;          // input/output buffers
	  var next;                   /* next input INDEX */
	  var put;                    /* next output INDEX */
	  var have, left;             /* available input and output */
	  var hold;                   /* bit buffer */
	  var bits;                   /* bits in bit buffer */
	  var _in, _out;              /* save starting available input and output */
	  var copy;                   /* number of stored or match bytes to copy */
	  var from;                   /* where to copy match bytes from */
	  var from_source;
	  var here = 0;               /* current decoding table entry */
	  var here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
	  //var last;                   /* parent table entry */
	  var last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
	  var len;                    /* length to copy for repeats, bits to drop */
	  var ret;                    /* return code */
	  var hbuf = new utils.Buf8(4);    /* buffer for gzip header crc calculation */
	  var opts;

	  var n; // temporary var for NEED_BITS

	  var order = /* permutation of code lengths */
	    [ 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15 ];


	  if (!strm || !strm.state || !strm.output ||
	      (!strm.input && strm.avail_in !== 0)) {
	    return Z_STREAM_ERROR;
	  }

	  state = strm.state;
	  if (state.mode === TYPE) { state.mode = TYPEDO; }    /* skip check */


	  //--- LOAD() ---
	  put = strm.next_out;
	  output = strm.output;
	  left = strm.avail_out;
	  next = strm.next_in;
	  input = strm.input;
	  have = strm.avail_in;
	  hold = state.hold;
	  bits = state.bits;
	  //---

	  _in = have;
	  _out = left;
	  ret = Z_OK;

	  inf_leave: // goto emulation
	  for (;;) {
	    switch (state.mode) {
	      case HEAD:
	        if (state.wrap === 0) {
	          state.mode = TYPEDO;
	          break;
	        }
	        //=== NEEDBITS(16);
	        while (bits < 16) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if ((state.wrap & 2) && hold === 0x8b1f) {  /* gzip header */
	          state.check = 0/*crc32(0L, Z_NULL, 0)*/;
	          //=== CRC2(state.check, hold);
	          hbuf[0] = hold & 0xff;
	          hbuf[1] = (hold >>> 8) & 0xff;
	          state.check = crc32(state.check, hbuf, 2, 0);
	          //===//

	          //=== INITBITS();
	          hold = 0;
	          bits = 0;
	          //===//
	          state.mode = FLAGS;
	          break;
	        }
	        state.flags = 0;           /* expect zlib header */
	        if (state.head) {
	          state.head.done = false;
	        }
	        if (!(state.wrap & 1) ||   /* check if zlib header allowed */
	          (((hold & 0xff)/*BITS(8)*/ << 8) + (hold >> 8)) % 31) {
	          strm.msg = 'incorrect header check';
	          state.mode = BAD;
	          break;
	        }
	        if ((hold & 0x0f)/*BITS(4)*/ !== Z_DEFLATED) {
	          strm.msg = 'unknown compression method';
	          state.mode = BAD;
	          break;
	        }
	        //--- DROPBITS(4) ---//
	        hold >>>= 4;
	        bits -= 4;
	        //---//
	        len = (hold & 0x0f)/*BITS(4)*/ + 8;
	        if (state.wbits === 0) {
	          state.wbits = len;
	        }
	        else if (len > state.wbits) {
	          strm.msg = 'invalid window size';
	          state.mode = BAD;
	          break;
	        }
	        state.dmax = 1 << len;
	        //Tracev((stderr, "inflate:   zlib header ok\n"));
	        strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
	        state.mode = hold & 0x200 ? DICTID : TYPE;
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        break;
	      case FLAGS:
	        //=== NEEDBITS(16); */
	        while (bits < 16) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.flags = hold;
	        if ((state.flags & 0xff) !== Z_DEFLATED) {
	          strm.msg = 'unknown compression method';
	          state.mode = BAD;
	          break;
	        }
	        if (state.flags & 0xe000) {
	          strm.msg = 'unknown header flags set';
	          state.mode = BAD;
	          break;
	        }
	        if (state.head) {
	          state.head.text = ((hold >> 8) & 1);
	        }
	        if (state.flags & 0x0200) {
	          //=== CRC2(state.check, hold);
	          hbuf[0] = hold & 0xff;
	          hbuf[1] = (hold >>> 8) & 0xff;
	          state.check = crc32(state.check, hbuf, 2, 0);
	          //===//
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = TIME;
	        /* falls through */
	      case TIME:
	        //=== NEEDBITS(32); */
	        while (bits < 32) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if (state.head) {
	          state.head.time = hold;
	        }
	        if (state.flags & 0x0200) {
	          //=== CRC4(state.check, hold)
	          hbuf[0] = hold & 0xff;
	          hbuf[1] = (hold >>> 8) & 0xff;
	          hbuf[2] = (hold >>> 16) & 0xff;
	          hbuf[3] = (hold >>> 24) & 0xff;
	          state.check = crc32(state.check, hbuf, 4, 0);
	          //===
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = OS;
	        /* falls through */
	      case OS:
	        //=== NEEDBITS(16); */
	        while (bits < 16) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if (state.head) {
	          state.head.xflags = (hold & 0xff);
	          state.head.os = (hold >> 8);
	        }
	        if (state.flags & 0x0200) {
	          //=== CRC2(state.check, hold);
	          hbuf[0] = hold & 0xff;
	          hbuf[1] = (hold >>> 8) & 0xff;
	          state.check = crc32(state.check, hbuf, 2, 0);
	          //===//
	        }
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = EXLEN;
	        /* falls through */
	      case EXLEN:
	        if (state.flags & 0x0400) {
	          //=== NEEDBITS(16); */
	          while (bits < 16) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          state.length = hold;
	          if (state.head) {
	            state.head.extra_len = hold;
	          }
	          if (state.flags & 0x0200) {
	            //=== CRC2(state.check, hold);
	            hbuf[0] = hold & 0xff;
	            hbuf[1] = (hold >>> 8) & 0xff;
	            state.check = crc32(state.check, hbuf, 2, 0);
	            //===//
	          }
	          //=== INITBITS();
	          hold = 0;
	          bits = 0;
	          //===//
	        }
	        else if (state.head) {
	          state.head.extra = null/*Z_NULL*/;
	        }
	        state.mode = EXTRA;
	        /* falls through */
	      case EXTRA:
	        if (state.flags & 0x0400) {
	          copy = state.length;
	          if (copy > have) { copy = have; }
	          if (copy) {
	            if (state.head) {
	              len = state.head.extra_len - state.length;
	              if (!state.head.extra) {
	                // Use untyped array for more convenient processing later
	                state.head.extra = new Array(state.head.extra_len);
	              }
	              utils.arraySet(
	                state.head.extra,
	                input,
	                next,
	                // extra field is limited to 65536 bytes
	                // - no need for additional size check
	                copy,
	                /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
	                len
	              );
	              //zmemcpy(state.head.extra + len, next,
	              //        len + copy > state.head.extra_max ?
	              //        state.head.extra_max - len : copy);
	            }
	            if (state.flags & 0x0200) {
	              state.check = crc32(state.check, input, copy, next);
	            }
	            have -= copy;
	            next += copy;
	            state.length -= copy;
	          }
	          if (state.length) { break inf_leave; }
	        }
	        state.length = 0;
	        state.mode = NAME;
	        /* falls through */
	      case NAME:
	        if (state.flags & 0x0800) {
	          if (have === 0) { break inf_leave; }
	          copy = 0;
	          do {
	            // TODO: 2 or 1 bytes?
	            len = input[next + copy++];
	            /* use constant limit because in js we should not preallocate memory */
	            if (state.head && len &&
	                (state.length < 65536 /*state.head.name_max*/)) {
	              state.head.name += String.fromCharCode(len);
	            }
	          } while (len && copy < have);

	          if (state.flags & 0x0200) {
	            state.check = crc32(state.check, input, copy, next);
	          }
	          have -= copy;
	          next += copy;
	          if (len) { break inf_leave; }
	        }
	        else if (state.head) {
	          state.head.name = null;
	        }
	        state.length = 0;
	        state.mode = COMMENT;
	        /* falls through */
	      case COMMENT:
	        if (state.flags & 0x1000) {
	          if (have === 0) { break inf_leave; }
	          copy = 0;
	          do {
	            len = input[next + copy++];
	            /* use constant limit because in js we should not preallocate memory */
	            if (state.head && len &&
	                (state.length < 65536 /*state.head.comm_max*/)) {
	              state.head.comment += String.fromCharCode(len);
	            }
	          } while (len && copy < have);
	          if (state.flags & 0x0200) {
	            state.check = crc32(state.check, input, copy, next);
	          }
	          have -= copy;
	          next += copy;
	          if (len) { break inf_leave; }
	        }
	        else if (state.head) {
	          state.head.comment = null;
	        }
	        state.mode = HCRC;
	        /* falls through */
	      case HCRC:
	        if (state.flags & 0x0200) {
	          //=== NEEDBITS(16); */
	          while (bits < 16) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          if (hold !== (state.check & 0xffff)) {
	            strm.msg = 'header crc mismatch';
	            state.mode = BAD;
	            break;
	          }
	          //=== INITBITS();
	          hold = 0;
	          bits = 0;
	          //===//
	        }
	        if (state.head) {
	          state.head.hcrc = ((state.flags >> 9) & 1);
	          state.head.done = true;
	        }
	        strm.adler = state.check = 0;
	        state.mode = TYPE;
	        break;
	      case DICTID:
	        //=== NEEDBITS(32); */
	        while (bits < 32) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        strm.adler = state.check = zswap32(hold);
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = DICT;
	        /* falls through */
	      case DICT:
	        if (state.havedict === 0) {
	          //--- RESTORE() ---
	          strm.next_out = put;
	          strm.avail_out = left;
	          strm.next_in = next;
	          strm.avail_in = have;
	          state.hold = hold;
	          state.bits = bits;
	          //---
	          return Z_NEED_DICT;
	        }
	        strm.adler = state.check = 1/*adler32(0L, Z_NULL, 0)*/;
	        state.mode = TYPE;
	        /* falls through */
	      case TYPE:
	        if (flush === Z_BLOCK || flush === Z_TREES) { break inf_leave; }
	        /* falls through */
	      case TYPEDO:
	        if (state.last) {
	          //--- BYTEBITS() ---//
	          hold >>>= bits & 7;
	          bits -= bits & 7;
	          //---//
	          state.mode = CHECK;
	          break;
	        }
	        //=== NEEDBITS(3); */
	        while (bits < 3) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.last = (hold & 0x01)/*BITS(1)*/;
	        //--- DROPBITS(1) ---//
	        hold >>>= 1;
	        bits -= 1;
	        //---//

	        switch ((hold & 0x03)/*BITS(2)*/) {
	          case 0:                             /* stored block */
	            //Tracev((stderr, "inflate:     stored block%s\n",
	            //        state.last ? " (last)" : ""));
	            state.mode = STORED;
	            break;
	          case 1:                             /* fixed block */
	            fixedtables(state);
	            //Tracev((stderr, "inflate:     fixed codes block%s\n",
	            //        state.last ? " (last)" : ""));
	            state.mode = LEN_;             /* decode codes */
	            if (flush === Z_TREES) {
	              //--- DROPBITS(2) ---//
	              hold >>>= 2;
	              bits -= 2;
	              //---//
	              break inf_leave;
	            }
	            break;
	          case 2:                             /* dynamic block */
	            //Tracev((stderr, "inflate:     dynamic codes block%s\n",
	            //        state.last ? " (last)" : ""));
	            state.mode = TABLE;
	            break;
	          case 3:
	            strm.msg = 'invalid block type';
	            state.mode = BAD;
	        }
	        //--- DROPBITS(2) ---//
	        hold >>>= 2;
	        bits -= 2;
	        //---//
	        break;
	      case STORED:
	        //--- BYTEBITS() ---// /* go to byte boundary */
	        hold >>>= bits & 7;
	        bits -= bits & 7;
	        //---//
	        //=== NEEDBITS(32); */
	        while (bits < 32) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        if ((hold & 0xffff) !== ((hold >>> 16) ^ 0xffff)) {
	          strm.msg = 'invalid stored block lengths';
	          state.mode = BAD;
	          break;
	        }
	        state.length = hold & 0xffff;
	        //Tracev((stderr, "inflate:       stored length %u\n",
	        //        state.length));
	        //=== INITBITS();
	        hold = 0;
	        bits = 0;
	        //===//
	        state.mode = COPY_;
	        if (flush === Z_TREES) { break inf_leave; }
	        /* falls through */
	      case COPY_:
	        state.mode = COPY;
	        /* falls through */
	      case COPY:
	        copy = state.length;
	        if (copy) {
	          if (copy > have) { copy = have; }
	          if (copy > left) { copy = left; }
	          if (copy === 0) { break inf_leave; }
	          //--- zmemcpy(put, next, copy); ---
	          utils.arraySet(output, input, next, copy, put);
	          //---//
	          have -= copy;
	          next += copy;
	          left -= copy;
	          put += copy;
	          state.length -= copy;
	          break;
	        }
	        //Tracev((stderr, "inflate:       stored end\n"));
	        state.mode = TYPE;
	        break;
	      case TABLE:
	        //=== NEEDBITS(14); */
	        while (bits < 14) {
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	        }
	        //===//
	        state.nlen = (hold & 0x1f)/*BITS(5)*/ + 257;
	        //--- DROPBITS(5) ---//
	        hold >>>= 5;
	        bits -= 5;
	        //---//
	        state.ndist = (hold & 0x1f)/*BITS(5)*/ + 1;
	        //--- DROPBITS(5) ---//
	        hold >>>= 5;
	        bits -= 5;
	        //---//
	        state.ncode = (hold & 0x0f)/*BITS(4)*/ + 4;
	        //--- DROPBITS(4) ---//
	        hold >>>= 4;
	        bits -= 4;
	        //---//
	//#ifndef PKZIP_BUG_WORKAROUND
	        if (state.nlen > 286 || state.ndist > 30) {
	          strm.msg = 'too many length or distance symbols';
	          state.mode = BAD;
	          break;
	        }
	//#endif
	        //Tracev((stderr, "inflate:       table sizes ok\n"));
	        state.have = 0;
	        state.mode = LENLENS;
	        /* falls through */
	      case LENLENS:
	        while (state.have < state.ncode) {
	          //=== NEEDBITS(3);
	          while (bits < 3) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          state.lens[order[state.have++]] = (hold & 0x07);//BITS(3);
	          //--- DROPBITS(3) ---//
	          hold >>>= 3;
	          bits -= 3;
	          //---//
	        }
	        while (state.have < 19) {
	          state.lens[order[state.have++]] = 0;
	        }
	        // We have separate tables & no pointers. 2 commented lines below not needed.
	        //state.next = state.codes;
	        //state.lencode = state.next;
	        // Switch to use dynamic table
	        state.lencode = state.lendyn;
	        state.lenbits = 7;

	        opts = { bits: state.lenbits };
	        ret = inflate_table(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
	        state.lenbits = opts.bits;

	        if (ret) {
	          strm.msg = 'invalid code lengths set';
	          state.mode = BAD;
	          break;
	        }
	        //Tracev((stderr, "inflate:       code lengths ok\n"));
	        state.have = 0;
	        state.mode = CODELENS;
	        /* falls through */
	      case CODELENS:
	        while (state.have < state.nlen + state.ndist) {
	          for (;;) {
	            here = state.lencode[hold & ((1 << state.lenbits) - 1)];/*BITS(state.lenbits)*/
	            here_bits = here >>> 24;
	            here_op = (here >>> 16) & 0xff;
	            here_val = here & 0xffff;

	            if ((here_bits) <= bits) { break; }
	            //--- PULLBYTE() ---//
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	            //---//
	          }
	          if (here_val < 16) {
	            //--- DROPBITS(here.bits) ---//
	            hold >>>= here_bits;
	            bits -= here_bits;
	            //---//
	            state.lens[state.have++] = here_val;
	          }
	          else {
	            if (here_val === 16) {
	              //=== NEEDBITS(here.bits + 2);
	              n = here_bits + 2;
	              while (bits < n) {
	                if (have === 0) { break inf_leave; }
	                have--;
	                hold += input[next++] << bits;
	                bits += 8;
	              }
	              //===//
	              //--- DROPBITS(here.bits) ---//
	              hold >>>= here_bits;
	              bits -= here_bits;
	              //---//
	              if (state.have === 0) {
	                strm.msg = 'invalid bit length repeat';
	                state.mode = BAD;
	                break;
	              }
	              len = state.lens[state.have - 1];
	              copy = 3 + (hold & 0x03);//BITS(2);
	              //--- DROPBITS(2) ---//
	              hold >>>= 2;
	              bits -= 2;
	              //---//
	            }
	            else if (here_val === 17) {
	              //=== NEEDBITS(here.bits + 3);
	              n = here_bits + 3;
	              while (bits < n) {
	                if (have === 0) { break inf_leave; }
	                have--;
	                hold += input[next++] << bits;
	                bits += 8;
	              }
	              //===//
	              //--- DROPBITS(here.bits) ---//
	              hold >>>= here_bits;
	              bits -= here_bits;
	              //---//
	              len = 0;
	              copy = 3 + (hold & 0x07);//BITS(3);
	              //--- DROPBITS(3) ---//
	              hold >>>= 3;
	              bits -= 3;
	              //---//
	            }
	            else {
	              //=== NEEDBITS(here.bits + 7);
	              n = here_bits + 7;
	              while (bits < n) {
	                if (have === 0) { break inf_leave; }
	                have--;
	                hold += input[next++] << bits;
	                bits += 8;
	              }
	              //===//
	              //--- DROPBITS(here.bits) ---//
	              hold >>>= here_bits;
	              bits -= here_bits;
	              //---//
	              len = 0;
	              copy = 11 + (hold & 0x7f);//BITS(7);
	              //--- DROPBITS(7) ---//
	              hold >>>= 7;
	              bits -= 7;
	              //---//
	            }
	            if (state.have + copy > state.nlen + state.ndist) {
	              strm.msg = 'invalid bit length repeat';
	              state.mode = BAD;
	              break;
	            }
	            while (copy--) {
	              state.lens[state.have++] = len;
	            }
	          }
	        }

	        /* handle error breaks in while */
	        if (state.mode === BAD) { break; }

	        /* check for end-of-block code (better have one) */
	        if (state.lens[256] === 0) {
	          strm.msg = 'invalid code -- missing end-of-block';
	          state.mode = BAD;
	          break;
	        }

	        /* build code tables -- note: do not change the lenbits or distbits
	           values here (9 and 6) without reading the comments in inftrees.h
	           concerning the ENOUGH constants, which depend on those values */
	        state.lenbits = 9;

	        opts = { bits: state.lenbits };
	        ret = inflate_table(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
	        // We have separate tables & no pointers. 2 commented lines below not needed.
	        // state.next_index = opts.table_index;
	        state.lenbits = opts.bits;
	        // state.lencode = state.next;

	        if (ret) {
	          strm.msg = 'invalid literal/lengths set';
	          state.mode = BAD;
	          break;
	        }

	        state.distbits = 6;
	        //state.distcode.copy(state.codes);
	        // Switch to use dynamic table
	        state.distcode = state.distdyn;
	        opts = { bits: state.distbits };
	        ret = inflate_table(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
	        // We have separate tables & no pointers. 2 commented lines below not needed.
	        // state.next_index = opts.table_index;
	        state.distbits = opts.bits;
	        // state.distcode = state.next;

	        if (ret) {
	          strm.msg = 'invalid distances set';
	          state.mode = BAD;
	          break;
	        }
	        //Tracev((stderr, 'inflate:       codes ok\n'));
	        state.mode = LEN_;
	        if (flush === Z_TREES) { break inf_leave; }
	        /* falls through */
	      case LEN_:
	        state.mode = LEN;
	        /* falls through */
	      case LEN:
	        if (have >= 6 && left >= 258) {
	          //--- RESTORE() ---
	          strm.next_out = put;
	          strm.avail_out = left;
	          strm.next_in = next;
	          strm.avail_in = have;
	          state.hold = hold;
	          state.bits = bits;
	          //---
	          inflate_fast(strm, _out);
	          //--- LOAD() ---
	          put = strm.next_out;
	          output = strm.output;
	          left = strm.avail_out;
	          next = strm.next_in;
	          input = strm.input;
	          have = strm.avail_in;
	          hold = state.hold;
	          bits = state.bits;
	          //---

	          if (state.mode === TYPE) {
	            state.back = -1;
	          }
	          break;
	        }
	        state.back = 0;
	        for (;;) {
	          here = state.lencode[hold & ((1 << state.lenbits) - 1)];  /*BITS(state.lenbits)*/
	          here_bits = here >>> 24;
	          here_op = (here >>> 16) & 0xff;
	          here_val = here & 0xffff;

	          if (here_bits <= bits) { break; }
	          //--- PULLBYTE() ---//
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	          //---//
	        }
	        if (here_op && (here_op & 0xf0) === 0) {
	          last_bits = here_bits;
	          last_op = here_op;
	          last_val = here_val;
	          for (;;) {
	            here = state.lencode[last_val +
	                    ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
	            here_bits = here >>> 24;
	            here_op = (here >>> 16) & 0xff;
	            here_val = here & 0xffff;

	            if ((last_bits + here_bits) <= bits) { break; }
	            //--- PULLBYTE() ---//
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	            //---//
	          }
	          //--- DROPBITS(last.bits) ---//
	          hold >>>= last_bits;
	          bits -= last_bits;
	          //---//
	          state.back += last_bits;
	        }
	        //--- DROPBITS(here.bits) ---//
	        hold >>>= here_bits;
	        bits -= here_bits;
	        //---//
	        state.back += here_bits;
	        state.length = here_val;
	        if (here_op === 0) {
	          //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
	          //        "inflate:         literal '%c'\n" :
	          //        "inflate:         literal 0x%02x\n", here.val));
	          state.mode = LIT;
	          break;
	        }
	        if (here_op & 32) {
	          //Tracevv((stderr, "inflate:         end of block\n"));
	          state.back = -1;
	          state.mode = TYPE;
	          break;
	        }
	        if (here_op & 64) {
	          strm.msg = 'invalid literal/length code';
	          state.mode = BAD;
	          break;
	        }
	        state.extra = here_op & 15;
	        state.mode = LENEXT;
	        /* falls through */
	      case LENEXT:
	        if (state.extra) {
	          //=== NEEDBITS(state.extra);
	          n = state.extra;
	          while (bits < n) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          state.length += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
	          //--- DROPBITS(state.extra) ---//
	          hold >>>= state.extra;
	          bits -= state.extra;
	          //---//
	          state.back += state.extra;
	        }
	        //Tracevv((stderr, "inflate:         length %u\n", state.length));
	        state.was = state.length;
	        state.mode = DIST;
	        /* falls through */
	      case DIST:
	        for (;;) {
	          here = state.distcode[hold & ((1 << state.distbits) - 1)];/*BITS(state.distbits)*/
	          here_bits = here >>> 24;
	          here_op = (here >>> 16) & 0xff;
	          here_val = here & 0xffff;

	          if ((here_bits) <= bits) { break; }
	          //--- PULLBYTE() ---//
	          if (have === 0) { break inf_leave; }
	          have--;
	          hold += input[next++] << bits;
	          bits += 8;
	          //---//
	        }
	        if ((here_op & 0xf0) === 0) {
	          last_bits = here_bits;
	          last_op = here_op;
	          last_val = here_val;
	          for (;;) {
	            here = state.distcode[last_val +
	                    ((hold & ((1 << (last_bits + last_op)) - 1))/*BITS(last.bits + last.op)*/ >> last_bits)];
	            here_bits = here >>> 24;
	            here_op = (here >>> 16) & 0xff;
	            here_val = here & 0xffff;

	            if ((last_bits + here_bits) <= bits) { break; }
	            //--- PULLBYTE() ---//
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	            //---//
	          }
	          //--- DROPBITS(last.bits) ---//
	          hold >>>= last_bits;
	          bits -= last_bits;
	          //---//
	          state.back += last_bits;
	        }
	        //--- DROPBITS(here.bits) ---//
	        hold >>>= here_bits;
	        bits -= here_bits;
	        //---//
	        state.back += here_bits;
	        if (here_op & 64) {
	          strm.msg = 'invalid distance code';
	          state.mode = BAD;
	          break;
	        }
	        state.offset = here_val;
	        state.extra = (here_op) & 15;
	        state.mode = DISTEXT;
	        /* falls through */
	      case DISTEXT:
	        if (state.extra) {
	          //=== NEEDBITS(state.extra);
	          n = state.extra;
	          while (bits < n) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          state.offset += hold & ((1 << state.extra) - 1)/*BITS(state.extra)*/;
	          //--- DROPBITS(state.extra) ---//
	          hold >>>= state.extra;
	          bits -= state.extra;
	          //---//
	          state.back += state.extra;
	        }
	//#ifdef INFLATE_STRICT
	        if (state.offset > state.dmax) {
	          strm.msg = 'invalid distance too far back';
	          state.mode = BAD;
	          break;
	        }
	//#endif
	        //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
	        state.mode = MATCH;
	        /* falls through */
	      case MATCH:
	        if (left === 0) { break inf_leave; }
	        copy = _out - left;
	        if (state.offset > copy) {         /* copy from window */
	          copy = state.offset - copy;
	          if (copy > state.whave) {
	            if (state.sane) {
	              strm.msg = 'invalid distance too far back';
	              state.mode = BAD;
	              break;
	            }
	// (!) This block is disabled in zlib defaults,
	// don't enable it for binary compatibility
	//#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
	//          Trace((stderr, "inflate.c too far\n"));
	//          copy -= state.whave;
	//          if (copy > state.length) { copy = state.length; }
	//          if (copy > left) { copy = left; }
	//          left -= copy;
	//          state.length -= copy;
	//          do {
	//            output[put++] = 0;
	//          } while (--copy);
	//          if (state.length === 0) { state.mode = LEN; }
	//          break;
	//#endif
	          }
	          if (copy > state.wnext) {
	            copy -= state.wnext;
	            from = state.wsize - copy;
	          }
	          else {
	            from = state.wnext - copy;
	          }
	          if (copy > state.length) { copy = state.length; }
	          from_source = state.window;
	        }
	        else {                              /* copy from output */
	          from_source = output;
	          from = put - state.offset;
	          copy = state.length;
	        }
	        if (copy > left) { copy = left; }
	        left -= copy;
	        state.length -= copy;
	        do {
	          output[put++] = from_source[from++];
	        } while (--copy);
	        if (state.length === 0) { state.mode = LEN; }
	        break;
	      case LIT:
	        if (left === 0) { break inf_leave; }
	        output[put++] = state.length;
	        left--;
	        state.mode = LEN;
	        break;
	      case CHECK:
	        if (state.wrap) {
	          //=== NEEDBITS(32);
	          while (bits < 32) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            // Use '|' instead of '+' to make sure that result is signed
	            hold |= input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          _out -= left;
	          strm.total_out += _out;
	          state.total += _out;
	          if (_out) {
	            strm.adler = state.check =
	                /*UPDATE(state.check, put - _out, _out);*/
	                (state.flags ? crc32(state.check, output, _out, put - _out) : adler32(state.check, output, _out, put - _out));

	          }
	          _out = left;
	          // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
	          if ((state.flags ? hold : zswap32(hold)) !== state.check) {
	            strm.msg = 'incorrect data check';
	            state.mode = BAD;
	            break;
	          }
	          //=== INITBITS();
	          hold = 0;
	          bits = 0;
	          //===//
	          //Tracev((stderr, "inflate:   check matches trailer\n"));
	        }
	        state.mode = LENGTH;
	        /* falls through */
	      case LENGTH:
	        if (state.wrap && state.flags) {
	          //=== NEEDBITS(32);
	          while (bits < 32) {
	            if (have === 0) { break inf_leave; }
	            have--;
	            hold += input[next++] << bits;
	            bits += 8;
	          }
	          //===//
	          if (hold !== (state.total & 0xffffffff)) {
	            strm.msg = 'incorrect length check';
	            state.mode = BAD;
	            break;
	          }
	          //=== INITBITS();
	          hold = 0;
	          bits = 0;
	          //===//
	          //Tracev((stderr, "inflate:   length matches trailer\n"));
	        }
	        state.mode = DONE;
	        /* falls through */
	      case DONE:
	        ret = Z_STREAM_END;
	        break inf_leave;
	      case BAD:
	        ret = Z_DATA_ERROR;
	        break inf_leave;
	      case MEM:
	        return Z_MEM_ERROR;
	      case SYNC:
	        /* falls through */
	      default:
	        return Z_STREAM_ERROR;
	    }
	  }

	  // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

	  /*
	     Return from inflate(), updating the total counts and the check value.
	     If there was no progress during the inflate() call, return a buffer
	     error.  Call updatewindow() to create and/or update the window state.
	     Note: a memory error from inflate() is non-recoverable.
	   */

	  //--- RESTORE() ---
	  strm.next_out = put;
	  strm.avail_out = left;
	  strm.next_in = next;
	  strm.avail_in = have;
	  state.hold = hold;
	  state.bits = bits;
	  //---

	  if (state.wsize || (_out !== strm.avail_out && state.mode < BAD &&
	                      (state.mode < CHECK || flush !== Z_FINISH))) {
	    if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) ;
	  }
	  _in -= strm.avail_in;
	  _out -= strm.avail_out;
	  strm.total_in += _in;
	  strm.total_out += _out;
	  state.total += _out;
	  if (state.wrap && _out) {
	    strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/
	      (state.flags ? crc32(state.check, output, _out, strm.next_out - _out) : adler32(state.check, output, _out, strm.next_out - _out));
	  }
	  strm.data_type = state.bits + (state.last ? 64 : 0) +
	                    (state.mode === TYPE ? 128 : 0) +
	                    (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
	  if (((_in === 0 && _out === 0) || flush === Z_FINISH) && ret === Z_OK) {
	    ret = Z_BUF_ERROR;
	  }
	  return ret;
	}

	function inflateEnd(strm) {

	  if (!strm || !strm.state /*|| strm->zfree == (free_func)0*/) {
	    return Z_STREAM_ERROR;
	  }

	  var state = strm.state;
	  if (state.window) {
	    state.window = null;
	  }
	  strm.state = null;
	  return Z_OK;
	}

	function inflateGetHeader(strm, head) {
	  var state;

	  /* check state */
	  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
	  state = strm.state;
	  if ((state.wrap & 2) === 0) { return Z_STREAM_ERROR; }

	  /* save header structure */
	  state.head = head;
	  head.done = false;
	  return Z_OK;
	}

	function inflateSetDictionary(strm, dictionary) {
	  var dictLength = dictionary.length;

	  var state;
	  var dictid;
	  var ret;

	  /* check state */
	  if (!strm /* == Z_NULL */ || !strm.state /* == Z_NULL */) { return Z_STREAM_ERROR; }
	  state = strm.state;

	  if (state.wrap !== 0 && state.mode !== DICT) {
	    return Z_STREAM_ERROR;
	  }

	  /* check for correct dictionary identifier */
	  if (state.mode === DICT) {
	    dictid = 1; /* adler32(0, null, 0)*/
	    /* dictid = adler32(dictid, dictionary, dictLength); */
	    dictid = adler32(dictid, dictionary, dictLength, 0);
	    if (dictid !== state.check) {
	      return Z_DATA_ERROR;
	    }
	  }
	  /* copy dictionary to window using updatewindow(), which will amend the
	   existing dictionary if appropriate */
	  ret = updatewindow(strm, dictionary, dictLength, dictLength);
	  if (ret) {
	    state.mode = MEM;
	    return Z_MEM_ERROR;
	  }
	  state.havedict = 1;
	  // Tracev((stderr, "inflate:   dictionary set\n"));
	  return Z_OK;
	}

	exports.inflateReset = inflateReset;
	exports.inflateReset2 = inflateReset2;
	exports.inflateResetKeep = inflateResetKeep;
	exports.inflateInit = inflateInit;
	exports.inflateInit2 = inflateInit2;
	exports.inflate = inflate;
	exports.inflateEnd = inflateEnd;
	exports.inflateGetHeader = inflateGetHeader;
	exports.inflateSetDictionary = inflateSetDictionary;
	exports.inflateInfo = 'pako inflate (from Nodeca project)';

	/* Not implemented
	exports.inflateCopy = inflateCopy;
	exports.inflateGetDictionary = inflateGetDictionary;
	exports.inflateMark = inflateMark;
	exports.inflatePrime = inflatePrime;
	exports.inflateSync = inflateSync;
	exports.inflateSyncPoint = inflateSyncPoint;
	exports.inflateUndermine = inflateUndermine;
	*/

	},{"../utils/common":182,"./adler32":184,"./crc32":186,"./inffast":189,"./inftrees":191}],191:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	var utils = require('../utils/common');

	var MAXBITS = 15;
	var ENOUGH_LENS = 852;
	var ENOUGH_DISTS = 592;
	//var ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

	var CODES = 0;
	var LENS = 1;
	var DISTS = 2;

	var lbase = [ /* Length codes 257..285 base */
	  3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
	  35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
	];

	var lext = [ /* Length codes 257..285 extra */
	  16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
	  19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78
	];

	var dbase = [ /* Distance codes 0..29 base */
	  1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
	  257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
	  8193, 12289, 16385, 24577, 0, 0
	];

	var dext = [ /* Distance codes 0..29 extra */
	  16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
	  23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
	  28, 28, 29, 29, 64, 64
	];

	module.exports = function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts)
	{
	  var bits = opts.bits;
	      //here = opts.here; /* table entry for duplication */

	  var len = 0;               /* a code's length in bits */
	  var sym = 0;               /* index of code symbols */
	  var min = 0, max = 0;          /* minimum and maximum code lengths */
	  var root = 0;              /* number of index bits for root table */
	  var curr = 0;              /* number of index bits for current table */
	  var drop = 0;              /* code bits to drop for sub-table */
	  var left = 0;                   /* number of prefix codes available */
	  var used = 0;              /* code entries in table used */
	  var huff = 0;              /* Huffman code */
	  var incr;              /* for incrementing code, index */
	  var fill;              /* index for replicating entries */
	  var low;               /* low bits for current root entry */
	  var mask;              /* mask for low root bits */
	  var next;             /* next available space in table */
	  var base = null;     /* base value table to use */
	  var base_index = 0;
	//  var shoextra;    /* extra bits table to use */
	  var end;                    /* use base and extra for symbol > end */
	  var count = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
	  var offs = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
	  var extra = null;
	  var extra_index = 0;

	  var here_bits, here_op, here_val;

	  /*
	   Process a set of code lengths to create a canonical Huffman code.  The
	   code lengths are lens[0..codes-1].  Each length corresponds to the
	   symbols 0..codes-1.  The Huffman code is generated by first sorting the
	   symbols by length from short to long, and retaining the symbol order
	   for codes with equal lengths.  Then the code starts with all zero bits
	   for the first code of the shortest length, and the codes are integer
	   increments for the same length, and zeros are appended as the length
	   increases.  For the deflate format, these bits are stored backwards
	   from their more natural integer increment ordering, and so when the
	   decoding tables are built in the large loop below, the integer codes
	   are incremented backwards.

	   This routine assumes, but does not check, that all of the entries in
	   lens[] are in the range 0..MAXBITS.  The caller must assure this.
	   1..MAXBITS is interpreted as that code length.  zero means that that
	   symbol does not occur in this code.

	   The codes are sorted by computing a count of codes for each length,
	   creating from that a table of starting indices for each length in the
	   sorted table, and then entering the symbols in order in the sorted
	   table.  The sorted table is work[], with that space being provided by
	   the caller.

	   The length counts are used for other purposes as well, i.e. finding
	   the minimum and maximum length codes, determining if there are any
	   codes at all, checking for a valid set of lengths, and looking ahead
	   at length counts to determine sub-table sizes when building the
	   decoding tables.
	   */

	  /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
	  for (len = 0; len <= MAXBITS; len++) {
	    count[len] = 0;
	  }
	  for (sym = 0; sym < codes; sym++) {
	    count[lens[lens_index + sym]]++;
	  }

	  /* bound code lengths, force root to be within code lengths */
	  root = bits;
	  for (max = MAXBITS; max >= 1; max--) {
	    if (count[max] !== 0) { break; }
	  }
	  if (root > max) {
	    root = max;
	  }
	  if (max === 0) {                     /* no symbols to code at all */
	    //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
	    //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
	    //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
	    table[table_index++] = (1 << 24) | (64 << 16) | 0;


	    //table.op[opts.table_index] = 64;
	    //table.bits[opts.table_index] = 1;
	    //table.val[opts.table_index++] = 0;
	    table[table_index++] = (1 << 24) | (64 << 16) | 0;

	    opts.bits = 1;
	    return 0;     /* no symbols, but wait for decoding to report error */
	  }
	  for (min = 1; min < max; min++) {
	    if (count[min] !== 0) { break; }
	  }
	  if (root < min) {
	    root = min;
	  }

	  /* check for an over-subscribed or incomplete set of lengths */
	  left = 1;
	  for (len = 1; len <= MAXBITS; len++) {
	    left <<= 1;
	    left -= count[len];
	    if (left < 0) {
	      return -1;
	    }        /* over-subscribed */
	  }
	  if (left > 0 && (type === CODES || max !== 1)) {
	    return -1;                      /* incomplete set */
	  }

	  /* generate offsets into symbol table for each length for sorting */
	  offs[1] = 0;
	  for (len = 1; len < MAXBITS; len++) {
	    offs[len + 1] = offs[len] + count[len];
	  }

	  /* sort symbols by length, by symbol order within each length */
	  for (sym = 0; sym < codes; sym++) {
	    if (lens[lens_index + sym] !== 0) {
	      work[offs[lens[lens_index + sym]]++] = sym;
	    }
	  }

	  /*
	   Create and fill in decoding tables.  In this loop, the table being
	   filled is at next and has curr index bits.  The code being used is huff
	   with length len.  That code is converted to an index by dropping drop
	   bits off of the bottom.  For codes where len is less than drop + curr,
	   those top drop + curr - len bits are incremented through all values to
	   fill the table with replicated entries.

	   root is the number of index bits for the root table.  When len exceeds
	   root, sub-tables are created pointed to by the root entry with an index
	   of the low root bits of huff.  This is saved in low to check for when a
	   new sub-table should be started.  drop is zero when the root table is
	   being filled, and drop is root when sub-tables are being filled.

	   When a new sub-table is needed, it is necessary to look ahead in the
	   code lengths to determine what size sub-table is needed.  The length
	   counts are used for this, and so count[] is decremented as codes are
	   entered in the tables.

	   used keeps track of how many table entries have been allocated from the
	   provided *table space.  It is checked for LENS and DIST tables against
	   the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
	   the initial root table size constants.  See the comments in inftrees.h
	   for more information.

	   sym increments through all symbols, and the loop terminates when
	   all codes of length max, i.e. all codes, have been processed.  This
	   routine permits incomplete codes, so another loop after this one fills
	   in the rest of the decoding tables with invalid code markers.
	   */

	  /* set up for code type */
	  // poor man optimization - use if-else instead of switch,
	  // to avoid deopts in old v8
	  if (type === CODES) {
	    base = extra = work;    /* dummy value--not used */
	    end = 19;

	  } else if (type === LENS) {
	    base = lbase;
	    base_index -= 257;
	    extra = lext;
	    extra_index -= 257;
	    end = 256;

	  } else {                    /* DISTS */
	    base = dbase;
	    extra = dext;
	    end = -1;
	  }

	  /* initialize opts for loop */
	  huff = 0;                   /* starting code */
	  sym = 0;                    /* starting code symbol */
	  len = min;                  /* starting code length */
	  next = table_index;              /* current table to fill in */
	  curr = root;                /* current table index bits */
	  drop = 0;                   /* current bits to drop from code for index */
	  low = -1;                   /* trigger new sub-table when len > root */
	  used = 1 << root;          /* use root table entries */
	  mask = used - 1;            /* mask for comparing low */

	  /* check available table space */
	  if ((type === LENS && used > ENOUGH_LENS) ||
	    (type === DISTS && used > ENOUGH_DISTS)) {
	    return 1;
	  }

	  /* process all codes and make table entries */
	  for (;;) {
	    /* create table entry */
	    here_bits = len - drop;
	    if (work[sym] < end) {
	      here_op = 0;
	      here_val = work[sym];
	    }
	    else if (work[sym] > end) {
	      here_op = extra[extra_index + work[sym]];
	      here_val = base[base_index + work[sym]];
	    }
	    else {
	      here_op = 32 + 64;         /* end of block */
	      here_val = 0;
	    }

	    /* replicate for those indices with low len bits equal to huff */
	    incr = 1 << (len - drop);
	    fill = 1 << curr;
	    min = fill;                 /* save offset to next table */
	    do {
	      fill -= incr;
	      table[next + (huff >> drop) + fill] = (here_bits << 24) | (here_op << 16) | here_val |0;
	    } while (fill !== 0);

	    /* backwards increment the len-bit code huff */
	    incr = 1 << (len - 1);
	    while (huff & incr) {
	      incr >>= 1;
	    }
	    if (incr !== 0) {
	      huff &= incr - 1;
	      huff += incr;
	    } else {
	      huff = 0;
	    }

	    /* go to next symbol, update count, len */
	    sym++;
	    if (--count[len] === 0) {
	      if (len === max) { break; }
	      len = lens[lens_index + work[sym]];
	    }

	    /* create new sub-table if needed */
	    if (len > root && (huff & mask) !== low) {
	      /* if first time, transition to sub-tables */
	      if (drop === 0) {
	        drop = root;
	      }

	      /* increment past last table */
	      next += min;            /* here min is 1 << curr */

	      /* determine length of next table */
	      curr = len - drop;
	      left = 1 << curr;
	      while (curr + drop < max) {
	        left -= count[curr + drop];
	        if (left <= 0) { break; }
	        curr++;
	        left <<= 1;
	      }

	      /* check for enough space */
	      used += 1 << curr;
	      if ((type === LENS && used > ENOUGH_LENS) ||
	        (type === DISTS && used > ENOUGH_DISTS)) {
	        return 1;
	      }

	      /* point entry in root table to sub-table */
	      low = huff & mask;
	      /*table.op[low] = curr;
	      table.bits[low] = root;
	      table.val[low] = next - opts.table_index;*/
	      table[low] = (root << 24) | (curr << 16) | (next - table_index) |0;
	    }
	  }

	  /* fill in remaining table entry if code is incomplete (guaranteed to have
	   at most one remaining entry, since if the code is incomplete, the
	   maximum code length that was allowed to get this far is one bit) */
	  if (huff !== 0) {
	    //table.op[next + huff] = 64;            /* invalid code marker */
	    //table.bits[next + huff] = len - drop;
	    //table.val[next + huff] = 0;
	    table[next + huff] = ((len - drop) << 24) | (64 << 16) |0;
	  }

	  /* set return parameters */
	  //opts.table_index += used;
	  opts.bits = root;
	  return 0;
	};

	},{"../utils/common":182}],192:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	module.exports = {
	  2:      'need dictionary',     /* Z_NEED_DICT       2  */
	  1:      'stream end',          /* Z_STREAM_END      1  */
	  0:      '',                    /* Z_OK              0  */
	  '-1':   'file error',          /* Z_ERRNO         (-1) */
	  '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
	  '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
	  '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
	  '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
	  '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
	};

	},{}],193:[function(require,module,exports){

	// (C) 1995-2013 Jean-loup Gailly and Mark Adler
	// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
	//
	// This software is provided 'as-is', without any express or implied
	// warranty. In no event will the authors be held liable for any damages
	// arising from the use of this software.
	//
	// Permission is granted to anyone to use this software for any purpose,
	// including commercial applications, and to alter it and redistribute it
	// freely, subject to the following restrictions:
	//
	// 1. The origin of this software must not be misrepresented; you must not
	//   claim that you wrote the original software. If you use this software
	//   in a product, an acknowledgment in the product documentation would be
	//   appreciated but is not required.
	// 2. Altered source versions must be plainly marked as such, and must not be
	//   misrepresented as being the original software.
	// 3. This notice may not be removed or altered from any source distribution.

	var utils = require('../utils/common');

	/* Public constants ==========================================================*/
	/* ===========================================================================*/


	//var Z_FILTERED          = 1;
	//var Z_HUFFMAN_ONLY      = 2;
	//var Z_RLE               = 3;
	var Z_FIXED               = 4;
	//var Z_DEFAULT_STRATEGY  = 0;

	/* Possible values of the data_type field (though see inflate()) */
	var Z_BINARY              = 0;
	var Z_TEXT                = 1;
	//var Z_ASCII             = 1; // = Z_TEXT
	var Z_UNKNOWN             = 2;

	/*============================================================================*/


	function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }

	// From zutil.h

	var STORED_BLOCK = 0;
	var STATIC_TREES = 1;
	var DYN_TREES    = 2;
	/* The three kinds of block type */

	var MIN_MATCH    = 3;
	var MAX_MATCH    = 258;
	/* The minimum and maximum match lengths */

	// From deflate.h
	/* ===========================================================================
	 * Internal compression state.
	 */

	var LENGTH_CODES  = 29;
	/* number of length codes, not counting the special END_BLOCK code */

	var LITERALS      = 256;
	/* number of literal bytes 0..255 */

	var L_CODES       = LITERALS + 1 + LENGTH_CODES;
	/* number of Literal or Length codes, including the END_BLOCK code */

	var D_CODES       = 30;
	/* number of distance codes */

	var BL_CODES      = 19;
	/* number of codes used to transfer the bit lengths */

	var HEAP_SIZE     = 2 * L_CODES + 1;
	/* maximum heap size */

	var MAX_BITS      = 15;
	/* All codes must not exceed MAX_BITS bits */

	var Buf_size      = 16;
	/* size of bit buffer in bi_buf */


	/* ===========================================================================
	 * Constants
	 */

	var MAX_BL_BITS = 7;
	/* Bit length codes must not exceed MAX_BL_BITS bits */

	var END_BLOCK   = 256;
	/* end of block literal code */

	var REP_3_6     = 16;
	/* repeat previous bit length 3-6 times (2 bits of repeat count) */

	var REPZ_3_10   = 17;
	/* repeat a zero length 3-10 times  (3 bits of repeat count) */

	var REPZ_11_138 = 18;
	/* repeat a zero length 11-138 times  (7 bits of repeat count) */

	/* eslint-disable comma-spacing,array-bracket-spacing */
	var extra_lbits =   /* extra bits for each length code */
	  [0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0];

	var extra_dbits =   /* extra bits for each distance code */
	  [0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];

	var extra_blbits =  /* extra bits for each bit length code */
	  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7];

	var bl_order =
	  [16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];
	/* eslint-enable comma-spacing,array-bracket-spacing */

	/* The lengths of the bit length codes are sent in order of decreasing
	 * probability, to avoid transmitting the lengths for unused bit length codes.
	 */

	/* ===========================================================================
	 * Local data. These are initialized only once.
	 */

	// We pre-fill arrays with 0 to avoid uninitialized gaps

	var DIST_CODE_LEN = 512; /* see definition of array dist_code below */

	// !!!! Use flat array instead of structure, Freq = i*2, Len = i*2+1
	var static_ltree  = new Array((L_CODES + 2) * 2);
	zero(static_ltree);
	/* The static literal tree. Since the bit lengths are imposed, there is no
	 * need for the L_CODES extra codes used during heap construction. However
	 * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
	 * below).
	 */

	var static_dtree  = new Array(D_CODES * 2);
	zero(static_dtree);
	/* The static distance tree. (Actually a trivial tree since all codes use
	 * 5 bits.)
	 */

	var _dist_code    = new Array(DIST_CODE_LEN);
	zero(_dist_code);
	/* Distance codes. The first 256 values correspond to the distances
	 * 3 .. 258, the last 256 values correspond to the top 8 bits of
	 * the 15 bit distances.
	 */

	var _length_code  = new Array(MAX_MATCH - MIN_MATCH + 1);
	zero(_length_code);
	/* length code for each normalized match length (0 == MIN_MATCH) */

	var base_length   = new Array(LENGTH_CODES);
	zero(base_length);
	/* First normalized length for each code (0 = MIN_MATCH) */

	var base_dist     = new Array(D_CODES);
	zero(base_dist);
	/* First normalized distance for each code (0 = distance of 1) */


	function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {

	  this.static_tree  = static_tree;  /* static tree or NULL */
	  this.extra_bits   = extra_bits;   /* extra bits for each code or NULL */
	  this.extra_base   = extra_base;   /* base index for extra_bits */
	  this.elems        = elems;        /* max number of elements in the tree */
	  this.max_length   = max_length;   /* max bit length for the codes */

	  // show if `static_tree` has data or dummy - needed for monomorphic objects
	  this.has_stree    = static_tree && static_tree.length;
	}


	var static_l_desc;
	var static_d_desc;
	var static_bl_desc;


	function TreeDesc(dyn_tree, stat_desc) {
	  this.dyn_tree = dyn_tree;     /* the dynamic tree */
	  this.max_code = 0;            /* largest code with non zero frequency */
	  this.stat_desc = stat_desc;   /* the corresponding static tree */
	}



	function d_code(dist) {
	  return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
	}


	/* ===========================================================================
	 * Output a short LSB first on the stream.
	 * IN assertion: there is enough room in pendingBuf.
	 */
	function put_short(s, w) {
	//    put_byte(s, (uch)((w) & 0xff));
	//    put_byte(s, (uch)((ush)(w) >> 8));
	  s.pending_buf[s.pending++] = (w) & 0xff;
	  s.pending_buf[s.pending++] = (w >>> 8) & 0xff;
	}


	/* ===========================================================================
	 * Send a value on a given number of bits.
	 * IN assertion: length <= 16 and value fits in length bits.
	 */
	function send_bits(s, value, length) {
	  if (s.bi_valid > (Buf_size - length)) {
	    s.bi_buf |= (value << s.bi_valid) & 0xffff;
	    put_short(s, s.bi_buf);
	    s.bi_buf = value >> (Buf_size - s.bi_valid);
	    s.bi_valid += length - Buf_size;
	  } else {
	    s.bi_buf |= (value << s.bi_valid) & 0xffff;
	    s.bi_valid += length;
	  }
	}


	function send_code(s, c, tree) {
	  send_bits(s, tree[c * 2]/*.Code*/, tree[c * 2 + 1]/*.Len*/);
	}


	/* ===========================================================================
	 * Reverse the first len bits of a code, using straightforward code (a faster
	 * method would use a table)
	 * IN assertion: 1 <= len <= 15
	 */
	function bi_reverse(code, len) {
	  var res = 0;
	  do {
	    res |= code & 1;
	    code >>>= 1;
	    res <<= 1;
	  } while (--len > 0);
	  return res >>> 1;
	}


	/* ===========================================================================
	 * Flush the bit buffer, keeping at most 7 bits in it.
	 */
	function bi_flush(s) {
	  if (s.bi_valid === 16) {
	    put_short(s, s.bi_buf);
	    s.bi_buf = 0;
	    s.bi_valid = 0;

	  } else if (s.bi_valid >= 8) {
	    s.pending_buf[s.pending++] = s.bi_buf & 0xff;
	    s.bi_buf >>= 8;
	    s.bi_valid -= 8;
	  }
	}


	/* ===========================================================================
	 * Compute the optimal bit lengths for a tree and update the total bit length
	 * for the current block.
	 * IN assertion: the fields freq and dad are set, heap[heap_max] and
	 *    above are the tree nodes sorted by increasing frequency.
	 * OUT assertions: the field len is set to the optimal bit length, the
	 *     array bl_count contains the frequencies for each bit length.
	 *     The length opt_len is updated; static_len is also updated if stree is
	 *     not null.
	 */
	function gen_bitlen(s, desc)
	//    deflate_state *s;
	//    tree_desc *desc;    /* the tree descriptor */
	{
	  var tree            = desc.dyn_tree;
	  var max_code        = desc.max_code;
	  var stree           = desc.stat_desc.static_tree;
	  var has_stree       = desc.stat_desc.has_stree;
	  var extra           = desc.stat_desc.extra_bits;
	  var base            = desc.stat_desc.extra_base;
	  var max_length      = desc.stat_desc.max_length;
	  var h;              /* heap index */
	  var n, m;           /* iterate over the tree elements */
	  var bits;           /* bit length */
	  var xbits;          /* extra bits */
	  var f;              /* frequency */
	  var overflow = 0;   /* number of elements with bit length too large */

	  for (bits = 0; bits <= MAX_BITS; bits++) {
	    s.bl_count[bits] = 0;
	  }

	  /* In a first pass, compute the optimal bit lengths (which may
	   * overflow in the case of the bit length tree).
	   */
	  tree[s.heap[s.heap_max] * 2 + 1]/*.Len*/ = 0; /* root of the heap */

	  for (h = s.heap_max + 1; h < HEAP_SIZE; h++) {
	    n = s.heap[h];
	    bits = tree[tree[n * 2 + 1]/*.Dad*/ * 2 + 1]/*.Len*/ + 1;
	    if (bits > max_length) {
	      bits = max_length;
	      overflow++;
	    }
	    tree[n * 2 + 1]/*.Len*/ = bits;
	    /* We overwrite tree[n].Dad which is no longer needed */

	    if (n > max_code) { continue; } /* not a leaf node */

	    s.bl_count[bits]++;
	    xbits = 0;
	    if (n >= base) {
	      xbits = extra[n - base];
	    }
	    f = tree[n * 2]/*.Freq*/;
	    s.opt_len += f * (bits + xbits);
	    if (has_stree) {
	      s.static_len += f * (stree[n * 2 + 1]/*.Len*/ + xbits);
	    }
	  }
	  if (overflow === 0) { return; }

	  // Trace((stderr,"\nbit length overflow\n"));
	  /* This happens for example on obj2 and pic of the Calgary corpus */

	  /* Find the first bit length which could increase: */
	  do {
	    bits = max_length - 1;
	    while (s.bl_count[bits] === 0) { bits--; }
	    s.bl_count[bits]--;      /* move one leaf down the tree */
	    s.bl_count[bits + 1] += 2; /* move one overflow item as its brother */
	    s.bl_count[max_length]--;
	    /* The brother of the overflow item also moves one step up,
	     * but this does not affect bl_count[max_length]
	     */
	    overflow -= 2;
	  } while (overflow > 0);

	  /* Now recompute all bit lengths, scanning in increasing frequency.
	   * h is still equal to HEAP_SIZE. (It is simpler to reconstruct all
	   * lengths instead of fixing only the wrong ones. This idea is taken
	   * from 'ar' written by Haruhiko Okumura.)
	   */
	  for (bits = max_length; bits !== 0; bits--) {
	    n = s.bl_count[bits];
	    while (n !== 0) {
	      m = s.heap[--h];
	      if (m > max_code) { continue; }
	      if (tree[m * 2 + 1]/*.Len*/ !== bits) {
	        // Trace((stderr,"code %d bits %d->%d\n", m, tree[m].Len, bits));
	        s.opt_len += (bits - tree[m * 2 + 1]/*.Len*/) * tree[m * 2]/*.Freq*/;
	        tree[m * 2 + 1]/*.Len*/ = bits;
	      }
	      n--;
	    }
	  }
	}


	/* ===========================================================================
	 * Generate the codes for a given tree and bit counts (which need not be
	 * optimal).
	 * IN assertion: the array bl_count contains the bit length statistics for
	 * the given tree and the field len is set for all tree elements.
	 * OUT assertion: the field code is set for all tree elements of non
	 *     zero code length.
	 */
	function gen_codes(tree, max_code, bl_count)
	//    ct_data *tree;             /* the tree to decorate */
	//    int max_code;              /* largest code with non zero frequency */
	//    ushf *bl_count;            /* number of codes at each bit length */
	{
	  var next_code = new Array(MAX_BITS + 1); /* next code value for each bit length */
	  var code = 0;              /* running code value */
	  var bits;                  /* bit index */
	  var n;                     /* code index */

	  /* The distribution counts are first used to generate the code values
	   * without bit reversal.
	   */
	  for (bits = 1; bits <= MAX_BITS; bits++) {
	    next_code[bits] = code = (code + bl_count[bits - 1]) << 1;
	  }
	  /* Check that the bit counts in bl_count are consistent. The last code
	   * must be all ones.
	   */
	  //Assert (code + bl_count[MAX_BITS]-1 == (1<<MAX_BITS)-1,
	  //        "inconsistent bit counts");
	  //Tracev((stderr,"\ngen_codes: max_code %d ", max_code));

	  for (n = 0;  n <= max_code; n++) {
	    var len = tree[n * 2 + 1]/*.Len*/;
	    if (len === 0) { continue; }
	    /* Now reverse the bits */
	    tree[n * 2]/*.Code*/ = bi_reverse(next_code[len]++, len);

	    //Tracecv(tree != static_ltree, (stderr,"\nn %3d %c l %2d c %4x (%x) ",
	    //     n, (isgraph(n) ? n : ' '), len, tree[n].Code, next_code[len]-1));
	  }
	}


	/* ===========================================================================
	 * Initialize the various 'constant' tables.
	 */
	function tr_static_init() {
	  var n;        /* iterates over tree elements */
	  var bits;     /* bit counter */
	  var length;   /* length value */
	  var code;     /* code value */
	  var dist;     /* distance index */
	  var bl_count = new Array(MAX_BITS + 1);
	  /* number of codes at each bit length for an optimal tree */

	  // do check in _tr_init()
	  //if (static_init_done) return;

	  /* For some embedded targets, global variables are not initialized: */
	/*#ifdef NO_INIT_GLOBAL_POINTERS
	  static_l_desc.static_tree = static_ltree;
	  static_l_desc.extra_bits = extra_lbits;
	  static_d_desc.static_tree = static_dtree;
	  static_d_desc.extra_bits = extra_dbits;
	  static_bl_desc.extra_bits = extra_blbits;
	#endif*/

	  /* Initialize the mapping length (0..255) -> length code (0..28) */
	  length = 0;
	  for (code = 0; code < LENGTH_CODES - 1; code++) {
	    base_length[code] = length;
	    for (n = 0; n < (1 << extra_lbits[code]); n++) {
	      _length_code[length++] = code;
	    }
	  }
	  //Assert (length == 256, "tr_static_init: length != 256");
	  /* Note that the length 255 (match length 258) can be represented
	   * in two different ways: code 284 + 5 bits or code 285, so we
	   * overwrite length_code[255] to use the best encoding:
	   */
	  _length_code[length - 1] = code;

	  /* Initialize the mapping dist (0..32K) -> dist code (0..29) */
	  dist = 0;
	  for (code = 0; code < 16; code++) {
	    base_dist[code] = dist;
	    for (n = 0; n < (1 << extra_dbits[code]); n++) {
	      _dist_code[dist++] = code;
	    }
	  }
	  //Assert (dist == 256, "tr_static_init: dist != 256");
	  dist >>= 7; /* from now on, all distances are divided by 128 */
	  for (; code < D_CODES; code++) {
	    base_dist[code] = dist << 7;
	    for (n = 0; n < (1 << (extra_dbits[code] - 7)); n++) {
	      _dist_code[256 + dist++] = code;
	    }
	  }
	  //Assert (dist == 256, "tr_static_init: 256+dist != 512");

	  /* Construct the codes of the static literal tree */
	  for (bits = 0; bits <= MAX_BITS; bits++) {
	    bl_count[bits] = 0;
	  }

	  n = 0;
	  while (n <= 143) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 8;
	    n++;
	    bl_count[8]++;
	  }
	  while (n <= 255) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 9;
	    n++;
	    bl_count[9]++;
	  }
	  while (n <= 279) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 7;
	    n++;
	    bl_count[7]++;
	  }
	  while (n <= 287) {
	    static_ltree[n * 2 + 1]/*.Len*/ = 8;
	    n++;
	    bl_count[8]++;
	  }
	  /* Codes 286 and 287 do not exist, but we must include them in the
	   * tree construction to get a canonical Huffman tree (longest code
	   * all ones)
	   */
	  gen_codes(static_ltree, L_CODES + 1, bl_count);

	  /* The static distance tree is trivial: */
	  for (n = 0; n < D_CODES; n++) {
	    static_dtree[n * 2 + 1]/*.Len*/ = 5;
	    static_dtree[n * 2]/*.Code*/ = bi_reverse(n, 5);
	  }

	  // Now data ready and we can init static trees
	  static_l_desc = new StaticTreeDesc(static_ltree, extra_lbits, LITERALS + 1, L_CODES, MAX_BITS);
	  static_d_desc = new StaticTreeDesc(static_dtree, extra_dbits, 0,          D_CODES, MAX_BITS);
	  static_bl_desc = new StaticTreeDesc(new Array(0), extra_blbits, 0,         BL_CODES, MAX_BL_BITS);

	  //static_init_done = true;
	}


	/* ===========================================================================
	 * Initialize a new block.
	 */
	function init_block(s) {
	  var n; /* iterates over tree elements */

	  /* Initialize the trees. */
	  for (n = 0; n < L_CODES;  n++) { s.dyn_ltree[n * 2]/*.Freq*/ = 0; }
	  for (n = 0; n < D_CODES;  n++) { s.dyn_dtree[n * 2]/*.Freq*/ = 0; }
	  for (n = 0; n < BL_CODES; n++) { s.bl_tree[n * 2]/*.Freq*/ = 0; }

	  s.dyn_ltree[END_BLOCK * 2]/*.Freq*/ = 1;
	  s.opt_len = s.static_len = 0;
	  s.last_lit = s.matches = 0;
	}


	/* ===========================================================================
	 * Flush the bit buffer and align the output on a byte boundary
	 */
	function bi_windup(s)
	{
	  if (s.bi_valid > 8) {
	    put_short(s, s.bi_buf);
	  } else if (s.bi_valid > 0) {
	    //put_byte(s, (Byte)s->bi_buf);
	    s.pending_buf[s.pending++] = s.bi_buf;
	  }
	  s.bi_buf = 0;
	  s.bi_valid = 0;
	}

	/* ===========================================================================
	 * Copy a stored block, storing first the length and its
	 * one's complement if requested.
	 */
	function copy_block(s, buf, len, header)
	//DeflateState *s;
	//charf    *buf;    /* the input data */
	//unsigned len;     /* its length */
	//int      header;  /* true if block header must be written */
	{
	  bi_windup(s);        /* align on byte boundary */

	  if (header) {
	    put_short(s, len);
	    put_short(s, ~len);
	  }
	//  while (len--) {
	//    put_byte(s, *buf++);
	//  }
	  utils.arraySet(s.pending_buf, s.window, buf, len, s.pending);
	  s.pending += len;
	}

	/* ===========================================================================
	 * Compares to subtrees, using the tree depth as tie breaker when
	 * the subtrees have equal frequency. This minimizes the worst case length.
	 */
	function smaller(tree, n, m, depth) {
	  var _n2 = n * 2;
	  var 