(*
 *  Copyright (c) 2023 Serge - SSW
 *
 *  This software is provided 'as-is', without any express or
 *  implied warranty. In no event will the authors be held
 *  liable for any damages arising from the use of this software.
 *
 *  Permission is granted to anyone to use this software for any purpose,
 *  including commercial applications, and to alter it and redistribute
 *  it freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented;
 *     you must not claim that you wrote the original software.
 *     If you use this software in a product, an acknowledgment
 *     in the product documentation would be appreciated but
 *     is not required.
 *
 *  2. Altered source versions must be plainly marked as such,
 *     and must not be misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any
 *     source distribution.
 *)

// Copyright 2013-2020 The Khronos Group Inc.
// SPDX-License-Identifier: MIT
//
// This header is generated from the Khronos OpenGL / OpenGL ES XML
// API Registry. The current version of the Registry, generator scripts
// used to make the header, and the header can be found at
//   https://github.com/KhronosGroup/OpenGL-Registry

unit zgl_gles;
{$I zgl_config.cfg}
{$mode delphi}

interface

{$IfNDef Windows}
  {$DEFINE stdcall := cdecl}
{$ENDIF}

uses
  zgl_utils;

Type
  PPGLchar = ^PGLChar;
  PGLboolean  = ^GLboolean;
  PGLchar  = ^GLchar;
  PGLenum  = ^GLenum;
  PGLfloat  = ^GLfloat;
  PGLint  = ^GLint;
  PGLsizei  = ^GLsizei;
  PGLubyte  = ^GLubyte;
  PGLuint  = ^GLuint;
  PGLdouble  = ^GLdouble;
  PGLint64  = ^GLint64;
  PGLint64EXT  = ^GLint64EXT;
  PGLuint64  = ^GLuint64;
  PGLuint64EXT  = ^GLuint64EXT;
  PGLfixed  = ^GLfixed;
  PGLshort = ^GLshort;
  PGLvoid = Pointer;

  GLbyte = Byte;        // khronos_int8_t;     // число без знака, почему тут со знаком?
  GLclampf = Single;    // khronos_float_t;
  GLfixed = LongInt;    // khronos_int32_t;
  GLshort = SmallInt;   // khronos_int16_t;
  GLushort = Word;      // khronos_uint16_t;
  GLvoid = pointer;
  GLsync = Pointer;     // ^__GLsync;

// WARNING!!!  Зависят от разрядности платформы!
//           khronos_intptr_t            signed   same number of bits as a pointer
//           khronos_uintptr_t           unsigned same number of bits as a pointer
//           khronos_ssize_t             signed   size
//           khronos_usize_t             unsigned size

  {$If not defined(CPU32) and not defined(CPUARM)}
  GLsizeiptr = Int64;      // khronos_ssize_t;
  GLintptr = Int64;        // khronos_intptr_t;
  GLuint64 = QWord;        // khronos_uint64_t;
  GLint64 = Int64;         // khronos_int64_t;
  GLuint64EXT = QWord;     // khronos_uint64_t;
  GLint64EXT = Int64;      // khronos_int64_t;
  GLsizeiptrARB = Int64;   // khronos_ssize_t;
  GLintptrARB = Int64;     // khronos_intptr_t;
  {$Else}
  GLsizeiptr = LongInt;    // khronos_ssize_t;
  GLintptr = LongInt;      // khronos_intptr_t;
  GLuint64 = Cardinal;     // khronos_uint64_t;
  GLint64 = LongInt;       // khronos_int64_t;
  GLuint64EXT = Cardinal;  // khronos_uint64_t;
  GLint64EXT = LongInt;
  GLsizeiptrARB = LongInt; // khronos_ssize_t;
  GLintptrARB = LongInt;   // khronos_intptr_t;
  {$IfEnd}
  GLenum = dword;
  GLuint = dword;
  GLchar = char;
  GLfloat = Single;     // khronos_float_t;
  GLbitfield = dword;
  GLint = longint;
  GLboolean = byte;
  GLsizei = longint;
  GLubyte = Byte;       // khronos_uint8_t;
  GLclampx = LongInt;   // khronos_int32_t;
  GLdouble = double;
  GLhalf = Word;        // khronos_uint16_t;

  GLeglImageOES = pointer;

type
  TVector2d = array[0..1] of double;
  TVector2f = array[0..1] of single;
  TVector2i = array[0..1] of longint;
  TVector2s = array[0..1] of smallint;
  TVector2b = array[0..1] of byte;

  TVector3d = array[0..2] of double;
  TVector3f = array[0..2] of single;
  TVector3i = array[0..2] of longint;
  TVector3s = array[0..2] of smallint;
  TVector3b = array[0..2] of byte;

  TVector4d = array[0..3] of double;
  TVector4f = array[0..3] of single;
  TVector4i = array[0..3] of longint;
  TVector4s = array[0..3] of smallint;
  TVector4b = array[0..3] of byte;

  TMatrix3d = array[0..2] of TVector3d;
  TMatrix3f = array[0..2] of TVector3f;
  TMatrix3i = array[0..2] of TVector3i;
  TMatrix3s = array[0..2] of TVector3s;
  TMatrix3b = array[0..2] of TVector3b;

  TMatrix4d = array[0..3] of TVector4d;
  TMatrix4f = array[0..3] of TVector4f;
  TMatrix4i = array[0..3] of TVector4i;
  TMatrix4s = array[0..3] of TVector4s;
  TMatrix4b = array[0..3] of TVector4b;

const
(*******************************************************************************
*                 GL_ES_VERSION_1_0, GL_ES_VERSION_1_1                         *
*******************************************************************************)
// GL_VERSION_ES_CM_1_0
//  GL_DEPTH_BUFFER_BIT = $00000100;
//  GL_STENCIL_BUFFER_BIT = $00000400;
//  GL_COLOR_BUFFER_BIT = $00004000;
//  GL_FALSE = 0;
//  GL_TRUE = 1;
//  GL_POINTS = $0000;
//  GL_LINES = $0001;
//  GL_LINE_LOOP = $0002;
//  GL_LINE_STRIP = $0003;
//  GL_TRIANGLES = $0004;
//  GL_TRIANGLE_STRIP = $0005;
//  GL_TRIANGLE_FAN = $0006;
//  GL_NEVER = $0200;
//  GL_LESS = $0201;
//  GL_EQUAL = $0202;
//  GL_LEQUAL = $0203;
//  GL_GREATER = $0204;
//  GL_NOTEQUAL = $0205;
//  GL_GEQUAL = $0206;
//  GL_ALWAYS = $0207;
//  GL_ZERO = 0;
//  GL_ONE = 1;
//  GL_SRC_COLOR = $0300;
//  GL_ONE_MINUS_SRC_COLOR = $0301;
//  GL_SRC_ALPHA = $0302;
//  GL_ONE_MINUS_SRC_ALPHA = $0303;
//  GL_DST_ALPHA = $0304;
//  GL_ONE_MINUS_DST_ALPHA = $0305;
//  GL_DST_COLOR = $0306;
//  GL_ONE_MINUS_DST_COLOR = $0307;
//  GL_SRC_ALPHA_SATURATE = $0308;
  GL_CLIP_PLANE0 = $3000;
  GL_CLIP_PLANE1 = $3001;
  GL_CLIP_PLANE2 = $3002;
  GL_CLIP_PLANE3 = $3003;
  GL_CLIP_PLANE4 = $3004;
  GL_CLIP_PLANE5 = $3005;
//  GL_FRONT = $0404;
//  GL_BACK = $0405;
//  GL_FRONT_AND_BACK = $0408;
  GL_FOG = $0B60;
  GL_LIGHTING = $0B50;
//  GL_TEXTURE_2D = $0DE1;
//  GL_CULL_FACE = $0B44;
  GL_ALPHA_TEST = $0BC0;
//  GL_BLEND = $0BE2;
  GL_COLOR_LOGIC_OP = $0BF2;
//  GL_DITHER = $0BD0;
//  GL_STENCIL_TEST = $0B90;
//  GL_DEPTH_TEST = $0B71;
  GL_POINT_SMOOTH = $0B10;
  GL_LINE_SMOOTH = $0B20;
//  GL_SCISSOR_TEST = $0C11;
  GL_COLOR_MATERIAL = $0B57;
  GL_NORMALIZE = $0BA1;
  GL_RESCALE_NORMAL = $803A;
//  GL_VERTEX_ARRAY = $8074;
  GL_NORMAL_ARRAY = $8075;
  GL_COLOR_ARRAY = $8076;
  GL_TEXTURE_COORD_ARRAY = $8078;
  GL_MULTISAMPLE = $809D;
//  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_ALPHA_TO_ONE = $809F;
//  GL_SAMPLE_COVERAGE = $80A0;
//  GL_NO_ERROR = 0;
//  GL_INVALID_ENUM = $0500;
//  GL_INVALID_VALUE = $0501;
//  GL_INVALID_OPERATION = $0502;
//  GL_STACK_OVERFLOW = $0503;
//  GL_STACK_UNDERFLOW = $0504;
//  GL_OUT_OF_MEMORY = $0505;
  GL_EXP = $0800;
  GL_EXP2 = $0801;
  GL_FOG_DENSITY = $0B62;
  GL_FOG_START = $0B63;
  GL_FOG_END = $0B64;
  GL_FOG_MODE = $0B65;
  GL_FOG_COLOR = $0B66;
//  GL_CW = $0900;
//  GL_CCW = $0901;
  GL_CURRENT_COLOR = $0B00;
  GL_CURRENT_NORMAL = $0B02;
  GL_CURRENT_TEXTURE_COORDS = $0B03;
  GL_POINT_SIZE = $0B11;
  GL_POINT_SIZE_MIN = $8126;
  GL_POINT_SIZE_MAX = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE = $8128;
  GL_POINT_DISTANCE_ATTENUATION = $8129;
  GL_SMOOTH_POINT_SIZE_RANGE = $0B12;
//  GL_LINE_WIDTH = $0B21;
  GL_SMOOTH_LINE_WIDTH_RANGE = $0B22;
//  GL_ALIASED_POINT_SIZE_RANGE = $846D;
//  GL_ALIASED_LINE_WIDTH_RANGE = $846E;
//  GL_CULL_FACE_MODE = $0B45;
//  GL_FRONT_FACE = $0B46;
  GL_SHADE_MODEL = $0B54;
//  GL_DEPTH_RANGE = $0B70;
//  GL_DEPTH_WRITEMASK = $0B72;
//  GL_DEPTH_CLEAR_VALUE = $0B73;
//  GL_DEPTH_FUNC = $0B74;
//  GL_STENCIL_CLEAR_VALUE = $0B91;
//  GL_STENCIL_FUNC = $0B92;
//  GL_STENCIL_VALUE_MASK = $0B93;
//  GL_STENCIL_FAIL = $0B94;
//  GL_STENCIL_PASS_DEPTH_FAIL = $0B95;
//  GL_STENCIL_PASS_DEPTH_PASS = $0B96;
//  GL_STENCIL_REF = $0B97;
//  GL_STENCIL_WRITEMASK = $0B98;
  GL_MATRIX_MODE = $0BA0;
//  GL_VIEWPORT = $0BA2;
  GL_MODELVIEW_STACK_DEPTH = $0BA3;
  GL_PROJECTION_STACK_DEPTH = $0BA4;
  GL_TEXTURE_STACK_DEPTH = $0BA5;
  GL_MODELVIEW_MATRIX = $0BA6;
  GL_PROJECTION_MATRIX = $0BA7;
  GL_TEXTURE_MATRIX = $0BA8;
  GL_ALPHA_TEST_FUNC = $0BC1;
  GL_ALPHA_TEST_REF = $0BC2;
  GL_BLEND_DST = $0BE0;
  GL_BLEND_SRC = $0BE1;
  GL_LOGIC_OP_MODE = $0BF0;
//  GL_SCISSOR_BOX = $0C10;
//  GL_COLOR_CLEAR_VALUE = $0C22;
//  GL_COLOR_WRITEMASK = $0C23;
  GL_MAX_LIGHTS = $0D31;
  GL_MAX_CLIP_PLANES = $0D32;
//  GL_MAX_TEXTURE_SIZE = $0D33;
  GL_MAX_MODELVIEW_STACK_DEPTH = $0D36;
  GL_MAX_PROJECTION_STACK_DEPTH = $0D38;
  GL_MAX_TEXTURE_STACK_DEPTH = $0D39;
//  GL_MAX_VIEWPORT_DIMS = $0D3A;
  GL_MAX_TEXTURE_UNITS = $84E2;
//  GL_SUBPIXEL_BITS = $0D50;
//  GL_RED_BITS = $0D52;
//  GL_GREEN_BITS = $0D53;
//  GL_BLUE_BITS = $0D54;
//  GL_ALPHA_BITS = $0D55;
//  GL_DEPTH_BITS = $0D56;
//  GL_STENCIL_BITS = $0D57;
//  GL_POLYGON_OFFSET_UNITS = $2A00;
//  GL_POLYGON_OFFSET_FILL = $8037;
//  GL_POLYGON_OFFSET_FACTOR = $8038;
//  GL_TEXTURE_BINDING_2D = $8069;
  GL_VERTEX_ARRAY_SIZE = $807A;
  GL_VERTEX_ARRAY_TYPE = $807B;
  GL_VERTEX_ARRAY_STRIDE = $807C;
  GL_NORMAL_ARRAY_TYPE = $807E;
  GL_NORMAL_ARRAY_STRIDE = $807F;
  GL_COLOR_ARRAY_SIZE = $8081;
  GL_COLOR_ARRAY_TYPE = $8082;
  GL_COLOR_ARRAY_STRIDE = $8083;
  GL_TEXTURE_COORD_ARRAY_SIZE = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE = $808A;
  GL_VERTEX_ARRAY_POINTER = $808E;
  GL_NORMAL_ARRAY_POINTER = $808F;
  GL_COLOR_ARRAY_POINTER = $8090;
  GL_TEXTURE_COORD_ARRAY_POINTER = $8092;
//  GL_SAMPLE_BUFFERS = $80A8;
//  GL_SAMPLES = $80A9;
//  GL_SAMPLE_COVERAGE_VALUE = $80AA;
//  GL_SAMPLE_COVERAGE_INVERT = $80AB;
//  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
//  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
//  GL_DONT_CARE = $1100;
//  GL_FASTEST = $1101;
//  GL_NICEST = $1102;
  GL_PERSPECTIVE_CORRECTION_HINT = $0C50;
  GL_POINT_SMOOTH_HINT = $0C51;
  GL_LINE_SMOOTH_HINT = $0C52;
  GL_FOG_HINT = $0C54;
//  GL_GENERATE_MIPMAP_HINT = $8192;
  GL_LIGHT_MODEL_AMBIENT = $0B53;
  GL_LIGHT_MODEL_TWO_SIDE = $0B52;
  GL_AMBIENT = $1200;
  GL_DIFFUSE = $1201;
  GL_SPECULAR = $1202;
  GL_POSITION = $1203;
  GL_SPOT_DIRECTION = $1204;
  GL_SPOT_EXPONENT = $1205;
  GL_SPOT_CUTOFF = $1206;
  GL_CONSTANT_ATTENUATION = $1207;
  GL_LINEAR_ATTENUATION = $1208;
  GL_QUADRATIC_ATTENUATION = $1209;
//  GL_BYTE = $1400;
//  GL_UNSIGNED_BYTE = $1401;
//  GL_SHORT = $1402;
//  GL_UNSIGNED_SHORT = $1403;
//  GL_FLOAT = $1406;
//  GL_FIXED = $140C;
  GL_CLEAR = $1500;
  GL_AND = $1501;
  GL_AND_REVERSE = $1502;
  GL_COPY = $1503;
  GL_AND_INVERTED = $1504;
  GL_NOOP = $1505;
  GL_XOR = $1506;
  GL_OR = $1507;
  GL_NOR = $1508;
  GL_EQUIV = $1509;
//  GL_INVERT = $150A;
  GL_OR_REVERSE = $150B;
  GL_COPY_INVERTED = $150C;
  GL_OR_INVERTED = $150D;
  GL_NAND = $150E;
  GL_SET = $150F;
  GL_EMISSION = $1600;
  GL_SHININESS = $1601;
  GL_AMBIENT_AND_DIFFUSE = $1602;
  GL_MODELVIEW = $1700;
  GL_PROJECTION = $1701;
//  GL_TEXTURE = $1702;
//  GL_ALPHA = $1906;
//  GL_RGB = $1907;
//  GL_RGBA = $1908;
//  GL_LUMINANCE = $1909;
//  GL_LUMINANCE_ALPHA = $190A;
//  GL_UNPACK_ALIGNMENT = $0CF5;
//  GL_PACK_ALIGNMENT = $0D05;
//  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
//  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
//  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_FLAT = $1D00;
  GL_SMOOTH = $1D01;
//  GL_KEEP = $1E00;
//  GL_REPLACE = $1E01;
//  GL_INCR = $1E02;
//  GL_DECR = $1E03;
//  GL_VENDOR = $1F00;
//  GL_RENDERER = $1F01;
//  GL_VERSION = $1F02;
//  GL_EXTENSIONS = $1F03;
  GL_MODULATE = $2100;
  GL_DECAL = $2101;
  GL_ADD = $0104;
  GL_TEXTURE_ENV_MODE = $2200;
  GL_TEXTURE_ENV_COLOR = $2201;
  GL_TEXTURE_ENV = $2300;
//  GL_NEAREST = $2600;
//  GL_LINEAR = $2601;
//  GL_NEAREST_MIPMAP_NEAREST = $2700;
//  GL_LINEAR_MIPMAP_NEAREST = $2701;
//  GL_NEAREST_MIPMAP_LINEAR = $2702;
//  GL_LINEAR_MIPMAP_LINEAR = $2703;
//  GL_TEXTURE_MAG_FILTER = $2800;
//  GL_TEXTURE_MIN_FILTER = $2801;
//  GL_TEXTURE_WRAP_S = $2802;
//  GL_TEXTURE_WRAP_T = $2803;
  GL_GENERATE_MIPMAP = $8191;
//  GL_TEXTURE0 = $84C0;
//  GL_TEXTURE1 = $84C1;
//  GL_TEXTURE2 = $84C2;
//  GL_TEXTURE3 = $84C3;
//  GL_TEXTURE4 = $84C4;
//  GL_TEXTURE5 = $84C5;
//  GL_TEXTURE6 = $84C6;
//  GL_TEXTURE7 = $84C7;
//  GL_TEXTURE8 = $84C8;
//  GL_TEXTURE9 = $84C9;
//  GL_TEXTURE10 = $84CA;
//  GL_TEXTURE11 = $84CB;
//  GL_TEXTURE12 = $84CC;
//  GL_TEXTURE13 = $84CD;
//  GL_TEXTURE14 = $84CE;
//  GL_TEXTURE15 = $84CF;
//  GL_TEXTURE16 = $84D0;
//  GL_TEXTURE17 = $84D1;
//  GL_TEXTURE18 = $84D2;
//  GL_TEXTURE19 = $84D3;
//  GL_TEXTURE20 = $84D4;
//  GL_TEXTURE21 = $84D5;
//  GL_TEXTURE22 = $84D6;
//  GL_TEXTURE23 = $84D7;
//  GL_TEXTURE24 = $84D8;
//  GL_TEXTURE25 = $84D9;
//  GL_TEXTURE26 = $84DA;
//  GL_TEXTURE27 = $84DB;
//  GL_TEXTURE28 = $84DC;
//  GL_TEXTURE29 = $84DD;
//  GL_TEXTURE30 = $84DE;
//  GL_TEXTURE31 = $84DF;
//  GL_ACTIVE_TEXTURE = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE = $84E1;
//  GL_REPEAT = $2901;
//  GL_CLAMP_TO_EDGE = $812F;
  GL_LIGHT0 = $4000;
  GL_LIGHT1 = $4001;
  GL_LIGHT2 = $4002;
  GL_LIGHT3 = $4003;
  GL_LIGHT4 = $4004;
  GL_LIGHT5 = $4005;
  GL_LIGHT6 = $4006;
  GL_LIGHT7 = $4007;
//  GL_ARRAY_BUFFER = $8892;
//  GL_ELEMENT_ARRAY_BUFFER = $8893;
//  GL_ARRAY_BUFFER_BINDING = $8894;
//  GL_ELEMENT_ARRAY_BUFFER_BINDING = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING = $8898;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = $889A;
//  GL_STATIC_DRAW = $88E4;
//  GL_DYNAMIC_DRAW = $88E8;
//  GL_BUFFER_SIZE = $8764;
//  GL_BUFFER_USAGE = $8765;
  GL_SUBTRACT = $84E7;
  GL_COMBINE = $8570;
  GL_COMBINE_RGB = $8571;
  GL_COMBINE_ALPHA = $8572;
  GL_RGB_SCALE = $8573;
  GL_ADD_SIGNED = $8574;
  GL_INTERPOLATE = $8575;
  GL_CONSTANT = $8576;
  GL_PRIMARY_COLOR = $8577;
  GL_PREVIOUS = $8578;
  GL_OPERAND0_RGB = $8590;
  GL_OPERAND1_RGB = $8591;
  GL_OPERAND2_RGB = $8592;
  GL_OPERAND0_ALPHA = $8598;
  GL_OPERAND1_ALPHA = $8599;
  GL_OPERAND2_ALPHA = $859A;
  GL_ALPHA_SCALE = $0D1C;
  GL_SRC0_RGB = $8580;
  GL_SRC1_RGB = $8581;
  GL_SRC2_RGB = $8582;
  GL_SRC0_ALPHA = $8588;
  GL_SRC1_ALPHA = $8589;
  GL_SRC2_ALPHA = $858A;
  GL_DOT3_RGB = $86AE;
  GL_DOT3_RGBA = $86AF;
// GL_OES_point_size_array
  GL_POINT_SIZE_ARRAY_OES = $8B9C;
  GL_POINT_SIZE_ARRAY_TYPE_OES = $898A;
  GL_POINT_SIZE_ARRAY_STRIDE_OES = $898B;
  GL_POINT_SIZE_ARRAY_POINTER_OES = $898C;
  GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES = $8B9F;
// GL_OES_point_sprite
  GL_POINT_SPRITE_OES = $8861;
  GL_COORD_REPLACE_OES = $8862;
// GL_OES_blend_equation_separate
  GL_BLEND_EQUATION_RGB_OES = $8009;
  GL_BLEND_EQUATION_ALPHA_OES = $883D;
// GL_OES_blend_func_separate
  GL_BLEND_DST_RGB_OES = $80C8;
  GL_BLEND_SRC_RGB_OES = $80C9;
  GL_BLEND_DST_ALPHA_OES = $80CA;
  GL_BLEND_SRC_ALPHA_OES = $80CB;
// GL_OES_blend_subtract
  GL_BLEND_EQUATION_OES = $8009;
  GL_FUNC_ADD_OES = $8006;
  GL_FUNC_SUBTRACT_OES = $800A;
  GL_FUNC_REVERSE_SUBTRACT_OES = $800B;
// GL_OES_draw_texture
  GL_TEXTURE_CROP_RECT_OES = $8B9D;
// GL_OES_fixed_point
  GL_FIXED_OES = $140C;
// GL_OES_framebuffer_object
  GL_NONE_OES = 0;
  GL_FRAMEBUFFER_OES = $8D40;
  GL_RENDERBUFFER_OES = $8D41;
//  GL_RGBA4_OES = $8056;
//  GL_RGB5_A1_OES = $8057;
//  GL_RGB565_OES = $8D62;
//  GL_DEPTH_COMPONENT16_OES = $81A5;
  GL_RENDERBUFFER_WIDTH_OES = $8D42;
  GL_RENDERBUFFER_HEIGHT_OES = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT_OES = $8D44;
  GL_RENDERBUFFER_RED_SIZE_OES = $8D50;
  GL_RENDERBUFFER_GREEN_SIZE_OES = $8D51;
  GL_RENDERBUFFER_BLUE_SIZE_OES = $8D52;
  GL_RENDERBUFFER_ALPHA_SIZE_OES = $8D53;
  GL_RENDERBUFFER_DEPTH_SIZE_OES = $8D54;
  GL_RENDERBUFFER_STENCIL_SIZE_OES = $8D55;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES = $8CD3;
  GL_COLOR_ATTACHMENT0_OES = $8CE0;
  GL_DEPTH_ATTACHMENT_OES = $8D00;
  GL_STENCIL_ATTACHMENT_OES = $8D20;
  GL_FRAMEBUFFER_COMPLETE_OES = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES = $8CDA;
  GL_FRAMEBUFFER_UNSUPPORTED_OES = $8CDD;
  GL_FRAMEBUFFER_BINDING_OES = $8CA6;
  GL_RENDERBUFFER_BINDING_OES = $8CA7;
  GL_MAX_RENDERBUFFER_SIZE_OES = $84E8;
  GL_INVALID_FRAMEBUFFER_OPERATION_OES = $0506;
// GL_OES_matrix_get
  GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES = $898D;
  GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES = $898E;
  GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES = $898F;
// GL_OES_matrix_palette
  GL_MAX_VERTEX_UNITS_OES = $86A4;
  GL_MAX_PALETTE_MATRICES_OES = $8842;
  GL_MATRIX_PALETTE_OES = $8840;
  GL_MATRIX_INDEX_ARRAY_OES = $8844;
  GL_WEIGHT_ARRAY_OES = $86AD;
  GL_CURRENT_PALETTE_MATRIX_OES = $8843;
  GL_MATRIX_INDEX_ARRAY_SIZE_OES = $8846;
  GL_MATRIX_INDEX_ARRAY_TYPE_OES = $8847;
  GL_MATRIX_INDEX_ARRAY_STRIDE_OES = $8848;
  GL_MATRIX_INDEX_ARRAY_POINTER_OES = $8849;
  GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES = $8B9E;
  GL_WEIGHT_ARRAY_SIZE_OES = $86AB;
  GL_WEIGHT_ARRAY_TYPE_OES = $86A9;
  GL_WEIGHT_ARRAY_STRIDE_OES = $86AA;
  GL_WEIGHT_ARRAY_POINTER_OES = $86AC;
  GL_WEIGHT_ARRAY_BUFFER_BINDING_OES = $889E;
// GL_OES_stencil_wrap
  GL_INCR_WRAP_OES = $8507;
  GL_DECR_WRAP_OES = $8508;
// GL_OES_texture_cube_map
  GL_NORMAL_MAP_OES = $8511;
  GL_REFLECTION_MAP_OES = $8512;
  GL_TEXTURE_CUBE_MAP_OES = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP_OES = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES = $851A;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES = $851C;
  GL_TEXTURE_GEN_MODE_OES = $2500;
  GL_TEXTURE_GEN_STR_OES = $8D60;
// GL_OES_texture_mirrored_repeat
  GL_MIRRORED_REPEAT_OES = $8370;
// GL_AMD_compressed_ATC_texture
  GL_ATC_RGB_AMD = $8C92;
//  GL_ATC_RGBA_EXPLICIT_ALPHA_AMD = $8C93;
//  GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = $87EE;
// GL_EXT_texture_lod_bias
  GL_MAX_TEXTURE_LOD_BIAS_EXT = $84FD;
  GL_TEXTURE_FILTER_CONTROL_EXT = $8500;
  GL_TEXTURE_LOD_BIAS_EXT = $8501;
// GL_IMG_texture_env_enhanced_fixed_function
  GL_MODULATE_COLOR_IMG = $8C04;
  GL_RECIP_ADD_SIGNED_ALPHA_IMG = $8C05;
  GL_TEXTURE_ALPHA_MODULATE_IMG = $8C06;
  GL_FACTOR_ALPHA_MODULATE_IMG = $8C07;
  GL_FRAGMENT_ALPHA_MODULATE_IMG = $8C08;
  GL_ADD_BLEND_IMG = $8C09;
  GL_DOT3_RGBA_IMG = $86AF;
// GL_IMG_user_clip_plane
  GL_CLIP_PLANE0_IMG = $3000;
  GL_CLIP_PLANE1_IMG = $3001;
  GL_CLIP_PLANE2_IMG = $3002;
  GL_CLIP_PLANE3_IMG = $3003;
  GL_CLIP_PLANE4_IMG = $3004;
  GL_CLIP_PLANE5_IMG = $3005;
  GL_MAX_CLIP_PLANES_IMG = $0D32;
(*******************************************************************************
*                           END GLES 1.0/1.1                                 *
*******************************************************************************)

(*******************************************************************************
*                            GL_ES_VERSION_2_0                                 *
*******************************************************************************)
  GL_DEPTH_BUFFER_BIT = $00000100;
  GL_STENCIL_BUFFER_BIT = $00000400;
  GL_COLOR_BUFFER_BIT = $00004000;
  GL_FALSE = 0;
  GL_TRUE = 1;
  GL_POINTS = $0000;
  GL_LINES = $0001;
  GL_LINE_LOOP = $0002;
  GL_LINE_STRIP = $0003;
  GL_TRIANGLES = $0004;
  GL_TRIANGLE_STRIP = $0005;
  GL_TRIANGLE_FAN = $0006;
  GL_ZERO = 0;
  GL_ONE = 1;
  GL_SRC_COLOR = $0300;
  GL_ONE_MINUS_SRC_COLOR = $0301;
  GL_SRC_ALPHA = $0302;
  GL_ONE_MINUS_SRC_ALPHA = $0303;
  GL_DST_ALPHA = $0304;
  GL_ONE_MINUS_DST_ALPHA = $0305;
  GL_DST_COLOR = $0306;
  GL_ONE_MINUS_DST_COLOR = $0307;
  GL_SRC_ALPHA_SATURATE = $0308;
  GL_FUNC_ADD = $8006;
  GL_BLEND_EQUATION = $8009;
  GL_BLEND_EQUATION_RGB = $8009;
  GL_BLEND_EQUATION_ALPHA = $883D;
  GL_FUNC_SUBTRACT = $800A;
  GL_FUNC_REVERSE_SUBTRACT = $800B;
  GL_BLEND_DST_RGB = $80C8;
  GL_BLEND_SRC_RGB = $80C9;
  GL_BLEND_DST_ALPHA = $80CA;
  GL_BLEND_SRC_ALPHA = $80CB;
  GL_CONSTANT_COLOR = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR = $8002;
  GL_CONSTANT_ALPHA = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA = $8004;
  GL_BLEND_COLOR = $8005;
  GL_ARRAY_BUFFER = $8892;
  GL_ELEMENT_ARRAY_BUFFER = $8893;
  GL_ARRAY_BUFFER_BINDING = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING = $8895;
  GL_STREAM_DRAW = $88E0;
  GL_STATIC_DRAW = $88E4;
  GL_DYNAMIC_DRAW = $88E8;
  GL_BUFFER_SIZE = $8764;
  GL_BUFFER_USAGE = $8765;
  GL_CURRENT_VERTEX_ATTRIB = $8626;
  GL_FRONT = $0404;
  GL_BACK = $0405;
  GL_FRONT_AND_BACK = $0408;
  GL_TEXTURE_2D = $0DE1;
  GL_CULL_FACE = $0B44;
  GL_BLEND = $0BE2;
  GL_DITHER = $0BD0;
  GL_STENCIL_TEST = $0B90;
  GL_DEPTH_TEST = $0B71;
  GL_SCISSOR_TEST = $0C11;
  GL_POLYGON_OFFSET_FILL = $8037;
  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_COVERAGE = $80A0;
  GL_NO_ERROR = 0;
  GL_INVALID_ENUM = $0500;
  GL_INVALID_VALUE = $0501;
  GL_INVALID_OPERATION = $0502;
  GL_OUT_OF_MEMORY = $0505;
  GL_CW = $0900;
  GL_CCW = $0901;
  GL_LINE_WIDTH = $0B21;
  GL_ALIASED_POINT_SIZE_RANGE = $846D;
  GL_ALIASED_LINE_WIDTH_RANGE = $846E;
  GL_CULL_FACE_MODE = $0B45;
  GL_FRONT_FACE = $0B46;
  GL_DEPTH_RANGE = $0B70;
  GL_DEPTH_WRITEMASK = $0B72;
  GL_DEPTH_CLEAR_VALUE = $0B73;
  GL_DEPTH_FUNC = $0B74;
  GL_STENCIL_CLEAR_VALUE = $0B91;
  GL_STENCIL_FUNC = $0B92;
  GL_STENCIL_FAIL = $0B94;
  GL_STENCIL_PASS_DEPTH_FAIL = $0B95;
  GL_STENCIL_PASS_DEPTH_PASS = $0B96;
  GL_STENCIL_REF = $0B97;
  GL_STENCIL_VALUE_MASK = $0B93;
  GL_STENCIL_WRITEMASK = $0B98;
  GL_STENCIL_BACK_FUNC = $8800;
  GL_STENCIL_BACK_FAIL = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS = $8803;
  GL_STENCIL_BACK_REF = $8CA3;
  GL_STENCIL_BACK_VALUE_MASK = $8CA4;
  GL_STENCIL_BACK_WRITEMASK = $8CA5;
  GL_VIEWPORT = $0BA2;
  GL_SCISSOR_BOX = $0C10;
  GL_COLOR_CLEAR_VALUE = $0C22;
  GL_COLOR_WRITEMASK = $0C23;
  GL_UNPACK_ALIGNMENT = $0CF5;
  GL_PACK_ALIGNMENT = $0D05;
  GL_MAX_TEXTURE_SIZE = $0D33;
  GL_MAX_VIEWPORT_DIMS = $0D3A;
  GL_SUBPIXEL_BITS = $0D50;
  GL_RED_BITS = $0D52;
  GL_GREEN_BITS = $0D53;
  GL_BLUE_BITS = $0D54;
  GL_ALPHA_BITS = $0D55;
  GL_DEPTH_BITS = $0D56;
  GL_STENCIL_BITS = $0D57;
  GL_POLYGON_OFFSET_UNITS = $2A00;
  GL_POLYGON_OFFSET_FACTOR = $8038;
  GL_TEXTURE_BINDING_2D = $8069;
  GL_SAMPLE_BUFFERS = $80A8;
  GL_SAMPLES = $80A9;
  GL_SAMPLE_COVERAGE_VALUE = $80AA;
  GL_SAMPLE_COVERAGE_INVERT = $80AB;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
  GL_DONT_CARE = $1100;
  GL_FASTEST = $1101;
  GL_NICEST = $1102;
  GL_GENERATE_MIPMAP_HINT = $8192;
  GL_BYTE = $1400;
  GL_UNSIGNED_BYTE = $1401;
  GL_SHORT = $1402;
  GL_UNSIGNED_SHORT = $1403;
  GL_INT = $1404;
  GL_UNSIGNED_INT = $1405;
  GL_FLOAT = $1406;
  GL_FIXED = $140C;
  GL_DEPTH_COMPONENT = $1902;
  GL_ALPHA = $1906;
  GL_RGB = $1907;
  GL_RGBA = $1908;
  GL_LUMINANCE = $1909;
  GL_LUMINANCE_ALPHA = $190A;
  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_FRAGMENT_SHADER = $8B30;
  GL_VERTEX_SHADER = $8B31;
  GL_MAX_VERTEX_ATTRIBS = $8869;
  GL_MAX_VERTEX_UNIFORM_VECTORS = $8DFB;
  GL_MAX_VARYING_VECTORS = $8DFC;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = $8B4D;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = $8B4C;
  GL_MAX_TEXTURE_IMAGE_UNITS = $8872;
  GL_MAX_FRAGMENT_UNIFORM_VECTORS = $8DFD;
  GL_SHADER_TYPE = $8B4F;
  GL_DELETE_STATUS = $8B80;
  GL_LINK_STATUS = $8B82;
  GL_VALIDATE_STATUS = $8B83;
  GL_ATTACHED_SHADERS = $8B85;
  GL_ACTIVE_UNIFORMS = $8B86;
  GL_ACTIVE_UNIFORM_MAX_LENGTH = $8B87;
  GL_ACTIVE_ATTRIBUTES = $8B89;
  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = $8B8A;
  GL_SHADING_LANGUAGE_VERSION = $8B8C;
  GL_CURRENT_PROGRAM = $8B8D;
  GL_NEVER = $0200;
  GL_LESS = $0201;
  GL_EQUAL = $0202;
  GL_LEQUAL = $0203;
  GL_GREATER = $0204;
  GL_NOTEQUAL = $0205;
  GL_GEQUAL = $0206;
  GL_ALWAYS = $0207;
  GL_KEEP = $1E00;
  GL_REPLACE = $1E01;
  GL_INCR = $1E02;
  GL_DECR = $1E03;
  GL_INVERT = $150A;
  GL_INCR_WRAP = $8507;
  GL_DECR_WRAP = $8508;
  GL_VENDOR = $1F00;
  GL_RENDERER = $1F01;
  GL_VERSION = $1F02;
  GL_EXTENSIONS = $1F03;
  GL_NEAREST = $2600;
  GL_LINEAR = $2601;
  GL_NEAREST_MIPMAP_NEAREST = $2700;
  GL_LINEAR_MIPMAP_NEAREST = $2701;
  GL_NEAREST_MIPMAP_LINEAR = $2702;
  GL_LINEAR_MIPMAP_LINEAR = $2703;
  GL_TEXTURE_MAG_FILTER = $2800;
  GL_TEXTURE_MIN_FILTER = $2801;
  GL_TEXTURE_WRAP_S = $2802;
  GL_TEXTURE_WRAP_T = $2803;
  GL_TEXTURE = $1702;
  GL_TEXTURE_CUBE_MAP = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = $851A;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE = $851C;
  GL_TEXTURE0 = $84C0;
  GL_TEXTURE1 = $84C1;
  GL_TEXTURE2 = $84C2;
  GL_TEXTURE3 = $84C3;
  GL_TEXTURE4 = $84C4;
  GL_TEXTURE5 = $84C5;
  GL_TEXTURE6 = $84C6;
  GL_TEXTURE7 = $84C7;
  GL_TEXTURE8 = $84C8;
  GL_TEXTURE9 = $84C9;
  GL_TEXTURE10 = $84CA;
  GL_TEXTURE11 = $84CB;
  GL_TEXTURE12 = $84CC;
  GL_TEXTURE13 = $84CD;
  GL_TEXTURE14 = $84CE;
  GL_TEXTURE15 = $84CF;
  GL_TEXTURE16 = $84D0;
  GL_TEXTURE17 = $84D1;
  GL_TEXTURE18 = $84D2;
  GL_TEXTURE19 = $84D3;
  GL_TEXTURE20 = $84D4;
  GL_TEXTURE21 = $84D5;
  GL_TEXTURE22 = $84D6;
  GL_TEXTURE23 = $84D7;
  GL_TEXTURE24 = $84D8;
  GL_TEXTURE25 = $84D9;
  GL_TEXTURE26 = $84DA;
  GL_TEXTURE27 = $84DB;
  GL_TEXTURE28 = $84DC;
  GL_TEXTURE29 = $84DD;
  GL_TEXTURE30 = $84DE;
  GL_TEXTURE31 = $84DF;
  GL_ACTIVE_TEXTURE = $84E0;
  GL_REPEAT = $2901;
  GL_CLAMP_TO_EDGE = $812F;
  GL_MIRRORED_REPEAT = $8370;
  GL_FLOAT_VEC2 = $8B50;
  GL_FLOAT_VEC3 = $8B51;
  GL_FLOAT_VEC4 = $8B52;
  GL_INT_VEC2 = $8B53;
  GL_INT_VEC3 = $8B54;
  GL_INT_VEC4 = $8B55;
  GL_BOOL = $8B56;
  GL_BOOL_VEC2 = $8B57;
  GL_BOOL_VEC3 = $8B58;
  GL_BOOL_VEC4 = $8B59;
  GL_FLOAT_MAT2 = $8B5A;
  GL_FLOAT_MAT3 = $8B5B;
  GL_FLOAT_MAT4 = $8B5C;
  GL_SAMPLER_2D = $8B5E;
  GL_SAMPLER_CUBE = $8B60;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE = $8625;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = $886A;
  GL_VERTEX_ATTRIB_ARRAY_POINTER = $8645;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = $889F;
  GL_IMPLEMENTATION_COLOR_READ_TYPE = $8B9A;
  GL_IMPLEMENTATION_COLOR_READ_FORMAT = $8B9B;
  GL_COMPILE_STATUS = $8B81;
  GL_INFO_LOG_LENGTH = $8B84;
  GL_SHADER_SOURCE_LENGTH = $8B88;
  GL_SHADER_COMPILER = $8DFA;
  GL_SHADER_BINARY_FORMATS = $8DF8;
  GL_NUM_SHADER_BINARY_FORMATS = $8DF9;
  GL_LOW_FLOAT = $8DF0;
  GL_MEDIUM_FLOAT = $8DF1;
  GL_HIGH_FLOAT = $8DF2;
  GL_LOW_INT = $8DF3;
  GL_MEDIUM_INT = $8DF4;
  GL_HIGH_INT = $8DF5;
  GL_FRAMEBUFFER = $8D40;
  GL_RENDERBUFFER = $8D41;
  GL_RGBA4 = $8056;
  GL_RGB5_A1 = $8057;
  GL_RGB565 = $8D62;
  GL_DEPTH_COMPONENT16 = $81A5;
  GL_STENCIL_INDEX8 = $8D48;
  GL_RENDERBUFFER_WIDTH = $8D42;
  GL_RENDERBUFFER_HEIGHT = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT = $8D44;
  GL_RENDERBUFFER_RED_SIZE = $8D50;
  GL_RENDERBUFFER_GREEN_SIZE = $8D51;
  GL_RENDERBUFFER_BLUE_SIZE = $8D52;
  GL_RENDERBUFFER_ALPHA_SIZE = $8D53;
  GL_RENDERBUFFER_DEPTH_SIZE = $8D54;
  GL_RENDERBUFFER_STENCIL_SIZE = $8D55;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = $8CD3;
  GL_COLOR_ATTACHMENT0 = $8CE0;
  GL_DEPTH_ATTACHMENT = $8D00;
  GL_STENCIL_ATTACHMENT = $8D20;
  GL_NONE = 0;
  GL_FRAMEBUFFER_COMPLETE = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = $8CD9;
  GL_FRAMEBUFFER_UNSUPPORTED = $8CDD;
  GL_FRAMEBUFFER_BINDING = $8CA6;
  GL_RENDERBUFFER_BINDING = $8CA7;
  GL_MAX_RENDERBUFFER_SIZE = $84E8;
  GL_INVALID_FRAMEBUFFER_OPERATION = $0506;
// GL_KHR_blend_equation_advanced
  GL_MULTIPLY_KHR = $9294;
  GL_SCREEN_KHR = $9295;
  GL_OVERLAY_KHR = $9296;
  GL_DARKEN_KHR = $9297;
  GL_LIGHTEN_KHR = $9298;
  GL_COLORDODGE_KHR = $9299;
  GL_COLORBURN_KHR = $929A;
  GL_HARDLIGHT_KHR = $929B;
  GL_SOFTLIGHT_KHR = $929C;
  GL_DIFFERENCE_KHR = $929E;
  GL_EXCLUSION_KHR = $92A0;
  GL_HSL_HUE_KHR = $92AD;
  GL_HSL_SATURATION_KHR = $92AE;
  GL_HSL_COLOR_KHR = $92AF;
  GL_HSL_LUMINOSITY_KHR = $92B0;
// GL_KHR_blend_equation_advanced_coherent
  GL_BLEND_ADVANCED_COHERENT_KHR = $9285;
// GL_KHR_context_flush_control
  GL_CONTEXT_RELEASE_BEHAVIOR_KHR = $82FB;
  GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = $82FC;
// GL_KHR_debug
  GL_SAMPLER = $82E6;
  GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = $8242;
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = $8243;
  GL_DEBUG_CALLBACK_FUNCTION_KHR = $8244;
  GL_DEBUG_CALLBACK_USER_PARAM_KHR = $8245;
  GL_DEBUG_SOURCE_API_KHR = $8246;
  GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = $8247;
  GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = $8248;
  GL_DEBUG_SOURCE_THIRD_PARTY_KHR = $8249;
  GL_DEBUG_SOURCE_APPLICATION_KHR = $824A;
  GL_DEBUG_SOURCE_OTHER_KHR = $824B;
  GL_DEBUG_TYPE_ERROR_KHR = $824C;
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = $824D;
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = $824E;
  GL_DEBUG_TYPE_PORTABILITY_KHR = $824F;
  GL_DEBUG_TYPE_PERFORMANCE_KHR = $8250;
  GL_DEBUG_TYPE_OTHER_KHR = $8251;
  GL_DEBUG_TYPE_MARKER_KHR = $8268;
  GL_DEBUG_TYPE_PUSH_GROUP_KHR = $8269;
  GL_DEBUG_TYPE_POP_GROUP_KHR = $826A;
  GL_DEBUG_SEVERITY_NOTIFICATION_KHR = $826B;
  GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = $826C;
  GL_DEBUG_GROUP_STACK_DEPTH_KHR = $826D;
  GL_BUFFER_KHR = $82E0;
  GL_SHADER_KHR = $82E1;
  GL_PROGRAM_KHR = $82E2;
  GL_VERTEX_ARRAY_KHR = $8074;
  GL_QUERY_KHR = $82E3;
  GL_PROGRAM_PIPELINE_KHR = $82E4;
  GL_SAMPLER_KHR = $82E6;
  GL_MAX_LABEL_LENGTH_KHR = $82E8;
  GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = $9143;
  GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = $9144;
  GL_DEBUG_LOGGED_MESSAGES_KHR = $9145;
  GL_DEBUG_SEVERITY_HIGH_KHR = $9146;
  GL_DEBUG_SEVERITY_MEDIUM_KHR = $9147;
  GL_DEBUG_SEVERITY_LOW_KHR = $9148;
  GL_DEBUG_OUTPUT_KHR = $92E0;
  GL_CONTEXT_FLAG_DEBUG_BIT_KHR = $00000002;
  GL_STACK_OVERFLOW_KHR = $0503;
  GL_STACK_UNDERFLOW_KHR = $0504;

{$IfDef GL_KHR_debug}
type
   GLDEBUGPROCKHR = procedure(source:GLenum; _type:GLenum; id:GLuint; severity:GLenum; length:GLsizei;
                  message:PGLchar; userParam:pointer);cdecl;
{$EndIf}
const
// GL_KHR_no_error
  GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = $00000008;
// GL_KHR_parallel_shader_compile
  GL_MAX_SHADER_COMPILER_THREADS_KHR = $91B0;
  GL_COMPLETION_STATUS_KHR = $91B1;
// GL_KHR_robustness
  GL_CONTEXT_ROBUST_ACCESS_KHR = $90F3;
  GL_LOSE_CONTEXT_ON_RESET_KHR = $8252;
  GL_GUILTY_CONTEXT_RESET_KHR = $8253;
  GL_INNOCENT_CONTEXT_RESET_KHR = $8254;
  GL_UNKNOWN_CONTEXT_RESET_KHR = $8255;
  GL_RESET_NOTIFICATION_STRATEGY_KHR = $8256;
  GL_NO_RESET_NOTIFICATION_KHR = $8261;
  GL_CONTEXT_LOST_KHR = $0507;
// GL_KHR_shader_subgroup
  GL_SUBGROUP_SIZE_KHR = $9532;
  GL_SUBGROUP_SUPPORTED_STAGES_KHR = $9533;
  GL_SUBGROUP_SUPPORTED_FEATURES_KHR = $9534;
  GL_SUBGROUP_QUAD_ALL_STAGES_KHR = $9535;
  GL_SUBGROUP_FEATURE_BASIC_BIT_KHR = $00000001;
  GL_SUBGROUP_FEATURE_VOTE_BIT_KHR = $00000002;
  GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR = $00000004;
  GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR = $00000008;
  GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR = $00000010;
  GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR = $00000020;
  GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR = $00000040;
  GL_SUBGROUP_FEATURE_QUAD_BIT_KHR = $00000080;
// GL_KHR_texture_compression_astc_hdr
  GL_COMPRESSED_RGBA_ASTC_4x4_KHR = $93B0;
  GL_COMPRESSED_RGBA_ASTC_5x4_KHR = $93B1;
  GL_COMPRESSED_RGBA_ASTC_5x5_KHR = $93B2;
  GL_COMPRESSED_RGBA_ASTC_6x5_KHR = $93B3;
  GL_COMPRESSED_RGBA_ASTC_6x6_KHR = $93B4;
  GL_COMPRESSED_RGBA_ASTC_8x5_KHR = $93B5;
  GL_COMPRESSED_RGBA_ASTC_8x6_KHR = $93B6;
  GL_COMPRESSED_RGBA_ASTC_8x8_KHR = $93B7;
  GL_COMPRESSED_RGBA_ASTC_10x5_KHR = $93B8;
  GL_COMPRESSED_RGBA_ASTC_10x6_KHR = $93B9;
  GL_COMPRESSED_RGBA_ASTC_10x8_KHR = $93BA;
  GL_COMPRESSED_RGBA_ASTC_10x10_KHR = $93BB;
  GL_COMPRESSED_RGBA_ASTC_12x10_KHR = $93BC;
  GL_COMPRESSED_RGBA_ASTC_12x12_KHR = $93BD;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = $93D0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = $93D1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = $93D2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = $93D3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = $93D4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = $93D5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = $93D6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = $93D7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = $93D8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = $93D9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = $93DA;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = $93DB;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = $93DC;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = $93DD;
// GL_OES_EGL_image_external
  GL_TEXTURE_EXTERNAL_OES = $8D65;
  GL_TEXTURE_BINDING_EXTERNAL_OES = $8D67;
  GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES = $8D68;
  GL_SAMPLER_EXTERNAL_OES = $8D66;
// GL_OES_compressed_ETC1_RGB8_texture
  GL_ETC1_RGB8_OES = $8D64;
// GL_OES_compressed_paletted_texture
  GL_PALETTE4_RGB8_OES = $8B90;
  GL_PALETTE4_RGBA8_OES = $8B91;
  GL_PALETTE4_R5_G6_B5_OES = $8B92;
  GL_PALETTE4_RGBA4_OES = $8B93;
  GL_PALETTE4_RGB5_A1_OES = $8B94;
  GL_PALETTE8_RGB8_OES = $8B95;
  GL_PALETTE8_RGBA8_OES = $8B96;
  GL_PALETTE8_R5_G6_B5_OES = $8B97;
  GL_PALETTE8_RGBA4_OES = $8B98;
  GL_PALETTE8_RGB5_A1_OES = $8B99;
// GL_OES_depth24
  GL_DEPTH_COMPONENT24_OES = $81A6;
// GL_OES_depth32
  GL_DEPTH_COMPONENT32_OES = $81A7;
// GL_OES_draw_buffers_indexed
  GL_MIN = $8007;
  GL_MAX = $8008;
// GL_OES_geometry_shader
  GL_GEOMETRY_SHADER_OES = $8DD9;
  GL_GEOMETRY_SHADER_BIT_OES = $00000004;
  GL_GEOMETRY_LINKED_VERTICES_OUT_OES = $8916;
  GL_GEOMETRY_LINKED_INPUT_TYPE_OES = $8917;
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES = $8918;
  GL_GEOMETRY_SHADER_INVOCATIONS_OES = $887F;
  GL_LAYER_PROVOKING_VERTEX_OES = $825E;
  GL_LINES_ADJACENCY_OES = $000A;
  GL_LINE_STRIP_ADJACENCY_OES = $000B;
  GL_TRIANGLES_ADJACENCY_OES = $000C;
  GL_TRIANGLE_STRIP_ADJACENCY_OES = $000D;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES = $8A2C;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES = $8A32;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES = $9123;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES = $9124;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES = $8DE0;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES = $8DE1;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES = $8E5A;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES = $8C29;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES = $92CF;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES = $92D5;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES = $90CD;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES = $90D7;
  GL_FIRST_VERTEX_CONVENTION_OES = $8E4D;
  GL_LAST_VERTEX_CONVENTION_OES = $8E4E;
  GL_UNDEFINED_VERTEX_OES = $8260;
  GL_PRIMITIVES_GENERATED_OES = $8C87;
  GL_FRAMEBUFFER_DEFAULT_LAYERS_OES = $9312;
  GL_MAX_FRAMEBUFFER_LAYERS_OES = $9317;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES = $8DA8;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES = $8DA7;
  GL_REFERENCED_BY_GEOMETRY_SHADER_OES = $9309;
// GL_OES_get_program_binary
  GL_PROGRAM_BINARY_LENGTH_OES = $8741;
  GL_NUM_PROGRAM_BINARY_FORMATS_OES = $87FE;
  GL_PROGRAM_BINARY_FORMATS_OES = $87FF;
// GL_OES_mapbuffer
  GL_WRITE_ONLY_OES = $88B9;
  GL_BUFFER_ACCESS_OES = $88BB;
  GL_BUFFER_MAPPED_OES = $88BC;
  GL_BUFFER_MAP_POINTER_OES = $88BD;
// GL_OES_packed_depth_stencil
  GL_DEPTH_STENCIL_OES = $84F9;
  GL_UNSIGNED_INT_24_8_OES = $84FA;
  GL_DEPTH24_STENCIL8_OES = $88F0;
// GL_OES_primitive_bounding_box
  GL_PRIMITIVE_BOUNDING_BOX_OES = $92BE;
// GL_OES_required_internalformat
  GL_ALPHA8_OES = $803C;
  GL_DEPTH_COMPONENT16_OES = $81A5;
  GL_LUMINANCE4_ALPHA4_OES = $8043;
  GL_LUMINANCE8_ALPHA8_OES = $8045;
  GL_LUMINANCE8_OES = $8040;
  GL_RGBA4_OES = $8056;
  GL_RGB5_A1_OES = $8057;
  GL_RGB565_OES = $8D62;
  GL_RGB8_OES = $8051;
  GL_RGBA8_OES = $8058;
  GL_RGB10_EXT = $8052;
  GL_RGB10_A2_EXT = $8059;
// GL_OES_sample_shading
  GL_SAMPLE_SHADING_OES = $8C36;
  GL_MIN_SAMPLE_SHADING_VALUE_OES = $8C37;
// GL_OES_shader_multisample_interpolation
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES = $8E5B;
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES = $8E5C;
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES = $8E5D;
// GL_OES_standard_derivatives
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = $8B8B;
// GL_OES_stencil1
  GL_STENCIL_INDEX1_OES = $8D46;
// GL_OES_stencil4
  GL_STENCIL_INDEX4_OES = $8D47;
// GL_OES_surfaceless_context
  GL_FRAMEBUFFER_UNDEFINED_OES = $8219;
// GL_OES_tessellation_shader
  GL_PATCHES_OES = $000E;
  GL_PATCH_VERTICES_OES = $8E72;
  GL_TESS_CONTROL_OUTPUT_VERTICES_OES = $8E75;
  GL_TESS_GEN_MODE_OES = $8E76;
  GL_TESS_GEN_SPACING_OES = $8E77;
  GL_TESS_GEN_VERTEX_ORDER_OES = $8E78;
  GL_TESS_GEN_POINT_MODE_OES = $8E79;
  GL_ISOLINES_OES = $8E7A;
  GL_QUADS_OES = $0007;
  GL_FRACTIONAL_ODD_OES = $8E7B;
  GL_FRACTIONAL_EVEN_OES = $8E7C;
  GL_MAX_PATCH_VERTICES_OES = $8E7D;
  GL_MAX_TESS_GEN_LEVEL_OES = $8E7E;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES = $8E7F;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = $8E80;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES = $8E81;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES = $8E82;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES = $8E83;
  GL_MAX_TESS_PATCH_COMPONENTS_OES = $8E84;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES = $8E85;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES = $8E86;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES = $8E89;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES = $8E8A;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES = $886C;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES = $886D;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES = $8E1E;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = $8E1F;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES = $92CD;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES = $92CE;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES = $92D3;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES = $92D4;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES = $90CB;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES = $90CC;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES = $90D8;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES = $90D9;
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES = $8221;
  GL_IS_PER_PATCH_OES = $92E7;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_OES = $9307;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES = $9308;
  GL_TESS_CONTROL_SHADER_OES = $8E88;
  GL_TESS_EVALUATION_SHADER_OES = $8E87;
  GL_TESS_CONTROL_SHADER_BIT_OES = $00000008;
  GL_TESS_EVALUATION_SHADER_BIT_OES = $00000010;
// GL_OES_texture_3D
  GL_TEXTURE_WRAP_R_OES = $8072;
  GL_TEXTURE_3D_OES = $806F;
  GL_TEXTURE_BINDING_3D_OES = $806A;
  GL_MAX_3D_TEXTURE_SIZE_OES = $8073;
  GL_SAMPLER_3D_OES = $8B5F;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = $8CD4;
// GL_OES_texture_border_clamp
  GL_TEXTURE_BORDER_COLOR_OES = $1004;
  GL_CLAMP_TO_BORDER_OES = $812D;
// GL_OES_texture_buffer
  GL_TEXTURE_BUFFER_OES = $8C2A;
  GL_TEXTURE_BUFFER_BINDING_OES = $8C2A;
  GL_MAX_TEXTURE_BUFFER_SIZE_OES = $8C2B;
  GL_TEXTURE_BINDING_BUFFER_OES = $8C2C;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES = $8C2D;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES = $919F;
  GL_SAMPLER_BUFFER_OES = $8DC2;
  GL_INT_SAMPLER_BUFFER_OES = $8DD0;
  GL_UNSIGNED_INT_SAMPLER_BUFFER_OES = $8DD8;
  GL_IMAGE_BUFFER_OES = $9051;
  GL_INT_IMAGE_BUFFER_OES = $905C;
  GL_UNSIGNED_INT_IMAGE_BUFFER_OES = $9067;
  GL_TEXTURE_BUFFER_OFFSET_OES = $919D;
  GL_TEXTURE_BUFFER_SIZE_OES = $919E;
 // GL_OES_texture_compression_astc
  GL_COMPRESSED_RGBA_ASTC_3x3x3_OES = $93C0;
  GL_COMPRESSED_RGBA_ASTC_4x3x3_OES = $93C1;
  GL_COMPRESSED_RGBA_ASTC_4x4x3_OES = $93C2;
  GL_COMPRESSED_RGBA_ASTC_4x4x4_OES = $93C3;
  GL_COMPRESSED_RGBA_ASTC_5x4x4_OES = $93C4;
  GL_COMPRESSED_RGBA_ASTC_5x5x4_OES = $93C5;
  GL_COMPRESSED_RGBA_ASTC_5x5x5_OES = $93C6;
  GL_COMPRESSED_RGBA_ASTC_6x5x5_OES = $93C7;
  GL_COMPRESSED_RGBA_ASTC_6x6x5_OES = $93C8;
  GL_COMPRESSED_RGBA_ASTC_6x6x6_OES = $93C9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES = $93E0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES = $93E1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES = $93E2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES = $93E3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES = $93E4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES = $93E5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES = $93E6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES = $93E7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES = $93E8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES = $93E9;
// GL_OES_texture_cube_map_array
  GL_TEXTURE_CUBE_MAP_ARRAY_OES = $9009;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES = $900A;
  GL_SAMPLER_CUBE_MAP_ARRAY_OES = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES = $900D;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES = $900E;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES = $900F;
  GL_IMAGE_CUBE_MAP_ARRAY_OES = $9054;
  GL_INT_IMAGE_CUBE_MAP_ARRAY_OES = $905F;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES = $906A;
// GL_OES_texture_half_float
  GL_HALF_FLOAT_OES = $8D61;
// GL_OES_texture_stencil8
  GL_STENCIL_INDEX_OES = $1901;
  GL_STENCIL_INDEX8_OES = $8D48;
// GL_OES_texture_storage_multisample_2d_array
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES = $9102;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES = $9105;
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910B;
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910C;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910D;
// GL_OES_texture_view
  GL_TEXTURE_VIEW_MIN_LEVEL_OES = $82DB;
  GL_TEXTURE_VIEW_NUM_LEVELS_OES = $82DC;
  GL_TEXTURE_VIEW_MIN_LAYER_OES = $82DD;
  GL_TEXTURE_VIEW_NUM_LAYERS_OES = $82DE;
  GL_TEXTURE_IMMUTABLE_LEVELS = $82DF;
// GL_OES_vertex_array_object
  GL_VERTEX_ARRAY_BINDING_OES = $85B5;
// GL_OES_vertex_type_10_10_10_2
  GL_UNSIGNED_INT_10_10_10_2_OES = $8DF6;
  GL_INT_10_10_10_2_OES = $8DF7;
// GL_OES_viewport_array
  GL_MAX_VIEWPORTS_OES = $825B;
  GL_VIEWPORT_SUBPIXEL_BITS_OES = $825C;
  GL_VIEWPORT_BOUNDS_RANGE_OES = $825D;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = $825F;
// GL_AMD_compressed_3DC_texture
  GL_3DC_X_AMD = $87F9;
  GL_3DC_XY_AMD = $87FA;
// GL_AMD_compressed_ATC_texture
  GL_ATC_RGBA_EXPLICIT_ALPHA_AMD = $8C93;
  GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = $87EE;
// GL_AMD_framebuffer_multisample_advanced
  GL_RENDERBUFFER_STORAGE_SAMPLES_AMD = $91B2;
  GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD = $91B3;
  GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD = $91B4;
  GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD = $91B5;
  GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD = $91B6;
  GL_SUPPORTED_MULTISAMPLE_MODES_AMD = $91B7;
// GL_AMD_performance_monitor
  GL_COUNTER_TYPE_AMD = $8BC0;
  GL_COUNTER_RANGE_AMD = $8BC1;
  GL_UNSIGNED_INT64_AMD = $8BC2;
  GL_PERCENTAGE_AMD = $8BC3;
  GL_PERFMON_RESULT_AVAILABLE_AMD = $8BC4;
  GL_PERFMON_RESULT_SIZE_AMD = $8BC5;
  GL_PERFMON_RESULT_AMD = $8BC6;
// GL_AMD_program_binary_Z400
  GL_Z400_BINARY_AMD = $8740;
// GL_ANGLE_framebuffer_blit
  GL_READ_FRAMEBUFFER_ANGLE = $8CA8;
  GL_DRAW_FRAMEBUFFER_ANGLE = $8CA9;
  GL_DRAW_FRAMEBUFFER_BINDING_ANGLE = $8CA6;
  GL_READ_FRAMEBUFFER_BINDING_ANGLE = $8CAA;
// GL_ANGLE_framebuffer_multisample
  GL_RENDERBUFFER_SAMPLES_ANGLE = $8CAB;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE = $8D56;
  GL_MAX_SAMPLES_ANGLE = $8D57;
// GL_ANGLE_instanced_arrays
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = $88FE;
// GL_ANGLE_pack_reverse_row_order
  GL_PACK_REVERSE_ROW_ORDER_ANGLE = $93A4;
// GL_ANGLE_program_binary
  GL_PROGRAM_BINARY_ANGLE = $93A6;
// GL_ANGLE_texture_compression_dxt3
  GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE = $83F2;
// GL_ANGLE_texture_compression_dxt5
  GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE = $83F3;
// GL_ANGLE_texture_usage
  GL_FRAMEBUFFER_ATTACHMENT_ANGLE = $93A3;
// GL_ANGLE_translated_shader_source
  GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = $93A0;
// GL_APPLE_clip_distance
  GL_MAX_CLIP_DISTANCES_APPLE = $0D32;
  GL_CLIP_DISTANCE0_APPLE = $3000;
  GL_CLIP_DISTANCE1_APPLE = $3001;
  GL_CLIP_DISTANCE2_APPLE = $3002;
  GL_CLIP_DISTANCE3_APPLE = $3003;
  GL_CLIP_DISTANCE4_APPLE = $3004;
  GL_CLIP_DISTANCE5_APPLE = $3005;
  GL_CLIP_DISTANCE6_APPLE = $3006;
  GL_CLIP_DISTANCE7_APPLE = $3007;
// GL_APPLE_framebuffer_multisample
  GL_RENDERBUFFER_SAMPLES_APPLE = $8CAB;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE = $8D56;
  GL_MAX_SAMPLES_APPLE = $8D57;
  GL_READ_FRAMEBUFFER_APPLE = $8CA8;
  GL_DRAW_FRAMEBUFFER_APPLE = $8CA9;
  GL_DRAW_FRAMEBUFFER_BINDING_APPLE = $8CA6;
  GL_READ_FRAMEBUFFER_BINDING_APPLE = $8CAA;
// GL_APPLE_rgb_422
  GL_RGB_422_APPLE = $8A1F;
  GL_UNSIGNED_SHORT_8_8_APPLE = $85BA;
  GL_UNSIGNED_SHORT_8_8_REV_APPLE = $85BB;
  GL_RGB_RAW_422_APPLE = $8A51;
// GL_APPLE_sync
  GL_SYNC_OBJECT_APPLE = $8A53;
  GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = $9111;
  GL_OBJECT_TYPE_APPLE = $9112;
  GL_SYNC_CONDITION_APPLE = $9113;
  GL_SYNC_STATUS_APPLE = $9114;
  GL_SYNC_FLAGS_APPLE = $9115;
  GL_SYNC_FENCE_APPLE = $9116;
  GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = $9117;
  GL_UNSIGNALED_APPLE = $9118;
  GL_SIGNALED_APPLE = $9119;
  GL_ALREADY_SIGNALED_APPLE = $911A;
  GL_TIMEOUT_EXPIRED_APPLE = $911B;
  GL_CONDITION_SATISFIED_APPLE = $911C;
  GL_WAIT_FAILED_APPLE = $911D;
  GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = $00000001;
  GL_TIMEOUT_IGNORED_APPLE = $FFFFFFFFFFFFFFFF;
// GL_APPLE_texture_format_BGRA8888
  GL_BGRA_EXT = $80E1;
  GL_BGRA8_EXT = $93A1;
// GL_APPLE_texture_max_level
  GL_TEXTURE_MAX_LEVEL_APPLE = $813D;
// GL_APPLE_texture_packed_float
  GL_UNSIGNED_INT_10F_11F_11F_REV_APPLE = $8C3B;
  GL_UNSIGNED_INT_5_9_9_9_REV_APPLE = $8C3E;
  GL_R11F_G11F_B10F_APPLE = $8C3A;
  GL_RGB9_E5_APPLE = $8C3D;
// GL_ARM_mali_program_binary
  GL_MALI_PROGRAM_BINARY_ARM = $8F61;
// GL_ARM_mali_shader_binary
  GL_MALI_SHADER_BINARY_ARM = $8F60;
// GL_ARM_shader_framebuffer_fetch
  GL_FETCH_PER_SAMPLE_ARM = $8F65;
  GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM = $8F66;
// GL_DMP_program_binary
  GL_SMAPHS30_PROGRAM_BINARY_DMP = $9251;
  GL_SMAPHS_PROGRAM_BINARY_DMP = $9252;
  GL_DMP_PROGRAM_BINARY_DMP = $9253;
// GL_DMP_shader_binary
  GL_SHADER_BINARY_DMP = $9250;
// GL_EXT_EGL_image_storage_compression
  GL_SURFACE_COMPRESSION_EXT = $96C0;
  GL_SURFACE_COMPRESSION_FIXED_RATE_NONE_EXT = $96C1;
  GL_SURFACE_COMPRESSION_FIXED_RATE_DEFAULT_EXT = $96C2;
// GL_EXT_YUV_target
  GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = $8BE7;
// GL_EXT_blend_func_extended
  GL_SRC1_COLOR_EXT = $88F9;
  GL_SRC1_ALPHA_EXT = $8589;
  GL_ONE_MINUS_SRC1_COLOR_EXT = $88FA;
  GL_ONE_MINUS_SRC1_ALPHA_EXT = $88FB;
  GL_SRC_ALPHA_SATURATE_EXT = $0308;
  GL_LOCATION_INDEX_EXT = $930F;
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = $88FC;
// GL_EXT_blend_minmax
  GL_MIN_EXT = $8007;
  GL_MAX_EXT = $8008;
// GL_EXT_buffer_storage
  GL_MAP_READ_BIT = $0001;
  GL_MAP_WRITE_BIT = $0002;
  GL_MAP_PERSISTENT_BIT_EXT = $0040;
  GL_MAP_COHERENT_BIT_EXT = $0080;
  GL_DYNAMIC_STORAGE_BIT_EXT = $0100;
  GL_CLIENT_STORAGE_BIT_EXT = $0200;
  GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = $00004000;
  GL_BUFFER_IMMUTABLE_STORAGE_EXT = $821F;
  GL_BUFFER_STORAGE_FLAGS_EXT = $8220;
// GL_EXT_clip_control
  GL_LOWER_LEFT_EXT = $8CA1;
  GL_UPPER_LEFT_EXT = $8CA2;
  GL_NEGATIVE_ONE_TO_ONE_EXT = $935E;
  GL_ZERO_TO_ONE_EXT = $935F;
  GL_CLIP_ORIGIN_EXT = $935C;
  GL_CLIP_DEPTH_MODE_EXT = $935D;
// GL_EXT_clip_cull_distance
  GL_MAX_CLIP_DISTANCES_EXT = $0D32;
  GL_MAX_CULL_DISTANCES_EXT = $82F9;
  GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT = $82FA;
  GL_CLIP_DISTANCE0_EXT = $3000;
  GL_CLIP_DISTANCE1_EXT = $3001;
  GL_CLIP_DISTANCE2_EXT = $3002;
  GL_CLIP_DISTANCE3_EXT = $3003;
  GL_CLIP_DISTANCE4_EXT = $3004;
  GL_CLIP_DISTANCE5_EXT = $3005;
  GL_CLIP_DISTANCE6_EXT = $3006;
  GL_CLIP_DISTANCE7_EXT = $3007;
// GL_EXT_color_buffer_half_float
  GL_RGBA16F_EXT = $881A;
  GL_RGB16F_EXT = $881B;
  GL_RG16F_EXT = $822F;
  GL_R16F_EXT = $822D;
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT = $8211;
  GL_UNSIGNED_NORMALIZED_EXT = $8C17;
// GL_EXT_debug_label
  GL_PROGRAM_PIPELINE_OBJECT_EXT = $8A4F;
  GL_PROGRAM_OBJECT_EXT = $8B40;
  GL_SHADER_OBJECT_EXT = $8B48;
  GL_BUFFER_OBJECT_EXT = $9151;
  GL_QUERY_OBJECT_EXT = $9153;
  GL_VERTEX_ARRAY_OBJECT_EXT = $9154;
  GL_TRANSFORM_FEEDBACK = $8E22;
// GL_EXT_depth_clamp
  GL_DEPTH_CLAMP_EXT = $864F;
// GL_EXT_discard_framebuffer
  GL_COLOR_EXT = $1800;
  GL_DEPTH_EXT = $1801;
  GL_STENCIL_EXT = $1802;
// GL_EXT_disjoint_timer_query
  GL_QUERY_COUNTER_BITS_EXT = $8864;
  GL_CURRENT_QUERY_EXT = $8865;
  GL_QUERY_RESULT_EXT = $8866;
  GL_QUERY_RESULT_AVAILABLE_EXT = $8867;
  GL_TIME_ELAPSED_EXT = $88BF;
  GL_TIMESTAMP_EXT = $8E28;
  GL_GPU_DISJOINT_EXT = $8FBB;
// GL_EXT_draw_buffers
  GL_MAX_COLOR_ATTACHMENTS_EXT = $8CDF;
  GL_MAX_DRAW_BUFFERS_EXT = $8824;
  GL_DRAW_BUFFER0_EXT = $8825;
  GL_DRAW_BUFFER1_EXT = $8826;
  GL_DRAW_BUFFER2_EXT = $8827;
  GL_DRAW_BUFFER3_EXT = $8828;
  GL_DRAW_BUFFER4_EXT = $8829;
  GL_DRAW_BUFFER5_EXT = $882A;
  GL_DRAW_BUFFER6_EXT = $882B;
  GL_DRAW_BUFFER7_EXT = $882C;
  GL_DRAW_BUFFER8_EXT = $882D;
  GL_DRAW_BUFFER9_EXT = $882E;
  GL_DRAW_BUFFER10_EXT = $882F;
  GL_DRAW_BUFFER11_EXT = $8830;
  GL_DRAW_BUFFER12_EXT = $8831;
  GL_DRAW_BUFFER13_EXT = $8832;
  GL_DRAW_BUFFER14_EXT = $8833;
  GL_DRAW_BUFFER15_EXT = $8834;
  GL_COLOR_ATTACHMENT0_EXT = $8CE0;
  GL_COLOR_ATTACHMENT1_EXT = $8CE1;
  GL_COLOR_ATTACHMENT2_EXT = $8CE2;
  GL_COLOR_ATTACHMENT3_EXT = $8CE3;
  GL_COLOR_ATTACHMENT4_EXT = $8CE4;
  GL_COLOR_ATTACHMENT5_EXT = $8CE5;
  GL_COLOR_ATTACHMENT6_EXT = $8CE6;
  GL_COLOR_ATTACHMENT7_EXT = $8CE7;
  GL_COLOR_ATTACHMENT8_EXT = $8CE8;
  GL_COLOR_ATTACHMENT9_EXT = $8CE9;
  GL_COLOR_ATTACHMENT10_EXT = $8CEA;
  GL_COLOR_ATTACHMENT11_EXT = $8CEB;
  GL_COLOR_ATTACHMENT12_EXT = $8CEC;
  GL_COLOR_ATTACHMENT13_EXT = $8CED;
  GL_COLOR_ATTACHMENT14_EXT = $8CEE;
  GL_COLOR_ATTACHMENT15_EXT = $8CEF;
{$IfDef GL_EXT_external_buffer}
type
  GLeglClientBufferEXT = pointer;
{$EndIf}

const
// GL_EXT_fragment_shading_rate
  GL_SHADING_RATE_1X1_PIXELS_EXT = $96A6;
  GL_SHADING_RATE_1X2_PIXELS_EXT = $96A7;
  GL_SHADING_RATE_2X1_PIXELS_EXT = $96A8;
  GL_SHADING_RATE_2X2_PIXELS_EXT = $96A9;
  GL_SHADING_RATE_1X4_PIXELS_EXT = $96AA;
  GL_SHADING_RATE_4X1_PIXELS_EXT = $96AB;
  GL_SHADING_RATE_4X2_PIXELS_EXT = $96AC;
  GL_SHADING_RATE_2X4_PIXELS_EXT = $96AD;
  GL_SHADING_RATE_4X4_PIXELS_EXT = $96AE;
  GL_SHADING_RATE_EXT = $96D0;
  GL_SHADING_RATE_ATTACHMENT_EXT = $96D1;
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_EXT = $96D2;
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_EXT = $96D3;
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_EXT = $96D4;
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_EXT = $96D5;
  GL_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_EXT = $96D6;
  GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT = $96D7;
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_WIDTH_EXT = $96D8;
  GL_MIN_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT = $96D9;
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_HEIGHT_EXT = $96DA;
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_TEXEL_ASPECT_RATIO_EXT = $96DB;
  GL_MAX_FRAGMENT_SHADING_RATE_ATTACHMENT_LAYERS_EXT = $96DC;
  GL_FRAGMENT_SHADING_RATE_WITH_SHADER_DEPTH_STENCIL_WRITES_SUPPORTED_EXT = $96DD;
  GL_FRAGMENT_SHADING_RATE_WITH_SAMPLE_MASK_SUPPORTED_EXT = $96DE;
  GL_FRAGMENT_SHADING_RATE_ATTACHMENT_WITH_DEFAULT_FRAMEBUFFER_SUPPORTED_EXT = $96DF;
  GL_FRAGMENT_SHADING_RATE_NON_TRIVIAL_COMBINERS_SUPPORTED_EXT = $8F6F;
// GL_EXT_geometry_shader
  GL_GEOMETRY_SHADER_EXT = $8DD9;
  GL_GEOMETRY_SHADER_BIT_EXT = $00000004;
  GL_GEOMETRY_LINKED_VERTICES_OUT_EXT = $8916;
  GL_GEOMETRY_LINKED_INPUT_TYPE_EXT = $8917;
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT = $8918;
  GL_GEOMETRY_SHADER_INVOCATIONS_EXT = $887F;
  GL_LAYER_PROVOKING_VERTEX_EXT = $825E;
  GL_LINES_ADJACENCY_EXT = $000A;
  GL_LINE_STRIP_ADJACENCY_EXT = $000B;
  GL_TRIANGLES_ADJACENCY_EXT = $000C;
  GL_TRIANGLE_STRIP_ADJACENCY_EXT = $000D;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT = $8A2C;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT = $8A32;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT = $9123;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT = $9124;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = $8DE0;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = $8DE1;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT = $8E5A;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = $8C29;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT = $92CF;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT = $92D5;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT = $90CD;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT = $90D7;
  GL_FIRST_VERTEX_CONVENTION_EXT = $8E4D;
  GL_LAST_VERTEX_CONVENTION_EXT = $8E4E;
  GL_UNDEFINED_VERTEX_EXT = $8260;
  GL_PRIMITIVES_GENERATED_EXT = $8C87;
  GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT = $9312;
  GL_MAX_FRAMEBUFFER_LAYERS_EXT = $9317;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = $8DA8;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = $8DA7;
  GL_REFERENCED_BY_GEOMETRY_SHADER_EXT = $9309;
// GL_EXT_instanced_arrays
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = $88FE;
// GL_EXT_map_buffer_range
  GL_MAP_READ_BIT_EXT = $0001;
  GL_MAP_WRITE_BIT_EXT = $0002;
  GL_MAP_INVALIDATE_RANGE_BIT_EXT = $0004;
  GL_MAP_INVALIDATE_BUFFER_BIT_EXT = $0008;
  GL_MAP_FLUSH_EXPLICIT_BIT_EXT = $0010;
  GL_MAP_UNSYNCHRONIZED_BIT_EXT = $0020;
// GL_EXT_memory_object
  GL_TEXTURE_TILING_EXT = $9580;
  GL_DEDICATED_MEMORY_OBJECT_EXT = $9581;
  GL_PROTECTED_MEMORY_OBJECT_EXT = $959B;
  GL_NUM_TILING_TYPES_EXT = $9582;
  GL_TILING_TYPES_EXT = $9583;
  GL_OPTIMAL_TILING_EXT = $9584;
  GL_LINEAR_TILING_EXT = $9585;
  GL_NUM_DEVICE_UUIDS_EXT = $9596;
  GL_DEVICE_UUID_EXT = $9597;
  GL_DRIVER_UUID_EXT = $9598;
  GL_UUID_SIZE_EXT = 16;
// GL_EXT_memory_object_fd
  GL_HANDLE_TYPE_OPAQUE_FD_EXT = $9586;
// GL_EXT_memory_object_win32
  GL_HANDLE_TYPE_OPAQUE_WIN32_EXT = $9587;
  GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT = $9588;
  GL_DEVICE_LUID_EXT = $9599;
  GL_DEVICE_NODE_MASK_EXT = $959A;
  GL_LUID_SIZE_EXT = 8;
  GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT = $9589;
  GL_HANDLE_TYPE_D3D12_RESOURCE_EXT = $958A;
  GL_HANDLE_TYPE_D3D11_IMAGE_EXT = $958B;
  GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT = $958C;
// GL_EXT_multisampled_compatibility
  GL_MULTISAMPLE_EXT = $809D;
  GL_SAMPLE_ALPHA_TO_ONE_EXT = $809F;
// GL_EXT_multisampled_render_to_texture
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT = $8D6C;
  GL_RENDERBUFFER_SAMPLES_EXT = $8CAB;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = $8D56;
  GL_MAX_SAMPLES_EXT = $8D57;
// GL_EXT_multiview_draw_buffers
  GL_COLOR_ATTACHMENT_EXT = $90F0;
  GL_MULTIVIEW_EXT = $90F1;
  GL_DRAW_BUFFER_EXT = $0C01;
  GL_READ_BUFFER_EXT = $0C02;
  GL_MAX_MULTIVIEW_BUFFERS_EXT = $90F2;
// GL_EXT_occlusion_query_boolean
  GL_ANY_SAMPLES_PASSED_EXT = $8C2F;
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = $8D6A;
// GL_EXT_polygon_offset_clamp
  GL_POLYGON_OFFSET_CLAMP_EXT = $8E1B;
// GL_EXT_primitive_bounding_box
  GL_PRIMITIVE_BOUNDING_BOX_EXT = $92BE;
// GL_EXT_protected_textures
  GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT = $00000010;
  GL_TEXTURE_PROTECTED_EXT = $8BFA;
// GL_EXT_pvrtc_sRGB
  GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT = $8A54;
  GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT = $8A55;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT = $8A56;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT = $8A57;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG = $93F0;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG = $93F1;
// GL_EXT_raster_multisample
  GL_RASTER_MULTISAMPLE_EXT = $9327;
  GL_RASTER_SAMPLES_EXT = $9328;
  GL_MAX_RASTER_SAMPLES_EXT = $9329;
  GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = $932A;
  GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = $932B;
  GL_EFFECTIVE_RASTER_SAMPLES_EXT = $932C;
// GL_EXT_read_format_bgra
  GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT = $8365;
  GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT = $8366;
// GL_EXT_render_snorm
  GL_R8_SNORM = $8F94;
  GL_RG8_SNORM = $8F95;
  GL_RGBA8_SNORM = $8F97;
  GL_R16_SNORM_EXT = $8F98;
  GL_RG16_SNORM_EXT = $8F99;
  GL_RGBA16_SNORM_EXT = $8F9B;
// GL_EXT_robustness
  GL_GUILTY_CONTEXT_RESET_EXT = $8253;
  GL_INNOCENT_CONTEXT_RESET_EXT = $8254;
  GL_UNKNOWN_CONTEXT_RESET_EXT = $8255;
  GL_CONTEXT_ROBUST_ACCESS_EXT = $90F3;
  GL_RESET_NOTIFICATION_STRATEGY_EXT = $8256;
  GL_LOSE_CONTEXT_ON_RESET_EXT = $8252;
  GL_NO_RESET_NOTIFICATION_EXT = $8261;
// GL_EXT_sRGB
  GL_SRGB_EXT = $8C40;
  GL_SRGB_ALPHA_EXT = $8C42;
  GL_SRGB8_ALPHA8_EXT = $8C43;
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT = $8210;
// GL_EXT_sRGB_write_control
  GL_FRAMEBUFFER_SRGB_EXT = $8DB9;
// GL_EXT_semaphore
  GL_LAYOUT_GENERAL_EXT = $958D;
  GL_LAYOUT_COLOR_ATTACHMENT_EXT = $958E;
  GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = $958F;
  GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = $9590;
  GL_LAYOUT_SHADER_READ_ONLY_EXT = $9591;
  GL_LAYOUT_TRANSFER_SRC_EXT = $9592;
  GL_LAYOUT_TRANSFER_DST_EXT = $9593;
  GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT = $9530;
  GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT = $9531;
// GL_EXT_semaphore_win32
  GL_HANDLE_TYPE_D3D12_FENCE_EXT = $9594;
  GL_D3D12_FENCE_VALUE_EXT = $9595;
// GL_EXT_separate_shader_objects
  GL_ACTIVE_PROGRAM_EXT = $8259;
  GL_VERTEX_SHADER_BIT_EXT = $00000001;
  GL_FRAGMENT_SHADER_BIT_EXT = $00000002;
  GL_ALL_SHADER_BITS_EXT = $FFFFFFFF;
  GL_PROGRAM_SEPARABLE_EXT = $8258;
  GL_PROGRAM_PIPELINE_BINDING_EXT = $825A;
// GL_EXT_shader_framebuffer_fetch
  GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = $8A52;
// GL_EXT_shader_pixel_local_storage
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT = $8F63;
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT = $8F67;
  GL_SHADER_PIXEL_LOCAL_STORAGE_EXT = $8F64;
// GL_EXT_shader_pixel_local_storage2
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT = $9650;
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT = $9651;
  GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT = $9652;
// GL_EXT_shadow_samplers
  GL_TEXTURE_COMPARE_MODE_EXT = $884C;
  GL_TEXTURE_COMPARE_FUNC_EXT = $884D;
  GL_COMPARE_REF_TO_TEXTURE_EXT = $884E;
  GL_SAMPLER_2D_SHADOW_EXT = $8B62;
// GL_EXT_sparse_texture
  GL_TEXTURE_SPARSE_EXT = $91A6;
  GL_VIRTUAL_PAGE_SIZE_INDEX_EXT = $91A7;
  GL_NUM_SPARSE_LEVELS_EXT = $91AA;
  GL_NUM_VIRTUAL_PAGE_SIZES_EXT = $91A8;
  GL_VIRTUAL_PAGE_SIZE_X_EXT = $9195;
  GL_VIRTUAL_PAGE_SIZE_Y_EXT = $9196;
  GL_VIRTUAL_PAGE_SIZE_Z_EXT = $9197;
  GL_TEXTURE_2D_ARRAY = $8C1A;
  GL_TEXTURE_3D = $806F;
  GL_MAX_SPARSE_TEXTURE_SIZE_EXT = $9198;
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT = $9199;
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT = $919A;
  GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT = $91A9;
// GL_EXT_tessellation_shader
  GL_PATCHES_EXT = $000E;
  GL_PATCH_VERTICES_EXT = $8E72;
  GL_TESS_CONTROL_OUTPUT_VERTICES_EXT = $8E75;
  GL_TESS_GEN_MODE_EXT = $8E76;
  GL_TESS_GEN_SPACING_EXT = $8E77;
  GL_TESS_GEN_VERTEX_ORDER_EXT = $8E78;
  GL_TESS_GEN_POINT_MODE_EXT = $8E79;
  GL_ISOLINES_EXT = $8E7A;
  GL_QUADS_EXT = $0007;
  GL_FRACTIONAL_ODD_EXT = $8E7B;
  GL_FRACTIONAL_EVEN_EXT = $8E7C;
  GL_MAX_PATCH_VERTICES_EXT = $8E7D;
  GL_MAX_TESS_GEN_LEVEL_EXT = $8E7E;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = $8E7F;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = $8E80;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT = $8E81;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT = $8E82;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT = $8E83;
  GL_MAX_TESS_PATCH_COMPONENTS_EXT = $8E84;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT = $8E85;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT = $8E86;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT = $8E89;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT = $8E8A;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT = $886C;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT = $886D;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = $8E1E;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = $8E1F;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT = $92CD;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT = $92CE;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT = $92D3;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT = $92D4;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT = $90CB;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT = $90CC;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT = $90D8;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT = $90D9;
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = $8221;
  GL_IS_PER_PATCH_EXT = $92E7;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT = $9307;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT = $9308;
  GL_TESS_CONTROL_SHADER_EXT = $8E88;
  GL_TESS_EVALUATION_SHADER_EXT = $8E87;
  GL_TESS_CONTROL_SHADER_BIT_EXT = $00000008;
  GL_TESS_EVALUATION_SHADER_BIT_EXT = $00000010;
// GL_EXT_texture_border_clamp
  GL_TEXTURE_BORDER_COLOR_EXT = $1004;
  GL_CLAMP_TO_BORDER_EXT = $812D;
// GL_EXT_texture_buffer
  GL_TEXTURE_BUFFER_EXT = $8C2A;
  GL_TEXTURE_BUFFER_BINDING_EXT = $8C2A;
  GL_MAX_TEXTURE_BUFFER_SIZE_EXT = $8C2B;
  GL_TEXTURE_BINDING_BUFFER_EXT = $8C2C;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = $8C2D;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT = $919F;
  GL_SAMPLER_BUFFER_EXT = $8DC2;
  GL_INT_SAMPLER_BUFFER_EXT = $8DD0;
  GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = $8DD8;
  GL_IMAGE_BUFFER_EXT = $9051;
  GL_INT_IMAGE_BUFFER_EXT = $905C;
  GL_UNSIGNED_INT_IMAGE_BUFFER_EXT = $9067;
  GL_TEXTURE_BUFFER_OFFSET_EXT = $919D;
  GL_TEXTURE_BUFFER_SIZE_EXT = $919E;
// GL_EXT_texture_compression_astc_decode_mode
  GL_TEXTURE_ASTC_DECODE_PRECISION_EXT = $8F69;
// GL_EXT_texture_compression_bptc
  GL_COMPRESSED_RGBA_BPTC_UNORM_EXT = $8E8C;
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT = $8E8D;
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT = $8E8E;
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT = $8E8F;
// GL_EXT_texture_compression_dxt1
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT = $83F0;
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
// GL_EXT_texture_compression_rgtc
  GL_COMPRESSED_RED_RGTC1_EXT = $8DBB;
  GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = $8DBC;
  GL_COMPRESSED_RED_GREEN_RGTC2_EXT = $8DBD;
  GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = $8DBE;
// GL_EXT_texture_compression_s3tc
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;
// GL_EXT_texture_compression_s3tc_srgb
  GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = $8C4C;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = $8C4D;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = $8C4E;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = $8C4F;
// GL_EXT_texture_cube_map_array
  GL_TEXTURE_CUBE_MAP_ARRAY_EXT = $9009;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT = $900A;
  GL_SAMPLER_CUBE_MAP_ARRAY_EXT = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT = $900D;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = $900E;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = $900F;
  GL_IMAGE_CUBE_MAP_ARRAY_EXT = $9054;
  GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT = $905F;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = $906A;
// GL_EXT_texture_filter_anisotropic
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;
// GL_EXT_texture_filter_minmax
  GL_TEXTURE_REDUCTION_MODE_EXT = $9366;
  GL_WEIGHTED_AVERAGE_EXT = $9367;
// GL_EXT_texture_format_sRGB_override
  GL_TEXTURE_FORMAT_SRGB_OVERRIDE_EXT = $8FBF;
// GL_EXT_texture_mirror_clamp_to_edge
  GL_MIRROR_CLAMP_TO_EDGE_EXT = $8743;
// GL_EXT_texture_norm16
  GL_R16_EXT = $822A;
  GL_RG16_EXT = $822C;
  GL_RGBA16_EXT = $805B;
  GL_RGB16_EXT = $8054;
  GL_RGB16_SNORM_EXT = $8F9A;
// GL_EXT_texture_rg
  GL_RED_EXT = $1903;
  GL_RG_EXT = $8227;
  GL_R8_EXT = $8229;
  GL_RG8_EXT = $822B;
// GL_EXT_texture_sRGB_R8
  GL_SR8_EXT = $8FBD;
// GL_EXT_texture_sRGB_RG8
  GL_SRG8_EXT = $8FBE;
// GL_EXT_texture_sRGB_decode
  GL_TEXTURE_SRGB_DECODE_EXT = $8A48;
  GL_DECODE_EXT = $8A49;
  GL_SKIP_DECODE_EXT = $8A4A;
// GL_EXT_texture_storage
  GL_TEXTURE_IMMUTABLE_FORMAT_EXT = $912F;
  GL_ALPHA8_EXT = $803C;
  GL_LUMINANCE8_EXT = $8040;
  GL_LUMINANCE8_ALPHA8_EXT = $8045;
  GL_RGBA32F_EXT = $8814;
  GL_RGB32F_EXT = $8815;
  GL_ALPHA32F_EXT = $8816;
  GL_LUMINANCE32F_EXT = $8818;
  GL_LUMINANCE_ALPHA32F_EXT = $8819;
  GL_ALPHA16F_EXT = $881C;
  GL_LUMINANCE16F_EXT = $881E;
  GL_LUMINANCE_ALPHA16F_EXT = $881F;
  GL_R32F_EXT = $822E;
  GL_RG32F_EXT = $8230;
// GL_EXT_texture_storage_compression
  GL_NUM_SURFACE_COMPRESSION_FIXED_RATES_EXT = $8F6E;
  GL_SURFACE_COMPRESSION_FIXED_RATE_1BPC_EXT = $96C4;
  GL_SURFACE_COMPRESSION_FIXED_RATE_2BPC_EXT = $96C5;
  GL_SURFACE_COMPRESSION_FIXED_RATE_3BPC_EXT = $96C6;
  GL_SURFACE_COMPRESSION_FIXED_RATE_4BPC_EXT = $96C7;
  GL_SURFACE_COMPRESSION_FIXED_RATE_5BPC_EXT = $96C8;
  GL_SURFACE_COMPRESSION_FIXED_RATE_6BPC_EXT = $96C9;
  GL_SURFACE_COMPRESSION_FIXED_RATE_7BPC_EXT = $96CA;
  GL_SURFACE_COMPRESSION_FIXED_RATE_8BPC_EXT = $96CB;
  GL_SURFACE_COMPRESSION_FIXED_RATE_9BPC_EXT = $96CC;
  GL_SURFACE_COMPRESSION_FIXED_RATE_10BPC_EXT = $96CD;
  GL_SURFACE_COMPRESSION_FIXED_RATE_11BPC_EXT = $96CE;
  GL_SURFACE_COMPRESSION_FIXED_RATE_12BPC_EXT = $96CF;
// GL_EXT_texture_type_2_10_10_10_REV
  GL_UNSIGNED_INT_2_10_10_10_REV_EXT = $8368;
// GL_EXT_texture_view
  GL_TEXTURE_VIEW_MIN_LEVEL_EXT = $82DB;
  GL_TEXTURE_VIEW_NUM_LEVELS_EXT = $82DC;
  GL_TEXTURE_VIEW_MIN_LAYER_EXT = $82DD;
  GL_TEXTURE_VIEW_NUM_LAYERS_EXT = $82DE;
// GL_EXT_unpack_subimage
  GL_UNPACK_ROW_LENGTH_EXT = $0CF2;
  GL_UNPACK_SKIP_ROWS_EXT = $0CF3;
  GL_UNPACK_SKIP_PIXELS_EXT = $0CF4;
// GL_EXT_window_rectangles
  GL_INCLUSIVE_EXT = $8F10;
  GL_EXCLUSIVE_EXT = $8F11;
  GL_WINDOW_RECTANGLE_EXT = $8F12;
  GL_WINDOW_RECTANGLE_MODE_EXT = $8F13;
  GL_MAX_WINDOW_RECTANGLES_EXT = $8F14;
  GL_NUM_WINDOW_RECTANGLES_EXT = $8F15;
// GL_FJ_shader_binary_GCCSO
  GL_GCCSO_SHADER_BINARY_FJ = $9260;
// GL_IMG_framebuffer_downsample
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG = $913C;
  GL_NUM_DOWNSAMPLE_SCALES_IMG = $913D;
  GL_DOWNSAMPLE_SCALES_IMG = $913E;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG = $913F;
// GL_IMG_multisampled_render_to_texture
  GL_RENDERBUFFER_SAMPLES_IMG = $9133;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG = $9134;
  GL_MAX_SAMPLES_IMG = $9135;
  GL_TEXTURE_SAMPLES_IMG = $9136;
// GL_IMG_program_binary
  GL_SGX_PROGRAM_BINARY_IMG = $9130;
// GL_IMG_read_format
  GL_BGRA_IMG = $80E1;
  GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG = $8365;
// GL_IMG_shader_binary
  GL_SGX_BINARY_IMG = $8C0A;
// GL_IMG_texture_compression_pvrtc
  GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = $8C00;
  GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = $8C01;
  GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = $8C02;
  GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = $8C03;
// GL_IMG_texture_compression_pvrtc2
  GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG = $9137;
  GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG = $9138;
// GL_IMG_texture_filter_cubic
  GL_CUBIC_IMG = $9139;
  GL_CUBIC_MIPMAP_NEAREST_IMG = $913A;
  GL_CUBIC_MIPMAP_LINEAR_IMG = $913B;
// GL_INTEL_blackhole_render
  GL_BLACKHOLE_RENDER_INTEL = $83FC;
// GL_INTEL_conservative_rasterization
  GL_CONSERVATIVE_RASTERIZATION_INTEL = $83FE;
// GL_INTEL_performance_query
  GL_PERFQUERY_SINGLE_CONTEXT_INTEL = $00000000;
  GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = $00000001;
  GL_PERFQUERY_WAIT_INTEL = $83FB;
  GL_PERFQUERY_FLUSH_INTEL = $83FA;
  GL_PERFQUERY_DONOT_FLUSH_INTEL = $83F9;
  GL_PERFQUERY_COUNTER_EVENT_INTEL = $94F0;
  GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = $94F1;
  GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = $94F2;
  GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = $94F3;
  GL_PERFQUERY_COUNTER_RAW_INTEL = $94F4;
  GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = $94F5;
  GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = $94F8;
  GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = $94F9;
  GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = $94FA;
  GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = $94FB;
  GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = $94FC;
  GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = $94FD;
  GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = $94FE;
  GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = $94FF;
  GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = $9500;
// GL_MESA_bgra
  GL_BGR_EXT = $80E0;
// GL_MESA_framebuffer_flip_x
  GL_FRAMEBUFFER_FLIP_X_MESA = $8BBC;
// GL_MESA_framebuffer_flip_y
  GL_FRAMEBUFFER_FLIP_Y_MESA = $8BBB;
// GL_MESA_framebuffer_swap_xy
  GL_FRAMEBUFFER_SWAP_XY_MESA = $8BBD;
// GL_MESA_program_binary_formats
  GL_PROGRAM_BINARY_FORMAT_MESA = $875F;
// GL_NV_blend_equation_advanced
  GL_BLEND_OVERLAP_NV = $9281;
  GL_BLEND_PREMULTIPLIED_SRC_NV = $9280;
  GL_BLUE_NV = $1905;
  GL_COLORBURN_NV = $929A;
  GL_COLORDODGE_NV = $9299;
  GL_CONJOINT_NV = $9284;
  GL_CONTRAST_NV = $92A1;
  GL_DARKEN_NV = $9297;
  GL_DIFFERENCE_NV = $929E;
  GL_DISJOINT_NV = $9283;
  GL_DST_ATOP_NV = $928F;
  GL_DST_IN_NV = $928B;
  GL_DST_NV = $9287;
  GL_DST_OUT_NV = $928D;
  GL_DST_OVER_NV = $9289;
  GL_EXCLUSION_NV = $92A0;
  GL_GREEN_NV = $1904;
  GL_HARDLIGHT_NV = $929B;
  GL_HARDMIX_NV = $92A9;
  GL_HSL_COLOR_NV = $92AF;
  GL_HSL_HUE_NV = $92AD;
  GL_HSL_LUMINOSITY_NV = $92B0;
  GL_HSL_SATURATION_NV = $92AE;
  GL_INVERT_OVG_NV = $92B4;
  GL_INVERT_RGB_NV = $92A3;
  GL_LIGHTEN_NV = $9298;
  GL_LINEARBURN_NV = $92A5;
  GL_LINEARDODGE_NV = $92A4;
  GL_LINEARLIGHT_NV = $92A7;
  GL_MINUS_CLAMPED_NV = $92B3;
  GL_MINUS_NV = $929F;
  GL_MULTIPLY_NV = $9294;
  GL_OVERLAY_NV = $9296;
  GL_PINLIGHT_NV = $92A8;
  GL_PLUS_CLAMPED_ALPHA_NV = $92B2;
  GL_PLUS_CLAMPED_NV = $92B1;
  GL_PLUS_DARKER_NV = $9292;
  GL_PLUS_NV = $9291;
  GL_RED_NV = $1903;
  GL_SCREEN_NV = $9295;
  GL_SOFTLIGHT_NV = $929C;
  GL_SRC_ATOP_NV = $928E;
  GL_SRC_IN_NV = $928A;
  GL_SRC_NV = $9286;
  GL_SRC_OUT_NV = $928C;
  GL_SRC_OVER_NV = $9288;
  GL_UNCORRELATED_NV = $9282;
  GL_VIVIDLIGHT_NV = $92A6;
  GL_XOR_NV = $1506;
// GL_NV_blend_equation_advanced_coherent
  GL_BLEND_ADVANCED_COHERENT_NV = $9285;
// GL_NV_blend_minmax_factor
  GL_FACTOR_MIN_AMD = $901C;
  GL_FACTOR_MAX_AMD = $901D;
// GL_NV_clip_space_w_scaling
  GL_VIEWPORT_POSITION_W_SCALE_NV = $937C;
  GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV = $937D;
  GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV = $937E;
// GL_NV_conditional_render
  GL_QUERY_WAIT_NV = $8E13;
  GL_QUERY_NO_WAIT_NV = $8E14;
  GL_QUERY_BY_REGION_WAIT_NV = $8E15;
  GL_QUERY_BY_REGION_NO_WAIT_NV = $8E16;
// GL_NV_conservative_raster
  GL_CONSERVATIVE_RASTERIZATION_NV = $9346;
  GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = $9347;
  GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = $9348;
  GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = $9349;
// GL_NV_conservative_raster_pre_snap
  GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV = $9550;
// GL_NV_conservative_raster_pre_snap_triangles
  GL_CONSERVATIVE_RASTER_MODE_NV = $954D;
  GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV = $954E;
  GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV = $954F;
// GL_NV_copy_buffer
  GL_COPY_READ_BUFFER_NV = $8F36;
  GL_COPY_WRITE_BUFFER_NV = $8F37;
// GL_NV_coverage_sample
  GL_COVERAGE_COMPONENT_NV = $8ED0;
  GL_COVERAGE_COMPONENT4_NV = $8ED1;
  GL_COVERAGE_ATTACHMENT_NV = $8ED2;
  GL_COVERAGE_BUFFERS_NV = $8ED3;
  GL_COVERAGE_SAMPLES_NV = $8ED4;
  GL_COVERAGE_ALL_FRAGMENTS_NV = $8ED5;
  GL_COVERAGE_EDGE_FRAGMENTS_NV = $8ED6;
  GL_COVERAGE_AUTOMATIC_NV = $8ED7;
  GL_COVERAGE_BUFFER_BIT_NV = $00008000;
// GL_NV_depth_nonlinear
  GL_DEPTH_COMPONENT16_NONLINEAR_NV = $8E2C;
// GL_NV_draw_buffers
  GL_MAX_DRAW_BUFFERS_NV = $8824;
  GL_DRAW_BUFFER0_NV = $8825;
  GL_DRAW_BUFFER1_NV = $8826;
  GL_DRAW_BUFFER2_NV = $8827;
  GL_DRAW_BUFFER3_NV = $8828;
  GL_DRAW_BUFFER4_NV = $8829;
  GL_DRAW_BUFFER5_NV = $882A;
  GL_DRAW_BUFFER6_NV = $882B;
  GL_DRAW_BUFFER7_NV = $882C;
  GL_DRAW_BUFFER8_NV = $882D;
  GL_DRAW_BUFFER9_NV = $882E;
  GL_DRAW_BUFFER10_NV = $882F;
  GL_DRAW_BUFFER11_NV = $8830;
  GL_DRAW_BUFFER12_NV = $8831;
  GL_DRAW_BUFFER13_NV = $8832;
  GL_DRAW_BUFFER14_NV = $8833;
  GL_DRAW_BUFFER15_NV = $8834;
  GL_COLOR_ATTACHMENT0_NV = $8CE0;
  GL_COLOR_ATTACHMENT1_NV = $8CE1;
  GL_COLOR_ATTACHMENT2_NV = $8CE2;
  GL_COLOR_ATTACHMENT3_NV = $8CE3;
  GL_COLOR_ATTACHMENT4_NV = $8CE4;
  GL_COLOR_ATTACHMENT5_NV = $8CE5;
  GL_COLOR_ATTACHMENT6_NV = $8CE6;
  GL_COLOR_ATTACHMENT7_NV = $8CE7;
  GL_COLOR_ATTACHMENT8_NV = $8CE8;
  GL_COLOR_ATTACHMENT9_NV = $8CE9;
  GL_COLOR_ATTACHMENT10_NV = $8CEA;
  GL_COLOR_ATTACHMENT11_NV = $8CEB;
  GL_COLOR_ATTACHMENT12_NV = $8CEC;
  GL_COLOR_ATTACHMENT13_NV = $8CED;
  GL_COLOR_ATTACHMENT14_NV = $8CEE;
  GL_COLOR_ATTACHMENT15_NV = $8CEF;

{$IfDef GL_NV_draw_vulkan_image}
type
  GLVULKANPROCNV = procedure(_para1:pointer);cdecl;
{$EndIf}

const
// GL_NV_fbo_color_attachments
  GL_MAX_COLOR_ATTACHMENTS_NV = $8CDF;
// GL_NV_fence
  GL_ALL_COMPLETED_NV = $84F2;
  GL_FENCE_STATUS_NV = $84F3;
  GL_FENCE_CONDITION_NV = $84F4;
// GL_NV_fill_rectangle
  GL_FILL_RECTANGLE_NV = $933C;
// GL_NV_fragment_coverage_to_color
  GL_FRAGMENT_COVERAGE_TO_COLOR_NV = $92DD;
  GL_FRAGMENT_COVERAGE_COLOR_NV = $92DE;
// GL_NV_framebuffer_blit
  GL_READ_FRAMEBUFFER_NV = $8CA8;
  GL_DRAW_FRAMEBUFFER_NV = $8CA9;
  GL_DRAW_FRAMEBUFFER_BINDING_NV = $8CA6;
  GL_READ_FRAMEBUFFER_BINDING_NV = $8CAA;
// GL_NV_framebuffer_mixed_samples
  GL_COVERAGE_MODULATION_TABLE_NV = $9331;
  GL_COLOR_SAMPLES_NV = $8E20;
  GL_DEPTH_SAMPLES_NV = $932D;
  GL_STENCIL_SAMPLES_NV = $932E;
  GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = $932F;
  GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = $9330;
  GL_COVERAGE_MODULATION_NV = $9332;
  GL_COVERAGE_MODULATION_TABLE_SIZE_NV = $9333;
// GL_NV_framebuffer_multisample
  GL_RENDERBUFFER_SAMPLES_NV = $8CAB;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV = $8D56;
  GL_MAX_SAMPLES_NV = $8D57;
// GL_NV_gpu_shader5
  GL_INT64_NV = $140E;
  GL_UNSIGNED_INT64_NV = $140F;
  GL_INT8_NV = $8FE0;
  GL_INT8_VEC2_NV = $8FE1;
  GL_INT8_VEC3_NV = $8FE2;
  GL_INT8_VEC4_NV = $8FE3;
  GL_INT16_NV = $8FE4;
  GL_INT16_VEC2_NV = $8FE5;
  GL_INT16_VEC3_NV = $8FE6;
  GL_INT16_VEC4_NV = $8FE7;
  GL_INT64_VEC2_NV = $8FE9;
  GL_INT64_VEC3_NV = $8FEA;
  GL_INT64_VEC4_NV = $8FEB;
  GL_UNSIGNED_INT8_NV = $8FEC;
  GL_UNSIGNED_INT8_VEC2_NV = $8FED;
  GL_UNSIGNED_INT8_VEC3_NV = $8FEE;
  GL_UNSIGNED_INT8_VEC4_NV = $8FEF;
  GL_UNSIGNED_INT16_NV = $8FF0;
  GL_UNSIGNED_INT16_VEC2_NV = $8FF1;
  GL_UNSIGNED_INT16_VEC3_NV = $8FF2;
  GL_UNSIGNED_INT16_VEC4_NV = $8FF3;
  GL_UNSIGNED_INT64_VEC2_NV = $8FF5;
  GL_UNSIGNED_INT64_VEC3_NV = $8FF6;
  GL_UNSIGNED_INT64_VEC4_NV = $8FF7;
  GL_FLOAT16_NV = $8FF8;
  GL_FLOAT16_VEC2_NV = $8FF9;
  GL_FLOAT16_VEC3_NV = $8FFA;
  GL_FLOAT16_VEC4_NV = $8FFB;
  GL_PATCHES = $000E;
// GL_NV_instanced_arrays
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV = $88FE;
// GL_NV_internalformat_sample_query
  GL_TEXTURE_2D_MULTISAMPLE = $9100;
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY = $9102;
  GL_MULTISAMPLES_NV = $9371;
  GL_SUPERSAMPLE_SCALE_X_NV = $9372;
  GL_SUPERSAMPLE_SCALE_Y_NV = $9373;
  GL_CONFORMANT_NV = $9374;
// GL_NV_memory_attachment
  GL_ATTACHED_MEMORY_OBJECT_NV = $95A4;
  GL_ATTACHED_MEMORY_OFFSET_NV = $95A5;
  GL_MEMORY_ATTACHABLE_ALIGNMENT_NV = $95A6;
  GL_MEMORY_ATTACHABLE_SIZE_NV = $95A7;
  GL_MEMORY_ATTACHABLE_NV = $95A8;
  GL_DETACHED_MEMORY_INCARNATION_NV = $95A9;
  GL_DETACHED_TEXTURES_NV = $95AA;
  GL_DETACHED_BUFFERS_NV = $95AB;
  GL_MAX_DETACHED_TEXTURES_NV = $95AC;
  GL_MAX_DETACHED_BUFFERS_NV = $95AD;
// GL_NV_mesh_shader
  GL_MESH_SHADER_NV = $9559;
  GL_TASK_SHADER_NV = $955A;
  GL_MAX_MESH_UNIFORM_BLOCKS_NV = $8E60;
  GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV = $8E61;
  GL_MAX_MESH_IMAGE_UNIFORMS_NV = $8E62;
  GL_MAX_MESH_UNIFORM_COMPONENTS_NV = $8E63;
  GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV = $8E64;
  GL_MAX_MESH_ATOMIC_COUNTERS_NV = $8E65;
  GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV = $8E66;
  GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV = $8E67;
  GL_MAX_TASK_UNIFORM_BLOCKS_NV = $8E68;
  GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV = $8E69;
  GL_MAX_TASK_IMAGE_UNIFORMS_NV = $8E6A;
  GL_MAX_TASK_UNIFORM_COMPONENTS_NV = $8E6B;
  GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV = $8E6C;
  GL_MAX_TASK_ATOMIC_COUNTERS_NV = $8E6D;
  GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV = $8E6E;
  GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV = $8E6F;
  GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV = $95A2;
  GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV = $95A3;
  GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV = $9536;
  GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV = $9537;
  GL_MAX_MESH_OUTPUT_VERTICES_NV = $9538;
  GL_MAX_MESH_OUTPUT_PRIMITIVES_NV = $9539;
  GL_MAX_TASK_OUTPUT_COUNT_NV = $953A;
  GL_MAX_DRAW_MESH_TASKS_COUNT_NV = $953D;
  GL_MAX_MESH_VIEWS_NV = $9557;
  GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV = $92DF;
  GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV = $9543;
  GL_MAX_MESH_WORK_GROUP_SIZE_NV = $953B;
  GL_MAX_TASK_WORK_GROUP_SIZE_NV = $953C;
  GL_MESH_WORK_GROUP_SIZE_NV = $953E;
  GL_TASK_WORK_GROUP_SIZE_NV = $953F;
  GL_MESH_VERTICES_OUT_NV = $9579;
  GL_MESH_PRIMITIVES_OUT_NV = $957A;
  GL_MESH_OUTPUT_TYPE_NV = $957B;
  GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV = $959C;
  GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV = $959D;
  GL_REFERENCED_BY_MESH_SHADER_NV = $95A0;
  GL_REFERENCED_BY_TASK_SHADER_NV = $95A1;
  GL_MESH_SHADER_BIT_NV = $00000040;
  GL_TASK_SHADER_BIT_NV = $00000080;
  GL_MESH_SUBROUTINE_NV = $957C;
  GL_TASK_SUBROUTINE_NV = $957D;
  GL_MESH_SUBROUTINE_UNIFORM_NV = $957E;
  GL_TASK_SUBROUTINE_UNIFORM_NV = $957F;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV = $959E;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV = $959F;
// GL_NV_non_square_matrices
  GL_FLOAT_MAT2x3_NV = $8B65;
  GL_FLOAT_MAT2x4_NV = $8B66;
  GL_FLOAT_MAT3x2_NV = $8B67;
  GL_FLOAT_MAT3x4_NV = $8B68;
  GL_FLOAT_MAT4x2_NV = $8B69;
  GL_FLOAT_MAT4x3_NV = $8B6A;
// GL_NV_pack_subimage
  GL_PACK_ROW_LENGTH_NV = $0D02;
  GL_PACK_SKIP_ROWS_NV = $0D03;
  GL_PACK_SKIP_PIXELS_NV = $0D04;
// GL_NV_path_rendering
  GL_PATH_FORMAT_SVG_NV = $9070;
  GL_PATH_FORMAT_PS_NV = $9071;
  GL_STANDARD_FONT_NAME_NV = $9072;
  GL_SYSTEM_FONT_NAME_NV = $9073;
  GL_FILE_NAME_NV = $9074;
  GL_PATH_STROKE_WIDTH_NV = $9075;
  GL_PATH_END_CAPS_NV = $9076;
  GL_PATH_INITIAL_END_CAP_NV = $9077;
  GL_PATH_TERMINAL_END_CAP_NV = $9078;
  GL_PATH_JOIN_STYLE_NV = $9079;
  GL_PATH_MITER_LIMIT_NV = $907A;
  GL_PATH_DASH_CAPS_NV = $907B;
  GL_PATH_INITIAL_DASH_CAP_NV = $907C;
  GL_PATH_TERMINAL_DASH_CAP_NV = $907D;
  GL_PATH_DASH_OFFSET_NV = $907E;
  GL_PATH_CLIENT_LENGTH_NV = $907F;
  GL_PATH_FILL_MODE_NV = $9080;
  GL_PATH_FILL_MASK_NV = $9081;
  GL_PATH_FILL_COVER_MODE_NV = $9082;
  GL_PATH_STROKE_COVER_MODE_NV = $9083;
  GL_PATH_STROKE_MASK_NV = $9084;
  GL_COUNT_UP_NV = $9088;
  GL_COUNT_DOWN_NV = $9089;
  GL_PATH_OBJECT_BOUNDING_BOX_NV = $908A;
  GL_CONVEX_HULL_NV = $908B;
  GL_BOUNDING_BOX_NV = $908D;
  GL_TRANSLATE_X_NV = $908E;
  GL_TRANSLATE_Y_NV = $908F;
  GL_TRANSLATE_2D_NV = $9090;
  GL_TRANSLATE_3D_NV = $9091;
  GL_AFFINE_2D_NV = $9092;
  GL_AFFINE_3D_NV = $9094;
  GL_TRANSPOSE_AFFINE_2D_NV = $9096;
  GL_TRANSPOSE_AFFINE_3D_NV = $9098;
  GL_UTF8_NV = $909A;
  GL_UTF16_NV = $909B;
  GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = $909C;
  GL_PATH_COMMAND_COUNT_NV = $909D;
  GL_PATH_COORD_COUNT_NV = $909E;
  GL_PATH_DASH_ARRAY_COUNT_NV = $909F;
  GL_PATH_COMPUTED_LENGTH_NV = $90A0;
  GL_PATH_FILL_BOUNDING_BOX_NV = $90A1;
  GL_PATH_STROKE_BOUNDING_BOX_NV = $90A2;
  GL_SQUARE_NV = $90A3;
  GL_ROUND_NV = $90A4;
  GL_TRIANGULAR_NV = $90A5;
  GL_BEVEL_NV = $90A6;
  GL_MITER_REVERT_NV = $90A7;
  GL_MITER_TRUNCATE_NV = $90A8;
  GL_SKIP_MISSING_GLYPH_NV = $90A9;
  GL_USE_MISSING_GLYPH_NV = $90AA;
  GL_PATH_ERROR_POSITION_NV = $90AB;
  GL_ACCUM_ADJACENT_PAIRS_NV = $90AD;
  GL_ADJACENT_PAIRS_NV = $90AE;
  GL_FIRST_TO_REST_NV = $90AF;
  GL_PATH_GEN_MODE_NV = $90B0;
  GL_PATH_GEN_COEFF_NV = $90B1;
  GL_PATH_GEN_COMPONENTS_NV = $90B3;
  GL_PATH_STENCIL_FUNC_NV = $90B7;
  GL_PATH_STENCIL_REF_NV = $90B8;
  GL_PATH_STENCIL_VALUE_MASK_NV = $90B9;
  GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = $90BD;
  GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = $90BE;
  GL_PATH_COVER_DEPTH_FUNC_NV = $90BF;
  GL_PATH_DASH_OFFSET_RESET_NV = $90B4;
  GL_MOVE_TO_RESETS_NV = $90B5;
  GL_MOVE_TO_CONTINUES_NV = $90B6;
  GL_CLOSE_PATH_NV = $00;
  GL_MOVE_TO_NV = $02;
  GL_RELATIVE_MOVE_TO_NV = $03;
  GL_LINE_TO_NV = $04;
  GL_RELATIVE_LINE_TO_NV = $05;
  GL_HORIZONTAL_LINE_TO_NV = $06;
  GL_RELATIVE_HORIZONTAL_LINE_TO_NV = $07;
  GL_VERTICAL_LINE_TO_NV = $08;
  GL_RELATIVE_VERTICAL_LINE_TO_NV = $09;
  GL_QUADRATIC_CURVE_TO_NV = $0A;
  GL_RELATIVE_QUADRATIC_CURVE_TO_NV = $0B;
  GL_CUBIC_CURVE_TO_NV = $0C;
  GL_RELATIVE_CUBIC_CURVE_TO_NV = $0D;
  GL_SMOOTH_QUADRATIC_CURVE_TO_NV = $0E;
  GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = $0F;
  GL_SMOOTH_CUBIC_CURVE_TO_NV = $10;
  GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = $11;
  GL_SMALL_CCW_ARC_TO_NV = $12;
  GL_RELATIVE_SMALL_CCW_ARC_TO_NV = $13;
  GL_SMALL_CW_ARC_TO_NV = $14;
  GL_RELATIVE_SMALL_CW_ARC_TO_NV = $15;
  GL_LARGE_CCW_ARC_TO_NV = $16;
  GL_RELATIVE_LARGE_CCW_ARC_TO_NV = $17;
  GL_LARGE_CW_ARC_TO_NV = $18;
  GL_RELATIVE_LARGE_CW_ARC_TO_NV = $19;
  GL_RESTART_PATH_NV = $F0;
  GL_DUP_FIRST_CUBIC_CURVE_TO_NV = $F2;
  GL_DUP_LAST_CUBIC_CURVE_TO_NV = $F4;
  GL_RECT_NV = $F6;
  GL_CIRCULAR_CCW_ARC_TO_NV = $F8;
  GL_CIRCULAR_CW_ARC_TO_NV = $FA;
  GL_CIRCULAR_TANGENT_ARC_TO_NV = $FC;
  GL_ARC_TO_NV = $FE;
  GL_RELATIVE_ARC_TO_NV = $FF;
  GL_BOLD_BIT_NV = $01;
  GL_ITALIC_BIT_NV = $02;
  GL_GLYPH_WIDTH_BIT_NV = $01;
  GL_GLYPH_HEIGHT_BIT_NV = $02;
  GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = $04;
  GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = $08;
  GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = $10;
  GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = $20;
  GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = $40;
  GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = $80;
  GL_GLYPH_HAS_KERNING_BIT_NV = $100;
  GL_FONT_X_MIN_BOUNDS_BIT_NV = $00010000;
  GL_FONT_Y_MIN_BOUNDS_BIT_NV = $00020000;
  GL_FONT_X_MAX_BOUNDS_BIT_NV = $00040000;
  GL_FONT_Y_MAX_BOUNDS_BIT_NV = $00080000;
  GL_FONT_UNITS_PER_EM_BIT_NV = $00100000;
  GL_FONT_ASCENDER_BIT_NV = $00200000;
  GL_FONT_DESCENDER_BIT_NV = $00400000;
  GL_FONT_HEIGHT_BIT_NV = $00800000;
  GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = $01000000;
  GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = $02000000;
  GL_FONT_UNDERLINE_POSITION_BIT_NV = $04000000;
  GL_FONT_UNDERLINE_THICKNESS_BIT_NV = $08000000;
  GL_FONT_HAS_KERNING_BIT_NV = $10000000;
  GL_ROUNDED_RECT_NV = $E8;
  GL_RELATIVE_ROUNDED_RECT_NV = $E9;
  GL_ROUNDED_RECT2_NV = $EA;
  GL_RELATIVE_ROUNDED_RECT2_NV = $EB;
  GL_ROUNDED_RECT4_NV = $EC;
  GL_RELATIVE_ROUNDED_RECT4_NV = $ED;
  GL_ROUNDED_RECT8_NV = $EE;
  GL_RELATIVE_ROUNDED_RECT8_NV = $EF;
  GL_RELATIVE_RECT_NV = $F7;
  GL_FONT_GLYPHS_AVAILABLE_NV = $9368;
  GL_FONT_TARGET_UNAVAILABLE_NV = $9369;
  GL_FONT_UNAVAILABLE_NV = $936A;
  GL_FONT_UNINTELLIGIBLE_NV = $936B;
  GL_CONIC_CURVE_TO_NV = $1A;
  GL_RELATIVE_CONIC_CURVE_TO_NV = $1B;
  GL_FONT_NUM_GLYPH_INDICES_BIT_NV = $20000000;
  GL_STANDARD_FONT_FORMAT_NV = $936C;
  GL_PATH_PROJECTION_NV = $1701;
  GL_PATH_MODELVIEW_NV = $1700;
  GL_PATH_MODELVIEW_STACK_DEPTH_NV = $0BA3;
  GL_PATH_MODELVIEW_MATRIX_NV = $0BA6;
  GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = $0D36;
  GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = $84E3;
  GL_PATH_PROJECTION_STACK_DEPTH_NV = $0BA4;
  GL_PATH_PROJECTION_MATRIX_NV = $0BA7;
  GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = $0D38;
  GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = $84E4;
  GL_FRAGMENT_INPUT_NV = $936D;
// GL_NV_path_rendering_shared_edge
  GL_SHARED_EDGE_NV = $C0;
// GL_NV_pixel_buffer_object
  GL_PIXEL_PACK_BUFFER_NV = $88EB;
  GL_PIXEL_UNPACK_BUFFER_NV = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING_NV = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING_NV = $88EF;
// GL_NV_polygon_mode
  GL_POLYGON_MODE_NV = $0B40;
  GL_POLYGON_OFFSET_POINT_NV = $2A01;
  GL_POLYGON_OFFSET_LINE_NV = $2A02;
  GL_POINT_NV = $1B00;
  GL_LINE_NV = $1B01;
  GL_FILL_NV = $1B02;
// GL_NV_primitive_shading_rate
  GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV = $95B1;
  GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV = $95B2;
// GL_NV_read_buffer
  GL_READ_BUFFER_NV = $0C02;
// GL_NV_representative_fragment_test
  GL_REPRESENTATIVE_FRAGMENT_TEST_NV = $937F;
// GL_NV_sRGB_formats
  GL_SLUMINANCE_NV = $8C46;
  GL_SLUMINANCE_ALPHA_NV = $8C44;
  GL_SRGB8_NV = $8C41;
  GL_SLUMINANCE8_NV = $8C47;
  GL_SLUMINANCE8_ALPHA8_NV = $8C45;
  GL_COMPRESSED_SRGB_S3TC_DXT1_NV = $8C4C;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV = $8C4D;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV = $8C4E;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV = $8C4F;
  GL_ETC1_SRGB8_NV = $88EE;
// GL_NV_sample_locations
  GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = $933D;
  GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = $933E;
  GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = $933F;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = $9340;
  GL_SAMPLE_LOCATION_NV = $8E50;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = $9341;
  GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = $9342;
  GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = $9343;
// GL_NV_scissor_exclusive
  GL_SCISSOR_TEST_EXCLUSIVE_NV = $9555;
  GL_SCISSOR_BOX_EXCLUSIVE_NV = $9556;
// GL_NV_shader_subgroup_partitioned
  GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV = $00000100;
// GL_NV_shading_rate_image
  GL_SHADING_RATE_IMAGE_NV = $9563;
  GL_SHADING_RATE_NO_INVOCATIONS_NV = $9564;
  GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV = $9565;
  GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV = $9566;
  GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV = $9567;
  GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV = $9568;
  GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV = $9569;
  GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV = $956A;
  GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV = $956B;
  GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV = $956C;
  GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV = $956D;
  GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV = $956E;
  GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV = $956F;
  GL_SHADING_RATE_IMAGE_BINDING_NV = $955B;
  GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV = $955C;
  GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV = $955D;
  GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV = $955E;
  GL_MAX_COARSE_FRAGMENT_SAMPLES_NV = $955F;
  GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV = $95AE;
  GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV = $95AF;
  GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV = $95B0;
// GL_NV_shadow_samplers_array
  GL_SAMPLER_2D_ARRAY_SHADOW_NV = $8DC4;
// GL_NV_shadow_samplers_cube
  GL_SAMPLER_CUBE_SHADOW_NV = $8DC5;
// GL_NV_texture_border_clamp
  GL_TEXTURE_BORDER_COLOR_NV = $1004;
  GL_CLAMP_TO_BORDER_NV = $812D;
// GL_NV_timeline_semaphore
  GL_TIMELINE_SEMAPHORE_VALUE_NV = $9595;
  GL_SEMAPHORE_TYPE_NV = $95B3;
  GL_SEMAPHORE_TYPE_BINARY_NV = $95B4;
  GL_SEMAPHORE_TYPE_TIMELINE_NV = $95B5;
  GL_MAX_TIMELINE_SEMAPHORE_VALUE_DIFFERENCE_NV = $95B6;
// GL_NV_viewport_array
  GL_MAX_VIEWPORTS_NV = $825B;
  GL_VIEWPORT_SUBPIXEL_BITS_NV = $825C;
  GL_VIEWPORT_BOUNDS_RANGE_NV = $825D;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = $825F;
// GL_NV_viewport_swizzle
  GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV = $9350;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV = $9351;
  GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV = $9352;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV = $9353;
  GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV = $9354;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV = $9355;
  GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV = $9356;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV = $9357;
  GL_VIEWPORT_SWIZZLE_X_NV = $9358;
  GL_VIEWPORT_SWIZZLE_Y_NV = $9359;
  GL_VIEWPORT_SWIZZLE_Z_NV = $935A;
  GL_VIEWPORT_SWIZZLE_W_NV = $935B;
// GL_OVR_multiview
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = $9630;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = $9632;
  GL_MAX_VIEWS_OVR = $9631;
  GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR = $9633;
// GL_QCOM_alpha_test
  GL_ALPHA_TEST_QCOM = $0BC0;
  GL_ALPHA_TEST_FUNC_QCOM = $0BC1;
  GL_ALPHA_TEST_REF_QCOM = $0BC2;
// GL_QCOM_binning_control
  GL_BINNING_CONTROL_HINT_QCOM = $8FB0;
  GL_CPU_OPTIMIZED_QCOM = $8FB1;
  GL_GPU_OPTIMIZED_QCOM = $8FB2;
  GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM = $8FB3;
// GL_QCOM_extended_get
  GL_TEXTURE_WIDTH_QCOM = $8BD2;
  GL_TEXTURE_HEIGHT_QCOM = $8BD3;
  GL_TEXTURE_DEPTH_QCOM = $8BD4;
  GL_TEXTURE_INTERNAL_FORMAT_QCOM = $8BD5;
  GL_TEXTURE_FORMAT_QCOM = $8BD6;
  GL_TEXTURE_TYPE_QCOM = $8BD7;
  GL_TEXTURE_IMAGE_VALID_QCOM = $8BD8;
  GL_TEXTURE_NUM_LEVELS_QCOM = $8BD9;
  GL_TEXTURE_TARGET_QCOM = $8BDA;
  GL_TEXTURE_OBJECT_VALID_QCOM = $8BDB;
  GL_STATE_RESTORE = $8BDC;
// GL_QCOM_framebuffer_foveated
  GL_FOVEATION_ENABLE_BIT_QCOM = $00000001;
  GL_FOVEATION_SCALED_BIN_METHOD_BIT_QCOM = $00000002;
// GL_QCOM_motion_estimation
  GL_MOTION_ESTIMATION_SEARCH_BLOCK_X_QCOM = $8C90;
  GL_MOTION_ESTIMATION_SEARCH_BLOCK_Y_QCOM = $8C91;
// GL_QCOM_perfmon_global_mode
  GL_PERFMON_GLOBAL_MODE_QCOM = $8FA0;
// GL_QCOM_shader_framebuffer_fetch_noncoherent
  GL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM = $96A2;
// GL_QCOM_shading_rate
  GL_SHADING_RATE_QCOM = $96A4;
  GL_SHADING_RATE_PRESERVE_ASPECT_RATIO_QCOM = $96A5;
  GL_SHADING_RATE_1X1_PIXELS_QCOM = $96A6;
  GL_SHADING_RATE_1X2_PIXELS_QCOM = $96A7;
  GL_SHADING_RATE_2X1_PIXELS_QCOM = $96A8;
  GL_SHADING_RATE_2X2_PIXELS_QCOM = $96A9;
  GL_SHADING_RATE_4X2_PIXELS_QCOM = $96AC;
  GL_SHADING_RATE_4X4_PIXELS_QCOM = $96AE;
// GL_QCOM_texture_foveated
  GL_TEXTURE_FOVEATED_FEATURE_BITS_QCOM = $8BFB;
  GL_TEXTURE_FOVEATED_MIN_PIXEL_DENSITY_QCOM = $8BFC;
  GL_TEXTURE_FOVEATED_FEATURE_QUERY_QCOM = $8BFD;
  GL_TEXTURE_FOVEATED_NUM_FOCAL_POINTS_QUERY_QCOM = $8BFE;
  GL_FRAMEBUFFER_INCOMPLETE_FOVEATION_QCOM = $8BFF;
// GL_QCOM_texture_foveated2
  GL_TEXTURE_FOVEATED_CUTOFF_DENSITY_QCOM = $96A0;
// GL_QCOM_texture_foveated_subsampled_layout
  GL_FOVEATION_SUBSAMPLED_LAYOUT_METHOD_BIT_QCOM = $00000004;
  GL_MAX_SHADER_SUBSAMPLED_IMAGE_UNITS_QCOM = $8FA1;
// GL_QCOM_tiled_rendering
  GL_COLOR_BUFFER_BIT0_QCOM = $00000001;
  GL_COLOR_BUFFER_BIT1_QCOM = $00000002;
  GL_COLOR_BUFFER_BIT2_QCOM = $00000004;
  GL_COLOR_BUFFER_BIT3_QCOM = $00000008;
  GL_COLOR_BUFFER_BIT4_QCOM = $00000010;
  GL_COLOR_BUFFER_BIT5_QCOM = $00000020;
  GL_COLOR_BUFFER_BIT6_QCOM = $00000040;
  GL_COLOR_BUFFER_BIT7_QCOM = $00000080;
  GL_DEPTH_BUFFER_BIT0_QCOM = $00000100;
  GL_DEPTH_BUFFER_BIT1_QCOM = $00000200;
  GL_DEPTH_BUFFER_BIT2_QCOM = $00000400;
  GL_DEPTH_BUFFER_BIT3_QCOM = $00000800;
  GL_DEPTH_BUFFER_BIT4_QCOM = $00001000;
  GL_DEPTH_BUFFER_BIT5_QCOM = $00002000;
  GL_DEPTH_BUFFER_BIT6_QCOM = $00004000;
  GL_DEPTH_BUFFER_BIT7_QCOM = $00008000;
  GL_STENCIL_BUFFER_BIT0_QCOM = $00010000;
  GL_STENCIL_BUFFER_BIT1_QCOM = $00020000;
  GL_STENCIL_BUFFER_BIT2_QCOM = $00040000;
  GL_STENCIL_BUFFER_BIT3_QCOM = $00080000;
  GL_STENCIL_BUFFER_BIT4_QCOM = $00100000;
  GL_STENCIL_BUFFER_BIT5_QCOM = $00200000;
  GL_STENCIL_BUFFER_BIT6_QCOM = $00400000;
  GL_STENCIL_BUFFER_BIT7_QCOM = $00800000;
  GL_MULTISAMPLE_BUFFER_BIT0_QCOM = $01000000;
  GL_MULTISAMPLE_BUFFER_BIT1_QCOM = $02000000;
  GL_MULTISAMPLE_BUFFER_BIT2_QCOM = $04000000;
  GL_MULTISAMPLE_BUFFER_BIT3_QCOM = $08000000;
  GL_MULTISAMPLE_BUFFER_BIT4_QCOM = $10000000;
  GL_MULTISAMPLE_BUFFER_BIT5_QCOM = $20000000;
  GL_MULTISAMPLE_BUFFER_BIT6_QCOM = $40000000;
  GL_MULTISAMPLE_BUFFER_BIT7_QCOM = $80000000;
// GL_QCOM_writeonly_rendering
  GL_WRITEONLY_RENDERING_QCOM = $8823;
// GL_VIV_shader_binary
  GL_SHADER_BINARY_VIV = $8FC4;
(*******************************************************************************
*                            GL_ES_VERSION_2_0                                 *
*******************************************************************************)

(*******************************************************************************
*                            GL_ES_VERSION_3_0                                 *
*******************************************************************************)
  GL_READ_BUFFER = $0C02;
  GL_UNPACK_ROW_LENGTH = $0CF2;
  GL_UNPACK_SKIP_ROWS = $0CF3;
  GL_UNPACK_SKIP_PIXELS = $0CF4;
  GL_PACK_ROW_LENGTH = $0D02;
  GL_PACK_SKIP_ROWS = $0D03;
  GL_PACK_SKIP_PIXELS = $0D04;
  GL_COLOR = $1800;
  GL_DEPTH = $1801;
  GL_STENCIL = $1802;
  GL_RED = $1903;
  GL_RGB8 = $8051;
  GL_RGBA8 = $8058;
  GL_RGB10_A2 = $8059;
  GL_TEXTURE_BINDING_3D = $806A;
  GL_UNPACK_SKIP_IMAGES = $806D;
  GL_UNPACK_IMAGE_HEIGHT = $806E;
//  GL_TEXTURE_3D = $806F;
  GL_TEXTURE_WRAP_R = $8072;
  GL_MAX_3D_TEXTURE_SIZE = $8073;
  GL_UNSIGNED_INT_2_10_10_10_REV = $8368;
  GL_MAX_ELEMENTS_VERTICES = $80E8;
  GL_MAX_ELEMENTS_INDICES = $80E9;
  GL_TEXTURE_MIN_LOD = $813A;
  GL_TEXTURE_MAX_LOD = $813B;
  GL_TEXTURE_BASE_LEVEL = $813C;
  GL_TEXTURE_MAX_LEVEL = $813D;
//  GL_MIN = $8007;
//  GL_MAX = $8008;
  GL_DEPTH_COMPONENT24 = $81A6;
  GL_MAX_TEXTURE_LOD_BIAS = $84FD;
  GL_TEXTURE_COMPARE_MODE = $884C;
  GL_TEXTURE_COMPARE_FUNC = $884D;
  GL_CURRENT_QUERY = $8865;
  GL_QUERY_RESULT = $8866;
  GL_QUERY_RESULT_AVAILABLE = $8867;
  GL_BUFFER_MAPPED = $88BC;
  GL_BUFFER_MAP_POINTER = $88BD;
  GL_STREAM_READ = $88E1;
  GL_STREAM_COPY = $88E2;
  GL_STATIC_READ = $88E5;
  GL_STATIC_COPY = $88E6;
  GL_DYNAMIC_READ = $88E9;
  GL_DYNAMIC_COPY = $88EA;
  GL_MAX_DRAW_BUFFERS = $8824;
  GL_DRAW_BUFFER0 = $8825;
  GL_DRAW_BUFFER1 = $8826;
  GL_DRAW_BUFFER2 = $8827;
  GL_DRAW_BUFFER3 = $8828;
  GL_DRAW_BUFFER4 = $8829;
  GL_DRAW_BUFFER5 = $882A;
  GL_DRAW_BUFFER6 = $882B;
  GL_DRAW_BUFFER7 = $882C;
  GL_DRAW_BUFFER8 = $882D;
  GL_DRAW_BUFFER9 = $882E;
  GL_DRAW_BUFFER10 = $882F;
  GL_DRAW_BUFFER11 = $8830;
  GL_DRAW_BUFFER12 = $8831;
  GL_DRAW_BUFFER13 = $8832;
  GL_DRAW_BUFFER14 = $8833;
  GL_DRAW_BUFFER15 = $8834;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = $8B49;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS = $8B4A;
  GL_SAMPLER_3D = $8B5F;
  GL_SAMPLER_2D_SHADOW = $8B62;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT = $8B8B;
  GL_PIXEL_PACK_BUFFER = $88EB;
  GL_PIXEL_UNPACK_BUFFER = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING = $88EF;
  GL_FLOAT_MAT2x3 = $8B65;
  GL_FLOAT_MAT2x4 = $8B66;
  GL_FLOAT_MAT3x2 = $8B67;
  GL_FLOAT_MAT3x4 = $8B68;
  GL_FLOAT_MAT4x2 = $8B69;
  GL_FLOAT_MAT4x3 = $8B6A;
  GL_SRGB = $8C40;
  GL_SRGB8 = $8C41;
  GL_SRGB8_ALPHA8 = $8C43;
  GL_COMPARE_REF_TO_TEXTURE = $884E;
  GL_MAJOR_VERSION = $821B;
  GL_MINOR_VERSION = $821C;
  GL_NUM_EXTENSIONS = $821D;
  GL_RGBA32F = $8814;
  GL_RGB32F = $8815;
  GL_RGBA16F = $881A;
  GL_RGB16F = $881B;
  GL_VERTEX_ATTRIB_ARRAY_INTEGER = $88FD;
  GL_MAX_ARRAY_TEXTURE_LAYERS = $88FF;
  GL_MIN_PROGRAM_TEXEL_OFFSET = $8904;
  GL_MAX_PROGRAM_TEXEL_OFFSET = $8905;
  GL_MAX_VARYING_COMPONENTS = $8B4B;
//  GL_TEXTURE_2D_ARRAY = $8C1A;
  GL_TEXTURE_BINDING_2D_ARRAY = $8C1D;
  GL_R11F_G11F_B10F = $8C3A;
  GL_UNSIGNED_INT_10F_11F_11F_REV = $8C3B;
  GL_RGB9_E5 = $8C3D;
  GL_UNSIGNED_INT_5_9_9_9_REV = $8C3E;
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = $8C76;
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE = $8C7F;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = $8C80;
  GL_TRANSFORM_FEEDBACK_VARYINGS = $8C83;
  GL_TRANSFORM_FEEDBACK_BUFFER_START = $8C84;
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = $8C85;
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = $8C88;
  GL_RASTERIZER_DISCARD = $8C89;
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = $8C8A;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = $8C8B;
  GL_INTERLEAVED_ATTRIBS = $8C8C;
  GL_SEPARATE_ATTRIBS = $8C8D;
  GL_TRANSFORM_FEEDBACK_BUFFER = $8C8E;
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = $8C8F;
  GL_RGBA32UI = $8D70;
  GL_RGB32UI = $8D71;
  GL_RGBA16UI = $8D76;
  GL_RGB16UI = $8D77;
  GL_RGBA8UI = $8D7C;
  GL_RGB8UI = $8D7D;
  GL_RGBA32I = $8D82;
  GL_RGB32I = $8D83;
  GL_RGBA16I = $8D88;
  GL_RGB16I = $8D89;
  GL_RGBA8I = $8D8E;
  GL_RGB8I = $8D8F;
  GL_RED_INTEGER = $8D94;
  GL_RGB_INTEGER = $8D98;
  GL_RGBA_INTEGER = $8D99;
  GL_SAMPLER_2D_ARRAY = $8DC1;
  GL_SAMPLER_2D_ARRAY_SHADOW = $8DC4;
  GL_SAMPLER_CUBE_SHADOW = $8DC5;
  GL_UNSIGNED_INT_VEC2 = $8DC6;
  GL_UNSIGNED_INT_VEC3 = $8DC7;
  GL_UNSIGNED_INT_VEC4 = $8DC8;
  GL_INT_SAMPLER_2D = $8DCA;
  GL_INT_SAMPLER_3D = $8DCB;
  GL_INT_SAMPLER_CUBE = $8DCC;
  GL_INT_SAMPLER_2D_ARRAY = $8DCF;
  GL_UNSIGNED_INT_SAMPLER_2D = $8DD2;
  GL_UNSIGNED_INT_SAMPLER_3D = $8DD3;
  GL_UNSIGNED_INT_SAMPLER_CUBE = $8DD4;
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = $8DD7;
  GL_BUFFER_ACCESS_FLAGS = $911F;
  GL_BUFFER_MAP_LENGTH = $9120;
  GL_BUFFER_MAP_OFFSET = $9121;
  GL_DEPTH_COMPONENT32F = $8CAC;
  GL_DEPTH32F_STENCIL8 = $8CAD;
  GL_FLOAT_32_UNSIGNED_INT_24_8_REV = $8DAD;
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = $8210;
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = $8211;
  GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = $8212;
  GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = $8213;
  GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = $8214;
  GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = $8215;
  GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = $8216;
  GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = $8217;
  GL_FRAMEBUFFER_DEFAULT = $8218;
  GL_FRAMEBUFFER_UNDEFINED = $8219;
  GL_DEPTH_STENCIL_ATTACHMENT = $821A;
  GL_DEPTH_STENCIL = $84F9;
  GL_UNSIGNED_INT_24_8 = $84FA;
  GL_DEPTH24_STENCIL8 = $88F0;
  GL_UNSIGNED_NORMALIZED = $8C17;
  GL_DRAW_FRAMEBUFFER_BINDING = $8CA6;
  GL_READ_FRAMEBUFFER = $8CA8;
  GL_DRAW_FRAMEBUFFER = $8CA9;
  GL_READ_FRAMEBUFFER_BINDING = $8CAA;
  GL_RENDERBUFFER_SAMPLES = $8CAB;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = $8CD4;
  GL_MAX_COLOR_ATTACHMENTS = $8CDF;
  GL_COLOR_ATTACHMENT1 = $8CE1;
  GL_COLOR_ATTACHMENT2 = $8CE2;
  GL_COLOR_ATTACHMENT3 = $8CE3;
  GL_COLOR_ATTACHMENT4 = $8CE4;
  GL_COLOR_ATTACHMENT5 = $8CE5;
  GL_COLOR_ATTACHMENT6 = $8CE6;
  GL_COLOR_ATTACHMENT7 = $8CE7;
  GL_COLOR_ATTACHMENT8 = $8CE8;
  GL_COLOR_ATTACHMENT9 = $8CE9;
  GL_COLOR_ATTACHMENT10 = $8CEA;
  GL_COLOR_ATTACHMENT11 = $8CEB;
  GL_COLOR_ATTACHMENT12 = $8CEC;
  GL_COLOR_ATTACHMENT13 = $8CED;
  GL_COLOR_ATTACHMENT14 = $8CEE;
  GL_COLOR_ATTACHMENT15 = $8CEF;
  GL_COLOR_ATTACHMENT16 = $8CF0;
  GL_COLOR_ATTACHMENT17 = $8CF1;
  GL_COLOR_ATTACHMENT18 = $8CF2;
  GL_COLOR_ATTACHMENT19 = $8CF3;
  GL_COLOR_ATTACHMENT20 = $8CF4;
  GL_COLOR_ATTACHMENT21 = $8CF5;
  GL_COLOR_ATTACHMENT22 = $8CF6;
  GL_COLOR_ATTACHMENT23 = $8CF7;
  GL_COLOR_ATTACHMENT24 = $8CF8;
  GL_COLOR_ATTACHMENT25 = $8CF9;
  GL_COLOR_ATTACHMENT26 = $8CFA;
  GL_COLOR_ATTACHMENT27 = $8CFB;
  GL_COLOR_ATTACHMENT28 = $8CFC;
  GL_COLOR_ATTACHMENT29 = $8CFD;
  GL_COLOR_ATTACHMENT30 = $8CFE;
  GL_COLOR_ATTACHMENT31 = $8CFF;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = $8D56;
  GL_MAX_SAMPLES = $8D57;
  GL_HALF_FLOAT = $140B;
//  GL_MAP_READ_BIT = $0001;
//  GL_MAP_WRITE_BIT = $0002;
  GL_MAP_INVALIDATE_RANGE_BIT = $0004;
  GL_MAP_INVALIDATE_BUFFER_BIT = $0008;
  GL_MAP_FLUSH_EXPLICIT_BIT = $0010;
  GL_MAP_UNSYNCHRONIZED_BIT = $0020;
  GL_RG = $8227;
  GL_RG_INTEGER = $8228;
  GL_R8 = $8229;
  GL_RG8 = $822B;
  GL_R16F = $822D;
  GL_R32F = $822E;
  GL_RG16F = $822F;
  GL_RG32F = $8230;
  GL_R8I = $8231;
  GL_R8UI = $8232;
  GL_R16I = $8233;
  GL_R16UI = $8234;
  GL_R32I = $8235;
  GL_R32UI = $8236;
  GL_RG8I = $8237;
  GL_RG8UI = $8238;
  GL_RG16I = $8239;
  GL_RG16UI = $823A;
  GL_RG32I = $823B;
  GL_RG32UI = $823C;
  GL_VERTEX_ARRAY_BINDING = $85B5;
//  GL_R8_SNORM = $8F94;
//  GL_RG8_SNORM = $8F95;
  GL_RGB8_SNORM = $8F96;
//  GL_RGBA8_SNORM = $8F97;
  GL_SIGNED_NORMALIZED = $8F9C;
  GL_PRIMITIVE_RESTART_FIXED_INDEX = $8D69;
  GL_COPY_READ_BUFFER = $8F36;
  GL_COPY_WRITE_BUFFER = $8F37;
  GL_COPY_READ_BUFFER_BINDING = $8F36;
  GL_COPY_WRITE_BUFFER_BINDING = $8F37;
  GL_UNIFORM_BUFFER = $8A11;
  GL_UNIFORM_BUFFER_BINDING = $8A28;
  GL_UNIFORM_BUFFER_START = $8A29;
  GL_UNIFORM_BUFFER_SIZE = $8A2A;
  GL_MAX_VERTEX_UNIFORM_BLOCKS = $8A2B;
  GL_MAX_FRAGMENT_UNIFORM_BLOCKS = $8A2D;
  GL_MAX_COMBINED_UNIFORM_BLOCKS = $8A2E;
  GL_MAX_UNIFORM_BUFFER_BINDINGS = $8A2F;
  GL_MAX_UNIFORM_BLOCK_SIZE = $8A30;
  GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = $8A31;
  GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = $8A33;
  GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = $8A34;
  GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = $8A35;
  GL_ACTIVE_UNIFORM_BLOCKS = $8A36;
  GL_UNIFORM_TYPE = $8A37;
  GL_UNIFORM_SIZE = $8A38;
  GL_UNIFORM_NAME_LENGTH = $8A39;
  GL_UNIFORM_BLOCK_INDEX = $8A3A;
  GL_UNIFORM_OFFSET = $8A3B;
  GL_UNIFORM_ARRAY_STRIDE = $8A3C;
  GL_UNIFORM_MATRIX_STRIDE = $8A3D;
  GL_UNIFORM_IS_ROW_MAJOR = $8A3E;
  GL_UNIFORM_BLOCK_BINDING = $8A3F;
  GL_UNIFORM_BLOCK_DATA_SIZE = $8A40;
  GL_UNIFORM_BLOCK_NAME_LENGTH = $8A41;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = $8A42;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = $8A43;
  GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = $8A44;
  GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = $8A46;
  GL_INVALID_INDEX = $FFFFFFFF;
  GL_MAX_VERTEX_OUTPUT_COMPONENTS = $9122;
  GL_MAX_FRAGMENT_INPUT_COMPONENTS = $9125;
  GL_MAX_SERVER_WAIT_TIMEOUT = $9111;
  GL_OBJECT_TYPE = $9112;
  GL_SYNC_CONDITION = $9113;
  GL_SYNC_STATUS = $9114;
  GL_SYNC_FLAGS = $9115;
  GL_SYNC_FENCE = $9116;
  GL_SYNC_GPU_COMMANDS_COMPLETE = $9117;
  GL_UNSIGNALED = $9118;
  GL_SIGNALED = $9119;
  GL_ALREADY_SIGNALED = $911A;
  GL_TIMEOUT_EXPIRED = $911B;
  GL_CONDITION_SATISFIED = $911C;
  GL_WAIT_FAILED = $911D;
  GL_SYNC_FLUSH_COMMANDS_BIT = $00000001;
  GL_TIMEOUT_IGNORED = $FFFFFFFFFFFFFFFF;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR = $88FE;
  GL_ANY_SAMPLES_PASSED = $8C2F;
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE = $8D6A;
  GL_SAMPLER_BINDING = $8919;
  GL_RGB10_A2UI = $906F;
  GL_TEXTURE_SWIZZLE_R = $8E42;
  GL_TEXTURE_SWIZZLE_G = $8E43;
  GL_TEXTURE_SWIZZLE_B = $8E44;
  GL_TEXTURE_SWIZZLE_A = $8E45;
  GL_GREEN = $1904;
  GL_BLUE = $1905;
  GL_INT_2_10_10_10_REV = $8D9F;
//  GL_TRANSFORM_FEEDBACK = $8E22;
  GL_TRANSFORM_FEEDBACK_PAUSED = $8E23;
  GL_TRANSFORM_FEEDBACK_ACTIVE = $8E24;
  GL_TRANSFORM_FEEDBACK_BINDING = $8E25;
  GL_PROGRAM_BINARY_RETRIEVABLE_HINT = $8257;
  GL_PROGRAM_BINARY_LENGTH = $8741;
  GL_NUM_PROGRAM_BINARY_FORMATS = $87FE;
  GL_PROGRAM_BINARY_FORMATS = $87FF;
  GL_COMPRESSED_R11_EAC = $9270;
  GL_COMPRESSED_SIGNED_R11_EAC = $9271;
  GL_COMPRESSED_RG11_EAC = $9272;
  GL_COMPRESSED_SIGNED_RG11_EAC = $9273;
  GL_COMPRESSED_RGB8_ETC2 = $9274;
  GL_COMPRESSED_SRGB8_ETC2 = $9275;
  GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = $9276;
  GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = $9277;
  GL_COMPRESSED_RGBA8_ETC2_EAC = $9278;
  GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = $9279;
  GL_TEXTURE_IMMUTABLE_FORMAT = $912F;
  GL_MAX_ELEMENT_INDEX = $8D6B;
  GL_NUM_SAMPLE_COUNTS = $9380;
//  GL_TEXTURE_IMMUTABLE_LEVELS = $82DF;
(*******************************************************************************
*                            GL_ES_VERSION_3_0                                 *
*******************************************************************************)

(*******************************************************************************
*                            GL_ES_VERSION_3_1                                 *
*******************************************************************************)
  GL_COMPUTE_SHADER = $91B9;
  GL_MAX_COMPUTE_UNIFORM_BLOCKS = $91BB;
  GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = $91BC;
  GL_MAX_COMPUTE_IMAGE_UNIFORMS = $91BD;
  GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = $8262;
  GL_MAX_COMPUTE_UNIFORM_COMPONENTS = $8263;
  GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = $8264;
  GL_MAX_COMPUTE_ATOMIC_COUNTERS = $8265;
  GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = $8266;
  GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = $90EB;
  GL_MAX_COMPUTE_WORK_GROUP_COUNT = $91BE;
  GL_MAX_COMPUTE_WORK_GROUP_SIZE = $91BF;
  GL_COMPUTE_WORK_GROUP_SIZE = $8267;
  GL_DISPATCH_INDIRECT_BUFFER = $90EE;
  GL_DISPATCH_INDIRECT_BUFFER_BINDING = $90EF;
  GL_COMPUTE_SHADER_BIT = $00000020;
  GL_DRAW_INDIRECT_BUFFER = $8F3F;
  GL_DRAW_INDIRECT_BUFFER_BINDING = $8F43;
  GL_MAX_UNIFORM_LOCATIONS = $826E;
  GL_FRAMEBUFFER_DEFAULT_WIDTH = $9310;
  GL_FRAMEBUFFER_DEFAULT_HEIGHT = $9311;
  GL_FRAMEBUFFER_DEFAULT_SAMPLES = $9313;
  GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = $9314;
  GL_MAX_FRAMEBUFFER_WIDTH = $9315;
  GL_MAX_FRAMEBUFFER_HEIGHT = $9316;
  GL_MAX_FRAMEBUFFER_SAMPLES = $9318;
  GL_UNIFORM = $92E1;
  GL_UNIFORM_BLOCK = $92E2;
  GL_PROGRAM_INPUT = $92E3;
  GL_PROGRAM_OUTPUT = $92E4;
  GL_BUFFER_VARIABLE = $92E5;
  GL_SHADER_STORAGE_BLOCK = $92E6;
  GL_ATOMIC_COUNTER_BUFFER = $92C0;
  GL_TRANSFORM_FEEDBACK_VARYING = $92F4;
  GL_ACTIVE_RESOURCES = $92F5;
  GL_MAX_NAME_LENGTH = $92F6;
  GL_MAX_NUM_ACTIVE_VARIABLES = $92F7;
  GL_NAME_LENGTH = $92F9;
  GL_TYPE = $92FA;
  GL_ARRAY_SIZE = $92FB;
  GL_OFFSET = $92FC;
  GL_BLOCK_INDEX = $92FD;
  GL_ARRAY_STRIDE = $92FE;
  GL_MATRIX_STRIDE = $92FF;
  GL_IS_ROW_MAJOR = $9300;
  GL_ATOMIC_COUNTER_BUFFER_INDEX = $9301;
  GL_BUFFER_BINDING = $9302;
  GL_BUFFER_DATA_SIZE = $9303;
  GL_NUM_ACTIVE_VARIABLES = $9304;
  GL_ACTIVE_VARIABLES = $9305;
  GL_REFERENCED_BY_VERTEX_SHADER = $9306;
  GL_REFERENCED_BY_FRAGMENT_SHADER = $930A;
  GL_REFERENCED_BY_COMPUTE_SHADER = $930B;
  GL_TOP_LEVEL_ARRAY_SIZE = $930C;
  GL_TOP_LEVEL_ARRAY_STRIDE = $930D;
  GL_LOCATION = $930E;
  GL_VERTEX_SHADER_BIT = $00000001;
  GL_FRAGMENT_SHADER_BIT = $00000002;
  GL_ALL_SHADER_BITS = $FFFFFFFF;
  GL_PROGRAM_SEPARABLE = $8258;
  GL_ACTIVE_PROGRAM = $8259;
  GL_PROGRAM_PIPELINE_BINDING = $825A;
  GL_ATOMIC_COUNTER_BUFFER_BINDING = $92C1;
  GL_ATOMIC_COUNTER_BUFFER_START = $92C2;
  GL_ATOMIC_COUNTER_BUFFER_SIZE = $92C3;
  GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = $92CC;
  GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = $92D0;
  GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = $92D1;
  GL_MAX_VERTEX_ATOMIC_COUNTERS = $92D2;
  GL_MAX_FRAGMENT_ATOMIC_COUNTERS = $92D6;
  GL_MAX_COMBINED_ATOMIC_COUNTERS = $92D7;
  GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = $92D8;
  GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = $92DC;
  GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = $92D9;
  GL_UNSIGNED_INT_ATOMIC_COUNTER = $92DB;
  GL_MAX_IMAGE_UNITS = $8F38;
  GL_MAX_VERTEX_IMAGE_UNIFORMS = $90CA;
  GL_MAX_FRAGMENT_IMAGE_UNIFORMS = $90CE;
  GL_MAX_COMBINED_IMAGE_UNIFORMS = $90CF;
  GL_IMAGE_BINDING_NAME = $8F3A;
  GL_IMAGE_BINDING_LEVEL = $8F3B;
  GL_IMAGE_BINDING_LAYERED = $8F3C;
  GL_IMAGE_BINDING_LAYER = $8F3D;
  GL_IMAGE_BINDING_ACCESS = $8F3E;
  GL_IMAGE_BINDING_FORMAT = $906E;
  GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = $00000001;
  GL_ELEMENT_ARRAY_BARRIER_BIT = $00000002;
  GL_UNIFORM_BARRIER_BIT = $00000004;
  GL_TEXTURE_FETCH_BARRIER_BIT = $00000008;
  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = $00000020;
  GL_COMMAND_BARRIER_BIT = $00000040;
  GL_PIXEL_BUFFER_BARRIER_BIT = $00000080;
  GL_TEXTURE_UPDATE_BARRIER_BIT = $00000100;
  GL_BUFFER_UPDATE_BARRIER_BIT = $00000200;
  GL_FRAMEBUFFER_BARRIER_BIT = $00000400;
  GL_TRANSFORM_FEEDBACK_BARRIER_BIT = $00000800;
  GL_ATOMIC_COUNTER_BARRIER_BIT = $00001000;
  GL_ALL_BARRIER_BITS = $FFFFFFFF;
  GL_IMAGE_2D = $904D;
  GL_IMAGE_3D = $904E;
  GL_IMAGE_CUBE = $9050;
  GL_IMAGE_2D_ARRAY = $9053;
  GL_INT_IMAGE_2D = $9058;
  GL_INT_IMAGE_3D = $9059;
  GL_INT_IMAGE_CUBE = $905B;
  GL_INT_IMAGE_2D_ARRAY = $905E;
  GL_UNSIGNED_INT_IMAGE_2D = $9063;
  GL_UNSIGNED_INT_IMAGE_3D = $9064;
  GL_UNSIGNED_INT_IMAGE_CUBE = $9066;
  GL_UNSIGNED_INT_IMAGE_2D_ARRAY = $9069;
  GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = $90C7;
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = $90C8;
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = $90C9;
  GL_READ_ONLY = $88B8;
  GL_WRITE_ONLY = $88B9;
  GL_READ_WRITE = $88BA;
  GL_SHADER_STORAGE_BUFFER = $90D2;
  GL_SHADER_STORAGE_BUFFER_BINDING = $90D3;
  GL_SHADER_STORAGE_BUFFER_START = $90D4;
  GL_SHADER_STORAGE_BUFFER_SIZE = $90D5;
  GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = $90D6;
  GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = $90DA;
  GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = $90DB;
  GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = $90DC;
  GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = $90DD;
  GL_MAX_SHADER_STORAGE_BLOCK_SIZE = $90DE;
  GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = $90DF;
  GL_SHADER_STORAGE_BARRIER_BIT = $00002000;
  GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = $8F39;
  GL_DEPTH_STENCIL_TEXTURE_MODE = $90EA;
  GL_STENCIL_INDEX = $1901;
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = $8E5E;
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = $8E5F;
  GL_SAMPLE_POSITION = $8E50;
  GL_SAMPLE_MASK = $8E51;
  GL_SAMPLE_MASK_VALUE = $8E52;
//  GL_TEXTURE_2D_MULTISAMPLE = $9100;
  GL_MAX_SAMPLE_MASK_WORDS = $8E59;
  GL_MAX_COLOR_TEXTURE_SAMPLES = $910E;
  GL_MAX_DEPTH_TEXTURE_SAMPLES = $910F;
  GL_MAX_INTEGER_SAMPLES = $9110;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE = $9104;
  GL_TEXTURE_SAMPLES = $9106;
  GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = $9107;
  GL_TEXTURE_WIDTH = $1000;
  GL_TEXTURE_HEIGHT = $1001;
  GL_TEXTURE_DEPTH = $8071;
  GL_TEXTURE_INTERNAL_FORMAT = $1003;
  GL_TEXTURE_RED_SIZE = $805C;
  GL_TEXTURE_GREEN_SIZE = $805D;
  GL_TEXTURE_BLUE_SIZE = $805E;
  GL_TEXTURE_ALPHA_SIZE = $805F;
  GL_TEXTURE_DEPTH_SIZE = $884A;
  GL_TEXTURE_STENCIL_SIZE = $88F1;
  GL_TEXTURE_SHARED_SIZE = $8C3F;
  GL_TEXTURE_RED_TYPE = $8C10;
  GL_TEXTURE_GREEN_TYPE = $8C11;
  GL_TEXTURE_BLUE_TYPE = $8C12;
  GL_TEXTURE_ALPHA_TYPE = $8C13;
  GL_TEXTURE_DEPTH_TYPE = $8C16;
  GL_TEXTURE_COMPRESSED = $86A1;
  GL_SAMPLER_2D_MULTISAMPLE = $9108;
  GL_INT_SAMPLER_2D_MULTISAMPLE = $9109;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = $910A;
  GL_VERTEX_ATTRIB_BINDING = $82D4;
  GL_VERTEX_ATTRIB_RELATIVE_OFFSET = $82D5;
  GL_VERTEX_BINDING_DIVISOR = $82D6;
  GL_VERTEX_BINDING_OFFSET = $82D7;
  GL_VERTEX_BINDING_STRIDE = $82D8;
  GL_VERTEX_BINDING_BUFFER = $8F4F;
  GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = $82D9;
  GL_MAX_VERTEX_ATTRIB_BINDINGS = $82DA;
  GL_MAX_VERTEX_ATTRIB_STRIDE = $82E5;
(*******************************************************************************
*                            GL_ES_VERSION_3_1                                 *
*******************************************************************************)

(*******************************************************************************
*                            GL_ES_VERSION_3_2                                 *
*******************************************************************************)
type
  GLDEBUGPROC = procedure(source:GLenum; _type:GLenum; id:GLuint; severity:GLenum; length:GLsizei;
                  message:PGLchar; userParam:pointer); stdcall;

const
  GL_MULTISAMPLE_LINE_WIDTH_RANGE = $9381;
  GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY = $9382;
  GL_MULTIPLY = $9294;
  GL_SCREEN = $9295;
  GL_OVERLAY = $9296;
  GL_DARKEN = $9297;
  GL_LIGHTEN = $9298;
  GL_COLORDODGE = $9299;
  GL_COLORBURN = $929A;
  GL_HARDLIGHT = $929B;
  GL_SOFTLIGHT = $929C;
  GL_DIFFERENCE = $929E;
  GL_EXCLUSION = $92A0;
  GL_HSL_HUE = $92AD;
  GL_HSL_SATURATION = $92AE;
  GL_HSL_COLOR = $92AF;
  GL_HSL_LUMINOSITY = $92B0;
  GL_DEBUG_OUTPUT_SYNCHRONOUS = $8242;
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = $8243;
  GL_DEBUG_CALLBACK_FUNCTION = $8244;
  GL_DEBUG_CALLBACK_USER_PARAM = $8245;
  GL_DEBUG_SOURCE_API = $8246;
  GL_DEBUG_SOURCE_WINDOW_SYSTEM = $8247;
  GL_DEBUG_SOURCE_SHADER_COMPILER = $8248;
  GL_DEBUG_SOURCE_THIRD_PARTY = $8249;
  GL_DEBUG_SOURCE_APPLICATION = $824A;
  GL_DEBUG_SOURCE_OTHER = $824B;
  GL_DEBUG_TYPE_ERROR = $824C;
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = $824D;
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = $824E;
  GL_DEBUG_TYPE_PORTABILITY = $824F;
  GL_DEBUG_TYPE_PERFORMANCE = $8250;
  GL_DEBUG_TYPE_OTHER = $8251;
  GL_DEBUG_TYPE_MARKER = $8268;
  GL_DEBUG_TYPE_PUSH_GROUP = $8269;
  GL_DEBUG_TYPE_POP_GROUP = $826A;
  GL_DEBUG_SEVERITY_NOTIFICATION = $826B;
  GL_MAX_DEBUG_GROUP_STACK_DEPTH = $826C;
  GL_DEBUG_GROUP_STACK_DEPTH = $826D;
  GL_BUFFER = $82E0;
  GL_SHADER = $82E1;
  GL_PROGRAM = $82E2;
  GL_VERTEX_ARRAY = $8074;
  GL_QUERY = $82E3;
  GL_PROGRAM_PIPELINE = $82E4;
//  GL_SAMPLER = $82E6;
  GL_MAX_LABEL_LENGTH = $82E8;
  GL_MAX_DEBUG_MESSAGE_LENGTH = $9143;
  GL_MAX_DEBUG_LOGGED_MESSAGES = $9144;
  GL_DEBUG_LOGGED_MESSAGES = $9145;
  GL_DEBUG_SEVERITY_HIGH = $9146;
  GL_DEBUG_SEVERITY_MEDIUM = $9147;
  GL_DEBUG_SEVERITY_LOW = $9148;
  GL_DEBUG_OUTPUT = $92E0;
  GL_CONTEXT_FLAG_DEBUG_BIT = $00000002;
  GL_STACK_OVERFLOW = $0503;
  GL_STACK_UNDERFLOW = $0504;
  GL_GEOMETRY_SHADER = $8DD9;
  GL_GEOMETRY_SHADER_BIT = $00000004;
  GL_GEOMETRY_VERTICES_OUT = $8916;
  GL_GEOMETRY_INPUT_TYPE = $8917;
  GL_GEOMETRY_OUTPUT_TYPE = $8918;
  GL_GEOMETRY_SHADER_INVOCATIONS = $887F;
  GL_LAYER_PROVOKING_VERTEX = $825E;
  GL_LINES_ADJACENCY = $000A;
  GL_LINE_STRIP_ADJACENCY = $000B;
  GL_TRIANGLES_ADJACENCY = $000C;
  GL_TRIANGLE_STRIP_ADJACENCY = $000D;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS = $8A2C;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = $8A32;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS = $9123;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = $9124;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES = $8DE0;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = $8DE1;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS = $8E5A;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = $8C29;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = $92CF;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS = $92D5;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS = $90CD;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = $90D7;
  GL_FIRST_VERTEX_CONVENTION = $8E4D;
  GL_LAST_VERTEX_CONVENTION = $8E4E;
  GL_UNDEFINED_VERTEX = $8260;
  GL_PRIMITIVES_GENERATED = $8C87;
  GL_FRAMEBUFFER_DEFAULT_LAYERS = $9312;
  GL_MAX_FRAMEBUFFER_LAYERS = $9317;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = $8DA8;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED = $8DA7;
  GL_REFERENCED_BY_GEOMETRY_SHADER = $9309;
  GL_PRIMITIVE_BOUNDING_BOX = $92BE;
  GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = $00000004;
  GL_CONTEXT_FLAGS = $821E;
  GL_LOSE_CONTEXT_ON_RESET = $8252;
  GL_GUILTY_CONTEXT_RESET = $8253;
  GL_INNOCENT_CONTEXT_RESET = $8254;
  GL_UNKNOWN_CONTEXT_RESET = $8255;
  GL_RESET_NOTIFICATION_STRATEGY = $8256;
  GL_NO_RESET_NOTIFICATION = $8261;
  GL_CONTEXT_LOST = $0507;
  GL_SAMPLE_SHADING = $8C36;
  GL_MIN_SAMPLE_SHADING_VALUE = $8C37;
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = $8E5B;
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = $8E5C;
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = $8E5D;
//  GL_PATCHES = $000E;
  GL_PATCH_VERTICES = $8E72;
  GL_TESS_CONTROL_OUTPUT_VERTICES = $8E75;
  GL_TESS_GEN_MODE = $8E76;
  GL_TESS_GEN_SPACING = $8E77;
  GL_TESS_GEN_VERTEX_ORDER = $8E78;
  GL_TESS_GEN_POINT_MODE = $8E79;
  GL_ISOLINES = $8E7A;
  GL_QUADS = $0007;
  GL_FRACTIONAL_ODD = $8E7B;
  GL_FRACTIONAL_EVEN = $8E7C;
  GL_MAX_PATCH_VERTICES = $8E7D;
  GL_MAX_TESS_GEN_LEVEL = $8E7E;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = $8E7F;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E80;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = $8E81;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = $8E82;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = $8E83;
  GL_MAX_TESS_PATCH_COMPONENTS = $8E84;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = $8E85;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = $8E86;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = $8E89;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = $8E8A;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = $886C;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = $886D;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = $8E1E;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E1F;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = $92CD;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = $92CE;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = $92D3;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = $92D4;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = $90CB;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = $90CC;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = $90D8;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = $90D9;
//  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = $8221;
  GL_IS_PER_PATCH = $92E7;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER = $9307;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER = $9308;
  GL_TESS_CONTROL_SHADER = $8E88;
  GL_TESS_EVALUATION_SHADER = $8E87;
  GL_TESS_CONTROL_SHADER_BIT = $00000008;
  GL_TESS_EVALUATION_SHADER_BIT = $00000010;
  GL_TEXTURE_BORDER_COLOR = $1004;
  GL_CLAMP_TO_BORDER = $812D;
  GL_TEXTURE_BUFFER = $8C2A;
  GL_TEXTURE_BUFFER_BINDING = $8C2A;
  GL_MAX_TEXTURE_BUFFER_SIZE = $8C2B;
  GL_TEXTURE_BINDING_BUFFER = $8C2C;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING = $8C2D;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = $919F;
  GL_SAMPLER_BUFFER = $8DC2;
  GL_INT_SAMPLER_BUFFER = $8DD0;
  GL_UNSIGNED_INT_SAMPLER_BUFFER = $8DD8;
  GL_IMAGE_BUFFER = $9051;
  GL_INT_IMAGE_BUFFER = $905C;
  GL_UNSIGNED_INT_IMAGE_BUFFER = $9067;
  GL_TEXTURE_BUFFER_OFFSET = $919D;
  GL_TEXTURE_BUFFER_SIZE = $919E;
  GL_COMPRESSED_RGBA_ASTC_4x4 = $93B0;
  GL_COMPRESSED_RGBA_ASTC_5x4 = $93B1;
  GL_COMPRESSED_RGBA_ASTC_5x5 = $93B2;
  GL_COMPRESSED_RGBA_ASTC_6x5 = $93B3;
  GL_COMPRESSED_RGBA_ASTC_6x6 = $93B4;
  GL_COMPRESSED_RGBA_ASTC_8x5 = $93B5;
  GL_COMPRESSED_RGBA_ASTC_8x6 = $93B6;
  GL_COMPRESSED_RGBA_ASTC_8x8 = $93B7;
  GL_COMPRESSED_RGBA_ASTC_10x5 = $93B8;
  GL_COMPRESSED_RGBA_ASTC_10x6 = $93B9;
  GL_COMPRESSED_RGBA_ASTC_10x8 = $93BA;
  GL_COMPRESSED_RGBA_ASTC_10x10 = $93BB;
  GL_COMPRESSED_RGBA_ASTC_12x10 = $93BC;
  GL_COMPRESSED_RGBA_ASTC_12x12 = $93BD;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = $93D0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = $93D1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = $93D2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = $93D3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = $93D4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = $93D5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = $93D6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = $93D7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = $93D8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = $93D9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = $93DA;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = $93DB;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = $93DC;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = $93DD;
  GL_TEXTURE_CUBE_MAP_ARRAY = $9009;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = $900A;
  GL_SAMPLER_CUBE_MAP_ARRAY = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = $900D;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY = $900E;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = $900F;
  GL_IMAGE_CUBE_MAP_ARRAY = $9054;
  GL_INT_IMAGE_CUBE_MAP_ARRAY = $905F;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = $906A;
//  GL_TEXTURE_2D_MULTISAMPLE_ARRAY = $9102;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = $9105;
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY = $910B;
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910C;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910D;
(*******************************************************************************
*                            GL_ES_VERSION_3_2                                 *
*******************************************************************************)


var
  GL_VERSION_ES_CM_1_0: Boolean;
  GL_ES_VERSION_2_0: Boolean;
  GL_ES_VERSION_3_0: Boolean;
  GL_ES_VERSION_3_1: Boolean;
  GL_ES_VERSION_3_2: Boolean;

  GL_OES_framebuffer_object: Boolean;                 // "подмена понятий"
  GL_OES_blend_func_separate: Boolean;                // "подмена понятий"
  GL_IMG_texture_compression_pvrtc: Boolean;
  GL_EXT_texture_filter_anisotropic: Boolean;
  GL_OES_depth24: Boolean;
  GL_OES_depth32: Boolean;
  {$IfDef GL_VERSION_ES_CM_1_0}
  GL_OES_compressed_paletted_texture: Boolean;
  GL_OES_point_size_array: Boolean;
  GL_OES_point_sprite: Boolean;
  GL_KHR_debug: Boolean;
  GL_OES_EGL_image: Boolean;
  GL_OES_EGL_image_external: Boolean;
  GL_OES_blend_equation_separate: Boolean;
  GL_OES_blend_subtract: Boolean;
  GL_OES_byte_coordinates: Boolean;
  GL_OES_compressed_ETC1_RGB8_sub_texture: Boolean;
  GL_OES_compressed_ETC1_RGB8_texture: Boolean;
//  GL_OES_depth24: Boolean;
//  GL_OES_depth32: Boolean;
  GL_OES_draw_texture: Boolean;
  GL_OES_element_index_uint: Boolean;
  GL_OES_extended_matrix_palette: Boolean;
  GL_OES_fbo_render_mipmap: Boolean;
  GL_OES_fixed_point: Boolean;
//  GL_OES_framebuffer_object: Boolean;
  GL_OES_mapbuffer: Boolean;
  GL_OES_matrix_get: Boolean;
  GL_OES_matrix_palette: Boolean;
  GL_OES_packed_depth_stencil: Boolean;
  GL_OES_query_matrix: Boolean;
  GL_OES_required_internalformat: Boolean;
  GL_OES_rgb8_rgba8: Boolean;
  GL_OES_single_precision: Boolean;
  GL_OES_stencil1: Boolean;
  GL_OES_stencil4: Boolean;
  GL_OES_stencil8: Boolean;
  GL_OES_stencil_wrap: Boolean;
  GL_OES_surfaceless_context: Boolean;
  GL_OES_texture_cube_map: Boolean;
  GL_OES_texture_env_crossbar: Boolean;
  GL_OES_texture_mirrored_repeat: Boolean;
  GL_OES_texture_npot: Boolean;
  GL_OES_vertex_array_object: Boolean;
  GL_AMD_compressed_3DC_texture: Boolean;
  GL_AMD_compressed_ATC_texture: Boolean;
  GL_APPLE_copy_texture_levels: Boolean;
  GL_APPLE_framebuffer_multisample: Boolean;
  GL_APPLE_sync: Boolean;
  GL_APPLE_texture_2D_limited_npot: Boolean;
  GL_APPLE_texture_format_BGRA8888: Boolean;
  GL_APPLE_texture_max_level: Boolean;
  GL_ARM_rgba8: Boolean;
  GL_EXT_blend_minmax: Boolean;
  GL_EXT_debug_marker: Boolean;
  GL_EXT_discard_framebuffer: Boolean;
  GL_EXT_map_buffer_range: Boolean;
  GL_EXT_multi_draw_arrays: Boolean;
  GL_EXT_multisampled_render_to_texture: Boolean;
  GL_EXT_read_format_bgra: Boolean;
  GL_EXT_robustness: Boolean;
  GL_EXT_sRGB: Boolean;
  GL_EXT_texture_compression_dxt1: Boolean;
//  GL_EXT_texture_filter_anisotropic: Boolean;
  GL_EXT_texture_format_BGRA8888: Boolean;
  GL_EXT_texture_lod_bias: Boolean;
  GL_EXT_texture_storage: Boolean;
  GL_IMG_multisampled_render_to_texture: Boolean;
  GL_IMG_read_format: Boolean;
//  GL_IMG_texture_compression_pvrtc: Boolean;
  GL_IMG_texture_env_enhanced_fixed_function: Boolean;
  GL_IMG_user_clip_plane: Boolean;
  GL_NV_fence: Boolean;
  GL_QCOM_driver_control: Boolean;
  GL_QCOM_extended_get: Boolean;
  GL_QCOM_extended_get2: Boolean;
  GL_QCOM_perfmon_global_mode: Boolean;
  GL_QCOM_tiled_rendering: Boolean;
  GL_QCOM_writeonly_rendering: Boolean;
{$EndIf}

{$IFDEF GL_ES_EXT_VERSION_2_0}
  GL_KHR_blend_equation_advanced: Boolean;
  GL_KHR_blend_equation_advanced_coherent: Boolean;
  GL_KHR_context_flush_control: Boolean;
  GL_KHR_debug: Boolean;
  GL_KHR_no_error: Boolean;
  GL_KHR_parallel_shader_compile: Boolean;
  GL_KHR_robust_buffer_access_behavior: Boolean;
  GL_KHR_robustness: Boolean;
  GL_KHR_shader_subgroup: Boolean;
  GL_KHR_texture_compression_astc_hdr: Boolean;
  GL_KHR_texture_compression_astc_ldr: Boolean;
  GL_KHR_texture_compression_astc_sliced_3d: Boolean;
  GL_OES_EGL_image: Boolean;
  GL_OES_EGL_image_external: Boolean;
  GL_OES_EGL_image_external_essl3: Boolean;
  GL_OES_compressed_ETC1_RGB8_sub_texture: Boolean;
  GL_OES_compressed_ETC1_RGB8_texture: Boolean;
  GL_OES_compressed_paletted_texture: Boolean;
  GL_OES_copy_image: Boolean;
//  GL_OES_depth24: Boolean;
//  GL_OES_depth32: Boolean;
  GL_OES_depth_texture: Boolean;
  GL_OES_draw_buffers_indexed: Boolean;
  GL_OES_draw_elements_base_vertex: Boolean;
  GL_OES_element_index_uint: Boolean;
  GL_OES_fbo_render_mipmap: Boolean;
  GL_OES_fragment_precision_high: Boolean;
  GL_OES_geometry_point_size: Boolean;
  GL_OES_geometry_shader: Boolean;
  GL_OES_get_program_binary: Boolean;
  GL_OES_gpu_shader5: Boolean;
  GL_OES_mapbuffer: Boolean;
  GL_OES_packed_depth_stencil: Boolean;
  GL_OES_primitive_bounding_box: Boolean;
  GL_OES_required_internalformat: Boolean;
  GL_OES_rgb8_rgba8: Boolean;
  GL_OES_sample_shading: Boolean;
  GL_OES_sample_variables: Boolean;
  GL_OES_shader_image_atomic: Boolean;
  GL_OES_shader_io_blocks: Boolean;
  GL_OES_shader_multisample_interpolation: Boolean;
  GL_OES_standard_derivatives: Boolean;
  GL_OES_stencil1: Boolean;
  GL_OES_stencil4: Boolean;
  GL_OES_surfaceless_context: Boolean;
  GL_OES_tessellation_point_size: Boolean;
  GL_OES_tessellation_shader: Boolean;
  GL_OES_texture_3D: Boolean;
  GL_OES_texture_border_clamp: Boolean;
  GL_OES_texture_buffer: Boolean;
  GL_OES_texture_compression_astc: Boolean;
  GL_OES_texture_cube_map_array: Boolean;
  GL_OES_texture_float: Boolean;
  GL_OES_texture_float_linear: Boolean;
  GL_OES_texture_half_float: Boolean;
  GL_OES_texture_half_float_linear: Boolean;
  GL_OES_texture_npot: Boolean;
  GL_OES_texture_stencil8: Boolean;
  GL_OES_texture_storage_multisample_2d_array: Boolean;
  GL_OES_texture_view: Boolean;
  GL_OES_vertex_array_object: Boolean;
  GL_OES_vertex_half_float: Boolean;
  GL_OES_vertex_type_10_10_10_2: Boolean;
  GL_OES_viewport_array: Boolean;
  GL_AMD_compressed_3DC_texture: Boolean;
  GL_AMD_compressed_ATC_texture: Boolean;
  GL_AMD_framebuffer_multisample_advanced: Boolean;
  GL_AMD_performance_monitor: Boolean;
  GL_AMD_program_binary_Z400: Boolean;
  GL_ANDROID_extension_pack_es31a: Boolean;
  GL_ANGLE_depth_texture: Boolean;
  GL_ANGLE_framebuffer_blit: Boolean;
  GL_ANGLE_framebuffer_multisample: Boolean;
  GL_ANGLE_instanced_arrays: Boolean;
  GL_ANGLE_pack_reverse_row_order: Boolean;
  GL_ANGLE_program_binary: Boolean;
  GL_ANGLE_texture_compression_dxt3: Boolean;
  GL_ANGLE_texture_compression_dxt5: Boolean;
  GL_ANGLE_texture_usage: Boolean;
  GL_ANGLE_translated_shader_source: Boolean;
  GL_APPLE_clip_distance: Boolean;
  GL_APPLE_color_buffer_packed_float: Boolean;
  GL_APPLE_copy_texture_levels: Boolean;
  GL_APPLE_framebuffer_multisample: Boolean;
  GL_APPLE_rgb_422: Boolean;
  GL_APPLE_sync: Boolean;
  GL_APPLE_texture_format_BGRA8888: Boolean;
  GL_APPLE_texture_max_level: Boolean;
  GL_APPLE_texture_packed_float: Boolean;
  GL_ARM_mali_program_binary: Boolean;
  GL_ARM_mali_shader_binary: Boolean;
  GL_ARM_rgba8: Boolean;
  GL_ARM_shader_framebuffer_fetch: Boolean;
  GL_ARM_shader_framebuffer_fetch_depth_stencil: Boolean;
  GL_ARM_texture_unnormalized_coordinates: Boolean;
  GL_DMP_program_binary: Boolean;
  GL_DMP_shader_binary: Boolean;
  GL_EXT_EGL_image_array: Boolean;
  GL_EXT_EGL_image_storage: Boolean;
  GL_EXT_EGL_image_storage_compression: Boolean;
  GL_EXT_YUV_target: Boolean;
  GL_EXT_base_instance: Boolean;
  GL_EXT_blend_func_extended: Boolean;
  GL_EXT_blend_minmax: Boolean;
  GL_EXT_buffer_storage: Boolean;
  GL_EXT_clear_texture: Boolean;
  GL_EXT_clip_control: Boolean;
  GL_EXT_clip_cull_distance: Boolean;
  GL_EXT_color_buffer_float: Boolean;
  GL_EXT_color_buffer_half_float: Boolean;
  GL_EXT_conservative_depth: Boolean;
  GL_EXT_copy_image: Boolean;
  GL_EXT_debug_label: Boolean;
  GL_EXT_debug_marker: Boolean;
  GL_EXT_depth_clamp: Boolean;
  GL_EXT_discard_framebuffer: Boolean;
  GL_EXT_disjoint_timer_query: Boolean;
  GL_EXT_draw_buffers: Boolean;
  GL_EXT_draw_elements_base_vertex: Boolean;
  GL_EXT_draw_instanced: Boolean;
  GL_EXT_draw_transform_feedback: Boolean;
  GL_EXT_external_buffer: Boolean;
  GL_EXT_float_blend: Boolean;
  GL_EXT_fragment_shading_rate: Boolean;
  GL_EXT_framebuffer_blit_layers: Boolean;
  GL_EXT_geometry_point_size: Boolean;
  GL_EXT_geometry_shader: Boolean;
  GL_EXT_gpu_shader5: Boolean;
  GL_EXT_instanced_arrays: Boolean;
  GL_EXT_map_buffer_range: Boolean;
  GL_EXT_memory_object: Boolean;
  GL_EXT_memory_object_fd: Boolean;
  GL_EXT_memory_object_win32: Boolean;
  GL_EXT_multi_draw_arrays: Boolean;
  GL_EXT_multi_draw_indirect: Boolean;
  GL_EXT_multisampled_compatibility: Boolean;
  GL_EXT_multisampled_render_to_texture: Boolean;
  GL_EXT_multisampled_render_to_texture2: Boolean;
  GL_EXT_multiview_draw_buffers: Boolean;
  GL_EXT_multiview_tessellation_geometry_shader: Boolean;
  GL_EXT_multiview_texture_multisample: Boolean;
  GL_EXT_multiview_timer_query: Boolean;
  GL_EXT_occlusion_query_boolean: Boolean;
  GL_EXT_polygon_offset_clamp: Boolean;
  GL_EXT_post_depth_coverage: Boolean;
  GL_EXT_primitive_bounding_box: Boolean;
  GL_EXT_protected_textures: Boolean;
  GL_EXT_pvrtc_sRGB: Boolean;
  GL_EXT_raster_multisample: Boolean;
  GL_EXT_read_format_bgra: Boolean;
  GL_EXT_render_snorm: Boolean;
  GL_EXT_robustness: Boolean;
  GL_EXT_sRGB: Boolean;
  GL_EXT_sRGB_write_control: Boolean;
  GL_EXT_semaphore: Boolean;
  GL_EXT_semaphore_fd: Boolean;
  GL_EXT_semaphore_win32: Boolean;
  GL_EXT_separate_depth_stencil: Boolean;
  GL_EXT_separate_shader_objects: Boolean;
  GL_EXT_shader_framebuffer_fetch: Boolean;
  GL_EXT_shader_framebuffer_fetch_non_coherent: Boolean;
  GL_EXT_shader_group_vote: Boolean;
  GL_EXT_shader_implicit_conversions: Boolean;
  GL_EXT_shader_integer_mix: Boolean;
  GL_EXT_shader_io_blocks: Boolean;
  GL_EXT_shader_non_constant_global_initializers: Boolean;
  GL_EXT_shader_pixel_local_storage: Boolean;
  GL_EXT_shader_pixel_local_storage2: Boolean;
  GL_EXT_shader_samples_identical: Boolean;
  GL_EXT_shader_texture_lod: Boolean;
  GL_EXT_shadow_samplers: Boolean;
  GL_EXT_sparse_texture: Boolean;
  GL_EXT_sparse_texture2: Boolean;
  GL_EXT_tessellation_point_size: Boolean;
  GL_EXT_tessellation_shader: Boolean;
  GL_EXT_texture_border_clamp: Boolean;
  GL_EXT_texture_buffer: Boolean;
  GL_EXT_texture_compression_astc_decode_mode: Boolean;
  GL_EXT_texture_compression_bptc: Boolean;
  GL_EXT_texture_compression_dxt1: Boolean;
  GL_EXT_texture_compression_rgtc: Boolean;
  GL_EXT_texture_compression_s3tc: Boolean;
  GL_EXT_texture_compression_s3tc_srgb: Boolean;
  GL_EXT_texture_cube_map_array: Boolean;
//  GL_EXT_texture_filter_anisotropic: Boolean;
  GL_EXT_texture_filter_minmax: Boolean;
  GL_EXT_texture_format_BGRA8888: Boolean;
  GL_EXT_texture_format_sRGB_override: Boolean;
  GL_EXT_texture_mirror_clamp_to_edge: Boolean;
  GL_EXT_texture_norm16: Boolean;
  GL_EXT_texture_query_lod: Boolean;
  GL_EXT_texture_rg: Boolean;
  GL_EXT_texture_sRGB_R8: Boolean;
  GL_EXT_texture_sRGB_RG8: Boolean;
  GL_EXT_texture_sRGB_decode: Boolean;
  GL_EXT_texture_shadow_lod: Boolean;
  GL_EXT_texture_storage: Boolean;
  GL_EXT_texture_storage_compression: Boolean;
  GL_EXT_texture_type_2_10_10_10_REV: Boolean;
  GL_EXT_texture_view: Boolean;
  GL_EXT_unpack_subimage: Boolean;
  GL_EXT_win32_keyed_mutex: Boolean;
  GL_EXT_window_rectangles: Boolean;
  GL_FJ_shader_binary_GCCSO: Boolean;
  GL_IMG_bindless_texture: Boolean;
  GL_IMG_framebuffer_downsample: Boolean;
  GL_IMG_multisampled_render_to_texture: Boolean;
  GL_IMG_program_binary: Boolean;
  GL_IMG_read_format: Boolean;
  GL_IMG_shader_binary: Boolean;
//  GL_IMG_texture_compression_pvrtc: Boolean;
  GL_IMG_texture_compression_pvrtc2: Boolean;
  GL_IMG_texture_filter_cubic: Boolean;
  GL_INTEL_blackhole_render: Boolean;
  GL_INTEL_conservative_rasterization: Boolean;
  GL_INTEL_framebuffer_CMAA: Boolean;
  GL_INTEL_performance_query: Boolean;
  GL_MESA_bgra: Boolean;
  GL_MESA_framebuffer_flip_x: Boolean;
  GL_MESA_framebuffer_flip_y: Boolean;
  GL_MESA_framebuffer_swap_xy: Boolean;
  GL_MESA_program_binary_formats: Boolean;
  GL_MESA_shader_integer_functions: Boolean;
  GL_NVX_blend_equation_advanced_multi_draw_buffers: Boolean;
  GL_NV_bindless_texture: Boolean;
  GL_NV_blend_equation_advanced: Boolean;
  GL_NV_blend_equation_advanced_coherent: Boolean;
  GL_NV_blend_minmax_factor: Boolean;
  GL_NV_clip_space_w_scaling: Boolean;
  GL_NV_compute_shader_derivatives: Boolean;
  GL_NV_conditional_render: Boolean;
  GL_NV_conservative_raster: Boolean;
  GL_NV_conservative_raster_pre_snap: Boolean;
  GL_NV_conservative_raster_pre_snap_triangles: Boolean;
  GL_NV_copy_buffer: Boolean;
  GL_NV_coverage_sample: Boolean;
  GL_NV_depth_nonlinear: Boolean;
  GL_NV_draw_buffers: Boolean;
  GL_NV_draw_instanced: Boolean;
  GL_NV_draw_vulkan_image: Boolean;
  GL_NV_explicit_attrib_location: Boolean;
  GL_NV_fbo_color_attachments: Boolean;
  GL_NV_fence: Boolean;
  GL_NV_fill_rectangle: Boolean;
  GL_NV_fragment_coverage_to_color: Boolean;
  GL_NV_fragment_shader_barycentric: Boolean;
  GL_NV_fragment_shader_interlock: Boolean;
  GL_NV_framebuffer_blit: Boolean;
  GL_NV_framebuffer_mixed_samples: Boolean;
  GL_NV_framebuffer_multisample: Boolean;
  GL_NV_generate_mipmap_sRGB: Boolean;
  GL_NV_geometry_shader_passthrough: Boolean;
  GL_NV_gpu_shader5: Boolean;
  GL_NV_image_formats: Boolean;
  GL_NV_instanced_arrays: Boolean;
  GL_NV_internalformat_sample_query: Boolean;
  GL_NV_memory_attachment: Boolean;
  GL_NV_memory_object_sparse: Boolean;
  GL_NV_mesh_shader: Boolean;
  GL_NV_non_square_matrices: Boolean;
  GL_NV_pack_subimage: Boolean;
  GL_NV_path_rendering: Boolean;
  GL_NV_path_rendering_shared_edge: Boolean;
  GL_NV_pixel_buffer_object: Boolean;
  GL_NV_polygon_mode: Boolean;
  GL_NV_primitive_shading_rate: Boolean;
  GL_NV_read_buffer: Boolean;
  GL_NV_read_buffer_front: Boolean;
  GL_NV_read_depth: Boolean;
  GL_NV_read_depth_stencil: Boolean;
  GL_NV_read_stencil: Boolean;
  GL_NV_representative_fragment_test: Boolean;
  GL_NV_sRGB_formats: Boolean;
  GL_NV_sample_locations: Boolean;
  GL_NV_sample_mask_override_coverage: Boolean;
  GL_NV_scissor_exclusive: Boolean;
  GL_NV_shader_atomic_fp16_vector: Boolean;
  GL_NV_shader_noperspective_interpolation: Boolean;
  GL_NV_shader_subgroup_partitioned: Boolean;
  GL_NV_shader_texture_footprint: Boolean;
  GL_NV_shading_rate_image: Boolean;
  GL_NV_shadow_samplers_array: Boolean;
  GL_NV_shadow_samplers_cube: Boolean;
  GL_NV_stereo_view_rendering: Boolean;
  GL_NV_texture_border_clamp: Boolean;
  GL_NV_texture_compression_s3tc_update: Boolean;
  GL_NV_texture_npot_2D_mipmap: Boolean;
  GL_NV_timeline_semaphore: Boolean;
  GL_NV_viewport_array: Boolean;
  GL_NV_viewport_array2: Boolean;
  GL_NV_viewport_swizzle: Boolean;
  GL_OVR_multiview: Boolean;
  GL_OVR_multiview2: Boolean;
  GL_OVR_multiview_multisampled_render_to_texture: Boolean;
  GL_QCOM_YUV_texture_gather: Boolean;
  GL_QCOM_alpha_test: Boolean;
  GL_QCOM_binning_control: Boolean;
  GL_QCOM_driver_control: Boolean;
  GL_QCOM_extended_get: Boolean;
  GL_QCOM_extended_get2: Boolean;
  GL_QCOM_frame_extrapolation: Boolean;
  GL_QCOM_framebuffer_foveated: Boolean;
  GL_QCOM_motion_estimation: Boolean;
  GL_QCOM_perfmon_global_mode: Boolean;
  GL_QCOM_render_shared_exponent: Boolean;
  GL_QCOM_shader_framebuffer_fetch_noncoherent: Boolean;
  GL_QCOM_shader_framebuffer_fetch_rate: Boolean;
  GL_QCOM_shading_rate: Boolean;
  GL_QCOM_texture_foveated: Boolean;
  GL_QCOM_texture_foveated2: Boolean;
  GL_QCOM_texture_foveated_subsampled_layout: Boolean;
  GL_QCOM_tiled_rendering: Boolean;
  GL_QCOM_writeonly_rendering: Boolean;
  GL_VIV_shader_binary: Boolean;
{$EndIf}

{$IfDef GL_VERSION_ES_CM_1_0}
var
// min GLES function - glAlphaFunc: procedure(func:GLenum; ref:GLfloat); stdcall;
// min GLES function - glClearColor: procedure(red, green, blue, alpha:GLfloat); stdcall;
// min GLES function - glClearDepthf: procedure(d:GLfloat); stdcall;
  glClipPlanef: procedure(p:GLenum; eqn:PGLfloat); stdcall;
// min GLES function - glColor4f: procedure(red, green, blue, alpha:GLfloat); stdcall;
  glDepthRangef: procedure(n:GLfloat; f:GLfloat); stdcall;
  glFogf: procedure(pname:GLenum; param:GLfloat); stdcall;
  glFogfv: procedure(pname:GLenum; params:PGLfloat); stdcall;
  glFrustumf: procedure(l:GLfloat; r:GLfloat; b:GLfloat; t:GLfloat; n:GLfloat; f:GLfloat); stdcall;
  glGetClipPlanef: procedure(plane:GLenum; equation:PGLfloat); stdcall;
// min GLES function - glGetFloatv: procedure(pname:GLenum; data:PGLfloat); stdcall;
  glGetLightfv: procedure(light:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glGetMaterialfv: procedure(face:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glGetTexEnvfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glGetTexParameterfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glLightModelf: procedure(pname:GLenum; param:GLfloat); stdcall;
  glLightModelfv: procedure(pname:GLenum; params:PGLfloat); stdcall;
  glLightf: procedure(light:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glLightfv: procedure(light:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glLineWidth: procedure(width:GLfloat); stdcall;
// min GLES function - glLoadMatrixf: procedure(m:PGLfloat); stdcall;
  glMaterialf: procedure(face:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glMaterialfv: procedure(face:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glMultMatrixf: procedure(m:PGLfloat); stdcall;
  glMultiTexCoord4f: procedure(target:GLenum; s:GLfloat; t:GLfloat; r:GLfloat; q:GLfloat); stdcall;
  glNormal3f: procedure(nx:GLfloat; ny:GLfloat; nz:GLfloat); stdcall;
// min GLES function - glOrthof: procedure(l, r, b, t, n, f:GLfloat); stdcall;
  glPointParameterf: procedure(pname:GLenum; param:GLfloat); stdcall;
  glPointParameterfv: procedure(pname:GLenum; params:PGLfloat); stdcall;
  glPointSize: procedure(size:GLfloat); stdcall;
  glPolygonOffset: procedure(factor:GLfloat; units:GLfloat); stdcall;
// min GLES function - glRotatef: procedure(angle:GLfloat; x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
// min GLES function - glScalef: procedure(x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glTexEnvf: procedure(target:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glTexEnvfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
// min GLES function - glTexParameterf: procedure(target:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glTexParameterfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
// min GLES function - glTranslatef: procedure(x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glActiveTexture: procedure(texture:GLenum); stdcall;
  glAlphaFuncx: procedure(func:GLenum; ref:GLfixed); stdcall;
  glBindBuffer: procedure(target:GLenum; buffer:GLuint); stdcall;
// min GLES function - glBindTexture: procedure(target:GLenum; texture:GLuint); stdcall;
// min GLES function - glBlendFunc: procedure(sfactor, dfactor:GLenum); stdcall;
  glBufferData: procedure(target:GLenum; size:GLsizeiptr; data:pointer; usage:GLenum); stdcall;
  glBufferSubData: procedure(target:GLenum; offset:GLintptr; size:GLsizeiptr; data:pointer); stdcall;
// min GLES function - glClear: procedure(mask:GLbitfield); stdcall;
  glClearColorx: procedure(red:GLfixed; green:GLfixed; blue:GLfixed; alpha:GLfixed); stdcall;
  glClearDepthx: procedure(depth:GLfixed); stdcall;
  glClearStencil: procedure(s:GLint); stdcall;
  glClientActiveTexture: procedure(texture:GLenum); stdcall;
  glClipPlanex: procedure(plane:GLenum; equation:PGLfixed); stdcall;
  glColor4ub: procedure(red:GLubyte; green:GLubyte; blue:GLubyte; alpha:GLubyte); stdcall;
  glColor4x: procedure(red:GLfixed; green:GLfixed; blue:GLfixed; alpha:GLfixed); stdcall;
// min GLES function - glColorMask: procedure(red, green, blue, alpha:GLboolean); stdcall;
// min GLES function - glColorPointer: procedure(size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
// min GLES function - glCompressedTexImage2D: procedure(target:GLenum; level:GLint; internalformat:GLenum; width, height:GLsizei; border:GLint; imageSize:GLsizei; data:pointer); stdcall;
// min GLES function - glCompressedTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; width:GLsizei; height:GLsizei; format:GLenum; imageSize:GLsizei; data:pointer); stdcall;
  glCopyTexImage2D: procedure(target:GLenum; level:GLint; internalformat:GLenum; x:GLint; y:GLint;
              width:GLsizei; height:GLsizei; border:GLint); stdcall;
// min GLES function - glCopyTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
  glCullFace: procedure(mode:GLenum); stdcall;
  glDeleteBuffers: procedure(n:GLsizei; buffers:PGLuint); stdcall;
// min GLES function - glDeleteTextures: procedure(n:GLsizei; textures:PGLuint); stdcall;
// min GLES function - glDepthFunc: procedure(func:GLenum); stdcall;
// min GLES function - glDepthMask: procedure(flag:GLboolean); stdcall;
  glDepthRangex: procedure(n:GLfixed; f:GLfixed); stdcall;
// min GLES function - glDisable: procedure(cap:GLenum); stdcall;
// min GLES function - glDisableClientState: procedure(_array:GLenum); stdcall;
// min GLES function - glDrawArrays: procedure(mode:GLenum; first:GLint; count:GLsizei); stdcall;
// min GLES function - glDrawElements: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer); stdcall;
// min GLES function - glEnable: procedure(cap:GLenum); stdcall;
// min GLES function - glEnableClientState: procedure(_array:GLenum); stdcall;
  glFinish: procedure; stdcall;
  glFlush: procedure; stdcall;
  glFogx: procedure(pname:GLenum; param:GLfixed); stdcall;
  glFogxv: procedure(pname:GLenum; param:PGLfixed); stdcall;
  glFrontFace: procedure(mode:GLenum); stdcall;
  glFrustumx: procedure(l:GLfixed; r:GLfixed; b:GLfixed; t:GLfixed; n:GLfixed; f:GLfixed); stdcall;
  glGetBooleanv: procedure(pname:GLenum; data:PGLboolean); stdcall;
  glGetBufferParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetClipPlanex: procedure(plane:GLenum; equation:PGLfixed); stdcall;
  glGenBuffers: procedure(n:GLsizei; buffers:PGLuint); stdcall;
// min GLES function - glGenTextures: procedure(n:GLsizei; textures:PGLuint); stdcall;
  glGetError: function: GLenum; stdcall;
  glGetFixedv: procedure(pname:GLenum; params:PGLfixed); stdcall;
// min GLES function - glGetIntegerv: procedure(pname:GLenum; data:PGLint); stdcall;
  glGetLightxv: procedure(light:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glGetMaterialxv: procedure(face:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glGetPointerv: procedure(pname:GLenum; params:Ppointer); stdcall;
// min GLES function - glGetString: function(name:GLenum):PGLubyte; stdcall;
  glGetTexEnviv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexEnvxv: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glGetTexParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexParameterxv: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
// min GLES function - glHint: procedure(target:GLenum; mode:GLenum); stdcall;
  glIsBuffer: function(buffer:GLuint):GLboolean; stdcall;
  glIsEnabled: function(cap:GLenum):GLboolean; stdcall;
  glIsTexture: function(texture:GLuint):GLboolean; stdcall;
  glLightModelx: procedure(pname:GLenum; param:GLfixed); stdcall;
  glLightModelxv: procedure(pname:GLenum; param:PGLfixed); stdcall;
  glLightx: procedure(light:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glLightxv: procedure(light:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glLineWidthx: procedure(width:GLfixed); stdcall;
// min GLES function - glLoadIdentity: procedure; stdcall;
  glLoadMatrixx: procedure(m:PGLfixed); stdcall;
  glLogicOp: procedure(opcode:GLenum); stdcall;
  glMaterialx: procedure(face:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glMaterialxv: procedure(face:GLenum; pname:GLenum; param:PGLfixed); stdcall;
// min GLES function - glMatrixMode: procedure(mode:GLenum); stdcall;
  glMultMatrixx: procedure(m:PGLfixed); stdcall;
  glMultiTexCoord4x: procedure(texture:GLenum; s:GLfixed; t:GLfixed; r:GLfixed; q:GLfixed); stdcall;
  glNormal3x: procedure(nx:GLfixed; ny:GLfixed; nz:GLfixed); stdcall;
  glNormalPointer: procedure(_type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
  glOrthox: procedure(l:GLfixed; r:GLfixed; b:GLfixed; t:GLfixed; n:GLfixed; f:GLfixed); stdcall;
// min GLES function - glPixelStorei: procedure(pname:GLenum; param:GLint); stdcall;
  glPointParameterx: procedure(pname:GLenum; param:GLfixed); stdcall;
  glPointParameterxv: procedure(pname:GLenum; params:PGLfixed); stdcall;
  glPointSizex: procedure(size:GLfixed); stdcall;
  glPolygonOffsetx: procedure(factor:GLfixed; units:GLfixed); stdcall;
// min GLES function - glPopMatrix: procedure; stdcall;
// min GLES function - glPushMatrix: procedure; stdcall;
// min GLES function - glReadPixels: procedure(x, y:GLint; width, height:GLsizei; format, _type:GLenum; pixels:pointer); stdcall;
  glRotatex: procedure(angle:GLfixed; x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
  glSampleCoverage: procedure(value:GLfloat; invert:GLboolean); stdcall;
  glSampleCoveragex: procedure(value:GLclampx; invert:GLboolean); stdcall;
  glScalex: procedure(x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
// min GLES function - glScissor: procedure(x, y:GLint; width, height:GLsizei); stdcall;
// min GLES function - glShadeModel: procedure(mode:GLenum); stdcall;
  glStencilFunc: procedure(func:GLenum; ref:GLint; mask:GLuint); stdcall;
  glStencilMask: procedure(mask:GLuint); stdcall;
  glStencilOp: procedure(fail:GLenum; zfail:GLenum; zpass:GLenum); stdcall;
// min GLES function - glTexCoordPointer: procedure(size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
// min GLES function - glTexEnvi: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
// min GLES function - glTexEnvx: procedure(target:GLenum; pname:GLenum; param:GLfixed); stdcall;
// min GLES function - glTexEnviv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glTexEnvxv: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
// min GLES function - glTexImage2D: procedure(target:GLenum; level, internalformat:GLint; width, height:GLsizei; border:GLint; format, _type:GLenum; pixels:pointer); stdcall;
// min GLES function - glTexParameteri: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
// min GLES function - glTexParameterx: procedure(target:GLenum; pname:GLenum; param:GLfixed); stdcall;
// min GLES function - glTexParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glTexParameterxv: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
// min GLES function - glTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; width:GLsizei; height:GLsizei; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glTranslatex: procedure(x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
// min GLES function - glVertexPointer: procedure(size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
// min GLES function - glViewport: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;

  {$IfDef GL_OES_point_size_array}
  glPointSizePointerOES: procedure(_type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
  {$EndIf}

  {$IfDef GL_OES_blend_equation_separate}
  glBlendEquationSeparateOES: procedure(modeRGB:GLenum; modeAlpha:GLenum); stdcall;
  {$EndIf}

  {$IfDef GL_OES_blend_func_separate}
  // min GLES function - glBlendFuncSeparateOES: procedure(srcRGB:GLenum; dstRGB:GLenum; srcAlpha:GLenum; dstAlpha:GLenum); stdcall;
  {$EndIf}

  {$IfDef GL_OES_blend_subtract}
  glBlendEquationOES: procedure(mode:GLenum); stdcall;
  {$EndIf}

  {$IfDef GL_OES_draw_texture}
  glDrawTexsOES: procedure(x:GLshort; y:GLshort; z:GLshort; width:GLshort; height:GLshort); stdcall;
  glDrawTexiOES: procedure(x:GLint; y:GLint; z:GLint; width:GLint; height:GLint); stdcall;
  glDrawTexxOES: procedure(x:GLfixed; y:GLfixed; z:GLfixed; width:GLfixed; height:GLfixed); stdcall;
  glDrawTexsvOES: procedure(coords:PGLshort); stdcall;
  glDrawTexivOES: procedure(coords:PGLint); stdcall;
  glDrawTexxvOES: procedure(coords:PGLfixed); stdcall;
  glDrawTexfOES: procedure(x:GLfloat; y:GLfloat; z:GLfloat; width:GLfloat; height:GLfloat); stdcall;
  glDrawTexfvOES: procedure(coords:PGLfloat); stdcall;
  {$EndIf}

  {$IfDef GL_OES_fixed_point}
  glAlphaFuncxOES: procedure(func:GLenum; ref:GLfixed); stdcall;
  glClearColorxOES: procedure(red:GLfixed; green:GLfixed; blue:GLfixed; alpha:GLfixed); stdcall;
  glClearDepthxOES: procedure(depth:GLfixed); stdcall;
  glClipPlanexOES: procedure(plane:GLenum; equation:PGLfixed); stdcall;
  glColor4xOES: procedure(red:GLfixed; green:GLfixed; blue:GLfixed; alpha:GLfixed); stdcall;
  glDepthRangexOES: procedure(n:GLfixed; f:GLfixed); stdcall;
  glFogxOES: procedure(pname:GLenum; param:GLfixed); stdcall;
  glFogxvOES: procedure(pname:GLenum; param:PGLfixed); stdcall;
  glFrustumxOES: procedure(l:GLfixed; r:GLfixed; b:GLfixed; t:GLfixed; n:GLfixed; f:GLfixed); stdcall;
  glGetClipPlanexOES: procedure(plane:GLenum; equation:PGLfixed); stdcall;
  glGetFixedvOES: procedure(pname:GLenum; params:PGLfixed); stdcall;
  glGetTexEnvxvOES: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glGetTexParameterxvOES: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glLightModelxOES: procedure(pname:GLenum; param:GLfixed); stdcall;
  glLightModelxvOES: procedure(pname:GLenum; param:PGLfixed); stdcall;
  glLightxOES: procedure(light:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glLightxvOES: procedure(light:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glLineWidthxOES: procedure(width:GLfixed); stdcall;
  glLoadMatrixxOES: procedure(m:PGLfixed); stdcall;
  glMaterialxOES: procedure(face:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glMaterialxvOES: procedure(face:GLenum; pname:GLenum; param:PGLfixed); stdcall;
  glMultMatrixxOES: procedure(m:PGLfixed); stdcall;
  glMultiTexCoord4xOES: procedure(texture:GLenum; s:GLfixed; t:GLfixed; r:GLfixed; q:GLfixed); stdcall;
  glNormal3xOES: procedure(nx:GLfixed; ny:GLfixed; nz:GLfixed); stdcall;
  glOrthoxOES: procedure(l:GLfixed; r:GLfixed; b:GLfixed; t:GLfixed; n:GLfixed; f:GLfixed); stdcall;
  glPointParameterxvOES: procedure(pname:GLenum; params:PGLfixed); stdcall;
  glPointSizexOES: procedure(size:GLfixed); stdcall;
  glPolygonOffsetxOES: procedure(factor:GLfixed; units:GLfixed); stdcall;
  glRotatexOES: procedure(angle:GLfixed; x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
  glScalexOES: procedure(x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
  glTexEnvxOES: procedure(target:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glTexEnvxvOES: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glTexParameterxOES: procedure(target:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glTexParameterxvOES: procedure(target:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glTranslatexOES: procedure(x:GLfixed; y:GLfixed; z:GLfixed); stdcall;
  glGetLightxvOES: procedure(light:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glGetMaterialxvOES: procedure(face:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glPointParameterxOES: procedure(pname:GLenum; param:GLfixed); stdcall;
  glSampleCoveragexOES: procedure(value:GLclampx; invert:GLboolean); stdcall;
  glGetTexGenxvOES: procedure(coord:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  glTexGenxOES: procedure(coord:GLenum; pname:GLenum; param:GLfixed); stdcall;
  glTexGenxvOES: procedure(coord:GLenum; pname:GLenum; params:PGLfixed); stdcall;
  {$EndIf}

  {$IfDef GL_OES_framebuffer_object}
// min GLES function - glIsRenderbufferOES: function(renderbuffer:GLuint):GLboolean; stdcall;
// min GLES function - glBindRenderbufferOES: procedure(target:GLenum; renderbuffer:GLuint); stdcall;
// min GLES function - glDeleteRenderbuffersOES: procedure(n:GLsizei; renderbuffers:PGLuint); stdcall;
// min GLES function - glGenRenderbuffersOES: procedure(n:GLsizei; renderbuffers:PGLuint); stdcall;
// min GLES function - glRenderbufferStorageOES: procedure(target:GLenum; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
// min GLES function - glGetRenderbufferParameterivOES: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glIsFramebufferOES: function(framebuffer:GLuint):GLboolean; stdcall;
// min GLES function - glBindFramebufferOES: procedure(target:GLenum; framebuffer:GLuint); stdcall;
// min GLES function - glDeleteFramebuffersOES: procedure(n:GLsizei; framebuffers:PGLuint); stdcall;
// min GLES function - glGenFramebuffersOES: procedure(n:GLsizei; framebuffers:PGLuint); stdcall;
// min GLES function - glCheckFramebufferStatusOES: function(target:GLenum):GLenum; stdcall;
// min GLES function - glFramebufferRenderbufferOES: procedure(target:GLenum; attachment:GLenum; renderbuffertarget:GLenum; renderbuffer:GLuint); stdcall;
// min GLES function - glFramebufferTexture2DOES: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint); stdcall;
// min GLES function - glGetFramebufferAttachmentParameterivOES: procedure(target:GLenum; attachment:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glGenerateMipmapOES: procedure(target:GLenum); stdcall;
  {$EndIf}

  {$IfDef GL_OES_matrix_palette}
  glCurrentPaletteMatrixOES: procedure(matrixpaletteindex:GLuint); stdcall;
  glLoadPaletteFromModelViewMatrixOES: procedure; stdcall;
  glMatrixIndexPointerOES: procedure(size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
  glWeightPointerOES: procedure(size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
  {$EndIf}

  {$IfDef GL_OES_query_matrix}
  glQueryMatrixxOES: function(mantissa:PGLfixed; exponent:PGLint):GLbitfield; stdcall;
  {$EndIf}

  {$IfDef GL_OES_single_precision}
  glClearDepthfOES: procedure(depth:GLclampf); stdcall;
  glClipPlanefOES: procedure(plane:GLenum; equation:PGLfloat); stdcall;
  glDepthRangefOES: procedure(n:GLclampf; f:GLclampf); stdcall;
  glFrustumfOES: procedure(l:GLfloat; r:GLfloat; b:GLfloat; t:GLfloat; n:GLfloat; f:GLfloat); stdcall;
  glGetClipPlanefOES: procedure(plane:GLenum; equation:PGLfloat); stdcall;
  glOrthofOES: procedure(l, r, b, t, n, f:GLfloat); stdcall;
  {$EndIf}

  {$IfDef GL_OES_texture_cube_map}
  glTexGenfOES: procedure(coord:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glTexGenfvOES: procedure(coord:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glTexGeniOES: procedure(coord:GLenum; pname:GLenum; param:GLint); stdcall;
  glTexGenivOES: procedure(coord:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexGenfvOES: procedure(coord:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glGetTexGenivOES: procedure(coord:GLenum; pname:GLenum; params:PGLint); stdcall;
  {$EndIf}

  {$IfDef GL_IMG_user_clip_plane}
  glClipPlanefIMG: procedure(p:GLenum; eqn:PGLfloat); stdcall;
  glClipPlanexIMG: procedure(p:GLenum; eqn:PGLfixed); stdcall;
  {$EndIf}
{$EndIf}

{$IfDef GL_ES_VERSION_2_0}
var
  glActiveTexture: procedure(texture:GLenum); stdcall;
  glAttachShader: procedure(_program:GLuint; shader:GLuint); stdcall;
  glBindAttribLocation: procedure(_program:GLuint; index:GLuint; name:PGLchar); stdcall;
  glBindBuffer: procedure(target:GLenum; buffer:GLuint); stdcall;
// min GLES function - glBindFramebuffer: procedure(target:GLenum; framebuffer:GLuint); stdcall;
// min GLES function - glBindRenderbuffer: procedure(target:GLenum; renderbuffer:GLuint); stdcall;
// min GLES function - glBindTexture: procedure(target:GLenum; texture:GLuint); stdcall;
  glBlendColor: procedure(red:GLfloat; green:GLfloat; blue:GLfloat; alpha:GLfloat); stdcall;
// min GLES function - glBlendEquation: procedure(mode:GLenum); stdcall;
  glBlendEquationSeparate: procedure(modeRGB:GLenum; modeAlpha:GLenum); stdcall;
// min GLES function - glBlendFunc: procedure(sfactor, dfactor:GLenum); stdcall;
// min GLES function - glBlendFuncSeparate: procedure(sfactorRGB:GLenum; dfactorRGB:GLenum; sfactorAlpha:GLenum; dfactorAlpha:GLenum); stdcall;
  glBufferData: procedure(target:GLenum; size:GLsizeiptr; data:pointer; usage:GLenum); stdcall;
  glBufferSubData: procedure(target:GLenum; offset:GLintptr; size:GLsizeiptr; data:pointer); stdcall;
// min GLES function - glCheckFramebufferStatus: function(target:GLenum):GLenum; stdcall;
// min GLES function - glClear: procedure(mask:GLbitfield); stdcall;
// min GLES function - glClearColor: procedure(red, green, blue, alpha:GLfloat); stdcall;
// min GLES function - glClearDepthf: procedure(d:GLfloat); stdcall;
  glClearStencil: procedure(s:GLint); stdcall;
// min GLES function - glColorMask: procedure(red, green, blue, alpha:GLboolean); stdcall;
  glCompileShader: procedure(shader:GLuint); stdcall;
// min GLES function - glCompressedTexImage2D: procedure(target:GLenum; level:GLint; internalformat:GLenum; width:GLsizei; height:GLsizei; border:GLint; imageSize:GLsizei; data:pointer); stdcall;
// min GLES function - glCompressedTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; width:GLsizei; height:GLsizei; format:GLenum; imageSize:GLsizei; data:pointer); stdcall;
  glCopyTexImage2D: procedure(target:GLenum; level:GLint; internalformat:GLenum; x:GLint; y:GLint;
              width:GLsizei; height:GLsizei; border:GLint); stdcall;
// min GLES function - glCopyTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
  glCreateProgram: function: GLuint; stdcall;
  glCreateShader: function(_type:GLenum):GLuint; stdcall;
  glCullFace: procedure(mode:GLenum); stdcall;
  glDeleteBuffers: procedure(n:GLsizei; buffers:PGLuint); stdcall;
// min GLES function - glDeleteFramebuffers: procedure(n:GLsizei; framebuffers:PGLuint); stdcall;
  glDeleteProgram: procedure(_program:GLuint); stdcall;
// min GLES function - glDeleteRenderbuffers: procedure(n:GLsizei; renderbuffers:PGLuint); stdcall;
  glDeleteShader: procedure(shader:GLuint); stdcall;
// min GLES function - glDeleteTextures: procedure(n:GLsizei; textures:PGLuint); stdcall;
// min GLES function - glDepthFunc: procedure(func:GLenum); stdcall;
// min GLES function - glDepthMask: procedure(flag:GLboolean); stdcall;
  glDepthRangef: procedure(n:GLfloat; f:GLfloat); stdcall;
  glDetachShader: procedure(_program:GLuint; shader:GLuint); stdcall;
// min GLES function - glDisable: procedure(cap:GLenum); stdcall;
  glDisableVertexAttribArray: procedure(index:GLuint); stdcall;
// min GLES function - glDrawArrays: procedure(mode:GLenum; first:GLint; count:GLsizei); stdcall;
// min GLES function - glDrawElements: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer); stdcall;
// min GLES function - glEnable: procedure(cap:GLenum); stdcall;
  glEnableVertexAttribArray: procedure(index:GLuint); stdcall;
  glFinish: procedure; stdcall;
  glFlush: procedure; stdcall;
// min GLES function - glFramebufferRenderbuffer: procedure(target:GLenum; attachment:GLenum; renderbuffertarget:GLenum; renderbuffer:GLuint); stdcall;
// min GLES function - glFramebufferTexture2D: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint); stdcall;
  glFrontFace: procedure(mode:GLenum); stdcall;
  glGenBuffers: procedure(n:GLsizei; buffers:PGLuint); stdcall;
// min GLES function - glGenerateMipmap: procedure(target:GLenum); stdcall;
// min GLES function - glGenFramebuffers: procedure(n:GLsizei; framebuffers:PGLuint); stdcall;
// min GLES function - glGenRenderbuffers: procedure(n:GLsizei; renderbuffers:PGLuint); stdcall;
// min GLES function - glGenTextures: procedure(n:GLsizei; textures:PGLuint); stdcall;
  glGetActiveAttrib: procedure(_program:GLuint; index:GLuint; bufSize:GLsizei; length:PGLsizei; size:PGLint;
              _type:PGLenum; name:PGLchar); stdcall;
  glGetActiveUniform: procedure(_program:GLuint; index:GLuint; bufSize:GLsizei; length:PGLsizei; size:PGLint;
              _type:PGLenum; name:PGLchar); stdcall;
  glGetAttachedShaders: procedure(_program:GLuint; maxCount:GLsizei; count:PGLsizei; shaders:PGLuint); stdcall;
  glGetAttribLocation: function(_program:GLuint; name:PGLchar):GLint; stdcall;
  glGetBooleanv: procedure(pname:GLenum; data:PGLboolean); stdcall;
  glGetBufferParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetError: function: GLenum; stdcall;
// min GLES function - glGetFloatv: procedure(pname:GLenum; data:PGLfloat); stdcall;
// min GLES function - glGetFramebufferAttachmentParameteriv: procedure(target:GLenum; attachment:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glGetIntegerv: procedure(pname:GLenum; data:PGLint); stdcall;
  glGetProgramiv: procedure(_program:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetProgramInfoLog: procedure(_program:GLuint; bufSize:GLsizei; length:PGLsizei; infoLog:PGLchar); stdcall;
// min GLES function - glGetRenderbufferParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetShaderiv: procedure(shader:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetShaderInfoLog: procedure(shader:GLuint; bufSize:GLsizei; length:PGLsizei; infoLog:PGLchar); stdcall;
  glGetShaderPrecisionFormat: procedure(shadertype:GLenum; precisiontype:GLenum; range:PGLint; precision:PGLint); stdcall;
  glGetShaderSource: procedure(shader:GLuint; bufSize:GLsizei; length:PGLsizei; source:PGLchar); stdcall;
  // min GLES function - glGetString: function(name:GLenum):PGLubyte; stdcall;
  glGetTexParameterfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
  glGetTexParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetUniformfv: procedure(_program:GLuint; location:GLint; params:PGLfloat); stdcall;
  glGetUniformiv: procedure(_program:GLuint; location:GLint; params:PGLint); stdcall;
  glGetUniformLocation: function(_program:GLuint; name:PGLchar):GLint; stdcall;
  glGetVertexAttribfv: procedure(index:GLuint; pname:GLenum; params:PGLfloat); stdcall;
  glGetVertexAttribiv: procedure(index:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetVertexAttribPointerv: procedure(index:GLuint; pname:GLenum; pointer:Ppointer); stdcall;
// min GLES function - glHint: procedure(target:GLenum; mode:GLenum); stdcall;
  glIsBuffer: function(buffer:GLuint):GLboolean; stdcall;
  glIsEnabled: function(cap:GLenum):GLboolean; stdcall;
// min GLES function - glIsFramebuffer: function(framebuffer:GLuint):GLboolean; stdcall;
  glIsProgram: function(_program:GLuint):GLboolean; stdcall;
// min GLES function - glIsRenderbuffer: function(renderbuffer:GLuint):GLboolean; stdcall;
  glIsShader: function(shader:GLuint):GLboolean; stdcall;
  glIsTexture: function(texture:GLuint):GLboolean; stdcall;
  glLineWidth: procedure(width:GLfloat); stdcall;
  glLinkProgram: procedure(_program:GLuint); stdcall;
// min GLES function - glPixelStorei: procedure(pname:GLenum; param:GLint); stdcall;
  glPolygonOffset: procedure(factor:GLfloat; units:GLfloat); stdcall;
//  // min GLES function - glReadPixels: procedure(x, y:GLint; width, height:GLsizei; format, _type:GLenum; pixels:pointer); stdcall;
  glReleaseShaderCompiler: procedure; stdcall;
// min GLES function - glRenderbufferStorage: procedure(target:GLenum; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glSampleCoverage: procedure(value:GLfloat; invert:GLboolean); stdcall;
// min GLES function - glScissor: procedure(x, y:GLint; width, height:GLsizei); stdcall;
  glShaderBinary: procedure(count:GLsizei; shaders:PGLuint; binaryFormat:GLenum; binary:pointer; length:GLsizei); stdcall;
  glShaderSource: procedure(shader:GLuint; count:GLsizei; _string:PPGLchar; length:PGLint); stdcall;
  glStencilFunc: procedure(func:GLenum; ref:GLint; mask:GLuint); stdcall;
  glStencilFuncSeparate: procedure(face:GLenum; func:GLenum; ref:GLint; mask:GLuint); stdcall;
  glStencilMask: procedure(mask:GLuint); stdcall;
  glStencilMaskSeparate: procedure(face:GLenum; mask:GLuint); stdcall;
  glStencilOp: procedure(fail:GLenum; zfail:GLenum; zpass:GLenum); stdcall;
  glStencilOpSeparate: procedure(face:GLenum; sfail:GLenum; dpfail:GLenum; dppass:GLenum); stdcall;
// min GLES function - glTexImage2D: procedure(target:GLenum; level, internalformat:GLint; width, height:GLsizei; border:GLint; format, _type:GLenum; pixels:pointer); stdcall;
// min GLES function - glTexParameterf: procedure(target:GLenum; pname:GLenum; param:GLfloat); stdcall;
  glTexParameterfv: procedure(target:GLenum; pname:GLenum; params:PGLfloat); stdcall;
// min GLES function - glTexParameteri: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
// min GLES function - glTexParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
// min GLES function - glTexSubImage2D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; width:GLsizei; height:GLsizei; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glUniform1f: procedure(location:GLint; v0:GLfloat); stdcall;
  glUniform1fv: procedure(location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glUniform1i: procedure(location:GLint; v0:GLint); stdcall;
  glUniform1iv: procedure(location:GLint; count:GLsizei; value:PGLint); stdcall;
  glUniform2f: procedure(location:GLint; v0:GLfloat; v1:GLfloat); stdcall;
  glUniform2fv: procedure(location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glUniform2i: procedure(location:GLint; v0:GLint; v1:GLint); stdcall;
  glUniform2iv: procedure(location:GLint; count:GLsizei; value:PGLint); stdcall;
  glUniform3f: procedure(location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat); stdcall;
  glUniform3fv: procedure(location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glUniform3i: procedure(location:GLint; v0:GLint; v1:GLint; v2:GLint); stdcall;
  glUniform3iv: procedure(location:GLint; count:GLsizei; value:PGLint); stdcall;
  glUniform4f: procedure(location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat; v3:GLfloat); stdcall;
  glUniform4fv: procedure(location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glUniform4i: procedure(location:GLint; v0:GLint; v1:GLint; v2:GLint; v3:GLint); stdcall;
  glUniform4iv: procedure(location:GLint; count:GLsizei; value:PGLint); stdcall;
  glUniformMatrix2fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix3fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix4fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUseProgram: procedure(_program:GLuint); stdcall;
  glValidateProgram: procedure(_program:GLuint); stdcall;
  glVertexAttrib1f: procedure(index:GLuint; x:GLfloat); stdcall;
  glVertexAttrib1fv: procedure(index:GLuint; v:PGLfloat); stdcall;
  glVertexAttrib2f: procedure(index:GLuint; x:GLfloat; y:GLfloat); stdcall;
  glVertexAttrib2fv: procedure(index:GLuint; v:PGLfloat); stdcall;
  glVertexAttrib3f: procedure(index:GLuint; x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glVertexAttrib3fv: procedure(index:GLuint; v:PGLfloat); stdcall;
  glVertexAttrib4f: procedure(index:GLuint; x:GLfloat; y:GLfloat; z:GLfloat; w:GLfloat); stdcall;
  glVertexAttrib4fv: procedure(index:GLuint; v:PGLfloat); stdcall;
  glVertexAttribPointer: procedure(index:GLuint; size:GLint; _type:GLenum; normalized:GLboolean; stride:GLsizei; pointer:pointer); stdcall;
// min GLES function - glViewport: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_KHR_blend_equation_advanced}
  glBlendBarrierKHR: procedure; stdcall;
{$EndIf}

{$IfDef GL_KHR_debug}
  glDebugMessageControlKHR: procedure(source:GLenum; _type:GLenum; severity:GLenum; count:GLsizei; ids:PGLuint; enabled:GLboolean); stdcall;
  glDebugMessageInsertKHR: procedure(source:GLenum; _type:GLenum; id:GLuint; severity:GLenum; length:GLsizei; buf:PGLchar); stdcall;
  glDebugMessageCallbackKHR: procedure(callback:GLDEBUGPROCKHR; userParam:pointer); stdcall;
  glGetDebugMessageLogKHR: function(count:GLuint; bufSize:GLsizei; sources:PGLenum; types:PGLenum; ids:PGLuint;
             severities:PGLenum; lengths:PGLsizei; messageLog:PGLchar):GLuint; stdcall;
  glPushDebugGroupKHR: procedure(source:GLenum; id:GLuint; length:GLsizei; message:PGLchar); stdcall;
  glPopDebugGroupKHR: procedure; stdcall;
  glObjectLabelKHR: procedure(identifier:GLenum; name:GLuint; length:GLsizei; _label:PGLchar); stdcall;
  glGetObjectLabelKHR: procedure(identifier:GLenum; name:GLuint; bufSize:GLsizei; length:PGLsizei; _label:PGLchar); stdcall;
  glObjectPtrLabelKHR: procedure(ptr:pointer; length:GLsizei; _label:PGLchar); stdcall;
  glGetObjectPtrLabelKHR: procedure(ptr:pointer; bufSize:GLsizei; length:PGLsizei; _label:PGLchar); stdcall;
  glGetPointervKHR: procedure(pname:GLenum; params:Ppointer); stdcall;
{$EndIf}

{$IfDef GL_KHR_parallel_shader_compile}
  glMaxShaderCompilerThreadsKHR: procedure(count:GLuint); stdcall;
{$EndIf}

{$IfDef GL_KHR_robustness}
  glGetGraphicsResetStatusKHR: function: GLenum; stdcall;
  glReadnPixelsKHR: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei; format:GLenum;
              _type:GLenum; bufSize:GLsizei; data:pointer); stdcall;
  glGetnUniformfvKHR: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLfloat); stdcall;
  glGetnUniformivKHR: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLint); stdcall;
  glGetnUniformuivKHR: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLuint); stdcall;
{$EndIf}

{$IfDef GL_OES_EGL_image}
var
  glEGLImageTargetTexture2DOES: procedure(target:GLenum; image:GLeglImageOES); stdcall;
  glEGLImageTargetRenderbufferStorageOES: procedure(target:GLenum; image:GLeglImageOES); stdcall;
{$EndIf}

{$IfDef GL_OES_copy_image}
  glCopyImageSubDataOES: procedure(srcName:GLuint; srcTarget:GLenum; srcLevel:GLint; srcX:GLint; srcY:GLint;
              srcZ:GLint; dstName:GLuint; dstTarget:GLenum; dstLevel:GLint; dstX:GLint;
              dstY:GLint; dstZ:GLint; srcWidth:GLsizei; srcHeight:GLsizei; srcDepth:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_OES_draw_buffers_indexed}
  glEnableiOES: procedure(target:GLenum; index:GLuint); stdcall;
  glDisableiOES: procedure(target:GLenum; index:GLuint); stdcall;
  glBlendEquationiOES: procedure(buf:GLuint; mode:GLenum); stdcall;
  glBlendEquationSeparateiOES: procedure(buf:GLuint; modeRGB:GLenum; modeAlpha:GLenum); stdcall;
  glBlendFunciOES: procedure(buf:GLuint; src:GLenum; dst:GLenum); stdcall;
  glBlendFuncSeparateiOES: procedure(buf:GLuint; srcRGB:GLenum; dstRGB:GLenum; srcAlpha:GLenum; dstAlpha:GLenum); stdcall;
  glColorMaskiOES: procedure(index:GLuint; r:GLboolean; g:GLboolean; b:GLboolean; a:GLboolean); stdcall;
  glIsEnablediOES: function(target:GLenum; index:GLuint):GLboolean; stdcall;
{$EndIf}

{$IfDef GL_OES_draw_elements_base_vertex}
  glDrawElementsBaseVertexOES: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; basevertex:GLint); stdcall;
  glDrawRangeElementsBaseVertexOES: procedure(mode:GLenum; start:GLuint; _end:GLuint; count:GLsizei; _type:GLenum;
              indices:pointer; basevertex:GLint); stdcall;
  glDrawElementsInstancedBaseVertexOES: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei;
              basevertex:GLint); stdcall;
  glMultiDrawElementsBaseVertexEXT: procedure(mode:GLenum; count:PGLsizei; _type:GLenum; indices:Ppointer; drawcount:GLsizei;
              basevertex:PGLint); stdcall;
{$EndIf}

{$IfDef GL_OES_geometry_shader}
  glFramebufferTextureOES: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint); stdcall;
{$EndIf}

{$IfDef GL_OES_get_program_binary}
  glGetProgramBinaryOES: procedure(_program:GLuint; bufSize:GLsizei; length:PGLsizei; binaryFormat:PGLenum; binary:pointer); stdcall;
  glProgramBinaryOES: procedure(_program:GLuint; binaryFormat:GLenum; binary:pointer; length:GLint); stdcall;
{$EndIf}

{$IfDef GL_OES_mapbuffer}
  glMapBufferOES: function(target:GLenum; access:GLenum):pointer; stdcall;
  glUnmapBufferOES: function(target:GLenum):GLboolean; stdcall;
  glGetBufferPointervOES: procedure(target:GLenum; pname:GLenum; params:Ppointer); stdcall;
{$EndIf}

{$IfDef GL_OES_primitive_bounding_box}
  glPrimitiveBoundingBoxOES: procedure(minX:GLfloat; minY:GLfloat; minZ:GLfloat; minW:GLfloat; maxX:GLfloat;
              maxY:GLfloat; maxZ:GLfloat; maxW:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_OES_sample_shading}
  glMinSampleShadingOES: procedure(value:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_OES_tessellation_shader}
  glPatchParameteriOES: procedure(pname:GLenum; value:GLint); stdcall;
{$EndIf}

{$IfDef GL_OES_texture_3D}
  glTexImage3DOES: procedure(target:GLenum; level:GLint; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; border:GLint; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glTexSubImage3DOES: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glCopyTexSubImage3DOES: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
  glCompressedTexImage3DOES: procedure(target:GLenum; level:GLint; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; border:GLint; imageSize:GLsizei; data:pointer); stdcall;
  glCompressedTexSubImage3DOES: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; imageSize:GLsizei; data:pointer); stdcall;
  glFramebufferTexture3DOES: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint; zoffset:GLint); stdcall;
{$EndIf}

{$IfDef GL_OES_texture_border_clamp}
  glTexParameterIivOES: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glTexParameterIuivOES: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glGetTexParameterIivOES: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexParameterIuivOES: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glSamplerParameterIivOES: procedure(sampler:GLuint; pname:GLenum; param:PGLint); stdcall;
  glSamplerParameterIuivOES: procedure(sampler:GLuint; pname:GLenum; param:PGLuint); stdcall;
  glGetSamplerParameterIivOES: procedure(sampler:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetSamplerParameterIuivOES: procedure(sampler:GLuint; pname:GLenum; params:PGLuint); stdcall;
{$EndIf}

{$IfDef GL_OES_texture_buffer}
  glTexBufferOES: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint); stdcall;
  glTexBufferRangeOES: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint; offset:GLintptr; size:GLsizeiptr); stdcall;
{$EndIf}

{$IfDef GL_OES_texture_storage_multisample_2d_array}
  glTexStorage3DMultisampleOES: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; fixedsamplelocations:GLboolean); stdcall;
{$EndIf}

{$IfDef GL_OES_texture_view}
  glTextureViewOES: procedure(texture:GLuint; target:GLenum; origtexture:GLuint; internalformat:GLenum; minlevel:GLuint;
              numlevels:GLuint; minlayer:GLuint; numlayers:GLuint); stdcall;
{$EndIf}

{$IfDef GL_OES_vertex_array_object}
  glBindVertexArrayOES: procedure(_array:GLuint); stdcall;
  glDeleteVertexArraysOES: procedure(n:GLsizei; arrays:PGLuint); stdcall;
  glGenVertexArraysOES: procedure(n:GLsizei; arrays:PGLuint); stdcall;
  glIsVertexArrayOES: function(_array:GLuint):GLboolean; stdcall;
{$EndIf}

{$IfDef GL_OES_viewport_array}
  glViewportArrayvOES: procedure(first:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glViewportIndexedfOES: procedure(index:GLuint; x:GLfloat; y:GLfloat; w:GLfloat; h:GLfloat); stdcall;
  glViewportIndexedfvOES: procedure(index:GLuint; v:PGLfloat); stdcall;
  glScissorArrayvOES: procedure(first:GLuint; count:GLsizei; v:PGLint); stdcall;
  glScissorIndexedOES: procedure(index:GLuint; left:GLint; bottom:GLint; width:GLsizei; height:GLsizei); stdcall;
  glScissorIndexedvOES: procedure(index:GLuint; v:PGLint); stdcall;
  glDepthRangeArrayfvOES: procedure(first:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glDepthRangeIndexedfOES: procedure(index:GLuint; n:GLfloat; f:GLfloat); stdcall;
  glGetFloati_vOES: procedure(target:GLenum; index:GLuint; data:PGLfloat); stdcall;
{$EndIf}

{$IfDef GL_AMD_framebuffer_multisample_advanced}
  glRenderbufferStorageMultisampleAdvancedAMD: procedure(target:GLenum; samples:GLsizei; storageSamples:GLsizei; internalformat:GLenum; width:GLsizei;
              height:GLsizei); stdcall;
  glNamedRenderbufferStorageMultisampleAdvancedAMD: procedure(renderbuffer:GLuint; samples:GLsizei; storageSamples:GLsizei; internalformat:GLenum; width:GLsizei;
              height:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_AMD_performance_monitor}
  glGetPerfMonitorGroupsAMD: procedure(numGroups:PGLint; groupsSize:GLsizei; groups:PGLuint); stdcall;
  glGetPerfMonitorCountersAMD: procedure(group:GLuint; numCounters:PGLint; maxActiveCounters:PGLint; counterSize:GLsizei; counters:PGLuint); stdcall;
  glGetPerfMonitorGroupStringAMD: procedure(group:GLuint; bufSize:GLsizei; length:PGLsizei; groupString:PGLchar); stdcall;
  glGetPerfMonitorCounterStringAMD: procedure(group:GLuint; counter:GLuint; bufSize:GLsizei; length:PGLsizei; counterString:PGLchar); stdcall;
  glGetPerfMonitorCounterInfoAMD: procedure(group:GLuint; counter:GLuint; pname:GLenum; data:pointer); stdcall;
  glGenPerfMonitorsAMD: procedure(n:GLsizei; monitors:PGLuint); stdcall;
  glDeletePerfMonitorsAMD: procedure(n:GLsizei; monitors:PGLuint); stdcall;
  glSelectPerfMonitorCountersAMD: procedure(monitor:GLuint; enable:GLboolean; group:GLuint; numCounters:GLint; counterList:PGLuint); stdcall;
  glBeginPerfMonitorAMD: procedure(monitor:GLuint); stdcall;
  glEndPerfMonitorAMD: procedure(monitor:GLuint); stdcall;
  glGetPerfMonitorCounterDataAMD: procedure(monitor:GLuint; pname:GLenum; dataSize:GLsizei; data:PGLuint; bytesWritten:PGLint); stdcall;
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_blit}
  glBlitFramebufferANGLE: procedure(srcX0:GLint; srcY0:GLint; srcX1:GLint; srcY1:GLint; dstX0:GLint;
              dstY0:GLint; dstX1:GLint; dstY1:GLint; mask:GLbitfield; filter:GLenum); stdcall;
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleANGLE: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_ANGLE_instanced_arrays}
  glDrawArraysInstancedANGLE: procedure(mode:GLenum; first:GLint; count:GLsizei; primcount:GLsizei); stdcall;
  glDrawElementsInstancedANGLE: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; primcount:GLsizei); stdcall;
  glVertexAttribDivisorANGLE: procedure(index:GLuint; divisor:GLuint); stdcall;
{$EndIf}

{$IfDef GL_ANGLE_translated_shader_source}
  glGetTranslatedShaderSourceANGLE: procedure(shader:GLuint; bufSize:GLsizei; length:PGLsizei; source:PGLchar); stdcall;
{$EndIf}

{$IfDef GL_APPLE_copy_texture_levels}
  glCopyTextureLevelsAPPLE: procedure(destinationTexture:GLuint; sourceTexture:GLuint; sourceBaseLevel:GLint; sourceLevelCount:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_APPLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleAPPLE: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glResolveMultisampleFramebufferAPPLE: procedure; stdcall;
{$EndIf}

{$IfDef GL_APPLE_sync}
  glFenceSyncAPPLE: function(condition:GLenum; flags:GLbitfield):GLsync; stdcall;
  glIsSyncAPPLE: function(sync:GLsync):GLboolean; stdcall;
  glDeleteSyncAPPLE: procedure(sync:GLsync); stdcall;
  glClientWaitSyncAPPLE: function(sync:GLsync; flags:GLbitfield; timeout:GLuint64):GLenum; stdcall;
  glWaitSyncAPPLE: procedure(sync:GLsync; flags:GLbitfield; timeout:GLuint64); stdcall;
  glGetInteger64vAPPLE: procedure(pname:GLenum; params:PGLint64); stdcall;
  glGetSyncivAPPLE: procedure(sync:GLsync; pname:GLenum; count:GLsizei; length:PGLsizei; values:PGLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_EGL_image_storage}
  glEGLImageTargetTexStorageEXT: procedure(target:GLenum; image:GLeglImageOES; attrib_list:PGLint); stdcall;
  glEGLImageTargetTextureStorageEXT: procedure(texture:GLuint; image:GLeglImageOES; attrib_list:PGLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_base_instance}
  glDrawArraysInstancedBaseInstanceEXT: procedure(mode:GLenum; first:GLint; count:GLsizei; instancecount:GLsizei; baseinstance:GLuint); stdcall;
  glDrawElementsInstancedBaseInstanceEXT: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei; baseinstance:GLuint); stdcall;
  glDrawElementsInstancedBaseVertexBaseInstanceEXT: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei;
              basevertex:GLint; baseinstance:GLuint); stdcall;
{$EndIf}

{$IfDef GL_EXT_blend_func_extended}
  glBindFragDataLocationIndexedEXT: procedure(_program:GLuint; colorNumber:GLuint; index:GLuint; name:PGLchar); stdcall;
  glBindFragDataLocationEXT: procedure(_program:GLuint; color:GLuint; name:PGLchar); stdcall;
  glGetProgramResourceLocationIndexEXT: function(_program:GLuint; programInterface:GLenum; name:PGLchar):GLint; stdcall;
  glGetFragDataIndexEXT: function(_program:GLuint; name:PGLchar):GLint; stdcall;
{$EndIf}

{$IfDef GL_EXT_buffer_storage}
  glBufferStorageEXT: procedure(target:GLenum; size:GLsizeiptr; data:pointer; flags:GLbitfield); stdcall;
{$EndIf}

{$IfDef GL_EXT_clear_texture}
  glClearTexImageEXT: procedure(texture:GLuint; level:GLint; format:GLenum; _type:GLenum; data:pointer); stdcall;
  glClearTexSubImageEXT: procedure(texture:GLuint; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; _type:GLenum; data:pointer); stdcall;
{$EndIf}

{$IfDef GL_EXT_clip_control}
  glClipControlEXT: procedure(origin:GLenum; depth:GLenum); stdcall;
{$EndIf}

{$IfDef GL_EXT_copy_image}
  glCopyImageSubDataEXT: procedure(srcName:GLuint; srcTarget:GLenum; srcLevel:GLint; srcX:GLint; srcY:GLint;
              srcZ:GLint; dstName:GLuint; dstTarget:GLenum; dstLevel:GLint; dstX:GLint;
              dstY:GLint; dstZ:GLint; srcWidth:GLsizei; srcHeight:GLsizei; srcDepth:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_debug_label}
  glLabelObjectEXT: procedure(_type:GLenum; _object:GLuint; length:GLsizei; _label:PGLchar); stdcall;
  glGetObjectLabelEXT: procedure(_type:GLenum; _object:GLuint; bufSize:GLsizei; length:PGLsizei; _label:PGLchar); stdcall;
{$EndIf}

{$IfDef GL_EXT_debug_marker}
  glInsertEventMarkerEXT: procedure(length:GLsizei; marker:PGLchar); stdcall;
  glPushGroupMarkerEXT: procedure(length:GLsizei; marker:PGLchar); stdcall;
  glPopGroupMarkerEXT: procedure; stdcall;
{$EndIf}

{$IfDef GL_EXT_discard_framebuffer}
  glDiscardFramebufferEXT: procedure(target:GLenum; numAttachments:GLsizei; attachments:PGLenum); stdcall;
{$EndIf}

{$IfDef GL_EXT_disjoint_timer_query}
  glGenQueriesEXT: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glDeleteQueriesEXT: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glIsQueryEXT: function(id:GLuint):GLboolean; stdcall;
  glBeginQueryEXT: procedure(target:GLenum; id:GLuint); stdcall;
  glEndQueryEXT: procedure(target:GLenum); stdcall;
  glQueryCounterEXT: procedure(id:GLuint; target:GLenum); stdcall;
  glGetQueryivEXT: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetQueryObjectivEXT: procedure(id:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetQueryObjectuivEXT: procedure(id:GLuint; pname:GLenum; params:PGLuint); stdcall;
  glGetQueryObjecti64vEXT: procedure(id:GLuint; pname:GLenum; params:PGLint64); stdcall;
  glGetQueryObjectui64vEXT: procedure(id:GLuint; pname:GLenum; params:PGLuint64); stdcall;
  glGetInteger64vEXT: procedure(pname:GLenum; data:PGLint64); stdcall;
{$EndIf}

{$IfDef GL_EXT_draw_buffers}
  glDrawBuffersEXT: procedure(n:GLsizei; bufs:PGLenum); stdcall;
{$EndIf}

{$IfDef GL_EXT_draw_elements_base_vertex}
  glDrawElementsBaseVertexEXT: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; basevertex:GLint); stdcall;
  glDrawRangeElementsBaseVertexEXT: procedure(mode:GLenum; start:GLuint; _end:GLuint; count:GLsizei; _type:GLenum;
              indices:pointer; basevertex:GLint); stdcall;
  glDrawElementsInstancedBaseVertexEXT: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei;
              basevertex:GLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_draw_instanced}
  glDrawArraysInstancedEXT: procedure(mode:GLenum; start:GLint; count:GLsizei; primcount:GLsizei); stdcall;
  glDrawElementsInstancedEXT: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; primcount:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_draw_transform_feedback}
  glDrawTransformFeedbackEXT: procedure(mode:GLenum; id:GLuint); stdcall;
  glDrawTransformFeedbackInstancedEXT: procedure(mode:GLenum; id:GLuint; instancecount:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_external_buffer}
  glBufferStorageExternalEXT: procedure(target:GLenum; offset:GLintptr; size:GLsizeiptr; clientBuffer:GLeglClientBufferEXT; flags:GLbitfield); stdcall;
  glNamedBufferStorageExternalEXT: procedure(buffer:GLuint; offset:GLintptr; size:GLsizeiptr; clientBuffer:GLeglClientBufferEXT; flags:GLbitfield); stdcall;
{$EndIf}

{$IfDef GL_EXT_fragment_shading_rate}
  glGetFragmentShadingRatesEXT: procedure(samples:GLsizei; maxCount:GLsizei; count:PGLsizei; shadingRates:PGLenum); stdcall;
  glShadingRateEXT: procedure(rate:GLenum); stdcall;
  glShadingRateCombinerOpsEXT: procedure(combinerOp0:GLenum; combinerOp1:GLenum); stdcall;
  glFramebufferShadingRateEXT: procedure(target:GLenum; attachment:GLenum; texture:GLuint; baseLayer:GLint; numLayers:GLsizei;
              texelWidth:GLsizei; texelHeight:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_framebuffer_blit_layers}
  glBlitFramebufferLayersEXT: procedure(srcX0:GLint; srcY0:GLint; srcX1:GLint; srcY1:GLint; dstX0:GLint;
              dstY0:GLint; dstX1:GLint; dstY1:GLint; mask:GLbitfield; filter:GLenum); stdcall;
  glBlitFramebufferLayerEXT: procedure(srcX0:GLint; srcY0:GLint; srcX1:GLint; srcY1:GLint; srcLayer:GLint;
              dstX0:GLint; dstY0:GLint; dstX1:GLint; dstY1:GLint; dstLayer:GLint;
              mask:GLbitfield; filter:GLenum); stdcall;
{$EndIf}

{$IfDef GL_EXT_geometry_shader}
  glFramebufferTextureEXT: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_instanced_arrays}
  glVertexAttribDivisorEXT: procedure(index:GLuint; divisor:GLuint); stdcall;
{$EndIf}

{$IfDef GL_EXT_map_buffer_range}
  glMapBufferRangeEXT: function(target:GLenum; offset:GLintptr; length:GLsizeiptr; access:GLbitfield):pointer; stdcall;
  glFlushMappedBufferRangeEXT: procedure(target:GLenum; offset:GLintptr; length:GLsizeiptr); stdcall;
{$EndIf}

{$IfDef GL_EXT_memory_object}
  glGetUnsignedBytevEXT: procedure(pname:GLenum; data:PGLubyte); stdcall;
  glGetUnsignedBytei_vEXT: procedure(target:GLenum; index:GLuint; data:PGLubyte); stdcall;
  glDeleteMemoryObjectsEXT: procedure(n:GLsizei; memoryObjects:PGLuint); stdcall;
  glIsMemoryObjectEXT: function(memoryObject:GLuint):GLboolean; stdcall;
  glCreateMemoryObjectsEXT: procedure(n:GLsizei; memoryObjects:PGLuint); stdcall;
  glMemoryObjectParameterivEXT: procedure(memoryObject:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetMemoryObjectParameterivEXT: procedure(memoryObject:GLuint; pname:GLenum; params:PGLint); stdcall;
  glTexStorageMem2DEXT: procedure(target:GLenum; levels:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              memory:GLuint; offset:GLuint64); stdcall;
  glTexStorageMem2DMultisampleEXT: procedure(target:GLenum; samples:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              fixedSampleLocations:GLboolean; memory:GLuint; offset:GLuint64); stdcall;
  glTexStorageMem3DEXT: procedure(target:GLenum; levels:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; memory:GLuint; offset:GLuint64); stdcall;
  glTexStorageMem3DMultisampleEXT: procedure(target:GLenum; samples:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; fixedSampleLocations:GLboolean; memory:GLuint; offset:GLuint64); stdcall;
  glBufferStorageMemEXT: procedure(target:GLenum; size:GLsizeiptr; memory:GLuint; offset:GLuint64); stdcall;
  glTextureStorageMem2DEXT: procedure(texture:GLuint; levels:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              memory:GLuint; offset:GLuint64); stdcall;
  glTextureStorageMem2DMultisampleEXT: procedure(texture:GLuint; samples:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              fixedSampleLocations:GLboolean; memory:GLuint; offset:GLuint64); stdcall;
  glTextureStorageMem3DEXT: procedure(texture:GLuint; levels:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; memory:GLuint; offset:GLuint64); stdcall;
  glTextureStorageMem3DMultisampleEXT: procedure(texture:GLuint; samples:GLsizei; internalFormat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; fixedSampleLocations:GLboolean; memory:GLuint; offset:GLuint64); stdcall;
  glNamedBufferStorageMemEXT: procedure(buffer:GLuint; size:GLsizeiptr; memory:GLuint; offset:GLuint64); stdcall;
{$EndIf}

{$IfDef GL_EXT_memory_object_fd}
  glImportMemoryFdEXT: procedure(memory:GLuint; size:GLuint64; handleType:GLenum; fd:GLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_memory_object_win32}
  glImportMemoryWin32HandleEXT: procedure(memory:GLuint; size:GLuint64; handleType:GLenum; handle:pointer); stdcall;
  glImportMemoryWin32NameEXT: procedure(memory:GLuint; size:GLuint64; handleType:GLenum; name:pointer); stdcall;
{$EndIf}

{$IfDef GL_EXT_multi_draw_arrays}
  glMultiDrawArraysEXT: procedure(mode:GLenum; first:PGLint; count:PGLsizei; primcount:GLsizei); stdcall;
  glMultiDrawElementsEXT: procedure(mode:GLenum; count:PGLsizei; _type:GLenum; indices:Ppointer; primcount:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_multi_draw_indirect}
  glMultiDrawArraysIndirectEXT: procedure(mode:GLenum; indirect:pointer; drawcount:GLsizei; stride:GLsizei); stdcall;
  glMultiDrawElementsIndirectEXT: procedure(mode:GLenum; _type:GLenum; indirect:pointer; drawcount:GLsizei; stride:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleEXT: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glFramebufferTexture2DMultisampleEXT: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint; samples:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_multiview_draw_buffers}
  glReadBufferIndexedEXT: procedure(src:GLenum; index:GLint); stdcall;
  glDrawBuffersIndexedEXT: procedure(n:GLint; location:PGLenum; indices:PGLint); stdcall;
  glGetIntegeri_vEXT: procedure(target:GLenum; index:GLuint; data:PGLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_polygon_offset_clamp}
   glPolygonOffsetClampEXT: procedure(factor:GLfloat; units:GLfloat; clamp:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_EXT_primitive_bounding_box}
  glPrimitiveBoundingBoxEXT: procedure(minX:GLfloat; minY:GLfloat; minZ:GLfloat; minW:GLfloat; maxX:GLfloat;
              maxY:GLfloat; maxZ:GLfloat; maxW:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_EXT_raster_multisample}
  glRasterSamplesEXT: procedure(samples:GLuint; fixedsamplelocations:GLboolean); stdcall;
{$EndIf}

{$IfDef GL_EXT_robustness}
  glGetGraphicsResetStatusEXT: function: GLenum; stdcall;
  glReadnPixelsEXT: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei; format:GLenum; _type:GLenum; bufSize:GLsizei; data:pointer); stdcall;
  glGetnUniformfvEXT: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLfloat); stdcall;
  glGetnUniformivEXT: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_semaphore}
  glGenSemaphoresEXT: procedure(n:GLsizei; semaphores:PGLuint); stdcall;
  glDeleteSemaphoresEXT: procedure(n:GLsizei; semaphores:PGLuint); stdcall;
  glIsSemaphoreEXT: function(semaphore:GLuint):GLboolean; stdcall;
  glSemaphoreParameterui64vEXT: procedure(semaphore:GLuint; pname:GLenum; params:PGLuint64); stdcall;
  glGetSemaphoreParameterui64vEXT: procedure(semaphore:GLuint; pname:GLenum; params:PGLuint64); stdcall;
  glWaitSemaphoreEXT: procedure(semaphore:GLuint; numBufferBarriers:GLuint; buffers:PGLuint; numTextureBarriers:GLuint; textures:PGLuint;
              srcLayouts:PGLenum); stdcall;
  glSignalSemaphoreEXT: procedure(semaphore:GLuint; numBufferBarriers:GLuint; buffers:PGLuint; numTextureBarriers:GLuint; textures:PGLuint;
              dstLayouts:PGLenum); stdcall;
{$EndIf}

{$IfDef GL_EXT_semaphore_fd}
  glImportSemaphoreFdEXT: procedure(semaphore:GLuint; handleType:GLenum; fd:GLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_semaphore_win32}
  glImportSemaphoreWin32HandleEXT: procedure(semaphore:GLuint; handleType:GLenum; handle:pointer); stdcall;
  glImportSemaphoreWin32NameEXT: procedure(semaphore:GLuint; handleType:GLenum; name:pointer); stdcall;
{$EndIf}

{$IfDef GL_EXT_separate_shader_objects}
  glActiveShaderProgramEXT: procedure(pipeline:GLuint; _program:GLuint); stdcall;
  glBindProgramPipelineEXT: procedure(pipeline:GLuint); stdcall;
  glCreateShaderProgramvEXT: function(_type:GLenum; count:GLsizei; strings:PPGLchar):GLuint; stdcall;
  glDeleteProgramPipelinesEXT: procedure(n:GLsizei; pipelines:PGLuint); stdcall;
  glGenProgramPipelinesEXT: procedure(n:GLsizei; pipelines:PGLuint); stdcall;
  glGetProgramPipelineInfoLogEXT: procedure(pipeline:GLuint; bufSize:GLsizei; length:PGLsizei; infoLog:PGLchar); stdcall;
  glGetProgramPipelineivEXT: procedure(pipeline:GLuint; pname:GLenum; params:PGLint); stdcall;
  glIsProgramPipelineEXT: function(pipeline:GLuint):GLboolean; stdcall;
  glProgramParameteriEXT: procedure(_program:GLuint; pname:GLenum; value:GLint); stdcall;
  glProgramUniform1fEXT: procedure(_program:GLuint; location:GLint; v0:GLfloat); stdcall;
  glProgramUniform1fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform1iEXT: procedure(_program:GLuint; location:GLint; v0:GLint); stdcall;
  glProgramUniform1ivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform2fEXT: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat); stdcall;
  glProgramUniform2fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform2iEXT: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint); stdcall;
  glProgramUniform2ivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform3fEXT: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat); stdcall;
  glProgramUniform3fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform3iEXT: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint; v2:GLint); stdcall;
  glProgramUniform3ivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform4fEXT: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat; v3:GLfloat); stdcall;
  glProgramUniform4fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform4iEXT: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint; v2:GLint; v3:GLint); stdcall;
  glProgramUniform4ivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniformMatrix2fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUseProgramStagesEXT: procedure(pipeline:GLuint; stages:GLbitfield; _program:GLuint); stdcall;
  glValidateProgramPipelineEXT: procedure(pipeline:GLuint); stdcall;
  glProgramUniform1uiEXT: procedure(_program:GLuint; location:GLint; v0:GLuint); stdcall;
  glProgramUniform2uiEXT: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint); stdcall;
  glProgramUniform3uiEXT: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint; v2:GLuint); stdcall;
  glProgramUniform4uiEXT: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint; v2:GLuint; v3:GLuint); stdcall;
  glProgramUniform1uivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform2uivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform3uivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform4uivEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniformMatrix2x3fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3x2fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix2x4fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4x2fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3x4fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4x3fvEXT: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
{$EndIf}

{$IfDef GL_EXT_shader_framebuffer_fetch_non_coherent}
  glFramebufferFetchBarrierEXT: procedure; stdcall;
{$EndIf}

{$IfDef GL_EXT_shader_pixel_local_storage2}
  glFramebufferPixelLocalStorageSizeEXT: procedure(target:GLuint; size:GLsizei); stdcall;
  glGetFramebufferPixelLocalStorageSizeEXT: function(target:GLuint):GLsizei; stdcall;
  glClearPixelLocalStorageuiEXT: procedure(offset:GLsizei; n:GLsizei; values:PGLuint); stdcall;
{$EndIf}

{$IfDef GL_EXT_sparse_texture}
  glTexPageCommitmentEXT: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; commit:GLboolean); stdcall;
{$EndIf}

{$IfDef GL_EXT_tessellation_shader}
  glPatchParameteriEXT: procedure(pname:GLenum; value:GLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_texture_border_clamp}
  glTexParameterIivEXT: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glTexParameterIuivEXT: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glGetTexParameterIivEXT: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexParameterIuivEXT: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glSamplerParameterIivEXT: procedure(sampler:GLuint; pname:GLenum; param:PGLint); stdcall;
  glSamplerParameterIuivEXT: procedure(sampler:GLuint; pname:GLenum; param:PGLuint); stdcall;
  glGetSamplerParameterIivEXT: procedure(sampler:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetSamplerParameterIuivEXT: procedure(sampler:GLuint; pname:GLenum; params:PGLuint); stdcall;
{$EndIf}

{$IfDef GL_EXT_texture_buffer}
  glTexBufferEXT: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint); stdcall;
  glTexBufferRangeEXT: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint; offset:GLintptr; size:GLsizeiptr); stdcall;
{$EndIf}

{$IfDef GL_EXT_texture_storage}
  glTexStorage1DEXT: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei); stdcall;
  glTexStorage2DEXT: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glTexStorage3DEXT: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei; depth:GLsizei); stdcall;
  glTextureStorage1DEXT: procedure(texture:GLuint; target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei); stdcall;
  glTextureStorage2DEXT: procedure(texture:GLuint; target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glTextureStorage3DEXT: procedure(texture:GLuint; target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei; depth:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_EXT_texture_storage_compression}
  glTexStorageAttribs2DEXT: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei;
              attrib_list:PGLint); stdcall;
  glTexStorageAttribs3DEXT: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; attrib_list:PGLint); stdcall;
{$EndIf}

{$IfDef GL_EXT_texture_view}
  glTextureViewEXT: procedure(texture:GLuint; target:GLenum; origtexture:GLuint; internalformat:GLenum; minlevel:GLuint;
              numlevels:GLuint; minlayer:GLuint; numlayers:GLuint); stdcall;
{$EndIf}

{$IfDef GL_EXT_win32_keyed_mutex}
  glAcquireKeyedMutexWin32EXT: function(memory:GLuint; key:GLuint64; timeout:GLuint):GLboolean; stdcall;
  glReleaseKeyedMutexWin32EXT: function(memory:GLuint; key:GLuint64):GLboolean; stdcall;
{$EndIf}

{$IfDef GL_EXT_window_rectangles}
  glWindowRectanglesEXT: procedure(mode:GLenum; count:GLsizei; box:PGLint); stdcall;
{$EndIf}

{$IfDef GL_IMG_bindless_texture}
  glGetTextureHandleIMG: function(texture:GLuint):GLuint64; stdcall;
  glGetTextureSamplerHandleIMG: function(texture:GLuint; sampler:GLuint):GLuint64; stdcall;
  glUniformHandleui64IMG: procedure(location:GLint; value:GLuint64); stdcall;
  glUniformHandleui64vIMG: procedure(location:GLint; count:GLsizei; value:PGLuint64); stdcall;
  glProgramUniformHandleui64IMG: procedure(_program:GLuint; location:GLint; value:GLuint64); stdcall;
  glProgramUniformHandleui64vIMG: procedure(_program:GLuint; location:GLint; count:GLsizei; values:PGLuint64); stdcall;
{$EndIf}

{$IfDef GL_IMG_framebuffer_downsample}
  glFramebufferTexture2DDownsampleIMG: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint;
              xscale:GLint; yscale:GLint); stdcall;
  glFramebufferTextureLayerDownsampleIMG: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint; layer:GLint;
              xscale:GLint; yscale:GLint); stdcall;
{$EndIf}

{$IfDef GL_IMG_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleIMG: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glFramebufferTexture2DMultisampleIMG: procedure(target:GLenum; attachment:GLenum; textarget:GLenum; texture:GLuint; level:GLint; samples:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_INTEL_framebuffer_CMAA}
  glApplyFramebufferAttachmentCMAAINTEL: procedure; stdcall;
{$EndIf}

{$IfDef GL_INTEL_performance_query}
  glBeginPerfQueryINTEL: procedure(queryHandle:GLuint); stdcall;
  glCreatePerfQueryINTEL: procedure(queryId:GLuint; queryHandle:PGLuint); stdcall;
  glDeletePerfQueryINTEL: procedure(queryHandle:GLuint); stdcall;
  glEndPerfQueryINTEL: procedure(queryHandle:GLuint); stdcall;
  glGetFirstPerfQueryIdINTEL: procedure(queryId:PGLuint); stdcall;
  glGetNextPerfQueryIdINTEL: procedure(queryId:GLuint; nextQueryId:PGLuint); stdcall;
  glGetPerfCounterInfoINTEL: procedure(queryId:GLuint; counterId:GLuint; counterNameLength:GLuint; counterName:PGLchar; counterDescLength:GLuint;
              counterDesc:PGLchar; counterOffset:PGLuint; counterDataSize:PGLuint; counterTypeEnum:PGLuint; counterDataTypeEnum:PGLuint;
              rawCounterMaxValue:PGLuint64); stdcall;
  glGetPerfQueryDataINTEL: procedure(queryHandle:GLuint; flags:GLuint; dataSize:GLsizei; data:pointer; bytesWritten:PGLuint); stdcall;
  glGetPerfQueryIdByNameINTEL: procedure(queryName:PGLchar; queryId:PGLuint); stdcall;
  glGetPerfQueryInfoINTEL: procedure(queryId:GLuint; queryNameLength:GLuint; queryName:PGLchar; dataSize:PGLuint; noCounters:PGLuint;
              noInstances:PGLuint; capsMask:PGLuint); stdcall;
{$EndIf}

{$IfDef GL_MESA_framebuffer_flip_y}
  glFramebufferParameteriMESA: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
  glGetFramebufferParameterivMESA: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
{$EndIf}

{$IfDef GL_NV_bindless_texture}
  glGetTextureHandleNV: function(texture:GLuint):GLuint64; stdcall;
  glGetTextureSamplerHandleNV: function(texture:GLuint; sampler:GLuint):GLuint64; stdcall;
  glMakeTextureHandleResidentNV: procedure(handle:GLuint64); stdcall;
  glMakeTextureHandleNonResidentNV: procedure(handle:GLuint64); stdcall;
  glGetImageHandleNV: function(texture:GLuint; level:GLint; layered:GLboolean; layer:GLint; format:GLenum):GLuint64; stdcall;
  glMakeImageHandleResidentNV: procedure(handle:GLuint64; access:GLenum); stdcall;
  glMakeImageHandleNonResidentNV: procedure(handle:GLuint64); stdcall;
  glUniformHandleui64NV: procedure(location:GLint; value:GLuint64); stdcall;
  glUniformHandleui64vNV: procedure(location:GLint; count:GLsizei; value:PGLuint64); stdcall;
  glProgramUniformHandleui64NV: procedure(_program:GLuint; location:GLint; value:GLuint64); stdcall;
  glProgramUniformHandleui64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; values:PGLuint64); stdcall;
  glIsTextureHandleResidentNV: function(handle:GLuint64):GLboolean; stdcall;
  glIsImageHandleResidentNV: function(handle:GLuint64):GLboolean; stdcall;
{$EndIf}

{$IfDef GL_NV_blend_equation_advanced}
  glBlendParameteriNV: procedure(pname:GLenum; value:GLint); stdcall;
  glBlendBarrierNV: procedure; stdcall;
{$EndIf}

{$IfDef GL_NV_clip_space_w_scaling}
  glViewportPositionWScaleNV: procedure(index:GLuint; xcoeff:GLfloat; ycoeff:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_NV_conditional_render}
  glBeginConditionalRenderNV: procedure(id:GLuint; mode:GLenum); stdcall;
  glEndConditionalRenderNV: procedure; stdcall;
{$EndIf}

{$IfDef GL_NV_conservative_raster}
  glSubpixelPrecisionBiasNV: procedure(xbits:GLuint; ybits:GLuint); stdcall;
{$EndIf}

{$IfDef GL_NV_conservative_raster_pre_snap_triangles}
  glConservativeRasterParameteriNV: procedure(pname:GLenum; param:GLint); stdcall;
{$EndIf}

{$IfDef GL_NV_copy_buffer}
  glCopyBufferSubDataNV: procedure(readTarget:GLenum; writeTarget:GLenum; readOffset:GLintptr; writeOffset:GLintptr; size:GLsizeiptr); stdcall;
{$EndIf}

{$IfDef GL_NV_coverage_sample}
  glCoverageMaskNV: procedure(mask:GLboolean); stdcall;
  glCoverageOperationNV: procedure(operation:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_draw_buffers}
  glDrawBuffersNV: procedure(n:GLsizei; bufs:PGLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_draw_instanced}
  glDrawArraysInstancedNV: procedure(mode:GLenum; first:GLint; count:GLsizei; primcount:GLsizei); stdcall;
  glDrawElementsInstancedNV: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; primcount:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_NV_draw_vulkan_image}
  glDrawVkImageNV: procedure(vkImage:GLuint64; sampler:GLuint; x0:GLfloat; y0:GLfloat; x1:GLfloat;
              y1:GLfloat; z:GLfloat; s0:GLfloat; t0:GLfloat; s1:GLfloat; t1:GLfloat); stdcall;
  glGetVkProcAddrNV: function(name:PGLchar):GLVULKANPROCNV; stdcall;
  glWaitVkSemaphoreNV: procedure(vkSemaphore:GLuint64); stdcall;
  glSignalVkSemaphoreNV: procedure(vkSemaphore:GLuint64); stdcall;
  glSignalVkFenceNV: procedure(vkFence:GLuint64); stdcall;
{$EndIf}

{$IfDef GL_NV_fence}
  glDeleteFencesNV: procedure(n:GLsizei; fences:PGLuint); stdcall;
  glGenFencesNV: procedure(n:GLsizei; fences:PGLuint); stdcall;
  glIsFenceNV: function(fence:GLuint):GLboolean; stdcall;
  glTestFenceNV: function(fence:GLuint):GLboolean; stdcall;
  glGetFenceivNV: procedure(fence:GLuint; pname:GLenum; params:PGLint); stdcall;
  glFinishFenceNV: procedure(fence:GLuint); stdcall;
  glSetFenceNV: procedure(fence:GLuint; condition:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_fragment_coverage_to_color}
  glFragmentCoverageColorNV: procedure(color:GLuint); stdcall;
{$EndIf}

{$IfDef GL_NV_framebuffer_blit}
  glBlitFramebufferNV: procedure(srcX0:GLint; srcY0:GLint; srcX1:GLint; srcY1:GLint; dstX0:GLint;
              dstY0:GLint; dstX1:GLint; dstY1:GLint; mask:GLbitfield; filter:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_framebuffer_mixed_samples}
  glCoverageModulationTableNV: procedure(n:GLsizei; v:PGLfloat); stdcall;
  glGetCoverageModulationTableNV: procedure(bufSize:GLsizei; v:PGLfloat); stdcall;
  glCoverageModulationNV: procedure(components:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_framebuffer_multisample}
  glRenderbufferStorageMultisampleNV: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_NV_gpu_shader5}
  glUniform1i64NV: procedure(location:GLint; x:GLint64EXT); stdcall;
  glUniform2i64NV: procedure(location:GLint; x:GLint64EXT; y:GLint64EXT); stdcall;
  glUniform3i64NV: procedure(location:GLint; x:GLint64EXT; y:GLint64EXT; z:GLint64EXT); stdcall;
  glUniform4i64NV: procedure(location:GLint; x:GLint64EXT; y:GLint64EXT; z:GLint64EXT; w:GLint64EXT); stdcall;
  glUniform1i64vNV: procedure(location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glUniform2i64vNV: procedure(location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glUniform3i64vNV: procedure(location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glUniform4i64vNV: procedure(location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glUniform1ui64NV: procedure(location:GLint; x:GLuint64EXT); stdcall;
  glUniform2ui64NV: procedure(location:GLint; x:GLuint64EXT; y:GLuint64EXT); stdcall;
  glUniform3ui64NV: procedure(location:GLint; x:GLuint64EXT; y:GLuint64EXT; z:GLuint64EXT); stdcall;
  glUniform4ui64NV: procedure(location:GLint; x:GLuint64EXT; y:GLuint64EXT; z:GLuint64EXT; w:GLuint64EXT); stdcall;
  glUniform1ui64vNV: procedure(location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glUniform2ui64vNV: procedure(location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glUniform3ui64vNV: procedure(location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glUniform4ui64vNV: procedure(location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glGetUniformi64vNV: procedure(_program:GLuint; location:GLint; params:PGLint64EXT); stdcall;
  glProgramUniform1i64NV: procedure(_program:GLuint; location:GLint; x:GLint64EXT); stdcall;
  glProgramUniform2i64NV: procedure(_program:GLuint; location:GLint; x:GLint64EXT; y:GLint64EXT); stdcall;
  glProgramUniform3i64NV: procedure(_program:GLuint; location:GLint; x:GLint64EXT; y:GLint64EXT; z:GLint64EXT); stdcall;
  glProgramUniform4i64NV: procedure(_program:GLuint; location:GLint; x:GLint64EXT; y:GLint64EXT; z:GLint64EXT; w:GLint64EXT); stdcall;
  glProgramUniform1i64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glProgramUniform2i64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glProgramUniform3i64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glProgramUniform4i64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint64EXT); stdcall;
  glProgramUniform1ui64NV: procedure(_program:GLuint; location:GLint; x:GLuint64EXT); stdcall;
  glProgramUniform2ui64NV: procedure(_program:GLuint; location:GLint; x:GLuint64EXT; y:GLuint64EXT); stdcall;
  glProgramUniform3ui64NV: procedure(_program:GLuint; location:GLint; x:GLuint64EXT; y:GLuint64EXT; z:GLuint64EXT); stdcall;
  glProgramUniform4ui64NV: procedure(_program:GLuint; location:GLint; x:GLuint64EXT; y:GLuint64EXT; z:GLuint64EXT; w:GLuint64EXT); stdcall;
  glProgramUniform1ui64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glProgramUniform2ui64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glProgramUniform3ui64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
  glProgramUniform4ui64vNV: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint64EXT); stdcall;
{$EndIf}

{$IfDef GL_NV_instanced_arrays}
  glVertexAttribDivisorNV: procedure(index:GLuint; divisor:GLuint); stdcall;
{$EndIf}

{$IfDef GL_NV_internalformat_sample_query}
  glGetInternalformatSampleivNV: procedure(target:GLenum; internalformat:GLenum; samples:GLsizei; pname:GLenum; count:GLsizei;
              params:PGLint); stdcall;
{$EndIf}

{$IfDef GL_NV_memory_attachment}
  glGetMemoryObjectDetachedResourcesuivNV: procedure(memory:GLuint; pname:GLenum; first:GLint; count:GLsizei; params:PGLuint); stdcall;
  glResetMemoryObjectParameterNV: procedure(memory:GLuint; pname:GLenum); stdcall;
  glTexAttachMemoryNV: procedure(target:GLenum; memory:GLuint; offset:GLuint64); stdcall;
  glBufferAttachMemoryNV: procedure(target:GLenum; memory:GLuint; offset:GLuint64); stdcall;
  glTextureAttachMemoryNV: procedure(texture:GLuint; memory:GLuint; offset:GLuint64); stdcall;
  glNamedBufferAttachMemoryNV: procedure(buffer:GLuint; memory:GLuint; offset:GLuint64); stdcall;
{$EndIf}

{$IfDef GL_NV_memory_object_sparse}
  glBufferPageCommitmentMemNV: procedure(target:GLenum; offset:GLintptr; size:GLsizeiptr; memory:GLuint; memOffset:GLuint64;
              commit:GLboolean); stdcall;
  glTexPageCommitmentMemNV: procedure(target:GLenum; layer:GLint; level:GLint; xoffset:GLint; yoffset:GLint;
              zoffset:GLint; width:GLsizei; height:GLsizei; depth:GLsizei; memory:GLuint;
              offset:GLuint64; commit:GLboolean); stdcall;
  glNamedBufferPageCommitmentMemNV: procedure(buffer:GLuint; offset:GLintptr; size:GLsizeiptr; memory:GLuint; memOffset:GLuint64;
              commit:GLboolean); stdcall;
  glTexturePageCommitmentMemNV: procedure(texture:GLuint; layer:GLint; level:GLint; xoffset:GLint; yoffset:GLint;
              zoffset:GLint; width:GLsizei; height:GLsizei; depth:GLsizei; memory:GLuint;
              offset:GLuint64; commit:GLboolean); stdcall;
{$EndIf}

{$IfDef GL_NV_mesh_shader}
  glDrawMeshTasksNV: procedure(first:GLuint; count:GLuint); stdcall;
  glDrawMeshTasksIndirectNV: procedure(indirect:GLintptr); stdcall;
  glMultiDrawMeshTasksIndirectNV: procedure(indirect:GLintptr; drawcount:GLsizei; stride:GLsizei); stdcall;
  glMultiDrawMeshTasksIndirectCountNV: procedure(indirect:GLintptr; drawcount:GLintptr; maxdrawcount:GLsizei; stride:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_NV_non_square_matrices}
  glUniformMatrix2x3fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix3x2fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix2x4fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix4x2fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix3x4fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix4x3fvNV: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
{$EndIf}

{$IfDef GL_NV_path_rendering}
  glGenPathsNV: function(range:GLsizei):GLuint; stdcall;
  glDeletePathsNV: procedure(path:GLuint; range:GLsizei); stdcall;
  glIsPathNV: function(path:GLuint):GLboolean; stdcall;
  glPathCommandsNV: procedure(path:GLuint; numCommands:GLsizei; commands:PGLubyte; numCoords:GLsizei; coordType:GLenum;
              coords:pointer); stdcall;
  glPathCoordsNV: procedure(path:GLuint; numCoords:GLsizei; coordType:GLenum; coords:pointer); stdcall;
  glPathSubCommandsNV: procedure(path:GLuint; commandStart:GLsizei; commandsToDelete:GLsizei; numCommands:GLsizei; commands:PGLubyte;
              numCoords:GLsizei; coordType:GLenum; coords:pointer); stdcall;
  glPathSubCoordsNV: procedure(path:GLuint; coordStart:GLsizei; numCoords:GLsizei; coordType:GLenum; coords:pointer); stdcall;
  glPathStringNV: procedure(path:GLuint; format:GLenum; length:GLsizei; pathString:pointer); stdcall;
  glPathGlyphsNV: procedure(firstPathName:GLuint; fontTarget:GLenum; fontName:pointer; fontStyle:GLbitfield; numGlyphs:GLsizei;
              _type:GLenum; charcodes:pointer; handleMissingGlyphs:GLenum; pathParameterTemplate:GLuint; emScale:GLfloat); stdcall;
  glPathGlyphRangeNV: procedure(firstPathName:GLuint; fontTarget:GLenum; fontName:pointer; fontStyle:GLbitfield; firstGlyph:GLuint;
              numGlyphs:GLsizei; handleMissingGlyphs:GLenum; pathParameterTemplate:GLuint; emScale:GLfloat); stdcall;
  glWeightPathsNV: procedure(resultPath:GLuint; numPaths:GLsizei; paths:PGLuint; weights:PGLfloat); stdcall;
  glCopyPathNV: procedure(resultPath:GLuint; srcPath:GLuint); stdcall;
  glInterpolatePathsNV: procedure(resultPath:GLuint; pathA:GLuint; pathB:GLuint; weight:GLfloat); stdcall;
  glTransformPathNV: procedure(resultPath:GLuint; srcPath:GLuint; transformType:GLenum; transformValues:PGLfloat); stdcall;
  glPathParameterivNV: procedure(path:GLuint; pname:GLenum; value:PGLint); stdcall;
  glPathParameteriNV: procedure(path:GLuint; pname:GLenum; value:GLint); stdcall;
  glPathParameterfvNV: procedure(path:GLuint; pname:GLenum; value:PGLfloat); stdcall;
  glPathParameterfNV: procedure(path:GLuint; pname:GLenum; value:GLfloat); stdcall;
  glPathDashArrayNV: procedure(path:GLuint; dashCount:GLsizei; dashArray:PGLfloat); stdcall;
  glPathStencilFuncNV: procedure(func:GLenum; ref:GLint; mask:GLuint); stdcall;
  glPathStencilDepthOffsetNV: procedure(factor:GLfloat; units:GLfloat); stdcall;
  glStencilFillPathNV: procedure(path:GLuint; fillMode:GLenum; mask:GLuint); stdcall;
  glStencilStrokePathNV: procedure(path:GLuint; reference:GLint; mask:GLuint); stdcall;
  glStencilFillPathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; fillMode:GLenum;
              mask:GLuint; transformType:GLenum; transformValues:PGLfloat); stdcall;
  glStencilStrokePathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; reference:GLint;
              mask:GLuint; transformType:GLenum; transformValues:PGLfloat); stdcall;
  glPathCoverDepthFuncNV: procedure(func:GLenum); stdcall;
  glCoverFillPathNV: procedure(path:GLuint; coverMode:GLenum); stdcall;
  glCoverStrokePathNV: procedure(path:GLuint; coverMode:GLenum); stdcall;
  glCoverFillPathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; coverMode:GLenum;
              transformType:GLenum; transformValues:PGLfloat); stdcall;
  glCoverStrokePathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; coverMode:GLenum;
              transformType:GLenum; transformValues:PGLfloat); stdcall;
  glGetPathParameterivNV: procedure(path:GLuint; pname:GLenum; value:PGLint); stdcall;
  glGetPathParameterfvNV: procedure(path:GLuint; pname:GLenum; value:PGLfloat); stdcall;
  glGetPathCommandsNV: procedure(path:GLuint; commands:PGLubyte); stdcall;
  glGetPathCoordsNV: procedure(path:GLuint; coords:PGLfloat); stdcall;
  glGetPathDashArrayNV: procedure(path:GLuint; dashArray:PGLfloat); stdcall;
  glGetPathMetricsNV: procedure(metricQueryMask:GLbitfield; numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint;
              stride:GLsizei; metrics:PGLfloat); stdcall;
  glGetPathMetricRangeNV: procedure(metricQueryMask:GLbitfield; firstPathName:GLuint; numPaths:GLsizei; stride:GLsizei; metrics:PGLfloat); stdcall;
  glGetPathSpacingNV: procedure(pathListMode:GLenum; numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint;
              advanceScale:GLfloat; kerningScale:GLfloat; transformType:GLenum; returnedSpacing:PGLfloat); stdcall;
  glIsPointInFillPathNV: function(path:GLuint; mask:GLuint; x:GLfloat; y:GLfloat):GLboolean; stdcall;
  glIsPointInStrokePathNV: function(path:GLuint; x:GLfloat; y:GLfloat):GLboolean; stdcall;
  glGetPathLengthNV: function(path:GLuint; startSegment:GLsizei; numSegments:GLsizei):GLfloat; stdcall;
  glPointAlongPathNV: function(path:GLuint; startSegment:GLsizei; numSegments:GLsizei; distance:GLfloat; x:PGLfloat;
             y:PGLfloat; tangentX:PGLfloat; tangentY:PGLfloat):GLboolean; stdcall;
  glMatrixLoad3x2fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glMatrixLoad3x3fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glMatrixLoadTranspose3x3fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glMatrixMult3x2fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glMatrixMult3x3fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glMatrixMultTranspose3x3fNV: procedure(matrixMode:GLenum; m:PGLfloat); stdcall;
  glStencilThenCoverFillPathNV: procedure(path:GLuint; fillMode:GLenum; mask:GLuint; coverMode:GLenum); stdcall;
  glStencilThenCoverStrokePathNV: procedure(path:GLuint; reference:GLint; mask:GLuint; coverMode:GLenum); stdcall;
  glStencilThenCoverFillPathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; fillMode:GLenum;
              mask:GLuint; coverMode:GLenum; transformType:GLenum; transformValues:PGLfloat); stdcall;
  glStencilThenCoverStrokePathInstancedNV: procedure(numPaths:GLsizei; pathNameType:GLenum; paths:pointer; pathBase:GLuint; reference:GLint;
              mask:GLuint; coverMode:GLenum; transformType:GLenum; transformValues:PGLfloat); stdcall;
  glPathGlyphIndexRangeNV: function(fontTarget:GLenum; fontName:pointer; fontStyle:GLbitfield; pathParameterTemplate:GLuint; emScale:GLfloat;
             baseAndCount:PGLuint):GLenum; stdcall;
  glPathGlyphIndexArrayNV: function(firstPathName:GLuint; fontTarget:GLenum; fontName:pointer; fontStyle:GLbitfield; firstGlyphIndex:GLuint;
             numGlyphs:GLsizei; pathParameterTemplate:GLuint; emScale:GLfloat):GLenum; stdcall;
  glPathMemoryGlyphIndexArrayNV: function(firstPathName:GLuint; fontTarget:GLenum; fontSize:GLsizeiptr; fontData:pointer; faceIndex:GLsizei;
             firstGlyphIndex:GLuint; numGlyphs:GLsizei; pathParameterTemplate:GLuint; emScale:GLfloat):GLenum; stdcall;
  glProgramPathFragmentInputGenNV: procedure(_program:GLuint; location:GLint; genMode:GLenum; components:GLint; coeffs:PGLfloat); stdcall;
  glGetProgramResourcefvNV: procedure(_program:GLuint; programInterface:GLenum; index:GLuint; propCount:GLsizei; props:PGLenum;
              count:GLsizei; length:PGLsizei; params:PGLfloat); stdcall;
  glMatrixFrustumEXT: procedure(mode:GLenum; left:GLdouble; right:GLdouble; bottom:GLdouble; top:GLdouble;
              zNear:GLdouble; zFar:GLdouble); stdcall;
  glMatrixLoadIdentityEXT: procedure(mode:GLenum); stdcall;
  glMatrixLoadTransposefEXT: procedure(mode:GLenum; m:PGLfloat); stdcall;
  glMatrixLoadTransposedEXT: procedure(mode:GLenum; m:PGLdouble); stdcall;
  glMatrixLoadfEXT: procedure(mode:GLenum; m:PGLfloat); stdcall;
  glMatrixLoaddEXT: procedure(mode:GLenum; m:PGLdouble); stdcall;
  glMatrixMultTransposefEXT: procedure(mode:GLenum; m:PGLfloat); stdcall;
  glMatrixMultTransposedEXT: procedure(mode:GLenum; m:PGLdouble); stdcall;
  glMatrixMultfEXT: procedure(mode:GLenum; m:PGLfloat); stdcall;
  glMatrixMultdEXT: procedure(mode:GLenum; m:PGLdouble); stdcall;
  glMatrixOrthoEXT: procedure(mode:GLenum; left:GLdouble; right:GLdouble; bottom:GLdouble; top:GLdouble;
              zNear:GLdouble; zFar:GLdouble); stdcall;
  glMatrixPopEXT: procedure(mode:GLenum); stdcall;
  glMatrixPushEXT: procedure(mode:GLenum); stdcall;
  glMatrixRotatefEXT: procedure(mode:GLenum; angle:GLfloat; x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glMatrixRotatedEXT: procedure(mode:GLenum; angle:GLdouble; x:GLdouble; y:GLdouble; z:GLdouble); stdcall;
  glMatrixScalefEXT: procedure(mode:GLenum; x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glMatrixScaledEXT: procedure(mode:GLenum; x:GLdouble; y:GLdouble; z:GLdouble); stdcall;
  glMatrixTranslatefEXT: procedure(mode:GLenum; x:GLfloat; y:GLfloat; z:GLfloat); stdcall;
  glMatrixTranslatedEXT: procedure(mode:GLenum; x:GLdouble; y:GLdouble; z:GLdouble); stdcall;
{$EndIf}

{$IfDef GL_NV_polygon_mode}
  glPolygonModeNV: procedure(face:GLenum; mode:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_read_buffer}
  glReadBufferNV: procedure(mode:GLenum); stdcall;
{$EndIf}

{$IfDef GL_NV_sample_locations}
  glFramebufferSampleLocationsfvNV: procedure(target:GLenum; start:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glNamedFramebufferSampleLocationsfvNV: procedure(framebuffer:GLuint; start:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glResolveDepthValuesNV: procedure; stdcall;
{$EndIf}

{$IfDef GL_NV_scissor_exclusive}
  glScissorExclusiveNV: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
  glScissorExclusiveArrayvNV: procedure(first:GLuint; count:GLsizei; v:PGLint); stdcall;
{$EndIf}

{$IfDef GL_NV_shading_rate_image}
  glBindShadingRateImageNV: procedure(texture:GLuint); stdcall;
  glGetShadingRateImagePaletteNV: procedure(viewport:GLuint; entry:GLuint; rate:PGLenum); stdcall;
  glGetShadingRateSampleLocationivNV: procedure(rate:GLenum; samples:GLuint; index:GLuint; location:PGLint); stdcall;
  glShadingRateImageBarrierNV: procedure(synchronize:GLboolean); stdcall;
  glShadingRateImagePaletteNV: procedure(viewport:GLuint; first:GLuint; count:GLsizei; rates:PGLenum); stdcall;
  glShadingRateSampleOrderNV: procedure(order:GLenum); stdcall;
  glShadingRateSampleOrderCustomNV: procedure(rate:GLenum; samples:GLuint; locations:PGLint); stdcall;
{$EndIf}

{$IfDef GL_NV_timeline_semaphore}
  glCreateSemaphoresNV: procedure(n:GLsizei; semaphores:PGLuint); stdcall;
  glSemaphoreParameterivNV: procedure(semaphore:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetSemaphoreParameterivNV: procedure(semaphore:GLuint; pname:GLenum; params:PGLint); stdcall;
{$EndIf}

{$IfDef GL_NV_viewport_array}
  glViewportArrayvNV: procedure(first:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glViewportIndexedfNV: procedure(index:GLuint; x:GLfloat; y:GLfloat; w:GLfloat; h:GLfloat); stdcall;
  glViewportIndexedfvNV: procedure(index:GLuint; v:PGLfloat); stdcall;
  glScissorArrayvNV: procedure(first:GLuint; count:GLsizei; v:PGLint); stdcall;
  glScissorIndexedNV: procedure(index:GLuint; left:GLint; bottom:GLint; width:GLsizei; height:GLsizei); stdcall;
  glScissorIndexedvNV: procedure(index:GLuint; v:PGLint); stdcall;
  glDepthRangeArrayfvNV: procedure(first:GLuint; count:GLsizei; v:PGLfloat); stdcall;
  glDepthRangeIndexedfNV: procedure(index:GLuint; n:GLfloat; f:GLfloat); stdcall;
  glGetFloati_vNV: procedure(target:GLenum; index:GLuint; data:PGLfloat); stdcall;
  glEnableiNV: procedure(target:GLenum; index:GLuint); stdcall;
  glDisableiNV: procedure(target:GLenum; index:GLuint); stdcall;
  glIsEnablediNV: function(target:GLenum; index:GLuint):GLboolean; stdcall;
{$EndIf}

{$IfDef GL_NV_viewport_swizzle}
  glViewportSwizzleNV: procedure(index:GLuint; swizzlex:GLenum; swizzley:GLenum; swizzlez:GLenum; swizzlew:GLenum); stdcall;
{$EndIf}

{$IfDef GL_OVR_multiview}
  glFramebufferTextureMultiviewOVR: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint; baseViewIndex:GLint;
              numViews:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_OVR_multiview_multisampled_render_to_texture}
  glFramebufferTextureMultisampleMultiviewOVR: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint; samples:GLsizei;
              baseViewIndex:GLint; numViews:GLsizei); stdcall;
{$EndIf}

{$IfDef GL_QCOM_alpha_test}
  glAlphaFuncQCOM: procedure(func:GLenum; ref:GLclampf); stdcall;
{$EndIf}

{$IfDef GL_QCOM_driver_control}
  glGetDriverControlsQCOM: procedure(num:PGLint; size:GLsizei; driverControls:PGLuint); stdcall;
  glGetDriverControlStringQCOM: procedure(driverControl:GLuint; bufSize:GLsizei; length:PGLsizei; driverControlString:PGLchar); stdcall;
  glEnableDriverControlQCOM: procedure(driverControl:GLuint); stdcall;
  glDisableDriverControlQCOM: procedure(driverControl:GLuint); stdcall;
{$EndIf}

{$IfDef GL_QCOM_extended_get}
  glExtGetTexturesQCOM: procedure(textures:PGLuint; maxTextures:GLint; numTextures:PGLint); stdcall;
  glExtGetBuffersQCOM: procedure(buffers:PGLuint; maxBuffers:GLint; numBuffers:PGLint); stdcall;
  glExtGetRenderbuffersQCOM: procedure(renderbuffers:PGLuint; maxRenderbuffers:GLint; numRenderbuffers:PGLint); stdcall;
  glExtGetFramebuffersQCOM: procedure(framebuffers:PGLuint; maxFramebuffers:GLint; numFramebuffers:PGLint); stdcall;
  glExtGetTexLevelParameterivQCOM: procedure(texture:GLuint; face:GLenum; level:GLint; pname:GLenum; params:PGLint); stdcall;
  glExtTexObjectStateOverrideiQCOM: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
  glExtGetTexSubImageQCOM: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; _type:GLenum; texels:pointer); stdcall;
  glExtGetBufferPointervQCOM: procedure(target:GLenum; params:Ppointer); stdcall;
{$EndIf}

{$IfDef GL_QCOM_extended_get2}
  glExtGetShadersQCOM: procedure(shaders:PGLuint; maxShaders:GLint; numShaders:PGLint); stdcall;
  glExtGetProgramsQCOM: procedure(programs:PGLuint; maxPrograms:GLint; numPrograms:PGLint); stdcall;
  glExtIsProgramBinaryQCOM: function(_program:GLuint):GLboolean; stdcall;
  glExtGetProgramBinarySourceQCOM: procedure(_program:GLuint; shadertype:GLenum; source:PGLchar; length:PGLint); stdcall;
{$EndIf}

{$IfDef GL_QCOM_frame_extrapolation}
  glExtrapolateTex2DQCOM: procedure(src1:GLuint; src2:GLuint; output:GLuint; scaleFactor:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_QCOM_framebuffer_foveated}
  glFramebufferFoveationConfigQCOM: procedure(framebuffer:GLuint; numLayers:GLuint; focalPointsPerLayer:GLuint; requestedFeatures:GLuint; providedFeatures:PGLuint); stdcall;
  glFramebufferFoveationParametersQCOM: procedure(framebuffer:GLuint; layer:GLuint; focalPoint:GLuint; focalX:GLfloat; focalY:GLfloat;
              gainX:GLfloat; gainY:GLfloat; foveaArea:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_QCOM_motion_estimation}
  glTexEstimateMotionQCOM: procedure(ref:GLuint; target:GLuint; output:GLuint); stdcall;
  glTexEstimateMotionRegionsQCOM: procedure(ref:GLuint; target:GLuint; output:GLuint; mask:GLuint); stdcall;
{$EndIf}

{$IfDef GL_QCOM_shader_framebuffer_fetch_noncoherent}
  glFramebufferFetchBarrierQCOM: procedure; stdcall;
{$EndIf}

{$IfDef GL_QCOM_shading_rate}
  glShadingRateQCOM: procedure(rate:GLenum); stdcall;
{$EndIf}

{$IfDef GL_QCOM_texture_foveated}
  glTextureFoveationParametersQCOM: procedure(texture:GLuint; layer:GLuint; focalPoint:GLuint; focalX:GLfloat; focalY:GLfloat;
              gainX:GLfloat; gainY:GLfloat; foveaArea:GLfloat); stdcall;
{$EndIf}

{$IfDef GL_QCOM_tiled_rendering}
  glStartTilingQCOM: procedure(x:GLuint; y:GLuint; width:GLuint; height:GLuint; preserveMask:GLbitfield); stdcall;
  glEndTilingQCOM: procedure(preserveMask:GLbitfield); stdcall;
{$EndIf}

{$IfDef GL_ES_VERSION_3_0}
// GL_NV_read_buffer
  glReadBuffer: procedure(src:GLenum); stdcall;
// none
  glDrawRangeElements: procedure(mode:GLenum; start:GLuint; _end:GLuint; count:GLsizei; _type:GLenum; indices:pointer); stdcall;
// GL_OES_texture_3D
  glTexImage3D: procedure(target:GLenum; level:GLint; internalformat:GLint; width:GLsizei; height:GLsizei;
              depth:GLsizei; border:GLint; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glTexSubImage3D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; _type:GLenum; pixels:pointer); stdcall;
  glCopyTexSubImage3D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              x:GLint; y:GLint; width:GLsizei; height:GLsizei); stdcall;
  glCompressedTexImage3D: procedure(target:GLenum; level:GLint; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; border:GLint; imageSize:GLsizei; data:pointer); stdcall;
  glCompressedTexSubImage3D: procedure(target:GLenum; level:GLint; xoffset:GLint; yoffset:GLint; zoffset:GLint;
              width:GLsizei; height:GLsizei; depth:GLsizei; format:GLenum; imageSize:GLsizei; data:pointer); stdcall;
// GL_EXT_disjoint_timer_query
  glGenQueries: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glDeleteQueries: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glIsQuery: function(id:GLuint):GLboolean; stdcall;
  glBeginQuery: procedure(target:GLenum; id:GLuint); stdcall;
  glEndQuery: procedure(target:GLenum); stdcall;
  glGetQueryiv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetQueryObjectuiv: procedure(id:GLuint; pname:GLenum; params:PGLuint); stdcall;
// GL_OES_mapbuffer
  glUnmapBuffer: function(target:GLenum):GLboolean; stdcall;
  glGetBufferPointerv: procedure(target:GLenum; pname:GLenum; params:Ppointer); stdcall;
// GL_EXT_draw_buffers + GL_NV_draw_buffers
  glDrawBuffers: procedure(n:GLsizei; bufs:PGLenum); stdcall;
// GL_NV_non_square_matrices
  glUniformMatrix2x3fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix3x2fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix2x4fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix4x2fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix3x4fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glUniformMatrix4x3fv: procedure(location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
// GL_ANGLE_framebuffer_blit + GL_NV_framebuffer_blit
  glBlitFramebuffer: procedure(srcX0:GLint; srcY0:GLint; srcX1:GLint; srcY1:GLint; dstX0:GLint;
              dstY0:GLint; dstX1:GLint; dstY1:GLint; mask:GLbitfield; filter:GLenum); stdcall;
// GL_ANGLE_framebuffer_multisample + GL_APPLE_framebuffer_multisample + GL_EXT_multisampled_render_to_texture +
//                                  GL_IMG_multisampled_render_to_texture + GL_NV_framebuffer_multisample
  glRenderbufferStorageMultisample: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
// none
  glFramebufferTextureLayer: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint; layer:GLint); stdcall;
// GL_EXT_map_buffer_range
  glMapBufferRange: function(target:GLenum; offset:GLintptr; length:GLsizeiptr; access:GLbitfield):pointer; stdcall;
  glFlushMappedBufferRange: procedure(target:GLenum; offset:GLintptr; length:GLsizeiptr); stdcall;
// GL_OES_vertex_array_object
  glBindVertexArray: procedure(_array:GLuint); stdcall;
  glDeleteVertexArrays: procedure(n:GLsizei; arrays:PGLuint); stdcall;
  glGenVertexArrays: procedure(n:GLsizei; arrays:PGLuint); stdcall;
  glIsVertexArray: function(_array:GLuint):GLboolean; stdcall;
// GL_EXT_multiview_draw_buffers
  glGetIntegeri_v: procedure(target:GLenum; index:GLuint; data:PGLint); stdcall;
// none
  glBeginTransformFeedback: procedure(primitiveMode:GLenum); stdcall;
  glEndTransformFeedback: procedure; stdcall;
  glBindBufferRange: procedure(target:GLenum; index:GLuint; buffer:GLuint; offset:GLintptr; size:GLsizeiptr); stdcall;
  glBindBufferBase: procedure(target:GLenum; index:GLuint; buffer:GLuint); stdcall;
  glTransformFeedbackVaryings: procedure(_program:GLuint; count:GLsizei; varyings:PPGLchar; bufferMode:GLenum); stdcall;
  glGetTransformFeedbackVarying: procedure(_program:GLuint; index:GLuint; bufSize:GLsizei; length:PGLsizei; size:PGLsizei;
              _type:PGLenum; name:PGLchar); stdcall;
  glVertexAttribIPointer: procedure(index:GLuint; size:GLint; _type:GLenum; stride:GLsizei; pointer:pointer); stdcall;
  glGetVertexAttribIiv: procedure(index:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetVertexAttribIuiv: procedure(index:GLuint; pname:GLenum; params:PGLuint); stdcall;
  glVertexAttribI4i: procedure(index:GLuint; x:GLint; y:GLint; z:GLint; w:GLint); stdcall;
  glVertexAttribI4ui: procedure(index:GLuint; x:GLuint; y:GLuint; z:GLuint; w:GLuint); stdcall;
  glVertexAttribI4iv: procedure(index:GLuint; v:PGLint); stdcall;
  glVertexAttribI4uiv: procedure(index:GLuint; v:PGLuint); stdcall;
  glGetUniformuiv: procedure(_program:GLuint; location:GLint; params:PGLuint); stdcall;
  glGetFragDataLocation: function(_program:GLuint; name:PGLchar):GLint; stdcall;
  glUniform1ui: procedure(location:GLint; v0:GLuint); stdcall;
  glUniform2ui: procedure(location:GLint; v0:GLuint; v1:GLuint); stdcall;
  glUniform3ui: procedure(location:GLint; v0:GLuint; v1:GLuint; v2:GLuint); stdcall;
  glUniform4ui: procedure(location:GLint; v0:GLuint; v1:GLuint; v2:GLuint; v3:GLuint); stdcall;
  glUniform1uiv: procedure(location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glUniform2uiv: procedure(location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glUniform3uiv: procedure(location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glUniform4uiv: procedure(location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glClearBufferiv: procedure(buffer:GLenum; drawbuffer:GLint; value:PGLint); stdcall;
  glClearBufferuiv: procedure(buffer:GLenum; drawbuffer:GLint; value:PGLuint); stdcall;
  glClearBufferfv: procedure(buffer:GLenum; drawbuffer:GLint; value:PGLfloat); stdcall;
  glClearBufferfi: procedure(buffer:GLenum; drawbuffer:GLint; depth:GLfloat; stencil:GLint); stdcall;
  glGetStringi: function(name:GLenum; index:GLuint):PGLubyte; stdcall;
// GL_NV_copy_buffer
  glCopyBufferSubData: procedure(readTarget:GLenum; writeTarget:GLenum; readOffset:GLintptr; writeOffset:GLintptr; size:GLsizeiptr); stdcall;
// none
  glGetUniformIndices: procedure(_program:GLuint; uniformCount:GLsizei; uniformNames:PPGLchar; uniformIndices:PGLuint); stdcall;
  glGetActiveUniformsiv: procedure(_program:GLuint; uniformCount:GLsizei; uniformIndices:PGLuint; pname:GLenum; params:PGLint); stdcall;
  glGetUniformBlockIndex: function(_program:GLuint; uniformBlockName:PGLchar):GLuint; stdcall;
  glGetActiveUniformBlockiv: procedure(_program:GLuint; uniformBlockIndex:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetActiveUniformBlockName: procedure(_program:GLuint; uniformBlockIndex:GLuint; bufSize:GLsizei; length:PGLsizei; uniformBlockName:PGLchar); stdcall;
  glUniformBlockBinding: procedure(_program:GLuint; uniformBlockIndex:GLuint; uniformBlockBinding:GLuint); stdcall;
// GL_ANGLE_instanced_arrays            GL_EXT_draw_instanced              GL_NV_draw_instanced
  glDrawArraysInstanced: procedure(mode:GLenum; first:GLint; count:GLsizei; instancecount:GLsizei); stdcall;
  glDrawElementsInstanced: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei); stdcall;
// GL_APPLE_sync
  glFenceSync: function(condition:GLenum; flags:GLbitfield):GLsync; stdcall;
  glIsSync: function(sync:GLsync):GLboolean; stdcall;
  glDeleteSync: procedure(sync:GLsync); stdcall;
  glClientWaitSync: function(sync:GLsync; flags:GLbitfield; timeout:GLuint64):GLenum; stdcall;
  glWaitSync: procedure(sync:GLsync; flags:GLbitfield; timeout:GLuint64); stdcall;
// GL_APPLE_sync                        GL_EXT_disjoint_timer_query
  glGetInteger64v: procedure(pname:GLenum; data:PGLint64); stdcall;
// GL_APPLE_sync
  glGetSynciv: procedure(sync:GLsync; pname:GLenum; bufSize:GLsizei; length:PGLsizei; values:PGLint); stdcall;
// none
  glGetInteger64i_v: procedure(target:GLenum; index:GLuint; data:PGLint64); stdcall;
  glGetBufferParameteri64v: procedure(target:GLenum; pname:GLenum; params:PGLint64); stdcall;
  glGenSamplers: procedure(count:GLsizei; samplers:PGLuint); stdcall;
  glDeleteSamplers: procedure(count:GLsizei; samplers:PGLuint); stdcall;
  glIsSampler: function(sampler:GLuint):GLboolean; stdcall;
  glBindSampler: procedure(_unit:GLuint; sampler:GLuint); stdcall;
  glSamplerParameteri: procedure(sampler:GLuint; pname:GLenum; param:GLint); stdcall;
  glSamplerParameteriv: procedure(sampler:GLuint; pname:GLenum; param:PGLint); stdcall;
  glSamplerParameterf: procedure(sampler:GLuint; pname:GLenum; param:GLfloat); stdcall;
  glSamplerParameterfv: procedure(sampler:GLuint; pname:GLenum; param:PGLfloat); stdcall;
  glGetSamplerParameteriv: procedure(sampler:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetSamplerParameterfv: procedure(sampler:GLuint; pname:GLenum; params:PGLfloat); stdcall;
// GL_ANGLE_instanced_arrays            GL_EXT_instanced_arrays       GL_NV_instanced_arrays
  glVertexAttribDivisor: procedure(index:GLuint; divisor:GLuint); stdcall;
// none
  glBindTransformFeedback: procedure(target:GLenum; id:GLuint); stdcall;
  glDeleteTransformFeedbacks: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glGenTransformFeedbacks: procedure(n:GLsizei; ids:PGLuint); stdcall;
  glIsTransformFeedback: function(id:GLuint):GLboolean; stdcall;
  glPauseTransformFeedback: procedure; stdcall;
  glResumeTransformFeedback: procedure; stdcall;
// GL_OES_get_program_binary
  glGetProgramBinary: procedure(_program:GLuint; bufSize:GLsizei; length:PGLsizei; binaryFormat:PGLenum; binary:pointer); stdcall;
  glProgramBinary: procedure(_program:GLuint; binaryFormat:GLenum; binary:pointer; length:GLsizei); stdcall;
// GL_EXT_separate_shader_objects
  glProgramParameteri: procedure(_program:GLuint; pname:GLenum; value:GLint); stdcall;
// none
  glInvalidateFramebuffer: procedure(target:GLenum; numAttachments:GLsizei; attachments:PGLenum); stdcall;
  glInvalidateSubFramebuffer: procedure(target:GLenum; numAttachments:GLsizei; attachments:PGLenum; x:GLint; y:GLint;
              width:GLsizei; height:GLsizei); stdcall;
// GL_EXT_texture_storage
  glTexStorage2D: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei); stdcall;
  glTexStorage3D: procedure(target:GLenum; levels:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei; depth:GLsizei); stdcall;
// none
  glGetInternalformativ: procedure(target:GLenum; internalformat:GLenum; pname:GLenum; bufSize:GLsizei; params:PGLint); stdcall;
{$EndIf}

{$IfDef GL_ES_VERSION_3_1}
// none
  glDispatchCompute: procedure(num_groups_x:GLuint; num_groups_y:GLuint; num_groups_z:GLuint); stdcall;
  glDispatchComputeIndirect: procedure(indirect:GLintptr); stdcall;
  glDrawArraysIndirect: procedure(mode:GLenum; indirect:pointer); stdcall;
  glDrawElementsIndirect: procedure(mode:GLenum; _type:GLenum; indirect:pointer); stdcall;
// GL_MESA_framebuffer_flip_y
  glFramebufferParameteri: procedure(target:GLenum; pname:GLenum; param:GLint); stdcall;
  glGetFramebufferParameteriv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
// none
  glGetProgramInterfaceiv: procedure(_program:GLuint; programInterface:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetProgramResourceIndex: function(_program:GLuint; programInterface:GLenum; name:PGLchar):GLuint; stdcall;
  glGetProgramResourceName: procedure(_program:GLuint; programInterface:GLenum; index:GLuint; bufSize:GLsizei; length:PGLsizei; name:PGLchar); stdcall;
  glGetProgramResourceiv: procedure(_program:GLuint; programInterface:GLenum; index:GLuint; propCount:GLsizei; props:PGLenum;
              bufSize:GLsizei; length:PGLsizei; params:PGLint); stdcall;
  glGetProgramResourceLocation: function(_program:GLuint; programInterface:GLenum; name:PGLchar):GLint; stdcall;
// GL_EXT_separate_shader_objects
  glUseProgramStages: procedure(pipeline:GLuint; stages:GLbitfield; _program:GLuint); stdcall;
  glActiveShaderProgram: procedure(pipeline:GLuint; _program:GLuint); stdcall;
  glCreateShaderProgramv: function(_type:GLenum; count:GLsizei; strings:PPGLchar):GLuint; stdcall;
  glBindProgramPipeline: procedure(pipeline:GLuint); stdcall;
  glDeleteProgramPipelines: procedure(n:GLsizei; pipelines:PGLuint); stdcall;
  glGenProgramPipelines: procedure(n:GLsizei; pipelines:PGLuint); stdcall;
  glIsProgramPipeline: function(pipeline:GLuint):GLboolean; stdcall;
  glGetProgramPipelineiv: procedure(pipeline:GLuint; pname:GLenum; params:PGLint); stdcall;
  glProgramUniform1i: procedure(_program:GLuint; location:GLint; v0:GLint); stdcall;
  glProgramUniform2i: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint); stdcall;
  glProgramUniform3i: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint; v2:GLint); stdcall;
  glProgramUniform4i: procedure(_program:GLuint; location:GLint; v0:GLint; v1:GLint; v2:GLint; v3:GLint); stdcall;
  glProgramUniform1ui: procedure(_program:GLuint; location:GLint; v0:GLuint); stdcall;
  glProgramUniform2ui: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint); stdcall;
  glProgramUniform3ui: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint; v2:GLuint); stdcall;
  glProgramUniform4ui: procedure(_program:GLuint; location:GLint; v0:GLuint; v1:GLuint; v2:GLuint; v3:GLuint); stdcall;
  glProgramUniform1f: procedure(_program:GLuint; location:GLint; v0:GLfloat); stdcall;
  glProgramUniform2f: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat); stdcall;
  glProgramUniform3f: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat); stdcall;
  glProgramUniform4f: procedure(_program:GLuint; location:GLint; v0:GLfloat; v1:GLfloat; v2:GLfloat; v3:GLfloat); stdcall;
  glProgramUniform1iv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform2iv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform3iv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform4iv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLint); stdcall;
  glProgramUniform1uiv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform2uiv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform3uiv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform4uiv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLuint); stdcall;
  glProgramUniform1fv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform2fv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform3fv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniform4fv: procedure(_program:GLuint; location:GLint; count:GLsizei; value:PGLfloat); stdcall;
  glProgramUniformMatrix2fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix2x3fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3x2fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix2x4fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4x2fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix3x4fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glProgramUniformMatrix4x3fv: procedure(_program:GLuint; location:GLint; count:GLsizei; transpose:GLboolean; value:PGLfloat); stdcall;
  glValidateProgramPipeline: procedure(pipeline:GLuint); stdcall;
  glGetProgramPipelineInfoLog: procedure(pipeline:GLuint; bufSize:GLsizei; length:PGLsizei; infoLog:PGLchar); stdcall;
// none
  glBindImageTexture: procedure(_unit:GLuint; texture:GLuint; level:GLint; layered:GLboolean; layer:GLint;
              access:GLenum; format:GLenum); stdcall;
  glGetBooleani_v: procedure(target:GLenum; index:GLuint; data:PGLboolean); stdcall;
  glMemoryBarrier: procedure(barriers:GLbitfield); stdcall;
  glMemoryBarrierByRegion: procedure(barriers:GLbitfield); stdcall;
  glTexStorage2DMultisample: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei;
              fixedsamplelocations:GLboolean); stdcall;
  glGetMultisamplefv: procedure(pname:GLenum; index:GLuint; val:PGLfloat); stdcall;
  glSampleMaski: procedure(maskNumber:GLuint; mask:GLbitfield); stdcall;
  glGetTexLevelParameteriv: procedure(target:GLenum; level:GLint; pname:GLenum; params:PGLint); stdcall;
  glGetTexLevelParameterfv: procedure(target:GLenum; level:GLint; pname:GLenum; params:PGLfloat); stdcall;
  glBindVertexBuffer: procedure(bindingindex:GLuint; buffer:GLuint; offset:GLintptr; stride:GLsizei); stdcall;
  glVertexAttribFormat: procedure(attribindex:GLuint; size:GLint; _type:GLenum; normalized:GLboolean; relativeoffset:GLuint); stdcall;
  glVertexAttribIFormat: procedure(attribindex:GLuint; size:GLint; _type:GLenum; relativeoffset:GLuint); stdcall;
  glVertexAttribBinding: procedure(attribindex:GLuint; bindingindex:GLuint); stdcall;
  glVertexBindingDivisor: procedure(bindingindex:GLuint; divisor:GLuint); stdcall;
{$EndIf}

{$IfDef GL_ES_VERSION_3_2}
// GL_KHR_blend_equation_advanced        GL_NV_blend_equation_advanced
  glBlendBarrier: procedure; stdcall;
// GL_OES_copy_image                     GL_EXT_copy_image
  glCopyImageSubData: procedure(srcName:GLuint; srcTarget:GLenum; srcLevel:GLint; srcX:GLint; srcY:GLint;
              srcZ:GLint; dstName:GLuint; dstTarget:GLenum; dstLevel:GLint; dstX:GLint;
              dstY:GLint; dstZ:GLint; srcWidth:GLsizei; srcHeight:GLsizei; srcDepth:GLsizei); stdcall;
// GL_KHR_debug
  glDebugMessageControl: procedure(source:GLenum; _type:GLenum; severity:GLenum; count:GLsizei; ids:PGLuint; enabled:GLboolean); stdcall;
  glDebugMessageInsert: procedure(source:GLenum; _type:GLenum; id:GLuint; severity:GLenum; length:GLsizei; buf:PGLchar); stdcall;
  glDebugMessageCallback: procedure(callback:GLDEBUGPROC; userParam:pointer); stdcall;
  glGetDebugMessageLog: function(count:GLuint; bufSize:GLsizei; sources:PGLenum; types:PGLenum; ids:PGLuint;
             severities:PGLenum; lengths:PGLsizei; messageLog:PGLchar):GLuint; stdcall;
  glPushDebugGroup: procedure(source:GLenum; id:GLuint; length:GLsizei; message:PGLchar); stdcall;
  glPopDebugGroup: procedure; stdcall;
  glObjectLabel: procedure(identifier:GLenum; name:GLuint; length:GLsizei; _label:PGLchar); stdcall;
// GL_KHR_debug                          GL_EXT_debug_label
  glGetObjectLabel: procedure(identifier:GLenum; name:GLuint; bufSize:GLsizei; length:PGLsizei; _label:PGLchar); stdcall;
// GL_KHR_debug
  glObjectPtrLabel: procedure(ptr:pointer; length:GLsizei; _label:PGLchar); stdcall;
  glGetObjectPtrLabel: procedure(ptr:pointer; bufSize:GLsizei; length:PGLsizei; _label:PGLchar); stdcall;
  glGetPointerv: procedure(pname:GLenum; params:Ppointer); stdcall;
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glEnablei: procedure(target:GLenum; index:GLuint); stdcall;
  glDisablei: procedure(target:GLenum; index:GLuint); stdcall;
// GL_OES_draw_buffers_indexed
  glBlendEquationi: procedure(buf:GLuint; mode:GLenum); stdcall;
  glBlendEquationSeparatei: procedure(buf:GLuint; modeRGB:GLenum; modeAlpha:GLenum); stdcall;
  glBlendFunci: procedure(buf:GLuint; src:GLenum; dst:GLenum); stdcall;
  glBlendFuncSeparatei: procedure(buf:GLuint; srcRGB:GLenum; dstRGB:GLenum; srcAlpha:GLenum; dstAlpha:GLenum); stdcall;
  glColorMaski: procedure(index:GLuint; r:GLboolean; g:GLboolean; b:GLboolean; a:GLboolean); stdcall;
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glIsEnabledi: function(target:GLenum; index:GLuint):GLboolean; stdcall;
// GL_OES_draw_elements_base_vertex      GL_EXT_draw_elements_base_vertex
  glDrawElementsBaseVertex: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; basevertex:GLint); stdcall;
  glDrawRangeElementsBaseVertex: procedure(mode:GLenum; start:GLuint; _end:GLuint; count:GLsizei; _type:GLenum;
              indices:pointer; basevertex:GLint); stdcall;
  glDrawElementsInstancedBaseVertex: procedure(mode:GLenum; count:GLsizei; _type:GLenum; indices:pointer; instancecount:GLsizei;
              basevertex:GLint); stdcall;
// GL_OES_geometry_shader                GL_EXT_geometry_shader
  glFramebufferTexture: procedure(target:GLenum; attachment:GLenum; texture:GLuint; level:GLint); stdcall;
// GL_OES_primitive_bounding_box         GL_EXT_primitive_bounding_box
  glPrimitiveBoundingBox: procedure(minX:GLfloat; minY:GLfloat; minZ:GLfloat; minW:GLfloat; maxX:GLfloat;
              maxY:GLfloat; maxZ:GLfloat; maxW:GLfloat); stdcall;
// GL_KHR_robustness                     GL_EXT_robustness
  glGetGraphicsResetStatus: function: GLenum; stdcall;
  glReadnPixels: procedure(x:GLint; y:GLint; width:GLsizei; height:GLsizei; format:GLenum;
              _type:GLenum; bufSize:GLsizei; data:pointer); stdcall;
  glGetnUniformfv: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLfloat); stdcall;
  glGetnUniformiv: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLint); stdcall;
// GL_KHR_robustness
  glGetnUniformuiv: procedure(_program:GLuint; location:GLint; bufSize:GLsizei; params:PGLuint); stdcall;
// GL_OES_sample_shading
  glMinSampleShading: procedure(value:GLfloat); stdcall;
// GL_OES_tessellation_shader            GL_EXT_tessellation_shader
  glPatchParameteri: procedure(pname:GLenum; value:GLint); stdcall;
// GL_OES_texture_border_clamp           GL_EXT_texture_border_clamp
  glTexParameterIiv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glTexParameterIuiv: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glGetTexParameterIiv: procedure(target:GLenum; pname:GLenum; params:PGLint); stdcall;
  glGetTexParameterIuiv: procedure(target:GLenum; pname:GLenum; params:PGLuint); stdcall;
  glSamplerParameterIiv: procedure(sampler:GLuint; pname:GLenum; param:PGLint); stdcall;
  glSamplerParameterIuiv: procedure(sampler:GLuint; pname:GLenum; param:PGLuint); stdcall;
  glGetSamplerParameterIiv: procedure(sampler:GLuint; pname:GLenum; params:PGLint); stdcall;
  glGetSamplerParameterIuiv: procedure(sampler:GLuint; pname:GLenum; params:PGLuint); stdcall;
// GL_OES_texture_buffer                 GL_EXT_texture_buffer
  glTexBuffer: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint); stdcall;
  glTexBufferRange: procedure(target:GLenum; internalformat:GLenum; buffer:GLuint; offset:GLintptr; size:GLsizeiptr); stdcall;
// GL_OES_texture_storage_multisample_2d_array
  glTexStorage3DMultisample: procedure(target:GLenum; samples:GLsizei; internalformat:GLenum; width:GLsizei; height:GLsizei;
              depth:GLsizei; fixedsamplelocations:GLboolean); stdcall;
{$EndIf}

procedure AllCheckGLExtension;
function LoadOpenGLES: Boolean;
procedure FreeOpenGLES;


implementation

uses
  zgl_opengles,
  zgl_opengles_all;

procedure AllCheckGLExtension;
begin
  GL_VERSION_ES_CM_1_0 := gl_IsSupported('GL_VERSION_ES_CM_1_0', oglExtensions);
  GL_ES_VERSION_2_0 := gl_IsSupported('GL_ES_VERSION_2_0', oglExtensions);
  GL_ES_VERSION_3_0 := gl_IsSupported('GL_ES_VERSION_3_0', oglExtensions);
  GL_ES_VERSION_3_1 := gl_IsSupported('GL_ES_VERSION_3_1', oglExtensions);
  GL_ES_VERSION_3_2 := gl_IsSupported('GL_ES_VERSION_3_2', oglExtensions);
  {$IfDef GL_VERSION_ES_CM_1_0}
  GL_OES_compressed_paletted_texture := gl_IsSupported('GL_OES_compressed_paletted_texture', oglExtensions);
  GL_OES_point_size_array := gl_IsSupported('GL_OES_point_size_array', oglExtensions);
  GL_OES_point_sprite := gl_IsSupported('GL_OES_point_sprite', oglExtensions);
  GL_KHR_debug := gl_IsSupported('GL_KHR_debug', oglExtensions);
  GL_OES_EGL_image := gl_IsSupported('GL_OES_EGL_image', oglExtensions);
  GL_OES_EGL_image_external := gl_IsSupported('GL_OES_EGL_image_external', oglExtensions);
  GL_OES_blend_equation_separate := gl_IsSupported('GL_OES_blend_equation_separate', oglExtensions);
//  GL_OES_blend_func_separate := gl_IsSupported('GL_OES_blend_func_separate', oglExtensions);
  GL_OES_blend_subtract := gl_IsSupported('GL_OES_blend_subtract', oglExtensions);
  GL_OES_byte_coordinates := gl_IsSupported('GL_OES_byte_coordinates', oglExtensions);
  GL_OES_compressed_ETC1_RGB8_sub_texture := gl_IsSupported('GL_OES_compressed_ETC1_RGB8_sub_texture', oglExtensions);
  GL_OES_compressed_ETC1_RGB8_texture := gl_IsSupported('GL_OES_compressed_ETC1_RGB8_texture', oglExtensions);
//  GL_OES_depth24 := gl_IsSupported('GL_OES_depth24', oglExtensions);
//  GL_OES_depth32 := gl_IsSupported('GL_OES_depth32', oglExtensions);
  GL_OES_draw_texture := gl_IsSupported('GL_OES_draw_texture', oglExtensions);
  GL_OES_element_index_uint := gl_IsSupported('GL_OES_element_index_uint', oglExtensions);
  GL_OES_extended_matrix_palette := gl_IsSupported('GL_OES_extended_matrix_palette', oglExtensions);
  GL_OES_fbo_render_mipmap := gl_IsSupported('GL_OES_fbo_render_mipmap', oglExtensions);
  GL_OES_fixed_point := gl_IsSupported('GL_OES_fixed_point', oglExtensions);
//  GL_OES_framebuffer_object := gl_IsSupported('GL_OES_framebuffer_object', oglExtensions);
  GL_OES_mapbuffer := gl_IsSupported('GL_OES_mapbuffer', oglExtensions);
  GL_OES_matrix_get := gl_IsSupported('GL_OES_matrix_get', oglExtensions);
  GL_OES_matrix_palette := gl_IsSupported('GL_OES_matrix_palette', oglExtensions);
  GL_OES_packed_depth_stencil := gl_IsSupported('GL_OES_packed_depth_stencil', oglExtensions);
  GL_OES_query_matrix := gl_IsSupported('GL_OES_query_matrix', oglExtensions);
  GL_OES_required_internalformat := gl_IsSupported('GL_OES_required_internalformat', oglExtensions);
  GL_OES_rgb8_rgba8 := gl_IsSupported('GL_OES_rgb8_rgba8', oglExtensions);
  GL_OES_single_precision := gl_IsSupported('GL_OES_single_precision', oglExtensions);
  GL_OES_stencil1 := gl_IsSupported('GL_OES_stencil1', oglExtensions);
  GL_OES_stencil4 := gl_IsSupported('GL_OES_stencil4', oglExtensions);
  GL_OES_stencil8 := gl_IsSupported('GL_OES_stencil8', oglExtensions);
  GL_OES_stencil_wrap := gl_IsSupported('GL_OES_stencil_wrap', oglExtensions);
  GL_OES_surfaceless_context := gl_IsSupported('GL_OES_surfaceless_context', oglExtensions);
  GL_OES_texture_cube_map := gl_IsSupported('GL_OES_texture_cube_map', oglExtensions);
  GL_OES_texture_env_crossbar := gl_IsSupported('GL_OES_texture_env_crossbar', oglExtensions);
  GL_OES_texture_mirrored_repeat := gl_IsSupported('GL_OES_texture_mirrored_repeat', oglExtensions);
  GL_OES_texture_npot := gl_IsSupported('GL_OES_texture_npot', oglExtensions);
  GL_OES_vertex_array_object := gl_IsSupported('GL_OES_vertex_array_object', oglExtensions);
  GL_AMD_compressed_3DC_texture := gl_IsSupported('GL_AMD_compressed_3DC_texture', oglExtensions);
  GL_AMD_compressed_ATC_texture := gl_IsSupported('GL_AMD_compressed_ATC_texture', oglExtensions);
  GL_APPLE_copy_texture_levels := gl_IsSupported('GL_APPLE_copy_texture_levels', oglExtensions);
  GL_APPLE_framebuffer_multisample := gl_IsSupported('GL_APPLE_framebuffer_multisample', oglExtensions);
  GL_APPLE_sync := gl_IsSupported('GL_APPLE_sync', oglExtensions);
  GL_APPLE_texture_2D_limited_npot := gl_IsSupported('GL_APPLE_texture_2D_limited_npot', oglExtensions);
  GL_APPLE_texture_format_BGRA8888 := gl_IsSupported('GL_APPLE_texture_format_BGRA8888', oglExtensions);
  GL_APPLE_texture_max_level := gl_IsSupported('GL_APPLE_texture_max_level', oglExtensions);
  GL_ARM_rgba8 := gl_IsSupported('GL_ARM_rgba8', oglExtensions);
  GL_EXT_blend_minmax := gl_IsSupported('GL_EXT_blend_minmax', oglExtensions);
  GL_EXT_debug_marker := gl_IsSupported('GL_EXT_debug_marker', oglExtensions);
  GL_EXT_discard_framebuffer := gl_IsSupported('GL_EXT_discard_framebuffer', oglExtensions);
  GL_EXT_map_buffer_range := gl_IsSupported('GL_EXT_map_buffer_range', oglExtensions);
  GL_EXT_multi_draw_arrays := gl_IsSupported('GL_EXT_multi_draw_arrays', oglExtensions);
  GL_EXT_multisampled_render_to_texture := gl_IsSupported('GL_EXT_multisampled_render_to_texture', oglExtensions);
  GL_EXT_read_format_bgra := gl_IsSupported('GL_EXT_read_format_bgra', oglExtensions);
  GL_EXT_robustness := gl_IsSupported('GL_EXT_robustness', oglExtensions);
  GL_EXT_sRGB := gl_IsSupported('GL_EXT_sRGB', oglExtensions);
  GL_EXT_texture_compression_dxt1 := gl_IsSupported('GL_EXT_texture_compression_dxt1', oglExtensions);
//  GL_EXT_texture_filter_anisotropic := gl_IsSupported('GL_EXT_texture_filter_anisotropic', oglExtensions);
  GL_EXT_texture_format_BGRA8888 := gl_IsSupported('GL_EXT_texture_format_BGRA8888', oglExtensions);
  GL_EXT_texture_lod_bias := gl_IsSupported('GL_EXT_texture_lod_bias', oglExtensions);
  GL_EXT_texture_storage := gl_IsSupported('GL_EXT_texture_storage', oglExtensions);
  GL_IMG_multisampled_render_to_texture := gl_IsSupported('GL_IMG_multisampled_render_to_texture', oglExtensions);
  GL_IMG_read_format := gl_IsSupported('GL_IMG_read_format', oglExtensions);
//  GL_IMG_texture_compression_pvrtc := gl_IsSupported('GL_IMG_texture_compression_pvrtc', oglExtensions);
  GL_IMG_texture_env_enhanced_fixed_function := gl_IsSupported('GL_IMG_texture_env_enhanced_fixed_function', oglExtensions);
  GL_IMG_user_clip_plane := gl_IsSupported('GL_IMG_user_clip_plane', oglExtensions);
  GL_NV_fence := gl_IsSupported('GL_NV_fence', oglExtensions);
  GL_QCOM_driver_control := gl_IsSupported('GL_QCOM_driver_control', oglExtensions);
  GL_QCOM_extended_get := gl_IsSupported('GL_QCOM_extended_get', oglExtensions);
  GL_QCOM_extended_get2 := gl_IsSupported('GL_QCOM_extended_get2', oglExtensions);
  GL_QCOM_perfmon_global_mode := gl_IsSupported('GL_QCOM_perfmon_global_mode', oglExtensions);
  GL_QCOM_tiled_rendering := gl_IsSupported('GL_QCOM_tiled_rendering', oglExtensions);
  GL_QCOM_writeonly_rendering := gl_IsSupported('GL_QCOM_writeonly_rendering', oglExtensions);
{$EndIf}

{$IFDEF GL_ES_EXT_VERSION_2_0}
  GL_KHR_blend_equation_advanced := gl_IsSupported('GL_KHR_blend_equation_advanced', oglExtensions);
  GL_KHR_blend_equation_advanced_coherent := gl_IsSupported('GL_KHR_blend_equation_advanced_coherent', oglExtensions);
  GL_KHR_context_flush_control := gl_IsSupported('GL_KHR_context_flush_control', oglExtensions);
  GL_KHR_debug := gl_IsSupported('GL_KHR_debug', oglExtensions);
  GL_KHR_no_error := gl_IsSupported('GL_KHR_no_error', oglExtensions);
  GL_KHR_parallel_shader_compile := gl_IsSupported('GL_KHR_parallel_shader_compile', oglExtensions);
  GL_KHR_robust_buffer_access_behavior := gl_IsSupported('GL_KHR_robust_buffer_access_behavior', oglExtensions);
  GL_KHR_robustness := gl_IsSupported('GL_KHR_robustness', oglExtensions);
  GL_KHR_shader_subgroup := gl_IsSupported('GL_KHR_shader_subgroup', oglExtensions);
  GL_KHR_texture_compression_astc_hdr := gl_IsSupported('GL_KHR_texture_compression_astc_hdr', oglExtensions);
  GL_KHR_texture_compression_astc_ldr := gl_IsSupported('GL_KHR_texture_compression_astc_ldr', oglExtensions);
  GL_KHR_texture_compression_astc_sliced_3d := gl_IsSupported('GL_KHR_texture_compression_astc_sliced_3d', oglExtensions);
  GL_OES_EGL_image := gl_IsSupported('GL_OES_EGL_image', oglExtensions);
  GL_OES_EGL_image_external := gl_IsSupported('GL_OES_EGL_image_external', oglExtensions);
  GL_OES_EGL_image_external_essl3 := gl_IsSupported('GL_OES_EGL_image_external_essl3', oglExtensions);
  GL_OES_compressed_ETC1_RGB8_sub_texture := gl_IsSupported('GL_OES_compressed_ETC1_RGB8_sub_texture', oglExtensions);
  GL_OES_compressed_ETC1_RGB8_texture := gl_IsSupported('GL_OES_compressed_ETC1_RGB8_texture', oglExtensions);
  GL_OES_compressed_paletted_texture := gl_IsSupported('GL_OES_compressed_paletted_texture', oglExtensions);
  GL_OES_copy_image := gl_IsSupported('GL_OES_copy_image', oglExtensions);
//  GL_OES_depth24 := gl_IsSupported('GL_OES_depth24', oglExtensions);
//  GL_OES_depth32 := gl_IsSupported('GL_OES_depth32', oglExtensions);
  GL_OES_depth_texture := gl_IsSupported('GL_OES_depth_texture', oglExtensions);
  GL_OES_draw_buffers_indexed := gl_IsSupported('GL_OES_draw_buffers_indexed', oglExtensions);
  GL_OES_draw_elements_base_vertex := gl_IsSupported('GL_OES_draw_elements_base_vertex', oglExtensions);
  GL_OES_element_index_uint := gl_IsSupported('GL_OES_element_index_uint', oglExtensions);
  GL_OES_fbo_render_mipmap := gl_IsSupported('GL_OES_fbo_render_mipmap', oglExtensions);
  GL_OES_fragment_precision_high := gl_IsSupported('GL_OES_fragment_precision_high', oglExtensions);
  GL_OES_geometry_point_size := gl_IsSupported('GL_OES_geometry_point_size', oglExtensions);
  GL_OES_geometry_shader := gl_IsSupported('GL_OES_geometry_shader', oglExtensions);
  GL_OES_get_program_binary := gl_IsSupported('GL_OES_get_program_binary', oglExtensions);
  GL_OES_gpu_shader5 := gl_IsSupported('GL_OES_gpu_shader5', oglExtensions);
  GL_OES_mapbuffer := gl_IsSupported('GL_OES_mapbuffer', oglExtensions);
  GL_OES_packed_depth_stencil := gl_IsSupported('GL_OES_packed_depth_stencil', oglExtensions);
  GL_OES_primitive_bounding_box := gl_IsSupported('GL_OES_primitive_bounding_box', oglExtensions);
  GL_OES_required_internalformat := gl_IsSupported('GL_OES_required_internalformat', oglExtensions);
  GL_OES_rgb8_rgba8 := gl_IsSupported('GL_OES_rgb8_rgba8', oglExtensions);
  GL_OES_sample_shading := gl_IsSupported('GL_OES_sample_shading', oglExtensions);
  GL_OES_sample_variables := gl_IsSupported('GL_OES_sample_variables', oglExtensions);
  GL_OES_shader_image_atomic := gl_IsSupported('GL_OES_shader_image_atomic', oglExtensions);
  GL_OES_shader_io_blocks := gl_IsSupported('GL_OES_shader_io_blocks', oglExtensions);
  GL_OES_shader_multisample_interpolation := gl_IsSupported('GL_OES_shader_multisample_interpolation', oglExtensions);
  GL_OES_standard_derivatives := gl_IsSupported('GL_OES_standard_derivatives', oglExtensions);
  GL_OES_stencil1 := gl_IsSupported('GL_OES_stencil1', oglExtensions);
  GL_OES_stencil4 := gl_IsSupported('GL_OES_stencil4', oglExtensions);
  GL_OES_surfaceless_context := gl_IsSupported('GL_OES_surfaceless_context', oglExtensions);
  GL_OES_tessellation_point_size := gl_IsSupported('GL_OES_tessellation_point_size', oglExtensions);
  GL_OES_tessellation_shader := gl_IsSupported('GL_OES_tessellation_shader', oglExtensions);
  GL_OES_texture_3D := gl_IsSupported('GL_OES_texture_3D', oglExtensions);
  GL_OES_texture_border_clamp := gl_IsSupported('GL_OES_texture_border_clamp', oglExtensions);
  GL_OES_texture_buffer := gl_IsSupported('GL_OES_texture_buffer', oglExtensions);
  GL_OES_texture_compression_astc := gl_IsSupported('GL_OES_texture_compression_astc', oglExtensions);
  GL_OES_texture_cube_map_array := gl_IsSupported('GL_OES_texture_cube_map_array', oglExtensions);
  GL_OES_texture_float := gl_IsSupported('GL_OES_texture_float', oglExtensions);
  GL_OES_texture_float_linear := gl_IsSupported('GL_OES_texture_float_linear', oglExtensions);
  GL_OES_texture_half_float := gl_IsSupported('GL_OES_texture_half_float', oglExtensions);
  GL_OES_texture_half_float_linear := gl_IsSupported('GL_OES_texture_half_float_linear', oglExtensions);
  GL_OES_texture_npot := gl_IsSupported('GL_OES_texture_npot', oglExtensions);
  GL_OES_texture_stencil8 := gl_IsSupported('GL_OES_texture_stencil8', oglExtensions);
  GL_OES_texture_storage_multisample_2d_array := gl_IsSupported('GL_OES_texture_storage_multisample_2d_array', oglExtensions);
  GL_OES_texture_view := gl_IsSupported('GL_OES_texture_view', oglExtensions);
  GL_OES_vertex_array_object := gl_IsSupported('GL_OES_vertex_array_object', oglExtensions);
  GL_OES_vertex_half_float := gl_IsSupported('GL_OES_vertex_half_float', oglExtensions);
  GL_OES_vertex_type_10_10_10_2 := gl_IsSupported('GL_OES_vertex_type_10_10_10_2', oglExtensions);
  GL_OES_viewport_array := gl_IsSupported('GL_OES_viewport_array', oglExtensions);
  GL_AMD_compressed_3DC_texture := gl_IsSupported('GL_AMD_compressed_3DC_texture', oglExtensions);
  GL_AMD_compressed_ATC_texture := gl_IsSupported('GL_AMD_compressed_ATC_texture', oglExtensions);
  GL_AMD_framebuffer_multisample_advanced := gl_IsSupported('GL_AMD_framebuffer_multisample_advanced', oglExtensions);
  GL_AMD_performance_monitor := gl_IsSupported('GL_AMD_performance_monitor', oglExtensions);
  GL_AMD_program_binary_Z400 := gl_IsSupported('GL_AMD_program_binary_Z400', oglExtensions);
  GL_ANDROID_extension_pack_es31a := gl_IsSupported('GL_ANDROID_extension_pack_es31a', oglExtensions);
  GL_ANGLE_depth_texture := gl_IsSupported('GL_ANGLE_depth_texture', oglExtensions);
  GL_ANGLE_framebuffer_blit := gl_IsSupported('GL_ANGLE_framebuffer_blit', oglExtensions);
  GL_ANGLE_framebuffer_multisample := gl_IsSupported('GL_ANGLE_framebuffer_multisample', oglExtensions);
  GL_ANGLE_instanced_arrays := gl_IsSupported('GL_ANGLE_instanced_arrays', oglExtensions);
  GL_ANGLE_pack_reverse_row_order := gl_IsSupported('GL_ANGLE_pack_reverse_row_order', oglExtensions);
  GL_ANGLE_program_binary := gl_IsSupported('GL_ANGLE_program_binary', oglExtensions);
  GL_ANGLE_texture_compression_dxt3 := gl_IsSupported('GL_ANGLE_texture_compression_dxt3', oglExtensions);
  GL_ANGLE_texture_compression_dxt5 := gl_IsSupported('GL_ANGLE_texture_compression_dxt5', oglExtensions);
  GL_ANGLE_texture_usage := gl_IsSupported('GL_ANGLE_texture_usage', oglExtensions);
  GL_ANGLE_translated_shader_source := gl_IsSupported('GL_ANGLE_translated_shader_source', oglExtensions);
  GL_APPLE_clip_distance := gl_IsSupported('GL_APPLE_clip_distance', oglExtensions);
  GL_APPLE_color_buffer_packed_float := gl_IsSupported('GL_APPLE_color_buffer_packed_float', oglExtensions);
  GL_APPLE_copy_texture_levels := gl_IsSupported('GL_APPLE_copy_texture_levels', oglExtensions);
  GL_APPLE_framebuffer_multisample := gl_IsSupported('GL_APPLE_framebuffer_multisample', oglExtensions);
  GL_APPLE_rgb_422 := gl_IsSupported('GL_APPLE_rgb_422', oglExtensions);
  GL_APPLE_sync := gl_IsSupported('GL_APPLE_sync', oglExtensions);
  GL_APPLE_texture_format_BGRA8888 := gl_IsSupported('GL_APPLE_texture_format_BGRA8888', oglExtensions);
  GL_APPLE_texture_max_level := gl_IsSupported('GL_APPLE_texture_max_level', oglExtensions);
  GL_APPLE_texture_packed_float := gl_IsSupported('GL_APPLE_texture_packed_float', oglExtensions);
  GL_ARM_mali_program_binary := gl_IsSupported('GL_ARM_mali_program_binary', oglExtensions);
  GL_ARM_mali_shader_binary := gl_IsSupported('GL_ARM_mali_shader_binary', oglExtensions);
  GL_ARM_rgba8 := gl_IsSupported('GL_ARM_rgba8', oglExtensions);
  GL_ARM_shader_framebuffer_fetch := gl_IsSupported('GL_ARM_shader_framebuffer_fetch', oglExtensions);
  GL_ARM_shader_framebuffer_fetch_depth_stencil := gl_IsSupported('GL_ARM_shader_framebuffer_fetch_depth_stencil', oglExtensions);
  GL_ARM_texture_unnormalized_coordinates := gl_IsSupported('GL_ARM_texture_unnormalized_coordinates', oglExtensions);
  GL_DMP_program_binary := gl_IsSupported('GL_DMP_program_binary', oglExtensions);
  GL_DMP_shader_binary := gl_IsSupported('GL_DMP_shader_binary', oglExtensions);
  GL_EXT_EGL_image_array := gl_IsSupported('GL_EXT_EGL_image_array', oglExtensions);
  GL_EXT_EGL_image_storage := gl_IsSupported('GL_EXT_EGL_image_storage', oglExtensions);
  GL_EXT_EGL_image_storage_compression := gl_IsSupported('GL_EXT_EGL_image_storage_compression', oglExtensions);
  GL_EXT_YUV_target := gl_IsSupported('GL_EXT_YUV_target', oglExtensions);
  GL_EXT_base_instance := gl_IsSupported('GL_EXT_base_instance', oglExtensions);
  GL_EXT_blend_func_extended := gl_IsSupported('GL_EXT_blend_func_extended', oglExtensions);
  GL_EXT_blend_minmax := gl_IsSupported('GL_EXT_blend_minmax', oglExtensions);
  GL_EXT_buffer_storage := gl_IsSupported('GL_EXT_buffer_storage', oglExtensions);
  GL_EXT_clear_texture := gl_IsSupported('GL_EXT_clear_texture', oglExtensions);
  GL_EXT_clip_control := gl_IsSupported('GL_EXT_clip_control', oglExtensions);
  GL_EXT_clip_cull_distance := gl_IsSupported('GL_EXT_clip_cull_distance', oglExtensions);
  GL_EXT_color_buffer_float := gl_IsSupported('GL_EXT_color_buffer_float', oglExtensions);
  GL_EXT_color_buffer_half_float := gl_IsSupported('GL_EXT_color_buffer_half_float', oglExtensions);
  GL_EXT_conservative_depth := gl_IsSupported('GL_EXT_conservative_depth', oglExtensions);
  GL_EXT_copy_image := gl_IsSupported('GL_EXT_copy_image', oglExtensions);
  GL_EXT_debug_label := gl_IsSupported('GL_EXT_debug_label', oglExtensions);
  GL_EXT_debug_marker := gl_IsSupported('GL_EXT_debug_marker', oglExtensions);
  GL_EXT_depth_clamp := gl_IsSupported('GL_EXT_depth_clamp', oglExtensions);
  GL_EXT_discard_framebuffer := gl_IsSupported('GL_EXT_discard_framebuffer', oglExtensions);
  GL_EXT_disjoint_timer_query := gl_IsSupported('GL_EXT_disjoint_timer_query', oglExtensions);
  GL_EXT_draw_buffers := gl_IsSupported('GL_EXT_draw_buffers', oglExtensions);
  GL_EXT_draw_elements_base_vertex := gl_IsSupported('GL_EXT_draw_elements_base_vertex', oglExtensions);
  GL_EXT_draw_instanced := gl_IsSupported('GL_EXT_draw_instanced', oglExtensions);
  GL_EXT_draw_transform_feedback := gl_IsSupported('GL_EXT_draw_transform_feedback', oglExtensions);
  GL_EXT_external_buffer := gl_IsSupported('GL_EXT_external_buffer', oglExtensions);
  GL_EXT_float_blend := gl_IsSupported('v', oglExtensions);
  GL_EXT_fragment_shading_rate := gl_IsSupported('GL_EXT_fragment_shading_rate', oglExtensions);
  GL_EXT_framebuffer_blit_layers := gl_IsSupported('GL_EXT_framebuffer_blit_layers', oglExtensions);
  GL_EXT_geometry_point_size := gl_IsSupported('GL_EXT_geometry_point_size', oglExtensions);
  GL_EXT_geometry_shader := gl_IsSupported('GL_EXT_geometry_shader', oglExtensions);
  GL_EXT_gpu_shader5 := gl_IsSupported('GL_EXT_gpu_shader5', oglExtensions);
  GL_EXT_instanced_arrays := gl_IsSupported('GL_EXT_instanced_arrays', oglExtensions);
  GL_EXT_map_buffer_range := gl_IsSupported('GL_EXT_map_buffer_range', oglExtensions);
  GL_EXT_memory_object := gl_IsSupported('GL_EXT_memory_object', oglExtensions);
  GL_EXT_memory_object_fd := gl_IsSupported('GL_EXT_memory_object_fd', oglExtensions);
  GL_EXT_memory_object_win32 := gl_IsSupported('GL_EXT_memory_object_win32', oglExtensions);
  GL_EXT_multi_draw_arrays := gl_IsSupported('GL_EXT_multi_draw_arrays', oglExtensions);
  GL_EXT_multi_draw_indirect := gl_IsSupported('GL_EXT_multi_draw_indirect', oglExtensions);
  GL_EXT_multisampled_compatibility := gl_IsSupported('GL_EXT_multisampled_compatibility', oglExtensions);
  GL_EXT_multisampled_render_to_texture := gl_IsSupported('GL_EXT_multisampled_render_to_texture', oglExtensions);
  GL_EXT_multisampled_render_to_texture2 := gl_IsSupported('GL_EXT_multisampled_render_to_texture2', oglExtensions);
  GL_EXT_multiview_draw_buffers := gl_IsSupported('GL_EXT_multiview_draw_buffers', oglExtensions);
  GL_EXT_multiview_tessellation_geometry_shader := gl_IsSupported('GL_EXT_multiview_tessellation_geometry_shader', oglExtensions);
  GL_EXT_multiview_texture_multisample := gl_IsSupported('GL_EXT_multiview_texture_multisample', oglExtensions);
  GL_EXT_multiview_timer_query := gl_IsSupported('GL_EXT_multiview_timer_query', oglExtensions);
  GL_EXT_occlusion_query_boolean := gl_IsSupported('GL_EXT_occlusion_query_boolean', oglExtensions);
  GL_EXT_polygon_offset_clamp := gl_IsSupported('GL_EXT_polygon_offset_clamp', oglExtensions);
  GL_EXT_post_depth_coverage := gl_IsSupported('GL_EXT_post_depth_coverage', oglExtensions);
  GL_EXT_primitive_bounding_box := gl_IsSupported('GL_EXT_primitive_bounding_box', oglExtensions);
  GL_EXT_protected_textures := gl_IsSupported('v', oglExtensions);
  GL_EXT_pvrtc_sRGB := gl_IsSupported('GL_EXT_pvrtc_sRGB', oglExtensions);
  GL_EXT_raster_multisample := gl_IsSupported('GL_EXT_raster_multisample', oglExtensions);
  GL_EXT_read_format_bgra := gl_IsSupported('GL_EXT_read_format_bgra', oglExtensions);
  GL_EXT_render_snorm := gl_IsSupported('GL_EXT_render_snorm', oglExtensions);
  GL_EXT_robustness := gl_IsSupported('GL_EXT_robustness', oglExtensions);
  GL_EXT_sRGB := gl_IsSupported('GL_EXT_sRGB', oglExtensions);
  GL_EXT_sRGB_write_control := gl_IsSupported('GL_EXT_sRGB_write_control', oglExtensions);
  GL_EXT_semaphore := gl_IsSupported('GL_EXT_semaphore', oglExtensions);
  GL_EXT_semaphore_fd := gl_IsSupported('GL_EXT_semaphore_fd', oglExtensions);
  GL_EXT_semaphore_win32 := gl_IsSupported('GL_EXT_semaphore_win32', oglExtensions);
  GL_EXT_separate_depth_stencil := gl_IsSupported('GL_EXT_separate_depth_stencil', oglExtensions);
  GL_EXT_separate_shader_objects := gl_IsSupported('GL_EXT_separate_shader_objects', oglExtensions);
  GL_EXT_shader_framebuffer_fetch := gl_IsSupported('GL_EXT_shader_framebuffer_fetch', oglExtensions);
  GL_EXT_shader_framebuffer_fetch_non_coherent := gl_IsSupported('GL_EXT_shader_framebuffer_fetch_non_coherent', oglExtensions);
  GL_EXT_shader_group_vote := gl_IsSupported('GL_EXT_shader_group_vote', oglExtensions);
  GL_EXT_shader_implicit_conversions := gl_IsSupported('GL_EXT_shader_implicit_conversions', oglExtensions);
  GL_EXT_shader_integer_mix := gl_IsSupported('GL_EXT_shader_integer_mix', oglExtensions);
  GL_EXT_shader_io_blocks := gl_IsSupported('GL_EXT_shader_io_blocks', oglExtensions);
  GL_EXT_shader_non_constant_global_initializers := gl_IsSupported('GL_EXT_shader_non_constant_global_initializers', oglExtensions);
  GL_EXT_shader_pixel_local_storage := gl_IsSupported('GL_EXT_shader_pixel_local_storage', oglExtensions);
  GL_EXT_shader_pixel_local_storage2 := gl_IsSupported('GL_EXT_shader_pixel_local_storage2', oglExtensions);
  GL_EXT_shader_samples_identical := gl_IsSupported('GL_EXT_shader_samples_identical', oglExtensions);
  GL_EXT_shader_texture_lod := gl_IsSupported('GL_EXT_shader_texture_lod', oglExtensions);
  GL_EXT_shadow_samplers := gl_IsSupported('GL_EXT_shadow_samplers', oglExtensions);
  GL_EXT_sparse_texture := gl_IsSupported('GL_EXT_sparse_texture', oglExtensions);
  GL_EXT_sparse_texture2 := gl_IsSupported('GL_EXT_sparse_texture2', oglExtensions);
  GL_EXT_tessellation_point_size := gl_IsSupported('GL_EXT_tessellation_point_size', oglExtensions);
  GL_EXT_tessellation_shader := gl_IsSupported('GL_EXT_tessellation_shader', oglExtensions);
  GL_EXT_texture_border_clamp := gl_IsSupported('GL_EXT_texture_border_clamp', oglExtensions);
  GL_EXT_texture_buffer := gl_IsSupported('GL_EXT_texture_buffer', oglExtensions);
  GL_EXT_texture_compression_astc_decode_mode := gl_IsSupported('GL_EXT_texture_compression_astc_decode_mode', oglExtensions);
  GL_EXT_texture_compression_bptc := gl_IsSupported('GL_EXT_texture_compression_bptc', oglExtensions);
  GL_EXT_texture_compression_dxt1 := gl_IsSupported('GL_EXT_texture_compression_dxt1', oglExtensions);
  GL_EXT_texture_compression_rgtc := gl_IsSupported('GL_EXT_texture_compression_rgtc', oglExtensions);
  GL_EXT_texture_compression_s3tc := gl_IsSupported('GL_EXT_texture_compression_s3tc', oglExtensions);
  GL_EXT_texture_compression_s3tc_srgb := gl_IsSupported('GL_EXT_texture_compression_s3tc_srgb', oglExtensions);
  GL_EXT_texture_cube_map_array := gl_IsSupported('GL_EXT_texture_cube_map_array', oglExtensions);
//  GL_EXT_texture_filter_anisotropic := gl_IsSupported('GL_EXT_texture_filter_anisotropic', oglExtensions);
  GL_EXT_texture_filter_minmax := gl_IsSupported('GL_EXT_texture_filter_minmax', oglExtensions);
  GL_EXT_texture_format_BGRA8888 := gl_IsSupported('GL_EXT_texture_format_BGRA8888', oglExtensions);
  GL_EXT_texture_format_sRGB_override := gl_IsSupported('GL_EXT_texture_format_sRGB_override', oglExtensions);
  GL_EXT_texture_mirror_clamp_to_edge := gl_IsSupported('GL_EXT_texture_mirror_clamp_to_edge', oglExtensions);
  GL_EXT_texture_norm16 := gl_IsSupported('GL_EXT_texture_norm16', oglExtensions);
  GL_EXT_texture_query_lod := gl_IsSupported('GL_EXT_texture_query_lod', oglExtensions);
  GL_EXT_texture_rg := gl_IsSupported('GL_EXT_texture_rg', oglExtensions);
  GL_EXT_texture_sRGB_R8 := gl_IsSupported('GL_EXT_texture_sRGB_R8', oglExtensions);
  GL_EXT_texture_sRGB_RG8 := gl_IsSupported('GL_EXT_texture_sRGB_RG8', oglExtensions);
  GL_EXT_texture_sRGB_decode := gl_IsSupported('GL_EXT_texture_sRGB_decode', oglExtensions);
  GL_EXT_texture_shadow_lod := gl_IsSupported('GL_EXT_texture_shadow_lod', oglExtensions);
  GL_EXT_texture_storage := gl_IsSupported('GL_EXT_texture_storage', oglExtensions);
  GL_EXT_texture_storage_compression := gl_IsSupported('GL_EXT_texture_storage_compression', oglExtensions);
  GL_EXT_texture_type_2_10_10_10_REV := gl_IsSupported('GL_EXT_texture_type_2_10_10_10_REV', oglExtensions);
  GL_EXT_texture_view := gl_IsSupported('GL_EXT_texture_view', oglExtensions);
  GL_EXT_unpack_subimage := gl_IsSupported('GL_EXT_unpack_subimage', oglExtensions);
  GL_EXT_win32_keyed_mutex := gl_IsSupported('GL_EXT_win32_keyed_mutex', oglExtensions);
  GL_EXT_window_rectangles := gl_IsSupported('GL_EXT_window_rectangles', oglExtensions);
  GL_FJ_shader_binary_GCCSO := gl_IsSupported('GL_FJ_shader_binary_GCCSO', oglExtensions);
  GL_IMG_bindless_texture := gl_IsSupported('GL_IMG_bindless_texture', oglExtensions);
  GL_IMG_framebuffer_downsample := gl_IsSupported('GL_IMG_framebuffer_downsample', oglExtensions);
  GL_IMG_multisampled_render_to_texture := gl_IsSupported('GL_IMG_multisampled_render_to_texture', oglExtensions);
  GL_IMG_program_binary := gl_IsSupported('GL_IMG_program_binary', oglExtensions);
  GL_IMG_read_format := gl_IsSupported('GL_IMG_read_format', oglExtensions);
  GL_IMG_shader_binary := gl_IsSupported('GL_IMG_shader_binary', oglExtensions);
//  GL_IMG_texture_compression_pvrtc := gl_IsSupported('GL_IMG_texture_compression_pvrtc', oglExtensions);
  GL_IMG_texture_compression_pvrtc2 := gl_IsSupported('GL_IMG_texture_compression_pvrtc2', oglExtensions);
  GL_IMG_texture_filter_cubic := gl_IsSupported('GL_IMG_texture_filter_cubic', oglExtensions);
  GL_INTEL_blackhole_render := gl_IsSupported('GL_INTEL_blackhole_render', oglExtensions);
  GL_INTEL_conservative_rasterization := gl_IsSupported('GL_INTEL_conservative_rasterization', oglExtensions);
  GL_INTEL_framebuffer_CMAA := gl_IsSupported('GL_INTEL_framebuffer_CMAA', oglExtensions);
  GL_INTEL_performance_query := gl_IsSupported('GL_INTEL_performance_query', oglExtensions);
  GL_MESA_bgra := gl_IsSupported('GL_MESA_bgra', oglExtensions);
  GL_MESA_framebuffer_flip_x := gl_IsSupported('GL_MESA_framebuffer_flip_x', oglExtensions);
  GL_MESA_framebuffer_flip_y := gl_IsSupported('GL_MESA_framebuffer_flip_y', oglExtensions);
  GL_MESA_framebuffer_swap_xy := gl_IsSupported('GL_MESA_framebuffer_swap_xy', oglExtensions);
  GL_MESA_program_binary_formats := gl_IsSupported('GL_MESA_program_binary_formats', oglExtensions);
  GL_MESA_shader_integer_functions := gl_IsSupported('GL_MESA_shader_integer_functions', oglExtensions);
  GL_NVX_blend_equation_advanced_multi_draw_buffers := gl_IsSupported('GL_NVX_blend_equation_advanced_multi_draw_buffers', oglExtensions);
  GL_NV_bindless_texture := gl_IsSupported('GL_NV_bindless_texture', oglExtensions);
  GL_NV_blend_equation_advanced := gl_IsSupported('GL_NV_blend_equation_advanced', oglExtensions);
  GL_NV_blend_equation_advanced_coherent := gl_IsSupported('GL_NV_blend_equation_advanced_coherent', oglExtensions);
  GL_NV_blend_minmax_factor := gl_IsSupported('GL_NV_blend_minmax_factor', oglExtensions);
  GL_NV_clip_space_w_scaling := gl_IsSupported('GL_NV_clip_space_w_scaling', oglExtensions);
  GL_NV_compute_shader_derivatives := gl_IsSupported('GL_NV_compute_shader_derivatives', oglExtensions);
  GL_NV_conditional_render := gl_IsSupported('GL_NV_conditional_render', oglExtensions);
  GL_NV_conservative_raster := gl_IsSupported('GL_NV_conservative_raster', oglExtensions);
  GL_NV_conservative_raster_pre_snap := gl_IsSupported('GL_NV_conservative_raster_pre_snap', oglExtensions);
  GL_NV_conservative_raster_pre_snap_triangles := gl_IsSupported('GL_NV_conservative_raster_pre_snap_triangles', oglExtensions);
  GL_NV_copy_buffer := gl_IsSupported('GL_NV_copy_buffer', oglExtensions);
  GL_NV_coverage_sample := gl_IsSupported('GL_NV_coverage_sample', oglExtensions);
  GL_NV_depth_nonlinear := gl_IsSupported('GL_NV_depth_nonlinear', oglExtensions);
  GL_NV_draw_buffers := gl_IsSupported('GL_NV_draw_buffers', oglExtensions);
  GL_NV_draw_instanced := gl_IsSupported('GL_NV_draw_instanced', oglExtensions);
  GL_NV_draw_vulkan_image := gl_IsSupported('GL_NV_draw_vulkan_image', oglExtensions);
  GL_NV_explicit_attrib_location := gl_IsSupported('GL_NV_explicit_attrib_location', oglExtensions);
  GL_NV_fbo_color_attachments := gl_IsSupported('GL_NV_fbo_color_attachments', oglExtensions);
  GL_NV_fence := gl_IsSupported('GL_NV_fence', oglExtensions);
  GL_NV_fill_rectangle := gl_IsSupported('GL_NV_fill_rectangle', oglExtensions);
  GL_NV_fragment_coverage_to_color := gl_IsSupported('GL_NV_fragment_coverage_to_color', oglExtensions);
  GL_NV_fragment_shader_barycentric := gl_IsSupported('GL_NV_fragment_shader_barycentric', oglExtensions);
  GL_NV_fragment_shader_interlock := gl_IsSupported('GL_NV_fragment_shader_interlock', oglExtensions);
  GL_NV_framebuffer_blit := gl_IsSupported('GL_NV_framebuffer_blit', oglExtensions);
  GL_NV_framebuffer_mixed_samples := gl_IsSupported('GL_NV_framebuffer_mixed_samples', oglExtensions);
  GL_NV_framebuffer_multisample := gl_IsSupported('GL_NV_framebuffer_multisample', oglExtensions);
  GL_NV_generate_mipmap_sRGB := gl_IsSupported('GL_NV_generate_mipmap_sRGB', oglExtensions);
  GL_NV_geometry_shader_passthrough := gl_IsSupported('GL_NV_geometry_shader_passthrough', oglExtensions);
  GL_NV_gpu_shader5 := gl_IsSupported('GL_NV_gpu_shader5', oglExtensions);
  GL_NV_image_formats := gl_IsSupported('GL_NV_image_formats', oglExtensions);
  GL_NV_instanced_arrays := gl_IsSupported('GL_NV_instanced_arrays', oglExtensions);
  GL_NV_internalformat_sample_query := gl_IsSupported('GL_NV_internalformat_sample_query', oglExtensions);
  GL_NV_memory_attachment := gl_IsSupported('GL_NV_memory_attachment', oglExtensions);
  GL_NV_memory_object_sparse := gl_IsSupported('GL_NV_memory_object_sparse', oglExtensions);
  GL_NV_mesh_shader := gl_IsSupported('GL_NV_mesh_shader', oglExtensions);
  GL_NV_non_square_matrices := gl_IsSupported('GL_NV_non_square_matrices', oglExtensions);
  GL_NV_pack_subimage := gl_IsSupported('GL_NV_pack_subimage', oglExtensions);
  GL_NV_path_rendering := gl_IsSupported('GL_NV_path_rendering', oglExtensions);
  GL_NV_path_rendering_shared_edge := gl_IsSupported('GL_NV_path_rendering_shared_edge', oglExtensions);
  GL_NV_pixel_buffer_object := gl_IsSupported('GL_NV_pixel_buffer_object', oglExtensions);
  GL_NV_polygon_mode := gl_IsSupported('GL_NV_polygon_mode', oglExtensions);
  GL_NV_primitive_shading_rate := gl_IsSupported('GL_NV_primitive_shading_rate', oglExtensions);
  GL_NV_read_buffer := gl_IsSupported('GL_NV_read_buffer', oglExtensions);
  GL_NV_read_buffer_front := gl_IsSupported('GL_NV_read_buffer_front', oglExtensions);
  GL_NV_read_depth := gl_IsSupported('GL_NV_read_depth', oglExtensions);
  GL_NV_read_depth_stencil := gl_IsSupported('GL_NV_read_depth_stencil', oglExtensions);
  GL_NV_read_stencil := gl_IsSupported('GL_NV_read_stencil', oglExtensions);
  GL_NV_representative_fragment_test := gl_IsSupported('GL_NV_representative_fragment_test', oglExtensions);
  GL_NV_sRGB_formats := gl_IsSupported('GL_NV_sRGB_formats', oglExtensions);
  GL_NV_sample_locations := gl_IsSupported('GL_NV_sample_locations', oglExtensions);
  GL_NV_sample_mask_override_coverage := gl_IsSupported('GL_NV_sample_mask_override_coverage', oglExtensions);
  GL_NV_scissor_exclusive := gl_IsSupported('GL_NV_scissor_exclusive', oglExtensions);
  GL_NV_shader_atomic_fp16_vector := gl_IsSupported('GL_NV_shader_atomic_fp16_vector', oglExtensions);
  GL_NV_shader_noperspective_interpolation := gl_IsSupported('GL_NV_shader_noperspective_interpolation', oglExtensions);
  GL_NV_shader_subgroup_partitioned := gl_IsSupported('GL_NV_shader_subgroup_partitioned', oglExtensions);
  GL_NV_shader_texture_footprint := gl_IsSupported('GL_NV_shader_texture_footprint', oglExtensions);
  GL_NV_shading_rate_image := gl_IsSupported('GL_NV_shading_rate_image', oglExtensions);
  GL_NV_shadow_samplers_array := gl_IsSupported('GL_NV_shadow_samplers_array', oglExtensions);
  GL_NV_shadow_samplers_cube := gl_IsSupported('GL_NV_shadow_samplers_cube', oglExtensions);
  GL_NV_stereo_view_rendering := gl_IsSupported('GL_NV_stereo_view_rendering', oglExtensions);
  GL_NV_texture_border_clamp := gl_IsSupported('GL_NV_texture_border_clamp', oglExtensions);
  GL_NV_texture_compression_s3tc_update := gl_IsSupported('GL_NV_texture_compression_s3tc_update', oglExtensions);
  GL_NV_texture_npot_2D_mipmap := gl_IsSupported('GL_NV_texture_npot_2D_mipmap', oglExtensions);
  GL_NV_timeline_semaphore := gl_IsSupported('GL_NV_timeline_semaphore', oglExtensions);
  GL_NV_viewport_array := gl_IsSupported('GL_NV_viewport_array', oglExtensions);
  GL_NV_viewport_array2 := gl_IsSupported('GL_NV_viewport_array2', oglExtensions);
  GL_NV_viewport_swizzle := gl_IsSupported('GL_NV_viewport_swizzle', oglExtensions);
  GL_OVR_multiview := gl_IsSupported('GL_OVR_multiview', oglExtensions);
  GL_OVR_multiview2 := gl_IsSupported('GL_OVR_multiview2', oglExtensions);
  GL_OVR_multiview_multisampled_render_to_texture := gl_IsSupported('GL_OVR_multiview_multisampled_render_to_texture', oglExtensions);
  GL_QCOM_YUV_texture_gather := gl_IsSupported('GL_QCOM_YUV_texture_gather', oglExtensions);
  GL_QCOM_alpha_test := gl_IsSupported('GL_QCOM_alpha_test', oglExtensions);
  GL_QCOM_binning_control := gl_IsSupported('GL_QCOM_binning_control', oglExtensions);
  GL_QCOM_driver_control := gl_IsSupported('GL_QCOM_driver_control', oglExtensions);
  GL_QCOM_extended_get := gl_IsSupported('GL_QCOM_extended_get', oglExtensions);
  GL_QCOM_extended_get2 := gl_IsSupported('GL_QCOM_extended_get2', oglExtensions);
  GL_QCOM_frame_extrapolation := gl_IsSupported('GL_QCOM_frame_extrapolation', oglExtensions);
  GL_QCOM_framebuffer_foveated := gl_IsSupported('GL_QCOM_framebuffer_foveated', oglExtensions);
  GL_QCOM_motion_estimation := gl_IsSupported('GL_QCOM_motion_estimation', oglExtensions);
  GL_QCOM_perfmon_global_mode := gl_IsSupported('GL_QCOM_perfmon_global_mode', oglExtensions);
  GL_QCOM_render_shared_exponent := gl_IsSupported('GL_QCOM_render_shared_exponent', oglExtensions);
  GL_QCOM_shader_framebuffer_fetch_noncoherent := gl_IsSupported('GL_QCOM_shader_framebuffer_fetch_noncoherent', oglExtensions);
  GL_QCOM_shader_framebuffer_fetch_rate := gl_IsSupported('GL_QCOM_shader_framebuffer_fetch_rate', oglExtensions);
  GL_QCOM_shading_rate := gl_IsSupported('GL_QCOM_shading_rate', oglExtensions);
  GL_QCOM_texture_foveated := gl_IsSupported('GL_QCOM_texture_foveated', oglExtensions);
  GL_QCOM_texture_foveated2 := gl_IsSupported('GL_QCOM_texture_foveated2', oglExtensions);
  GL_QCOM_texture_foveated_subsampled_layout := gl_IsSupported('GL_QCOM_texture_foveated_subsampled_layout', oglExtensions);
  GL_QCOM_tiled_rendering := gl_IsSupported('GL_QCOM_tiled_rendering', oglExtensions);
  GL_QCOM_writeonly_rendering := gl_IsSupported('GL_QCOM_writeonly_rendering', oglExtensions);
  GL_VIV_shader_binary := gl_IsSupported('GL_VIV_shader_binary', oglExtensions);
{$EndIf}
end;

function LoadOpenGLES: Boolean;
{$IfDef LINUX}
{$IfDef GL_ES_VERSION_3_0}
var
  i, j: Integer;
{$EndIf}{$EndIf}
begin
  Result := True;

  {$IfDef LINUX}
  oglExtensions := '';
  {$IfDef GL_ES_VERSION_3_0}
 (* if use_glMajorVer >= 3 then          // этот код выдаёт очень "весёлое" зависание при использованиее GLES...
  begin
    if not Assigned(glGetStringi) then
      glGetStringi := gl_GetProc('glGetStringi');
    if Assigned(glGetStringi) then
    begin
      glGetIntegerv(GL_NUM_EXTENSIONS, @j);
      for i := 0 to j - 1 do
        oglExtensions := oglExtensions + PAnsiChar(glGetStringi(GL_EXTENSIONS, i)) + #32;
    end;
  end; *)

  if oglExtensions = '' then
  {$EndIf}
    oglExtensions := glGetString(GL_EXTENSIONS);
  {$EndIf}
  AllCheckGLExtension;
{$IfDef GL_VERSION_ES_CM_1_0}
// min GLES function - glAlphaFunc := dlsym(glesLibrary, 'glAlphaFunc');
// min GLES function - glClearColor := dlsym(glesLibrary, 'glClearColor');
// min GLES function - glClearDepthf := dlsym(glesLibrary, 'glClearDepthf');
  glClipPlanef := dlsym(glesLibrary, 'glClipPlanef');
// min GLES function - glColor4f := dlsym(glesLibrary, 'glColor4f');
  glDepthRangef := dlsym(glesLibrary, 'glDepthRangef');
  glFogf := dlsym(glesLibrary, 'glFogf');
  glFogfv := dlsym(glesLibrary, 'glFogfv');
  glFrustumf := dlsym(glesLibrary, 'glFrustumf');
  glGetClipPlanef := dlsym(glesLibrary, 'glGetClipPlanef');
// min GLES function - glGetFloatv := dlsym(glesLibrary, 'glGetFloatv');
  glGetLightfv := dlsym(glesLibrary, 'glGetLightfv');
  glGetMaterialfv := dlsym(glesLibrary, 'glGetMaterialfv');
  glGetTexEnvfv := dlsym(glesLibrary, 'glGetTexEnvfv');
  glGetTexParameterfv := dlsym(glesLibrary, 'glGetTexParameterfv');
  glLightModelf := dlsym(glesLibrary, 'glLightModelf');
  glLightModelfv := dlsym(glesLibrary, 'glLightModelfv');
  glLightf := dlsym(glesLibrary, 'glLightf');
  glLightfv := dlsym(glesLibrary, 'glLightfv');
  glLineWidth := dlsym(glesLibrary, 'glLineWidth');
// min GLES function - glLoadMatrixf := dlsym(glesLibrary, 'glLoadMatrixf');
  glMaterialf := dlsym(glesLibrary, 'glMaterialf');
  glMaterialfv := dlsym(glesLibrary, 'glMaterialfv');
  glMultMatrixf := dlsym(glesLibrary, 'glMultMatrixf');
  glMultiTexCoord4f := dlsym(glesLibrary, 'glMultiTexCoord4f');
  glNormal3f := dlsym(glesLibrary, 'glNormal3f');
// min GLES function - glOrthof := dlsym(glesLibrary, 'glOrthof');
  glPointParameterf := dlsym(glesLibrary, 'glPointParameterf');
  glPointParameterfv := dlsym(glesLibrary, 'glPointParameterfv');
  glPointSize := dlsym(glesLibrary, 'glPointSize');
  glPolygonOffset := dlsym(glesLibrary, 'glPolygonOffset');
// min GLES function - glRotatef := dlsym(glesLibrary, 'glRotatef');
// min GLES function - glScalef := dlsym(glesLibrary, 'glScalef');
  glTexEnvf := dlsym(glesLibrary, 'glTexEnvf');
  glTexEnvfv := dlsym(glesLibrary, 'glTexEnvfv');
// min GLES function - glTexParameterf := dlsym(glesLibrary, 'glTexParameterf');
  glTexParameterfv := dlsym(glesLibrary, 'glTexParameterfv');
// min GLES function - glTranslatef := dlsym(glesLibrary, 'glTranslatef');
  glActiveTexture := dlsym(glesLibrary, 'glActiveTexture');
  glAlphaFuncx := dlsym(glesLibrary, 'glAlphaFuncx');
  glBindBuffer := dlsym(glesLibrary, 'glBindBuffer');
// min GLES function - glBindTexture := dlsym(glesLibrary, 'glBindTexture');
// min GLES function - glBlendFunc := dlsym(glesLibrary, 'glBlendFunc');
  glBufferData := dlsym(glesLibrary, 'glBufferData');
  glBufferSubData := dlsym(glesLibrary, 'glBufferSubData');
// min GLES function - glClear := dlsym(glesLibrary, 'glClear');
  glClearColorx := dlsym(glesLibrary, 'glClearColorx');
  glClearDepthx := dlsym(glesLibrary, 'glClearDepthx');
  glClearStencil := dlsym(glesLibrary, 'glClearStencil');
  glClientActiveTexture := dlsym(glesLibrary, 'glClientActiveTexture');
  glClipPlanex := dlsym(glesLibrary, 'glClipPlanex');
  glColor4ub := dlsym(glesLibrary, 'glColor4ub');
  glColor4x := dlsym(glesLibrary, 'glColor4x');
// min GLES function - glColorMask := dlsym(glesLibrary, 'glColorMask');
// min GLES function - glColorPointer := dlsym(glesLibrary, 'glColorPointer');
// min GLES function - glCompressedTexImage2D := dlsym(glesLibrary, 'glCompressedTexImage2D');
// min GLES function - glCompressedTexSubImage2D := dlsym(glesLibrary, 'glCompressedTexSubImage2D');
  glCopyTexImage2D := dlsym(glesLibrary, 'glCopyTexImage2D');
// min GLES function - glCopyTexSubImage2D := dlsym(glesLibrary, 'glCopyTexSubImage2D');
  glCullFace := dlsym(glesLibrary, 'glCullFace');
  glDeleteBuffers := dlsym(glesLibrary, 'glDeleteBuffers');
// min GLES function - glDeleteTextures := dlsym(glesLibrary, 'glDeleteTextures');
// min GLES function - glDepthFunc := dlsym(glesLibrary, 'glDepthFunc');
// min GLES function - glDepthMask := dlsym(glesLibrary, 'glDepthMask');
  glDepthRangex := dlsym(glesLibrary, 'glDepthRangex');
// min GLES function - glDisable := dlsym(glesLibrary, 'glDisable');
// min GLES function - glDisableClientState := dlsym(glesLibrary, 'glDisableClientState');
// min GLES function - glDrawArrays := dlsym(glesLibrary, 'glDrawArrays');
// min GLES function - glDrawElements := dlsym(glesLibrary, 'glDrawElements');
// min GLES function - glEnable := dlsym(glesLibrary, 'glEnable');
// min GLES function - glEnableClientState := dlsym(glesLibrary, 'glEnableClientState');
  glFinish := dlsym(glesLibrary, 'glFinish');
  glFlush := dlsym(glesLibrary, 'glFlush');
  glFogx := dlsym(glesLibrary, 'glFogx');
  glFogxv := dlsym(glesLibrary, 'glFogxv');
  glFrontFace := dlsym(glesLibrary, 'glFrontFace');
  glFrustumx := dlsym(glesLibrary, 'glFrustumx');
  glGetBooleanv := dlsym(glesLibrary, 'glGetBooleanv');
  glGetBufferParameteriv := dlsym(glesLibrary, 'glGetBufferParameteriv');
  glGetClipPlanex := dlsym(glesLibrary, 'glGetClipPlanex');
  glGenBuffers := dlsym(glesLibrary, 'glGenBuffers');
// min GLES function - glGenTextures := dlsym(glesLibrary, 'glGenTextures');
  glGetError := dlsym(glesLibrary, 'glGetError');
  glGetFixedv := dlsym(glesLibrary, 'glGetFixedv');
// min GLES function - glGetIntegerv := dlsym(glesLibrary, 'glGetIntegerv');
  glGetLightxv := dlsym(glesLibrary, 'glGetLightxv');
  glGetMaterialxv := dlsym(glesLibrary, 'glGetMaterialxv');
  glGetPointerv := dlsym(glesLibrary, 'glGetPointerv');
// min GLES function - glGetString := dlsym(glesLibrary, 'glGetString');
  glGetTexEnviv := dlsym(glesLibrary, 'glGetTexEnviv');
  glGetTexEnvxv := dlsym(glesLibrary, 'glGetTexEnvxv');
  glGetTexParameteriv := dlsym(glesLibrary, 'glGetTexParameteriv');
  glGetTexParameterxv := dlsym(glesLibrary, 'glGetTexParameterxv');
// min GLES function - glHint := dlsym(glesLibrary, 'glHint');
  glIsBuffer := dlsym(glesLibrary, 'glIsBuffer');
  glIsEnabled := dlsym(glesLibrary, 'glIsEnabled');
  glIsTexture := dlsym(glesLibrary, 'glIsTexture');
  glLightModelx := dlsym(glesLibrary, 'glLightModelx');
  glLightModelxv := dlsym(glesLibrary, 'glLightModelxv');
  glLightx := dlsym(glesLibrary, 'glLightx');
  glLightxv := dlsym(glesLibrary, 'glLightxv');
  glLineWidthx := dlsym(glesLibrary, 'glLineWidthx');
// min GLES function - glLoadIdentity := dlsym(glesLibrary, 'glLoadIdentity');
  glLoadMatrixx := dlsym(glesLibrary, 'glLoadMatrixx');
  glLogicOp := dlsym(glesLibrary, 'glLogicOp');
  glMaterialx := dlsym(glesLibrary, 'glMaterialx');
  glMaterialxv := dlsym(glesLibrary, 'glMaterialxv');
// min GLES function - glMatrixMode := dlsym(glesLibrary, 'glMatrixMode');
  glMultMatrixx := dlsym(glesLibrary, 'glMultMatrixx');
  glMultiTexCoord4x := dlsym(glesLibrary, 'glMultiTexCoord4x');
  glNormal3x := dlsym(glesLibrary, 'glNormal3x');
  glNormalPointer := dlsym(glesLibrary, 'glNormalPointer');
  glOrthox := dlsym(glesLibrary, 'glOrthox');
// min GLES function - glPixelStorei := dlsym(glesLibrary, 'glPixelStorei');
  glPointParameterx := dlsym(glesLibrary, 'glPointParameterx');
  glPointParameterxv := dlsym(glesLibrary, 'glPointParameterxv');
  glPointSizex := dlsym(glesLibrary, 'glPointSizex');
  glPolygonOffsetx := dlsym(glesLibrary, 'glPolygonOffsetx');
// min GLES function - glPopMatrix := dlsym(glesLibrary, 'glPopMatrix');
// min GLES function - glPushMatrix := dlsym(glesLibrary, 'glPushMatrix');
// min GLES function - glReadPixels := dlsym(glesLibrary, 'glReadPixels');
  glRotatex := dlsym(glesLibrary, 'glRotatex');
  glSampleCoverage := dlsym(glesLibrary, 'glSampleCoverage');
  glSampleCoveragex := dlsym(glesLibrary, 'glSampleCoveragex');
  glScalex := dlsym(glesLibrary, 'glScalex');
// min GLES function - glScissor := dlsym(glesLibrary, 'glScissor');
// min GLES function - glShadeModel := dlsym(glesLibrary, 'glShadeModel');
  glStencilFunc := dlsym(glesLibrary, 'glStencilFunc');
  glStencilMask := dlsym(glesLibrary, 'glStencilMask');
  glStencilOp := dlsym(glesLibrary, 'glStencilOp');
// min GLES function - glTexCoordPointer := dlsym(glesLibrary, 'glTexCoordPointer');
// min GLES function - glTexEnvi := dlsym(glesLibrary, 'glTexEnvi');
// min GLES function - glTexEnvx := dlsym(glesLibrary, 'glTexEnvx');
// min GLES function - glTexEnviv := dlsym(glesLibrary, 'glTexEnviv');
// min GLES function - glTexEnvxv := dlsym(glesLibrary, 'glTexEnvxv');
// min GLES function - glTexImage2D := dlsym(glesLibrary, 'glTexImage2D');
// min GLES function - glTexParameteri := dlsym(glesLibrary, 'glTexParameteri');
// min GLES function - glTexParameterx := dlsym(glesLibrary, 'glTexParameterx');
// min GLES function - glTexParameteriv := dlsym(glesLibrary, 'glTexParameteriv');
// min GLES function - glTexParameterxv := dlsym(glesLibrary, 'glTexParameterxv');
// min GLES function - glTexSubImage2D := dlsym(glesLibrary, 'glTexSubImage2D');
  glTranslatex := dlsym(glesLibrary, 'glTranslatex');
// min GLES function - glVertexPointer := dlsym(glesLibrary, 'glVertexPointer');
// min GLES function - glViewport := dlsym(glesLibrary, 'glViewport');

  {$IfDef GL_OES_point_size_array}
  glPointSizePointerOES := dlsym(glesLibrary, 'glPointSizePointerOES');
  {$EndIf}

  {$IfDef GL_OES_blend_equation_separate}
  glBlendEquationSeparateOES := dlsym(glesLibrary, 'glBlendEquationSeparateOES');
  {$EndIf}

  {$IfDef GL_OES_blend_func_separate}
  // min GLES function - glBlendFuncSeparateOES := dlsym(glesLibrary, 'glBlendFuncSeparateOES');
  {$EndIf}

  {$IfDef GL_OES_blend_subtract}
  glBlendEquationOES := dlsym(glesLibrary, 'glBlendEquationOES');
  {$EndIf}

  {$IfDef GL_OES_draw_texture}
  glDrawTexsOES := dlsym(glesLibrary, 'glDrawTexsOES');
  glDrawTexiOES := dlsym(glesLibrary, 'glDrawTexiOES');
  glDrawTexxOES := dlsym(glesLibrary, 'glDrawTexxOES');
  glDrawTexsvOES := dlsym(glesLibrary, 'glDrawTexsvOES');
  glDrawTexivOES := dlsym(glesLibrary, 'glDrawTexivOES');
  glDrawTexxvOES := dlsym(glesLibrary, 'glDrawTexxvOES');
  glDrawTexfOES := dlsym(glesLibrary, 'glDrawTexfOES');
  glDrawTexfvOES := dlsym(glesLibrary, 'glDrawTexfvOES');
  {$EndIf}

  {$IfDef GL_OES_fixed_point}
  glAlphaFuncxOES := dlsym(glesLibrary, 'glAlphaFuncxOES');
  glClearColorxOES := dlsym(glesLibrary, 'glClearColorxOES');
  glClearDepthxOES := dlsym(glesLibrary, 'glClearDepthxOES');
  glClipPlanexOES := dlsym(glesLibrary, 'glClipPlanexOES');
  glColor4xOES := dlsym(glesLibrary, 'glColor4xOES');
  glDepthRangexOES := dlsym(glesLibrary, 'glDepthRangexOES');
  glFogxOES := dlsym(glesLibrary, 'glFogxOES');
  glFogxvOES := dlsym(glesLibrary, 'glFogxvOES');
  glFrustumxOES := dlsym(glesLibrary, 'glFrustumxOES');
  glGetClipPlanexOES := dlsym(glesLibrary, 'glGetClipPlanexOES');
  glGetFixedvOES := dlsym(glesLibrary, 'glGetFixedvOES');
  glGetTexEnvxvOES := dlsym(glesLibrary, 'glGetTexEnvxvOES');
  glGetTexParameterxvOES := dlsym(glesLibrary, 'glGetTexParameterxvOES');
  glLightModelxOES := dlsym(glesLibrary, 'glLightModelxOES');
  glLightModelxvOES := dlsym(glesLibrary, 'glLightModelxvOES');
  glLightxOES := dlsym(glesLibrary, 'glLightxOES');
  glLightxvOES := dlsym(glesLibrary, 'glLightxvOES');
  glLineWidthxOES := dlsym(glesLibrary, 'glLineWidthxOES');
  glLoadMatrixxOES := dlsym(glesLibrary, 'glLoadMatrixxOES');
  glMaterialxOES := dlsym(glesLibrary, 'glMaterialxOES');
  glMaterialxvOES := dlsym(glesLibrary, 'glMaterialxvOES');
  glMultMatrixxOES := dlsym(glesLibrary, 'glMultMatrixxOES');
  glMultiTexCoord4xOES := dlsym(glesLibrary, 'glMultiTexCoord4xOES');
  glNormal3xOES := dlsym(glesLibrary, 'glNormal3xOES');
  glOrthoxOES := dlsym(glesLibrary, 'glOrthoxOES');
  glPointParameterxvOES := dlsym(glesLibrary, 'glPointParameterxvOES');
  glPointSizexOES := dlsym(glesLibrary, 'glPointSizexOES');
  glPolygonOffsetxOES := dlsym(glesLibrary, 'glPolygonOffsetxOES');
  glRotatexOES := dlsym(glesLibrary, 'glRotatexOES');
  glScalexOES := dlsym(glesLibrary, 'glScalexOES');
  glTexEnvxOES := dlsym(glesLibrary, 'glTexEnvxOES');
  glTexEnvxvOES := dlsym(glesLibrary, 'glTexEnvxvOES');
  glTexParameterxOES := dlsym(glesLibrary, 'glTexParameterxOES');
  glTexParameterxvOES := dlsym(glesLibrary, 'glTexParameterxvOES');
  glTranslatexOES := dlsym(glesLibrary, 'glTranslatexOES');
  glGetLightxvOES := dlsym(glesLibrary, 'glGetLightxvOES');
  glGetMaterialxvOES := dlsym(glesLibrary, 'glGetMaterialxvOES');
  glPointParameterxOES := dlsym(glesLibrary, 'glPointParameterxOES');
  glSampleCoveragexOES := dlsym(glesLibrary, 'glSampleCoveragexOES');
  glGetTexGenxvOES := dlsym(glesLibrary, 'glGetTexGenxvOES');
  glTexGenxOES := dlsym(glesLibrary, 'glTexGenxOES');
  glTexGenxvOES := dlsym(glesLibrary, 'glTexGenxvOES');
  {$EndIf}

  {$IfDef GL_OES_framebuffer_object}
// min GLES function - glIsRenderbufferOES := dlsym(glesLibrary, 'glIsRenderbufferOES');
// min GLES function - glBindRenderbufferOES := dlsym(glesLibrary, 'glBindRenderbufferOES');
// min GLES function - glDeleteRenderbuffersOES := dlsym(glesLibrary, 'glDeleteRenderbuffersOES');
// min GLES function - glGenRenderbuffersOES := dlsym(glesLibrary, 'glGenRenderbuffersOES');
// min GLES function - glRenderbufferStorageOES := dlsym(glesLibrary, 'glRenderbufferStorageOES');
// min GLES function - glGetRenderbufferParameterivOES := dlsym(glesLibrary, 'glGetRenderbufferParameterivOES');
// min GLES function - glIsFramebufferOES := dlsym(glesLibrary, 'glIsFramebufferOES');
// min GLES function - glBindFramebufferOES := dlsym(glesLibrary, 'glBindFramebufferOES');
// min GLES function - glDeleteFramebuffersOES := dlsym(glesLibrary, 'glDeleteFramebuffersOES');
// min GLES function - glGenFramebuffersOES := dlsym(glesLibrary, 'glGenFramebuffersOES');
// min GLES function - glCheckFramebufferStatusOES := dlsym(glesLibrary, 'glCheckFramebufferStatusOES');
// min GLES function - glFramebufferRenderbufferOES := dlsym(glesLibrary, 'glFramebufferRenderbufferOES');
// min GLES function - glFramebufferTexture2DOES := dlsym(glesLibrary, 'glFramebufferTexture2DOES');
// min GLES function - glGetFramebufferAttachmentParameterivOES := dlsym(glesLibrary, 'glGetFramebufferAttachmentParameterivOES');
// min GLES function - glGenerateMipmapOES := dlsym(glesLibrary, 'glGenerateMipmapOES');
  {$EndIf}

  {$IfDef GL_OES_matrix_palette}
  glCurrentPaletteMatrixOES := dlsym(glesLibrary, 'glCurrentPaletteMatrixOES');
  glLoadPaletteFromModelViewMatrixOES := dlsym(glesLibrary, 'glLoadPaletteFromModelViewMatrixOES');
  glMatrixIndexPointerOES := dlsym(glesLibrary, 'glMatrixIndexPointerOES');
  glWeightPointerOES := dlsym(glesLibrary, 'glWeightPointerOES');
  {$EndIf}

  {$IfDef GL_OES_query_matrix}
  glQueryMatrixxOES := dlsym(glesLibrary, 'glQueryMatrixxOES');
  {$EndIf}

  {$IfDef GL_OES_single_precision}
  glClearDepthfOES := dlsym(glesLibrary, 'glClearDepthfOES');
  glClipPlanefOES := dlsym(glesLibrary, 'glClipPlanefOES');
  glDepthRangefOES := dlsym(glesLibrary, 'glDepthRangefOES');
  glFrustumfOES := dlsym(glesLibrary, 'glFrustumfOES');
  glGetClipPlanefOES := dlsym(glesLibrary, 'glGetClipPlanefOES');
  glOrthofOES := dlsym(glesLibrary, 'glOrthofOES');
  {$EndIf}

  {$IfDef GL_OES_texture_cube_map}
  glTexGenfOES := dlsym(glesLibrary, 'glTexGenfOES');
  glTexGenfvOES := dlsym(glesLibrary, 'glTexGenfvOES');
  glTexGeniOES := dlsym(glesLibrary, 'glTexGeniOES');
  glTexGenivOES := dlsym(glesLibrary, 'glTexGenivOES');
  glGetTexGenfvOES := dlsym(glesLibrary, 'glGetTexGenfvOES');
  glGetTexGenivOES := dlsym(glesLibrary, 'glGetTexGenivOES');
  {$EndIf}

  {$IfDef GL_IMG_user_clip_plane}
  glClipPlanefIMG := dlsym(glesLibrary, 'glClipPlanefIMG');
  glClipPlanexIMG := dlsym(glesLibrary, 'glClipPlanexIMG');
  {$EndIf}
{$EndIf}

{$IfDef GL_ES_VERSION_2_0}
  glActiveTexture := dlsym(glesLibrary, 'glActiveTexture');
  glAttachShader := dlsym(glesLibrary, 'glAttachShader');
  glBindAttribLocation := dlsym(glesLibrary, 'glBindAttribLocation');
  glBindBuffer := dlsym(glesLibrary, 'glBindBuffer');
// min GLES function - glBindFramebuffer := dlsym(glesLibrary, 'glBindFramebuffer');
// min GLES function - glBindRenderbuffer := dlsym(glesLibrary, 'glBindRenderbuffer');
// min GLES function - glBindTexture := dlsym(glesLibrary, 'glBindTexture');
  glBlendColor := dlsym(glesLibrary, 'glBlendColor');
// min GLES function - glBlendEquation := dlsym(glesLibrary, 'glBlendEquation');
  glBlendEquationSeparate := dlsym(glesLibrary, 'glBlendEquationSeparate');
// min GLES function - glBlendFunc := dlsym(glesLibrary, 'glBlendFunc');
// min GLES function - glBlendFuncSeparate := dlsym(glesLibrary, 'glBlendFuncSeparate');
  glBufferData := dlsym(glesLibrary, 'glBufferData');
  glBufferSubData := dlsym(glesLibrary, 'glBufferSubData');
// min GLES function - glCheckFramebufferStatus := dlsym(glesLibrary, 'glCheckFramebufferStatus');
// min GLES function - glClear := dlsym(glesLibrary, 'glClear');
// min GLES function - glClearColor := dlsym(glesLibrary, 'glClearColor');
// min GLES function - glClearDepthf := dlsym(glesLibrary, 'glClearDepthf');
  glClearStencil := dlsym(glesLibrary, 'glClearStencil');
// min GLES function - glColorMask := dlsym(glesLibrary, 'glColorMask');
  glCompileShader := dlsym(glesLibrary, 'glCompileShader');
// min GLES function - glCompressedTexImage2D := dlsym(glesLibrary, 'glCompressedTexImage2D');
// min GLES function - glCompressedTexSubImage2D := dlsym(glesLibrary, 'glCompressedTexSubImage2D');
  glCopyTexImage2D := dlsym(glesLibrary, 'glCopyTexImage2D');
// min GLES function - glCopyTexSubImage2D := dlsym(glesLibrary, 'glCopyTexSubImage2D');
  glCreateProgram := dlsym(glesLibrary, 'glCreateProgram');
  glCreateShader := dlsym(glesLibrary, 'glCreateShader');
  glCullFace := dlsym(glesLibrary, 'glCullFace');
  glDeleteBuffers := dlsym(glesLibrary, 'glDeleteBuffers');
// min GLES function - glDeleteFramebuffers := dlsym(glesLibrary, 'glDeleteFramebuffers');
  glDeleteProgram := dlsym(glesLibrary, 'glDeleteProgram');
// min GLES function - glDeleteRenderbuffers := dlsym(glesLibrary, 'glDeleteRenderbuffers');
  glDeleteShader := dlsym(glesLibrary, 'glDeleteShader');
// min GLES function - glDeleteTextures := dlsym(glesLibrary, 'glDeleteTextures');
// min GLES function - glDepthFunc := dlsym(glesLibrary, 'glDepthFunc');
// min GLES function - glDepthMask := dlsym(glesLibrary, 'glDepthMask');
  glDepthRangef := dlsym(glesLibrary, 'glDepthRangef');
  glDetachShader := dlsym(glesLibrary, 'glDetachShader');
// min GLES function - glDisable := dlsym(glesLibrary, 'glDisable');
  glDisableVertexAttribArray := dlsym(glesLibrary, 'glDisableVertexAttribArray');
// min GLES function - glDrawArrays := dlsym(glesLibrary, 'glDrawArrays');
// min GLES function - glDrawElements := dlsym(glesLibrary, 'glDrawElements');
// min GLES function - glEnable := dlsym(glesLibrary, 'glEnable');
  glEnableVertexAttribArray := dlsym(glesLibrary, 'glEnableVertexAttribArray');
  glFinish := dlsym(glesLibrary, 'glFinish');
  glFlush := dlsym(glesLibrary, 'glFlush');
// min GLES function - glFramebufferRenderbuffer := dlsym(glesLibrary, 'glFramebufferRenderbuffer');
// min GLES function - glFramebufferTexture2D := dlsym(glesLibrary, 'glFramebufferTexture2D');
  glFrontFace := dlsym(glesLibrary, 'glFrontFace');
  glGenBuffers := dlsym(glesLibrary, 'glGenBuffers');
// min GLES function - glGenerateMipmap := dlsym(glesLibrary, 'glGenerateMipmap');
// min GLES function - glGenFramebuffers := dlsym(glesLibrary, 'glGenFramebuffers');
// min GLES function - glGenRenderbuffers := dlsym(glesLibrary, 'glGenRenderbuffers');
// min GLES function - glGenTextures := dlsym(glesLibrary, 'glGenTextures');
  glGetActiveAttrib := dlsym(glesLibrary, 'glGetActiveAttrib');
  glGetActiveUniform := dlsym(glesLibrary, 'glGetActiveUniform');
  glGetAttachedShaders := dlsym(glesLibrary, 'glGetAttachedShaders');
  glGetAttribLocation := dlsym(glesLibrary, 'glGetAttribLocation');
  glGetBooleanv := dlsym(glesLibrary, 'glGetBooleanv');
  glGetBufferParameteriv := dlsym(glesLibrary, 'glGetBufferParameteriv');
  glGetError := dlsym(glesLibrary, 'glGetError');
// min GLES function - glGetFloatv := dlsym(glesLibrary, 'glGetFloatv');
// min GLES function - glGetFramebufferAttachmentParameteriv := dlsym(glesLibrary, 'glGetFramebufferAttachmentParameteriv');
// min GLES function - glGetIntegerv := dlsym(glesLibrary, 'glGetIntegerv');
  glGetProgramiv := dlsym(glesLibrary, 'glGetProgramiv');
  glGetProgramInfoLog := dlsym(glesLibrary, 'glGetProgramInfoLog');
// min GLES function - glGetRenderbufferParameteriv := dlsym(glesLibrary, 'glGetRenderbufferParameteriv');
  glGetShaderiv := dlsym(glesLibrary, 'glGetShaderiv');
  glGetShaderInfoLog := dlsym(glesLibrary, 'glGetShaderInfoLog');
  glGetShaderPrecisionFormat := dlsym(glesLibrary, 'glGetShaderPrecisionFormat');
  glGetShaderSource := dlsym(glesLibrary, 'glGetShaderSource');
  // min GLES function - glGetString := dlsym(glesLibrary, 'glGetString');
  glGetTexParameterfv := dlsym(glesLibrary, 'glGetTexParameterfv');
  glGetTexParameteriv := dlsym(glesLibrary, 'glGetTexParameteriv');
  glGetUniformfv := dlsym(glesLibrary, 'glGetUniformfv');
  glGetUniformiv := dlsym(glesLibrary, 'glGetUniformiv');
  glGetUniformLocation := dlsym(glesLibrary, 'glGetUniformLocation');
  glGetVertexAttribfv := dlsym(glesLibrary, 'glGetVertexAttribfv');
  glGetVertexAttribiv := dlsym(glesLibrary, 'glGetVertexAttribiv');
  glGetVertexAttribPointerv := dlsym(glesLibrary, 'glGetVertexAttribPointerv');
// min GLES function - glHint := dlsym(glesLibrary, 'glHint');
  glIsBuffer := dlsym(glesLibrary, 'glIsBuffer');
  glIsEnabled := dlsym(glesLibrary, 'glIsEnabled');
// min GLES function - glIsFramebuffer := dlsym(glesLibrary, 'glIsFramebuffer');
  glIsProgram := dlsym(glesLibrary, 'glIsProgram');
// min GLES function - glIsRenderbuffer := dlsym(glesLibrary, 'glIsRenderbuffer');
  glIsShader := dlsym(glesLibrary, 'glIsShader');
  glIsTexture := dlsym(glesLibrary, 'glIsTexture');
  glLineWidth := dlsym(glesLibrary, 'glLineWidth');
  glLinkProgram := dlsym(glesLibrary, 'glLinkProgram');
// min GLES function - glPixelStorei := dlsym(glesLibrary, 'glPixelStorei');
  glPolygonOffset := dlsym(glesLibrary, 'glPolygonOffset');
//  // min GLES function - glReadPixels := dlsym(glesLibrary, 'glReadPixels');
  glReleaseShaderCompiler := dlsym(glesLibrary, 'glReleaseShaderCompiler');
// min GLES function - glRenderbufferStorage := dlsym(glesLibrary, 'glRenderbufferStorage');
  glSampleCoverage := dlsym(glesLibrary, 'glSampleCoverage');
// min GLES function - glScissor := dlsym(glesLibrary, 'glScissor');
  glShaderBinary := dlsym(glesLibrary, 'glShaderBinary');
  glShaderSource := dlsym(glesLibrary, 'glShaderSource');
  glStencilFunc := dlsym(glesLibrary, 'glStencilFunc');
  glStencilFuncSeparate := dlsym(glesLibrary, 'glStencilFuncSeparate');
  glStencilMask := dlsym(glesLibrary, 'glStencilMask');
  glStencilMaskSeparate := dlsym(glesLibrary, 'glStencilMaskSeparate');
  glStencilOp := dlsym(glesLibrary, 'glStencilOp');
  glStencilOpSeparate := dlsym(glesLibrary, 'glStencilOpSeparate');
// min GLES function - glTexImage2D := dlsym(glesLibrary, 'glTexImage2D');
// min GLES function - glTexParameterf := dlsym(glesLibrary, 'glTexParameterf');
  glTexParameterfv := dlsym(glesLibrary, 'glTexParameterfv');
// min GLES function - glTexParameteri := dlsym(glesLibrary, 'glTexParameteri');
// min GLES function - glTexParameteriv := dlsym(glesLibrary, 'glTexParameteriv');
// min GLES function - glTexSubImage2D := dlsym(glesLibrary, 'glTexSubImage2D');
  glUniform1f := dlsym(glesLibrary, 'glUniform1f');
  glUniform1fv := dlsym(glesLibrary, 'glUniform1fv');
  glUniform1i := dlsym(glesLibrary, 'glUniform1i');
  glUniform1iv := dlsym(glesLibrary, 'glUniform1iv');
  glUniform2f := dlsym(glesLibrary, 'glUniform2f');
  glUniform2fv := dlsym(glesLibrary, 'glUniform2fv');
  glUniform2i := dlsym(glesLibrary, 'glUniform2i');
  glUniform2iv := dlsym(glesLibrary, 'glUniform2iv');
  glUniform3f := dlsym(glesLibrary, 'glUniform3f');
  glUniform3fv := dlsym(glesLibrary, 'glUniform3fv');
  glUniform3i := dlsym(glesLibrary, 'glUniform3i');
  glUniform3iv := dlsym(glesLibrary, 'glUniform3iv');
  glUniform4f := dlsym(glesLibrary, 'glUniform4f');
  glUniform4fv := dlsym(glesLibrary, 'glUniform4fv');
  glUniform4i := dlsym(glesLibrary, 'glUniform4i');
  glUniform4iv := dlsym(glesLibrary, 'glUniform4iv');
  glUniformMatrix2fv := dlsym(glesLibrary, 'glUniformMatrix2fv');
  glUniformMatrix3fv := dlsym(glesLibrary, 'glUniformMatrix3fv');
  glUniformMatrix4fv := dlsym(glesLibrary, 'glUniformMatrix4fv');
  glUseProgram := dlsym(glesLibrary, 'glUseProgram');
  glValidateProgram := dlsym(glesLibrary, 'glValidateProgram');
  glVertexAttrib1f := dlsym(glesLibrary, 'glVertexAttrib1f');
  glVertexAttrib1fv := dlsym(glesLibrary, 'glVertexAttrib1fv');
  glVertexAttrib2f := dlsym(glesLibrary, 'glVertexAttrib2f');
  glVertexAttrib2fv := dlsym(glesLibrary, 'glVertexAttrib2fv');
  glVertexAttrib3f := dlsym(glesLibrary, 'glVertexAttrib3f');
  glVertexAttrib3fv := dlsym(glesLibrary, 'glVertexAttrib3fv');
  glVertexAttrib4f := dlsym(glesLibrary, 'glVertexAttrib4f');
  glVertexAttrib4fv := dlsym(glesLibrary, 'glVertexAttrib4fv');
  glVertexAttribPointer := dlsym(glesLibrary, 'glVertexAttribPointer');
// min GLES function - glViewport := dlsym(glesLibrary, 'glViewport');
{$EndIf}

{$IfDef GL_KHR_blend_equation_advanced}
  glBlendBarrierKHR := dlsym(glesLibrary, 'glBlendBarrierKHR');
{$EndIf}

{$IfDef GL_KHR_debug}
  glDebugMessageControlKHR := dlsym(glesLibrary, 'glDebugMessageControlKHR');
  glDebugMessageInsertKHR := dlsym(glesLibrary, 'glDebugMessageInsertKHR');
  glDebugMessageCallbackKHR := dlsym(glesLibrary, 'glDebugMessageCallbackKHR');
  glGetDebugMessageLogKHR := dlsym(glesLibrary, 'glGetDebugMessageLogKHR');
  glPushDebugGroupKHR := dlsym(glesLibrary, 'glPushDebugGroupKHR');
  glPopDebugGroupKHR := dlsym(glesLibrary, 'glPopDebugGroupKHR');
  glObjectLabelKHR := dlsym(glesLibrary, 'glObjectLabelKHR');
  glGetObjectLabelKHR := dlsym(glesLibrary, 'glGetObjectLabelKHR');
  glObjectPtrLabelKHR := dlsym(glesLibrary, 'glObjectPtrLabelKHR');
  glGetObjectPtrLabelKHR := dlsym(glesLibrary, 'glGetObjectPtrLabelKHR');
  glGetPointervKHR := dlsym(glesLibrary, 'glGetPointervKHR');
{$EndIf}

{$IfDef GL_KHR_parallel_shader_compile}
  glMaxShaderCompilerThreadsKHR := dlsym(glesLibrary, 'glMaxShaderCompilerThreadsKHR');
{$EndIf}

{$IfDef GL_KHR_robustness}
  glGetGraphicsResetStatusKHR := dlsym(glesLibrary, 'glGetGraphicsResetStatusKHR');
  glReadnPixelsKHR := dlsym(glesLibrary, 'glReadnPixelsKHR');
  glGetnUniformfvKHR := dlsym(glesLibrary, 'glGetnUniformfvKHR');
  glGetnUniformivKHR := dlsym(glesLibrary, 'glGetnUniformivKHR');
  glGetnUniformuivKHR := dlsym(glesLibrary, 'glGetnUniformuivKHR');
{$EndIf}

{$IfDef GL_OES_EGL_image}
  glEGLImageTargetTexture2DOES := dlsym(glesLibrary, 'glEGLImageTargetTexture2DOES');
  glEGLImageTargetRenderbufferStorageOES := dlsym(glesLibrary, 'glEGLImageTargetRenderbufferStorageOES');
{$EndIf}

{$IfDef GL_OES_copy_image}
  glCopyImageSubDataOES := dlsym(glesLibrary, 'glCopyImageSubDataOES');
{$EndIf}

{$IfDef GL_OES_draw_buffers_indexed}
  glEnableiOES := dlsym(glesLibrary, 'glEnableiOES');
  glDisableiOES := dlsym(glesLibrary, 'glDisableiOES');
  glBlendEquationiOES := dlsym(glesLibrary, 'glBlendEquationiOES');
  glBlendEquationSeparateiOES := dlsym(glesLibrary, 'glBlendEquationSeparateiOES');
  glBlendFunciOES := dlsym(glesLibrary, 'glBlendFunciOES');
  glBlendFuncSeparateiOES := dlsym(glesLibrary, 'glBlendFuncSeparateiOES');
  glColorMaskiOES := dlsym(glesLibrary, 'glColorMaskiOES');
  glIsEnablediOES := dlsym(glesLibrary, 'glIsEnablediOES');
{$EndIf}

{$IfDef GL_OES_draw_elements_base_vertex}
  glDrawElementsBaseVertexOES := dlsym(glesLibrary, 'glDrawElementsBaseVertexOES');
  glDrawRangeElementsBaseVertexOES := dlsym(glesLibrary, 'glDrawRangeElementsBaseVertexOES');
  glDrawElementsInstancedBaseVertexOES := dlsym(glesLibrary, 'glDrawElementsInstancedBaseVertexOES');
  glMultiDrawElementsBaseVertexEXT := dlsym(glesLibrary, 'glMultiDrawElementsBaseVertexEXT');
{$EndIf}

{$IfDef GL_OES_geometry_shader}
  glFramebufferTextureOES := dlsym(glesLibrary, 'glFramebufferTextureOES');
{$EndIf}

{$IfDef GL_OES_get_program_binary}
  glGetProgramBinaryOES := dlsym(glesLibrary, 'glGetProgramBinaryOES');
  glProgramBinaryOES := dlsym(glesLibrary, 'glProgramBinaryOES');
{$EndIf}

{$IfDef GL_OES_mapbuffer}
  glMapBufferOES := dlsym(glesLibrary, 'glMapBufferOES');
  glUnmapBufferOES := dlsym(glesLibrary, 'glUnmapBufferOES');
  glGetBufferPointervOES := dlsym(glesLibrary, 'glGetBufferPointervOES');
{$EndIf}

{$IfDef GL_OES_primitive_bounding_box}
  glPrimitiveBoundingBoxOES := dlsym(glesLibrary, 'glPrimitiveBoundingBoxOES');
{$EndIf}

{$IfDef GL_OES_sample_shading}
  glMinSampleShadingOES := dlsym(glesLibrary, 'glMinSampleShadingOES');
{$EndIf}

{$IfDef GL_OES_tessellation_shader}
  glPatchParameteriOES := dlsym(glesLibrary, 'glPatchParameteriOES');
{$EndIf}

{$IfDef GL_OES_texture_3D}
  glTexImage3DOES := dlsym(glesLibrary, 'glTexImage3DOES');
  glTexSubImage3DOES := dlsym(glesLibrary, 'glTexSubImage3DOES');
  glCopyTexSubImage3DOES := dlsym(glesLibrary, 'glCopyTexSubImage3DOES');
  glCompressedTexImage3DOES := dlsym(glesLibrary, 'glCompressedTexImage3DOES');
  glCompressedTexSubImage3DOES := dlsym(glesLibrary, 'glCompressedTexSubImage3DOES');
  glFramebufferTexture3DOES := dlsym(glesLibrary, 'glFramebufferTexture3DOES');
{$EndIf}

{$IfDef GL_OES_texture_border_clamp}
  glTexParameterIivOES := dlsym(glesLibrary, 'glTexParameterIivOES');
  glTexParameterIuivOES := dlsym(glesLibrary, 'glTexParameterIuivOES');
  glGetTexParameterIivOES := dlsym(glesLibrary, 'glGetTexParameterIivOES');
  glGetTexParameterIuivOES := dlsym(glesLibrary, 'glGetTexParameterIuivOES');
  glSamplerParameterIivOES := dlsym(glesLibrary, 'glSamplerParameterIivOES');
  glSamplerParameterIuivOES := dlsym(glesLibrary, 'glSamplerParameterIuivOES');
  glGetSamplerParameterIivOES := dlsym(glesLibrary, 'glGetSamplerParameterIivOES');
  glGetSamplerParameterIuivOES := dlsym(glesLibrary, 'glGetSamplerParameterIuivOES');
{$EndIf}

{$IfDef GL_OES_texture_buffer}
  glTexBufferOES := dlsym(glesLibrary, 'glTexBufferOES');
  glTexBufferRangeOES := dlsym(glesLibrary, 'glTexBufferRangeOES');
{$EndIf}

{$IfDef GL_OES_texture_storage_multisample_2d_array}
  glTexStorage3DMultisampleOES := dlsym(glesLibrary, 'glTexStorage3DMultisampleOES');
{$EndIf}

{$IfDef GL_OES_texture_view}
  glTextureViewOES := dlsym(glesLibrary, 'glTextureViewOES');
{$EndIf}

{$IfDef GL_OES_vertex_array_object}
  glBindVertexArrayOES := dlsym(glesLibrary, 'glBindVertexArrayOES');
  glDeleteVertexArraysOES := dlsym(glesLibrary, 'glDeleteVertexArraysOES');
  glGenVertexArraysOES := dlsym(glesLibrary, 'glGenVertexArraysOES');
  glIsVertexArrayOES := dlsym(glesLibrary, 'glIsVertexArrayOES');
{$EndIf}

{$IfDef GL_OES_viewport_array}
  glViewportArrayvOES := dlsym(glesLibrary, 'glViewportArrayvOES');
  glViewportIndexedfOES := dlsym(glesLibrary, 'glViewportIndexedfOES');
  glViewportIndexedfvOES := dlsym(glesLibrary, 'glViewportIndexedfvOES');
  glScissorArrayvOES := dlsym(glesLibrary, 'glScissorArrayvOES');
  glScissorIndexedOES := dlsym(glesLibrary, 'glScissorIndexedOES');
  glScissorIndexedvOES := dlsym(glesLibrary, 'glScissorIndexedvOES');
  glDepthRangeArrayfvOES := dlsym(glesLibrary, 'glDepthRangeArrayfvOES');
  glDepthRangeIndexedfOES := dlsym(glesLibrary, 'glDepthRangeIndexedfOES');
  glGetFloati_vOES := dlsym(glesLibrary, 'glGetFloati_vOES');
{$EndIf}

{$IfDef GL_AMD_framebuffer_multisample_advanced}
  glRenderbufferStorageMultisampleAdvancedAMD := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleAdvancedAMD');
  glNamedRenderbufferStorageMultisampleAdvancedAMD := dlsym(glesLibrary, 'glNamedRenderbufferStorageMultisampleAdvancedAMD');
{$EndIf}

{$IfDef GL_AMD_performance_monitor}
  glGetPerfMonitorGroupsAMD := dlsym(glesLibrary, 'glGetPerfMonitorGroupsAMD');
  glGetPerfMonitorCountersAMD := dlsym(glesLibrary, 'glGetPerfMonitorCountersAMD');
  glGetPerfMonitorGroupStringAMD := dlsym(glesLibrary, 'glGetPerfMonitorGroupStringAMD');
  glGetPerfMonitorCounterStringAMD := dlsym(glesLibrary, 'glGetPerfMonitorCounterStringAMD');
  glGetPerfMonitorCounterInfoAMD := dlsym(glesLibrary, 'glGetPerfMonitorCounterInfoAMD');
  glGenPerfMonitorsAMD := dlsym(glesLibrary, 'glGenPerfMonitorsAMD');
  glDeletePerfMonitorsAMD := dlsym(glesLibrary, 'glDeletePerfMonitorsAMD');
  glSelectPerfMonitorCountersAMD := dlsym(glesLibrary, 'glSelectPerfMonitorCountersAMD');
  glBeginPerfMonitorAMD := dlsym(glesLibrary, 'glBeginPerfMonitorAMD');
  glEndPerfMonitorAMD := dlsym(glesLibrary, 'glEndPerfMonitorAMD');
  glGetPerfMonitorCounterDataAMD := dlsym(glesLibrary, 'glGetPerfMonitorCounterDataAMD');
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_blit}
  glBlitFramebufferANGLE := dlsym(glesLibrary, 'glBlitFramebufferANGLE');
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleANGLE := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleANGLE');
{$EndIf}

{$IfDef GL_ANGLE_instanced_arrays}
  glDrawArraysInstancedANGLE := dlsym(glesLibrary, 'glDrawArraysInstancedANGLE');
  glDrawElementsInstancedANGLE := dlsym(glesLibrary, 'glDrawElementsInstancedANGLE');
  glVertexAttribDivisorANGLE := dlsym(glesLibrary, 'glVertexAttribDivisorANGLE');
{$EndIf}

{$IfDef GL_ANGLE_translated_shader_source}
  glGetTranslatedShaderSourceANGLE := dlsym(glesLibrary, 'glGetTranslatedShaderSourceANGLE');
{$EndIf}

{$IfDef GL_APPLE_copy_texture_levels}
  glCopyTextureLevelsAPPLE := dlsym(glesLibrary, 'glCopyTextureLevelsAPPLE');
{$EndIf}

{$IfDef GL_APPLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleAPPLE := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleAPPLE');
  glResolveMultisampleFramebufferAPPLE := dlsym(glesLibrary, 'glResolveMultisampleFramebufferAPPLE');
{$EndIf}

{$IfDef GL_APPLE_sync}
  glFenceSyncAPPLE := dlsym(glesLibrary, 'glFenceSyncAPPLE');
  glIsSyncAPPLE := dlsym(glesLibrary, 'glIsSyncAPPLE');
  glDeleteSyncAPPLE := dlsym(glesLibrary, 'glDeleteSyncAPPLE');
  glClientWaitSyncAPPLE := dlsym(glesLibrary, 'glClientWaitSyncAPPLE');
  glWaitSyncAPPLE := dlsym(glesLibrary, 'glWaitSyncAPPLE');
  glGetInteger64vAPPLE := dlsym(glesLibrary, 'glGetInteger64vAPPLE');
  glGetSyncivAPPLE := dlsym(glesLibrary, 'glGetSyncivAPPLE');
{$EndIf}

{$IfDef GL_EXT_EGL_image_storage}
  glEGLImageTargetTexStorageEXT := dlsym(glesLibrary, 'glEGLImageTargetTexStorageEXT');
  glEGLImageTargetTextureStorageEXT := dlsym(glesLibrary, 'glEGLImageTargetTextureStorageEXT');
{$EndIf}

{$IfDef GL_EXT_base_instance}
  glDrawArraysInstancedBaseInstanceEXT := dlsym(glesLibrary, 'glDrawArraysInstancedBaseInstanceEXT');
  glDrawElementsInstancedBaseInstanceEXT := dlsym(glesLibrary, 'glDrawElementsInstancedBaseInstanceEXT');
  glDrawElementsInstancedBaseVertexBaseInstanceEXT := dlsym(glesLibrary, 'glDrawElementsInstancedBaseVertexBaseInstanceEXT');
{$EndIf}

{$IfDef GL_EXT_blend_func_extended}
  glBindFragDataLocationIndexedEXT := dlsym(glesLibrary, 'glBindFragDataLocationIndexedEXT');
  glBindFragDataLocationEXT := dlsym(glesLibrary, 'glBindFragDataLocationEXT');
  glGetProgramResourceLocationIndexEXT := dlsym(glesLibrary, 'glGetProgramResourceLocationIndexEXT');
  glGetFragDataIndexEXT := dlsym(glesLibrary, 'glGetFragDataIndexEXT');
{$EndIf}

{$IfDef GL_EXT_buffer_storage}
  glBufferStorageEXT := dlsym(glesLibrary, 'glBufferStorageEXT');
{$EndIf}

{$IfDef GL_EXT_clear_texture}
  glClearTexImageEXT := dlsym(glesLibrary, 'glClearTexImageEXT');
  glClearTexSubImageEXT := dlsym(glesLibrary, 'glClearTexSubImageEXT');
{$EndIf}

{$IfDef GL_EXT_clip_control}
  glClipControlEXT := dlsym(glesLibrary, 'glClipControlEXT');
{$EndIf}

{$IfDef GL_EXT_copy_image}
  glCopyImageSubDataEXT := dlsym(glesLibrary, 'glCopyImageSubDataEXT');
{$EndIf}

{$IfDef GL_EXT_debug_label}
  glLabelObjectEXT := dlsym(glesLibrary, 'glLabelObjectEXT');
  glGetObjectLabelEXT := dlsym(glesLibrary, 'glGetObjectLabelEXT');
{$EndIf}

{$IfDef GL_EXT_debug_marker}
  glInsertEventMarkerEXT := dlsym(glesLibrary, 'glInsertEventMarkerEXT');
  glPushGroupMarkerEXT := dlsym(glesLibrary, 'glPushGroupMarkerEXT');
  glPopGroupMarkerEXT := dlsym(glesLibrary, 'glPopGroupMarkerEXT');
{$EndIf}

{$IfDef GL_EXT_discard_framebuffer}
  glDiscardFramebufferEXT := dlsym(glesLibrary, 'glDiscardFramebufferEXT');
{$EndIf}

{$IfDef GL_EXT_disjoint_timer_query}
  glGenQueriesEXT := dlsym(glesLibrary, 'glGenQueriesEXT');
  glDeleteQueriesEXT := dlsym(glesLibrary, 'glDeleteQueriesEXT');
  glIsQueryEXT := dlsym(glesLibrary, 'glIsQueryEXT');
  glBeginQueryEXT := dlsym(glesLibrary, 'glBeginQueryEXT');
  glEndQueryEXT := dlsym(glesLibrary, 'glEndQueryEXT');
  glQueryCounterEXT := dlsym(glesLibrary, 'glQueryCounterEXT');
  glGetQueryivEXT := dlsym(glesLibrary, 'glGetQueryivEXT');
  glGetQueryObjectivEXT := dlsym(glesLibrary, 'glGetQueryObjectivEXT');
  glGetQueryObjectuivEXT := dlsym(glesLibrary, 'glGetQueryObjectuivEXT');
  glGetQueryObjecti64vEXT := dlsym(glesLibrary, 'glGetQueryObjecti64vEXT');
  glGetQueryObjectui64vEXT := dlsym(glesLibrary, 'glGetQueryObjectui64vEXT');
  glGetInteger64vEXT := dlsym(glesLibrary, 'glGetInteger64vEXT');
{$EndIf}

{$IfDef GL_EXT_draw_buffers}
  glDrawBuffersEXT := dlsym(glesLibrary, 'glDrawBuffersEXT');
{$EndIf}

{$IfDef GL_EXT_draw_elements_base_vertex}
  glDrawElementsBaseVertexEXT := dlsym(glesLibrary, 'glDrawElementsBaseVertexEXT');
  glDrawRangeElementsBaseVertexEXT := dlsym(glesLibrary, 'glDrawRangeElementsBaseVertexEXT');
  glDrawElementsInstancedBaseVertexEXT := dlsym(glesLibrary, 'glDrawElementsInstancedBaseVertexEXT');
{$EndIf}

{$IfDef GL_EXT_draw_instanced}
  glDrawArraysInstancedEXT := dlsym(glesLibrary, 'glDrawArraysInstancedEXT');
  glDrawElementsInstancedEXT := dlsym(glesLibrary, 'glDrawElementsInstancedEXT');
{$EndIf}

{$IfDef GL_EXT_draw_transform_feedback}
  glDrawTransformFeedbackEXT := dlsym(glesLibrary, 'glDrawTransformFeedbackEXT');
  glDrawTransformFeedbackInstancedEXT := dlsym(glesLibrary, 'glDrawTransformFeedbackInstancedEXT');
{$EndIf}

{$IfDef GL_EXT_external_buffer}
  glBufferStorageExternalEXT := dlsym(glesLibrary, 'glBufferStorageExternalEXT');
  glNamedBufferStorageExternalEXT := dlsym(glesLibrary, 'glNamedBufferStorageExternalEXT');
{$EndIf}

{$IfDef GL_EXT_fragment_shading_rate}
  glGetFragmentShadingRatesEXT := dlsym(glesLibrary, 'glGetFragmentShadingRatesEXT');
  glShadingRateEXT := dlsym(glesLibrary, 'glShadingRateEXT');
  glShadingRateCombinerOpsEXT := dlsym(glesLibrary, 'glShadingRateCombinerOpsEXT');
  glFramebufferShadingRateEXT := dlsym(glesLibrary, 'glFramebufferShadingRateEXT');
{$EndIf}

{$IfDef GL_EXT_framebuffer_blit_layers}
  glBlitFramebufferLayersEXT := dlsym(glesLibrary, 'glBlitFramebufferLayersEXT');
  glBlitFramebufferLayerEXT := dlsym(glesLibrary, 'glBlitFramebufferLayerEXT');
{$EndIf}

{$IfDef GL_EXT_geometry_shader}
  glFramebufferTextureEXT := dlsym(glesLibrary, 'glFramebufferTextureEXT');
{$EndIf}

{$IfDef GL_EXT_instanced_arrays}
  glVertexAttribDivisorEXT := dlsym(glesLibrary, 'glVertexAttribDivisorEXT');
{$EndIf}

{$IfDef GL_EXT_map_buffer_range}
  glMapBufferRangeEXT := dlsym(glesLibrary, 'glMapBufferRangeEXT');
  glFlushMappedBufferRangeEXT := dlsym(glesLibrary, 'glFlushMappedBufferRangeEXT');
{$EndIf}

{$IfDef GL_EXT_memory_object}
  glGetUnsignedBytevEXT := dlsym(glesLibrary, 'glGetUnsignedBytevEXT');
  glGetUnsignedBytei_vEXT := dlsym(glesLibrary, 'glGetUnsignedBytei_vEXT');
  glDeleteMemoryObjectsEXT := dlsym(glesLibrary, 'glDeleteMemoryObjectsEXT');
  glIsMemoryObjectEXT := dlsym(glesLibrary, 'glIsMemoryObjectEXT');
  glCreateMemoryObjectsEXT := dlsym(glesLibrary, 'glCreateMemoryObjectsEXT');
  glMemoryObjectParameterivEXT := dlsym(glesLibrary, 'glMemoryObjectParameterivEXT');
  glGetMemoryObjectParameterivEXT := dlsym(glesLibrary, 'glGetMemoryObjectParameterivEXT');
  glTexStorageMem2DEXT := dlsym(glesLibrary, 'glTexStorageMem2DEXT');
  glTexStorageMem2DMultisampleEXT := dlsym(glesLibrary, 'glTexStorageMem2DMultisampleEXT');
  glTexStorageMem3DEXT := dlsym(glesLibrary, 'glTexStorageMem3DEXT');
  glTexStorageMem3DMultisampleEXT := dlsym(glesLibrary, 'glTexStorageMem3DMultisampleEXT');
  glBufferStorageMemEXT := dlsym(glesLibrary, 'glBufferStorageMemEXT');
  glTextureStorageMem2DEXT := dlsym(glesLibrary, 'glTextureStorageMem2DEXT');
  glTextureStorageMem2DMultisampleEXT := dlsym(glesLibrary, 'glTextureStorageMem2DMultisampleEXT');
  glTextureStorageMem3DEXT := dlsym(glesLibrary, 'glTextureStorageMem3DEXT');
  glTextureStorageMem3DMultisampleEXT := dlsym(glesLibrary, 'glTextureStorageMem3DMultisampleEXT');
  glNamedBufferStorageMemEXT := dlsym(glesLibrary, 'glNamedBufferStorageMemEXT');
{$EndIf}

{$IfDef GL_EXT_memory_object_fd}
  glImportMemoryFdEXT := dlsym(glesLibrary, 'glImportMemoryFdEXT');
{$EndIf}

{$IfDef GL_EXT_memory_object_win32}
  glImportMemoryWin32HandleEXT := dlsym(glesLibrary, 'glImportMemoryWin32HandleEXT');
  glImportMemoryWin32NameEXT := dlsym(glesLibrary, 'glImportMemoryWin32NameEXT');
{$EndIf}

{$IfDef GL_EXT_multi_draw_arrays}
  glMultiDrawArraysEXT := dlsym(glesLibrary, 'glMultiDrawArraysEXT');
  glMultiDrawElementsEXT := dlsym(glesLibrary, 'glMultiDrawElementsEXT');
{$EndIf}

{$IfDef GL_EXT_multi_draw_indirect}
  glMultiDrawArraysIndirectEXT := dlsym(glesLibrary, 'glMultiDrawArraysIndirectEXT');
  glMultiDrawElementsIndirectEXT := dlsym(glesLibrary, 'glMultiDrawElementsIndirectEXT');
{$EndIf}

{$IfDef GL_EXT_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleEXT := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleEXT');
  glFramebufferTexture2DMultisampleEXT := dlsym(glesLibrary, 'glFramebufferTexture2DMultisampleEXT');
{$EndIf}

{$IfDef GL_EXT_multiview_draw_buffers}
  glReadBufferIndexedEXT := dlsym(glesLibrary, 'glReadBufferIndexedEXT');
  glDrawBuffersIndexedEXT := dlsym(glesLibrary, 'glDrawBuffersIndexedEXT');
  glGetIntegeri_vEXT := dlsym(glesLibrary, 'glGetIntegeri_vEXT');
{$EndIf}

{$IfDef GL_EXT_polygon_offset_clamp}
   glPolygonOffsetClampEXT := dlsym(glesLibrary, 'glPolygonOffsetClampEXT');
{$EndIf}

{$IfDef GL_EXT_primitive_bounding_box}
  glPrimitiveBoundingBoxEXT := dlsym(glesLibrary, 'glPrimitiveBoundingBoxEXT');
{$EndIf}

{$IfDef GL_EXT_raster_multisample}
  glRasterSamplesEXT := dlsym(glesLibrary, 'glRasterSamplesEXT');
{$EndIf}

{$IfDef GL_EXT_robustness}
  glGetGraphicsResetStatusEXT := dlsym(glesLibrary, 'glGetGraphicsResetStatusEXT');
  glReadnPixelsEXT := dlsym(glesLibrary, 'glReadnPixelsEXT');
  glGetnUniformfvEXT := dlsym(glesLibrary, 'glGetnUniformfvEXT');
  glGetnUniformivEXT := dlsym(glesLibrary, 'glGetnUniformivEXT');
{$EndIf}

{$IfDef GL_EXT_semaphore}
  glGenSemaphoresEXT := dlsym(glesLibrary, 'glGenSemaphoresEXT');
  glDeleteSemaphoresEXT := dlsym(glesLibrary, 'glDeleteSemaphoresEXT');
  glIsSemaphoreEXT := dlsym(glesLibrary, 'glIsSemaphoreEXT');
  glSemaphoreParameterui64vEXT := dlsym(glesLibrary, 'glSemaphoreParameterui64vEXT');
  glGetSemaphoreParameterui64vEXT := dlsym(glesLibrary, 'glGetSemaphoreParameterui64vEXT');
  glWaitSemaphoreEXT := dlsym(glesLibrary, 'glWaitSemaphoreEXT');
  glSignalSemaphoreEXT := dlsym(glesLibrary, 'glSignalSemaphoreEXT');
{$EndIf}

{$IfDef GL_EXT_semaphore_fd}
  glImportSemaphoreFdEXT := dlsym(glesLibrary, 'glImportSemaphoreFdEXT');
{$EndIf}

{$IfDef GL_EXT_semaphore_win32}
  glImportSemaphoreWin32HandleEXT := dlsym(glesLibrary, 'glImportSemaphoreWin32HandleEXT');
  glImportSemaphoreWin32NameEXT := dlsym(glesLibrary, 'glImportSemaphoreWin32NameEXT');
{$EndIf}

{$IfDef GL_EXT_separate_shader_objects}
  glActiveShaderProgramEXT := dlsym(glesLibrary, 'glActiveShaderProgramEXT');
  glBindProgramPipelineEXT := dlsym(glesLibrary, 'glBindProgramPipelineEXT');
  glCreateShaderProgramvEXT := dlsym(glesLibrary, 'glCreateShaderProgramvEXT');
  glDeleteProgramPipelinesEXT := dlsym(glesLibrary, 'glDeleteProgramPipelinesEXT');
  glGenProgramPipelinesEXT := dlsym(glesLibrary, 'glGenProgramPipelinesEXT');
  glGetProgramPipelineInfoLogEXT := dlsym(glesLibrary, 'glGetProgramPipelineInfoLogEXT');
  glGetProgramPipelineivEXT := dlsym(glesLibrary, 'glGetProgramPipelineivEXT');
  glIsProgramPipelineEXT := dlsym(glesLibrary, 'glIsProgramPipelineEXT');
  glProgramParameteriEXT := dlsym(glesLibrary, 'glProgramParameteriEXT');
  glProgramUniform1fEXT := dlsym(glesLibrary, 'glProgramUniform1fEXT');
  glProgramUniform1fvEXT := dlsym(glesLibrary, 'glProgramUniform1fvEXT');
  glProgramUniform1iEXT := dlsym(glesLibrary, 'glProgramUniform1iEXT');
  glProgramUniform1ivEXT := dlsym(glesLibrary, 'glProgramUniform1ivEXT');
  glProgramUniform2fEXT := dlsym(glesLibrary, 'glProgramUniform2fEXT');
  glProgramUniform2fvEXT := dlsym(glesLibrary, 'glProgramUniform2fvEXT');
  glProgramUniform2iEXT := dlsym(glesLibrary, 'glProgramUniform2iEXT');
  glProgramUniform2ivEXT := dlsym(glesLibrary, 'glProgramUniform2ivEXT');
  glProgramUniform3fEXT := dlsym(glesLibrary, 'glProgramUniform3fEXT');
  glProgramUniform3fvEXT := dlsym(glesLibrary, 'glProgramUniform3fvEXT');
  glProgramUniform3iEXT := dlsym(glesLibrary, 'glProgramUniform3iEXT');
  glProgramUniform3ivEXT := dlsym(glesLibrary, 'glProgramUniform3ivEXT');
  glProgramUniform4fEXT := dlsym(glesLibrary, 'glProgramUniform4fEXT');
  glProgramUniform4fvEXT := dlsym(glesLibrary, 'glProgramUniform4fvEXT');
  glProgramUniform4iEXT := dlsym(glesLibrary, 'glProgramUniform4iEXT');
  glProgramUniform4ivEXT := dlsym(glesLibrary, 'glProgramUniform4ivEXT');
  glProgramUniformMatrix2fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix2fvEXT');
  glProgramUniformMatrix3fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix3fvEXT');
  glProgramUniformMatrix4fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix4fvEXT');
  glUseProgramStagesEXT := dlsym(glesLibrary, 'glUseProgramStagesEXT');
  glValidateProgramPipelineEXT := dlsym(glesLibrary, 'glValidateProgramPipelineEXT');
  glProgramUniform1uiEXT := dlsym(glesLibrary, 'glProgramUniform1uiEXT');
  glProgramUniform2uiEXT := dlsym(glesLibrary, 'glProgramUniform2uiEXT');
  glProgramUniform3uiEXT := dlsym(glesLibrary, 'glProgramUniform3uiEXT');
  glProgramUniform4uiEXT := dlsym(glesLibrary, 'glProgramUniform4uiEXT');
  glProgramUniform1uivEXT := dlsym(glesLibrary, 'glProgramUniform1uivEXT');
  glProgramUniform2uivEXT := dlsym(glesLibrary, 'glProgramUniform2uivEXT');
  glProgramUniform3uivEXT := dlsym(glesLibrary, 'glProgramUniform3uivEXT');
  glProgramUniform4uivEXT := dlsym(glesLibrary, 'glProgramUniform4uivEXT');
  glProgramUniformMatrix2x3fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix2x3fvEXT');
  glProgramUniformMatrix3x2fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix3x2fvEXT');
  glProgramUniformMatrix2x4fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix2x4fvEXT');
  glProgramUniformMatrix4x2fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix4x2fvEXT');
  glProgramUniformMatrix3x4fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix3x4fvEXT');
  glProgramUniformMatrix4x3fvEXT := dlsym(glesLibrary, 'glProgramUniformMatrix4x3fvEXT');
{$EndIf}

{$IfDef GL_EXT_shader_framebuffer_fetch_non_coherent}
  glFramebufferFetchBarrierEXT := dlsym(glesLibrary, 'glFramebufferFetchBarrierEXT');
{$EndIf}

{$IfDef GL_EXT_shader_pixel_local_storage2}
  glFramebufferPixelLocalStorageSizeEXT := dlsym(glesLibrary, 'glFramebufferPixelLocalStorageSizeEXT');
  glGetFramebufferPixelLocalStorageSizeEXT := dlsym(glesLibrary, 'glGetFramebufferPixelLocalStorageSizeEXT');
  glClearPixelLocalStorageuiEXT := dlsym(glesLibrary, 'glClearPixelLocalStorageuiEXT');
{$EndIf}

{$IfDef GL_EXT_sparse_texture}
  glTexPageCommitmentEXT := dlsym(glesLibrary, 'glTexPageCommitmentEXT');
{$EndIf}

{$IfDef GL_EXT_tessellation_shader}
  glPatchParameteriEXT := dlsym(glesLibrary, 'glPatchParameteriEXT');
{$EndIf}

{$IfDef GL_EXT_texture_border_clamp}
  glTexParameterIivEXT := dlsym(glesLibrary, 'glTexParameterIivEXT');
  glTexParameterIuivEXT := dlsym(glesLibrary, 'glTexParameterIuivEXT');
  glGetTexParameterIivEXT := dlsym(glesLibrary, 'glGetTexParameterIivEXT');
  glGetTexParameterIuivEXT := dlsym(glesLibrary, 'glGetTexParameterIuivEXT');
  glSamplerParameterIivEXT := dlsym(glesLibrary, 'glSamplerParameterIivEXT');
  glSamplerParameterIuivEXT := dlsym(glesLibrary, 'glSamplerParameterIuivEXT');
  glGetSamplerParameterIivEXT := dlsym(glesLibrary, 'glGetSamplerParameterIivEXT');
  glGetSamplerParameterIuivEXT := dlsym(glesLibrary, 'glGetSamplerParameterIuivEXT');
{$EndIf}

{$IfDef GL_EXT_texture_buffer}
  glTexBufferEXT := dlsym(glesLibrary, 'glTexBufferEXT');
  glTexBufferRangeEXT := dlsym(glesLibrary, 'glTexBufferRangeEXT');
{$EndIf}

{$IfDef GL_EXT_texture_storage}
  glTexStorage1DEXT := dlsym(glesLibrary, 'glTexStorage1DEXT');
  glTexStorage2DEXT := dlsym(glesLibrary, 'glTexStorage2DEXT');
  glTexStorage3DEXT := dlsym(glesLibrary, 'glTexStorage3DEXT');
  glTextureStorage1DEXT := dlsym(glesLibrary, 'glTextureStorage1DEXT');
  glTextureStorage2DEXT := dlsym(glesLibrary, 'glTextureStorage2DEXT');
  glTextureStorage3DEXT := dlsym(glesLibrary, 'glTextureStorage3DEXT');
{$EndIf}

{$IfDef GL_EXT_texture_storage_compression}
  glTexStorageAttribs2DEXT := dlsym(glesLibrary, 'glTexStorageAttribs2DEXT');
  glTexStorageAttribs3DEXT := dlsym(glesLibrary, 'glTexStorageAttribs3DEXT');
{$EndIf}

{$IfDef GL_EXT_texture_view}
  glTextureViewEXT := dlsym(glesLibrary, 'glTextureViewEXT');
{$EndIf}

{$IfDef GL_EXT_win32_keyed_mutex}
  glAcquireKeyedMutexWin32EXT := dlsym(glesLibrary, 'glAcquireKeyedMutexWin32EXT');
  glReleaseKeyedMutexWin32EXT := dlsym(glesLibrary, 'glReleaseKeyedMutexWin32EXT');
{$EndIf}

{$IfDef GL_EXT_window_rectangles}
  glWindowRectanglesEXT := dlsym(glesLibrary, 'glWindowRectanglesEXT');
{$EndIf}

{$IfDef GL_IMG_bindless_texture}
  glGetTextureHandleIMG := dlsym(glesLibrary, 'glGetTextureHandleIMG');
  glGetTextureSamplerHandleIMG := dlsym(glesLibrary, 'glGetTextureSamplerHandleIMG');
  glUniformHandleui64IMG := dlsym(glesLibrary, 'glUniformHandleui64IMG');
  glUniformHandleui64vIMG := dlsym(glesLibrary, 'glUniformHandleui64vIMG');
  glProgramUniformHandleui64IMG := dlsym(glesLibrary, 'glProgramUniformHandleui64IMG');
  glProgramUniformHandleui64vIMG := dlsym(glesLibrary, 'glProgramUniformHandleui64vIMG');
{$EndIf}

{$IfDef GL_IMG_framebuffer_downsample}
  glFramebufferTexture2DDownsampleIMG := dlsym(glesLibrary, 'glFramebufferTexture2DDownsampleIMG');
  glFramebufferTextureLayerDownsampleIMG := dlsym(glesLibrary, 'glFramebufferTextureLayerDownsampleIMG');
{$EndIf}

{$IfDef GL_IMG_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleIMG := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleIMG');
  glFramebufferTexture2DMultisampleIMG := dlsym(glesLibrary, 'glFramebufferTexture2DMultisampleIMG');
{$EndIf}

{$IfDef GL_INTEL_framebuffer_CMAA}
  glApplyFramebufferAttachmentCMAAINTEL := dlsym(glesLibrary, 'glApplyFramebufferAttachmentCMAAINTEL');
{$EndIf}

{$IfDef GL_INTEL_performance_query}
  glBeginPerfQueryINTEL := dlsym(glesLibrary, 'glBeginPerfQueryINTEL');
  glCreatePerfQueryINTEL := dlsym(glesLibrary, 'glCreatePerfQueryINTEL');
  glDeletePerfQueryINTEL := dlsym(glesLibrary, 'glDeletePerfQueryINTEL');
  glEndPerfQueryINTEL := dlsym(glesLibrary, 'glEndPerfQueryINTEL');
  glGetFirstPerfQueryIdINTEL := dlsym(glesLibrary, 'glGetFirstPerfQueryIdINTEL');
  glGetNextPerfQueryIdINTEL := dlsym(glesLibrary, 'glGetNextPerfQueryIdINTEL');
  glGetPerfCounterInfoINTEL := dlsym(glesLibrary, 'glGetPerfCounterInfoINTEL');
  glGetPerfQueryDataINTEL := dlsym(glesLibrary, 'glGetPerfQueryDataINTEL');
  glGetPerfQueryIdByNameINTEL := dlsym(glesLibrary, 'glGetPerfQueryIdByNameINTEL');
  glGetPerfQueryInfoINTEL := dlsym(glesLibrary, 'glGetPerfQueryInfoINTEL');
{$EndIf}

{$IfDef GL_MESA_framebuffer_flip_y}
  glFramebufferParameteriMESA := dlsym(glesLibrary, 'glFramebufferParameteriMESA');
  glGetFramebufferParameterivMESA := dlsym(glesLibrary, 'glGetFramebufferParameterivMESA');
{$EndIf}

{$IfDef GL_NV_bindless_texture}
  glGetTextureHandleNV := dlsym(glesLibrary, 'glGetTextureHandleNV');
  glGetTextureSamplerHandleNV := dlsym(glesLibrary, 'glGetTextureSamplerHandleNV');
  glMakeTextureHandleResidentNV := dlsym(glesLibrary, 'glMakeTextureHandleResidentNV');
  glMakeTextureHandleNonResidentNV := dlsym(glesLibrary, 'glMakeTextureHandleNonResidentNV');
  glGetImageHandleNV := dlsym(glesLibrary, 'glGetImageHandleNV');
  glMakeImageHandleResidentNV := dlsym(glesLibrary, 'glMakeImageHandleResidentNV');
  glMakeImageHandleNonResidentNV := dlsym(glesLibrary, 'glMakeImageHandleNonResidentNV');
  glUniformHandleui64NV := dlsym(glesLibrary, 'glUniformHandleui64NV');
  glUniformHandleui64vNV := dlsym(glesLibrary, 'glUniformHandleui64vNV');
  glProgramUniformHandleui64NV := dlsym(glesLibrary, 'glProgramUniformHandleui64NV');
  glProgramUniformHandleui64vNV := dlsym(glesLibrary, 'glProgramUniformHandleui64vNV');
  glIsTextureHandleResidentNV := dlsym(glesLibrary, 'glIsTextureHandleResidentNV');
  glIsImageHandleResidentNV := dlsym(glesLibrary, 'glIsImageHandleResidentNV');
{$EndIf}

{$IfDef GL_NV_blend_equation_advanced}
  glBlendParameteriNV := dlsym(glesLibrary, 'glBlendParameteriNV');
  glBlendBarrierNV := dlsym(glesLibrary, 'glBlendBarrierNV');
{$EndIf}

{$IfDef GL_NV_clip_space_w_scaling}
  glViewportPositionWScaleNV := dlsym(glesLibrary, 'glViewportPositionWScaleNV');
{$EndIf}

{$IfDef GL_NV_conditional_render}
  glBeginConditionalRenderNV := dlsym(glesLibrary, 'glBeginConditionalRenderNV');
  glEndConditionalRenderNV := dlsym(glesLibrary, 'glEndConditionalRenderNV');
{$EndIf}

{$IfDef GL_NV_conservative_raster}
  glSubpixelPrecisionBiasNV := dlsym(glesLibrary, 'glSubpixelPrecisionBiasNV');
{$EndIf}

{$IfDef GL_NV_conservative_raster_pre_snap_triangles}
  glConservativeRasterParameteriNV := dlsym(glesLibrary, 'glConservativeRasterParameteriNV');
{$EndIf}

{$IfDef GL_NV_copy_buffer}
  glCopyBufferSubDataNV := dlsym(glesLibrary, 'glCopyBufferSubDataNV');
{$EndIf}

{$IfDef GL_NV_coverage_sample}
  glCoverageMaskNV := dlsym(glesLibrary, 'glCoverageMaskNV');
  glCoverageOperationNV := dlsym(glesLibrary, 'glCoverageOperationNV');
{$EndIf}

{$IfDef GL_NV_draw_buffers}
  glDrawBuffersNV := dlsym(glesLibrary, 'glDrawBuffersNV');
{$EndIf}

{$IfDef GL_NV_draw_instanced}
  glDrawArraysInstancedNV := dlsym(glesLibrary, 'glDrawArraysInstancedNV');
  glDrawElementsInstancedNV := dlsym(glesLibrary, 'glDrawElementsInstancedNV');
{$EndIf}

{$IfDef GL_NV_draw_vulkan_image}
  glDrawVkImageNV := dlsym(glesLibrary, 'glDrawVkImageNV');
  glGetVkProcAddrNV := dlsym(glesLibrary, 'glGetVkProcAddrNV');
  glWaitVkSemaphoreNV := dlsym(glesLibrary, 'glWaitVkSemaphoreNV');
  glSignalVkSemaphoreNV := dlsym(glesLibrary, 'glSignalVkSemaphoreNV');
  glSignalVkFenceNV := dlsym(glesLibrary, 'glSignalVkFenceNV');
{$EndIf}

{$IfDef GL_NV_fence}
  glDeleteFencesNV := dlsym(glesLibrary, 'glDeleteFencesNV');
  glGenFencesNV := dlsym(glesLibrary, 'glGenFencesNV');
  glIsFenceNV := dlsym(glesLibrary, 'glIsFenceNV');
  glTestFenceNV := dlsym(glesLibrary, 'glTestFenceNV');
  glGetFenceivNV := dlsym(glesLibrary, 'glGetFenceivNV');
  glFinishFenceNV := dlsym(glesLibrary, 'glFinishFenceNV');
  glSetFenceNV := dlsym(glesLibrary, 'glSetFenceNV');
{$EndIf}

{$IfDef GL_NV_fragment_coverage_to_color}
  glFragmentCoverageColorNV := dlsym(glesLibrary, 'glFragmentCoverageColorNV');
{$EndIf}

{$IfDef GL_NV_framebuffer_blit}
  glBlitFramebufferNV := dlsym(glesLibrary, 'glBlitFramebufferNV');
{$EndIf}

{$IfDef GL_NV_framebuffer_mixed_samples}
  glCoverageModulationTableNV := dlsym(glesLibrary, 'glCoverageModulationTableNV');
  glGetCoverageModulationTableNV := dlsym(glesLibrary, 'glGetCoverageModulationTableNV');
  glCoverageModulationNV := dlsym(glesLibrary, 'glCoverageModulationNV');
{$EndIf}

{$IfDef GL_NV_framebuffer_multisample}
  glRenderbufferStorageMultisampleNV := dlsym(glesLibrary, 'glRenderbufferStorageMultisampleNV');
{$EndIf}

{$IfDef GL_NV_gpu_shader5}
  glUniform1i64NV := dlsym(glesLibrary, 'glUniform1i64NV');
  glUniform2i64NV := dlsym(glesLibrary, 'glUniform2i64NV');
  glUniform3i64NV := dlsym(glesLibrary, 'glUniform3i64NV');
  glUniform4i64NV := dlsym(glesLibrary, 'glUniform4i64NV');
  glUniform1i64vNV := dlsym(glesLibrary, 'glUniform1i64vNV');
  glUniform2i64vNV := dlsym(glesLibrary, 'glUniform2i64vNV');
  glUniform3i64vNV := dlsym(glesLibrary, 'glUniform3i64vNV');
  glUniform4i64vNV := dlsym(glesLibrary, 'glUniform4i64vNV');
  glUniform1ui64NV := dlsym(glesLibrary, 'glUniform1ui64NV');
  glUniform2ui64NV := dlsym(glesLibrary, 'glUniform2ui64NV');
  glUniform3ui64NV := dlsym(glesLibrary, 'glUniform3ui64NV');
  glUniform4ui64NV := dlsym(glesLibrary, 'glUniform4ui64NV');
  glUniform1ui64vNV := dlsym(glesLibrary, 'glUniform1ui64vNV');
  glUniform2ui64vNV := dlsym(glesLibrary, 'glUniform2ui64vNV');
  glUniform3ui64vNV := dlsym(glesLibrary, 'glUniform3ui64vNV');
  glUniform4ui64vNV := dlsym(glesLibrary, 'glUniform4ui64vNV');
  glGetUniformi64vNV := dlsym(glesLibrary, 'glGetUniformi64vNV');
  glProgramUniform1i64NV := dlsym(glesLibrary, 'glProgramUniform1i64NV');
  glProgramUniform2i64NV := dlsym(glesLibrary, 'glProgramUniform2i64NV');
  glProgramUniform3i64NV := dlsym(glesLibrary, 'glProgramUniform3i64NV');
  glProgramUniform4i64NV := dlsym(glesLibrary, 'glProgramUniform4i64NV');
  glProgramUniform1i64vNV := dlsym(glesLibrary, 'glProgramUniform1i64vNV');
  glProgramUniform2i64vNV := dlsym(glesLibrary, 'glProgramUniform2i64vNV');
  glProgramUniform3i64vNV := dlsym(glesLibrary, 'glProgramUniform3i64vNV');
  glProgramUniform4i64vNV := dlsym(glesLibrary, 'glProgramUniform4i64vNV');
  glProgramUniform1ui64NV := dlsym(glesLibrary, 'glProgramUniform1ui64NV');
  glProgramUniform2ui64NV := dlsym(glesLibrary, 'glProgramUniform2ui64NV');
  glProgramUniform3ui64NV := dlsym(glesLibrary, 'glProgramUniform3ui64NV');
  glProgramUniform4ui64NV := dlsym(glesLibrary, 'glProgramUniform4ui64NV');
  glProgramUniform1ui64vNV := dlsym(glesLibrary, 'glProgramUniform1ui64vNV');
  glProgramUniform2ui64vNV := dlsym(glesLibrary, 'glProgramUniform2ui64vNV');
  glProgramUniform3ui64vNV := dlsym(glesLibrary, 'glProgramUniform3ui64vNV');
  glProgramUniform4ui64vNV := dlsym(glesLibrary, 'glProgramUniform4ui64vNV');
{$EndIf}

{$IfDef GL_NV_instanced_arrays}
  glVertexAttribDivisorNV := dlsym(glesLibrary, 'glVertexAttribDivisorNV');
{$EndIf}

{$IfDef GL_NV_internalformat_sample_query}
  glGetInternalformatSampleivNV := dlsym(glesLibrary, 'glGetInternalformatSampleivNV');
{$EndIf}

{$IfDef GL_NV_memory_attachment}
  glGetMemoryObjectDetachedResourcesuivNV := dlsym(glesLibrary, 'glGetMemoryObjectDetachedResourcesuivNV');
  glResetMemoryObjectParameterNV := dlsym(glesLibrary, 'glResetMemoryObjectParameterNV');
  glTexAttachMemoryNV := dlsym(glesLibrary, 'glTexAttachMemoryNV');
  glBufferAttachMemoryNV := dlsym(glesLibrary, 'glBufferAttachMemoryNV');
  glTextureAttachMemoryNV := dlsym(glesLibrary, 'glTextureAttachMemoryNV');
  glNamedBufferAttachMemoryNV := dlsym(glesLibrary, 'glNamedBufferAttachMemoryNV');
{$EndIf}

{$IfDef GL_NV_memory_object_sparse}
  glBufferPageCommitmentMemNV := dlsym(glesLibrary, 'glBufferPageCommitmentMemNV');
  glTexPageCommitmentMemNV := dlsym(glesLibrary, 'glTexPageCommitmentMemNV');
  glNamedBufferPageCommitmentMemNV := dlsym(glesLibrary, 'glNamedBufferPageCommitmentMemNV');
  glTexturePageCommitmentMemNV := dlsym(glesLibrary, 'glTexturePageCommitmentMemNV');
{$EndIf}

{$IfDef GL_NV_mesh_shader}
  glDrawMeshTasksNV := dlsym(glesLibrary, 'glDrawMeshTasksNV');
  glDrawMeshTasksIndirectNV := dlsym(glesLibrary, 'glDrawMeshTasksIndirectNV');
  glMultiDrawMeshTasksIndirectNV := dlsym(glesLibrary, 'glMultiDrawMeshTasksIndirectNV');
  glMultiDrawMeshTasksIndirectCountNV := dlsym(glesLibrary, 'glMultiDrawMeshTasksIndirectCountNV');
{$EndIf}

{$IfDef GL_NV_non_square_matrices}
  glUniformMatrix2x3fvNV := dlsym(glesLibrary, 'glUniformMatrix2x3fvNV');
  glUniformMatrix3x2fvNV := dlsym(glesLibrary, 'glUniformMatrix3x2fvNV');
  glUniformMatrix2x4fvNV := dlsym(glesLibrary, 'glUniformMatrix2x4fvNV');
  glUniformMatrix4x2fvNV := dlsym(glesLibrary, 'glUniformMatrix4x2fvNV');
  glUniformMatrix3x4fvNV := dlsym(glesLibrary, 'glUniformMatrix3x4fvNV');
  glUniformMatrix4x3fvNV := dlsym(glesLibrary, 'glUniformMatrix4x3fvNV');
{$EndIf}

{$IfDef GL_NV_path_rendering}
  glGenPathsNV := dlsym(glesLibrary, 'glGenPathsNV');
  glDeletePathsNV := dlsym(glesLibrary, 'glDeletePathsNV');
  glIsPathNV := dlsym(glesLibrary, 'glIsPathNV');
  glPathCommandsNV := dlsym(glesLibrary, 'glPathCommandsNV');
  glPathCoordsNV := dlsym(glesLibrary, 'glPathCoordsNV');
  glPathSubCommandsNV := dlsym(glesLibrary, 'glPathSubCommandsNV');
  glPathSubCoordsNV := dlsym(glesLibrary, 'glPathSubCoordsNV');
  glPathStringNV := dlsym(glesLibrary, 'glPathStringNV');
  glPathGlyphsNV := dlsym(glesLibrary, 'glPathGlyphsNV');
  glPathGlyphRangeNV := dlsym(glesLibrary, 'glPathGlyphRangeNV');
  glWeightPathsNV := dlsym(glesLibrary, 'glWeightPathsNV');
  glCopyPathNV := dlsym(glesLibrary, 'glCopyPathNV');
  glInterpolatePathsNV := dlsym(glesLibrary, 'glInterpolatePathsNV');
  glTransformPathNV := dlsym(glesLibrary, 'glTransformPathNV');
  glPathParameterivNV := dlsym(glesLibrary, 'glPathParameterivNV');
  glPathParameteriNV := dlsym(glesLibrary, 'glPathParameteriNV');
  glPathParameterfvNV := dlsym(glesLibrary, 'glPathParameterfvNV');
  glPathParameterfNV := dlsym(glesLibrary, 'glPathParameterfNV');
  glPathDashArrayNV := dlsym(glesLibrary, 'glPathDashArrayNV');
  glPathStencilFuncNV := dlsym(glesLibrary, 'glPathStencilFuncNV');
  glPathStencilDepthOffsetNV := dlsym(glesLibrary, 'glPathStencilDepthOffsetNV');
  glStencilFillPathNV := dlsym(glesLibrary, 'glStencilFillPathNV');
  glStencilStrokePathNV := dlsym(glesLibrary, 'glStencilStrokePathNV');
  glStencilFillPathInstancedNV := dlsym(glesLibrary, 'glStencilFillPathInstancedNV');
  glStencilStrokePathInstancedNV := dlsym(glesLibrary, 'glStencilStrokePathInstancedNV');
  glPathCoverDepthFuncNV := dlsym(glesLibrary, 'glPathCoverDepthFuncNV');
  glCoverFillPathNV := dlsym(glesLibrary, 'glCoverFillPathNV');
  glCoverStrokePathNV := dlsym(glesLibrary, 'glCoverStrokePathNV');
  glCoverFillPathInstancedNV := dlsym(glesLibrary, 'glCoverFillPathInstancedNV');
  glCoverStrokePathInstancedNV := dlsym(glesLibrary, 'glCoverStrokePathInstancedNV');
  glGetPathParameterivNV := dlsym(glesLibrary, 'glGetPathParameterivNV');
  glGetPathParameterfvNV := dlsym(glesLibrary, 'glGetPathParameterfvNV');
  glGetPathCommandsNV := dlsym(glesLibrary, 'glGetPathCommandsNV');
  glGetPathCoordsNV := dlsym(glesLibrary, 'glGetPathCoordsNV');
  glGetPathDashArrayNV := dlsym(glesLibrary, 'glGetPathDashArrayNV');
  glGetPathMetricsNV := dlsym(glesLibrary, 'glGetPathMetricsNV');
  glGetPathMetricRangeNV := dlsym(glesLibrary, 'glGetPathMetricRangeNV');
  glGetPathSpacingNV := dlsym(glesLibrary, 'glGetPathSpacingNV');
  glIsPointInFillPathNV := dlsym(glesLibrary, 'glIsPointInFillPathNV');
  glIsPointInStrokePathNV := dlsym(glesLibrary, 'glIsPointInStrokePathNV');
  glGetPathLengthNV := dlsym(glesLibrary, 'glGetPathLengthNV');
  glPointAlongPathNV := dlsym(glesLibrary, 'glPointAlongPathNV');
  glMatrixLoad3x2fNV := dlsym(glesLibrary, 'glMatrixLoad3x2fNV');
  glMatrixLoad3x3fNV := dlsym(glesLibrary, 'glMatrixLoad3x3fNV');
  glMatrixLoadTranspose3x3fNV := dlsym(glesLibrary, 'glMatrixLoadTranspose3x3fNV');
  glMatrixMult3x2fNV := dlsym(glesLibrary, 'glMatrixMult3x2fNV');
  glMatrixMult3x3fNV := dlsym(glesLibrary, 'glMatrixMult3x3fNV');
  glMatrixMultTranspose3x3fNV := dlsym(glesLibrary, 'glMatrixMultTranspose3x3fNV');
  glStencilThenCoverFillPathNV := dlsym(glesLibrary, 'glStencilThenCoverFillPathNV');
  glStencilThenCoverStrokePathNV := dlsym(glesLibrary, 'glStencilThenCoverStrokePathNV');
  glStencilThenCoverFillPathInstancedNV := dlsym(glesLibrary, 'glStencilThenCoverFillPathInstancedNV');
  glStencilThenCoverStrokePathInstancedNV := dlsym(glesLibrary, 'glStencilThenCoverStrokePathInstancedNV');
  glPathGlyphIndexRangeNV := dlsym(glesLibrary, 'glPathGlyphIndexRangeNV');
  glPathGlyphIndexArrayNV := dlsym(glesLibrary, 'glPathGlyphIndexArrayNV');
  glPathMemoryGlyphIndexArrayNV := dlsym(glesLibrary, 'glPathMemoryGlyphIndexArrayNV');
  glProgramPathFragmentInputGenNV := dlsym(glesLibrary, 'glProgramPathFragmentInputGenNV');
  glGetProgramResourcefvNV := dlsym(glesLibrary, 'glGetProgramResourcefvNV');
  glMatrixFrustumEXT := dlsym(glesLibrary, 'glMatrixFrustumEXT');
  glMatrixLoadIdentityEXT := dlsym(glesLibrary, 'glMatrixLoadIdentityEXT');
  glMatrixLoadTransposefEXT := dlsym(glesLibrary, 'glMatrixLoadTransposefEXT');
  glMatrixLoadTransposedEXT := dlsym(glesLibrary, 'glMatrixLoadTransposedEXT');
  glMatrixLoadfEXT := dlsym(glesLibrary, 'glMatrixLoadfEXT');
  glMatrixLoaddEXT := dlsym(glesLibrary, 'glMatrixLoaddEXT');
  glMatrixMultTransposefEXT := dlsym(glesLibrary, 'glMatrixMultTransposefEXT');
  glMatrixMultTransposedEXT := dlsym(glesLibrary, 'glMatrixMultTransposedEXT');
  glMatrixMultfEXT := dlsym(glesLibrary, 'glMatrixMultfEXT');
  glMatrixMultdEXT := dlsym(glesLibrary, 'glMatrixMultdEXT');
  glMatrixOrthoEXT := dlsym(glesLibrary, 'glMatrixOrthoEXT');
  glMatrixPopEXT := dlsym(glesLibrary, 'glMatrixPopEXT');
  glMatrixPushEXT := dlsym(glesLibrary, 'glMatrixPushEXT');
  glMatrixRotatefEXT := dlsym(glesLibrary, 'glMatrixRotatefEXT');
  glMatrixRotatedEXT := dlsym(glesLibrary, 'glMatrixRotatedEXT');
  glMatrixScalefEXT := dlsym(glesLibrary, 'glMatrixScalefEXT');
  glMatrixScaledEXT := dlsym(glesLibrary, 'glMatrixScaledEXT');
  glMatrixTranslatefEXT := dlsym(glesLibrary, 'glMatrixTranslatefEXT');
  glMatrixTranslatedEXT := dlsym(glesLibrary, 'glMatrixTranslatedEXT');
{$EndIf}

{$IfDef GL_NV_polygon_mode}
  glPolygonModeNV := dlsym(glesLibrary, 'glPolygonModeNV');
{$EndIf}

{$IfDef GL_NV_read_buffer}
  glReadBufferNV := dlsym(glesLibrary, 'glReadBufferNV');
{$EndIf}

{$IfDef GL_NV_sample_locations}
  glFramebufferSampleLocationsfvNV := dlsym(glesLibrary, 'glFramebufferSampleLocationsfvNV');
  glNamedFramebufferSampleLocationsfvNV := dlsym(glesLibrary, 'glNamedFramebufferSampleLocationsfvNV');
  glResolveDepthValuesNV := dlsym(glesLibrary, 'glResolveDepthValuesNV');
{$EndIf}

{$IfDef GL_NV_scissor_exclusive}
  glScissorExclusiveNV := dlsym(glesLibrary, 'glScissorExclusiveNV');
  glScissorExclusiveArrayvNV := dlsym(glesLibrary, 'glScissorExclusiveArrayvNV');
{$EndIf}

{$IfDef GL_NV_shading_rate_image}
  glBindShadingRateImageNV := dlsym(glesLibrary, 'glBindShadingRateImageNV');
  glGetShadingRateImagePaletteNV := dlsym(glesLibrary, 'glGetShadingRateImagePaletteNV');
  glGetShadingRateSampleLocationivNV := dlsym(glesLibrary, 'glGetShadingRateSampleLocationivNV');
  glShadingRateImageBarrierNV := dlsym(glesLibrary, 'glShadingRateImageBarrierNV');
  glShadingRateImagePaletteNV := dlsym(glesLibrary, 'glShadingRateImagePaletteNV');
  glShadingRateSampleOrderNV := dlsym(glesLibrary, 'glShadingRateSampleOrderNV');
  glShadingRateSampleOrderCustomNV := dlsym(glesLibrary, 'glShadingRateSampleOrderCustomNV');
{$EndIf}

{$IfDef GL_NV_timeline_semaphore}
  glCreateSemaphoresNV := dlsym(glesLibrary, 'glCreateSemaphoresNV');
  glSemaphoreParameterivNV := dlsym(glesLibrary, 'glSemaphoreParameterivNV');
  glGetSemaphoreParameterivNV := dlsym(glesLibrary, 'glGetSemaphoreParameterivNV');
{$EndIf}

{$IfDef GL_NV_viewport_array}
  glViewportArrayvNV := dlsym(glesLibrary, 'glViewportArrayvNV');
  glViewportIndexedfNV := dlsym(glesLibrary, 'glViewportIndexedfNV');
  glViewportIndexedfvNV := dlsym(glesLibrary, 'glViewportIndexedfvNV');
  glScissorArrayvNV := dlsym(glesLibrary, 'glScissorArrayvNV');
  glScissorIndexedNV := dlsym(glesLibrary, 'glScissorIndexedNV');
  glScissorIndexedvNV := dlsym(glesLibrary, 'glScissorIndexedvNV');
  glDepthRangeArrayfvNV := dlsym(glesLibrary, 'glDepthRangeArrayfvNV');
  glDepthRangeIndexedfNV := dlsym(glesLibrary, 'glDepthRangeIndexedfNV');
  glGetFloati_vNV := dlsym(glesLibrary, 'glGetFloati_vNV');
  glEnableiNV := dlsym(glesLibrary, 'glEnableiNV');
  glDisableiNV := dlsym(glesLibrary, 'glDisableiNV');
  glIsEnablediNV := dlsym(glesLibrary, 'glIsEnablediNV');
{$EndIf}

{$IfDef GL_NV_viewport_swizzle}
  glViewportSwizzleNV := dlsym(glesLibrary, 'glViewportSwizzleNV');
{$EndIf}

{$IfDef GL_OVR_multiview}
  glFramebufferTextureMultiviewOVR := dlsym(glesLibrary, 'glFramebufferTextureMultiviewOVR');
{$EndIf}

{$IfDef GL_OVR_multiview_multisampled_render_to_texture}
  glFramebufferTextureMultisampleMultiviewOVR := dlsym(glesLibrary, 'glFramebufferTextureMultisampleMultiviewOVR');
{$EndIf}

{$IfDef GL_QCOM_alpha_test}
  glAlphaFuncQCOM := dlsym(glesLibrary, 'glAlphaFuncQCOM');
{$EndIf}

{$IfDef GL_QCOM_driver_control}
  glGetDriverControlsQCOM := dlsym(glesLibrary, 'glGetDriverControlsQCOM');
  glGetDriverControlStringQCOM := dlsym(glesLibrary, 'glGetDriverControlStringQCOM');
  glEnableDriverControlQCOM := dlsym(glesLibrary, 'glEnableDriverControlQCOM');
  glDisableDriverControlQCOM := dlsym(glesLibrary, 'glDisableDriverControlQCOM');
{$EndIf}

{$IfDef GL_QCOM_extended_get}
  glExtGetTexturesQCOM := dlsym(glesLibrary, 'glExtGetTexturesQCOM');
  glExtGetBuffersQCOM := dlsym(glesLibrary, 'glExtGetBuffersQCOM');
  glExtGetRenderbuffersQCOM := dlsym(glesLibrary, 'glExtGetRenderbuffersQCOM');
  glExtGetFramebuffersQCOM := dlsym(glesLibrary, 'glExtGetFramebuffersQCOM');
  glExtGetTexLevelParameterivQCOM := dlsym(glesLibrary, 'glExtGetTexLevelParameterivQCOM');
  glExtTexObjectStateOverrideiQCOM := dlsym(glesLibrary, 'glExtTexObjectStateOverrideiQCOM');
  glExtGetTexSubImageQCOM := dlsym(glesLibrary, 'glExtGetTexSubImageQCOM');
  glExtGetBufferPointervQCOM := dlsym(glesLibrary, 'glExtGetBufferPointervQCOM');
{$EndIf}

{$IfDef GL_QCOM_extended_get2}
  glExtGetShadersQCOM := dlsym(glesLibrary, 'glExtGetShadersQCOM');
  glExtGetProgramsQCOM := dlsym(glesLibrary, 'glExtGetProgramsQCOM');
  glExtIsProgramBinaryQCOM := dlsym(glesLibrary, 'glExtIsProgramBinaryQCOM');
  glExtGetProgramBinarySourceQCOM := dlsym(glesLibrary, 'glExtGetProgramBinarySourceQCOM');
{$EndIf}

{$IfDef GL_QCOM_frame_extrapolation}
  glExtrapolateTex2DQCOM := dlsym(glesLibrary, 'glExtrapolateTex2DQCOM');
{$EndIf}

{$IfDef GL_QCOM_framebuffer_foveated}
  glFramebufferFoveationConfigQCOM := dlsym(glesLibrary, 'glFramebufferFoveationConfigQCOM');
  glFramebufferFoveationParametersQCOM := dlsym(glesLibrary, 'glFramebufferFoveationParametersQCOM');
{$EndIf}

{$IfDef GL_QCOM_motion_estimation}
  glTexEstimateMotionQCOM := dlsym(glesLibrary, 'glTexEstimateMotionQCOM');
  glTexEstimateMotionRegionsQCOM := dlsym(glesLibrary, 'glTexEstimateMotionRegionsQCOM');
{$EndIf}

{$IfDef GL_QCOM_shader_framebuffer_fetch_noncoherent}
  glFramebufferFetchBarrierQCOM := dlsym(glesLibrary, 'glFramebufferFetchBarrierQCOM');
{$EndIf}

{$IfDef GL_QCOM_shading_rate}
  glShadingRateQCOM := dlsym(glesLibrary, 'glShadingRateQCOM');
{$EndIf}

{$IfDef GL_QCOM_texture_foveated}
  glTextureFoveationParametersQCOM := dlsym(glesLibrary, 'glTextureFoveationParametersQCOM');
{$EndIf}

{$IfDef GL_QCOM_tiled_rendering}
  glStartTilingQCOM := dlsym(glesLibrary, 'glStartTilingQCOM');
  glEndTilingQCOM := dlsym(glesLibrary, 'glEndTilingQCOM');
{$EndIf}

{$IfDef GL_ES_VERSION_3_0}
// GL_NV_read_buffer
  glReadBuffer := dlsym(glesLibrary, 'glReadBuffer');
// none
  glDrawRangeElements := dlsym(glesLibrary, 'glDrawRangeElements');
// GL_OES_texture_3D
  glTexImage3D := dlsym(glesLibrary, 'glTexImage3D');
  glTexSubImage3D := dlsym(glesLibrary, 'glTexSubImage3D');
  glCopyTexSubImage3D := dlsym(glesLibrary, 'glCopyTexSubImage3D');
  glCompressedTexImage3D := dlsym(glesLibrary, 'glCompressedTexImage3D');
  glCompressedTexSubImage3D := dlsym(glesLibrary, 'glCompressedTexSubImage3D');
// GL_EXT_disjoint_timer_query
  glGenQueries := dlsym(glesLibrary, 'glGenQueries');
  glDeleteQueries := dlsym(glesLibrary, 'glDeleteQueries');
  glIsQuery := dlsym(glesLibrary, 'glIsQuery');
  glBeginQuery := dlsym(glesLibrary, 'glBeginQuery');
  glEndQuery := dlsym(glesLibrary, 'glEndQuery');
  glGetQueryiv := dlsym(glesLibrary, 'glGetQueryiv');
  glGetQueryObjectuiv := dlsym(glesLibrary, 'glGetQueryObjectuiv');
// GL_OES_mapbuffer
  glUnmapBuffer := dlsym(glesLibrary, 'glUnmapBuffer');
  glGetBufferPointerv := dlsym(glesLibrary, 'glGetBufferPointerv');
// GL_EXT_draw_buffers + GL_NV_draw_buffers
  glDrawBuffers := dlsym(glesLibrary, 'glDrawBuffers');
// GL_NV_non_square_matrices
  glUniformMatrix2x3fv := dlsym(glesLibrary, 'glUniformMatrix2x3fv');
  glUniformMatrix3x2fv := dlsym(glesLibrary, 'glUniformMatrix3x2fv');
  glUniformMatrix2x4fv := dlsym(glesLibrary, 'glUniformMatrix2x4fv');
  glUniformMatrix4x2fv := dlsym(glesLibrary, 'glUniformMatrix4x2fv');
  glUniformMatrix3x4fv := dlsym(glesLibrary, 'glUniformMatrix3x4fv');
  glUniformMatrix4x3fv := dlsym(glesLibrary, 'glUniformMatrix4x3fv');
// GL_ANGLE_framebuffer_blit + GL_NV_framebuffer_blit
  glBlitFramebuffer := dlsym(glesLibrary, 'glBlitFramebuffer');
// GL_ANGLE_framebuffer_multisample + GL_APPLE_framebuffer_multisample + GL_EXT_multisampled_render_to_texture +
//                                  GL_IMG_multisampled_render_to_texture + GL_NV_framebuffer_multisample
  glRenderbufferStorageMultisample := dlsym(glesLibrary, 'glRenderbufferStorageMultisample');
// none
  glFramebufferTextureLayer := dlsym(glesLibrary, 'glFramebufferTextureLayer');
// GL_EXT_map_buffer_range
  glMapBufferRange := dlsym(glesLibrary, 'glMapBufferRange');
  glFlushMappedBufferRange := dlsym(glesLibrary, 'glFlushMappedBufferRange');
// GL_OES_vertex_array_object
  glBindVertexArray := dlsym(glesLibrary, 'glBindVertexArray');
  glDeleteVertexArrays := dlsym(glesLibrary, 'glDeleteVertexArrays');
  glGenVertexArrays := dlsym(glesLibrary, 'glGenVertexArrays');
  glIsVertexArray := dlsym(glesLibrary, 'glIsVertexArray');
// GL_EXT_multiview_draw_buffers
  glGetIntegeri_v := dlsym(glesLibrary, 'glGetIntegeri_v');
// none
  glBeginTransformFeedback := dlsym(glesLibrary, 'glBeginTransformFeedback');
  glEndTransformFeedback := dlsym(glesLibrary, 'glEndTransformFeedback');
  glBindBufferRange := dlsym(glesLibrary, 'glBindBufferRange');
  glBindBufferBase := dlsym(glesLibrary, 'glBindBufferBase');
  glTransformFeedbackVaryings := dlsym(glesLibrary, 'glTransformFeedbackVaryings');
  glGetTransformFeedbackVarying := dlsym(glesLibrary, 'glGetTransformFeedbackVarying');
  glVertexAttribIPointer := dlsym(glesLibrary, 'glVertexAttribIPointer');
  glGetVertexAttribIiv := dlsym(glesLibrary, 'glGetVertexAttribIiv');
  glGetVertexAttribIuiv := dlsym(glesLibrary, 'glGetVertexAttribIuiv');
  glVertexAttribI4i := dlsym(glesLibrary, 'glVertexAttribI4i');
  glVertexAttribI4ui := dlsym(glesLibrary, 'glVertexAttribI4ui');
  glVertexAttribI4iv := dlsym(glesLibrary, 'glVertexAttribI4iv');
  glVertexAttribI4uiv := dlsym(glesLibrary, 'glVertexAttribI4uiv');
  glGetUniformuiv := dlsym(glesLibrary, 'glGetUniformuiv');
  glGetFragDataLocation := dlsym(glesLibrary, 'glGetFragDataLocation');
  glUniform1ui := dlsym(glesLibrary, 'glUniform1ui');
  glUniform2ui := dlsym(glesLibrary, 'glUniform2ui');
  glUniform3ui := dlsym(glesLibrary, 'glUniform3ui');
  glUniform4ui := dlsym(glesLibrary, 'glUniform4ui');
  glUniform1uiv := dlsym(glesLibrary, 'glUniform1uiv');
  glUniform2uiv := dlsym(glesLibrary, 'glUniform2uiv');
  glUniform3uiv := dlsym(glesLibrary, 'glUniform3uiv');
  glUniform4uiv := dlsym(glesLibrary, 'glUniform4uiv');
  glClearBufferiv := dlsym(glesLibrary, 'glClearBufferiv');
  glClearBufferuiv := dlsym(glesLibrary, 'glClearBufferuiv');
  glClearBufferfv := dlsym(glesLibrary, 'glClearBufferfv');
  glClearBufferfi := dlsym(glesLibrary, 'glClearBufferfi');
  glGetStringi := dlsym(glesLibrary, 'glGetStringi');
// GL_NV_copy_buffer
  glCopyBufferSubData := dlsym(glesLibrary, 'glCopyBufferSubData');
// none
  glGetUniformIndices := dlsym(glesLibrary, 'glGetUniformIndices');
  glGetActiveUniformsiv := dlsym(glesLibrary, 'glGetActiveUniformsiv');
  glGetUniformBlockIndex := dlsym(glesLibrary, 'glGetUniformBlockIndex');
  glGetActiveUniformBlockiv := dlsym(glesLibrary, 'glGetActiveUniformBlockiv');
  glGetActiveUniformBlockName := dlsym(glesLibrary, 'glGetActiveUniformBlockName');
  glUniformBlockBinding := dlsym(glesLibrary, 'glUniformBlockBinding');
// GL_ANGLE_instanced_arrays            GL_EXT_draw_instanced              GL_NV_draw_instanced
  glDrawArraysInstanced := dlsym(glesLibrary, 'glDrawArraysInstanced');
  glDrawElementsInstanced := dlsym(glesLibrary, 'glDrawElementsInstanced');
// GL_APPLE_sync
  glFenceSync := dlsym(glesLibrary, 'glFenceSync');
  glIsSync := dlsym(glesLibrary, 'glIsSync');
  glDeleteSync := dlsym(glesLibrary, 'glDeleteSync');
  glClientWaitSync := dlsym(glesLibrary, 'glClientWaitSync');
  glWaitSync := dlsym(glesLibrary, 'glWaitSync');
// GL_APPLE_sync                        GL_EXT_disjoint_timer_query
  glGetInteger64v := dlsym(glesLibrary, 'glGetInteger64v');
// GL_APPLE_sync
  glGetSynciv := dlsym(glesLibrary, 'glGetSynciv');
// none
  glGetInteger64i_v := dlsym(glesLibrary, 'glGetInteger64i_v');
  glGetBufferParameteri64v := dlsym(glesLibrary, 'glGetBufferParameteri64v');
  glGenSamplers := dlsym(glesLibrary, 'glGenSamplers');
  glDeleteSamplers := dlsym(glesLibrary, 'glDeleteSamplers');
  glIsSampler := dlsym(glesLibrary, 'glIsSampler');
  glBindSampler := dlsym(glesLibrary, 'glBindSampler');
  glSamplerParameteri := dlsym(glesLibrary, 'glSamplerParameteri');
  glSamplerParameteriv := dlsym(glesLibrary, 'glSamplerParameteriv');
  glSamplerParameterf := dlsym(glesLibrary, 'glSamplerParameterf');
  glSamplerParameterfv := dlsym(glesLibrary, 'glSamplerParameterfv');
  glGetSamplerParameteriv := dlsym(glesLibrary, 'glGetSamplerParameteriv');
  glGetSamplerParameterfv := dlsym(glesLibrary, 'glGetSamplerParameterfv');
// GL_ANGLE_instanced_arrays            GL_EXT_instanced_arrays       GL_NV_instanced_arrays
  glVertexAttribDivisor := dlsym(glesLibrary, 'glVertexAttribDivisor');
// none
  glBindTransformFeedback := dlsym(glesLibrary, 'glBindTransformFeedback');
  glDeleteTransformFeedbacks := dlsym(glesLibrary, 'glDeleteTransformFeedbacks');
  glGenTransformFeedbacks := dlsym(glesLibrary, 'glGenTransformFeedbacks');
  glIsTransformFeedback := dlsym(glesLibrary, 'glIsTransformFeedback');
  glPauseTransformFeedback := dlsym(glesLibrary, 'glPauseTransformFeedback');
  glResumeTransformFeedback := dlsym(glesLibrary, 'glResumeTransformFeedback');
// GL_OES_get_program_binary
  glGetProgramBinary := dlsym(glesLibrary, 'glGetProgramBinary');
  glProgramBinary := dlsym(glesLibrary, 'glProgramBinary');
// GL_EXT_separate_shader_objects
  glProgramParameteri := dlsym(glesLibrary, 'glProgramParameteri');
// none
  glInvalidateFramebuffer := dlsym(glesLibrary, 'glInvalidateFramebuffer');
  glInvalidateSubFramebuffer := dlsym(glesLibrary, 'glInvalidateSubFramebuffer');
// GL_EXT_texture_storage
  glTexStorage2D := dlsym(glesLibrary, 'glTexStorage2D');
  glTexStorage3D := dlsym(glesLibrary, 'glTexStorage3D');
// none
  glGetInternalformativ := dlsym(glesLibrary, 'glGetInternalformativ');
{$EndIf}

{$IfDef GL_ES_VERSION_3_1}
// none
  glDispatchCompute := dlsym(glesLibrary, 'glDispatchCompute');
  glDispatchComputeIndirect := dlsym(glesLibrary, 'glDispatchComputeIndirect');
  glDrawArraysIndirect := dlsym(glesLibrary, 'glDrawArraysIndirect');
  glDrawElementsIndirect := dlsym(glesLibrary, 'glDrawElementsIndirect');
// GL_MESA_framebuffer_flip_y
  glFramebufferParameteri := dlsym(glesLibrary, 'glFramebufferParameteri');
  glGetFramebufferParameteriv := dlsym(glesLibrary, 'glGetFramebufferParameteriv');
// none
  glGetProgramInterfaceiv := dlsym(glesLibrary, 'glGetProgramInterfaceiv');
  glGetProgramResourceIndex := dlsym(glesLibrary, 'glGetProgramResourceIndex');
  glGetProgramResourceName := dlsym(glesLibrary, 'glGetProgramResourceName');
  glGetProgramResourceiv := dlsym(glesLibrary, 'glGetProgramResourceiv');
  glGetProgramResourceLocation := dlsym(glesLibrary, 'glGetProgramResourceLocation');
// GL_EXT_separate_shader_objects
  glUseProgramStages := dlsym(glesLibrary, 'glUseProgramStages');
  glActiveShaderProgram := dlsym(glesLibrary, 'glActiveShaderProgram');
  glCreateShaderProgramv := dlsym(glesLibrary, 'glCreateShaderProgramv');
  glBindProgramPipeline := dlsym(glesLibrary, 'glBindProgramPipeline');
  glDeleteProgramPipelines := dlsym(glesLibrary, 'glDeleteProgramPipelines');
  glGenProgramPipelines := dlsym(glesLibrary, 'glGenProgramPipelines');
  glIsProgramPipeline := dlsym(glesLibrary, 'glIsProgramPipeline');
  glGetProgramPipelineiv := dlsym(glesLibrary, 'glGetProgramPipelineiv');
  glProgramUniform1i := dlsym(glesLibrary, 'glProgramUniform1i');
  glProgramUniform2i := dlsym(glesLibrary, 'glProgramUniform2i');
  glProgramUniform3i := dlsym(glesLibrary, 'glProgramUniform3i');
  glProgramUniform4i := dlsym(glesLibrary, 'glProgramUniform4i');
  glProgramUniform1ui := dlsym(glesLibrary, 'glProgramUniform1ui');
  glProgramUniform2ui := dlsym(glesLibrary, 'glProgramUniform2ui');
  glProgramUniform3ui := dlsym(glesLibrary, 'glProgramUniform3ui');
  glProgramUniform4ui := dlsym(glesLibrary, 'glProgramUniform4ui');
  glProgramUniform1f := dlsym(glesLibrary, 'glProgramUniform1f');
  glProgramUniform2f := dlsym(glesLibrary, 'glProgramUniform2f');
  glProgramUniform3f := dlsym(glesLibrary, 'glProgramUniform3f');
  glProgramUniform4f := dlsym(glesLibrary, 'glProgramUniform4f');
  glProgramUniform1iv := dlsym(glesLibrary, 'glProgramUniform1iv');
  glProgramUniform2iv := dlsym(glesLibrary, 'glProgramUniform2iv');
  glProgramUniform3iv := dlsym(glesLibrary, 'glProgramUniform3iv');
  glProgramUniform4iv := dlsym(glesLibrary, 'glProgramUniform4iv');
  glProgramUniform1uiv := dlsym(glesLibrary, 'glProgramUniform1uiv');
  glProgramUniform2uiv := dlsym(glesLibrary, 'glProgramUniform2uiv');
  glProgramUniform3uiv := dlsym(glesLibrary, 'glProgramUniform3uiv');
  glProgramUniform4uiv := dlsym(glesLibrary, 'glProgramUniform4uiv');
  glProgramUniform1fv := dlsym(glesLibrary, 'glProgramUniform1fv');
  glProgramUniform2fv := dlsym(glesLibrary, 'glProgramUniform2fv');
  glProgramUniform3fv := dlsym(glesLibrary, 'glProgramUniform3fv');
  glProgramUniform4fv := dlsym(glesLibrary, 'glProgramUniform4fv');
  glProgramUniformMatrix2fv := dlsym(glesLibrary, 'glProgramUniformMatrix2fv');
  glProgramUniformMatrix3fv := dlsym(glesLibrary, 'glProgramUniformMatrix3fv');
  glProgramUniformMatrix4fv := dlsym(glesLibrary, 'glProgramUniformMatrix4fv');
  glProgramUniformMatrix2x3fv := dlsym(glesLibrary, 'glProgramUniformMatrix2x3fv');
  glProgramUniformMatrix3x2fv := dlsym(glesLibrary, 'glProgramUniformMatrix3x2fv');
  glProgramUniformMatrix2x4fv := dlsym(glesLibrary, 'glProgramUniformMatrix2x4fv');
  glProgramUniformMatrix4x2fv := dlsym(glesLibrary, 'glProgramUniformMatrix4x2fv');
  glProgramUniformMatrix3x4fv := dlsym(glesLibrary, 'glProgramUniformMatrix3x4fv');
  glProgramUniformMatrix4x3fv := dlsym(glesLibrary, 'glProgramUniformMatrix4x3fv');
  glValidateProgramPipeline := dlsym(glesLibrary, 'glValidateProgramPipeline');
  glGetProgramPipelineInfoLog := dlsym(glesLibrary, 'glGetProgramPipelineInfoLog');
// none
  glBindImageTexture := dlsym(glesLibrary, 'glBindImageTexture');
  glGetBooleani_v := dlsym(glesLibrary, 'glGetBooleani_v');
  glMemoryBarrier := dlsym(glesLibrary, 'glMemoryBarrier');
  glMemoryBarrierByRegion := dlsym(glesLibrary, 'glMemoryBarrierByRegion');
  glTexStorage2DMultisample := dlsym(glesLibrary, 'glTexStorage2DMultisample');
  glGetMultisamplefv := dlsym(glesLibrary, 'glGetMultisamplefv');
  glSampleMaski := dlsym(glesLibrary, 'glSampleMaski');
  glGetTexLevelParameteriv := dlsym(glesLibrary, 'glGetTexLevelParameteriv');
  glGetTexLevelParameterfv := dlsym(glesLibrary, 'glGetTexLevelParameterfv');
  glBindVertexBuffer := dlsym(glesLibrary, 'glBindVertexBuffer');
  glVertexAttribFormat := dlsym(glesLibrary, 'glVertexAttribFormat');
  glVertexAttribIFormat := dlsym(glesLibrary, 'glVertexAttribIFormat');
  glVertexAttribBinding := dlsym(glesLibrary, 'glVertexAttribBinding');
  glVertexBindingDivisor := dlsym(glesLibrary, 'glVertexBindingDivisor');
{$EndIf}

{$IfDef GL_ES_VERSION_3_2}
// GL_KHR_blend_equation_advanced        GL_NV_blend_equation_advanced
  glBlendBarrier := dlsym(glesLibrary, 'glBlendBarrier');
// GL_OES_copy_image                     GL_EXT_copy_image
  glCopyImageSubData := dlsym(glesLibrary, 'glCopyImageSubData');
// GL_KHR_debug
  glDebugMessageControl := dlsym(glesLibrary, 'glDebugMessageControl');
  glDebugMessageInsert := dlsym(glesLibrary, 'glDebugMessageInsert');
  glDebugMessageCallback := dlsym(glesLibrary, 'glDebugMessageCallback');
  glGetDebugMessageLog := dlsym(glesLibrary, 'glGetDebugMessageLog');
  glPushDebugGroup := dlsym(glesLibrary, 'glPushDebugGroup');
  glPopDebugGroup := dlsym(glesLibrary, 'glPopDebugGroup');
  glObjectLabel := dlsym(glesLibrary, 'glObjectLabel');
// GL_KHR_debug                          GL_EXT_debug_label
  glGetObjectLabel := dlsym(glesLibrary, 'glGetObjectLabel');
// GL_KHR_debug
  glObjectPtrLabel := dlsym(glesLibrary, 'glObjectPtrLabel');
  glGetObjectPtrLabel := dlsym(glesLibrary, 'glGetObjectPtrLabel');
  glGetPointerv := dlsym(glesLibrary, 'glGetPointerv');
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glEnablei := dlsym(glesLibrary, 'glEnablei');
  glDisablei := dlsym(glesLibrary, 'glDisablei');
// GL_OES_draw_buffers_indexed
  glBlendEquationi := dlsym(glesLibrary, 'glBlendEquationi');
  glBlendEquationSeparatei := dlsym(glesLibrary, 'glBlendEquationSeparatei');
  glBlendFunci := dlsym(glesLibrary, 'glBlendFunci');
  glBlendFuncSeparatei := dlsym(glesLibrary, 'glBlendFuncSeparatei');
  glColorMaski := dlsym(glesLibrary, 'glColorMaski');
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glIsEnabledi := dlsym(glesLibrary, 'glIsEnabledi');
// GL_OES_draw_elements_base_vertex      GL_EXT_draw_elements_base_vertex
  glDrawElementsBaseVertex := dlsym(glesLibrary, 'glDrawElementsBaseVertex');
  glDrawRangeElementsBaseVertex := dlsym(glesLibrary, 'glDrawRangeElementsBaseVertex');
  glDrawElementsInstancedBaseVertex := dlsym(glesLibrary, 'glDrawElementsInstancedBaseVertex');
// GL_OES_geometry_shader                GL_EXT_geometry_shader
  glFramebufferTexture := dlsym(glesLibrary, 'glFramebufferTexture');
// GL_OES_primitive_bounding_box         GL_EXT_primitive_bounding_box
  glPrimitiveBoundingBox := dlsym(glesLibrary, 'glPrimitiveBoundingBox');
// GL_KHR_robustness                     GL_EXT_robustness
  glGetGraphicsResetStatus := dlsym(glesLibrary, 'glGetGraphicsResetStatus');
  glReadnPixels := dlsym(glesLibrary, 'glReadnPixels');
  glGetnUniformfv := dlsym(glesLibrary, 'glGetnUniformfv');
  glGetnUniformiv := dlsym(glesLibrary, 'glGetnUniformiv');
// GL_KHR_robustness
  glGetnUniformuiv := dlsym(glesLibrary, 'glGetnUniformuiv');
// GL_OES_sample_shading
  glMinSampleShading := dlsym(glesLibrary, 'glMinSampleShading');
// GL_OES_tessellation_shader            GL_EXT_tessellation_shader
  glPatchParameteri := dlsym(glesLibrary, 'glPatchParameteri');
// GL_OES_texture_border_clamp           GL_EXT_texture_border_clamp
  glTexParameterIiv := dlsym(glesLibrary, 'glTexParameterIiv');
  glTexParameterIuiv := dlsym(glesLibrary, 'glTexParameterIuiv');
  glGetTexParameterIiv := dlsym(glesLibrary, 'glGetTexParameterIiv');
  glGetTexParameterIuiv := dlsym(glesLibrary, 'glGetTexParameterIuiv');
  glSamplerParameterIiv := dlsym(glesLibrary, 'glSamplerParameterIiv');
  glSamplerParameterIuiv := dlsym(glesLibrary, 'glSamplerParameterIuiv');
  glGetSamplerParameterIiv := dlsym(glesLibrary, 'glGetSamplerParameterIiv');
  glGetSamplerParameterIuiv := dlsym(glesLibrary, 'glGetSamplerParameterIuiv');
// GL_OES_texture_buffer                 GL_EXT_texture_buffer
  glTexBuffer := dlsym(glesLibrary, 'glTexBuffer');
  glTexBufferRange := dlsym(glesLibrary, 'glTexBufferRange');
// GL_OES_texture_storage_multisample_2d_array
  glTexStorage3DMultisample := dlsym(glesLibrary, 'glTexStorage3DMultisample');
{$EndIf}
end;

procedure FreeOpenGLES;
begin
  {$IfDef GL_VERSION_ES_CM_1_0}
// min GLES function - glAlphaFunc := nil;
// min GLES function - glClearColor := nil;
// min GLES function - glClearDepthf := nil;
  glClipPlanef := nil;
// min GLES function - glColor4f := nil;
  glDepthRangef := nil;
  glFogf := nil;
  glFogfv := nil;
  glFrustumf := nil;
  glGetClipPlanef := nil;
// min GLES function - glGetFloatv := nil;
  glGetLightfv := nil;
  glGetMaterialfv := nil;
  glGetTexEnvfv := nil;
  glGetTexParameterfv := nil;
  glLightModelf := nil;
  glLightModelfv := nil;
  glLightf := nil;
  glLightfv := nil;
  glLineWidth := nil;
// min GLES function - glLoadMatrixf := nil;
  glMaterialf := nil;
  glMaterialfv := nil;
  glMultMatrixf := nil;
  glMultiTexCoord4f := nil;
  glNormal3f := nil;
// min GLES function - glOrthof := nil;
  glPointParameterf := nil;
  glPointParameterfv := nil;
  glPointSize := nil;
  glPolygonOffset := nil;
// min GLES function - glRotatef := nil;
// min GLES function - glScalef := nil;
  glTexEnvf := nil;
  glTexEnvfv := nil;
// min GLES function - glTexParameterf := nil;
  glTexParameterfv := nil;
// min GLES function - glTranslatef := nil;
  glActiveTexture := nil;
  glAlphaFuncx := nil;
  glBindBuffer := nil;
// min GLES function - glBindTexture := nil;
// min GLES function - glBlendFunc := nil;
  glBufferData := nil;
  glBufferSubData := nil;
// min GLES function - glClear := nil;
  glClearColorx := nil;
  glClearDepthx := nil;
  glClearStencil := nil;
  glClientActiveTexture := nil;
  glClipPlanex := nil;
  glColor4ub := nil;
  glColor4x := nil;
// min GLES function - glColorMask := nil;
// min GLES function - glColorPointer := nil;
// min GLES function - glCompressedTexImage2D := nil;
// min GLES function - glCompressedTexSubImage2D := nil;
  glCopyTexImage2D := nil;
// min GLES function - glCopyTexSubImage2D := nil;
  glCullFace := nil;
  glDeleteBuffers := nil;
// min GLES function - glDeleteTextures := nil;
// min GLES function - glDepthFunc := nil;
// min GLES function - glDepthMask := nil;
  glDepthRangex := nil;
// min GLES function - glDisable := nil;
// min GLES function - glDisableClientState := nil;
// min GLES function - glDrawArrays := nil;
// min GLES function - glDrawElements := nil;
// min GLES function - glEnable := nil;
// min GLES function - glEnableClientState := nil;
  glFinish := nil;
  glFlush := nil;
  glFogx := nil;
  glFogxv := nil;
  glFrontFace := nil;
  glFrustumx := nil;
  glGetBooleanv := nil;
  glGetBufferParameteriv := nil;
  glGetClipPlanex := nil;
  glGenBuffers := nil;
// min GLES function - glGenTextures := nil;
  glGetError := nil;
  glGetFixedv := nil;
// min GLES function - nil;
  glGetLightxv := nil;
  glGetMaterialxv := nil;
  glGetPointerv := nil;
// min GLES function - glGetString := nil;
  glGetTexEnviv := nil;
  glGetTexEnvxv := nil;
  glGetTexParameteriv := nil;
  glGetTexParameterxv := nil;
// min GLES function - glHint := nil;
  glIsBuffer := nil;
  glIsEnabled := nil;
  glIsTexture := nil;
  glLightModelx := nil;
  glLightModelxv := nil;
  glLightx := nil;
  glLightxv := nil;
  glLineWidthx := nil;
// min GLES function - glLoadIdentity := nil;
  glLoadMatrixx := nil;
  glLogicOp := nil;
  glMaterialx := nil;
  glMaterialxv := nil;
// min GLES function - glMatrixMode := nil;
  glMultMatrixx := nil;
  glMultiTexCoord4x := nil;
  glNormal3x := nil;
  glNormalPointer := nil;
  glOrthox := nil;
// min GLES function - glPixelStorei := nil;
  glPointParameterx := nil;
  glPointParameterxv := nil;
  glPointSizex := nil;
  glPolygonOffsetx := nil;
// min GLES function - glPopMatrix := nil;
// min GLES function - glPushMatrix := nil;
// min GLES function - glReadPixels := nil;
  glRotatex := nil;
  glSampleCoverage := nil;
  glSampleCoveragex := nil;
  glScalex := nil;
// min GLES function - glScissor := nil;
// min GLES function - glShadeModel := nil;
  glStencilFunc := nil;
  glStencilMask := nil;
  glStencilOp := nil;
// min GLES function - glTexCoordPointer := nil;
// min GLES function - glTexEnvi := nil;
// min GLES function - glTexEnvx := nil;
// min GLES function - glTexEnviv := nil;
// min GLES function - glTexEnvxv := nil;
// min GLES function - glTexImage2D := nil;
// min GLES function - glTexParameteri := nil;
// min GLES function - glTexParameterx := nil;
// min GLES function - glTexParameteriv := nil;
// min GLES function - glTexParameterxv := nil;
// min GLES function - glTexSubImage2D := nil;
  glTranslatex := nil;
// min GLES function - glVertexPointer := nil;
// min GLES function - glViewport := nil;

  {$IfDef GL_OES_point_size_array}
  glPointSizePointerOES := nil;
  {$EndIf}

  {$IfDef GL_OES_blend_equation_separate}
  glBlendEquationSeparateOES := nil;
  {$EndIf}

  {$IfDef GL_OES_blend_func_separate}
  // min GLES function - glBlendFuncSeparateOES := nil;
  {$EndIf}

  {$IfDef GL_OES_blend_subtract}
  glBlendEquationOES := nil;
  {$EndIf}

  {$IfDef GL_OES_draw_texture}
  glDrawTexsOES := nil;
  glDrawTexiOES := nil;
  glDrawTexxOES := nil;
  glDrawTexsvOES := nil;
  glDrawTexivOES := nil;
  glDrawTexxvOES := nil;
  glDrawTexfOES := nil;
  glDrawTexfvOES := nil;
  {$EndIf}

  {$IfDef GL_OES_fixed_point}
  glAlphaFuncxOES := nil;
  glClearColorxOES := nil;
  glClearDepthxOES := nil;
  glClipPlanexOES := nil;
  glColor4xOES := nil;
  glDepthRangexOES := nil;
  glFogxOES := nil;
  glFogxvOES := nil;
  glFrustumxOES := nil;
  glGetClipPlanexOES := nil;
  glGetFixedvOES := nil;
  glGetTexEnvxvOES := nil;
  glGetTexParameterxvOES := nil;
  glLightModelxOES := nil;
  glLightModelxvOES := nil;
  glLightxOES := nil;
  glLightxvOES := nil;
  glLineWidthxOES := nil;
  glLoadMatrixxOES := nil;
  glMaterialxOES := nil;
  glMaterialxvOES := nil;
  glMultMatrixxOES := nil;
  glMultiTexCoord4xOES := nil;
  glNormal3xOES := nil;
  glOrthoxOES := nil;
  glPointParameterxvOES := nil;
  glPointSizexOES := nil;
  glPolygonOffsetxOES := nil;
  glRotatexOES := nil;
  glScalexOES := nil;
  glTexEnvxOES := nil;
  glTexEnvxvOES := nil;
  glTexParameterxOES := nil;
  glTexParameterxvOES := nil;
  glTranslatexOES := nil;
  glGetLightxvOES := nil;
  glGetMaterialxvOES := nil;
  glPointParameterxOES := nil;
  glSampleCoveragexOES := nil;
  glGetTexGenxvOES := nil;
  glTexGenxOES := nil;
  glTexGenxvOES := nil;
  {$EndIf}

  {$IfDef GL_OES_framebuffer_object}
// min GLES function - glIsRenderbufferOES := nil;
// min GLES function - glBindRenderbufferOES := nil;
// min GLES function - glDeleteRenderbuffersOES := nil;
// min GLES function - glGenRenderbuffersOES := nil;
// min GLES function - glRenderbufferStorageOES := nil;
// min GLES function - glGetRenderbufferParameterivOES := nil;
// min GLES function - glIsFramebufferOES := nil;
// min GLES function - glBindFramebufferOES := nil;
// min GLES function - glDeleteFramebuffersOES := nil;
// min GLES function - glGenFramebuffersOES := nil;
// min GLES function - glCheckFramebufferStatusOES := nil;
// min GLES function - glFramebufferRenderbufferOES := nil;
// min GLES function - glFramebufferTexture2DOES := nil;
// min GLES function - glGetFramebufferAttachmentParameterivOES := nil;
// min GLES function - glGenerateMipmapOES := nil;
  {$EndIf}

  {$IfDef GL_OES_matrix_palette}
  glCurrentPaletteMatrixOES := nil;
  glLoadPaletteFromModelViewMatrixOES := nil;
  glMatrixIndexPointerOES := nil;
  glWeightPointerOES := nil;
  {$EndIf}

  {$IfDef GL_OES_query_matrix}
  glQueryMatrixxOES := nil;
  {$EndIf}

  {$IfDef GL_OES_single_precision}
  glClearDepthfOES := nil;
  glClipPlanefOES := nil;
  glDepthRangefOES := nil;
  glFrustumfOES := nil;
  glGetClipPlanefOES := nil;
  glOrthofOES := nil;
  {$EndIf}

  {$IfDef GL_OES_texture_cube_map}
  glTexGenfOES := nil;
  glTexGenfvOES := nil;
  glTexGeniOES := nil;
  glTexGenivOES := nil;
  glGetTexGenfvOES := nil;
  glGetTexGenivOES := nil;
  {$EndIf}

  {$IfDef GL_IMG_user_clip_plane}
  glClipPlanefIMG := nil;
  glClipPlanexIMG := nil;
  {$EndIf}
{$EndIf}

{$IfDef GL_ES_VERSION_2_0}
  glActiveTexture := nil;
  glAttachShader := nil;
  glBindAttribLocation := nil;
  glBindBuffer := nil;
// min GLES function - glBindFramebuffer := nil;
// min GLES function - glBindRenderbuffer := nil;
// min GLES function - glBindTexture := nil;
  glBlendColor := nil;
// min GLES function - glBlendEquation := nil;
  glBlendEquationSeparate := nil;
// min GLES function - glBlendFunc := nil;
// min GLES function - glBlendFuncSeparate := nil;
  glBufferData := nil;
  glBufferSubData := nil;
// min GLES function - glCheckFramebufferStatus := nil;
// min GLES function - glClear := nil;
// min GLES function - glClearColor := nil;
// min GLES function - glClearDepthf := nil;
  glClearStencil := nil;
// min GLES function - glColorMask := nil;
  glCompileShader := nil;
// min GLES function - glCompressedTexImage2D := nil;
// min GLES function - glCompressedTexSubImage2D := nil;
  glCopyTexImage2D := nil;
// min GLES function - glCopyTexSubImage2D := nil;
  glCreateProgram := nil;
  glCreateShader := nil;
  glCullFace := nil;
  glDeleteBuffers := nil;
// min GLES function - glDeleteFramebuffers := nil;
  glDeleteProgram := nil;
// min GLES function - glDeleteRenderbuffers := nil;
  glDeleteShader := nil;
// min GLES function - glDeleteTextures := nil;
// min GLES function - glDepthFunc := nil;
// min GLES function - glDepthMask := nil;
  glDepthRangef := nil;
  glDetachShader := nil;
// min GLES function - glDisable := nil;
  glDisableVertexAttribArray := nil;
// min GLES function - glDrawArrays := nil;
// min GLES function - glDrawElements := nil;
// min GLES function - glEnable := nil;
  glEnableVertexAttribArray := nil;
  glFinish := nil;
  glFlush := nil;
// min GLES function - glFramebufferRenderbuffer := nil;
// min GLES function - glFramebufferTexture2D := nil;
  glFrontFace := nil;
  glGenBuffers := nil;
// min GLES function - glGenerateMipmap := nil;
// min GLES function - glGenFramebuffers := nil;
// min GLES function - glGenRenderbuffers := nil;
// min GLES function - glGenTextures := nil;
  glGetActiveAttrib := nil;
  glGetActiveUniform := nil;
  glGetAttachedShaders := nil;
  glGetAttribLocation := nil;
  glGetBooleanv := nil;
  glGetBufferParameteriv := nil;
  glGetError := nil;
// min GLES function - glGetFloatv := nil;
// min GLES function - glGetFramebufferAttachmentParameteriv := nil;
// min GLES function - glGetIntegerv := nil;
  glGetProgramiv := nil;
  glGetProgramInfoLog := nil;
// min GLES function - glGetRenderbufferParameteriv := nil;
  glGetShaderiv := nil;
  glGetShaderInfoLog := nil;
  glGetShaderPrecisionFormat := nil;
  glGetShaderSource := nil;
  // min GLES function - glGetString := nil;
  glGetTexParameterfv := nil;
  glGetTexParameteriv := nil;
  glGetUniformfv := nil;
  glGetUniformiv := nil;
  glGetUniformLocation := nil;
  glGetVertexAttribfv := nil;
  glGetVertexAttribiv := nil;
  glGetVertexAttribPointerv := nil;
// min GLES function - glHint := nil;
  glIsBuffer := nil;
  glIsEnabled := nil;
// min GLES function - glIsFramebuffer := nil;
  glIsProgram := nil;
// min GLES function - glIsRenderbuffer := nil;
  glIsShader := nil;
  glIsTexture := nil;
  glLineWidth := nil;
  glLinkProgram := nil;
// min GLES function - glPixelStorei := nil;
  glPolygonOffset := nil;
//  // min GLES function - glReadPixels := nil;
  glReleaseShaderCompiler := nil;
// min GLES function - glRenderbufferStorage := nil;
  glSampleCoverage := nil;
// min GLES function - glScissor := nil;
  glShaderBinary := nil;
  glShaderSource := nil;
  glStencilFunc := nil;
  glStencilFuncSeparate := nil;
  glStencilMask := nil;
  glStencilMaskSeparate := nil;
  glStencilOp := nil;
  glStencilOpSeparate := nil;
// min GLES function - glTexImage2D := dlsym(glesLibrary, 'glTexImage2D');
// min GLES function - glTexParameterf := dlsym(glesLibrary, 'glTexParameterf');
  glTexParameterfv := nil;
// min GLES function - glTexParameteri := dlsym(glesLibrary, 'glTexParameteri');
// min GLES function - glTexParameteriv := dlsym(glesLibrary, 'glTexParameteriv');
// min GLES function - glTexSubImage2D := dlsym(glesLibrary, 'glTexSubImage2D');
  glUniform1f := nil;
  glUniform1fv := nil;
  glUniform1i := nil;
  glUniform1iv := nil;
  glUniform2f := nil;
  glUniform2fv := nil;
  glUniform2i := nil;
  glUniform2iv := nil;
  glUniform3f := nil;
  glUniform3fv := nil;
  glUniform3i := nil;
  glUniform3iv := nil;
  glUniform4f := nil;
  glUniform4fv := nil;
  glUniform4i := nil;
  glUniform4iv := nil;
  glUniformMatrix2fv := nil;
  glUniformMatrix3fv := nil;
  glUniformMatrix4fv := nil;
  glUseProgram := nil;
  glValidateProgram := nil;
  glVertexAttrib1f := nil;
  glVertexAttrib1fv := nil;
  glVertexAttrib2f := nil;
  glVertexAttrib2fv := nil;
  glVertexAttrib3f := nil;
  glVertexAttrib3fv := nil;
  glVertexAttrib4f := nil;
  glVertexAttrib4fv := nil;
  glVertexAttribPointer := nil;
// min GLES function - glViewport := dlsym(glesLibrary, 'glViewport');
{$EndIf}

{$IfDef GL_KHR_blend_equation_advanced}
  glBlendBarrierKHR := nil;
{$EndIf}

{$IfDef GL_KHR_debug}
  glDebugMessageControlKHR := nil;
  glDebugMessageInsertKHR := nil;
  glDebugMessageCallbackKHR := nil;
  glGetDebugMessageLogKHR := nil;
  glPushDebugGroupKHR := nil;
  glPopDebugGroupKHR := nil;
  glObjectLabelKHR := nil;
  glGetObjectLabelKHR := nil;
  glObjectPtrLabelKHR := nil;
  glGetObjectPtrLabelKHR := nil;
  glGetPointervKHR := nil;
{$EndIf}

{$IfDef GL_KHR_parallel_shader_compile}
  glMaxShaderCompilerThreadsKHR := nil;
{$EndIf}

{$IfDef GL_KHR_robustness}
  glGetGraphicsResetStatusKHR := nil;
  glReadnPixelsKHR := nil;
  glGetnUniformfvKHR := nil;
  glGetnUniformivKHR := nil;
  glGetnUniformuivKHR := nil;
{$EndIf}

{$IfDef GL_OES_EGL_image}
  glEGLImageTargetTexture2DOES := nil;
  glEGLImageTargetRenderbufferStorageOES := nil;
{$EndIf}

{$IfDef GL_OES_copy_image}
  glCopyImageSubDataOES := nil;
{$EndIf}

{$IfDef GL_OES_draw_buffers_indexed}
  glEnableiOES := nil;
  glDisableiOES := nil;
  glBlendEquationiOES := nil;
  glBlendEquationSeparateiOES := nil;
  glBlendFunciOES := nil;
  glBlendFuncSeparateiOES := nil;
  glColorMaskiOES := nil;
  glIsEnablediOES := nil;
{$EndIf}

{$IfDef GL_OES_draw_elements_base_vertex}
  glDrawElementsBaseVertexOES := nil;
  glDrawRangeElementsBaseVertexOES := nil;
  glDrawElementsInstancedBaseVertexOES := nil;
  glMultiDrawElementsBaseVertexEXT := nil;
{$EndIf}

{$IfDef GL_OES_geometry_shader}
  glFramebufferTextureOES := nil;
{$EndIf}

{$IfDef GL_OES_get_program_binary}
  glGetProgramBinaryOES := nil;
  glProgramBinaryOES := nil;
{$EndIf}

{$IfDef GL_OES_mapbuffer}
  glMapBufferOES := nil;
  glUnmapBufferOES := nil;
  glGetBufferPointervOES := nil;
{$EndIf}

{$IfDef GL_OES_primitive_bounding_box}
  glPrimitiveBoundingBoxOES := nil;
{$EndIf}

{$IfDef GL_OES_sample_shading}
  glMinSampleShadingOES := nil;
{$EndIf}

{$IfDef GL_OES_tessellation_shader}
  glPatchParameteriOES := nil;
{$EndIf}

{$IfDef GL_OES_texture_3D}
  glTexImage3DOES := nil;
  glTexSubImage3DOES := nil;
  glCopyTexSubImage3DOES := nil;
  glCompressedTexImage3DOES := nil;
  glCompressedTexSubImage3DOES := nil;
  glFramebufferTexture3DOES := nil;
{$EndIf}

{$IfDef GL_OES_texture_border_clamp}
  glTexParameterIivOES := nil;
  glTexParameterIuivOES := nil;
  glGetTexParameterIivOES := nil;
  glGetTexParameterIuivOES := nil;
  glSamplerParameterIivOES := nil;
  glSamplerParameterIuivOES := nil;
  glGetSamplerParameterIivOES := nil;
  glGetSamplerParameterIuivOES := nil;
{$EndIf}

{$IfDef GL_OES_texture_buffer}
  glTexBufferOES := nil;
  glTexBufferRangeOES := nil;
{$EndIf}

{$IfDef GL_OES_texture_storage_multisample_2d_array}
  glTexStorage3DMultisampleOES := nil;
{$EndIf}

{$IfDef GL_OES_texture_view}
  glTextureViewOES := nil;
{$EndIf}

{$IfDef GL_OES_vertex_array_object}
  glBindVertexArrayOES := nil;
  glDeleteVertexArraysOES := nil;
  glGenVertexArraysOES := nil;
  glIsVertexArrayOES := nil;
{$EndIf}

{$IfDef GL_OES_viewport_array}
  glViewportArrayvOES := nil;
  glViewportIndexedfOES := nil;
  glViewportIndexedfvOES := nil;
  glScissorArrayvOES := nil;
  glScissorIndexedOES := nil;
  glScissorIndexedvOES := nil;
  glDepthRangeArrayfvOES := nil;
  glDepthRangeIndexedfOES := nil;
  glGetFloati_vOES := nil;
{$EndIf}

{$IfDef GL_AMD_framebuffer_multisample_advanced}
  glRenderbufferStorageMultisampleAdvancedAMD := nil;
  glNamedRenderbufferStorageMultisampleAdvancedAMD := nil;
{$EndIf}

{$IfDef GL_AMD_performance_monitor}
  glGetPerfMonitorGroupsAMD := nil;
  glGetPerfMonitorCountersAMD := nil;
  glGetPerfMonitorGroupStringAMD := nil;
  glGetPerfMonitorCounterStringAMD := nil;
  glGetPerfMonitorCounterInfoAMD := nil;
  glGenPerfMonitorsAMD := nil;
  glDeletePerfMonitorsAMD := nil;
  glSelectPerfMonitorCountersAMD := nil;
  glBeginPerfMonitorAMD := nil;
  glEndPerfMonitorAMD := nil;
  glGetPerfMonitorCounterDataAMD := nil;
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_blit}
  glBlitFramebufferANGLE := nil;
{$EndIf}

{$IfDef GL_ANGLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleANGLE := nil;
{$EndIf}

{$IfDef GL_ANGLE_instanced_arrays}
  glDrawArraysInstancedANGLE := nil;
  glDrawElementsInstancedANGLE := nil;
  glVertexAttribDivisorANGLE := nil;
{$EndIf}

{$IfDef GL_ANGLE_translated_shader_source}
  glGetTranslatedShaderSourceANGLE := nil;
{$EndIf}

{$IfDef GL_APPLE_copy_texture_levels}
  glCopyTextureLevelsAPPLE := nil;
{$EndIf}

{$IfDef GL_APPLE_framebuffer_multisample}
  glRenderbufferStorageMultisampleAPPLE := nil;
  glResolveMultisampleFramebufferAPPLE := nil;
{$EndIf}

{$IfDef GL_APPLE_sync}
  glFenceSyncAPPLE := nil;
  glIsSyncAPPLE := nil;
  glDeleteSyncAPPLE := nil;
  glClientWaitSyncAPPLE := nil;
  glWaitSyncAPPLE := nil;
  glGetInteger64vAPPLE := nil;
  glGetSyncivAPPLE := nil;
{$EndIf}

{$IfDef GL_EXT_EGL_image_storage}
  glEGLImageTargetTexStorageEXT := nil;
  glEGLImageTargetTextureStorageEXT := nil;
{$EndIf}

{$IfDef GL_EXT_base_instance}
  glDrawArraysInstancedBaseInstanceEXT := nil;
  glDrawElementsInstancedBaseInstanceEXT := nil;
  glDrawElementsInstancedBaseVertexBaseInstanceEXT := nil;
{$EndIf}

{$IfDef GL_EXT_blend_func_extended}
  glBindFragDataLocationIndexedEXT := nil;
  glBindFragDataLocationEXT := nil;
  glGetProgramResourceLocationIndexEXT := nil;
  glGetFragDataIndexEXT := nil;
{$EndIf}

{$IfDef GL_EXT_buffer_storage}
  glBufferStorageEXT := nil;
{$EndIf}

{$IfDef GL_EXT_clear_texture}
  glClearTexImageEXT := nil;
  glClearTexSubImageEXT := nil;
{$EndIf}

{$IfDef GL_EXT_clip_control}
  glClipControlEXT := nil;
{$EndIf}

{$IfDef GL_EXT_copy_image}
  glCopyImageSubDataEXT := nil;
{$EndIf}

{$IfDef GL_EXT_debug_label}
  glLabelObjectEXT := nil;
  glGetObjectLabelEXT := nil;
{$EndIf}

{$IfDef GL_EXT_debug_marker}
  glInsertEventMarkerEXT := nil;
  glPushGroupMarkerEXT := nil;
  glPopGroupMarkerEXT := nil;
{$EndIf}

{$IfDef GL_EXT_discard_framebuffer}
  glDiscardFramebufferEXT := nil;
{$EndIf}

{$IfDef GL_EXT_disjoint_timer_query}
  glGenQueriesEXT := nil;
  glDeleteQueriesEXT := nil;
  glIsQueryEXT := nil;
  glBeginQueryEXT := nil;
  glEndQueryEXT := nil;
  glQueryCounterEXT := nil;
  glGetQueryivEXT := nil;
  glGetQueryObjectivEXT := nil;
  glGetQueryObjectuivEXT := nil;
  glGetQueryObjecti64vEXT := nil;
  glGetQueryObjectui64vEXT := nil;
  glGetInteger64vEXT := nil;
{$EndIf}

{$IfDef GL_EXT_draw_buffers}
  glDrawBuffersEXT := nil;
{$EndIf}

{$IfDef GL_EXT_draw_elements_base_vertex}
  glDrawElementsBaseVertexEXT := nil;
  glDrawRangeElementsBaseVertexEXT := nil;
  glDrawElementsInstancedBaseVertexEXT := nil;
{$EndIf}

{$IfDef GL_EXT_draw_instanced}
  glDrawArraysInstancedEXT := nil;
  glDrawElementsInstancedEXT := nil;
{$EndIf}

{$IfDef GL_EXT_draw_transform_feedback}
  glDrawTransformFeedbackEXT := nil;
  glDrawTransformFeedbackInstancedEXT := nil;
{$EndIf}

{$IfDef GL_EXT_external_buffer}
  glBufferStorageExternalEXT := nil;
  glNamedBufferStorageExternalEXT := nil;
{$EndIf}

{$IfDef GL_EXT_fragment_shading_rate}
  glGetFragmentShadingRatesEXT := nil;
  glShadingRateEXT := nil;
  glShadingRateCombinerOpsEXT := nil;
  glFramebufferShadingRateEXT := nil;
{$EndIf}

{$IfDef GL_EXT_framebuffer_blit_layers}
  glBlitFramebufferLayersEXT := nil;
  glBlitFramebufferLayerEXT := nil;
{$EndIf}

{$IfDef GL_EXT_geometry_shader}
  glFramebufferTextureEXT := nil;
{$EndIf}

{$IfDef GL_EXT_instanced_arrays}
  glVertexAttribDivisorEXT := nil;
{$EndIf}

{$IfDef GL_EXT_map_buffer_range}
  glMapBufferRangeEXT := nil;
  glFlushMappedBufferRangeEXT := nil;
{$EndIf}

{$IfDef GL_EXT_memory_object}
  glGetUnsignedBytevEXT := nil;
  glGetUnsignedBytei_vEXT := nil;
  glDeleteMemoryObjectsEXT := nil;
  glIsMemoryObjectEXT := nil;
  glCreateMemoryObjectsEXT := nil;
  glMemoryObjectParameterivEXT := nil;
  glGetMemoryObjectParameterivEXT := nil;
  glTexStorageMem2DEXT := nil;
  glTexStorageMem2DMultisampleEXT := nil;
  glTexStorageMem3DEXT := nil;
  glTexStorageMem3DMultisampleEXT := nil;
  glBufferStorageMemEXT := nil;
  glTextureStorageMem2DEXT := nil;
  glTextureStorageMem2DMultisampleEXT := nil;
  glTextureStorageMem3DEXT := nil;
  glTextureStorageMem3DMultisampleEXT := nil;
  glNamedBufferStorageMemEXT := nil;
{$EndIf}

{$IfDef GL_EXT_memory_object_fd}
  glImportMemoryFdEXT := nil;
{$EndIf}

{$IfDef GL_EXT_memory_object_win32}
  glImportMemoryWin32HandleEXT := nil;
  glImportMemoryWin32NameEXT := nil;
{$EndIf}

{$IfDef GL_EXT_multi_draw_arrays}
  glMultiDrawArraysEXT := nil;
  glMultiDrawElementsEXT := nil;
{$EndIf}

{$IfDef GL_EXT_multi_draw_indirect}
  glMultiDrawArraysIndirectEXT := nil;
  glMultiDrawElementsIndirectEXT := nil;
{$EndIf}

{$IfDef GL_EXT_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleEXT := nil;
  glFramebufferTexture2DMultisampleEXT := nil;
{$EndIf}

{$IfDef GL_EXT_multiview_draw_buffers}
  glReadBufferIndexedEXT := nil;
  glDrawBuffersIndexedEXT := nil;
  glGetIntegeri_vEXT := nil;
{$EndIf}

{$IfDef GL_EXT_polygon_offset_clamp}
   glPolygonOffsetClampEXT := nil;
{$EndIf}

{$IfDef GL_EXT_primitive_bounding_box}
  glPrimitiveBoundingBoxEXT := nil;
{$EndIf}

{$IfDef GL_EXT_raster_multisample}
  glRasterSamplesEXT := nil;
{$EndIf}

{$IfDef GL_EXT_robustness}
  glGetGraphicsResetStatusEXT := nil;
  glReadnPixelsEXT := nil;
  glGetnUniformfvEXT := nil;
  glGetnUniformivEXT := nil;
{$EndIf}

{$IfDef GL_EXT_semaphore}
  glGenSemaphoresEXT := nil;
  glDeleteSemaphoresEXT := nil;
  glIsSemaphoreEXT := nil;
  glSemaphoreParameterui64vEXT := nil;
  glGetSemaphoreParameterui64vEXT := nil;
  glWaitSemaphoreEXT := nil;
  glSignalSemaphoreEXT := nil;
{$EndIf}

{$IfDef GL_EXT_semaphore_fd}
  glImportSemaphoreFdEXT := nil;
{$EndIf}

{$IfDef GL_EXT_semaphore_win32}
  glImportSemaphoreWin32HandleEXT := nil;
  glImportSemaphoreWin32NameEXT := nil;
{$EndIf}

{$IfDef GL_EXT_separate_shader_objects}
  glActiveShaderProgramEXT := nil;
  glBindProgramPipelineEXT := nil;
  glCreateShaderProgramvEXT := nil;
  glDeleteProgramPipelinesEXT := nil;
  glGenProgramPipelinesEXT := nil;
  glGetProgramPipelineInfoLogEXT := nil;
  glGetProgramPipelineivEXT := nil;
  glIsProgramPipelineEXT := nil;
  glProgramParameteriEXT := nil;
  glProgramUniform1fEXT := nil;
  glProgramUniform1fvEXT := nil;
  glProgramUniform1iEXT := nil;
  glProgramUniform1ivEXT := nil;
  glProgramUniform2fEXT := nil;
  glProgramUniform2fvEXT := nil;
  glProgramUniform2iEXT := nil;
  glProgramUniform2ivEXT := nil;
  glProgramUniform3fEXT := nil;
  glProgramUniform3fvEXT := nil;
  glProgramUniform3iEXT := nil;
  glProgramUniform3ivEXT := nil;
  glProgramUniform4fEXT := nil;
  glProgramUniform4fvEXT := nil;
  glProgramUniform4iEXT := nil;
  glProgramUniform4ivEXT := nil;
  glProgramUniformMatrix2fvEXT := nil;
  glProgramUniformMatrix3fvEXT := nil;
  glProgramUniformMatrix4fvEXT := nil;
  glUseProgramStagesEXT := nil;
  glValidateProgramPipelineEXT := nil;
  glProgramUniform1uiEXT := nil;
  glProgramUniform2uiEXT := nil;
  glProgramUniform3uiEXT := nil;
  glProgramUniform4uiEXT := nil;
  glProgramUniform1uivEXT := nil;
  glProgramUniform2uivEXT := nil;
  glProgramUniform3uivEXT := nil;
  glProgramUniform4uivEXT := nil;
  glProgramUniformMatrix2x3fvEXT := nil;
  glProgramUniformMatrix3x2fvEXT := nil;
  glProgramUniformMatrix2x4fvEXT := nil;
  glProgramUniformMatrix4x2fvEXT := nil;
  glProgramUniformMatrix3x4fvEXT := nil;
  glProgramUniformMatrix4x3fvEXT := nil;
{$EndIf}

{$IfDef GL_EXT_shader_framebuffer_fetch_non_coherent}
  glFramebufferFetchBarrierEXT := nil;
{$EndIf}

{$IfDef GL_EXT_shader_pixel_local_storage2}
  glFramebufferPixelLocalStorageSizeEXT := nil;
  glGetFramebufferPixelLocalStorageSizeEXT := nil;
  glClearPixelLocalStorageuiEXT := nil;
{$EndIf}

{$IfDef GL_EXT_sparse_texture}
  glTexPageCommitmentEXT := nil;
{$EndIf}

{$IfDef GL_EXT_tessellation_shader}
  glPatchParameteriEXT := nil;
{$EndIf}

{$IfDef GL_EXT_texture_border_clamp}
  glTexParameterIivEXT := nil;
  glTexParameterIuivEXT := nil;
  glGetTexParameterIivEXT := nil;
  glGetTexParameterIuivEXT := nil;
  glSamplerParameterIivEXT := nil;
  glSamplerParameterIuivEXT := nil;
  glGetSamplerParameterIivEXT := nil;
  glGetSamplerParameterIuivEXT := nil;
{$EndIf}

{$IfDef GL_EXT_texture_buffer}
  glTexBufferEXT := nil;
  glTexBufferRangeEXT := nil;
{$EndIf}

{$IfDef GL_EXT_texture_storage}
  glTexStorage1DEXT := nil;
  glTexStorage2DEXT := nil;
  glTexStorage3DEXT := nil;
  glTextureStorage1DEXT := nil;
  glTextureStorage2DEXT := nil;
  glTextureStorage3DEXT := nil;
{$EndIf}

{$IfDef GL_EXT_texture_storage_compression}
  glTexStorageAttribs2DEXT := nil;
  glTexStorageAttribs3DEXT := nil;
{$EndIf}

{$IfDef GL_EXT_texture_view}
  glTextureViewEXT := nil;
{$EndIf}

{$IfDef GL_EXT_win32_keyed_mutex}
  glAcquireKeyedMutexWin32EXT := nil;
  glReleaseKeyedMutexWin32EXT := nil;
{$EndIf}

{$IfDef GL_EXT_window_rectangles}
  glWindowRectanglesEXT := nil;
{$EndIf}

{$IfDef GL_IMG_bindless_texture}
  glGetTextureHandleIMG := nil;
  glGetTextureSamplerHandleIMG := nil;
  glUniformHandleui64IMG := nil;
  glUniformHandleui64vIMG := nil;
  glProgramUniformHandleui64IMG := nil;
  glProgramUniformHandleui64vIMG := nil;
{$EndIf}

{$IfDef GL_IMG_framebuffer_downsample}
  glFramebufferTexture2DDownsampleIMG := nil;
  glFramebufferTextureLayerDownsampleIMG := nil;
{$EndIf}

{$IfDef GL_IMG_multisampled_render_to_texture}
  glRenderbufferStorageMultisampleIMG := nil;
  glFramebufferTexture2DMultisampleIMG := nil;
{$EndIf}

{$IfDef GL_INTEL_framebuffer_CMAA}
  glApplyFramebufferAttachmentCMAAINTEL := nil;
{$EndIf}

{$IfDef GL_INTEL_performance_query}
  glBeginPerfQueryINTEL := nil;
  glCreatePerfQueryINTEL := nil;
  glDeletePerfQueryINTEL := nil;
  glEndPerfQueryINTEL := nil;
  glGetFirstPerfQueryIdINTEL := nil;
  glGetNextPerfQueryIdINTEL := nil;
  glGetPerfCounterInfoINTEL := nil;
  glGetPerfQueryDataINTEL := nil;
  glGetPerfQueryIdByNameINTEL := nil;
  glGetPerfQueryInfoINTEL := nil;
{$EndIf}

{$IfDef GL_MESA_framebuffer_flip_y}
  glFramebufferParameteriMESA := nil;
  glGetFramebufferParameterivMESA := nil;
{$EndIf}

{$IfDef GL_NV_bindless_texture}
  glGetTextureHandleNV := nil;
  glGetTextureSamplerHandleNV := nil;
  glMakeTextureHandleResidentNV := nil;
  glMakeTextureHandleNonResidentNV := nil;
  glGetImageHandleNV := nil;
  glMakeImageHandleResidentNV := nil;
  glMakeImageHandleNonResidentNV := nil;
  glUniformHandleui64NV := nil;
  glUniformHandleui64vNV := nil;
  glProgramUniformHandleui64NV := nil;
  glProgramUniformHandleui64vNV := nil;
  glIsTextureHandleResidentNV := nil;
  glIsImageHandleResidentNV := nil;
{$EndIf}

{$IfDef GL_NV_blend_equation_advanced}
  glBlendParameteriNV := nil;
  glBlendBarrierNV := nil;
{$EndIf}

{$IfDef GL_NV_clip_space_w_scaling}
  glViewportPositionWScaleNV := nil;
{$EndIf}

{$IfDef GL_NV_conditional_render}
  glBeginConditionalRenderNV := nil;
  glEndConditionalRenderNV := nil;
{$EndIf}

{$IfDef GL_NV_conservative_raster}
  glSubpixelPrecisionBiasNV := nil;
{$EndIf}

{$IfDef GL_NV_conservative_raster_pre_snap_triangles}
  glConservativeRasterParameteriNV := nil;
{$EndIf}

{$IfDef GL_NV_copy_buffer}
  glCopyBufferSubDataNV := nil;
{$EndIf}

{$IfDef GL_NV_coverage_sample}
  glCoverageMaskNV := nil;
  glCoverageOperationNV := nil;
{$EndIf}

{$IfDef GL_NV_draw_buffers}
  glDrawBuffersNV := nil;
{$EndIf}

{$IfDef GL_NV_draw_instanced}
  glDrawArraysInstancedNV := nil;
  glDrawElementsInstancedNV := nil;
{$EndIf}

{$IfDef GL_NV_draw_vulkan_image}
  glDrawVkImageNV := nil;
  glGetVkProcAddrNV := nil;
  glWaitVkSemaphoreNV := nil;
  glSignalVkSemaphoreNV := nil;
  glSignalVkFenceNV := nil;
{$EndIf}

{$IfDef GL_NV_fence}
  glDeleteFencesNV := nil;
  glGenFencesNV := nil;
  glIsFenceNV := nil;
  glTestFenceNV := nil;
  glGetFenceivNV := nil;
  glFinishFenceNV := nil;
  glSetFenceNV := nil;
{$EndIf}

{$IfDef GL_NV_fragment_coverage_to_color}
  glFragmentCoverageColorNV := nil;
{$EndIf}

{$IfDef GL_NV_framebuffer_blit}
  glBlitFramebufferNV := nil;
{$EndIf}

{$IfDef GL_NV_framebuffer_mixed_samples}
  glCoverageModulationTableNV := nil;
  glGetCoverageModulationTableNV := nil;
  glCoverageModulationNV := nil;
{$EndIf}

{$IfDef GL_NV_framebuffer_multisample}
  glRenderbufferStorageMultisampleNV := nil;
{$EndIf}

{$IfDef GL_NV_gpu_shader5}
  glUniform1i64NV := nil;
  glUniform2i64NV := nil;
  glUniform3i64NV := nil;
  glUniform4i64NV := nil;
  glUniform1i64vNV := nil;
  glUniform2i64vNV := nil;
  glUniform3i64vNV := nil;
  glUniform4i64vNV := nil;
  glUniform1ui64NV := nil;
  glUniform2ui64NV := nil;
  glUniform3ui64NV := nil;
  glUniform4ui64NV := nil;
  glUniform1ui64vNV := nil;
  glUniform2ui64vNV := nil;
  glUniform3ui64vNV := nil;
  glUniform4ui64vNV := nil;
  glGetUniformi64vNV := nil;
  glProgramUniform1i64NV := nil;
  glProgramUniform2i64NV := nil;
  glProgramUniform3i64NV := nil;
  glProgramUniform4i64NV := nil;
  glProgramUniform1i64vNV := nil;
  glProgramUniform2i64vNV := nil;
  glProgramUniform3i64vNV := nil;
  glProgramUniform4i64vNV := nil;
  glProgramUniform1ui64NV := nil;
  glProgramUniform2ui64NV := nil;
  glProgramUniform3ui64NV := nil;
  glProgramUniform4ui64NV := nil;
  glProgramUniform1ui64vNV := nil;
  glProgramUniform2ui64vNV := nil;
  glProgramUniform3ui64vNV := nil;
  glProgramUniform4ui64vNV := nil;
{$EndIf}

{$IfDef GL_NV_instanced_arrays}
  glVertexAttribDivisorNV := nil;
{$EndIf}

{$IfDef GL_NV_internalformat_sample_query}
  glGetInternalformatSampleivNV := nil;
{$EndIf}

{$IfDef GL_NV_memory_attachment}
  glGetMemoryObjectDetachedResourcesuivNV := nil;
  glResetMemoryObjectParameterNV := nil;
  glTexAttachMemoryNV := nil;
  glBufferAttachMemoryNV := nil;
  glTextureAttachMemoryNV := nil;
  glNamedBufferAttachMemoryNV := nil;
{$EndIf}

{$IfDef GL_NV_memory_object_sparse}
  glBufferPageCommitmentMemNV := nil;
  glTexPageCommitmentMemNV := nil;
  glNamedBufferPageCommitmentMemNV := nil;
  glTexturePageCommitmentMemNV := nil;
{$EndIf}

{$IfDef GL_NV_mesh_shader}
  glDrawMeshTasksNV := nil;
  glDrawMeshTasksIndirectNV := nil;
  glMultiDrawMeshTasksIndirectNV := nil;
  glMultiDrawMeshTasksIndirectCountNV := nil;
{$EndIf}

{$IfDef GL_NV_non_square_matrices}
  glUniformMatrix2x3fvNV := nil;
  glUniformMatrix3x2fvNV := nil;
  glUniformMatrix2x4fvNV := nil;
  glUniformMatrix4x2fvNV := nil;
  glUniformMatrix3x4fvNV := nil;
  glUniformMatrix4x3fvNV := nil;
{$EndIf}

{$IfDef GL_NV_path_rendering}
  glGenPathsNV := nil;
  glDeletePathsNV := nil;
  glIsPathNV := nil;
  glPathCommandsNV := nil;
  glPathCoordsNV := nil;
  glPathSubCommandsNV := nil;
  glPathSubCoordsNV := nil;
  glPathStringNV := nil;
  glPathGlyphsNV := nil;
  glPathGlyphRangeNV := nil;
  glWeightPathsNV := nil;
  glCopyPathNV := nil;
  glInterpolatePathsNV := nil;
  glTransformPathNV := nil;
  glPathParameterivNV := nil;
  glPathParameteriNV := nil;
  glPathParameterfvNV := nil;
  glPathParameterfNV := nil;
  glPathDashArrayNV := nil;
  glPathStencilFuncNV := nil;
  glPathStencilDepthOffsetNV := nil;
  glStencilFillPathNV := nil;
  glStencilStrokePathNV := nil;
  glStencilFillPathInstancedNV := nil;
  glStencilStrokePathInstancedNV := nil;
  glPathCoverDepthFuncNV := nil;
  glCoverFillPathNV := nil;
  glCoverStrokePathNV := nil;
  glCoverFillPathInstancedNV := nil;
  glCoverStrokePathInstancedNV := nil;
  glGetPathParameterivNV := nil;
  glGetPathParameterfvNV := nil;
  glGetPathCommandsNV := nil;
  glGetPathCoordsNV := nil;
  glGetPathDashArrayNV := nil;
  glGetPathMetricsNV := nil;
  glGetPathMetricRangeNV := nil;
  glGetPathSpacingNV := nil;
  glIsPointInFillPathNV := nil;
  glIsPointInStrokePathNV := nil;
  glGetPathLengthNV := nil;
  glPointAlongPathNV := nil;
  glMatrixLoad3x2fNV := nil;
  glMatrixLoad3x3fNV := nil;
  glMatrixLoadTranspose3x3fNV := nil;
  glMatrixMult3x2fNV := nil;
  glMatrixMult3x3fNV := nil;
  glMatrixMultTranspose3x3fNV := nil;
  glStencilThenCoverFillPathNV := nil;
  glStencilThenCoverStrokePathNV := nil;
  glStencilThenCoverFillPathInstancedNV := nil;
  glStencilThenCoverStrokePathInstancedNV := nil;
  glPathGlyphIndexRangeNV := nil;
  glPathGlyphIndexArrayNV := nil;
  glPathMemoryGlyphIndexArrayNV := nil;
  glProgramPathFragmentInputGenNV := nil;
  glGetProgramResourcefvNV := nil;
  glMatrixFrustumEXT := nil;
  glMatrixLoadIdentityEXT := nil;
  glMatrixLoadTransposefEXT := nil;
  glMatrixLoadTransposedEXT := nil;
  glMatrixLoadfEXT := nil;
  glMatrixLoaddEXT := nil;
  glMatrixMultTransposefEXT := nil;
  glMatrixMultTransposedEXT := nil;
  glMatrixMultfEXT := nil;
  glMatrixMultdEXT := nil;
  glMatrixOrthoEXT := nil;
  glMatrixPopEXT := nil;
  glMatrixPushEXT := nil;
  glMatrixRotatefEXT := nil;
  glMatrixRotatedEXT := nil;
  glMatrixScalefEXT := nil;
  glMatrixScaledEXT := nil;
  glMatrixTranslatefEXT := nil;
  glMatrixTranslatedEXT := nil;
{$EndIf}

{$IfDef GL_NV_polygon_mode}
  glPolygonModeNV := nil;
{$EndIf}

{$IfDef GL_NV_read_buffer}
  glReadBufferNV := nil;
{$EndIf}

{$IfDef GL_NV_sample_locations}
  glFramebufferSampleLocationsfvNV := nil;
  glNamedFramebufferSampleLocationsfvNV := nil;
  glResolveDepthValuesNV := nil;
{$EndIf}

{$IfDef GL_NV_scissor_exclusive}
  glScissorExclusiveNV := nil;
  glScissorExclusiveArrayvNV := nil;
{$EndIf}

{$IfDef GL_NV_shading_rate_image}
  glBindShadingRateImageNV := nil;
  glGetShadingRateImagePaletteNV := nil;
  glGetShadingRateSampleLocationivNV := nil;
  glShadingRateImageBarrierNV := nil;
  glShadingRateImagePaletteNV := nil;
  glShadingRateSampleOrderNV := nil;
  glShadingRateSampleOrderCustomNV := nil;
{$EndIf}

{$IfDef GL_NV_timeline_semaphore}
  glCreateSemaphoresNV := nil;
  glSemaphoreParameterivNV := nil;
  glGetSemaphoreParameterivNV := nil;
{$EndIf}

{$IfDef GL_NV_viewport_array}
  glViewportArrayvNV := nil;
  glViewportIndexedfNV := nil;
  glViewportIndexedfvNV := nil;
  glScissorArrayvNV := nil;
  glScissorIndexedNV := nil;
  glScissorIndexedvNV := nil;
  glDepthRangeArrayfvNV := nil;
  glDepthRangeIndexedfNV := nil;
  glGetFloati_vNV := nil;
  glEnableiNV := nil;
  glDisableiNV := nil;
  glIsEnablediNV := nil;
{$EndIf}

{$IfDef GL_NV_viewport_swizzle}
  glViewportSwizzleNV := nil;
{$EndIf}

{$IfDef GL_OVR_multiview}
  glFramebufferTextureMultiviewOVR := nil;
{$EndIf}

{$IfDef GL_OVR_multiview_multisampled_render_to_texture}
  glFramebufferTextureMultisampleMultiviewOVR := nil;
{$EndIf}

{$IfDef GL_QCOM_alpha_test}
  glAlphaFuncQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_driver_control}
  glGetDriverControlsQCOM := nil;
  glGetDriverControlStringQCOM := nil;
  glEnableDriverControlQCOM := nil;
  glDisableDriverControlQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_extended_get}
  glExtGetTexturesQCOM := nil;
  glExtGetBuffersQCOM := nil;
  glExtGetRenderbuffersQCOM := nil;
  glExtGetFramebuffersQCOM := nil;
  glExtGetTexLevelParameterivQCOM := nil;
  glExtTexObjectStateOverrideiQCOM := nil;
  glExtGetTexSubImageQCOM := nil;
  glExtGetBufferPointervQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_extended_get2}
  glExtGetShadersQCOM := nil;
  glExtGetProgramsQCOM := nil;
  glExtIsProgramBinaryQCOM := nil;
  glExtGetProgramBinarySourceQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_frame_extrapolation}
  glExtrapolateTex2DQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_framebuffer_foveated}
  glFramebufferFoveationConfigQCOM := nil;
  glFramebufferFoveationParametersQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_motion_estimation}
  glTexEstimateMotionQCOM := nil;
  glTexEstimateMotionRegionsQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_shader_framebuffer_fetch_noncoherent}
  glFramebufferFetchBarrierQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_shading_rate}
  glShadingRateQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_texture_foveated}
  glTextureFoveationParametersQCOM := nil;
{$EndIf}

{$IfDef GL_QCOM_tiled_rendering}
  glStartTilingQCOM := nil;
  glEndTilingQCOM := nil;
{$EndIf}

{$IfDef GL_ES_VERSION_3_0}
// GL_NV_read_buffer
  glReadBuffer := nil;
// none
  glDrawRangeElements := nil;
// GL_OES_texture_3D
  glTexImage3D := nil;
  glTexSubImage3D := nil;
  glCopyTexSubImage3D := nil;
  glCompressedTexImage3D := nil;
  glCompressedTexSubImage3D := nil;
// GL_EXT_disjoint_timer_query
  glGenQueries := nil;
  glDeleteQueries := nil;
  glIsQuery := nil;
  glBeginQuery := nil;
  glEndQuery := nil;
  glGetQueryiv := nil;
  glGetQueryObjectuiv := nil;
// GL_OES_mapbuffer
  glUnmapBuffer := nil;
  glGetBufferPointerv := nil;
// GL_EXT_draw_buffers + GL_NV_draw_buffers
  glDrawBuffers := nil;
// GL_NV_non_square_matrices
  glUniformMatrix2x3fv := nil;
  glUniformMatrix3x2fv := nil;
  glUniformMatrix2x4fv := nil;
  glUniformMatrix4x2fv := nil;
  glUniformMatrix3x4fv := nil;
  glUniformMatrix4x3fv := nil;
// GL_ANGLE_framebuffer_blit + GL_NV_framebuffer_blit
  glBlitFramebuffer := nil;
// GL_ANGLE_framebuffer_multisample + GL_APPLE_framebuffer_multisample + GL_EXT_multisampled_render_to_texture +
//                                  GL_IMG_multisampled_render_to_texture + GL_NV_framebuffer_multisample
  glRenderbufferStorageMultisample := nil;
// none
  glFramebufferTextureLayer := nil;
// GL_EXT_map_buffer_range
  glMapBufferRange := nil;
  glFlushMappedBufferRange := nil;
// GL_OES_vertex_array_object
  glBindVertexArray := nil;
  glDeleteVertexArrays := nil;
  glGenVertexArrays := nil;
  glIsVertexArray := nil;
// GL_EXT_multiview_draw_buffers
  glGetIntegeri_v := nil;
// none
  glBeginTransformFeedback := nil;
  glEndTransformFeedback := nil;
  glBindBufferRange := nil;
  glBindBufferBase := nil;
  glTransformFeedbackVaryings := nil;
  glGetTransformFeedbackVarying := nil;
  glVertexAttribIPointer := nil;
  glGetVertexAttribIiv := nil;
  glGetVertexAttribIuiv := nil;
  glVertexAttribI4i := nil;
  glVertexAttribI4ui := nil;
  glVertexAttribI4iv := nil;
  glVertexAttribI4uiv := nil;
  glGetUniformuiv := nil;
  glGetFragDataLocation := nil;
  glUniform1ui := nil;
  glUniform2ui := nil;
  glUniform3ui := nil;
  glUniform4ui := nil;
  glUniform1uiv := nil;
  glUniform2uiv := nil;
  glUniform3uiv := nil;
  glUniform4uiv := nil;
  glClearBufferiv := nil;
  glClearBufferuiv := nil;
  glClearBufferfv := nil;
  glClearBufferfi := nil;
  glGetStringi := nil;
// GL_NV_copy_buffer
  glCopyBufferSubData := nil;
// none
  glGetUniformIndices := nil;
  glGetActiveUniformsiv := nil;
  glGetUniformBlockIndex := nil;
  glGetActiveUniformBlockiv := nil;
  glGetActiveUniformBlockName := nil;
  glUniformBlockBinding := nil;
// GL_ANGLE_instanced_arrays            GL_EXT_draw_instanced              GL_NV_draw_instanced
  glDrawArraysInstanced := nil;
  glDrawElementsInstanced := nil;
// GL_APPLE_sync
  glFenceSync := nil;
  glIsSync := nil;
  glDeleteSync := nil;
  glClientWaitSync := nil;
  glWaitSync := nil;
// GL_APPLE_sync                        GL_EXT_disjoint_timer_query
  glGetInteger64v := nil;
// GL_APPLE_sync
  glGetSynciv := nil;
// none
  glGetInteger64i_v := nil;
  glGetBufferParameteri64v := nil;
  glGenSamplers := nil;
  glDeleteSamplers := nil;
  glIsSampler := nil;
  glBindSampler := nil;
  glSamplerParameteri := nil;
  glSamplerParameteriv := nil;
  glSamplerParameterf := nil;
  glSamplerParameterfv := nil;
  glGetSamplerParameteriv := nil;
  glGetSamplerParameterfv := nil;
// GL_ANGLE_instanced_arrays            GL_EXT_instanced_arrays       GL_NV_instanced_arrays
  glVertexAttribDivisor := nil;
// none
  glBindTransformFeedback := nil;
  glDeleteTransformFeedbacks := nil;
  glGenTransformFeedbacks := nil;
  glIsTransformFeedback := nil;
  glPauseTransformFeedback := nil;
  glResumeTransformFeedback := nil;
// GL_OES_get_program_binary
  glGetProgramBinary := nil;
  glProgramBinary := nil;
// GL_EXT_separate_shader_objects
  glProgramParameteri := nil;
// none
  glInvalidateFramebuffer := nil;
  glInvalidateSubFramebuffer := nil;
// GL_EXT_texture_storage
  glTexStorage2D := nil;
  glTexStorage3D := nil;
// none
  glGetInternalformativ := nil;
{$EndIf}

{$IfDef GL_ES_VERSION_3_1}
// none
  glDispatchCompute := nil;
  glDispatchComputeIndirect := nil;
  glDrawArraysIndirect := nil;
  glDrawElementsIndirect := nil;
// GL_MESA_framebuffer_flip_y
  glFramebufferParameteri := nil;
  glGetFramebufferParameteriv := nil;
// none
  glGetProgramInterfaceiv := nil;
  glGetProgramResourceIndex := nil;
  glGetProgramResourceName := nil;
  glGetProgramResourceiv := nil;
  glGetProgramResourceLocation := nil;
// GL_EXT_separate_shader_objects
  glUseProgramStages := nil;
  glActiveShaderProgram := nil;
  glCreateShaderProgramv := nil;
  glBindProgramPipeline := nil;
  glDeleteProgramPipelines := nil;
  glGenProgramPipelines := nil;
  glIsProgramPipeline := nil;
  glGetProgramPipelineiv := nil;
  glProgramUniform1i := nil;
  glProgramUniform2i := nil;
  glProgramUniform3i := nil;
  glProgramUniform4i := nil;
  glProgramUniform1ui := nil;
  glProgramUniform2ui := nil;
  glProgramUniform3ui := nil;
  glProgramUniform4ui := nil;
  glProgramUniform1f := nil;
  glProgramUniform2f := nil;
  glProgramUniform3f := nil;
  glProgramUniform4f := nil;
  glProgramUniform1iv := nil;
  glProgramUniform2iv := nil;
  glProgramUniform3iv := nil;
  glProgramUniform4iv := nil;
  glProgramUniform1uiv := nil;
  glProgramUniform2uiv := nil;
  glProgramUniform3uiv := nil;
  glProgramUniform4uiv := nil;
  glProgramUniform1fv := nil;
  glProgramUniform2fv := nil;
  glProgramUniform3fv := nil;
  glProgramUniform4fv := nil;
  glProgramUniformMatrix2fv := nil;
  glProgramUniformMatrix3fv := nil;
  glProgramUniformMatrix4fv := nil;
  glProgramUniformMatrix2x3fv := nil;
  glProgramUniformMatrix3x2fv := nil;
  glProgramUniformMatrix2x4fv := nil;
  glProgramUniformMatrix4x2fv := nil;
  glProgramUniformMatrix3x4fv := nil;
  glProgramUniformMatrix4x3fv := nil;
  glValidateProgramPipeline := nil;
  glGetProgramPipelineInfoLog := nil;
// none
  glBindImageTexture := nil;
  glGetBooleani_v := nil;
  glMemoryBarrier := nil;
  glMemoryBarrierByRegion := nil;
  glTexStorage2DMultisample := nil;
  glGetMultisamplefv := nil;
  glSampleMaski := nil;
  glGetTexLevelParameteriv := nil;
  glGetTexLevelParameterfv := nil;
  glBindVertexBuffer := nil;
  glVertexAttribFormat := nil;
  glVertexAttribIFormat := nil;
  glVertexAttribBinding := nil;
  glVertexBindingDivisor := nil;
{$EndIf}

{$IfDef GL_ES_VERSION_3_2}
// GL_KHR_blend_equation_advanced        GL_NV_blend_equation_advanced
  glBlendBarrier := nil;
// GL_OES_copy_image                     GL_EXT_copy_image
  glCopyImageSubData := nil;
// GL_KHR_debug
  glDebugMessageControl := nil;
  glDebugMessageInsert := nil;
  glDebugMessageCallback := nil;
  glGetDebugMessageLog := nil;
  glPushDebugGroup := nil;
  glPopDebugGroup := nil;
  glObjectLabel := nil;
// GL_KHR_debug                          GL_EXT_debug_label
  glGetObjectLabel := nil;
// GL_KHR_debug
  glObjectPtrLabel := nil;
  glGetObjectPtrLabel := nil;
  glGetPointerv := nil;
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glEnablei := nil;
  glDisablei := nil;
// GL_OES_draw_buffers_indexed
  glBlendEquationi := nil;
  glBlendEquationSeparatei := nil;
  glBlendFunci := nil;
  glBlendFuncSeparatei := nil;
  glColorMaski := nil;
// GL_OES_draw_buffers_indexed           GL_NV_viewport_array
  glIsEnabledi := nil;
// GL_OES_draw_elements_base_vertex      GL_EXT_draw_elements_base_vertex
  glDrawElementsBaseVertex := nil;
  glDrawRangeElementsBaseVertex := nil;
  glDrawElementsInstancedBaseVertex := nil;
// GL_OES_geometry_shader                GL_EXT_geometry_shader
  glFramebufferTexture := nil;
// GL_OES_primitive_bounding_box         GL_EXT_primitive_bounding_box
  glPrimitiveBoundingBox := nil;
// GL_KHR_robustness                     GL_EXT_robustness
  glGetGraphicsResetStatus := nil;
  glReadnPixels := nil;
  glGetnUniformfv := nil;
  glGetnUniformiv := nil;
// GL_KHR_robustness
  glGetnUniformuiv := nil;
// GL_OES_sample_shading
  glMinSampleShading := nil;
// GL_OES_tessellation_shader            GL_EXT_tessellation_shader
  glPatchParameteri := nil;
// GL_OES_texture_border_clamp           GL_EXT_texture_border_clamp
  glTexParameterIiv := nil;
  glTexParameterIuiv := nil;
  glGetTexParameterIiv := nil;
  glGetTexParameterIuiv := nil;
  glSamplerParameterIiv := nil;
  glSamplerParameterIuiv := nil;
  glGetSamplerParameterIiv := nil;
  glGetSamplerParameterIuiv := nil;
// GL_OES_texture_buffer                 GL_EXT_texture_buffer
  glTexBuffer := nil;
  glTexBufferRange := nil;
// GL_OES_texture_storage_multisample_2d_array
  glTexStorage3DMultisample := nil;
{$EndIf}
end;

end.

