/**
 * Privacy Friendly Camera Ruler is licensed under the GPLv3. Copyright (C) 2016 Roberts Kolosovs

 This program is free software: you can redistribute it and/or modify it under the terms of the GNU
 General Public License as published by the Free Software Foundation, either version 3 of the
 License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with this program.
 If not, see http://www.gnu.org/licenses/.

 The icons used in the nagivation drawer are licensed under the CC BY 2.5.
 In addition to them the app uses icons from Google Design Material Icons licensed under Apache
 License Version 2.0. All other images (the logo of Privacy Friendly Apps, the SECUSO logo and the
 header in the navigation drawer) copyright Technische Universtität Darmstadt (2016).
 */

package org.secuso.privacyfriendlycameraruler.database;

/**
 * Class representing the type of a predefined reference object. All objects of the same type have
 * the same basic shape (line, circle, tetragon, etc.) and are also thematically similar. ObjectType
 * can be used to handle an group of similar predefined reference objects in a similar way.
 *
 * @author Roberts Kolosovs
 * Created by rkolosovs on 14.02.17.
 */

public class ObjectType {

    public String name;
    public String shape;

    ObjectType(String name, String shape){
        this.name = name;
        this.shape = shape;
    }
}
