﻿namespace ScottPlot.NamedColors;

/// <summary>
/// Colors defined according to results of the xkcd color name survey
/// https://xkcd.com/color/rgb/
/// </summary>
public class XkcdColors : NamedColorsBase
{
    public static Color AcidGreen => new(143, 254, 9);
    public static Color Adobe => new(189, 108, 72);
    public static Color Algae => new(84, 172, 104);
    public static Color AlgaeGreen => new(33, 195, 111);
    public static Color AlmostBlack => new(7, 13, 13);
    public static Color Amber => new(254, 179, 8);
    public static Color Amethyst => new(155, 95, 192);
    public static Color Apple => new(110, 203, 60);
    public static Color AppleGreen => new(118, 205, 38);
    public static Color Apricot => new(255, 177, 109);
    public static Color Aqua => new(19, 234, 201);
    public static Color AquaBlue => new(2, 216, 233);
    public static Color AquaGreen => new(18, 225, 147);
    public static Color AquaMarine => new(46, 232, 187);
    public static Color Aquamarine => new(4, 216, 178);
    public static Color ArmyGreen => new(75, 93, 22);
    public static Color Asparagus => new(119, 171, 86);
    public static Color Aubergine => new(61, 7, 52);
    public static Color Auburn => new(154, 48, 1);
    public static Color Avocado => new(144, 177, 52);
    public static Color AvocadoGreen => new(135, 169, 34);
    public static Color Azul => new(29, 93, 236);
    public static Color Azure => new(6, 154, 243);
    public static Color BabyBlue => new(162, 207, 254);
    public static Color BabyGreen => new(140, 255, 158);
    public static Color BabyPink => new(255, 183, 206);
    public static Color BabyPoo => new(171, 144, 4);
    public static Color BabyPoop => new(147, 124, 0);
    public static Color BabyPoopGreen => new(143, 152, 5);
    public static Color BabyPukeGreen => new(182, 196, 6);
    public static Color BabyPurple => new(202, 155, 247);
    public static Color BabyShitBrown => new(173, 144, 13);
    public static Color BabyShitGreen => new(136, 151, 23);
    public static Color Banana => new(255, 255, 126);
    public static Color BananaYellow => new(250, 254, 75);
    public static Color BarbiePink => new(254, 70, 165);
    public static Color BarfGreen => new(148, 172, 2);
    public static Color Barney => new(172, 29, 184);
    public static Color BarneyPurple => new(160, 4, 152);
    public static Color BattleshipGrey => new(107, 124, 133);
    public static Color Beige => new(230, 218, 166);
    public static Color Berry => new(153, 15, 75);
    public static Color Bile => new(181, 195, 6);
    public static Color Black => new(0, 0, 0);
    public static Color Bland => new(175, 168, 139);
    public static Color Blood => new(119, 0, 1);
    public static Color BloodOrange => new(254, 75, 3);
    public static Color BloodRed => new(152, 0, 2);
    public static Color Blue => new(3, 67, 223);
    public static Color BlueBlue => new(34, 66, 199);
    public static Color BlueGreen => new(19, 126, 109);
    public static Color BlueGrey => new(96, 124, 142);
    public static Color BluePurple => new(87, 41, 206);
    public static Color BlueSlashGreen => new(15, 155, 142);
    public static Color BlueSlashGrey => new(117, 141, 163);
    public static Color BlueSlashPurple => new(90, 6, 239);
    public static Color BlueViolet => new(93, 6, 233);
    public static Color BlueWithAHintOfPurple => new(83, 60, 198);
    public static Color Blueberry => new(70, 65, 150);
    public static Color Bluegreen => new(1, 122, 121);
    public static Color Bluegrey => new(133, 163, 178);
    public static Color BlueyGreen => new(43, 177, 121);
    public static Color BlueyGrey => new(137, 160, 176);
    public static Color BlueyPurple => new(98, 65, 199);
    public static Color Bluish => new(41, 118, 187);
    public static Color BluishGreen => new(16, 166, 116);
    public static Color BluishGrey => new(116, 139, 151);
    public static Color BluishPurple => new(112, 59, 231);
    public static Color Blurple => new(85, 57, 204);
    public static Color Blush => new(242, 158, 142);
    public static Color BlushPink => new(254, 130, 140);
    public static Color Booger => new(155, 181, 60);
    public static Color BoogerGreen => new(150, 180, 3);
    public static Color Bordeaux => new(123, 0, 44);
    public static Color BoringGreen => new(99, 179, 101);
    public static Color BottleGreen => new(4, 74, 5);
    public static Color Brick => new(160, 54, 35);
    public static Color BrickOrange => new(193, 74, 9);
    public static Color BrickRed => new(143, 20, 2);
    public static Color BrightAqua => new(11, 249, 234);
    public static Color BrightBlue => new(1, 101, 252);
    public static Color BrightCyan => new(65, 253, 254);
    public static Color BrightGreen => new(1, 255, 7);
    public static Color BrightLavender => new(199, 96, 255);
    public static Color BrightLightBlue => new(38, 247, 253);
    public static Color BrightLightGreen => new(45, 254, 84);
    public static Color BrightLilac => new(201, 94, 251);
    public static Color BrightLime => new(135, 253, 5);
    public static Color BrightLimeGreen => new(101, 254, 8);
    public static Color BrightMagenta => new(255, 8, 232);
    public static Color BrightOlive => new(156, 187, 4);
    public static Color BrightOrange => new(255, 91, 0);
    public static Color BrightPink => new(254, 1, 177);
    public static Color BrightPurple => new(190, 3, 253);
    public static Color BrightRed => new(255, 0, 13);
    public static Color BrightSeaGreen => new(5, 255, 166);
    public static Color BrightSkyBlue => new(2, 204, 254);
    public static Color BrightTeal => new(1, 249, 198);
    public static Color BrightTurquoise => new(15, 254, 249);
    public static Color BrightViolet => new(173, 10, 253);
    public static Color BrightYellow => new(255, 253, 1);
    public static Color BrightYellowGreen => new(157, 255, 0);
    public static Color BritishRacingGreen => new(5, 72, 13);
    public static Color Bronze => new(168, 121, 0);
    public static Color Brown => new(101, 55, 0);
    public static Color BrownGreen => new(112, 108, 17);
    public static Color BrownGrey => new(141, 132, 104);
    public static Color BrownOrange => new(185, 105, 2);
    public static Color BrownRed => new(146, 43, 5);
    public static Color BrownYellow => new(178, 151, 5);
    public static Color Brownish => new(156, 109, 87);
    public static Color BrownishGreen => new(106, 110, 9);
    public static Color BrownishGrey => new(134, 119, 95);
    public static Color BrownishOrange => new(203, 119, 35);
    public static Color BrownishPink => new(194, 126, 121);
    public static Color BrownishPurple => new(118, 66, 78);
    public static Color BrownishRed => new(158, 54, 35);
    public static Color BrownishYellow => new(201, 176, 3);
    public static Color BrownyGreen => new(111, 108, 10);
    public static Color BrownyOrange => new(202, 107, 2);
    public static Color Bruise => new(126, 64, 113);
    public static Color BubbleGumPink => new(255, 105, 175);
    public static Color Bubblegum => new(255, 108, 181);
    public static Color BubblegumPink => new(254, 131, 204);
    public static Color Buff => new(254, 246, 158);
    public static Color Burgundy => new(97, 0, 35);
    public static Color BurntOrange => new(192, 78, 1);
    public static Color BurntRed => new(159, 35, 5);
    public static Color BurntSiena => new(183, 82, 3);
    public static Color BurntSienna => new(176, 78, 15);
    public static Color BurntUmber => new(160, 69, 14);
    public static Color BurntYellow => new(213, 171, 9);
    public static Color Burple => new(104, 50, 227);
    public static Color Butter => new(255, 255, 129);
    public static Color ButterYellow => new(255, 253, 116);
    public static Color Butterscotch => new(253, 177, 71);
    public static Color CadetBlue => new(78, 116, 150);
    public static Color Camel => new(198, 159, 89);
    public static Color Camo => new(127, 143, 78);
    public static Color CamoGreen => new(82, 101, 37);
    public static Color CamouflageGreen => new(75, 97, 19);
    public static Color Canary => new(253, 255, 99);
    public static Color CanaryYellow => new(255, 254, 64);
    public static Color CandyPink => new(255, 99, 233);
    public static Color Caramel => new(175, 111, 9);
    public static Color Carmine => new(157, 2, 22);
    public static Color Carnation => new(253, 121, 143);
    public static Color CarnationPink => new(255, 127, 167);
    public static Color CarolinaBlue => new(138, 184, 254);
    public static Color Celadon => new(190, 253, 183);
    public static Color Celery => new(193, 253, 149);
    public static Color Cement => new(165, 163, 145);
    public static Color Cerise => new(222, 12, 98);
    public static Color Cerulean => new(4, 133, 209);
    public static Color CeruleanBlue => new(5, 110, 238);
    public static Color Charcoal => new(52, 56, 55);
    public static Color CharcoalGrey => new(60, 65, 66);
    public static Color Chartreuse => new(193, 248, 10);
    public static Color Cherry => new(207, 2, 52);
    public static Color CherryRed => new(247, 2, 42);
    public static Color Chestnut => new(116, 40, 2);
    public static Color Chocolate => new(61, 28, 2);
    public static Color ChocolateBrown => new(65, 25, 0);
    public static Color Cinnamon => new(172, 79, 6);
    public static Color Claret => new(104, 0, 24);
    public static Color Clay => new(182, 106, 80);
    public static Color ClayBrown => new(178, 113, 61);
    public static Color ClearBlue => new(36, 122, 253);
    public static Color CloudyBlue => new(172, 194, 217);
    public static Color Cobalt => new(30, 72, 143);
    public static Color CobaltBlue => new(3, 10, 167);
    public static Color Cocoa => new(135, 95, 66);
    public static Color Coffee => new(166, 129, 76);
    public static Color CoolBlue => new(73, 132, 184);
    public static Color CoolGreen => new(51, 184, 100);
    public static Color CoolGrey => new(149, 163, 166);
    public static Color Copper => new(182, 99, 37);
    public static Color Coral => new(252, 90, 80);
    public static Color CoralPink => new(255, 97, 99);
    public static Color Cornflower => new(106, 121, 247);
    public static Color CornflowerBlue => new(81, 112, 215);
    public static Color Cranberry => new(158, 0, 58);
    public static Color Cream => new(255, 255, 194);
    public static Color Creme => new(255, 255, 182);
    public static Color Crimson => new(140, 0, 15);
    public static Color Custard => new(255, 253, 120);
    public static Color Cyan => new(0, 255, 255);
    public static Color Dandelion => new(254, 223, 8);
    public static Color Dark => new(27, 36, 49);
    public static Color DarkAqua => new(5, 105, 107);
    public static Color DarkAquamarine => new(1, 115, 113);
    public static Color DarkBeige => new(172, 147, 98);
    public static Color DarkBlue => new(0, 3, 91);
    public static Color DarkBlueGreen => new(0, 82, 73);
    public static Color DarkBlueGrey => new(31, 59, 77);
    public static Color DarkBrown => new(52, 28, 2);
    public static Color DarkCoral => new(207, 82, 78);
    public static Color DarkCream => new(255, 243, 154);
    public static Color DarkCyan => new(10, 136, 138);
    public static Color DarkForestGreen => new(0, 45, 4);
    public static Color DarkFuchsia => new(157, 7, 89);
    public static Color DarkGold => new(181, 148, 16);
    public static Color DarkGrassGreen => new(56, 128, 4);
    public static Color DarkGreen => new(3, 53, 0);
    public static Color DarkGreenBlue => new(31, 99, 87);
    public static Color DarkGrey => new(54, 55, 55);
    public static Color DarkGreyBlue => new(41, 70, 91);
    public static Color DarkHotPink => new(217, 1, 102);
    public static Color DarkIndigo => new(31, 9, 84);
    public static Color DarkKhaki => new(155, 143, 85);
    public static Color DarkLavender => new(133, 103, 152);
    public static Color DarkLilac => new(156, 109, 165);
    public static Color DarkLime => new(132, 183, 1);
    public static Color DarkLimeGreen => new(126, 189, 1);
    public static Color DarkMagenta => new(150, 0, 86);
    public static Color DarkMaroon => new(60, 0, 8);
    public static Color DarkMauve => new(135, 76, 98);
    public static Color DarkMint => new(72, 192, 114);
    public static Color DarkMintGreen => new(32, 192, 115);
    public static Color DarkMustard => new(168, 137, 5);
    public static Color DarkNavy => new(0, 4, 53);
    public static Color DarkNavyBlue => new(0, 2, 46);
    public static Color DarkOlive => new(55, 62, 2);
    public static Color DarkOliveGreen => new(60, 77, 3);
    public static Color DarkOrange => new(198, 81, 2);
    public static Color DarkPastelGreen => new(86, 174, 87);
    public static Color DarkPeach => new(222, 126, 93);
    public static Color DarkPeriwinkle => new(102, 95, 209);
    public static Color DarkPink => new(203, 65, 107);
    public static Color DarkPlum => new(63, 1, 44);
    public static Color DarkPurple => new(53, 6, 62);
    public static Color DarkRed => new(132, 0, 0);
    public static Color DarkRose => new(181, 72, 93);
    public static Color DarkRoyalBlue => new(2, 6, 111);
    public static Color DarkSage => new(89, 133, 86);
    public static Color DarkSalmon => new(200, 90, 83);
    public static Color DarkSand => new(168, 143, 89);
    public static Color DarkSeaGreen => new(17, 135, 93);
    public static Color DarkSeafoam => new(31, 181, 122);
    public static Color DarkSeafoamGreen => new(62, 175, 118);
    public static Color DarkSkyBlue => new(68, 142, 228);
    public static Color DarkSlateBlue => new(33, 71, 97);
    public static Color DarkTan => new(175, 136, 74);
    public static Color DarkTaupe => new(127, 104, 78);
    public static Color DarkTeal => new(1, 77, 78);
    public static Color DarkTurquoise => new(4, 92, 90);
    public static Color DarkViolet => new(52, 1, 63);
    public static Color DarkYellow => new(213, 182, 10);
    public static Color DarkYellowGreen => new(114, 143, 2);
    public static Color Darkblue => new(3, 7, 100);
    public static Color Darkgreen => new(5, 73, 7);
    public static Color DarkishBlue => new(1, 65, 130);
    public static Color DarkishGreen => new(40, 124, 55);
    public static Color DarkishPink => new(218, 70, 125);
    public static Color DarkishPurple => new(117, 25, 115);
    public static Color DarkishRed => new(169, 3, 8);
    public static Color DeepAqua => new(8, 120, 127);
    public static Color DeepBlue => new(4, 2, 115);
    public static Color DeepBrown => new(65, 2, 0);
    public static Color DeepGreen => new(2, 89, 15);
    public static Color DeepLavender => new(141, 94, 183);
    public static Color DeepLilac => new(150, 110, 189);
    public static Color DeepMagenta => new(160, 2, 92);
    public static Color DeepOrange => new(220, 77, 1);
    public static Color DeepPink => new(203, 1, 98);
    public static Color DeepPurple => new(54, 1, 63);
    public static Color DeepRed => new(154, 2, 0);
    public static Color DeepRose => new(199, 71, 103);
    public static Color DeepSeaBlue => new(1, 84, 130);
    public static Color DeepSkyBlue => new(13, 117, 248);
    public static Color DeepTeal => new(0, 85, 90);
    public static Color DeepTurquoise => new(1, 115, 116);
    public static Color DeepViolet => new(73, 6, 72);
    public static Color Denim => new(59, 99, 140);
    public static Color DenimBlue => new(59, 91, 146);
    public static Color Desert => new(204, 173, 96);
    public static Color Diarrhea => new(159, 131, 3);
    public static Color Dirt => new(138, 110, 69);
    public static Color DirtBrown => new(131, 101, 57);
    public static Color DirtyBlue => new(63, 130, 157);
    public static Color DirtyGreen => new(102, 126, 44);
    public static Color DirtyOrange => new(200, 118, 6);
    public static Color DirtyPink => new(202, 123, 128);
    public static Color DirtyPurple => new(115, 74, 101);
    public static Color DirtyYellow => new(205, 197, 10);
    public static Color DodgerBlue => new(62, 130, 252);
    public static Color Drab => new(130, 131, 68);
    public static Color DrabGreen => new(116, 149, 81);
    public static Color DriedBlood => new(75, 1, 1);
    public static Color DuckEggBlue => new(195, 251, 244);
    public static Color DullBlue => new(73, 117, 156);
    public static Color DullBrown => new(135, 110, 75);
    public static Color DullGreen => new(116, 166, 98);
    public static Color DullOrange => new(216, 134, 59);
    public static Color DullPink => new(213, 134, 157);
    public static Color DullPurple => new(132, 89, 126);
    public static Color DullRed => new(187, 63, 63);
    public static Color DullTeal => new(95, 158, 143);
    public static Color DullYellow => new(238, 220, 91);
    public static Color Dusk => new(78, 84, 129);
    public static Color DuskBlue => new(38, 83, 141);
    public static Color DuskyBlue => new(71, 95, 148);
    public static Color DuskyPink => new(204, 122, 139);
    public static Color DuskyPurple => new(137, 91, 123);
    public static Color DuskyRose => new(186, 104, 115);
    public static Color Dust => new(178, 153, 110);
    public static Color DustyBlue => new(90, 134, 173);
    public static Color DustyGreen => new(118, 169, 115);
    public static Color DustyLavender => new(172, 134, 168);
    public static Color DustyOrange => new(240, 131, 58);
    public static Color DustyPink => new(213, 138, 148);
    public static Color DustyPurple => new(130, 95, 135);
    public static Color DustyRed => new(185, 72, 78);
    public static Color DustyRose => new(192, 115, 122);
    public static Color DustyTeal => new(76, 144, 133);
    public static Color Earth => new(162, 101, 62);
    public static Color EasterGreen => new(140, 253, 126);
    public static Color EasterPurple => new(192, 113, 254);
    public static Color Ecru => new(254, 255, 202);
    public static Color EggShell => new(255, 252, 196);
    public static Color Eggplant => new(56, 8, 53);
    public static Color EggplantPurple => new(67, 5, 65);
    public static Color Eggshell => new(255, 255, 212);
    public static Color EggshellBlue => new(196, 255, 247);
    public static Color ElectricBlue => new(6, 82, 255);
    public static Color ElectricGreen => new(33, 252, 13);
    public static Color ElectricLime => new(168, 255, 4);
    public static Color ElectricPink => new(255, 4, 144);
    public static Color ElectricPurple => new(170, 35, 255);
    public static Color Emerald => new(1, 160, 73);
    public static Color EmeraldGreen => new(2, 143, 30);
    public static Color Evergreen => new(5, 71, 42);
    public static Color FadedBlue => new(101, 140, 187);
    public static Color FadedGreen => new(123, 178, 116);
    public static Color FadedOrange => new(240, 148, 77);
    public static Color FadedPink => new(222, 157, 172);
    public static Color FadedPurple => new(145, 110, 153);
    public static Color FadedRed => new(211, 73, 78);
    public static Color FadedYellow => new(254, 255, 127);
    public static Color Fawn => new(207, 175, 123);
    public static Color Fern => new(99, 169, 80);
    public static Color FernGreen => new(84, 141, 68);
    public static Color FireEngineRed => new(254, 0, 2);
    public static Color FlatBlue => new(60, 115, 168);
    public static Color FlatGreen => new(105, 157, 76);
    public static Color FluorescentGreen => new(8, 255, 8);
    public static Color FluroGreen => new(10, 255, 2);
    public static Color FoamGreen => new(144, 253, 169);
    public static Color Forest => new(11, 85, 9);
    public static Color ForestGreen => new(6, 71, 12);
    public static Color ForrestGreen => new(21, 68, 6);
    public static Color FrenchBlue => new(67, 107, 173);
    public static Color FreshGreen => new(105, 216, 79);
    public static Color FrogGreen => new(88, 188, 8);
    public static Color Fuchsia => new(237, 13, 217);
    public static Color Gold => new(219, 180, 12);
    public static Color Golden => new(245, 191, 3);
    public static Color GoldenBrown => new(178, 122, 1);
    public static Color GoldenRod => new(249, 188, 8);
    public static Color GoldenYellow => new(254, 198, 21);
    public static Color Goldenrod => new(250, 194, 5);
    public static Color Grape => new(108, 52, 97);
    public static Color GrapePurple => new(93, 20, 81);
    public static Color Grapefruit => new(253, 89, 86);
    public static Color Grass => new(92, 172, 45);
    public static Color GrassGreen => new(63, 155, 11);
    public static Color GrassyGreen => new(65, 156, 3);
    public static Color Green => new(21, 176, 26);
    public static Color GreenApple => new(94, 220, 31);
    public static Color GreenBlue => new(6, 180, 139);
    public static Color GreenBrown => new(84, 78, 3);
    public static Color GreenGrey => new(119, 146, 111);
    public static Color GreenSlashBlue => new(1, 192, 141);
    public static Color GreenSlashYellow => new(181, 206, 8);
    public static Color GreenTeal => new(12, 181, 119);
    public static Color GreenYellow => new(201, 255, 39);
    public static Color Greenblue => new(35, 196, 139);
    public static Color Greenish => new(64, 163, 104);
    public static Color GreenishBeige => new(201, 209, 121);
    public static Color GreenishBlue => new(11, 139, 135);
    public static Color GreenishBrown => new(105, 97, 18);
    public static Color GreenishCyan => new(42, 254, 183);
    public static Color GreenishGrey => new(150, 174, 141);
    public static Color GreenishTan => new(188, 203, 122);
    public static Color GreenishTeal => new(50, 191, 132);
    public static Color GreenishTurquoise => new(0, 251, 176);
    public static Color GreenishYellow => new(205, 253, 2);
    public static Color GreenyBlue => new(66, 179, 149);
    public static Color GreenyBrown => new(105, 96, 6);
    public static Color GreenyGrey => new(126, 160, 122);
    public static Color GreenyYellow => new(198, 248, 8);
    public static Color Grey => new(146, 149, 145);
    public static Color GreyBlue => new(107, 139, 164);
    public static Color GreyBrown => new(127, 112, 83);
    public static Color GreyGreen => new(120, 155, 115);
    public static Color GreyPink => new(195, 144, 155);
    public static Color GreyPurple => new(130, 109, 140);
    public static Color GreySlashBlue => new(100, 125, 142);
    public static Color GreySlashGreen => new(134, 161, 125);
    public static Color GreyTeal => new(94, 155, 138);
    public static Color Greyblue => new(119, 161, 181);
    public static Color Greyish => new(168, 164, 149);
    public static Color GreyishBlue => new(94, 129, 157);
    public static Color GreyishBrown => new(122, 106, 79);
    public static Color GreyishGreen => new(130, 166, 125);
    public static Color GreyishPink => new(200, 141, 148);
    public static Color GreyishPurple => new(136, 113, 145);
    public static Color GreyishTeal => new(113, 159, 145);
    public static Color GrossGreen => new(160, 191, 22);
    public static Color Gunmetal => new(83, 98, 103);
    public static Color Hazel => new(142, 118, 24);
    public static Color Heather => new(164, 132, 172);
    public static Color Heliotrope => new(217, 79, 245);
    public static Color HighlighterGreen => new(27, 252, 6);
    public static Color HospitalGreen => new(155, 229, 170);
    public static Color HotGreen => new(37, 255, 41);
    public static Color HotMagenta => new(245, 4, 201);
    public static Color HotPink => new(255, 2, 141);
    public static Color HotPurple => new(203, 0, 245);
    public static Color HunterGreen => new(11, 64, 8);
    public static Color Ice => new(214, 255, 250);
    public static Color IceBlue => new(215, 255, 254);
    public static Color IckyGreen => new(143, 174, 34);
    public static Color IndianRed => new(133, 14, 4);
    public static Color Indigo => new(56, 2, 130);
    public static Color IndigoBlue => new(58, 24, 177);
    public static Color Iris => new(98, 88, 196);
    public static Color IrishGreen => new(1, 149, 41);
    public static Color Ivory => new(255, 255, 203);
    public static Color Jade => new(31, 167, 116);
    public static Color JadeGreen => new(43, 175, 106);
    public static Color JungleGreen => new(4, 130, 67);
    public static Color KelleyGreen => new(0, 147, 55);
    public static Color KellyGreen => new(2, 171, 46);
    public static Color KermitGreen => new(92, 178, 0);
    public static Color KeyLime => new(174, 255, 110);
    public static Color Khaki => new(170, 166, 98);
    public static Color KhakiGreen => new(114, 134, 57);
    public static Color Kiwi => new(156, 239, 67);
    public static Color KiwiGreen => new(142, 229, 63);
    public static Color Lavender => new(199, 159, 239);
    public static Color LavenderBlue => new(139, 136, 248);
    public static Color LavenderPink => new(221, 133, 215);
    public static Color LawnGreen => new(77, 164, 9);
    public static Color Leaf => new(113, 170, 52);
    public static Color LeafGreen => new(92, 169, 4);
    public static Color LeafyGreen => new(81, 183, 59);
    public static Color Leather => new(172, 116, 52);
    public static Color Lemon => new(253, 255, 82);
    public static Color LemonGreen => new(173, 248, 2);
    public static Color LemonLime => new(191, 254, 40);
    public static Color LemonYellow => new(253, 255, 56);
    public static Color Lichen => new(143, 182, 123);
    public static Color LightAqua => new(140, 255, 219);
    public static Color LightAquamarine => new(123, 253, 199);
    public static Color LightBeige => new(255, 254, 182);
    public static Color LightBlue => new(149, 208, 252);
    public static Color LightBlueGreen => new(126, 251, 179);
    public static Color LightBlueGrey => new(183, 201, 226);
    public static Color LightBluishGreen => new(118, 253, 168);
    public static Color LightBrightGreen => new(83, 254, 92);
    public static Color LightBrown => new(173, 129, 80);
    public static Color LightBurgundy => new(168, 65, 91);
    public static Color LightCyan => new(172, 255, 252);
    public static Color LightEggplant => new(137, 69, 133);
    public static Color LightForestGreen => new(79, 145, 83);
    public static Color LightGold => new(253, 220, 92);
    public static Color LightGrassGreen => new(154, 247, 100);
    public static Color LightGreen => new(150, 249, 123);
    public static Color LightGreenBlue => new(86, 252, 162);
    public static Color LightGreenishBlue => new(99, 247, 180);
    public static Color LightGrey => new(216, 220, 214);
    public static Color LightGreyBlue => new(157, 188, 212);
    public static Color LightGreyGreen => new(183, 225, 161);
    public static Color LightIndigo => new(109, 90, 207);
    public static Color LightKhaki => new(230, 242, 162);
    public static Color LightLavendar => new(239, 192, 254);
    public static Color LightLavender => new(223, 197, 254);
    public static Color LightLightBlue => new(202, 255, 251);
    public static Color LightLightGreen => new(200, 255, 176);
    public static Color LightLilac => new(237, 200, 255);
    public static Color LightLime => new(174, 253, 108);
    public static Color LightLimeGreen => new(185, 255, 102);
    public static Color LightMagenta => new(250, 95, 247);
    public static Color LightMaroon => new(162, 72, 87);
    public static Color LightMauve => new(194, 146, 161);
    public static Color LightMint => new(182, 255, 187);
    public static Color LightMintGreen => new(166, 251, 178);
    public static Color LightMossGreen => new(166, 200, 117);
    public static Color LightMustard => new(247, 213, 96);
    public static Color LightNavy => new(21, 80, 132);
    public static Color LightNavyBlue => new(46, 90, 136);
    public static Color LightNeonGreen => new(78, 253, 84);
    public static Color LightOlive => new(172, 191, 105);
    public static Color LightOliveGreen => new(164, 190, 92);
    public static Color LightOrange => new(253, 170, 72);
    public static Color LightPastelGreen => new(178, 251, 165);
    public static Color LightPeaGreen => new(196, 254, 130);
    public static Color LightPeach => new(255, 216, 177);
    public static Color LightPeriwinkle => new(193, 198, 252);
    public static Color LightPink => new(255, 209, 223);
    public static Color LightPlum => new(157, 87, 131);
    public static Color LightPurple => new(191, 119, 246);
    public static Color LightRed => new(255, 71, 76);
    public static Color LightRose => new(255, 197, 203);
    public static Color LightRoyalBlue => new(58, 46, 254);
    public static Color LightSage => new(188, 236, 172);
    public static Color LightSalmon => new(254, 169, 147);
    public static Color LightSeaGreen => new(152, 246, 176);
    public static Color LightSeafoam => new(160, 254, 191);
    public static Color LightSeafoamGreen => new(167, 255, 181);
    public static Color LightSkyBlue => new(198, 252, 255);
    public static Color LightTan => new(251, 238, 172);
    public static Color LightTeal => new(144, 228, 193);
    public static Color LightTurquoise => new(126, 244, 204);
    public static Color LightUrple => new(179, 111, 246);
    public static Color LightViolet => new(214, 180, 252);
    public static Color LightYellow => new(255, 254, 122);
    public static Color LightYellowGreen => new(204, 253, 127);
    public static Color LightYellowishGreen => new(194, 255, 137);
    public static Color Lightblue => new(123, 200, 246);
    public static Color LighterGreen => new(117, 253, 99);
    public static Color LighterPurple => new(165, 90, 244);
    public static Color Lightgreen => new(118, 255, 123);
    public static Color LightishBlue => new(61, 122, 253);
    public static Color LightishGreen => new(97, 225, 96);
    public static Color LightishPurple => new(165, 82, 230);
    public static Color LightishRed => new(254, 47, 74);
    public static Color Lilac => new(206, 162, 253);
    public static Color Liliac => new(196, 142, 253);
    public static Color Lime => new(170, 255, 50);
    public static Color LimeGreen => new(137, 254, 5);
    public static Color LimeYellow => new(208, 254, 29);
    public static Color Lipstick => new(213, 23, 78);
    public static Color LipstickRed => new(192, 2, 47);
    public static Color MacaroniAndCheese => new(239, 180, 53);
    public static Color Magenta => new(194, 0, 120);
    public static Color Mahogany => new(74, 1, 0);
    public static Color Maize => new(244, 208, 84);
    public static Color Mango => new(255, 166, 43);
    public static Color Manilla => new(255, 250, 134);
    public static Color Marigold => new(252, 192, 6);
    public static Color Marine => new(4, 46, 96);
    public static Color MarineBlue => new(1, 56, 106);
    public static Color Maroon => new(101, 0, 33);
    public static Color Mauve => new(174, 113, 129);
    public static Color MediumBlue => new(44, 111, 187);
    public static Color MediumBrown => new(127, 81, 18);
    public static Color MediumGreen => new(57, 173, 72);
    public static Color MediumGrey => new(125, 127, 124);
    public static Color MediumPink => new(243, 97, 150);
    public static Color MediumPurple => new(158, 67, 162);
    public static Color Melon => new(255, 120, 85);
    public static Color Merlot => new(115, 0, 57);
    public static Color MetallicBlue => new(79, 115, 142);
    public static Color MidBlue => new(39, 106, 179);
    public static Color MidGreen => new(80, 167, 71);
    public static Color Midnight => new(3, 1, 45);
    public static Color MidnightBlue => new(2, 0, 53);
    public static Color MidnightPurple => new(40, 1, 55);
    public static Color MilitaryGreen => new(102, 124, 62);
    public static Color MilkChocolate => new(127, 78, 30);
    public static Color Mint => new(159, 254, 176);
    public static Color MintGreen => new(143, 255, 159);
    public static Color MintyGreen => new(11, 247, 125);
    public static Color Mocha => new(157, 118, 81);
    public static Color Moss => new(118, 153, 88);
    public static Color MossGreen => new(101, 139, 56);
    public static Color MossyGreen => new(99, 139, 39);
    public static Color Mud => new(115, 92, 18);
    public static Color MudBrown => new(96, 70, 15);
    public static Color MudGreen => new(96, 102, 2);
    public static Color MuddyBrown => new(136, 104, 6);
    public static Color MuddyGreen => new(101, 116, 50);
    public static Color MuddyYellow => new(191, 172, 5);
    public static Color Mulberry => new(146, 10, 78);
    public static Color MurkyGreen => new(108, 122, 14);
    public static Color Mushroom => new(186, 158, 136);
    public static Color Mustard => new(206, 179, 1);
    public static Color MustardBrown => new(172, 126, 4);
    public static Color MustardGreen => new(168, 181, 4);
    public static Color MustardYellow => new(210, 189, 10);
    public static Color MutedBlue => new(59, 113, 159);
    public static Color MutedGreen => new(95, 160, 82);
    public static Color MutedPink => new(209, 118, 143);
    public static Color MutedPurple => new(128, 91, 135);
    public static Color NastyGreen => new(112, 178, 63);
    public static Color Navy => new(1, 21, 62);
    public static Color NavyBlue => new(0, 17, 70);
    public static Color NavyGreen => new(53, 83, 10);
    public static Color NeonBlue => new(4, 217, 255);
    public static Color NeonGreen => new(12, 255, 12);
    public static Color NeonPink => new(254, 1, 154);
    public static Color NeonPurple => new(188, 19, 254);
    public static Color NeonRed => new(255, 7, 58);
    public static Color NeonYellow => new(207, 255, 4);
    public static Color NiceBlue => new(16, 122, 176);
    public static Color NightBlue => new(4, 3, 72);
    public static Color Ocean => new(1, 123, 146);
    public static Color OceanBlue => new(3, 113, 156);
    public static Color OceanGreen => new(61, 153, 115);
    public static Color Ocher => new(191, 155, 12);
    public static Color Ochre => new(191, 144, 5);
    public static Color Ocre => new(198, 156, 4);
    public static Color OffBlue => new(86, 132, 174);
    public static Color OffGreen => new(107, 163, 83);
    public static Color OffWhite => new(255, 255, 228);
    public static Color OffYellow => new(241, 243, 63);
    public static Color OldPink => new(199, 121, 134);
    public static Color OldRose => new(200, 127, 137);
    public static Color Olive => new(110, 117, 14);
    public static Color OliveBrown => new(100, 84, 3);
    public static Color OliveDrab => new(111, 118, 50);
    public static Color OliveGreen => new(103, 122, 4);
    public static Color OliveYellow => new(194, 183, 9);
    public static Color Orange => new(249, 115, 6);
    public static Color OrangeBrown => new(190, 100, 0);
    public static Color OrangePink => new(255, 111, 82);
    public static Color OrangeRed => new(253, 65, 30);
    public static Color OrangeYellow => new(255, 173, 1);
    public static Color Orangeish => new(253, 141, 73);
    public static Color Orangered => new(254, 66, 15);
    public static Color OrangeyBrown => new(177, 96, 2);
    public static Color OrangeyRed => new(250, 66, 36);
    public static Color OrangeyYellow => new(253, 185, 21);
    public static Color Orangish => new(252, 130, 74);
    public static Color OrangishBrown => new(178, 95, 3);
    public static Color OrangishRed => new(244, 54, 5);
    public static Color Orchid => new(200, 117, 196);
    public static Color Pale => new(255, 249, 208);
    public static Color PaleAqua => new(184, 255, 235);
    public static Color PaleBlue => new(208, 254, 254);
    public static Color PaleBrown => new(177, 145, 110);
    public static Color PaleCyan => new(183, 255, 250);
    public static Color PaleGold => new(253, 222, 108);
    public static Color PaleGreen => new(199, 253, 181);
    public static Color PaleGrey => new(253, 253, 254);
    public static Color PaleLavender => new(238, 207, 254);
    public static Color PaleLightGreen => new(177, 252, 153);
    public static Color PaleLilac => new(228, 203, 255);
    public static Color PaleLime => new(190, 253, 115);
    public static Color PaleLimeGreen => new(177, 255, 101);
    public static Color PaleMagenta => new(215, 103, 173);
    public static Color PaleMauve => new(254, 208, 252);
    public static Color PaleOlive => new(185, 204, 129);
    public static Color PaleOliveGreen => new(177, 210, 123);
    public static Color PaleOrange => new(255, 167, 86);
    public static Color PalePeach => new(255, 229, 173);
    public static Color PalePink => new(255, 207, 220);
    public static Color PalePurple => new(183, 144, 212);
    public static Color PaleRed => new(217, 84, 77);
    public static Color PaleRose => new(253, 193, 197);
    public static Color PaleSalmon => new(255, 177, 154);
    public static Color PaleSkyBlue => new(189, 246, 254);
    public static Color PaleTeal => new(130, 203, 178);
    public static Color PaleTurquoise => new(165, 251, 213);
    public static Color PaleViolet => new(206, 174, 250);
    public static Color PaleYellow => new(255, 255, 132);
    public static Color Parchment => new(254, 252, 175);
    public static Color PastelBlue => new(162, 191, 254);
    public static Color PastelGreen => new(176, 255, 157);
    public static Color PastelOrange => new(255, 150, 79);
    public static Color PastelPink => new(255, 186, 205);
    public static Color PastelPurple => new(202, 160, 255);
    public static Color PastelRed => new(219, 88, 86);
    public static Color PastelYellow => new(255, 254, 113);
    public static Color Pea => new(164, 191, 32);
    public static Color PeaGreen => new(142, 171, 18);
    public static Color PeaSoup => new(146, 153, 1);
    public static Color PeaSoupGreen => new(148, 166, 23);
    public static Color Peach => new(255, 176, 124);
    public static Color PeachyPink => new(255, 154, 138);
    public static Color PeacockBlue => new(1, 103, 149);
    public static Color Pear => new(203, 248, 95);
    public static Color Periwinkle => new(142, 130, 254);
    public static Color PeriwinkleBlue => new(143, 153, 251);
    public static Color Perrywinkle => new(143, 140, 231);
    public static Color Petrol => new(0, 95, 106);
    public static Color PigPink => new(231, 142, 165);
    public static Color Pine => new(43, 93, 52);
    public static Color PineGreen => new(10, 72, 30);
    public static Color Pink => new(255, 129, 192);
    public static Color PinkPurple => new(219, 75, 218);
    public static Color PinkRed => new(245, 5, 79);
    public static Color PinkSlashPurple => new(239, 29, 231);
    public static Color Pinkish => new(212, 106, 126);
    public static Color PinkishBrown => new(177, 114, 97);
    public static Color PinkishGrey => new(200, 172, 169);
    public static Color PinkishOrange => new(255, 114, 76);
    public static Color PinkishPurple => new(214, 72, 215);
    public static Color PinkishRed => new(241, 12, 69);
    public static Color PinkishTan => new(217, 155, 130);
    public static Color Pinky => new(252, 134, 170);
    public static Color PinkyPurple => new(201, 76, 190);
    public static Color PinkyRed => new(252, 38, 71);
    public static Color PissYellow => new(221, 214, 24);
    public static Color Pistachio => new(192, 250, 139);
    public static Color Plum => new(88, 15, 65);
    public static Color PlumPurple => new(78, 5, 80);
    public static Color PoisonGreen => new(64, 253, 20);
    public static Color Poo => new(143, 115, 3);
    public static Color PooBrown => new(136, 95, 1);
    public static Color Poop => new(127, 94, 0);
    public static Color PoopBrown => new(122, 89, 1);
    public static Color PoopGreen => new(111, 124, 0);
    public static Color PowderBlue => new(177, 209, 252);
    public static Color PowderPink => new(255, 178, 208);
    public static Color PrimaryBlue => new(8, 4, 249);
    public static Color PrussianBlue => new(0, 69, 119);
    public static Color Puce => new(165, 126, 82);
    public static Color Puke => new(165, 165, 2);
    public static Color PukeBrown => new(148, 119, 6);
    public static Color PukeGreen => new(154, 174, 7);
    public static Color PukeYellow => new(194, 190, 14);
    public static Color Pumpkin => new(225, 119, 1);
    public static Color PumpkinOrange => new(251, 125, 7);
    public static Color PureBlue => new(2, 3, 226);
    public static Color Purple => new(126, 30, 156);
    public static Color PurpleBlue => new(99, 45, 233);
    public static Color PurpleBrown => new(103, 58, 63);
    public static Color PurpleGrey => new(134, 111, 133);
    public static Color PurplePink => new(224, 63, 216);
    public static Color PurpleRed => new(153, 1, 71);
    public static Color PurpleSlashBlue => new(93, 33, 208);
    public static Color PurpleSlashPink => new(215, 37, 222);
    public static Color Purpleish => new(152, 86, 141);
    public static Color PurpleishBlue => new(97, 64, 239);
    public static Color PurpleishPink => new(223, 78, 200);
    public static Color Purpley => new(135, 86, 228);
    public static Color PurpleyBlue => new(95, 52, 231);
    public static Color PurpleyGrey => new(148, 126, 148);
    public static Color PurpleyPink => new(200, 60, 185);
    public static Color Purplish => new(148, 86, 140);
    public static Color PurplishBlue => new(96, 30, 249);
    public static Color PurplishBrown => new(107, 66, 71);
    public static Color PurplishGrey => new(122, 104, 127);
    public static Color PurplishPink => new(206, 93, 174);
    public static Color PurplishRed => new(176, 5, 75);
    public static Color Purply => new(152, 63, 178);
    public static Color PurplyBlue => new(102, 26, 238);
    public static Color PurplyPink => new(240, 117, 230);
    public static Color Putty => new(190, 174, 138);
    public static Color RacingGreen => new(1, 70, 0);
    public static Color RadioactiveGreen => new(44, 250, 31);
    public static Color Raspberry => new(176, 1, 73);
    public static Color RawSienna => new(154, 98, 0);
    public static Color RawUmber => new(167, 94, 9);
    public static Color ReallyLightBlue => new(212, 255, 255);
    public static Color Red => new(229, 0, 0);
    public static Color RedBrown => new(139, 46, 22);
    public static Color RedOrange => new(253, 60, 6);
    public static Color RedPink => new(250, 42, 85);
    public static Color RedPurple => new(130, 7, 71);
    public static Color RedViolet => new(158, 1, 104);
    public static Color RedWine => new(140, 0, 52);
    public static Color Reddish => new(196, 66, 64);
    public static Color ReddishBrown => new(127, 43, 10);
    public static Color ReddishGrey => new(153, 117, 112);
    public static Color ReddishOrange => new(248, 72, 28);
    public static Color ReddishPink => new(254, 44, 84);
    public static Color ReddishPurple => new(145, 9, 81);
    public static Color ReddyBrown => new(110, 16, 5);
    public static Color RichBlue => new(2, 27, 249);
    public static Color RichPurple => new(114, 0, 88);
    public static Color RobinEggBlue => new(138, 241, 254);
    public static Color RobinsEgg => new(109, 237, 253);
    public static Color RobinsEggBlue => new(152, 239, 249);
    public static Color Rosa => new(254, 134, 164);
    public static Color Rose => new(207, 98, 117);
    public static Color RosePink => new(247, 135, 154);
    public static Color RoseRed => new(190, 1, 60);
    public static Color RosyPink => new(246, 104, 142);
    public static Color Rouge => new(171, 18, 57);
    public static Color Royal => new(12, 23, 147);
    public static Color RoyalBlue => new(5, 4, 170);
    public static Color RoyalPurple => new(75, 0, 110);
    public static Color Ruby => new(202, 1, 71);
    public static Color Russet => new(161, 57, 5);
    public static Color Rust => new(168, 60, 9);
    public static Color RustBrown => new(139, 49, 3);
    public static Color RustOrange => new(196, 85, 8);
    public static Color RustRed => new(170, 39, 4);
    public static Color RustyOrange => new(205, 89, 9);
    public static Color RustyRed => new(175, 47, 13);
    public static Color Saffron => new(254, 178, 9);
    public static Color Sage => new(135, 174, 115);
    public static Color SageGreen => new(136, 179, 120);
    public static Color Salmon => new(255, 121, 108);
    public static Color SalmonPink => new(254, 123, 124);
    public static Color Sand => new(226, 202, 118);
    public static Color SandBrown => new(203, 165, 96);
    public static Color SandYellow => new(252, 225, 102);
    public static Color Sandstone => new(201, 174, 116);
    public static Color Sandy => new(241, 218, 122);
    public static Color SandyBrown => new(196, 166, 97);
    public static Color SandyYellow => new(253, 238, 115);
    public static Color SapGreen => new(92, 139, 21);
    public static Color Sapphire => new(33, 56, 171);
    public static Color Scarlet => new(190, 1, 25);
    public static Color Sea => new(60, 153, 146);
    public static Color SeaBlue => new(4, 116, 149);
    public static Color SeaGreen => new(83, 252, 161);
    public static Color Seafoam => new(128, 249, 173);
    public static Color SeafoamBlue => new(120, 209, 182);
    public static Color SeafoamGreen => new(122, 249, 171);
    public static Color Seaweed => new(24, 209, 123);
    public static Color SeaweedGreen => new(53, 173, 107);
    public static Color Sepia => new(152, 94, 43);
    public static Color Shamrock => new(1, 180, 76);
    public static Color ShamrockGreen => new(2, 193, 77);
    public static Color Shit => new(127, 95, 0);
    public static Color ShitBrown => new(123, 88, 4);
    public static Color ShitGreen => new(117, 128, 0);
    public static Color ShockingPink => new(254, 2, 162);
    public static Color SickGreen => new(157, 185, 44);
    public static Color SicklyGreen => new(148, 178, 28);
    public static Color SicklyYellow => new(208, 228, 41);
    public static Color Sienna => new(169, 86, 30);
    public static Color Silver => new(197, 201, 199);
    public static Color Sky => new(130, 202, 252);
    public static Color SkyBlue => new(117, 187, 253);
    public static Color Slate => new(81, 101, 114);
    public static Color SlateBlue => new(91, 124, 153);
    public static Color SlateGreen => new(101, 141, 109);
    public static Color SlateGrey => new(89, 101, 109);
    public static Color SlimeGreen => new(153, 204, 4);
    public static Color Snot => new(172, 187, 13);
    public static Color SnotGreen => new(157, 193, 0);
    public static Color SoftBlue => new(100, 136, 234);
    public static Color SoftGreen => new(111, 194, 118);
    public static Color SoftPink => new(253, 176, 192);
    public static Color SoftPurple => new(166, 111, 181);
    public static Color Spearmint => new(30, 248, 118);
    public static Color SpringGreen => new(169, 249, 113);
    public static Color Spruce => new(10, 95, 56);
    public static Color Squash => new(242, 171, 21);
    public static Color Steel => new(115, 133, 149);
    public static Color SteelBlue => new(90, 125, 154);
    public static Color SteelGrey => new(111, 130, 138);
    public static Color Stone => new(173, 165, 135);
    public static Color StormyBlue => new(80, 123, 156);
    public static Color Straw => new(252, 246, 121);
    public static Color Strawberry => new(251, 41, 67);
    public static Color StrongBlue => new(12, 6, 247);
    public static Color StrongPink => new(255, 7, 137);
    public static Color SunYellow => new(255, 223, 34);
    public static Color Sunflower => new(255, 197, 18);
    public static Color SunflowerYellow => new(255, 218, 3);
    public static Color SunnyYellow => new(255, 249, 23);
    public static Color SunshineYellow => new(255, 253, 55);
    public static Color Swamp => new(105, 131, 57);
    public static Color SwampGreen => new(116, 133, 0);
    public static Color Tan => new(209, 178, 111);
    public static Color TanBrown => new(171, 126, 76);
    public static Color TanGreen => new(169, 190, 112);
    public static Color Tangerine => new(255, 148, 8);
    public static Color Taupe => new(185, 162, 129);
    public static Color Tea => new(101, 171, 124);
    public static Color TeaGreen => new(189, 248, 163);
    public static Color Teal => new(2, 147, 134);
    public static Color TealBlue => new(1, 136, 159);
    public static Color TealGreen => new(37, 163, 111);
    public static Color Tealish => new(36, 188, 168);
    public static Color TealishGreen => new(12, 220, 115);
    public static Color TerraCotta => new(201, 100, 59);
    public static Color Terracota => new(203, 104, 67);
    public static Color Terracotta => new(202, 102, 65);
    public static Color TiffanyBlue => new(123, 242, 218);
    public static Color Tomato => new(239, 64, 38);
    public static Color TomatoRed => new(236, 45, 1);
    public static Color Topaz => new(19, 187, 175);
    public static Color Toupe => new(199, 172, 125);
    public static Color ToxicGreen => new(97, 222, 42);
    public static Color TreeGreen => new(42, 126, 25);
    public static Color TrueBlue => new(1, 15, 204);
    public static Color TrueGreen => new(8, 148, 4);
    public static Color Turquoise => new(6, 194, 172);
    public static Color TurquoiseBlue => new(6, 177, 196);
    public static Color TurquoiseGreen => new(4, 244, 137);
    public static Color TurtleGreen => new(117, 184, 79);
    public static Color Twilight => new(78, 81, 139);
    public static Color TwilightBlue => new(10, 67, 122);
    public static Color UglyBlue => new(49, 102, 138);
    public static Color UglyBrown => new(125, 113, 3);
    public static Color UglyGreen => new(122, 151, 3);
    public static Color UglyPink => new(205, 117, 132);
    public static Color UglyPurple => new(164, 66, 160);
    public static Color UglyYellow => new(208, 193, 1);
    public static Color Ultramarine => new(32, 0, 177);
    public static Color UltramarineBlue => new(24, 5, 219);
    public static Color Umber => new(178, 100, 0);
    public static Color Velvet => new(117, 8, 81);
    public static Color Vermillion => new(244, 50, 12);
    public static Color VeryDarkBlue => new(0, 1, 51);
    public static Color VeryDarkBrown => new(29, 2, 0);
    public static Color VeryDarkGreen => new(6, 46, 3);
    public static Color VeryDarkPurple => new(42, 1, 52);
    public static Color VeryLightBlue => new(213, 255, 255);
    public static Color VeryLightBrown => new(211, 182, 131);
    public static Color VeryLightGreen => new(209, 255, 189);
    public static Color VeryLightPink => new(255, 244, 242);
    public static Color VeryLightPurple => new(246, 206, 252);
    public static Color VeryPaleBlue => new(214, 255, 254);
    public static Color VeryPaleGreen => new(207, 253, 188);
    public static Color VibrantBlue => new(3, 57, 248);
    public static Color VibrantGreen => new(10, 221, 8);
    public static Color VibrantPurple => new(173, 3, 222);
    public static Color Violet => new(154, 14, 234);
    public static Color VioletBlue => new(81, 10, 201);
    public static Color VioletPink => new(251, 95, 252);
    public static Color VioletRed => new(165, 0, 85);
    public static Color Viridian => new(30, 145, 103);
    public static Color VividBlue => new(21, 46, 255);
    public static Color VividGreen => new(47, 239, 16);
    public static Color VividPurple => new(153, 0, 250);
    public static Color Vomit => new(162, 164, 21);
    public static Color VomitGreen => new(137, 162, 3);
    public static Color VomitYellow => new(199, 193, 12);
    public static Color WarmBlue => new(75, 87, 219);
    public static Color WarmBrown => new(150, 78, 2);
    public static Color WarmGrey => new(151, 138, 132);
    public static Color WarmPink => new(251, 85, 129);
    public static Color WarmPurple => new(149, 46, 143);
    public static Color WashedOutGreen => new(188, 245, 166);
    public static Color WaterBlue => new(14, 135, 204);
    public static Color Watermelon => new(253, 70, 89);
    public static Color WeirdGreen => new(58, 229, 127);
    public static Color Wheat => new(251, 221, 126);
    public static Color White => new(255, 255, 255);
    public static Color WindowsBlue => new(55, 120, 191);
    public static Color Wine => new(128, 1, 63);
    public static Color WineRed => new(123, 3, 35);
    public static Color Wintergreen => new(32, 249, 134);
    public static Color Wisteria => new(168, 125, 194);
    public static Color Yellow => new(255, 255, 20);
    public static Color YellowBrown => new(183, 148, 0);
    public static Color YellowGreen => new(192, 251, 45);
    public static Color YellowOchre => new(203, 157, 6);
    public static Color YellowOrange => new(252, 176, 1);
    public static Color YellowSlashGreen => new(200, 253, 61);
    public static Color YellowTan => new(255, 227, 110);
    public static Color Yellowgreen => new(187, 249, 15);
    public static Color Yellowish => new(250, 238, 102);
    public static Color YellowishBrown => new(155, 122, 1);
    public static Color YellowishGreen => new(176, 221, 22);
    public static Color YellowishOrange => new(255, 171, 15);
    public static Color YellowishTan => new(252, 252, 129);
    public static Color YellowyBrown => new(174, 139, 12);
    public static Color YellowyGreen => new(191, 241, 40);
}
