﻿/* Inferno is a colormap by Nathaniel J. Smith and Stefan van der Walt
 * https://bids.github.io/colormap/
 * https://github.com/BIDS/colormap/blob/master/colormaps.py
 * 
 * This colormap is provided under the CC0 license / public domain dedication
 * http://creativecommons.org/publicdomain/zero/1.0/
 */

namespace ScottPlot.Colormaps;

public class Inferno : IColormap
{
    public string Name => "Inferno";
    private readonly CustomPalette Colormap;
    public Color GetColor(double position) => Colormap.GetColor(position);

    public Inferno()
    {
        int[] rgbColors =
        [
            00000003, 00000004, 00000006, 00065543, 00065801, 00065803, 00131342, 00131600,
            00197138, 00262932, 00262934, 00328728, 00394267, 00460061, 00525855, 00591393,
            00657187, 00722726, 00854056, 00919594, 00985389, 01050927, 01182258, 01247796,
            01313590, 01444665, 01510203, 01641278, 01706816, 01838147, 01903685, 02034759,
            02100298, 02231116, 02362190, 02493264, 02558802, 02689876, 02820694, 02951768,
            03017306, 03148380, 03279197, 03410271, 03475808, 03606881, 03737954, 03869028,
            03934565, 04065638, 04196710, 04262247, 04393576, 04524649, 04590185, 04721514,
            04852586, 04918379, 05049451, 05180780, 05246316, 05377644, 05443181, 05574509,
            05705581, 05771373, 05902701, 05968238, 06099566, 06230638, 06296430, 06427758,
            06493294, 06624622, 06690158, 06821486, 06952814, 07018350, 07149678, 07215214,
            07346542, 07477613, 07543405, 07674733, 07740269, 07871597, 08002669, 08068460,
            08199532, 08265324, 08396651, 08462187, 08593515, 08724586, 08790378, 08921450,
            08987241, 09118313, 09249641, 09315432, 09446504, 09512295, 09643367, 09774694,
            09840230, 09971557, 10037348, 10168420, 10234211, 10365283, 10496610, 10562401,
            10693473, 10759264, 10890335, 10956127, 11087454, 11218525, 11284316, 11415643,
            11481435, 11612506, 11678297, 11809624, 11875159, 12006486, 12072278, 12203605,
            12269396, 12400467, 12466258, 12532049, 12663376, 12729167, 12860494, 12926285,
            13057612, 13123147, 13188938, 13320265, 13386056, 13451847, 13583430, 13649220,
            13715011, 13780802, 13912129, 13977920, 14043711, 14109502, 14241085, 14306875,
            14372666, 14438457, 14504504, 14570295, 14636086, 14702132, 14833459, 14899250,
            14965297, 15031088, 15096878, 15097389, 15163180, 15229227, 15295018, 15361064,
            15426855, 15492902, 15558693, 15559203, 15625250, 15691041, 15757087, 15757342,
            15823389, 15889436, 15889690, 15955737, 15956248, 16022038, 16088085, 16088596,
            16154642, 16154897, 16220944, 16221454, 16287501, 16287756, 16288267, 16354313,
            16354824, 16355336, 16421127, 16421638, 16422150, 16422662, 16488710, 16489222,
            16489734, 16489991, 16490503, 16491016, 16491530, 16492043, 16492557, 16493070,
            16493584, 16494098, 16494612, 16494870, 16495384, 16495898, 16496412, 16496926,
            16431905, 16432419, 16432933, 16433448, 16368426, 16368940, 16369455, 16304433,
            16304948, 16305463, 16240442, 16240956, 16175935, 16176450, 16111429, 16111944,
            16046923, 16047183, 15982162, 15982678, 15983193, 15918173, 15918688, 15853668,
            15853928, 15854444, 15854960, 15855220, 15855737, 15856253, 15922049, 15922309,
            15988361, 16054157, 16119953, 16186005, 16251801, 16383133, 16448928, 16580260,
        ];

        Color[] colors = rgbColors.Select(rgb => unchecked((uint)(0xFF << 24) | (uint)rgb)).Select(Color.FromARGB).ToArray();

        Colormap = new CustomPalette(colors);
    }
}
