﻿/* Plasma is a colormap by Nathaniel J. Smith and Stefan van der Walt
 * https://bids.github.io/colormap/
 * https://github.com/BIDS/colormap/blob/master/colormaps.py
 * 
 * This colormap is provided under the CC0 license / public domain dedication
 * http://creativecommons.org/publicdomain/zero/1.0/
 */

using System;

namespace ScottPlot.Drawing.Colormaps
{
    public class Plasma : IColormap
    {
        public string Name => "Plasma";

        public (byte r, byte g, byte b) GetRGB(byte value)
        {
            byte[] bytes = BitConverter.GetBytes(rgb[value]);
            return (bytes[2], bytes[1], bytes[0]);
        }

        private readonly int[] rgb =
        {
            00788358, 01050503, 01246857, 01377930, 01574539, 01771148, 01902221, 02033038,
            02164111, 02295184, 02426257, 02557330, 02688403, 02819476, 02950292, 03081365,
            03212438, 03343511, 03409048, 03540120, 03671193, 03802266, 03867546, 03998619,
            04129692, 04195228, 04326301, 04457374, 04522910, 04653727, 04784799, 04850336,
            04981409, 05112481, 05178018, 05308834, 05374371, 05505443, 05636515, 05702052,
            05833124, 05898405, 06029477, 06160549, 06226086, 06357158, 06422694, 06553767,
            06619303, 06750375, 06815911, 06946983, 07078056, 07143592, 07274664, 07340200,
            07471272, 07536808, 07667880, 07733672, 07864744, 07930280, 08061608, 08127143,
            08258471, 08324007, 08455335, 08520871, 08652198, 08717990, 08783782, 08914853,
            08980645, 09111972, 09177764, 09309348, 09375139, 09440931, 09572258, 09638049,
            09769377, 09835168, 09900960, 10032287, 10098078, 10164126, 10295453, 10361244,
            10427035, 10492827, 10624154, 10689945, 10755736, 10821527, 10953111, 11018902,
            11084693, 11150484, 11281811, 11347602, 11413393, 11479184, 11545231, 11611023,
            11676814, 11808141, 11873932, 11939723, 12005514, 12071561, 12137352, 12203143,
            12268934, 12334725, 12400516, 12466307, 12532098, 12598145, 12663936, 12729728,
            12795519, 12861310, 12927101, 12992892, 13058683, 13124730, 13190521, 13256312,
            13322103, 13387894, 13453685, 13519477, 13585268, 13651315, 13717106, 13717361,
            13783152, 13848943, 13914734, 13980525, 14046573, 14112364, 14112619, 14178410,
            14244201, 14309992, 14375783, 14441830, 14442086, 14507877, 14573668, 14639459,
            14639714, 14705761, 14771552, 14837344, 14903135, 14903390, 14969437, 15035228,
            15035483, 15101274, 15167066, 15233113, 15233368, 15299159, 15364950, 15365205,
            15431252, 15497044, 15497299, 15563090, 15563601, 15629392, 15695183, 15695438,
            15761485, 15761741, 15827532, 15893579, 15893834, 15959625, 15959880, 16025927,
            16026183, 16091974, 16092485, 16158276, 16158531, 16159042, 16224833, 16225089,
            16291136, 16291391, 16291902, 16357693, 16357948, 16423995, 16424250, 16424762,
            16425017, 16491064, 16491319, 16491574, 16557621, 16557877, 16558388, 16558643,
            16559154, 16559409, 16625457, 16625712, 16626223, 16626478, 16626989, 16627245,
            16627756, 16628011, 16628523, 16628778, 16629289, 16629801, 16630056, 16630568,
            16630823, 16631334, 16566054, 16566566, 16567077, 16567333, 16567845, 16502820,
            16503076, 16503588, 16438564, 16438820, 16439332, 16374052, 16374564, 16309540,
            16310052, 16244772, 16245285, 16180261, 16180517, 16115494, 16116006, 16050726,
            15985702, 15986214, 15921190, 15921446, 15856422, 15791397, 15791651, 15726625,
        };
    }
}
