"use strict";

var cov_1ia30hret7 = function () {
  var path = "/home/travis/build/commitizen/cz-cli/src/configLoader/getContent.js";
  var hash = "dd54b9863cc28669094c54e487b6ac45b6fa0f1b";
  var global = new Function("return this")();
  var gcv = "__coverage__";
  var coverageData = {
    path: "/home/travis/build/commitizen/cz-cli/src/configLoader/getContent.js",
    statementMap: {
      "0": {
        start: {
          line: 20,
          column: 23
        },
        end: {
          line: 20,
          column: 45
        }
      },
      "1": {
        start: {
          line: 21,
          column: 21
        },
        end: {
          line: 21,
          column: 75
        }
      },
      "2": {
        start: {
          line: 22,
          column: 23
        },
        end: {
          line: 22,
          column: 56
        }
      },
      "3": {
        start: {
          line: 23,
          column: 18
        },
        end: {
          line: 25,
          column: 40
        }
      },
      "4": {
        start: {
          line: 24,
          column: 20
        },
        end: {
          line: 24,
          column: 59
        }
      },
      "5": {
        start: {
          line: 25,
          column: 20
        },
        end: {
          line: 25,
          column: 40
        }
      },
      "6": {
        start: {
          line: 27,
          column: 4
        },
        end: {
          line: 42,
          column: 5
        }
      },
      "7": {
        start: {
          line: 28,
          column: 23
        },
        end: {
          line: 28,
          column: 40
        }
      },
      "8": {
        start: {
          line: 30,
          column: 8
        },
        end: {
          line: 32,
          column: 11
        }
      },
      "9": {
        start: {
          line: 34,
          column: 8
        },
        end: {
          line: 34,
          column: 22
        }
      },
      "10": {
        start: {
          line: 36,
          column: 8
        },
        end: {
          line: 39,
          column: 21
        }
      },
      "11": {
        start: {
          line: 41,
          column: 8
        },
        end: {
          line: 41,
          column: 20
        }
      },
      "12": {
        start: {
          line: 52,
          column: 4
        },
        end: {
          line: 54,
          column: 5
        }
      },
      "13": {
        start: {
          line: 53,
          column: 6
        },
        end: {
          line: 53,
          column: 13
        }
      },
      "14": {
        start: {
          line: 56,
          column: 25
        },
        end: {
          line: 56,
          column: 64
        }
      },
      "15": {
        start: {
          line: 57,
          column: 27
        },
        end: {
          line: 57,
          column: 54
        }
      },
      "16": {
        start: {
          line: 59,
          column: 4
        },
        end: {
          line: 61,
          column: 5
        }
      },
      "17": {
        start: {
          line: 60,
          column: 6
        },
        end: {
          line: 60,
          column: 47
        }
      },
      "18": {
        start: {
          line: 63,
          column: 20
        },
        end: {
          line: 63,
          column: 51
        }
      },
      "19": {
        start: {
          line: 64,
          column: 4
        },
        end: {
          line: 64,
          column: 56
        }
      },
      "20": {
        start: {
          line: 75,
          column: 22
        },
        end: {
          line: 75,
          column: 49
        }
      },
      "21": {
        start: {
          line: 77,
          column: 2
        },
        end: {
          line: 79,
          column: 3
        }
      },
      "22": {
        start: {
          line: 78,
          column: 4
        },
        end: {
          line: 78,
          column: 96
        }
      },
      "23": {
        start: {
          line: 81,
          column: 2
        },
        end: {
          line: 81,
          column: 50
        }
      }
    },
    fnMap: {
      "0": {
        name: "readConfigContent",
        decl: {
          start: {
            line: 19,
            column: 9
          },
          end: {
            line: 19,
            column: 26
          }
        },
        loc: {
          start: {
            line: 19,
            column: 40
          },
          end: {
            line: 43,
            column: 1
          }
        },
        line: 19
      },
      "1": {
        name: "(anonymous_1)",
        decl: {
          start: {
            line: 24,
            column: 6
          },
          end: {
            line: 24,
            column: 7
          }
        },
        loc: {
          start: {
            line: 24,
            column: 20
          },
          end: {
            line: 24,
            column: 59
          }
        },
        line: 24
      },
      "2": {
        name: "(anonymous_2)",
        decl: {
          start: {
            line: 25,
            column: 6
          },
          end: {
            line: 25,
            column: 7
          }
        },
        loc: {
          start: {
            line: 25,
            column: 20
          },
          end: {
            line: 25,
            column: 40
          }
        },
        line: 25
      },
      "3": {
        name: "getConfigContent",
        decl: {
          start: {
            line: 51,
            column: 9
          },
          end: {
            line: 51,
            column: 25
          }
        },
        loc: {
          start: {
            line: 51,
            column: 54
          },
          end: {
            line: 65,
            column: 1
          }
        },
        line: 51
      },
      "4": {
        name: "readConfigFileContent",
        decl: {
          start: {
            line: 73,
            column: 9
          },
          end: {
            line: 73,
            column: 30
          }
        },
        loc: {
          start: {
            line: 73,
            column: 44
          },
          end: {
            line: 82,
            column: 1
          }
        },
        line: 73
      }
    },
    branchMap: {
      "0": {
        loc: {
          start: {
            line: 21,
            column: 21
          },
          end: {
            line: 21,
            column: 75
          }
        },
        type: "binary-expr",
        locations: [{
          start: {
            line: 21,
            column: 21
          },
          end: {
            line: 21,
            column: 45
          }
        }, {
          start: {
            line: 21,
            column: 49
          },
          end: {
            line: 21,
            column: 75
          }
        }],
        line: 21
      },
      "1": {
        loc: {
          start: {
            line: 23,
            column: 18
          },
          end: {
            line: 25,
            column: 40
          }
        },
        type: "cond-expr",
        locations: [{
          start: {
            line: 24,
            column: 6
          },
          end: {
            line: 24,
            column: 59
          }
        }, {
          start: {
            line: 25,
            column: 6
          },
          end: {
            line: 25,
            column: 40
          }
        }],
        line: 23
      },
      "2": {
        loc: {
          start: {
            line: 52,
            column: 4
          },
          end: {
            line: 54,
            column: 5
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 52,
            column: 4
          },
          end: {
            line: 54,
            column: 5
          }
        }, {
          start: {
            line: 52,
            column: 4
          },
          end: {
            line: 54,
            column: 5
          }
        }],
        line: 52
      },
      "3": {
        loc: {
          start: {
            line: 59,
            column: 4
          },
          end: {
            line: 61,
            column: 5
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 59,
            column: 4
          },
          end: {
            line: 61,
            column: 5
          }
        }, {
          start: {
            line: 59,
            column: 4
          },
          end: {
            line: 61,
            column: 5
          }
        }],
        line: 59
      },
      "4": {
        loc: {
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        }, {
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        }],
        line: 77
      }
    },
    s: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0,
      "5": 0,
      "6": 0,
      "7": 0,
      "8": 0,
      "9": 0,
      "10": 0,
      "11": 0,
      "12": 0,
      "13": 0,
      "14": 0,
      "15": 0,
      "16": 0,
      "17": 0,
      "18": 0,
      "19": 0,
      "20": 0,
      "21": 0,
      "22": 0,
      "23": 0
    },
    f: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0
    },
    b: {
      "0": [0, 0],
      "1": [0, 0],
      "2": [0, 0],
      "3": [0, 0],
      "4": [0, 0]
    },
    _coverageSchema: "43e27e138ebf9cfc5966b082cf9a028302ed4184",
    hash: "dd54b9863cc28669094c54e487b6ac45b6fa0f1b"
  };
  var coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  return coverage[path] = coverageData;
}();

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var _stripJsonComments = _interopRequireDefault(require("strip-json-comments"));

var _isUtf = _interopRequireDefault(require("is-utf8"));

var _stripBom = _interopRequireDefault(require("strip-bom"));

var _configLoader = require("../configLoader");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = getConfigContent;
/**
 * Read the content of a configuration file
 * - if not js or json: strip any comments
 * - if js or json: require it
 * @param {String} configPath - full path to configuration file
 * @return {Object}
 */

exports.default = _default;

function readConfigContent(configPath) {
  cov_1ia30hret7.f[0]++;
  const parsedPath = (cov_1ia30hret7.s[0]++, _path.default.parse(configPath));
  const isRcFile = (cov_1ia30hret7.s[1]++, (cov_1ia30hret7.b[0][0]++, parsedPath.ext !== '.js') && (cov_1ia30hret7.b[0][1]++, parsedPath.ext !== '.json'));
  const jsonString = (cov_1ia30hret7.s[2]++, readConfigFileContent(configPath));
  const parse = (cov_1ia30hret7.s[3]++, isRcFile ? (cov_1ia30hret7.b[1][0]++, contents => {
    cov_1ia30hret7.f[1]++;
    cov_1ia30hret7.s[4]++;
    return JSON.parse((0, _stripJsonComments.default)(contents));
  }) : (cov_1ia30hret7.b[1][1]++, contents => {
    cov_1ia30hret7.f[2]++;
    cov_1ia30hret7.s[5]++;
    return JSON.parse(contents);
  }));
  cov_1ia30hret7.s[6]++;

  try {
    const parsed = (cov_1ia30hret7.s[7]++, parse(jsonString));
    cov_1ia30hret7.s[8]++;
    Object.defineProperty(parsed, 'configPath', {
      value: configPath
    });
    cov_1ia30hret7.s[9]++;
    return parsed;
  } catch (error) {
    cov_1ia30hret7.s[10]++;
    error.message = [`Parsing JSON at ${configPath} for commitizen config failed:`, error.mesasge].join('\n');
    cov_1ia30hret7.s[11]++;
    throw error;
  }
}
/**
 * Get content of the configuration file
 * @param {String} configPath - partial path to configuration file
 * @param {String} directory - directory path which will be joined with config argument
 * @return {Object}
 */


function getConfigContent(configPath, baseDirectory) {
  cov_1ia30hret7.f[3]++;
  cov_1ia30hret7.s[12]++;

  if (!configPath) {
    cov_1ia30hret7.b[2][0]++;
    cov_1ia30hret7.s[13]++;
    return;
  } else {
    cov_1ia30hret7.b[2][1]++;
  }

  const resolvedPath = (cov_1ia30hret7.s[14]++, _path.default.resolve(baseDirectory, configPath));
  const configBasename = (cov_1ia30hret7.s[15]++, _path.default.basename(resolvedPath));
  cov_1ia30hret7.s[16]++;

  if (!_fs.default.existsSync(resolvedPath)) {
    cov_1ia30hret7.b[3][0]++;
    cov_1ia30hret7.s[17]++;
    return (0, _configLoader.getNormalizedConfig)(resolvedPath);
  } else {
    cov_1ia30hret7.b[3][1]++;
  }

  const content = (cov_1ia30hret7.s[18]++, readConfigContent(resolvedPath));
  cov_1ia30hret7.s[19]++;
  return (0, _configLoader.getNormalizedConfig)(configBasename, content);
}

;
/**
 * Read proper content from config file.
 * If the chartset of the config file is not utf-8, one error will be thrown.
 * @param {String} configPath
 * @return {String}
 */

function readConfigFileContent(configPath) {
  cov_1ia30hret7.f[4]++;
  let rawBufContent = (cov_1ia30hret7.s[20]++, _fs.default.readFileSync(configPath));
  cov_1ia30hret7.s[21]++;

  if (!(0, _isUtf.default)(rawBufContent)) {
    cov_1ia30hret7.b[4][0]++;
    cov_1ia30hret7.s[22]++;
    throw new Error(`The config file at "${configPath}" contains invalid charset, expect utf8`);
  } else {
    cov_1ia30hret7.b[4][1]++;
  }

  cov_1ia30hret7.s[23]++;
  return (0, _stripBom.default)(rawBufContent.toString("utf8"));
}