"use strict";

var cov_29br46dhp = function () {
  var path = "/home/travis/build/commitizen/cz-cli/src/commitizen/commit.js";
  var hash = "278239d97c93019a25911186df022c8cb60dab67";
  var global = new Function("return this")();
  var gcv = "__coverage__";
  var coverageData = {
    path: "/home/travis/build/commitizen/cz-cli/src/commitizen/commit.js",
    statementMap: {
      "0": {
        start: {
          line: 15,
          column: 4
        },
        end: {
          line: 17,
          column: 7
        }
      },
      "1": {
        start: {
          line: 16,
          column: 6
        },
        end: {
          line: 16,
          column: 28
        }
      },
      "2": {
        start: {
          line: 24,
          column: 23
        },
        end: {
          line: 24,
          column: 45
        }
      },
      "3": {
        start: {
          line: 25,
          column: 18
        },
        end: {
          line: 25,
          column: 62
        }
      },
      "4": {
        start: {
          line: 27,
          column: 2
        },
        end: {
          line: 66,
          column: 5
        }
      },
      "5": {
        start: {
          line: 28,
          column: 4
        },
        end: {
          line: 65,
          column: 5
        }
      },
      "6": {
        start: {
          line: 29,
          column: 6
        },
        end: {
          line: 29,
          column: 75
        }
      },
      "7": {
        start: {
          line: 32,
          column: 6
        },
        end: {
          line: 64,
          column: 7
        }
      },
      "8": {
        start: {
          line: 34,
          column: 8
        },
        end: {
          line: 34,
          column: 53
        }
      },
      "9": {
        start: {
          line: 42,
          column: 12
        },
        end: {
          line: 42,
          column: 56
        }
      },
      "10": {
        start: {
          line: 43,
          column: 8
        },
        end: {
          line: 43,
          column: 93
        }
      },
      "11": {
        start: {
          line: 47,
          column: 8
        },
        end: {
          line: 63,
          column: 11
        }
      },
      "12": {
        start: {
          line: 50,
          column: 10
        },
        end: {
          line: 54,
          column: 11
        }
      },
      "13": {
        start: {
          line: 51,
          column: 12
        },
        end: {
          line: 51,
          column: 39
        }
      },
      "14": {
        start: {
          line: 52,
          column: 12
        },
        end: {
          line: 52,
          column: 29
        }
      },
      "15": {
        start: {
          line: 53,
          column: 12
        },
        end: {
          line: 53,
          column: 25
        }
      },
      "16": {
        start: {
          line: 56,
          column: 10
        },
        end: {
          line: 58,
          column: 11
        }
      },
      "17": {
        start: {
          line: 57,
          column: 12
        },
        end: {
          line: 57,
          column: 31
        }
      },
      "18": {
        start: {
          line: 61,
          column: 10
        },
        end: {
          line: 61,
          column: 95
        }
      },
      "19": {
        start: {
          line: 62,
          column: 10
        },
        end: {
          line: 62,
          column: 80
        }
      }
    },
    fnMap: {
      "0": {
        name: "dispatchGitCommit",
        decl: {
          start: {
            line: 13,
            column: 9
          },
          end: {
            line: 13,
            column: 26
          }
        },
        loc: {
          start: {
            line: 13,
            column: 80
          },
          end: {
            line: 18,
            column: 1
          }
        },
        line: 13
      },
      "1": {
        name: "(anonymous_1)",
        decl: {
          start: {
            line: 15,
            column: 70
          },
          end: {
            line: 15,
            column: 71
          }
        },
        loc: {
          start: {
            line: 15,
            column: 87
          },
          end: {
            line: 17,
            column: 5
          }
        },
        line: 15
      },
      "2": {
        name: "commit",
        decl: {
          start: {
            line: 23,
            column: 9
          },
          end: {
            line: 23,
            column: 15
          }
        },
        loc: {
          start: {
            line: 23,
            column: 62
          },
          end: {
            line: 68,
            column: 1
          }
        },
        line: 23
      },
      "3": {
        name: "(anonymous_3)",
        decl: {
          start: {
            line: 27,
            column: 28
          },
          end: {
            line: 27,
            column: 29
          }
        },
        loc: {
          start: {
            line: 27,
            column: 45
          },
          end: {
            line: 66,
            column: 3
          }
        },
        line: 27
      },
      "4": {
        name: "(anonymous_4)",
        decl: {
          start: {
            line: 47,
            column: 27
          },
          end: {
            line: 47,
            column: 28
          }
        },
        loc: {
          start: {
            line: 47,
            column: 71
          },
          end: {
            line: 63,
            column: 9
          }
        },
        line: 47
      }
    },
    branchMap: {
      "0": {
        loc: {
          start: {
            line: 28,
            column: 4
          },
          end: {
            line: 65,
            column: 5
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 28,
            column: 4
          },
          end: {
            line: 65,
            column: 5
          }
        }, {
          start: {
            line: 28,
            column: 4
          },
          end: {
            line: 65,
            column: 5
          }
        }],
        line: 28
      },
      "1": {
        loc: {
          start: {
            line: 32,
            column: 6
          },
          end: {
            line: 64,
            column: 7
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 32,
            column: 6
          },
          end: {
            line: 64,
            column: 7
          }
        }, {
          start: {
            line: 32,
            column: 6
          },
          end: {
            line: 64,
            column: 7
          }
        }],
        line: 32
      },
      "2": {
        loc: {
          start: {
            line: 50,
            column: 10
          },
          end: {
            line: 54,
            column: 11
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 50,
            column: 10
          },
          end: {
            line: 54,
            column: 11
          }
        }, {
          start: {
            line: 50,
            column: 10
          },
          end: {
            line: 54,
            column: 11
          }
        }],
        line: 50
      },
      "3": {
        loc: {
          start: {
            line: 56,
            column: 10
          },
          end: {
            line: 58,
            column: 11
          }
        },
        type: "if",
        locations: [{
          start: {
            line: 56,
            column: 10
          },
          end: {
            line: 58,
            column: 11
          }
        }, {
          start: {
            line: 56,
            column: 10
          },
          end: {
            line: 58,
            column: 11
          }
        }],
        line: 56
      }
    },
    s: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0,
      "5": 0,
      "6": 0,
      "7": 0,
      "8": 0,
      "9": 0,
      "10": 0,
      "11": 0,
      "12": 0,
      "13": 0,
      "14": 0,
      "15": 0,
      "16": 0,
      "17": 0,
      "18": 0,
      "19": 0
    },
    f: {
      "0": 0,
      "1": 0,
      "2": 0,
      "3": 0,
      "4": 0
    },
    b: {
      "0": [0, 0],
      "1": [0, 0],
      "2": [0, 0],
      "3": [0, 0]
    },
    _coverageSchema: "43e27e138ebf9cfc5966b082cf9a028302ed4184",
    hash: "278239d97c93019a25911186df022c8cb60dab67"
  };
  var coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  return coverage[path] = coverageData;
}();

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _cachedir = _interopRequireDefault(require("cachedir"));

var _fsExtra = require("fs-extra");

var _git = require("../git");

var cache = _interopRequireWildcard(require("./cache"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = commit;
/**
 * Takes all of the final inputs needed in order to make dispatch a git commit
 */

exports.default = _default;

function dispatchGitCommit(repoPath, template, options, overrideOptions, done) {
  cov_29br46dhp.f[0]++;
  cov_29br46dhp.s[0]++;
  // Commit the user input -- side effect that we'll test
  (0, _git.commit)(repoPath, template, _objectSpread2({}, options, {}, overrideOptions), function (error) {
    cov_29br46dhp.f[1]++;
    cov_29br46dhp.s[1]++;
    done(error, template);
  });
}
/**
 * Asynchronously commits files using commitizen
 */


function commit(inquirer, repoPath, prompter, options, done) {
  cov_29br46dhp.f[2]++;
  var cacheDirectory = (cov_29br46dhp.s[2]++, (0, _cachedir.default)('commitizen'));
  var cachePath = (cov_29br46dhp.s[3]++, _path.default.join(cacheDirectory, 'commitizen.json'));
  cov_29br46dhp.s[4]++;
  (0, _fsExtra.ensureDir)(cacheDirectory, function (error) {
    cov_29br46dhp.f[3]++;
    cov_29br46dhp.s[5]++;

    if (error) {
      cov_29br46dhp.b[0][0]++;
      cov_29br46dhp.s[6]++;
      console.error("Couldn't create commitizen cache directory: ", error); // TODO: properly handle error?
    } else {
      cov_29br46dhp.b[0][1]++;
      cov_29br46dhp.s[7]++;

      if (options.retryLastCommit) {
        cov_29br46dhp.b[1][0]++;
        cov_29br46dhp.s[8]++;
        console.log('Retrying last commit attempt.'); // We want to use the last commit instead of the current commit,
        // so lets override some options using the values from cache.

        let {
          options: retryOptions,
          overrideOptions: retryOverrideOptions,
          template: retryTemplate
        } = (cov_29br46dhp.s[9]++, cache.getCacheValueSync(cachePath, repoPath));
        cov_29br46dhp.s[10]++;
        dispatchGitCommit(repoPath, retryTemplate, retryOptions, retryOverrideOptions, done);
      } else {
        cov_29br46dhp.b[1][1]++;
        cov_29br46dhp.s[11]++;
        // Get user input -- side effect that is hard to test
        prompter(inquirer, function (error, template, overrideOptions) {
          cov_29br46dhp.f[4]++;
          cov_29br46dhp.s[12]++;

          // Allow adapters to error out
          // (error: Error?, template: String, overrideOptions: Object)
          if (!(error instanceof Error)) {
            cov_29br46dhp.b[2][0]++;
            cov_29br46dhp.s[13]++;
            overrideOptions = template;
            cov_29br46dhp.s[14]++;
            template = error;
            cov_29br46dhp.s[15]++;
            error = null;
          } else {
            cov_29br46dhp.b[2][1]++;
          }

          cov_29br46dhp.s[16]++;

          if (error) {
            cov_29br46dhp.b[3][0]++;
            cov_29br46dhp.s[17]++;
            return done(error);
          } else {
            cov_29br46dhp.b[3][1]++;
          } // We don't want to add retries to the cache, only actual commands


          cov_29br46dhp.s[18]++;
          cache.setCacheValueSync(cachePath, repoPath, {
            template,
            options,
            overrideOptions
          });
          cov_29br46dhp.s[19]++;
          dispatchGitCommit(repoPath, template, options, overrideOptions, done);
        });
      }
    }
  });
}