# Contributing to Our Project

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html)
We use Github Flow, so all code changes happen through pull requests. Pull requests are the best way to propose changes to the codebase.

## Any contributions you make will be under the MIT Software License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project.

## Report bugs using Github's [issues](https://github.com/briandk/transcriptase-atom/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/briandk/transcriptase-atom/issues/new); it's that easy!

## Write bug reports with detail, background, and sample code
A good bug report is one that makes it easy for everyone to understand what you were doing and what went wrong. Be as detailed as possible when explaining what happened so that others can reproduce the issue.

## Use a Consistent Coding Style
We recommend using a consistent coding style to make the codebase easier to read and maintain. You might want to use a linter to help with this.

## License
By contributing, you agree that your contributions will be licensed under its MIT License.
