import './searchbar.css'
import React from 'react';
import './ComboBox.tsx'
import ComboBox from './ComboBox.tsx';
import { Ubicaciones } from '../../../models/Ubicaciones.tsx';
import { MyDatePicker } from './DatePicker.tsx';

function SearchBar({ OnSearch, OnCheckCompraClick, locations, OnLocationChange, selectedDate, setSelectedDate }: { OnSearch: (input: string) => void, OnCheckCompraClick: () => void, locations:Ubicaciones[], OnLocationChange: ((ubicacion:string)=> void), selectedDate:Date|null, setSelectedDate:((fecha: Date|null)=>void)}) {
    const [search, setSearch] = React.useState<string>("")

    const handleInputChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setSearch(event.target.value);
    };
    const buscarBTNClick = () =>{
        OnSearch(search)
    };
    


    return (
        <>
            <div className="search-bar">
                <div className="field">
                    <input type='text' value={search} onChange={handleInputChange} placeholder='Nombre o descripción del evento' className="input-field" />
                </div>

                <button onClick={buscarBTNClick} className="buscarBTN ">
                    Buscar
                </button>
            </div>

            <div className='filter-row'>

                <div className="filter-field">
                    <ComboBox placeholder='Ubicación' className='filter-input' options={locations}  onChange={OnLocationChange}/>
                    <svg className="icon" width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M13.1618 20.907C15.6673 18.7019 20.125 14.1967 20.125 10.0625C20.125 7.77501 19.2163 5.58121 17.5988 3.9637C15.9813 2.3462 13.7875 1.4375 11.5 1.4375C9.21251 1.4375 7.01871 2.3462 5.4012 3.9637C3.7837 5.58121 2.875 7.77501 2.875 10.0625C2.875 14.1967 7.33125 18.7019 9.83825 20.907C10.2955 21.3152 10.887 21.5408 11.5 21.5408C12.113 21.5408 12.7045 21.3152 13.1618 20.907ZM8.625 10.0625C8.625 9.3 8.9279 8.56873 9.46707 8.02957C10.0062 7.4904 10.7375 7.1875 11.5 7.1875C12.2625 7.1875 12.9938 7.4904 13.5329 8.02957C14.0721 8.56873 14.375 9.3 14.375 10.0625C14.375 10.825 14.0721 11.5563 13.5329 12.0954C12.9938 12.6346 12.2625 12.9375 11.5 12.9375C10.7375 12.9375 10.0062 12.6346 9.46707 12.0954C8.9279 11.5563 8.625 10.825 8.625 10.0625Z"
                            fill="#FFB55E"
                        />
                    </svg>
                </div>

                <div className="filter-field">
                    <MyDatePicker placeholder='dd/MM/yyyy' selectedDate={selectedDate} setSelectedDate={setSelectedDate} className='date-input'/>
                    <svg className="icon" width="27" height="27" viewBox="0 0 27 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_58_7)">
                            <path
                                d="M24.1875 4.49999H21.1875V6.74999C21.1875 6.96668 21.1448 7.18124 21.0619 7.38142C20.979 7.58161 20.8575 7.7635 20.7042 7.91672C20.551 8.06994 20.3691 8.19148 20.1689 8.2744C19.9688 8.35732 19.7542 8.39999 19.5375 8.39999C19.3208 8.39999 19.1063 8.35732 18.9061 8.2744C18.7059 8.19148 18.524 8.06994 18.3708 7.91672C18.2176 7.7635 18.096 7.58161 18.0131 7.38142C17.9302 7.18124 17.8875 6.96668 17.8875 6.74999V4.49999H9.15001V6.74999C9.15001 7.1876 8.97617 7.60729 8.66674 7.91672C8.3573 8.22616 7.93762 8.39999 7.50001 8.39999C7.0624 8.39999 6.64272 8.22616 6.33328 7.91672C6.02385 7.60729 5.85001 7.1876 5.85001 6.74999V4.49999H2.85001C2.67153 4.49796 2.49445 4.53175 2.32925 4.59934C2.16405 4.66694 2.01408 4.76698 1.88822 4.89354C1.76236 5.0201 1.66315 5.17062 1.59647 5.33619C1.52979 5.50176 1.49699 5.67903 1.50001 5.85749V22.6425C1.49703 22.8178 1.52862 22.992 1.59297 23.1551C1.65732 23.3182 1.75317 23.4671 1.87506 23.5931C1.99694 23.7192 2.14246 23.82 2.30331 23.8898C2.46416 23.9596 2.63719 23.9971 2.81251 24H24.1875C24.3628 23.9971 24.5359 23.9596 24.6967 23.8898C24.8576 23.82 25.0031 23.7192 25.125 23.5931C25.2468 23.4671 25.3427 23.3182 25.407 23.1551C25.4714 22.992 25.503 22.8178 25.5 22.6425V5.85749C25.503 5.68217 25.4714 5.50798 25.407 5.34487C25.3427 5.18176 25.2468 5.03292 25.125 4.90686C25.0031 4.7808 24.8576 4.67999 24.6967 4.61018C24.5359 4.54036 24.3628 4.50292 24.1875 4.49999ZM7.50001 19.5H6.00001V18H7.50001V19.5ZM7.50001 15.75H6.00001V14.25H7.50001V15.75ZM7.50001 12H6.00001V10.5H7.50001V12ZM12 19.5H10.5V18H12V19.5ZM12 15.75H10.5V14.25H12V15.75ZM12 12H10.5V10.5H12V12ZM16.5 19.5H15V18H16.5V19.5ZM16.5 15.75H15V14.25H16.5V15.75ZM16.5 12H15V10.5H16.5V12ZM21 19.5H19.5V18H21V19.5ZM21 15.75H19.5V14.25H21V15.75ZM21 12H19.5V10.5H21V12Z"
                                fill="#FFB55E"
                            />
                            <path
                                d="M7.5 7.5C7.69891 7.5 7.88968 7.42098 8.03033 7.28033C8.17098 7.13968 8.25 6.94891 8.25 6.75V2.25C8.25 2.05109 8.17098 1.86032 8.03033 1.71967C7.88968 1.57902 7.69891 1.5 7.5 1.5C7.30109 1.5 7.11032 1.57902 6.96967 1.71967C6.82902 1.86032 6.75 2.05109 6.75 2.25V6.75C6.75 6.94891 6.82902 7.13968 6.96967 7.28033C7.11032 7.42098 7.30109 7.5 7.5 7.5Z"
                                fill="#FFB55E"
                            />
                            <path
                                d="M19.5 7.5C19.6989 7.5 19.8897 7.42098 20.0303 7.28033C20.171 7.13968 20.25 6.94891 20.25 6.75V2.25C20.25 2.05109 20.171 1.86032 20.0303 1.71967C19.8897 1.57902 19.6989 1.5 19.5 1.5C19.3011 1.5 19.1103 1.57902 18.9697 1.71967C18.829 1.86032 18.75 2.05109 18.75 2.25V6.75C18.75 6.94891 18.829 7.13968 18.9697 7.28033C19.1103 7.42098 19.3011 7.5 19.5 7.5Z"
                                fill="#FFB55E"
                            />
                        </g>
                        <defs>
                            <clipPath id="clip0_58_7">
                                <rect width="27" height="27" fill="white" />
                            </clipPath>
                        </defs>
                    </svg>


                </div>
                <button className="buy-button"  onClick={OnCheckCompraClick} >
                    <svg
                        width="32"
                        height="32"
                        viewBox="0 0 32 32"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            d="M4 7.00001C3.73478 7.00001 3.48043 7.10537 3.29289 7.29291C3.10536 7.48044 3 7.7348 3 8.00001C3 8.26523 3.10536 8.51958 3.29289 8.70712C3.48043 8.89465 3.73478 9.00001 4 9.00001H6.22L8.844 19.5C9.067 20.39 9.864 21 10.781 21H23.251C24.154 21 24.921 20.4 25.158 19.53L27.75 10H25.656L23.25 19H10.78L8.157 8.50001C8.04865 8.06924 7.79888 7.68729 7.44768 7.41533C7.09648 7.14336 6.66418 6.99712 6.22 7.00001H4ZM22 21C20.355 21 19 22.355 19 24C19 25.645 20.355 27 22 27C23.645 27 25 25.645 25 24C25 22.355 23.645 21 22 21ZM13 21C11.355 21 10 22.355 10 24C10 25.645 11.355 27 13 27C14.645 27 16 25.645 16 24C16 22.355 14.645 21 13 21ZM16 7.00001V12H13L17 16L21 12H18V7.00001H16ZM13 23C13.564 23 14 23.436 14 24C14 24.564 13.564 25 13 25C12.436 25 12 24.564 12 24C12 23.436 12.436 23 13 23ZM22 23C22.564 23 23 23.436 23 24C23 24.564 22.564 25 22 25C21.436 25 21 24.564 21 24C21 23.436 21.436 23 22 23Z"
                            fill="black"
                        />
                    </svg>
                </button>
            </div>
        </>
    );
}

export default SearchBar