[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-class"></code> `ForwardLayer` {#safeds.ml.nn.layers.ForwardLayer data-toc-label='[class] ForwardLayer'}

A fully connected forward layer.

**Parent type:** [`Layer`][safeds.ml.nn.layers.Layer]

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `neuronCount` | [`Int`][safeds.lang.Int] | The number of neurons in this layer | - |
| `activationFunction` | `#!sds literal<"sigmoid", "relu", "softmax", "none", "notset">` | The activation function used in the forward layer, if not set the activation will be set automatically. | `#!sds "notset"` |

??? quote "Stub code in `ForwardLayer.sdsstub`"

    ```sds linenums="13"
    class ForwardLayer(
        @PythonName("neuron_count") neuronCount: Int,
        @PythonName("overwrite_activation_function") activationFunction: literal<"sigmoid", "relu", "softmax", "none", "notset"> = "notset"
    ) sub Layer {
        /**
         * Get the input_size of this layer.
         */
        @PythonName("input_size") attr inputSize: Int
        /**
         * Get the output_size of this layer.
         */
        @PythonName("output_size") attr outputSize: Int
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `inputSize` {#safeds.ml.nn.layers.ForwardLayer.inputSize data-toc-label='[attribute] inputSize'}

Get the input_size of this layer.

**Type:** [`Int`][safeds.lang.Int]

## <code class="doc-symbol doc-symbol-attribute"></code> `outputSize` {#safeds.ml.nn.layers.ForwardLayer.outputSize data-toc-label='[attribute] outputSize'}

Get the output_size of this layer.

**Type:** [`Int`][safeds.lang.Int]
