[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-class"></code> `BaselineRegressor` {#safeds.ml.classical.regression.BaselineRegressor data-toc-label='[class] BaselineRegressor'}

Baseline Regressor.

Get a baseline by fitting data on multiple different models and comparing the best metrics.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `extendedSearch` | [`Boolean`][safeds.lang.Boolean] | If set to true, an extended set of models will be used to fit the classifier. This might result in significantly higher runtime. | `#!sds false` |

??? quote "Stub code in `BaselineRegressor.sdsstub`"

    ```sds linenums="14"
    class BaselineRegressor(
        @PythonName("extended_search") extendedSearch: Boolean = false
    ) {
        /**
         * Whether the model is fitted.
         */
        @PythonName("is_fitted") attr isFitted: Boolean

        /**
         * Train the Regressor with given training data.
         *
         * The original model is not modified.
         *
         * @param trainData The data the network should be trained on.
         *
         * @result trainedClassifier The trained Regressor
         */
        @Pure
        fun fit(
            @PythonName("train_data") trainData: TabularDataset
        ) -> trainedClassifier: BaselineRegressor

        /**
         * Make a prediction for the given test data and calculate the best metrics.
         *
         * The original Model is not modified.
         *
         * @param testData The data the Regressor should predict.
         *
         * @result bestMetrics A dictionary with the best metrics that were achieved.
         */
        @Pure
        fun predict(
            @PythonName("test_data") testData: TabularDataset
        ) -> bestMetrics: Map<String, Float>
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `isFitted` {#safeds.ml.classical.regression.BaselineRegressor.isFitted data-toc-label='[attribute] isFitted'}

Whether the model is fitted.

**Type:** [`Boolean`][safeds.lang.Boolean]

## <code class="doc-symbol doc-symbol-function"></code> `fit` {#safeds.ml.classical.regression.BaselineRegressor.fit data-toc-label='[function] fit'}

Train the Regressor with given training data.

The original model is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `trainData` | [`TabularDataset`][safeds.data.labeled.containers.TabularDataset] | The data the network should be trained on. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `trainedClassifier` | [`BaselineRegressor`][safeds.ml.classical.regression.BaselineRegressor] | The trained Regressor |

??? quote "Stub code in `BaselineRegressor.sdsstub`"

    ```sds linenums="31"
    @Pure
    fun fit(
        @PythonName("train_data") trainData: TabularDataset
    ) -> trainedClassifier: BaselineRegressor
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `predict` {#safeds.ml.classical.regression.BaselineRegressor.predict data-toc-label='[function] predict'}

Make a prediction for the given test data and calculate the best metrics.

The original Model is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `testData` | [`TabularDataset`][safeds.data.labeled.containers.TabularDataset] | The data the Regressor should predict. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `bestMetrics` | [`Map<String, Float>`][safeds.lang.Map] | A dictionary with the best metrics that were achieved. |

??? quote "Stub code in `BaselineRegressor.sdsstub`"

    ```sds linenums="45"
    @Pure
    fun predict(
        @PythonName("test_data") testData: TabularDataset
    ) -> bestMetrics: Map<String, Float>
    ```
    { data-search-exclude }
