---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `Classifier` {#safeds.ml.classical.classification.Classifier data-toc-label='[class] Classifier'}

A model for classification tasks.

**Parent type:** [`SupervisedModel`][safeds.ml.classical.SupervisedModel]

**Inheritors:**

- [`AdaBoostClassifier`][safeds.ml.classical.classification.AdaBoostClassifier]
- [`DecisionTreeClassifier`][safeds.ml.classical.classification.DecisionTreeClassifier]
- [`GradientBoostingClassifier`][safeds.ml.classical.classification.GradientBoostingClassifier]
- [`KNearestNeighborsClassifier`][safeds.ml.classical.classification.KNearestNeighborsClassifier]
- [`LogisticClassifier`][safeds.ml.classical.classification.LogisticClassifier]
- [`RandomForestClassifier`][safeds.ml.classical.classification.RandomForestClassifier]
- [`SupportVectorClassifier`][safeds.ml.classical.classification.SupportVectorClassifier]

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="10"
    class Classifier sub SupervisedModel {
        /**
         * Create a copy of this model and fit it with the given training data.
         *
         * **Note:** This model is not modified.
         *
         * @param trainingSet The training data containing the features and target.
         *
         * @result fittedModel The fitted model.
         */
        @Pure
        @Category(DataScienceCategory.ModelingQClassicalClassification)
        fun fit(
            @PythonName("training_set") trainingSet: TabularDataset
        ) -> fittedModel: Classifier

        /**
         * Summarize the classifier's metrics on the given data.
         *
         * **Note:** The model must be fitted.
         *
         * @param validationOrTestSet The validation or test set.
         * @param positiveClass The class to be considered positive. All other classes are considered negative.
         *
         * @result metrics A table containing the classifier's metrics.
         */
        @Pure
        @PythonName("summarize_metrics")
        @Category(DataScienceCategory.ModelEvaluationQMetric)
        fun summarizeMetrics(
            @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
            @PythonName("positive_class") positiveClass: Any
        ) -> metrics: Table

        /**
         * Compute the accuracy of the classifier on the given data.
         *
         * The accuracy is the proportion of predicted target values that were correct. The **higher** the accuracy, the
         * better. Results range from 0.0 to 1.0.
         *
         * **Note:** The model must be fitted.
         *
         * @param validationOrTestSet The validation or test set.
         *
         * @result accuracy The classifier's accuracy.
         */
        @Pure
        @Category(DataScienceCategory.ModelEvaluationQMetric)
        fun accuracy(
            @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>
        ) -> accuracy: Float

        /**
         * Compute the classifier's F₁ score on the given data.
         *
         * The F₁ score is the harmonic mean of precision and recall. The **higher** the F₁ score, the better the
         * classifier. Results range from 0.0 to 1.0.
         *
         * **Note:** The model must be fitted.
         *
         * @param validationOrTestSet The validation or test set.
         * @param positiveClass The class to be considered positive. All other classes are considered negative.
         *
         * @result f1Score The classifier's F₁ score.
         */
        @Pure
        @PythonName("f1_score")
        @Category(DataScienceCategory.ModelEvaluationQMetric)
        fun f1Score(
            @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
            @PythonName("positive_class") positiveClass: Any
        ) -> f1Score: Float

        /**
         * Compute the classifier's precision on the given data.
         *
         * The precision is the proportion of positive predictions that were correct. The **higher** the precision, the
         * better the classifier. Results range from 0.0 to 1.0.
         *
         * **Note:** The model must be fitted.
         *
         * @param validationOrTestSet The validation or test set.
         * @param positiveClass The class to be considered positive. All other classes are considered negative.
         *
         * @result precision The classifier's precision.
         */
        @Pure
        @Category(DataScienceCategory.ModelEvaluationQMetric)
        fun precision(
            @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
            @PythonName("positive_class") positiveClass: Any
        ) -> precision: Float

        /**
         * Compute the classifier's recall on the given data.
         *
         * The recall is the proportion of actual positives that were predicted correctly. The **higher** the recall, the
         * better the classifier. Results range from 0.0 to 1.0.
         *
         * **Note:** The model must be fitted.
         *
         * @param validationOrTestSet The validation or test set.
         * @param positiveClass The class to be considered positive. All other classes are considered negative.
         *
         * @result recall The classifier's recall.
         */
        @Pure
        @Category(DataScienceCategory.ModelEvaluationQMetric)
        fun recall(
            @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
            @PythonName("positive_class") positiveClass: Any
        ) -> recall: Float
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `isFitted` {#safeds.ml.classical.classification.Classifier.isFitted data-toc-label='[attribute] isFitted'}

Whether the model is fitted.

**Type:** [`Boolean`][safeds.lang.Boolean]

## <code class="doc-symbol doc-symbol-function"></code> `accuracy` {#safeds.ml.classical.classification.Classifier.accuracy data-toc-label='[function] accuracy'}

Compute the accuracy of the classifier on the given data.

The accuracy is the proportion of predicted target values that were correct. The **higher** the accuracy, the
better. Results range from 0.0 to 1.0.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `validationOrTestSet` | `#!sds union<Table, TabularDataset>` | The validation or test set. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `accuracy` | [`Float`][safeds.lang.Float] | The classifier's accuracy. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="56"
    @Pure
    @Category(DataScienceCategory.ModelEvaluationQMetric)
    fun accuracy(
        @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>
    ) -> accuracy: Float
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `f1Score` {#safeds.ml.classical.classification.Classifier.f1Score data-toc-label='[function] f1Score'}

Compute the classifier's F₁ score on the given data.

The F₁ score is the harmonic mean of precision and recall. The **higher** the F₁ score, the better the
classifier. Results range from 0.0 to 1.0.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `validationOrTestSet` | `#!sds union<Table, TabularDataset>` | The validation or test set. | - |
| `positiveClass` | [`Any`][safeds.lang.Any] | The class to be considered positive. All other classes are considered negative. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `f1Score` | [`Float`][safeds.lang.Float] | The classifier's F₁ score. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="75"
    @Pure
    @PythonName("f1_score")
    @Category(DataScienceCategory.ModelEvaluationQMetric)
    fun f1Score(
        @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
        @PythonName("positive_class") positiveClass: Any
    ) -> f1Score: Float
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `fit` {#safeds.ml.classical.classification.Classifier.fit data-toc-label='[function] fit'}

Create a copy of this model and fit it with the given training data.

**Note:** This model is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `trainingSet` | [`TabularDataset`][safeds.data.labeled.containers.TabularDataset] | The training data containing the features and target. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedModel` | [`Classifier`][safeds.ml.classical.classification.Classifier] | The fitted model. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="20"
    @Pure
    @Category(DataScienceCategory.ModelingQClassicalClassification)
    fun fit(
        @PythonName("training_set") trainingSet: TabularDataset
    ) -> fittedModel: Classifier
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `getFeatureNames` {#safeds.ml.classical.classification.Classifier.getFeatureNames data-toc-label='[function] getFeatureNames'}

Return the names of the feature columns.

**Note:** The model must be fitted.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `featureNames` | [`List<String>`][safeds.lang.List] | The names of the feature columns. |

??? quote "Stub code in `SupervisedModel.sdsstub`"

    ```sds linenums="52"
    @Pure
    @PythonName("get_feature_names")
    fun getFeatureNames() -> featureNames: List<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `getFeaturesSchema` {#safeds.ml.classical.classification.Classifier.getFeaturesSchema data-toc-label='[function] getFeaturesSchema'}

Return the schema of the feature columns.

**Note:** The model must be fitted.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `featureSchema` | [`Schema`][safeds.data.tabular.typing.Schema] | The schema of the feature columns. |

??? quote "Stub code in `SupervisedModel.sdsstub`"

    ```sds linenums="63"
    @Pure
    @PythonName("get_features_schema")
    fun getFeaturesSchema() -> featureSchema: Schema
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `getTargetName` {#safeds.ml.classical.classification.Classifier.getTargetName data-toc-label='[function] getTargetName'}

Return the name of the target column.

**Note:** The model must be fitted.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `targetName` | [`String`][safeds.lang.String] | The name of the target column. |

??? quote "Stub code in `SupervisedModel.sdsstub`"

    ```sds linenums="74"
    @Pure
    @PythonName("get_target_name")
    fun getTargetName() -> targetName: String
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `getTargetType` {#safeds.ml.classical.classification.Classifier.getTargetType data-toc-label='[function] getTargetType'}

Return the type of the target column.

**Note:** The model must be fitted.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `targetType` | [`DataType`][safeds.data.tabular.typing.DataType] | The type of the target column. |

??? quote "Stub code in `SupervisedModel.sdsstub`"

    ```sds linenums="85"
    @Pure
    @PythonName("get_target_type")
    fun getTargetType() -> targetType: DataType
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `precision` {#safeds.ml.classical.classification.Classifier.precision data-toc-label='[function] precision'}

Compute the classifier's precision on the given data.

The precision is the proportion of positive predictions that were correct. The **higher** the precision, the
better the classifier. Results range from 0.0 to 1.0.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `validationOrTestSet` | `#!sds union<Table, TabularDataset>` | The validation or test set. | - |
| `positiveClass` | [`Any`][safeds.lang.Any] | The class to be considered positive. All other classes are considered negative. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `precision` | [`Float`][safeds.lang.Float] | The classifier's precision. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="96"
    @Pure
    @Category(DataScienceCategory.ModelEvaluationQMetric)
    fun precision(
        @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
        @PythonName("positive_class") positiveClass: Any
    ) -> precision: Float
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `predict` {#safeds.ml.classical.classification.Classifier.predict data-toc-label='[function] predict'}

Predict the target values on the given dataset.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `dataset` | `#!sds union<Table, TabularDataset>` | The dataset containing at least the features. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `prediction` | [`TabularDataset`][safeds.data.labeled.containers.TabularDataset] | The given dataset with an additional column for the predicted target values. |

??? quote "Stub code in `SupervisedModel.sdsstub`"

    ```sds linenums="40"
    @Pure
    fun predict(
        dataset: union<Table, TabularDataset>
    ) -> prediction: TabularDataset
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `recall` {#safeds.ml.classical.classification.Classifier.recall data-toc-label='[function] recall'}

Compute the classifier's recall on the given data.

The recall is the proportion of actual positives that were predicted correctly. The **higher** the recall, the
better the classifier. Results range from 0.0 to 1.0.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `validationOrTestSet` | `#!sds union<Table, TabularDataset>` | The validation or test set. | - |
| `positiveClass` | [`Any`][safeds.lang.Any] | The class to be considered positive. All other classes are considered negative. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `recall` | [`Float`][safeds.lang.Float] | The classifier's recall. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="116"
    @Pure
    @Category(DataScienceCategory.ModelEvaluationQMetric)
    fun recall(
        @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
        @PythonName("positive_class") positiveClass: Any
    ) -> recall: Float
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `summarizeMetrics` {#safeds.ml.classical.classification.Classifier.summarizeMetrics data-toc-label='[function] summarizeMetrics'}

Summarize the classifier's metrics on the given data.

**Note:** The model must be fitted.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `validationOrTestSet` | `#!sds union<Table, TabularDataset>` | The validation or test set. | - |
| `positiveClass` | [`Any`][safeds.lang.Any] | The class to be considered positive. All other classes are considered negative. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `metrics` | [`Table`][safeds.data.tabular.containers.Table] | A table containing the classifier's metrics. |

??? quote "Stub code in `Classifier.sdsstub`"

    ```sds linenums="36"
    @Pure
    @PythonName("summarize_metrics")
    @Category(DataScienceCategory.ModelEvaluationQMetric)
    fun summarizeMetrics(
        @PythonName("validation_or_test_set") validationOrTestSet: union<Table, TabularDataset>,
        @PythonName("positive_class") positiveClass: Any
    ) -> metrics: Table
    ```
    { data-search-exclude }
