---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `Int` {#safeds.lang.Int data-toc-label='[class] Int'}

An integer.

**Parent type:** [`Float`][safeds.lang.Float]

**Examples:**

```sds
pipeline example {
    val int = 1;
}
```

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="94"
    class Int sub Float {

        /**
         * Convert this integer to a floating-point number.
         *
         * @example
         * pipeline example {
         *     val float = 1.toFloat(); // 1.0
         * }
         */
        @Pure
        @PythonMacro("float($this)")
        fun toFloat() -> float: Float
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toFloat` {#safeds.lang.Int.toFloat data-toc-label='[function] toFloat'}

Convert this integer to a floating-point number.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `float` | [`Float`][safeds.lang.Float] | - |

**Examples:**

```sds hl_lines="2"
pipeline example {
    val float = 1.toFloat(); // 1.0
}
```

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="104"
    @Pure
    @PythonMacro("float($this)")
    fun toFloat() -> float: Float
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toInt` {#safeds.lang.Int.toInt data-toc-label='[function] toInt'}

Convert this floating-point number to an integer by truncating the fractional part.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `int` | [`Int`][safeds.lang.Int] | - |

**Examples:**

```sds hl_lines="2"
pipeline example {
    val int = (1.0).toInt(); // 1
}
```

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="81"
    @Pure
    @PythonMacro("int($this)")
    fun toInt() -> int: Int
    ```
    { data-search-exclude }
