---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `Any` {#safeds.lang.Any data-toc-label='[class] Any'}

The common superclass of all classes.

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="6"
    class Any {

        /**
         * Return whether the object is truthy.
         *
         * @example
         * pipeline example {
         *     val boolean = 1.toBoolean(); // true
         * }
         *
         * @example
         * pipeline example {
         *     val boolean = 0.toBoolean(); // false
         * }
         */
        @Pure
        @PythonMacro("bool($this)")
        fun toBoolean() -> boolean: Boolean

        /**
         * Return a string representation of the object.
         *
         * @example
         * pipeline example {
         *     val string = 1.toString(); // "1"
         * }
         */
        @Pure
        @PythonMacro("str($this)")
        fun toString() -> string: String
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toBoolean` {#safeds.lang.Any.toBoolean data-toc-label='[function] toBoolean'}

Return whether the object is truthy.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `boolean` | [`Boolean`][safeds.lang.Boolean] | - |

**Examples:**

```sds hl_lines="2"
pipeline example {
    val boolean = 1.toBoolean(); // true
}
```
```sds hl_lines="2"
pipeline example {
    val boolean = 0.toBoolean(); // false
}
```

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="21"
    @Pure
    @PythonMacro("bool($this)")
    fun toBoolean() -> boolean: Boolean
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toString` {#safeds.lang.Any.toString data-toc-label='[function] toString'}

Return a string representation of the object.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `string` | [`String`][safeds.lang.String] | - |

**Examples:**

```sds hl_lines="2"
pipeline example {
    val string = 1.toString(); // "1"
}
```

??? quote "Stub code in `coreClasses.sdsstub`"

    ```sds linenums="33"
    @Pure
    @PythonMacro("str($this)")
    fun toString() -> string: String
    ```
    { data-search-exclude }
