[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-enum"></code> `AnnotationTarget` {#safeds.lang.AnnotationTarget data-toc-label='[enum] AnnotationTarget'}

The declaration types that can be targeted by annotations.

??? quote "Stub code in `annotationUsage.sdsstub`"

    ```sds linenums="16"
    enum AnnotationTarget {

        /**
         * The annotation can be called on annotations.
         */
        Annotation

        /**
         * The annotation can be called on attributes.
         */
        Attribute

        /**
         * The annotation can be called on classes.
         */
        Class

        /**
         * The annotation can be called on enums.
         */
        Enum

        /**
         * The annotation can be called on enum variants.
         */
        EnumVariant

        /**
         * The annotation can be called on functions.
         */
        Function

        /**
         * The annotation can be called on modules (i.e. files).
         */
        Module

        /**
         * The annotation can be called on parameters.
         */
        Parameter

        /**
         * The annotation can be called on pipelines.
         */
        Pipeline

        /**
         * The annotation can be called on results.
         */
        Result

        /**
         * The annotation can be called on segments.
         */
        Segment

        /**
         * The annotation can be called on type parameters.
         */
        TypeParameter
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-variant"></code> `Annotation` {#safeds.lang.AnnotationTarget.Annotation data-toc-label='[variant] Annotation'}

The annotation can be called on annotations.

## <code class="doc-symbol doc-symbol-variant"></code> `Attribute` {#safeds.lang.AnnotationTarget.Attribute data-toc-label='[variant] Attribute'}

The annotation can be called on attributes.

## <code class="doc-symbol doc-symbol-variant"></code> `Class` {#safeds.lang.AnnotationTarget.Class data-toc-label='[variant] Class'}

The annotation can be called on classes.

## <code class="doc-symbol doc-symbol-variant"></code> `Enum` {#safeds.lang.AnnotationTarget.Enum data-toc-label='[variant] Enum'}

The annotation can be called on enums.

## <code class="doc-symbol doc-symbol-variant"></code> `EnumVariant` {#safeds.lang.AnnotationTarget.EnumVariant data-toc-label='[variant] EnumVariant'}

The annotation can be called on enum variants.

## <code class="doc-symbol doc-symbol-variant"></code> `Function` {#safeds.lang.AnnotationTarget.Function data-toc-label='[variant] Function'}

The annotation can be called on functions.

## <code class="doc-symbol doc-symbol-variant"></code> `Module` {#safeds.lang.AnnotationTarget.Module data-toc-label='[variant] Module'}

The annotation can be called on modules (i.e. files).

## <code class="doc-symbol doc-symbol-variant"></code> `Parameter` {#safeds.lang.AnnotationTarget.Parameter data-toc-label='[variant] Parameter'}

The annotation can be called on parameters.

## <code class="doc-symbol doc-symbol-variant"></code> `Pipeline` {#safeds.lang.AnnotationTarget.Pipeline data-toc-label='[variant] Pipeline'}

The annotation can be called on pipelines.

## <code class="doc-symbol doc-symbol-variant"></code> `Result` {#safeds.lang.AnnotationTarget.Result data-toc-label='[variant] Result'}

The annotation can be called on results.

## <code class="doc-symbol doc-symbol-variant"></code> `Segment` {#safeds.lang.AnnotationTarget.Segment data-toc-label='[variant] Segment'}

The annotation can be called on segments.

## <code class="doc-symbol doc-symbol-variant"></code> `TypeParameter` {#safeds.lang.AnnotationTarget.TypeParameter data-toc-label='[variant] TypeParameter'}

The annotation can be called on type parameters.
