---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `TableTransformer` {#safeds.data.tabular.transformation.TableTransformer data-toc-label='[class] TableTransformer'}

Learn a transformation for a set of columns in a `Table` and transform another `Table` with the same columns.

**Inheritors:**

- [`Discretizer`][safeds.data.tabular.transformation.Discretizer]
- [`FunctionalTableTransformer`][safeds.data.tabular.transformation.FunctionalTableTransformer]
- [`InvertibleTableTransformer`][safeds.data.tabular.transformation.InvertibleTableTransformer]
- [`KNearestNeighborsImputer`][safeds.data.tabular.transformation.KNearestNeighborsImputer]
- [`SimpleImputer`][safeds.data.tabular.transformation.SimpleImputer]

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="10"
    class TableTransformer {
        /**
         * Whether the transformer is fitted.
         */
        @PythonName("is_fitted") attr isFitted: Boolean

        /**
         * Learn a transformation for a set of columns in a table.
         *
         * **Note:** This transformer is not modified.
         *
         * @param table The table used to fit the transformer.
         *
         * @result fittedTransformer The fitted transformer.
         */
        @Pure
        fun fit(
            table: Table
        ) -> fittedTransformer: TableTransformer

        /**
         * Apply the learned transformation to a table.
         *
         * **Note:** The given table is not modified.
         *
         * @param table The table to which the learned transformation is applied.
         *
         * @result transformedTable The transformed table.
         */
        @Pure
        fun transform(
            table: Table
        ) -> transformedTable: Table

        /**
         * Learn a transformation for a set of columns in a table and apply the learned transformation to the same table.
         *
         * **Note:** Neither this transformer nor the given table are modified.
         *
         * @param table The table used to fit the transformer. The transformer is then applied to this table.
         *
         * @result fittedTransformer The fitted transformer.
         * @result transformedTable The transformed table.
         */
        @Pure
        @PythonName("fit_and_transform")
        fun fitAndTransform(
            table: Table
        ) -> (fittedTransformer: TableTransformer, transformedTable: Table)
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `isFitted` {#safeds.data.tabular.transformation.TableTransformer.isFitted data-toc-label='[attribute] isFitted'}

Whether the transformer is fitted.

**Type:** [`Boolean`][safeds.lang.Boolean]

## <code class="doc-symbol doc-symbol-function"></code> `fit` {#safeds.data.tabular.transformation.TableTransformer.fit data-toc-label='[function] fit'}

Learn a transformation for a set of columns in a table.

**Note:** This transformer is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table used to fit the transformer. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`TableTransformer`][safeds.data.tabular.transformation.TableTransformer] | The fitted transformer. |

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="25"
    @Pure
    fun fit(
        table: Table
    ) -> fittedTransformer: TableTransformer
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `fitAndTransform` {#safeds.data.tabular.transformation.TableTransformer.fitAndTransform data-toc-label='[function] fitAndTransform'}

Learn a transformation for a set of columns in a table and apply the learned transformation to the same table.

**Note:** Neither this transformer nor the given table are modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table used to fit the transformer. The transformer is then applied to this table. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`TableTransformer`][safeds.data.tabular.transformation.TableTransformer] | The fitted transformer. |
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="54"
    @Pure
    @PythonName("fit_and_transform")
    fun fitAndTransform(
        table: Table
    ) -> (fittedTransformer: TableTransformer, transformedTable: Table)
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `transform` {#safeds.data.tabular.transformation.TableTransformer.transform data-toc-label='[function] transform'}

Apply the learned transformation to a table.

**Note:** The given table is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table to which the learned transformation is applied. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="39"
    @Pure
    fun transform(
        table: Table
    ) -> transformedTable: Table
    ```
    { data-search-exclude }
