[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `KNearestNeighborsImputer` {#safeds.data.tabular.transformation.KNearestNeighborsImputer data-toc-label='[class] KNearestNeighborsImputer'}

The KNearestNeighborsImputer replaces missing values in given Columns with the mean value of the K-nearest neighbors.

**Parent type:** [`TableTransformer`][safeds.data.tabular.transformation.TableTransformer]

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `neighborCount` | [`Int`][safeds.lang.Int] | The number of neighbors to consider when imputing missing values. | - |
| `columnNames` | `#!sds union<List<String>, String?>` | The list of columns used to impute missing values. If 'None', all columns are used. | `#!sds null` |
| `valueToReplace` | `#!sds union<Float, String?>` | The placeholder for the missing values. All occurrences of`missing_values` will be imputed. | `#!sds null` |

??? quote "Stub code in `KNearestNeighborsImputer.sdsstub`"

    ```sds linenums="13"
    class KNearestNeighborsImputer(
        @PythonName("neighbor_count") neighborCount: Int,
        @PythonName("column_names") columnNames: union<List<String>, String, Nothing?> = null,
        @PythonName("value_to_replace") valueToReplace: union<Float, String, Nothing?> = null
    ) sub TableTransformer {
        /**
         * The number of neighbors to consider when imputing missing values.
         */
        @PythonName("neighbor_count") attr neighborCount: Int
        /**
         * The value to replace.
         */
        @PythonName("value_to_replace") attr valueToReplace: Any?

        /**
         * Learn a transformation for a set of columns in a table.
         *
         * **Note:** This transformer is not modified.
         *
         * @param table The table used to fit the transformer.
         *
         * @result fittedTransformer The fitted transformer.
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQTransformer)
        fun fit(
            table: Table
        ) -> fittedTransformer: KNearestNeighborsImputer

        /**
         * Learn a transformation for a set of columns in a table and apply the learned transformation to the same table.
         *
         * **Note:** Neither this transformer nor the given table are modified.
         *
         * @param table The table used to fit the transformer. The transformer is then applied to this table.
         *
         * @result fittedTransformer The fitted transformer.
         * @result transformedTable The transformed table.
         */
        @Pure
        @PythonName("fit_and_transform")
        @Category(DataScienceCategory.DataProcessingQTransformer)
        fun fitAndTransform(
            table: Table
        ) -> (fittedTransformer: KNearestNeighborsImputer, transformedTable: Table)
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `isFitted` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.isFitted data-toc-label='[attribute] isFitted'}

Whether the transformer is fitted.

**Type:** [`Boolean`][safeds.lang.Boolean]

## <code class="doc-symbol doc-symbol-attribute"></code> `neighborCount` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.neighborCount data-toc-label='[attribute] neighborCount'}

The number of neighbors to consider when imputing missing values.

**Type:** [`Int`][safeds.lang.Int]

## <code class="doc-symbol doc-symbol-attribute"></code> `valueToReplace` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.valueToReplace data-toc-label='[attribute] valueToReplace'}

The value to replace.

**Type:** [`Any?`][safeds.lang.Any]

## <code class="doc-symbol doc-symbol-function"></code> `fit` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.fit data-toc-label='[function] fit'}

Learn a transformation for a set of columns in a table.

**Note:** This transformer is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table used to fit the transformer. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`KNearestNeighborsImputer`][safeds.data.tabular.transformation.KNearestNeighborsImputer] | The fitted transformer. |

??? quote "Stub code in `KNearestNeighborsImputer.sdsstub`"

    ```sds linenums="36"
    @Pure
    @Category(DataScienceCategory.DataProcessingQTransformer)
    fun fit(
        table: Table
    ) -> fittedTransformer: KNearestNeighborsImputer
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `fitAndTransform` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.fitAndTransform data-toc-label='[function] fitAndTransform'}

Learn a transformation for a set of columns in a table and apply the learned transformation to the same table.

**Note:** Neither this transformer nor the given table are modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table used to fit the transformer. The transformer is then applied to this table. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`KNearestNeighborsImputer`][safeds.data.tabular.transformation.KNearestNeighborsImputer] | The fitted transformer. |
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `KNearestNeighborsImputer.sdsstub`"

    ```sds linenums="52"
    @Pure
    @PythonName("fit_and_transform")
    @Category(DataScienceCategory.DataProcessingQTransformer)
    fun fitAndTransform(
        table: Table
    ) -> (fittedTransformer: KNearestNeighborsImputer, transformedTable: Table)
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `transform` {#safeds.data.tabular.transformation.KNearestNeighborsImputer.transform data-toc-label='[function] transform'}

Apply the learned transformation to a table.

**Note:** The given table is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table to which the learned transformation is applied. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="39"
    @Pure
    fun transform(
        table: Table
    ) -> transformedTable: Table
    ```
    { data-search-exclude }
