[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `FunctionalTableTransformer` {#safeds.data.tabular.transformation.FunctionalTableTransformer data-toc-label='[class] FunctionalTableTransformer'}

Wraps a callable so that it conforms to the TableTransformer interface.

**Parent type:** [`TableTransformer`][safeds.data.tabular.transformation.TableTransformer]

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `transformer` | `#!sds (table: Table) -> (transformedTable: Table)` | A callable that receives a table and returns a table. | - |

??? quote "Stub code in `FunctionalTableTransformer.sdsstub`"

    ```sds linenums="11"
    class FunctionalTableTransformer(
        transformer: (table: Table) -> transformedTable: Table
    ) sub TableTransformer {
        /**
         * **Note:** For FunctionalTableTransformer this is a no-OP.
         *
         * @param table Required only to be consistent with other transformers.
         *
         * @result fittedTransformer Returns self, because this transformer is always fitted.
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQTransformer)
        fun fit(
            table: Table
        ) -> fittedTransformer: FunctionalTableTransformer

        /**
         * **Note:** For the FunctionalTableTransformer this is the same as transform().
         *
         * @param table The table on which the callable is to be executed.
         *
         * @result fittedTransformer Return self because the transformer is always fitted.
         * @result transformedTable The transformed table.
         */
        @Pure
        @PythonName("fit_and_transform")
        @Category(DataScienceCategory.DataProcessingQTransformer)
        fun fitAndTransform(
            table: Table
        ) -> (fittedTransformer: FunctionalTableTransformer, transformedTable: Table)
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `isFitted` {#safeds.data.tabular.transformation.FunctionalTableTransformer.isFitted data-toc-label='[attribute] isFitted'}

Whether the transformer is fitted.

**Type:** [`Boolean`][safeds.lang.Boolean]

## <code class="doc-symbol doc-symbol-function"></code> `fit` {#safeds.data.tabular.transformation.FunctionalTableTransformer.fit data-toc-label='[function] fit'}

**Note:** For FunctionalTableTransformer this is a no-OP.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | Required only to be consistent with other transformers. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`FunctionalTableTransformer`][safeds.data.tabular.transformation.FunctionalTableTransformer] | Returns self, because this transformer is always fitted. |

??? quote "Stub code in `FunctionalTableTransformer.sdsstub`"

    ```sds linenums="21"
    @Pure
    @Category(DataScienceCategory.DataProcessingQTransformer)
    fun fit(
        table: Table
    ) -> fittedTransformer: FunctionalTableTransformer
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `fitAndTransform` {#safeds.data.tabular.transformation.FunctionalTableTransformer.fitAndTransform data-toc-label='[function] fitAndTransform'}

**Note:** For the FunctionalTableTransformer this is the same as transform().

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table on which the callable is to be executed. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `fittedTransformer` | [`FunctionalTableTransformer`][safeds.data.tabular.transformation.FunctionalTableTransformer] | Return self because the transformer is always fitted. |
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `FunctionalTableTransformer.sdsstub`"

    ```sds linenums="35"
    @Pure
    @PythonName("fit_and_transform")
    @Category(DataScienceCategory.DataProcessingQTransformer)
    fun fitAndTransform(
        table: Table
    ) -> (fittedTransformer: FunctionalTableTransformer, transformedTable: Table)
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `transform` {#safeds.data.tabular.transformation.FunctionalTableTransformer.transform data-toc-label='[function] transform'}

Apply the learned transformation to a table.

**Note:** The given table is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table to which the learned transformation is applied. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `transformedTable` | [`Table`][safeds.data.tabular.containers.Table] | The transformed table. |

??? quote "Stub code in `TableTransformer.sdsstub`"

    ```sds linenums="39"
    @Pure
    fun transform(
        table: Table
    ) -> transformedTable: Table
    ```
    { data-search-exclude }
