[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `TablePlotter` {#safeds.data.tabular.plotting.TablePlotter data-toc-label='[class] TablePlotter'}

A class that contains plotting methods for a table.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `table` | [`Table`][safeds.data.tabular.containers.Table] | The table to plot. | - |

**Examples:**

```sds
pipeline example {
    val table = Table({"test": [1, 2, 3]});
    val plotter = table.plot;
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="18"
    class TablePlotter(
        table: Table
    ) {
        /**
         * Create a box plot for every numerical column.
         *
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The box plot(s) as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table({"a":[1, 2], "b": [3, 42]});
         *     val image = table.plot.boxPlots();
         * }
         */
        @Pure
        @PythonName("box_plots")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun boxPlots(
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a violin plot for every numerical column.
         *
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The violin plot(s) as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table({"a": [1, 2], "b": [3, 42]});
         *     val image = table.plot.violinPlots();
         * }
         */
        @Pure
        @PythonName("violin_plots")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun violinPlots(
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Plot a correlation heatmap for all numerical columns of this `Table`.
         *
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table({"temperature": [10, 15, 20, 25, 30], "sales": [54, 74, 90, 206, 210]});
         *     val image = table.plot.correlationHeatmap();
         * }
         */
        @Pure
        @PythonName("correlation_heatmap")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun correlationHeatmap(
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Plot a histogram for every column.
         *
         * @param maxBinCount The maximum number of bins to use in the histogram. Default is 10.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table({"a": [2, 3, 5, 1], "b": [54, 74, 90, 2014]});
         *     val image = table.plot.histograms();
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun histograms(
            @PythonName("max_bin_count") const maxBinCount: Int = 10,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image where {
            maxBinCount > 0
        }

        /**
         * Create a line plot for two columns in the table.
         *
         * @param xName The name of the column to be plotted on the x-axis.
         * @param yNames The name(s) of the column(s) to be plotted on the y-axis.
         * @param showConfidenceInterval Whether a confidence interval is shown.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table(
         *         {
         *             "a": [1, 2, 3, 4, 5],
         *             "b": [2, 3, 4, 5, 6],
         *         }
         *     );
         *     val image = table.plot.linePlot("a", ["b"]);
         * }
         */
        @Pure
        @PythonName("line_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun linePlot(
            @PythonName("x_name") xName: String,
            @PythonName("y_names") yNames: List<String>,
            @PythonName("show_confidence_interval") showConfidenceInterval: Boolean = true,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a scatter plot for two columns in the table.
         *
         * @param xName The name of the column to be plotted on the x-axis.
         * @param yNames The name(s) of the column(s) to be plotted on the y-axis.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table(
         *         {
         *             "a": [1, 2, 3, 4, 5],
         *             "b": [2, 3, 4, 5, 6],
         *         }
         *     );
         *     val image = table.plot.scatterPlot("a", ["b"]);
         * }
         */
        @Pure
        @PythonName("scatter_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun scatterPlot(
            @PythonName("x_name") xName: String,
            @PythonName("y_names") yNames: List<String>,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a moving average plot for the y column and plot it by the x column in the table.
         *
         * @param xName The name of the column to be plotted on the x-axis.
         * @param yName The name of the column to be plotted on the y-axis.
         * @param windowSize The size of the moving average window
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table(
         *         {
         *             "a": [1, 2, 3, 4, 5],
         *             "b": [2, 3, 4, 5, 6],
         *         }
         *     );
         *     val image = table.plot.movingAveragePlot("a", "b", windowSize = 2);
         * }
         */
        @Pure
        @PythonName("moving_average_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun movingAveragePlot(
            @PythonName("x_name") xName: String,
            @PythonName("y_name") yName: String,
            @PythonName("window_size") windowSize: Int,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a 2D histogram for two columns in the table.
         *
         * @param xName The name of the column to be plotted on the x-axis.
         * @param yName The name of the column to be plotted on the y-axis.
         * @param xMaxBinCount The maximum number of bins to use in the histogram for the x-axis. Default is 10.
         * @param yMaxBinCount The maximum number of bins to use in the histogram for the y-axis. Default is 10.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val table = Table(
         *         {
         *             "a": [1, 2, 3, 4, 5],
         *             "b": [2, 3, 4, 5, 6],
         *         }
         *     );
         *     val image = table.plot.histogram2d("a", "b");
         * }
         */
        @Pure
        @PythonName("histogram_2d")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun histogram2d(
            @PythonName("x_name") xName: String,
            @PythonName("y_name") yName: String,
            @PythonName("x_max_bin_count") xMaxBinCount: Int = 10,
            @PythonName("y_max_bin_count") yMaxBinCount: Int = 10,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `boxPlots` {#safeds.data.tabular.plotting.TablePlotter.boxPlots data-toc-label='[function] boxPlots'}

Create a box plot for every numerical column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The box plot(s) as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val table = Table({"a":[1, 2], "b": [3, 42]});
    val image = table.plot.boxPlots();
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="34"
    @Pure
    @PythonName("box_plots")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun boxPlots(
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `correlationHeatmap` {#safeds.data.tabular.plotting.TablePlotter.correlationHeatmap data-toc-label='[function] correlationHeatmap'}

Plot a correlation heatmap for all numerical columns of this `Table`.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val table = Table({"temperature": [10, 15, 20, 25, 30], "sales": [54, 74, 90, 206, 210]});
    val image = table.plot.correlationHeatmap();
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="74"
    @Pure
    @PythonName("correlation_heatmap")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun correlationHeatmap(
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `histogram2d` {#safeds.data.tabular.plotting.TablePlotter.histogram2d data-toc-label='[function] histogram2d'}

Create a 2D histogram for two columns in the table.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `xName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the x-axis. | - |
| `yName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the y-axis. | - |
| `xMaxBinCount` | [`Int`][safeds.lang.Int] | The maximum number of bins to use in the histogram for the x-axis. Default is 10. | `#!sds 10` |
| `yMaxBinCount` | [`Int`][safeds.lang.Int] | The maximum number of bins to use in the histogram for the y-axis. Default is 10. | `#!sds 10` |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="8"
pipeline example {
    val table = Table(
        {
            "a": [1, 2, 3, 4, 5],
            "b": [2, 3, 4, 5, 6],
        }
    );
    val image = table.plot.histogram2d("a", "b");
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="217"
    @Pure
    @PythonName("histogram_2d")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun histogram2d(
        @PythonName("x_name") xName: String,
        @PythonName("y_name") yName: String,
        @PythonName("x_max_bin_count") xMaxBinCount: Int = 10,
        @PythonName("y_max_bin_count") yMaxBinCount: Int = 10,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `histograms` {#safeds.data.tabular.plotting.TablePlotter.histograms data-toc-label='[function] histograms'}

Plot a histogram for every column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `maxBinCount` | [`Int`][safeds.lang.Int] | The maximum number of bins to use in the histogram. Default is 10. | `#!sds 10` |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val table = Table({"a": [2, 3, 5, 1], "b": [54, 74, 90, 2014]});
    val image = table.plot.histograms();
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="95"
    @Pure
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun histograms(
        @PythonName("max_bin_count") const maxBinCount: Int = 10,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image where {
        maxBinCount > 0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `linePlot` {#safeds.data.tabular.plotting.TablePlotter.linePlot data-toc-label='[function] linePlot'}

Create a line plot for two columns in the table.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `xName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the x-axis. | - |
| `yNames` | [`List<String>`][safeds.lang.List] | The name(s) of the column(s) to be plotted on the y-axis. | - |
| `showConfidenceInterval` | [`Boolean`][safeds.lang.Boolean] | Whether a confidence interval is shown. | `#!sds true` |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="8"
pipeline example {
    val table = Table(
        {
            "a": [1, 2, 3, 4, 5],
            "b": [2, 3, 4, 5, 6],
        }
    );
    val image = table.plot.linePlot("a", ["b"]);
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="125"
    @Pure
    @PythonName("line_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun linePlot(
        @PythonName("x_name") xName: String,
        @PythonName("y_names") yNames: List<String>,
        @PythonName("show_confidence_interval") showConfidenceInterval: Boolean = true,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `movingAveragePlot` {#safeds.data.tabular.plotting.TablePlotter.movingAveragePlot data-toc-label='[function] movingAveragePlot'}

Create a moving average plot for the y column and plot it by the x column in the table.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `xName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the x-axis. | - |
| `yName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the y-axis. | - |
| `windowSize` | [`Int`][safeds.lang.Int] | The size of the moving average window | - |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="8"
pipeline example {
    val table = Table(
        {
            "a": [1, 2, 3, 4, 5],
            "b": [2, 3, 4, 5, 6],
        }
    );
    val image = table.plot.movingAveragePlot("a", "b", windowSize = 2);
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="185"
    @Pure
    @PythonName("moving_average_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun movingAveragePlot(
        @PythonName("x_name") xName: String,
        @PythonName("y_name") yName: String,
        @PythonName("window_size") windowSize: Int,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `scatterPlot` {#safeds.data.tabular.plotting.TablePlotter.scatterPlot data-toc-label='[function] scatterPlot'}

Create a scatter plot for two columns in the table.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `xName` | [`String`][safeds.lang.String] | The name of the column to be plotted on the x-axis. | - |
| `yNames` | [`List<String>`][safeds.lang.List] | The name(s) of the column(s) to be plotted on the y-axis. | - |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="8"
pipeline example {
    val table = Table(
        {
            "a": [1, 2, 3, 4, 5],
            "b": [2, 3, 4, 5, 6],
        }
    );
    val image = table.plot.scatterPlot("a", ["b"]);
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="155"
    @Pure
    @PythonName("scatter_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun scatterPlot(
        @PythonName("x_name") xName: String,
        @PythonName("y_names") yNames: List<String>,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `violinPlots` {#safeds.data.tabular.plotting.TablePlotter.violinPlots data-toc-label='[function] violinPlots'}

Create a violin plot for every numerical column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The violin plot(s) as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val table = Table({"a": [1, 2], "b": [3, 42]});
    val image = table.plot.violinPlots();
}
```

??? quote "Stub code in `TablePlotter.sdsstub`"

    ```sds linenums="54"
    @Pure
    @PythonName("violin_plots")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun violinPlots(
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }
