[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `ColumnPlotter` {#safeds.data.tabular.plotting.ColumnPlotter data-toc-label='[class] ColumnPlotter'}

A class that contains plotting methods for a column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `column` | [`Column<Any>`][safeds.data.tabular.containers.Column] | The column to plot. | - |

**Examples:**

```sds
pipeline example {
    val column = Column("test", [1, 2, 3]);
    val plotter = column.plot;
}
```

??? quote "Stub code in `ColumnPlotter.sdsstub`"

    ```sds linenums="17"
    class ColumnPlotter(
        column: Column<Any>
    ) {
        /**
         * Create a box plot for the values in the column. This is only possible for numeric columns.
         *
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The box plot as an image.
         *
         * @example
         * pipeline example {
         *     val column = Column("test", [1, 2, 3]);
         *     val boxplot = column.plot.boxPlot();
         * }
         */
        @Pure
        @PythonName("box_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun boxPlot(
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a violin plot for the values in the column. This is only possible for numeric columns.
         *
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The violin plot as an image.
         *
         * @example
         * pipeline example {
         *     val column = Column("test", [1, 2, 3]);
         *     val violinplot = column.plot.violinPlot();
         * }
         */
        @Pure
        @PythonName("violin_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun violinPlot(
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image

        /**
         * Create a histogram for the values in the column.
         *
         * @param maxBinCount The maximum number of bins to use in the histogram. Default is 10.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val column = Column("test", [1, 2, 3]);
         *     val histogram = column.plot.histogram();
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun histogram(
            @PythonName("max_bin_count") const maxBinCount: Int = 10,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image where {
            maxBinCount > 0
        }

        /**
         * Create a lag plot for the values in the column.
         *
         * @param lag The amount of lag.
         * @param theme The color theme of the plot. Default is "light".
         *
         * @result plot The plot as an image.
         *
         * @example
         * pipeline example {
         *     val column = Column("values", [1, 2, 3, 4]);
         *     val image = column.plot.lagPlot(2);
         * }
         */
        @Pure
        @PythonName("lag_plot")
        @Category(DataScienceCategory.DataExplorationQVisualization)
        fun lagPlot(
            lag: Int,
            theme: literal<"dark", "light"> = "light"
        ) -> plot: Image
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `boxPlot` {#safeds.data.tabular.plotting.ColumnPlotter.boxPlot data-toc-label='[function] boxPlot'}

Create a box plot for the values in the column. This is only possible for numeric columns.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The box plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("test", [1, 2, 3]);
    val boxplot = column.plot.boxPlot();
}
```

??? quote "Stub code in `ColumnPlotter.sdsstub`"

    ```sds linenums="33"
    @Pure
    @PythonName("box_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun boxPlot(
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `histogram` {#safeds.data.tabular.plotting.ColumnPlotter.histogram data-toc-label='[function] histogram'}

Create a histogram for the values in the column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `maxBinCount` | [`Int`][safeds.lang.Int] | The maximum number of bins to use in the histogram. Default is 10. | `#!sds 10` |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("test", [1, 2, 3]);
    val histogram = column.plot.histogram();
}
```

??? quote "Stub code in `ColumnPlotter.sdsstub`"

    ```sds linenums="74"
    @Pure
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun histogram(
        @PythonName("max_bin_count") const maxBinCount: Int = 10,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image where {
        maxBinCount > 0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `lagPlot` {#safeds.data.tabular.plotting.ColumnPlotter.lagPlot data-toc-label='[function] lagPlot'}

Create a lag plot for the values in the column.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `lag` | [`Int`][safeds.lang.Int] | The amount of lag. | - |
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("values", [1, 2, 3, 4]);
    val image = column.plot.lagPlot(2);
}
```

??? quote "Stub code in `ColumnPlotter.sdsstub`"

    ```sds linenums="97"
    @Pure
    @PythonName("lag_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun lagPlot(
        lag: Int,
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `violinPlot` {#safeds.data.tabular.plotting.ColumnPlotter.violinPlot data-toc-label='[function] violinPlot'}

Create a violin plot for the values in the column. This is only possible for numeric columns.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `theme` | `#!sds literal<"dark", "light">` | The color theme of the plot. Default is "light". | `#!sds "light"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `plot` | [`Image`][safeds.data.image.containers.Image] | The violin plot as an image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("test", [1, 2, 3]);
    val violinplot = column.plot.violinPlot();
}
```

??? quote "Stub code in `ColumnPlotter.sdsstub`"

    ```sds linenums="53"
    @Pure
    @PythonName("violin_plot")
    @Category(DataScienceCategory.DataExplorationQVisualization)
    fun violinPlot(
        theme: literal<"dark", "light"> = "light"
    ) -> plot: Image
    ```
    { data-search-exclude }
