---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-class"></code> `TemporalCell` {#safeds.data.tabular.containers.TemporalCell data-toc-label='[class] TemporalCell'}

Namespace for operations on temporal data.

This class cannot be instantiated directly. It can only be accessed using the `dt` attribute of a cell.

**Examples:**

```sds
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 9)])
    // column.transform(lambda cell: cell.dt.date_to_string("%Y/%m/%d"))
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="17"
    class TemporalCell {
        /**
         * Get the century of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 1)])
         *     // column.transform(lambda cell: cell.dt.century())
         * }
         */
        @Pure
        fun century() -> century: Cell<Int>

        /**
         * Get the weekday of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 1)])
         *     // column.transform(lambda cell: cell.dt.weekday())
         * }
         */
        @Pure
        fun weekday() -> weekday: Cell<Int>

        /**
         * Get the week of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 1)])
         *     // column.transform(lambda cell: cell.dt.week())
         * }
         */
        @Pure
        fun week() -> week: Cell<Int>

        /**
         * Get the year of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 9)])
         *     // column.transform(lambda cell: cell.dt.year())
         * }
         */
        @Pure
        fun year() -> year: Cell<Int>

        /**
         * Get the month of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 9)])
         *     // column.transform(lambda cell: cell.dt.month())
         * }
         */
        @Pure
        fun month() -> month: Cell<Int>

        /**
         * Get the day of the underlying date(time) data.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 9)])
         *     // column.transform(lambda cell: cell.dt.day())
         * }
         */
        @Pure
        fun day() -> day: Cell<Int>

        /**
         * Convert the date value in the cell to a string.
         *
         * @param formatString The format string it will be used to convert the data into the string.
         *
         * @result string The string value.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [ datetime.datetime(2022, 1, 9, 23, 29, 1, tzinfo=datetime.UTC)])
         *     // column.transform(lambda cell: cell.dt.datetime_to_string())
         * }
         */
        @Pure
        @PythonName("datetime_to_string")
        fun datetimeToString(
            @PythonName("format_string") formatString: String = "%Y/%m/%d %H:%M:%S"
        ) -> string: Cell<String>

        /**
         * Convert the date value in the cell to a string.
         *
         * @param formatString The format string it will be used to convert the data into the string.
         *
         * @result string The string value.
         *
         * @example
         * pipeline example {
         *     // from safeds.data.tabular.containers import Column
         *     // import datetime
         *     // column = Column("example", [datetime.date(2022, 1, 9)])
         *     // column.transform(lambda cell: cell.dt.date_to_string())
         * }
         */
        @Pure
        @PythonName("date_to_string")
        fun dateToString(
            @PythonName("format_string") formatString: String = "%F"
        ) -> string: Cell<String>
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `century` {#safeds.data.tabular.containers.TemporalCell.century data-toc-label='[function] century'}

Get the century of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `century` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 1)])
    // column.transform(lambda cell: cell.dt.century())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="29"
    @Pure
    fun century() -> century: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `datetimeToString` {#safeds.data.tabular.containers.TemporalCell.datetimeToString data-toc-label='[function] datetimeToString'}

Convert the date value in the cell to a string.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `formatString` | [`String`][safeds.lang.String] | The format string it will be used to convert the data into the string. | `#!sds "%Y/%m/%d %H:%M:%S"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `string` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value. |

**Examples:**

```sds
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [ datetime.datetime(2022, 1, 9, 23, 29, 1, tzinfo=datetime.UTC)])
    // column.transform(lambda cell: cell.dt.datetime_to_string())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="117"
    @Pure
    @PythonName("datetime_to_string")
    fun datetimeToString(
        @PythonName("format_string") formatString: String = "%Y/%m/%d %H:%M:%S"
    ) -> string: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `dateToString` {#safeds.data.tabular.containers.TemporalCell.dateToString data-toc-label='[function] dateToString'}

Convert the date value in the cell to a string.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `formatString` | [`String`][safeds.lang.String] | The format string it will be used to convert the data into the string. | `#!sds "%F"` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `string` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value. |

**Examples:**

```sds
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 9)])
    // column.transform(lambda cell: cell.dt.date_to_string())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="138"
    @Pure
    @PythonName("date_to_string")
    fun dateToString(
        @PythonName("format_string") formatString: String = "%F"
    ) -> string: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `day` {#safeds.data.tabular.containers.TemporalCell.day data-toc-label='[function] day'}

Get the day of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `day` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 9)])
    // column.transform(lambda cell: cell.dt.day())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="99"
    @Pure
    fun day() -> day: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `month` {#safeds.data.tabular.containers.TemporalCell.month data-toc-label='[function] month'}

Get the month of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `month` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 9)])
    // column.transform(lambda cell: cell.dt.month())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="85"
    @Pure
    fun month() -> month: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `week` {#safeds.data.tabular.containers.TemporalCell.week data-toc-label='[function] week'}

Get the week of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `week` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 1)])
    // column.transform(lambda cell: cell.dt.week())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="57"
    @Pure
    fun week() -> week: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `weekday` {#safeds.data.tabular.containers.TemporalCell.weekday data-toc-label='[function] weekday'}

Get the weekday of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `weekday` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 1)])
    // column.transform(lambda cell: cell.dt.weekday())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="43"
    @Pure
    fun weekday() -> weekday: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `year` {#safeds.data.tabular.containers.TemporalCell.year data-toc-label='[function] year'}

Get the year of the underlying date(time) data.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `year` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    // from safeds.data.tabular.containers import Column
    // import datetime
    // column = Column("example", [datetime.date(2022, 1, 9)])
    // column.transform(lambda cell: cell.dt.year())
}
```

??? quote "Stub code in `TemporalCell.sdsstub`"

    ```sds linenums="71"
    @Pure
    fun year() -> year: Cell<Int>
    ```
    { data-search-exclude }
