---
search:
  boost: 0.5
---

[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `StringCell` {#safeds.data.tabular.containers.StringCell data-toc-label='[class] StringCell'}

Namespace for operations on strings.

This class cannot be instantiated directly. It can only be accessed using the `str` attribute of a cell.

**Examples:**

```sds
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.transform((cell) -> cell.str.toUppercase());
    // Column("example", ["AB", "BC", "CD"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="15"
    class StringCell {
        /**
         * Check if the string value in the cell contains the substring.
         *
         * @param substring The substring to search for.
         *
         * @result contains Whether the string value contains the substring.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.countIf((cell) -> cell.str.contains("b")); // 2
         * }
         */
        @Pure
        fun contains(
            substring: String
        ) -> contains: Cell<Boolean>

        /**
         * Check if the string value in the cell ends with the suffix.
         *
         * @param suffix The suffix to search for.
         *
         * @result endsWith Whether the string value ends with the suffix.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.countIf((cell) -> cell.str.endsWith("c")); // 1
         * }
         */
        @Pure
        @PythonName("ends_with")
        fun endsWith(
            suffix: String
        ) -> endsWith: Cell<Boolean>

        /**
         * Get the index of the first occurrence of the substring in the string value in the cell.
         *
         * @param substring The substring to search for.
         *
         * @result indexOf The index of the first occurrence of the substring. If the substring is not found, null is returned.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.transform((cell) -> cell.str.indexOf("b"));
         *     // Column("example", [1, 0, null])
         * }
         */
        @Pure
        @PythonName("index_of")
        fun indexOf(
            substring: String
        ) -> indexOf: Cell<Int?>

        /**
         * Get the number of characters of the string value in the cell.
         *
         * @param optimizeForAscii Greatly speed up this operation if the string is ASCII-only. If the string contains non-ASCII characters,
         * this option will return incorrect results, though.
         *
         * @result length The length of the string value.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["", "a", "abc"]);
         *     val result = column.transform((cell) -> cell.str.length());
         *     // Column("example", [0, 1, 3])
         * }
         */
        @Pure
        fun length(
            @PythonName("optimize_for_ascii") optimizeForAscii: Boolean = false
        ) -> length: Cell<Int>

        /**
         * Replace occurrences of the old substring with the new substring in the string value in the cell.
         *
         * @param old The substring to replace.
         * @param new The substring to replace with.
         *
         * @result replacedString The string value with the occurrences replaced.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.transform((cell) -> cell.str.replace("b", "z"));
         *     // Column("example", ["az", "zc", "cd"])
         * }
         */
        @Pure
        fun replace(
            old: String,
            new: String
        ) -> replacedString: Cell<String>

        /**
         * Check if the string value in the cell starts with the prefix.
         *
         * @param prefix The prefix to search for.
         *
         * @result startsWith Whether the string value starts with the prefix.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.countIf((cell) -> cell.str.startsWith("a")); // 1
         * }
         */
        @Pure
        @PythonName("starts_with")
        fun startsWith(
            prefix: String
        ) -> startsWith: Cell<Boolean>

        /**
         * Get a substring of the string value in the cell.
         *
         * @param start The start index of the substring.
         * @param length The length of the substring. If null, the slice contains all rows starting from `start`. Must greater than
         * or equal to 0.
         *
         * @result substring The substring of the string value.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["abc", "def", "ghi"]);
         *     val result = column.transform((cell) -> cell.str.substring(1, 2));
         *     // Column("example", ["bc", "ef", "hi"])
         * }
         */
        @Pure
        fun substring(
            start: Int = 0,
            length: Int? = null
        ) -> substring: Cell<String>

        /**
         * Convert the string value in the cell to a date. Requires the string to be in the ISO 8601 format.
         *
         * @result date The date value. If the string cannot be converted to a date, null is returned.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["2021-01-01", "2021-02-01", "abc"]);
         *     val result = column.transform((cell) -> cell.str.toDate());
         * }
         */
        @Pure
        @PythonName("to_date")
        fun toDate() -> date: Cell  // TODO: Add builtin type for date

        /**
         * Convert the string value in the cell to a datetime. Requires the string to be in the ISO 8601 format.
         *
         * @result datetime The datetime value. If the string cannot be converted to a datetime, null is returned.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["2021-01-01T00:00:00z", "2021-02-01T00:00:00z", "abc"]);
         *     val result = column.transform((cell) -> cell.str.toDatetime());
         * }
         */
        @Pure
        @PythonName("to_datetime")
        fun toDatetime() -> datetime: Cell  // TODO: Add builtin type for datetime

        /**
         * Convert the string value in the cell to a float.
         *
         * @result float The float value. If the string cannot be converted to a float, null is returned.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["1", "3.4", "5.6", "abc"]);
         *     val result = column.transform((cell) -> cell.str.toFloat());
         *     // Column("example", [1.0, 3.4, 5.6, null])
         * }
         */
        @Pure
        @PythonName("to_float")
        fun toFloat() -> float: Cell<Float?>

        /**
         * Convert the string value in the cell to an integer.
         *
         * @param base The base of the integer.
         *
         * @result int The integer value. If the string cannot be converted to an integer, null is returned.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["1", "2", "3", "abc"]);
         *     val result = column.transform((cell) -> cell.str.toInt());
         *     // Column("example", [1, 2, 3, null])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["1", "10", "11", "abc"]);
         *     val result = column.transform((cell) -> cell.str.toInt(base = 2));
         *     // Column("example", [1, 2, 3, null])
         * }
         */
        @Pure
        @PythonName("to_int")
        fun toInt(
            base: Int = 10
        ) -> int: Cell<Int?>

        /**
         * Convert the string value in the cell to lowercase.
         *
         * @result lowercase The string value in lowercase.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["AB", "BC", "CD"]);
         *     val result = column.transform((cell) -> cell.str.toLowercase());
         *     // Column("example", ["ab", "bc", "cd"])
         * }
         */
        @Pure
        @PythonName("to_lowercase")
        fun toLowercase() -> lowercase: Cell<String>

        /**
         * Convert the string value in the cell to uppercase.
         *
         * @result uppercase The string value in uppercase.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["ab", "bc", "cd"]);
         *     val result = column.transform((cell) -> cell.str.toUppercase());
         *     // Column("example", ["AB", "BC", "CD"])
         * }
         */
        @Pure
        @PythonName("to_uppercase")
        fun toUppercase() -> uppercase: Cell<String>

        /**
         * Remove whitespace from the start and end of the string value in the cell.
         *
         * @result trimmed The string value without whitespace at the start and end.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["", " abc", "abc ", " abc "]);
         *     val result = column.transform((cell) -> cell.str.trim());
         *     // Column("example", ["", "abc", "abc", "abc"])
         * }
         */
        @Pure
        fun trim() -> trimmed: Cell<String>

        /**
         * Remove whitespace from the end of the string value in the cell.
         *
         * @result trimmed The string value without whitespace at the end.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["", " abc", "abc ", " abc "]);
         *     val result = column.transform((cell) -> cell.str.trimEnd());
         *     // Column("example", ["", " abc", "abc", " abc"])
         * }
         */
        @Pure
        @PythonName("trim_end")
        fun trimEnd() -> trimmed: Cell<String>

        /**
         * Remove whitespace from the start of the string value in the cell.
         *
         * @result trimmed The string value without whitespace at the start.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", ["", " abc", "abc ", " abc "]);
         *     val result = column.transform((cell) -> cell.str.trimStart());
         *     // Column("example", ["", "abc", "abc ", "abc "])
         * }
         */
        @Pure
        @PythonName("trim_start")
        fun trimStart() -> trimmed: Cell<String>
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `contains` {#safeds.data.tabular.containers.StringCell.contains data-toc-label='[function] contains'}

Check if the string value in the cell contains the substring.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `substring` | [`String`][safeds.lang.String] | The substring to search for. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `contains` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | Whether the string value contains the substring. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.countIf((cell) -> cell.str.contains("b")); // 2
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="29"
    @Pure
    fun contains(
        substring: String
    ) -> contains: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `endsWith` {#safeds.data.tabular.containers.StringCell.endsWith data-toc-label='[function] endsWith'}

Check if the string value in the cell ends with the suffix.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `suffix` | [`String`][safeds.lang.String] | The suffix to search for. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `endsWith` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | Whether the string value ends with the suffix. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.countIf((cell) -> cell.str.endsWith("c")); // 1
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="47"
    @Pure
    @PythonName("ends_with")
    fun endsWith(
        suffix: String
    ) -> endsWith: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `indexOf` {#safeds.data.tabular.containers.StringCell.indexOf data-toc-label='[function] indexOf'}

Get the index of the first occurrence of the substring in the string value in the cell.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `substring` | [`String`][safeds.lang.String] | The substring to search for. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `indexOf` | [`Cell<Int?>`][safeds.data.tabular.containers.Cell] | The index of the first occurrence of the substring. If the substring is not found, null is returned. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.transform((cell) -> cell.str.indexOf("b"));
    // Column("example", [1, 0, null])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="67"
    @Pure
    @PythonName("index_of")
    fun indexOf(
        substring: String
    ) -> indexOf: Cell<Int?>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `length` {#safeds.data.tabular.containers.StringCell.length data-toc-label='[function] length'}

Get the number of characters of the string value in the cell.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `optimizeForAscii` | [`Boolean`][safeds.lang.Boolean] | Greatly speed up this operation if the string is ASCII-only. If the string contains non-ASCII characters, this option will return incorrect results, though. | `#!sds false` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `length` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | The length of the string value. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["", "a", "abc"]);
    val result = column.transform((cell) -> cell.str.length());
    // Column("example", [0, 1, 3])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="88"
    @Pure
    fun length(
        @PythonName("optimize_for_ascii") optimizeForAscii: Boolean = false
    ) -> length: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `replace` {#safeds.data.tabular.containers.StringCell.replace data-toc-label='[function] replace'}

Replace occurrences of the old substring with the new substring in the string value in the cell.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `old` | [`String`][safeds.lang.String] | The substring to replace. | - |
| `new` | [`String`][safeds.lang.String] | The substring to replace with. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `replacedString` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value with the occurrences replaced. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.transform((cell) -> cell.str.replace("b", "z"));
    // Column("example", ["az", "zc", "cd"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="108"
    @Pure
    fun replace(
        old: String,
        new: String
    ) -> replacedString: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `startsWith` {#safeds.data.tabular.containers.StringCell.startsWith data-toc-label='[function] startsWith'}

Check if the string value in the cell starts with the prefix.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `prefix` | [`String`][safeds.lang.String] | The prefix to search for. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `startsWith` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | Whether the string value starts with the prefix. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.countIf((cell) -> cell.str.startsWith("a")); // 1
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="127"
    @Pure
    @PythonName("starts_with")
    fun startsWith(
        prefix: String
    ) -> startsWith: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `substring` {#safeds.data.tabular.containers.StringCell.substring data-toc-label='[function] substring'}

Get a substring of the string value in the cell.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `start` | [`Int`][safeds.lang.Int] | The start index of the substring. | `#!sds 0` |
| `length` | [`Int?`][safeds.lang.Int] | The length of the substring. If null, the slice contains all rows starting from `start`. Must greater than or equal to 0. | `#!sds null` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `substring` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The substring of the string value. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["abc", "def", "ghi"]);
    val result = column.transform((cell) -> cell.str.substring(1, 2));
    // Column("example", ["bc", "ef", "hi"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="149"
    @Pure
    fun substring(
        start: Int = 0,
        length: Int? = null
    ) -> substring: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toDate` {#safeds.data.tabular.containers.StringCell.toDate data-toc-label='[function] toDate'}

Convert the string value in the cell to a date. Requires the string to be in the ISO 8601 format.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `date` | [`Cell<Any?>`][safeds.data.tabular.containers.Cell] | The date value. If the string cannot be converted to a date, null is returned. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["2021-01-01", "2021-02-01", "abc"]);
    val result = column.transform((cell) -> cell.str.toDate());
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="166"
    @Pure
    @PythonName("to_date")
    fun toDate() -> date: Cell
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toDatetime` {#safeds.data.tabular.containers.StringCell.toDatetime data-toc-label='[function] toDatetime'}

Convert the string value in the cell to a datetime. Requires the string to be in the ISO 8601 format.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `datetime` | [`Cell<Any?>`][safeds.data.tabular.containers.Cell] | The datetime value. If the string cannot be converted to a datetime, null is returned. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["2021-01-01T00:00:00z", "2021-02-01T00:00:00z", "abc"]);
    val result = column.transform((cell) -> cell.str.toDatetime());
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="181"
    @Pure
    @PythonName("to_datetime")
    fun toDatetime() -> datetime: Cell
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toFloat` {#safeds.data.tabular.containers.StringCell.toFloat data-toc-label='[function] toFloat'}

Convert the string value in the cell to a float.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `float` | [`Cell<Float?>`][safeds.data.tabular.containers.Cell] | The float value. If the string cannot be converted to a float, null is returned. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["1", "3.4", "5.6", "abc"]);
    val result = column.transform((cell) -> cell.str.toFloat());
    // Column("example", [1.0, 3.4, 5.6, null])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="197"
    @Pure
    @PythonName("to_float")
    fun toFloat() -> float: Cell<Float?>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toInt` {#safeds.data.tabular.containers.StringCell.toInt data-toc-label='[function] toInt'}

Convert the string value in the cell to an integer.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `base` | [`Int`][safeds.lang.Int] | The base of the integer. | `#!sds 10` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `int` | [`Cell<Int?>`][safeds.data.tabular.containers.Cell] | The integer value. If the string cannot be converted to an integer, null is returned. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["1", "2", "3", "abc"]);
    val result = column.transform((cell) -> cell.str.toInt());
    // Column("example", [1, 2, 3, null])
}
```
```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["1", "10", "11", "abc"]);
    val result = column.transform((cell) -> cell.str.toInt(base = 2));
    // Column("example", [1, 2, 3, null])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="222"
    @Pure
    @PythonName("to_int")
    fun toInt(
        base: Int = 10
    ) -> int: Cell<Int?>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toLowercase` {#safeds.data.tabular.containers.StringCell.toLowercase data-toc-label='[function] toLowercase'}

Convert the string value in the cell to lowercase.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `lowercase` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value in lowercase. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["AB", "BC", "CD"]);
    val result = column.transform((cell) -> cell.str.toLowercase());
    // Column("example", ["ab", "bc", "cd"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="240"
    @Pure
    @PythonName("to_lowercase")
    fun toLowercase() -> lowercase: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toUppercase` {#safeds.data.tabular.containers.StringCell.toUppercase data-toc-label='[function] toUppercase'}

Convert the string value in the cell to uppercase.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `uppercase` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value in uppercase. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["ab", "bc", "cd"]);
    val result = column.transform((cell) -> cell.str.toUppercase());
    // Column("example", ["AB", "BC", "CD"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="256"
    @Pure
    @PythonName("to_uppercase")
    fun toUppercase() -> uppercase: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `trim` {#safeds.data.tabular.containers.StringCell.trim data-toc-label='[function] trim'}

Remove whitespace from the start and end of the string value in the cell.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `trimmed` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value without whitespace at the start and end. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["", " abc", "abc ", " abc "]);
    val result = column.transform((cell) -> cell.str.trim());
    // Column("example", ["", "abc", "abc", "abc"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="272"
    @Pure
    fun trim() -> trimmed: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `trimEnd` {#safeds.data.tabular.containers.StringCell.trimEnd data-toc-label='[function] trimEnd'}

Remove whitespace from the end of the string value in the cell.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `trimmed` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value without whitespace at the end. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["", " abc", "abc ", " abc "]);
    val result = column.transform((cell) -> cell.str.trimEnd());
    // Column("example", ["", " abc", "abc", " abc"])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="287"
    @Pure
    @PythonName("trim_end")
    fun trimEnd() -> trimmed: Cell<String>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `trimStart` {#safeds.data.tabular.containers.StringCell.trimStart data-toc-label='[function] trimStart'}

Remove whitespace from the start of the string value in the cell.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `trimmed` | [`Cell<String>`][safeds.data.tabular.containers.Cell] | The string value without whitespace at the start. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", ["", " abc", "abc ", " abc "]);
    val result = column.transform((cell) -> cell.str.trimStart());
    // Column("example", ["", "abc", "abc ", "abc "])
}
```

??? quote "Stub code in `StringCell.sdsstub`"

    ```sds linenums="303"
    @Pure
    @PythonName("trim_start")
    fun trimStart() -> trimmed: Cell<String>
    ```
    { data-search-exclude }
