[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# <code class="doc-symbol doc-symbol-class"></code> `Cell` {#safeds.data.tabular.containers.Cell data-toc-label='[class] Cell'}

A single value in a table.

This class cannot be instantiated directly. It is only used for arguments of callbacks.

**Type parameters:**

| Name | Upper Bound | Description | Default |
|------|-------------|-------------|---------|
| `T` | [`Any?`][safeds.lang.Any] | - | [`Any?`][safeds.lang.Any] |

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="8"
    class Cell<out T = Any?> {
        /**
         * Namespace for operations on strings.
         */
        attr str: StringCell
        /**
         * Namespace for operations on date time values.
         */
        @Experimental
        attr dt: TemporalCell

        /**
         * Return the first cell from the given list that is not None.
         *
         * @param cells The list of cells to be searched.
         *
         * @result cell Returns the contents of the first cell that is not None.
         * If all cells in the list are None or the list is empty returns None.
         */
        @Pure
        @PythonName("first_not_none")
        static fun firstNotNone<T>(
            cells: List<Cell<T>>
        ) -> cell: Cell<T?>

        /**
         * Negate a boolean. This is equivalent to the `not` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell.^not());
         *     // Column("example", [false, true])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> not cell);
         *     // Column("example", [false, true])
         * }
         */
        @Pure
        @PythonName("not_")
        fun ^not() -> result: Cell<Boolean>

        /**
         * Perform a boolean AND operation. This is equivalent to the `and` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell.^and(false));
         *     // Column("example", [false, false])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell and false);
         *     // Column("example", [false, false])
         * }
         */
        @Pure
        @PythonName("and_")
        fun ^and(
            other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
        ) -> result: Cell<Boolean>

        /**
         * Perform a boolean OR operation. This is equivalent to the `or` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell.^or(true));
         *     // Column("example", [true, true])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell or true);
         *     // Column("example", [true, true])
         * }
         */
        @Pure
        @PythonName("or_")
        fun ^or(
            other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
        ) -> result: Cell<Boolean>

        /**
         * Perform a boolean XOR operation.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [true, false]);
         *     val result = column.transform((cell) -> cell.xor(true));
         *     // Column("example", [false, true])
         * }
         */
        @Pure
        fun xor(
            other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
        ) -> result: Cell<Boolean>

        /**
         * Get the absolute value.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, -2]);
         *     val result = column.transform((cell) -> cell.abs());
         *     // Column("example", [1, 2])
         * }
         */
        @Pure
        fun abs() -> result: Cell<Number>

        /**
         * Round up to the nearest integer.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1.1, 2.9]);
         *     val result = column.transform((cell) -> cell.ceil());
         *     // Column("example", [2, 3])
         * }
         */
        @Pure
        fun ceil() -> result: Cell<Int>

        /**
         * Round down to the nearest integer.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1.1, 2.9]);
         *     val result = column.transform((cell) -> cell.floor());
         *     // Column("example", [1, 2])
         * }
         */
        @Pure
        fun floor() -> result: Cell<Int>

        /**
         * Negate the value. This is equivalent to the unary `-` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, -2]);
         *     val result = column.transform((cell) -> cell.neg());
         *     // Column("example", [-1, 2])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, -2]);
         *     val result = column.transform((cell) -> -cell);
         *     // Column("example", [-1, 2])
         * }
         */
        @Pure
        fun neg() -> result: Cell<Number>

        /**
         * Add a value. This is equivalent to the `+` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.add(3));
         *     // Column("example", [4, 5])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell + 3);
         *     // Column("example", [4, 5])
         * }
         */
        @Pure
        fun add(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Divide by a value. This is equivalent to the `/` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [6, 8]);
         *     val result = column.transform((cell) -> cell.div(2));
         *     // Column("example", [3, 4])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [6, 8]);
         *     val result = column.transform((cell) -> cell / 2);
         *     // Column("example", [3, 4])
         * }
         */
        @Pure
        fun div(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Perform a modulo operation.  This is equivalent to the `%` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [5, 6]);
         *     val result = column.transform((cell) -> cell.mod(3));
         *     // Column("example", [2, 0])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [5, 6]);
         *     val result = column.transform((cell) -> cell % 3);
         *     // Column("example", [2, 0])
         * }
         */
        @Pure
        fun mod(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Multiply by a value. This is equivalent to the `*` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [2, 3]);
         *     val result = column.transform((cell) -> cell.mul(4));
         *     // Column("example", [8, 12])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [2, 3]);
         *     val result = column.transform((cell) -> cell * 4);
         *     // Column("example", [8, 12])
         * }
         */
        @Pure
        fun mul(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Raise to a power.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [2, 3]);
         *     val result = column.transform((cell) -> cell.pow(3.0));
         *     // Column("example", [8, 27])
         * }
         */
        @Pure
        fun pow(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Subtract a value. This is equivalent to the binary `-` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [5, 6]);
         *     val result = column.transform((cell) -> cell.^sub(3));
         *     // Column("example", [2, 3])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [5, 6]);
         *     val result = column.transform((cell) -> cell - 3);
         *     // Column("example", [2, 3])
         * }
         */
        @Pure
        fun ^sub(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Number>

        /**
         * Check if equal to a value. This is equivalent to the `==` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.eq(2));
         *     // Column("example", [false, true])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell == 2);
         *     // Column("example", [false, true])
         * }
         */
        @Pure
        fun eq(
            other: Any?
        ) -> result: Cell<Boolean>

        /**
         * Check if not equal to a value. This is equivalent to the `!=` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.neq(2));
         *     // Column("example", [true, false])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell != 2);
         *     // Column("example", [true, false])
         * }
         */
        @Pure
        fun neq(
            other: Any?
        ) -> result: Cell<Boolean>

        /**
         * Check if greater than or equal to a value. This is equivalent to the `>=` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.ge(2));
         *     // Column("example", [false, true])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell >= 2);
         *     // Column("example", [false, true])
         * }
         */
        @Pure
        fun ge(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Boolean>

        /**
         * Check if greater than a value. This is equivalent to the `>` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.gt(2));
         *     // Column("example", [false, false])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell > 2);
         *     // Column("example", [false, false])
         * }
         */
        @Pure
        fun gt(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Boolean>

        /**
         * Check if less than or equal to a value. This is equivalent to the `<=` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.le(2));
         *     // Column("example", [true, true])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell <= 2);
         *     // Column("example", [true, true])
         * }
         */
        @Pure
        fun le(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Boolean>

        /**
         * Check if less than a value. This is equivalent to the `<` operator.
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell.lt(2));
         *     // Column("example", [true, false])
         * }
         *
         * @example
         * pipeline example {
         *     val column = Column("example", [1, 2]);
         *     val result = column.transform((cell) -> cell < 2);
         *     // Column("example", [true, false])
         * }
         */
        @Pure
        fun lt(
            other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
        ) -> result: Cell<Boolean>
    }
    ```
    { data-search-exclude }

## :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-attribute"></code> `dt` {#safeds.data.tabular.containers.Cell.dt data-toc-label='[attribute] dt'}

Namespace for operations on date time values.

**Type:** [`TemporalCell`][safeds.data.tabular.containers.TemporalCell]

## <code class="doc-symbol doc-symbol-attribute"></code> `str` {#safeds.data.tabular.containers.Cell.str data-toc-label='[attribute] str'}

Namespace for operations on strings.

**Type:** [`StringCell`][safeds.data.tabular.containers.StringCell]

## <code class="doc-symbol doc-symbol-function"></code> `abs` {#safeds.data.tabular.containers.Cell.abs data-toc-label='[function] abs'}

Get the absolute value.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, -2]);
    val result = column.transform((cell) -> cell.abs());
    // Column("example", [1, 2])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="125"
    @Pure
    fun abs() -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `add` {#safeds.data.tabular.containers.Cell.add data-toc-label='[function] add'}

Add a value. This is equivalent to the `+` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.add(3));
    // Column("example", [4, 5])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell + 3);
    // Column("example", [4, 5])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="191"
    @Pure
    fun add(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `and` {#safeds.data.tabular.containers.Cell.and data-toc-label='[function] and'}

Perform a boolean AND operation. This is equivalent to the `and` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Boolean, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell.^and(false));
    // Column("example", [false, false])
}
```
```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell and false);
    // Column("example", [false, false])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="71"
    @Pure
    @PythonName("and_")
    fun ^and(
        other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `ceil` {#safeds.data.tabular.containers.Cell.ceil data-toc-label='[function] ceil'}

Round up to the nearest integer.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1.1, 2.9]);
    val result = column.transform((cell) -> cell.ceil());
    // Column("example", [2, 3])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="138"
    @Pure
    fun ceil() -> result: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `div` {#safeds.data.tabular.containers.Cell.div data-toc-label='[function] div'}

Divide by a value. This is equivalent to the `/` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [6, 8]);
    val result = column.transform((cell) -> cell.div(2));
    // Column("example", [3, 4])
}
```
```sds
pipeline example {
    val column = Column("example", [6, 8]);
    val result = column.transform((cell) -> cell / 2);
    // Column("example", [3, 4])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="213"
    @Pure
    fun div(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `eq` {#safeds.data.tabular.containers.Cell.eq data-toc-label='[function] eq'}

Check if equal to a value. This is equivalent to the `==` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | [`Any?`][safeds.lang.Any] | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.eq(2));
    // Column("example", [false, true])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell == 2);
    // Column("example", [false, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="316"
    @Pure
    fun eq(
        other: Any?
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `floor` {#safeds.data.tabular.containers.Cell.floor data-toc-label='[function] floor'}

Round down to the nearest integer.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Int>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1.1, 2.9]);
    val result = column.transform((cell) -> cell.floor());
    // Column("example", [1, 2])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="151"
    @Pure
    fun floor() -> result: Cell<Int>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `ge` {#safeds.data.tabular.containers.Cell.ge data-toc-label='[function] ge'}

Check if greater than or equal to a value. This is equivalent to the `>=` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.ge(2));
    // Column("example", [false, true])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell >= 2);
    // Column("example", [false, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="360"
    @Pure
    fun ge(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `gt` {#safeds.data.tabular.containers.Cell.gt data-toc-label='[function] gt'}

Check if greater than a value. This is equivalent to the `>` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.gt(2));
    // Column("example", [false, false])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell > 2);
    // Column("example", [false, false])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="382"
    @Pure
    fun gt(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `le` {#safeds.data.tabular.containers.Cell.le data-toc-label='[function] le'}

Check if less than or equal to a value. This is equivalent to the `<=` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.le(2));
    // Column("example", [true, true])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell <= 2);
    // Column("example", [true, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="404"
    @Pure
    fun le(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `lt` {#safeds.data.tabular.containers.Cell.lt data-toc-label='[function] lt'}

Check if less than a value. This is equivalent to the `<` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.lt(2));
    // Column("example", [true, false])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell < 2);
    // Column("example", [true, false])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="426"
    @Pure
    fun lt(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `mod` {#safeds.data.tabular.containers.Cell.mod data-toc-label='[function] mod'}

Perform a modulo operation.  This is equivalent to the `%` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [5, 6]);
    val result = column.transform((cell) -> cell.mod(3));
    // Column("example", [2, 0])
}
```
```sds
pipeline example {
    val column = Column("example", [5, 6]);
    val result = column.transform((cell) -> cell % 3);
    // Column("example", [2, 0])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="235"
    @Pure
    fun mod(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `mul` {#safeds.data.tabular.containers.Cell.mul data-toc-label='[function] mul'}

Multiply by a value. This is equivalent to the `*` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [2, 3]);
    val result = column.transform((cell) -> cell.mul(4));
    // Column("example", [8, 12])
}
```
```sds
pipeline example {
    val column = Column("example", [2, 3]);
    val result = column.transform((cell) -> cell * 4);
    // Column("example", [8, 12])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="257"
    @Pure
    fun mul(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `neg` {#safeds.data.tabular.containers.Cell.neg data-toc-label='[function] neg'}

Negate the value. This is equivalent to the unary `-` operator.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, -2]);
    val result = column.transform((cell) -> cell.neg());
    // Column("example", [-1, 2])
}
```
```sds
pipeline example {
    val column = Column("example", [1, -2]);
    val result = column.transform((cell) -> -cell);
    // Column("example", [-1, 2])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="171"
    @Pure
    fun neg() -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `neq` {#safeds.data.tabular.containers.Cell.neq data-toc-label='[function] neq'}

Check if not equal to a value. This is equivalent to the `!=` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | [`Any?`][safeds.lang.Any] | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell.neq(2));
    // Column("example", [true, false])
}
```
```sds
pipeline example {
    val column = Column("example", [1, 2]);
    val result = column.transform((cell) -> cell != 2);
    // Column("example", [true, false])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="338"
    @Pure
    fun neq(
        other: Any?
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `not` {#safeds.data.tabular.containers.Cell.not data-toc-label='[function] not'}

Negate a boolean. This is equivalent to the `not` operator.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell.^not());
    // Column("example", [false, true])
}
```
```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> not cell);
    // Column("example", [false, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="50"
    @Pure
    @PythonName("not_")
    fun ^not() -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `or` {#safeds.data.tabular.containers.Cell.or data-toc-label='[function] or'}

Perform a boolean OR operation. This is equivalent to the `or` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Boolean, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell.^or(true));
    // Column("example", [true, true])
}
```
```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell or true);
    // Column("example", [true, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="94"
    @Pure
    @PythonName("or_")
    fun ^or(
        other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `pow` {#safeds.data.tabular.containers.Cell.pow data-toc-label='[function] pow'}

Raise to a power.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [2, 3]);
    val result = column.transform((cell) -> cell.pow(3.0));
    // Column("example", [8, 27])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="272"
    @Pure
    fun pow(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `sub` {#safeds.data.tabular.containers.Cell.sub data-toc-label='[function] sub'}

Subtract a value. This is equivalent to the binary `-` operator.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Number, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Number>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [5, 6]);
    val result = column.transform((cell) -> cell.^sub(3));
    // Column("example", [2, 3])
}
```
```sds
pipeline example {
    val column = Column("example", [5, 6]);
    val result = column.transform((cell) -> cell - 3);
    // Column("example", [2, 3])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="294"
    @Pure
    fun ^sub(
        other: union<Number, Cell> // TODO, once cell types can be inferred: union<Number, Cell<Number>>
    ) -> result: Cell<Number>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `xor` {#safeds.data.tabular.containers.Cell.xor data-toc-label='[function] xor'}

Perform a boolean XOR operation.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `other` | `#!sds union<Boolean, Cell<Any?>>` | - | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `result` | [`Cell<Boolean>`][safeds.data.tabular.containers.Cell] | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val column = Column("example", [true, false]);
    val result = column.transform((cell) -> cell.xor(true));
    // Column("example", [false, true])
}
```

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="110"
    @Pure
    fun xor(
        other: union<Boolean, Cell> // TODO, once cell types can be inferred: union<Boolean, Cell<Boolean>>
    ) -> result: Cell<Boolean>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-static-function"></code> `firstNotNone` {#safeds.data.tabular.containers.Cell.firstNotNone data-toc-label='[static-function] firstNotNone'}

Return the first cell from the given list that is not None.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `cells` | [`List<Cell<T>>`][safeds.lang.List] | The list of cells to be searched. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `cell` | [`Cell<T?>`][safeds.data.tabular.containers.Cell] | Returns the contents of the first cell that is not None. If all cells in the list are None or the list is empty returns None. |

**Type parameters:**

| Name | Upper Bound | Description | Default |
|------|-------------|-------------|---------|
| `T` | [`Any?`][safeds.lang.Any] | - | - |

??? quote "Stub code in `Cell.sdsstub`"

    ```sds linenums="27"
    @Pure
    @PythonName("first_not_none")
    static fun firstNotNone<T>(
        cells: List<Cell<T>>
    ) -> cell: Cell<T?>
    ```
    { data-search-exclude }
