[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-class"></code> `ImageDataset` {#safeds.data.labeled.containers.ImageDataset data-toc-label='[class] ImageDataset'}

A Dataset for ImageLists as input and ImageLists, Tables or Columns as output.

**Parent type:** [`Dataset<ImageList, O>`][safeds.data.labeled.containers.Dataset]

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `inputData` | [`ImageList`][safeds.data.image.containers.ImageList] | The input ImageList | - |
| `outputData` | `#!sds O` | The output data | - |
| `batchSize` | [`Int`][safeds.lang.Int] | The batch size used for training | `#!sds 1` |
| `shuffle` | [`Boolean`][safeds.lang.Boolean] | Whether the data should be shuffled after each epoch of training | `#!sds false` |

**Type parameters:**

| Name | Upper Bound | Description | Default |
|------|-------------|-------------|---------|
| `O` | [`Any?`][safeds.lang.Any] | - | - |

**Examples:**

```sds hl_lines="5"
pipeline example {
    val image = Image.fromFile("example.png");
    val imageList = ImageList.fromImages([image]);
    val labels = Column("label", ["example"]);
    val dataset = ImageDataset(imageList, labels);
}
```

??? quote "Stub code in `ImageDataset.sdsstub`"

    ```sds linenums="25"
    class ImageDataset<out O>(
        @PythonName("input_data") inputData: ImageList,
        @PythonName("output_data") outputData: O,
        @PythonName("batch_size") batchSize: Int = 1,
        shuffle: Boolean = false
    ) sub Dataset<ImageList, O> {
        /**
         * Get the input `ImageSize` of this dataset.
         */
        @PythonName("input_size") attr inputSize: ImageSize
        /**
         * Get the output size of this dataset.
         */
        @PythonName("output_size") attr outputSize: ImageSize

        /**
         * Get the input data of this dataset.
         *
         * @result input the input data of this dataset
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val imageList = ImageList.fromImages([image]);
         *     val labels = Column("label", ["example"]);
         *     val dataset = ImageDataset(imageList, labels);
         *     val input = dataset.getInput();
         * }
         */
        @Pure
        @PythonName("get_input")
        fun getInput() -> input: ImageList

        /**
         * Get the output data of this dataset.
         *
         * @result output the output data of this dataset
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val imageList = ImageList.fromImages([image]);
         *     val labels = Column("label", ["example"]);
         *     val dataset = ImageDataset(imageList, labels);
         *     val output = dataset.getOutput();
         * }
         */
        @Pure
        @PythonName("get_output")
        fun getOutput() -> output: O

        /**
         * Return a new `ImageDataset` with shuffled data.
         *
         * The original dataset is not modified.
         *
         * @result imageDataset the shuffled `ImageDataset`
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val imageList = ImageList.fromImages([image]);
         *     val labels = Column("label", ["example"]);
         *     val dataset = ImageDataset(imageList, labels);
         *     val shuffledDataset = dataset.shuffle();
         * }
         */
        @Pure
        fun shuffle() -> imageDataset: ImageDataset<O>

        /**
         * Create two image datasets by splitting the data of the current dataset.
         *
         * The first dataset contains a percentage of the data specified by `percentage_in_first`, and the second dataset
         * contains the remaining data. By default, the data is shuffled before splitting. You can disable this by setting
         * `shuffle` to False.
         *
         * The original dataset is not modified.
         *
         * @param percentageInFirst The percentage of data to include in the first dataset. Must be between 0 and 1.
         * @param shuffle Whether to shuffle the data before splitting.
         *
         * @result firstDataset The first dataset.
         * @result secondDataset The second dataset.
         */
        @Pure
        fun split(
            @PythonName("percentage_in_first") percentageInFirst: Float,
            shuffle: Boolean = true
        ) -> (firstDataset: ImageDataset<O>, secondDataset: ImageDataset<O>)
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `inputSize` {#safeds.data.labeled.containers.ImageDataset.inputSize data-toc-label='[attribute] inputSize'}

Get the input `ImageSize` of this dataset.

**Type:** [`ImageSize`][safeds.data.image.typing.ImageSize]

## <code class="doc-symbol doc-symbol-attribute"></code> `outputSize` {#safeds.data.labeled.containers.ImageDataset.outputSize data-toc-label='[attribute] outputSize'}

Get the output size of this dataset.

**Type:** [`ImageSize`][safeds.data.image.typing.ImageSize]

## <code class="doc-symbol doc-symbol-function"></code> `getInput` {#safeds.data.labeled.containers.ImageDataset.getInput data-toc-label='[function] getInput'}

Get the input data of this dataset.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `input` | [`ImageList`][safeds.data.image.containers.ImageList] | the input data of this dataset |

**Examples:**

```sds hl_lines="6"
pipeline example {
    val image = Image.fromFile("example.png");
    val imageList = ImageList.fromImages([image]);
    val labels = Column("label", ["example"]);
    val dataset = ImageDataset(imageList, labels);
    val input = dataset.getInput();
}
```

??? quote "Stub code in `ImageDataset.sdsstub`"

    ```sds linenums="54"
    @Pure
    @PythonName("get_input")
    fun getInput() -> input: ImageList
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `getOutput` {#safeds.data.labeled.containers.ImageDataset.getOutput data-toc-label='[function] getOutput'}

Get the output data of this dataset.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `output` | `#!sds O` | the output data of this dataset |

**Examples:**

```sds hl_lines="6"
pipeline example {
    val image = Image.fromFile("example.png");
    val imageList = ImageList.fromImages([image]);
    val labels = Column("label", ["example"]);
    val dataset = ImageDataset(imageList, labels);
    val output = dataset.getOutput();
}
```

??? quote "Stub code in `ImageDataset.sdsstub`"

    ```sds linenums="72"
    @Pure
    @PythonName("get_output")
    fun getOutput() -> output: O
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `shuffle` {#safeds.data.labeled.containers.ImageDataset.shuffle data-toc-label='[function] shuffle'}

Return a new `ImageDataset` with shuffled data.

The original dataset is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `imageDataset` | [`ImageDataset<O>`][safeds.data.labeled.containers.ImageDataset] | the shuffled `ImageDataset` |

**Examples:**

```sds hl_lines="6"
pipeline example {
    val image = Image.fromFile("example.png");
    val imageList = ImageList.fromImages([image]);
    val labels = Column("label", ["example"]);
    val dataset = ImageDataset(imageList, labels);
    val shuffledDataset = dataset.shuffle();
}
```

??? quote "Stub code in `ImageDataset.sdsstub`"

    ```sds linenums="92"
    @Pure
    fun shuffle() -> imageDataset: ImageDataset<O>
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `split` {#safeds.data.labeled.containers.ImageDataset.split data-toc-label='[function] split'}

Create two image datasets by splitting the data of the current dataset.

The first dataset contains a percentage of the data specified by `percentage_in_first`, and the second dataset
contains the remaining data. By default, the data is shuffled before splitting. You can disable this by setting
`shuffle` to False.

The original dataset is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `percentageInFirst` | [`Float`][safeds.lang.Float] | The percentage of data to include in the first dataset. Must be between 0 and 1. | - |
| `shuffle` | [`Boolean`][safeds.lang.Boolean] | Whether to shuffle the data before splitting. | `#!sds true` |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `firstDataset` | [`ImageDataset<O>`][safeds.data.labeled.containers.ImageDataset] | The first dataset. |
| `secondDataset` | [`ImageDataset<O>`][safeds.data.labeled.containers.ImageDataset] | The second dataset. |

??? quote "Stub code in `ImageDataset.sdsstub`"

    ```sds linenums="110"
    @Pure
    fun split(
        @PythonName("percentage_in_first") percentageInFirst: Float,
        shuffle: Boolean = true
    ) -> (firstDataset: ImageDataset<O>, secondDataset: ImageDataset<O>)
    ```
    { data-search-exclude }
