[//]: # (DO NOT EDIT THIS FILE DIRECTLY. Instead, edit the corresponding stub file and execute `npm run docs:api`.)

# :test_tube:{ title="Experimental" } <code class="doc-symbol doc-symbol-class"></code> `Image` {#safeds.data.image.containers.Image data-toc-label='[class] Image'}

A container for image data.

**Examples:**

```sds hl_lines="2"
pipeline example {
    val image = Image.fromFile("example.png");
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="14"
    class Image {
        /**
         * Get the width of the image in pixels.
         */
        attr width: Int
        /**
         * Get the height of the image in pixels.
         */
        attr height: Int
        /**
         * Get the number of channels of the image.
         */
        attr channel: Int
        /**
         * Get the `ImageSize` of the image.
         */
        attr size: ImageSize

        /**
         * Create an image from a file.
         *
         * @param path The path to the image file.
         *
         * @result image The image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         * }
         */
        @Impure([ImpurityReason.FileReadFromParameterizedPath("path")])
        @PythonName("from_file")
        @Category(DataScienceCategory.DataImport)
        static fun fromFile(
            path: String
        ) -> image: Image

        /**
         * Save the image as a JPEG file.
         *
         * @param path The path to the JPEG file.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     image.toJpegFile("output.jpeg");
         * }
         */
        @Impure([ImpurityReason.FileWriteToParameterizedPath("path")])
        @PythonName("to_jpeg_file")
        @Category(DataScienceCategory.DataExport)
        fun toJpegFile(
            path: String
        )

        /**
         * Save the image as a PNG file.
         *
         * @param path The path to the PNG file.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     image.toPngFile("output.png");
         * }
         */
        @Impure([ImpurityReason.FileWriteToParameterizedPath("path")])
        @PythonName("to_png_file")
        @Category(DataScienceCategory.DataExport)
        fun toPngFile(
            path: String
        )

        /**
         * Return a new `Image` that has the given number of channels.
         *
         * The original image is not modified.
         *
         * @param channel The new number of channels. 1 will result in a grayscale image.
         *
         * @result newImage The image with the given number of channels.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.changeChannel(channel = 1);
         * }
         */
        @Pure
        @PythonName("change_channel")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun changeChannel(
            channel: Int
        ) -> newImage: Image

        /**
         * Return a new `Image` that has been resized to a given size.
         *
         * The original image is not modified.
         *
         * @param newWidth The new width of the image.
         * @param newHeight The new height of the image.
         *
         * @result newImage The image with the given width and height.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.resize(newWidth = 100, newHeight = 50);
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQImage)
        fun resize(
            @PythonName("new_width") const newWidth: Int,
            @PythonName("new_height") const newHeight: Int
        ) -> newImage: Image where {
            newWidth >= 0,
            newHeight >= 0
        }

        /**
         * Return a new `Image` that is converted to grayscale.
         *
         * The new image will have the same amount of channels as the original image. If you want to change the amount of
         * channels used, please use the method {@link Image.changeChannel}.
         *
         * The original image is not modified.
         *
         * @result newImage The grayscale image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.convertToGrayscale();
         * }
         */
        @Pure
        @PythonName("convert_to_grayscale")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun convertToGrayscale() -> newImage: Image

        /**
         * Return a new `Image` that has been cropped to a given bounding rectangle.
         *
         * The original image is not modified.
         *
         * @param x The x coordinate of the top-left corner of the bounding rectangle.
         * @param y The y coordinate of the top-left corner of the bounding rectangle.
         * @param width The width of the bounding rectangle.
         * @param height The height of the bounding rectangle.
         *
         * @result newImage The cropped image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.crop(20, 20, 80, 40);
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQImage)
        fun crop(
            const x: Int,
            const y: Int,
            const width: Int,
            const height: Int
        ) -> newImage: Image where {
            x >= 0,
            y >= 0,
            width >= 0,
            height >= 0
        }

        /**
         * Return a new `Image` that is flipped vertically (horizontal axis, flips up-down and vice versa).
         *
         * The original image is not modified.
         *
         * @result newImage The flipped image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.flipVertically();
         * }
         */
        @Pure
        @PythonName("flip_vertically")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun flipVertically() -> newImage: Image

        /**
         * Return a new `Image` that is flipped horizontally (vertical axis, flips left-right and vice versa).
         *
         * The original image is not modified.
         *
         * @result newImage The flipped image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.flipHorizontally();
         * }
         */
        @Pure
        @PythonName("flip_horizontally")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun flipHorizontally() -> newImage: Image

        /**
         * Return a new `Image` with an adjusted brightness.
         *
         * The original image is not modified.
         *
         * @param factor The brightness factor.
         * 1.0 will not change the brightness.
         * Below 1.0 will result in a darker image.
         * Above 1.0 will resolut in a brighter image.
         * Has to be bigger than or equal to 0 (black).
         *
         * @result newImage The Image with adjusted brightness.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.adjustBrightness(factor = 2.0);
         * }
         */
        @Pure
        @PythonName("adjust_brightness")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun adjustBrightness(
            const factor: Float
        ) -> newImage: Image where {
            factor >= 0.0
        }

        /**
         * Return a new `Image` with noise added to the image.
         *
         * The original image is not modified.
         *
         * @param standardDeviation The standard deviation of the normal distribution. Has to be bigger than or equal to 0.
         *
         * @result newImage The image with added noise.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.addNoise(standardDeviation = 1.0);
         * }
         */
        @Pure
        @PythonName("add_noise")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun addNoise(
            @PythonName("standard_deviation") const standardDeviation: Float
        ) -> newImage: Image where {
            standardDeviation >= 0.0
        }

        /**
         * Return a new `Image` with adjusted contrast.
         *
         * The original image is not modified.
         *
         * @param factor If factor > 1, increase contrast of image.
         * If factor = 1, no changes will be made.
         * If factor < 1, make image greyer.
         * Has to be bigger than or equal to 0 (gray).
         *
         * @result newImage New image with adjusted contrast.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.adjustContrast(factor = 2.0);
         * }
         */
        @Pure
        @PythonName("adjust_contrast")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun adjustContrast(
            const factor: Float
        ) -> newImage: Image where {
            factor >= 0.0
        }

        /**
         * Return a new `Image` with adjusted color balance.
         *
         * The original image is not modified.
         *
         * @param factor Has to be bigger than or equal to 0.
         * If 0 <= factor < 1, make image greyer.
         * If factor = 1, no changes will be made.
         * If factor > 1, increase color balance of image.
         *
         * @result newImage The new, adjusted image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.adjustColorBalance(factor = 2.0);
         * }
         */
        @Pure
        @PythonName("adjust_color_balance")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun adjustColorBalance(
            const factor: Float
        ) -> newImage: Image where {
            factor >= 0.0
        }

        /**
         * Return a blurred version of the image.
         *
         * The original image is not modified.
         *
         * @param radius Radius is directly proportional to the blur value. The radius is equal to the amount of pixels united in
         * each direction. A radius of 1 will result in a united box of 9 pixels.
         *
         * @result newImage The blurred image.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.blur(radius = 50);
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQImage)
        fun blur(
            const radius: Int
        ) -> newImage: Image where {
            radius >= 0
        }

        /**
         * Return a sharpened version of the image.
         *
         * The original image is not modified.
         *
         * @param factor If factor > 1, increase the sharpness of the image.
         * If factor = 1, no changes will be made.
         * If factor < 1, blur the image.
         * Has to be bigger than or equal to 0 (blurred).
         *
         * @result newImage The image sharpened by the given factor.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.sharpen(factor = 5.0);
         * }
         */
        @Pure
        @Category(DataScienceCategory.DataProcessingQImage)
        fun sharpen(
            const factor: Float
        ) -> newImage: Image where {
            factor >= 0.0
        }

        /**
         * Return a new `Image` with colors inverted.
         *
         * The original image is not modified.
         *
         * @result newImage The image with inverted colors.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.invertColors();
         * }
         */
        @Pure
        @PythonName("invert_colors")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun invertColors() -> newImage: Image

        /**
         * Return a new `Image` that is rotated 90 degrees clockwise.
         *
         * The original image is not modified.
         *
         * @result newImage The image rotated 90 degrees clockwise.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.rotateRight();
         * }
         */
        @Pure
        @PythonName("rotate_right")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun rotateRight() -> newImage: Image

        /**
         * Return a new `Image` that is rotated 90 degrees counter-clockwise.
         *
         * The original image is not modified.
         *
         * @result newImage The image rotated 90 degrees counter-clockwise.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.rotateLeft();
         * }
         */
        @Pure
        @PythonName("rotate_left")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun rotateLeft() -> newImage: Image

        /**
         * Return a grayscale version of the image with the edges highlighted.
         *
         * The original image is not modified.
         *
         * @result newImage The image with edges found.
         *
         * @example
         * pipeline example {
         *     val image = Image.fromFile("example.png");
         *     val newImage = image.findEdges();
         * }
         */
        @Pure
        @PythonName("find_edges")
        @Category(DataScienceCategory.DataProcessingQImage)
        fun findEdges() -> newImage: Image
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-attribute"></code> `channel` {#safeds.data.image.containers.Image.channel data-toc-label='[attribute] channel'}

Get the number of channels of the image.

**Type:** [`Int`][safeds.lang.Int]

## <code class="doc-symbol doc-symbol-attribute"></code> `height` {#safeds.data.image.containers.Image.height data-toc-label='[attribute] height'}

Get the height of the image in pixels.

**Type:** [`Int`][safeds.lang.Int]

## <code class="doc-symbol doc-symbol-attribute"></code> `size` {#safeds.data.image.containers.Image.size data-toc-label='[attribute] size'}

Get the `ImageSize` of the image.

**Type:** [`ImageSize`][safeds.data.image.typing.ImageSize]

## <code class="doc-symbol doc-symbol-attribute"></code> `width` {#safeds.data.image.containers.Image.width data-toc-label='[attribute] width'}

Get the width of the image in pixels.

**Type:** [`Int`][safeds.lang.Int]

## <code class="doc-symbol doc-symbol-function"></code> `addNoise` {#safeds.data.image.containers.Image.addNoise data-toc-label='[function] addNoise'}

Return a new `Image` with noise added to the image.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `standardDeviation` | [`Float`][safeds.lang.Float] | The standard deviation of the normal distribution. Has to be bigger than or equal to 0. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image with added noise. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.addNoise(standardDeviation = 1.0);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="267"
    @Pure
    @PythonName("add_noise")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun addNoise(
        @PythonName("standard_deviation") const standardDeviation: Float
    ) -> newImage: Image where {
        standardDeviation >= 0.0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `adjustBrightness` {#safeds.data.image.containers.Image.adjustBrightness data-toc-label='[function] adjustBrightness'}

Return a new `Image` with an adjusted brightness.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `factor` | [`Float`][safeds.lang.Float] | The brightness factor. 1.0 will not change the brightness. Below 1.0 will result in a darker image. Above 1.0 will resolut in a brighter image. Has to be bigger than or equal to 0 (black). | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The Image with adjusted brightness. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.adjustBrightness(factor = 2.0);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="243"
    @Pure
    @PythonName("adjust_brightness")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun adjustBrightness(
        const factor: Float
    ) -> newImage: Image where {
        factor >= 0.0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `adjustColorBalance` {#safeds.data.image.containers.Image.adjustColorBalance data-toc-label='[function] adjustColorBalance'}

Return a new `Image` with adjusted color balance.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `factor` | [`Float`][safeds.lang.Float] | Has to be bigger than or equal to 0. If 0 <= factor < 1, make image greyer. If factor = 1, no changes will be made. If factor > 1, increase color balance of image. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The new, adjusted image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.adjustColorBalance(factor = 2.0);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="321"
    @Pure
    @PythonName("adjust_color_balance")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun adjustColorBalance(
        const factor: Float
    ) -> newImage: Image where {
        factor >= 0.0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `adjustContrast` {#safeds.data.image.containers.Image.adjustContrast data-toc-label='[function] adjustContrast'}

Return a new `Image` with adjusted contrast.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `factor` | [`Float`][safeds.lang.Float] | If factor > 1, increase contrast of image. If factor = 1, no changes will be made. If factor < 1, make image greyer. Has to be bigger than or equal to 0 (gray). | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | New image with adjusted contrast. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.adjustContrast(factor = 2.0);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="294"
    @Pure
    @PythonName("adjust_contrast")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun adjustContrast(
        const factor: Float
    ) -> newImage: Image where {
        factor >= 0.0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `blur` {#safeds.data.image.containers.Image.blur data-toc-label='[function] blur'}

Return a blurred version of the image.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `radius` | [`Int`][safeds.lang.Int] | Radius is directly proportional to the blur value. The radius is equal to the amount of pixels united in each direction. A radius of 1 will result in a united box of 9 pixels. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The blurred image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.blur(radius = 50);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="346"
    @Pure
    @Category(DataScienceCategory.DataProcessingQImage)
    fun blur(
        const radius: Int
    ) -> newImage: Image where {
        radius >= 0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `changeChannel` {#safeds.data.image.containers.Image.changeChannel data-toc-label='[function] changeChannel'}

Return a new `Image` that has the given number of channels.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `channel` | [`Int`][safeds.lang.Int] | The new number of channels. 1 will result in a grayscale image. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image with the given number of channels. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.changeChannel(channel = 1);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="102"
    @Pure
    @PythonName("change_channel")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun changeChannel(
        channel: Int
    ) -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `convertToGrayscale` {#safeds.data.image.containers.Image.convertToGrayscale data-toc-label='[function] convertToGrayscale'}

Return a new `Image` that is converted to grayscale.

The new image will have the same amount of channels as the original image. If you want to change the amount of
channels used, please use the method [Image.changeChannel][safeds.data.image.containers.Image.changeChannel].

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The grayscale image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.convertToGrayscale();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="151"
    @Pure
    @PythonName("convert_to_grayscale")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun convertToGrayscale() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `crop` {#safeds.data.image.containers.Image.crop data-toc-label='[function] crop'}

Return a new `Image` that has been cropped to a given bounding rectangle.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `x` | [`Int`][safeds.lang.Int] | The x coordinate of the top-left corner of the bounding rectangle. | - |
| `y` | [`Int`][safeds.lang.Int] | The y coordinate of the top-left corner of the bounding rectangle. | - |
| `width` | [`Int`][safeds.lang.Int] | The width of the bounding rectangle. | - |
| `height` | [`Int`][safeds.lang.Int] | The height of the bounding rectangle. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The cropped image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.crop(20, 20, 80, 40);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="174"
    @Pure
    @Category(DataScienceCategory.DataProcessingQImage)
    fun crop(
        const x: Int,
        const y: Int,
        const width: Int,
        const height: Int
    ) -> newImage: Image where {
        x >= 0,
        y >= 0,
        width >= 0,
        height >= 0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `findEdges` {#safeds.data.image.containers.Image.findEdges data-toc-label='[function] findEdges'}

Return a grayscale version of the image with the edges highlighted.

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image with edges found. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.findEdges();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="447"
    @Pure
    @PythonName("find_edges")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun findEdges() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `flipHorizontally` {#safeds.data.image.containers.Image.flipHorizontally data-toc-label='[function] flipHorizontally'}

Return a new `Image` that is flipped horizontally (vertical axis, flips left-right and vice versa).

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The flipped image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.flipHorizontally();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="219"
    @Pure
    @PythonName("flip_horizontally")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun flipHorizontally() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `flipVertically` {#safeds.data.image.containers.Image.flipVertically data-toc-label='[function] flipVertically'}

Return a new `Image` that is flipped vertically (horizontal axis, flips up-down and vice versa).

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The flipped image. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.flipVertically();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="201"
    @Pure
    @PythonName("flip_vertically")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun flipVertically() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `invertColors` {#safeds.data.image.containers.Image.invertColors data-toc-label='[function] invertColors'}

Return a new `Image` with colors inverted.

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image with inverted colors. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.invertColors();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="393"
    @Pure
    @PythonName("invert_colors")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun invertColors() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `resize` {#safeds.data.image.containers.Image.resize data-toc-label='[function] resize'}

Return a new `Image` that has been resized to a given size.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `newWidth` | [`Int`][safeds.lang.Int] | The new width of the image. | - |
| `newHeight` | [`Int`][safeds.lang.Int] | The new height of the image. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image with the given width and height. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.resize(newWidth = 100, newHeight = 50);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="125"
    @Pure
    @Category(DataScienceCategory.DataProcessingQImage)
    fun resize(
        @PythonName("new_width") const newWidth: Int,
        @PythonName("new_height") const newHeight: Int
    ) -> newImage: Image where {
        newWidth >= 0,
        newHeight >= 0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `rotateLeft` {#safeds.data.image.containers.Image.rotateLeft data-toc-label='[function] rotateLeft'}

Return a new `Image` that is rotated 90 degrees counter-clockwise.

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image rotated 90 degrees counter-clockwise. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.rotateLeft();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="429"
    @Pure
    @PythonName("rotate_left")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun rotateLeft() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `rotateRight` {#safeds.data.image.containers.Image.rotateRight data-toc-label='[function] rotateRight'}

Return a new `Image` that is rotated 90 degrees clockwise.

The original image is not modified.

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image rotated 90 degrees clockwise. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.rotateRight();
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="411"
    @Pure
    @PythonName("rotate_right")
    @Category(DataScienceCategory.DataProcessingQImage)
    fun rotateRight() -> newImage: Image
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `sharpen` {#safeds.data.image.containers.Image.sharpen data-toc-label='[function] sharpen'}

Return a sharpened version of the image.

The original image is not modified.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `factor` | [`Float`][safeds.lang.Float] | If factor > 1, increase the sharpness of the image. If factor = 1, no changes will be made. If factor < 1, blur the image. Has to be bigger than or equal to 0 (blurred). | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `newImage` | [`Image`][safeds.data.image.containers.Image] | The image sharpened by the given factor. |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    val newImage = image.sharpen(factor = 5.0);
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="372"
    @Pure
    @Category(DataScienceCategory.DataProcessingQImage)
    fun sharpen(
        const factor: Float
    ) -> newImage: Image where {
        factor >= 0.0
    }
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toJpegFile` {#safeds.data.image.containers.Image.toJpegFile data-toc-label='[function] toJpegFile'}

Save the image as a JPEG file.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `path` | [`String`][safeds.lang.String] | The path to the JPEG file. | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    image.toJpegFile("output.jpeg");
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="62"
    @Impure([ImpurityReason.FileWriteToParameterizedPath("path")])
    @PythonName("to_jpeg_file")
    @Category(DataScienceCategory.DataExport)
    fun toJpegFile(
        path: String
    )
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-function"></code> `toPngFile` {#safeds.data.image.containers.Image.toPngFile data-toc-label='[function] toPngFile'}

Save the image as a PNG file.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `path` | [`String`][safeds.lang.String] | The path to the PNG file. | - |

**Examples:**

```sds hl_lines="3"
pipeline example {
    val image = Image.fromFile("example.png");
    image.toPngFile("output.png");
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="80"
    @Impure([ImpurityReason.FileWriteToParameterizedPath("path")])
    @PythonName("to_png_file")
    @Category(DataScienceCategory.DataExport)
    fun toPngFile(
        path: String
    )
    ```
    { data-search-exclude }

## <code class="doc-symbol doc-symbol-static-function"></code> `fromFile` {#safeds.data.image.containers.Image.fromFile data-toc-label='[static-function] fromFile'}

Create an image from a file.

**Parameters:**

| Name | Type | Description | Default |
|------|------|-------------|---------|
| `path` | [`String`][safeds.lang.String] | The path to the image file. | - |

**Results:**

| Name | Type | Description |
|------|------|-------------|
| `image` | [`Image`][safeds.data.image.containers.Image] | The image. |

**Examples:**

```sds hl_lines="2"
pipeline example {
    val image = Image.fromFile("example.png");
}
```

??? quote "Stub code in `Image.sdsstub`"

    ```sds linenums="44"
    @Impure([ImpurityReason.FileReadFromParameterizedPath("path")])
    @PythonName("from_file")
    @Category(DataScienceCategory.DataImport)
    static fun fromFile(
        path: String
    ) -> image: Image
    ```
    { data-search-exclude }
