# How to Contribute

First of all, thank you for taking the time to contribute to Sabaki!

## Reporting Bugs

- Before submitting bug reports, please check the
  [issues](https://github.com/SabakiHQ/Sabaki/issues) for already existing
  reports. You might not need to create one.
- Use a clear and descriptive title.
- Please include as many details as possible in your issue, especially the
  version of Sabaki you're using and the name and version of the OS you're
  using.
- It's also helpful to provide specific steps to reproduce the problem.

## Code Contribution

- Before you begin, make sure there's an issue for your task and that you've let
  us known that you'd like to take it on.
- You can look at
  [the documentation](https://github.com/SabakiHQ/Sabaki/tree/master/docs) to
  get an overview how Sabaki's code is structured.
- Run prettier to make sure your code adheres to the coding style standards. You
  can use the command `npm run format` to format all the files.
- Avoid platform-dependent code.
- Create mocha tests if possible and applicable.
- Document new code in the documentation if applicable.
- Note the issue number in your pull request.

## Translation

If you speak multiple languages, you can help us translate Sabaki. Head over to
[Sabaki I18n](https://github.com/SabakiHQ/sabaki-i18n) for progress and
instructions.

## Donate

You can also support this project by [donating](https://paypal.me/yishn/5).
