## Contributing

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it is:

 - Reporting a bug
 - Discussing the current state of the code
 - Submitting a fix
 - Proposing new features
 - Becoming a maintainer

When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

### General rules

 -  Commits must be atomic. Each commit must commit one and only one thing. It has to be a single complete unit of work.
 -  Commit messages must be meaningful, clear and concise. Stress on your grammar.
 - Commits should do exactly what their message says. If a commit affects quite a few files, and does a few related things, mention them in the commit description.
 -  IDE configuration files,temp files and cached data are not meant to be a part of the repository and they should remain so.
 -  Variable names like `a` or `x` are unacceptable, use variable names that describes its purpose.
 -  Format the code correctly before sending a pull request. 
 -	If you've added code that should be tested, add tests.
 - If you have a question, think you've discovered an issue, would like to propose a new feature, etc., then find/file an issue **BEFORE** starting work to fix/implement it.

 ### Filing a new Issue
 - Before filing a new issue, search existing open and closed issues first. It is  likely someone else has found the problem you're seeing, and someone may be working on or have already contributed a fix!
 - Don't know whether you're reporting an issue or requesting a feature? File an issue.
 - Have a question that you don't see answered in docs, videos, etc.? File an issue.
 - Want to know if we're planning on building a particular feature? File an issue.
 - Got a great idea for a new feature? File an issue.
 - Found an existing issue that describes yours? Great - upvote and add additional commentary / info / repro-steps / etc.
 
 ### Formatting guidelines
 
 - For Class, method declarations and anything else, have braces starting in the next line. 
 - One space between operators and operands is a must.
 - Use tabs for intendation.
 - Make sure a line doesn't exceed 80 characters. 

### Pull Request Process

 -  Check if there's already a pull request assigned to someone that solves a similar problem to yours.
 - Ensure that the pull request is being sent from a hotfix/feature branch and not from `master`.
 - Check the issue page if the feature you are trying to add/bug you are trying to fix is already in the list. If it does, mention the issue number in parentheses with the pull request.
 - Provide a clear, concise description of why this pull request is necessary and what value it adds. Make sure that your pull request doesn't contain any more or less than what the pull request description says.
 - One pull request should do only one thing. No more, no less. If you want to implement two new features, open two pull requests.
 
### Any contributions you make will be under the MIT Software License

In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project. Feel free to contact the maintainers if that's a concern.