import {
  AlarmClock,
  AlertTriangle,
  ArrowDown,
  ArrowUp,
  BadgeCheck,
  BadgePlus,
  BarChart3,
  Boxes,
  CalendarDays,
  Check,
  ChevronDown,
  ChevronLeft,
  ChevronRight,
  ChevronUp,
  ChevronsLeft,
  ChevronsRight,
  ChevronsUpDown,
  Circle,
  Cog,
  Copy,
  CreditCard,
  Crop,
  DollarSign,
  Download,
  Edit,
  Eye,
  EyeOff,
  FileTerminal,
  Filter,
  Footprints,
  GalleryVerticalEnd,
  Gem,
  HardHat,
  Heart,
  Image,
  LayoutDashboard,
  ListOrderedIcon,
  Loader2,
  LocateIcon,
  LockIcon,
  LogOut,
  Mailbox,
  Menu,
  MessageSquare,
  Minus,
  Moon,
  MoreHorizontal,
  MoreVertical,
  Package,
  PackageSearch,
  Pencil,
  PencilRuler,
  PercentIcon,
  Phone,
  Plus,
  PlusCircle,
  RefreshCw,
  Search,
  Send,
  Settings,
  ShieldQuestion,
  Shirt,
  ShoppingBag,
  ShoppingCart,
  Sliders,
  SlidersHorizontal,
  Star,
  Store,
  SunMedium,
  Tag,
  Trash,
  Twitter,
  UploadCloud,
  User,
  Volume2,
  VolumeX,
  Wallet,
  X,
  type LucideIcon,
  type LucideProps,
} from "lucide-react";

export type Icon = LucideIcon | any;

export const Icons = {
  sun: SunMedium,
  moon: Moon,
  star: Star,
  twitter: Twitter,
  close: X,
  spinner: Loader2,
  chevronLeft: ChevronLeft,
  chevronRight: ChevronRight,
  chevronsLeft: ChevronsLeft,
  chevronsRight: ChevronsRight,
  chevronUp: ChevronUp,
  chevronDown: ChevronDown,
  chevronUpDown: ChevronsUpDown,
  arrowUp: ArrowUp,
  order: ListOrderedIcon,
  lock: LockIcon,
  success: BadgeCheck,
  arrowDown: ArrowDown,
  menu: Menu,
  attribute: Cog,
  tag: Tag,
  verticalThreeDots: MoreVertical,
  horizontalThreeDots: MoreHorizontal,
  verticalSliders: Sliders,
  horizontalSliders: SlidersHorizontal,
  circle: Circle,
  check: Check,
  plus: BadgePlus,
  gem: Gem,
  review: Mailbox,
  phone: Phone,
  percent: PercentIcon,
  add: Plus,
  addCircle: PlusCircle,
  remove: Minus,
  eyeOff: EyeOff,
  view: Eye,
  hide: EyeOff,
  question: ShieldQuestion,
  products: PackageSearch,
  trash: Trash,
  arrowPrev: ChevronLeft,
  arrowNext: ChevronRight,
  edit: Edit,
  dashboard: LayoutDashboard,
  slidersHorizontal: SlidersHorizontal,
  moreHorizontal: MoreHorizontal,
  crop: Crop,
  address: LocateIcon,
  message: MessageSquare,
  reset: RefreshCw,
  send: Send,
  copy: Copy,
  downlaod: Download,
  warning: AlertTriangle,
  search: Search,
  filter: Filter,
  alarm: AlarmClock,
  pencil: Pencil,
  calendar: CalendarDays,
  user: User,
  card: CreditCard,
  wishlist: Heart,
  terminal: FileTerminal,
  settings: Settings,
  logout: LogOut,
  group: Boxes,
  volumne: Volume2,
  volumneMute: VolumeX,
  billing: CreditCard,
  wallet: Wallet,
  storehouse: Store,
  category: GalleryVerticalEnd,
  author: PencilRuler,
  dollarSign: DollarSign,
  cart: ShoppingCart,
  product: Package,
  store: ShoppingBag,
  chart: BarChart3,
  upload: UploadCloud,
  placeholder: Image,
  clothing: Shirt,
  shoes: Footprints,
  accessories: HardHat,
  nextjs: (props: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" {...props}>
      <path
        fill="currentColor"
        d="M11.572 0c-.176 0-.31.001-.358.007a19.76 19.76 0 0 1-.364.033C7.443.346 4.25 2.185 2.228 5.012a11.875 11.875 0 0 0-2.119 5.243c-.096.659-.108.854-.108 1.747s.012 1.089.108 1.748c.652 4.506 3.86 8.292 8.209 9.695.779.25 1.6.422 2.534.525.363.04 1.935.04 2.299 0 1.611-.178 2.977-.577 4.323-1.264.207-.106.247-.134.219-.158-.02-.013-.9-1.193-1.955-2.62l-1.919-2.592-2.404-3.558a338.739 338.739 0 0 0-2.422-3.556c-.009-.002-.018 1.579-.023 3.51-.007 3.38-.01 3.515-.052 3.595a.426.426 0 0 1-.206.214c-.075.037-.14.044-.495.044H7.81l-.108-.068a.438.438 0 0 1-.157-.171l-.05-.106.006-4.703.007-4.705.072-.092a.645.645 0 0 1 .174-.143c.096-.047.134-.051.54-.051.478 0 .558.018.682.154.035.038 1.337 1.999 2.895 4.361a10760.433 10760.433 0 0 0 4.735 7.17l1.9 2.879.096-.063a12.317 12.317 0 0 0 2.466-2.163 11.944 11.944 0 0 0 2.824-6.134c.096-.66.108-.854.108-1.748 0-.893-.012-1.088-.108-1.747-.652-4.506-3.859-8.292-8.208-9.695a12.597 12.597 0 0 0-2.499-.523A33.119 33.119 0 0 0 11.573 0zm4.069 7.217c.347 0 .408.005.486.047a.473.473 0 0 1 .237.277c.018.06.023 1.365.018 4.304l-.006 4.218-.744-1.14-.746-1.14v-3.066c0-1.982.01-3.097.023-3.15a.478.478 0 0 1 .233-.296c.096-.05.13-.054.5-.054z"
      />
    </svg>
  ),
  CheckMarkCircle: (props: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 330 330"
      fill="currentColor"
      {...props}
    >
      <path d="M165 0C74.019 0 0 74.019 0 165s74.019 165 165 165 165-74.019 165-165S255.981 0 165 0zm0 300c-74.44 0-135-60.561-135-135S90.56 30 165 30s135 60.561 135 135-60.561 135-135 135z" />
      <path d="M226.872 106.664l-84.854 84.853-38.89-38.891c-5.857-5.857-15.355-5.858-21.213-.001-5.858 5.858-5.858 15.355 0 21.213l49.496 49.498a15 15 0 0010.606 4.394h.001c3.978 0 7.793-1.581 10.606-4.393l95.461-95.459c5.858-5.858 5.858-15.355 0-21.213-5.858-5.858-15.355-5.859-21.213-.001z" />
    </svg>
  ),
  gitHub: (props: LucideProps) => (
    <svg viewBox="0 0 438.549 438.549" {...props}>
      <path
        fill="currentColor"
        d="M409.132 114.573c-19.608-33.596-46.205-60.194-79.798-79.8-33.598-19.607-70.277-29.408-110.063-29.408-39.781 0-76.472 9.804-110.063 29.408-33.596 19.605-60.192 46.204-79.8 79.8C9.803 148.168 0 184.854 0 224.63c0 47.78 13.94 90.745 41.827 128.906 27.884 38.164 63.906 64.572 108.063 79.227 5.14.954 8.945.283 11.419-1.996 2.475-2.282 3.711-5.14 3.711-8.562 0-.571-.049-5.708-.144-15.417a2549.81 2549.81 0 01-.144-25.406l-6.567 1.136c-4.187.767-9.469 1.092-15.846 1-6.374-.089-12.991-.757-19.842-1.999-6.854-1.231-13.229-4.086-19.13-8.559-5.898-4.473-10.085-10.328-12.56-17.556l-2.855-6.57c-1.903-4.374-4.899-9.233-8.992-14.559-4.093-5.331-8.232-8.945-12.419-10.848l-1.999-1.431c-1.332-.951-2.568-2.098-3.711-3.429-1.142-1.331-1.997-2.663-2.568-3.997-.572-1.335-.098-2.43 1.427-3.289 1.525-.859 4.281-1.276 8.28-1.276l5.708.853c3.807.763 8.516 3.042 14.133 6.851 5.614 3.806 10.229 8.754 13.846 14.842 4.38 7.806 9.657 13.754 15.846 17.847 6.184 4.093 12.419 6.136 18.699 6.136 6.28 0 11.704-.476 16.274-1.423 4.565-.952 8.848-2.383 12.847-4.285 1.713-12.758 6.377-22.559 13.988-29.41-10.848-1.14-20.601-2.857-29.264-5.14-8.658-2.286-17.605-5.996-26.835-11.14-9.235-5.137-16.896-11.516-22.985-19.126-6.09-7.614-11.088-17.61-14.987-29.979-3.901-12.374-5.852-26.648-5.852-42.826 0-23.035 7.52-42.637 22.557-58.817-7.044-17.318-6.379-36.732 1.997-58.24 5.52-1.715 13.706-.428 24.554 3.853 10.85 4.283 18.794 7.952 23.84 10.994 5.046 3.041 9.089 5.618 12.135 7.708 17.705-4.947 35.976-7.421 54.818-7.421s37.117 2.474 54.823 7.421l10.849-6.849c7.419-4.57 16.18-8.758 26.262-12.565 10.088-3.805 17.802-4.853 23.134-3.138 8.562 21.509 9.325 40.922 2.279 58.24 15.036 16.18 22.559 35.787 22.559 58.817 0 16.178-1.958 30.497-5.853 42.966-3.9 12.471-8.941 22.457-15.125 29.979-6.191 7.521-13.901 13.85-23.131 18.986-9.232 5.14-18.182 8.85-26.84 11.136-8.662 2.286-18.415 4.004-29.263 5.146 9.894 8.562 14.842 22.077 14.842 40.539v60.237c0 3.422 1.19 6.279 3.572 8.562 2.379 2.279 6.136 2.95 11.276 1.995 44.163-14.653 80.185-41.062 108.068-79.226 27.88-38.161 41.825-81.126 41.825-128.906-.01-39.771-9.818-76.454-29.414-110.049z"
      ></path>
    </svg>
  ),
  google: ({ ...props }: LucideProps) => (
    <svg
      aria-hidden="true"
      focusable="false"
      data-prefix="fab"
      data-icon="discord"
      role="img"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 488 512"
      {...props}
    >
      <path
        fill="currentColor"
        d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"
      ></path>
    </svg>
  ),
  facebook: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" {...props}>
      <path
        fill="currentColor"
        d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"
      />
    </svg>
  ),
  discord: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512" {...props}>
      <path
        fill="currentColor"
        d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z"
      />
    </svg>
  ),

  bakery: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      id="Outline"
      viewBox="0 0 512 512"
      width="512"
      height="512"
      fill="currentColor"
      {...props}
    >
      <path
        d="M213.056,231.438a8,8,0,1,0,5.888-14.876c-18.527-7.335-42.3-11.374-66.944-11.374s-48.417,4.039-66.944,11.374a8,8,0,1,0,5.888,14.876c16.7-6.61,38.382-10.25,61.056-10.25S196.357,224.828,213.056,231.438Z"
        fill="currentColor"
      />
      <path
        d="M416,16H384c-23.366,0-43.613,25.444-58.552,73.58-7.08,22.815-12.528,49.446-16.163,78.42H144v.118c-32.288.855-62.486,6.86-85.746,17.149C31.006,197.319,16,214.135,16,232.617c0,15.891,11.317,30.777,32,42.266V422.049a65.688,65.688,0,0,0-23.435,38.717,29.684,29.684,0,0,0,6.2,24.659A28.79,28.79,0,0,0,53.047,496H346.953a28.681,28.681,0,0,0,17.852-6.229A34.1,34.1,0,0,0,384,496h32c23.366,0,43.613-25.444,58.552-73.58C488.383,377.854,496,318.751,496,256s-7.617-121.854-21.448-166.42C459.613,41.444,439.366,16,416,16ZM53.047,480a12.848,12.848,0,0,1-9.929-4.743,13.738,13.738,0,0,1-2.851-11.416,49.465,49.465,0,0,1,29.246-36.168,111.883,111.883,0,0,0-4.867,19.063A47.027,47.027,0,0,0,71.416,480ZM104,480H99.361c-4.729,0-9.3-2.31-12.859-6.5-5.263-6.195-7.531-15.233-6.067-24.177,4-24.452,16.7-44.92,33.932-56.125a86.14,86.14,0,0,0-.505,38.033l9.6,45.7a23.548,23.548,0,0,0,.886,3.067Zm18.94-108.547c-18.246,5.984-33.872,19.364-44.576,37.26A63.07,63.07,0,0,0,64,412.654V270.061a8,8,0,0,0-4.415-7.152C41.8,253.993,32,243.235,32,232.617,32,221.024,43.929,209.1,64.727,199.9,87.905,189.646,118.9,184,152,184s64.1,5.646,87.273,15.9c20.8,9.2,32.727,21.125,32.727,32.718,0,10.618-9.8,21.376-27.585,30.292A8,8,0,0,0,240,270.061v66.433a82.933,82.933,0,0,0-19.088-6.381,104.007,104.007,0,0,0-41.824,0,82.889,82.889,0,0,0-52.978,36.075C124.979,367.91,123.938,369.673,122.94,371.453Zm147.539,56.485-9.6,45.707A8.037,8.037,0,0,1,253.05,480H146.95a8.037,8.037,0,0,1-7.829-6.355l-9.6-45.707a69.688,69.688,0,0,1,9.962-52.964,66.994,66.994,0,0,1,42.8-29.184,88.1,88.1,0,0,1,35.426,0,66.994,66.994,0,0,1,42.8,29.184A69.688,69.688,0,0,1,270.479,427.938ZM313.5,473.5c-3.563,4.193-8.13,6.5-12.859,6.5H275.651a23.579,23.579,0,0,0,.886-3.066l9.6-45.706a86.14,86.14,0,0,0-.5-38.033c17.233,11.2,29.929,31.674,33.932,56.126C321.029,458.265,318.761,467.3,313.5,473.5ZM277.06,371.453c-1-1.78-2.039-3.543-3.17-5.265A84.568,84.568,0,0,0,256,346.53V274.883c20.683-11.489,32-26.375,32-42.266,0-18.482-15.006-35.3-42.254-47.35-.982-.435-2-.848-3-1.267h64.745C305.194,206.984,304,231.205,304,256c0,56.555,6.13,109.782,17.4,152.319C310.705,390.619,295.172,377.393,277.06,371.453Zm79.822,103.8A12.848,12.848,0,0,1,346.953,480H328.584a47.028,47.028,0,0,0,6.77-33.265,111.965,111.965,0,0,0-4.867-19.062,49.463,49.463,0,0,1,29.246,36.169A13.737,13.737,0,0,1,356.882,475.257ZM384,480a18.245,18.245,0,0,1-9.814-3.218,29.809,29.809,0,0,0,1.249-16.016A65.552,65.552,0,0,0,339.708,414.3a401.074,401.074,0,0,1-9.879-42.129c11.047-3.1,35.55-7.273,67.641,3.423v0a8,8,0,1,0,5.058-15.17v0l-.089-.029-.113-.035c-34.435-11.43-61.2-7.762-75.142-4.084a677.754,677.754,0,0,1-7.164-94.85c9.779-3.326,35.077-9.281,69.448,2.176v0a8,8,0,1,0,5.058-15.17v0l-.088-.028-.116-.037c-33.673-11.174-60.012-7.529-74.241-3.655a669.018,669.018,0,0,1,6.836-87.643c9.119-3,35.244-9.227,70.549,2.541v0a8,8,0,1,0,5.058-15.17v0l-.089-.029-.113-.035c-32.393-10.752-57.989-8.143-72.517-4.733a393.693,393.693,0,0,1,10.918-45.292C352.84,55.3,369.016,32,384,32s31.16,23.3,43.271,62.322C440.639,137.4,448,194.812,448,256s-7.361,118.605-20.729,161.678C415.16,456.7,398.984,480,384,480Zm75.271-62.322C447.16,456.7,430.984,480,416,480h-1.859c10.781-12.331,20.367-31.659,28.411-57.58C456.383,377.854,464,318.751,464,256s-7.617-121.854-21.448-166.42c-8.044-25.921-17.63-45.249-28.411-57.58H416c14.984,0,31.16,23.3,43.271,62.322C472.639,137.4,480,194.812,480,256S472.639,374.605,459.271,417.678Z"
        fill="currentColor"
      />
    </svg>
  ),
  book: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24.6"
      height="19.335"
      viewBox="0 0 24.6 19.335"
      fill="currentColor"
      {...props}
    >
      <g id="Books" transform="translate(-24.7 -30.187)">
        <g
          id="Group_12308"
          data-name="Group 12308"
          transform="translate(25 32.504)"
        >
          <g
            id="Group_12306"
            data-name="Group 12306"
            transform="translate(0 0)"
          >
            <path
              id="Path_17416"
              data-name="Path 17416"
              d="M32.612,50.142h0a34.57,34.57,0,0,0-7.238.8h0l0,0V35a0,0,0,0,1,0,0h.583a0,0,0,0,0,0,0v-.357a0,0,0,0,0,0,0h-.771a.183.183,0,0,0-.183.183V51.164a.182.182,0,0,0,.183.183.181.181,0,0,0,.036,0,28.735,28.735,0,0,1,9.287-.669.006.006,0,0,0,.006,0,.005.005,0,0,0,0-.006Z"
              transform="translate(-25 -34.629)"
              fill="currentColor"
              stroke="currentColor"
              strokeWidth="0.6"
            />
          </g>
          <g
            id="Group_12307"
            data-name="Group 12307"
            transform="translate(14.922 0)"
          >
            <path
              id="Path_17417"
              data-name="Path 17417"
              d="M64.983,34.629h-.776V35H64.8V50.957c-.5-.063-1.009-.13-1.515-.2a47.178,47.178,0,0,0-6.073-.546l-.013,0-1.075.311a.048.048,0,0,0,.017.094,37.04,37.04,0,0,1,7.1.5c.576.076,1.152.152,1.724.223a.183.183,0,0,0,.205-.181V34.812A.183.183,0,0,0,64.983,34.629Z"
              transform="translate(-56.088 -34.629)"
              fill="currentColor"
              stroke="currentColor"
              strokeWidth="0.6"
            />
          </g>
        </g>
        <g
          id="Group_12309"
          data-name="Group 12309"
          transform="translate(26.919 30.542)"
        >
          <path
            id="Path_17418"
            data-name="Path 17418"
            d="M49.16,30.842a.183.183,0,0,0-.166-.182c-.314-.029-7.587-.67-9.915,1.365-2.327-2.035-9.6-1.393-9.915-1.365a.183.183,0,0,0-.166.182v15.7a.183.183,0,0,0,.195.183c.073,0,7.272-.441,9.754,2.133a.187.187,0,0,0,.062.042h0a.186.186,0,0,0,.069.013.182.182,0,0,0,.069-.013h0a.187.187,0,0,0,.062-.042c2.481-2.573,9.682-2.138,9.754-2.133a.187.187,0,0,0,.137-.049.183.183,0,0,0,.058-.134Zm-19.8,15.51V31.011c1.122-.085,7.578-.49,9.531,1.336V48.314c-2.072-1.743-6.2-1.988-8.356-1.988C30.006,46.326,29.594,46.341,29.364,46.352Zm19.429,0c-1.16-.056-6.948-.212-9.531,1.962V32.347c1.954-1.827,8.409-1.421,9.531-1.336Z"
            transform="translate(-28.998 -30.542)"
            fill="currentColor"
            stroke="currentColor"
            strokeWidth="0.6"
          />
        </g>
      </g>
    </svg>
  ),
  dress: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24.6"
      height="19.335"
      viewBox="0 0 24.6 19.335"
      fill="currentColor"
      {...props}
    >
      <g id="Books" transform="translate(-24.7 -30.187)">
        <g
          id="Group_12308"
          data-name="Group 12308"
          transform="translate(25 32.504)"
        >
          <g
            id="Group_12306"
            data-name="Group 12306"
            transform="translate(0 0)"
          >
            <path
              id="Path_17416"
              data-name="Path 17416"
              d="M32.612,50.142h0a34.57,34.57,0,0,0-7.238.8h0l0,0V35a0,0,0,0,1,0,0h.583a0,0,0,0,0,0,0v-.357a0,0,0,0,0,0,0h-.771a.183.183,0,0,0-.183.183V51.164a.182.182,0,0,0,.183.183.181.181,0,0,0,.036,0,28.735,28.735,0,0,1,9.287-.669.006.006,0,0,0,.006,0,.005.005,0,0,0,0-.006Z"
              transform="translate(-25 -34.629)"
              fill="currentColor"
              stroke="currentColor"
              strokeWidth="0.6"
            />
          </g>
          <g
            id="Group_12307"
            data-name="Group 12307"
            transform="translate(14.922 0)"
          >
            <path
              id="Path_17417"
              data-name="Path 17417"
              d="M64.983,34.629h-.776V35H64.8V50.957c-.5-.063-1.009-.13-1.515-.2a47.178,47.178,0,0,0-6.073-.546l-.013,0-1.075.311a.048.048,0,0,0,.017.094,37.04,37.04,0,0,1,7.1.5c.576.076,1.152.152,1.724.223a.183.183,0,0,0,.205-.181V34.812A.183.183,0,0,0,64.983,34.629Z"
              transform="translate(-56.088 -34.629)"
              fill="currentColor"
              stroke="currentColor"
              strokeWidth="0.6"
            />
          </g>
        </g>
        <g
          id="Group_12309"
          data-name="Group 12309"
          transform="translate(26.919 30.542)"
        >
          <path
            id="Path_17418"
            data-name="Path 17418"
            d="M49.16,30.842a.183.183,0,0,0-.166-.182c-.314-.029-7.587-.67-9.915,1.365-2.327-2.035-9.6-1.393-9.915-1.365a.183.183,0,0,0-.166.182v15.7a.183.183,0,0,0,.195.183c.073,0,7.272-.441,9.754,2.133a.187.187,0,0,0,.062.042h0a.186.186,0,0,0,.069.013.182.182,0,0,0,.069-.013h0a.187.187,0,0,0,.062-.042c2.481-2.573,9.682-2.138,9.754-2.133a.187.187,0,0,0,.137-.049.183.183,0,0,0,.058-.134Zm-19.8,15.51V31.011c1.122-.085,7.578-.49,9.531,1.336V48.314c-2.072-1.743-6.2-1.988-8.356-1.988C30.006,46.326,29.594,46.341,29.364,46.352Zm19.429,0c-1.16-.056-6.948-.212-9.531,1.962V32.347c1.954-1.827,8.409-1.421,9.531-1.336Z"
            transform="translate(-28.998 -30.542)"
            fill="currentColor"
            stroke="currentColor"
            strokeWidth="0.6"
          />
        </g>
      </g>
    </svg>
  ),
  facial: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="18.814"
      height="24"
      viewBox="0 0 18.814 24"
      fill="currentColor"
      {...props}
    >
      <g id="Makup" transform="translate(-507.818 -485.385)">
        <path
          id="Path_17426"
          data-name="Path 17426"
          d="M514.58,502.867a.721.721,0,0,0-.448-.579.411.411,0,0,0-.125-.041v-4.5a.591.591,0,0,0-.29-.5V494.9a6.977,6.977,0,0,0-.675-2.868l0-.009,0-.005a3.2,3.2,0,0,0-.272-.449,1.188,1.188,0,0,0-1.347-.362,2.261,2.261,0,0,0-1.492,1.22l-.022.045a6.315,6.315,0,0,0-.338.874c0,.007-.006.012-.008.019s0,.01,0,.015a7.074,7.074,0,0,0-.292,2.044v1.707c-.336.144-.509.35-.509.613v4.486c-.354.155-.545.364-.57.622,0,.006,0,.011,0,.017a71.956,71.956,0,0,0-.289,10.391c0,.787,1.5,1.38,3.49,1.38s3.49-.593,3.489-1.355a72.1,72.1,0,0,0-.288-10.417ZM512.8,494a5.335,5.335,0,0,1,.085.9v2.779a6.961,6.961,0,0,1-1.5.142,7.622,7.622,0,0,1-1.284-.1v-2.3a6.715,6.715,0,0,1,.043-.751,1.974,1.974,0,0,0,.891.2A2.569,2.569,0,0,0,512.8,494Zm-3.209,4.464a8.613,8.613,0,0,0,3.585,0v4.508a10.2,10.2,0,0,1-3.585,0Zm1.087-5.676a1.447,1.447,0,0,1,.938-.773c.172-.042.394-.067.479.048a2.406,2.406,0,0,1,.206.344v0a.832.832,0,0,1-.006.876,1.743,1.743,0,0,1-1.264.749.87.87,0,0,1-.655-.213c-.017-.023-.055-.077-.019-.21a5.462,5.462,0,0,1,.3-.781Zm3.364,20.4a6.081,6.081,0,0,1-5.316,0,71.567,71.567,0,0,1,.219-9.528,10,10,0,0,0,4.877,0A71.829,71.829,0,0,1,514.038,513.194Z"
          transform="translate(0 -5.256)"
          fill="currentColor"
        />
        <path
          id="Path_17427"
          data-name="Path 17427"
          d="M618.005,487.378c-.617-1.323-2.2-1.993-4.7-1.993s-4.08.671-4.7,1.994c-1.3,2.781,2.328,7.41,2.923,8.139l-.194,12.539c0,.514.524,1.279,1.969,1.279s1.969-.765,1.969-1.286l-.195-12.532C615.675,494.791,619.3,490.161,618.005,487.378Zm-5.671,10.394.026-1.66a3.555,3.555,0,0,0,.65.1.415.415,0,0,0,.088.01c.013,0,.024,0,.037,0,.058,0,.116,0,.174,0a3.918,3.918,0,0,0,.949-.107l.026,1.66a2.931,2.931,0,0,1-1.949,0Zm-2.966-10.041c.468-1,1.794-1.511,3.94-1.511s3.472.508,3.94,1.511c.836,1.792-1.112,5.009-2.374,6.7a6.637,6.637,0,0,0,.23-1.731.417.417,0,0,0-.417-.417h0a.418.418,0,0,0-.417.417c0,.657-.2,2.461-1.017,2.665a2.056,2.056,0,0,1-.49-1.175.417.417,0,0,0-.826.123,4.453,4.453,0,0,0,.112.518C610.835,493.3,608.46,489.678,609.368,487.731Zm3.94,20.771c-.9,0-1.126-.359-1.134-.438l.146-9.408a4.2,4.2,0,0,0,1.976,0l.146,9.4C614.435,508.143,614.208,508.5,613.308,508.5Z"
          transform="translate(-91.651)"
          fill="currentColor"
        />
      </g>
    </svg>
  ),
  fruits: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="20.347"
      height="24.101"
      viewBox="0 0 20.347 24.101"
      fill="currentColor"
      {...props}
    >
      <g id="Grocery" transform="translate(-39.481 0.052)">
        <path
          id="Path_17386"
          data-name="Path 17386"
          d="M349.261,399.988a.469.469,0,1,1,.461-.385A.473.473,0,0,1,349.261,399.988Z"
          transform="translate(-294.289 -380.346)"
          fill="currentColor"
          stroke="currentColor"
          strokeWidth="0.1"
        />
        <path
          id="Path_17387"
          data-name="Path 17387"
          d="M58.743,8.638A6.2,6.2,0,0,0,55.4,6.3a6.662,6.662,0,0,0-3.058.055h0l-.034.008-.091.02c-.074.017-.188.045-.31.076-.16.041-.323.078-.485.108q0-.182-.014-.374a6.162,6.162,0,0,1,1.87-3.956A6.643,6.643,0,0,1,55.212.9.469.469,0,0,0,54.87.032a7.448,7.448,0,0,0-2.223,1.509,7.229,7.229,0,0,0-1.659,2.437,4.837,4.837,0,0,0-1.119-1.837C47.744.019,43.762.68,43.527.721h0a.457.457,0,0,0-.367.314.6.6,0,0,0-.017.066c-.027.151-.573,3.346.8,5.557a7.353,7.353,0,0,0-3.914,6.923,11.6,11.6,0,0,0,1.142,4.581,14.2,14.2,0,0,0,2.744,4.091A5.044,5.044,0,0,0,47.309,24a6.6,6.6,0,0,0,1.88-.276A3.331,3.331,0,0,1,51,23.691l.006,0,.11.031A6.6,6.6,0,0,0,53,24a4.912,4.912,0,0,0,3.25-1.608,13.985,13.985,0,0,0,4.029-8.812A8.163,8.163,0,0,0,58.743,8.638ZM49.206,2.8a5.247,5.247,0,0,1,1.256,3.409c-.017.211-.025,1.132-.025,1.132L46.881,3.794a.469.469,0,0,0-.663.663L49.8,8.033c-1.224.066-3.343-.027-4.572-1.255C43.75,5.3,43.912,2.552,44.02,1.6c.953-.108,3.709-.27,5.185,1.2ZM55.6,21.716A4.033,4.033,0,0,1,53,23.062a5.728,5.728,0,0,1-1.609-.236l-.141-.04h0a4.269,4.269,0,0,0-2.329.04,5.728,5.728,0,0,1-1.609.236A4.172,4.172,0,0,1,44.58,21.59a13.058,13.058,0,0,1-3.612-8.009c0-3.445,1.878-5.444,3.571-6.163l.024.024a6.632,6.632,0,0,0,4.665,1.547A9.91,9.91,0,0,0,50.9,8.863c.374-.082.365-.256.388-.364V8.482a9.219,9.219,0,0,0,.107-.965.475.475,0,0,0,.083-.007c.22-.038.441-.085.658-.142.084-.022.165-.042.232-.058,1.934.674,3.846,2.849,3.846,6.269a9.857,9.857,0,0,1-.747,3.455.469.469,0,1,0,.874.339,10.789,10.789,0,0,0,.811-3.795,7.594,7.594,0,0,0-3.162-6.493,4.317,4.317,0,0,1,1.17.122c2.013.521,4.18,2.737,4.18,6.371A13.138,13.138,0,0,1,55.6,21.716Z"
          transform="translate(-0.5)"
          fill="currentColor"
          stroke="currentColor"
          strokeWidth="0.1"
        />
      </g>
    </svg>
  ),
  furniture: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="18.1"
      height="24.1"
      viewBox="0 0 18.1 24.1"
      fill="currentColor"
      {...props}
    >
      <g id="Furniture" transform="translate(-47.95 -583.95)">
        <path
          id="Path_17415"
          data-name="Path 17415"
          d="M66.684,585.288A1.5,1.5,0,0,0,65.2,584H58.8a1.5,1.5,0,0,0-1.485,1.288L56,596H68Zm-8.625.1a.753.753,0,0,1,.741-.638h6.4a.753.753,0,0,1,.741.638l1.212,9.862h-10.3Z"
          transform="translate(-5)"
          fill="currentColor"
          stroke="currentColor"
          strokeWidth="0.1"
        />
        <path
          id="Path_17416"
          data-name="Path 17416"
          d="M65.25,608H64.5a.75.75,0,0,0-.75.75v.75a.75.75,0,0,0,.75.75v3h-.75a1.5,1.5,0,0,0-1.5-1.5H51.75a1.5,1.5,0,0,0-1.5,1.5H49.5v-3a.75.75,0,0,0,.75-.75v-.75a.75.75,0,0,0-.75-.75h-.75a.75.75,0,0,0-.75.75v.75a.75.75,0,0,0,.75.75v3a.75.75,0,0,0,.75.75h.952a1.5,1.5,0,0,0,1.3.75H55.5v1.5a.75.75,0,0,0,.75.75h.375v.75h-2.25a1.877,1.877,0,0,0-1.875,1.875v1.19a1.125,1.125,0,1,0,.75,0v-1.19a1.126,1.126,0,0,1,1.125-1.125h2.25v2.315a1.125,1.125,0,1,0,.75,0V618.5h2.25a1.126,1.126,0,0,1,1.125,1.125v1.19a1.125,1.125,0,1,0,.75,0v-1.19a1.877,1.877,0,0,0-1.875-1.875h-2.25V617h.375a.75.75,0,0,0,.75-.75v-1.5h3.75a1.5,1.5,0,0,0,1.3-.75H64.5a.75.75,0,0,0,.75-.75v-3a.75.75,0,0,0,.75-.75v-.75A.75.75,0,0,0,65.25,608Zm-16.5,1.5v-.75h.75v.75Zm4.125,12.75a.375.375,0,1,1,.375-.375A.376.376,0,0,1,52.875,622.25Zm8.25-.75a.375.375,0,1,1-.375.375A.376.376,0,0,1,61.125,621.5ZM57,622.25a.375.375,0,1,1,.375-.375A.376.376,0,0,1,57,622.25Zm.75-6h-1.5v-1.5h1.5Zm4.5-2.25H51.75a.75.75,0,0,1,0-1.5h10.5a.75.75,0,0,1,0,1.5Zm3-4.5H64.5v-.75h.75Z"
          transform="translate(0 -15)"
          fill="currentColor"
          stroke="currentColor"
          strokeWidth="0.1"
        />
      </g>
    </svg>
  ),
  handbag: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="23.878"
      height="24.3"
      viewBox="0 0 23.878 24.3"
      fill="currentColor"
      {...props}
    >
      <path
        id="Bags"
        d="M334.087,36.795h6.808a2.594,2.594,0,0,1,1.833.763h0a2.592,2.592,0,0,1,.763,1.833v2.718h3.328a2.384,2.384,0,0,1,1.686.7h0a2.383,2.383,0,0,1,.7,1.686v3.227a5.569,5.569,0,0,1-.606,2.532v6.066a4.48,4.48,0,0,1-4.469,4.469H330.795a4.567,4.567,0,0,1-4.556-4.556V50.26a5.569,5.569,0,0,1-.606-2.532V44.5a2.384,2.384,0,0,1,.7-1.687h0a2.382,2.382,0,0,1,1.688-.7h3.328v-2.58a2.742,2.742,0,0,1,2.736-2.736Zm13.29,15.077a5.6,5.6,0,0,1-3.443,1.462l-.048,0h-.009l-.061,0h-.01l-.066,0h-3.826v.718a1.838,1.838,0,0,1-.541,1.3v0a1.841,1.841,0,0,1-1.3.541h-1.245a1.891,1.891,0,0,1-1.339-.556v0a1.887,1.887,0,0,1-.556-1.337v-.668H331.1l-.066,0h-.01l-.06,0h-.009l-.048,0a5.6,5.6,0,0,1-3.443-1.462v4.367a3.339,3.339,0,0,0,3.328,3.328h13.341a3.252,3.252,0,0,0,3.241-3.241V51.872Zm-3.883-8.533H328.022a1.159,1.159,0,0,0-.82.342h0a1.158,1.158,0,0,0-.339.82v3.227a4.405,4.405,0,0,0,4.161,4.383h0l.11,0h12.574l.11,0h0a4.4,4.4,0,0,0,4.161-4.383V44.5a1.157,1.157,0,0,0-.339-.82l0,0a1.157,1.157,0,0,0-.82-.339Zm-4.807,10.006h-2.53v.668a.669.669,0,0,0,.2.472h0a.667.667,0,0,0,.471.2h1.245a.615.615,0,0,0,.436-.182h0a.62.62,0,0,0,.18-.437v-.718Zm2.208-15.322h-6.808a1.515,1.515,0,0,0-1.509,1.509v2.58h9.688V39.394a1.365,1.365,0,0,0-.4-.968l0,0A1.365,1.365,0,0,0,340.895,38.023Z"
        transform="translate(-325.483 -36.645)"
        fill="currentColor"
        stroke="#fff"
        strokeWidth="0.3"
        fillRule="evenodd"
      />
    </svg>
  ),
  medicine: ({ ...props }: LucideProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24.2"
      height="24.2"
      viewBox="0 0 24.2 24.2"
      fill="currentColor"
      {...props}
    >
      <g id="Medicine" transform="translate(-332.9 -1656.038)">
        <g
          id="Group_12311"
          data-name="Group 12311"
          transform="translate(333 1656.138)"
        >
          <path
            id="Path_17420"
            data-name="Path 17420"
            d="M350.833,1680.138a6.126,6.126,0,0,1-4.361-1.806l-11.666-11.666a6.167,6.167,0,0,1,8.722-8.722l11.666,11.666a6.167,6.167,0,0,1-4.361,10.528Zm-11.666-23.214a5.381,5.381,0,0,0-3.805,9.186l11.666,11.666a5.381,5.381,0,0,0,7.61,0h0a5.381,5.381,0,0,0,0-7.61L342.972,1658.5A5.346,5.346,0,0,0,339.167,1656.924Z"
            transform="translate(-333 -1656.138)"
            fill="currentColor"
            stroke="currentColor"
            strokeWidth="0.2"
          />
        </g>
        <g
          id="Group_12312"
          data-name="Group 12312"
          transform="translate(340.524 1663.662)"
        >
          <line
            id="Line_3"
            data-name="Line 3"
            y1="8.166"
            x2="8.166"
            transform="translate(0.393 0.393)"
            fill="#fff"
            stroke="currentColor"
            strokeWidth="0.2"
          />
          <path
            id="Path_17421"
            data-name="Path 17421"
            d="M536.93,1868.628a.393.393,0,0,1-.278-.671l8.166-8.166a.393.393,0,0,1,.556.556l-8.166,8.166A.392.392,0,0,1,536.93,1868.628Z"
            transform="translate(-536.537 -1859.676)"
            fill="currentColor"
            stroke="currentColor"
            strokeWidth="0.2"
          />
        </g>
        <g
          id="Group_12313"
          data-name="Group 12313"
          transform="translate(334.856 1659.668)"
        >
          <path
            id="Path_17423"
            data-name="Path 17423"
            d="M386.6,1759.337a.392.392,0,0,1-.278-.115,10.88,10.88,0,0,1-2.936-4.287,3.121,3.121,0,0,1,.659-3.167.393.393,0,1,1,.579.532,2.353,2.353,0,0,0-.482,2.417,10.161,10.161,0,0,0,2.737,3.949.393.393,0,0,1-.278.671Z"
            transform="translate(-383.216 -1751.641)"
            fill="currentColor"
            stroke="currentColor"
            strokeWidth="0.2"
          />
        </g>
      </g>
    </svg>
  ),
};
