# PHP CRUD Application

## Project Overview
- Basic CRUD (Create, Read, Update, Delete) functionality for managing users in a database
- Allows users to register, login, view, update, and delete their accounts
- Provides a simple and intuitive interface for interacting with user data
- Enhances efficiency and usability for users

## Technology Used
- PHP (Hypertext Preprocessor) for server-side scripting
- MySQL Database for data storage
- HTML and CSS for front-end development
- Sessions for user authentication and state management

## Installation
1. Clone this repository using the following command:
    ```bash
    git clone https://github.com/SLoharkar/PHP-CRUD-Application.git
    ```
2. Set up a local server environment (e.g., XAMPP, WAMP) to run PHP scripts.
3. Import the provided SQL file (`database.sql`) into your MySQL database to create the necessary tables.

## Highlights
- User-friendly interface for managing user accounts
- Secure user authentication using PHP sessions
- Easy navigation and interaction with user data
- Responsive design for seamless user experience across devices

## Dependencies
- Web server environment (e.g., XAMPP, WAMP)
- PHP 7 or later
- MySQL Database
- Web browser (Chrome, Firefox, Safari, etc.)

## Usage
1. Start your local server environment (e.g., XAMPP, WAMP).
2. Import the provided SQL file (`database.sql`) into your MySQL database to create the necessary tables.
3. Open the project directory in your web server's document root directory.
4. Navigate to the project URL in your web browser to access the application.

## Video Demo
https://github.com/SLoharkar/PHP-CRUD-Application/assets/68845746/8c29e882-611e-4abb-93ed-b4d22a85cb48
