# Contributing to SDWebImage

First of all, we want to thank you for you interest in this project.
Every contribution matters, this is how we are keeping the project alive. 
We are all owners, from Olivier who started the project, to the people who use it in their projects and participated in a conversation, improved the documentation, created an example or made any code changes.
If you want to help, but don't know where to begin, we recommend you start small:
- it would help a lot if you read: https://opensource.guide/how-to-contribute/
- read the ongoing discussions to see what the overall status is
- pitch in the converstations where you feel it's useful. Talk to other people, ask questions if you don't understand something
- contributing to the documentation or the ongoing converstations is as important as contributing to the code

We want to make contributing to this project as easy and transparent as possible. Here are a few guidelines for making all our lives easier.

## Contribute to ongoing conversations

If you have a valid opinion about something we are talking about, feel free to share it.
If you also encountered an issue that someone else described, pitch in. Better yet, if you already fixed it in a certain way, share that.
We focus mostly on the GitHub conversations, but you can also help by going to the [questions tagged with "SDWebImage" on StackOverflow](https://stackoverflow.com/questions/tagged/sdwebimage) and getting involved.

## Improving documentation

A project's documentation is something you can always improve on. Make sure you go through the existing documentation and suggest changes or just create new pieces of documentation.
Examples are also welcome.

## Asking questions

We don't use GitHub as a support forum. For any usage questions that are not specific to the project itself, please ask on [Stack Overflow](https://stackoverflow.com/) instead. By doing so, you'll be more likely to quickly solve your problem, and you'll allow anyone else with the same question to find the answer. This also allows maintainers to focus on improving the project for others.

## Reporting Issues

A great way to contribute to the project is to send a detailed issue when you encounter an problem.
It is very important to check for the same problem or suggestion in the project's issue list first. If you find a match, just add a small comment there. 
Doing this helps prioritize the most common problems and requests.

When reporting issues, please include the following:

- The platform name and version (e.g. iOS 10.0)
- The library version
- The integration method (e.g. CocoaPods/Carthage/manually)
- The version of Xcode you're using
- The full output of any stack trace or compiler error
- A small demo project that replicates the issue (especially if the way to reproduce the issue is not straight-forward)
- Any other details that would be useful in understanding the problem

This information will help us review and fix your issue faster.


Please do not be offended if we close your issue and reference this document. 
If you believe the issue is truely a fault in the project’s codebase, re-open it.

## Pull Requests

We gladly accept any PR's assuming they are well written, documented ( if necessary ) and preferably have test code. 
If you're unsure if we'll accept a new feature please open an issue requesting it and we can have a discussion before you code and submit a PR.

Checklist:
- Fork the repo and create your branch from the latest master (to minimize the conflicts)
- If you've added code that should be tested, add tests.
- If you've changed APIs, update the documentation.
- Ensure the test suite passes.
- Make sure your code lints (pod lib lint)

