# SAP BTP Industry Use Cases
[![License: Apache2](https://img.shields.io/badge/License-Apache2-green.svg)](https://opensource.org/licenses/Apache-2.0)
[![REUSE status](https://api.reuse.software/badge/github.com/SAP-samples/btp-industry-use-cases)](https://api.reuse.software/info/github.com/SAP-samples/btp-industry-use-cases)

<!--- Register repository https://api.reuse.software/register, then add REUSE badge:
[![REUSE status](https://api.reuse.software/badge/github.com/SAP-samples/REPO-NAME)](https://api.reuse.software/info/github.com/SAP-samples/REPO-NAME)

2. The .reuse/dep5 file: 
The [Reuse Tool](https://reuse.software/) must be used for your samples project. You can find the .reuse/dep5 in the project initial. Please replace the parts inside the single angle quotation marks < > by the specific information for your repository.

3. The README.md file (this file):
Please edit this file as it is the primary description file for your project. You can find some placeholder titles for sections below.
-->

## Description
This repository includes a list of sample code about industry use cases with SAP BTP, which are presented during the [SAP BTP Industry Use Cases series](https://blogs.sap.com/2023/02/10/deliver-real-life-use-cases-with-sap-btp/). Each numbered folder you see in the structure is comprised by the code presented on an individual session. And each folder represents a completed runnable project about a industry use case with SAP BTP. To run a specific project, please kindly follow the READMe.md within its folder. <br/>
Use Case | Industry | SAP BTP Services | Blog Post
---------|----------|----------|----------
[`01-Intelligent Ticketing System`](01-intelligent-ticket-system) | Service | SAP CAP, CF, Business Rule | [link](https://blogs.sap.com/2023/02/28/deliver-real-life-use-cases-with-sap-btp-intelligent-ticket-system/)
[`02-Fleet Driver Tracking`](02-fleet-driver-tracking) | Transportation | SSO with IAS between SAC and CAP, SAP Graph, SAP Build Process Automation | [link](https://blogs.sap.com/2023/03/30/deliver-real-life-use-cases-with-sap-btp-fleet-driver-tracking-solution/)
[`03-Workplace Management`](03-workplace-management) | Real Estate | Multitenancy, Security, SAP CAP | [link](https://blogs.sap.com/?p=1763035)
[`04-Customer Interaction Powered by GPT`](04-customer-interaction-gpt4) | Service | Generative AI, Large Language Model, GPT, SAP CAP, SAP RAP | [link](https://blogs.sap.com/2023/06/20/exploring-the-potential-of-gpt-in-sap-ecosystem/)
[`05-AI-driven Public Urban Transport Optimization`](05-urban-public-transport) | Service | Data Intelligence, Datasphere, AI Core, SAC | [link1](https://blogs.sap.com/2023/07/31/ai-driven-public-urban-transport-optimization-introduction-architecture/), [link2](https://blogs.sap.com/2023/07/19/ai-driven-public-urban-transport-optimization-implementation-deep-dive/)
[`06-AI-powered Returnable Packaging`](06-ai-powered-returnable-packaging) | Sustainability | AI-Core, SAP Computer Vision, Kyma, SAP Build Apps | coming soon
[`07-AI-powered Pipeline Corrosion Analysis`](07-ai-powered-pipeline-corrosion-analysis) | Oil&Gas | SAP AI Core, MLOps, CM, CT, CD, CI/CD | [link1](https://blogs.sap.com/2023/11/28/ai-powered-pipeline-corrosion-analysis-introduction-architecture/), [link2](https://blogs.sap.com/2023/11/27/ai-powered-pipeline-corrosion-analysis-implementation-deep-dive/)

## Known Issues
No known issues.

## How to obtain support
[Create an issue](https://github.com/SAP-samples/<repository-name>/issues) in this repository if you find a bug or have questions about the content.
 
For additional support, [ask a question in SAP Community](https://answers.sap.com/questions/ask.html).

## Contributing
If you wish to contribute code, offer fixes or improvements, please send a pull request. Due to legal reasons, contributors will be asked to accept a DCO when they create the first pull request to this project. This happens in an automated fashion during the submission process. SAP uses [the standard DCO text of the Linux Foundation](https://developercertificate.org/).

## License
Copyright (c) 2023 SAP SE or an SAP affiliate company. All rights reserved. This project is licensed under the Apache Software License, version 2.0 except as noted otherwise in the [LICENSE](LICENSE) file.
