// AUTOGENERATED: DO NOT EDIT
// Last update date: 2021-01-06 23:02:26.837899
#region Grammar License
// Copyright (c) 2014-2020 The Khronos Group Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and/or associated documentation files (the "Materials"),
// to deal in the Materials without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Materials, and to permit persons to whom the
// Materials are furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Materials.
//
// MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
// STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
// HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/
//
// THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
// IN THE MATERIALS.
#endregion

using static Spv.Specification;

namespace Spv.Generator
{
    public partial class Module
    {
        // Miscellaneous

        public Instruction Nop()
        {
            Instruction result = NewInstruction(Op.OpNop);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Undef(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpUndef, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SizeOf(Instruction resultType, Instruction pointer)
        {
            Instruction result = NewInstruction(Op.OpSizeOf, GetNewId(), resultType);

            result.AddOperand(pointer);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Debug

        public Instruction SourceContinued(string continuedSource)
        {
            Instruction result = NewInstruction(Op.OpSourceContinued);

            result.AddOperand(continuedSource);
            AddDebug(result);

            return result;
        }

        public Instruction Source(SourceLanguage sourceLanguage, LiteralInteger version, Instruction file = null, string source = null)
        {
            Instruction result = NewInstruction(Op.OpSource);

            result.AddOperand(sourceLanguage);
            result.AddOperand(version);
            if (file != null)
            {
                result.AddOperand(file);
            }
            if (source != null)
            {
                result.AddOperand(source);
            }
            AddDebug(result);

            return result;
        }

        public Instruction SourceExtension(string extension)
        {
            Instruction result = NewInstruction(Op.OpSourceExtension);

            result.AddOperand(extension);
            AddDebug(result);

            return result;
        }

        public Instruction Name(Instruction target, string name)
        {
            Instruction result = NewInstruction(Op.OpName);

            result.AddOperand(target);
            result.AddOperand(name);
            AddDebug(result);

            return result;
        }

        public Instruction MemberName(Instruction type, LiteralInteger member, string name)
        {
            Instruction result = NewInstruction(Op.OpMemberName);

            result.AddOperand(type);
            result.AddOperand(member);
            result.AddOperand(name);
            AddDebug(result);

            return result;
        }

        public Instruction String(string str)
        {
            Instruction result = NewInstruction(Op.OpString, GetNewId());

            result.AddOperand(str);
            AddDebug(result);

            return result;
        }

        public Instruction Line(Instruction file, LiteralInteger line, LiteralInteger column)
        {
            Instruction result = NewInstruction(Op.OpLine);

            result.AddOperand(file);
            result.AddOperand(line);
            result.AddOperand(column);
            AddDebug(result);

            return result;
        }

        public Instruction NoLine()
        {
            Instruction result = NewInstruction(Op.OpNoLine);

            AddDebug(result);

            return result;
        }

        public Instruction ModuleProcessed(string process)
        {
            Instruction result = NewInstruction(Op.OpModuleProcessed);

            result.AddOperand(process);
            AddDebug(result);

            return result;
        }

        // Annotation

        public Instruction Decorate(Instruction target, Decoration decoration)
        {
            Instruction result = NewInstruction(Op.OpDecorate);

            result.AddOperand(target);
            result.AddOperand(decoration);
            AddAnnotation(result);

            return result;
        }

        public Instruction Decorate(Instruction target, Decoration decoration, IOperand parameter)
        {
            Instruction result = NewInstruction(Op.OpDecorate);

            result.AddOperand(target);
            result.AddOperand(decoration);
            result.AddOperand(parameter);
            AddAnnotation(result);

            return result;
        }

        public Instruction Decorate(Instruction target, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpDecorate);

            result.AddOperand(target);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction MemberDecorate(Instruction structureType, LiteralInteger member, Decoration decoration)
        {
            Instruction result = NewInstruction(Op.OpMemberDecorate);

            result.AddOperand(structureType);
            result.AddOperand(member);
            result.AddOperand(decoration);
            AddAnnotation(result);

            return result;
        }

        public Instruction MemberDecorate(Instruction structureType, LiteralInteger member, Decoration decoration, IOperand parameter)
        {
            Instruction result = NewInstruction(Op.OpMemberDecorate);

            result.AddOperand(structureType);
            result.AddOperand(member);
            result.AddOperand(decoration);
            result.AddOperand(parameter);
            AddAnnotation(result);

            return result;
        }

        public Instruction MemberDecorate(Instruction structureType, LiteralInteger member, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpMemberDecorate);

            result.AddOperand(structureType);
            result.AddOperand(member);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction DecorationGroup()
        {
            Instruction result = NewInstruction(Op.OpDecorationGroup, GetNewId());

            AddAnnotation(result);

            return result;
        }

        public Instruction GroupDecorate(Instruction decorationGroup, params Instruction[] targets)
        {
            Instruction result = NewInstruction(Op.OpGroupDecorate);

            result.AddOperand(decorationGroup);
            result.AddOperand(targets);
            AddAnnotation(result);

            return result;
        }

        public Instruction GroupMemberDecorate(Instruction decorationGroup, params IOperand[] targets)
        {
            Instruction result = NewInstruction(Op.OpGroupMemberDecorate);

            result.AddOperand(decorationGroup);
            result.AddOperand(targets);
            AddAnnotation(result);

            return result;
        }

        public Instruction DecorateId(Instruction target, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpDecorateId);

            result.AddOperand(target);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction DecorateString(Instruction target, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpDecorateString);

            result.AddOperand(target);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction DecorateStringGOOGLE(Instruction target, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpDecorateStringGOOGLE);

            result.AddOperand(target);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction MemberDecorateString(Instruction structType, LiteralInteger member, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpMemberDecorateString);

            result.AddOperand(structType);
            result.AddOperand(member);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        public Instruction MemberDecorateStringGOOGLE(Instruction structType, LiteralInteger member, Decoration decoration, params IOperand[] parameters)
        {
            Instruction result = NewInstruction(Op.OpMemberDecorateStringGOOGLE);

            result.AddOperand(structType);
            result.AddOperand(member);
            result.AddOperand(decoration);
            result.AddOperand(parameters);
            AddAnnotation(result);

            return result;
        }

        // Type-Declaration

        public Instruction TypeVoid(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeVoid);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeBool(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeBool);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeInt(LiteralInteger width, LiteralInteger signedness, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeInt);

            result.AddOperand(width);
            result.AddOperand(signedness);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeFloat(LiteralInteger width, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeFloat);

            result.AddOperand(width);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeVector(Instruction componentType, LiteralInteger componentCount, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeVector);

            result.AddOperand(componentType);
            result.AddOperand(componentCount);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeMatrix(Instruction columnType, LiteralInteger columnCount, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeMatrix);

            result.AddOperand(columnType);
            result.AddOperand(columnCount);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeImage(Instruction sampledType, Dim dim, LiteralInteger depth, LiteralInteger arrayed, LiteralInteger mS, LiteralInteger sampled, ImageFormat imageFormat, AccessQualifier accessQualifier = (AccessQualifier)int.MaxValue, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeImage);

            result.AddOperand(sampledType);
            result.AddOperand(dim);
            result.AddOperand(depth);
            result.AddOperand(arrayed);
            result.AddOperand(mS);
            result.AddOperand(sampled);
            result.AddOperand(imageFormat);
            if (accessQualifier != (AccessQualifier)int.MaxValue)
            {
                result.AddOperand(accessQualifier);
            }
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeSampler(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeSampler);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeSampledImage(Instruction imageType, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeSampledImage);

            result.AddOperand(imageType);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeArray(Instruction elementType, Instruction length, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeArray);

            result.AddOperand(elementType);
            result.AddOperand(length);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeRuntimeArray(Instruction elementType, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeRuntimeArray);

            result.AddOperand(elementType);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeStruct(bool forceIdAllocation, params Instruction[] parameters)
        {
            Instruction result = NewInstruction(Op.OpTypeStruct);

            result.AddOperand(parameters);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeOpaque(string thenameoftheopaquetype, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeOpaque);

            result.AddOperand(thenameoftheopaquetype);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypePointer(StorageClass storageClass, Instruction type, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypePointer);

            result.AddOperand(storageClass);
            result.AddOperand(type);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeFunction(Instruction returnType, bool forceIdAllocation, params Instruction[] parameters)
        {
            Instruction result = NewInstruction(Op.OpTypeFunction);

            result.AddOperand(returnType);
            result.AddOperand(parameters);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeEvent(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeEvent);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeDeviceEvent(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeDeviceEvent);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeReserveId(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeReserveId);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeQueue(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeQueue);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypePipe(AccessQualifier qualifier, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypePipe);

            result.AddOperand(qualifier);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeForwardPointer(Instruction pointerType, StorageClass storageClass, bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeForwardPointer);

            result.AddOperand(pointerType);
            result.AddOperand(storageClass);
            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypePipeStorage(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypePipeStorage);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        public Instruction TypeNamedBarrier(bool forceIdAllocation = false)
        {
            Instruction result = NewInstruction(Op.OpTypeNamedBarrier);

            AddTypeDeclaration(result, forceIdAllocation);

            return result;
        }

        // Constant-Creation

        public Instruction ConstantTrue(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpConstantTrue, Instruction.InvalidId, resultType);

            AddConstant(result);

            return result;
        }

        public Instruction ConstantFalse(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpConstantFalse, Instruction.InvalidId, resultType);

            AddConstant(result);

            return result;
        }

        public Instruction Constant(Instruction resultType, LiteralInteger value)
        {
            Instruction result = NewInstruction(Op.OpConstant, Instruction.InvalidId, resultType);

            result.AddOperand(value);
            AddConstant(result);

            return result;
        }

        public Instruction ConstantComposite(Instruction resultType, params Instruction[] constituents)
        {
            Instruction result = NewInstruction(Op.OpConstantComposite, Instruction.InvalidId, resultType);

            result.AddOperand(constituents);
            AddConstant(result);

            return result;
        }

        public Instruction ConstantSampler(Instruction resultType, SamplerAddressingMode samplerAddressingMode, LiteralInteger param, SamplerFilterMode samplerFilterMode)
        {
            Instruction result = NewInstruction(Op.OpConstantSampler, Instruction.InvalidId, resultType);

            result.AddOperand(samplerAddressingMode);
            result.AddOperand(param);
            result.AddOperand(samplerFilterMode);
            AddConstant(result);

            return result;
        }

        public Instruction ConstantNull(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpConstantNull, Instruction.InvalidId, resultType);

            AddConstant(result);

            return result;
        }

        public Instruction SpecConstantTrue(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpSpecConstantTrue, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SpecConstantFalse(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpSpecConstantFalse, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SpecConstant(Instruction resultType, LiteralInteger value)
        {
            Instruction result = NewInstruction(Op.OpSpecConstant, GetNewId(), resultType);

            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SpecConstantComposite(Instruction resultType, params Instruction[] constituents)
        {
            Instruction result = NewInstruction(Op.OpSpecConstantComposite, GetNewId(), resultType);

            result.AddOperand(constituents);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SpecConstantOp(Instruction resultType, LiteralInteger opcode)
        {
            Instruction result = NewInstruction(Op.OpSpecConstantOp, GetNewId(), resultType);

            result.AddOperand(opcode);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Memory

        public Instruction Variable(Instruction resultType, StorageClass storageClass, Instruction initializer = null)
        {
            Instruction result = NewInstruction(Op.OpVariable, GetNewId(), resultType);

            result.AddOperand(storageClass);
            if (initializer != null)
            {
                result.AddOperand(initializer);
            }
            return result;
        }

        public Instruction ImageTexelPointer(Instruction resultType, Instruction image, Instruction coordinate, Instruction sample)
        {
            Instruction result = NewInstruction(Op.OpImageTexelPointer, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(sample);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Load(Instruction resultType, Instruction pointer, MemoryAccessMask memoryAccess = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpLoad, GetNewId(), resultType);

            result.AddOperand(pointer);
            if (memoryAccess != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Store(Instruction pointer, Instruction obj, MemoryAccessMask memoryAccess = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpStore);

            result.AddOperand(pointer);
            result.AddOperand(obj);
            if (memoryAccess != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CopyMemory(Instruction target, Instruction source, MemoryAccessMask memoryAccess0 = (MemoryAccessMask)int.MaxValue, MemoryAccessMask memoryAccess1 = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpCopyMemory);

            result.AddOperand(target);
            result.AddOperand(source);
            if (memoryAccess0 != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess0);
            }
            if (memoryAccess1 != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess1);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CopyMemorySized(Instruction target, Instruction source, Instruction size, MemoryAccessMask memoryAccess0 = (MemoryAccessMask)int.MaxValue, MemoryAccessMask memoryAccess1 = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpCopyMemorySized);

            result.AddOperand(target);
            result.AddOperand(source);
            result.AddOperand(size);
            if (memoryAccess0 != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess0);
            }
            if (memoryAccess1 != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess1);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AccessChain(Instruction resultType, Instruction baseObj, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AccessChain(Instruction resultType, Instruction baseObj, Instruction index0, Instruction index1)
        {
            Instruction result = NewInstruction(Op.OpAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(index0);
            result.AddOperand(index1);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AccessChain(Instruction resultType, Instruction baseObj, Instruction index0, Instruction index1, Instruction index2)
        {
            Instruction result = NewInstruction(Op.OpAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(index0);
            result.AddOperand(index1);
            result.AddOperand(index2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AccessChain(Instruction resultType, Instruction baseObj, params Instruction[] indexes)
        {
            Instruction result = NewInstruction(Op.OpAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction InBoundsAccessChain(Instruction resultType, Instruction baseObj, params Instruction[] indexes)
        {
            Instruction result = NewInstruction(Op.OpInBoundsAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction PtrAccessChain(Instruction resultType, Instruction baseObj, Instruction element, params Instruction[] indexes)
        {
            Instruction result = NewInstruction(Op.OpPtrAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(element);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ArrayLength(Instruction resultType, Instruction structure, LiteralInteger arraymember)
        {
            Instruction result = NewInstruction(Op.OpArrayLength, GetNewId(), resultType);

            result.AddOperand(structure);
            result.AddOperand(arraymember);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GenericPtrMemSemantics(Instruction resultType, Instruction pointer)
        {
            Instruction result = NewInstruction(Op.OpGenericPtrMemSemantics, GetNewId(), resultType);

            result.AddOperand(pointer);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction InBoundsPtrAccessChain(Instruction resultType, Instruction baseObj, Instruction element, params Instruction[] indexes)
        {
            Instruction result = NewInstruction(Op.OpInBoundsPtrAccessChain, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(element);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction PtrEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpPtrEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction PtrNotEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpPtrNotEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction PtrDiff(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpPtrDiff, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Function

        public Instruction Function(Instruction resultType, FunctionControlMask functionControl, Instruction functionType)
        {
            Instruction result = NewInstruction(Op.OpFunction, GetNewId(), resultType);

            result.AddOperand(functionControl);
            result.AddOperand(functionType);

            return result;
        }

        public void AddFunction(Instruction function)
        {
            AddToFunctionDefinitions(function);
        }

        public Instruction FunctionParameter(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpFunctionParameter, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FunctionEnd()
        {
            Instruction result = NewInstruction(Op.OpFunctionEnd);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FunctionCall(Instruction resultType, Instruction function, params Instruction[] parameters)
        {
            Instruction result = NewInstruction(Op.OpFunctionCall, GetNewId(), resultType);

            result.AddOperand(function);
            result.AddOperand(parameters);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Image

        public Instruction SampledImage(Instruction resultType, Instruction image, Instruction sampler)
        {
            Instruction result = NewInstruction(Op.OpSampledImage, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(sampler);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleDrefImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleDrefImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleDrefExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleDrefExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleProjImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleProjImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleProjExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleProjExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleProjDrefImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleProjDrefImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleProjDrefExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleProjDrefExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageFetch(Instruction resultType, Instruction image, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageFetch, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageGather(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction component, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageGather, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(component);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageDrefGather(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageDrefGather, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageRead(Instruction resultType, Instruction image, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageRead, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageWrite(Instruction image, Instruction coordinate, Instruction texel, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageWrite);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(texel);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Image(Instruction resultType, Instruction sampledImage)
        {
            Instruction result = NewInstruction(Op.OpImage, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQueryFormat(Instruction resultType, Instruction image)
        {
            Instruction result = NewInstruction(Op.OpImageQueryFormat, GetNewId(), resultType);

            result.AddOperand(image);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQueryOrder(Instruction resultType, Instruction image)
        {
            Instruction result = NewInstruction(Op.OpImageQueryOrder, GetNewId(), resultType);

            result.AddOperand(image);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQuerySizeLod(Instruction resultType, Instruction image, Instruction levelofDetail)
        {
            Instruction result = NewInstruction(Op.OpImageQuerySizeLod, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(levelofDetail);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQuerySize(Instruction resultType, Instruction image)
        {
            Instruction result = NewInstruction(Op.OpImageQuerySize, GetNewId(), resultType);

            result.AddOperand(image);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQueryLod(Instruction resultType, Instruction sampledImage, Instruction coordinate)
        {
            Instruction result = NewInstruction(Op.OpImageQueryLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQueryLevels(Instruction resultType, Instruction image)
        {
            Instruction result = NewInstruction(Op.OpImageQueryLevels, GetNewId(), resultType);

            result.AddOperand(image);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageQuerySamples(Instruction resultType, Instruction image)
        {
            Instruction result = NewInstruction(Op.OpImageQuerySamples, GetNewId(), resultType);

            result.AddOperand(image);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleDrefImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleDrefImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleDrefExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleDrefExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleProjImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleProjImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleProjExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleProjExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleProjDrefImplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleProjDrefImplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseSampleProjDrefExplicitLod(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseSampleProjDrefExplicitLod, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            result.AddOperand(imageOperands);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseFetch(Instruction resultType, Instruction image, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseFetch, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseGather(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction component, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseGather, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(component);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseDrefGather(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction dRef, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseDrefGather, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(dRef);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseTexelsResident(Instruction resultType, Instruction residentCode)
        {
            Instruction result = NewInstruction(Op.OpImageSparseTexelsResident, GetNewId(), resultType);

            result.AddOperand(residentCode);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSparseRead(Instruction resultType, Instruction image, Instruction coordinate, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSparseRead, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ImageSampleFootprintNV(Instruction resultType, Instruction sampledImage, Instruction coordinate, Instruction granularity, Instruction coarse, ImageOperandsMask imageOperands, params Instruction[] imageOperandIds)
        {
            Instruction result = NewInstruction(Op.OpImageSampleFootprintNV, GetNewId(), resultType);

            result.AddOperand(sampledImage);
            result.AddOperand(coordinate);
            result.AddOperand(granularity);
            result.AddOperand(coarse);
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperands);
            }
            if (imageOperands != (ImageOperandsMask)int.MaxValue)
            {
                result.AddOperand(imageOperandIds);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        // Conversion

        public Instruction ConvertFToU(Instruction resultType, Instruction floatValue)
        {
            Instruction result = NewInstruction(Op.OpConvertFToU, GetNewId(), resultType);

            result.AddOperand(floatValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertFToS(Instruction resultType, Instruction floatValue)
        {
            Instruction result = NewInstruction(Op.OpConvertFToS, GetNewId(), resultType);

            result.AddOperand(floatValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertSToF(Instruction resultType, Instruction signedValue)
        {
            Instruction result = NewInstruction(Op.OpConvertSToF, GetNewId(), resultType);

            result.AddOperand(signedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertUToF(Instruction resultType, Instruction unsignedValue)
        {
            Instruction result = NewInstruction(Op.OpConvertUToF, GetNewId(), resultType);

            result.AddOperand(unsignedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UConvert(Instruction resultType, Instruction unsignedValue)
        {
            Instruction result = NewInstruction(Op.OpUConvert, GetNewId(), resultType);

            result.AddOperand(unsignedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SConvert(Instruction resultType, Instruction signedValue)
        {
            Instruction result = NewInstruction(Op.OpSConvert, GetNewId(), resultType);

            result.AddOperand(signedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FConvert(Instruction resultType, Instruction floatValue)
        {
            Instruction result = NewInstruction(Op.OpFConvert, GetNewId(), resultType);

            result.AddOperand(floatValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction QuantizeToF16(Instruction resultType, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpQuantizeToF16, GetNewId(), resultType);

            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertPtrToU(Instruction resultType, Instruction pointer)
        {
            Instruction result = NewInstruction(Op.OpConvertPtrToU, GetNewId(), resultType);

            result.AddOperand(pointer);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SatConvertSToU(Instruction resultType, Instruction signedValue)
        {
            Instruction result = NewInstruction(Op.OpSatConvertSToU, GetNewId(), resultType);

            result.AddOperand(signedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SatConvertUToS(Instruction resultType, Instruction unsignedValue)
        {
            Instruction result = NewInstruction(Op.OpSatConvertUToS, GetNewId(), resultType);

            result.AddOperand(unsignedValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertUToPtr(Instruction resultType, Instruction integerValue)
        {
            Instruction result = NewInstruction(Op.OpConvertUToPtr, GetNewId(), resultType);

            result.AddOperand(integerValue);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction PtrCastToGeneric(Instruction resultType, Instruction pointer)
        {
            Instruction result = NewInstruction(Op.OpPtrCastToGeneric, GetNewId(), resultType);

            result.AddOperand(pointer);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GenericCastToPtr(Instruction resultType, Instruction pointer)
        {
            Instruction result = NewInstruction(Op.OpGenericCastToPtr, GetNewId(), resultType);

            result.AddOperand(pointer);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GenericCastToPtrExplicit(Instruction resultType, Instruction pointer, StorageClass storage)
        {
            Instruction result = NewInstruction(Op.OpGenericCastToPtrExplicit, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(storage);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Bitcast(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpBitcast, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Composite

        public Instruction VectorExtractDynamic(Instruction resultType, Instruction vector, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpVectorExtractDynamic, GetNewId(), resultType);

            result.AddOperand(vector);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction VectorInsertDynamic(Instruction resultType, Instruction vector, Instruction component, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpVectorInsertDynamic, GetNewId(), resultType);

            result.AddOperand(vector);
            result.AddOperand(component);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction VectorShuffle(Instruction resultType, Instruction vector1, Instruction vector2, params LiteralInteger[] components)
        {
            Instruction result = NewInstruction(Op.OpVectorShuffle, GetNewId(), resultType);

            result.AddOperand(vector1);
            result.AddOperand(vector2);
            result.AddOperand(components);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CompositeConstruct(Instruction resultType, params Instruction[] constituents)
        {
            Instruction result = NewInstruction(Op.OpCompositeConstruct, GetNewId(), resultType);

            result.AddOperand(constituents);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CompositeExtract(Instruction resultType, Instruction composite, params LiteralInteger[] indexes)
        {
            Instruction result = NewInstruction(Op.OpCompositeExtract, GetNewId(), resultType);

            result.AddOperand(composite);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CompositeInsert(Instruction resultType, Instruction obj, Instruction composite, params LiteralInteger[] indexes)
        {
            Instruction result = NewInstruction(Op.OpCompositeInsert, GetNewId(), resultType);

            result.AddOperand(obj);
            result.AddOperand(composite);
            result.AddOperand(indexes);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CopyObject(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpCopyObject, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Transpose(Instruction resultType, Instruction matrix)
        {
            Instruction result = NewInstruction(Op.OpTranspose, GetNewId(), resultType);

            result.AddOperand(matrix);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CopyLogical(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpCopyLogical, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Arithmetic

        public Instruction SNegate(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpSNegate, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FNegate(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpFNegate, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IAdd(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIAdd, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FAdd(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFAdd, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ISub(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpISub, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FSub(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFSub, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IMul(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIMul, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FMul(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFMul, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UDiv(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUDiv, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SDiv(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSDiv, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FDiv(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFDiv, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UMod(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUMod, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SRem(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSRem, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SMod(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSMod, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FRem(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFRem, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FMod(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFMod, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction VectorTimesScalar(Instruction resultType, Instruction vector, Instruction scalar)
        {
            Instruction result = NewInstruction(Op.OpVectorTimesScalar, GetNewId(), resultType);

            result.AddOperand(vector);
            result.AddOperand(scalar);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction MatrixTimesScalar(Instruction resultType, Instruction matrix, Instruction scalar)
        {
            Instruction result = NewInstruction(Op.OpMatrixTimesScalar, GetNewId(), resultType);

            result.AddOperand(matrix);
            result.AddOperand(scalar);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction VectorTimesMatrix(Instruction resultType, Instruction vector, Instruction matrix)
        {
            Instruction result = NewInstruction(Op.OpVectorTimesMatrix, GetNewId(), resultType);

            result.AddOperand(vector);
            result.AddOperand(matrix);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction MatrixTimesVector(Instruction resultType, Instruction matrix, Instruction vector)
        {
            Instruction result = NewInstruction(Op.OpMatrixTimesVector, GetNewId(), resultType);

            result.AddOperand(matrix);
            result.AddOperand(vector);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction MatrixTimesMatrix(Instruction resultType, Instruction leftMatrix, Instruction rightMatrix)
        {
            Instruction result = NewInstruction(Op.OpMatrixTimesMatrix, GetNewId(), resultType);

            result.AddOperand(leftMatrix);
            result.AddOperand(rightMatrix);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction OuterProduct(Instruction resultType, Instruction vector1, Instruction vector2)
        {
            Instruction result = NewInstruction(Op.OpOuterProduct, GetNewId(), resultType);

            result.AddOperand(vector1);
            result.AddOperand(vector2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Dot(Instruction resultType, Instruction vector1, Instruction vector2)
        {
            Instruction result = NewInstruction(Op.OpDot, GetNewId(), resultType);

            result.AddOperand(vector1);
            result.AddOperand(vector2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IAddCarry(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIAddCarry, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ISubBorrow(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpISubBorrow, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UMulExtended(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUMulExtended, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SMulExtended(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSMulExtended, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Bit

        public Instruction ShiftRightLogical(Instruction resultType, Instruction baseObj, Instruction shift)
        {
            Instruction result = NewInstruction(Op.OpShiftRightLogical, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(shift);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ShiftRightArithmetic(Instruction resultType, Instruction baseObj, Instruction shift)
        {
            Instruction result = NewInstruction(Op.OpShiftRightArithmetic, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(shift);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ShiftLeftLogical(Instruction resultType, Instruction baseObj, Instruction shift)
        {
            Instruction result = NewInstruction(Op.OpShiftLeftLogical, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(shift);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitwiseOr(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpBitwiseOr, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitwiseXor(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpBitwiseXor, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitwiseAnd(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpBitwiseAnd, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Not(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpNot, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitFieldInsert(Instruction resultType, Instruction baseObj, Instruction insert, Instruction offset, Instruction count)
        {
            Instruction result = NewInstruction(Op.OpBitFieldInsert, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(insert);
            result.AddOperand(offset);
            result.AddOperand(count);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitFieldSExtract(Instruction resultType, Instruction baseObj, Instruction offset, Instruction count)
        {
            Instruction result = NewInstruction(Op.OpBitFieldSExtract, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(offset);
            result.AddOperand(count);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitFieldUExtract(Instruction resultType, Instruction baseObj, Instruction offset, Instruction count)
        {
            Instruction result = NewInstruction(Op.OpBitFieldUExtract, GetNewId(), resultType);

            result.AddOperand(baseObj);
            result.AddOperand(offset);
            result.AddOperand(count);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitReverse(Instruction resultType, Instruction baseObj)
        {
            Instruction result = NewInstruction(Op.OpBitReverse, GetNewId(), resultType);

            result.AddOperand(baseObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BitCount(Instruction resultType, Instruction baseObj)
        {
            Instruction result = NewInstruction(Op.OpBitCount, GetNewId(), resultType);

            result.AddOperand(baseObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Relational_and_Logical

        public Instruction Any(Instruction resultType, Instruction vector)
        {
            Instruction result = NewInstruction(Op.OpAny, GetNewId(), resultType);

            result.AddOperand(vector);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction All(Instruction resultType, Instruction vector)
        {
            Instruction result = NewInstruction(Op.OpAll, GetNewId(), resultType);

            result.AddOperand(vector);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsNan(Instruction resultType, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpIsNan, GetNewId(), resultType);

            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsInf(Instruction resultType, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpIsInf, GetNewId(), resultType);

            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsFinite(Instruction resultType, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpIsFinite, GetNewId(), resultType);

            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsNormal(Instruction resultType, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpIsNormal, GetNewId(), resultType);

            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SignBitSet(Instruction resultType, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpSignBitSet, GetNewId(), resultType);

            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LessOrGreater(Instruction resultType, Instruction x, Instruction y)
        {
            Instruction result = NewInstruction(Op.OpLessOrGreater, GetNewId(), resultType);

            result.AddOperand(x);
            result.AddOperand(y);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Ordered(Instruction resultType, Instruction x, Instruction y)
        {
            Instruction result = NewInstruction(Op.OpOrdered, GetNewId(), resultType);

            result.AddOperand(x);
            result.AddOperand(y);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Unordered(Instruction resultType, Instruction x, Instruction y)
        {
            Instruction result = NewInstruction(Op.OpUnordered, GetNewId(), resultType);

            result.AddOperand(x);
            result.AddOperand(y);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LogicalEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpLogicalEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LogicalNotEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpLogicalNotEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LogicalOr(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpLogicalOr, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LogicalAnd(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpLogicalAnd, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LogicalNot(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpLogicalNot, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Select(Instruction resultType, Instruction condition, Instruction object1, Instruction object2)
        {
            Instruction result = NewInstruction(Op.OpSelect, GetNewId(), resultType);

            result.AddOperand(condition);
            result.AddOperand(object1);
            result.AddOperand(object2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction INotEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpINotEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UGreaterThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUGreaterThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SGreaterThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSGreaterThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UGreaterThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUGreaterThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SGreaterThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSGreaterThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ULessThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpULessThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SLessThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSLessThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ULessThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpULessThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SLessThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpSLessThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdNotEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdNotEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordNotEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordNotEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdLessThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdLessThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordLessThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordLessThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdGreaterThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdGreaterThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordGreaterThan(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordGreaterThan, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdLessThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdLessThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordLessThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordLessThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FOrdGreaterThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFOrdGreaterThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FUnordGreaterThanEqual(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpFUnordGreaterThanEqual, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Derivative

        public Instruction DPdx(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdx, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DPdy(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdy, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Fwidth(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpFwidth, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DPdxFine(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdxFine, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DPdyFine(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdyFine, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FwidthFine(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpFwidthFine, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DPdxCoarse(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdxCoarse, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DPdyCoarse(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpDPdyCoarse, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FwidthCoarse(Instruction resultType, Instruction p)
        {
            Instruction result = NewInstruction(Op.OpFwidthCoarse, GetNewId(), resultType);

            result.AddOperand(p);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Control-Flow

        public Instruction Phi(Instruction resultType, params Instruction[] parameters)
        {
            Instruction result = NewInstruction(Op.OpPhi, GetNewId(), resultType);

            result.AddOperand(parameters);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LoopMerge(Instruction mergeBlock, Instruction continueTarget, LoopControlMask loopControl)
        {
            Instruction result = NewInstruction(Op.OpLoopMerge);

            result.AddOperand(mergeBlock);
            result.AddOperand(continueTarget);
            result.AddOperand(loopControl);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SelectionMerge(Instruction mergeBlock, SelectionControlMask selectionControl)
        {
            Instruction result = NewInstruction(Op.OpSelectionMerge);

            result.AddOperand(mergeBlock);
            result.AddOperand(selectionControl);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Label()
        {
            Instruction result = NewInstruction(Op.OpLabel);

            return result;
        }

        public Instruction Branch(Instruction targetLabel)
        {
            Instruction result = NewInstruction(Op.OpBranch);

            result.AddOperand(targetLabel);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BranchConditional(Instruction condition, Instruction trueLabel, Instruction falseLabel, params LiteralInteger[] branchweights)
        {
            Instruction result = NewInstruction(Op.OpBranchConditional);

            result.AddOperand(condition);
            result.AddOperand(trueLabel);
            result.AddOperand(falseLabel);
            result.AddOperand(branchweights);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Switch(Instruction selector, Instruction defaultObj, params IOperand[] target)
        {
            Instruction result = NewInstruction(Op.OpSwitch);

            result.AddOperand(selector);
            result.AddOperand(defaultObj);
            result.AddOperand(target);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Kill()
        {
            Instruction result = NewInstruction(Op.OpKill);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Return()
        {
            Instruction result = NewInstruction(Op.OpReturn);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReturnValue(Instruction value)
        {
            Instruction result = NewInstruction(Op.OpReturnValue);

            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction Unreachable()
        {
            Instruction result = NewInstruction(Op.OpUnreachable);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LifetimeStart(Instruction pointer, LiteralInteger size)
        {
            Instruction result = NewInstruction(Op.OpLifetimeStart);

            result.AddOperand(pointer);
            result.AddOperand(size);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LifetimeStop(Instruction pointer, LiteralInteger size)
        {
            Instruction result = NewInstruction(Op.OpLifetimeStop);

            result.AddOperand(pointer);
            result.AddOperand(size);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TerminateInvocation()
        {
            Instruction result = NewInstruction(Op.OpTerminateInvocation);

            AddToFunctionDefinitions(result);

            return result;
        }

        // Atomic

        public Instruction AtomicLoad(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpAtomicLoad, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicStore(Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicStore);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicExchange(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicExchange, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicCompareExchange(Instruction resultType, Instruction pointer, Instruction memory, Instruction equal, Instruction unequal, Instruction value, Instruction comparator)
        {
            Instruction result = NewInstruction(Op.OpAtomicCompareExchange, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(equal);
            result.AddOperand(unequal);
            result.AddOperand(value);
            result.AddOperand(comparator);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicCompareExchangeWeak(Instruction resultType, Instruction pointer, Instruction memory, Instruction equal, Instruction unequal, Instruction value, Instruction comparator)
        {
            Instruction result = NewInstruction(Op.OpAtomicCompareExchangeWeak, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(equal);
            result.AddOperand(unequal);
            result.AddOperand(value);
            result.AddOperand(comparator);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicIIncrement(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpAtomicIIncrement, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicIDecrement(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpAtomicIDecrement, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicIAdd(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicIAdd, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicISub(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicISub, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicSMin(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicSMin, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicUMin(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicUMin, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicSMax(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicSMax, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicUMax(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicUMax, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicAnd(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicAnd, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicOr(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicOr, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicXor(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicXor, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicFlagTestAndSet(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpAtomicFlagTestAndSet, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicFlagClear(Instruction pointer, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpAtomicFlagClear);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AtomicFAddEXT(Instruction resultType, Instruction pointer, Instruction memory, Instruction semantics, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpAtomicFAddEXT, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Primitive

        public Instruction EmitVertex()
        {
            Instruction result = NewInstruction(Op.OpEmitVertex);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction EndPrimitive()
        {
            Instruction result = NewInstruction(Op.OpEndPrimitive);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction EmitStreamVertex(Instruction stream)
        {
            Instruction result = NewInstruction(Op.OpEmitStreamVertex);

            result.AddOperand(stream);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction EndStreamPrimitive(Instruction stream)
        {
            Instruction result = NewInstruction(Op.OpEndStreamPrimitive);

            result.AddOperand(stream);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Barrier

        public Instruction ControlBarrier(Instruction execution, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpControlBarrier);

            result.AddOperand(execution);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction MemoryBarrier(Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpMemoryBarrier);

            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction NamedBarrierInitialize(Instruction resultType, Instruction subgroupCount)
        {
            Instruction result = NewInstruction(Op.OpNamedBarrierInitialize, GetNewId(), resultType);

            result.AddOperand(subgroupCount);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction MemoryNamedBarrier(Instruction namedBarrier, Instruction memory, Instruction semantics)
        {
            Instruction result = NewInstruction(Op.OpMemoryNamedBarrier);

            result.AddOperand(namedBarrier);
            result.AddOperand(memory);
            result.AddOperand(semantics);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Group

        public Instruction GroupAsyncCopy(Instruction resultType, Instruction execution, Instruction destination, Instruction source, Instruction numElements, Instruction stride, Instruction eventObj)
        {
            Instruction result = NewInstruction(Op.OpGroupAsyncCopy, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(destination);
            result.AddOperand(source);
            result.AddOperand(numElements);
            result.AddOperand(stride);
            result.AddOperand(eventObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupWaitEvents(Instruction execution, Instruction numEvents, Instruction eventsList)
        {
            Instruction result = NewInstruction(Op.OpGroupWaitEvents);

            result.AddOperand(execution);
            result.AddOperand(numEvents);
            result.AddOperand(eventsList);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupAll(Instruction resultType, Instruction execution, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpGroupAll, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupAny(Instruction resultType, Instruction execution, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpGroupAny, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupBroadcast(Instruction resultType, Instruction execution, Instruction value, Instruction localId)
        {
            Instruction result = NewInstruction(Op.OpGroupBroadcast, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(localId);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupIAdd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupIAdd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFAdd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFAdd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupUMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupUMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupSMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupSMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupUMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupUMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupSMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupSMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupBallotKHR(Instruction resultType, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpSubgroupBallotKHR, GetNewId(), resultType);

            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupFirstInvocationKHR(Instruction resultType, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpSubgroupFirstInvocationKHR, GetNewId(), resultType);

            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupAllKHR(Instruction resultType, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpSubgroupAllKHR, GetNewId(), resultType);

            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupAnyKHR(Instruction resultType, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpSubgroupAnyKHR, GetNewId(), resultType);

            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupAllEqualKHR(Instruction resultType, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpSubgroupAllEqualKHR, GetNewId(), resultType);

            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupReadInvocationKHR(Instruction resultType, Instruction value, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpSubgroupReadInvocationKHR, GetNewId(), resultType);

            result.AddOperand(value);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupIAddNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupIAddNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFAddNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFAddNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFMinNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFMinNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupUMinNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupUMinNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupSMinNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupSMinNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupFMaxNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupFMaxNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupUMaxNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupUMaxNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupSMaxNonUniformAMD(Instruction resultType, Instruction execution, GroupOperation operation, Instruction x)
        {
            Instruction result = NewInstruction(Op.OpGroupSMaxNonUniformAMD, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(x);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupShuffleINTEL(Instruction resultType, Instruction data, Instruction invocationId)
        {
            Instruction result = NewInstruction(Op.OpSubgroupShuffleINTEL, GetNewId(), resultType);

            result.AddOperand(data);
            result.AddOperand(invocationId);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupShuffleDownINTEL(Instruction resultType, Instruction current, Instruction next, Instruction delta)
        {
            Instruction result = NewInstruction(Op.OpSubgroupShuffleDownINTEL, GetNewId(), resultType);

            result.AddOperand(current);
            result.AddOperand(next);
            result.AddOperand(delta);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupShuffleUpINTEL(Instruction resultType, Instruction previous, Instruction current, Instruction delta)
        {
            Instruction result = NewInstruction(Op.OpSubgroupShuffleUpINTEL, GetNewId(), resultType);

            result.AddOperand(previous);
            result.AddOperand(current);
            result.AddOperand(delta);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupShuffleXorINTEL(Instruction resultType, Instruction data, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpSubgroupShuffleXorINTEL, GetNewId(), resultType);

            result.AddOperand(data);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupBlockReadINTEL(Instruction resultType, Instruction ptr)
        {
            Instruction result = NewInstruction(Op.OpSubgroupBlockReadINTEL, GetNewId(), resultType);

            result.AddOperand(ptr);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupBlockWriteINTEL(Instruction ptr, Instruction data)
        {
            Instruction result = NewInstruction(Op.OpSubgroupBlockWriteINTEL);

            result.AddOperand(ptr);
            result.AddOperand(data);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupImageBlockReadINTEL(Instruction resultType, Instruction image, Instruction coordinate)
        {
            Instruction result = NewInstruction(Op.OpSubgroupImageBlockReadINTEL, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupImageBlockWriteINTEL(Instruction image, Instruction coordinate, Instruction data)
        {
            Instruction result = NewInstruction(Op.OpSubgroupImageBlockWriteINTEL);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(data);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupImageMediaBlockReadINTEL(Instruction resultType, Instruction image, Instruction coordinate, Instruction width, Instruction height)
        {
            Instruction result = NewInstruction(Op.OpSubgroupImageMediaBlockReadINTEL, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(width);
            result.AddOperand(height);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SubgroupImageMediaBlockWriteINTEL(Instruction image, Instruction coordinate, Instruction width, Instruction height, Instruction data)
        {
            Instruction result = NewInstruction(Op.OpSubgroupImageMediaBlockWriteINTEL);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(width);
            result.AddOperand(height);
            result.AddOperand(data);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Device-Side_Enqueue

        public Instruction EnqueueMarker(Instruction resultType, Instruction queue, Instruction numEvents, Instruction waitEvents, Instruction retEvent)
        {
            Instruction result = NewInstruction(Op.OpEnqueueMarker, GetNewId(), resultType);

            result.AddOperand(queue);
            result.AddOperand(numEvents);
            result.AddOperand(waitEvents);
            result.AddOperand(retEvent);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction EnqueueKernel(Instruction resultType, Instruction queue, Instruction flags, Instruction nDRange, Instruction numEvents, Instruction waitEvents, Instruction retEvent, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign, params Instruction[] localSize)
        {
            Instruction result = NewInstruction(Op.OpEnqueueKernel, GetNewId(), resultType);

            result.AddOperand(queue);
            result.AddOperand(flags);
            result.AddOperand(nDRange);
            result.AddOperand(numEvents);
            result.AddOperand(waitEvents);
            result.AddOperand(retEvent);
            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            result.AddOperand(localSize);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelNDrangeSubGroupCount(Instruction resultType, Instruction nDRange, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelNDrangeSubGroupCount, GetNewId(), resultType);

            result.AddOperand(nDRange);
            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelNDrangeMaxSubGroupSize(Instruction resultType, Instruction nDRange, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelNDrangeMaxSubGroupSize, GetNewId(), resultType);

            result.AddOperand(nDRange);
            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelWorkGroupSize(Instruction resultType, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelWorkGroupSize, GetNewId(), resultType);

            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelPreferredWorkGroupSizeMultiple(Instruction resultType, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelPreferredWorkGroupSizeMultiple, GetNewId(), resultType);

            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RetainEvent(Instruction eventObj)
        {
            Instruction result = NewInstruction(Op.OpRetainEvent);

            result.AddOperand(eventObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReleaseEvent(Instruction eventObj)
        {
            Instruction result = NewInstruction(Op.OpReleaseEvent);

            result.AddOperand(eventObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CreateUserEvent(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpCreateUserEvent, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsValidEvent(Instruction resultType, Instruction eventObj)
        {
            Instruction result = NewInstruction(Op.OpIsValidEvent, GetNewId(), resultType);

            result.AddOperand(eventObj);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction SetUserEventStatus(Instruction eventObj, Instruction status)
        {
            Instruction result = NewInstruction(Op.OpSetUserEventStatus);

            result.AddOperand(eventObj);
            result.AddOperand(status);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CaptureEventProfilingInfo(Instruction eventObj, Instruction profilingInfo, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpCaptureEventProfilingInfo);

            result.AddOperand(eventObj);
            result.AddOperand(profilingInfo);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetDefaultQueue(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpGetDefaultQueue, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BuildNDRange(Instruction resultType, Instruction globalWorkSize, Instruction localWorkSize, Instruction globalWorkOffset)
        {
            Instruction result = NewInstruction(Op.OpBuildNDRange, GetNewId(), resultType);

            result.AddOperand(globalWorkSize);
            result.AddOperand(localWorkSize);
            result.AddOperand(globalWorkOffset);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelLocalSizeForSubgroupCount(Instruction resultType, Instruction subgroupCount, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelLocalSizeForSubgroupCount, GetNewId(), resultType);

            result.AddOperand(subgroupCount);
            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetKernelMaxNumSubgroups(Instruction resultType, Instruction invoke, Instruction param, Instruction paramSize, Instruction paramAlign)
        {
            Instruction result = NewInstruction(Op.OpGetKernelMaxNumSubgroups, GetNewId(), resultType);

            result.AddOperand(invoke);
            result.AddOperand(param);
            result.AddOperand(paramSize);
            result.AddOperand(paramAlign);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Pipe

        public Instruction ReadPipe(Instruction resultType, Instruction pipe, Instruction pointer, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReadPipe, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(pointer);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction WritePipe(Instruction resultType, Instruction pipe, Instruction pointer, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpWritePipe, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(pointer);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReservedReadPipe(Instruction resultType, Instruction pipe, Instruction reserveId, Instruction index, Instruction pointer, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReservedReadPipe, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(index);
            result.AddOperand(pointer);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReservedWritePipe(Instruction resultType, Instruction pipe, Instruction reserveId, Instruction index, Instruction pointer, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReservedWritePipe, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(index);
            result.AddOperand(pointer);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReserveReadPipePackets(Instruction resultType, Instruction pipe, Instruction numPackets, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReserveReadPipePackets, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(numPackets);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReserveWritePipePackets(Instruction resultType, Instruction pipe, Instruction numPackets, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReserveWritePipePackets, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(numPackets);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CommitReadPipe(Instruction pipe, Instruction reserveId, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpCommitReadPipe);

            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CommitWritePipe(Instruction pipe, Instruction reserveId, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpCommitWritePipe);

            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsValidReserveId(Instruction resultType, Instruction reserveId)
        {
            Instruction result = NewInstruction(Op.OpIsValidReserveId, GetNewId(), resultType);

            result.AddOperand(reserveId);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetNumPipePackets(Instruction resultType, Instruction pipe, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGetNumPipePackets, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GetMaxPipePackets(Instruction resultType, Instruction pipe, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGetMaxPipePackets, GetNewId(), resultType);

            result.AddOperand(pipe);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupReserveReadPipePackets(Instruction resultType, Instruction execution, Instruction pipe, Instruction numPackets, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGroupReserveReadPipePackets, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(pipe);
            result.AddOperand(numPackets);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupReserveWritePipePackets(Instruction resultType, Instruction execution, Instruction pipe, Instruction numPackets, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGroupReserveWritePipePackets, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(pipe);
            result.AddOperand(numPackets);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupCommitReadPipe(Instruction execution, Instruction pipe, Instruction reserveId, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGroupCommitReadPipe);

            result.AddOperand(execution);
            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupCommitWritePipe(Instruction execution, Instruction pipe, Instruction reserveId, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpGroupCommitWritePipe);

            result.AddOperand(execution);
            result.AddOperand(pipe);
            result.AddOperand(reserveId);
            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConstantPipeStorage(Instruction resultType, LiteralInteger packetSize, LiteralInteger packetAlignment, LiteralInteger capacity)
        {
            Instruction result = NewInstruction(Op.OpConstantPipeStorage, GetNewId(), resultType);

            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            result.AddOperand(capacity);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CreatePipeFromPipeStorage(Instruction resultType, Instruction pipeStorage)
        {
            Instruction result = NewInstruction(Op.OpCreatePipeFromPipeStorage, GetNewId(), resultType);

            result.AddOperand(pipeStorage);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReadPipeBlockingINTEL(Instruction resultType, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpReadPipeBlockingINTEL, GetNewId(), resultType);

            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction WritePipeBlockingINTEL(Instruction resultType, Instruction packetSize, Instruction packetAlignment)
        {
            Instruction result = NewInstruction(Op.OpWritePipeBlockingINTEL, GetNewId(), resultType);

            result.AddOperand(packetSize);
            result.AddOperand(packetAlignment);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Non-Uniform

        public Instruction GroupNonUniformElect(Instruction resultType, Instruction execution)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformElect, GetNewId(), resultType);

            result.AddOperand(execution);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformAll(Instruction resultType, Instruction execution, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformAll, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformAny(Instruction resultType, Instruction execution, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformAny, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformAllEqual(Instruction resultType, Instruction execution, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformAllEqual, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBroadcast(Instruction resultType, Instruction execution, Instruction value, Instruction id)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBroadcast, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(id);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBroadcastFirst(Instruction resultType, Instruction execution, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBroadcastFirst, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBallot(Instruction resultType, Instruction execution, Instruction predicate)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBallot, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(predicate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformInverseBallot(Instruction resultType, Instruction execution, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformInverseBallot, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBallotBitExtract(Instruction resultType, Instruction execution, Instruction value, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBallotBitExtract, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBallotBitCount(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBallotBitCount, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBallotFindLSB(Instruction resultType, Instruction execution, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBallotFindLSB, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBallotFindMSB(Instruction resultType, Instruction execution, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBallotFindMSB, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformShuffle(Instruction resultType, Instruction execution, Instruction value, Instruction id)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformShuffle, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(id);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformShuffleXor(Instruction resultType, Instruction execution, Instruction value, Instruction mask)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformShuffleXor, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(mask);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformShuffleUp(Instruction resultType, Instruction execution, Instruction value, Instruction delta)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformShuffleUp, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(delta);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformShuffleDown(Instruction resultType, Instruction execution, Instruction value, Instruction delta)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformShuffleDown, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(delta);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformIAdd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformIAdd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformFAdd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformFAdd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformIMul(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformIMul, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformFMul(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformFMul, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformSMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformSMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformUMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformUMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformFMin(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformFMin, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformSMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformSMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformUMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformUMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformFMax(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformFMax, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBitwiseAnd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBitwiseAnd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBitwiseOr(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBitwiseOr, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformBitwiseXor(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformBitwiseXor, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformLogicalAnd(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformLogicalAnd, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformLogicalOr(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformLogicalOr, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformLogicalXor(Instruction resultType, Instruction execution, GroupOperation operation, Instruction value, Instruction clusterSize = null)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformLogicalXor, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(operation);
            result.AddOperand(value);
            if (clusterSize != null)
            {
                result.AddOperand(clusterSize);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformQuadBroadcast(Instruction resultType, Instruction execution, Instruction value, Instruction index)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformQuadBroadcast, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(index);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformQuadSwap(Instruction resultType, Instruction execution, Instruction value, Instruction direction)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformQuadSwap, GetNewId(), resultType);

            result.AddOperand(execution);
            result.AddOperand(value);
            result.AddOperand(direction);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction GroupNonUniformPartitionNV(Instruction resultType, Instruction value)
        {
            Instruction result = NewInstruction(Op.OpGroupNonUniformPartitionNV, GetNewId(), resultType);

            result.AddOperand(value);
            AddToFunctionDefinitions(result);

            return result;
        }

        // Reserved

        public Instruction TraceRayKHR(Instruction accel, Instruction rayFlags, Instruction cullMask, Instruction sBTOffset, Instruction sBTStride, Instruction missIndex, Instruction rayOrigin, Instruction rayTmin, Instruction rayDirection, Instruction rayTmax, Instruction payload)
        {
            Instruction result = NewInstruction(Op.OpTraceRayKHR);

            result.AddOperand(accel);
            result.AddOperand(rayFlags);
            result.AddOperand(cullMask);
            result.AddOperand(sBTOffset);
            result.AddOperand(sBTStride);
            result.AddOperand(missIndex);
            result.AddOperand(rayOrigin);
            result.AddOperand(rayTmin);
            result.AddOperand(rayDirection);
            result.AddOperand(rayTmax);
            result.AddOperand(payload);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ExecuteCallableKHR(Instruction sBTIndex, Instruction callableData)
        {
            Instruction result = NewInstruction(Op.OpExecuteCallableKHR);

            result.AddOperand(sBTIndex);
            result.AddOperand(callableData);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ConvertUToAccelerationStructureKHR(Instruction resultType, Instruction accel)
        {
            Instruction result = NewInstruction(Op.OpConvertUToAccelerationStructureKHR, GetNewId(), resultType);

            result.AddOperand(accel);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IgnoreIntersectionKHR()
        {
            Instruction result = NewInstruction(Op.OpIgnoreIntersectionKHR);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TerminateRayKHR()
        {
            Instruction result = NewInstruction(Op.OpTerminateRayKHR);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TypeRayQueryKHR()
        {
            Instruction result = NewInstruction(Op.OpTypeRayQueryKHR, GetNewId());

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryInitializeKHR(Instruction rayQuery, Instruction accel, Instruction rayFlags, Instruction cullMask, Instruction rayOrigin, Instruction rayTMin, Instruction rayDirection, Instruction rayTMax)
        {
            Instruction result = NewInstruction(Op.OpRayQueryInitializeKHR);

            result.AddOperand(rayQuery);
            result.AddOperand(accel);
            result.AddOperand(rayFlags);
            result.AddOperand(cullMask);
            result.AddOperand(rayOrigin);
            result.AddOperand(rayTMin);
            result.AddOperand(rayDirection);
            result.AddOperand(rayTMax);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryTerminateKHR(Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryTerminateKHR);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGenerateIntersectionKHR(Instruction rayQuery, Instruction hitT)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGenerateIntersectionKHR);

            result.AddOperand(rayQuery);
            result.AddOperand(hitT);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryConfirmIntersectionKHR(Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryConfirmIntersectionKHR);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryProceedKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryProceedKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionTypeKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionTypeKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FragmentMaskFetchAMD(Instruction resultType, Instruction image, Instruction coordinate)
        {
            Instruction result = NewInstruction(Op.OpFragmentMaskFetchAMD, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FragmentFetchAMD(Instruction resultType, Instruction image, Instruction coordinate, Instruction fragmentIndex)
        {
            Instruction result = NewInstruction(Op.OpFragmentFetchAMD, GetNewId(), resultType);

            result.AddOperand(image);
            result.AddOperand(coordinate);
            result.AddOperand(fragmentIndex);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReadClockKHR(Instruction resultType, Instruction execution)
        {
            Instruction result = NewInstruction(Op.OpReadClockKHR, GetNewId(), resultType);

            result.AddOperand(execution);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction WritePackedPrimitiveIndices4x8NV(Instruction indexOffset, Instruction packedIndices)
        {
            Instruction result = NewInstruction(Op.OpWritePackedPrimitiveIndices4x8NV);

            result.AddOperand(indexOffset);
            result.AddOperand(packedIndices);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReportIntersectionNV(Instruction resultType, Instruction hit, Instruction hitKind)
        {
            Instruction result = NewInstruction(Op.OpReportIntersectionNV, GetNewId(), resultType);

            result.AddOperand(hit);
            result.AddOperand(hitKind);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ReportIntersectionKHR(Instruction resultType, Instruction hit, Instruction hitKind)
        {
            Instruction result = NewInstruction(Op.OpReportIntersectionKHR, GetNewId(), resultType);

            result.AddOperand(hit);
            result.AddOperand(hitKind);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IgnoreIntersectionNV()
        {
            Instruction result = NewInstruction(Op.OpIgnoreIntersectionNV);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TerminateRayNV()
        {
            Instruction result = NewInstruction(Op.OpTerminateRayNV);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TraceNV(Instruction accel, Instruction rayFlags, Instruction cullMask, Instruction sBTOffset, Instruction sBTStride, Instruction missIndex, Instruction rayOrigin, Instruction rayTmin, Instruction rayDirection, Instruction rayTmax, Instruction payloadId)
        {
            Instruction result = NewInstruction(Op.OpTraceNV);

            result.AddOperand(accel);
            result.AddOperand(rayFlags);
            result.AddOperand(cullMask);
            result.AddOperand(sBTOffset);
            result.AddOperand(sBTStride);
            result.AddOperand(missIndex);
            result.AddOperand(rayOrigin);
            result.AddOperand(rayTmin);
            result.AddOperand(rayDirection);
            result.AddOperand(rayTmax);
            result.AddOperand(payloadId);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TypeAccelerationStructureNV()
        {
            Instruction result = NewInstruction(Op.OpTypeAccelerationStructureNV, GetNewId());

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TypeAccelerationStructureKHR()
        {
            Instruction result = NewInstruction(Op.OpTypeAccelerationStructureKHR, GetNewId());

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ExecuteCallableNV(Instruction sBTIndex, Instruction callableDataId)
        {
            Instruction result = NewInstruction(Op.OpExecuteCallableNV);

            result.AddOperand(sBTIndex);
            result.AddOperand(callableDataId);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction TypeCooperativeMatrixNV(Instruction componentType, Instruction execution, Instruction rows, Instruction columns)
        {
            Instruction result = NewInstruction(Op.OpTypeCooperativeMatrixNV, GetNewId());

            result.AddOperand(componentType);
            result.AddOperand(execution);
            result.AddOperand(rows);
            result.AddOperand(columns);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CooperativeMatrixLoadNV(Instruction resultType, Instruction pointer, Instruction stride, Instruction columnMajor, MemoryAccessMask memoryAccess = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpCooperativeMatrixLoadNV, GetNewId(), resultType);

            result.AddOperand(pointer);
            result.AddOperand(stride);
            result.AddOperand(columnMajor);
            if (memoryAccess != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CooperativeMatrixStoreNV(Instruction pointer, Instruction obj, Instruction stride, Instruction columnMajor, MemoryAccessMask memoryAccess = (MemoryAccessMask)int.MaxValue)
        {
            Instruction result = NewInstruction(Op.OpCooperativeMatrixStoreNV);

            result.AddOperand(pointer);
            result.AddOperand(obj);
            result.AddOperand(stride);
            result.AddOperand(columnMajor);
            if (memoryAccess != (MemoryAccessMask)int.MaxValue)
            {
                result.AddOperand(memoryAccess);
            }
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CooperativeMatrixMulAddNV(Instruction resultType, Instruction a, Instruction b, Instruction c)
        {
            Instruction result = NewInstruction(Op.OpCooperativeMatrixMulAddNV, GetNewId(), resultType);

            result.AddOperand(a);
            result.AddOperand(b);
            result.AddOperand(c);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction CooperativeMatrixLengthNV(Instruction resultType, Instruction type)
        {
            Instruction result = NewInstruction(Op.OpCooperativeMatrixLengthNV, GetNewId(), resultType);

            result.AddOperand(type);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction BeginInvocationInterlockEXT()
        {
            Instruction result = NewInstruction(Op.OpBeginInvocationInterlockEXT);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction EndInvocationInterlockEXT()
        {
            Instruction result = NewInstruction(Op.OpEndInvocationInterlockEXT);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction DemoteToHelperInvocationEXT()
        {
            Instruction result = NewInstruction(Op.OpDemoteToHelperInvocationEXT);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IsHelperInvocationEXT(Instruction resultType)
        {
            Instruction result = NewInstruction(Op.OpIsHelperInvocationEXT, GetNewId(), resultType);

            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UCountLeadingZerosINTEL(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpUCountLeadingZerosINTEL, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UCountTrailingZerosINTEL(Instruction resultType, Instruction operand)
        {
            Instruction result = NewInstruction(Op.OpUCountTrailingZerosINTEL, GetNewId(), resultType);

            result.AddOperand(operand);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AbsISubINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpAbsISubINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction AbsUSubINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpAbsUSubINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IAddSatINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIAddSatINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UAddSatINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUAddSatINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IAverageINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIAverageINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UAverageINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUAverageINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IAverageRoundedINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIAverageRoundedINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UAverageRoundedINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUAverageRoundedINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction ISubSatINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpISubSatINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction USubSatINTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUSubSatINTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction IMul32x16INTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpIMul32x16INTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction UMul32x16INTEL(Instruction resultType, Instruction operand1, Instruction operand2)
        {
            Instruction result = NewInstruction(Op.OpUMul32x16INTEL, GetNewId(), resultType);

            result.AddOperand(operand1);
            result.AddOperand(operand2);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction LoopControlINTEL(params LiteralInteger[] loopControlParameters)
        {
            Instruction result = NewInstruction(Op.OpLoopControlINTEL);

            result.AddOperand(loopControlParameters);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction FPGARegINTEL(Instruction resultType, Instruction resultObj, Instruction input)
        {
            Instruction result = NewInstruction(Op.OpFPGARegINTEL, GetNewId(), resultType);

            result.AddOperand(resultObj);
            result.AddOperand(input);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetRayTMinKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetRayTMinKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetRayFlagsKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetRayFlagsKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionTKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionTKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionInstanceCustomIndexKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionInstanceCustomIndexKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionInstanceIdKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionInstanceIdKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionGeometryIndexKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionGeometryIndexKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionPrimitiveIndexKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionPrimitiveIndexKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionBarycentricsKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionBarycentricsKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionFrontFaceKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionFrontFaceKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionCandidateAABBOpaqueKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionCandidateAABBOpaqueKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionObjectRayDirectionKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionObjectRayDirectionKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionObjectRayOriginKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionObjectRayOriginKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetWorldRayDirectionKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetWorldRayDirectionKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetWorldRayOriginKHR(Instruction resultType, Instruction rayQuery)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetWorldRayOriginKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionObjectToWorldKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionObjectToWorldKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

        public Instruction RayQueryGetIntersectionWorldToObjectKHR(Instruction resultType, Instruction rayQuery, Instruction intersection)
        {
            Instruction result = NewInstruction(Op.OpRayQueryGetIntersectionWorldToObjectKHR, GetNewId(), resultType);

            result.AddOperand(rayQuery);
            result.AddOperand(intersection);
            AddToFunctionDefinitions(result);

            return result;
        }

    }
}
