using Ryujinx.Horizon.Common;
using Ryujinx.Horizon.Sdk.Account;
using Ryujinx.Horizon.Sdk.Settings;
using Ryujinx.Horizon.Sdk.Sf;
using System;

namespace Ryujinx.Horizon.Sdk.Friends.Detail.Ipc
{
    interface IFriendService : IServiceObject
    {
        Result GetCompletionEvent(out int completionEventHandle);
        Result Cancel();
        Result GetFriendListIds(out int count, Span<NetworkServiceAccountId> friendIds, Uid userId, int offset, SizedFriendFilter filter, ulong pidPlaceholder, ulong pid);
        Result GetFriendList(out int count, Span<FriendImpl> friendList, Uid userId, int offset, SizedFriendFilter filter, ulong pidPlaceholder, ulong pid);
        Result UpdateFriendInfo(Span<FriendImpl> info, Uid userId, ReadOnlySpan<NetworkServiceAccountId> friendIds, ulong pidPlaceholder, ulong pid);
        Result GetFriendProfileImage(out int size, Uid userId, NetworkServiceAccountId friendId, Span<byte> profileImage);
        Result CheckFriendListAvailability(out bool listAvailable, Uid userId);
        Result EnsureFriendListAvailable(Uid userId);
        Result SendFriendRequestForApplication(Uid userId, NetworkServiceAccountId friendId, in InAppScreenName arg2, in InAppScreenName arg3, ulong pidPlaceholder, ulong pid);
        Result AddFacedFriendRequestForApplication(Uid userId, FacedFriendRequestRegistrationKey key, Nickname nickname, ReadOnlySpan<byte> arg3, in InAppScreenName arg4, in InAppScreenName arg5, ulong pidPlaceholder, ulong pid);
        Result GetBlockedUserListIds(out int count, Span<NetworkServiceAccountId> blockedIds, Uid userId, int offset);
        Result CheckBlockedUserListAvailability(out bool listAvailable, Uid userId);
        Result EnsureBlockedUserListAvailable(Uid userId);
        Result GetProfileList(Span<ProfileImpl> profileList, Uid userId, ReadOnlySpan<NetworkServiceAccountId> friendIds);
        Result DeclareOpenOnlinePlaySession(Uid userId);
        Result DeclareCloseOnlinePlaySession(Uid userId);
        Result UpdateUserPresence(Uid userId, in UserPresenceImpl userPresence, ulong pidPlaceholder, ulong pid);
        Result GetPlayHistoryRegistrationKey(out PlayHistoryRegistrationKey registrationKey, Uid userId, bool arg2);
        Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(out PlayHistoryRegistrationKey registrationKey, NetworkServiceAccountId friendId, bool arg2);
        Result AddPlayHistory(Uid userId, in PlayHistoryRegistrationKey registrationKey, in InAppScreenName arg2, in InAppScreenName arg3, ulong pidPlaceholder, ulong pid);
        Result GetProfileImageUrl(out Url imageUrl, Url url, int arg2);
        Result GetFriendCount(out int count, Uid userId, SizedFriendFilter filter, ulong pidPlaceholder, ulong pid);
        Result GetNewlyFriendCount(out int count, Uid userId);
        Result GetFriendDetailedInfo(out FriendDetailedInfoImpl detailedInfo, Uid userId, NetworkServiceAccountId friendId);
        Result SyncFriendList(Uid userId);
        Result RequestSyncFriendList(Uid userId);
        Result LoadFriendSetting(out FriendSettingImpl friendSetting, Uid userId, NetworkServiceAccountId friendId);
        Result GetReceivedFriendRequestCount(out int count, out int count2, Uid userId);
        Result GetFriendRequestList(out int count, Span<FriendRequestImpl> requestList, Uid userId, int arg3, int arg4);
        Result GetFriendCandidateList(out int count, Span<FriendCandidateImpl> candidateList, Uid userId, int arg3);
        Result GetNintendoNetworkIdInfo(out NintendoNetworkIdUserInfo networkIdInfo, out int arg1, Span<NintendoNetworkIdFriendImpl> friendInfo, Uid userId, int arg4);
        Result GetSnsAccountLinkage(out SnsAccountLinkage accountLinkage, Uid userId);
        Result GetSnsAccountProfile(out SnsAccountProfile accountProfile, Uid userId, NetworkServiceAccountId friendId, int arg3);
        Result GetSnsAccountFriendList(out int count, Span<SnsAccountFriendImpl> friendList, Uid userId, int arg3);
        Result GetBlockedUserList(out int count, Span<BlockedUserImpl> blockedUsers, Uid userId, int arg3);
        Result SyncBlockedUserList(Uid userId);
        Result GetProfileExtraList(Span<ProfileExtraImpl> extraList, Uid userId, ReadOnlySpan<NetworkServiceAccountId> friendIds);
        Result GetRelationship(out Relationship relationship, Uid userId, NetworkServiceAccountId friendId);
        Result GetUserPresenceView(out UserPresenceViewImpl userPresenceView, Uid userId);
        Result GetPlayHistoryList(out int count, Span<PlayHistoryImpl> playHistoryList, Uid userId, int arg3);
        Result GetPlayHistoryStatistics(out PlayHistoryStatistics statistics, Uid userId);
        Result LoadUserSetting(out UserSettingImpl userSetting, Uid userId);
        Result SyncUserSetting(Uid userId);
        Result RequestListSummaryOverlayNotification();
        Result GetExternalApplicationCatalog(out ExternalApplicationCatalog catalog, ExternalApplicationCatalogId catalogId, LanguageCode language);
        Result GetReceivedFriendInvitationList(out int count, Span<FriendInvitationForViewerImpl> invitationList, Uid userId);
        Result GetReceivedFriendInvitationDetailedInfo(out FriendInvitationGroupImpl invicationGroup, Uid userId, FriendInvitationGroupId groupId);
        Result GetReceivedFriendInvitationCountCache(out int count, Uid userId);
        Result DropFriendNewlyFlags(Uid userId);
        Result DeleteFriend(Uid userId, NetworkServiceAccountId friendId);
        Result DropFriendNewlyFlag(Uid userId, NetworkServiceAccountId friendId);
        Result ChangeFriendFavoriteFlag(Uid userId, NetworkServiceAccountId friendId, bool favoriteFlag);
        Result ChangeFriendOnlineNotificationFlag(Uid userId, NetworkServiceAccountId friendId, bool onlineNotificationFlag);
        Result SendFriendRequest(Uid userId, NetworkServiceAccountId friendId, int arg2);
        Result SendFriendRequestWithApplicationInfo(Uid userId, NetworkServiceAccountId friendId, int arg2, ApplicationInfo applicationInfo, in InAppScreenName arg4, in InAppScreenName arg5);
        Result CancelFriendRequest(Uid userId, RequestId requestId);
        Result AcceptFriendRequest(Uid userId, RequestId requestId);
        Result RejectFriendRequest(Uid userId, RequestId requestId);
        Result ReadFriendRequest(Uid userId, RequestId requestId);
        Result GetFacedFriendRequestRegistrationKey(out FacedFriendRequestRegistrationKey registrationKey, Uid userId);
        Result AddFacedFriendRequest(Uid userId, FacedFriendRequestRegistrationKey registrationKey, Nickname nickname, ReadOnlySpan<byte> arg3);
        Result CancelFacedFriendRequest(Uid userId, NetworkServiceAccountId friendId);
        Result GetFacedFriendRequestProfileImage(out int size, Uid userId, NetworkServiceAccountId friendId, Span<byte> profileImage);
        Result GetFacedFriendRequestProfileImageFromPath(out int size, ReadOnlySpan<byte> path, Span<byte> profileImage);
        Result SendFriendRequestWithExternalApplicationCatalogId(Uid userId, NetworkServiceAccountId friendId, int arg2, ExternalApplicationCatalogId catalogId, in InAppScreenName arg4, in InAppScreenName arg5);
        Result ResendFacedFriendRequest(Uid userId, NetworkServiceAccountId friendId);
        Result SendFriendRequestWithNintendoNetworkIdInfo(Uid userId, NetworkServiceAccountId friendId, int arg2, MiiName arg3, MiiImageUrlParam arg4, MiiName arg5, MiiImageUrlParam arg6);
        Result GetSnsAccountLinkPageUrl(out WebPageUrl url, Uid userId, int arg2);
        Result UnlinkSnsAccount(Uid userId, int arg1);
        Result BlockUser(Uid userId, NetworkServiceAccountId friendId, int arg2);
        Result BlockUserWithApplicationInfo(Uid userId, NetworkServiceAccountId friendId, int arg2, ApplicationInfo applicationInfo, in InAppScreenName arg4);
        Result UnblockUser(Uid userId, NetworkServiceAccountId friendId);
        Result GetProfileExtraFromFriendCode(out ProfileExtraImpl profileExtra, Uid userId, FriendCode friendCode);
        Result DeletePlayHistory(Uid userId);
        Result ChangePresencePermission(Uid userId, int permission);
        Result ChangeFriendRequestReception(Uid userId, bool reception);
        Result ChangePlayLogPermission(Uid userId, int permission);
        Result IssueFriendCode(Uid userId);
        Result ClearPlayLog(Uid userId);
        Result SendFriendInvitation(Uid userId, ReadOnlySpan<NetworkServiceAccountId> friendIds, in FriendInvitationGameModeDescription description, ApplicationInfo applicationInfo, ReadOnlySpan<byte> arg4, bool arg5);
        Result ReadFriendInvitation(Uid userId, ReadOnlySpan<FriendInvitationId> invitationIds);
        Result ReadAllFriendInvitations(Uid userId);
        Result DeleteFriendListCache(Uid userId);
        Result DeleteBlockedUserListCache(Uid userId);
        Result DeleteNetworkServiceAccountCache(Uid userId);
    }
}
