using System.Diagnostics.CodeAnalysis;

namespace Ryujinx.HLE.HOS.Services.Sockets.Bsd.Types
{
    [SuppressMessage("Design", "CA1069: Enums values should not be duplicated")]
    enum BsdSocketOption
    {
        SoDebug = 0x1,
        SoAcceptConn = 0x2,
        SoReuseAddr = 0x4,
        SoKeepAlive = 0x8,
        SoDontRoute = 0x10,
        SoBroadcast = 0x20,
        SoUseLoopBack = 0x40,
        SoLinger = 0x80,
        SoOobInline = 0x100,
        SoReusePort = 0x200,
        SoTimestamp = 0x400,
        SoNoSigpipe = 0x800,
        SoAcceptFilter = 0x1000,
        SoBinTime = 0x2000,
        SoNoOffload = 0x4000,
        SoNoDdp = 0x8000,
        SoReusePortLb = 0x10000,
        SoRError = 0x20000,

        SoSndBuf = 0x1001,
        SoRcvBuf = 0x1002,
        SoSndLoWat = 0x1003,
        SoRcvLoWat = 0x1004,
        SoSndTimeo = 0x1005,
        SoRcvTimeo = 0x1006,
        SoError = 0x1007,
        SoType = 0x1008,
        SoLabel = 0x1009,
        SoPeerLabel = 0x1010,
        SoListenQLimit = 0x1011,
        SoListenQLen = 0x1012,
        SoListenIncQLen = 0x1013,
        SoSetFib = 0x1014,
        SoUserCookie = 0x1015,
        SoProtocol = 0x1016,
        SoTsClock = 0x1017,
        SoMaxPacingRate = 0x1018,
        SoDomain = 0x1019,

        IpOptions = 1,
        IpHdrIncl = 2,
        IpTos = 3,
        IpTtl = 4,
        IpRecvOpts = 5,
        IpRecvRetOpts = 6,
        IpRecvDstAddr = 7,
        IpRetOpts = 8,
        IpMulticastIf = 9,
        IpMulticastTtl = 10,
        IpMulticastLoop = 11,
        IpAddMembership = 12,
        IpDropMembership = 13,
        IpMulticastVif = 14,
        IpRsvpOn = 15,
        IpRsvpOff = 16,
        IpRsvpVifOn = 17,
        IpRsvpVifOff = 18,
        IpPortRange = 19,
        IpRecvIf = 20,
        IpIpsecPolicy = 21,
        IpOnesBcast = 23,
        IpBindany = 24,
        IpBindMulti = 25,
        IpRssListenBucket = 26,
        IpOrigDstAddr = 27,

        IpFwTableAdd = 40,
        IpFwTableDel = 41,
        IpFwTableFlush = 42,
        IpFwTableGetSize = 43,
        IpFwTableList = 44,

        IpFw3 = 48,
        IpDummyNet3 = 49,

        IpFwAdd = 50,
        IpFwDel = 51,
        IpFwFlush = 52,
        IpFwZero = 53,
        IpFwGet = 54,
        IpFwResetLog = 55,

        IpFwNatCfg = 56,
        IpFwNatDel = 57,
        IpFwNatGetConfig = 58,
        IpFwNatGetLog = 59,

        IpDummyNetConfigure = 60,
        IpDummyNetDel = 61,
        IpDummyNetFlush = 62,
        IpDummyNetGet = 64,

        IpRecvTtl = 65,
        IpMinTtl = 66,
        IpDontFrag = 67,
        IpRecvTos = 68,

        IpAddSourceMembership = 70,
        IpDropSourceMembership = 71,
        IpBlockSource = 72,
        IpUnblockSource = 73,

        TcpNoDelay = 1,
        TcpMaxSeg = 2,
        TcpNoPush = 4,
        TcpNoOpt = 8,
        TcpMd5Sig = 16,
        TcpInfo = 32,
        TcpCongestion = 64,
        TcpKeepInit = 128,
        TcpKeepIdle = 256,
        TcpKeepIntvl = 512,
        TcpKeepCnt = 1024,
    }
}
