using System;

namespace Ryujinx.Cpu.LightningJit.Arm64
{
    [Flags]
    enum InstFlags
    {
        None = 0,
        Rd = 1 << 0,
        RdSP = Rd | (1 << 1),
        ReadRd = 1 << 2,
        Rt = 1 << 3,
        RtSeq = Rt | (1 << 4),
        ReadRt = 1 << 5,
        Rt2 = 1 << 6,
        Rn = 1 << 7,
        RnSeq = Rn | (1 << 8),
        RnSP = Rn | (1 << 9),
        Rm = 1 << 10,
        Rs = 1 << 11,
        Ra = 1 << 12,
        Nzcv = 1 << 13,
        C = 1 << 14,
        S = 1 << 15,
        Qc = 1 << 16,
        FpSimd = 1 << 17,
        FpSimdFromGpr = FpSimd | (1 << 18),
        FpSimdToGpr = FpSimd | (1 << 19),
        FpSimdFromToGpr = FpSimdFromGpr | FpSimdToGpr,
        Memory = 1 << 20,
        MemWBack = 1 << 21,

        RdFpSimd = Rd | FpSimd,
        RdReadRd = Rd | ReadRd,
        RdReadRdRn = Rd | ReadRd | Rn,
        RdReadRdRnFpSimd = Rd | ReadRd | Rn | FpSimd,
        RdReadRdRnFpSimdFromGpr = Rd | ReadRd | Rn | FpSimdFromGpr,
        RdReadRdRnQcFpSimd = Rd | ReadRd | Rn | Qc | FpSimd,
        RdReadRdRnRmFpSimd = Rd | ReadRd | Rn | Rm | FpSimd,
        RdReadRdRnRmQcFpSimd = Rd | ReadRd | Rn | Rm | Qc | FpSimd,
        RdRn = Rd | Rn,
        RdRnFpSimd = Rd | Rn | FpSimd,
        RdRnFpSimdFromGpr = Rd | Rn | FpSimdFromGpr,
        RdRnFpSimdToGpr = Rd | Rn | FpSimdToGpr,
        RdRnQcFpSimd = Rd | Rn | Qc | FpSimd,
        RdRnRm = Rd | Rn | Rm,
        RdRnRmC = Rd | Rn | Rm | C,
        RdRnRmCS = Rd | Rn | Rm | C | S,
        RdRnRmFpSimd = Rd | Rn | Rm | FpSimd,
        RdRnRmNzcv = Rd | Rn | Rm | Nzcv,
        RdRnRmNzcvFpSimd = Rd | Rn | Rm | Nzcv | FpSimd,
        RdRnRmQcFpSimd = Rd | Rn | Rm | Qc | FpSimd,
        RdRnRmRa = Rd | Rn | Rm | Ra,
        RdRnRmRaFpSimd = Rd | Rn | Rm | Ra | FpSimd,
        RdRnRmS = Rd | Rn | Rm | S,
        RdRnRsS = Rd | Rn | Rs | S,
        RdRnS = Rd | Rn | S,
        RdRnSeqRmFpSimd = Rd | RnSeq | Rm | FpSimd,
        RdRnSFpSimd = Rd | Rn | S | FpSimd,
        RdRnSFpSimdFromToGpr = Rd | Rn | S | FpSimdFromToGpr,
        RdRnSP = Rd | RnSP,
        RdRnSPRmS = Rd | RnSP | Rm | S,
        RdRnSPS = Rd | RnSP | S,
        RdSPRn = RdSP | Rn,
        RdSPRnSP = RdSP | RnSP,
        RdSPRnSPRm = RdSP | RnSP | Rm,
        RnC = Rn | C,
        RnNzcvS = Rn | Nzcv | S,
        RnRm = Rn | Rm,
        RnRmNzcvS = Rn | Rm | Nzcv | S,
        RnRmNzcvSFpSimd = Rn | Rm | Nzcv | S | FpSimd,
        RnRmSFpSimd = Rn | Rm | S | FpSimd,
        RnSPRm = RnSP | Rm,
        RtFpSimd = Rt | FpSimd,
        RtReadRt = Rt | ReadRt,
        RtReadRtRnSP = Rt | ReadRt | RnSP,
        RtReadRtRnSPFpSimd = Rt | ReadRt | RnSP | FpSimd,
        RtReadRtRnSPFpSimdMemWBack = Rt | ReadRt | RnSP | FpSimd | MemWBack,
        RtReadRtRnSPMemWBack = Rt | ReadRt | RnSP | MemWBack,
        RtReadRtRnSPRm = Rt | ReadRt | RnSP | Rm,
        RtReadRtRnSPRmFpSimd = Rt | ReadRt | RnSP | Rm | FpSimd,
        RtReadRtRnSPRmFpSimdMemWBack = Rt | ReadRt | RnSP | Rm | FpSimd | MemWBack,
        RtReadRtRnSPRs = Rt | ReadRt | RnSP | Rs,
        RtReadRtRnSPRsS = Rt | ReadRt | RnSP | Rs | S,
        RtReadRtRt2RnSP = Rt | ReadRt | Rt2 | RnSP,
        RtReadRtRt2RnSPFpSimd = Rt | ReadRt | Rt2 | RnSP | FpSimd,
        RtReadRtRt2RnSPFpSimdMemWBack = Rt | ReadRt | Rt2 | RnSP | FpSimd | MemWBack,
        RtReadRtRt2RnSPMemWBack = Rt | ReadRt | Rt2 | RnSP | MemWBack,
        RtReadRtRt2RnSPRs = Rt | ReadRt | Rt2 | RnSP | Rs,
        RtReadRtRt2RnSPS = Rt | ReadRt | Rt2 | RnSP | S,
        RtRnSP = Rt | RnSP,
        RtRnSPFpSimd = Rt | RnSP | FpSimd,
        RtRnSPFpSimdMemWBack = Rt | RnSP | FpSimd | MemWBack,
        RtRnSPMemWBack = Rt | RnSP | MemWBack,
        RtRnSPRm = Rt | RnSP | Rm,
        RtRnSPRmFpSimd = Rt | RnSP | Rm | FpSimd,
        RtRnSPRmFpSimdMemWBack = Rt | RnSP | Rm | FpSimd | MemWBack,
        RtRnSPRs = Rt | RnSP | Rs,
        RtRt2RnSP = Rt | Rt2 | RnSP,
        RtRt2RnSPFpSimd = Rt | Rt2 | RnSP | FpSimd,
        RtRt2RnSPFpSimdMemWBack = Rt | Rt2 | RnSP | FpSimd | MemWBack,
        RtRt2RnSPMemWBack = Rt | Rt2 | RnSP | MemWBack,
        RtSeqReadRtRnSPFpSimd = RtSeq | ReadRt | RnSP | FpSimd,
        RtSeqReadRtRnSPRmFpSimdMemWBack = RtSeq | ReadRt | RnSP | Rm | FpSimd | MemWBack,
        RtSeqRnSPFpSimd = RtSeq | RnSP | FpSimd,
        RtSeqRnSPRmFpSimdMemWBack = RtSeq | RnSP | Rm | FpSimd | MemWBack,
    }
}
