using System;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using static Ryujinx.Audio.Renderer.Parameter.VoiceInParameter;

namespace Ryujinx.Audio.Renderer.Dsp
{
    public static class ResamplerHelper
    {
        #region "Default Quality Lookup Tables"
        private static readonly short[] _normalCurveLut0 = {
            6600,  19426, 6722,  3,     6479,  19424, 6845,  9,     6359,  19419, 6968,  15,    6239,  19412, 7093,  22,
            6121,  19403, 7219,  28,    6004,  19391, 7345,  34,    5888,  19377, 7472,  41,    5773,  19361, 7600,  48,
            5659,  19342, 7728,  55,    5546,  19321, 7857,  62,    5434,  19298, 7987,  69,    5323,  19273, 8118,  77,
            5213,  19245, 8249,  84,    5104,  19215, 8381,  92,    4997,  19183, 8513,  101,   4890,  19148, 8646,  109,
            4785,  19112, 8780,  118,   4681,  19073, 8914,  127,   4579,  19031, 9048,  137,   4477,  18988, 9183,  147,
            4377,  18942, 9318,  157,   4277,  18895, 9454,  168,   4179,  18845, 9590,  179,   4083,  18793, 9726,  190,
            3987,  18738, 9863,  202,   3893,  18682, 10000, 215,   3800,  18624, 10137, 228,   3709,  18563, 10274, 241,
            3618,  18500, 10411, 255,   3529,  18436, 10549, 270,   3441,  18369, 10687, 285,   3355,  18300, 10824, 300,
            3269,  18230, 10962, 317,   3186,  18157, 11100, 334,   3103,  18082, 11238, 351,   3022,  18006, 11375, 369,
            2942,  17927, 11513, 388,   2863,  17847, 11650, 408,   2785,  17765, 11788, 428,   2709,  17681, 11925, 449,
            2635,  17595, 12062, 471,   2561,  17507, 12198, 494,   2489,  17418, 12334, 517,   2418,  17327, 12470, 541,
            2348,  17234, 12606, 566,   2280,  17140, 12741, 592,   2213,  17044, 12876, 619,   2147,  16946, 13010, 647,
            2083,  16846, 13144, 675,   2020,  16745, 13277, 704,   1958,  16643, 13409, 735,   1897,  16539, 13541, 766,
            1838,  16434, 13673, 798,   1780,  16327, 13803, 832,   1723,  16218, 13933, 866,   1667,  16109, 14062, 901,
            1613,  15998, 14191, 937,   1560,  15885, 14318, 975,   1508,  15772, 14445, 1013,  1457,  15657, 14571, 1052,
            1407,  15540, 14695, 1093,  1359,  15423, 14819, 1134,  1312,  15304, 14942, 1177,  1266,  15185, 15064, 1221,
            1221,  15064, 15185, 1266,  1177,  14942, 15304, 1312,  1134,  14819, 15423, 1359,  1093,  14695, 15540, 1407,
            1052,  14571, 15657, 1457,  1013,  14445, 15772, 1508,  975,   14318, 15885, 1560,  937,   14191, 15998, 1613,
            901,   14062, 16109, 1667,  866,   13933, 16218, 1723,  832,   13803, 16327, 1780,  798,   13673, 16434, 1838,
            766,   13541, 16539, 1897,  735,   13409, 16643, 1958,  704,   13277, 16745, 2020,  675,   13144, 16846, 2083,
            647,   13010, 16946, 2147,  619,   12876, 17044, 2213,  592,   12741, 17140, 2280,  566,   12606, 17234, 2348,
            541,   12470, 17327, 2418,  517,   12334, 17418, 2489,  494,   12198, 17507, 2561,  471,   12062, 17595, 2635,
            449,   11925, 17681, 2709,  428,   11788, 17765, 2785,  408,   11650, 17847, 2863,  388,   11513, 17927, 2942,
            369,   11375, 18006, 3022,  351,   11238, 18082, 3103,  334,   11100, 18157, 3186,  317,   10962, 18230, 3269,
            300,   10824, 18300, 3355,  285,   10687, 18369, 3441,  270,   10549, 18436, 3529,  255,   10411, 18500, 3618,
            241,   10274, 18563, 3709,  228,   10137, 18624, 3800,  215,   10000, 18682, 3893,  202,   9863,  18738, 3987,
            190,   9726,  18793, 4083,  179,   9590,  18845, 4179,  168,   9454,  18895, 4277,  157,   9318,  18942, 4377,
            147,   9183,  18988, 4477,  137,   9048,  19031, 4579,  127,   8914,  19073, 4681,  118,   8780,  19112, 4785,
            109,   8646,  19148, 4890,  101,   8513,  19183, 4997,  92,    8381,  19215, 5104,  84,    8249,  19245, 5213,
            77,    8118,  19273, 5323,  69,    7987,  19298, 5434,  62,    7857,  19321, 5546,  55,    7728,  19342, 5659,
            48,    7600,  19361, 5773,  41,    7472,  19377, 5888,  34,    7345,  19391, 6004,  28,    7219,  19403, 6121,
            22,    7093,  19412, 6239,  15,    6968,  19419, 6359,  9,     6845,  19424, 6479,  3,     6722,  19426, 6600,
        };

        private static readonly short[] _normalCurveLut1 = {
            -68,   32639, 69,    -5,    -200,  32630, 212,   -15,   -328,  32613, 359,   -26,   -450,  32586, 512,   -36,
            -568,  32551, 669,   -47,   -680,  32507, 832,   -58,   -788,  32454, 1000,  -69,   -891,  32393, 1174,  -80,
            -990,  32323, 1352,  -92,   -1084, 32244, 1536,  -103,  -1173, 32157, 1724,  -115,  -1258, 32061, 1919,  -128,
            -1338, 31956, 2118,  -140,  -1414, 31844, 2322,  -153,  -1486, 31723, 2532,  -167,  -1554, 31593, 2747,  -180,
            -1617, 31456, 2967,  -194,  -1676, 31310, 3192,  -209,  -1732, 31157, 3422,  -224,  -1783, 30995, 3657,  -240,
            -1830, 30826, 3897,  -256,  -1874, 30649, 4143,  -272,  -1914, 30464, 4393,  -289,  -1951, 30272, 4648,  -307,
            -1984, 30072, 4908,  -325,  -2014, 29866, 5172,  -343,  -2040, 29652, 5442,  -362,  -2063, 29431, 5716,  -382,
            -2083, 29203, 5994,  -403,  -2100, 28968, 6277,  -424,  -2114, 28727, 6565,  -445,  -2125, 28480, 6857,  -468,
            -2133, 28226, 7153,  -490,  -2139, 27966, 7453,  -514,  -2142, 27700, 7758,  -538,  -2142, 27428, 8066,  -563,
            -2141, 27151, 8378,  -588,  -2136, 26867, 8694,  -614,  -2130, 26579, 9013,  -641,  -2121, 26285, 9336,  -668,
            -2111, 25987, 9663,  -696,  -2098, 25683, 9993,  -724,  -2084, 25375, 10326, -753,  -2067, 25063, 10662, -783,
            -2049, 24746, 11000, -813,  -2030, 24425, 11342, -844,  -2009, 24100, 11686, -875,  -1986, 23771, 12033, -907,
            -1962, 23438, 12382, -939,  -1937, 23103, 12733, -972,  -1911, 22764, 13086, -1005, -1883, 22422, 13441, -1039,
            -1855, 22077, 13798, -1072, -1825, 21729, 14156, -1107, -1795, 21380, 14516, -1141, -1764, 21027, 14877, -1176,
            -1732, 20673, 15239, -1211, -1700, 20317, 15602, -1246, -1667, 19959, 15965, -1282, -1633, 19600, 16329, -1317,
            -1599, 19239, 16694, -1353, -1564, 18878, 17058, -1388, -1530, 18515, 17423, -1424, -1495, 18151, 17787, -1459,
            -1459, 17787, 18151, -1495, -1424, 17423, 18515, -1530, -1388, 17058, 18878, -1564, -1353, 16694, 19239, -1599,
            -1317, 16329, 19600, -1633, -1282, 15965, 19959, -1667, -1246, 15602, 20317, -1700, -1211, 15239, 20673, -1732,
            -1176, 14877, 21027, -1764, -1141, 14516, 21380, -1795, -1107, 14156, 21729, -1825, -1072, 13798, 22077, -1855,
            -1039, 13441, 22422, -1883, -1005, 13086, 22764, -1911, -972,  12733, 23103, -1937, -939,  12382, 23438, -1962,
            -907,  12033, 23771, -1986, -875,  11686, 24100, -2009, -844,  11342, 24425, -2030, -813,  11000, 24746, -2049,
            -783,  10662, 25063, -2067, -753,  10326, 25375, -2084, -724,  9993,  25683, -2098, -696,  9663,  25987, -2111,
            -668,  9336,  26285, -2121, -641,  9013,  26579, -2130, -614,  8694,  26867, -2136, -588,  8378,  27151, -2141,
            -563,  8066,  27428, -2142, -538,  7758,  27700, -2142, -514,  7453,  27966, -2139, -490,  7153,  28226, -2133,
            -468,  6857,  28480, -2125, -445,  6565,  28727, -2114, -424,  6277,  28968, -2100, -403,  5994,  29203, -2083,
            -382,  5716,  29431, -2063, -362,  5442,  29652, -2040, -343,  5172,  29866, -2014, -325,  4908,  30072, -1984,
            -307,  4648,  30272, -1951, -289,  4393,  30464, -1914, -272,  4143,  30649, -1874, -256,  3897,  30826, -1830,
            -240,  3657,  30995, -1783, -224,  3422,  31157, -1732, -209,  3192,  31310, -1676, -194,  2967,  31456, -1617,
            -180,  2747,  31593, -1554, -167,  2532,  31723, -1486, -153,  2322,  31844, -1414, -140,  2118,  31956, -1338,
            -128,  1919,  32061, -1258, -115,  1724,  32157, -1173, -103,  1536,  32244, -1084, -92,   1352,  32323, -990,
            -80,   1174,  32393, -891,  -69,   1000,  32454, -788,  -58,   832,   32507, -680,  -47,   669,   32551, -568,
            -36,   512,   32586, -450,  -26,   359,   32613, -328,  -15,   212,   32630, -200,  -5,    69,    32639, -68,
        };

        private static readonly short[] _normalCurveLut2 = {
            3195,  26287, 3329,  -32,   3064,  26281, 3467,  -34,   2936,  26270, 3608,  -38,   2811,  26253, 3751,  -42,
            2688,  26230, 3897,  -46,   2568,  26202, 4046,  -50,   2451,  26169, 4199,  -54,   2338,  26130, 4354,  -58,
            2227,  26085, 4512,  -63,   2120,  26035, 4673,  -67,   2015,  25980, 4837,  -72,   1912,  25919, 5004,  -76,
            1813,  25852, 5174,  -81,   1716,  25780, 5347,  -87,   1622,  25704, 5522,  -92,   1531,  25621, 5701,  -98,
            1442,  25533, 5882,  -103,  1357,  25440, 6066,  -109,  1274,  25342, 6253,  -115,  1193,  25239, 6442,  -121,
            1115,  25131, 6635,  -127,  1040,  25018, 6830,  -133,  967,   24899, 7027,  -140,  897,   24776, 7227,  -146,
            829,   24648, 7430,  -153,  764,   24516, 7635,  -159,  701,   24379, 7842,  -166,  641,   24237, 8052,  -174,
            583,   24091, 8264,  -181,  526,   23940, 8478,  -187,  472,   23785, 8695,  -194,  420,   23626, 8914,  -202,
            371,   23462, 9135,  -209,  324,   23295, 9358,  -215,  279,   23123, 9583,  -222,  236,   22948, 9809,  -230,
            194,   22769, 10038, -237,  154,   22586, 10269, -243,  117,   22399, 10501, -250,  81,    22208, 10735, -258,
            47,    22015, 10970, -265,  15,    21818, 11206, -271,  -16,   21618, 11444, -277,  -44,   21415, 11684, -283,
            -71,   21208, 11924, -290,  -97,   20999, 12166, -296,  -121,  20786, 12409, -302,  -143,  20571, 12653, -306,
            -163,  20354, 12898, -311,  -183,  20134, 13143, -316,  -201,  19911, 13389, -321,  -218,  19686, 13635, -325,
            -234,  19459, 13882, -328,  -248,  19230, 14130, -332,  -261,  18998, 14377, -335,  -273,  18765, 14625, -337,
            -284,  18531, 14873, -339,  -294,  18295, 15121, -341,  -302,  18057, 15369, -341,  -310,  17817, 15617, -341,
            -317,  17577, 15864, -340,  -323,  17335, 16111, -340,  -328,  17092, 16357, -338,  -332,  16848, 16603, -336,
            -336,  16603, 16848, -332,  -338,  16357, 17092, -328,  -340,  16111, 17335, -323,  -340,  15864, 17577, -317,
            -341,  15617, 17817, -310,  -341,  15369, 18057, -302,  -341,  15121, 18295, -294,  -339,  14873, 18531, -284,
            -337,  14625, 18765, -273,  -335,  14377, 18998, -261,  -332,  14130, 19230, -248,  -328,  13882, 19459, -234,
            -325,  13635, 19686, -218,  -321,  13389, 19911, -201,  -316,  13143, 20134, -183,  -311,  12898, 20354, -163,
            -306,  12653, 20571, -143,  -302,  12409, 20786, -121,  -296,  12166, 20999, -97,   -290,  11924, 21208, -71,
            -283,  11684, 21415, -44,   -277,  11444, 21618, -16,   -271,  11206, 21818, 15,    -265,  10970, 22015, 47,
            -258,  10735, 22208, 81,    -250,  10501, 22399, 117,   -243,  10269, 22586, 154,   -237,  10038, 22769, 194,
            -230,  9809,  22948, 236,   -222,  9583,  23123, 279,   -215,  9358,  23295, 324,   -209,  9135,  23462, 371,
            -202,  8914,  23626, 420,   -194,  8695,  23785, 472,   -187,  8478,  23940, 526,   -181,  8264,  24091, 583,
            -174,  8052,  24237, 641,   -166,  7842,  24379, 701,   -159,  7635,  24516, 764,   -153,  7430,  24648, 829,
            -146,  7227,  24776, 897,   -140,  7027,  24899, 967,   -133,  6830,  25018, 1040,  -127,  6635,  25131, 1115,
            -121,  6442,  25239, 1193,  -115,  6253,  25342, 1274,  -109,  6066,  25440, 1357,  -103,  5882,  25533, 1442,
            -98,   5701,  25621, 1531,  -92,   5522,  25704, 1622,  -87,   5347,  25780, 1716,  -81,   5174,  25852, 1813,
            -76,   5004,  25919, 1912,  -72,   4837,  25980, 2015,  -67,   4673,  26035, 2120,  -63,   4512,  26085, 2227,
            -58,   4354,  26130, 2338,  -54,   4199,  26169, 2451,  -50,   4046,  26202, 2568,  -46,   3897,  26230, 2688,
            -42,   3751,  26253, 2811,  -38,   3608,  26270, 2936,  -34,   3467,  26281, 3064,  -32,   3329,  26287, 3195,
        };
        #endregion

        #region "High Quality Lookup Tables"
        private static readonly short[] _highCurveLut0 = {
            -582, -23,  8740, 16386, 8833,  8,    -590,  0,    -573, -54,  8647, 16385, 8925,  40,   -598, -1,
            -565, -84,  8555, 16383, 9018,  72,   -606,  -1,   -557, -113, 8462, 16379, 9110,  105,  -614, -2,
            -549, -142, 8370, 16375, 9203,  139,  -622,  -2,   -541, -170, 8277, 16369, 9295,  173,  -630, -3,
            -533, -198, 8185, 16362, 9387,  208,  -638,  -4,   -525, -225, 8093, 16354, 9480,  244,  -646, -5,
            -516, -251, 8000, 16344, 9572,  280,  -654,  -5,   -508, -277, 7908, 16334, 9664,  317,  -662, -6,
            -500, -302, 7816, 16322, 9756,  355,  -670,  -7,   -492, -327, 7724, 16310, 9847,  393,  -678, -8,
            -484, -351, 7632, 16296, 9939,  432,  -686,  -9,   -476, -374, 7540, 16281, 10030, 471,  -694, -10,
            -468, -397, 7449, 16265, 10121, 511,  -702,  -11,  -460, -419, 7357, 16247, 10212, 552,  -709, -13,
            -452, -441, 7266, 16229, 10303, 593,  -717,  -14,  -445, -462, 7175, 16209, 10394, 635,  -724, -15,
            -437, -483, 7084, 16189, 10484, 678,  -732,  -16,  -429, -503, 6994, 16167, 10574, 722,  -739, -18,
            -421, -523, 6903, 16144, 10664, 766,  -747,  -19,  -414, -542, 6813, 16120, 10754, 810,  -754, -21,
            -406, -560, 6723, 16095, 10843, 856,  -761,  -22,  -398, -578, 6633, 16068, 10932, 902,  -768, -24,
            -391, -596, 6544, 16041, 11021, 949,  -775,  -26,  -383, -612, 6454, 16012, 11109, 996,  -782, -27,
            -376, -629, 6366, 15983, 11197, 1044, -789,  -29,  -368, -645, 6277, 15952, 11285, 1093, -796, -31,
            -361, -660, 6189, 15920, 11372, 1142, -802,  -33,  -354, -675, 6100, 15887, 11459, 1192, -809, -35,
            -347, -689, 6013, 15853, 11546, 1243, -815,  -37,  -339, -703, 5925, 15818, 11632, 1294, -821, -39,
            -332, -717, 5838, 15782, 11718, 1346, -827,  -41,  -325, -730, 5751, 15745, 11803, 1399, -833, -43,
            -318, -742, 5665, 15707, 11888, 1452, -839,  -46,  -312, -754, 5579, 15668, 11973, 1506, -845, -48,
            -305, -766, 5493, 15627, 12057, 1561, -850,  -50,  -298, -777, 5408, 15586, 12140, 1616, -855, -53,
            -291, -787, 5323, 15544, 12224, 1672, -861,  -56,  -285, -798, 5239, 15500, 12306, 1729, -866, -58,
            -278, -807, 5155, 15456, 12388, 1786, -871,  -61,  -272, -817, 5071, 15410, 12470, 1844, -875, -64,
            -265, -826, 4988, 15364, 12551, 1902, -880,  -67,  -259, -834, 4905, 15317, 12631, 1962, -884, -70,
            -253, -842, 4823, 15268, 12711, 2022, -888,  -73,  -247, -850, 4741, 15219, 12790, 2082, -892, -76,
            -241, -857, 4659, 15168, 12869, 2143, -896,  -79,  -235, -864, 4578, 15117, 12947, 2205, -899, -82,
            -229, -870, 4498, 15065, 13025, 2267, -903,  -85,  -223, -876, 4417, 15012, 13102, 2331, -906, -89,
            -217, -882, 4338, 14958, 13178, 2394, -909,  -92,  -211, -887, 4259, 14903, 13254, 2459, -911, -96,
            -206, -892, 4180, 14847, 13329, 2523, -914,  -100, -200, -896, 4102, 14790, 13403, 2589, -916, -103,
            -195, -900, 4024, 14732, 13477, 2655, -918,  -107, -190, -904, 3947, 14673, 13550, 2722, -919, -111,
            -184, -908, 3871, 14614, 13622, 2789, -921,  -115, -179, -911, 3795, 14553, 13693, 2857, -922, -119,
            -174, -913, 3719, 14492, 13764, 2926, -923,  -123, -169, -916, 3644, 14430, 13834, 2995, -923, -127,
            -164, -918, 3570, 14367, 13904, 3065, -924,  -132, -159, -920, 3496, 14303, 13972, 3136, -924, -136,
            -154, -921, 3423, 14239, 14040, 3207, -924,  -140, -150, -922, 3350, 14173, 14107, 3278, -923, -145,
            -145, -923, 3278, 14107, 14173, 3350, -922,  -150, -140, -924, 3207, 14040, 14239, 3423, -921, -154,
            -136, -924, 3136, 13972, 14303, 3496, -920,  -159, -132, -924, 3065, 13904, 14367, 3570, -918, -164,
            -127, -923, 2995, 13834, 14430, 3644, -916,  -169, -123, -923, 2926, 13764, 14492, 3719, -913, -174,
            -119, -922, 2857, 13693, 14553, 3795, -911,  -179, -115, -921, 2789, 13622, 14614, 3871, -908, -184,
            -111, -919, 2722, 13550, 14673, 3947, -904,  -190, -107, -918, 2655, 13477, 14732, 4024, -900, -195,
            -103, -916, 2589, 13403, 14790, 4102, -896,  -200, -100, -914, 2523, 13329, 14847, 4180, -892, -206,
            -96,  -911, 2459, 13254, 14903, 4259, -887,  -211, -92,  -909, 2394, 13178, 14958, 4338, -882, -217,
            -89,  -906, 2331, 13102, 15012, 4417, -876,  -223, -85,  -903, 2267, 13025, 15065, 4498, -870, -229,
            -82,  -899, 2205, 12947, 15117, 4578, -864,  -235, -79,  -896, 2143, 12869, 15168, 4659, -857, -241,
            -76,  -892, 2082, 12790, 15219, 4741, -850,  -247, -73,  -888, 2022, 12711, 15268, 4823, -842, -253,
            -70,  -884, 1962, 12631, 15317, 4905, -834,  -259, -67,  -880, 1902, 12551, 15364, 4988, -826, -265,
            -64,  -875, 1844, 12470, 15410, 5071, -817,  -272, -61,  -871, 1786, 12388, 15456, 5155, -807, -278,
            -58,  -866, 1729, 12306, 15500, 5239, -798,  -285, -56,  -861, 1672, 12224, 15544, 5323, -787, -291,
            -53,  -855, 1616, 12140, 15586, 5408, -777,  -298, -50,  -850, 1561, 12057, 15627, 5493, -766, -305,
            -48,  -845, 1506, 11973, 15668, 5579, -754,  -312, -46,  -839, 1452, 11888, 15707, 5665, -742, -318,
            -43,  -833, 1399, 11803, 15745, 5751, -730,  -325, -41,  -827, 1346, 11718, 15782, 5838, -717, -332,
            -39,  -821, 1294, 11632, 15818, 5925, -703,  -339, -37,  -815, 1243, 11546, 15853, 6013, -689, -347,
            -35,  -809, 1192, 11459, 15887, 6100, -675,  -354, -33,  -802, 1142, 11372, 15920, 6189, -660, -361,
            -31,  -796, 1093, 11285, 15952, 6277, -645,  -368, -29,  -789, 1044, 11197, 15983, 6366, -629, -376,
            -27,  -782, 996,  11109, 16012, 6454, -612,  -383, -26,  -775, 949,  11021, 16041, 6544, -596, -391,
            -24,  -768, 902,  10932, 16068, 6633, -578,  -398, -22,  -761, 856,  10843, 16095, 6723, -560, -406,
            -21,  -754, 810,  10754, 16120, 6813, -542,  -414, -19,  -747, 766,  10664, 16144, 6903, -523, -421,
            -18,  -739, 722,  10574, 16167, 6994, -503,  -429, -16,  -732, 678,  10484, 16189, 7084, -483, -437,
            -15,  -724, 635,  10394, 16209, 7175, -462,  -445, -14,  -717, 593,  10303, 16229, 7266, -441, -452,
            -13,  -709, 552,  10212, 16247, 7357, -419,  -460, -11,  -702, 511,  10121, 16265, 7449, -397, -468,
            -10,  -694, 471,  10030, 16281, 7540, -374,  -476, -9,   -686, 432,  9939,  16296, 7632, -351, -484,
            -8,   -678, 393,  9847,  16310, 7724, -327,  -492, -7,   -670, 355,  9756,  16322, 7816, -302, -500,
            -6,   -662, 317,  9664,  16334, 7908, -277,  -508, -5,   -654, 280,  9572,  16344, 8000, -251, -516,
            -5,   -646, 244,  9480,  16354, 8093, -225,  -525, -4,   -638, 208,  9387,  16362, 8185, -198, -533,
            -3,   -630, 173,  9295,  16369, 8277, -170,  -541, -2,   -622, 139,  9203,  16375, 8370, -142, -549,
            -2,   -614, 105,  9110,  16379, 8462, -113,  -557, -1,   -606, 72,   9018,  16383, 8555, -84,  -565,
            -1,   -598, 40,   8925,  16385, 8647, -54,   -573, 0,    -590, 8,    8833,  16386, 8740, -23,  -582,
        };

        private static readonly short[] _highCurveLut1 = {
            -12,  47,   -134,  32767, 81,     -16,   2,     0,    -26,  108,  -345,   32760, 301,   -79,   17,   -1,
            -40,  168,  -552,  32745, 526,    -144,  32,    -2,   -53,  226,  -753,   32723, 755,   -210,  47,   -3,
            -66,  284,  -950,  32694, 989,    -277,  63,    -5,   -78,  340,  -1143,  32658, 1226,  -346,  79,   -6,
            -90,  394,  -1331, 32615, 1469,   -415,  96,    -8,   -101, 447,  -1514,  32564, 1715,  -486,  113,  -9,
            -112, 499,  -1692, 32506, 1966,   -557,  130,   -11,  -123, 550,  -1865,  32441, 2221,  -630,  148,  -13,
            -133, 599,  -2034, 32369, 2480,   -703,  166,   -14,  -143, 646,  -2198,  32290, 2743,  -778,  185,  -16,
            -152, 693,  -2357, 32204, 3010,   -853,  204,   -18,  -162, 738,  -2512,  32110, 3281,  -929,  223,  -20,
            -170, 781,  -2662, 32010, 3555,   -1007, 242,   -23,  -178, 823,  -2807,  31903, 3834,  -1084, 262,  -25,
            -186, 864,  -2947, 31789, 4116,   -1163, 282,   -27,  -194, 903,  -3082,  31668, 4403,  -1242, 303,  -30,
            -201, 940,  -3213, 31540, 4692,   -1322, 323,   -32,  -207, 977,  -3339,  31406, 4985,  -1403, 344,  -35,
            -214, 1011, -3460, 31265, 5282,   -1484, 365,   -37,  -220, 1045, -3577,  31117, 5582,  -1566, 387,  -40,
            -225, 1077, -3688, 30963, 5885,   -1648, 409,   -43,  -230, 1107, -3796,  30802, 6191,  -1730, 431,  -46,
            -235, 1136, -3898, 30635, 6501,   -1813, 453,   -49,  -240, 1164, -3996,  30462, 6813,  -1896, 475,  -52,
            -244, 1190, -4089, 30282, 7128,   -1980, 498,   -55,  -247, 1215, -4178,  30097, 7446,  -2064, 520,  -58,
            -251, 1239, -4262, 29905, 7767,   -2148, 543,   -62,  -254, 1261, -4342,  29707, 8091,  -2231, 566,  -65,
            -257, 1281, -4417, 29503, 8416,   -2315, 589,   -69,  -259, 1301, -4488,  29293, 8745,  -2399, 613,  -72,
            -261, 1319, -4555, 29078, 9075,   -2483, 636,   -76,  -263, 1336, -4617,  28857, 9408,  -2567, 659,  -80,
            -265, 1351, -4674, 28631, 9743,   -2651, 683,   -83,  -266, 1365, -4728,  28399, 10080, -2734, 706,  -87,
            -267, 1378, -4777, 28161, 10418,  -2817, 730,   -91,  -267, 1389, -4822,  27919, 10759, -2899, 753,  -95,
            -268, 1400, -4863, 27671, 11100,  -2981, 777,   -99,  -268, 1409, -4900,  27418, 11444, -3063, 800,  -103,
            -268, 1416, -4933, 27161, 11789,  -3144, 824,   -107, -267, 1423, -4962,  26898, 12135, -3224, 847,  -112,
            -267, 1428, -4987, 26631, 12482,  -3303, 870,   -116, -266, 1433, -5008,  26359, 12830, -3382, 893,  -120,
            -265, 1436, -5026, 26083, 13179,  -3460, 916,   -125, -264, 1438, -5039,  25802, 13529, -3537, 939,  -129,
            -262, 1438, -5049, 25517, 13880,  -3613, 962,   -133, -260, 1438, -5055,  25228, 14231, -3687, 984,  -138,
            -258, 1437, -5058, 24935, 14582,  -3761, 1006,  -142, -256, 1435, -5058,  24639, 14934, -3833, 1028, -147,
            -254, 1431, -5053, 24338, 15286,  -3904, 1049,  -151, -252, 1427, -5046,  24034, 15638, -3974, 1071, -155,
            -249, 1422, -5035, 23726, 15989,  -4042, 1091,  -160, -246, 1416, -5021,  23415, 16341, -4109, 1112, -164,
            -243, 1408, -5004, 23101, 16691,  -4174, 1132,  -169, -240, 1400, -4984,  22783, 17042, -4237, 1152, -173,
            -237, 1392, -4960, 22463, 17392,  -4299, 1171,  -178, -234, 1382, -4934,  22140, 17740, -4358, 1190, -182,
            -230, 1371, -4905, 21814, 18088,  -4416, 1209,  -186, -227, 1360, -4873,  21485, 18435, -4472, 1226, -191,
            -223, 1348, -4839, 21154, 18781,  -4526, 1244,  -195, -219, 1335, -4801,  20821, 19125, -4578, 1260, -199,
            -215, 1321, -4761, 20486, 19468,  -4627, 1277,  -203, -211, 1307, -4719,  20148, 19809, -4674, 1292, -207,
            -207, 1292, -4674, 19809, 20148,  -4719, 1307,  -211, -203, 1277, -4627,  19468, 20486, -4761, 1321, -215,
            -199, 1260, -4578, 19125, 20821,  -4801, 1335,  -219, -195, 1244, -4526,  18781, 21154, -4839, 1348, -223,
            -191, 1226, -4472, 18435, 21485,  -4873, 1360,  -227, -186, 1209, -4416,  18088, 21814, -4905, 1371, -230,
            -182, 1190, -4358, 17740, 22140,  -4934, 1382,  -234, -178, 1171, -4299,  17392, 22463, -4960, 1392, -237,
            -173, 1152, -4237, 17042, 22783,  -4984, 1400,  -240, -169, 1132, -4174,  16691, 23101, -5004, 1408, -243,
            -164, 1112, -4109, 16341, 23415,  -5021, 1416,  -246, -160, 1091, -4042,  15989, 23726, -5035, 1422, -249,
            -155, 1071, -3974, 15638, 24034,  -5046, 1427,  -252, -151, 1049, -3904,  15286, 24338, -5053, 1431, -254,
            -147, 1028, -3833, 14934, 24639,  -5058, 1435,  -256, -142, 1006, -3761,  14582, 24935, -5058, 1437, -258,
            -138, 984,  -3687, 14231, 25228,  -5055, 1438,  -260, -133, 962,  -3613,  13880, 25517, -5049, 1438, -262,
            -129, 939,  -3537, 13529, 25802,  -5039, 1438,  -264, -125, 916,  -3460,  13179, 26083, -5026, 1436, -265,
            -120, 893,  -3382, 12830, 26359,  -5008, 1433,  -266, -116, 870,  -3303,  12482, 26631, -4987, 1428, -267,
            -112, 847,  -3224, 12135, 26898,  -4962, 1423,  -267, -107, 824,  -3144,  11789, 27161, -4933, 1416, -268,
            -103, 800,  -3063, 11444, 27418,  -4900, 1409,  -268, -99,  777,  -2981,  11100, 27671, -4863, 1400, -268,
            -95,  753,  -2899, 10759, 27919,  -4822, 1389,  -267, -91,  730,  -2817,  10418, 28161, -4777, 1378, -267,
            -87,  706,  -2734, 10080, 28399,  -4728, 1365,  -266, -83,  683,  -2651,  9743,  28631, -4674, 1351, -265,
            -80,  659,  -2567, 9408,  28857,  -4617, 1336,  -263, -76,  636,  -2483,  9075,  29078, -4555, 1319, -261,
            -72,  613,  -2399, 8745,  29293,  -4488, 1301,  -259, -69,  589,  -2315,  8416,  29503, -4417, 1281, -257,
            -65,  566,  -2231, 8091,  29707,  -4342, 1261,  -254, -62,  543,  -2148,  7767,  29905, -4262, 1239, -251,
            -58,  520,  -2064, 7446,  30097,  -4178, 1215,  -247, -55,  498,  -1980,  7128,  30282, -4089, 1190, -244,
            -52,  475,  -1896, 6813,  30462,  -3996, 1164,  -240, -49,  453,  -1813,  6501,  30635, -3898, 1136, -235,
            -46,  431,  -1730, 6191,  30802,  -3796, 1107,  -230, -43,  409,  -1648,  5885,  30963, -3688, 1077, -225,
            -40,  387,  -1566, 5582,  31117,  -3577, 1045,  -220, -37,  365,  -1484,  5282,  31265, -3460, 1011, -214,
            -35,  344,  -1403, 4985,  31406,  -3339, 977,   -207, -32,  323,  -1322,  4692,  31540, -3213, 940,  -201,
            -30,  303,  -1242, 4403,  31668,  -3082, 903,   -194, -27,  282,  -1163,  4116,  31789, -2947, 864,  -186,
            -25,  262,  -1084, 3834,  31903,  -2807, 823,   -178, -23,  242,  -1007,  3555,  32010, -2662, 781,  -170,
            -20,  223,  -929,  3281,  32110,  -2512, 738,   -162, -18,  204,  -853,   3010,  32204, -2357, 693,  -152,
            -16,  185,  -778,  2743,  32290,  -2198, 646,   -143, -14,  166,  -703,   2480,  32369, -2034, 599,  -133,
            -13,  148,  -630,  2221,  32441,  -1865, 550,   -123, -11,  130,  -557,   1966,  32506, -1692, 499,  -112,
            -9,   113,  -486,  1715,  32564,  -1514, 447,   -101, -8,   96,   -415,   1469,  32615, -1331, 394,  -90,
            -6,   79,   -346,  1226,  32658,  -1143, 340,   -78,  -5,   63,   -277,   989,   32694, -950,  284,  -66,
            -3,   47,   -210,  755,   32723,  -753,  226,   -53,  -2,   32,   -144,   526,   32745, -552,  168,  -40,
            -1,   17,   -79,   301,   32760,  -345,  108,   -26,  0,    2,    -16,    81,    32767, -134,  47,   -12,
        };

        private static readonly short[] _highCurveLut2 = {
            418, -2538, 6118,  24615, 6298,  -2563, 417,   0,   420, -2512, 5939,  24611, 6479,  -2588, 415,   1,
            421, -2485, 5761,  24605, 6662,  -2612, 412,   2,   422, -2458, 5585,  24595, 6846,  -2635, 409,   3,
            423, -2430, 5410,  24582, 7030,  -2658, 406,   4,   423, -2402, 5236,  24565, 7216,  -2680, 403,   5,
            423, -2373, 5064,  24546, 7403,  -2701, 399,   6,   423, -2343, 4893,  24523, 7591,  -2721, 395,   7,
            423, -2313, 4724,  24496, 7780,  -2741, 391,   8,   422, -2283, 4556,  24467, 7970,  -2759, 386,   9,
            421, -2252, 4390,  24434, 8161,  -2777, 381,   11,  420, -2221, 4225,  24398, 8353,  -2794, 376,   12,
            419, -2190, 4062,  24359, 8545,  -2810, 370,   14,  418, -2158, 3900,  24316, 8739,  -2825, 364,   15,
            416, -2126, 3740,  24271, 8933,  -2839, 358,   17,  414, -2093, 3582,  24222, 9127,  -2851, 351,   19,
            412, -2060, 3425,  24170, 9323,  -2863, 344,   21,  410, -2027, 3270,  24115, 9519,  -2874, 336,   22,
            407, -1993, 3117,  24056, 9715,  -2884, 328,   24,  404, -1960, 2966,  23995, 9912,  -2893, 319,   26,
            402, -1926, 2816,  23930, 10110, -2900, 311,   29,  398, -1892, 2668,  23863, 10308, -2907, 301,   31,
            395, -1858, 2522,  23792, 10506, -2912, 292,   33,  392, -1823, 2378,  23718, 10705, -2916, 282,   35,
            389, -1789, 2235,  23641, 10904, -2919, 271,   38,  385, -1754, 2095,  23561, 11103, -2920, 261,   40,
            381, -1719, 1956,  23478, 11303, -2921, 249,   43,  377, -1684, 1819,  23393, 11502, -2920, 238,   45,
            373, -1649, 1684,  23304, 11702, -2917, 225,   48,  369, -1615, 1551,  23212, 11902, -2914, 213,   51,
            365, -1580, 1420,  23118, 12102, -2909, 200,   54,  361, -1545, 1291,  23020, 12302, -2902, 186,   57,
            356, -1510, 1163,  22920, 12502, -2895, 173,   60,  352, -1475, 1038,  22817, 12702, -2885, 158,   63,
            347, -1440, 915,   22711, 12901, -2875, 143,   66,  342, -1405, 793,   22602, 13101, -2863, 128,   69,
            338, -1370, 674,   22491, 13300, -2849, 113,   73,  333, -1335, 557,   22377, 13499, -2834, 97,    76,
            328, -1301, 441,   22260, 13698, -2817, 80,    80,  323, -1266, 328,   22141, 13896, -2799, 63,    83,
            318, -1232, 217,   22019, 14094, -2779, 46,    87,  313, -1197, 107,   21894, 14291, -2758, 28,    91,
            307, -1163, 0,     21767, 14488, -2735, 9,     95,  302, -1129, -105,  21637, 14684, -2710, -9,    98,
            297, -1096, -208,  21506, 14879, -2684, -29,   102, 292, -1062, -310,  21371, 15074, -2656, -48,   106,
            286, -1029, -409,  21234, 15268, -2626, -69,   111, 281, -996,  -506,  21095, 15461, -2595, -89,   115,
            276, -963,  -601,  20954, 15654, -2562, -110,  119, 270, -930,  -694,  20810, 15846, -2527, -132,  123,
            265, -898,  -785,  20664, 16036, -2490, -154,  128, 260, -866,  -874,  20516, 16226, -2452, -176,  132,
            254, -834,  -961,  20366, 16415, -2411, -199,  137, 249, -803,  -1046, 20213, 16602, -2369, -222,  141,
            243, -771,  -1129, 20059, 16789, -2326, -246,  146, 238, -740,  -1209, 19902, 16974, -2280, -270,  151,
            233, -710,  -1288, 19744, 17158, -2232, -294,  156, 227, -680,  -1365, 19583, 17341, -2183, -319,  160,
            222, -650,  -1440, 19421, 17523, -2132, -345,  165, 217, -620,  -1513, 19257, 17703, -2079, -370,  170,
            211, -591,  -1583, 19091, 17882, -2023, -396,  175, 206, -562,  -1652, 18923, 18059, -1966, -423,  180,
            201, -533,  -1719, 18754, 18235, -1907, -450,  185, 196, -505,  -1784, 18582, 18410, -1847, -477,  191,
            191, -477,  -1847, 18410, 18582, -1784, -505,  196, 185, -450,  -1907, 18235, 18754, -1719, -533,  201,
            180, -423,  -1966, 18059, 18923, -1652, -562,  206, 175, -396,  -2023, 17882, 19091, -1583, -591,  211,
            170, -370,  -2079, 17703, 19257, -1513, -620,  217, 165, -345,  -2132, 17523, 19421, -1440, -650,  222,
            160, -319,  -2183, 17341, 19583, -1365, -680,  227, 156, -294,  -2232, 17158, 19744, -1288, -710,  233,
            151, -270,  -2280, 16974, 19902, -1209, -740,  238, 146, -246,  -2326, 16789, 20059, -1129, -771,  243,
            141, -222,  -2369, 16602, 20213, -1046, -803,  249, 137, -199,  -2411, 16415, 20366, -961,  -834,  254,
            132, -176,  -2452, 16226, 20516, -874,  -866,  260, 128, -154,  -2490, 16036, 20664, -785,  -898,  265,
            123, -132,  -2527, 15846, 20810, -694,  -930,  270, 119, -110,  -2562, 15654, 20954, -601,  -963,  276,
            115, -89,   -2595, 15461, 21095, -506,  -996,  281, 111, -69,   -2626, 15268, 21234, -409,  -1029, 286,
            106, -48,   -2656, 15074, 21371, -310,  -1062, 292, 102, -29,   -2684, 14879, 21506, -208,  -1096, 297,
            98,  -9,    -2710, 14684, 21637, -105,  -1129, 302, 95,  9,     -2735, 14488, 21767, 0,     -1163, 307,
            91,  28,    -2758, 14291, 21894, 107,   -1197, 313, 87,  46,    -2779, 14094, 22019, 217,   -1232, 318,
            83,  63,    -2799, 13896, 22141, 328,   -1266, 323, 80,  80,    -2817, 13698, 22260, 441,   -1301, 328,
            76,  97,    -2834, 13499, 22377, 557,   -1335, 333, 73,  113,   -2849, 13300, 22491, 674,   -1370, 338,
            69,  128,   -2863, 13101, 22602, 793,   -1405, 342, 66,  143,   -2875, 12901, 22711, 915,   -1440, 347,
            63,  158,   -2885, 12702, 22817, 1038,  -1475, 352, 60,  173,   -2895, 12502, 22920, 1163,  -1510, 356,
            57,  186,   -2902, 12302, 23020, 1291,  -1545, 361, 54,  200,   -2909, 12102, 23118, 1420,  -1580, 365,
            51,  213,   -2914, 11902, 23212, 1551,  -1615, 369, 48,  225,   -2917, 11702, 23304, 1684,  -1649, 373,
            45,  238,   -2920, 11502, 23393, 1819,  -1684, 377, 43,  249,   -2921, 11303, 23478, 1956,  -1719, 381,
            40,  261,   -2920, 11103, 23561, 2095,  -1754, 385, 38,  271,   -2919, 10904, 23641, 2235,  -1789, 389,
            35,  282,   -2916, 10705, 23718, 2378,  -1823, 392, 33,  292,   -2912, 10506, 23792, 2522,  -1858, 395,
            31,  301,   -2907, 10308, 23863, 2668,  -1892, 398, 29,  311,   -2900, 10110, 23930, 2816,  -1926, 402,
            26,  319,   -2893, 9912,  23995, 2966,  -1960, 404, 24,  328,   -2884, 9715,  24056, 3117,  -1993, 407,
            22,  336,   -2874, 9519,  24115, 3270,  -2027, 410, 21,  344,   -2863, 9323,  24170, 3425,  -2060, 412,
            19,  351,   -2851, 9127,  24222, 3582,  -2093, 414, 17,  358,   -2839, 8933,  24271, 3740,  -2126, 416,
            15,  364,   -2825, 8739,  24316, 3900,  -2158, 418, 14,  370,   -2810, 8545,  24359, 4062,  -2190, 419,
            12,  376,   -2794, 8353,  24398, 4225,  -2221, 420, 11,  381,   -2777, 8161,  24434, 4390,  -2252, 421,
            9,   386,   -2759, 7970,  24467, 4556,  -2283, 422, 8,   391,   -2741, 7780,  24496, 4724,  -2313, 423,
            7,   395,   -2721, 7591,  24523, 4893,  -2343, 423, 6,   399,   -2701, 7403,  24546, 5064,  -2373, 423,
            5,   403,   -2680, 7216,  24565, 5236,  -2402, 423, 4,   406,   -2658, 7030,  24582, 5410,  -2430, 423,
            3,   409,   -2635, 6846,  24595, 5585,  -2458, 422, 2,   412,   -2612, 6662,  24605, 5761,  -2485, 421,
            1,   415,   -2588, 6479,  24611, 5939,  -2512, 420, 0,   417,   -2563, 6298,  24615, 6118,  -2538, 418,
        };
        #endregion

        private static readonly float[] _normalCurveLut0F;
        private static readonly float[] _normalCurveLut1F;
        private static readonly float[] _normalCurveLut2F;

        private static readonly float[] _highCurveLut0F;
        private static readonly float[] _highCurveLut1F;
        private static readonly float[] _highCurveLut2F;

        static ResamplerHelper()
        {
            _normalCurveLut0F = _normalCurveLut0.Select(x => x / 32768f).ToArray();
            _normalCurveLut1F = _normalCurveLut1.Select(x => x / 32768f).ToArray();
            _normalCurveLut2F = _normalCurveLut2.Select(x => x / 32768f).ToArray();

            _highCurveLut0F = _highCurveLut0.Select(x => x / 32768f).ToArray();
            _highCurveLut1F = _highCurveLut1.Select(x => x / 32768f).ToArray();
            _highCurveLut2F = _highCurveLut2.Select(x => x / 32768f).ToArray();
        }

        private const int FixedPointPrecision = 15;

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void Resample(Span<float> outputBuffer, ReadOnlySpan<short> inputBuffer, float ratio, ref float fraction, int sampleCount, SampleRateConversionQuality srcQuality, bool needPitch)
        {
            switch (srcQuality)
            {
                case SampleRateConversionQuality.Default:
                    ResampleDefaultQuality(outputBuffer, inputBuffer, ratio, ref fraction, sampleCount, needPitch);
                    break;
                case SampleRateConversionQuality.Low:
                    ResampleLowQuality(outputBuffer, inputBuffer, ratio, ref fraction, sampleCount);
                    break;
                case SampleRateConversionQuality.High:
                    ResampleHighQuality(outputBuffer, inputBuffer, ratio, ref fraction, sampleCount);
                    break;
                default:
                    throw new NotImplementedException($"{srcQuality}");
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        private static ReadOnlySpan<float> GetDefaultParameter(float ratio)
        {
            if (ratio <= 1.0f)
            {
                return _normalCurveLut1F;
            }

            if (ratio > 1.333313f)
            {
                return _normalCurveLut0F;
            }

            return _normalCurveLut2F;
        }

        private unsafe static void ResampleDefaultQuality(Span<float> outputBuffer, ReadOnlySpan<short> inputBuffer, float ratio, ref float fraction, int sampleCount, bool needPitch)
        {
            ReadOnlySpan<float> parameters = GetDefaultParameter(ratio);

            int inputBufferIndex = 0, i = 0;

            // TODO: REV8 fast path (when needPitch == false the input index progression is constant + we need SIMD)

            if (Sse41.IsSupported)
            {
                if (ratio == 1f)
                {
                    fixed (short* pInput = inputBuffer)
                    fixed (float* pOutput = outputBuffer, pParameters = parameters)
                    {
                        Vector128<float> parameter = Sse.LoadVector128(pParameters);

                        for (; i < (sampleCount & ~3); i += 4)
                        {
                            Vector128<int> intInput0 = Sse41.ConvertToVector128Int32(pInput + (uint)i);
                            Vector128<int> intInput1 = Sse41.ConvertToVector128Int32(pInput + (uint)i + 1);
                            Vector128<int> intInput2 = Sse41.ConvertToVector128Int32(pInput + (uint)i + 2);
                            Vector128<int> intInput3 = Sse41.ConvertToVector128Int32(pInput + (uint)i + 3);

                            Vector128<float> input0 = Sse2.ConvertToVector128Single(intInput0);
                            Vector128<float> input1 = Sse2.ConvertToVector128Single(intInput1);
                            Vector128<float> input2 = Sse2.ConvertToVector128Single(intInput2);
                            Vector128<float> input3 = Sse2.ConvertToVector128Single(intInput3);

                            Vector128<float> mix0 = Sse.Multiply(input0, parameter);
                            Vector128<float> mix1 = Sse.Multiply(input1, parameter);
                            Vector128<float> mix2 = Sse.Multiply(input2, parameter);
                            Vector128<float> mix3 = Sse.Multiply(input3, parameter);

                            Vector128<float> mix01 = Sse3.HorizontalAdd(mix0, mix1);
                            Vector128<float> mix23 = Sse3.HorizontalAdd(mix2, mix3);

                            Vector128<float> mix0123 = Sse3.HorizontalAdd(mix01, mix23);

                            Sse.Store(pOutput + (uint)i, Sse41.RoundToNearestInteger(mix0123));
                        }
                    }

                    inputBufferIndex = i;
                }
                else
                {
                    fixed (short* pInput = inputBuffer)
                    fixed (float* pOutput = outputBuffer, pParameters = parameters)
                    {
                        for (; i < (sampleCount & ~3); i += 4)
                        {
                            uint baseIndex0 = (uint)(fraction * 128) * 4;
                            uint inputIndex0 = (uint)inputBufferIndex;

                            fraction += ratio;

                            uint baseIndex1 = ((uint)(fraction * 128) & 127) * 4;
                            uint inputIndex1 = (uint)inputBufferIndex + (uint)fraction;

                            fraction += ratio;

                            uint baseIndex2 = ((uint)(fraction * 128) & 127) * 4;
                            uint inputIndex2 = (uint)inputBufferIndex + (uint)fraction;

                            fraction += ratio;

                            uint baseIndex3 = ((uint)(fraction * 128) & 127) * 4;
                            uint inputIndex3 = (uint)inputBufferIndex + (uint)fraction;

                            fraction += ratio;
                            inputBufferIndex += (int)fraction;

                            // Only keep lower part (safe as fraction isn't supposed to be negative)
                            fraction -= (int)fraction;

                            Vector128<float> parameter0 = Sse.LoadVector128(pParameters + baseIndex0);
                            Vector128<float> parameter1 = Sse.LoadVector128(pParameters + baseIndex1);
                            Vector128<float> parameter2 = Sse.LoadVector128(pParameters + baseIndex2);
                            Vector128<float> parameter3 = Sse.LoadVector128(pParameters + baseIndex3);

                            Vector128<int> intInput0 = Sse41.ConvertToVector128Int32(pInput + inputIndex0);
                            Vector128<int> intInput1 = Sse41.ConvertToVector128Int32(pInput + inputIndex1);
                            Vector128<int> intInput2 = Sse41.ConvertToVector128Int32(pInput + inputIndex2);
                            Vector128<int> intInput3 = Sse41.ConvertToVector128Int32(pInput + inputIndex3);

                            Vector128<float> input0 = Sse2.ConvertToVector128Single(intInput0);
                            Vector128<float> input1 = Sse2.ConvertToVector128Single(intInput1);
                            Vector128<float> input2 = Sse2.ConvertToVector128Single(intInput2);
                            Vector128<float> input3 = Sse2.ConvertToVector128Single(intInput3);

                            Vector128<float> mix0 = Sse.Multiply(input0, parameter0);
                            Vector128<float> mix1 = Sse.Multiply(input1, parameter1);
                            Vector128<float> mix2 = Sse.Multiply(input2, parameter2);
                            Vector128<float> mix3 = Sse.Multiply(input3, parameter3);

                            Vector128<float> mix01 = Sse3.HorizontalAdd(mix0, mix1);
                            Vector128<float> mix23 = Sse3.HorizontalAdd(mix2, mix3);

                            Vector128<float> mix0123 = Sse3.HorizontalAdd(mix01, mix23);

                            Sse.Store(pOutput + (uint)i, Sse41.RoundToNearestInteger(mix0123));
                        }
                    }
                }
            }

            for (; i < sampleCount; i++)
            {
                int baseIndex = (int)(fraction * 128) * 4;
                ReadOnlySpan<float> parameter = parameters.Slice(baseIndex, 4);
                ReadOnlySpan<short> currentInput = inputBuffer.Slice(inputBufferIndex, 4);

                outputBuffer[i] = (float)Math.Round(currentInput[0] * parameter[0] +
                                                    currentInput[1] * parameter[1] +
                                                    currentInput[2] * parameter[2] +
                                                    currentInput[3] * parameter[3]);

                fraction += ratio;
                inputBufferIndex += (int)fraction;

                // Only keep lower part (safe as fraction isn't supposed to be negative)
                fraction -= (int)fraction;
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        private static ReadOnlySpan<float> GetHighParameter(float ratio)
        {
            if (ratio <= 1.0f)
            {
                return _highCurveLut1F;
            }

            if (ratio > 1.333313f)
            {
                return _highCurveLut0F;
            }

            return _highCurveLut2F;
        }

        private static unsafe void ResampleHighQuality(Span<float> outputBuffer, ReadOnlySpan<short> inputBuffer, float ratio, ref float fraction, int sampleCount)
        {
            ReadOnlySpan<float> parameters = GetHighParameter(ratio);

            int inputBufferIndex = 0;

            if (Avx2.IsSupported)
            {
                // Fast path; assumes 256-bit vectors for simplicity because the filter is 8 taps
                fixed (short* pInput = inputBuffer)
                fixed (float* pParameters = parameters)
                {
                    for (int i = 0; i < sampleCount; i++)
                    {
                        int baseIndex = (int)(fraction * 128) * 8;

                        Vector256<int> intInput = Avx2.ConvertToVector256Int32(pInput + inputBufferIndex);
                        Vector256<float> floatInput = Avx.ConvertToVector256Single(intInput);
                        Vector256<float> parameter = Avx.LoadVector256(pParameters + baseIndex);
                        Vector256<float> dp = Avx.DotProduct(floatInput, parameter, control: 0xFF);

                        // avx2 does an 8-element dot product piecewise so we have to sum up 2 intermediate results
                        outputBuffer[i] = (float)Math.Round(dp[0] + dp[4]);

                        fraction += ratio;
                        inputBufferIndex += (int)MathF.Truncate(fraction);

                        fraction -= (int)fraction;
                    }
                }
            }
            else
            {
                for (int i = 0; i < sampleCount; i++)
                {
                    int baseIndex = (int)(fraction * 128) * 8;
                    ReadOnlySpan<float> parameter = parameters.Slice(baseIndex, 8);
                    ReadOnlySpan<short> currentInput = inputBuffer.Slice(inputBufferIndex, 8);

                    outputBuffer[i] = (float)Math.Round(currentInput[0] * parameter[0] +
                                                        currentInput[1] * parameter[1] +
                                                        currentInput[2] * parameter[2] +
                                                        currentInput[3] * parameter[3] +
                                                        currentInput[4] * parameter[4] +
                                                        currentInput[5] * parameter[5] +
                                                        currentInput[6] * parameter[6] +
                                                        currentInput[7] * parameter[7]);

                    fraction += ratio;
                    inputBufferIndex += (int)MathF.Truncate(fraction);

                    fraction -= (int)fraction;
                }
            }
        }

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public static void ResampleLowQuality(Span<float> outputBuffer, ReadOnlySpan<short> inputBuffer, float ratio, ref float fraction, int sampleCount)
        {
            int inputBufferIndex = 0;

            for (int i = 0; i < sampleCount; i++)
            {
                int outputData = inputBuffer[inputBufferIndex];

                if (fraction > 1.0f)
                {
                    outputData = inputBuffer[inputBufferIndex + 1];
                }

                outputBuffer[i] = outputData;

                fraction += ratio;
                inputBufferIndex += (int)MathF.Truncate(fraction);

                fraction -= (int)fraction;
            }
        }
    }
}
