namespace ARMeilleure.Decoders
{
    class OpCodeT32Alu : OpCodeT32, IOpCode32Alu
    {
        public int Rd { get; }
        public int Rn { get; }

        public bool? SetFlags { get; }

        public new static OpCode Create(InstDescriptor inst, ulong address, int opCode) => new OpCodeT32Alu(inst, address, opCode);

        public OpCodeT32Alu(InstDescriptor inst, ulong address, int opCode) : base(inst, address, opCode)
        {
            Rd = (opCode >> 8) & 0xf;
            Rn = (opCode >> 16) & 0xf;

            SetFlags = ((opCode >> 20) & 1) != 0;
        }
    }
}
