namespace ARMeilleure.Decoders
{
    class OpCodeT16AluRegHigh : OpCodeT16, IOpCode32AluReg
    {
        public int Rm { get; }
        public int Rd { get; }
        public int Rn { get; }

        public bool? SetFlags => false;

        public static new OpCode Create(InstDescriptor inst, ulong address, int opCode) => new OpCodeT16AluRegHigh(inst, address, opCode);

        public OpCodeT16AluRegHigh(InstDescriptor inst, ulong address, int opCode) : base(inst, address, opCode)
        {
            Rd = ((opCode >> 0) & 0x7) | ((opCode >> 4) & 0x8);
            Rn = ((opCode >> 0) & 0x7) | ((opCode >> 4) & 0x8);
            Rm = (opCode >> 3) & 0xf;
        }
    }
}
