using ARMeilleure.Common;
using ARMeilleure.IntermediateRepresentation;

namespace ARMeilleure.CodeGen.Arm64
{
    static class IntrinsicTable
    {
        private static readonly IntrinsicInfo[] _intrinTable;

        static IntrinsicTable()
        {
            _intrinTable = new IntrinsicInfo[EnumUtils.GetCount(typeof(Intrinsic))];

#pragma warning disable IDE0055 // Disable formatting
            Add(Intrinsic.Arm64AbsS,          new IntrinsicInfo(0x5e20b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64AbsV,          new IntrinsicInfo(0x0e20b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64AddhnV,        new IntrinsicInfo(0x0e204000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64AddpS,         new IntrinsicInfo(0x5e31b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64AddpV,         new IntrinsicInfo(0x0e20bc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64AddvV,         new IntrinsicInfo(0x0e31b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64AddS,          new IntrinsicInfo(0x5e208400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64AddV,          new IntrinsicInfo(0x0e208400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64AesdV,         new IntrinsicInfo(0x4e285800u, IntrinsicType.Vector128BinaryRd));
            Add(Intrinsic.Arm64AeseV,         new IntrinsicInfo(0x4e284800u, IntrinsicType.Vector128BinaryRd));
            Add(Intrinsic.Arm64AesimcV,       new IntrinsicInfo(0x4e287800u, IntrinsicType.Vector128Unary));
            Add(Intrinsic.Arm64AesmcV,        new IntrinsicInfo(0x4e286800u, IntrinsicType.Vector128Unary));
            Add(Intrinsic.Arm64AndV,          new IntrinsicInfo(0x0e201c00u, IntrinsicType.VectorBinaryBitwise));
            Add(Intrinsic.Arm64BicVi,         new IntrinsicInfo(0x2f001400u, IntrinsicType.VectorBinaryBitwiseImm));
            Add(Intrinsic.Arm64BicV,          new IntrinsicInfo(0x0e601c00u, IntrinsicType.VectorBinaryBitwise));
            Add(Intrinsic.Arm64BifV,          new IntrinsicInfo(0x2ee01c00u, IntrinsicType.VectorTernaryRdBitwise));
            Add(Intrinsic.Arm64BitV,          new IntrinsicInfo(0x2ea01c00u, IntrinsicType.VectorTernaryRdBitwise));
            Add(Intrinsic.Arm64BslV,          new IntrinsicInfo(0x2e601c00u, IntrinsicType.VectorTernaryRdBitwise));
            Add(Intrinsic.Arm64ClsV,          new IntrinsicInfo(0x0e204800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64ClzV,          new IntrinsicInfo(0x2e204800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmeqS,         new IntrinsicInfo(0x7e208c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmeqV,         new IntrinsicInfo(0x2e208c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CmeqSz,        new IntrinsicInfo(0x5e209800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64CmeqVz,        new IntrinsicInfo(0x0e209800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmgeS,         new IntrinsicInfo(0x5e203c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmgeV,         new IntrinsicInfo(0x0e203c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CmgeSz,        new IntrinsicInfo(0x7e208800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64CmgeVz,        new IntrinsicInfo(0x2e208800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmgtS,         new IntrinsicInfo(0x5e203400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmgtV,         new IntrinsicInfo(0x0e203400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CmgtSz,        new IntrinsicInfo(0x5e208800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64CmgtVz,        new IntrinsicInfo(0x0e208800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmhiS,         new IntrinsicInfo(0x7e203400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmhiV,         new IntrinsicInfo(0x2e203400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CmhsS,         new IntrinsicInfo(0x7e203c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmhsV,         new IntrinsicInfo(0x2e203c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CmleSz,        new IntrinsicInfo(0x7e209800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64CmleVz,        new IntrinsicInfo(0x2e209800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmltSz,        new IntrinsicInfo(0x5e20a800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64CmltVz,        new IntrinsicInfo(0x0e20a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64CmtstS,        new IntrinsicInfo(0x5e208c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64CmtstV,        new IntrinsicInfo(0x0e208c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64CntV,          new IntrinsicInfo(0x0e205800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64DupSe,         new IntrinsicInfo(0x5e000400u, IntrinsicType.ScalarUnaryByElem));
            Add(Intrinsic.Arm64DupVe,         new IntrinsicInfo(0x0e000400u, IntrinsicType.VectorUnaryByElem));
            Add(Intrinsic.Arm64DupGp,         new IntrinsicInfo(0x0e000c00u, IntrinsicType.VectorUnaryByElem));
            Add(Intrinsic.Arm64EorV,          new IntrinsicInfo(0x2e201c00u, IntrinsicType.VectorBinaryBitwise));
            Add(Intrinsic.Arm64ExtV,          new IntrinsicInfo(0x2e000000u, IntrinsicType.VectorExt));
            Add(Intrinsic.Arm64FabdS,         new IntrinsicInfo(0x7ea0d400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FabdV,         new IntrinsicInfo(0x2ea0d400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FabsV,         new IntrinsicInfo(0x0ea0f800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FabsS,         new IntrinsicInfo(0x1e20c000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FacgeS,        new IntrinsicInfo(0x7e20ec00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FacgeV,        new IntrinsicInfo(0x2e20ec00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FacgtS,        new IntrinsicInfo(0x7ea0ec00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FacgtV,        new IntrinsicInfo(0x2ea0ec00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FaddpS,        new IntrinsicInfo(0x7e30d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FaddpV,        new IntrinsicInfo(0x2e20d400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FaddV,         new IntrinsicInfo(0x0e20d400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FaddS,         new IntrinsicInfo(0x1e202800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FccmpeS,       new IntrinsicInfo(0x1e200410u, IntrinsicType.ScalarFPCompareCond));
            Add(Intrinsic.Arm64FccmpS,        new IntrinsicInfo(0x1e200400u, IntrinsicType.ScalarFPCompareCond));
            Add(Intrinsic.Arm64FcmeqS,        new IntrinsicInfo(0x5e20e400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FcmeqV,        new IntrinsicInfo(0x0e20e400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FcmeqSz,       new IntrinsicInfo(0x5ea0d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcmeqVz,       new IntrinsicInfo(0x0ea0d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcmgeS,        new IntrinsicInfo(0x7e20e400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FcmgeV,        new IntrinsicInfo(0x2e20e400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FcmgeSz,       new IntrinsicInfo(0x7ea0c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcmgeVz,       new IntrinsicInfo(0x2ea0c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcmgtS,        new IntrinsicInfo(0x7ea0e400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FcmgtV,        new IntrinsicInfo(0x2ea0e400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FcmgtSz,       new IntrinsicInfo(0x5ea0c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcmgtVz,       new IntrinsicInfo(0x0ea0c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcmleSz,       new IntrinsicInfo(0x7ea0d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcmleVz,       new IntrinsicInfo(0x2ea0d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcmltSz,       new IntrinsicInfo(0x5ea0e800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcmltVz,       new IntrinsicInfo(0x0ea0e800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcmpeS,        new IntrinsicInfo(0x1e202010u, IntrinsicType.ScalarFPCompare));
            Add(Intrinsic.Arm64FcmpS,         new IntrinsicInfo(0x1e202000u, IntrinsicType.ScalarFPCompare));
            Add(Intrinsic.Arm64FcselS,        new IntrinsicInfo(0x1e200c00u, IntrinsicType.ScalarFcsel));
            Add(Intrinsic.Arm64FcvtasS,       new IntrinsicInfo(0x5e21c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtasV,       new IntrinsicInfo(0x0e21c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtasGp,      new IntrinsicInfo(0x1e240000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtauS,       new IntrinsicInfo(0x7e21c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtauV,       new IntrinsicInfo(0x2e21c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtauGp,      new IntrinsicInfo(0x1e250000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtlV,        new IntrinsicInfo(0x0e217800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtmsS,       new IntrinsicInfo(0x5e21b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtmsV,       new IntrinsicInfo(0x0e21b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtmsGp,      new IntrinsicInfo(0x1e300000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtmuS,       new IntrinsicInfo(0x7e21b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtmuV,       new IntrinsicInfo(0x2e21b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtmuGp,      new IntrinsicInfo(0x1e310000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtnsS,       new IntrinsicInfo(0x5e21a800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtnsV,       new IntrinsicInfo(0x0e21a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtnsGp,      new IntrinsicInfo(0x1e200000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtnuS,       new IntrinsicInfo(0x7e21a800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtnuV,       new IntrinsicInfo(0x2e21a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtnuGp,      new IntrinsicInfo(0x1e210000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtnV,        new IntrinsicInfo(0x0e216800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64FcvtpsS,       new IntrinsicInfo(0x5ea1a800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtpsV,       new IntrinsicInfo(0x0ea1a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtpsGp,      new IntrinsicInfo(0x1e280000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtpuS,       new IntrinsicInfo(0x7ea1a800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtpuV,       new IntrinsicInfo(0x2ea1a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtpuGp,      new IntrinsicInfo(0x1e290000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtxnS,       new IntrinsicInfo(0x7e216800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtxnV,       new IntrinsicInfo(0x2e216800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtzsSFixed,  new IntrinsicInfo(0x5f00fc00u, IntrinsicType.ScalarFPConvFixed));
            Add(Intrinsic.Arm64FcvtzsVFixed,  new IntrinsicInfo(0x0f00fc00u, IntrinsicType.VectorFPConvFixed));
            Add(Intrinsic.Arm64FcvtzsS,       new IntrinsicInfo(0x5ea1b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtzsV,       new IntrinsicInfo(0x0ea1b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtzsGpFixed, new IntrinsicInfo(0x1e180000u, IntrinsicType.ScalarFPConvFixedGpr));
            Add(Intrinsic.Arm64FcvtzsGp,      new IntrinsicInfo(0x1e380000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtzuSFixed,  new IntrinsicInfo(0x7f00fc00u, IntrinsicType.ScalarFPConvFixed));
            Add(Intrinsic.Arm64FcvtzuVFixed,  new IntrinsicInfo(0x2f00fc00u, IntrinsicType.VectorFPConvFixed));
            Add(Intrinsic.Arm64FcvtzuS,       new IntrinsicInfo(0x7ea1b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FcvtzuV,       new IntrinsicInfo(0x2ea1b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FcvtzuGpFixed, new IntrinsicInfo(0x1e190000u, IntrinsicType.ScalarFPConvFixedGpr));
            Add(Intrinsic.Arm64FcvtzuGp,      new IntrinsicInfo(0x1e390000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FcvtS,         new IntrinsicInfo(0x1e224000u, IntrinsicType.ScalarFPConv));
            Add(Intrinsic.Arm64FdivV,         new IntrinsicInfo(0x2e20fc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FdivS,         new IntrinsicInfo(0x1e201800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FmaddS,        new IntrinsicInfo(0x1f000000u, IntrinsicType.ScalarTernary));
            Add(Intrinsic.Arm64FmaxnmpS,      new IntrinsicInfo(0x7e30c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FmaxnmpV,      new IntrinsicInfo(0x2e20c400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmaxnmvV,      new IntrinsicInfo(0x2e30c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FmaxnmV,       new IntrinsicInfo(0x0e20c400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmaxnmS,       new IntrinsicInfo(0x1e206800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FmaxpS,        new IntrinsicInfo(0x7e30f800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FmaxpV,        new IntrinsicInfo(0x2e20f400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmaxvV,        new IntrinsicInfo(0x2e30f800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FmaxV,         new IntrinsicInfo(0x0e20f400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmaxS,         new IntrinsicInfo(0x1e204800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FminnmpS,      new IntrinsicInfo(0x7eb0c800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FminnmpV,      new IntrinsicInfo(0x2ea0c400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FminnmvV,      new IntrinsicInfo(0x2eb0c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FminnmV,       new IntrinsicInfo(0x0ea0c400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FminnmS,       new IntrinsicInfo(0x1e207800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FminpS,        new IntrinsicInfo(0x7eb0f800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FminpV,        new IntrinsicInfo(0x2ea0f400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FminvV,        new IntrinsicInfo(0x2eb0f800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FminV,         new IntrinsicInfo(0x0ea0f400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FminS,         new IntrinsicInfo(0x1e205800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FmlaSe,        new IntrinsicInfo(0x5f801000u, IntrinsicType.ScalarTernaryFPRdByElem));
            Add(Intrinsic.Arm64FmlaVe,        new IntrinsicInfo(0x0f801000u, IntrinsicType.VectorTernaryFPRdByElem));
            Add(Intrinsic.Arm64FmlaV,         new IntrinsicInfo(0x0e20cc00u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64FmlsSe,        new IntrinsicInfo(0x5f805000u, IntrinsicType.ScalarTernaryFPRdByElem));
            Add(Intrinsic.Arm64FmlsVe,        new IntrinsicInfo(0x0f805000u, IntrinsicType.VectorTernaryFPRdByElem));
            Add(Intrinsic.Arm64FmlsV,         new IntrinsicInfo(0x0ea0cc00u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64FmovVi,        new IntrinsicInfo(0x0f00f400u, IntrinsicType.VectorFmovi));
            Add(Intrinsic.Arm64FmovS,         new IntrinsicInfo(0x1e204000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FmovGp,        new IntrinsicInfo(0x1e260000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64FmovSi,        new IntrinsicInfo(0x1e201000u, IntrinsicType.ScalarFmovi));
            Add(Intrinsic.Arm64FmsubS,        new IntrinsicInfo(0x1f008000u, IntrinsicType.ScalarTernary));
            Add(Intrinsic.Arm64FmulxSe,       new IntrinsicInfo(0x7f809000u, IntrinsicType.ScalarBinaryFPByElem));
            Add(Intrinsic.Arm64FmulxVe,       new IntrinsicInfo(0x2f809000u, IntrinsicType.VectorBinaryFPByElem));
            Add(Intrinsic.Arm64FmulxS,        new IntrinsicInfo(0x5e20dc00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FmulxV,        new IntrinsicInfo(0x0e20dc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmulSe,        new IntrinsicInfo(0x5f809000u, IntrinsicType.ScalarBinaryFPByElem));
            Add(Intrinsic.Arm64FmulVe,        new IntrinsicInfo(0x0f809000u, IntrinsicType.VectorBinaryFPByElem));
            Add(Intrinsic.Arm64FmulV,         new IntrinsicInfo(0x2e20dc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FmulS,         new IntrinsicInfo(0x1e200800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FnegV,         new IntrinsicInfo(0x2ea0f800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FnegS,         new IntrinsicInfo(0x1e214000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FnmaddS,       new IntrinsicInfo(0x1f200000u, IntrinsicType.ScalarTernary));
            Add(Intrinsic.Arm64FnmsubS,       new IntrinsicInfo(0x1f208000u, IntrinsicType.ScalarTernary));
            Add(Intrinsic.Arm64FnmulS,        new IntrinsicInfo(0x1e208800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FrecpeS,       new IntrinsicInfo(0x5ea1d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrecpeV,       new IntrinsicInfo(0x0ea1d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrecpsS,       new IntrinsicInfo(0x5e20fc00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FrecpsV,       new IntrinsicInfo(0x0e20fc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FrecpxS,       new IntrinsicInfo(0x5ea1f800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintaV,       new IntrinsicInfo(0x2e218800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintaS,       new IntrinsicInfo(0x1e264000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintiV,       new IntrinsicInfo(0x2ea19800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintiS,       new IntrinsicInfo(0x1e27c000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintmV,       new IntrinsicInfo(0x0e219800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintmS,       new IntrinsicInfo(0x1e254000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintnV,       new IntrinsicInfo(0x0e218800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintnS,       new IntrinsicInfo(0x1e244000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintpV,       new IntrinsicInfo(0x0ea18800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintpS,       new IntrinsicInfo(0x1e24c000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintxV,       new IntrinsicInfo(0x2e219800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintxS,       new IntrinsicInfo(0x1e274000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrintzV,       new IntrinsicInfo(0x0ea19800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrintzS,       new IntrinsicInfo(0x1e25c000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrsqrteS,      new IntrinsicInfo(0x7ea1d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FrsqrteV,      new IntrinsicInfo(0x2ea1d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FrsqrtsS,      new IntrinsicInfo(0x5ea0fc00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64FrsqrtsV,      new IntrinsicInfo(0x0ea0fc00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FsqrtV,        new IntrinsicInfo(0x2ea1f800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64FsqrtS,        new IntrinsicInfo(0x1e21c000u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64FsubV,         new IntrinsicInfo(0x0ea0d400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64FsubS,         new IntrinsicInfo(0x1e203800u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64InsVe,         new IntrinsicInfo(0x6e000400u, IntrinsicType.VectorInsertByElem));
            Add(Intrinsic.Arm64InsGp,         new IntrinsicInfo(0x4e001c00u, IntrinsicType.ScalarUnaryByElem));
            Add(Intrinsic.Arm64Ld1rV,         new IntrinsicInfo(0x0d40c000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld1Vms,        new IntrinsicInfo(0x0c402000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld1Vss,        new IntrinsicInfo(0x0d400000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64Ld2rV,         new IntrinsicInfo(0x0d60c000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld2Vms,        new IntrinsicInfo(0x0c408000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld2Vss,        new IntrinsicInfo(0x0d600000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64Ld3rV,         new IntrinsicInfo(0x0d40e000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld3Vms,        new IntrinsicInfo(0x0c404000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld3Vss,        new IntrinsicInfo(0x0d402000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64Ld4rV,         new IntrinsicInfo(0x0d60e000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld4Vms,        new IntrinsicInfo(0x0c400000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64Ld4Vss,        new IntrinsicInfo(0x0d602000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64MlaVe,         new IntrinsicInfo(0x2f000000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64MlaV,          new IntrinsicInfo(0x0e209400u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64MlsVe,         new IntrinsicInfo(0x2f004000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64MlsV,          new IntrinsicInfo(0x2e209400u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64MoviV,         new IntrinsicInfo(0x0f000400u, IntrinsicType.VectorMovi));
            Add(Intrinsic.Arm64MrsFpcr,       new IntrinsicInfo(0xd53b4400u, IntrinsicType.GetRegister));
            Add(Intrinsic.Arm64MsrFpcr,       new IntrinsicInfo(0xd51b4400u, IntrinsicType.SetRegister));
            Add(Intrinsic.Arm64MrsFpsr,       new IntrinsicInfo(0xd53b4420u, IntrinsicType.GetRegister));
            Add(Intrinsic.Arm64MsrFpsr,       new IntrinsicInfo(0xd51b4420u, IntrinsicType.SetRegister));
            Add(Intrinsic.Arm64MulVe,         new IntrinsicInfo(0x0f008000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64MulV,          new IntrinsicInfo(0x0e209c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64MvniV,         new IntrinsicInfo(0x2f000400u, IntrinsicType.VectorMvni));
            Add(Intrinsic.Arm64NegS,          new IntrinsicInfo(0x7e20b800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64NegV,          new IntrinsicInfo(0x2e20b800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64NotV,          new IntrinsicInfo(0x2e205800u, IntrinsicType.VectorUnaryBitwise));
            Add(Intrinsic.Arm64OrnV,          new IntrinsicInfo(0x0ee01c00u, IntrinsicType.VectorBinaryBitwise));
            Add(Intrinsic.Arm64OrrVi,         new IntrinsicInfo(0x0f001400u, IntrinsicType.VectorBinaryBitwiseImm));
            Add(Intrinsic.Arm64OrrV,          new IntrinsicInfo(0x0ea01c00u, IntrinsicType.VectorBinaryBitwise));
            Add(Intrinsic.Arm64PmullV,        new IntrinsicInfo(0x0e20e000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64PmulV,         new IntrinsicInfo(0x2e209c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64RaddhnV,       new IntrinsicInfo(0x2e204000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64RbitV,         new IntrinsicInfo(0x2e605800u, IntrinsicType.VectorUnaryBitwise));
            Add(Intrinsic.Arm64Rev16V,        new IntrinsicInfo(0x0e201800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64Rev32V,        new IntrinsicInfo(0x2e200800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64Rev64V,        new IntrinsicInfo(0x0e200800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64RshrnV,        new IntrinsicInfo(0x0f008c00u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64RsubhnV,       new IntrinsicInfo(0x2e206000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SabalV,        new IntrinsicInfo(0x0e205000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SabaV,         new IntrinsicInfo(0x0e207c00u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SabdlV,        new IntrinsicInfo(0x0e207000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SabdV,         new IntrinsicInfo(0x0e207400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SadalpV,       new IntrinsicInfo(0x0e206800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64SaddlpV,       new IntrinsicInfo(0x0e202800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SaddlvV,       new IntrinsicInfo(0x0e303800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SaddlV,        new IntrinsicInfo(0x0e200000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SaddwV,        new IntrinsicInfo(0x0e201000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64ScvtfSFixed,   new IntrinsicInfo(0x5f00e400u, IntrinsicType.ScalarFPConvFixed));
            Add(Intrinsic.Arm64ScvtfVFixed,   new IntrinsicInfo(0x0f00e400u, IntrinsicType.VectorFPConvFixed));
            Add(Intrinsic.Arm64ScvtfS,        new IntrinsicInfo(0x5e21d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64ScvtfV,        new IntrinsicInfo(0x0e21d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64ScvtfGpFixed,  new IntrinsicInfo(0x1e020000u, IntrinsicType.ScalarFPConvFixedGpr));
            Add(Intrinsic.Arm64ScvtfGp,       new IntrinsicInfo(0x1e220000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64Sha1cV,        new IntrinsicInfo(0x5e000000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha1hV,        new IntrinsicInfo(0x5e280800u, IntrinsicType.Vector128Unary));
            Add(Intrinsic.Arm64Sha1mV,        new IntrinsicInfo(0x5e002000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha1pV,        new IntrinsicInfo(0x5e001000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha1su0V,      new IntrinsicInfo(0x5e003000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha1su1V,      new IntrinsicInfo(0x5e281800u, IntrinsicType.Vector128Unary));
            Add(Intrinsic.Arm64Sha256h2V,     new IntrinsicInfo(0x5e005000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha256hV,      new IntrinsicInfo(0x5e004000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64Sha256su0V,    new IntrinsicInfo(0x5e282800u, IntrinsicType.Vector128Unary));
            Add(Intrinsic.Arm64Sha256su1V,    new IntrinsicInfo(0x5e006000u, IntrinsicType.Vector128Binary));
            Add(Intrinsic.Arm64ShaddV,        new IntrinsicInfo(0x0e200400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64ShllV,         new IntrinsicInfo(0x2e213800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64ShlS,          new IntrinsicInfo(0x5f005400u, IntrinsicType.ScalarBinaryShl));
            Add(Intrinsic.Arm64ShlV,          new IntrinsicInfo(0x0f005400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64ShrnV,         new IntrinsicInfo(0x0f008400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64ShsubV,        new IntrinsicInfo(0x0e202400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SliS,          new IntrinsicInfo(0x7f005400u, IntrinsicType.ScalarTernaryShlRd));
            Add(Intrinsic.Arm64SliV,          new IntrinsicInfo(0x2f005400u, IntrinsicType.VectorTernaryShlRd));
            Add(Intrinsic.Arm64SmaxpV,        new IntrinsicInfo(0x0e20a400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SmaxvV,        new IntrinsicInfo(0x0e30a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SmaxV,         new IntrinsicInfo(0x0e206400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SminpV,        new IntrinsicInfo(0x0e20ac00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SminvV,        new IntrinsicInfo(0x0e31a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SminV,         new IntrinsicInfo(0x0e206c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SmlalVe,       new IntrinsicInfo(0x0f002000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64SmlalV,        new IntrinsicInfo(0x0e208000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SmlslVe,       new IntrinsicInfo(0x0f006000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64SmlslV,        new IntrinsicInfo(0x0e20a000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SmovV,         new IntrinsicInfo(0x0e002c00u, IntrinsicType.VectorUnaryByElem));
            Add(Intrinsic.Arm64SmullVe,       new IntrinsicInfo(0x0f00a000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SmullV,        new IntrinsicInfo(0x0e20c000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqabsS,        new IntrinsicInfo(0x5e207800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64SqabsV,        new IntrinsicInfo(0x0e207800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SqaddS,        new IntrinsicInfo(0x5e200c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqaddV,        new IntrinsicInfo(0x0e200c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqdmlalSe,     new IntrinsicInfo(0x5f003000u, IntrinsicType.ScalarBinaryByElem));
            Add(Intrinsic.Arm64SqdmlalVe,     new IntrinsicInfo(0x0f003000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SqdmlalS,      new IntrinsicInfo(0x5e209000u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqdmlalV,      new IntrinsicInfo(0x0e209000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqdmlslSe,     new IntrinsicInfo(0x5f007000u, IntrinsicType.ScalarBinaryByElem));
            Add(Intrinsic.Arm64SqdmlslVe,     new IntrinsicInfo(0x0f007000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SqdmlslS,      new IntrinsicInfo(0x5e20b000u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqdmlslV,      new IntrinsicInfo(0x0e20b000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqdmulhSe,     new IntrinsicInfo(0x5f00c000u, IntrinsicType.ScalarBinaryByElem));
            Add(Intrinsic.Arm64SqdmulhVe,     new IntrinsicInfo(0x0f00c000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SqdmulhS,      new IntrinsicInfo(0x5e20b400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqdmulhV,      new IntrinsicInfo(0x0e20b400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqdmullSe,     new IntrinsicInfo(0x5f00b000u, IntrinsicType.ScalarBinaryByElem));
            Add(Intrinsic.Arm64SqdmullVe,     new IntrinsicInfo(0x0f00b000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SqdmullS,      new IntrinsicInfo(0x5e20d000u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqdmullV,      new IntrinsicInfo(0x0e20d000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqnegS,        new IntrinsicInfo(0x7e207800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64SqnegV,        new IntrinsicInfo(0x2e207800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64SqrdmulhSe,    new IntrinsicInfo(0x5f00d000u, IntrinsicType.ScalarBinaryByElem));
            Add(Intrinsic.Arm64SqrdmulhVe,    new IntrinsicInfo(0x0f00d000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64SqrdmulhS,     new IntrinsicInfo(0x7e20b400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqrdmulhV,     new IntrinsicInfo(0x2e20b400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqrshlS,       new IntrinsicInfo(0x5e205c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqrshlV,       new IntrinsicInfo(0x0e205c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqrshrnS,      new IntrinsicInfo(0x5f009c00u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SqrshrnV,      new IntrinsicInfo(0x0f009c00u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SqrshrunS,     new IntrinsicInfo(0x7f008c00u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SqrshrunV,     new IntrinsicInfo(0x2f008c00u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SqshluS,       new IntrinsicInfo(0x7f006400u, IntrinsicType.ScalarBinaryShl));
            Add(Intrinsic.Arm64SqshluV,       new IntrinsicInfo(0x2f006400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64SqshlSi,       new IntrinsicInfo(0x5f007400u, IntrinsicType.ScalarBinaryShl));
            Add(Intrinsic.Arm64SqshlVi,       new IntrinsicInfo(0x0f007400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64SqshlS,        new IntrinsicInfo(0x5e204c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqshlV,        new IntrinsicInfo(0x0e204c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqshrnS,       new IntrinsicInfo(0x5f009400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SqshrnV,       new IntrinsicInfo(0x0f009400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SqshrunS,      new IntrinsicInfo(0x7f008400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SqshrunV,      new IntrinsicInfo(0x2f008400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SqsubS,        new IntrinsicInfo(0x5e202c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SqsubV,        new IntrinsicInfo(0x0e202c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SqxtnS,        new IntrinsicInfo(0x5e214800u, IntrinsicType.ScalarBinaryRd));
            Add(Intrinsic.Arm64SqxtnV,        new IntrinsicInfo(0x0e214800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64SqxtunS,       new IntrinsicInfo(0x7e212800u, IntrinsicType.ScalarBinaryRd));
            Add(Intrinsic.Arm64SqxtunV,       new IntrinsicInfo(0x2e212800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64SrhaddV,       new IntrinsicInfo(0x0e201400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SriS,          new IntrinsicInfo(0x7f004400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SriV,          new IntrinsicInfo(0x2f004400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SrshlS,        new IntrinsicInfo(0x5e205400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SrshlV,        new IntrinsicInfo(0x0e205400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SrshrS,        new IntrinsicInfo(0x5f002400u, IntrinsicType.ScalarBinaryShr));
            Add(Intrinsic.Arm64SrshrV,        new IntrinsicInfo(0x0f002400u, IntrinsicType.VectorBinaryShr));
            Add(Intrinsic.Arm64SrsraS,        new IntrinsicInfo(0x5f003400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SrsraV,        new IntrinsicInfo(0x0f003400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SshllV,        new IntrinsicInfo(0x0f00a400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64SshlS,         new IntrinsicInfo(0x5e204400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SshlV,         new IntrinsicInfo(0x0e204400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SshrS,         new IntrinsicInfo(0x5f000400u, IntrinsicType.ScalarBinaryShr));
            Add(Intrinsic.Arm64SshrV,         new IntrinsicInfo(0x0f000400u, IntrinsicType.VectorBinaryShr));
            Add(Intrinsic.Arm64SsraS,         new IntrinsicInfo(0x5f001400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64SsraV,         new IntrinsicInfo(0x0f001400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64SsublV,        new IntrinsicInfo(0x0e202000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SsubwV,        new IntrinsicInfo(0x0e203000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64St1Vms,        new IntrinsicInfo(0x0c002000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64St1Vss,        new IntrinsicInfo(0x0d000000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64St2Vms,        new IntrinsicInfo(0x0c008000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64St2Vss,        new IntrinsicInfo(0x0d200000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64St3Vms,        new IntrinsicInfo(0x0c004000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64St3Vss,        new IntrinsicInfo(0x0d002000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64St4Vms,        new IntrinsicInfo(0x0c000000u, IntrinsicType.VectorLdSt));
            Add(Intrinsic.Arm64St4Vss,        new IntrinsicInfo(0x0d202000u, IntrinsicType.VectorLdStSs));
            Add(Intrinsic.Arm64SubhnV,        new IntrinsicInfo(0x0e206000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64SubS,          new IntrinsicInfo(0x7e208400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64SubV,          new IntrinsicInfo(0x2e208400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64SuqaddS,       new IntrinsicInfo(0x5e203800u, IntrinsicType.ScalarBinaryRd));
            Add(Intrinsic.Arm64SuqaddV,       new IntrinsicInfo(0x0e203800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64TblV,          new IntrinsicInfo(0x0e000000u, IntrinsicType.VectorLookupTable));
            Add(Intrinsic.Arm64TbxV,          new IntrinsicInfo(0x0e001000u, IntrinsicType.VectorLookupTable));
            Add(Intrinsic.Arm64Trn1V,         new IntrinsicInfo(0x0e002800u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64Trn2V,         new IntrinsicInfo(0x0e006800u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UabalV,        new IntrinsicInfo(0x2e205000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64UabaV,         new IntrinsicInfo(0x2e207c00u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64UabdlV,        new IntrinsicInfo(0x2e207000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UabdV,         new IntrinsicInfo(0x2e207400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UadalpV,       new IntrinsicInfo(0x2e206800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64UaddlpV,       new IntrinsicInfo(0x2e202800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UaddlvV,       new IntrinsicInfo(0x2e303800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UaddlV,        new IntrinsicInfo(0x2e200000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UaddwV,        new IntrinsicInfo(0x2e201000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UcvtfSFixed,   new IntrinsicInfo(0x7f00e400u, IntrinsicType.ScalarFPConvFixed));
            Add(Intrinsic.Arm64UcvtfVFixed,   new IntrinsicInfo(0x2f00e400u, IntrinsicType.VectorFPConvFixed));
            Add(Intrinsic.Arm64UcvtfS,        new IntrinsicInfo(0x7e21d800u, IntrinsicType.ScalarUnary));
            Add(Intrinsic.Arm64UcvtfV,        new IntrinsicInfo(0x2e21d800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UcvtfGpFixed,  new IntrinsicInfo(0x1e030000u, IntrinsicType.ScalarFPConvFixedGpr));
            Add(Intrinsic.Arm64UcvtfGp,       new IntrinsicInfo(0x1e230000u, IntrinsicType.ScalarFPConvGpr));
            Add(Intrinsic.Arm64UhaddV,        new IntrinsicInfo(0x2e200400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UhsubV,        new IntrinsicInfo(0x2e202400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UmaxpV,        new IntrinsicInfo(0x2e20a400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UmaxvV,        new IntrinsicInfo(0x2e30a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UmaxV,         new IntrinsicInfo(0x2e206400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UminpV,        new IntrinsicInfo(0x2e20ac00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UminvV,        new IntrinsicInfo(0x2e31a800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UminV,         new IntrinsicInfo(0x2e206c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UmlalVe,       new IntrinsicInfo(0x2f002000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64UmlalV,        new IntrinsicInfo(0x2e208000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64UmlslVe,       new IntrinsicInfo(0x2f006000u, IntrinsicType.VectorTernaryRdByElem));
            Add(Intrinsic.Arm64UmlslV,        new IntrinsicInfo(0x2e20a000u, IntrinsicType.VectorTernaryRd));
            Add(Intrinsic.Arm64UmovV,         new IntrinsicInfo(0x0e003c00u, IntrinsicType.VectorUnaryByElem));
            Add(Intrinsic.Arm64UmullVe,       new IntrinsicInfo(0x2f00a000u, IntrinsicType.VectorBinaryByElem));
            Add(Intrinsic.Arm64UmullV,        new IntrinsicInfo(0x2e20c000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UqaddS,        new IntrinsicInfo(0x7e200c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UqaddV,        new IntrinsicInfo(0x2e200c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UqrshlS,       new IntrinsicInfo(0x7e205c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UqrshlV,       new IntrinsicInfo(0x2e205c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UqrshrnS,      new IntrinsicInfo(0x7f009c00u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64UqrshrnV,      new IntrinsicInfo(0x2f009c00u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64UqshlSi,       new IntrinsicInfo(0x7f007400u, IntrinsicType.ScalarBinaryShl));
            Add(Intrinsic.Arm64UqshlVi,       new IntrinsicInfo(0x2f007400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64UqshlS,        new IntrinsicInfo(0x7e204c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UqshlV,        new IntrinsicInfo(0x2e204c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UqshrnS,       new IntrinsicInfo(0x7f009400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64UqshrnV,       new IntrinsicInfo(0x2f009400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64UqsubS,        new IntrinsicInfo(0x7e202c00u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UqsubV,        new IntrinsicInfo(0x2e202c00u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UqxtnS,        new IntrinsicInfo(0x7e214800u, IntrinsicType.ScalarBinaryRd));
            Add(Intrinsic.Arm64UqxtnV,        new IntrinsicInfo(0x2e214800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64UrecpeV,       new IntrinsicInfo(0x0ea1c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UrhaddV,       new IntrinsicInfo(0x2e201400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UrshlS,        new IntrinsicInfo(0x7e205400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UrshlV,        new IntrinsicInfo(0x2e205400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UrshrS,        new IntrinsicInfo(0x7f002400u, IntrinsicType.ScalarBinaryShr));
            Add(Intrinsic.Arm64UrshrV,        new IntrinsicInfo(0x2f002400u, IntrinsicType.VectorBinaryShr));
            Add(Intrinsic.Arm64UrsqrteV,      new IntrinsicInfo(0x2ea1c800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64UrsraS,        new IntrinsicInfo(0x7f003400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64UrsraV,        new IntrinsicInfo(0x2f003400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64UshllV,        new IntrinsicInfo(0x2f00a400u, IntrinsicType.VectorBinaryShl));
            Add(Intrinsic.Arm64UshlS,         new IntrinsicInfo(0x7e204400u, IntrinsicType.ScalarBinary));
            Add(Intrinsic.Arm64UshlV,         new IntrinsicInfo(0x2e204400u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UshrS,         new IntrinsicInfo(0x7f000400u, IntrinsicType.ScalarBinaryShr));
            Add(Intrinsic.Arm64UshrV,         new IntrinsicInfo(0x2f000400u, IntrinsicType.VectorBinaryShr));
            Add(Intrinsic.Arm64UsqaddS,       new IntrinsicInfo(0x7e203800u, IntrinsicType.ScalarBinaryRd));
            Add(Intrinsic.Arm64UsqaddV,       new IntrinsicInfo(0x2e203800u, IntrinsicType.VectorBinaryRd));
            Add(Intrinsic.Arm64UsraS,         new IntrinsicInfo(0x7f001400u, IntrinsicType.ScalarTernaryShrRd));
            Add(Intrinsic.Arm64UsraV,         new IntrinsicInfo(0x2f001400u, IntrinsicType.VectorTernaryShrRd));
            Add(Intrinsic.Arm64UsublV,        new IntrinsicInfo(0x2e202000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64UsubwV,        new IntrinsicInfo(0x2e203000u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64Uzp1V,         new IntrinsicInfo(0x0e001800u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64Uzp2V,         new IntrinsicInfo(0x0e005800u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64XtnV,          new IntrinsicInfo(0x0e212800u, IntrinsicType.VectorUnary));
            Add(Intrinsic.Arm64Zip1V,         new IntrinsicInfo(0x0e003800u, IntrinsicType.VectorBinary));
            Add(Intrinsic.Arm64Zip2V,         new IntrinsicInfo(0x0e007800u, IntrinsicType.VectorBinary));
#pragma warning restore IDE0055
        }

        private static void Add(Intrinsic intrin, IntrinsicInfo info)
        {
            _intrinTable[(int)intrin] = info;
        }

        public static IntrinsicInfo GetInfo(Intrinsic intrin)
        {
            return _intrinTable[(int)intrin];
        }
    }
}
